// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.2.0

// Generic/internal class name =  Ai
// Wrapped Chilkat C++ class name =  CkAi

@class CkoTask;
@class CkoJsonObject;
@class CkoStringTable;
@class CkoStringBuilder;
@class CkoBinData;
@class CkoSocket;


@class CkoBaseProgress;

@interface CkoAi : NSObject {

	@private
		void *m_eventCallback;
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

// property setter: EventCallbackObject
- (void)setEventCallbackObject: (CkoBaseProgress *)eventObj;

@property (nonatomic, copy) NSString *ApiKey;
@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic) BOOL FullTranscript;
@property (nonatomic, copy) NSNumber *HeartbeatMs;
@property (nonatomic) BOOL HostedConvo;
@property (nonatomic, copy) NSNumber *IdleTimeoutMs;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic, copy) NSString *Model;
@property (nonatomic, copy) NSString *Provider;
@property (nonatomic, readonly, copy) NSNumber *ResponseStatusCode;
@property (nonatomic, copy) NSString *SelectedConvo;
@property (nonatomic) BOOL Streaming;
@property (nonatomic, copy) NSString *UncommonOptions;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
// method: Ask
- (BOOL)Ask: (NSString *)outputType;
// method: AskAsync
- (CkoTask *)AskAsync: (NSString *)outputType;
// method: DeleteConvo
- (BOOL)DeleteConvo: (NSString *)name;
// method: ExportConvo
- (BOOL)ExportConvo: (NSString *)name 
	json: (CkoJsonObject *)json;
// method: GetLastJsonData
- (void)GetLastJsonData: (CkoJsonObject *)json;
// method: GetModels
- (BOOL)GetModels: (CkoStringTable *)st;
// method: GetModelsAsync
- (CkoTask *)GetModelsAsync: (CkoStringTable *)st;
// method: GetOutputText
- (NSString *)GetOutputText;
// method: GetOutputTextSb
- (BOOL)GetOutputTextSb: (CkoStringBuilder *)sb;
// method: ImportConvo
- (BOOL)ImportConvo: (NSString *)name 
	json: (CkoJsonObject *)json;
// method: InputAddFileData
- (BOOL)InputAddFileData: (NSString *)filename 
	bd: (CkoBinData *)bd 
	summary: (NSString *)summary;
// method: InputAddFileUrl
- (BOOL)InputAddFileUrl: (NSString *)url 
	summary: (NSString *)summary;
// method: InputAddImageData
- (BOOL)InputAddImageData: (CkoBinData *)bd 
	summary: (NSString *)summary;
// method: InputAddImageUrl
- (BOOL)InputAddImageUrl: (NSString *)url 
	summary: (NSString *)summary;
// method: InputAddText
- (BOOL)InputAddText: (NSString *)text;
// method: InputAddTextSb
- (BOOL)InputAddTextSb: (CkoStringBuilder *)sb;
// method: InputClear
- (void)InputClear;
// method: ListConvos
- (BOOL)ListConvos: (CkoStringTable *)st;
// method: NewConvo
- (BOOL)NewConvo: (NSString *)name 
	sysMsg: (NSString *)sysMsg 
	devMsg: (NSString *)devMsg;
// method: NextAiEvent
- (BOOL)NextAiEvent: (NSNumber *)maxWaitMs 
	sbName: (CkoStringBuilder *)sbName 
	sbDelta: (CkoStringBuilder *)sbDelta;
// method: PollAi
- (NSNumber *)PollAi: (BOOL)abort;
// method: SetConnectionSettings
- (BOOL)SetConnectionSettings: (CkoSocket *)sock;
// method: SleepMs
- (void)SleepMs: (NSNumber *)millisec;

@end
