// CkMhtW.h: interface for the CkMhtW class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.2.0

#ifndef _CkMhtW_H
#define _CkMhtW_H
	
#include "chilkatDefs.h"
#include "CkString.h"
#include "CkClassWithCallbacksW.h"

class CkTaskW;
class CkBaseProgressW;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkMhtW
class CK_VISIBLE_PUBLIC CkMhtW  : public CkClassWithCallbacksW
{
	private:
	bool m_cbOwned;

	private:
	
	// Don't allow assignment or copying these objects.
	CkMhtW(const CkMhtW &);
	CkMhtW &operator=(const CkMhtW &);

    public:
	CkMhtW(void);
	virtual ~CkMhtW(void);

	

	static CkMhtW *createNew(void);
	

	CkMhtW(bool bCallbackOwned);
	static CkMhtW *createNew(bool bCallbackOwned);

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	CkBaseProgressW *get_EventCallbackObject(void) const;
	void put_EventCallbackObject(CkBaseProgressW *progress);


	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// When set to true, causes the currently running method to abort. Methods that
	// always finish quickly (i.e.have no length file operations or network
	// communications) are not affected. If no method is running, then this property is
	// automatically reset to false when the next method is called. When the abort
	// occurs, this property is reset to false. Both synchronous and asynchronous
	// method calls can be aborted. (A synchronous method call could be aborted by
	// setting this property from a separate thread.)
	bool get_AbortCurrent(void);
	// When set to true, causes the currently running method to abort. Methods that
	// always finish quickly (i.e.have no length file operations or network
	// communications) are not affected. If no method is running, then this property is
	// automatically reset to false when the next method is called. When the abort
	// occurs, this property is reset to false. Both synchronous and asynchronous
	// method calls can be aborted. (A synchronous method call could be aborted by
	// setting this property from a separate thread.)
	void put_AbortCurrent(bool newVal);

	// When processing an HTML file or string (not a website URL), this defines the
	// base URL to be used when converting relative HREFs to absolute HREFs.
	void get_BaseUrl(CkString &str);
	// When processing an HTML file or string (not a website URL), this defines the
	// base URL to be used when converting relative HREFs to absolute HREFs.
	const wchar_t *baseUrl(void);
	// When processing an HTML file or string (not a website URL), this defines the
	// base URL to be used when converting relative HREFs to absolute HREFs.
	void put_BaseUrl(const wchar_t *newVal);

	// The amount of time in seconds to wait before timing out when connecting to an
	// HTTP server. The default value is 10 seconds.
	int get_ConnectTimeout(void);
	// The amount of time in seconds to wait before timing out when connecting to an
	// HTTP server. The default value is 10 seconds.
	void put_ConnectTimeout(int newVal);

	// A filename to save the result HTML when converting a URL, file, or HTML string.
	// If problems are experienced, the before/after HTML can be analyzed to help
	// determine the cause.
	void get_DebugHtmlAfter(CkString &str);
	// A filename to save the result HTML when converting a URL, file, or HTML string.
	// If problems are experienced, the before/after HTML can be analyzed to help
	// determine the cause.
	const wchar_t *debugHtmlAfter(void);
	// A filename to save the result HTML when converting a URL, file, or HTML string.
	// If problems are experienced, the before/after HTML can be analyzed to help
	// determine the cause.
	void put_DebugHtmlAfter(const wchar_t *newVal);

	// A filename to save the input HTML when converting a URL, file, or HTML string.
	// If problems are experienced, the before/after HTML can be analyzed to help
	// determine the cause.
	void get_DebugHtmlBefore(CkString &str);
	// A filename to save the input HTML when converting a URL, file, or HTML string.
	// If problems are experienced, the before/after HTML can be analyzed to help
	// determine the cause.
	const wchar_t *debugHtmlBefore(void);
	// A filename to save the input HTML when converting a URL, file, or HTML string.
	// If problems are experienced, the before/after HTML can be analyzed to help
	// determine the cause.
	void put_DebugHtmlBefore(const wchar_t *newVal);

	// Controls whether images are embedded in the MHT/EML, or whether the IMG SRC
	// attributes are left as external URL references. If false, the IMG SRC tags are
	// converted to absolute URLs (if necessary) and the images are not embedded within
	// the MHT/EML.
	bool get_EmbedImages(void);
	// Controls whether images are embedded in the MHT/EML, or whether the IMG SRC
	// attributes are left as external URL references. If false, the IMG SRC tags are
	// converted to absolute URLs (if necessary) and the images are not embedded within
	// the MHT/EML.
	void put_EmbedImages(bool newVal);

	// If true, only images found on the local filesystem (i.e. links to files) will
	// be embedded within the MHT.
	bool get_EmbedLocalOnly(void);
	// If true, only images found on the local filesystem (i.e. links to files) will
	// be embedded within the MHT.
	void put_EmbedLocalOnly(bool newVal);

	// If true, page parts such as images, style sheets, etc. will be fetched from
	// the disk cache if possible. The disk cache root may be defined by calling
	// AddCacheRoot. The default value is false.
	bool get_FetchFromCache(void);
	// If true, page parts such as images, style sheets, etc. will be fetched from
	// the disk cache if possible. The disk cache root may be defined by calling
	// AddCacheRoot. The default value is false.
	void put_FetchFromCache(bool newVal);

	// The interval in milliseconds between each AbortCheck event callback, which
	// enables an application to abort certain method calls before they complete. By
	// default, HeartbeatMs is set to 0 , meaning no AbortCheck event callbacks will
	// trigger.
	// 
	// References:
	// 1: #AbortCheck
	int get_HeartbeatMs(void);
	// The interval in milliseconds between each AbortCheck event callback, which
	// enables an application to abort certain method calls before they complete. By
	// default, HeartbeatMs is set to 0 , meaning no AbortCheck event callbacks will
	// trigger.
	// 
	// References:
	// 1: #AbortCheck
	void put_HeartbeatMs(int newVal);

	// Some HTTP responses contain a Cache-Control: must-revalidate header. If this is
	// present, the server is requesting that the client always issue a revalidate HTTP
	// request instead of serving the page directly from cache. If IgnoreMustRevalidate
	// is set to true, then Chilkat MHT will serve the page directly from cache
	// without revalidating until the page is no longer fresh. (assuming that
	// FetchFromCache is set to true)
	// 
	// The default value of this property is false.
	// 
	bool get_IgnoreMustRevalidate(void);
	// Some HTTP responses contain a Cache-Control: must-revalidate header. If this is
	// present, the server is requesting that the client always issue a revalidate HTTP
	// request instead of serving the page directly from cache. If IgnoreMustRevalidate
	// is set to true, then Chilkat MHT will serve the page directly from cache
	// without revalidating until the page is no longer fresh. (assuming that
	// FetchFromCache is set to true)
	// 
	// The default value of this property is false.
	// 
	void put_IgnoreMustRevalidate(bool newVal);

	// Some HTTP responses contain headers of various types that indicate that the page
	// should not be cached. Chilkat MHT will adhere to this unless this property is
	// set to true.
	// 
	// The default value of this property is false.
	// 
	bool get_IgnoreNoCache(void);
	// Some HTTP responses contain headers of various types that indicate that the page
	// should not be cached. Chilkat MHT will adhere to this unless this property is
	// set to true.
	// 
	// The default value of this property is false.
	// 
	void put_IgnoreNoCache(bool newVal);

	// Only applies when creating MHT files. Scripts are always removed when creating
	// EML or emails from HTML. If set to true, then all scripts are removed, if set
	// to false (the default) then scripts are not removed.
	bool get_NoScripts(void);
	// Only applies when creating MHT files. Scripts are always removed when creating
	// EML or emails from HTML. If set to true, then all scripts are removed, if set
	// to false (the default) then scripts are not removed.
	void put_NoScripts(bool newVal);

	// Setting this property to true causes the MHT component to use NTLM
	// authentication (also known as IWA -- or Integrated Windows Authentication) when
	// authentication with an HTTP server.
	// 
	// The default value of this property is false.
	// 
	bool get_NtlmAuth(void);
	// Setting this property to true causes the MHT component to use NTLM
	// authentication (also known as IWA -- or Integrated Windows Authentication) when
	// authentication with an HTTP server.
	// 
	// The default value of this property is false.
	// 
	void put_NtlmAuth(bool newVal);

	// The number of directory levels to be used under each cache root. The default is
	// 0, meaning that each cached item is stored in a cache root directory. A value of
	// 1 causes each cached page to be stored in one of 255 subdirectories named 0 , 1
	// , 2 , ... 255 under a cache root. A value of 2 causes two levels of
	// subdirectories ( 0..255/0..255 ) under each cache root. The MHT control
	// automatically creates subdirectories as needed. The reason for mutliple levels
	// is to alleviate problems that may arise when huge numbers of files are stored in
	// a single directory. For example, Windows Explorer does not behave well when
	// trying to display the contents of directories with thousands of files.
	int get_NumCacheLevels(void);
	// The number of directory levels to be used under each cache root. The default is
	// 0, meaning that each cached item is stored in a cache root directory. A value of
	// 1 causes each cached page to be stored in one of 255 subdirectories named 0 , 1
	// , 2 , ... 255 under a cache root. A value of 2 causes two levels of
	// subdirectories ( 0..255/0..255 ) under each cache root. The MHT control
	// automatically creates subdirectories as needed. The reason for mutliple levels
	// is to alleviate problems that may arise when huge numbers of files are stored in
	// a single directory. For example, Windows Explorer does not behave well when
	// trying to display the contents of directories with thousands of files.
	void put_NumCacheLevels(int newVal);

	// The number of cache roots to be used for the disk cache. This allows the disk
	// cache spread out over multiple disk drives. Each cache root is a string
	// indicating the drive letter and directory path. For example, E:\Cache . To
	// create a cache with four roots, call AddCacheRoot once for each directory root.
	int get_NumCacheRoots(void);

	// If true, then use IPv6 over IPv4 when both are supported for a particular
	// domain. The default value of this property is false, which will choose IPv4
	// over IPv6.
	bool get_PreferIpv6(void);
	// If true, then use IPv6 over IPv4 when both are supported for a particular
	// domain. The default value of this property is false, which will choose IPv4
	// over IPv6.
	void put_PreferIpv6(bool newVal);

	// This property provides a means for the noscript option to be selected when
	// possible. If PreferMHTScripts = false, then scripts with noscript alternatives
	// are removed and the noscript content is kept. If true (the default), then
	// scripts are preserved and the noscript options are discarded.
	bool get_PreferMHTScripts(void);
	// This property provides a means for the noscript option to be selected when
	// possible. If PreferMHTScripts = false, then scripts with noscript alternatives
	// are removed and the noscript content is kept. If true (the default), then
	// scripts are preserved and the noscript options are discarded.
	void put_PreferMHTScripts(bool newVal);

	// (Optional) A proxy host:port if a proxy is necessary to access the Internet. The
	// proxy string should be formatted as hostname:port , such as
	// www.chilkatsoft.com:100 .
	void get_Proxy(CkString &str);
	// (Optional) A proxy host:port if a proxy is necessary to access the Internet. The
	// proxy string should be formatted as hostname:port , such as
	// www.chilkatsoft.com:100 .
	const wchar_t *proxy(void);
	// (Optional) A proxy host:port if a proxy is necessary to access the Internet. The
	// proxy string should be formatted as hostname:port , such as
	// www.chilkatsoft.com:100 .
	void put_Proxy(const wchar_t *newVal);

	// If an HTTP proxy is used and it requires authentication, this property specifies
	// the HTTP proxy login.
	void get_ProxyLogin(CkString &str);
	// If an HTTP proxy is used and it requires authentication, this property specifies
	// the HTTP proxy login.
	const wchar_t *proxyLogin(void);
	// If an HTTP proxy is used and it requires authentication, this property specifies
	// the HTTP proxy login.
	void put_ProxyLogin(const wchar_t *newVal);

	// If an HTTP proxy is used and it requires authentication, this property specifies
	// the HTTP proxy password.
	void get_ProxyPassword(CkString &str);
	// If an HTTP proxy is used and it requires authentication, this property specifies
	// the HTTP proxy password.
	const wchar_t *proxyPassword(void);
	// If an HTTP proxy is used and it requires authentication, this property specifies
	// the HTTP proxy password.
	void put_ProxyPassword(const wchar_t *newVal);

	// The amount of time in seconds to wait before timing out when reading from an
	// HTTP server. The ReadTimeout is the amount of time that needs to elapse while no
	// additional data is forthcoming. During a long data transfer, if the data stream
	// halts for more than this amount, it will timeout. Otherwise, there is no limit
	// on the length of time for the entire data transfer.
	// 
	// The default value is 20 seconds.
	// 
	int get_ReadTimeout(void);
	// The amount of time in seconds to wait before timing out when reading from an
	// HTTP server. The ReadTimeout is the amount of time that needs to elapse while no
	// additional data is forthcoming. During a long data transfer, if the data stream
	// halts for more than this amount, it will timeout. Otherwise, there is no limit
	// on the length of time for the entire data transfer.
	// 
	// The default value is 20 seconds.
	// 
	void put_ReadTimeout(int newVal);

	// If true, then the HTTP client will verify the server's SSL certificate. The
	// certificate is expired, or if the cert's signature is invalid, the connection is
	// not allowed. The default value of this property is false.
	bool get_RequireSslCertVerify(void);
	// If true, then the HTTP client will verify the server's SSL certificate. The
	// certificate is expired, or if the cert's signature is invalid, the connection is
	// not allowed. The default value of this property is false.
	void put_RequireSslCertVerify(bool newVal);

	// The SOCKS4/SOCKS5 hostname or IPv4 address (in dotted decimal notation). This
	// property is only used if the SocksVersion property is set to 4 or 5).
	void get_SocksHostname(CkString &str);
	// The SOCKS4/SOCKS5 hostname or IPv4 address (in dotted decimal notation). This
	// property is only used if the SocksVersion property is set to 4 or 5).
	const wchar_t *socksHostname(void);
	// The SOCKS4/SOCKS5 hostname or IPv4 address (in dotted decimal notation). This
	// property is only used if the SocksVersion property is set to 4 or 5).
	void put_SocksHostname(const wchar_t *newVal);

	// The SOCKS5 password (if required). The SOCKS4 protocol does not include the use
	// of a password, so this does not apply to SOCKS4.
	void get_SocksPassword(CkString &str);
	// The SOCKS5 password (if required). The SOCKS4 protocol does not include the use
	// of a password, so this does not apply to SOCKS4.
	const wchar_t *socksPassword(void);
	// The SOCKS5 password (if required). The SOCKS4 protocol does not include the use
	// of a password, so this does not apply to SOCKS4.
	void put_SocksPassword(const wchar_t *newVal);

	// The SOCKS4/SOCKS5 proxy port. The default value is 1080. This property only
	// applies if a SOCKS proxy is used (if the SocksVersion property is set to 4 or
	// 5).
	int get_SocksPort(void);
	// The SOCKS4/SOCKS5 proxy port. The default value is 1080. This property only
	// applies if a SOCKS proxy is used (if the SocksVersion property is set to 4 or
	// 5).
	void put_SocksPort(int newVal);

	// The SOCKS4/SOCKS5 proxy username. This property is only used if the SocksVersion
	// property is set to 4 or 5).
	void get_SocksUsername(CkString &str);
	// The SOCKS4/SOCKS5 proxy username. This property is only used if the SocksVersion
	// property is set to 4 or 5).
	const wchar_t *socksUsername(void);
	// The SOCKS4/SOCKS5 proxy username. This property is only used if the SocksVersion
	// property is set to 4 or 5).
	void put_SocksUsername(const wchar_t *newVal);

	// SocksVersion May be set to one of the following integer values:
	// 
	// 0 - No SOCKS proxy is used. This is the default.
	// 4 - Connect via a SOCKS4 proxy.
	// 5 - Connect via a SOCKS5 proxy.
	// 
	int get_SocksVersion(void);
	// SocksVersion May be set to one of the following integer values:
	// 
	// 0 - No SOCKS proxy is used. This is the default.
	// 4 - Connect via a SOCKS4 proxy.
	// 5 - Connect via a SOCKS5 proxy.
	// 
	void put_SocksVersion(int newVal);

	// If true, then the UnpackMHT and UnpackMHTString methods will unpack the MHT
	// directly with no transformations. Normally, the related parts are unpacked to a
	// parts sub-directory, and the unpacked HTML is edited to update references to
	// point to the unpacked image and script files. When unpacking direct, the HTML is
	// not edited, and the related parts are unpacked to sub-directories rooted in the
	// directory where HTML file is created (i.e. the unpack directory). When unpacking
	// direct, the partsSubDir argument of the UnpackMHT* methods is unused.
	// 
	// Note: It is only possible to directly unpack MHT files where the
	// Content-Location headers DO NOT contain URLs. The MHT must be such that the
	// Content-Location headers of the related items contain relative paths.
	// 
	// Note: The default value of this property is false.
	// 
	bool get_UnpackDirect(void);
	// If true, then the UnpackMHT and UnpackMHTString methods will unpack the MHT
	// directly with no transformations. Normally, the related parts are unpacked to a
	// parts sub-directory, and the unpacked HTML is edited to update references to
	// point to the unpacked image and script files. When unpacking direct, the HTML is
	// not edited, and the related parts are unpacked to sub-directories rooted in the
	// directory where HTML file is created (i.e. the unpack directory). When unpacking
	// direct, the partsSubDir argument of the UnpackMHT* methods is unused.
	// 
	// Note: It is only possible to directly unpack MHT files where the
	// Content-Location headers DO NOT contain URLs. The MHT must be such that the
	// Content-Location headers of the related items contain relative paths.
	// 
	// Note: The default value of this property is false.
	// 
	void put_UnpackDirect(bool newVal);

	// Controls whether absolute or relative paths are used when referencing images in
	// the unpacked HTML. The default value is true indicating that relative paths
	// will be used. To use absolute paths, set this property value equal to false.
	bool get_UnpackUseRelPaths(void);
	// Controls whether absolute or relative paths are used when referencing images in
	// the unpacked HTML. The default value is true indicating that relative paths
	// will be used. To use absolute paths, set this property value equal to false.
	void put_UnpackUseRelPaths(bool newVal);

	// Controls whether the cache is automatically updated with the responses from HTTP
	// GET requests. If true, the disk cache is updated, if false (the default),
	// the cache is not updated.
	bool get_UpdateCache(void);
	// Controls whether the cache is automatically updated with the responses from HTTP
	// GET requests. If true, the disk cache is updated, if false (the default),
	// the cache is not updated.
	void put_UpdateCache(bool newVal);

	// Controls whether CID URLs are used for embedded references when generating MHT
	// or EML documents. If UseCids is false, then URLs are left unchanged and the
	// embedded items will contain content-location headers that match the URLs in the
	// HTML. If true, CIDs are generated and the URLs within the HTML are replaced
	// with CID: links.
	// 
	// The default value of this property is true.
	// 
	bool get_UseCids(void);
	// Controls whether CID URLs are used for embedded references when generating MHT
	// or EML documents. If UseCids is false, then URLs are left unchanged and the
	// embedded items will contain content-location headers that match the URLs in the
	// HTML. If true, CIDs are generated and the URLs within the HTML are replaced
	// with CID: links.
	// 
	// The default value of this property is true.
	// 
	void put_UseCids(bool newVal);

	// If true, a filename attribute is added to each Content-Disposition MIME header
	// field for each embedded item (image, style sheet, etc.). If false, then no
	// filename attribute is added.
	// 
	// The default value of this property is true.
	// 
	bool get_UseFilename(void);
	// If true, a filename attribute is added to each Content-Disposition MIME header
	// field for each embedded item (image, style sheet, etc.). If false, then no
	// filename attribute is added.
	// 
	// The default value of this property is true.
	// 
	void put_UseFilename(bool newVal);

	// If true, the proxy host/port used by Internet Explorer will also be used by
	// Chilkat MHT.
	bool get_UseIEProxy(void);
	// If true, the proxy host/port used by Internet Explorer will also be used by
	// Chilkat MHT.
	void put_UseIEProxy(bool newVal);

	// If true, an inline attribute is added to each Content-Disposition MIME header
	// field for each embedded item (image, style sheet, etc.). If false, then no
	// inline attribute is added.
	// 
	// The default value of this property is true.
	// 
	bool get_UseInline(void);
	// If true, an inline attribute is added to each Content-Disposition MIME header
	// field for each embedded item (image, style sheet, etc.). If false, then no
	// inline attribute is added.
	// 
	// The default value of this property is true.
	// 
	void put_UseInline(bool newVal);

	// (Optional) Specifies the login if a a Web page is accessed that requires a login
	void get_WebSiteLogin(CkString &str);
	// (Optional) Specifies the login if a a Web page is accessed that requires a login
	const wchar_t *webSiteLogin(void);
	// (Optional) Specifies the login if a a Web page is accessed that requires a login
	void put_WebSiteLogin(const wchar_t *newVal);

	// The optional domain name to be used with NTLM authentication.
	void get_WebSiteLoginDomain(CkString &str);
	// The optional domain name to be used with NTLM authentication.
	const wchar_t *webSiteLoginDomain(void);
	// The optional domain name to be used with NTLM authentication.
	void put_WebSiteLoginDomain(const wchar_t *newVal);

	// Optional) Specifies the password if a a Web page is accessed that requires a
	// login and password
	void get_WebSitePassword(CkString &str);
	// Optional) Specifies the password if a a Web page is accessed that requires a
	// login and password
	const wchar_t *webSitePassword(void);
	// Optional) Specifies the password if a a Web page is accessed that requires a
	// login and password
	void put_WebSitePassword(const wchar_t *newVal);



	// ----------------------
	// Methods
	// ----------------------
	// If disk caching is used, this must be called once for each cache root. For
	// example, if the cache is spread across D:\cacheRoot, E:\cacheRoot, and
	// F:\cacheRoot, an application would setup the cache object by calling AddRoot
	// three times -- once with D:\cacheRoot , once with E:\cacheRoot , and once with
	// F:\cacheRoot .
	void AddCacheRoot(const wchar_t *dir);

	// Adds a custom HTTP header to all HTTP requests sent by the MHT component. To add
	// multiple header fields, call this method once for each custom header.
	void AddCustomHeader(const wchar_t *name, const wchar_t *value);

	// (This method rarely needs to be called.) Includes an additional style sheet that
	// would not normally be included with the HTML. This method is provided for cases
	// when style sheet names are constructed and dynamically included in Javascript
	// such that MHT .NET cannot know beforehand what stylesheet to embed. MHT .NET by
	// default downloads and embeds all stylesheets externally referenced by the HTML
	void AddExternalStyleSheet(const wchar_t *url);

	// Removes all custom headers that may have accumulated from previous calls to
	// AddCustomHeader.
	void ClearCustomHeaders(void);

	// (This method rarely needs to be called.) Tells Chilkat MHT .NET to not embed any
	// images whose URL matches a pattern. Sometimes images can be referenced within
	// style sheets and not actually used when rendering the page. In cases like those,
	// the image will appear as an attachment in the HTML email. This feature allows
	// you to explicitly remove those images from the email so no attachments appear.
	void ExcludeImagesMatching(const wchar_t *pattern);

	// Creates an EML file from a web page or HTML file. All external images and style
	// sheets are downloaded and embedded in the EML file.
	bool GetAndSaveEML(const wchar_t *url_or_htmlFilepath, const wchar_t *emlPath);

	// Creates an asynchronous task to call the GetAndSaveEML method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetAndSaveEMLAsync(const wchar_t *url_or_htmlFilepath, const wchar_t *emlPath);

	// Creates an MHT file from a web page or local HTML file. All external images,
	// scripts, and style sheets are downloaded and embedded in the MHT file.
	bool GetAndSaveMHT(const wchar_t *url_or_htmlFilepath, const wchar_t *mhtPath);

	// Creates an asynchronous task to call the GetAndSaveMHT method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetAndSaveMHTAsync(const wchar_t *url_or_htmlFilepath, const wchar_t *mhtPath);

	// Creates an EML file from a web page or HTML file, compresses, and appends to a
	// new or existing Zip file. All external images and style sheets are downloaded
	// and embedded in the EML.
	bool GetAndZipEML(const wchar_t *url_or_htmlFilepath, const wchar_t *zipEntryFilename, const wchar_t *zipFilename);

	// Creates an asynchronous task to call the GetAndZipEML method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetAndZipEMLAsync(const wchar_t *url_or_htmlFilepath, const wchar_t *zipEntryFilename, const wchar_t *zipFilename);

	// Creates an MHT file from a web page or HTML file, compresses, and appends to a
	// new or existing Zip file. All external images and style sheets are downloaded
	// and embedded in the MHT.
	bool GetAndZipMHT(const wchar_t *url_or_htmlFilepath, const wchar_t *zipEntryFilename, const wchar_t *zipFilename);

	// Creates an asynchronous task to call the GetAndZipMHT method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetAndZipMHTAsync(const wchar_t *url_or_htmlFilepath, const wchar_t *zipEntryFilename, const wchar_t *zipFilename);

	// Returns the Nth cache root (indexing begins at 0). Cache roots are set by
	// calling AddCacheRoot one or more times.
	bool GetCacheRoot(int index, CkString &outStr);
	// Returns the Nth cache root (indexing begins at 0). Cache roots are set by
	// calling AddCacheRoot one or more times.
	const wchar_t *getCacheRoot(int index);
	// Returns the Nth cache root (indexing begins at 0). Cache roots are set by
	// calling AddCacheRoot one or more times.
	const wchar_t *cacheRoot(int index);

	// Creates EML from a web page or HTML file, and returns the EML (MIME) message
	// data as a string.
	bool GetEML(const wchar_t *url_or_htmlFilepath, CkString &outStr);
	// Creates EML from a web page or HTML file, and returns the EML (MIME) message
	// data as a string.
	const wchar_t *getEML(const wchar_t *url_or_htmlFilepath);
	// Creates EML from a web page or HTML file, and returns the EML (MIME) message
	// data as a string.
	const wchar_t *eML(const wchar_t *url_or_htmlFilepath);

	// Creates an asynchronous task to call the GetEML method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetEMLAsync(const wchar_t *url_or_htmlFilepath);

	// Creates MHT from a web page or local HTML file, and returns the MHT (MIME)
	// message data as a string
	bool GetMHT(const wchar_t *url_or_htmlFilepath, CkString &outStr);
	// Creates MHT from a web page or local HTML file, and returns the MHT (MIME)
	// message data as a string
	const wchar_t *getMHT(const wchar_t *url_or_htmlFilepath);
	// Creates MHT from a web page or local HTML file, and returns the MHT (MIME)
	// message data as a string
	const wchar_t *mHT(const wchar_t *url_or_htmlFilepath);

	// Creates an asynchronous task to call the GetMHT method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetMHTAsync(const wchar_t *url_or_htmlFilepath);

	// Creates an in-memory EML string from an in-memory HTML string. All external
	// images and style sheets are downloaded and embedded in the EML string that is
	// returned.
	bool HtmlToEML(const wchar_t *htmlText, CkString &outStr);
	// Creates an in-memory EML string from an in-memory HTML string. All external
	// images and style sheets are downloaded and embedded in the EML string that is
	// returned.
	const wchar_t *htmlToEML(const wchar_t *htmlText);

	// Creates an asynchronous task to call the HtmlToEML method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *HtmlToEMLAsync(const wchar_t *htmlText);

	// Creates an EML file from an in-memory HTML string. All external images and style
	// sheets are downloaded and embedded in the EML file.
	bool HtmlToEMLFile(const wchar_t *html, const wchar_t *emlFilename);

	// Creates an asynchronous task to call the HtmlToEMLFile method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *HtmlToEMLFileAsync(const wchar_t *html, const wchar_t *emlFilename);

	// Creates an in-memory MHT web archive from an in-memory HTML string. All external
	// images and style sheets are downloaded and embedded in the MHT string.
	bool HtmlToMHT(const wchar_t *htmlText, CkString &outStr);
	// Creates an in-memory MHT web archive from an in-memory HTML string. All external
	// images and style sheets are downloaded and embedded in the MHT string.
	const wchar_t *htmlToMHT(const wchar_t *htmlText);

	// Creates an asynchronous task to call the HtmlToMHT method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *HtmlToMHTAsync(const wchar_t *htmlText);

	// Creates an MHT file from an in-memory HTML string. All external images and style
	// sheets are downloaded and embedded in the MHT file.
	bool HtmlToMHTFile(const wchar_t *html, const wchar_t *mhtFilename);

	// Creates an asynchronous task to call the HtmlToMHTFile method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *HtmlToMHTFileAsync(const wchar_t *html, const wchar_t *mhtFilename);

	// Loads the caller of the task's async method.
	bool LoadTaskCaller(CkTaskW &task);

	// Removes a custom header by header field name.
	void RemoveCustomHeader(const wchar_t *name);

	// Restores the default property settings.
	void RestoreDefaults(void);

	// Unpacks the contents of a MHT file. The destination directory is specified by
	// unpackDir. The name of the HTML file created is specified by htmlFilename, and supporting
	// files (images, javascripts, etc.) are created in partsSubDir, which is automatically
	// created if it does not already exist.
	bool UnpackMHT(const wchar_t *mhtFilename, const wchar_t *unpackDir, const wchar_t *htmlFilename, const wchar_t *partsSubDir);

	// Same as UnpackMHT, except the MHT is passed in as an in-memory string.
	bool UnpackMHTString(const wchar_t *mhtString, const wchar_t *unpackDir, const wchar_t *htmlFilename, const wchar_t *partsSubDir);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
