// CkAiW.h: interface for the CkAiW class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.2.0

#ifndef _CkAiW_H
#define _CkAiW_H
	
#include "chilkatDefs.h"
#include "CkString.h"
#include "CkClassWithCallbacksW.h"

class CkTaskW;
class CkJsonObjectW;
class CkStringTableW;
class CkStringBuilderW;
class CkBinDataW;
class CkSocketW;
class CkBaseProgressW;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkAiW
class CK_VISIBLE_PUBLIC CkAiW  : public CkClassWithCallbacksW
{
	private:
	bool m_cbOwned;

	private:
	
	// Don't allow assignment or copying these objects.
	CkAiW(const CkAiW &);
	CkAiW &operator=(const CkAiW &);

    public:
	CkAiW(void);
	virtual ~CkAiW(void);

	

	static CkAiW *createNew(void);
	

	CkAiW(bool bCallbackOwned);
	static CkAiW *createNew(bool bCallbackOwned);

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	CkBaseProgressW *get_EventCallbackObject(void) const;
	void put_EventCallbackObject(CkBaseProgressW *progress);


	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// This is the API key used for authentication. Use your API key that matches your
	// Provider .
	// 
	// References:
	// 1: #Provider
	void get_ApiKey(CkString &str);
	// This is the API key used for authentication. Use your API key that matches your
	// Provider .
	// 
	// References:
	// 1: #Provider
	const wchar_t *apiKey(void);
	// This is the API key used for authentication. Use your API key that matches your
	// Provider .
	// 
	// References:
	// 1: #Provider
	void put_ApiKey(const wchar_t *newVal);

	// For multimodal inputs like image data, image URLs, file data, and file URLs, the
	// full data or URL is sent initially. If the property is set to true, the full
	// data/URL is re-sent in subsequent interactions. If set to false, only the
	// image or file summary is sent thereafter.
	// 
	// By default, this property is false.
	// 
	// Full transcript style: always send the entire conversation (including
	// files/images). This guarantees the model has all context, but can get expensive.
	// 
	// Summarized transcript style: for previously sent multimodal items, sends the
	// summary message (e.g. “Earlier, I uploaded a PDF with account statements”)
	// instead of the raw file or url itself.
	// 
	bool get_FullTranscript(void);
	// For multimodal inputs like image data, image URLs, file data, and file URLs, the
	// full data or URL is sent initially. If the property is set to true, the full
	// data/URL is re-sent in subsequent interactions. If set to false, only the
	// image or file summary is sent thereafter.
	// 
	// By default, this property is false.
	// 
	// Full transcript style: always send the entire conversation (including
	// files/images). This guarantees the model has all context, but can get expensive.
	// 
	// Summarized transcript style: for previously sent multimodal items, sends the
	// summary message (e.g. “Earlier, I uploaded a PDF with account statements”)
	// instead of the raw file or url itself.
	// 
	void put_FullTranscript(bool newVal);

	// The interval in milliseconds between each AbortCheck event callback, which
	// enables an application to abort certain method calls before they complete. By
	// default, HeartbeatMs is set to 0 , meaning no AbortCheck event callbacks will
	// trigger.
	// 
	// References:
	// 1: #AbortCheck
	int get_HeartbeatMs(void);
	// The interval in milliseconds between each AbortCheck event callback, which
	// enables an application to abort certain method calls before they complete. By
	// default, HeartbeatMs is set to 0 , meaning no AbortCheck event callbacks will
	// trigger.
	// 
	// References:
	// 1: #AbortCheck
	void put_HeartbeatMs(int newVal);

	// This applies to providers like OpenAI that can maintain conversation state on
	// the server. If set to true, only the conversation ID is sent with each query.
	// If set to false, the entire conversation transcript is sent with each query,
	// making each query stateless.
	// 
	// This only applies if a conversation is selected.
	// 
	// The default value of this property is false.
	// 
	bool get_HostedConvo(void);
	// This applies to providers like OpenAI that can maintain conversation state on
	// the server. If set to true, only the conversation ID is sent with each query.
	// If set to false, the entire conversation transcript is sent with each query,
	// making each query stateless.
	// 
	// This only applies if a conversation is selected.
	// 
	// The default value of this property is false.
	// 
	void put_HostedConvo(bool newVal);

	// The maximum amount of time to wait for additional incoming data when receiving a
	// response. The default value is 90000 (90 seconds). This is not a total timeout,
	// but the maximum time allowed when data transmission has paused.
	int get_IdleTimeoutMs(void);
	// The maximum amount of time to wait for additional incoming data when receiving a
	// response. The default value is 90000 (90 seconds). This is not a total timeout,
	// but the maximum time allowed when data transmission has paused.
	void put_IdleTimeoutMs(int newVal);

	// The model to be used for AI conversations. For example, GPT-4o or GPT-5 . The
	// list of available models can be obtained by calling GetModels .
	// 
	// The default value is the empty string. A model must always be specified. Chilkat
	// won't try to guess or default to a model.
	// 
	// 
	// References:
	// 1: #GetModels
	void get_Model(CkString &str);
	// The model to be used for AI conversations. For example, GPT-4o or GPT-5 . The
	// list of available models can be obtained by calling GetModels .
	// 
	// The default value is the empty string. A model must always be specified. Chilkat
	// won't try to guess or default to a model.
	// 
	// 
	// References:
	// 1: #GetModels
	const wchar_t *model(void);
	// The model to be used for AI conversations. For example, GPT-4o or GPT-5 . The
	// list of available models can be obtained by calling GetModels .
	// 
	// The default value is the empty string. A model must always be specified. Chilkat
	// won't try to guess or default to a model.
	// 
	// 
	// References:
	// 1: #GetModels
	void put_Model(const wchar_t *newVal);

	// This is the AI provider. Possible values are: openai , google , claude ,
	// deepseek , perplexity , and xai .
	// 
	// The default value is openai .
	// 
	void get_Provider(CkString &str);
	// This is the AI provider. Possible values are: openai , google , claude ,
	// deepseek , perplexity , and xai .
	// 
	// The default value is openai .
	// 
	const wchar_t *provider(void);
	// This is the AI provider. Possible values are: openai , google , claude ,
	// deepseek , perplexity , and xai .
	// 
	// The default value is openai .
	// 
	void put_Provider(const wchar_t *newVal);

	// The HTTP response status code for the last Ask is as follows:
	//     * 0 indicates an error occurred before receiving an HTTP response.
	//     * 200 indicates a successful response.
	//     * A failed response has a status code of 400 or higher.
	// 
	// References:
	// 1: #Ask
	int get_ResponseStatusCode(void);

	// The currently selected conversation can be set to your desired conversation
	// name. Once set, all future queries will be part of that conversation, updating
	// its state with each input and output. By default, no conversation is selected,
	// indicated by an empty string, leading to stateless queries. The first
	// conversation created or imported will be automatically selected. If you attempt
	// to select a non-existent conversation, the selection will not change. You can
	// reset this property to an empty string to revert to stateless querying.
	void get_SelectedConvo(CkString &str);
	// The currently selected conversation can be set to your desired conversation
	// name. Once set, all future queries will be part of that conversation, updating
	// its state with each input and output. By default, no conversation is selected,
	// indicated by an empty string, leading to stateless queries. The first
	// conversation created or imported will be automatically selected. If you attempt
	// to select a non-existent conversation, the selection will not change. You can
	// reset this property to an empty string to revert to stateless querying.
	const wchar_t *selectedConvo(void);
	// The currently selected conversation can be set to your desired conversation
	// name. Once set, all future queries will be part of that conversation, updating
	// its state with each input and output. By default, no conversation is selected,
	// indicated by an empty string, leading to stateless queries. The first
	// conversation created or imported will be automatically selected. If you attempt
	// to select a non-existent conversation, the selection will not change. You can
	// reset this property to an empty string to revert to stateless querying.
	void put_SelectedConvo(const wchar_t *newVal);

	// When set to true, the Ask method operates in streaming mode, returning
	// immediately after the request is sent. You can then use the PollAi and
	// NextAiEvent methods to receive streaming events. By default, this property is
	// false.
	// 
	// References:
	// 1: #Ask
	bool get_Streaming(void);
	// When set to true, the Ask method operates in streaming mode, returning
	// immediately after the request is sent. You can then use the PollAi and
	// NextAiEvent methods to receive streaming events. By default, this property is
	// false.
	// 
	// References:
	// 1: #Ask
	void put_Streaming(bool newVal);

	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	void get_UncommonOptions(CkString &str);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	const wchar_t *uncommonOptions(void);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	void put_UncommonOptions(const wchar_t *newVal);



	// ----------------------
	// Methods
	// ----------------------
	// Sends the current potentially multimodal input within the context of the
	// selected conversation and receives the model's output. Currently, the desired
	// outputType can only be text . Future versions of Chilkat will support image , audio ,
	// or a JSON schema to tell the model to return data in the specified JSON
	// structured output.
	// 
	// Accumulated outputs are cleared on entry to this method. Accumulated inputs are
	// cleared on the successful return of this method.
	// 
	// This method cannot be called while a streaming Ask is in progress. In such a
	// case the return value is false and nothing will occur.
	// 
	bool Ask(const wchar_t *outputType);

	// Creates an asynchronous task to call the Ask method with the arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *AskAsync(const wchar_t *outputType);

	// Deletes the conversation by its name. If name equals * then all conversations
	// are deleted.
	bool DeleteConvo(const wchar_t *name);

	// Exports the conversation specified by name to json, replacing json's contents
	// with the exported transcript. You can later import a conversation using
	// ImportConvo . The currently selected conversation can be exported by passing *
	// for the name.
	// 
	// References:
	// 1: #ImportConvo
	bool ExportConvo(const wchar_t *name, CkJsonObjectW &json);

	// Provides details about the last method called on this object instance. While
	// many methods do not generate information, some allow you to retrieve details by
	// accessing the last JSON data immediately after the method call returns.
	// 
	// Methods that produce last JSON information include: GetModels .
	// 
	// 
	// References:
	// 1: #GetModels
	void GetLastJsonData(CkJsonObjectW &json);

	// Returns a list of models available to your account, such as GPT-4o and GPT-5 .
	// The models are listed in st, sorted in ascending, case-insensitive order. To
	// access the raw JSON response after calling this method, use GetLastJsonData .
	// 
	// References:
	// 1: #GetLastJsonData
	bool GetModels(CkStringTableW &st);

	// Creates an asynchronous task to call the GetModels method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskW *GetModelsAsync(CkStringTableW &st);

	// Returns the text output from the last call to Ask .
	// 
	// References:
	// 1: #Ask
	bool GetOutputText(CkString &outStr);
	// Returns the text output from the last call to Ask .
	// 
	// References:
	// 1: #Ask
	const wchar_t *getOutputText(void);
	// Returns the text output from the last call to Ask .
	// 
	// References:
	// 1: #Ask
	const wchar_t *outputText(void);

	// Returns the text output, appended to sb, from the last call to Ask .
	// 
	// References:
	// 1: #Ask
	bool GetOutputTextSb(CkStringBuilderW &sb);

	// Imports the conversation from json and assigns it the name in name.
	bool ImportConvo(const wchar_t *name, CkJsonObjectW &json);

	// Adds file data, such as a PDF, to the potentially multimodal input that will be
	// sent in the next call to Ask . The bd contains the file data.
	// 
	// If FullTranscript is _CKFALSE_, summary is sent in subsequent interactions instead
	// of the file data. If FullTranscript is true, summary is not sent, and the file
	// data is re-sent in each interaction.
	// 
	// This method cannot be used with DeepSeek .
	// 
	// 
	// References:
	// 1: #Ask
	// 2: #FullTranscript
	bool InputAddFileData(const wchar_t *filename, CkBinDataW &bd, const wchar_t *summary);

	// Adds a file located at a url to the potentially multimodal input that will be
	// sent in the next call to Ask .
	// 
	// If FullTranscript is _CKFALSE_, summary is sent in subsequent interactions instead
	// of the file URL. If FullTranscript is true, summary is not sent, and the file URL
	// is re-sent in each interaction.
	// 
	// This method cannot be used with DeepSeek .
	// 
	// 
	// References:
	// 1: #Ask
	// 2: #FullTranscript
	bool InputAddFileUrl(const wchar_t *url, const wchar_t *summary);

	// Adds an image to the potentially multimodal input that will be sent in the next
	// call to Ask . The bd contains the images data. The image data must be jpeg,
	// png, or webp format.
	// 
	// If FullTranscript is _CKFALSE_, summary is sent in subsequent interactions instead
	// of the image data. If FullTranscript is true, summary is not sent, and the image
	// data is re-sent in each interaction.
	// 
	// This method cannot be used with DeepSeek . DeepSeek does not appear to expose an
	// OpenAI-compatible vision model (yet). You cannot send image URLs or image data
	// to DeepSeek.
	// 
	// 
	// References:
	// 1: #Ask
	// 2: #FullTranscript
	bool InputAddImageData(CkBinDataW &bd, const wchar_t *summary);

	// Adds an image located at a url to the potentially multimodal input that will be
	// sent in the next call to Ask .
	// 
	// If FullTranscript is _CKFALSE_, summary is sent in subsequent interactions instead
	// of the image URL. If FullTranscript is true, summary is not sent, and the image
	// URL is re-sent in each interaction.
	// 
	// This method cannot be used with DeepSeek . DeepSeek does not appear to expose an
	// OpenAI-compatible vision model (yet). You cannot send image URLs or image data
	// to DeepSeek.
	// 
	// 
	// References:
	// 1: #Ask
	// 2: #FullTranscript
	bool InputAddImageUrl(const wchar_t *url, const wchar_t *summary);

	// Adds text to the potentially multimodal input that will be sent in the next call
	// to Ask .
	// 
	// References:
	// 1: #Ask
	bool InputAddText(const wchar_t *text);

	// Adds text to the potentially multimodal input that will be sent in the next call
	// to Ask .
	// 
	// References:
	// 1: #Ask
	bool InputAddTextSb(CkStringBuilderW &sb);

	// Clears the inputs to be sent in the next call to Ask .
	// 
	// References:
	// 1: #Ask
	void InputClear(void);

	// Returns the full list of conversation names in st.
	bool ListConvos(CkStringTableW &st);

	// Creates and initializes a transcript for a new conversation. The name is a
	// unique name for the conversation. You can reference the conversation by this
	// name, such as for the ExportConvo method.
	// 
	// The sysMsg sets the broad behavior, tone, and role of the assistant. Example: "You
	// are a polite tutor who explains concepts clearly and simply." Think of it as the
	// high-level persona or instructions the model follows throughout the
	// conversation. The devMsg provides more technical or policy-level guidance.
	// Example: "Always respond in Markdown. Do not reveal internal reasoning. Keep
	// answers under 200 words." It’s like hidden scaffolding to enforce app rules,
	// formatting, or safety constraints.
	// 
	// Note: The first conversation created is automatically set as the SelectedConvo .
	// You can use any unique name for a conversation except * .
	// 
	// 
	// References:
	// 1: #ExportConvo
	// 2: #SelectedConvo
	bool NewConvo(const wchar_t *name, const wchar_t *sysMsg, const wchar_t *devMsg);

	// Retrieves the next available AI streaming mode response update. Use the PollAi
	// method to check if a response update is immediately accessible. The event name
	// is returned in sbName. If the event name is delta , the text is returned in sbDelta.
	// 
	// For the complete raw event JSON, use the GetLastJsonData function. Note that the
	// raw JSON format varies by AI provider.
	// 
	// Each AI provider (e.g., OpenAI, Claude, xAI) sends a unique set of events. Some
	// of these events mark the start and end of sections and content parts, while
	// others do not. Chilkat standardizes these events and returns the following event
	// types.
	//     * response_created — The server acknowledges the request and has created a
	//     response object. Nothing has been streamed yet — it’s just the signal that the
	//     response pipeline is open.
	//     * empty — Some AI providers send empty heartbeat / keep-alive updates to
	//     ensure the stream stays open and proxies don't time out.
	//     * output_item_added — A new output item has been added to the response. An
	//     “output item” is a top-level container — could be text, tool call, or other
	//     structured content.
	//     * content_part_added — Within the output item, the model starts a new
	//     content part. A content part is typically a segment of a specific type (e.g.,
	//     text, JSON snippet, or image reference).
	//     * delta — These are the incremental text tokens being streamed. Each delta
	//     contains the next piece of text (like characters or words). You’ll see many of
	//     these in sequence while the model is generating.
	//     * output_text_done — Marks the end of the text streaming for that content
	//     part. No more deltas will arrive for this part.
	//     * content_part_done — Closes the current content part. Tells you the model
	//     is finished with that segment (e.g., done streaming a paragraph).
	//     * output_item_done — Closes the current output item entirely. Means that
	//     item is fully complete (all its parts are done).
	//     * response_completed — The entire response object is finished. No more items
	//     will be added, and the stream will soon close.
	//     * null_terminator — The stream is closed. All streaming responses end with a
	//     single null_terminator.
	// 
	// maxWaitMs defines the maximum wait time to receive the complete event. For instance,
	// if PollAi signals an available streaming update but only part of the event JSON
	// has been received, the rest is probably on its way. In such cases, this method
	// must wait to receive the entire JSON.
	// 
	// 
	// References:
	// 1: #PollAi
	// 2: #GetLastJsonData
	bool NextAiEvent(int maxWaitMs, CkStringBuilderW &sbName, CkStringBuilderW &sbDelta);

	// Returns immediately with one of the following values:
	// 
	// -1 - Error
	// 0 - No streaming event updates are available.
	// 1 - A streaming event updates is ready for retrieval via NextAiEvent
	// 2 - The streaming AI response has already completed, or no streaming response is
	// ongoing.
	// 
	// If abort is true, then the streaming response is aborted and this method
	// returns the value 2 . Applications should pass in false for abort to continue
	// streaming.
	// 
	// 
	// References:
	// 1: #NextAiEvent
	int PollAi(bool abort);

	// This method copies connection settings, including HTTP proxy, SOCKS proxy,
	// network interface IP address, and other related settings from sock. It's
	// optional; if not used, default settings apply. Call this method before sending
	// REST API requests to an AI provider.
	bool SetConnectionSettings(CkSocketW &sock);

	// This method is provided for convenience. It causes the calling thread to sleep
	// for a number of milliseconds.
	void SleepMs(int millisec);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
