// CkGlobalW.h: interface for the CkGlobalW class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.2.0

#ifndef _CkGlobalW_H
#define _CkGlobalW_H
	
#include "chilkatDefs.h"
#include "CkString.h"
#include "CkWideCharBase.h"




#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkGlobalW
class CK_VISIBLE_PUBLIC CkGlobalW  : public CkWideCharBase
{
	

	private:
	
	// Don't allow assignment or copying these objects.
	CkGlobalW(const CkGlobalW &);
	CkGlobalW &operator=(const CkGlobalW &);

    public:
	CkGlobalW(void);
	virtual ~CkGlobalW(void);

	

	static CkGlobalW *createNew(void);
	

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	

	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// The default ANSI code page is determined at runtime based on the computer where
	// the application happens to be running. For example, the ANSI code page for an
	// application running on a Japanese computer is likely to be Shift_JIS (code page
	// 932), whereas on a US-English computer it would be iso-8859-1 (or Windows-1252
	// which is essentially a superset of iso-8859-1).
	// 
	// If there is a desire for the Chilkat library to use a specific ANSI code page
	// regardless of locale, then this property should be set to the desired code page.
	// The default value of this property is the ANSI code page of the local computer.
	// 
	int get_AnsiCodePage(void);
	// The default ANSI code page is determined at runtime based on the computer where
	// the application happens to be running. For example, the ANSI code page for an
	// application running on a Japanese computer is likely to be Shift_JIS (code page
	// 932), whereas on a US-English computer it would be iso-8859-1 (or Windows-1252
	// which is essentially a superset of iso-8859-1).
	// 
	// If there is a desire for the Chilkat library to use a specific ANSI code page
	// regardless of locale, then this property should be set to the desired code page.
	// The default value of this property is the ANSI code page of the local computer.
	// 
	void put_AnsiCodePage(int newVal);

	// If set to true, then Q or B encoded strings can be passed in any string
	// argument to any Chilkat method, and Chilkat will automatically decode the string
	// before using it. This is meant to be a convenient way to use non-usascii literal
	// strings in your source code. See the links below for an example and for a
	// discussion about non-usascii literal strings.
	bool get_AutoQBDecode(void);
	// If set to true, then Q or B encoded strings can be passed in any string
	// argument to any Chilkat method, and Chilkat will automatically decode the string
	// before using it. This is meant to be a convenient way to use non-usascii literal
	// strings in your source code. See the links below for an example and for a
	// discussion about non-usascii literal strings.
	void put_AutoQBDecode(bool newVal);

	// Selects the default NTLM protocol version to use for NTLM authentication for
	// HTTP, POP3, IMAP, SMTP, and HTTP proxies. The default value is 2. This property
	// may optionally be set to 1.
	int get_DefaultNtlmVersion(void);
	// Selects the default NTLM protocol version to use for NTLM authentication for
	// HTTP, POP3, IMAP, SMTP, and HTTP proxies. The default value is 2. This property
	// may optionally be set to 1.
	void put_DefaultNtlmVersion(int newVal);

	// If DNS caching is enabled, this is the time-to-live (in seconds) for a cached
	// DNS lookup. A DNS lookup result older than this expiration time is discarded,
	// and causes a new DNS lookup to occur. A value of 0 indicates an infinite
	// time-to-live. The default value of this property is 0.
	int get_DnsTimeToLive(void);
	// If DNS caching is enabled, this is the time-to-live (in seconds) for a cached
	// DNS lookup. A DNS lookup result older than this expiration time is discarded,
	// and causes a new DNS lookup to occur. A value of 0 indicates an infinite
	// time-to-live. The default value of this property is 0.
	void put_DnsTimeToLive(int newVal);

	// Controls whether DNS domain lookups (to resolve to IP addresses) are cached in
	// memory. The default value is false, meaning that DNS caching is disabled.
	bool get_EnableDnsCaching(void);
	// Controls whether DNS domain lookups (to resolve to IP addresses) are cached in
	// memory. The default value is false, meaning that DNS caching is disabled.
	void put_EnableDnsCaching(bool newVal);

	// The maximum number of thread pool threads. The default value is 100. The maximum
	// value is 500. Note: Asynchronous worker threads are created on as needed up to
	// the maximum.
	int get_MaxThreads(void);
	// The maximum number of thread pool threads. The default value is 100. The maximum
	// value is 500. Note: Asynchronous worker threads are created on as needed up to
	// the maximum.
	void put_MaxThreads(int newVal);

	// If true, then use IPv6 over IPv4 when both are supported for a particular
	// domain. The default value of this property is false, which will choose IPv4
	// over IPv6.
	// 
	// Note: Setting this property has the effect of also setting the default value of
	// the PreferIpv6 property for other classes.
	// 
	bool get_PreferIpv6(void);
	// If true, then use IPv6 over IPv4 when both are supported for a particular
	// domain. The default value of this property is false, which will choose IPv4
	// over IPv6.
	// 
	// Note: Setting this property has the effect of also setting the default value of
	// the PreferIpv6 property for other classes.
	// 
	void put_PreferIpv6(bool newVal);

	// If set, indicates the path of a log file to be used by the thread pool thread
	// and each of the pool worker threads for logging async activity. Chilkat always
	// appends to the log file. If the log file already exists, then new information
	// will be appended.
	void get_ThreadPoolLogPath(CkString &str);
	// If set, indicates the path of a log file to be used by the thread pool thread
	// and each of the pool worker threads for logging async activity. Chilkat always
	// appends to the log file. If the log file already exists, then new information
	// will be appended.
	const wchar_t *threadPoolLogPath(void);
	// If set, indicates the path of a log file to be used by the thread pool thread
	// and each of the pool worker threads for logging async activity. Chilkat always
	// appends to the log file. If the log file already exists, then new information
	// will be appended.
	void put_ThreadPoolLogPath(const wchar_t *newVal);

	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	void get_UncommonOptions(CkString &str);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	const wchar_t *uncommonOptions(void);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	void put_UncommonOptions(const wchar_t *newVal);

	// Indicates the unlocked status for the last call to UnlockBundle. The possible
	// values are:
	//     1. Not unlocked. (Still in locked state.)
	//     2. Unlocked with in fully-functional trial mode.
	//     3. Unlocked using a valid purchased unlock code.
	// 
	// Note: If UnlockBundle is called with a purchased unlock code, the UnlockStatus
	// is correctly set to the value 2. This value is intentionally sticky. If a
	// subsequent and redundant call to UnlockBundle happens, it is effectively a No-Op
	// because the library is already unlocked. The UnlockStatus will not change.
	// 
	// If however, if the 1st call resulted in UnlockStatus = 1, and THEN the unlock
	// method is called again with a purchased unlock code, the UnlockStatus should
	// change from 1 to 2.
	// 
	int get_UnlockStatus(void);

	// This property should typically be left at the default value of false. If set
	// to true, then Chilkat will use a constructed ASN.1 encoding for PCKS7 data.
	// (This is an internal implementation option that normally does not matter, and
	// should not matter. Some PKCS7 receiving systems might be picky, and this option
	// can be used to satisfy this requirement.)
	bool get_UsePkcsConstructedEncoding(void);
	// This property should typically be left at the default value of false. If set
	// to true, then Chilkat will use a constructed ASN.1 encoding for PCKS7 data.
	// (This is an internal implementation option that normally does not matter, and
	// should not matter. Some PKCS7 receiving systems might be picky, and this option
	// can be used to satisfy this requirement.)
	void put_UsePkcsConstructedEncoding(bool newVal);

	// If set to true, then causes extremely verbose logging (in LastErrorText) all
	// TLS connections in any Chilkat class. This property should only be used for
	// troubleshooting TLS problems. The default value is false.
	// 
	// Note: This property only has effect on Chilkat objects not yet created. Set the
	// property first, then instantiate the Chilkat object.
	// 
	bool get_VerboseTls(void);
	// If set to true, then causes extremely verbose logging (in LastErrorText) all
	// TLS connections in any Chilkat class. This property should only be used for
	// troubleshooting TLS problems. The default value is false.
	// 
	// Note: This property only has effect on Chilkat objects not yet created. Set the
	// property first, then instantiate the Chilkat object.
	// 
	void put_VerboseTls(bool newVal);



	// ----------------------
	// Methods
	// ----------------------
	// This function clears the Chilkat in-memory DNS cache, which stores
	// hostname-to-IP address mappings to avoid repeated DNS lookups.
	// 
	// Note:
	// 
	//     * The DNS cache is shared across all Chilkat objects, so clearing it will
	//     impact all such objects.
	//     * Chilkat's DNS caching respects the TTL (time to live) of DNS records. If
	//     the TTL has expired since the initial lookup, Chilkat will perform a new DNS
	//     query and update the cache with the latest IP address.
	bool DnsClearCache(void);

	// Called to stop and finalize all threads in the thread pool, and causes the
	// thread pool thread to exit.
	// 
	// The following behaviors exist in v9.5.0.64 and later:
	//     * All remaining asynchronous tasks are automatically canceled.
	//     * Restores the thread pool to it's pristine state where no background
	//     threads are running.
	// 
	// It is a good idea to call this method at the very end of a program, just before
	// it exits. This is especially true for programs written in VBScript, VB6, FoxPro,
	// and PowerBuilder.
	// 
	bool FinalizeThreadPool(void);

	// Logs a line to the thread pool log file.
	bool ThreadPoolLogLine(const wchar_t *str);

	// Unlocks the entire Chilkat API for all classes. This should be called once at
	// the beginning of a program. Once unlocked, objects of any Chilkat class may be
	// instantiated and used. To unlock in fully-functional 30-day trial mode, pass any
	// string, such as Hello , in bundleUnlockCode. If a license is purchased, then replace the
	// Hello with the purchased unlock code.
	// 
	// After calling UnlockBundle once, the instance of the CLASS_NAME object may be
	// discarded/deleted (assuming the programming language requires explicit deletes).
	// Multiple calls to UnlockBundle are harmless. If the Chilkat API is already
	// unlocked, the duplicate calls to UnlockBundle are no-ops.
	// 
	// Important: Unlocking sets a flag in memory to indicate the unlocked status.
	// There are no licensing files, and there is no communication with any Chilkat
	// servers. This means your application, script, etc. must call UnlockBundle once
	// at the start each time it runs. The good thing is that your application can run
	// on any computer -- there are no licensing files to worry about. Also: If an
	// application forgets to call UnlockBundle, Chilkat will automatically unlock in
	// trial mode, and this will eventually fail when the trial runs out. If you
	// purchased a license, it is very important to make sure you call UnlockBundle
	// with the purchased unlock code.
	// 
	bool UnlockBundle(const wchar_t *bundleUnlockCode);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
