// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.2.0

// Generic/internal class name =  PublicKey
// Wrapped Chilkat C++ class name =  CkPublicKey

@class CkoBinData;


@interface CkoPublicKey : NSObject {

	@private
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic, readonly) BOOL Empty;
@property (nonatomic, readonly, copy) NSNumber *KeySize;
@property (nonatomic, readonly, copy) NSString *KeyType;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
// method: GetDer
- (NSData *)GetDer: (BOOL)preferPkcs1;
// method: GetDerBd
- (BOOL)GetDerBd: (BOOL)preferPkcs1 
	bd: (CkoBinData *)bd;
// method: GetEncoded
- (NSString *)GetEncoded: (BOOL)preferPkcs1 
	encoding: (NSString *)encoding;
// method: GetJwk
- (NSString *)GetJwk;
// method: GetJwkThumbprint
- (NSString *)GetJwkThumbprint: (NSString *)hashAlg;
// method: GetPem
- (NSString *)GetPem: (BOOL)preferPkcs1;
// method: GetXml
- (NSString *)GetXml;
// method: LoadBase64
- (BOOL)LoadBase64: (NSString *)keyStr;
// method: LoadBd
- (BOOL)LoadBd: (CkoBinData *)bd;
// method: LoadEcdsa
- (BOOL)LoadEcdsa: (NSString *)curveName 
	Qx: (NSString *)Qx 
	Qy: (NSString *)Qy;
// method: LoadEd25519
- (BOOL)LoadEd25519: (NSString *)pubKey;
// method: LoadFromBinary
- (BOOL)LoadFromBinary: (NSData *)keyBytes;
// method: LoadFromFile
- (BOOL)LoadFromFile: (NSString *)path;
// method: LoadFromString
- (BOOL)LoadFromString: (NSString *)keyString;
// method: SaveDerFile
- (BOOL)SaveDerFile: (BOOL)preferPkcs1 
	path: (NSString *)path;
// method: SavePemFile
- (BOOL)SavePemFile: (BOOL)preferPkcs1 
	path: (NSString *)path;
// method: SaveXmlFile
- (BOOL)SaveXmlFile: (NSString *)path;

@end
