unit Ai;

interface

type

HCkJsonObject = Pointer;
HCkSocket = Pointer;
HCkString = Pointer;
HCkBinData = Pointer;
HCkAi = Pointer;
HCkTask = Pointer;
HCkStringTable = Pointer;
HCkStringBuilder = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TAiAbortCheck = function(): Integer; cdecl;
TAiProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TAiPercentDone = function(pctDone: Integer): Integer; cdecl;
TAiTaskCompleted = procedure(task: HCkTask); cdecl;


function CkAi_Create: HCkAi;  stdcall;
procedure CkAi_Dispose(handle: HCkAi); stdcall;

procedure CkAi_SetAbortCheck(objHandle: HCkAi; fn: TAiAbortCheck) stdcall;
procedure CkAi_SetProgressInfo(objHandle: HCkAi; fn: TAiProgressInfo) stdcall;
procedure CkAi_SetPercentDone(objHandle: HCkAi; fn: TAiPercentDone) stdcall;
procedure CkAi_SetTaskCompleted(objHandle: HCkAi; fn: TAiTaskCompleted) stdcall;
procedure CkAi_getApiKey(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putApiKey(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__apiKey(objHandle: HCkAi): PWideChar;
procedure CkAi_getApiKeyHeader(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putApiKeyHeader(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__apiKeyHeader(objHandle: HCkAi): PWideChar;
procedure CkAi_getApiSpec(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putApiSpec(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__apiSpec(objHandle: HCkAi): PWideChar;
procedure CkAi_getBaseUrl(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putBaseUrl(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__baseUrl(objHandle: HCkAi): PWideChar;
procedure CkAi_getDebugLogFilePath(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putDebugLogFilePath(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__debugLogFilePath(objHandle: HCkAi): PWideChar;
function CkAi_getFullTranscript(objHandle: HCkAi): wordbool;
procedure CkAi_putFullTranscript(objHandle: HCkAi; newPropVal: wordbool);
function CkAi_getHeartbeatMs(objHandle: HCkAi): Integer;
procedure CkAi_putHeartbeatMs(objHandle: HCkAi; newPropVal: Integer);
function CkAi_getHostedConvo(objHandle: HCkAi): wordbool;
procedure CkAi_putHostedConvo(objHandle: HCkAi; newPropVal: wordbool);
function CkAi_getIdleTimeoutMs(objHandle: HCkAi): Integer;
procedure CkAi_putIdleTimeoutMs(objHandle: HCkAi; newPropVal: Integer);
procedure CkAi_getLastErrorHtml(objHandle: HCkAi; outPropVal: HCkString);
function CkAi__lastErrorHtml(objHandle: HCkAi): PWideChar;
procedure CkAi_getLastErrorText(objHandle: HCkAi; outPropVal: HCkString);
function CkAi__lastErrorText(objHandle: HCkAi): PWideChar;
procedure CkAi_getLastErrorXml(objHandle: HCkAi; outPropVal: HCkString);
function CkAi__lastErrorXml(objHandle: HCkAi): PWideChar;
function CkAi_getLastMethodSuccess(objHandle: HCkAi): wordbool;
procedure CkAi_putLastMethodSuccess(objHandle: HCkAi; newPropVal: wordbool);
procedure CkAi_getModel(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putModel(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__model(objHandle: HCkAi): PWideChar;
procedure CkAi_getProvider(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putProvider(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__provider(objHandle: HCkAi): PWideChar;
function CkAi_getResponseStatusCode(objHandle: HCkAi): Integer;
procedure CkAi_getSelectedConvo(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putSelectedConvo(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__selectedConvo(objHandle: HCkAi): PWideChar;
function CkAi_getStreaming(objHandle: HCkAi): wordbool;
procedure CkAi_putStreaming(objHandle: HCkAi; newPropVal: wordbool);
procedure CkAi_getUncommonOptions(objHandle: HCkAi; outPropVal: HCkString);
procedure CkAi_putUncommonOptions(objHandle: HCkAi; newPropVal: PWideChar);
function CkAi__uncommonOptions(objHandle: HCkAi): PWideChar;
function CkAi_getVerboseLogging(objHandle: HCkAi): wordbool;
procedure CkAi_putVerboseLogging(objHandle: HCkAi; newPropVal: wordbool);
procedure CkAi_getVersion(objHandle: HCkAi; outPropVal: HCkString);
function CkAi__version(objHandle: HCkAi): PWideChar;
function CkAi_Ask(objHandle: HCkAi; outputType: PWideChar): wordbool;
function CkAi_AskAsync(objHandle: HCkAi; outputType: PWideChar): HCkTask;
function CkAi_DeleteConvo(objHandle: HCkAi; name: PWideChar): wordbool;
function CkAi_ExportConvo(objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool;
procedure CkAi_GetLastJsonData(objHandle: HCkAi; json: HCkJsonObject);
function CkAi_GetModels(objHandle: HCkAi; st: HCkStringTable): wordbool;
function CkAi_GetModelsAsync(objHandle: HCkAi; st: HCkStringTable): HCkTask;
function CkAi_GetOutputText(objHandle: HCkAi; outStr: HCkString): wordbool;
function CkAi__getOutputText(objHandle: HCkAi): PWideChar;
function CkAi_GetOutputTextSb(objHandle: HCkAi; sb: HCkStringBuilder): wordbool;
function CkAi_ImportConvo(objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool;
function CkAi_InputAddFileData(objHandle: HCkAi; filename: PWideChar; bd: HCkBinData; summary: PWideChar): wordbool;
function CkAi_InputAddFileUrl(objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool;
function CkAi_InputAddImageData(objHandle: HCkAi; bd: HCkBinData; summary: PWideChar): wordbool;
function CkAi_InputAddImageUrl(objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool;
function CkAi_InputAddText(objHandle: HCkAi; text: PWideChar): wordbool;
function CkAi_InputAddTextSb(objHandle: HCkAi; sb: HCkStringBuilder): wordbool;
procedure CkAi_InputClear(objHandle: HCkAi);
function CkAi_ListConvos(objHandle: HCkAi; st: HCkStringTable): wordbool;
function CkAi_NewConvo(objHandle: HCkAi; name: PWideChar; sysMsg: PWideChar; devMsg: PWideChar): wordbool;
function CkAi_NextAiEvent(objHandle: HCkAi; maxWaitMs: Integer; sbName: HCkStringBuilder; sbDelta: HCkStringBuilder): wordbool;
function CkAi_PollAi(objHandle: HCkAi; abort: wordbool): Integer;
function CkAi_SetAskParams(objHandle: HCkAi; json: HCkJsonObject): wordbool;
function CkAi_SetConnectionSettings(objHandle: HCkAi; sock: HCkSocket): wordbool;
function CkAi_SetProviderParams(objHandle: HCkAi; json: HCkJsonObject): wordbool;
procedure CkAi_SleepMs(objHandle: HCkAi; millisec: Integer);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkAi_Create = function : HCkAi; stdcall;
  TCkAi_Dispose = procedure (handle: HCkAi); stdcall;
  TCkAi_SetAbortCheck = procedure (objHandle: HCkAi; fn: TAiAbortCheck); stdcall;
  TCkAi_SetProgressInfo = procedure (objHandle: HCkAi; fn: TAiProgressInfo); stdcall;
  TCkAi_SetPercentDone = procedure (objHandle: HCkAi; fn: TAiPercentDone); stdcall;
  TCkAi_SetTaskCompleted = procedure (objHandle: HCkAi; fn: TAiTaskCompleted); stdcall;
  TCkAi_getApiKey = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putApiKey = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__apiKey = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getApiKeyHeader = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putApiKeyHeader = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__apiKeyHeader = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getApiSpec = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putApiSpec = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__apiSpec = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getBaseUrl = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putBaseUrl = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__baseUrl = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getDebugLogFilePath = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putDebugLogFilePath = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__debugLogFilePath = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getFullTranscript = function (objHandle: HCkAi): wordbool; stdcall;
  TCkAi_putFullTranscript = procedure (objHandle: HCkAi; newPropVal: wordbool); stdcall;
  TCkAi_getHeartbeatMs = function (objHandle: HCkAi): Integer; stdcall;
  TCkAi_putHeartbeatMs = procedure (objHandle: HCkAi; newPropVal: Integer); stdcall;
  TCkAi_getHostedConvo = function (objHandle: HCkAi): wordbool; stdcall;
  TCkAi_putHostedConvo = procedure (objHandle: HCkAi; newPropVal: wordbool); stdcall;
  TCkAi_getIdleTimeoutMs = function (objHandle: HCkAi): Integer; stdcall;
  TCkAi_putIdleTimeoutMs = procedure (objHandle: HCkAi; newPropVal: Integer); stdcall;
  TCkAi_getLastErrorHtml = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi__lastErrorHtml = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getLastErrorText = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi__lastErrorText = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getLastErrorXml = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi__lastErrorXml = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getLastMethodSuccess = function (objHandle: HCkAi): wordbool; stdcall;
  TCkAi_putLastMethodSuccess = procedure (objHandle: HCkAi; newPropVal: wordbool); stdcall;
  TCkAi_getModel = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putModel = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__model = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getProvider = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putProvider = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__provider = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getResponseStatusCode = function (objHandle: HCkAi): Integer; stdcall;
  TCkAi_getSelectedConvo = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putSelectedConvo = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__selectedConvo = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getStreaming = function (objHandle: HCkAi): wordbool; stdcall;
  TCkAi_putStreaming = procedure (objHandle: HCkAi; newPropVal: wordbool); stdcall;
  TCkAi_getUncommonOptions = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi_putUncommonOptions = procedure (objHandle: HCkAi; newPropVal: PWideChar); stdcall;
  TCkAi__uncommonOptions = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_getVerboseLogging = function (objHandle: HCkAi): wordbool; stdcall;
  TCkAi_putVerboseLogging = procedure (objHandle: HCkAi; newPropVal: wordbool); stdcall;
  TCkAi_getVersion = procedure (objHandle: HCkAi; outPropVal: HCkString); stdcall;
  TCkAi__version = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_Ask = function (objHandle: HCkAi; outputType: PWideChar): wordbool; stdcall;
  TCkAi_AskAsync = function (objHandle: HCkAi; outputType: PWideChar): HCkTask; stdcall;
  TCkAi_DeleteConvo = function (objHandle: HCkAi; name: PWideChar): wordbool; stdcall;
  TCkAi_ExportConvo = function (objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool; stdcall;
  TCkAi_GetLastJsonData = procedure (objHandle: HCkAi; json: HCkJsonObject); stdcall;
  TCkAi_GetModels = function (objHandle: HCkAi; st: HCkStringTable): wordbool; stdcall;
  TCkAi_GetModelsAsync = function (objHandle: HCkAi; st: HCkStringTable): HCkTask; stdcall;
  TCkAi_GetOutputText = function (objHandle: HCkAi; outStr: HCkString): wordbool; stdcall;
  TCkAi__getOutputText = function (objHandle: HCkAi): PWideChar; stdcall;
  TCkAi_GetOutputTextSb = function (objHandle: HCkAi; sb: HCkStringBuilder): wordbool; stdcall;
  TCkAi_ImportConvo = function (objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool; stdcall;
  TCkAi_InputAddFileData = function (objHandle: HCkAi; filename: PWideChar; bd: HCkBinData; summary: PWideChar): wordbool; stdcall;
  TCkAi_InputAddFileUrl = function (objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool; stdcall;
  TCkAi_InputAddImageData = function (objHandle: HCkAi; bd: HCkBinData; summary: PWideChar): wordbool; stdcall;
  TCkAi_InputAddImageUrl = function (objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool; stdcall;
  TCkAi_InputAddText = function (objHandle: HCkAi; text: PWideChar): wordbool; stdcall;
  TCkAi_InputAddTextSb = function (objHandle: HCkAi; sb: HCkStringBuilder): wordbool; stdcall;
  TCkAi_InputClear = procedure (objHandle: HCkAi); stdcall;
  TCkAi_ListConvos = function (objHandle: HCkAi; st: HCkStringTable): wordbool; stdcall;
  TCkAi_NewConvo = function (objHandle: HCkAi; name: PWideChar; sysMsg: PWideChar; devMsg: PWideChar): wordbool; stdcall;
  TCkAi_NextAiEvent = function (objHandle: HCkAi; maxWaitMs: Integer; sbName: HCkStringBuilder; sbDelta: HCkStringBuilder): wordbool; stdcall;
  TCkAi_PollAi = function (objHandle: HCkAi; abort: wordbool): Integer; stdcall;
  TCkAi_SetAskParams = function (objHandle: HCkAi; json: HCkJsonObject): wordbool; stdcall;
  TCkAi_SetConnectionSettings = function (objHandle: HCkAi; sock: HCkSocket): wordbool; stdcall;
  TCkAi_SetProviderParams = function (objHandle: HCkAi; json: HCkJsonObject): wordbool; stdcall;
  TCkAi_SleepMs = procedure (objHandle: HCkAi; millisec: Integer); stdcall;

var
  _fkt_ptr_arr:   array [0..81] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkAi_Create : HCkAi;
begin
  result := TCkAi_Create(_map(0, 'CkAi_Create'));
end;

procedure CkAi_Dispose (handle: HCkAi);
begin
  TCkAi_Dispose(_map(1, 'CkAi_Dispose'))
    (handle);
end;


procedure CkAi_SetAbortCheck (objHandle: HCkAi; fn: TAiAbortCheck);
begin
    TCkAi_SetAbortCheck(_map(2, 'CkAi_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkAi_SetProgressInfo (objHandle: HCkAi; fn: TAiProgressInfo);
begin
    TCkAi_SetProgressInfo(_map(3, 'CkAi_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkAi_SetPercentDone (objHandle: HCkAi; fn: TAiPercentDone);
begin
    TCkAi_SetPercentDone(_map(4, 'CkAi_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkAi_SetTaskCompleted (objHandle: HCkAi; fn: TAiTaskCompleted);
begin
    TCkAi_SetTaskCompleted(_map(5, 'CkAi_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkAi_getApiKey (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getApiKey(_map(6, 'CkAi_getApiKey'))
    (objHandle, outPropVal);
end;

procedure CkAi_putApiKey (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putApiKey(_map(7, 'CkAi_putApiKey'))
    (objHandle, newPropVal);
end;

function CkAi__apiKey (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__apiKey(_map(8, 'CkAi__apiKey'))
    (objHandle);
end;

procedure CkAi_getApiKeyHeader (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getApiKeyHeader(_map(9, 'CkAi_getApiKeyHeader'))
    (objHandle, outPropVal);
end;

procedure CkAi_putApiKeyHeader (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putApiKeyHeader(_map(10, 'CkAi_putApiKeyHeader'))
    (objHandle, newPropVal);
end;

function CkAi__apiKeyHeader (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__apiKeyHeader(_map(11, 'CkAi__apiKeyHeader'))
    (objHandle);
end;

procedure CkAi_getApiSpec (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getApiSpec(_map(12, 'CkAi_getApiSpec'))
    (objHandle, outPropVal);
end;

procedure CkAi_putApiSpec (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putApiSpec(_map(13, 'CkAi_putApiSpec'))
    (objHandle, newPropVal);
end;

function CkAi__apiSpec (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__apiSpec(_map(14, 'CkAi__apiSpec'))
    (objHandle);
end;

procedure CkAi_getBaseUrl (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getBaseUrl(_map(15, 'CkAi_getBaseUrl'))
    (objHandle, outPropVal);
end;

procedure CkAi_putBaseUrl (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putBaseUrl(_map(16, 'CkAi_putBaseUrl'))
    (objHandle, newPropVal);
end;

function CkAi__baseUrl (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__baseUrl(_map(17, 'CkAi__baseUrl'))
    (objHandle);
end;

procedure CkAi_getDebugLogFilePath (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getDebugLogFilePath(_map(18, 'CkAi_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkAi_putDebugLogFilePath (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putDebugLogFilePath(_map(19, 'CkAi_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkAi__debugLogFilePath (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__debugLogFilePath(_map(20, 'CkAi__debugLogFilePath'))
    (objHandle);
end;

function CkAi_getFullTranscript (objHandle: HCkAi): wordbool;
begin
    result := TCkAi_getFullTranscript(_map(21, 'CkAi_getFullTranscript'))
    (objHandle);
end;

procedure CkAi_putFullTranscript (objHandle: HCkAi; newPropVal: wordbool);
begin
  TCkAi_putFullTranscript(_map(22, 'CkAi_putFullTranscript'))
    (objHandle, newPropVal);
end;

function CkAi_getHeartbeatMs (objHandle: HCkAi): Integer;
begin
    result := TCkAi_getHeartbeatMs(_map(23, 'CkAi_getHeartbeatMs'))
    (objHandle);
end;

procedure CkAi_putHeartbeatMs (objHandle: HCkAi; newPropVal: Integer);
begin
  TCkAi_putHeartbeatMs(_map(24, 'CkAi_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkAi_getHostedConvo (objHandle: HCkAi): wordbool;
begin
    result := TCkAi_getHostedConvo(_map(25, 'CkAi_getHostedConvo'))
    (objHandle);
end;

procedure CkAi_putHostedConvo (objHandle: HCkAi; newPropVal: wordbool);
begin
  TCkAi_putHostedConvo(_map(26, 'CkAi_putHostedConvo'))
    (objHandle, newPropVal);
end;

function CkAi_getIdleTimeoutMs (objHandle: HCkAi): Integer;
begin
    result := TCkAi_getIdleTimeoutMs(_map(27, 'CkAi_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkAi_putIdleTimeoutMs (objHandle: HCkAi; newPropVal: Integer);
begin
  TCkAi_putIdleTimeoutMs(_map(28, 'CkAi_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkAi_getLastErrorHtml (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getLastErrorHtml(_map(29, 'CkAi_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkAi__lastErrorHtml (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__lastErrorHtml(_map(30, 'CkAi__lastErrorHtml'))
    (objHandle);
end;

procedure CkAi_getLastErrorText (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getLastErrorText(_map(31, 'CkAi_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkAi__lastErrorText (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__lastErrorText(_map(32, 'CkAi__lastErrorText'))
    (objHandle);
end;

procedure CkAi_getLastErrorXml (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getLastErrorXml(_map(33, 'CkAi_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkAi__lastErrorXml (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__lastErrorXml(_map(34, 'CkAi__lastErrorXml'))
    (objHandle);
end;

function CkAi_getLastMethodSuccess (objHandle: HCkAi): wordbool;
begin
    result := TCkAi_getLastMethodSuccess(_map(35, 'CkAi_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkAi_putLastMethodSuccess (objHandle: HCkAi; newPropVal: wordbool);
begin
  TCkAi_putLastMethodSuccess(_map(36, 'CkAi_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkAi_getModel (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getModel(_map(37, 'CkAi_getModel'))
    (objHandle, outPropVal);
end;

procedure CkAi_putModel (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putModel(_map(38, 'CkAi_putModel'))
    (objHandle, newPropVal);
end;

function CkAi__model (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__model(_map(39, 'CkAi__model'))
    (objHandle);
end;

procedure CkAi_getProvider (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getProvider(_map(40, 'CkAi_getProvider'))
    (objHandle, outPropVal);
end;

procedure CkAi_putProvider (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putProvider(_map(41, 'CkAi_putProvider'))
    (objHandle, newPropVal);
end;

function CkAi__provider (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__provider(_map(42, 'CkAi__provider'))
    (objHandle);
end;

function CkAi_getResponseStatusCode (objHandle: HCkAi): Integer;
begin
    result := TCkAi_getResponseStatusCode(_map(43, 'CkAi_getResponseStatusCode'))
    (objHandle);
end;

procedure CkAi_getSelectedConvo (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getSelectedConvo(_map(44, 'CkAi_getSelectedConvo'))
    (objHandle, outPropVal);
end;

procedure CkAi_putSelectedConvo (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putSelectedConvo(_map(45, 'CkAi_putSelectedConvo'))
    (objHandle, newPropVal);
end;

function CkAi__selectedConvo (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__selectedConvo(_map(46, 'CkAi__selectedConvo'))
    (objHandle);
end;

function CkAi_getStreaming (objHandle: HCkAi): wordbool;
begin
    result := TCkAi_getStreaming(_map(47, 'CkAi_getStreaming'))
    (objHandle);
end;

procedure CkAi_putStreaming (objHandle: HCkAi; newPropVal: wordbool);
begin
  TCkAi_putStreaming(_map(48, 'CkAi_putStreaming'))
    (objHandle, newPropVal);
end;

procedure CkAi_getUncommonOptions (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getUncommonOptions(_map(49, 'CkAi_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkAi_putUncommonOptions (objHandle: HCkAi; newPropVal: PWideChar);
begin
  TCkAi_putUncommonOptions(_map(50, 'CkAi_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkAi__uncommonOptions (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__uncommonOptions(_map(51, 'CkAi__uncommonOptions'))
    (objHandle);
end;

function CkAi_getVerboseLogging (objHandle: HCkAi): wordbool;
begin
    result := TCkAi_getVerboseLogging(_map(52, 'CkAi_getVerboseLogging'))
    (objHandle);
end;

procedure CkAi_putVerboseLogging (objHandle: HCkAi; newPropVal: wordbool);
begin
  TCkAi_putVerboseLogging(_map(53, 'CkAi_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkAi_getVersion (objHandle: HCkAi; outPropVal: HCkString);
begin
  TCkAi_getVersion(_map(54, 'CkAi_getVersion'))
    (objHandle, outPropVal);
end;

function CkAi__version (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__version(_map(55, 'CkAi__version'))
    (objHandle);
end;

function CkAi_Ask (objHandle: HCkAi; outputType: PWideChar): wordbool;
begin
  result := TCkAi_Ask(_map(56, 'CkAi_Ask'))
    (objHandle, outputType);
end;

function CkAi_AskAsync (objHandle: HCkAi; outputType: PWideChar): HCkTask;
begin
  result := TCkAi_AskAsync(_map(57, 'CkAi_AskAsync'))
    (objHandle, outputType);
end;

function CkAi_DeleteConvo (objHandle: HCkAi; name: PWideChar): wordbool;
begin
  result := TCkAi_DeleteConvo(_map(58, 'CkAi_DeleteConvo'))
    (objHandle, name);
end;

function CkAi_ExportConvo (objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool;
begin
  result := TCkAi_ExportConvo(_map(59, 'CkAi_ExportConvo'))
    (objHandle, name, json);
end;

procedure CkAi_GetLastJsonData (objHandle: HCkAi; json: HCkJsonObject);
begin
  TCkAi_GetLastJsonData(_map(60, 'CkAi_GetLastJsonData'))
    (objHandle, json);
end;

function CkAi_GetModels (objHandle: HCkAi; st: HCkStringTable): wordbool;
begin
  result := TCkAi_GetModels(_map(61, 'CkAi_GetModels'))
    (objHandle, st);
end;

function CkAi_GetModelsAsync (objHandle: HCkAi; st: HCkStringTable): HCkTask;
begin
  result := TCkAi_GetModelsAsync(_map(62, 'CkAi_GetModelsAsync'))
    (objHandle, st);
end;

function CkAi_GetOutputText (objHandle: HCkAi; outStr: HCkString): wordbool;
begin
  result := TCkAi_GetOutputText(_map(63, 'CkAi_GetOutputText'))
    (objHandle, outStr);
end;

function CkAi__getOutputText (objHandle: HCkAi): PWideChar;
begin
  result := TCkAi__getOutputText(_map(64, 'CkAi__getOutputText'))
    (objHandle);
end;

function CkAi_GetOutputTextSb (objHandle: HCkAi; sb: HCkStringBuilder): wordbool;
begin
  result := TCkAi_GetOutputTextSb(_map(65, 'CkAi_GetOutputTextSb'))
    (objHandle, sb);
end;

function CkAi_ImportConvo (objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool;
begin
  result := TCkAi_ImportConvo(_map(66, 'CkAi_ImportConvo'))
    (objHandle, name, json);
end;

function CkAi_InputAddFileData (objHandle: HCkAi; filename: PWideChar; bd: HCkBinData; summary: PWideChar): wordbool;
begin
  result := TCkAi_InputAddFileData(_map(67, 'CkAi_InputAddFileData'))
    (objHandle, filename, bd, summary);
end;

function CkAi_InputAddFileUrl (objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool;
begin
  result := TCkAi_InputAddFileUrl(_map(68, 'CkAi_InputAddFileUrl'))
    (objHandle, url, summary);
end;

function CkAi_InputAddImageData (objHandle: HCkAi; bd: HCkBinData; summary: PWideChar): wordbool;
begin
  result := TCkAi_InputAddImageData(_map(69, 'CkAi_InputAddImageData'))
    (objHandle, bd, summary);
end;

function CkAi_InputAddImageUrl (objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool;
begin
  result := TCkAi_InputAddImageUrl(_map(70, 'CkAi_InputAddImageUrl'))
    (objHandle, url, summary);
end;

function CkAi_InputAddText (objHandle: HCkAi; text: PWideChar): wordbool;
begin
  result := TCkAi_InputAddText(_map(71, 'CkAi_InputAddText'))
    (objHandle, text);
end;

function CkAi_InputAddTextSb (objHandle: HCkAi; sb: HCkStringBuilder): wordbool;
begin
  result := TCkAi_InputAddTextSb(_map(72, 'CkAi_InputAddTextSb'))
    (objHandle, sb);
end;

procedure CkAi_InputClear (objHandle: HCkAi);
begin
  TCkAi_InputClear(_map(73, 'CkAi_InputClear'))
    (objHandle);
end;

function CkAi_ListConvos (objHandle: HCkAi; st: HCkStringTable): wordbool;
begin
  result := TCkAi_ListConvos(_map(74, 'CkAi_ListConvos'))
    (objHandle, st);
end;

function CkAi_NewConvo (objHandle: HCkAi; name: PWideChar; sysMsg: PWideChar; devMsg: PWideChar): wordbool;
begin
  result := TCkAi_NewConvo(_map(75, 'CkAi_NewConvo'))
    (objHandle, name, sysMsg, devMsg);
end;

function CkAi_NextAiEvent (objHandle: HCkAi; maxWaitMs: Integer; sbName: HCkStringBuilder; sbDelta: HCkStringBuilder): wordbool;
begin
  result := TCkAi_NextAiEvent(_map(76, 'CkAi_NextAiEvent'))
    (objHandle, maxWaitMs, sbName, sbDelta);
end;

function CkAi_PollAi (objHandle: HCkAi; abort: wordbool): Integer;
begin
  result := TCkAi_PollAi(_map(77, 'CkAi_PollAi'))
    (objHandle, abort);
end;

function CkAi_SetAskParams (objHandle: HCkAi; json: HCkJsonObject): wordbool;
begin
  result := TCkAi_SetAskParams(_map(78, 'CkAi_SetAskParams'))
    (objHandle, json);
end;

function CkAi_SetConnectionSettings (objHandle: HCkAi; sock: HCkSocket): wordbool;
begin
  result := TCkAi_SetConnectionSettings(_map(79, 'CkAi_SetConnectionSettings'))
    (objHandle, sock);
end;

function CkAi_SetProviderParams (objHandle: HCkAi; json: HCkJsonObject): wordbool;
begin
  result := TCkAi_SetProviderParams(_map(80, 'CkAi_SetProviderParams'))
    (objHandle, json);
end;

procedure CkAi_SleepMs (objHandle: HCkAi; millisec: Integer);
begin
  TCkAi_SleepMs(_map(81, 'CkAi_SleepMs'))
    (objHandle, millisec);
end;

end.
