unit AuthGoogle;

interface

type

HCkJsonObject = Pointer;
HCkSocket = Pointer;
HCkString = Pointer;
HCkPfx = Pointer;
HCkAuthGoogle = Pointer;
HCkTask = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TAuthGoogleAbortCheck = function(): Integer; cdecl;
TAuthGoogleProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TAuthGooglePercentDone = function(pctDone: Integer): Integer; cdecl;
TAuthGoogleTaskCompleted = procedure(task: HCkTask); cdecl;


function CkAuthGoogle_Create: HCkAuthGoogle;  stdcall;
procedure CkAuthGoogle_Dispose(handle: HCkAuthGoogle); stdcall;

procedure CkAuthGoogle_SetAbortCheck(objHandle: HCkAuthGoogle; fn: TAuthGoogleAbortCheck) stdcall;
procedure CkAuthGoogle_SetProgressInfo(objHandle: HCkAuthGoogle; fn: TAuthGoogleProgressInfo) stdcall;
procedure CkAuthGoogle_SetPercentDone(objHandle: HCkAuthGoogle; fn: TAuthGooglePercentDone) stdcall;
procedure CkAuthGoogle_SetTaskCompleted(objHandle: HCkAuthGoogle; fn: TAuthGoogleTaskCompleted) stdcall;
procedure CkAuthGoogle_getAccessToken(objHandle: HCkAuthGoogle; outPropVal: HCkString);
procedure CkAuthGoogle_putAccessToken(objHandle: HCkAuthGoogle; newPropVal: PWideChar);
function CkAuthGoogle__accessToken(objHandle: HCkAuthGoogle): PWideChar;
procedure CkAuthGoogle_getDebugLogFilePath(objHandle: HCkAuthGoogle; outPropVal: HCkString);
procedure CkAuthGoogle_putDebugLogFilePath(objHandle: HCkAuthGoogle; newPropVal: PWideChar);
function CkAuthGoogle__debugLogFilePath(objHandle: HCkAuthGoogle): PWideChar;
procedure CkAuthGoogle_getEmailAddress(objHandle: HCkAuthGoogle; outPropVal: HCkString);
procedure CkAuthGoogle_putEmailAddress(objHandle: HCkAuthGoogle; newPropVal: PWideChar);
function CkAuthGoogle__emailAddress(objHandle: HCkAuthGoogle): PWideChar;
function CkAuthGoogle_getExpireNumSeconds(objHandle: HCkAuthGoogle): Integer;
procedure CkAuthGoogle_putExpireNumSeconds(objHandle: HCkAuthGoogle; newPropVal: Integer);
function CkAuthGoogle_getIat(objHandle: HCkAuthGoogle): Integer;
procedure CkAuthGoogle_putIat(objHandle: HCkAuthGoogle; newPropVal: Integer);
procedure CkAuthGoogle_getJsonKey(objHandle: HCkAuthGoogle; outPropVal: HCkString);
procedure CkAuthGoogle_putJsonKey(objHandle: HCkAuthGoogle; newPropVal: PWideChar);
function CkAuthGoogle__jsonKey(objHandle: HCkAuthGoogle): PWideChar;
procedure CkAuthGoogle_getLastErrorHtml(objHandle: HCkAuthGoogle; outPropVal: HCkString);
function CkAuthGoogle__lastErrorHtml(objHandle: HCkAuthGoogle): PWideChar;
procedure CkAuthGoogle_getLastErrorText(objHandle: HCkAuthGoogle; outPropVal: HCkString);
function CkAuthGoogle__lastErrorText(objHandle: HCkAuthGoogle): PWideChar;
procedure CkAuthGoogle_getLastErrorXml(objHandle: HCkAuthGoogle; outPropVal: HCkString);
function CkAuthGoogle__lastErrorXml(objHandle: HCkAuthGoogle): PWideChar;
function CkAuthGoogle_getLastMethodSuccess(objHandle: HCkAuthGoogle): wordbool;
procedure CkAuthGoogle_putLastMethodSuccess(objHandle: HCkAuthGoogle; newPropVal: wordbool);
function CkAuthGoogle_getNumSecondsRemaining(objHandle: HCkAuthGoogle): Integer;
procedure CkAuthGoogle_getScope(objHandle: HCkAuthGoogle; outPropVal: HCkString);
procedure CkAuthGoogle_putScope(objHandle: HCkAuthGoogle; newPropVal: PWideChar);
function CkAuthGoogle__scope(objHandle: HCkAuthGoogle): PWideChar;
procedure CkAuthGoogle_getSubEmailAddress(objHandle: HCkAuthGoogle; outPropVal: HCkString);
procedure CkAuthGoogle_putSubEmailAddress(objHandle: HCkAuthGoogle; newPropVal: PWideChar);
function CkAuthGoogle__subEmailAddress(objHandle: HCkAuthGoogle): PWideChar;
function CkAuthGoogle_getValid(objHandle: HCkAuthGoogle): wordbool;
function CkAuthGoogle_getVerboseLogging(objHandle: HCkAuthGoogle): wordbool;
procedure CkAuthGoogle_putVerboseLogging(objHandle: HCkAuthGoogle; newPropVal: wordbool);
procedure CkAuthGoogle_getVersion(objHandle: HCkAuthGoogle; outPropVal: HCkString);
function CkAuthGoogle__version(objHandle: HCkAuthGoogle): PWideChar;
function CkAuthGoogle_AddClaims(objHandle: HCkAuthGoogle; json: HCkJsonObject): wordbool;
function CkAuthGoogle_GetP12(objHandle: HCkAuthGoogle): HCkPfx;
function CkAuthGoogle_LoadTaskCaller(objHandle: HCkAuthGoogle; task: HCkTask): wordbool;
function CkAuthGoogle_ObtainAccessToken(objHandle: HCkAuthGoogle; connection: HCkSocket): wordbool;
function CkAuthGoogle_ObtainAccessTokenAsync(objHandle: HCkAuthGoogle; connection: HCkSocket): HCkTask;
function CkAuthGoogle_SetP12(objHandle: HCkAuthGoogle; key: HCkPfx): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkAuthGoogle_Create = function : HCkAuthGoogle; stdcall;
  TCkAuthGoogle_Dispose = procedure (handle: HCkAuthGoogle); stdcall;
  TCkAuthGoogle_SetAbortCheck = procedure (objHandle: HCkAuthGoogle; fn: TAuthGoogleAbortCheck); stdcall;
  TCkAuthGoogle_SetProgressInfo = procedure (objHandle: HCkAuthGoogle; fn: TAuthGoogleProgressInfo); stdcall;
  TCkAuthGoogle_SetPercentDone = procedure (objHandle: HCkAuthGoogle; fn: TAuthGooglePercentDone); stdcall;
  TCkAuthGoogle_SetTaskCompleted = procedure (objHandle: HCkAuthGoogle; fn: TAuthGoogleTaskCompleted); stdcall;
  TCkAuthGoogle_getAccessToken = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle_putAccessToken = procedure (objHandle: HCkAuthGoogle; newPropVal: PWideChar); stdcall;
  TCkAuthGoogle__accessToken = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getDebugLogFilePath = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle_putDebugLogFilePath = procedure (objHandle: HCkAuthGoogle; newPropVal: PWideChar); stdcall;
  TCkAuthGoogle__debugLogFilePath = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getEmailAddress = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle_putEmailAddress = procedure (objHandle: HCkAuthGoogle; newPropVal: PWideChar); stdcall;
  TCkAuthGoogle__emailAddress = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getExpireNumSeconds = function (objHandle: HCkAuthGoogle): Integer; stdcall;
  TCkAuthGoogle_putExpireNumSeconds = procedure (objHandle: HCkAuthGoogle; newPropVal: Integer); stdcall;
  TCkAuthGoogle_getIat = function (objHandle: HCkAuthGoogle): Integer; stdcall;
  TCkAuthGoogle_putIat = procedure (objHandle: HCkAuthGoogle; newPropVal: Integer); stdcall;
  TCkAuthGoogle_getJsonKey = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle_putJsonKey = procedure (objHandle: HCkAuthGoogle; newPropVal: PWideChar); stdcall;
  TCkAuthGoogle__jsonKey = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getLastErrorHtml = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle__lastErrorHtml = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getLastErrorText = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle__lastErrorText = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getLastErrorXml = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle__lastErrorXml = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getLastMethodSuccess = function (objHandle: HCkAuthGoogle): wordbool; stdcall;
  TCkAuthGoogle_putLastMethodSuccess = procedure (objHandle: HCkAuthGoogle; newPropVal: wordbool); stdcall;
  TCkAuthGoogle_getNumSecondsRemaining = function (objHandle: HCkAuthGoogle): Integer; stdcall;
  TCkAuthGoogle_getScope = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle_putScope = procedure (objHandle: HCkAuthGoogle; newPropVal: PWideChar); stdcall;
  TCkAuthGoogle__scope = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getSubEmailAddress = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle_putSubEmailAddress = procedure (objHandle: HCkAuthGoogle; newPropVal: PWideChar); stdcall;
  TCkAuthGoogle__subEmailAddress = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_getValid = function (objHandle: HCkAuthGoogle): wordbool; stdcall;
  TCkAuthGoogle_getVerboseLogging = function (objHandle: HCkAuthGoogle): wordbool; stdcall;
  TCkAuthGoogle_putVerboseLogging = procedure (objHandle: HCkAuthGoogle; newPropVal: wordbool); stdcall;
  TCkAuthGoogle_getVersion = procedure (objHandle: HCkAuthGoogle; outPropVal: HCkString); stdcall;
  TCkAuthGoogle__version = function (objHandle: HCkAuthGoogle): PWideChar; stdcall;
  TCkAuthGoogle_AddClaims = function (objHandle: HCkAuthGoogle; json: HCkJsonObject): wordbool; stdcall;
  TCkAuthGoogle_GetP12 = function (objHandle: HCkAuthGoogle): HCkPfx; stdcall;
  TCkAuthGoogle_LoadTaskCaller = function (objHandle: HCkAuthGoogle; task: HCkTask): wordbool; stdcall;
  TCkAuthGoogle_ObtainAccessToken = function (objHandle: HCkAuthGoogle; connection: HCkSocket): wordbool; stdcall;
  TCkAuthGoogle_ObtainAccessTokenAsync = function (objHandle: HCkAuthGoogle; connection: HCkSocket): HCkTask; stdcall;
  TCkAuthGoogle_SetP12 = function (objHandle: HCkAuthGoogle; key: HCkPfx): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..47] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkAuthGoogle_Create : HCkAuthGoogle;
begin
  result := TCkAuthGoogle_Create(_map(0, 'CkAuthGoogle_Create'));
end;

procedure CkAuthGoogle_Dispose (handle: HCkAuthGoogle);
begin
  TCkAuthGoogle_Dispose(_map(1, 'CkAuthGoogle_Dispose'))
    (handle);
end;


procedure CkAuthGoogle_SetAbortCheck (objHandle: HCkAuthGoogle; fn: TAuthGoogleAbortCheck);
begin
    TCkAuthGoogle_SetAbortCheck(_map(2, 'CkAuthGoogle_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkAuthGoogle_SetProgressInfo (objHandle: HCkAuthGoogle; fn: TAuthGoogleProgressInfo);
begin
    TCkAuthGoogle_SetProgressInfo(_map(3, 'CkAuthGoogle_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkAuthGoogle_SetPercentDone (objHandle: HCkAuthGoogle; fn: TAuthGooglePercentDone);
begin
    TCkAuthGoogle_SetPercentDone(_map(4, 'CkAuthGoogle_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkAuthGoogle_SetTaskCompleted (objHandle: HCkAuthGoogle; fn: TAuthGoogleTaskCompleted);
begin
    TCkAuthGoogle_SetTaskCompleted(_map(5, 'CkAuthGoogle_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkAuthGoogle_getAccessToken (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getAccessToken(_map(6, 'CkAuthGoogle_getAccessToken'))
    (objHandle, outPropVal);
end;

procedure CkAuthGoogle_putAccessToken (objHandle: HCkAuthGoogle; newPropVal: PWideChar);
begin
  TCkAuthGoogle_putAccessToken(_map(7, 'CkAuthGoogle_putAccessToken'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle__accessToken (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__accessToken(_map(8, 'CkAuthGoogle__accessToken'))
    (objHandle);
end;

procedure CkAuthGoogle_getDebugLogFilePath (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getDebugLogFilePath(_map(9, 'CkAuthGoogle_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkAuthGoogle_putDebugLogFilePath (objHandle: HCkAuthGoogle; newPropVal: PWideChar);
begin
  TCkAuthGoogle_putDebugLogFilePath(_map(10, 'CkAuthGoogle_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle__debugLogFilePath (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__debugLogFilePath(_map(11, 'CkAuthGoogle__debugLogFilePath'))
    (objHandle);
end;

procedure CkAuthGoogle_getEmailAddress (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getEmailAddress(_map(12, 'CkAuthGoogle_getEmailAddress'))
    (objHandle, outPropVal);
end;

procedure CkAuthGoogle_putEmailAddress (objHandle: HCkAuthGoogle; newPropVal: PWideChar);
begin
  TCkAuthGoogle_putEmailAddress(_map(13, 'CkAuthGoogle_putEmailAddress'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle__emailAddress (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__emailAddress(_map(14, 'CkAuthGoogle__emailAddress'))
    (objHandle);
end;

function CkAuthGoogle_getExpireNumSeconds (objHandle: HCkAuthGoogle): Integer;
begin
    result := TCkAuthGoogle_getExpireNumSeconds(_map(15, 'CkAuthGoogle_getExpireNumSeconds'))
    (objHandle);
end;

procedure CkAuthGoogle_putExpireNumSeconds (objHandle: HCkAuthGoogle; newPropVal: Integer);
begin
  TCkAuthGoogle_putExpireNumSeconds(_map(16, 'CkAuthGoogle_putExpireNumSeconds'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle_getIat (objHandle: HCkAuthGoogle): Integer;
begin
    result := TCkAuthGoogle_getIat(_map(17, 'CkAuthGoogle_getIat'))
    (objHandle);
end;

procedure CkAuthGoogle_putIat (objHandle: HCkAuthGoogle; newPropVal: Integer);
begin
  TCkAuthGoogle_putIat(_map(18, 'CkAuthGoogle_putIat'))
    (objHandle, newPropVal);
end;

procedure CkAuthGoogle_getJsonKey (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getJsonKey(_map(19, 'CkAuthGoogle_getJsonKey'))
    (objHandle, outPropVal);
end;

procedure CkAuthGoogle_putJsonKey (objHandle: HCkAuthGoogle; newPropVal: PWideChar);
begin
  TCkAuthGoogle_putJsonKey(_map(20, 'CkAuthGoogle_putJsonKey'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle__jsonKey (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__jsonKey(_map(21, 'CkAuthGoogle__jsonKey'))
    (objHandle);
end;

procedure CkAuthGoogle_getLastErrorHtml (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getLastErrorHtml(_map(22, 'CkAuthGoogle_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkAuthGoogle__lastErrorHtml (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__lastErrorHtml(_map(23, 'CkAuthGoogle__lastErrorHtml'))
    (objHandle);
end;

procedure CkAuthGoogle_getLastErrorText (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getLastErrorText(_map(24, 'CkAuthGoogle_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkAuthGoogle__lastErrorText (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__lastErrorText(_map(25, 'CkAuthGoogle__lastErrorText'))
    (objHandle);
end;

procedure CkAuthGoogle_getLastErrorXml (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getLastErrorXml(_map(26, 'CkAuthGoogle_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkAuthGoogle__lastErrorXml (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__lastErrorXml(_map(27, 'CkAuthGoogle__lastErrorXml'))
    (objHandle);
end;

function CkAuthGoogle_getLastMethodSuccess (objHandle: HCkAuthGoogle): wordbool;
begin
    result := TCkAuthGoogle_getLastMethodSuccess(_map(28, 'CkAuthGoogle_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkAuthGoogle_putLastMethodSuccess (objHandle: HCkAuthGoogle; newPropVal: wordbool);
begin
  TCkAuthGoogle_putLastMethodSuccess(_map(29, 'CkAuthGoogle_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle_getNumSecondsRemaining (objHandle: HCkAuthGoogle): Integer;
begin
    result := TCkAuthGoogle_getNumSecondsRemaining(_map(30, 'CkAuthGoogle_getNumSecondsRemaining'))
    (objHandle);
end;

procedure CkAuthGoogle_getScope (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getScope(_map(31, 'CkAuthGoogle_getScope'))
    (objHandle, outPropVal);
end;

procedure CkAuthGoogle_putScope (objHandle: HCkAuthGoogle; newPropVal: PWideChar);
begin
  TCkAuthGoogle_putScope(_map(32, 'CkAuthGoogle_putScope'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle__scope (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__scope(_map(33, 'CkAuthGoogle__scope'))
    (objHandle);
end;

procedure CkAuthGoogle_getSubEmailAddress (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getSubEmailAddress(_map(34, 'CkAuthGoogle_getSubEmailAddress'))
    (objHandle, outPropVal);
end;

procedure CkAuthGoogle_putSubEmailAddress (objHandle: HCkAuthGoogle; newPropVal: PWideChar);
begin
  TCkAuthGoogle_putSubEmailAddress(_map(35, 'CkAuthGoogle_putSubEmailAddress'))
    (objHandle, newPropVal);
end;

function CkAuthGoogle__subEmailAddress (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__subEmailAddress(_map(36, 'CkAuthGoogle__subEmailAddress'))
    (objHandle);
end;

function CkAuthGoogle_getValid (objHandle: HCkAuthGoogle): wordbool;
begin
    result := TCkAuthGoogle_getValid(_map(37, 'CkAuthGoogle_getValid'))
    (objHandle);
end;

function CkAuthGoogle_getVerboseLogging (objHandle: HCkAuthGoogle): wordbool;
begin
    result := TCkAuthGoogle_getVerboseLogging(_map(38, 'CkAuthGoogle_getVerboseLogging'))
    (objHandle);
end;

procedure CkAuthGoogle_putVerboseLogging (objHandle: HCkAuthGoogle; newPropVal: wordbool);
begin
  TCkAuthGoogle_putVerboseLogging(_map(39, 'CkAuthGoogle_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkAuthGoogle_getVersion (objHandle: HCkAuthGoogle; outPropVal: HCkString);
begin
  TCkAuthGoogle_getVersion(_map(40, 'CkAuthGoogle_getVersion'))
    (objHandle, outPropVal);
end;

function CkAuthGoogle__version (objHandle: HCkAuthGoogle): PWideChar;
begin
  result := TCkAuthGoogle__version(_map(41, 'CkAuthGoogle__version'))
    (objHandle);
end;

function CkAuthGoogle_AddClaims (objHandle: HCkAuthGoogle; json: HCkJsonObject): wordbool;
begin
  result := TCkAuthGoogle_AddClaims(_map(42, 'CkAuthGoogle_AddClaims'))
    (objHandle, json);
end;

function CkAuthGoogle_GetP12 (objHandle: HCkAuthGoogle): HCkPfx;
begin
  result := TCkAuthGoogle_GetP12(_map(43, 'CkAuthGoogle_GetP12'))
    (objHandle);
end;

function CkAuthGoogle_LoadTaskCaller (objHandle: HCkAuthGoogle; task: HCkTask): wordbool;
begin
  result := TCkAuthGoogle_LoadTaskCaller(_map(44, 'CkAuthGoogle_LoadTaskCaller'))
    (objHandle, task);
end;

function CkAuthGoogle_ObtainAccessToken (objHandle: HCkAuthGoogle; connection: HCkSocket): wordbool;
begin
  result := TCkAuthGoogle_ObtainAccessToken(_map(45, 'CkAuthGoogle_ObtainAccessToken'))
    (objHandle, connection);
end;

function CkAuthGoogle_ObtainAccessTokenAsync (objHandle: HCkAuthGoogle; connection: HCkSocket): HCkTask;
begin
  result := TCkAuthGoogle_ObtainAccessTokenAsync(_map(46, 'CkAuthGoogle_ObtainAccessTokenAsync'))
    (objHandle, connection);
end;

function CkAuthGoogle_SetP12 (objHandle: HCkAuthGoogle; key: HCkPfx): wordbool;
begin
  result := TCkAuthGoogle_SetP12(_map(47, 'CkAuthGoogle_SetP12'))
    (objHandle, key);
end;

end.
