unit BinData;

interface

type

HCkBinData = Pointer;
HCkStringBuilder = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


function CkBinData_Create: HCkBinData;  stdcall;
procedure CkBinData_Dispose(handle: HCkBinData); stdcall;
procedure CkBinData_getDebugLogFilePath(objHandle: HCkBinData; outPropVal: HCkString);
procedure CkBinData_putDebugLogFilePath(objHandle: HCkBinData; newPropVal: PWideChar);
function CkBinData__debugLogFilePath(objHandle: HCkBinData): PWideChar;
procedure CkBinData_getLastErrorHtml(objHandle: HCkBinData; outPropVal: HCkString);
function CkBinData__lastErrorHtml(objHandle: HCkBinData): PWideChar;
procedure CkBinData_getLastErrorText(objHandle: HCkBinData; outPropVal: HCkString);
function CkBinData__lastErrorText(objHandle: HCkBinData): PWideChar;
procedure CkBinData_getLastErrorXml(objHandle: HCkBinData; outPropVal: HCkString);
function CkBinData__lastErrorXml(objHandle: HCkBinData): PWideChar;
function CkBinData_getLastMethodSuccess(objHandle: HCkBinData): wordbool;
procedure CkBinData_putLastMethodSuccess(objHandle: HCkBinData; newPropVal: wordbool);
function CkBinData_getNumBytes(objHandle: HCkBinData): Integer;
function CkBinData_getVerboseLogging(objHandle: HCkBinData): wordbool;
procedure CkBinData_putVerboseLogging(objHandle: HCkBinData; newPropVal: wordbool);
procedure CkBinData_getVersion(objHandle: HCkBinData; outPropVal: HCkString);
function CkBinData__version(objHandle: HCkBinData): PWideChar;
function CkBinData_AppendBd(objHandle: HCkBinData; binData: HCkBinData): wordbool;
function CkBinData_AppendBinary(objHandle: HCkBinData; data: HCkByteData): wordbool;
function CkBinData_AppendBom(objHandle: HCkBinData; charset: PWideChar): wordbool;
function CkBinData_AppendByte(objHandle: HCkBinData; byteValue: Integer): wordbool;
function CkBinData_AppendCountedString(objHandle: HCkBinData; numCountBytes: Integer; bigEndian: wordbool; str: PWideChar; charset: PWideChar): wordbool;
function CkBinData_AppendData(objHandle: HCkBinData; data: pbyte; numBytes: Integer): wordbool;
function CkBinData_AppendEncoded(objHandle: HCkBinData; encData: PWideChar; encoding: PWideChar): wordbool;
function CkBinData_AppendEncodedSb(objHandle: HCkBinData; sb: HCkStringBuilder; encoding: PWideChar): wordbool;
function CkBinData_AppendInt2(objHandle: HCkBinData; value: Integer; littleEndian: wordbool): wordbool;
function CkBinData_AppendInt4(objHandle: HCkBinData; value: Integer; littleEndian: wordbool): wordbool;
function CkBinData_AppendPadded(objHandle: HCkBinData; str: PWideChar; charset: PWideChar; padWithSpace: wordbool; fieldLen: Integer): wordbool;
function CkBinData_AppendSb(objHandle: HCkBinData; sb: HCkStringBuilder; charset: PWideChar): wordbool;
function CkBinData_AppendString(objHandle: HCkBinData; str: PWideChar; charset: PWideChar): wordbool;
procedure CkBinData_ByteSwap(objHandle: HCkBinData; size: Integer);
function CkBinData_CharsetConvert(objHandle: HCkBinData; fromCharset: PWideChar; toCharset: PWideChar; allOrNone: wordbool): wordbool;
function CkBinData_Clear(objHandle: HCkBinData): wordbool;
function CkBinData_ContentsEqual(objHandle: HCkBinData; binData: HCkBinData): wordbool;
function CkBinData_FindString(objHandle: HCkBinData; str: PWideChar; startIdx: Integer; charset: PWideChar): Integer;
function CkBinData_GetBinary(objHandle: HCkBinData; outData: HCkByteData): wordbool;
function CkBinData_GetBinaryChunk(objHandle: HCkBinData; offset: Integer; numBytes: Integer; outData: HCkByteData): wordbool;
function CkBinData_GetByte(objHandle: HCkBinData; index: Integer): Integer;
function CkBinData_GetData(objHandle: HCkBinData): pbyte;
function CkBinData_GetDataChunk(objHandle: HCkBinData; offset: Integer; numBytes: Integer): pbyte;
function CkBinData_GetEncoded(objHandle: HCkBinData; encoding: PWideChar; outStr: HCkString): wordbool;
function CkBinData__getEncoded(objHandle: HCkBinData; encoding: PWideChar): PWideChar;
function CkBinData_GetEncodedChunk(objHandle: HCkBinData; offset: Integer; numBytes: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
function CkBinData__getEncodedChunk(objHandle: HCkBinData; offset: Integer; numBytes: Integer; encoding: PWideChar): PWideChar;
function CkBinData_GetEncodedSb(objHandle: HCkBinData; encoding: PWideChar; sb: HCkStringBuilder): wordbool;
function CkBinData_GetHash(objHandle: HCkBinData; algorithm: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkBinData__getHash(objHandle: HCkBinData; algorithm: PWideChar; encoding: PWideChar): PWideChar;
function CkBinData_GetInt2(objHandle: HCkBinData; index: Integer; littleEndian: wordbool): Integer;
function CkBinData_GetInt4(objHandle: HCkBinData; index: Integer; littleEndian: wordbool): Integer;
function CkBinData_GetString(objHandle: HCkBinData; charset: PWideChar; outStr: HCkString): wordbool;
function CkBinData__getString(objHandle: HCkBinData; charset: PWideChar): PWideChar;
function CkBinData_GetTextChunk(objHandle: HCkBinData; startIdx: Integer; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkBinData__getTextChunk(objHandle: HCkBinData; startIdx: Integer; numBytes: Integer; charset: PWideChar): PWideChar;
function CkBinData_GetUInt2(objHandle: HCkBinData; index: Integer; littleEndian: wordbool): LongWord;
function CkBinData_GetUInt4(objHandle: HCkBinData; index: Integer; littleEndian: wordbool): LongWord;
function CkBinData_IsValidUtf8(objHandle: HCkBinData): wordbool;
function CkBinData_LoadBinary(objHandle: HCkBinData; data: HCkByteData): wordbool;
function CkBinData_LoadEncoded(objHandle: HCkBinData; encData: PWideChar; encoding: PWideChar): wordbool;
function CkBinData_LoadFile(objHandle: HCkBinData; path: PWideChar): wordbool;
procedure CkBinData_RemoveByteVal(objHandle: HCkBinData; value: Integer);
function CkBinData_RemoveChunk(objHandle: HCkBinData; offset: Integer; numBytes: Integer): wordbool;
function CkBinData_SecureClear(objHandle: HCkBinData): wordbool;
function CkBinData_WriteAppendFile(objHandle: HCkBinData; path: PWideChar): wordbool;
function CkBinData_WriteFile(objHandle: HCkBinData; path: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkBinData_Create = function : HCkBinData; stdcall;
  TCkBinData_Dispose = procedure (handle: HCkBinData); stdcall;
  TCkBinData_getDebugLogFilePath = procedure (objHandle: HCkBinData; outPropVal: HCkString); stdcall;
  TCkBinData_putDebugLogFilePath = procedure (objHandle: HCkBinData; newPropVal: PWideChar); stdcall;
  TCkBinData__debugLogFilePath = function (objHandle: HCkBinData): PWideChar; stdcall;
  TCkBinData_getLastErrorHtml = procedure (objHandle: HCkBinData; outPropVal: HCkString); stdcall;
  TCkBinData__lastErrorHtml = function (objHandle: HCkBinData): PWideChar; stdcall;
  TCkBinData_getLastErrorText = procedure (objHandle: HCkBinData; outPropVal: HCkString); stdcall;
  TCkBinData__lastErrorText = function (objHandle: HCkBinData): PWideChar; stdcall;
  TCkBinData_getLastErrorXml = procedure (objHandle: HCkBinData; outPropVal: HCkString); stdcall;
  TCkBinData__lastErrorXml = function (objHandle: HCkBinData): PWideChar; stdcall;
  TCkBinData_getLastMethodSuccess = function (objHandle: HCkBinData): wordbool; stdcall;
  TCkBinData_putLastMethodSuccess = procedure (objHandle: HCkBinData; newPropVal: wordbool); stdcall;
  TCkBinData_getNumBytes = function (objHandle: HCkBinData): Integer; stdcall;
  TCkBinData_getVerboseLogging = function (objHandle: HCkBinData): wordbool; stdcall;
  TCkBinData_putVerboseLogging = procedure (objHandle: HCkBinData; newPropVal: wordbool); stdcall;
  TCkBinData_getVersion = procedure (objHandle: HCkBinData; outPropVal: HCkString); stdcall;
  TCkBinData__version = function (objHandle: HCkBinData): PWideChar; stdcall;
  TCkBinData_AppendBd = function (objHandle: HCkBinData; binData: HCkBinData): wordbool; stdcall;
  TCkBinData_AppendBinary = function (objHandle: HCkBinData; data: HCkByteData): wordbool; stdcall;
  TCkBinData_AppendBom = function (objHandle: HCkBinData; charset: PWideChar): wordbool; stdcall;
  TCkBinData_AppendByte = function (objHandle: HCkBinData; byteValue: Integer): wordbool; stdcall;
  TCkBinData_AppendCountedString = function (objHandle: HCkBinData; numCountBytes: Integer; bigEndian: wordbool; str: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkBinData_AppendData = function (objHandle: HCkBinData; data: pbyte; numBytes: Integer): wordbool; stdcall;
  TCkBinData_AppendEncoded = function (objHandle: HCkBinData; encData: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkBinData_AppendEncodedSb = function (objHandle: HCkBinData; sb: HCkStringBuilder; encoding: PWideChar): wordbool; stdcall;
  TCkBinData_AppendInt2 = function (objHandle: HCkBinData; value: Integer; littleEndian: wordbool): wordbool; stdcall;
  TCkBinData_AppendInt4 = function (objHandle: HCkBinData; value: Integer; littleEndian: wordbool): wordbool; stdcall;
  TCkBinData_AppendPadded = function (objHandle: HCkBinData; str: PWideChar; charset: PWideChar; padWithSpace: wordbool; fieldLen: Integer): wordbool; stdcall;
  TCkBinData_AppendSb = function (objHandle: HCkBinData; sb: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkBinData_AppendString = function (objHandle: HCkBinData; str: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkBinData_ByteSwap = procedure (objHandle: HCkBinData; size: Integer); stdcall;
  TCkBinData_CharsetConvert = function (objHandle: HCkBinData; fromCharset: PWideChar; toCharset: PWideChar; allOrNone: wordbool): wordbool; stdcall;
  TCkBinData_Clear = function (objHandle: HCkBinData): wordbool; stdcall;
  TCkBinData_ContentsEqual = function (objHandle: HCkBinData; binData: HCkBinData): wordbool; stdcall;
  TCkBinData_FindString = function (objHandle: HCkBinData; str: PWideChar; startIdx: Integer; charset: PWideChar): Integer; stdcall;
  TCkBinData_GetBinary = function (objHandle: HCkBinData; outData: HCkByteData): wordbool; stdcall;
  TCkBinData_GetBinaryChunk = function (objHandle: HCkBinData; offset: Integer; numBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkBinData_GetByte = function (objHandle: HCkBinData; index: Integer): Integer; stdcall;
  TCkBinData_GetData = function (objHandle: HCkBinData): pbyte; stdcall;
  TCkBinData_GetDataChunk = function (objHandle: HCkBinData; offset: Integer; numBytes: Integer): pbyte; stdcall;
  TCkBinData_GetEncoded = function (objHandle: HCkBinData; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkBinData__getEncoded = function (objHandle: HCkBinData; encoding: PWideChar): PWideChar; stdcall;
  TCkBinData_GetEncodedChunk = function (objHandle: HCkBinData; offset: Integer; numBytes: Integer; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkBinData__getEncodedChunk = function (objHandle: HCkBinData; offset: Integer; numBytes: Integer; encoding: PWideChar): PWideChar; stdcall;
  TCkBinData_GetEncodedSb = function (objHandle: HCkBinData; encoding: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkBinData_GetHash = function (objHandle: HCkBinData; algorithm: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkBinData__getHash = function (objHandle: HCkBinData; algorithm: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkBinData_GetInt2 = function (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): Integer; stdcall;
  TCkBinData_GetInt4 = function (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): Integer; stdcall;
  TCkBinData_GetString = function (objHandle: HCkBinData; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkBinData__getString = function (objHandle: HCkBinData; charset: PWideChar): PWideChar; stdcall;
  TCkBinData_GetTextChunk = function (objHandle: HCkBinData; startIdx: Integer; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkBinData__getTextChunk = function (objHandle: HCkBinData; startIdx: Integer; numBytes: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkBinData_GetUInt2 = function (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): LongWord; stdcall;
  TCkBinData_GetUInt4 = function (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): LongWord; stdcall;
  TCkBinData_IsValidUtf8 = function (objHandle: HCkBinData): wordbool; stdcall;
  TCkBinData_LoadBinary = function (objHandle: HCkBinData; data: HCkByteData): wordbool; stdcall;
  TCkBinData_LoadEncoded = function (objHandle: HCkBinData; encData: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkBinData_LoadFile = function (objHandle: HCkBinData; path: PWideChar): wordbool; stdcall;
  TCkBinData_RemoveByteVal = procedure (objHandle: HCkBinData; value: Integer); stdcall;
  TCkBinData_RemoveChunk = function (objHandle: HCkBinData; offset: Integer; numBytes: Integer): wordbool; stdcall;
  TCkBinData_SecureClear = function (objHandle: HCkBinData): wordbool; stdcall;
  TCkBinData_WriteAppendFile = function (objHandle: HCkBinData; path: PWideChar): wordbool; stdcall;
  TCkBinData_WriteFile = function (objHandle: HCkBinData; path: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..64] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkBinData_Create : HCkBinData;
begin
  result := TCkBinData_Create(_map(0, 'CkBinData_Create'));
end;

procedure CkBinData_Dispose (handle: HCkBinData);
begin
  TCkBinData_Dispose(_map(1, 'CkBinData_Dispose'))
    (handle);
end;


procedure CkBinData_getDebugLogFilePath (objHandle: HCkBinData; outPropVal: HCkString);
begin
  TCkBinData_getDebugLogFilePath(_map(2, 'CkBinData_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkBinData_putDebugLogFilePath (objHandle: HCkBinData; newPropVal: PWideChar);
begin
  TCkBinData_putDebugLogFilePath(_map(3, 'CkBinData_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkBinData__debugLogFilePath (objHandle: HCkBinData): PWideChar;
begin
  result := TCkBinData__debugLogFilePath(_map(4, 'CkBinData__debugLogFilePath'))
    (objHandle);
end;

procedure CkBinData_getLastErrorHtml (objHandle: HCkBinData; outPropVal: HCkString);
begin
  TCkBinData_getLastErrorHtml(_map(5, 'CkBinData_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkBinData__lastErrorHtml (objHandle: HCkBinData): PWideChar;
begin
  result := TCkBinData__lastErrorHtml(_map(6, 'CkBinData__lastErrorHtml'))
    (objHandle);
end;

procedure CkBinData_getLastErrorText (objHandle: HCkBinData; outPropVal: HCkString);
begin
  TCkBinData_getLastErrorText(_map(7, 'CkBinData_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkBinData__lastErrorText (objHandle: HCkBinData): PWideChar;
begin
  result := TCkBinData__lastErrorText(_map(8, 'CkBinData__lastErrorText'))
    (objHandle);
end;

procedure CkBinData_getLastErrorXml (objHandle: HCkBinData; outPropVal: HCkString);
begin
  TCkBinData_getLastErrorXml(_map(9, 'CkBinData_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkBinData__lastErrorXml (objHandle: HCkBinData): PWideChar;
begin
  result := TCkBinData__lastErrorXml(_map(10, 'CkBinData__lastErrorXml'))
    (objHandle);
end;

function CkBinData_getLastMethodSuccess (objHandle: HCkBinData): wordbool;
begin
    result := TCkBinData_getLastMethodSuccess(_map(11, 'CkBinData_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkBinData_putLastMethodSuccess (objHandle: HCkBinData; newPropVal: wordbool);
begin
  TCkBinData_putLastMethodSuccess(_map(12, 'CkBinData_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkBinData_getNumBytes (objHandle: HCkBinData): Integer;
begin
    result := TCkBinData_getNumBytes(_map(13, 'CkBinData_getNumBytes'))
    (objHandle);
end;

function CkBinData_getVerboseLogging (objHandle: HCkBinData): wordbool;
begin
    result := TCkBinData_getVerboseLogging(_map(14, 'CkBinData_getVerboseLogging'))
    (objHandle);
end;

procedure CkBinData_putVerboseLogging (objHandle: HCkBinData; newPropVal: wordbool);
begin
  TCkBinData_putVerboseLogging(_map(15, 'CkBinData_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkBinData_getVersion (objHandle: HCkBinData; outPropVal: HCkString);
begin
  TCkBinData_getVersion(_map(16, 'CkBinData_getVersion'))
    (objHandle, outPropVal);
end;

function CkBinData__version (objHandle: HCkBinData): PWideChar;
begin
  result := TCkBinData__version(_map(17, 'CkBinData__version'))
    (objHandle);
end;

function CkBinData_AppendBd (objHandle: HCkBinData; binData: HCkBinData): wordbool;
begin
  result := TCkBinData_AppendBd(_map(18, 'CkBinData_AppendBd'))
    (objHandle, binData);
end;

function CkBinData_AppendBinary (objHandle: HCkBinData; data: HCkByteData): wordbool;
begin
  result := TCkBinData_AppendBinary(_map(19, 'CkBinData_AppendBinary'))
    (objHandle, data);
end;

function CkBinData_AppendBom (objHandle: HCkBinData; charset: PWideChar): wordbool;
begin
  result := TCkBinData_AppendBom(_map(20, 'CkBinData_AppendBom'))
    (objHandle, charset);
end;

function CkBinData_AppendByte (objHandle: HCkBinData; byteValue: Integer): wordbool;
begin
  result := TCkBinData_AppendByte(_map(21, 'CkBinData_AppendByte'))
    (objHandle, byteValue);
end;

function CkBinData_AppendCountedString (objHandle: HCkBinData; numCountBytes: Integer; bigEndian: wordbool; str: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkBinData_AppendCountedString(_map(22, 'CkBinData_AppendCountedString'))
    (objHandle, numCountBytes, bigEndian, str, charset);
end;

function CkBinData_AppendData (objHandle: HCkBinData; data: pbyte; numBytes: Integer): wordbool;
begin
  result := TCkBinData_AppendData(_map(23, 'CkBinData_AppendData'))
    (objHandle, data, numBytes);
end;

function CkBinData_AppendEncoded (objHandle: HCkBinData; encData: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkBinData_AppendEncoded(_map(24, 'CkBinData_AppendEncoded'))
    (objHandle, encData, encoding);
end;

function CkBinData_AppendEncodedSb (objHandle: HCkBinData; sb: HCkStringBuilder; encoding: PWideChar): wordbool;
begin
  result := TCkBinData_AppendEncodedSb(_map(25, 'CkBinData_AppendEncodedSb'))
    (objHandle, sb, encoding);
end;

function CkBinData_AppendInt2 (objHandle: HCkBinData; value: Integer; littleEndian: wordbool): wordbool;
begin
  result := TCkBinData_AppendInt2(_map(26, 'CkBinData_AppendInt2'))
    (objHandle, value, littleEndian);
end;

function CkBinData_AppendInt4 (objHandle: HCkBinData; value: Integer; littleEndian: wordbool): wordbool;
begin
  result := TCkBinData_AppendInt4(_map(27, 'CkBinData_AppendInt4'))
    (objHandle, value, littleEndian);
end;

function CkBinData_AppendPadded (objHandle: HCkBinData; str: PWideChar; charset: PWideChar; padWithSpace: wordbool; fieldLen: Integer): wordbool;
begin
  result := TCkBinData_AppendPadded(_map(28, 'CkBinData_AppendPadded'))
    (objHandle, str, charset, padWithSpace, fieldLen);
end;

function CkBinData_AppendSb (objHandle: HCkBinData; sb: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkBinData_AppendSb(_map(29, 'CkBinData_AppendSb'))
    (objHandle, sb, charset);
end;

function CkBinData_AppendString (objHandle: HCkBinData; str: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkBinData_AppendString(_map(30, 'CkBinData_AppendString'))
    (objHandle, str, charset);
end;

procedure CkBinData_ByteSwap (objHandle: HCkBinData; size: Integer);
begin
  TCkBinData_ByteSwap(_map(31, 'CkBinData_ByteSwap'))
    (objHandle, size);
end;

function CkBinData_CharsetConvert (objHandle: HCkBinData; fromCharset: PWideChar; toCharset: PWideChar; allOrNone: wordbool): wordbool;
begin
  result := TCkBinData_CharsetConvert(_map(32, 'CkBinData_CharsetConvert'))
    (objHandle, fromCharset, toCharset, allOrNone);
end;

function CkBinData_Clear (objHandle: HCkBinData): wordbool;
begin
  result := TCkBinData_Clear(_map(33, 'CkBinData_Clear'))
    (objHandle);
end;

function CkBinData_ContentsEqual (objHandle: HCkBinData; binData: HCkBinData): wordbool;
begin
  result := TCkBinData_ContentsEqual(_map(34, 'CkBinData_ContentsEqual'))
    (objHandle, binData);
end;

function CkBinData_FindString (objHandle: HCkBinData; str: PWideChar; startIdx: Integer; charset: PWideChar): Integer;
begin
  result := TCkBinData_FindString(_map(35, 'CkBinData_FindString'))
    (objHandle, str, startIdx, charset);
end;

function CkBinData_GetBinary (objHandle: HCkBinData; outData: HCkByteData): wordbool;
begin
  result := TCkBinData_GetBinary(_map(36, 'CkBinData_GetBinary'))
    (objHandle, outData);
end;

function CkBinData_GetBinaryChunk (objHandle: HCkBinData; offset: Integer; numBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkBinData_GetBinaryChunk(_map(37, 'CkBinData_GetBinaryChunk'))
    (objHandle, offset, numBytes, outData);
end;

function CkBinData_GetByte (objHandle: HCkBinData; index: Integer): Integer;
begin
  result := TCkBinData_GetByte(_map(38, 'CkBinData_GetByte'))
    (objHandle, index);
end;

function CkBinData_GetData (objHandle: HCkBinData): pbyte;
begin
  result := TCkBinData_GetData(_map(39, 'CkBinData_GetData'))
    (objHandle);
end;

function CkBinData_GetDataChunk (objHandle: HCkBinData; offset: Integer; numBytes: Integer): pbyte;
begin
  result := TCkBinData_GetDataChunk(_map(40, 'CkBinData_GetDataChunk'))
    (objHandle, offset, numBytes);
end;

function CkBinData_GetEncoded (objHandle: HCkBinData; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkBinData_GetEncoded(_map(41, 'CkBinData_GetEncoded'))
    (objHandle, encoding, outStr);
end;

function CkBinData__getEncoded (objHandle: HCkBinData; encoding: PWideChar): PWideChar;
begin
  result := TCkBinData__getEncoded(_map(42, 'CkBinData__getEncoded'))
    (objHandle, encoding);
end;

function CkBinData_GetEncodedChunk (objHandle: HCkBinData; offset: Integer; numBytes: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkBinData_GetEncodedChunk(_map(43, 'CkBinData_GetEncodedChunk'))
    (objHandle, offset, numBytes, encoding, outStr);
end;

function CkBinData__getEncodedChunk (objHandle: HCkBinData; offset: Integer; numBytes: Integer; encoding: PWideChar): PWideChar;
begin
  result := TCkBinData__getEncodedChunk(_map(44, 'CkBinData__getEncodedChunk'))
    (objHandle, offset, numBytes, encoding);
end;

function CkBinData_GetEncodedSb (objHandle: HCkBinData; encoding: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkBinData_GetEncodedSb(_map(45, 'CkBinData_GetEncodedSb'))
    (objHandle, encoding, sb);
end;

function CkBinData_GetHash (objHandle: HCkBinData; algorithm: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkBinData_GetHash(_map(46, 'CkBinData_GetHash'))
    (objHandle, algorithm, encoding, outStr);
end;

function CkBinData__getHash (objHandle: HCkBinData; algorithm: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkBinData__getHash(_map(47, 'CkBinData__getHash'))
    (objHandle, algorithm, encoding);
end;

function CkBinData_GetInt2 (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): Integer;
begin
  result := TCkBinData_GetInt2(_map(48, 'CkBinData_GetInt2'))
    (objHandle, index, littleEndian);
end;

function CkBinData_GetInt4 (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): Integer;
begin
  result := TCkBinData_GetInt4(_map(49, 'CkBinData_GetInt4'))
    (objHandle, index, littleEndian);
end;

function CkBinData_GetString (objHandle: HCkBinData; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkBinData_GetString(_map(50, 'CkBinData_GetString'))
    (objHandle, charset, outStr);
end;

function CkBinData__getString (objHandle: HCkBinData; charset: PWideChar): PWideChar;
begin
  result := TCkBinData__getString(_map(51, 'CkBinData__getString'))
    (objHandle, charset);
end;

function CkBinData_GetTextChunk (objHandle: HCkBinData; startIdx: Integer; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkBinData_GetTextChunk(_map(52, 'CkBinData_GetTextChunk'))
    (objHandle, startIdx, numBytes, charset, outStr);
end;

function CkBinData__getTextChunk (objHandle: HCkBinData; startIdx: Integer; numBytes: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkBinData__getTextChunk(_map(53, 'CkBinData__getTextChunk'))
    (objHandle, startIdx, numBytes, charset);
end;

function CkBinData_GetUInt2 (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): LongWord;
begin
  result := TCkBinData_GetUInt2(_map(54, 'CkBinData_GetUInt2'))
    (objHandle, index, littleEndian);
end;

function CkBinData_GetUInt4 (objHandle: HCkBinData; index: Integer; littleEndian: wordbool): LongWord;
begin
  result := TCkBinData_GetUInt4(_map(55, 'CkBinData_GetUInt4'))
    (objHandle, index, littleEndian);
end;

function CkBinData_IsValidUtf8 (objHandle: HCkBinData): wordbool;
begin
  result := TCkBinData_IsValidUtf8(_map(56, 'CkBinData_IsValidUtf8'))
    (objHandle);
end;

function CkBinData_LoadBinary (objHandle: HCkBinData; data: HCkByteData): wordbool;
begin
  result := TCkBinData_LoadBinary(_map(57, 'CkBinData_LoadBinary'))
    (objHandle, data);
end;

function CkBinData_LoadEncoded (objHandle: HCkBinData; encData: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkBinData_LoadEncoded(_map(58, 'CkBinData_LoadEncoded'))
    (objHandle, encData, encoding);
end;

function CkBinData_LoadFile (objHandle: HCkBinData; path: PWideChar): wordbool;
begin
  result := TCkBinData_LoadFile(_map(59, 'CkBinData_LoadFile'))
    (objHandle, path);
end;

procedure CkBinData_RemoveByteVal (objHandle: HCkBinData; value: Integer);
begin
  TCkBinData_RemoveByteVal(_map(60, 'CkBinData_RemoveByteVal'))
    (objHandle, value);
end;

function CkBinData_RemoveChunk (objHandle: HCkBinData; offset: Integer; numBytes: Integer): wordbool;
begin
  result := TCkBinData_RemoveChunk(_map(61, 'CkBinData_RemoveChunk'))
    (objHandle, offset, numBytes);
end;

function CkBinData_SecureClear (objHandle: HCkBinData): wordbool;
begin
  result := TCkBinData_SecureClear(_map(62, 'CkBinData_SecureClear'))
    (objHandle);
end;

function CkBinData_WriteAppendFile (objHandle: HCkBinData; path: PWideChar): wordbool;
begin
  result := TCkBinData_WriteAppendFile(_map(63, 'CkBinData_WriteAppendFile'))
    (objHandle, path);
end;

function CkBinData_WriteFile (objHandle: HCkBinData; path: PWideChar): wordbool;
begin
  result := TCkBinData_WriteFile(_map(64, 'CkBinData_WriteFile'))
    (objHandle, path);
end;

end.
