unit Bz2;

interface

type

HCkBinData = Pointer;
HCkBz2 = Pointer;
HCkTask = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TBz2AbortCheck = function(): Integer; cdecl;
TBz2ProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TBz2PercentDone = function(pctDone: Integer): Integer; cdecl;
TBz2TaskCompleted = procedure(task: HCkTask); cdecl;


function CkBz2_Create: HCkBz2;  stdcall;
procedure CkBz2_Dispose(handle: HCkBz2); stdcall;

procedure CkBz2_SetAbortCheck(objHandle: HCkBz2; fn: TBz2AbortCheck) stdcall;
procedure CkBz2_SetProgressInfo(objHandle: HCkBz2; fn: TBz2ProgressInfo) stdcall;
procedure CkBz2_SetPercentDone(objHandle: HCkBz2; fn: TBz2PercentDone) stdcall;
procedure CkBz2_SetTaskCompleted(objHandle: HCkBz2; fn: TBz2TaskCompleted) stdcall;
function CkBz2_getAbortCurrent(objHandle: HCkBz2): wordbool;
procedure CkBz2_putAbortCurrent(objHandle: HCkBz2; newPropVal: wordbool);
procedure CkBz2_getDebugLogFilePath(objHandle: HCkBz2; outPropVal: HCkString);
procedure CkBz2_putDebugLogFilePath(objHandle: HCkBz2; newPropVal: PWideChar);
function CkBz2__debugLogFilePath(objHandle: HCkBz2): PWideChar;
function CkBz2_getHeartbeatMs(objHandle: HCkBz2): Integer;
procedure CkBz2_putHeartbeatMs(objHandle: HCkBz2; newPropVal: Integer);
procedure CkBz2_getLastErrorHtml(objHandle: HCkBz2; outPropVal: HCkString);
function CkBz2__lastErrorHtml(objHandle: HCkBz2): PWideChar;
procedure CkBz2_getLastErrorText(objHandle: HCkBz2; outPropVal: HCkString);
function CkBz2__lastErrorText(objHandle: HCkBz2): PWideChar;
procedure CkBz2_getLastErrorXml(objHandle: HCkBz2; outPropVal: HCkString);
function CkBz2__lastErrorXml(objHandle: HCkBz2): PWideChar;
function CkBz2_getLastMethodSuccess(objHandle: HCkBz2): wordbool;
procedure CkBz2_putLastMethodSuccess(objHandle: HCkBz2; newPropVal: wordbool);
function CkBz2_getVerboseLogging(objHandle: HCkBz2): wordbool;
procedure CkBz2_putVerboseLogging(objHandle: HCkBz2; newPropVal: wordbool);
procedure CkBz2_getVersion(objHandle: HCkBz2; outPropVal: HCkString);
function CkBz2__version(objHandle: HCkBz2): PWideChar;
function CkBz2_CompressBd(objHandle: HCkBz2; bd: HCkBinData): wordbool;
function CkBz2_CompressBdAsync(objHandle: HCkBz2; bd: HCkBinData): HCkTask;
function CkBz2_CompressFile(objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): wordbool;
function CkBz2_CompressFileAsync(objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): HCkTask;
function CkBz2_CompressFileToMem(objHandle: HCkBz2; inFilename: PWideChar; outData: HCkByteData): wordbool;
function CkBz2_CompressFileToMemAsync(objHandle: HCkBz2; inFilename: PWideChar): HCkTask;
function CkBz2_CompressMemory(objHandle: HCkBz2; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkBz2_CompressMemoryAsync(objHandle: HCkBz2; inData: HCkByteData): HCkTask;
function CkBz2_CompressMemToFile(objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): wordbool;
function CkBz2_CompressMemToFileAsync(objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): HCkTask;
function CkBz2_LoadTaskCaller(objHandle: HCkBz2; task: HCkTask): wordbool;
function CkBz2_UncompressBd(objHandle: HCkBz2; bd: HCkBinData): wordbool;
function CkBz2_UncompressBdAsync(objHandle: HCkBz2; bd: HCkBinData): HCkTask;
function CkBz2_UncompressFile(objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): wordbool;
function CkBz2_UncompressFileAsync(objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): HCkTask;
function CkBz2_UncompressFileToMem(objHandle: HCkBz2; inFilename: PWideChar; outData: HCkByteData): wordbool;
function CkBz2_UncompressFileToMemAsync(objHandle: HCkBz2; inFilename: PWideChar): HCkTask;
function CkBz2_UncompressMemory(objHandle: HCkBz2; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkBz2_UncompressMemoryAsync(objHandle: HCkBz2; inData: HCkByteData): HCkTask;
function CkBz2_UncompressMemToFile(objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): wordbool;
function CkBz2_UncompressMemToFileAsync(objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkBz2_Create = function : HCkBz2; stdcall;
  TCkBz2_Dispose = procedure (handle: HCkBz2); stdcall;
  TCkBz2_SetAbortCheck = procedure (objHandle: HCkBz2; fn: TBz2AbortCheck); stdcall;
  TCkBz2_SetProgressInfo = procedure (objHandle: HCkBz2; fn: TBz2ProgressInfo); stdcall;
  TCkBz2_SetPercentDone = procedure (objHandle: HCkBz2; fn: TBz2PercentDone); stdcall;
  TCkBz2_SetTaskCompleted = procedure (objHandle: HCkBz2; fn: TBz2TaskCompleted); stdcall;
  TCkBz2_getAbortCurrent = function (objHandle: HCkBz2): wordbool; stdcall;
  TCkBz2_putAbortCurrent = procedure (objHandle: HCkBz2; newPropVal: wordbool); stdcall;
  TCkBz2_getDebugLogFilePath = procedure (objHandle: HCkBz2; outPropVal: HCkString); stdcall;
  TCkBz2_putDebugLogFilePath = procedure (objHandle: HCkBz2; newPropVal: PWideChar); stdcall;
  TCkBz2__debugLogFilePath = function (objHandle: HCkBz2): PWideChar; stdcall;
  TCkBz2_getHeartbeatMs = function (objHandle: HCkBz2): Integer; stdcall;
  TCkBz2_putHeartbeatMs = procedure (objHandle: HCkBz2; newPropVal: Integer); stdcall;
  TCkBz2_getLastErrorHtml = procedure (objHandle: HCkBz2; outPropVal: HCkString); stdcall;
  TCkBz2__lastErrorHtml = function (objHandle: HCkBz2): PWideChar; stdcall;
  TCkBz2_getLastErrorText = procedure (objHandle: HCkBz2; outPropVal: HCkString); stdcall;
  TCkBz2__lastErrorText = function (objHandle: HCkBz2): PWideChar; stdcall;
  TCkBz2_getLastErrorXml = procedure (objHandle: HCkBz2; outPropVal: HCkString); stdcall;
  TCkBz2__lastErrorXml = function (objHandle: HCkBz2): PWideChar; stdcall;
  TCkBz2_getLastMethodSuccess = function (objHandle: HCkBz2): wordbool; stdcall;
  TCkBz2_putLastMethodSuccess = procedure (objHandle: HCkBz2; newPropVal: wordbool); stdcall;
  TCkBz2_getVerboseLogging = function (objHandle: HCkBz2): wordbool; stdcall;
  TCkBz2_putVerboseLogging = procedure (objHandle: HCkBz2; newPropVal: wordbool); stdcall;
  TCkBz2_getVersion = procedure (objHandle: HCkBz2; outPropVal: HCkString); stdcall;
  TCkBz2__version = function (objHandle: HCkBz2): PWideChar; stdcall;
  TCkBz2_CompressBd = function (objHandle: HCkBz2; bd: HCkBinData): wordbool; stdcall;
  TCkBz2_CompressBdAsync = function (objHandle: HCkBz2; bd: HCkBinData): HCkTask; stdcall;
  TCkBz2_CompressFile = function (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): wordbool; stdcall;
  TCkBz2_CompressFileAsync = function (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): HCkTask; stdcall;
  TCkBz2_CompressFileToMem = function (objHandle: HCkBz2; inFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkBz2_CompressFileToMemAsync = function (objHandle: HCkBz2; inFilename: PWideChar): HCkTask; stdcall;
  TCkBz2_CompressMemory = function (objHandle: HCkBz2; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkBz2_CompressMemoryAsync = function (objHandle: HCkBz2; inData: HCkByteData): HCkTask; stdcall;
  TCkBz2_CompressMemToFile = function (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): wordbool; stdcall;
  TCkBz2_CompressMemToFileAsync = function (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): HCkTask; stdcall;
  TCkBz2_LoadTaskCaller = function (objHandle: HCkBz2; task: HCkTask): wordbool; stdcall;
  TCkBz2_UncompressBd = function (objHandle: HCkBz2; bd: HCkBinData): wordbool; stdcall;
  TCkBz2_UncompressBdAsync = function (objHandle: HCkBz2; bd: HCkBinData): HCkTask; stdcall;
  TCkBz2_UncompressFile = function (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): wordbool; stdcall;
  TCkBz2_UncompressFileAsync = function (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): HCkTask; stdcall;
  TCkBz2_UncompressFileToMem = function (objHandle: HCkBz2; inFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkBz2_UncompressFileToMemAsync = function (objHandle: HCkBz2; inFilename: PWideChar): HCkTask; stdcall;
  TCkBz2_UncompressMemory = function (objHandle: HCkBz2; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkBz2_UncompressMemoryAsync = function (objHandle: HCkBz2; inData: HCkByteData): HCkTask; stdcall;
  TCkBz2_UncompressMemToFile = function (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): wordbool; stdcall;
  TCkBz2_UncompressMemToFileAsync = function (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..45] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkBz2_Create : HCkBz2;
begin
  result := TCkBz2_Create(_map(0, 'CkBz2_Create'));
end;

procedure CkBz2_Dispose (handle: HCkBz2);
begin
  TCkBz2_Dispose(_map(1, 'CkBz2_Dispose'))
    (handle);
end;


procedure CkBz2_SetAbortCheck (objHandle: HCkBz2; fn: TBz2AbortCheck);
begin
    TCkBz2_SetAbortCheck(_map(2, 'CkBz2_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkBz2_SetProgressInfo (objHandle: HCkBz2; fn: TBz2ProgressInfo);
begin
    TCkBz2_SetProgressInfo(_map(3, 'CkBz2_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkBz2_SetPercentDone (objHandle: HCkBz2; fn: TBz2PercentDone);
begin
    TCkBz2_SetPercentDone(_map(4, 'CkBz2_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkBz2_SetTaskCompleted (objHandle: HCkBz2; fn: TBz2TaskCompleted);
begin
    TCkBz2_SetTaskCompleted(_map(5, 'CkBz2_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkBz2_getAbortCurrent (objHandle: HCkBz2): wordbool;
begin
    result := TCkBz2_getAbortCurrent(_map(6, 'CkBz2_getAbortCurrent'))
    (objHandle);
end;

procedure CkBz2_putAbortCurrent (objHandle: HCkBz2; newPropVal: wordbool);
begin
  TCkBz2_putAbortCurrent(_map(7, 'CkBz2_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkBz2_getDebugLogFilePath (objHandle: HCkBz2; outPropVal: HCkString);
begin
  TCkBz2_getDebugLogFilePath(_map(8, 'CkBz2_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkBz2_putDebugLogFilePath (objHandle: HCkBz2; newPropVal: PWideChar);
begin
  TCkBz2_putDebugLogFilePath(_map(9, 'CkBz2_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkBz2__debugLogFilePath (objHandle: HCkBz2): PWideChar;
begin
  result := TCkBz2__debugLogFilePath(_map(10, 'CkBz2__debugLogFilePath'))
    (objHandle);
end;

function CkBz2_getHeartbeatMs (objHandle: HCkBz2): Integer;
begin
    result := TCkBz2_getHeartbeatMs(_map(11, 'CkBz2_getHeartbeatMs'))
    (objHandle);
end;

procedure CkBz2_putHeartbeatMs (objHandle: HCkBz2; newPropVal: Integer);
begin
  TCkBz2_putHeartbeatMs(_map(12, 'CkBz2_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkBz2_getLastErrorHtml (objHandle: HCkBz2; outPropVal: HCkString);
begin
  TCkBz2_getLastErrorHtml(_map(13, 'CkBz2_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkBz2__lastErrorHtml (objHandle: HCkBz2): PWideChar;
begin
  result := TCkBz2__lastErrorHtml(_map(14, 'CkBz2__lastErrorHtml'))
    (objHandle);
end;

procedure CkBz2_getLastErrorText (objHandle: HCkBz2; outPropVal: HCkString);
begin
  TCkBz2_getLastErrorText(_map(15, 'CkBz2_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkBz2__lastErrorText (objHandle: HCkBz2): PWideChar;
begin
  result := TCkBz2__lastErrorText(_map(16, 'CkBz2__lastErrorText'))
    (objHandle);
end;

procedure CkBz2_getLastErrorXml (objHandle: HCkBz2; outPropVal: HCkString);
begin
  TCkBz2_getLastErrorXml(_map(17, 'CkBz2_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkBz2__lastErrorXml (objHandle: HCkBz2): PWideChar;
begin
  result := TCkBz2__lastErrorXml(_map(18, 'CkBz2__lastErrorXml'))
    (objHandle);
end;

function CkBz2_getLastMethodSuccess (objHandle: HCkBz2): wordbool;
begin
    result := TCkBz2_getLastMethodSuccess(_map(19, 'CkBz2_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkBz2_putLastMethodSuccess (objHandle: HCkBz2; newPropVal: wordbool);
begin
  TCkBz2_putLastMethodSuccess(_map(20, 'CkBz2_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkBz2_getVerboseLogging (objHandle: HCkBz2): wordbool;
begin
    result := TCkBz2_getVerboseLogging(_map(21, 'CkBz2_getVerboseLogging'))
    (objHandle);
end;

procedure CkBz2_putVerboseLogging (objHandle: HCkBz2; newPropVal: wordbool);
begin
  TCkBz2_putVerboseLogging(_map(22, 'CkBz2_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkBz2_getVersion (objHandle: HCkBz2; outPropVal: HCkString);
begin
  TCkBz2_getVersion(_map(23, 'CkBz2_getVersion'))
    (objHandle, outPropVal);
end;

function CkBz2__version (objHandle: HCkBz2): PWideChar;
begin
  result := TCkBz2__version(_map(24, 'CkBz2__version'))
    (objHandle);
end;

function CkBz2_CompressBd (objHandle: HCkBz2; bd: HCkBinData): wordbool;
begin
  result := TCkBz2_CompressBd(_map(25, 'CkBz2_CompressBd'))
    (objHandle, bd);
end;

function CkBz2_CompressBdAsync (objHandle: HCkBz2; bd: HCkBinData): HCkTask;
begin
  result := TCkBz2_CompressBdAsync(_map(26, 'CkBz2_CompressBdAsync'))
    (objHandle, bd);
end;

function CkBz2_CompressFile (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): wordbool;
begin
  result := TCkBz2_CompressFile(_map(27, 'CkBz2_CompressFile'))
    (objHandle, inFilename, toPath);
end;

function CkBz2_CompressFileAsync (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): HCkTask;
begin
  result := TCkBz2_CompressFileAsync(_map(28, 'CkBz2_CompressFileAsync'))
    (objHandle, inFilename, toPath);
end;

function CkBz2_CompressFileToMem (objHandle: HCkBz2; inFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkBz2_CompressFileToMem(_map(29, 'CkBz2_CompressFileToMem'))
    (objHandle, inFilename, outData);
end;

function CkBz2_CompressFileToMemAsync (objHandle: HCkBz2; inFilename: PWideChar): HCkTask;
begin
  result := TCkBz2_CompressFileToMemAsync(_map(30, 'CkBz2_CompressFileToMemAsync'))
    (objHandle, inFilename);
end;

function CkBz2_CompressMemory (objHandle: HCkBz2; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkBz2_CompressMemory(_map(31, 'CkBz2_CompressMemory'))
    (objHandle, inData, outData);
end;

function CkBz2_CompressMemoryAsync (objHandle: HCkBz2; inData: HCkByteData): HCkTask;
begin
  result := TCkBz2_CompressMemoryAsync(_map(32, 'CkBz2_CompressMemoryAsync'))
    (objHandle, inData);
end;

function CkBz2_CompressMemToFile (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): wordbool;
begin
  result := TCkBz2_CompressMemToFile(_map(33, 'CkBz2_CompressMemToFile'))
    (objHandle, inData, toPath);
end;

function CkBz2_CompressMemToFileAsync (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): HCkTask;
begin
  result := TCkBz2_CompressMemToFileAsync(_map(34, 'CkBz2_CompressMemToFileAsync'))
    (objHandle, inData, toPath);
end;

function CkBz2_LoadTaskCaller (objHandle: HCkBz2; task: HCkTask): wordbool;
begin
  result := TCkBz2_LoadTaskCaller(_map(35, 'CkBz2_LoadTaskCaller'))
    (objHandle, task);
end;

function CkBz2_UncompressBd (objHandle: HCkBz2; bd: HCkBinData): wordbool;
begin
  result := TCkBz2_UncompressBd(_map(36, 'CkBz2_UncompressBd'))
    (objHandle, bd);
end;

function CkBz2_UncompressBdAsync (objHandle: HCkBz2; bd: HCkBinData): HCkTask;
begin
  result := TCkBz2_UncompressBdAsync(_map(37, 'CkBz2_UncompressBdAsync'))
    (objHandle, bd);
end;

function CkBz2_UncompressFile (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): wordbool;
begin
  result := TCkBz2_UncompressFile(_map(38, 'CkBz2_UncompressFile'))
    (objHandle, inFilename, toPath);
end;

function CkBz2_UncompressFileAsync (objHandle: HCkBz2; inFilename: PWideChar; toPath: PWideChar): HCkTask;
begin
  result := TCkBz2_UncompressFileAsync(_map(39, 'CkBz2_UncompressFileAsync'))
    (objHandle, inFilename, toPath);
end;

function CkBz2_UncompressFileToMem (objHandle: HCkBz2; inFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkBz2_UncompressFileToMem(_map(40, 'CkBz2_UncompressFileToMem'))
    (objHandle, inFilename, outData);
end;

function CkBz2_UncompressFileToMemAsync (objHandle: HCkBz2; inFilename: PWideChar): HCkTask;
begin
  result := TCkBz2_UncompressFileToMemAsync(_map(41, 'CkBz2_UncompressFileToMemAsync'))
    (objHandle, inFilename);
end;

function CkBz2_UncompressMemory (objHandle: HCkBz2; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkBz2_UncompressMemory(_map(42, 'CkBz2_UncompressMemory'))
    (objHandle, inData, outData);
end;

function CkBz2_UncompressMemoryAsync (objHandle: HCkBz2; inData: HCkByteData): HCkTask;
begin
  result := TCkBz2_UncompressMemoryAsync(_map(43, 'CkBz2_UncompressMemoryAsync'))
    (objHandle, inData);
end;

function CkBz2_UncompressMemToFile (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): wordbool;
begin
  result := TCkBz2_UncompressMemToFile(_map(44, 'CkBz2_UncompressMemToFile'))
    (objHandle, inData, toPath);
end;

function CkBz2_UncompressMemToFileAsync (objHandle: HCkBz2; inData: HCkByteData; toPath: PWideChar): HCkTask;
begin
  result := TCkBz2_UncompressMemToFileAsync(_map(45, 'CkBz2_UncompressMemToFileAsync'))
    (objHandle, inData, toPath);
end;

end.
