unit Cert;

interface

type

HCkPublicKey = Pointer;
HCkBinData = Pointer;
HCkDateTime = Pointer;
HCkPrivateKey = Pointer;
HCkTask = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkXmlCertVault = Pointer;
HCkJsonObject = Pointer;
HCkCertChain = Pointer;
HCkCert = Pointer;
HCkPkcs11 = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TCertAbortCheck = function(): Integer; cdecl;
TCertProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TCertPercentDone = function(pctDone: Integer): Integer; cdecl;
TCertTaskCompleted = procedure(task: HCkTask); cdecl;


function CkCert_Create: HCkCert;  stdcall;
procedure CkCert_Dispose(handle: HCkCert); stdcall;

procedure CkCert_SetAbortCheck(objHandle: HCkCert; fn: TCertAbortCheck) stdcall;
procedure CkCert_SetProgressInfo(objHandle: HCkCert; fn: TCertProgressInfo) stdcall;
procedure CkCert_SetPercentDone(objHandle: HCkCert; fn: TCertPercentDone) stdcall;
procedure CkCert_SetTaskCompleted(objHandle: HCkCert; fn: TCertTaskCompleted) stdcall;
procedure CkCert_getAuthorityKeyId(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__authorityKeyId(objHandle: HCkCert): PWideChar;
function CkCert_getAvoidWindowsPkAccess(objHandle: HCkCert): wordbool;
procedure CkCert_putAvoidWindowsPkAccess(objHandle: HCkCert; newPropVal: wordbool);
function CkCert_getCertVersion(objHandle: HCkCert): Integer;
procedure CkCert_getDebugLogFilePath(objHandle: HCkCert; outPropVal: HCkString);
procedure CkCert_putDebugLogFilePath(objHandle: HCkCert; newPropVal: PWideChar);
function CkCert__debugLogFilePath(objHandle: HCkCert): PWideChar;
function CkCert_getExpired(objHandle: HCkCert): wordbool;
procedure CkCert_getExtendedKeyUsage(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__extendedKeyUsage(objHandle: HCkCert): PWideChar;
function CkCert_getForClientAuthentication(objHandle: HCkCert): wordbool;
function CkCert_getForCodeSigning(objHandle: HCkCert): wordbool;
function CkCert_getForSecureEmail(objHandle: HCkCert): wordbool;
function CkCert_getForServerAuthentication(objHandle: HCkCert): wordbool;
function CkCert_getForTimeStamping(objHandle: HCkCert): wordbool;
function CkCert_getIntendedKeyUsage(objHandle: HCkCert): LongWord;
function CkCert_getIsRoot(objHandle: HCkCert): wordbool;
procedure CkCert_getIssuerC(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerC(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerCN(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerCN(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerDN(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerDN(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerE(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerE(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerL(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerL(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerO(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerO(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerOU(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerOU(objHandle: HCkCert): PWideChar;
procedure CkCert_getIssuerS(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__issuerS(objHandle: HCkCert): PWideChar;
procedure CkCert_getLastErrorHtml(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__lastErrorHtml(objHandle: HCkCert): PWideChar;
procedure CkCert_getLastErrorText(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__lastErrorText(objHandle: HCkCert): PWideChar;
procedure CkCert_getLastErrorXml(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__lastErrorXml(objHandle: HCkCert): PWideChar;
function CkCert_getLastMethodSuccess(objHandle: HCkCert): wordbool;
procedure CkCert_putLastMethodSuccess(objHandle: HCkCert; newPropVal: wordbool);
procedure CkCert_getOcspUrl(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__ocspUrl(objHandle: HCkCert): PWideChar;
function CkCert_getPrivateKeyExportable(objHandle: HCkCert): wordbool;
function CkCert_getRevoked(objHandle: HCkCert): wordbool;
procedure CkCert_getRfc822Name(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__rfc822Name(objHandle: HCkCert): PWideChar;
function CkCert_getSelfSigned(objHandle: HCkCert): wordbool;
procedure CkCert_getSerialDecimal(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__serialDecimal(objHandle: HCkCert): PWideChar;
procedure CkCert_getSerialNumber(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__serialNumber(objHandle: HCkCert): PWideChar;
procedure CkCert_getSha1Thumbprint(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__sha1Thumbprint(objHandle: HCkCert): PWideChar;
function CkCert_getSignatureVerified(objHandle: HCkCert): wordbool;
function CkCert_getSmartCardFailReason(objHandle: HCkCert): Integer;
function CkCert_getSmartCardNoDialog(objHandle: HCkCert): wordbool;
procedure CkCert_putSmartCardNoDialog(objHandle: HCkCert; newPropVal: wordbool);
procedure CkCert_getSmartCardPin(objHandle: HCkCert; outPropVal: HCkString);
procedure CkCert_putSmartCardPin(objHandle: HCkCert; newPropVal: PWideChar);
function CkCert__smartCardPin(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectAlternativeName(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectAlternativeName(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectC(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectC(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectCN(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectCN(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectDN(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectDN(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectE(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectE(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectKeyId(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectKeyId(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectL(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectL(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectO(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectO(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectOU(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectOU(objHandle: HCkCert): PWideChar;
procedure CkCert_getSubjectS(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__subjectS(objHandle: HCkCert): PWideChar;
function CkCert_getTrustedRoot(objHandle: HCkCert): wordbool;
procedure CkCert_getUncommonOptions(objHandle: HCkCert; outPropVal: HCkString);
procedure CkCert_putUncommonOptions(objHandle: HCkCert; newPropVal: PWideChar);
function CkCert__uncommonOptions(objHandle: HCkCert): PWideChar;
procedure CkCert_getValidFromStr(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__validFromStr(objHandle: HCkCert): PWideChar;
procedure CkCert_getValidToStr(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__validToStr(objHandle: HCkCert): PWideChar;
function CkCert_getVerboseLogging(objHandle: HCkCert): wordbool;
procedure CkCert_putVerboseLogging(objHandle: HCkCert; newPropVal: wordbool);
procedure CkCert_getVersion(objHandle: HCkCert; outPropVal: HCkString);
function CkCert__version(objHandle: HCkCert): PWideChar;
function CkCert_BuildCertChain(objHandle: HCkCert; certChain: HCkCertChain): wordbool;
function CkCert_CheckRevoked(objHandle: HCkCert): Integer;
function CkCert_CheckSmartCardPin(objHandle: HCkCert): Integer;
function CkCert_ExportCertDer(objHandle: HCkCert; outData: HCkByteData): wordbool;
function CkCert_ExportCertDerBd(objHandle: HCkCert; cerData: HCkBinData): wordbool;
function CkCert_ExportCertDerFile(objHandle: HCkCert; path: PWideChar): wordbool;
function CkCert_ExportCertPem(objHandle: HCkCert; outStr: HCkString): wordbool;
function CkCert__exportCertPem(objHandle: HCkCert): PWideChar;
function CkCert_ExportCertPemFile(objHandle: HCkCert; path: PWideChar): wordbool;
function CkCert_ExportCertXml(objHandle: HCkCert; outStr: HCkString): wordbool;
function CkCert__exportCertXml(objHandle: HCkCert): PWideChar;
function CkCert_ExportPrivateKey(objHandle: HCkCert): HCkPrivateKey;
function CkCert_ExportPublicKey(objHandle: HCkCert): HCkPublicKey;
function CkCert_ExportToPfxBd(objHandle: HCkCert; password: PWideChar; includeCertChain: wordbool; pfxData: HCkBinData): wordbool;
function CkCert_ExportToPfxData(objHandle: HCkCert; password: PWideChar; includeCertChain: wordbool; outData: HCkByteData): wordbool;
function CkCert_ExportToPfxFile(objHandle: HCkCert; pfxFilename: PWideChar; pfxPassword: PWideChar; bIncludeCertChain: wordbool): wordbool;
function CkCert_FindIssuer(objHandle: HCkCert): HCkCert;
function CkCert_GetCertChain(objHandle: HCkCert): HCkCertChain;
function CkCert_GetEncoded(objHandle: HCkCert; outStr: HCkString): wordbool;
function CkCert__getEncoded(objHandle: HCkCert): PWideChar;
function CkCert_GetExtensionAsText(objHandle: HCkCert; oid: PWideChar; outStr: HCkString): wordbool;
function CkCert__getExtensionAsText(objHandle: HCkCert; oid: PWideChar): PWideChar;
function CkCert_GetExtensionAsXml(objHandle: HCkCert; oid: PWideChar; outStr: HCkString): wordbool;
function CkCert__getExtensionAsXml(objHandle: HCkCert; oid: PWideChar): PWideChar;
function CkCert_GetExtensionBd(objHandle: HCkCert; oid: PWideChar; bd: HCkBinData): wordbool;
function CkCert_GetIssuer(objHandle: HCkCert; issuer: HCkCert): wordbool;
function CkCert_GetPrivateKey(objHandle: HCkCert; privKey: HCkPrivateKey): wordbool;
function CkCert_GetPrivateKeyPem(objHandle: HCkCert; outStr: HCkString): wordbool;
function CkCert__getPrivateKeyPem(objHandle: HCkCert): PWideChar;
function CkCert_GetPubKeyDer(objHandle: HCkCert; preferPkcs1: wordbool; bd: HCkBinData): wordbool;
function CkCert_GetPublicKey(objHandle: HCkCert; pubKey: HCkPublicKey): wordbool;
function CkCert_GetSignature(objHandle: HCkCert; bd: HCkBinData): wordbool;
function CkCert_GetSpkiFingerprint(objHandle: HCkCert; hashAlg: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkCert__getSpkiFingerprint(objHandle: HCkCert; hashAlg: PWideChar; encoding: PWideChar): PWideChar;
function CkCert_GetSubjectPart(objHandle: HCkCert; partNameOrOid: PWideChar; outStr: HCkString): wordbool;
function CkCert__getSubjectPart(objHandle: HCkCert; partNameOrOid: PWideChar): PWideChar;
function CkCert_GetValidFromDt(objHandle: HCkCert): HCkDateTime;
function CkCert_GetValidToDt(objHandle: HCkCert): HCkDateTime;
function CkCert_HashOf(objHandle: HCkCert; part: PWideChar; hashAlg: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkCert__hashOf(objHandle: HCkCert; part: PWideChar; hashAlg: PWideChar; encoding: PWideChar): PWideChar;
function CkCert_HasPrivateKey(objHandle: HCkCert): wordbool;
function CkCert_IsEcdsa(objHandle: HCkCert): wordbool;
function CkCert_IsRsa(objHandle: HCkCert): wordbool;
function CkCert_LinkPkcs11(objHandle: HCkCert; session: HCkPkcs11): wordbool;
function CkCert_LoadByCommonName(objHandle: HCkCert; cn: PWideChar): wordbool;
function CkCert_LoadByEmailAddress(objHandle: HCkCert; emailAddress: PWideChar): wordbool;
function CkCert_LoadByIssuerAndSerialNumber(objHandle: HCkCert; issuerCN: PWideChar; serialNumber: PWideChar): wordbool;
function CkCert_LoadBySubjectOid(objHandle: HCkCert; oid: PWideChar; value: PWideChar): wordbool;
function CkCert_LoadByThumbprint(objHandle: HCkCert; thumbprint: PWideChar; encoding: PWideChar): wordbool;
function CkCert_LoadFromBase64(objHandle: HCkCert; encodedCert: PWideChar): wordbool;
function CkCert_LoadFromBd(objHandle: HCkCert; certBytes: HCkBinData): wordbool;
function CkCert_LoadFromBinary(objHandle: HCkCert; data: HCkByteData): wordbool;
function CkCert_LoadFromFile(objHandle: HCkCert; path: PWideChar): wordbool;
function CkCert_LoadFromSmartcard(objHandle: HCkCert; certSpec: PWideChar): wordbool;
function CkCert_LoadPem(objHandle: HCkCert; strPem: PWideChar): wordbool;
function CkCert_LoadPfxBd(objHandle: HCkCert; pfxData: HCkBinData; password: PWideChar): wordbool;
function CkCert_LoadPfxData(objHandle: HCkCert; pfxData: HCkByteData; password: PWideChar): wordbool;
function CkCert_LoadPfxFile(objHandle: HCkCert; pfxPath: PWideChar; password: PWideChar): wordbool;
function CkCert_LoadTaskResult(objHandle: HCkCert; task: HCkTask): wordbool;
function CkCert_PemFileToDerFile(objHandle: HCkCert; fromPath: PWideChar; toPath: PWideChar): wordbool;
function CkCert_SaveToFile(objHandle: HCkCert; path: PWideChar): wordbool;
function CkCert_SetCloudSigner(objHandle: HCkCert; json: HCkJsonObject): wordbool;
function CkCert_SetCloudSignerAsync(objHandle: HCkCert; json: HCkJsonObject): HCkTask;
function CkCert_SetFromEncoded(objHandle: HCkCert; encodedCert: PWideChar): wordbool;
function CkCert_SetPrivateKey(objHandle: HCkCert; privKey: HCkPrivateKey): wordbool;
function CkCert_SetPrivateKeyPem(objHandle: HCkCert; privKeyPem: PWideChar): wordbool;
function CkCert_Unload(objHandle: HCkCert): wordbool;
function CkCert_UploadToCloud(objHandle: HCkCert; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
function CkCert_UploadToCloudAsync(objHandle: HCkCert; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
function CkCert_UseCertVault(objHandle: HCkCert; vault: HCkXmlCertVault): wordbool;
function CkCert_VerifySignature(objHandle: HCkCert): wordbool;
function CkCert_X509PKIPathv1(objHandle: HCkCert; outStr: HCkString): wordbool;
function CkCert__x509PKIPathv1(objHandle: HCkCert): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCert_Create = function : HCkCert; stdcall;
  TCkCert_Dispose = procedure (handle: HCkCert); stdcall;
  TCkCert_SetAbortCheck = procedure (objHandle: HCkCert; fn: TCertAbortCheck); stdcall;
  TCkCert_SetProgressInfo = procedure (objHandle: HCkCert; fn: TCertProgressInfo); stdcall;
  TCkCert_SetPercentDone = procedure (objHandle: HCkCert; fn: TCertPercentDone); stdcall;
  TCkCert_SetTaskCompleted = procedure (objHandle: HCkCert; fn: TCertTaskCompleted); stdcall;
  TCkCert_getAuthorityKeyId = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__authorityKeyId = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getAvoidWindowsPkAccess = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_putAvoidWindowsPkAccess = procedure (objHandle: HCkCert; newPropVal: wordbool); stdcall;
  TCkCert_getCertVersion = function (objHandle: HCkCert): Integer; stdcall;
  TCkCert_getDebugLogFilePath = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert_putDebugLogFilePath = procedure (objHandle: HCkCert; newPropVal: PWideChar); stdcall;
  TCkCert__debugLogFilePath = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getExpired = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getExtendedKeyUsage = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__extendedKeyUsage = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getForClientAuthentication = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getForCodeSigning = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getForSecureEmail = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getForServerAuthentication = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getForTimeStamping = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getIntendedKeyUsage = function (objHandle: HCkCert): LongWord; stdcall;
  TCkCert_getIsRoot = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getIssuerC = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerC = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerCN = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerCN = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerDN = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerDN = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerE = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerE = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerL = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerL = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerO = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerO = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerOU = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerOU = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getIssuerS = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__issuerS = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getLastErrorHtml = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__lastErrorHtml = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getLastErrorText = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__lastErrorText = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getLastErrorXml = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__lastErrorXml = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getLastMethodSuccess = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_putLastMethodSuccess = procedure (objHandle: HCkCert; newPropVal: wordbool); stdcall;
  TCkCert_getOcspUrl = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__ocspUrl = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getPrivateKeyExportable = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getRevoked = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getRfc822Name = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__rfc822Name = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSelfSigned = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getSerialDecimal = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__serialDecimal = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSerialNumber = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__serialNumber = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSha1Thumbprint = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__sha1Thumbprint = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSignatureVerified = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getSmartCardFailReason = function (objHandle: HCkCert): Integer; stdcall;
  TCkCert_getSmartCardNoDialog = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_putSmartCardNoDialog = procedure (objHandle: HCkCert; newPropVal: wordbool); stdcall;
  TCkCert_getSmartCardPin = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert_putSmartCardPin = procedure (objHandle: HCkCert; newPropVal: PWideChar); stdcall;
  TCkCert__smartCardPin = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectAlternativeName = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectAlternativeName = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectC = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectC = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectCN = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectCN = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectDN = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectDN = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectE = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectE = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectKeyId = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectKeyId = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectL = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectL = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectO = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectO = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectOU = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectOU = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getSubjectS = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__subjectS = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getTrustedRoot = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_getUncommonOptions = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert_putUncommonOptions = procedure (objHandle: HCkCert; newPropVal: PWideChar); stdcall;
  TCkCert__uncommonOptions = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getValidFromStr = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__validFromStr = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getValidToStr = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__validToStr = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_getVerboseLogging = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_putVerboseLogging = procedure (objHandle: HCkCert; newPropVal: wordbool); stdcall;
  TCkCert_getVersion = procedure (objHandle: HCkCert; outPropVal: HCkString); stdcall;
  TCkCert__version = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_BuildCertChain = function (objHandle: HCkCert; certChain: HCkCertChain): wordbool; stdcall;
  TCkCert_CheckRevoked = function (objHandle: HCkCert): Integer; stdcall;
  TCkCert_CheckSmartCardPin = function (objHandle: HCkCert): Integer; stdcall;
  TCkCert_ExportCertDer = function (objHandle: HCkCert; outData: HCkByteData): wordbool; stdcall;
  TCkCert_ExportCertDerBd = function (objHandle: HCkCert; cerData: HCkBinData): wordbool; stdcall;
  TCkCert_ExportCertDerFile = function (objHandle: HCkCert; path: PWideChar): wordbool; stdcall;
  TCkCert_ExportCertPem = function (objHandle: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkCert__exportCertPem = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_ExportCertPemFile = function (objHandle: HCkCert; path: PWideChar): wordbool; stdcall;
  TCkCert_ExportCertXml = function (objHandle: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkCert__exportCertXml = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_ExportPrivateKey = function (objHandle: HCkCert): HCkPrivateKey; stdcall;
  TCkCert_ExportPublicKey = function (objHandle: HCkCert): HCkPublicKey; stdcall;
  TCkCert_ExportToPfxBd = function (objHandle: HCkCert; password: PWideChar; includeCertChain: wordbool; pfxData: HCkBinData): wordbool; stdcall;
  TCkCert_ExportToPfxData = function (objHandle: HCkCert; password: PWideChar; includeCertChain: wordbool; outData: HCkByteData): wordbool; stdcall;
  TCkCert_ExportToPfxFile = function (objHandle: HCkCert; pfxFilename: PWideChar; pfxPassword: PWideChar; bIncludeCertChain: wordbool): wordbool; stdcall;
  TCkCert_FindIssuer = function (objHandle: HCkCert): HCkCert; stdcall;
  TCkCert_GetCertChain = function (objHandle: HCkCert): HCkCertChain; stdcall;
  TCkCert_GetEncoded = function (objHandle: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkCert__getEncoded = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_GetExtensionAsText = function (objHandle: HCkCert; oid: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCert__getExtensionAsText = function (objHandle: HCkCert; oid: PWideChar): PWideChar; stdcall;
  TCkCert_GetExtensionAsXml = function (objHandle: HCkCert; oid: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCert__getExtensionAsXml = function (objHandle: HCkCert; oid: PWideChar): PWideChar; stdcall;
  TCkCert_GetExtensionBd = function (objHandle: HCkCert; oid: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkCert_GetIssuer = function (objHandle: HCkCert; issuer: HCkCert): wordbool; stdcall;
  TCkCert_GetPrivateKey = function (objHandle: HCkCert; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkCert_GetPrivateKeyPem = function (objHandle: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkCert__getPrivateKeyPem = function (objHandle: HCkCert): PWideChar; stdcall;
  TCkCert_GetPubKeyDer = function (objHandle: HCkCert; preferPkcs1: wordbool; bd: HCkBinData): wordbool; stdcall;
  TCkCert_GetPublicKey = function (objHandle: HCkCert; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkCert_GetSignature = function (objHandle: HCkCert; bd: HCkBinData): wordbool; stdcall;
  TCkCert_GetSpkiFingerprint = function (objHandle: HCkCert; hashAlg: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCert__getSpkiFingerprint = function (objHandle: HCkCert; hashAlg: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkCert_GetSubjectPart = function (objHandle: HCkCert; partNameOrOid: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCert__getSubjectPart = function (objHandle: HCkCert; partNameOrOid: PWideChar): PWideChar; stdcall;
  TCkCert_GetValidFromDt = function (objHandle: HCkCert): HCkDateTime; stdcall;
  TCkCert_GetValidToDt = function (objHandle: HCkCert): HCkDateTime; stdcall;
  TCkCert_HashOf = function (objHandle: HCkCert; part: PWideChar; hashAlg: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCert__hashOf = function (objHandle: HCkCert; part: PWideChar; hashAlg: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkCert_HasPrivateKey = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_IsEcdsa = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_IsRsa = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_LinkPkcs11 = function (objHandle: HCkCert; session: HCkPkcs11): wordbool; stdcall;
  TCkCert_LoadByCommonName = function (objHandle: HCkCert; cn: PWideChar): wordbool; stdcall;
  TCkCert_LoadByEmailAddress = function (objHandle: HCkCert; emailAddress: PWideChar): wordbool; stdcall;
  TCkCert_LoadByIssuerAndSerialNumber = function (objHandle: HCkCert; issuerCN: PWideChar; serialNumber: PWideChar): wordbool; stdcall;
  TCkCert_LoadBySubjectOid = function (objHandle: HCkCert; oid: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkCert_LoadByThumbprint = function (objHandle: HCkCert; thumbprint: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkCert_LoadFromBase64 = function (objHandle: HCkCert; encodedCert: PWideChar): wordbool; stdcall;
  TCkCert_LoadFromBd = function (objHandle: HCkCert; certBytes: HCkBinData): wordbool; stdcall;
  TCkCert_LoadFromBinary = function (objHandle: HCkCert; data: HCkByteData): wordbool; stdcall;
  TCkCert_LoadFromFile = function (objHandle: HCkCert; path: PWideChar): wordbool; stdcall;
  TCkCert_LoadFromSmartcard = function (objHandle: HCkCert; certSpec: PWideChar): wordbool; stdcall;
  TCkCert_LoadPem = function (objHandle: HCkCert; strPem: PWideChar): wordbool; stdcall;
  TCkCert_LoadPfxBd = function (objHandle: HCkCert; pfxData: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkCert_LoadPfxData = function (objHandle: HCkCert; pfxData: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkCert_LoadPfxFile = function (objHandle: HCkCert; pfxPath: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkCert_LoadTaskResult = function (objHandle: HCkCert; task: HCkTask): wordbool; stdcall;
  TCkCert_PemFileToDerFile = function (objHandle: HCkCert; fromPath: PWideChar; toPath: PWideChar): wordbool; stdcall;
  TCkCert_SaveToFile = function (objHandle: HCkCert; path: PWideChar): wordbool; stdcall;
  TCkCert_SetCloudSigner = function (objHandle: HCkCert; json: HCkJsonObject): wordbool; stdcall;
  TCkCert_SetCloudSignerAsync = function (objHandle: HCkCert; json: HCkJsonObject): HCkTask; stdcall;
  TCkCert_SetFromEncoded = function (objHandle: HCkCert; encodedCert: PWideChar): wordbool; stdcall;
  TCkCert_SetPrivateKey = function (objHandle: HCkCert; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkCert_SetPrivateKeyPem = function (objHandle: HCkCert; privKeyPem: PWideChar): wordbool; stdcall;
  TCkCert_Unload = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_UploadToCloud = function (objHandle: HCkCert; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): wordbool; stdcall;
  TCkCert_UploadToCloudAsync = function (objHandle: HCkCert; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask; stdcall;
  TCkCert_UseCertVault = function (objHandle: HCkCert; vault: HCkXmlCertVault): wordbool; stdcall;
  TCkCert_VerifySignature = function (objHandle: HCkCert): wordbool; stdcall;
  TCkCert_X509PKIPathv1 = function (objHandle: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkCert__x509PKIPathv1 = function (objHandle: HCkCert): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..172] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCert_Create : HCkCert;
begin
  result := TCkCert_Create(_map(0, 'CkCert_Create'));
end;

procedure CkCert_Dispose (handle: HCkCert);
begin
  TCkCert_Dispose(_map(1, 'CkCert_Dispose'))
    (handle);
end;


procedure CkCert_SetAbortCheck (objHandle: HCkCert; fn: TCertAbortCheck);
begin
    TCkCert_SetAbortCheck(_map(2, 'CkCert_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkCert_SetProgressInfo (objHandle: HCkCert; fn: TCertProgressInfo);
begin
    TCkCert_SetProgressInfo(_map(3, 'CkCert_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkCert_SetPercentDone (objHandle: HCkCert; fn: TCertPercentDone);
begin
    TCkCert_SetPercentDone(_map(4, 'CkCert_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkCert_SetTaskCompleted (objHandle: HCkCert; fn: TCertTaskCompleted);
begin
    TCkCert_SetTaskCompleted(_map(5, 'CkCert_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkCert_getAuthorityKeyId (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getAuthorityKeyId(_map(6, 'CkCert_getAuthorityKeyId'))
    (objHandle, outPropVal);
end;

function CkCert__authorityKeyId (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__authorityKeyId(_map(7, 'CkCert__authorityKeyId'))
    (objHandle);
end;

function CkCert_getAvoidWindowsPkAccess (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getAvoidWindowsPkAccess(_map(8, 'CkCert_getAvoidWindowsPkAccess'))
    (objHandle);
end;

procedure CkCert_putAvoidWindowsPkAccess (objHandle: HCkCert; newPropVal: wordbool);
begin
  TCkCert_putAvoidWindowsPkAccess(_map(9, 'CkCert_putAvoidWindowsPkAccess'))
    (objHandle, newPropVal);
end;

function CkCert_getCertVersion (objHandle: HCkCert): Integer;
begin
    result := TCkCert_getCertVersion(_map(10, 'CkCert_getCertVersion'))
    (objHandle);
end;

procedure CkCert_getDebugLogFilePath (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getDebugLogFilePath(_map(11, 'CkCert_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCert_putDebugLogFilePath (objHandle: HCkCert; newPropVal: PWideChar);
begin
  TCkCert_putDebugLogFilePath(_map(12, 'CkCert_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCert__debugLogFilePath (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__debugLogFilePath(_map(13, 'CkCert__debugLogFilePath'))
    (objHandle);
end;

function CkCert_getExpired (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getExpired(_map(14, 'CkCert_getExpired'))
    (objHandle);
end;

procedure CkCert_getExtendedKeyUsage (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getExtendedKeyUsage(_map(15, 'CkCert_getExtendedKeyUsage'))
    (objHandle, outPropVal);
end;

function CkCert__extendedKeyUsage (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__extendedKeyUsage(_map(16, 'CkCert__extendedKeyUsage'))
    (objHandle);
end;

function CkCert_getForClientAuthentication (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getForClientAuthentication(_map(17, 'CkCert_getForClientAuthentication'))
    (objHandle);
end;

function CkCert_getForCodeSigning (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getForCodeSigning(_map(18, 'CkCert_getForCodeSigning'))
    (objHandle);
end;

function CkCert_getForSecureEmail (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getForSecureEmail(_map(19, 'CkCert_getForSecureEmail'))
    (objHandle);
end;

function CkCert_getForServerAuthentication (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getForServerAuthentication(_map(20, 'CkCert_getForServerAuthentication'))
    (objHandle);
end;

function CkCert_getForTimeStamping (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getForTimeStamping(_map(21, 'CkCert_getForTimeStamping'))
    (objHandle);
end;

function CkCert_getIntendedKeyUsage (objHandle: HCkCert): LongWord;
begin
    result := TCkCert_getIntendedKeyUsage(_map(22, 'CkCert_getIntendedKeyUsage'))
    (objHandle);
end;

function CkCert_getIsRoot (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getIsRoot(_map(23, 'CkCert_getIsRoot'))
    (objHandle);
end;

procedure CkCert_getIssuerC (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerC(_map(24, 'CkCert_getIssuerC'))
    (objHandle, outPropVal);
end;

function CkCert__issuerC (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerC(_map(25, 'CkCert__issuerC'))
    (objHandle);
end;

procedure CkCert_getIssuerCN (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerCN(_map(26, 'CkCert_getIssuerCN'))
    (objHandle, outPropVal);
end;

function CkCert__issuerCN (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerCN(_map(27, 'CkCert__issuerCN'))
    (objHandle);
end;

procedure CkCert_getIssuerDN (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerDN(_map(28, 'CkCert_getIssuerDN'))
    (objHandle, outPropVal);
end;

function CkCert__issuerDN (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerDN(_map(29, 'CkCert__issuerDN'))
    (objHandle);
end;

procedure CkCert_getIssuerE (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerE(_map(30, 'CkCert_getIssuerE'))
    (objHandle, outPropVal);
end;

function CkCert__issuerE (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerE(_map(31, 'CkCert__issuerE'))
    (objHandle);
end;

procedure CkCert_getIssuerL (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerL(_map(32, 'CkCert_getIssuerL'))
    (objHandle, outPropVal);
end;

function CkCert__issuerL (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerL(_map(33, 'CkCert__issuerL'))
    (objHandle);
end;

procedure CkCert_getIssuerO (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerO(_map(34, 'CkCert_getIssuerO'))
    (objHandle, outPropVal);
end;

function CkCert__issuerO (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerO(_map(35, 'CkCert__issuerO'))
    (objHandle);
end;

procedure CkCert_getIssuerOU (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerOU(_map(36, 'CkCert_getIssuerOU'))
    (objHandle, outPropVal);
end;

function CkCert__issuerOU (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerOU(_map(37, 'CkCert__issuerOU'))
    (objHandle);
end;

procedure CkCert_getIssuerS (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getIssuerS(_map(38, 'CkCert_getIssuerS'))
    (objHandle, outPropVal);
end;

function CkCert__issuerS (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__issuerS(_map(39, 'CkCert__issuerS'))
    (objHandle);
end;

procedure CkCert_getLastErrorHtml (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getLastErrorHtml(_map(40, 'CkCert_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCert__lastErrorHtml (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__lastErrorHtml(_map(41, 'CkCert__lastErrorHtml'))
    (objHandle);
end;

procedure CkCert_getLastErrorText (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getLastErrorText(_map(42, 'CkCert_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCert__lastErrorText (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__lastErrorText(_map(43, 'CkCert__lastErrorText'))
    (objHandle);
end;

procedure CkCert_getLastErrorXml (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getLastErrorXml(_map(44, 'CkCert_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCert__lastErrorXml (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__lastErrorXml(_map(45, 'CkCert__lastErrorXml'))
    (objHandle);
end;

function CkCert_getLastMethodSuccess (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getLastMethodSuccess(_map(46, 'CkCert_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCert_putLastMethodSuccess (objHandle: HCkCert; newPropVal: wordbool);
begin
  TCkCert_putLastMethodSuccess(_map(47, 'CkCert_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkCert_getOcspUrl (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getOcspUrl(_map(48, 'CkCert_getOcspUrl'))
    (objHandle, outPropVal);
end;

function CkCert__ocspUrl (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__ocspUrl(_map(49, 'CkCert__ocspUrl'))
    (objHandle);
end;

function CkCert_getPrivateKeyExportable (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getPrivateKeyExportable(_map(50, 'CkCert_getPrivateKeyExportable'))
    (objHandle);
end;

function CkCert_getRevoked (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getRevoked(_map(51, 'CkCert_getRevoked'))
    (objHandle);
end;

procedure CkCert_getRfc822Name (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getRfc822Name(_map(52, 'CkCert_getRfc822Name'))
    (objHandle, outPropVal);
end;

function CkCert__rfc822Name (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__rfc822Name(_map(53, 'CkCert__rfc822Name'))
    (objHandle);
end;

function CkCert_getSelfSigned (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getSelfSigned(_map(54, 'CkCert_getSelfSigned'))
    (objHandle);
end;

procedure CkCert_getSerialDecimal (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSerialDecimal(_map(55, 'CkCert_getSerialDecimal'))
    (objHandle, outPropVal);
end;

function CkCert__serialDecimal (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__serialDecimal(_map(56, 'CkCert__serialDecimal'))
    (objHandle);
end;

procedure CkCert_getSerialNumber (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSerialNumber(_map(57, 'CkCert_getSerialNumber'))
    (objHandle, outPropVal);
end;

function CkCert__serialNumber (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__serialNumber(_map(58, 'CkCert__serialNumber'))
    (objHandle);
end;

procedure CkCert_getSha1Thumbprint (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSha1Thumbprint(_map(59, 'CkCert_getSha1Thumbprint'))
    (objHandle, outPropVal);
end;

function CkCert__sha1Thumbprint (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__sha1Thumbprint(_map(60, 'CkCert__sha1Thumbprint'))
    (objHandle);
end;

function CkCert_getSignatureVerified (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getSignatureVerified(_map(61, 'CkCert_getSignatureVerified'))
    (objHandle);
end;

function CkCert_getSmartCardFailReason (objHandle: HCkCert): Integer;
begin
    result := TCkCert_getSmartCardFailReason(_map(62, 'CkCert_getSmartCardFailReason'))
    (objHandle);
end;

function CkCert_getSmartCardNoDialog (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getSmartCardNoDialog(_map(63, 'CkCert_getSmartCardNoDialog'))
    (objHandle);
end;

procedure CkCert_putSmartCardNoDialog (objHandle: HCkCert; newPropVal: wordbool);
begin
  TCkCert_putSmartCardNoDialog(_map(64, 'CkCert_putSmartCardNoDialog'))
    (objHandle, newPropVal);
end;

procedure CkCert_getSmartCardPin (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSmartCardPin(_map(65, 'CkCert_getSmartCardPin'))
    (objHandle, outPropVal);
end;

procedure CkCert_putSmartCardPin (objHandle: HCkCert; newPropVal: PWideChar);
begin
  TCkCert_putSmartCardPin(_map(66, 'CkCert_putSmartCardPin'))
    (objHandle, newPropVal);
end;

function CkCert__smartCardPin (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__smartCardPin(_map(67, 'CkCert__smartCardPin'))
    (objHandle);
end;

procedure CkCert_getSubjectAlternativeName (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectAlternativeName(_map(68, 'CkCert_getSubjectAlternativeName'))
    (objHandle, outPropVal);
end;

function CkCert__subjectAlternativeName (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectAlternativeName(_map(69, 'CkCert__subjectAlternativeName'))
    (objHandle);
end;

procedure CkCert_getSubjectC (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectC(_map(70, 'CkCert_getSubjectC'))
    (objHandle, outPropVal);
end;

function CkCert__subjectC (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectC(_map(71, 'CkCert__subjectC'))
    (objHandle);
end;

procedure CkCert_getSubjectCN (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectCN(_map(72, 'CkCert_getSubjectCN'))
    (objHandle, outPropVal);
end;

function CkCert__subjectCN (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectCN(_map(73, 'CkCert__subjectCN'))
    (objHandle);
end;

procedure CkCert_getSubjectDN (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectDN(_map(74, 'CkCert_getSubjectDN'))
    (objHandle, outPropVal);
end;

function CkCert__subjectDN (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectDN(_map(75, 'CkCert__subjectDN'))
    (objHandle);
end;

procedure CkCert_getSubjectE (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectE(_map(76, 'CkCert_getSubjectE'))
    (objHandle, outPropVal);
end;

function CkCert__subjectE (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectE(_map(77, 'CkCert__subjectE'))
    (objHandle);
end;

procedure CkCert_getSubjectKeyId (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectKeyId(_map(78, 'CkCert_getSubjectKeyId'))
    (objHandle, outPropVal);
end;

function CkCert__subjectKeyId (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectKeyId(_map(79, 'CkCert__subjectKeyId'))
    (objHandle);
end;

procedure CkCert_getSubjectL (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectL(_map(80, 'CkCert_getSubjectL'))
    (objHandle, outPropVal);
end;

function CkCert__subjectL (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectL(_map(81, 'CkCert__subjectL'))
    (objHandle);
end;

procedure CkCert_getSubjectO (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectO(_map(82, 'CkCert_getSubjectO'))
    (objHandle, outPropVal);
end;

function CkCert__subjectO (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectO(_map(83, 'CkCert__subjectO'))
    (objHandle);
end;

procedure CkCert_getSubjectOU (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectOU(_map(84, 'CkCert_getSubjectOU'))
    (objHandle, outPropVal);
end;

function CkCert__subjectOU (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectOU(_map(85, 'CkCert__subjectOU'))
    (objHandle);
end;

procedure CkCert_getSubjectS (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getSubjectS(_map(86, 'CkCert_getSubjectS'))
    (objHandle, outPropVal);
end;

function CkCert__subjectS (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__subjectS(_map(87, 'CkCert__subjectS'))
    (objHandle);
end;

function CkCert_getTrustedRoot (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getTrustedRoot(_map(88, 'CkCert_getTrustedRoot'))
    (objHandle);
end;

procedure CkCert_getUncommonOptions (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getUncommonOptions(_map(89, 'CkCert_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkCert_putUncommonOptions (objHandle: HCkCert; newPropVal: PWideChar);
begin
  TCkCert_putUncommonOptions(_map(90, 'CkCert_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkCert__uncommonOptions (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__uncommonOptions(_map(91, 'CkCert__uncommonOptions'))
    (objHandle);
end;

procedure CkCert_getValidFromStr (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getValidFromStr(_map(92, 'CkCert_getValidFromStr'))
    (objHandle, outPropVal);
end;

function CkCert__validFromStr (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__validFromStr(_map(93, 'CkCert__validFromStr'))
    (objHandle);
end;

procedure CkCert_getValidToStr (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getValidToStr(_map(94, 'CkCert_getValidToStr'))
    (objHandle, outPropVal);
end;

function CkCert__validToStr (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__validToStr(_map(95, 'CkCert__validToStr'))
    (objHandle);
end;

function CkCert_getVerboseLogging (objHandle: HCkCert): wordbool;
begin
    result := TCkCert_getVerboseLogging(_map(96, 'CkCert_getVerboseLogging'))
    (objHandle);
end;

procedure CkCert_putVerboseLogging (objHandle: HCkCert; newPropVal: wordbool);
begin
  TCkCert_putVerboseLogging(_map(97, 'CkCert_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCert_getVersion (objHandle: HCkCert; outPropVal: HCkString);
begin
  TCkCert_getVersion(_map(98, 'CkCert_getVersion'))
    (objHandle, outPropVal);
end;

function CkCert__version (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__version(_map(99, 'CkCert__version'))
    (objHandle);
end;

function CkCert_BuildCertChain (objHandle: HCkCert; certChain: HCkCertChain): wordbool;
begin
  result := TCkCert_BuildCertChain(_map(100, 'CkCert_BuildCertChain'))
    (objHandle, certChain);
end;

function CkCert_CheckRevoked (objHandle: HCkCert): Integer;
begin
  result := TCkCert_CheckRevoked(_map(101, 'CkCert_CheckRevoked'))
    (objHandle);
end;

function CkCert_CheckSmartCardPin (objHandle: HCkCert): Integer;
begin
  result := TCkCert_CheckSmartCardPin(_map(102, 'CkCert_CheckSmartCardPin'))
    (objHandle);
end;

function CkCert_ExportCertDer (objHandle: HCkCert; outData: HCkByteData): wordbool;
begin
  result := TCkCert_ExportCertDer(_map(103, 'CkCert_ExportCertDer'))
    (objHandle, outData);
end;

function CkCert_ExportCertDerBd (objHandle: HCkCert; cerData: HCkBinData): wordbool;
begin
  result := TCkCert_ExportCertDerBd(_map(104, 'CkCert_ExportCertDerBd'))
    (objHandle, cerData);
end;

function CkCert_ExportCertDerFile (objHandle: HCkCert; path: PWideChar): wordbool;
begin
  result := TCkCert_ExportCertDerFile(_map(105, 'CkCert_ExportCertDerFile'))
    (objHandle, path);
end;

function CkCert_ExportCertPem (objHandle: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkCert_ExportCertPem(_map(106, 'CkCert_ExportCertPem'))
    (objHandle, outStr);
end;

function CkCert__exportCertPem (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__exportCertPem(_map(107, 'CkCert__exportCertPem'))
    (objHandle);
end;

function CkCert_ExportCertPemFile (objHandle: HCkCert; path: PWideChar): wordbool;
begin
  result := TCkCert_ExportCertPemFile(_map(108, 'CkCert_ExportCertPemFile'))
    (objHandle, path);
end;

function CkCert_ExportCertXml (objHandle: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkCert_ExportCertXml(_map(109, 'CkCert_ExportCertXml'))
    (objHandle, outStr);
end;

function CkCert__exportCertXml (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__exportCertXml(_map(110, 'CkCert__exportCertXml'))
    (objHandle);
end;

function CkCert_ExportPrivateKey (objHandle: HCkCert): HCkPrivateKey;
begin
  result := TCkCert_ExportPrivateKey(_map(111, 'CkCert_ExportPrivateKey'))
    (objHandle);
end;

function CkCert_ExportPublicKey (objHandle: HCkCert): HCkPublicKey;
begin
  result := TCkCert_ExportPublicKey(_map(112, 'CkCert_ExportPublicKey'))
    (objHandle);
end;

function CkCert_ExportToPfxBd (objHandle: HCkCert; password: PWideChar; includeCertChain: wordbool; pfxData: HCkBinData): wordbool;
begin
  result := TCkCert_ExportToPfxBd(_map(113, 'CkCert_ExportToPfxBd'))
    (objHandle, password, includeCertChain, pfxData);
end;

function CkCert_ExportToPfxData (objHandle: HCkCert; password: PWideChar; includeCertChain: wordbool; outData: HCkByteData): wordbool;
begin
  result := TCkCert_ExportToPfxData(_map(114, 'CkCert_ExportToPfxData'))
    (objHandle, password, includeCertChain, outData);
end;

function CkCert_ExportToPfxFile (objHandle: HCkCert; pfxFilename: PWideChar; pfxPassword: PWideChar; bIncludeCertChain: wordbool): wordbool;
begin
  result := TCkCert_ExportToPfxFile(_map(115, 'CkCert_ExportToPfxFile'))
    (objHandle, pfxFilename, pfxPassword, bIncludeCertChain);
end;

function CkCert_FindIssuer (objHandle: HCkCert): HCkCert;
begin
  result := TCkCert_FindIssuer(_map(116, 'CkCert_FindIssuer'))
    (objHandle);
end;

function CkCert_GetCertChain (objHandle: HCkCert): HCkCertChain;
begin
  result := TCkCert_GetCertChain(_map(117, 'CkCert_GetCertChain'))
    (objHandle);
end;

function CkCert_GetEncoded (objHandle: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkCert_GetEncoded(_map(118, 'CkCert_GetEncoded'))
    (objHandle, outStr);
end;

function CkCert__getEncoded (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__getEncoded(_map(119, 'CkCert__getEncoded'))
    (objHandle);
end;

function CkCert_GetExtensionAsText (objHandle: HCkCert; oid: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCert_GetExtensionAsText(_map(120, 'CkCert_GetExtensionAsText'))
    (objHandle, oid, outStr);
end;

function CkCert__getExtensionAsText (objHandle: HCkCert; oid: PWideChar): PWideChar;
begin
  result := TCkCert__getExtensionAsText(_map(121, 'CkCert__getExtensionAsText'))
    (objHandle, oid);
end;

function CkCert_GetExtensionAsXml (objHandle: HCkCert; oid: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCert_GetExtensionAsXml(_map(122, 'CkCert_GetExtensionAsXml'))
    (objHandle, oid, outStr);
end;

function CkCert__getExtensionAsXml (objHandle: HCkCert; oid: PWideChar): PWideChar;
begin
  result := TCkCert__getExtensionAsXml(_map(123, 'CkCert__getExtensionAsXml'))
    (objHandle, oid);
end;

function CkCert_GetExtensionBd (objHandle: HCkCert; oid: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkCert_GetExtensionBd(_map(124, 'CkCert_GetExtensionBd'))
    (objHandle, oid, bd);
end;

function CkCert_GetIssuer (objHandle: HCkCert; issuer: HCkCert): wordbool;
begin
  result := TCkCert_GetIssuer(_map(125, 'CkCert_GetIssuer'))
    (objHandle, issuer);
end;

function CkCert_GetPrivateKey (objHandle: HCkCert; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkCert_GetPrivateKey(_map(126, 'CkCert_GetPrivateKey'))
    (objHandle, privKey);
end;

function CkCert_GetPrivateKeyPem (objHandle: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkCert_GetPrivateKeyPem(_map(127, 'CkCert_GetPrivateKeyPem'))
    (objHandle, outStr);
end;

function CkCert__getPrivateKeyPem (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__getPrivateKeyPem(_map(128, 'CkCert__getPrivateKeyPem'))
    (objHandle);
end;

function CkCert_GetPubKeyDer (objHandle: HCkCert; preferPkcs1: wordbool; bd: HCkBinData): wordbool;
begin
  result := TCkCert_GetPubKeyDer(_map(129, 'CkCert_GetPubKeyDer'))
    (objHandle, preferPkcs1, bd);
end;

function CkCert_GetPublicKey (objHandle: HCkCert; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkCert_GetPublicKey(_map(130, 'CkCert_GetPublicKey'))
    (objHandle, pubKey);
end;

function CkCert_GetSignature (objHandle: HCkCert; bd: HCkBinData): wordbool;
begin
  result := TCkCert_GetSignature(_map(131, 'CkCert_GetSignature'))
    (objHandle, bd);
end;

function CkCert_GetSpkiFingerprint (objHandle: HCkCert; hashAlg: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCert_GetSpkiFingerprint(_map(132, 'CkCert_GetSpkiFingerprint'))
    (objHandle, hashAlg, encoding, outStr);
end;

function CkCert__getSpkiFingerprint (objHandle: HCkCert; hashAlg: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkCert__getSpkiFingerprint(_map(133, 'CkCert__getSpkiFingerprint'))
    (objHandle, hashAlg, encoding);
end;

function CkCert_GetSubjectPart (objHandle: HCkCert; partNameOrOid: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCert_GetSubjectPart(_map(134, 'CkCert_GetSubjectPart'))
    (objHandle, partNameOrOid, outStr);
end;

function CkCert__getSubjectPart (objHandle: HCkCert; partNameOrOid: PWideChar): PWideChar;
begin
  result := TCkCert__getSubjectPart(_map(135, 'CkCert__getSubjectPart'))
    (objHandle, partNameOrOid);
end;

function CkCert_GetValidFromDt (objHandle: HCkCert): HCkDateTime;
begin
  result := TCkCert_GetValidFromDt(_map(136, 'CkCert_GetValidFromDt'))
    (objHandle);
end;

function CkCert_GetValidToDt (objHandle: HCkCert): HCkDateTime;
begin
  result := TCkCert_GetValidToDt(_map(137, 'CkCert_GetValidToDt'))
    (objHandle);
end;

function CkCert_HashOf (objHandle: HCkCert; part: PWideChar; hashAlg: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCert_HashOf(_map(138, 'CkCert_HashOf'))
    (objHandle, part, hashAlg, encoding, outStr);
end;

function CkCert__hashOf (objHandle: HCkCert; part: PWideChar; hashAlg: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkCert__hashOf(_map(139, 'CkCert__hashOf'))
    (objHandle, part, hashAlg, encoding);
end;

function CkCert_HasPrivateKey (objHandle: HCkCert): wordbool;
begin
  result := TCkCert_HasPrivateKey(_map(140, 'CkCert_HasPrivateKey'))
    (objHandle);
end;

function CkCert_IsEcdsa (objHandle: HCkCert): wordbool;
begin
  result := TCkCert_IsEcdsa(_map(141, 'CkCert_IsEcdsa'))
    (objHandle);
end;

function CkCert_IsRsa (objHandle: HCkCert): wordbool;
begin
  result := TCkCert_IsRsa(_map(142, 'CkCert_IsRsa'))
    (objHandle);
end;

function CkCert_LinkPkcs11 (objHandle: HCkCert; session: HCkPkcs11): wordbool;
begin
  result := TCkCert_LinkPkcs11(_map(143, 'CkCert_LinkPkcs11'))
    (objHandle, session);
end;

function CkCert_LoadByCommonName (objHandle: HCkCert; cn: PWideChar): wordbool;
begin
  result := TCkCert_LoadByCommonName(_map(144, 'CkCert_LoadByCommonName'))
    (objHandle, cn);
end;

function CkCert_LoadByEmailAddress (objHandle: HCkCert; emailAddress: PWideChar): wordbool;
begin
  result := TCkCert_LoadByEmailAddress(_map(145, 'CkCert_LoadByEmailAddress'))
    (objHandle, emailAddress);
end;

function CkCert_LoadByIssuerAndSerialNumber (objHandle: HCkCert; issuerCN: PWideChar; serialNumber: PWideChar): wordbool;
begin
  result := TCkCert_LoadByIssuerAndSerialNumber(_map(146, 'CkCert_LoadByIssuerAndSerialNumber'))
    (objHandle, issuerCN, serialNumber);
end;

function CkCert_LoadBySubjectOid (objHandle: HCkCert; oid: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkCert_LoadBySubjectOid(_map(147, 'CkCert_LoadBySubjectOid'))
    (objHandle, oid, value);
end;

function CkCert_LoadByThumbprint (objHandle: HCkCert; thumbprint: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkCert_LoadByThumbprint(_map(148, 'CkCert_LoadByThumbprint'))
    (objHandle, thumbprint, encoding);
end;

function CkCert_LoadFromBase64 (objHandle: HCkCert; encodedCert: PWideChar): wordbool;
begin
  result := TCkCert_LoadFromBase64(_map(149, 'CkCert_LoadFromBase64'))
    (objHandle, encodedCert);
end;

function CkCert_LoadFromBd (objHandle: HCkCert; certBytes: HCkBinData): wordbool;
begin
  result := TCkCert_LoadFromBd(_map(150, 'CkCert_LoadFromBd'))
    (objHandle, certBytes);
end;

function CkCert_LoadFromBinary (objHandle: HCkCert; data: HCkByteData): wordbool;
begin
  result := TCkCert_LoadFromBinary(_map(151, 'CkCert_LoadFromBinary'))
    (objHandle, data);
end;

function CkCert_LoadFromFile (objHandle: HCkCert; path: PWideChar): wordbool;
begin
  result := TCkCert_LoadFromFile(_map(152, 'CkCert_LoadFromFile'))
    (objHandle, path);
end;

function CkCert_LoadFromSmartcard (objHandle: HCkCert; certSpec: PWideChar): wordbool;
begin
  result := TCkCert_LoadFromSmartcard(_map(153, 'CkCert_LoadFromSmartcard'))
    (objHandle, certSpec);
end;

function CkCert_LoadPem (objHandle: HCkCert; strPem: PWideChar): wordbool;
begin
  result := TCkCert_LoadPem(_map(154, 'CkCert_LoadPem'))
    (objHandle, strPem);
end;

function CkCert_LoadPfxBd (objHandle: HCkCert; pfxData: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkCert_LoadPfxBd(_map(155, 'CkCert_LoadPfxBd'))
    (objHandle, pfxData, password);
end;

function CkCert_LoadPfxData (objHandle: HCkCert; pfxData: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkCert_LoadPfxData(_map(156, 'CkCert_LoadPfxData'))
    (objHandle, pfxData, password);
end;

function CkCert_LoadPfxFile (objHandle: HCkCert; pfxPath: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkCert_LoadPfxFile(_map(157, 'CkCert_LoadPfxFile'))
    (objHandle, pfxPath, password);
end;

function CkCert_LoadTaskResult (objHandle: HCkCert; task: HCkTask): wordbool;
begin
  result := TCkCert_LoadTaskResult(_map(158, 'CkCert_LoadTaskResult'))
    (objHandle, task);
end;

function CkCert_PemFileToDerFile (objHandle: HCkCert; fromPath: PWideChar; toPath: PWideChar): wordbool;
begin
  result := TCkCert_PemFileToDerFile(_map(159, 'CkCert_PemFileToDerFile'))
    (objHandle, fromPath, toPath);
end;

function CkCert_SaveToFile (objHandle: HCkCert; path: PWideChar): wordbool;
begin
  result := TCkCert_SaveToFile(_map(160, 'CkCert_SaveToFile'))
    (objHandle, path);
end;

function CkCert_SetCloudSigner (objHandle: HCkCert; json: HCkJsonObject): wordbool;
begin
  result := TCkCert_SetCloudSigner(_map(161, 'CkCert_SetCloudSigner'))
    (objHandle, json);
end;

function CkCert_SetCloudSignerAsync (objHandle: HCkCert; json: HCkJsonObject): HCkTask;
begin
  result := TCkCert_SetCloudSignerAsync(_map(162, 'CkCert_SetCloudSignerAsync'))
    (objHandle, json);
end;

function CkCert_SetFromEncoded (objHandle: HCkCert; encodedCert: PWideChar): wordbool;
begin
  result := TCkCert_SetFromEncoded(_map(163, 'CkCert_SetFromEncoded'))
    (objHandle, encodedCert);
end;

function CkCert_SetPrivateKey (objHandle: HCkCert; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkCert_SetPrivateKey(_map(164, 'CkCert_SetPrivateKey'))
    (objHandle, privKey);
end;

function CkCert_SetPrivateKeyPem (objHandle: HCkCert; privKeyPem: PWideChar): wordbool;
begin
  result := TCkCert_SetPrivateKeyPem(_map(165, 'CkCert_SetPrivateKeyPem'))
    (objHandle, privKeyPem);
end;

function CkCert_Unload (objHandle: HCkCert): wordbool;
begin
  result := TCkCert_Unload(_map(166, 'CkCert_Unload'))
    (objHandle);
end;

function CkCert_UploadToCloud (objHandle: HCkCert; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
begin
  result := TCkCert_UploadToCloud(_map(167, 'CkCert_UploadToCloud'))
    (objHandle, jsonIn, jsonOut);
end;

function CkCert_UploadToCloudAsync (objHandle: HCkCert; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
begin
  result := TCkCert_UploadToCloudAsync(_map(168, 'CkCert_UploadToCloudAsync'))
    (objHandle, jsonIn, jsonOut);
end;

function CkCert_UseCertVault (objHandle: HCkCert; vault: HCkXmlCertVault): wordbool;
begin
  result := TCkCert_UseCertVault(_map(169, 'CkCert_UseCertVault'))
    (objHandle, vault);
end;

function CkCert_VerifySignature (objHandle: HCkCert): wordbool;
begin
  result := TCkCert_VerifySignature(_map(170, 'CkCert_VerifySignature'))
    (objHandle);
end;

function CkCert_X509PKIPathv1 (objHandle: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkCert_X509PKIPathv1(_map(171, 'CkCert_X509PKIPathv1'))
    (objHandle, outStr);
end;

function CkCert__x509PKIPathv1 (objHandle: HCkCert): PWideChar;
begin
  result := TCkCert__x509PKIPathv1(_map(172, 'CkCert__x509PKIPathv1'))
    (objHandle);
end;

end.
