unit CertStore;

interface

type

HCkCertStore = Pointer;
HCkCert = Pointer;
HCkBinData = Pointer;
HCkJsonObject = Pointer;
HCkString = Pointer;


function CkCertStore_Create: HCkCertStore;  stdcall;
procedure CkCertStore_Dispose(handle: HCkCertStore); stdcall;
function CkCertStore_getAvoidWindowsPkAccess(objHandle: HCkCertStore): wordbool;
procedure CkCertStore_putAvoidWindowsPkAccess(objHandle: HCkCertStore; newPropVal: wordbool);
procedure CkCertStore_getDebugLogFilePath(objHandle: HCkCertStore; outPropVal: HCkString);
procedure CkCertStore_putDebugLogFilePath(objHandle: HCkCertStore; newPropVal: PWideChar);
function CkCertStore__debugLogFilePath(objHandle: HCkCertStore): PWideChar;
procedure CkCertStore_getLastErrorHtml(objHandle: HCkCertStore; outPropVal: HCkString);
function CkCertStore__lastErrorHtml(objHandle: HCkCertStore): PWideChar;
procedure CkCertStore_getLastErrorText(objHandle: HCkCertStore; outPropVal: HCkString);
function CkCertStore__lastErrorText(objHandle: HCkCertStore): PWideChar;
procedure CkCertStore_getLastErrorXml(objHandle: HCkCertStore; outPropVal: HCkString);
function CkCertStore__lastErrorXml(objHandle: HCkCertStore): PWideChar;
function CkCertStore_getLastMethodSuccess(objHandle: HCkCertStore): wordbool;
procedure CkCertStore_putLastMethodSuccess(objHandle: HCkCertStore; newPropVal: wordbool);
function CkCertStore_getNumCertificates(objHandle: HCkCertStore): Integer;
procedure CkCertStore_getSmartCardPin(objHandle: HCkCertStore; outPropVal: HCkString);
procedure CkCertStore_putSmartCardPin(objHandle: HCkCertStore; newPropVal: PWideChar);
function CkCertStore__smartCardPin(objHandle: HCkCertStore): PWideChar;
procedure CkCertStore_getUncommonOptions(objHandle: HCkCertStore; outPropVal: HCkString);
procedure CkCertStore_putUncommonOptions(objHandle: HCkCertStore; newPropVal: PWideChar);
function CkCertStore__uncommonOptions(objHandle: HCkCertStore): PWideChar;
function CkCertStore_getVerboseLogging(objHandle: HCkCertStore): wordbool;
procedure CkCertStore_putVerboseLogging(objHandle: HCkCertStore; newPropVal: wordbool);
procedure CkCertStore_getVersion(objHandle: HCkCertStore; outPropVal: HCkString);
function CkCertStore__version(objHandle: HCkCertStore): PWideChar;
function CkCertStore_AddCertificate(objHandle: HCkCertStore; cert: HCkCert): wordbool;
function CkCertStore_CloseCertStore(objHandle: HCkCertStore): wordbool;
function CkCertStore_CreateFileStore(objHandle: HCkCertStore; filename: PWideChar): wordbool;
function CkCertStore_CreateMemoryStore(objHandle: HCkCertStore): wordbool;
function CkCertStore_CreateRegistryStore(objHandle: HCkCertStore; regRoot: PWideChar; regPath: PWideChar): wordbool;
function CkCertStore_FindCert(objHandle: HCkCertStore; json: HCkJsonObject; cert: HCkCert): wordbool;
function CkCertStore_GetCert(objHandle: HCkCertStore; index: Integer; cert: HCkCert): wordbool;
function CkCertStore_LoadPemFile(objHandle: HCkCertStore; pemPath: PWideChar): wordbool;
function CkCertStore_LoadPemStr(objHandle: HCkCertStore; pemString: PWideChar): wordbool;
function CkCertStore_LoadPfxBd(objHandle: HCkCertStore; bd: HCkBinData; password: PWideChar): wordbool;
function CkCertStore_LoadPfxFile(objHandle: HCkCertStore; pfxFilename: PWideChar; password: PWideChar): wordbool;
function CkCertStore_OpenCurrentUserStore(objHandle: HCkCertStore; readOnly: wordbool): wordbool;
function CkCertStore_OpenFileStore(objHandle: HCkCertStore; filename: PWideChar; readOnly: wordbool): wordbool;
function CkCertStore_OpenLocalSystemStore(objHandle: HCkCertStore; readOnly: wordbool): wordbool;
function CkCertStore_OpenRegistryStore(objHandle: HCkCertStore; regRoot: PWideChar; regPath: PWideChar; readOnly: wordbool): wordbool;
function CkCertStore_OpenSmartcard(objHandle: HCkCertStore; csp: PWideChar): wordbool;
function CkCertStore_OpenWindowsStore(objHandle: HCkCertStore; storeLocation: PWideChar; storeName: PWideChar; readOnly: wordbool): wordbool;
function CkCertStore_RemoveCertificate(objHandle: HCkCertStore; cert: HCkCert): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCertStore_Create = function : HCkCertStore; stdcall;
  TCkCertStore_Dispose = procedure (handle: HCkCertStore); stdcall;
  TCkCertStore_getAvoidWindowsPkAccess = function (objHandle: HCkCertStore): wordbool; stdcall;
  TCkCertStore_putAvoidWindowsPkAccess = procedure (objHandle: HCkCertStore; newPropVal: wordbool); stdcall;
  TCkCertStore_getDebugLogFilePath = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore_putDebugLogFilePath = procedure (objHandle: HCkCertStore; newPropVal: PWideChar); stdcall;
  TCkCertStore__debugLogFilePath = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_getLastErrorHtml = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore__lastErrorHtml = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_getLastErrorText = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore__lastErrorText = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_getLastErrorXml = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore__lastErrorXml = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_getLastMethodSuccess = function (objHandle: HCkCertStore): wordbool; stdcall;
  TCkCertStore_putLastMethodSuccess = procedure (objHandle: HCkCertStore; newPropVal: wordbool); stdcall;
  TCkCertStore_getNumCertificates = function (objHandle: HCkCertStore): Integer; stdcall;
  TCkCertStore_getSmartCardPin = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore_putSmartCardPin = procedure (objHandle: HCkCertStore; newPropVal: PWideChar); stdcall;
  TCkCertStore__smartCardPin = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_getUncommonOptions = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore_putUncommonOptions = procedure (objHandle: HCkCertStore; newPropVal: PWideChar); stdcall;
  TCkCertStore__uncommonOptions = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_getVerboseLogging = function (objHandle: HCkCertStore): wordbool; stdcall;
  TCkCertStore_putVerboseLogging = procedure (objHandle: HCkCertStore; newPropVal: wordbool); stdcall;
  TCkCertStore_getVersion = procedure (objHandle: HCkCertStore; outPropVal: HCkString); stdcall;
  TCkCertStore__version = function (objHandle: HCkCertStore): PWideChar; stdcall;
  TCkCertStore_AddCertificate = function (objHandle: HCkCertStore; cert: HCkCert): wordbool; stdcall;
  TCkCertStore_CloseCertStore = function (objHandle: HCkCertStore): wordbool; stdcall;
  TCkCertStore_CreateFileStore = function (objHandle: HCkCertStore; filename: PWideChar): wordbool; stdcall;
  TCkCertStore_CreateMemoryStore = function (objHandle: HCkCertStore): wordbool; stdcall;
  TCkCertStore_CreateRegistryStore = function (objHandle: HCkCertStore; regRoot: PWideChar; regPath: PWideChar): wordbool; stdcall;
  TCkCertStore_FindCert = function (objHandle: HCkCertStore; json: HCkJsonObject; cert: HCkCert): wordbool; stdcall;
  TCkCertStore_GetCert = function (objHandle: HCkCertStore; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkCertStore_LoadPemFile = function (objHandle: HCkCertStore; pemPath: PWideChar): wordbool; stdcall;
  TCkCertStore_LoadPemStr = function (objHandle: HCkCertStore; pemString: PWideChar): wordbool; stdcall;
  TCkCertStore_LoadPfxBd = function (objHandle: HCkCertStore; bd: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkCertStore_LoadPfxFile = function (objHandle: HCkCertStore; pfxFilename: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkCertStore_OpenCurrentUserStore = function (objHandle: HCkCertStore; readOnly: wordbool): wordbool; stdcall;
  TCkCertStore_OpenFileStore = function (objHandle: HCkCertStore; filename: PWideChar; readOnly: wordbool): wordbool; stdcall;
  TCkCertStore_OpenLocalSystemStore = function (objHandle: HCkCertStore; readOnly: wordbool): wordbool; stdcall;
  TCkCertStore_OpenRegistryStore = function (objHandle: HCkCertStore; regRoot: PWideChar; regPath: PWideChar; readOnly: wordbool): wordbool; stdcall;
  TCkCertStore_OpenSmartcard = function (objHandle: HCkCertStore; csp: PWideChar): wordbool; stdcall;
  TCkCertStore_OpenWindowsStore = function (objHandle: HCkCertStore; storeLocation: PWideChar; storeName: PWideChar; readOnly: wordbool): wordbool; stdcall;
  TCkCertStore_RemoveCertificate = function (objHandle: HCkCertStore; cert: HCkCert): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..43] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCertStore_Create : HCkCertStore;
begin
  result := TCkCertStore_Create(_map(0, 'CkCertStore_Create'));
end;

procedure CkCertStore_Dispose (handle: HCkCertStore);
begin
  TCkCertStore_Dispose(_map(1, 'CkCertStore_Dispose'))
    (handle);
end;


function CkCertStore_getAvoidWindowsPkAccess (objHandle: HCkCertStore): wordbool;
begin
    result := TCkCertStore_getAvoidWindowsPkAccess(_map(2, 'CkCertStore_getAvoidWindowsPkAccess'))
    (objHandle);
end;

procedure CkCertStore_putAvoidWindowsPkAccess (objHandle: HCkCertStore; newPropVal: wordbool);
begin
  TCkCertStore_putAvoidWindowsPkAccess(_map(3, 'CkCertStore_putAvoidWindowsPkAccess'))
    (objHandle, newPropVal);
end;

procedure CkCertStore_getDebugLogFilePath (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getDebugLogFilePath(_map(4, 'CkCertStore_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCertStore_putDebugLogFilePath (objHandle: HCkCertStore; newPropVal: PWideChar);
begin
  TCkCertStore_putDebugLogFilePath(_map(5, 'CkCertStore_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCertStore__debugLogFilePath (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__debugLogFilePath(_map(6, 'CkCertStore__debugLogFilePath'))
    (objHandle);
end;

procedure CkCertStore_getLastErrorHtml (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getLastErrorHtml(_map(7, 'CkCertStore_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCertStore__lastErrorHtml (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__lastErrorHtml(_map(8, 'CkCertStore__lastErrorHtml'))
    (objHandle);
end;

procedure CkCertStore_getLastErrorText (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getLastErrorText(_map(9, 'CkCertStore_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCertStore__lastErrorText (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__lastErrorText(_map(10, 'CkCertStore__lastErrorText'))
    (objHandle);
end;

procedure CkCertStore_getLastErrorXml (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getLastErrorXml(_map(11, 'CkCertStore_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCertStore__lastErrorXml (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__lastErrorXml(_map(12, 'CkCertStore__lastErrorXml'))
    (objHandle);
end;

function CkCertStore_getLastMethodSuccess (objHandle: HCkCertStore): wordbool;
begin
    result := TCkCertStore_getLastMethodSuccess(_map(13, 'CkCertStore_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCertStore_putLastMethodSuccess (objHandle: HCkCertStore; newPropVal: wordbool);
begin
  TCkCertStore_putLastMethodSuccess(_map(14, 'CkCertStore_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkCertStore_getNumCertificates (objHandle: HCkCertStore): Integer;
begin
    result := TCkCertStore_getNumCertificates(_map(15, 'CkCertStore_getNumCertificates'))
    (objHandle);
end;

procedure CkCertStore_getSmartCardPin (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getSmartCardPin(_map(16, 'CkCertStore_getSmartCardPin'))
    (objHandle, outPropVal);
end;

procedure CkCertStore_putSmartCardPin (objHandle: HCkCertStore; newPropVal: PWideChar);
begin
  TCkCertStore_putSmartCardPin(_map(17, 'CkCertStore_putSmartCardPin'))
    (objHandle, newPropVal);
end;

function CkCertStore__smartCardPin (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__smartCardPin(_map(18, 'CkCertStore__smartCardPin'))
    (objHandle);
end;

procedure CkCertStore_getUncommonOptions (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getUncommonOptions(_map(19, 'CkCertStore_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkCertStore_putUncommonOptions (objHandle: HCkCertStore; newPropVal: PWideChar);
begin
  TCkCertStore_putUncommonOptions(_map(20, 'CkCertStore_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkCertStore__uncommonOptions (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__uncommonOptions(_map(21, 'CkCertStore__uncommonOptions'))
    (objHandle);
end;

function CkCertStore_getVerboseLogging (objHandle: HCkCertStore): wordbool;
begin
    result := TCkCertStore_getVerboseLogging(_map(22, 'CkCertStore_getVerboseLogging'))
    (objHandle);
end;

procedure CkCertStore_putVerboseLogging (objHandle: HCkCertStore; newPropVal: wordbool);
begin
  TCkCertStore_putVerboseLogging(_map(23, 'CkCertStore_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCertStore_getVersion (objHandle: HCkCertStore; outPropVal: HCkString);
begin
  TCkCertStore_getVersion(_map(24, 'CkCertStore_getVersion'))
    (objHandle, outPropVal);
end;

function CkCertStore__version (objHandle: HCkCertStore): PWideChar;
begin
  result := TCkCertStore__version(_map(25, 'CkCertStore__version'))
    (objHandle);
end;

function CkCertStore_AddCertificate (objHandle: HCkCertStore; cert: HCkCert): wordbool;
begin
  result := TCkCertStore_AddCertificate(_map(26, 'CkCertStore_AddCertificate'))
    (objHandle, cert);
end;

function CkCertStore_CloseCertStore (objHandle: HCkCertStore): wordbool;
begin
  result := TCkCertStore_CloseCertStore(_map(27, 'CkCertStore_CloseCertStore'))
    (objHandle);
end;

function CkCertStore_CreateFileStore (objHandle: HCkCertStore; filename: PWideChar): wordbool;
begin
  result := TCkCertStore_CreateFileStore(_map(28, 'CkCertStore_CreateFileStore'))
    (objHandle, filename);
end;

function CkCertStore_CreateMemoryStore (objHandle: HCkCertStore): wordbool;
begin
  result := TCkCertStore_CreateMemoryStore(_map(29, 'CkCertStore_CreateMemoryStore'))
    (objHandle);
end;

function CkCertStore_CreateRegistryStore (objHandle: HCkCertStore; regRoot: PWideChar; regPath: PWideChar): wordbool;
begin
  result := TCkCertStore_CreateRegistryStore(_map(30, 'CkCertStore_CreateRegistryStore'))
    (objHandle, regRoot, regPath);
end;

function CkCertStore_FindCert (objHandle: HCkCertStore; json: HCkJsonObject; cert: HCkCert): wordbool;
begin
  result := TCkCertStore_FindCert(_map(31, 'CkCertStore_FindCert'))
    (objHandle, json, cert);
end;

function CkCertStore_GetCert (objHandle: HCkCertStore; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkCertStore_GetCert(_map(32, 'CkCertStore_GetCert'))
    (objHandle, index, cert);
end;

function CkCertStore_LoadPemFile (objHandle: HCkCertStore; pemPath: PWideChar): wordbool;
begin
  result := TCkCertStore_LoadPemFile(_map(33, 'CkCertStore_LoadPemFile'))
    (objHandle, pemPath);
end;

function CkCertStore_LoadPemStr (objHandle: HCkCertStore; pemString: PWideChar): wordbool;
begin
  result := TCkCertStore_LoadPemStr(_map(34, 'CkCertStore_LoadPemStr'))
    (objHandle, pemString);
end;

function CkCertStore_LoadPfxBd (objHandle: HCkCertStore; bd: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkCertStore_LoadPfxBd(_map(35, 'CkCertStore_LoadPfxBd'))
    (objHandle, bd, password);
end;

function CkCertStore_LoadPfxFile (objHandle: HCkCertStore; pfxFilename: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkCertStore_LoadPfxFile(_map(36, 'CkCertStore_LoadPfxFile'))
    (objHandle, pfxFilename, password);
end;

function CkCertStore_OpenCurrentUserStore (objHandle: HCkCertStore; readOnly: wordbool): wordbool;
begin
  result := TCkCertStore_OpenCurrentUserStore(_map(37, 'CkCertStore_OpenCurrentUserStore'))
    (objHandle, readOnly);
end;

function CkCertStore_OpenFileStore (objHandle: HCkCertStore; filename: PWideChar; readOnly: wordbool): wordbool;
begin
  result := TCkCertStore_OpenFileStore(_map(38, 'CkCertStore_OpenFileStore'))
    (objHandle, filename, readOnly);
end;

function CkCertStore_OpenLocalSystemStore (objHandle: HCkCertStore; readOnly: wordbool): wordbool;
begin
  result := TCkCertStore_OpenLocalSystemStore(_map(39, 'CkCertStore_OpenLocalSystemStore'))
    (objHandle, readOnly);
end;

function CkCertStore_OpenRegistryStore (objHandle: HCkCertStore; regRoot: PWideChar; regPath: PWideChar; readOnly: wordbool): wordbool;
begin
  result := TCkCertStore_OpenRegistryStore(_map(40, 'CkCertStore_OpenRegistryStore'))
    (objHandle, regRoot, regPath, readOnly);
end;

function CkCertStore_OpenSmartcard (objHandle: HCkCertStore; csp: PWideChar): wordbool;
begin
  result := TCkCertStore_OpenSmartcard(_map(41, 'CkCertStore_OpenSmartcard'))
    (objHandle, csp);
end;

function CkCertStore_OpenWindowsStore (objHandle: HCkCertStore; storeLocation: PWideChar; storeName: PWideChar; readOnly: wordbool): wordbool;
begin
  result := TCkCertStore_OpenWindowsStore(_map(42, 'CkCertStore_OpenWindowsStore'))
    (objHandle, storeLocation, storeName, readOnly);
end;

function CkCertStore_RemoveCertificate (objHandle: HCkCertStore; cert: HCkCert): wordbool;
begin
  result := TCkCertStore_RemoveCertificate(_map(43, 'CkCertStore_RemoveCertificate'))
    (objHandle, cert);
end;

end.
