unit Charset;

interface

type

HCkCharset = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


function CkCharset_Create: HCkCharset;  stdcall;
procedure CkCharset_Dispose(handle: HCkCharset); stdcall;
procedure CkCharset_getAltToCharset(objHandle: HCkCharset; outPropVal: HCkString);
procedure CkCharset_putAltToCharset(objHandle: HCkCharset; newPropVal: PWideChar);
function CkCharset__altToCharset(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getDebugLogFilePath(objHandle: HCkCharset; outPropVal: HCkString);
procedure CkCharset_putDebugLogFilePath(objHandle: HCkCharset; newPropVal: PWideChar);
function CkCharset__debugLogFilePath(objHandle: HCkCharset): PWideChar;
function CkCharset_getErrorAction(objHandle: HCkCharset): Integer;
procedure CkCharset_putErrorAction(objHandle: HCkCharset; newPropVal: Integer);
procedure CkCharset_getFromCharset(objHandle: HCkCharset; outPropVal: HCkString);
procedure CkCharset_putFromCharset(objHandle: HCkCharset; newPropVal: PWideChar);
function CkCharset__fromCharset(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getLastErrorHtml(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastErrorHtml(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getLastErrorText(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastErrorText(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getLastErrorXml(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastErrorXml(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getLastInputAsHex(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastInputAsHex(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getLastInputAsQP(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastInputAsQP(objHandle: HCkCharset): PWideChar;
function CkCharset_getLastMethodSuccess(objHandle: HCkCharset): wordbool;
procedure CkCharset_putLastMethodSuccess(objHandle: HCkCharset; newPropVal: wordbool);
procedure CkCharset_getLastOutputAsHex(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastOutputAsHex(objHandle: HCkCharset): PWideChar;
procedure CkCharset_getLastOutputAsQP(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__lastOutputAsQP(objHandle: HCkCharset): PWideChar;
function CkCharset_getSaveLast(objHandle: HCkCharset): wordbool;
procedure CkCharset_putSaveLast(objHandle: HCkCharset; newPropVal: wordbool);
procedure CkCharset_getToCharset(objHandle: HCkCharset; outPropVal: HCkString);
procedure CkCharset_putToCharset(objHandle: HCkCharset; newPropVal: PWideChar);
function CkCharset__toCharset(objHandle: HCkCharset): PWideChar;
function CkCharset_getVerboseLogging(objHandle: HCkCharset): wordbool;
procedure CkCharset_putVerboseLogging(objHandle: HCkCharset; newPropVal: wordbool);
procedure CkCharset_getVersion(objHandle: HCkCharset; outPropVal: HCkString);
function CkCharset__version(objHandle: HCkCharset): PWideChar;
function CkCharset_CharsetToCodePage(objHandle: HCkCharset; charsetName: PWideChar): Integer;
function CkCharset_CodePageToCharset(objHandle: HCkCharset; codePage: Integer; outStr: HCkString): wordbool;
function CkCharset__codePageToCharset(objHandle: HCkCharset; codePage: Integer): PWideChar;
function CkCharset_ConvertData(objHandle: HCkCharset; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkCharset_ConvertFile(objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
function CkCharset_ConvertFileNoPreamble(objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
function CkCharset_ConvertFromUnicode(objHandle: HCkCharset; inData: PWideChar; outData: HCkByteData): wordbool;
function CkCharset_ConvertFromUtf16(objHandle: HCkCharset; uniData: HCkByteData; outData: HCkByteData): wordbool;
function CkCharset_ConvertHtml(objHandle: HCkCharset; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkCharset_ConvertHtmlFile(objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
function CkCharset_ConvertToUnicode(objHandle: HCkCharset; inData: HCkByteData; outStr: HCkString): wordbool;
function CkCharset__convertToUnicode(objHandle: HCkCharset; inData: HCkByteData): PWideChar;
function CkCharset_ConvertToUtf16(objHandle: HCkCharset; mbData: HCkByteData; outData: HCkByteData): wordbool;
function CkCharset_EntityEncodeDec(objHandle: HCkCharset; str: PWideChar; outStr: HCkString): wordbool;
function CkCharset__entityEncodeDec(objHandle: HCkCharset; str: PWideChar): PWideChar;
function CkCharset_EntityEncodeHex(objHandle: HCkCharset; str: PWideChar; outStr: HCkString): wordbool;
function CkCharset__entityEncodeHex(objHandle: HCkCharset; str: PWideChar): PWideChar;
function CkCharset_GetHtmlCharset(objHandle: HCkCharset; inData: HCkByteData; outStr: HCkString): wordbool;
function CkCharset__getHtmlCharset(objHandle: HCkCharset; inData: HCkByteData): PWideChar;
function CkCharset_GetHtmlFileCharset(objHandle: HCkCharset; htmlFilePath: PWideChar; outStr: HCkString): wordbool;
function CkCharset__getHtmlFileCharset(objHandle: HCkCharset; htmlFilePath: PWideChar): PWideChar;
function CkCharset_HtmlDecodeToStr(objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
function CkCharset__htmlDecodeToStr(objHandle: HCkCharset; inStr: PWideChar): PWideChar;
function CkCharset_HtmlEntityDecode(objHandle: HCkCharset; inHtml: HCkByteData; outData: HCkByteData): wordbool;
function CkCharset_HtmlEntityDecodeFile(objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
function CkCharset_LowerCase(objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
function CkCharset__lowerCase(objHandle: HCkCharset; inStr: PWideChar): PWideChar;
function CkCharset_ReadFile(objHandle: HCkCharset; path: PWideChar; outData: HCkByteData): wordbool;
function CkCharset_ReadFileToString(objHandle: HCkCharset; path: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkCharset__readFileToString(objHandle: HCkCharset; path: PWideChar; charset: PWideChar): PWideChar;
procedure CkCharset_SetErrorString(objHandle: HCkCharset; str: PWideChar; charset: PWideChar);
function CkCharset_UpperCase(objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
function CkCharset__upperCase(objHandle: HCkCharset; inStr: PWideChar): PWideChar;
function CkCharset_UrlDecodeStr(objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
function CkCharset__urlDecodeStr(objHandle: HCkCharset; inStr: PWideChar): PWideChar;
function CkCharset_VerifyData(objHandle: HCkCharset; charset: PWideChar; inData: HCkByteData): wordbool;
function CkCharset_VerifyFile(objHandle: HCkCharset; charset: PWideChar; path: PWideChar): wordbool;
function CkCharset_WriteFile(objHandle: HCkCharset; path: PWideChar; byteData: HCkByteData): wordbool;
function CkCharset_WriteStringToFile(objHandle: HCkCharset; textData: PWideChar; path: PWideChar; charset: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCharset_Create = function : HCkCharset; stdcall;
  TCkCharset_Dispose = procedure (handle: HCkCharset); stdcall;
  TCkCharset_getAltToCharset = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset_putAltToCharset = procedure (objHandle: HCkCharset; newPropVal: PWideChar); stdcall;
  TCkCharset__altToCharset = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getDebugLogFilePath = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset_putDebugLogFilePath = procedure (objHandle: HCkCharset; newPropVal: PWideChar); stdcall;
  TCkCharset__debugLogFilePath = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getErrorAction = function (objHandle: HCkCharset): Integer; stdcall;
  TCkCharset_putErrorAction = procedure (objHandle: HCkCharset; newPropVal: Integer); stdcall;
  TCkCharset_getFromCharset = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset_putFromCharset = procedure (objHandle: HCkCharset; newPropVal: PWideChar); stdcall;
  TCkCharset__fromCharset = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastErrorHtml = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastErrorHtml = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastErrorText = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastErrorText = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastErrorXml = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastErrorXml = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastInputAsHex = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastInputAsHex = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastInputAsQP = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastInputAsQP = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastMethodSuccess = function (objHandle: HCkCharset): wordbool; stdcall;
  TCkCharset_putLastMethodSuccess = procedure (objHandle: HCkCharset; newPropVal: wordbool); stdcall;
  TCkCharset_getLastOutputAsHex = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastOutputAsHex = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getLastOutputAsQP = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__lastOutputAsQP = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getSaveLast = function (objHandle: HCkCharset): wordbool; stdcall;
  TCkCharset_putSaveLast = procedure (objHandle: HCkCharset; newPropVal: wordbool); stdcall;
  TCkCharset_getToCharset = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset_putToCharset = procedure (objHandle: HCkCharset; newPropVal: PWideChar); stdcall;
  TCkCharset__toCharset = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_getVerboseLogging = function (objHandle: HCkCharset): wordbool; stdcall;
  TCkCharset_putVerboseLogging = procedure (objHandle: HCkCharset; newPropVal: wordbool); stdcall;
  TCkCharset_getVersion = procedure (objHandle: HCkCharset; outPropVal: HCkString); stdcall;
  TCkCharset__version = function (objHandle: HCkCharset): PWideChar; stdcall;
  TCkCharset_CharsetToCodePage = function (objHandle: HCkCharset; charsetName: PWideChar): Integer; stdcall;
  TCkCharset_CodePageToCharset = function (objHandle: HCkCharset; codePage: Integer; outStr: HCkString): wordbool; stdcall;
  TCkCharset__codePageToCharset = function (objHandle: HCkCharset; codePage: Integer): PWideChar; stdcall;
  TCkCharset_ConvertData = function (objHandle: HCkCharset; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_ConvertFile = function (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCharset_ConvertFileNoPreamble = function (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCharset_ConvertFromUnicode = function (objHandle: HCkCharset; inData: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_ConvertFromUtf16 = function (objHandle: HCkCharset; uniData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_ConvertHtml = function (objHandle: HCkCharset; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_ConvertHtmlFile = function (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCharset_ConvertToUnicode = function (objHandle: HCkCharset; inData: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCharset__convertToUnicode = function (objHandle: HCkCharset; inData: HCkByteData): PWideChar; stdcall;
  TCkCharset_ConvertToUtf16 = function (objHandle: HCkCharset; mbData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_EntityEncodeDec = function (objHandle: HCkCharset; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__entityEncodeDec = function (objHandle: HCkCharset; str: PWideChar): PWideChar; stdcall;
  TCkCharset_EntityEncodeHex = function (objHandle: HCkCharset; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__entityEncodeHex = function (objHandle: HCkCharset; str: PWideChar): PWideChar; stdcall;
  TCkCharset_GetHtmlCharset = function (objHandle: HCkCharset; inData: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCharset__getHtmlCharset = function (objHandle: HCkCharset; inData: HCkByteData): PWideChar; stdcall;
  TCkCharset_GetHtmlFileCharset = function (objHandle: HCkCharset; htmlFilePath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__getHtmlFileCharset = function (objHandle: HCkCharset; htmlFilePath: PWideChar): PWideChar; stdcall;
  TCkCharset_HtmlDecodeToStr = function (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__htmlDecodeToStr = function (objHandle: HCkCharset; inStr: PWideChar): PWideChar; stdcall;
  TCkCharset_HtmlEntityDecode = function (objHandle: HCkCharset; inHtml: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_HtmlEntityDecodeFile = function (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCharset_LowerCase = function (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__lowerCase = function (objHandle: HCkCharset; inStr: PWideChar): PWideChar; stdcall;
  TCkCharset_ReadFile = function (objHandle: HCkCharset; path: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCharset_ReadFileToString = function (objHandle: HCkCharset; path: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__readFileToString = function (objHandle: HCkCharset; path: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkCharset_SetErrorString = procedure (objHandle: HCkCharset; str: PWideChar; charset: PWideChar); stdcall;
  TCkCharset_UpperCase = function (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__upperCase = function (objHandle: HCkCharset; inStr: PWideChar): PWideChar; stdcall;
  TCkCharset_UrlDecodeStr = function (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCharset__urlDecodeStr = function (objHandle: HCkCharset; inStr: PWideChar): PWideChar; stdcall;
  TCkCharset_VerifyData = function (objHandle: HCkCharset; charset: PWideChar; inData: HCkByteData): wordbool; stdcall;
  TCkCharset_VerifyFile = function (objHandle: HCkCharset; charset: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkCharset_WriteFile = function (objHandle: HCkCharset; path: PWideChar; byteData: HCkByteData): wordbool; stdcall;
  TCkCharset_WriteStringToFile = function (objHandle: HCkCharset; textData: PWideChar; path: PWideChar; charset: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..76] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCharset_Create : HCkCharset;
begin
  result := TCkCharset_Create(_map(0, 'CkCharset_Create'));
end;

procedure CkCharset_Dispose (handle: HCkCharset);
begin
  TCkCharset_Dispose(_map(1, 'CkCharset_Dispose'))
    (handle);
end;


procedure CkCharset_getAltToCharset (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getAltToCharset(_map(2, 'CkCharset_getAltToCharset'))
    (objHandle, outPropVal);
end;

procedure CkCharset_putAltToCharset (objHandle: HCkCharset; newPropVal: PWideChar);
begin
  TCkCharset_putAltToCharset(_map(3, 'CkCharset_putAltToCharset'))
    (objHandle, newPropVal);
end;

function CkCharset__altToCharset (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__altToCharset(_map(4, 'CkCharset__altToCharset'))
    (objHandle);
end;

procedure CkCharset_getDebugLogFilePath (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getDebugLogFilePath(_map(5, 'CkCharset_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCharset_putDebugLogFilePath (objHandle: HCkCharset; newPropVal: PWideChar);
begin
  TCkCharset_putDebugLogFilePath(_map(6, 'CkCharset_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCharset__debugLogFilePath (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__debugLogFilePath(_map(7, 'CkCharset__debugLogFilePath'))
    (objHandle);
end;

function CkCharset_getErrorAction (objHandle: HCkCharset): Integer;
begin
    result := TCkCharset_getErrorAction(_map(8, 'CkCharset_getErrorAction'))
    (objHandle);
end;

procedure CkCharset_putErrorAction (objHandle: HCkCharset; newPropVal: Integer);
begin
  TCkCharset_putErrorAction(_map(9, 'CkCharset_putErrorAction'))
    (objHandle, newPropVal);
end;

procedure CkCharset_getFromCharset (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getFromCharset(_map(10, 'CkCharset_getFromCharset'))
    (objHandle, outPropVal);
end;

procedure CkCharset_putFromCharset (objHandle: HCkCharset; newPropVal: PWideChar);
begin
  TCkCharset_putFromCharset(_map(11, 'CkCharset_putFromCharset'))
    (objHandle, newPropVal);
end;

function CkCharset__fromCharset (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__fromCharset(_map(12, 'CkCharset__fromCharset'))
    (objHandle);
end;

procedure CkCharset_getLastErrorHtml (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastErrorHtml(_map(13, 'CkCharset_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCharset__lastErrorHtml (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastErrorHtml(_map(14, 'CkCharset__lastErrorHtml'))
    (objHandle);
end;

procedure CkCharset_getLastErrorText (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastErrorText(_map(15, 'CkCharset_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCharset__lastErrorText (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastErrorText(_map(16, 'CkCharset__lastErrorText'))
    (objHandle);
end;

procedure CkCharset_getLastErrorXml (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastErrorXml(_map(17, 'CkCharset_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCharset__lastErrorXml (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastErrorXml(_map(18, 'CkCharset__lastErrorXml'))
    (objHandle);
end;

procedure CkCharset_getLastInputAsHex (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastInputAsHex(_map(19, 'CkCharset_getLastInputAsHex'))
    (objHandle, outPropVal);
end;

function CkCharset__lastInputAsHex (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastInputAsHex(_map(20, 'CkCharset__lastInputAsHex'))
    (objHandle);
end;

procedure CkCharset_getLastInputAsQP (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastInputAsQP(_map(21, 'CkCharset_getLastInputAsQP'))
    (objHandle, outPropVal);
end;

function CkCharset__lastInputAsQP (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastInputAsQP(_map(22, 'CkCharset__lastInputAsQP'))
    (objHandle);
end;

function CkCharset_getLastMethodSuccess (objHandle: HCkCharset): wordbool;
begin
    result := TCkCharset_getLastMethodSuccess(_map(23, 'CkCharset_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCharset_putLastMethodSuccess (objHandle: HCkCharset; newPropVal: wordbool);
begin
  TCkCharset_putLastMethodSuccess(_map(24, 'CkCharset_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkCharset_getLastOutputAsHex (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastOutputAsHex(_map(25, 'CkCharset_getLastOutputAsHex'))
    (objHandle, outPropVal);
end;

function CkCharset__lastOutputAsHex (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastOutputAsHex(_map(26, 'CkCharset__lastOutputAsHex'))
    (objHandle);
end;

procedure CkCharset_getLastOutputAsQP (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getLastOutputAsQP(_map(27, 'CkCharset_getLastOutputAsQP'))
    (objHandle, outPropVal);
end;

function CkCharset__lastOutputAsQP (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__lastOutputAsQP(_map(28, 'CkCharset__lastOutputAsQP'))
    (objHandle);
end;

function CkCharset_getSaveLast (objHandle: HCkCharset): wordbool;
begin
    result := TCkCharset_getSaveLast(_map(29, 'CkCharset_getSaveLast'))
    (objHandle);
end;

procedure CkCharset_putSaveLast (objHandle: HCkCharset; newPropVal: wordbool);
begin
  TCkCharset_putSaveLast(_map(30, 'CkCharset_putSaveLast'))
    (objHandle, newPropVal);
end;

procedure CkCharset_getToCharset (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getToCharset(_map(31, 'CkCharset_getToCharset'))
    (objHandle, outPropVal);
end;

procedure CkCharset_putToCharset (objHandle: HCkCharset; newPropVal: PWideChar);
begin
  TCkCharset_putToCharset(_map(32, 'CkCharset_putToCharset'))
    (objHandle, newPropVal);
end;

function CkCharset__toCharset (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__toCharset(_map(33, 'CkCharset__toCharset'))
    (objHandle);
end;

function CkCharset_getVerboseLogging (objHandle: HCkCharset): wordbool;
begin
    result := TCkCharset_getVerboseLogging(_map(34, 'CkCharset_getVerboseLogging'))
    (objHandle);
end;

procedure CkCharset_putVerboseLogging (objHandle: HCkCharset; newPropVal: wordbool);
begin
  TCkCharset_putVerboseLogging(_map(35, 'CkCharset_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCharset_getVersion (objHandle: HCkCharset; outPropVal: HCkString);
begin
  TCkCharset_getVersion(_map(36, 'CkCharset_getVersion'))
    (objHandle, outPropVal);
end;

function CkCharset__version (objHandle: HCkCharset): PWideChar;
begin
  result := TCkCharset__version(_map(37, 'CkCharset__version'))
    (objHandle);
end;

function CkCharset_CharsetToCodePage (objHandle: HCkCharset; charsetName: PWideChar): Integer;
begin
  result := TCkCharset_CharsetToCodePage(_map(38, 'CkCharset_CharsetToCodePage'))
    (objHandle, charsetName);
end;

function CkCharset_CodePageToCharset (objHandle: HCkCharset; codePage: Integer; outStr: HCkString): wordbool;
begin
  result := TCkCharset_CodePageToCharset(_map(39, 'CkCharset_CodePageToCharset'))
    (objHandle, codePage, outStr);
end;

function CkCharset__codePageToCharset (objHandle: HCkCharset; codePage: Integer): PWideChar;
begin
  result := TCkCharset__codePageToCharset(_map(40, 'CkCharset__codePageToCharset'))
    (objHandle, codePage);
end;

function CkCharset_ConvertData (objHandle: HCkCharset; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_ConvertData(_map(41, 'CkCharset_ConvertData'))
    (objHandle, inData, outData);
end;

function CkCharset_ConvertFile (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCharset_ConvertFile(_map(42, 'CkCharset_ConvertFile'))
    (objHandle, inPath, destPath);
end;

function CkCharset_ConvertFileNoPreamble (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCharset_ConvertFileNoPreamble(_map(43, 'CkCharset_ConvertFileNoPreamble'))
    (objHandle, inPath, destPath);
end;

function CkCharset_ConvertFromUnicode (objHandle: HCkCharset; inData: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_ConvertFromUnicode(_map(44, 'CkCharset_ConvertFromUnicode'))
    (objHandle, inData, outData);
end;

function CkCharset_ConvertFromUtf16 (objHandle: HCkCharset; uniData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_ConvertFromUtf16(_map(45, 'CkCharset_ConvertFromUtf16'))
    (objHandle, uniData, outData);
end;

function CkCharset_ConvertHtml (objHandle: HCkCharset; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_ConvertHtml(_map(46, 'CkCharset_ConvertHtml'))
    (objHandle, inData, outData);
end;

function CkCharset_ConvertHtmlFile (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCharset_ConvertHtmlFile(_map(47, 'CkCharset_ConvertHtmlFile'))
    (objHandle, inPath, destPath);
end;

function CkCharset_ConvertToUnicode (objHandle: HCkCharset; inData: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCharset_ConvertToUnicode(_map(48, 'CkCharset_ConvertToUnicode'))
    (objHandle, inData, outStr);
end;

function CkCharset__convertToUnicode (objHandle: HCkCharset; inData: HCkByteData): PWideChar;
begin
  result := TCkCharset__convertToUnicode(_map(49, 'CkCharset__convertToUnicode'))
    (objHandle, inData);
end;

function CkCharset_ConvertToUtf16 (objHandle: HCkCharset; mbData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_ConvertToUtf16(_map(50, 'CkCharset_ConvertToUtf16'))
    (objHandle, mbData, outData);
end;

function CkCharset_EntityEncodeDec (objHandle: HCkCharset; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_EntityEncodeDec(_map(51, 'CkCharset_EntityEncodeDec'))
    (objHandle, str, outStr);
end;

function CkCharset__entityEncodeDec (objHandle: HCkCharset; str: PWideChar): PWideChar;
begin
  result := TCkCharset__entityEncodeDec(_map(52, 'CkCharset__entityEncodeDec'))
    (objHandle, str);
end;

function CkCharset_EntityEncodeHex (objHandle: HCkCharset; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_EntityEncodeHex(_map(53, 'CkCharset_EntityEncodeHex'))
    (objHandle, str, outStr);
end;

function CkCharset__entityEncodeHex (objHandle: HCkCharset; str: PWideChar): PWideChar;
begin
  result := TCkCharset__entityEncodeHex(_map(54, 'CkCharset__entityEncodeHex'))
    (objHandle, str);
end;

function CkCharset_GetHtmlCharset (objHandle: HCkCharset; inData: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCharset_GetHtmlCharset(_map(55, 'CkCharset_GetHtmlCharset'))
    (objHandle, inData, outStr);
end;

function CkCharset__getHtmlCharset (objHandle: HCkCharset; inData: HCkByteData): PWideChar;
begin
  result := TCkCharset__getHtmlCharset(_map(56, 'CkCharset__getHtmlCharset'))
    (objHandle, inData);
end;

function CkCharset_GetHtmlFileCharset (objHandle: HCkCharset; htmlFilePath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_GetHtmlFileCharset(_map(57, 'CkCharset_GetHtmlFileCharset'))
    (objHandle, htmlFilePath, outStr);
end;

function CkCharset__getHtmlFileCharset (objHandle: HCkCharset; htmlFilePath: PWideChar): PWideChar;
begin
  result := TCkCharset__getHtmlFileCharset(_map(58, 'CkCharset__getHtmlFileCharset'))
    (objHandle, htmlFilePath);
end;

function CkCharset_HtmlDecodeToStr (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_HtmlDecodeToStr(_map(59, 'CkCharset_HtmlDecodeToStr'))
    (objHandle, inStr, outStr);
end;

function CkCharset__htmlDecodeToStr (objHandle: HCkCharset; inStr: PWideChar): PWideChar;
begin
  result := TCkCharset__htmlDecodeToStr(_map(60, 'CkCharset__htmlDecodeToStr'))
    (objHandle, inStr);
end;

function CkCharset_HtmlEntityDecode (objHandle: HCkCharset; inHtml: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_HtmlEntityDecode(_map(61, 'CkCharset_HtmlEntityDecode'))
    (objHandle, inHtml, outData);
end;

function CkCharset_HtmlEntityDecodeFile (objHandle: HCkCharset; inPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCharset_HtmlEntityDecodeFile(_map(62, 'CkCharset_HtmlEntityDecodeFile'))
    (objHandle, inPath, destPath);
end;

function CkCharset_LowerCase (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_LowerCase(_map(63, 'CkCharset_LowerCase'))
    (objHandle, inStr, outStr);
end;

function CkCharset__lowerCase (objHandle: HCkCharset; inStr: PWideChar): PWideChar;
begin
  result := TCkCharset__lowerCase(_map(64, 'CkCharset__lowerCase'))
    (objHandle, inStr);
end;

function CkCharset_ReadFile (objHandle: HCkCharset; path: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCharset_ReadFile(_map(65, 'CkCharset_ReadFile'))
    (objHandle, path, outData);
end;

function CkCharset_ReadFileToString (objHandle: HCkCharset; path: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_ReadFileToString(_map(66, 'CkCharset_ReadFileToString'))
    (objHandle, path, charset, outStr);
end;

function CkCharset__readFileToString (objHandle: HCkCharset; path: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkCharset__readFileToString(_map(67, 'CkCharset__readFileToString'))
    (objHandle, path, charset);
end;

procedure CkCharset_SetErrorString (objHandle: HCkCharset; str: PWideChar; charset: PWideChar);
begin
  TCkCharset_SetErrorString(_map(68, 'CkCharset_SetErrorString'))
    (objHandle, str, charset);
end;

function CkCharset_UpperCase (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_UpperCase(_map(69, 'CkCharset_UpperCase'))
    (objHandle, inStr, outStr);
end;

function CkCharset__upperCase (objHandle: HCkCharset; inStr: PWideChar): PWideChar;
begin
  result := TCkCharset__upperCase(_map(70, 'CkCharset__upperCase'))
    (objHandle, inStr);
end;

function CkCharset_UrlDecodeStr (objHandle: HCkCharset; inStr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCharset_UrlDecodeStr(_map(71, 'CkCharset_UrlDecodeStr'))
    (objHandle, inStr, outStr);
end;

function CkCharset__urlDecodeStr (objHandle: HCkCharset; inStr: PWideChar): PWideChar;
begin
  result := TCkCharset__urlDecodeStr(_map(72, 'CkCharset__urlDecodeStr'))
    (objHandle, inStr);
end;

function CkCharset_VerifyData (objHandle: HCkCharset; charset: PWideChar; inData: HCkByteData): wordbool;
begin
  result := TCkCharset_VerifyData(_map(73, 'CkCharset_VerifyData'))
    (objHandle, charset, inData);
end;

function CkCharset_VerifyFile (objHandle: HCkCharset; charset: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkCharset_VerifyFile(_map(74, 'CkCharset_VerifyFile'))
    (objHandle, charset, path);
end;

function CkCharset_WriteFile (objHandle: HCkCharset; path: PWideChar; byteData: HCkByteData): wordbool;
begin
  result := TCkCharset_WriteFile(_map(75, 'CkCharset_WriteFile'))
    (objHandle, path, byteData);
end;

function CkCharset_WriteStringToFile (objHandle: HCkCharset; textData: PWideChar; path: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkCharset_WriteStringToFile(_map(76, 'CkCharset_WriteStringToFile'))
    (objHandle, textData, path, charset);
end;

end.
