unit CkDateTime;

interface

type

HCkTask = Pointer;
HCkDtObj = Pointer;
HCkStringBuilder = Pointer;
HCkDateTime = Pointer;
HCkString = Pointer;


function CkDateTime_Create: HCkDateTime;  stdcall;
procedure CkDateTime_Dispose(handle: HCkDateTime); stdcall;
procedure CkDateTime_getDebugLogFilePath(objHandle: HCkDateTime; outPropVal: HCkString);
procedure CkDateTime_putDebugLogFilePath(objHandle: HCkDateTime; newPropVal: PWideChar);
function CkDateTime__debugLogFilePath(objHandle: HCkDateTime): PWideChar;
function CkDateTime_getIsDst(objHandle: HCkDateTime): Integer;
procedure CkDateTime_getLastErrorHtml(objHandle: HCkDateTime; outPropVal: HCkString);
function CkDateTime__lastErrorHtml(objHandle: HCkDateTime): PWideChar;
procedure CkDateTime_getLastErrorText(objHandle: HCkDateTime; outPropVal: HCkString);
function CkDateTime__lastErrorText(objHandle: HCkDateTime): PWideChar;
procedure CkDateTime_getLastErrorXml(objHandle: HCkDateTime; outPropVal: HCkString);
function CkDateTime__lastErrorXml(objHandle: HCkDateTime): PWideChar;
function CkDateTime_getLastMethodSuccess(objHandle: HCkDateTime): wordbool;
procedure CkDateTime_putLastMethodSuccess(objHandle: HCkDateTime; newPropVal: wordbool);
function CkDateTime_getUtcOffset(objHandle: HCkDateTime): Integer;
function CkDateTime_getVerboseLogging(objHandle: HCkDateTime): wordbool;
procedure CkDateTime_putVerboseLogging(objHandle: HCkDateTime; newPropVal: wordbool);
procedure CkDateTime_getVersion(objHandle: HCkDateTime; outPropVal: HCkString);
function CkDateTime__version(objHandle: HCkDateTime): PWideChar;
function CkDateTime_AddDays(objHandle: HCkDateTime; numDays: Integer): wordbool;
function CkDateTime_AddSeconds(objHandle: HCkDateTime; numSeconds: Integer): wordbool;
procedure CkDateTime_DeSerialize(objHandle: HCkDateTime; serializedDateTime: PWideChar);
function CkDateTime_DiffSeconds(objHandle: HCkDateTime; dateTimeArg: HCkDateTime): Integer;
function CkDateTime_ExpiresWithin(objHandle: HCkDateTime; n: Integer; units: PWideChar): wordbool;
function CkDateTime_GetAsDateTimeTicks(objHandle: HCkDateTime; bLocal: wordbool): Int64;
function CkDateTime_GetAsDosDate(objHandle: HCkDateTime; bLocal: wordbool): LongWord;
function CkDateTime_GetAsIso8601(objHandle: HCkDateTime; formatStr: PWideChar; bLocal: wordbool; outStr: HCkString): wordbool;
function CkDateTime__getAsIso8601(objHandle: HCkDateTime; formatStr: PWideChar; bLocal: wordbool): PWideChar;
function CkDateTime_GetAsOleDate(objHandle: HCkDateTime; bLocal: wordbool): Double;
function CkDateTime_GetAsRfc822(objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
function CkDateTime__getAsRfc822(objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
function CkDateTime_GetAsTimestamp(objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
function CkDateTime__getAsTimestamp(objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
function CkDateTime_GetAsUnixTime(objHandle: HCkDateTime; bLocal: wordbool): LongWord;
function CkDateTime_GetAsUnixTime64(objHandle: HCkDateTime; bLocal: wordbool): Int64;
function CkDateTime_GetAsUnixTimeDbl(objHandle: HCkDateTime; bLocal: wordbool): Double;
function CkDateTime_GetAsUnixTimeStr(objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
function CkDateTime__getAsUnixTimeStr(objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
function CkDateTime_GetDtObj(objHandle: HCkDateTime; bLocal: wordbool): HCkDtObj;
function CkDateTime_LoadTaskResult(objHandle: HCkDateTime; task: HCkTask): wordbool;
function CkDateTime_OlderThan(objHandle: HCkDateTime; n: Integer; units: PWideChar): wordbool;
function CkDateTime_Serialize(objHandle: HCkDateTime; outStr: HCkString): wordbool;
function CkDateTime__serialize(objHandle: HCkDateTime): PWideChar;
function CkDateTime_SetFromCurrentSystemTime(objHandle: HCkDateTime): wordbool;
function CkDateTime_SetFromDateTimeTicks(objHandle: HCkDateTime; bLocal: wordbool; ticks: Int64): wordbool;
function CkDateTime_SetFromDosDate(objHandle: HCkDateTime; bLocal: wordbool; t: LongWord): wordbool;
function CkDateTime_SetFromDtObj(objHandle: HCkDateTime; dt: HCkDtObj): wordbool;
function CkDateTime_SetFromNtpServer(objHandle: HCkDateTime; jsonStr: PWideChar): wordbool;
function CkDateTime_SetFromNtpTime(objHandle: HCkDateTime; ntpSeconds: Integer): wordbool;
function CkDateTime_SetFromOleDate(objHandle: HCkDateTime; bLocal: wordbool; dt: Double): wordbool;
function CkDateTime_SetFromRfc822(objHandle: HCkDateTime; rfc822Str: PWideChar): wordbool;
function CkDateTime_SetFromTimestamp(objHandle: HCkDateTime; timestamp: PWideChar): wordbool;
function CkDateTime_SetFromUlid(objHandle: HCkDateTime; bLocal: wordbool; ulid: PWideChar): wordbool;
function CkDateTime_SetFromUnixTime(objHandle: HCkDateTime; bLocal: wordbool; t: LongWord): wordbool;
function CkDateTime_SetFromUnixTime64(objHandle: HCkDateTime; bLocal: wordbool; t: Int64): wordbool;
function CkDateTime_SetFromUnixTimeDbl(objHandle: HCkDateTime; bLocal: wordbool; d: Double): wordbool;
procedure CkDateTime_ToDtObj(objHandle: HCkDateTime; bLocal: wordbool; dtObj: HCkDtObj);
function CkDateTime_UlidGenerate(objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
function CkDateTime__ulidGenerate(objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
function CkDateTime_UlidIncrement(objHandle: HCkDateTime; ulid: HCkStringBuilder): wordbool;
function CkDateTime_UlidValidate(objHandle: HCkDateTime; ulid: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDateTime_Create = function : HCkDateTime; stdcall;
  TCkDateTime_Dispose = procedure (handle: HCkDateTime); stdcall;
  TCkDateTime_getDebugLogFilePath = procedure (objHandle: HCkDateTime; outPropVal: HCkString); stdcall;
  TCkDateTime_putDebugLogFilePath = procedure (objHandle: HCkDateTime; newPropVal: PWideChar); stdcall;
  TCkDateTime__debugLogFilePath = function (objHandle: HCkDateTime): PWideChar; stdcall;
  TCkDateTime_getIsDst = function (objHandle: HCkDateTime): Integer; stdcall;
  TCkDateTime_getLastErrorHtml = procedure (objHandle: HCkDateTime; outPropVal: HCkString); stdcall;
  TCkDateTime__lastErrorHtml = function (objHandle: HCkDateTime): PWideChar; stdcall;
  TCkDateTime_getLastErrorText = procedure (objHandle: HCkDateTime; outPropVal: HCkString); stdcall;
  TCkDateTime__lastErrorText = function (objHandle: HCkDateTime): PWideChar; stdcall;
  TCkDateTime_getLastErrorXml = procedure (objHandle: HCkDateTime; outPropVal: HCkString); stdcall;
  TCkDateTime__lastErrorXml = function (objHandle: HCkDateTime): PWideChar; stdcall;
  TCkDateTime_getLastMethodSuccess = function (objHandle: HCkDateTime): wordbool; stdcall;
  TCkDateTime_putLastMethodSuccess = procedure (objHandle: HCkDateTime; newPropVal: wordbool); stdcall;
  TCkDateTime_getUtcOffset = function (objHandle: HCkDateTime): Integer; stdcall;
  TCkDateTime_getVerboseLogging = function (objHandle: HCkDateTime): wordbool; stdcall;
  TCkDateTime_putVerboseLogging = procedure (objHandle: HCkDateTime; newPropVal: wordbool); stdcall;
  TCkDateTime_getVersion = procedure (objHandle: HCkDateTime; outPropVal: HCkString); stdcall;
  TCkDateTime__version = function (objHandle: HCkDateTime): PWideChar; stdcall;
  TCkDateTime_AddDays = function (objHandle: HCkDateTime; numDays: Integer): wordbool; stdcall;
  TCkDateTime_AddSeconds = function (objHandle: HCkDateTime; numSeconds: Integer): wordbool; stdcall;
  TCkDateTime_DeSerialize = procedure (objHandle: HCkDateTime; serializedDateTime: PWideChar); stdcall;
  TCkDateTime_DiffSeconds = function (objHandle: HCkDateTime; dateTimeArg: HCkDateTime): Integer; stdcall;
  TCkDateTime_ExpiresWithin = function (objHandle: HCkDateTime; n: Integer; units: PWideChar): wordbool; stdcall;
  TCkDateTime_GetAsDateTimeTicks = function (objHandle: HCkDateTime; bLocal: wordbool): Int64; stdcall;
  TCkDateTime_GetAsDosDate = function (objHandle: HCkDateTime; bLocal: wordbool): LongWord; stdcall;
  TCkDateTime_GetAsIso8601 = function (objHandle: HCkDateTime; formatStr: PWideChar; bLocal: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkDateTime__getAsIso8601 = function (objHandle: HCkDateTime; formatStr: PWideChar; bLocal: wordbool): PWideChar; stdcall;
  TCkDateTime_GetAsOleDate = function (objHandle: HCkDateTime; bLocal: wordbool): Double; stdcall;
  TCkDateTime_GetAsRfc822 = function (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkDateTime__getAsRfc822 = function (objHandle: HCkDateTime; bLocal: wordbool): PWideChar; stdcall;
  TCkDateTime_GetAsTimestamp = function (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkDateTime__getAsTimestamp = function (objHandle: HCkDateTime; bLocal: wordbool): PWideChar; stdcall;
  TCkDateTime_GetAsUnixTime = function (objHandle: HCkDateTime; bLocal: wordbool): LongWord; stdcall;
  TCkDateTime_GetAsUnixTime64 = function (objHandle: HCkDateTime; bLocal: wordbool): Int64; stdcall;
  TCkDateTime_GetAsUnixTimeDbl = function (objHandle: HCkDateTime; bLocal: wordbool): Double; stdcall;
  TCkDateTime_GetAsUnixTimeStr = function (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkDateTime__getAsUnixTimeStr = function (objHandle: HCkDateTime; bLocal: wordbool): PWideChar; stdcall;
  TCkDateTime_GetDtObj = function (objHandle: HCkDateTime; bLocal: wordbool): HCkDtObj; stdcall;
  TCkDateTime_LoadTaskResult = function (objHandle: HCkDateTime; task: HCkTask): wordbool; stdcall;
  TCkDateTime_OlderThan = function (objHandle: HCkDateTime; n: Integer; units: PWideChar): wordbool; stdcall;
  TCkDateTime_Serialize = function (objHandle: HCkDateTime; outStr: HCkString): wordbool; stdcall;
  TCkDateTime__serialize = function (objHandle: HCkDateTime): PWideChar; stdcall;
  TCkDateTime_SetFromCurrentSystemTime = function (objHandle: HCkDateTime): wordbool; stdcall;
  TCkDateTime_SetFromDateTimeTicks = function (objHandle: HCkDateTime; bLocal: wordbool; ticks: Int64): wordbool; stdcall;
  TCkDateTime_SetFromDosDate = function (objHandle: HCkDateTime; bLocal: wordbool; t: LongWord): wordbool; stdcall;
  TCkDateTime_SetFromDtObj = function (objHandle: HCkDateTime; dt: HCkDtObj): wordbool; stdcall;
  TCkDateTime_SetFromNtpServer = function (objHandle: HCkDateTime; jsonStr: PWideChar): wordbool; stdcall;
  TCkDateTime_SetFromNtpTime = function (objHandle: HCkDateTime; ntpSeconds: Integer): wordbool; stdcall;
  TCkDateTime_SetFromOleDate = function (objHandle: HCkDateTime; bLocal: wordbool; dt: Double): wordbool; stdcall;
  TCkDateTime_SetFromRfc822 = function (objHandle: HCkDateTime; rfc822Str: PWideChar): wordbool; stdcall;
  TCkDateTime_SetFromTimestamp = function (objHandle: HCkDateTime; timestamp: PWideChar): wordbool; stdcall;
  TCkDateTime_SetFromUlid = function (objHandle: HCkDateTime; bLocal: wordbool; ulid: PWideChar): wordbool; stdcall;
  TCkDateTime_SetFromUnixTime = function (objHandle: HCkDateTime; bLocal: wordbool; t: LongWord): wordbool; stdcall;
  TCkDateTime_SetFromUnixTime64 = function (objHandle: HCkDateTime; bLocal: wordbool; t: Int64): wordbool; stdcall;
  TCkDateTime_SetFromUnixTimeDbl = function (objHandle: HCkDateTime; bLocal: wordbool; d: Double): wordbool; stdcall;
  TCkDateTime_ToDtObj = procedure (objHandle: HCkDateTime; bLocal: wordbool; dtObj: HCkDtObj); stdcall;
  TCkDateTime_UlidGenerate = function (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkDateTime__ulidGenerate = function (objHandle: HCkDateTime; bLocal: wordbool): PWideChar; stdcall;
  TCkDateTime_UlidIncrement = function (objHandle: HCkDateTime; ulid: HCkStringBuilder): wordbool; stdcall;
  TCkDateTime_UlidValidate = function (objHandle: HCkDateTime; ulid: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..60] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDateTime_Create : HCkDateTime;
begin
  result := TCkDateTime_Create(_map(0, 'CkDateTime_Create'));
end;

procedure CkDateTime_Dispose (handle: HCkDateTime);
begin
  TCkDateTime_Dispose(_map(1, 'CkDateTime_Dispose'))
    (handle);
end;


procedure CkDateTime_getDebugLogFilePath (objHandle: HCkDateTime; outPropVal: HCkString);
begin
  TCkDateTime_getDebugLogFilePath(_map(2, 'CkDateTime_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDateTime_putDebugLogFilePath (objHandle: HCkDateTime; newPropVal: PWideChar);
begin
  TCkDateTime_putDebugLogFilePath(_map(3, 'CkDateTime_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDateTime__debugLogFilePath (objHandle: HCkDateTime): PWideChar;
begin
  result := TCkDateTime__debugLogFilePath(_map(4, 'CkDateTime__debugLogFilePath'))
    (objHandle);
end;

function CkDateTime_getIsDst (objHandle: HCkDateTime): Integer;
begin
    result := TCkDateTime_getIsDst(_map(5, 'CkDateTime_getIsDst'))
    (objHandle);
end;

procedure CkDateTime_getLastErrorHtml (objHandle: HCkDateTime; outPropVal: HCkString);
begin
  TCkDateTime_getLastErrorHtml(_map(6, 'CkDateTime_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDateTime__lastErrorHtml (objHandle: HCkDateTime): PWideChar;
begin
  result := TCkDateTime__lastErrorHtml(_map(7, 'CkDateTime__lastErrorHtml'))
    (objHandle);
end;

procedure CkDateTime_getLastErrorText (objHandle: HCkDateTime; outPropVal: HCkString);
begin
  TCkDateTime_getLastErrorText(_map(8, 'CkDateTime_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDateTime__lastErrorText (objHandle: HCkDateTime): PWideChar;
begin
  result := TCkDateTime__lastErrorText(_map(9, 'CkDateTime__lastErrorText'))
    (objHandle);
end;

procedure CkDateTime_getLastErrorXml (objHandle: HCkDateTime; outPropVal: HCkString);
begin
  TCkDateTime_getLastErrorXml(_map(10, 'CkDateTime_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDateTime__lastErrorXml (objHandle: HCkDateTime): PWideChar;
begin
  result := TCkDateTime__lastErrorXml(_map(11, 'CkDateTime__lastErrorXml'))
    (objHandle);
end;

function CkDateTime_getLastMethodSuccess (objHandle: HCkDateTime): wordbool;
begin
    result := TCkDateTime_getLastMethodSuccess(_map(12, 'CkDateTime_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDateTime_putLastMethodSuccess (objHandle: HCkDateTime; newPropVal: wordbool);
begin
  TCkDateTime_putLastMethodSuccess(_map(13, 'CkDateTime_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkDateTime_getUtcOffset (objHandle: HCkDateTime): Integer;
begin
    result := TCkDateTime_getUtcOffset(_map(14, 'CkDateTime_getUtcOffset'))
    (objHandle);
end;

function CkDateTime_getVerboseLogging (objHandle: HCkDateTime): wordbool;
begin
    result := TCkDateTime_getVerboseLogging(_map(15, 'CkDateTime_getVerboseLogging'))
    (objHandle);
end;

procedure CkDateTime_putVerboseLogging (objHandle: HCkDateTime; newPropVal: wordbool);
begin
  TCkDateTime_putVerboseLogging(_map(16, 'CkDateTime_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDateTime_getVersion (objHandle: HCkDateTime; outPropVal: HCkString);
begin
  TCkDateTime_getVersion(_map(17, 'CkDateTime_getVersion'))
    (objHandle, outPropVal);
end;

function CkDateTime__version (objHandle: HCkDateTime): PWideChar;
begin
  result := TCkDateTime__version(_map(18, 'CkDateTime__version'))
    (objHandle);
end;

function CkDateTime_AddDays (objHandle: HCkDateTime; numDays: Integer): wordbool;
begin
  result := TCkDateTime_AddDays(_map(19, 'CkDateTime_AddDays'))
    (objHandle, numDays);
end;

function CkDateTime_AddSeconds (objHandle: HCkDateTime; numSeconds: Integer): wordbool;
begin
  result := TCkDateTime_AddSeconds(_map(20, 'CkDateTime_AddSeconds'))
    (objHandle, numSeconds);
end;

procedure CkDateTime_DeSerialize (objHandle: HCkDateTime; serializedDateTime: PWideChar);
begin
  TCkDateTime_DeSerialize(_map(21, 'CkDateTime_DeSerialize'))
    (objHandle, serializedDateTime);
end;

function CkDateTime_DiffSeconds (objHandle: HCkDateTime; dateTimeArg: HCkDateTime): Integer;
begin
  result := TCkDateTime_DiffSeconds(_map(22, 'CkDateTime_DiffSeconds'))
    (objHandle, dateTimeArg);
end;

function CkDateTime_ExpiresWithin (objHandle: HCkDateTime; n: Integer; units: PWideChar): wordbool;
begin
  result := TCkDateTime_ExpiresWithin(_map(23, 'CkDateTime_ExpiresWithin'))
    (objHandle, n, units);
end;

function CkDateTime_GetAsDateTimeTicks (objHandle: HCkDateTime; bLocal: wordbool): Int64;
begin
  result := TCkDateTime_GetAsDateTimeTicks(_map(24, 'CkDateTime_GetAsDateTimeTicks'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsDosDate (objHandle: HCkDateTime; bLocal: wordbool): LongWord;
begin
  result := TCkDateTime_GetAsDosDate(_map(25, 'CkDateTime_GetAsDosDate'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsIso8601 (objHandle: HCkDateTime; formatStr: PWideChar; bLocal: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkDateTime_GetAsIso8601(_map(26, 'CkDateTime_GetAsIso8601'))
    (objHandle, formatStr, bLocal, outStr);
end;

function CkDateTime__getAsIso8601 (objHandle: HCkDateTime; formatStr: PWideChar; bLocal: wordbool): PWideChar;
begin
  result := TCkDateTime__getAsIso8601(_map(27, 'CkDateTime__getAsIso8601'))
    (objHandle, formatStr, bLocal);
end;

function CkDateTime_GetAsOleDate (objHandle: HCkDateTime; bLocal: wordbool): Double;
begin
  result := TCkDateTime_GetAsOleDate(_map(28, 'CkDateTime_GetAsOleDate'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsRfc822 (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkDateTime_GetAsRfc822(_map(29, 'CkDateTime_GetAsRfc822'))
    (objHandle, bLocal, outStr);
end;

function CkDateTime__getAsRfc822 (objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
begin
  result := TCkDateTime__getAsRfc822(_map(30, 'CkDateTime__getAsRfc822'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsTimestamp (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkDateTime_GetAsTimestamp(_map(31, 'CkDateTime_GetAsTimestamp'))
    (objHandle, bLocal, outStr);
end;

function CkDateTime__getAsTimestamp (objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
begin
  result := TCkDateTime__getAsTimestamp(_map(32, 'CkDateTime__getAsTimestamp'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsUnixTime (objHandle: HCkDateTime; bLocal: wordbool): LongWord;
begin
  result := TCkDateTime_GetAsUnixTime(_map(33, 'CkDateTime_GetAsUnixTime'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsUnixTime64 (objHandle: HCkDateTime; bLocal: wordbool): Int64;
begin
  result := TCkDateTime_GetAsUnixTime64(_map(34, 'CkDateTime_GetAsUnixTime64'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsUnixTimeDbl (objHandle: HCkDateTime; bLocal: wordbool): Double;
begin
  result := TCkDateTime_GetAsUnixTimeDbl(_map(35, 'CkDateTime_GetAsUnixTimeDbl'))
    (objHandle, bLocal);
end;

function CkDateTime_GetAsUnixTimeStr (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkDateTime_GetAsUnixTimeStr(_map(36, 'CkDateTime_GetAsUnixTimeStr'))
    (objHandle, bLocal, outStr);
end;

function CkDateTime__getAsUnixTimeStr (objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
begin
  result := TCkDateTime__getAsUnixTimeStr(_map(37, 'CkDateTime__getAsUnixTimeStr'))
    (objHandle, bLocal);
end;

function CkDateTime_GetDtObj (objHandle: HCkDateTime; bLocal: wordbool): HCkDtObj;
begin
  result := TCkDateTime_GetDtObj(_map(38, 'CkDateTime_GetDtObj'))
    (objHandle, bLocal);
end;

function CkDateTime_LoadTaskResult (objHandle: HCkDateTime; task: HCkTask): wordbool;
begin
  result := TCkDateTime_LoadTaskResult(_map(39, 'CkDateTime_LoadTaskResult'))
    (objHandle, task);
end;

function CkDateTime_OlderThan (objHandle: HCkDateTime; n: Integer; units: PWideChar): wordbool;
begin
  result := TCkDateTime_OlderThan(_map(40, 'CkDateTime_OlderThan'))
    (objHandle, n, units);
end;

function CkDateTime_Serialize (objHandle: HCkDateTime; outStr: HCkString): wordbool;
begin
  result := TCkDateTime_Serialize(_map(41, 'CkDateTime_Serialize'))
    (objHandle, outStr);
end;

function CkDateTime__serialize (objHandle: HCkDateTime): PWideChar;
begin
  result := TCkDateTime__serialize(_map(42, 'CkDateTime__serialize'))
    (objHandle);
end;

function CkDateTime_SetFromCurrentSystemTime (objHandle: HCkDateTime): wordbool;
begin
  result := TCkDateTime_SetFromCurrentSystemTime(_map(43, 'CkDateTime_SetFromCurrentSystemTime'))
    (objHandle);
end;

function CkDateTime_SetFromDateTimeTicks (objHandle: HCkDateTime; bLocal: wordbool; ticks: Int64): wordbool;
begin
  result := TCkDateTime_SetFromDateTimeTicks(_map(44, 'CkDateTime_SetFromDateTimeTicks'))
    (objHandle, bLocal, ticks);
end;

function CkDateTime_SetFromDosDate (objHandle: HCkDateTime; bLocal: wordbool; t: LongWord): wordbool;
begin
  result := TCkDateTime_SetFromDosDate(_map(45, 'CkDateTime_SetFromDosDate'))
    (objHandle, bLocal, t);
end;

function CkDateTime_SetFromDtObj (objHandle: HCkDateTime; dt: HCkDtObj): wordbool;
begin
  result := TCkDateTime_SetFromDtObj(_map(46, 'CkDateTime_SetFromDtObj'))
    (objHandle, dt);
end;

function CkDateTime_SetFromNtpServer (objHandle: HCkDateTime; jsonStr: PWideChar): wordbool;
begin
  result := TCkDateTime_SetFromNtpServer(_map(47, 'CkDateTime_SetFromNtpServer'))
    (objHandle, jsonStr);
end;

function CkDateTime_SetFromNtpTime (objHandle: HCkDateTime; ntpSeconds: Integer): wordbool;
begin
  result := TCkDateTime_SetFromNtpTime(_map(48, 'CkDateTime_SetFromNtpTime'))
    (objHandle, ntpSeconds);
end;

function CkDateTime_SetFromOleDate (objHandle: HCkDateTime; bLocal: wordbool; dt: Double): wordbool;
begin
  result := TCkDateTime_SetFromOleDate(_map(49, 'CkDateTime_SetFromOleDate'))
    (objHandle, bLocal, dt);
end;

function CkDateTime_SetFromRfc822 (objHandle: HCkDateTime; rfc822Str: PWideChar): wordbool;
begin
  result := TCkDateTime_SetFromRfc822(_map(50, 'CkDateTime_SetFromRfc822'))
    (objHandle, rfc822Str);
end;

function CkDateTime_SetFromTimestamp (objHandle: HCkDateTime; timestamp: PWideChar): wordbool;
begin
  result := TCkDateTime_SetFromTimestamp(_map(51, 'CkDateTime_SetFromTimestamp'))
    (objHandle, timestamp);
end;

function CkDateTime_SetFromUlid (objHandle: HCkDateTime; bLocal: wordbool; ulid: PWideChar): wordbool;
begin
  result := TCkDateTime_SetFromUlid(_map(52, 'CkDateTime_SetFromUlid'))
    (objHandle, bLocal, ulid);
end;

function CkDateTime_SetFromUnixTime (objHandle: HCkDateTime; bLocal: wordbool; t: LongWord): wordbool;
begin
  result := TCkDateTime_SetFromUnixTime(_map(53, 'CkDateTime_SetFromUnixTime'))
    (objHandle, bLocal, t);
end;

function CkDateTime_SetFromUnixTime64 (objHandle: HCkDateTime; bLocal: wordbool; t: Int64): wordbool;
begin
  result := TCkDateTime_SetFromUnixTime64(_map(54, 'CkDateTime_SetFromUnixTime64'))
    (objHandle, bLocal, t);
end;

function CkDateTime_SetFromUnixTimeDbl (objHandle: HCkDateTime; bLocal: wordbool; d: Double): wordbool;
begin
  result := TCkDateTime_SetFromUnixTimeDbl(_map(55, 'CkDateTime_SetFromUnixTimeDbl'))
    (objHandle, bLocal, d);
end;

procedure CkDateTime_ToDtObj (objHandle: HCkDateTime; bLocal: wordbool; dtObj: HCkDtObj);
begin
  TCkDateTime_ToDtObj(_map(56, 'CkDateTime_ToDtObj'))
    (objHandle, bLocal, dtObj);
end;

function CkDateTime_UlidGenerate (objHandle: HCkDateTime; bLocal: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkDateTime_UlidGenerate(_map(57, 'CkDateTime_UlidGenerate'))
    (objHandle, bLocal, outStr);
end;

function CkDateTime__ulidGenerate (objHandle: HCkDateTime; bLocal: wordbool): PWideChar;
begin
  result := TCkDateTime__ulidGenerate(_map(58, 'CkDateTime__ulidGenerate'))
    (objHandle, bLocal);
end;

function CkDateTime_UlidIncrement (objHandle: HCkDateTime; ulid: HCkStringBuilder): wordbool;
begin
  result := TCkDateTime_UlidIncrement(_map(59, 'CkDateTime_UlidIncrement'))
    (objHandle, ulid);
end;

function CkDateTime_UlidValidate (objHandle: HCkDateTime; ulid: PWideChar): wordbool;
begin
  result := TCkDateTime_UlidValidate(_map(60, 'CkDateTime_UlidValidate'))
    (objHandle, ulid);
end;

end.
