unit CkString;

interface

type

HCkStringArray = Pointer;
HCkString = Pointer;


function CkString_Create: HCkString;  stdcall;
procedure CkString_Dispose(handle: HCkString); stdcall;
function CkString_getNumArabic(objHandle: HCkString): Integer;
function CkString_getNumAscii(objHandle: HCkString): Integer;
function CkString_getNumCentralEuro(objHandle: HCkString): Integer;
function CkString_getNumChinese(objHandle: HCkString): Integer;
function CkString_getNumCyrillic(objHandle: HCkString): Integer;
function CkString_getNumGreek(objHandle: HCkString): Integer;
function CkString_getNumHebrew(objHandle: HCkString): Integer;
function CkString_getNumJapanese(objHandle: HCkString): Integer;
function CkString_getNumKorean(objHandle: HCkString): Integer;
function CkString_getNumLatin(objHandle: HCkString): Integer;
function CkString_getNumThai(objHandle: HCkString): Integer;
procedure CkString_append(objHandle: HCkString; str: pbyte);
procedure CkString_appendAnsi(objHandle: HCkString; str: pbyte);
procedure CkString_appendChar(objHandle: HCkString; c: Char);
procedure CkString_appendCurrentDateRfc822(objHandle: HCkString);
procedure CkString_appendEnc(objHandle: HCkString; str: pbyte; charsetEncoding: pbyte);
procedure CkString_appendInt(objHandle: HCkString; n: Integer);
procedure CkString_appendN(objHandle: HCkString; str: pbyte; numBytes: LongWord);
procedure CkString_appendNU(objHandle: HCkString; wideStr: PWideChar; numChars: Integer);
procedure CkString_appendRandom(objHandle: HCkString; numBytes: Integer; encoding: pbyte);
procedure CkString_appendStr(objHandle: HCkString; strObj: HCkString);
procedure CkString_appendU(objHandle: HCkString; unicode: PWideChar);
procedure CkString_appendUtf8(objHandle: HCkString; str: pbyte);
procedure CkString_base64Decode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_base64DecodeW(objHandle: HCkString; charsetEncoding: PWideChar);
procedure CkString_base64Encode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_base64EncodeW(objHandle: HCkString; charsetEncoding: PWideChar);
function CkString_beginsWith(objHandle: HCkString; substr: pbyte): wordbool;
function CkString_beginsWithStr(objHandle: HCkString; strObj: HCkString): wordbool;
function CkString_beginsWithW(objHandle: HCkString; str: PWideChar): wordbool;
function CkString_charAt(objHandle: HCkString; idx: Integer): Char;
function CkString_charAtU(objHandle: HCkString; idx: Integer): WideChar;
procedure CkString_chopAtFirstChar(objHandle: HCkString; ch: Char);
procedure CkString_chopAtStr(objHandle: HCkString; subStrObj: HCkString);
procedure CkString_clear(objHandle: HCkString);
function CkString_clone(objHandle: HCkString): HCkString;
function CkString_compareStr(objHandle: HCkString; str: HCkString): Integer;
function CkString_containsSubstring(objHandle: HCkString; substr: pbyte): wordbool;
function CkString_containsSubstringNoCase(objHandle: HCkString; substr: pbyte): wordbool;
function CkString_containsSubstringNoCaseW(objHandle: HCkString; substr: PWideChar): wordbool;
function CkString_containsSubstringW(objHandle: HCkString; substr: PWideChar): wordbool;
function CkString_countCharOccurances(objHandle: HCkString; ch: Char): Integer;
procedure CkString_decodeXMLSpecial(objHandle: HCkString);
function CkString_doubleValue(objHandle: HCkString): Double;
procedure CkString_eliminateChar(objHandle: HCkString; ansiChar: Char; startIndex: Integer);
procedure CkString_encodeXMLSpecial(objHandle: HCkString);
function CkString_endsWith(objHandle: HCkString; substr: pbyte): wordbool;
function CkString_endsWithStr(objHandle: HCkString; substrObj: HCkString): wordbool;
function CkString_endsWithW(objHandle: HCkString; s: PWideChar): wordbool;
procedure CkString_entityDecode(objHandle: HCkString);
procedure CkString_entityEncode(objHandle: HCkString);
function CkString_equals(objHandle: HCkString; str: pbyte): wordbool;
function CkString_equalsIgnoreCase(objHandle: HCkString; str: pbyte): wordbool;
function CkString_equalsIgnoreCaseStr(objHandle: HCkString; strObj: HCkString): wordbool;
function CkString_equalsIgnoreCaseW(objHandle: HCkString; s: PWideChar): wordbool;
function CkString_equalsStr(objHandle: HCkString; strObj: HCkString): wordbool;
function CkString_equalsW(objHandle: HCkString; s: PWideChar): wordbool;
function CkString_getChar(objHandle: HCkString; idx: Integer): HCkString;
function CkString_getEnc(objHandle: HCkString; encoding: pbyte): pbyte;
function CkString_getNumChars(objHandle: HCkString): Integer;
function CkString_getSizeAnsi(objHandle: HCkString): Integer;
function CkString_getSizeUnicode(objHandle: HCkString): Integer;
function CkString_getSizeUtf8(objHandle: HCkString): Integer;
function CkString_getString(objHandle: HCkString): pbyte;
function CkString_getStringAnsi(objHandle: HCkString): pbyte;
function CkString_getStringUtf8(objHandle: HCkString): pbyte;
function CkString_getUnicode(objHandle: HCkString): PWideChar;
procedure CkString_hexDecode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_hexDecodeW(objHandle: HCkString; charsetEncoding: PWideChar);
procedure CkString_hexEncode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_hexEncodeW(objHandle: HCkString; charsetEncoding: PWideChar);
function CkString_indexOf(objHandle: HCkString; substr: pbyte): Integer;
function CkString_indexOfStr(objHandle: HCkString; substrObj: HCkString): Integer;
function CkString_indexOfW(objHandle: HCkString; s: PWideChar): Integer;
function CkString_intValue(objHandle: HCkString): Integer;
function CkString_isEmpty(objHandle: HCkString): wordbool;
function CkString_lastChar(objHandle: HCkString): Char;
function CkString_loadFile(objHandle: HCkString; path: pbyte; charsetEncoding: pbyte): wordbool;
function CkString_loadFileW(objHandle: HCkString; path: PWideChar; charsetEncoding: PWideChar): wordbool;
function CkString_matches(objHandle: HCkString; strPattern: pbyte): wordbool;
function CkString_matchesNoCase(objHandle: HCkString; strPattern: pbyte): wordbool;
function CkString_matchesNoCaseW(objHandle: HCkString; s: PWideChar): wordbool;
function CkString_matchesStr(objHandle: HCkString; strPatternObj: HCkString): wordbool;
function CkString_matchesW(objHandle: HCkString; s: PWideChar): wordbool;
procedure CkString_minimizeMemory(objHandle: HCkString);
procedure CkString_obfuscate(objHandle: HCkString);
procedure CkString_prepend(objHandle: HCkString; str: pbyte);
procedure CkString_prependW(objHandle: HCkString; s: PWideChar);
procedure CkString_punyDecode(objHandle: HCkString);
procedure CkString_punyEncode(objHandle: HCkString);
procedure CkString_qpDecode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_qpDecodeW(objHandle: HCkString; charset: PWideChar);
procedure CkString_qpEncode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_qpEncodeW(objHandle: HCkString; charset: PWideChar);
function CkString_removeAll(objHandle: HCkString; substr: HCkString): Integer;
procedure CkString_removeCharOccurances(objHandle: HCkString; ch: Char);
procedure CkString_removeChunk(objHandle: HCkString; charStartPos: Integer; numChars: Integer);
procedure CkString_removeDelimited(objHandle: HCkString; beginDelim: pbyte; endDelim: pbyte; caseSensitive: wordbool);
function CkString_removeFirst(objHandle: HCkString; substr: HCkString): wordbool;
function CkString_replaceAll(objHandle: HCkString; findStrObj: HCkString; replaceStrObj: HCkString): Integer;
function CkString_replaceAllOccurances(objHandle: HCkString; findStr: pbyte; replaceStr: pbyte): Integer;
function CkString_replaceAllOccurancesW(objHandle: HCkString; pattern: PWideChar; replacement: PWideChar): Integer;
procedure CkString_replaceChar(objHandle: HCkString; findCh: Char; replaceCh: Char);
function CkString_replaceFirst(objHandle: HCkString; findStrObj: HCkString; replaceStrObj: HCkString): wordbool;
function CkString_replaceFirstOccurance(objHandle: HCkString; findStr: pbyte; replaceStr: pbyte): wordbool;
function CkString_replaceFirstOccuranceW(objHandle: HCkString; pattern: PWideChar; replacement: PWideChar): wordbool;
function CkString_saveToFile(objHandle: HCkString; path: pbyte; charsetEncoding: pbyte): wordbool;
function CkString_saveToFileW(objHandle: HCkString; path: PWideChar; charset: PWideChar): wordbool;
procedure CkString_setStr(objHandle: HCkString; s: HCkString);
procedure CkString_setString(objHandle: HCkString; str: pbyte);
procedure CkString_setStringAnsi(objHandle: HCkString; s: pbyte);
procedure CkString_setStringU(objHandle: HCkString; unicode: PWideChar);
procedure CkString_setStringUtf8(objHandle: HCkString; s: pbyte);
procedure CkString_shorten(objHandle: HCkString; n: Integer);
function CkString_split(objHandle: HCkString; delimiterChar: Char; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray;
function CkString_split2(objHandle: HCkString; delimiterChars: pbyte; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray;
function CkString_split2W(objHandle: HCkString; splitCharSet: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray;
function CkString_splitAtWS(objHandle: HCkString): HCkStringArray;
function CkString_substring(objHandle: HCkString; startCharIndex: Integer; numChars: Integer): HCkString;
procedure CkString_toCRLF(objHandle: HCkString);
function CkString_tokenize(objHandle: HCkString; punctuation: pbyte): HCkStringArray;
function CkString_tokenizeW(objHandle: HCkString; punctuation: PWideChar): HCkStringArray;
procedure CkString_toLF(objHandle: HCkString);
procedure CkString_toLowerCase(objHandle: HCkString);
procedure CkString_toUpperCase(objHandle: HCkString);
procedure CkString_trim(objHandle: HCkString);
procedure CkString_trim2(objHandle: HCkString);
procedure CkString_trimInsideSpaces(objHandle: HCkString);
procedure CkString_unobfuscate(objHandle: HCkString);
procedure CkString_urlDecode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_urlDecodeW(objHandle: HCkString; charsetEncoding: PWideChar);
procedure CkString_urlEncode(objHandle: HCkString; charsetEncoding: pbyte);
procedure CkString_urlEncodeW(objHandle: HCkString; charsetEncoding: PWideChar);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkString_Create = function : HCkString; stdcall;
  TCkString_Dispose = procedure (handle: HCkString); stdcall;
  TCkString_getNumArabic = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumAscii = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumCentralEuro = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumChinese = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumCyrillic = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumGreek = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumHebrew = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumJapanese = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumKorean = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumLatin = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getNumThai = function (objHandle: HCkString): Integer; stdcall;
  TCkString_append = procedure (objHandle: HCkString; str: pbyte); stdcall;
  TCkString_appendAnsi = procedure (objHandle: HCkString; str: pbyte); stdcall;
  TCkString_appendChar = procedure (objHandle: HCkString; c: Char); stdcall;
  TCkString_appendCurrentDateRfc822 = procedure (objHandle: HCkString); stdcall;
  TCkString_appendEnc = procedure (objHandle: HCkString; str: pbyte; charsetEncoding: pbyte); stdcall;
  TCkString_appendInt = procedure (objHandle: HCkString; n: Integer); stdcall;
  TCkString_appendN = procedure (objHandle: HCkString; str: pbyte; numBytes: LongWord); stdcall;
  TCkString_appendNU = procedure (objHandle: HCkString; wideStr: PWideChar; numChars: Integer); stdcall;
  TCkString_appendRandom = procedure (objHandle: HCkString; numBytes: Integer; encoding: pbyte); stdcall;
  TCkString_appendStr = procedure (objHandle: HCkString; strObj: HCkString); stdcall;
  TCkString_appendU = procedure (objHandle: HCkString; unicode: PWideChar); stdcall;
  TCkString_appendUtf8 = procedure (objHandle: HCkString; str: pbyte); stdcall;
  TCkString_base64Decode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_base64DecodeW = procedure (objHandle: HCkString; charsetEncoding: PWideChar); stdcall;
  TCkString_base64Encode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_base64EncodeW = procedure (objHandle: HCkString; charsetEncoding: PWideChar); stdcall;
  TCkString_beginsWith = function (objHandle: HCkString; substr: pbyte): wordbool; stdcall;
  TCkString_beginsWithStr = function (objHandle: HCkString; strObj: HCkString): wordbool; stdcall;
  TCkString_beginsWithW = function (objHandle: HCkString; str: PWideChar): wordbool; stdcall;
  TCkString_charAt = function (objHandle: HCkString; idx: Integer): Char; stdcall;
  TCkString_charAtU = function (objHandle: HCkString; idx: Integer): WideChar; stdcall;
  TCkString_chopAtFirstChar = procedure (objHandle: HCkString; ch: Char); stdcall;
  TCkString_chopAtStr = procedure (objHandle: HCkString; subStrObj: HCkString); stdcall;
  TCkString_clear = procedure (objHandle: HCkString); stdcall;
  TCkString_clone = function (objHandle: HCkString): HCkString; stdcall;
  TCkString_compareStr = function (objHandle: HCkString; str: HCkString): Integer; stdcall;
  TCkString_containsSubstring = function (objHandle: HCkString; substr: pbyte): wordbool; stdcall;
  TCkString_containsSubstringNoCase = function (objHandle: HCkString; substr: pbyte): wordbool; stdcall;
  TCkString_containsSubstringNoCaseW = function (objHandle: HCkString; substr: PWideChar): wordbool; stdcall;
  TCkString_containsSubstringW = function (objHandle: HCkString; substr: PWideChar): wordbool; stdcall;
  TCkString_countCharOccurances = function (objHandle: HCkString; ch: Char): Integer; stdcall;
  TCkString_decodeXMLSpecial = procedure (objHandle: HCkString); stdcall;
  TCkString_doubleValue = function (objHandle: HCkString): Double; stdcall;
  TCkString_eliminateChar = procedure (objHandle: HCkString; ansiChar: Char; startIndex: Integer); stdcall;
  TCkString_encodeXMLSpecial = procedure (objHandle: HCkString); stdcall;
  TCkString_endsWith = function (objHandle: HCkString; substr: pbyte): wordbool; stdcall;
  TCkString_endsWithStr = function (objHandle: HCkString; substrObj: HCkString): wordbool; stdcall;
  TCkString_endsWithW = function (objHandle: HCkString; s: PWideChar): wordbool; stdcall;
  TCkString_entityDecode = procedure (objHandle: HCkString); stdcall;
  TCkString_entityEncode = procedure (objHandle: HCkString); stdcall;
  TCkString_equals = function (objHandle: HCkString; str: pbyte): wordbool; stdcall;
  TCkString_equalsIgnoreCase = function (objHandle: HCkString; str: pbyte): wordbool; stdcall;
  TCkString_equalsIgnoreCaseStr = function (objHandle: HCkString; strObj: HCkString): wordbool; stdcall;
  TCkString_equalsIgnoreCaseW = function (objHandle: HCkString; s: PWideChar): wordbool; stdcall;
  TCkString_equalsStr = function (objHandle: HCkString; strObj: HCkString): wordbool; stdcall;
  TCkString_equalsW = function (objHandle: HCkString; s: PWideChar): wordbool; stdcall;
  TCkString_getChar = function (objHandle: HCkString; idx: Integer): HCkString; stdcall;
  TCkString_getEnc = function (objHandle: HCkString; encoding: pbyte): pbyte; stdcall;
  TCkString_getNumChars = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getSizeAnsi = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getSizeUnicode = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getSizeUtf8 = function (objHandle: HCkString): Integer; stdcall;
  TCkString_getString = function (objHandle: HCkString): pbyte; stdcall;
  TCkString_getStringAnsi = function (objHandle: HCkString): pbyte; stdcall;
  TCkString_getStringUtf8 = function (objHandle: HCkString): pbyte; stdcall;
  TCkString_getUnicode = function (objHandle: HCkString): PWideChar; stdcall;
  TCkString_hexDecode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_hexDecodeW = procedure (objHandle: HCkString; charsetEncoding: PWideChar); stdcall;
  TCkString_hexEncode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_hexEncodeW = procedure (objHandle: HCkString; charsetEncoding: PWideChar); stdcall;
  TCkString_indexOf = function (objHandle: HCkString; substr: pbyte): Integer; stdcall;
  TCkString_indexOfStr = function (objHandle: HCkString; substrObj: HCkString): Integer; stdcall;
  TCkString_indexOfW = function (objHandle: HCkString; s: PWideChar): Integer; stdcall;
  TCkString_intValue = function (objHandle: HCkString): Integer; stdcall;
  TCkString_isEmpty = function (objHandle: HCkString): wordbool; stdcall;
  TCkString_lastChar = function (objHandle: HCkString): Char; stdcall;
  TCkString_loadFile = function (objHandle: HCkString; path: pbyte; charsetEncoding: pbyte): wordbool; stdcall;
  TCkString_loadFileW = function (objHandle: HCkString; path: PWideChar; charsetEncoding: PWideChar): wordbool; stdcall;
  TCkString_matches = function (objHandle: HCkString; strPattern: pbyte): wordbool; stdcall;
  TCkString_matchesNoCase = function (objHandle: HCkString; strPattern: pbyte): wordbool; stdcall;
  TCkString_matchesNoCaseW = function (objHandle: HCkString; s: PWideChar): wordbool; stdcall;
  TCkString_matchesStr = function (objHandle: HCkString; strPatternObj: HCkString): wordbool; stdcall;
  TCkString_matchesW = function (objHandle: HCkString; s: PWideChar): wordbool; stdcall;
  TCkString_minimizeMemory = procedure (objHandle: HCkString); stdcall;
  TCkString_obfuscate = procedure (objHandle: HCkString); stdcall;
  TCkString_prepend = procedure (objHandle: HCkString; str: pbyte); stdcall;
  TCkString_prependW = procedure (objHandle: HCkString; s: PWideChar); stdcall;
  TCkString_punyDecode = procedure (objHandle: HCkString); stdcall;
  TCkString_punyEncode = procedure (objHandle: HCkString); stdcall;
  TCkString_qpDecode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_qpDecodeW = procedure (objHandle: HCkString; charset: PWideChar); stdcall;
  TCkString_qpEncode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_qpEncodeW = procedure (objHandle: HCkString; charset: PWideChar); stdcall;
  TCkString_removeAll = function (objHandle: HCkString; substr: HCkString): Integer; stdcall;
  TCkString_removeCharOccurances = procedure (objHandle: HCkString; ch: Char); stdcall;
  TCkString_removeChunk = procedure (objHandle: HCkString; charStartPos: Integer; numChars: Integer); stdcall;
  TCkString_removeDelimited = procedure (objHandle: HCkString; beginDelim: pbyte; endDelim: pbyte; caseSensitive: wordbool); stdcall;
  TCkString_removeFirst = function (objHandle: HCkString; substr: HCkString): wordbool; stdcall;
  TCkString_replaceAll = function (objHandle: HCkString; findStrObj: HCkString; replaceStrObj: HCkString): Integer; stdcall;
  TCkString_replaceAllOccurances = function (objHandle: HCkString; findStr: pbyte; replaceStr: pbyte): Integer; stdcall;
  TCkString_replaceAllOccurancesW = function (objHandle: HCkString; pattern: PWideChar; replacement: PWideChar): Integer; stdcall;
  TCkString_replaceChar = procedure (objHandle: HCkString; findCh: Char; replaceCh: Char); stdcall;
  TCkString_replaceFirst = function (objHandle: HCkString; findStrObj: HCkString; replaceStrObj: HCkString): wordbool; stdcall;
  TCkString_replaceFirstOccurance = function (objHandle: HCkString; findStr: pbyte; replaceStr: pbyte): wordbool; stdcall;
  TCkString_replaceFirstOccuranceW = function (objHandle: HCkString; pattern: PWideChar; replacement: PWideChar): wordbool; stdcall;
  TCkString_saveToFile = function (objHandle: HCkString; path: pbyte; charsetEncoding: pbyte): wordbool; stdcall;
  TCkString_saveToFileW = function (objHandle: HCkString; path: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkString_setStr = procedure (objHandle: HCkString; s: HCkString); stdcall;
  TCkString_setString = procedure (objHandle: HCkString; str: pbyte); stdcall;
  TCkString_setStringAnsi = procedure (objHandle: HCkString; s: pbyte); stdcall;
  TCkString_setStringU = procedure (objHandle: HCkString; unicode: PWideChar); stdcall;
  TCkString_setStringUtf8 = procedure (objHandle: HCkString; s: pbyte); stdcall;
  TCkString_shorten = procedure (objHandle: HCkString; n: Integer); stdcall;
  TCkString_split = function (objHandle: HCkString; delimiterChar: Char; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray; stdcall;
  TCkString_split2 = function (objHandle: HCkString; delimiterChars: pbyte; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray; stdcall;
  TCkString_split2W = function (objHandle: HCkString; splitCharSet: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray; stdcall;
  TCkString_splitAtWS = function (objHandle: HCkString): HCkStringArray; stdcall;
  TCkString_substring = function (objHandle: HCkString; startCharIndex: Integer; numChars: Integer): HCkString; stdcall;
  TCkString_toCRLF = procedure (objHandle: HCkString); stdcall;
  TCkString_tokenize = function (objHandle: HCkString; punctuation: pbyte): HCkStringArray; stdcall;
  TCkString_tokenizeW = function (objHandle: HCkString; punctuation: PWideChar): HCkStringArray; stdcall;
  TCkString_toLF = procedure (objHandle: HCkString); stdcall;
  TCkString_toLowerCase = procedure (objHandle: HCkString); stdcall;
  TCkString_toUpperCase = procedure (objHandle: HCkString); stdcall;
  TCkString_trim = procedure (objHandle: HCkString); stdcall;
  TCkString_trim2 = procedure (objHandle: HCkString); stdcall;
  TCkString_trimInsideSpaces = procedure (objHandle: HCkString); stdcall;
  TCkString_unobfuscate = procedure (objHandle: HCkString); stdcall;
  TCkString_urlDecode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_urlDecodeW = procedure (objHandle: HCkString; charsetEncoding: PWideChar); stdcall;
  TCkString_urlEncode = procedure (objHandle: HCkString; charsetEncoding: pbyte); stdcall;
  TCkString_urlEncodeW = procedure (objHandle: HCkString; charsetEncoding: PWideChar); stdcall;

var
  _fkt_ptr_arr:   array [0..134] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkString_Create : HCkString;
begin
  result := TCkString_Create(_map(0, 'CkString_Create'));
end;

procedure CkString_Dispose (handle: HCkString);
begin
  TCkString_Dispose(_map(1, 'CkString_Dispose'))
    (handle);
end;


function CkString_getNumArabic (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumArabic(_map(2, 'CkString_getNumArabic'))
    (objHandle);
end;

function CkString_getNumAscii (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumAscii(_map(3, 'CkString_getNumAscii'))
    (objHandle);
end;

function CkString_getNumCentralEuro (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumCentralEuro(_map(4, 'CkString_getNumCentralEuro'))
    (objHandle);
end;

function CkString_getNumChinese (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumChinese(_map(5, 'CkString_getNumChinese'))
    (objHandle);
end;

function CkString_getNumCyrillic (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumCyrillic(_map(6, 'CkString_getNumCyrillic'))
    (objHandle);
end;

function CkString_getNumGreek (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumGreek(_map(7, 'CkString_getNumGreek'))
    (objHandle);
end;

function CkString_getNumHebrew (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumHebrew(_map(8, 'CkString_getNumHebrew'))
    (objHandle);
end;

function CkString_getNumJapanese (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumJapanese(_map(9, 'CkString_getNumJapanese'))
    (objHandle);
end;

function CkString_getNumKorean (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumKorean(_map(10, 'CkString_getNumKorean'))
    (objHandle);
end;

function CkString_getNumLatin (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumLatin(_map(11, 'CkString_getNumLatin'))
    (objHandle);
end;

function CkString_getNumThai (objHandle: HCkString): Integer;
begin
    result := TCkString_getNumThai(_map(12, 'CkString_getNumThai'))
    (objHandle);
end;

procedure CkString_append (objHandle: HCkString; str: pbyte);
begin
  TCkString_append(_map(13, 'CkString_append'))
    (objHandle, str);
end;

procedure CkString_appendAnsi (objHandle: HCkString; str: pbyte);
begin
  TCkString_appendAnsi(_map(14, 'CkString_appendAnsi'))
    (objHandle, str);
end;

procedure CkString_appendChar (objHandle: HCkString; c: Char);
begin
  TCkString_appendChar(_map(15, 'CkString_appendChar'))
    (objHandle, c);
end;

procedure CkString_appendCurrentDateRfc822 (objHandle: HCkString);
begin
  TCkString_appendCurrentDateRfc822(_map(16, 'CkString_appendCurrentDateRfc822'))
    (objHandle);
end;

procedure CkString_appendEnc (objHandle: HCkString; str: pbyte; charsetEncoding: pbyte);
begin
  TCkString_appendEnc(_map(17, 'CkString_appendEnc'))
    (objHandle, str, charsetEncoding);
end;

procedure CkString_appendInt (objHandle: HCkString; n: Integer);
begin
  TCkString_appendInt(_map(18, 'CkString_appendInt'))
    (objHandle, n);
end;

procedure CkString_appendN (objHandle: HCkString; str: pbyte; numBytes: LongWord);
begin
  TCkString_appendN(_map(19, 'CkString_appendN'))
    (objHandle, str, numBytes);
end;

procedure CkString_appendNU (objHandle: HCkString; wideStr: PWideChar; numChars: Integer);
begin
  TCkString_appendNU(_map(20, 'CkString_appendNU'))
    (objHandle, wideStr, numChars);
end;

procedure CkString_appendRandom (objHandle: HCkString; numBytes: Integer; encoding: pbyte);
begin
  TCkString_appendRandom(_map(21, 'CkString_appendRandom'))
    (objHandle, numBytes, encoding);
end;

procedure CkString_appendStr (objHandle: HCkString; strObj: HCkString);
begin
  TCkString_appendStr(_map(22, 'CkString_appendStr'))
    (objHandle, strObj);
end;

procedure CkString_appendU (objHandle: HCkString; unicode: PWideChar);
begin
  TCkString_appendU(_map(23, 'CkString_appendU'))
    (objHandle, unicode);
end;

procedure CkString_appendUtf8 (objHandle: HCkString; str: pbyte);
begin
  TCkString_appendUtf8(_map(24, 'CkString_appendUtf8'))
    (objHandle, str);
end;

procedure CkString_base64Decode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_base64Decode(_map(25, 'CkString_base64Decode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_base64DecodeW (objHandle: HCkString; charsetEncoding: PWideChar);
begin
  TCkString_base64DecodeW(_map(26, 'CkString_base64DecodeW'))
    (objHandle, charsetEncoding);
end;

procedure CkString_base64Encode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_base64Encode(_map(27, 'CkString_base64Encode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_base64EncodeW (objHandle: HCkString; charsetEncoding: PWideChar);
begin
  TCkString_base64EncodeW(_map(28, 'CkString_base64EncodeW'))
    (objHandle, charsetEncoding);
end;

function CkString_beginsWith (objHandle: HCkString; substr: pbyte): wordbool;
begin
  result := TCkString_beginsWith(_map(29, 'CkString_beginsWith'))
    (objHandle, substr);
end;

function CkString_beginsWithStr (objHandle: HCkString; strObj: HCkString): wordbool;
begin
  result := TCkString_beginsWithStr(_map(30, 'CkString_beginsWithStr'))
    (objHandle, strObj);
end;

function CkString_beginsWithW (objHandle: HCkString; str: PWideChar): wordbool;
begin
  result := TCkString_beginsWithW(_map(31, 'CkString_beginsWithW'))
    (objHandle, str);
end;

function CkString_charAt (objHandle: HCkString; idx: Integer): Char;
begin
  result := TCkString_charAt(_map(32, 'CkString_charAt'))
    (objHandle, idx);
end;

function CkString_charAtU (objHandle: HCkString; idx: Integer): WideChar;
begin
  result := TCkString_charAtU(_map(33, 'CkString_charAtU'))
    (objHandle, idx);
end;

procedure CkString_chopAtFirstChar (objHandle: HCkString; ch: Char);
begin
  TCkString_chopAtFirstChar(_map(34, 'CkString_chopAtFirstChar'))
    (objHandle, ch);
end;

procedure CkString_chopAtStr (objHandle: HCkString; subStrObj: HCkString);
begin
  TCkString_chopAtStr(_map(35, 'CkString_chopAtStr'))
    (objHandle, subStrObj);
end;

procedure CkString_clear (objHandle: HCkString);
begin
  TCkString_clear(_map(36, 'CkString_clear'))
    (objHandle);
end;

function CkString_clone (objHandle: HCkString): HCkString;
begin
  result := TCkString_clone(_map(37, 'CkString_clone'))
    (objHandle);
end;

function CkString_compareStr (objHandle: HCkString; str: HCkString): Integer;
begin
  result := TCkString_compareStr(_map(38, 'CkString_compareStr'))
    (objHandle, str);
end;

function CkString_containsSubstring (objHandle: HCkString; substr: pbyte): wordbool;
begin
  result := TCkString_containsSubstring(_map(39, 'CkString_containsSubstring'))
    (objHandle, substr);
end;

function CkString_containsSubstringNoCase (objHandle: HCkString; substr: pbyte): wordbool;
begin
  result := TCkString_containsSubstringNoCase(_map(40, 'CkString_containsSubstringNoCase'))
    (objHandle, substr);
end;

function CkString_containsSubstringNoCaseW (objHandle: HCkString; substr: PWideChar): wordbool;
begin
  result := TCkString_containsSubstringNoCaseW(_map(41, 'CkString_containsSubstringNoCaseW'))
    (objHandle, substr);
end;

function CkString_containsSubstringW (objHandle: HCkString; substr: PWideChar): wordbool;
begin
  result := TCkString_containsSubstringW(_map(42, 'CkString_containsSubstringW'))
    (objHandle, substr);
end;

function CkString_countCharOccurances (objHandle: HCkString; ch: Char): Integer;
begin
  result := TCkString_countCharOccurances(_map(43, 'CkString_countCharOccurances'))
    (objHandle, ch);
end;

procedure CkString_decodeXMLSpecial (objHandle: HCkString);
begin
  TCkString_decodeXMLSpecial(_map(44, 'CkString_decodeXMLSpecial'))
    (objHandle);
end;

function CkString_doubleValue (objHandle: HCkString): Double;
begin
  result := TCkString_doubleValue(_map(45, 'CkString_doubleValue'))
    (objHandle);
end;

procedure CkString_eliminateChar (objHandle: HCkString; ansiChar: Char; startIndex: Integer);
begin
  TCkString_eliminateChar(_map(46, 'CkString_eliminateChar'))
    (objHandle, ansiChar, startIndex);
end;

procedure CkString_encodeXMLSpecial (objHandle: HCkString);
begin
  TCkString_encodeXMLSpecial(_map(47, 'CkString_encodeXMLSpecial'))
    (objHandle);
end;

function CkString_endsWith (objHandle: HCkString; substr: pbyte): wordbool;
begin
  result := TCkString_endsWith(_map(48, 'CkString_endsWith'))
    (objHandle, substr);
end;

function CkString_endsWithStr (objHandle: HCkString; substrObj: HCkString): wordbool;
begin
  result := TCkString_endsWithStr(_map(49, 'CkString_endsWithStr'))
    (objHandle, substrObj);
end;

function CkString_endsWithW (objHandle: HCkString; s: PWideChar): wordbool;
begin
  result := TCkString_endsWithW(_map(50, 'CkString_endsWithW'))
    (objHandle, s);
end;

procedure CkString_entityDecode (objHandle: HCkString);
begin
  TCkString_entityDecode(_map(51, 'CkString_entityDecode'))
    (objHandle);
end;

procedure CkString_entityEncode (objHandle: HCkString);
begin
  TCkString_entityEncode(_map(52, 'CkString_entityEncode'))
    (objHandle);
end;

function CkString_equals (objHandle: HCkString; str: pbyte): wordbool;
begin
  result := TCkString_equals(_map(53, 'CkString_equals'))
    (objHandle, str);
end;

function CkString_equalsIgnoreCase (objHandle: HCkString; str: pbyte): wordbool;
begin
  result := TCkString_equalsIgnoreCase(_map(54, 'CkString_equalsIgnoreCase'))
    (objHandle, str);
end;

function CkString_equalsIgnoreCaseStr (objHandle: HCkString; strObj: HCkString): wordbool;
begin
  result := TCkString_equalsIgnoreCaseStr(_map(55, 'CkString_equalsIgnoreCaseStr'))
    (objHandle, strObj);
end;

function CkString_equalsIgnoreCaseW (objHandle: HCkString; s: PWideChar): wordbool;
begin
  result := TCkString_equalsIgnoreCaseW(_map(56, 'CkString_equalsIgnoreCaseW'))
    (objHandle, s);
end;

function CkString_equalsStr (objHandle: HCkString; strObj: HCkString): wordbool;
begin
  result := TCkString_equalsStr(_map(57, 'CkString_equalsStr'))
    (objHandle, strObj);
end;

function CkString_equalsW (objHandle: HCkString; s: PWideChar): wordbool;
begin
  result := TCkString_equalsW(_map(58, 'CkString_equalsW'))
    (objHandle, s);
end;

function CkString_getChar (objHandle: HCkString; idx: Integer): HCkString;
begin
  result := TCkString_getChar(_map(59, 'CkString_getChar'))
    (objHandle, idx);
end;

function CkString_getEnc (objHandle: HCkString; encoding: pbyte): pbyte;
begin
  result := TCkString_getEnc(_map(60, 'CkString_getEnc'))
    (objHandle, encoding);
end;

function CkString_getNumChars (objHandle: HCkString): Integer;
begin
  result := TCkString_getNumChars(_map(61, 'CkString_getNumChars'))
    (objHandle);
end;

function CkString_getSizeAnsi (objHandle: HCkString): Integer;
begin
  result := TCkString_getSizeAnsi(_map(62, 'CkString_getSizeAnsi'))
    (objHandle);
end;

function CkString_getSizeUnicode (objHandle: HCkString): Integer;
begin
  result := TCkString_getSizeUnicode(_map(63, 'CkString_getSizeUnicode'))
    (objHandle);
end;

function CkString_getSizeUtf8 (objHandle: HCkString): Integer;
begin
  result := TCkString_getSizeUtf8(_map(64, 'CkString_getSizeUtf8'))
    (objHandle);
end;

function CkString_getString (objHandle: HCkString): pbyte;
begin
  result := TCkString_getString(_map(65, 'CkString_getString'))
    (objHandle);
end;

function CkString_getStringAnsi (objHandle: HCkString): pbyte;
begin
  result := TCkString_getStringAnsi(_map(66, 'CkString_getStringAnsi'))
    (objHandle);
end;

function CkString_getStringUtf8 (objHandle: HCkString): pbyte;
begin
  result := TCkString_getStringUtf8(_map(67, 'CkString_getStringUtf8'))
    (objHandle);
end;

function CkString_getUnicode (objHandle: HCkString): PWideChar;
begin
  result := TCkString_getUnicode(_map(68, 'CkString_getUnicode'))
    (objHandle);
end;

procedure CkString_hexDecode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_hexDecode(_map(69, 'CkString_hexDecode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_hexDecodeW (objHandle: HCkString; charsetEncoding: PWideChar);
begin
  TCkString_hexDecodeW(_map(70, 'CkString_hexDecodeW'))
    (objHandle, charsetEncoding);
end;

procedure CkString_hexEncode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_hexEncode(_map(71, 'CkString_hexEncode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_hexEncodeW (objHandle: HCkString; charsetEncoding: PWideChar);
begin
  TCkString_hexEncodeW(_map(72, 'CkString_hexEncodeW'))
    (objHandle, charsetEncoding);
end;

function CkString_indexOf (objHandle: HCkString; substr: pbyte): Integer;
begin
  result := TCkString_indexOf(_map(73, 'CkString_indexOf'))
    (objHandle, substr);
end;

function CkString_indexOfStr (objHandle: HCkString; substrObj: HCkString): Integer;
begin
  result := TCkString_indexOfStr(_map(74, 'CkString_indexOfStr'))
    (objHandle, substrObj);
end;

function CkString_indexOfW (objHandle: HCkString; s: PWideChar): Integer;
begin
  result := TCkString_indexOfW(_map(75, 'CkString_indexOfW'))
    (objHandle, s);
end;

function CkString_intValue (objHandle: HCkString): Integer;
begin
  result := TCkString_intValue(_map(76, 'CkString_intValue'))
    (objHandle);
end;

function CkString_isEmpty (objHandle: HCkString): wordbool;
begin
  result := TCkString_isEmpty(_map(77, 'CkString_isEmpty'))
    (objHandle);
end;

function CkString_lastChar (objHandle: HCkString): Char;
begin
  result := TCkString_lastChar(_map(78, 'CkString_lastChar'))
    (objHandle);
end;

function CkString_loadFile (objHandle: HCkString; path: pbyte; charsetEncoding: pbyte): wordbool;
begin
  result := TCkString_loadFile(_map(79, 'CkString_loadFile'))
    (objHandle, path, charsetEncoding);
end;

function CkString_loadFileW (objHandle: HCkString; path: PWideChar; charsetEncoding: PWideChar): wordbool;
begin
  result := TCkString_loadFileW(_map(80, 'CkString_loadFileW'))
    (objHandle, path, charsetEncoding);
end;

function CkString_matches (objHandle: HCkString; strPattern: pbyte): wordbool;
begin
  result := TCkString_matches(_map(81, 'CkString_matches'))
    (objHandle, strPattern);
end;

function CkString_matchesNoCase (objHandle: HCkString; strPattern: pbyte): wordbool;
begin
  result := TCkString_matchesNoCase(_map(82, 'CkString_matchesNoCase'))
    (objHandle, strPattern);
end;

function CkString_matchesNoCaseW (objHandle: HCkString; s: PWideChar): wordbool;
begin
  result := TCkString_matchesNoCaseW(_map(83, 'CkString_matchesNoCaseW'))
    (objHandle, s);
end;

function CkString_matchesStr (objHandle: HCkString; strPatternObj: HCkString): wordbool;
begin
  result := TCkString_matchesStr(_map(84, 'CkString_matchesStr'))
    (objHandle, strPatternObj);
end;

function CkString_matchesW (objHandle: HCkString; s: PWideChar): wordbool;
begin
  result := TCkString_matchesW(_map(85, 'CkString_matchesW'))
    (objHandle, s);
end;

procedure CkString_minimizeMemory (objHandle: HCkString);
begin
  TCkString_minimizeMemory(_map(86, 'CkString_minimizeMemory'))
    (objHandle);
end;

procedure CkString_obfuscate (objHandle: HCkString);
begin
  TCkString_obfuscate(_map(87, 'CkString_obfuscate'))
    (objHandle);
end;

procedure CkString_prepend (objHandle: HCkString; str: pbyte);
begin
  TCkString_prepend(_map(88, 'CkString_prepend'))
    (objHandle, str);
end;

procedure CkString_prependW (objHandle: HCkString; s: PWideChar);
begin
  TCkString_prependW(_map(89, 'CkString_prependW'))
    (objHandle, s);
end;

procedure CkString_punyDecode (objHandle: HCkString);
begin
  TCkString_punyDecode(_map(90, 'CkString_punyDecode'))
    (objHandle);
end;

procedure CkString_punyEncode (objHandle: HCkString);
begin
  TCkString_punyEncode(_map(91, 'CkString_punyEncode'))
    (objHandle);
end;

procedure CkString_qpDecode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_qpDecode(_map(92, 'CkString_qpDecode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_qpDecodeW (objHandle: HCkString; charset: PWideChar);
begin
  TCkString_qpDecodeW(_map(93, 'CkString_qpDecodeW'))
    (objHandle, charset);
end;

procedure CkString_qpEncode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_qpEncode(_map(94, 'CkString_qpEncode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_qpEncodeW (objHandle: HCkString; charset: PWideChar);
begin
  TCkString_qpEncodeW(_map(95, 'CkString_qpEncodeW'))
    (objHandle, charset);
end;

function CkString_removeAll (objHandle: HCkString; substr: HCkString): Integer;
begin
  result := TCkString_removeAll(_map(96, 'CkString_removeAll'))
    (objHandle, substr);
end;

procedure CkString_removeCharOccurances (objHandle: HCkString; ch: Char);
begin
  TCkString_removeCharOccurances(_map(97, 'CkString_removeCharOccurances'))
    (objHandle, ch);
end;

procedure CkString_removeChunk (objHandle: HCkString; charStartPos: Integer; numChars: Integer);
begin
  TCkString_removeChunk(_map(98, 'CkString_removeChunk'))
    (objHandle, charStartPos, numChars);
end;

procedure CkString_removeDelimited (objHandle: HCkString; beginDelim: pbyte; endDelim: pbyte; caseSensitive: wordbool);
begin
  TCkString_removeDelimited(_map(99, 'CkString_removeDelimited'))
    (objHandle, beginDelim, endDelim, caseSensitive);
end;

function CkString_removeFirst (objHandle: HCkString; substr: HCkString): wordbool;
begin
  result := TCkString_removeFirst(_map(100, 'CkString_removeFirst'))
    (objHandle, substr);
end;

function CkString_replaceAll (objHandle: HCkString; findStrObj: HCkString; replaceStrObj: HCkString): Integer;
begin
  result := TCkString_replaceAll(_map(101, 'CkString_replaceAll'))
    (objHandle, findStrObj, replaceStrObj);
end;

function CkString_replaceAllOccurances (objHandle: HCkString; findStr: pbyte; replaceStr: pbyte): Integer;
begin
  result := TCkString_replaceAllOccurances(_map(102, 'CkString_replaceAllOccurances'))
    (objHandle, findStr, replaceStr);
end;

function CkString_replaceAllOccurancesW (objHandle: HCkString; pattern: PWideChar; replacement: PWideChar): Integer;
begin
  result := TCkString_replaceAllOccurancesW(_map(103, 'CkString_replaceAllOccurancesW'))
    (objHandle, pattern, replacement);
end;

procedure CkString_replaceChar (objHandle: HCkString; findCh: Char; replaceCh: Char);
begin
  TCkString_replaceChar(_map(104, 'CkString_replaceChar'))
    (objHandle, findCh, replaceCh);
end;

function CkString_replaceFirst (objHandle: HCkString; findStrObj: HCkString; replaceStrObj: HCkString): wordbool;
begin
  result := TCkString_replaceFirst(_map(105, 'CkString_replaceFirst'))
    (objHandle, findStrObj, replaceStrObj);
end;

function CkString_replaceFirstOccurance (objHandle: HCkString; findStr: pbyte; replaceStr: pbyte): wordbool;
begin
  result := TCkString_replaceFirstOccurance(_map(106, 'CkString_replaceFirstOccurance'))
    (objHandle, findStr, replaceStr);
end;

function CkString_replaceFirstOccuranceW (objHandle: HCkString; pattern: PWideChar; replacement: PWideChar): wordbool;
begin
  result := TCkString_replaceFirstOccuranceW(_map(107, 'CkString_replaceFirstOccuranceW'))
    (objHandle, pattern, replacement);
end;

function CkString_saveToFile (objHandle: HCkString; path: pbyte; charsetEncoding: pbyte): wordbool;
begin
  result := TCkString_saveToFile(_map(108, 'CkString_saveToFile'))
    (objHandle, path, charsetEncoding);
end;

function CkString_saveToFileW (objHandle: HCkString; path: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkString_saveToFileW(_map(109, 'CkString_saveToFileW'))
    (objHandle, path, charset);
end;

procedure CkString_setStr (objHandle: HCkString; s: HCkString);
begin
  TCkString_setStr(_map(110, 'CkString_setStr'))
    (objHandle, s);
end;

procedure CkString_setString (objHandle: HCkString; str: pbyte);
begin
  TCkString_setString(_map(111, 'CkString_setString'))
    (objHandle, str);
end;

procedure CkString_setStringAnsi (objHandle: HCkString; s: pbyte);
begin
  TCkString_setStringAnsi(_map(112, 'CkString_setStringAnsi'))
    (objHandle, s);
end;

procedure CkString_setStringU (objHandle: HCkString; unicode: PWideChar);
begin
  TCkString_setStringU(_map(113, 'CkString_setStringU'))
    (objHandle, unicode);
end;

procedure CkString_setStringUtf8 (objHandle: HCkString; s: pbyte);
begin
  TCkString_setStringUtf8(_map(114, 'CkString_setStringUtf8'))
    (objHandle, s);
end;

procedure CkString_shorten (objHandle: HCkString; n: Integer);
begin
  TCkString_shorten(_map(115, 'CkString_shorten'))
    (objHandle, n);
end;

function CkString_split (objHandle: HCkString; delimiterChar: Char; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray;
begin
  result := TCkString_split(_map(116, 'CkString_split'))
    (objHandle, delimiterChar, exceptDoubleQuoted, exceptEscaped, keepEmpty);
end;

function CkString_split2 (objHandle: HCkString; delimiterChars: pbyte; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray;
begin
  result := TCkString_split2(_map(117, 'CkString_split2'))
    (objHandle, delimiterChars, exceptDoubleQuoted, exceptEscaped, keepEmpty);
end;

function CkString_split2W (objHandle: HCkString; splitCharSet: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; keepEmpty: wordbool): HCkStringArray;
begin
  result := TCkString_split2W(_map(118, 'CkString_split2W'))
    (objHandle, splitCharSet, exceptDoubleQuoted, exceptEscaped, keepEmpty);
end;

function CkString_splitAtWS (objHandle: HCkString): HCkStringArray;
begin
  result := TCkString_splitAtWS(_map(119, 'CkString_splitAtWS'))
    (objHandle);
end;

function CkString_substring (objHandle: HCkString; startCharIndex: Integer; numChars: Integer): HCkString;
begin
  result := TCkString_substring(_map(120, 'CkString_substring'))
    (objHandle, startCharIndex, numChars);
end;

procedure CkString_toCRLF (objHandle: HCkString);
begin
  TCkString_toCRLF(_map(121, 'CkString_toCRLF'))
    (objHandle);
end;

function CkString_tokenize (objHandle: HCkString; punctuation: pbyte): HCkStringArray;
begin
  result := TCkString_tokenize(_map(122, 'CkString_tokenize'))
    (objHandle, punctuation);
end;

function CkString_tokenizeW (objHandle: HCkString; punctuation: PWideChar): HCkStringArray;
begin
  result := TCkString_tokenizeW(_map(123, 'CkString_tokenizeW'))
    (objHandle, punctuation);
end;

procedure CkString_toLF (objHandle: HCkString);
begin
  TCkString_toLF(_map(124, 'CkString_toLF'))
    (objHandle);
end;

procedure CkString_toLowerCase (objHandle: HCkString);
begin
  TCkString_toLowerCase(_map(125, 'CkString_toLowerCase'))
    (objHandle);
end;

procedure CkString_toUpperCase (objHandle: HCkString);
begin
  TCkString_toUpperCase(_map(126, 'CkString_toUpperCase'))
    (objHandle);
end;

procedure CkString_trim (objHandle: HCkString);
begin
  TCkString_trim(_map(127, 'CkString_trim'))
    (objHandle);
end;

procedure CkString_trim2 (objHandle: HCkString);
begin
  TCkString_trim2(_map(128, 'CkString_trim2'))
    (objHandle);
end;

procedure CkString_trimInsideSpaces (objHandle: HCkString);
begin
  TCkString_trimInsideSpaces(_map(129, 'CkString_trimInsideSpaces'))
    (objHandle);
end;

procedure CkString_unobfuscate (objHandle: HCkString);
begin
  TCkString_unobfuscate(_map(130, 'CkString_unobfuscate'))
    (objHandle);
end;

procedure CkString_urlDecode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_urlDecode(_map(131, 'CkString_urlDecode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_urlDecodeW (objHandle: HCkString; charsetEncoding: PWideChar);
begin
  TCkString_urlDecodeW(_map(132, 'CkString_urlDecodeW'))
    (objHandle, charsetEncoding);
end;

procedure CkString_urlEncode (objHandle: HCkString; charsetEncoding: pbyte);
begin
  TCkString_urlEncode(_map(133, 'CkString_urlEncode'))
    (objHandle, charsetEncoding);
end;

procedure CkString_urlEncodeW (objHandle: HCkString; charsetEncoding: PWideChar);
begin
  TCkString_urlEncodeW(_map(134, 'CkString_urlEncodeW'))
    (objHandle, charsetEncoding);
end;

end.
