unit Csv;

interface

type

HCkStringTable = Pointer;
HCkCsv = Pointer;
HCkStringBuilder = Pointer;
HCkZip = Pointer;
HCkString = Pointer;


function CkCsv_Create: HCkCsv;  stdcall;
procedure CkCsv_Dispose(handle: HCkCsv); stdcall;
function CkCsv_getAutoTrim(objHandle: HCkCsv): wordbool;
procedure CkCsv_putAutoTrim(objHandle: HCkCsv; newPropVal: wordbool);
function CkCsv_getCrlf(objHandle: HCkCsv): wordbool;
procedure CkCsv_putCrlf(objHandle: HCkCsv; newPropVal: wordbool);
procedure CkCsv_getDebugLogFilePath(objHandle: HCkCsv; outPropVal: HCkString);
procedure CkCsv_putDebugLogFilePath(objHandle: HCkCsv; newPropVal: PWideChar);
function CkCsv__debugLogFilePath(objHandle: HCkCsv): PWideChar;
procedure CkCsv_getDelimiter(objHandle: HCkCsv; outPropVal: HCkString);
procedure CkCsv_putDelimiter(objHandle: HCkCsv; newPropVal: PWideChar);
function CkCsv__delimiter(objHandle: HCkCsv): PWideChar;
function CkCsv_getEnableQuotes(objHandle: HCkCsv): wordbool;
procedure CkCsv_putEnableQuotes(objHandle: HCkCsv; newPropVal: wordbool);
function CkCsv_getEscapeBackslash(objHandle: HCkCsv): wordbool;
procedure CkCsv_putEscapeBackslash(objHandle: HCkCsv; newPropVal: wordbool);
function CkCsv_getHasColumnNames(objHandle: HCkCsv): wordbool;
procedure CkCsv_putHasColumnNames(objHandle: HCkCsv; newPropVal: wordbool);
procedure CkCsv_getLastErrorHtml(objHandle: HCkCsv; outPropVal: HCkString);
function CkCsv__lastErrorHtml(objHandle: HCkCsv): PWideChar;
procedure CkCsv_getLastErrorText(objHandle: HCkCsv; outPropVal: HCkString);
function CkCsv__lastErrorText(objHandle: HCkCsv): PWideChar;
procedure CkCsv_getLastErrorXml(objHandle: HCkCsv; outPropVal: HCkString);
function CkCsv__lastErrorXml(objHandle: HCkCsv): PWideChar;
function CkCsv_getLastMethodSuccess(objHandle: HCkCsv): wordbool;
procedure CkCsv_putLastMethodSuccess(objHandle: HCkCsv; newPropVal: wordbool);
function CkCsv_getNumColumns(objHandle: HCkCsv): Integer;
function CkCsv_getNumRows(objHandle: HCkCsv): Integer;
procedure CkCsv_getUncommonOptions(objHandle: HCkCsv; outPropVal: HCkString);
procedure CkCsv_putUncommonOptions(objHandle: HCkCsv; newPropVal: PWideChar);
function CkCsv__uncommonOptions(objHandle: HCkCsv): PWideChar;
function CkCsv_getVerboseLogging(objHandle: HCkCsv): wordbool;
procedure CkCsv_putVerboseLogging(objHandle: HCkCsv; newPropVal: wordbool);
procedure CkCsv_getVersion(objHandle: HCkCsv; outPropVal: HCkString);
function CkCsv__version(objHandle: HCkCsv): PWideChar;
procedure CkCsv_getXlsxDateFormat(objHandle: HCkCsv; outPropVal: HCkString);
procedure CkCsv_putXlsxDateFormat(objHandle: HCkCsv; newPropVal: PWideChar);
function CkCsv__xlsxDateFormat(objHandle: HCkCsv): PWideChar;
function CkCsv_DeleteColumn(objHandle: HCkCsv; index: Integer): wordbool;
function CkCsv_DeleteColumnByName(objHandle: HCkCsv; columnName: PWideChar): wordbool;
function CkCsv_DeleteRow(objHandle: HCkCsv; index: Integer): wordbool;
function CkCsv_GetCell(objHandle: HCkCsv; row: Integer; col: Integer; outStr: HCkString): wordbool;
function CkCsv__getCell(objHandle: HCkCsv; row: Integer; col: Integer): PWideChar;
function CkCsv_GetCellByName(objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar; outStr: HCkString): wordbool;
function CkCsv__getCellByName(objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar): PWideChar;
function CkCsv_GetColumnName(objHandle: HCkCsv; index: Integer; outStr: HCkString): wordbool;
function CkCsv__getColumnName(objHandle: HCkCsv; index: Integer): PWideChar;
function CkCsv_GetIndex(objHandle: HCkCsv; columnName: PWideChar): Integer;
function CkCsv_GetNumCols(objHandle: HCkCsv; row: Integer): Integer;
function CkCsv_InsertColumn(objHandle: HCkCsv; index: Integer): wordbool;
function CkCsv_LoadFile(objHandle: HCkCsv; path: PWideChar): wordbool;
function CkCsv_LoadFile2(objHandle: HCkCsv; filename: PWideChar; charset: PWideChar): wordbool;
function CkCsv_LoadFromString(objHandle: HCkCsv; csvData: PWideChar): wordbool;
function CkCsv_RowMatches(objHandle: HCkCsv; rowIndex: Integer; matchPattern: PWideChar; caseSensitive: wordbool): wordbool;
function CkCsv_SaveFile(objHandle: HCkCsv; path: PWideChar): wordbool;
function CkCsv_SaveFile2(objHandle: HCkCsv; filename: PWideChar; charset: PWideChar): wordbool;
function CkCsv_SaveToSb(objHandle: HCkCsv; sb: HCkStringBuilder): wordbool;
function CkCsv_SaveToString(objHandle: HCkCsv; outStr: HCkString): wordbool;
function CkCsv__saveToString(objHandle: HCkCsv): PWideChar;
function CkCsv_SetCell(objHandle: HCkCsv; row: Integer; col: Integer; content: PWideChar): wordbool;
function CkCsv_SetCellByName(objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar; contentStr: PWideChar): wordbool;
function CkCsv_SetColumnName(objHandle: HCkCsv; index: Integer; columnName: PWideChar): wordbool;
function CkCsv_SortByColumn(objHandle: HCkCsv; columnName: PWideChar; ascending: wordbool; caseSensitive: wordbool): wordbool;
function CkCsv_SortByColumnIndex(objHandle: HCkCsv; index: Integer; ascending: wordbool; caseSensitive: wordbool): wordbool;
function CkCsv_XlsxGetSheets(objHandle: HCkCsv; xlsx: HCkZip; sheetNames: HCkStringTable): wordbool;
function CkCsv_XlsxLoadSheet(objHandle: HCkCsv; zip: HCkZip; sheetName: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCsv_Create = function : HCkCsv; stdcall;
  TCkCsv_Dispose = procedure (handle: HCkCsv); stdcall;
  TCkCsv_getAutoTrim = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putAutoTrim = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getCrlf = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putCrlf = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getDebugLogFilePath = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv_putDebugLogFilePath = procedure (objHandle: HCkCsv; newPropVal: PWideChar); stdcall;
  TCkCsv__debugLogFilePath = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getDelimiter = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv_putDelimiter = procedure (objHandle: HCkCsv; newPropVal: PWideChar); stdcall;
  TCkCsv__delimiter = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getEnableQuotes = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putEnableQuotes = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getEscapeBackslash = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putEscapeBackslash = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getHasColumnNames = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putHasColumnNames = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getLastErrorHtml = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv__lastErrorHtml = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getLastErrorText = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv__lastErrorText = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getLastErrorXml = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv__lastErrorXml = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getLastMethodSuccess = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putLastMethodSuccess = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getNumColumns = function (objHandle: HCkCsv): Integer; stdcall;
  TCkCsv_getNumRows = function (objHandle: HCkCsv): Integer; stdcall;
  TCkCsv_getUncommonOptions = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv_putUncommonOptions = procedure (objHandle: HCkCsv; newPropVal: PWideChar); stdcall;
  TCkCsv__uncommonOptions = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getVerboseLogging = function (objHandle: HCkCsv): wordbool; stdcall;
  TCkCsv_putVerboseLogging = procedure (objHandle: HCkCsv; newPropVal: wordbool); stdcall;
  TCkCsv_getVersion = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv__version = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_getXlsxDateFormat = procedure (objHandle: HCkCsv; outPropVal: HCkString); stdcall;
  TCkCsv_putXlsxDateFormat = procedure (objHandle: HCkCsv; newPropVal: PWideChar); stdcall;
  TCkCsv__xlsxDateFormat = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_DeleteColumn = function (objHandle: HCkCsv; index: Integer): wordbool; stdcall;
  TCkCsv_DeleteColumnByName = function (objHandle: HCkCsv; columnName: PWideChar): wordbool; stdcall;
  TCkCsv_DeleteRow = function (objHandle: HCkCsv; index: Integer): wordbool; stdcall;
  TCkCsv_GetCell = function (objHandle: HCkCsv; row: Integer; col: Integer; outStr: HCkString): wordbool; stdcall;
  TCkCsv__getCell = function (objHandle: HCkCsv; row: Integer; col: Integer): PWideChar; stdcall;
  TCkCsv_GetCellByName = function (objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCsv__getCellByName = function (objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar): PWideChar; stdcall;
  TCkCsv_GetColumnName = function (objHandle: HCkCsv; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkCsv__getColumnName = function (objHandle: HCkCsv; index: Integer): PWideChar; stdcall;
  TCkCsv_GetIndex = function (objHandle: HCkCsv; columnName: PWideChar): Integer; stdcall;
  TCkCsv_GetNumCols = function (objHandle: HCkCsv; row: Integer): Integer; stdcall;
  TCkCsv_InsertColumn = function (objHandle: HCkCsv; index: Integer): wordbool; stdcall;
  TCkCsv_LoadFile = function (objHandle: HCkCsv; path: PWideChar): wordbool; stdcall;
  TCkCsv_LoadFile2 = function (objHandle: HCkCsv; filename: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkCsv_LoadFromString = function (objHandle: HCkCsv; csvData: PWideChar): wordbool; stdcall;
  TCkCsv_RowMatches = function (objHandle: HCkCsv; rowIndex: Integer; matchPattern: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkCsv_SaveFile = function (objHandle: HCkCsv; path: PWideChar): wordbool; stdcall;
  TCkCsv_SaveFile2 = function (objHandle: HCkCsv; filename: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkCsv_SaveToSb = function (objHandle: HCkCsv; sb: HCkStringBuilder): wordbool; stdcall;
  TCkCsv_SaveToString = function (objHandle: HCkCsv; outStr: HCkString): wordbool; stdcall;
  TCkCsv__saveToString = function (objHandle: HCkCsv): PWideChar; stdcall;
  TCkCsv_SetCell = function (objHandle: HCkCsv; row: Integer; col: Integer; content: PWideChar): wordbool; stdcall;
  TCkCsv_SetCellByName = function (objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar; contentStr: PWideChar): wordbool; stdcall;
  TCkCsv_SetColumnName = function (objHandle: HCkCsv; index: Integer; columnName: PWideChar): wordbool; stdcall;
  TCkCsv_SortByColumn = function (objHandle: HCkCsv; columnName: PWideChar; ascending: wordbool; caseSensitive: wordbool): wordbool; stdcall;
  TCkCsv_SortByColumnIndex = function (objHandle: HCkCsv; index: Integer; ascending: wordbool; caseSensitive: wordbool): wordbool; stdcall;
  TCkCsv_XlsxGetSheets = function (objHandle: HCkCsv; xlsx: HCkZip; sheetNames: HCkStringTable): wordbool; stdcall;
  TCkCsv_XlsxLoadSheet = function (objHandle: HCkCsv; zip: HCkZip; sheetName: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..65] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCsv_Create : HCkCsv;
begin
  result := TCkCsv_Create(_map(0, 'CkCsv_Create'));
end;

procedure CkCsv_Dispose (handle: HCkCsv);
begin
  TCkCsv_Dispose(_map(1, 'CkCsv_Dispose'))
    (handle);
end;


function CkCsv_getAutoTrim (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getAutoTrim(_map(2, 'CkCsv_getAutoTrim'))
    (objHandle);
end;

procedure CkCsv_putAutoTrim (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putAutoTrim(_map(3, 'CkCsv_putAutoTrim'))
    (objHandle, newPropVal);
end;

function CkCsv_getCrlf (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getCrlf(_map(4, 'CkCsv_getCrlf'))
    (objHandle);
end;

procedure CkCsv_putCrlf (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putCrlf(_map(5, 'CkCsv_putCrlf'))
    (objHandle, newPropVal);
end;

procedure CkCsv_getDebugLogFilePath (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getDebugLogFilePath(_map(6, 'CkCsv_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCsv_putDebugLogFilePath (objHandle: HCkCsv; newPropVal: PWideChar);
begin
  TCkCsv_putDebugLogFilePath(_map(7, 'CkCsv_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCsv__debugLogFilePath (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__debugLogFilePath(_map(8, 'CkCsv__debugLogFilePath'))
    (objHandle);
end;

procedure CkCsv_getDelimiter (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getDelimiter(_map(9, 'CkCsv_getDelimiter'))
    (objHandle, outPropVal);
end;

procedure CkCsv_putDelimiter (objHandle: HCkCsv; newPropVal: PWideChar);
begin
  TCkCsv_putDelimiter(_map(10, 'CkCsv_putDelimiter'))
    (objHandle, newPropVal);
end;

function CkCsv__delimiter (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__delimiter(_map(11, 'CkCsv__delimiter'))
    (objHandle);
end;

function CkCsv_getEnableQuotes (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getEnableQuotes(_map(12, 'CkCsv_getEnableQuotes'))
    (objHandle);
end;

procedure CkCsv_putEnableQuotes (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putEnableQuotes(_map(13, 'CkCsv_putEnableQuotes'))
    (objHandle, newPropVal);
end;

function CkCsv_getEscapeBackslash (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getEscapeBackslash(_map(14, 'CkCsv_getEscapeBackslash'))
    (objHandle);
end;

procedure CkCsv_putEscapeBackslash (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putEscapeBackslash(_map(15, 'CkCsv_putEscapeBackslash'))
    (objHandle, newPropVal);
end;

function CkCsv_getHasColumnNames (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getHasColumnNames(_map(16, 'CkCsv_getHasColumnNames'))
    (objHandle);
end;

procedure CkCsv_putHasColumnNames (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putHasColumnNames(_map(17, 'CkCsv_putHasColumnNames'))
    (objHandle, newPropVal);
end;

procedure CkCsv_getLastErrorHtml (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getLastErrorHtml(_map(18, 'CkCsv_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCsv__lastErrorHtml (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__lastErrorHtml(_map(19, 'CkCsv__lastErrorHtml'))
    (objHandle);
end;

procedure CkCsv_getLastErrorText (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getLastErrorText(_map(20, 'CkCsv_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCsv__lastErrorText (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__lastErrorText(_map(21, 'CkCsv__lastErrorText'))
    (objHandle);
end;

procedure CkCsv_getLastErrorXml (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getLastErrorXml(_map(22, 'CkCsv_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCsv__lastErrorXml (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__lastErrorXml(_map(23, 'CkCsv__lastErrorXml'))
    (objHandle);
end;

function CkCsv_getLastMethodSuccess (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getLastMethodSuccess(_map(24, 'CkCsv_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCsv_putLastMethodSuccess (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putLastMethodSuccess(_map(25, 'CkCsv_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkCsv_getNumColumns (objHandle: HCkCsv): Integer;
begin
    result := TCkCsv_getNumColumns(_map(26, 'CkCsv_getNumColumns'))
    (objHandle);
end;

function CkCsv_getNumRows (objHandle: HCkCsv): Integer;
begin
    result := TCkCsv_getNumRows(_map(27, 'CkCsv_getNumRows'))
    (objHandle);
end;

procedure CkCsv_getUncommonOptions (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getUncommonOptions(_map(28, 'CkCsv_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkCsv_putUncommonOptions (objHandle: HCkCsv; newPropVal: PWideChar);
begin
  TCkCsv_putUncommonOptions(_map(29, 'CkCsv_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkCsv__uncommonOptions (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__uncommonOptions(_map(30, 'CkCsv__uncommonOptions'))
    (objHandle);
end;

function CkCsv_getVerboseLogging (objHandle: HCkCsv): wordbool;
begin
    result := TCkCsv_getVerboseLogging(_map(31, 'CkCsv_getVerboseLogging'))
    (objHandle);
end;

procedure CkCsv_putVerboseLogging (objHandle: HCkCsv; newPropVal: wordbool);
begin
  TCkCsv_putVerboseLogging(_map(32, 'CkCsv_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCsv_getVersion (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getVersion(_map(33, 'CkCsv_getVersion'))
    (objHandle, outPropVal);
end;

function CkCsv__version (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__version(_map(34, 'CkCsv__version'))
    (objHandle);
end;

procedure CkCsv_getXlsxDateFormat (objHandle: HCkCsv; outPropVal: HCkString);
begin
  TCkCsv_getXlsxDateFormat(_map(35, 'CkCsv_getXlsxDateFormat'))
    (objHandle, outPropVal);
end;

procedure CkCsv_putXlsxDateFormat (objHandle: HCkCsv; newPropVal: PWideChar);
begin
  TCkCsv_putXlsxDateFormat(_map(36, 'CkCsv_putXlsxDateFormat'))
    (objHandle, newPropVal);
end;

function CkCsv__xlsxDateFormat (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__xlsxDateFormat(_map(37, 'CkCsv__xlsxDateFormat'))
    (objHandle);
end;

function CkCsv_DeleteColumn (objHandle: HCkCsv; index: Integer): wordbool;
begin
  result := TCkCsv_DeleteColumn(_map(38, 'CkCsv_DeleteColumn'))
    (objHandle, index);
end;

function CkCsv_DeleteColumnByName (objHandle: HCkCsv; columnName: PWideChar): wordbool;
begin
  result := TCkCsv_DeleteColumnByName(_map(39, 'CkCsv_DeleteColumnByName'))
    (objHandle, columnName);
end;

function CkCsv_DeleteRow (objHandle: HCkCsv; index: Integer): wordbool;
begin
  result := TCkCsv_DeleteRow(_map(40, 'CkCsv_DeleteRow'))
    (objHandle, index);
end;

function CkCsv_GetCell (objHandle: HCkCsv; row: Integer; col: Integer; outStr: HCkString): wordbool;
begin
  result := TCkCsv_GetCell(_map(41, 'CkCsv_GetCell'))
    (objHandle, row, col, outStr);
end;

function CkCsv__getCell (objHandle: HCkCsv; row: Integer; col: Integer): PWideChar;
begin
  result := TCkCsv__getCell(_map(42, 'CkCsv__getCell'))
    (objHandle, row, col);
end;

function CkCsv_GetCellByName (objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCsv_GetCellByName(_map(43, 'CkCsv_GetCellByName'))
    (objHandle, rowIndex, columnName, outStr);
end;

function CkCsv__getCellByName (objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar): PWideChar;
begin
  result := TCkCsv__getCellByName(_map(44, 'CkCsv__getCellByName'))
    (objHandle, rowIndex, columnName);
end;

function CkCsv_GetColumnName (objHandle: HCkCsv; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkCsv_GetColumnName(_map(45, 'CkCsv_GetColumnName'))
    (objHandle, index, outStr);
end;

function CkCsv__getColumnName (objHandle: HCkCsv; index: Integer): PWideChar;
begin
  result := TCkCsv__getColumnName(_map(46, 'CkCsv__getColumnName'))
    (objHandle, index);
end;

function CkCsv_GetIndex (objHandle: HCkCsv; columnName: PWideChar): Integer;
begin
  result := TCkCsv_GetIndex(_map(47, 'CkCsv_GetIndex'))
    (objHandle, columnName);
end;

function CkCsv_GetNumCols (objHandle: HCkCsv; row: Integer): Integer;
begin
  result := TCkCsv_GetNumCols(_map(48, 'CkCsv_GetNumCols'))
    (objHandle, row);
end;

function CkCsv_InsertColumn (objHandle: HCkCsv; index: Integer): wordbool;
begin
  result := TCkCsv_InsertColumn(_map(49, 'CkCsv_InsertColumn'))
    (objHandle, index);
end;

function CkCsv_LoadFile (objHandle: HCkCsv; path: PWideChar): wordbool;
begin
  result := TCkCsv_LoadFile(_map(50, 'CkCsv_LoadFile'))
    (objHandle, path);
end;

function CkCsv_LoadFile2 (objHandle: HCkCsv; filename: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkCsv_LoadFile2(_map(51, 'CkCsv_LoadFile2'))
    (objHandle, filename, charset);
end;

function CkCsv_LoadFromString (objHandle: HCkCsv; csvData: PWideChar): wordbool;
begin
  result := TCkCsv_LoadFromString(_map(52, 'CkCsv_LoadFromString'))
    (objHandle, csvData);
end;

function CkCsv_RowMatches (objHandle: HCkCsv; rowIndex: Integer; matchPattern: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkCsv_RowMatches(_map(53, 'CkCsv_RowMatches'))
    (objHandle, rowIndex, matchPattern, caseSensitive);
end;

function CkCsv_SaveFile (objHandle: HCkCsv; path: PWideChar): wordbool;
begin
  result := TCkCsv_SaveFile(_map(54, 'CkCsv_SaveFile'))
    (objHandle, path);
end;

function CkCsv_SaveFile2 (objHandle: HCkCsv; filename: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkCsv_SaveFile2(_map(55, 'CkCsv_SaveFile2'))
    (objHandle, filename, charset);
end;

function CkCsv_SaveToSb (objHandle: HCkCsv; sb: HCkStringBuilder): wordbool;
begin
  result := TCkCsv_SaveToSb(_map(56, 'CkCsv_SaveToSb'))
    (objHandle, sb);
end;

function CkCsv_SaveToString (objHandle: HCkCsv; outStr: HCkString): wordbool;
begin
  result := TCkCsv_SaveToString(_map(57, 'CkCsv_SaveToString'))
    (objHandle, outStr);
end;

function CkCsv__saveToString (objHandle: HCkCsv): PWideChar;
begin
  result := TCkCsv__saveToString(_map(58, 'CkCsv__saveToString'))
    (objHandle);
end;

function CkCsv_SetCell (objHandle: HCkCsv; row: Integer; col: Integer; content: PWideChar): wordbool;
begin
  result := TCkCsv_SetCell(_map(59, 'CkCsv_SetCell'))
    (objHandle, row, col, content);
end;

function CkCsv_SetCellByName (objHandle: HCkCsv; rowIndex: Integer; columnName: PWideChar; contentStr: PWideChar): wordbool;
begin
  result := TCkCsv_SetCellByName(_map(60, 'CkCsv_SetCellByName'))
    (objHandle, rowIndex, columnName, contentStr);
end;

function CkCsv_SetColumnName (objHandle: HCkCsv; index: Integer; columnName: PWideChar): wordbool;
begin
  result := TCkCsv_SetColumnName(_map(61, 'CkCsv_SetColumnName'))
    (objHandle, index, columnName);
end;

function CkCsv_SortByColumn (objHandle: HCkCsv; columnName: PWideChar; ascending: wordbool; caseSensitive: wordbool): wordbool;
begin
  result := TCkCsv_SortByColumn(_map(62, 'CkCsv_SortByColumn'))
    (objHandle, columnName, ascending, caseSensitive);
end;

function CkCsv_SortByColumnIndex (objHandle: HCkCsv; index: Integer; ascending: wordbool; caseSensitive: wordbool): wordbool;
begin
  result := TCkCsv_SortByColumnIndex(_map(63, 'CkCsv_SortByColumnIndex'))
    (objHandle, index, ascending, caseSensitive);
end;

function CkCsv_XlsxGetSheets (objHandle: HCkCsv; xlsx: HCkZip; sheetNames: HCkStringTable): wordbool;
begin
  result := TCkCsv_XlsxGetSheets(_map(64, 'CkCsv_XlsxGetSheets'))
    (objHandle, xlsx, sheetNames);
end;

function CkCsv_XlsxLoadSheet (objHandle: HCkCsv; zip: HCkZip; sheetName: PWideChar): wordbool;
begin
  result := TCkCsv_XlsxLoadSheet(_map(65, 'CkCsv_XlsxLoadSheet'))
    (objHandle, zip, sheetName);
end;

end.
