unit Dkim;

interface

type

HCkBinData = Pointer;
HCkDkim = Pointer;
HCkTask = Pointer;
HCkPrivateKey = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TDkimAbortCheck = function(): Integer; cdecl;
TDkimProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TDkimPercentDone = function(pctDone: Integer): Integer; cdecl;
TDkimTaskCompleted = procedure(task: HCkTask); cdecl;


function CkDkim_Create: HCkDkim;  stdcall;
procedure CkDkim_Dispose(handle: HCkDkim); stdcall;

procedure CkDkim_SetAbortCheck(objHandle: HCkDkim; fn: TDkimAbortCheck) stdcall;
procedure CkDkim_SetProgressInfo(objHandle: HCkDkim; fn: TDkimProgressInfo) stdcall;
procedure CkDkim_SetPercentDone(objHandle: HCkDkim; fn: TDkimPercentDone) stdcall;
procedure CkDkim_SetTaskCompleted(objHandle: HCkDkim; fn: TDkimTaskCompleted) stdcall;
function CkDkim_getAbortCurrent(objHandle: HCkDkim): wordbool;
procedure CkDkim_putAbortCurrent(objHandle: HCkDkim; newPropVal: wordbool);
procedure CkDkim_getDebugLogFilePath(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDebugLogFilePath(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__debugLogFilePath(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDkimAlg(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDkimAlg(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__dkimAlg(objHandle: HCkDkim): PWideChar;
function CkDkim_getDkimBodyLengthCount(objHandle: HCkDkim): Integer;
procedure CkDkim_putDkimBodyLengthCount(objHandle: HCkDkim; newPropVal: Integer);
procedure CkDkim_getDkimCanon(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDkimCanon(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__dkimCanon(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDkimDomain(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDkimDomain(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__dkimDomain(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDkimHeaders(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDkimHeaders(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__dkimHeaders(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDkimSelector(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDkimSelector(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__dkimSelector(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDomainKeyAlg(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDomainKeyAlg(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__domainKeyAlg(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDomainKeyCanon(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDomainKeyCanon(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__domainKeyCanon(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDomainKeyDomain(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDomainKeyDomain(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__domainKeyDomain(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDomainKeyHeaders(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDomainKeyHeaders(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__domainKeyHeaders(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getDomainKeySelector(objHandle: HCkDkim; outPropVal: HCkString);
procedure CkDkim_putDomainKeySelector(objHandle: HCkDkim; newPropVal: PWideChar);
function CkDkim__domainKeySelector(objHandle: HCkDkim): PWideChar;
function CkDkim_getHeartbeatMs(objHandle: HCkDkim): Integer;
procedure CkDkim_putHeartbeatMs(objHandle: HCkDkim; newPropVal: Integer);
procedure CkDkim_getLastErrorHtml(objHandle: HCkDkim; outPropVal: HCkString);
function CkDkim__lastErrorHtml(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getLastErrorText(objHandle: HCkDkim; outPropVal: HCkString);
function CkDkim__lastErrorText(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getLastErrorXml(objHandle: HCkDkim; outPropVal: HCkString);
function CkDkim__lastErrorXml(objHandle: HCkDkim): PWideChar;
function CkDkim_getLastMethodSuccess(objHandle: HCkDkim): wordbool;
procedure CkDkim_putLastMethodSuccess(objHandle: HCkDkim; newPropVal: wordbool);
function CkDkim_getVerboseLogging(objHandle: HCkDkim): wordbool;
procedure CkDkim_putVerboseLogging(objHandle: HCkDkim; newPropVal: wordbool);
procedure CkDkim_getVerifyInfo(objHandle: HCkDkim; outPropVal: HCkString);
function CkDkim__verifyInfo(objHandle: HCkDkim): PWideChar;
procedure CkDkim_getVersion(objHandle: HCkDkim; outPropVal: HCkString);
function CkDkim__version(objHandle: HCkDkim): PWideChar;
function CkDkim_DkimSign(objHandle: HCkDkim; mimeData: HCkBinData): wordbool;
function CkDkim_DkimVerify(objHandle: HCkDkim; sigIndex: Integer; mimeData: HCkBinData): wordbool;
function CkDkim_DomainKeySign(objHandle: HCkDkim; mimeData: HCkBinData): wordbool;
function CkDkim_DomainKeyVerify(objHandle: HCkDkim; sigIndex: Integer; mimeData: HCkBinData): wordbool;
function CkDkim_LoadPublicKey(objHandle: HCkDkim; selector: PWideChar; domain: PWideChar; publicKey: PWideChar): wordbool;
function CkDkim_LoadPublicKeyFile(objHandle: HCkDkim; selector: PWideChar; domain: PWideChar; publicKeyFilepath: PWideChar): wordbool;
function CkDkim_LoadTaskCaller(objHandle: HCkDkim; task: HCkTask): wordbool;
function CkDkim_NumDkimSigs(objHandle: HCkDkim; mimeData: HCkBinData): Integer;
function CkDkim_NumDomainKeySigs(objHandle: HCkDkim; mimeData: HCkBinData): Integer;
function CkDkim_PrefetchPublicKey(objHandle: HCkDkim; selector: PWideChar; domain: PWideChar): wordbool;
function CkDkim_PrefetchPublicKeyAsync(objHandle: HCkDkim; selector: PWideChar; domain: PWideChar): HCkTask;
function CkDkim_SetDkimPrivateKey(objHandle: HCkDkim; privateKey: HCkPrivateKey): wordbool;
function CkDkim_SetDomainKeyPrivateKey(objHandle: HCkDkim; privateKey: HCkPrivateKey): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDkim_Create = function : HCkDkim; stdcall;
  TCkDkim_Dispose = procedure (handle: HCkDkim); stdcall;
  TCkDkim_SetAbortCheck = procedure (objHandle: HCkDkim; fn: TDkimAbortCheck); stdcall;
  TCkDkim_SetProgressInfo = procedure (objHandle: HCkDkim; fn: TDkimProgressInfo); stdcall;
  TCkDkim_SetPercentDone = procedure (objHandle: HCkDkim; fn: TDkimPercentDone); stdcall;
  TCkDkim_SetTaskCompleted = procedure (objHandle: HCkDkim; fn: TDkimTaskCompleted); stdcall;
  TCkDkim_getAbortCurrent = function (objHandle: HCkDkim): wordbool; stdcall;
  TCkDkim_putAbortCurrent = procedure (objHandle: HCkDkim; newPropVal: wordbool); stdcall;
  TCkDkim_getDebugLogFilePath = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDebugLogFilePath = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__debugLogFilePath = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDkimAlg = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDkimAlg = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__dkimAlg = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDkimBodyLengthCount = function (objHandle: HCkDkim): Integer; stdcall;
  TCkDkim_putDkimBodyLengthCount = procedure (objHandle: HCkDkim; newPropVal: Integer); stdcall;
  TCkDkim_getDkimCanon = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDkimCanon = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__dkimCanon = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDkimDomain = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDkimDomain = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__dkimDomain = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDkimHeaders = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDkimHeaders = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__dkimHeaders = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDkimSelector = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDkimSelector = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__dkimSelector = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDomainKeyAlg = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDomainKeyAlg = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__domainKeyAlg = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDomainKeyCanon = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDomainKeyCanon = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__domainKeyCanon = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDomainKeyDomain = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDomainKeyDomain = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__domainKeyDomain = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDomainKeyHeaders = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDomainKeyHeaders = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__domainKeyHeaders = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getDomainKeySelector = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim_putDomainKeySelector = procedure (objHandle: HCkDkim; newPropVal: PWideChar); stdcall;
  TCkDkim__domainKeySelector = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getHeartbeatMs = function (objHandle: HCkDkim): Integer; stdcall;
  TCkDkim_putHeartbeatMs = procedure (objHandle: HCkDkim; newPropVal: Integer); stdcall;
  TCkDkim_getLastErrorHtml = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim__lastErrorHtml = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getLastErrorText = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim__lastErrorText = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getLastErrorXml = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim__lastErrorXml = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getLastMethodSuccess = function (objHandle: HCkDkim): wordbool; stdcall;
  TCkDkim_putLastMethodSuccess = procedure (objHandle: HCkDkim; newPropVal: wordbool); stdcall;
  TCkDkim_getVerboseLogging = function (objHandle: HCkDkim): wordbool; stdcall;
  TCkDkim_putVerboseLogging = procedure (objHandle: HCkDkim; newPropVal: wordbool); stdcall;
  TCkDkim_getVerifyInfo = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim__verifyInfo = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_getVersion = procedure (objHandle: HCkDkim; outPropVal: HCkString); stdcall;
  TCkDkim__version = function (objHandle: HCkDkim): PWideChar; stdcall;
  TCkDkim_DkimSign = function (objHandle: HCkDkim; mimeData: HCkBinData): wordbool; stdcall;
  TCkDkim_DkimVerify = function (objHandle: HCkDkim; sigIndex: Integer; mimeData: HCkBinData): wordbool; stdcall;
  TCkDkim_DomainKeySign = function (objHandle: HCkDkim; mimeData: HCkBinData): wordbool; stdcall;
  TCkDkim_DomainKeyVerify = function (objHandle: HCkDkim; sigIndex: Integer; mimeData: HCkBinData): wordbool; stdcall;
  TCkDkim_LoadPublicKey = function (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar; publicKey: PWideChar): wordbool; stdcall;
  TCkDkim_LoadPublicKeyFile = function (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar; publicKeyFilepath: PWideChar): wordbool; stdcall;
  TCkDkim_LoadTaskCaller = function (objHandle: HCkDkim; task: HCkTask): wordbool; stdcall;
  TCkDkim_NumDkimSigs = function (objHandle: HCkDkim; mimeData: HCkBinData): Integer; stdcall;
  TCkDkim_NumDomainKeySigs = function (objHandle: HCkDkim; mimeData: HCkBinData): Integer; stdcall;
  TCkDkim_PrefetchPublicKey = function (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar): wordbool; stdcall;
  TCkDkim_PrefetchPublicKeyAsync = function (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar): HCkTask; stdcall;
  TCkDkim_SetDkimPrivateKey = function (objHandle: HCkDkim; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkDkim_SetDomainKeyPrivateKey = function (objHandle: HCkDkim; privateKey: HCkPrivateKey): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..71] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDkim_Create : HCkDkim;
begin
  result := TCkDkim_Create(_map(0, 'CkDkim_Create'));
end;

procedure CkDkim_Dispose (handle: HCkDkim);
begin
  TCkDkim_Dispose(_map(1, 'CkDkim_Dispose'))
    (handle);
end;


procedure CkDkim_SetAbortCheck (objHandle: HCkDkim; fn: TDkimAbortCheck);
begin
    TCkDkim_SetAbortCheck(_map(2, 'CkDkim_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkDkim_SetProgressInfo (objHandle: HCkDkim; fn: TDkimProgressInfo);
begin
    TCkDkim_SetProgressInfo(_map(3, 'CkDkim_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkDkim_SetPercentDone (objHandle: HCkDkim; fn: TDkimPercentDone);
begin
    TCkDkim_SetPercentDone(_map(4, 'CkDkim_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkDkim_SetTaskCompleted (objHandle: HCkDkim; fn: TDkimTaskCompleted);
begin
    TCkDkim_SetTaskCompleted(_map(5, 'CkDkim_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkDkim_getAbortCurrent (objHandle: HCkDkim): wordbool;
begin
    result := TCkDkim_getAbortCurrent(_map(6, 'CkDkim_getAbortCurrent'))
    (objHandle);
end;

procedure CkDkim_putAbortCurrent (objHandle: HCkDkim; newPropVal: wordbool);
begin
  TCkDkim_putAbortCurrent(_map(7, 'CkDkim_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkDkim_getDebugLogFilePath (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDebugLogFilePath(_map(8, 'CkDkim_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDebugLogFilePath (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDebugLogFilePath(_map(9, 'CkDkim_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDkim__debugLogFilePath (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__debugLogFilePath(_map(10, 'CkDkim__debugLogFilePath'))
    (objHandle);
end;

procedure CkDkim_getDkimAlg (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDkimAlg(_map(11, 'CkDkim_getDkimAlg'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDkimAlg (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDkimAlg(_map(12, 'CkDkim_putDkimAlg'))
    (objHandle, newPropVal);
end;

function CkDkim__dkimAlg (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__dkimAlg(_map(13, 'CkDkim__dkimAlg'))
    (objHandle);
end;

function CkDkim_getDkimBodyLengthCount (objHandle: HCkDkim): Integer;
begin
    result := TCkDkim_getDkimBodyLengthCount(_map(14, 'CkDkim_getDkimBodyLengthCount'))
    (objHandle);
end;

procedure CkDkim_putDkimBodyLengthCount (objHandle: HCkDkim; newPropVal: Integer);
begin
  TCkDkim_putDkimBodyLengthCount(_map(15, 'CkDkim_putDkimBodyLengthCount'))
    (objHandle, newPropVal);
end;

procedure CkDkim_getDkimCanon (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDkimCanon(_map(16, 'CkDkim_getDkimCanon'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDkimCanon (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDkimCanon(_map(17, 'CkDkim_putDkimCanon'))
    (objHandle, newPropVal);
end;

function CkDkim__dkimCanon (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__dkimCanon(_map(18, 'CkDkim__dkimCanon'))
    (objHandle);
end;

procedure CkDkim_getDkimDomain (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDkimDomain(_map(19, 'CkDkim_getDkimDomain'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDkimDomain (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDkimDomain(_map(20, 'CkDkim_putDkimDomain'))
    (objHandle, newPropVal);
end;

function CkDkim__dkimDomain (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__dkimDomain(_map(21, 'CkDkim__dkimDomain'))
    (objHandle);
end;

procedure CkDkim_getDkimHeaders (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDkimHeaders(_map(22, 'CkDkim_getDkimHeaders'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDkimHeaders (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDkimHeaders(_map(23, 'CkDkim_putDkimHeaders'))
    (objHandle, newPropVal);
end;

function CkDkim__dkimHeaders (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__dkimHeaders(_map(24, 'CkDkim__dkimHeaders'))
    (objHandle);
end;

procedure CkDkim_getDkimSelector (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDkimSelector(_map(25, 'CkDkim_getDkimSelector'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDkimSelector (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDkimSelector(_map(26, 'CkDkim_putDkimSelector'))
    (objHandle, newPropVal);
end;

function CkDkim__dkimSelector (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__dkimSelector(_map(27, 'CkDkim__dkimSelector'))
    (objHandle);
end;

procedure CkDkim_getDomainKeyAlg (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDomainKeyAlg(_map(28, 'CkDkim_getDomainKeyAlg'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDomainKeyAlg (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDomainKeyAlg(_map(29, 'CkDkim_putDomainKeyAlg'))
    (objHandle, newPropVal);
end;

function CkDkim__domainKeyAlg (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__domainKeyAlg(_map(30, 'CkDkim__domainKeyAlg'))
    (objHandle);
end;

procedure CkDkim_getDomainKeyCanon (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDomainKeyCanon(_map(31, 'CkDkim_getDomainKeyCanon'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDomainKeyCanon (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDomainKeyCanon(_map(32, 'CkDkim_putDomainKeyCanon'))
    (objHandle, newPropVal);
end;

function CkDkim__domainKeyCanon (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__domainKeyCanon(_map(33, 'CkDkim__domainKeyCanon'))
    (objHandle);
end;

procedure CkDkim_getDomainKeyDomain (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDomainKeyDomain(_map(34, 'CkDkim_getDomainKeyDomain'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDomainKeyDomain (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDomainKeyDomain(_map(35, 'CkDkim_putDomainKeyDomain'))
    (objHandle, newPropVal);
end;

function CkDkim__domainKeyDomain (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__domainKeyDomain(_map(36, 'CkDkim__domainKeyDomain'))
    (objHandle);
end;

procedure CkDkim_getDomainKeyHeaders (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDomainKeyHeaders(_map(37, 'CkDkim_getDomainKeyHeaders'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDomainKeyHeaders (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDomainKeyHeaders(_map(38, 'CkDkim_putDomainKeyHeaders'))
    (objHandle, newPropVal);
end;

function CkDkim__domainKeyHeaders (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__domainKeyHeaders(_map(39, 'CkDkim__domainKeyHeaders'))
    (objHandle);
end;

procedure CkDkim_getDomainKeySelector (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getDomainKeySelector(_map(40, 'CkDkim_getDomainKeySelector'))
    (objHandle, outPropVal);
end;

procedure CkDkim_putDomainKeySelector (objHandle: HCkDkim; newPropVal: PWideChar);
begin
  TCkDkim_putDomainKeySelector(_map(41, 'CkDkim_putDomainKeySelector'))
    (objHandle, newPropVal);
end;

function CkDkim__domainKeySelector (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__domainKeySelector(_map(42, 'CkDkim__domainKeySelector'))
    (objHandle);
end;

function CkDkim_getHeartbeatMs (objHandle: HCkDkim): Integer;
begin
    result := TCkDkim_getHeartbeatMs(_map(43, 'CkDkim_getHeartbeatMs'))
    (objHandle);
end;

procedure CkDkim_putHeartbeatMs (objHandle: HCkDkim; newPropVal: Integer);
begin
  TCkDkim_putHeartbeatMs(_map(44, 'CkDkim_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkDkim_getLastErrorHtml (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getLastErrorHtml(_map(45, 'CkDkim_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDkim__lastErrorHtml (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__lastErrorHtml(_map(46, 'CkDkim__lastErrorHtml'))
    (objHandle);
end;

procedure CkDkim_getLastErrorText (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getLastErrorText(_map(47, 'CkDkim_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDkim__lastErrorText (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__lastErrorText(_map(48, 'CkDkim__lastErrorText'))
    (objHandle);
end;

procedure CkDkim_getLastErrorXml (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getLastErrorXml(_map(49, 'CkDkim_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDkim__lastErrorXml (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__lastErrorXml(_map(50, 'CkDkim__lastErrorXml'))
    (objHandle);
end;

function CkDkim_getLastMethodSuccess (objHandle: HCkDkim): wordbool;
begin
    result := TCkDkim_getLastMethodSuccess(_map(51, 'CkDkim_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDkim_putLastMethodSuccess (objHandle: HCkDkim; newPropVal: wordbool);
begin
  TCkDkim_putLastMethodSuccess(_map(52, 'CkDkim_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkDkim_getVerboseLogging (objHandle: HCkDkim): wordbool;
begin
    result := TCkDkim_getVerboseLogging(_map(53, 'CkDkim_getVerboseLogging'))
    (objHandle);
end;

procedure CkDkim_putVerboseLogging (objHandle: HCkDkim; newPropVal: wordbool);
begin
  TCkDkim_putVerboseLogging(_map(54, 'CkDkim_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDkim_getVerifyInfo (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getVerifyInfo(_map(55, 'CkDkim_getVerifyInfo'))
    (objHandle, outPropVal);
end;

function CkDkim__verifyInfo (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__verifyInfo(_map(56, 'CkDkim__verifyInfo'))
    (objHandle);
end;

procedure CkDkim_getVersion (objHandle: HCkDkim; outPropVal: HCkString);
begin
  TCkDkim_getVersion(_map(57, 'CkDkim_getVersion'))
    (objHandle, outPropVal);
end;

function CkDkim__version (objHandle: HCkDkim): PWideChar;
begin
  result := TCkDkim__version(_map(58, 'CkDkim__version'))
    (objHandle);
end;

function CkDkim_DkimSign (objHandle: HCkDkim; mimeData: HCkBinData): wordbool;
begin
  result := TCkDkim_DkimSign(_map(59, 'CkDkim_DkimSign'))
    (objHandle, mimeData);
end;

function CkDkim_DkimVerify (objHandle: HCkDkim; sigIndex: Integer; mimeData: HCkBinData): wordbool;
begin
  result := TCkDkim_DkimVerify(_map(60, 'CkDkim_DkimVerify'))
    (objHandle, sigIndex, mimeData);
end;

function CkDkim_DomainKeySign (objHandle: HCkDkim; mimeData: HCkBinData): wordbool;
begin
  result := TCkDkim_DomainKeySign(_map(61, 'CkDkim_DomainKeySign'))
    (objHandle, mimeData);
end;

function CkDkim_DomainKeyVerify (objHandle: HCkDkim; sigIndex: Integer; mimeData: HCkBinData): wordbool;
begin
  result := TCkDkim_DomainKeyVerify(_map(62, 'CkDkim_DomainKeyVerify'))
    (objHandle, sigIndex, mimeData);
end;

function CkDkim_LoadPublicKey (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar; publicKey: PWideChar): wordbool;
begin
  result := TCkDkim_LoadPublicKey(_map(63, 'CkDkim_LoadPublicKey'))
    (objHandle, selector, domain, publicKey);
end;

function CkDkim_LoadPublicKeyFile (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar; publicKeyFilepath: PWideChar): wordbool;
begin
  result := TCkDkim_LoadPublicKeyFile(_map(64, 'CkDkim_LoadPublicKeyFile'))
    (objHandle, selector, domain, publicKeyFilepath);
end;

function CkDkim_LoadTaskCaller (objHandle: HCkDkim; task: HCkTask): wordbool;
begin
  result := TCkDkim_LoadTaskCaller(_map(65, 'CkDkim_LoadTaskCaller'))
    (objHandle, task);
end;

function CkDkim_NumDkimSigs (objHandle: HCkDkim; mimeData: HCkBinData): Integer;
begin
  result := TCkDkim_NumDkimSigs(_map(66, 'CkDkim_NumDkimSigs'))
    (objHandle, mimeData);
end;

function CkDkim_NumDomainKeySigs (objHandle: HCkDkim; mimeData: HCkBinData): Integer;
begin
  result := TCkDkim_NumDomainKeySigs(_map(67, 'CkDkim_NumDomainKeySigs'))
    (objHandle, mimeData);
end;

function CkDkim_PrefetchPublicKey (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar): wordbool;
begin
  result := TCkDkim_PrefetchPublicKey(_map(68, 'CkDkim_PrefetchPublicKey'))
    (objHandle, selector, domain);
end;

function CkDkim_PrefetchPublicKeyAsync (objHandle: HCkDkim; selector: PWideChar; domain: PWideChar): HCkTask;
begin
  result := TCkDkim_PrefetchPublicKeyAsync(_map(69, 'CkDkim_PrefetchPublicKeyAsync'))
    (objHandle, selector, domain);
end;

function CkDkim_SetDkimPrivateKey (objHandle: HCkDkim; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkDkim_SetDkimPrivateKey(_map(70, 'CkDkim_SetDkimPrivateKey'))
    (objHandle, privateKey);
end;

function CkDkim_SetDomainKeyPrivateKey (objHandle: HCkDkim; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkDkim_SetDomainKeyPrivateKey(_map(71, 'CkDkim_SetDomainKeyPrivateKey'))
    (objHandle, privateKey);
end;

end.
