unit Dsa;

interface

type

HCkBinData = Pointer;
HCkDsa = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


function CkDsa_Create: HCkDsa;  stdcall;
procedure CkDsa_Dispose(handle: HCkDsa); stdcall;
procedure CkDsa_getDebugLogFilePath(objHandle: HCkDsa; outPropVal: HCkString);
procedure CkDsa_putDebugLogFilePath(objHandle: HCkDsa; newPropVal: PWideChar);
function CkDsa__debugLogFilePath(objHandle: HCkDsa): PWideChar;
function CkDsa_getGroupSize(objHandle: HCkDsa): Integer;
procedure CkDsa_putGroupSize(objHandle: HCkDsa; newPropVal: Integer);
procedure CkDsa_getHexG(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__hexG(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getHexP(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__hexP(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getHexQ(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__hexQ(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getHexX(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__hexX(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getHexY(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__hexY(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getLastErrorHtml(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__lastErrorHtml(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getLastErrorText(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__lastErrorText(objHandle: HCkDsa): PWideChar;
procedure CkDsa_getLastErrorXml(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__lastErrorXml(objHandle: HCkDsa): PWideChar;
function CkDsa_getLastMethodSuccess(objHandle: HCkDsa): wordbool;
procedure CkDsa_putLastMethodSuccess(objHandle: HCkDsa; newPropVal: wordbool);
procedure CkDsa_getUncommonOptions(objHandle: HCkDsa; outPropVal: HCkString);
procedure CkDsa_putUncommonOptions(objHandle: HCkDsa; newPropVal: PWideChar);
function CkDsa__uncommonOptions(objHandle: HCkDsa): PWideChar;
function CkDsa_getVerboseLogging(objHandle: HCkDsa): wordbool;
procedure CkDsa_putVerboseLogging(objHandle: HCkDsa; newPropVal: wordbool);
procedure CkDsa_getVersion(objHandle: HCkDsa; outPropVal: HCkString);
function CkDsa__version(objHandle: HCkDsa): PWideChar;
function CkDsa_FromDer(objHandle: HCkDsa; derData: HCkByteData): wordbool;
function CkDsa_FromDerBd(objHandle: HCkDsa; bd: HCkBinData): wordbool;
function CkDsa_FromDerFile(objHandle: HCkDsa; path: PWideChar): wordbool;
function CkDsa_FromEncryptedPem(objHandle: HCkDsa; password: PWideChar; pemData: PWideChar): wordbool;
function CkDsa_FromPem(objHandle: HCkDsa; pemData: PWideChar): wordbool;
function CkDsa_FromPublicDer(objHandle: HCkDsa; derData: HCkByteData): wordbool;
function CkDsa_FromPublicDerBd(objHandle: HCkDsa; bd: HCkBinData): wordbool;
function CkDsa_FromPublicDerFile(objHandle: HCkDsa; path: PWideChar): wordbool;
function CkDsa_FromPublicPem(objHandle: HCkDsa; pemData: PWideChar): wordbool;
function CkDsa_FromXml(objHandle: HCkDsa; xmlKey: PWideChar): wordbool;
function CkDsa_GenKey(objHandle: HCkDsa; numBits: Integer): wordbool;
function CkDsa_GenKey2(objHandle: HCkDsa; keyLenBits: Integer; modLenBits: Integer): wordbool;
function CkDsa_GenKeyFromParamsDer(objHandle: HCkDsa; derBytes: HCkByteData): wordbool;
function CkDsa_GenKeyFromParamsDerBd(objHandle: HCkDsa; bd: HCkBinData): wordbool;
function CkDsa_GenKeyFromParamsDerFile(objHandle: HCkDsa; path: PWideChar): wordbool;
function CkDsa_GenKeyFromParamsPem(objHandle: HCkDsa; pem: PWideChar): wordbool;
function CkDsa_GenKeyFromParamsPemFile(objHandle: HCkDsa; path: PWideChar): wordbool;
function CkDsa_GenKeyFromPQG(objHandle: HCkDsa; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar): wordbool;
function CkDsa_GetEncodedHash(objHandle: HCkDsa; encoding: PWideChar; outStr: HCkString): wordbool;
function CkDsa__getEncodedHash(objHandle: HCkDsa; encoding: PWideChar): PWideChar;
function CkDsa_GetEncodedSignature(objHandle: HCkDsa; encoding: PWideChar; outStr: HCkString): wordbool;
function CkDsa__getEncodedSignature(objHandle: HCkDsa; encoding: PWideChar): PWideChar;
function CkDsa_LoadText(objHandle: HCkDsa; path: PWideChar; outStr: HCkString): wordbool;
function CkDsa__loadText(objHandle: HCkDsa; path: PWideChar): PWideChar;
function CkDsa_SaveText(objHandle: HCkDsa; strToSave: PWideChar; path: PWideChar): wordbool;
function CkDsa_SetEncodedHash(objHandle: HCkDsa; encoding: PWideChar; encodedHash: PWideChar): wordbool;
function CkDsa_SetEncodedSignature(objHandle: HCkDsa; encoding: PWideChar; encodedSig: PWideChar): wordbool;
function CkDsa_SetEncodedSignatureRS(objHandle: HCkDsa; encoding: PWideChar; encodedR: PWideChar; encodedS: PWideChar): wordbool;
function CkDsa_SetKeyExplicit(objHandle: HCkDsa; groupSizeInBytes: Integer; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar; xHex: PWideChar): wordbool;
function CkDsa_SetPubKeyExplicit(objHandle: HCkDsa; groupSizeInBytes: Integer; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar; yHex: PWideChar): wordbool;
function CkDsa_SignHash(objHandle: HCkDsa): wordbool;
function CkDsa_ToDer(objHandle: HCkDsa; outData: HCkByteData): wordbool;
function CkDsa_ToDerBd(objHandle: HCkDsa; bd: HCkBinData): wordbool;
function CkDsa_ToDerFile(objHandle: HCkDsa; path: PWideChar): wordbool;
function CkDsa_ToEncryptedPem(objHandle: HCkDsa; password: PWideChar; outStr: HCkString): wordbool;
function CkDsa__toEncryptedPem(objHandle: HCkDsa; password: PWideChar): PWideChar;
function CkDsa_ToPem(objHandle: HCkDsa; outStr: HCkString): wordbool;
function CkDsa__toPem(objHandle: HCkDsa): PWideChar;
function CkDsa_ToPublicDer(objHandle: HCkDsa; outData: HCkByteData): wordbool;
function CkDsa_ToPublicDerBd(objHandle: HCkDsa; bd: HCkBinData): wordbool;
function CkDsa_ToPublicDerFile(objHandle: HCkDsa; path: PWideChar): wordbool;
function CkDsa_ToPublicPem(objHandle: HCkDsa; outStr: HCkString): wordbool;
function CkDsa__toPublicPem(objHandle: HCkDsa): PWideChar;
function CkDsa_ToXml(objHandle: HCkDsa; bPublicOnly: wordbool; outStr: HCkString): wordbool;
function CkDsa__toXml(objHandle: HCkDsa; bPublicOnly: wordbool): PWideChar;
function CkDsa_Verify(objHandle: HCkDsa): wordbool;
function CkDsa_VerifyKey(objHandle: HCkDsa): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDsa_Create = function : HCkDsa; stdcall;
  TCkDsa_Dispose = procedure (handle: HCkDsa); stdcall;
  TCkDsa_getDebugLogFilePath = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa_putDebugLogFilePath = procedure (objHandle: HCkDsa; newPropVal: PWideChar); stdcall;
  TCkDsa__debugLogFilePath = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getGroupSize = function (objHandle: HCkDsa): Integer; stdcall;
  TCkDsa_putGroupSize = procedure (objHandle: HCkDsa; newPropVal: Integer); stdcall;
  TCkDsa_getHexG = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__hexG = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getHexP = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__hexP = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getHexQ = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__hexQ = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getHexX = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__hexX = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getHexY = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__hexY = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getLastErrorHtml = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__lastErrorHtml = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getLastErrorText = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__lastErrorText = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getLastErrorXml = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__lastErrorXml = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getLastMethodSuccess = function (objHandle: HCkDsa): wordbool; stdcall;
  TCkDsa_putLastMethodSuccess = procedure (objHandle: HCkDsa; newPropVal: wordbool); stdcall;
  TCkDsa_getUncommonOptions = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa_putUncommonOptions = procedure (objHandle: HCkDsa; newPropVal: PWideChar); stdcall;
  TCkDsa__uncommonOptions = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_getVerboseLogging = function (objHandle: HCkDsa): wordbool; stdcall;
  TCkDsa_putVerboseLogging = procedure (objHandle: HCkDsa; newPropVal: wordbool); stdcall;
  TCkDsa_getVersion = procedure (objHandle: HCkDsa; outPropVal: HCkString); stdcall;
  TCkDsa__version = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_FromDer = function (objHandle: HCkDsa; derData: HCkByteData): wordbool; stdcall;
  TCkDsa_FromDerBd = function (objHandle: HCkDsa; bd: HCkBinData): wordbool; stdcall;
  TCkDsa_FromDerFile = function (objHandle: HCkDsa; path: PWideChar): wordbool; stdcall;
  TCkDsa_FromEncryptedPem = function (objHandle: HCkDsa; password: PWideChar; pemData: PWideChar): wordbool; stdcall;
  TCkDsa_FromPem = function (objHandle: HCkDsa; pemData: PWideChar): wordbool; stdcall;
  TCkDsa_FromPublicDer = function (objHandle: HCkDsa; derData: HCkByteData): wordbool; stdcall;
  TCkDsa_FromPublicDerBd = function (objHandle: HCkDsa; bd: HCkBinData): wordbool; stdcall;
  TCkDsa_FromPublicDerFile = function (objHandle: HCkDsa; path: PWideChar): wordbool; stdcall;
  TCkDsa_FromPublicPem = function (objHandle: HCkDsa; pemData: PWideChar): wordbool; stdcall;
  TCkDsa_FromXml = function (objHandle: HCkDsa; xmlKey: PWideChar): wordbool; stdcall;
  TCkDsa_GenKey = function (objHandle: HCkDsa; numBits: Integer): wordbool; stdcall;
  TCkDsa_GenKey2 = function (objHandle: HCkDsa; keyLenBits: Integer; modLenBits: Integer): wordbool; stdcall;
  TCkDsa_GenKeyFromParamsDer = function (objHandle: HCkDsa; derBytes: HCkByteData): wordbool; stdcall;
  TCkDsa_GenKeyFromParamsDerBd = function (objHandle: HCkDsa; bd: HCkBinData): wordbool; stdcall;
  TCkDsa_GenKeyFromParamsDerFile = function (objHandle: HCkDsa; path: PWideChar): wordbool; stdcall;
  TCkDsa_GenKeyFromParamsPem = function (objHandle: HCkDsa; pem: PWideChar): wordbool; stdcall;
  TCkDsa_GenKeyFromParamsPemFile = function (objHandle: HCkDsa; path: PWideChar): wordbool; stdcall;
  TCkDsa_GenKeyFromPQG = function (objHandle: HCkDsa; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar): wordbool; stdcall;
  TCkDsa_GetEncodedHash = function (objHandle: HCkDsa; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkDsa__getEncodedHash = function (objHandle: HCkDsa; encoding: PWideChar): PWideChar; stdcall;
  TCkDsa_GetEncodedSignature = function (objHandle: HCkDsa; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkDsa__getEncodedSignature = function (objHandle: HCkDsa; encoding: PWideChar): PWideChar; stdcall;
  TCkDsa_LoadText = function (objHandle: HCkDsa; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkDsa__loadText = function (objHandle: HCkDsa; path: PWideChar): PWideChar; stdcall;
  TCkDsa_SaveText = function (objHandle: HCkDsa; strToSave: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkDsa_SetEncodedHash = function (objHandle: HCkDsa; encoding: PWideChar; encodedHash: PWideChar): wordbool; stdcall;
  TCkDsa_SetEncodedSignature = function (objHandle: HCkDsa; encoding: PWideChar; encodedSig: PWideChar): wordbool; stdcall;
  TCkDsa_SetEncodedSignatureRS = function (objHandle: HCkDsa; encoding: PWideChar; encodedR: PWideChar; encodedS: PWideChar): wordbool; stdcall;
  TCkDsa_SetKeyExplicit = function (objHandle: HCkDsa; groupSizeInBytes: Integer; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar; xHex: PWideChar): wordbool; stdcall;
  TCkDsa_SetPubKeyExplicit = function (objHandle: HCkDsa; groupSizeInBytes: Integer; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar; yHex: PWideChar): wordbool; stdcall;
  TCkDsa_SignHash = function (objHandle: HCkDsa): wordbool; stdcall;
  TCkDsa_ToDer = function (objHandle: HCkDsa; outData: HCkByteData): wordbool; stdcall;
  TCkDsa_ToDerBd = function (objHandle: HCkDsa; bd: HCkBinData): wordbool; stdcall;
  TCkDsa_ToDerFile = function (objHandle: HCkDsa; path: PWideChar): wordbool; stdcall;
  TCkDsa_ToEncryptedPem = function (objHandle: HCkDsa; password: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkDsa__toEncryptedPem = function (objHandle: HCkDsa; password: PWideChar): PWideChar; stdcall;
  TCkDsa_ToPem = function (objHandle: HCkDsa; outStr: HCkString): wordbool; stdcall;
  TCkDsa__toPem = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_ToPublicDer = function (objHandle: HCkDsa; outData: HCkByteData): wordbool; stdcall;
  TCkDsa_ToPublicDerBd = function (objHandle: HCkDsa; bd: HCkBinData): wordbool; stdcall;
  TCkDsa_ToPublicDerFile = function (objHandle: HCkDsa; path: PWideChar): wordbool; stdcall;
  TCkDsa_ToPublicPem = function (objHandle: HCkDsa; outStr: HCkString): wordbool; stdcall;
  TCkDsa__toPublicPem = function (objHandle: HCkDsa): PWideChar; stdcall;
  TCkDsa_ToXml = function (objHandle: HCkDsa; bPublicOnly: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkDsa__toXml = function (objHandle: HCkDsa; bPublicOnly: wordbool): PWideChar; stdcall;
  TCkDsa_Verify = function (objHandle: HCkDsa): wordbool; stdcall;
  TCkDsa_VerifyKey = function (objHandle: HCkDsa): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..78] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDsa_Create : HCkDsa;
begin
  result := TCkDsa_Create(_map(0, 'CkDsa_Create'));
end;

procedure CkDsa_Dispose (handle: HCkDsa);
begin
  TCkDsa_Dispose(_map(1, 'CkDsa_Dispose'))
    (handle);
end;


procedure CkDsa_getDebugLogFilePath (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getDebugLogFilePath(_map(2, 'CkDsa_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDsa_putDebugLogFilePath (objHandle: HCkDsa; newPropVal: PWideChar);
begin
  TCkDsa_putDebugLogFilePath(_map(3, 'CkDsa_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDsa__debugLogFilePath (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__debugLogFilePath(_map(4, 'CkDsa__debugLogFilePath'))
    (objHandle);
end;

function CkDsa_getGroupSize (objHandle: HCkDsa): Integer;
begin
    result := TCkDsa_getGroupSize(_map(5, 'CkDsa_getGroupSize'))
    (objHandle);
end;

procedure CkDsa_putGroupSize (objHandle: HCkDsa; newPropVal: Integer);
begin
  TCkDsa_putGroupSize(_map(6, 'CkDsa_putGroupSize'))
    (objHandle, newPropVal);
end;

procedure CkDsa_getHexG (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getHexG(_map(7, 'CkDsa_getHexG'))
    (objHandle, outPropVal);
end;

function CkDsa__hexG (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__hexG(_map(8, 'CkDsa__hexG'))
    (objHandle);
end;

procedure CkDsa_getHexP (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getHexP(_map(9, 'CkDsa_getHexP'))
    (objHandle, outPropVal);
end;

function CkDsa__hexP (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__hexP(_map(10, 'CkDsa__hexP'))
    (objHandle);
end;

procedure CkDsa_getHexQ (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getHexQ(_map(11, 'CkDsa_getHexQ'))
    (objHandle, outPropVal);
end;

function CkDsa__hexQ (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__hexQ(_map(12, 'CkDsa__hexQ'))
    (objHandle);
end;

procedure CkDsa_getHexX (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getHexX(_map(13, 'CkDsa_getHexX'))
    (objHandle, outPropVal);
end;

function CkDsa__hexX (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__hexX(_map(14, 'CkDsa__hexX'))
    (objHandle);
end;

procedure CkDsa_getHexY (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getHexY(_map(15, 'CkDsa_getHexY'))
    (objHandle, outPropVal);
end;

function CkDsa__hexY (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__hexY(_map(16, 'CkDsa__hexY'))
    (objHandle);
end;

procedure CkDsa_getLastErrorHtml (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getLastErrorHtml(_map(17, 'CkDsa_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDsa__lastErrorHtml (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__lastErrorHtml(_map(18, 'CkDsa__lastErrorHtml'))
    (objHandle);
end;

procedure CkDsa_getLastErrorText (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getLastErrorText(_map(19, 'CkDsa_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDsa__lastErrorText (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__lastErrorText(_map(20, 'CkDsa__lastErrorText'))
    (objHandle);
end;

procedure CkDsa_getLastErrorXml (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getLastErrorXml(_map(21, 'CkDsa_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDsa__lastErrorXml (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__lastErrorXml(_map(22, 'CkDsa__lastErrorXml'))
    (objHandle);
end;

function CkDsa_getLastMethodSuccess (objHandle: HCkDsa): wordbool;
begin
    result := TCkDsa_getLastMethodSuccess(_map(23, 'CkDsa_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDsa_putLastMethodSuccess (objHandle: HCkDsa; newPropVal: wordbool);
begin
  TCkDsa_putLastMethodSuccess(_map(24, 'CkDsa_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkDsa_getUncommonOptions (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getUncommonOptions(_map(25, 'CkDsa_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkDsa_putUncommonOptions (objHandle: HCkDsa; newPropVal: PWideChar);
begin
  TCkDsa_putUncommonOptions(_map(26, 'CkDsa_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkDsa__uncommonOptions (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__uncommonOptions(_map(27, 'CkDsa__uncommonOptions'))
    (objHandle);
end;

function CkDsa_getVerboseLogging (objHandle: HCkDsa): wordbool;
begin
    result := TCkDsa_getVerboseLogging(_map(28, 'CkDsa_getVerboseLogging'))
    (objHandle);
end;

procedure CkDsa_putVerboseLogging (objHandle: HCkDsa; newPropVal: wordbool);
begin
  TCkDsa_putVerboseLogging(_map(29, 'CkDsa_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDsa_getVersion (objHandle: HCkDsa; outPropVal: HCkString);
begin
  TCkDsa_getVersion(_map(30, 'CkDsa_getVersion'))
    (objHandle, outPropVal);
end;

function CkDsa__version (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__version(_map(31, 'CkDsa__version'))
    (objHandle);
end;

function CkDsa_FromDer (objHandle: HCkDsa; derData: HCkByteData): wordbool;
begin
  result := TCkDsa_FromDer(_map(32, 'CkDsa_FromDer'))
    (objHandle, derData);
end;

function CkDsa_FromDerBd (objHandle: HCkDsa; bd: HCkBinData): wordbool;
begin
  result := TCkDsa_FromDerBd(_map(33, 'CkDsa_FromDerBd'))
    (objHandle, bd);
end;

function CkDsa_FromDerFile (objHandle: HCkDsa; path: PWideChar): wordbool;
begin
  result := TCkDsa_FromDerFile(_map(34, 'CkDsa_FromDerFile'))
    (objHandle, path);
end;

function CkDsa_FromEncryptedPem (objHandle: HCkDsa; password: PWideChar; pemData: PWideChar): wordbool;
begin
  result := TCkDsa_FromEncryptedPem(_map(35, 'CkDsa_FromEncryptedPem'))
    (objHandle, password, pemData);
end;

function CkDsa_FromPem (objHandle: HCkDsa; pemData: PWideChar): wordbool;
begin
  result := TCkDsa_FromPem(_map(36, 'CkDsa_FromPem'))
    (objHandle, pemData);
end;

function CkDsa_FromPublicDer (objHandle: HCkDsa; derData: HCkByteData): wordbool;
begin
  result := TCkDsa_FromPublicDer(_map(37, 'CkDsa_FromPublicDer'))
    (objHandle, derData);
end;

function CkDsa_FromPublicDerBd (objHandle: HCkDsa; bd: HCkBinData): wordbool;
begin
  result := TCkDsa_FromPublicDerBd(_map(38, 'CkDsa_FromPublicDerBd'))
    (objHandle, bd);
end;

function CkDsa_FromPublicDerFile (objHandle: HCkDsa; path: PWideChar): wordbool;
begin
  result := TCkDsa_FromPublicDerFile(_map(39, 'CkDsa_FromPublicDerFile'))
    (objHandle, path);
end;

function CkDsa_FromPublicPem (objHandle: HCkDsa; pemData: PWideChar): wordbool;
begin
  result := TCkDsa_FromPublicPem(_map(40, 'CkDsa_FromPublicPem'))
    (objHandle, pemData);
end;

function CkDsa_FromXml (objHandle: HCkDsa; xmlKey: PWideChar): wordbool;
begin
  result := TCkDsa_FromXml(_map(41, 'CkDsa_FromXml'))
    (objHandle, xmlKey);
end;

function CkDsa_GenKey (objHandle: HCkDsa; numBits: Integer): wordbool;
begin
  result := TCkDsa_GenKey(_map(42, 'CkDsa_GenKey'))
    (objHandle, numBits);
end;

function CkDsa_GenKey2 (objHandle: HCkDsa; keyLenBits: Integer; modLenBits: Integer): wordbool;
begin
  result := TCkDsa_GenKey2(_map(43, 'CkDsa_GenKey2'))
    (objHandle, keyLenBits, modLenBits);
end;

function CkDsa_GenKeyFromParamsDer (objHandle: HCkDsa; derBytes: HCkByteData): wordbool;
begin
  result := TCkDsa_GenKeyFromParamsDer(_map(44, 'CkDsa_GenKeyFromParamsDer'))
    (objHandle, derBytes);
end;

function CkDsa_GenKeyFromParamsDerBd (objHandle: HCkDsa; bd: HCkBinData): wordbool;
begin
  result := TCkDsa_GenKeyFromParamsDerBd(_map(45, 'CkDsa_GenKeyFromParamsDerBd'))
    (objHandle, bd);
end;

function CkDsa_GenKeyFromParamsDerFile (objHandle: HCkDsa; path: PWideChar): wordbool;
begin
  result := TCkDsa_GenKeyFromParamsDerFile(_map(46, 'CkDsa_GenKeyFromParamsDerFile'))
    (objHandle, path);
end;

function CkDsa_GenKeyFromParamsPem (objHandle: HCkDsa; pem: PWideChar): wordbool;
begin
  result := TCkDsa_GenKeyFromParamsPem(_map(47, 'CkDsa_GenKeyFromParamsPem'))
    (objHandle, pem);
end;

function CkDsa_GenKeyFromParamsPemFile (objHandle: HCkDsa; path: PWideChar): wordbool;
begin
  result := TCkDsa_GenKeyFromParamsPemFile(_map(48, 'CkDsa_GenKeyFromParamsPemFile'))
    (objHandle, path);
end;

function CkDsa_GenKeyFromPQG (objHandle: HCkDsa; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar): wordbool;
begin
  result := TCkDsa_GenKeyFromPQG(_map(49, 'CkDsa_GenKeyFromPQG'))
    (objHandle, pHex, qHex, gHex);
end;

function CkDsa_GetEncodedHash (objHandle: HCkDsa; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkDsa_GetEncodedHash(_map(50, 'CkDsa_GetEncodedHash'))
    (objHandle, encoding, outStr);
end;

function CkDsa__getEncodedHash (objHandle: HCkDsa; encoding: PWideChar): PWideChar;
begin
  result := TCkDsa__getEncodedHash(_map(51, 'CkDsa__getEncodedHash'))
    (objHandle, encoding);
end;

function CkDsa_GetEncodedSignature (objHandle: HCkDsa; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkDsa_GetEncodedSignature(_map(52, 'CkDsa_GetEncodedSignature'))
    (objHandle, encoding, outStr);
end;

function CkDsa__getEncodedSignature (objHandle: HCkDsa; encoding: PWideChar): PWideChar;
begin
  result := TCkDsa__getEncodedSignature(_map(53, 'CkDsa__getEncodedSignature'))
    (objHandle, encoding);
end;

function CkDsa_LoadText (objHandle: HCkDsa; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkDsa_LoadText(_map(54, 'CkDsa_LoadText'))
    (objHandle, path, outStr);
end;

function CkDsa__loadText (objHandle: HCkDsa; path: PWideChar): PWideChar;
begin
  result := TCkDsa__loadText(_map(55, 'CkDsa__loadText'))
    (objHandle, path);
end;

function CkDsa_SaveText (objHandle: HCkDsa; strToSave: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkDsa_SaveText(_map(56, 'CkDsa_SaveText'))
    (objHandle, strToSave, path);
end;

function CkDsa_SetEncodedHash (objHandle: HCkDsa; encoding: PWideChar; encodedHash: PWideChar): wordbool;
begin
  result := TCkDsa_SetEncodedHash(_map(57, 'CkDsa_SetEncodedHash'))
    (objHandle, encoding, encodedHash);
end;

function CkDsa_SetEncodedSignature (objHandle: HCkDsa; encoding: PWideChar; encodedSig: PWideChar): wordbool;
begin
  result := TCkDsa_SetEncodedSignature(_map(58, 'CkDsa_SetEncodedSignature'))
    (objHandle, encoding, encodedSig);
end;

function CkDsa_SetEncodedSignatureRS (objHandle: HCkDsa; encoding: PWideChar; encodedR: PWideChar; encodedS: PWideChar): wordbool;
begin
  result := TCkDsa_SetEncodedSignatureRS(_map(59, 'CkDsa_SetEncodedSignatureRS'))
    (objHandle, encoding, encodedR, encodedS);
end;

function CkDsa_SetKeyExplicit (objHandle: HCkDsa; groupSizeInBytes: Integer; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar; xHex: PWideChar): wordbool;
begin
  result := TCkDsa_SetKeyExplicit(_map(60, 'CkDsa_SetKeyExplicit'))
    (objHandle, groupSizeInBytes, pHex, qHex, gHex, xHex);
end;

function CkDsa_SetPubKeyExplicit (objHandle: HCkDsa; groupSizeInBytes: Integer; pHex: PWideChar; qHex: PWideChar; gHex: PWideChar; yHex: PWideChar): wordbool;
begin
  result := TCkDsa_SetPubKeyExplicit(_map(61, 'CkDsa_SetPubKeyExplicit'))
    (objHandle, groupSizeInBytes, pHex, qHex, gHex, yHex);
end;

function CkDsa_SignHash (objHandle: HCkDsa): wordbool;
begin
  result := TCkDsa_SignHash(_map(62, 'CkDsa_SignHash'))
    (objHandle);
end;

function CkDsa_ToDer (objHandle: HCkDsa; outData: HCkByteData): wordbool;
begin
  result := TCkDsa_ToDer(_map(63, 'CkDsa_ToDer'))
    (objHandle, outData);
end;

function CkDsa_ToDerBd (objHandle: HCkDsa; bd: HCkBinData): wordbool;
begin
  result := TCkDsa_ToDerBd(_map(64, 'CkDsa_ToDerBd'))
    (objHandle, bd);
end;

function CkDsa_ToDerFile (objHandle: HCkDsa; path: PWideChar): wordbool;
begin
  result := TCkDsa_ToDerFile(_map(65, 'CkDsa_ToDerFile'))
    (objHandle, path);
end;

function CkDsa_ToEncryptedPem (objHandle: HCkDsa; password: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkDsa_ToEncryptedPem(_map(66, 'CkDsa_ToEncryptedPem'))
    (objHandle, password, outStr);
end;

function CkDsa__toEncryptedPem (objHandle: HCkDsa; password: PWideChar): PWideChar;
begin
  result := TCkDsa__toEncryptedPem(_map(67, 'CkDsa__toEncryptedPem'))
    (objHandle, password);
end;

function CkDsa_ToPem (objHandle: HCkDsa; outStr: HCkString): wordbool;
begin
  result := TCkDsa_ToPem(_map(68, 'CkDsa_ToPem'))
    (objHandle, outStr);
end;

function CkDsa__toPem (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__toPem(_map(69, 'CkDsa__toPem'))
    (objHandle);
end;

function CkDsa_ToPublicDer (objHandle: HCkDsa; outData: HCkByteData): wordbool;
begin
  result := TCkDsa_ToPublicDer(_map(70, 'CkDsa_ToPublicDer'))
    (objHandle, outData);
end;

function CkDsa_ToPublicDerBd (objHandle: HCkDsa; bd: HCkBinData): wordbool;
begin
  result := TCkDsa_ToPublicDerBd(_map(71, 'CkDsa_ToPublicDerBd'))
    (objHandle, bd);
end;

function CkDsa_ToPublicDerFile (objHandle: HCkDsa; path: PWideChar): wordbool;
begin
  result := TCkDsa_ToPublicDerFile(_map(72, 'CkDsa_ToPublicDerFile'))
    (objHandle, path);
end;

function CkDsa_ToPublicPem (objHandle: HCkDsa; outStr: HCkString): wordbool;
begin
  result := TCkDsa_ToPublicPem(_map(73, 'CkDsa_ToPublicPem'))
    (objHandle, outStr);
end;

function CkDsa__toPublicPem (objHandle: HCkDsa): PWideChar;
begin
  result := TCkDsa__toPublicPem(_map(74, 'CkDsa__toPublicPem'))
    (objHandle);
end;

function CkDsa_ToXml (objHandle: HCkDsa; bPublicOnly: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkDsa_ToXml(_map(75, 'CkDsa_ToXml'))
    (objHandle, bPublicOnly, outStr);
end;

function CkDsa__toXml (objHandle: HCkDsa; bPublicOnly: wordbool): PWideChar;
begin
  result := TCkDsa__toXml(_map(76, 'CkDsa__toXml'))
    (objHandle, bPublicOnly);
end;

function CkDsa_Verify (objHandle: HCkDsa): wordbool;
begin
  result := TCkDsa_Verify(_map(77, 'CkDsa_Verify'))
    (objHandle);
end;

function CkDsa_VerifyKey (objHandle: HCkDsa): wordbool;
begin
  result := TCkDsa_VerifyKey(_map(78, 'CkDsa_VerifyKey'))
    (objHandle);
end;

end.
