unit EdDSA;

interface

type

HCkPublicKey = Pointer;
HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkPrng = Pointer;
HCkString = Pointer;
HCkEdDSA = Pointer;


function CkEdDSA_Create: HCkEdDSA;  stdcall;
procedure CkEdDSA_Dispose(handle: HCkEdDSA); stdcall;
procedure CkEdDSA_getAlgorithm(objHandle: HCkEdDSA; outPropVal: HCkString);
procedure CkEdDSA_putAlgorithm(objHandle: HCkEdDSA; newPropVal: PWideChar);
function CkEdDSA__algorithm(objHandle: HCkEdDSA): PWideChar;
procedure CkEdDSA_getContext(objHandle: HCkEdDSA; outPropVal: HCkString);
procedure CkEdDSA_putContext(objHandle: HCkEdDSA; newPropVal: PWideChar);
function CkEdDSA__context(objHandle: HCkEdDSA): PWideChar;
procedure CkEdDSA_getDebugLogFilePath(objHandle: HCkEdDSA; outPropVal: HCkString);
procedure CkEdDSA_putDebugLogFilePath(objHandle: HCkEdDSA; newPropVal: PWideChar);
function CkEdDSA__debugLogFilePath(objHandle: HCkEdDSA): PWideChar;
procedure CkEdDSA_getLastErrorHtml(objHandle: HCkEdDSA; outPropVal: HCkString);
function CkEdDSA__lastErrorHtml(objHandle: HCkEdDSA): PWideChar;
procedure CkEdDSA_getLastErrorText(objHandle: HCkEdDSA; outPropVal: HCkString);
function CkEdDSA__lastErrorText(objHandle: HCkEdDSA): PWideChar;
procedure CkEdDSA_getLastErrorXml(objHandle: HCkEdDSA; outPropVal: HCkString);
function CkEdDSA__lastErrorXml(objHandle: HCkEdDSA): PWideChar;
function CkEdDSA_getLastMethodSuccess(objHandle: HCkEdDSA): wordbool;
procedure CkEdDSA_putLastMethodSuccess(objHandle: HCkEdDSA; newPropVal: wordbool);
function CkEdDSA_getVerboseLogging(objHandle: HCkEdDSA): wordbool;
procedure CkEdDSA_putVerboseLogging(objHandle: HCkEdDSA; newPropVal: wordbool);
procedure CkEdDSA_getVersion(objHandle: HCkEdDSA; outPropVal: HCkString);
function CkEdDSA__version(objHandle: HCkEdDSA): PWideChar;
function CkEdDSA_GenEd25519Key(objHandle: HCkEdDSA; prng: HCkPrng; privKey: HCkPrivateKey): wordbool;
function CkEdDSA_SharedSecretENC(objHandle: HCkEdDSA; privkey: HCkPrivateKey; pubkey: HCkPublicKey; encoding: PWideChar; outStr: HCkString): wordbool;
function CkEdDSA__sharedSecretENC(objHandle: HCkEdDSA; privkey: HCkPrivateKey; pubkey: HCkPublicKey; encoding: PWideChar): PWideChar;
function CkEdDSA_SignBdENC(objHandle: HCkEdDSA; bd: HCkBinData; encoding: PWideChar; privkey: HCkPrivateKey; outStr: HCkString): wordbool;
function CkEdDSA__signBdENC(objHandle: HCkEdDSA; bd: HCkBinData; encoding: PWideChar; privkey: HCkPrivateKey): PWideChar;
function CkEdDSA_VerifyBdENC(objHandle: HCkEdDSA; bd: HCkBinData; encodedSig: PWideChar; enocding: PWideChar; pubkey: HCkPublicKey): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkEdDSA_Create = function : HCkEdDSA; stdcall;
  TCkEdDSA_Dispose = procedure (handle: HCkEdDSA); stdcall;
  TCkEdDSA_getAlgorithm = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA_putAlgorithm = procedure (objHandle: HCkEdDSA; newPropVal: PWideChar); stdcall;
  TCkEdDSA__algorithm = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_getContext = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA_putContext = procedure (objHandle: HCkEdDSA; newPropVal: PWideChar); stdcall;
  TCkEdDSA__context = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_getDebugLogFilePath = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA_putDebugLogFilePath = procedure (objHandle: HCkEdDSA; newPropVal: PWideChar); stdcall;
  TCkEdDSA__debugLogFilePath = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_getLastErrorHtml = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA__lastErrorHtml = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_getLastErrorText = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA__lastErrorText = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_getLastErrorXml = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA__lastErrorXml = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_getLastMethodSuccess = function (objHandle: HCkEdDSA): wordbool; stdcall;
  TCkEdDSA_putLastMethodSuccess = procedure (objHandle: HCkEdDSA; newPropVal: wordbool); stdcall;
  TCkEdDSA_getVerboseLogging = function (objHandle: HCkEdDSA): wordbool; stdcall;
  TCkEdDSA_putVerboseLogging = procedure (objHandle: HCkEdDSA; newPropVal: wordbool); stdcall;
  TCkEdDSA_getVersion = procedure (objHandle: HCkEdDSA; outPropVal: HCkString); stdcall;
  TCkEdDSA__version = function (objHandle: HCkEdDSA): PWideChar; stdcall;
  TCkEdDSA_GenEd25519Key = function (objHandle: HCkEdDSA; prng: HCkPrng; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkEdDSA_SharedSecretENC = function (objHandle: HCkEdDSA; privkey: HCkPrivateKey; pubkey: HCkPublicKey; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkEdDSA__sharedSecretENC = function (objHandle: HCkEdDSA; privkey: HCkPrivateKey; pubkey: HCkPublicKey; encoding: PWideChar): PWideChar; stdcall;
  TCkEdDSA_SignBdENC = function (objHandle: HCkEdDSA; bd: HCkBinData; encoding: PWideChar; privkey: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkEdDSA__signBdENC = function (objHandle: HCkEdDSA; bd: HCkBinData; encoding: PWideChar; privkey: HCkPrivateKey): PWideChar; stdcall;
  TCkEdDSA_VerifyBdENC = function (objHandle: HCkEdDSA; bd: HCkBinData; encodedSig: PWideChar; enocding: PWideChar; pubkey: HCkPublicKey): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..28] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkEdDSA_Create : HCkEdDSA;
begin
  result := TCkEdDSA_Create(_map(0, 'CkEdDSA_Create'));
end;

procedure CkEdDSA_Dispose (handle: HCkEdDSA);
begin
  TCkEdDSA_Dispose(_map(1, 'CkEdDSA_Dispose'))
    (handle);
end;


procedure CkEdDSA_getAlgorithm (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getAlgorithm(_map(2, 'CkEdDSA_getAlgorithm'))
    (objHandle, outPropVal);
end;

procedure CkEdDSA_putAlgorithm (objHandle: HCkEdDSA; newPropVal: PWideChar);
begin
  TCkEdDSA_putAlgorithm(_map(3, 'CkEdDSA_putAlgorithm'))
    (objHandle, newPropVal);
end;

function CkEdDSA__algorithm (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__algorithm(_map(4, 'CkEdDSA__algorithm'))
    (objHandle);
end;

procedure CkEdDSA_getContext (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getContext(_map(5, 'CkEdDSA_getContext'))
    (objHandle, outPropVal);
end;

procedure CkEdDSA_putContext (objHandle: HCkEdDSA; newPropVal: PWideChar);
begin
  TCkEdDSA_putContext(_map(6, 'CkEdDSA_putContext'))
    (objHandle, newPropVal);
end;

function CkEdDSA__context (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__context(_map(7, 'CkEdDSA__context'))
    (objHandle);
end;

procedure CkEdDSA_getDebugLogFilePath (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getDebugLogFilePath(_map(8, 'CkEdDSA_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkEdDSA_putDebugLogFilePath (objHandle: HCkEdDSA; newPropVal: PWideChar);
begin
  TCkEdDSA_putDebugLogFilePath(_map(9, 'CkEdDSA_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkEdDSA__debugLogFilePath (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__debugLogFilePath(_map(10, 'CkEdDSA__debugLogFilePath'))
    (objHandle);
end;

procedure CkEdDSA_getLastErrorHtml (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getLastErrorHtml(_map(11, 'CkEdDSA_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkEdDSA__lastErrorHtml (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__lastErrorHtml(_map(12, 'CkEdDSA__lastErrorHtml'))
    (objHandle);
end;

procedure CkEdDSA_getLastErrorText (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getLastErrorText(_map(13, 'CkEdDSA_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkEdDSA__lastErrorText (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__lastErrorText(_map(14, 'CkEdDSA__lastErrorText'))
    (objHandle);
end;

procedure CkEdDSA_getLastErrorXml (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getLastErrorXml(_map(15, 'CkEdDSA_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkEdDSA__lastErrorXml (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__lastErrorXml(_map(16, 'CkEdDSA__lastErrorXml'))
    (objHandle);
end;

function CkEdDSA_getLastMethodSuccess (objHandle: HCkEdDSA): wordbool;
begin
    result := TCkEdDSA_getLastMethodSuccess(_map(17, 'CkEdDSA_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkEdDSA_putLastMethodSuccess (objHandle: HCkEdDSA; newPropVal: wordbool);
begin
  TCkEdDSA_putLastMethodSuccess(_map(18, 'CkEdDSA_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkEdDSA_getVerboseLogging (objHandle: HCkEdDSA): wordbool;
begin
    result := TCkEdDSA_getVerboseLogging(_map(19, 'CkEdDSA_getVerboseLogging'))
    (objHandle);
end;

procedure CkEdDSA_putVerboseLogging (objHandle: HCkEdDSA; newPropVal: wordbool);
begin
  TCkEdDSA_putVerboseLogging(_map(20, 'CkEdDSA_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkEdDSA_getVersion (objHandle: HCkEdDSA; outPropVal: HCkString);
begin
  TCkEdDSA_getVersion(_map(21, 'CkEdDSA_getVersion'))
    (objHandle, outPropVal);
end;

function CkEdDSA__version (objHandle: HCkEdDSA): PWideChar;
begin
  result := TCkEdDSA__version(_map(22, 'CkEdDSA__version'))
    (objHandle);
end;

function CkEdDSA_GenEd25519Key (objHandle: HCkEdDSA; prng: HCkPrng; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkEdDSA_GenEd25519Key(_map(23, 'CkEdDSA_GenEd25519Key'))
    (objHandle, prng, privKey);
end;

function CkEdDSA_SharedSecretENC (objHandle: HCkEdDSA; privkey: HCkPrivateKey; pubkey: HCkPublicKey; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkEdDSA_SharedSecretENC(_map(24, 'CkEdDSA_SharedSecretENC'))
    (objHandle, privkey, pubkey, encoding, outStr);
end;

function CkEdDSA__sharedSecretENC (objHandle: HCkEdDSA; privkey: HCkPrivateKey; pubkey: HCkPublicKey; encoding: PWideChar): PWideChar;
begin
  result := TCkEdDSA__sharedSecretENC(_map(25, 'CkEdDSA__sharedSecretENC'))
    (objHandle, privkey, pubkey, encoding);
end;

function CkEdDSA_SignBdENC (objHandle: HCkEdDSA; bd: HCkBinData; encoding: PWideChar; privkey: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkEdDSA_SignBdENC(_map(26, 'CkEdDSA_SignBdENC'))
    (objHandle, bd, encoding, privkey, outStr);
end;

function CkEdDSA__signBdENC (objHandle: HCkEdDSA; bd: HCkBinData; encoding: PWideChar; privkey: HCkPrivateKey): PWideChar;
begin
  result := TCkEdDSA__signBdENC(_map(27, 'CkEdDSA__signBdENC'))
    (objHandle, bd, encoding, privkey);
end;

function CkEdDSA_VerifyBdENC (objHandle: HCkEdDSA; bd: HCkBinData; encodedSig: PWideChar; enocding: PWideChar; pubkey: HCkPublicKey): wordbool;
begin
  result := TCkEdDSA_VerifyBdENC(_map(28, 'CkEdDSA_VerifyBdENC'))
    (objHandle, bd, encodedSig, enocding, pubkey);
end;

end.
