unit EmailBundle;

interface

type

HCkJsonObject = Pointer;
HCkEmail = Pointer;
HCkString = Pointer;
HCkEmailBundle = Pointer;
HCkStringArray = Pointer;
HCkTask = Pointer;


function CkEmailBundle_Create: HCkEmailBundle;  stdcall;
procedure CkEmailBundle_Dispose(handle: HCkEmailBundle); stdcall;
procedure CkEmailBundle_getDebugLogFilePath(objHandle: HCkEmailBundle; outPropVal: HCkString);
procedure CkEmailBundle_putDebugLogFilePath(objHandle: HCkEmailBundle; newPropVal: PWideChar);
function CkEmailBundle__debugLogFilePath(objHandle: HCkEmailBundle): PWideChar;
procedure CkEmailBundle_getLastErrorHtml(objHandle: HCkEmailBundle; outPropVal: HCkString);
function CkEmailBundle__lastErrorHtml(objHandle: HCkEmailBundle): PWideChar;
procedure CkEmailBundle_getLastErrorText(objHandle: HCkEmailBundle; outPropVal: HCkString);
function CkEmailBundle__lastErrorText(objHandle: HCkEmailBundle): PWideChar;
procedure CkEmailBundle_getLastErrorXml(objHandle: HCkEmailBundle; outPropVal: HCkString);
function CkEmailBundle__lastErrorXml(objHandle: HCkEmailBundle): PWideChar;
function CkEmailBundle_getLastMethodSuccess(objHandle: HCkEmailBundle): wordbool;
procedure CkEmailBundle_putLastMethodSuccess(objHandle: HCkEmailBundle; newPropVal: wordbool);
function CkEmailBundle_getMessageCount(objHandle: HCkEmailBundle): Integer;
function CkEmailBundle_getVerboseLogging(objHandle: HCkEmailBundle): wordbool;
procedure CkEmailBundle_putVerboseLogging(objHandle: HCkEmailBundle; newPropVal: wordbool);
procedure CkEmailBundle_getVersion(objHandle: HCkEmailBundle; outPropVal: HCkString);
function CkEmailBundle__version(objHandle: HCkEmailBundle): PWideChar;
function CkEmailBundle_AddEmail(objHandle: HCkEmailBundle; email: HCkEmail): wordbool;
procedure CkEmailBundle_Clear(objHandle: HCkEmailBundle);
function CkEmailBundle_EmailAt(objHandle: HCkEmailBundle; index: Integer; email: HCkEmail): wordbool;
function CkEmailBundle_FindByHeader(objHandle: HCkEmailBundle; headerFieldName: PWideChar; headerFieldValue: PWideChar): HCkEmail;
function CkEmailBundle_FindEmail(objHandle: HCkEmailBundle; json: HCkJsonObject; email: HCkEmail): wordbool;
function CkEmailBundle_GetEmail(objHandle: HCkEmailBundle; index: Integer): HCkEmail;
function CkEmailBundle_GetUidls(objHandle: HCkEmailBundle): HCkStringArray;
function CkEmailBundle_GetXml(objHandle: HCkEmailBundle; outStr: HCkString): wordbool;
function CkEmailBundle__getXml(objHandle: HCkEmailBundle): PWideChar;
function CkEmailBundle_LoadTaskResult(objHandle: HCkEmailBundle; task: HCkTask): wordbool;
function CkEmailBundle_LoadXml(objHandle: HCkEmailBundle; filename: PWideChar): wordbool;
function CkEmailBundle_LoadXmlString(objHandle: HCkEmailBundle; xmlStr: PWideChar): wordbool;
function CkEmailBundle_RemoveEmail(objHandle: HCkEmailBundle; email: HCkEmail): wordbool;
function CkEmailBundle_RemoveEmailByIndex(objHandle: HCkEmailBundle; index: Integer): wordbool;
function CkEmailBundle_SaveXml(objHandle: HCkEmailBundle; filename: PWideChar): wordbool;
procedure CkEmailBundle_SortByDate(objHandle: HCkEmailBundle; ascending: wordbool);
procedure CkEmailBundle_SortByRecipient(objHandle: HCkEmailBundle; ascending: wordbool);
procedure CkEmailBundle_SortBySender(objHandle: HCkEmailBundle; ascending: wordbool);
procedure CkEmailBundle_SortBySubject(objHandle: HCkEmailBundle; ascending: wordbool);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkEmailBundle_Create = function : HCkEmailBundle; stdcall;
  TCkEmailBundle_Dispose = procedure (handle: HCkEmailBundle); stdcall;
  TCkEmailBundle_getDebugLogFilePath = procedure (objHandle: HCkEmailBundle; outPropVal: HCkString); stdcall;
  TCkEmailBundle_putDebugLogFilePath = procedure (objHandle: HCkEmailBundle; newPropVal: PWideChar); stdcall;
  TCkEmailBundle__debugLogFilePath = function (objHandle: HCkEmailBundle): PWideChar; stdcall;
  TCkEmailBundle_getLastErrorHtml = procedure (objHandle: HCkEmailBundle; outPropVal: HCkString); stdcall;
  TCkEmailBundle__lastErrorHtml = function (objHandle: HCkEmailBundle): PWideChar; stdcall;
  TCkEmailBundle_getLastErrorText = procedure (objHandle: HCkEmailBundle; outPropVal: HCkString); stdcall;
  TCkEmailBundle__lastErrorText = function (objHandle: HCkEmailBundle): PWideChar; stdcall;
  TCkEmailBundle_getLastErrorXml = procedure (objHandle: HCkEmailBundle; outPropVal: HCkString); stdcall;
  TCkEmailBundle__lastErrorXml = function (objHandle: HCkEmailBundle): PWideChar; stdcall;
  TCkEmailBundle_getLastMethodSuccess = function (objHandle: HCkEmailBundle): wordbool; stdcall;
  TCkEmailBundle_putLastMethodSuccess = procedure (objHandle: HCkEmailBundle; newPropVal: wordbool); stdcall;
  TCkEmailBundle_getMessageCount = function (objHandle: HCkEmailBundle): Integer; stdcall;
  TCkEmailBundle_getVerboseLogging = function (objHandle: HCkEmailBundle): wordbool; stdcall;
  TCkEmailBundle_putVerboseLogging = procedure (objHandle: HCkEmailBundle; newPropVal: wordbool); stdcall;
  TCkEmailBundle_getVersion = procedure (objHandle: HCkEmailBundle; outPropVal: HCkString); stdcall;
  TCkEmailBundle__version = function (objHandle: HCkEmailBundle): PWideChar; stdcall;
  TCkEmailBundle_AddEmail = function (objHandle: HCkEmailBundle; email: HCkEmail): wordbool; stdcall;
  TCkEmailBundle_Clear = procedure (objHandle: HCkEmailBundle); stdcall;
  TCkEmailBundle_EmailAt = function (objHandle: HCkEmailBundle; index: Integer; email: HCkEmail): wordbool; stdcall;
  TCkEmailBundle_FindByHeader = function (objHandle: HCkEmailBundle; headerFieldName: PWideChar; headerFieldValue: PWideChar): HCkEmail; stdcall;
  TCkEmailBundle_FindEmail = function (objHandle: HCkEmailBundle; json: HCkJsonObject; email: HCkEmail): wordbool; stdcall;
  TCkEmailBundle_GetEmail = function (objHandle: HCkEmailBundle; index: Integer): HCkEmail; stdcall;
  TCkEmailBundle_GetUidls = function (objHandle: HCkEmailBundle): HCkStringArray; stdcall;
  TCkEmailBundle_GetXml = function (objHandle: HCkEmailBundle; outStr: HCkString): wordbool; stdcall;
  TCkEmailBundle__getXml = function (objHandle: HCkEmailBundle): PWideChar; stdcall;
  TCkEmailBundle_LoadTaskResult = function (objHandle: HCkEmailBundle; task: HCkTask): wordbool; stdcall;
  TCkEmailBundle_LoadXml = function (objHandle: HCkEmailBundle; filename: PWideChar): wordbool; stdcall;
  TCkEmailBundle_LoadXmlString = function (objHandle: HCkEmailBundle; xmlStr: PWideChar): wordbool; stdcall;
  TCkEmailBundle_RemoveEmail = function (objHandle: HCkEmailBundle; email: HCkEmail): wordbool; stdcall;
  TCkEmailBundle_RemoveEmailByIndex = function (objHandle: HCkEmailBundle; index: Integer): wordbool; stdcall;
  TCkEmailBundle_SaveXml = function (objHandle: HCkEmailBundle; filename: PWideChar): wordbool; stdcall;
  TCkEmailBundle_SortByDate = procedure (objHandle: HCkEmailBundle; ascending: wordbool); stdcall;
  TCkEmailBundle_SortByRecipient = procedure (objHandle: HCkEmailBundle; ascending: wordbool); stdcall;
  TCkEmailBundle_SortBySender = procedure (objHandle: HCkEmailBundle; ascending: wordbool); stdcall;
  TCkEmailBundle_SortBySubject = procedure (objHandle: HCkEmailBundle; ascending: wordbool); stdcall;

var
  _fkt_ptr_arr:   array [0..36] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkEmailBundle_Create : HCkEmailBundle;
begin
  result := TCkEmailBundle_Create(_map(0, 'CkEmailBundle_Create'));
end;

procedure CkEmailBundle_Dispose (handle: HCkEmailBundle);
begin
  TCkEmailBundle_Dispose(_map(1, 'CkEmailBundle_Dispose'))
    (handle);
end;


procedure CkEmailBundle_getDebugLogFilePath (objHandle: HCkEmailBundle; outPropVal: HCkString);
begin
  TCkEmailBundle_getDebugLogFilePath(_map(2, 'CkEmailBundle_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkEmailBundle_putDebugLogFilePath (objHandle: HCkEmailBundle; newPropVal: PWideChar);
begin
  TCkEmailBundle_putDebugLogFilePath(_map(3, 'CkEmailBundle_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkEmailBundle__debugLogFilePath (objHandle: HCkEmailBundle): PWideChar;
begin
  result := TCkEmailBundle__debugLogFilePath(_map(4, 'CkEmailBundle__debugLogFilePath'))
    (objHandle);
end;

procedure CkEmailBundle_getLastErrorHtml (objHandle: HCkEmailBundle; outPropVal: HCkString);
begin
  TCkEmailBundle_getLastErrorHtml(_map(5, 'CkEmailBundle_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkEmailBundle__lastErrorHtml (objHandle: HCkEmailBundle): PWideChar;
begin
  result := TCkEmailBundle__lastErrorHtml(_map(6, 'CkEmailBundle__lastErrorHtml'))
    (objHandle);
end;

procedure CkEmailBundle_getLastErrorText (objHandle: HCkEmailBundle; outPropVal: HCkString);
begin
  TCkEmailBundle_getLastErrorText(_map(7, 'CkEmailBundle_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkEmailBundle__lastErrorText (objHandle: HCkEmailBundle): PWideChar;
begin
  result := TCkEmailBundle__lastErrorText(_map(8, 'CkEmailBundle__lastErrorText'))
    (objHandle);
end;

procedure CkEmailBundle_getLastErrorXml (objHandle: HCkEmailBundle; outPropVal: HCkString);
begin
  TCkEmailBundle_getLastErrorXml(_map(9, 'CkEmailBundle_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkEmailBundle__lastErrorXml (objHandle: HCkEmailBundle): PWideChar;
begin
  result := TCkEmailBundle__lastErrorXml(_map(10, 'CkEmailBundle__lastErrorXml'))
    (objHandle);
end;

function CkEmailBundle_getLastMethodSuccess (objHandle: HCkEmailBundle): wordbool;
begin
    result := TCkEmailBundle_getLastMethodSuccess(_map(11, 'CkEmailBundle_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkEmailBundle_putLastMethodSuccess (objHandle: HCkEmailBundle; newPropVal: wordbool);
begin
  TCkEmailBundle_putLastMethodSuccess(_map(12, 'CkEmailBundle_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkEmailBundle_getMessageCount (objHandle: HCkEmailBundle): Integer;
begin
    result := TCkEmailBundle_getMessageCount(_map(13, 'CkEmailBundle_getMessageCount'))
    (objHandle);
end;

function CkEmailBundle_getVerboseLogging (objHandle: HCkEmailBundle): wordbool;
begin
    result := TCkEmailBundle_getVerboseLogging(_map(14, 'CkEmailBundle_getVerboseLogging'))
    (objHandle);
end;

procedure CkEmailBundle_putVerboseLogging (objHandle: HCkEmailBundle; newPropVal: wordbool);
begin
  TCkEmailBundle_putVerboseLogging(_map(15, 'CkEmailBundle_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkEmailBundle_getVersion (objHandle: HCkEmailBundle; outPropVal: HCkString);
begin
  TCkEmailBundle_getVersion(_map(16, 'CkEmailBundle_getVersion'))
    (objHandle, outPropVal);
end;

function CkEmailBundle__version (objHandle: HCkEmailBundle): PWideChar;
begin
  result := TCkEmailBundle__version(_map(17, 'CkEmailBundle__version'))
    (objHandle);
end;

function CkEmailBundle_AddEmail (objHandle: HCkEmailBundle; email: HCkEmail): wordbool;
begin
  result := TCkEmailBundle_AddEmail(_map(18, 'CkEmailBundle_AddEmail'))
    (objHandle, email);
end;

procedure CkEmailBundle_Clear (objHandle: HCkEmailBundle);
begin
  TCkEmailBundle_Clear(_map(19, 'CkEmailBundle_Clear'))
    (objHandle);
end;

function CkEmailBundle_EmailAt (objHandle: HCkEmailBundle; index: Integer; email: HCkEmail): wordbool;
begin
  result := TCkEmailBundle_EmailAt(_map(20, 'CkEmailBundle_EmailAt'))
    (objHandle, index, email);
end;

function CkEmailBundle_FindByHeader (objHandle: HCkEmailBundle; headerFieldName: PWideChar; headerFieldValue: PWideChar): HCkEmail;
begin
  result := TCkEmailBundle_FindByHeader(_map(21, 'CkEmailBundle_FindByHeader'))
    (objHandle, headerFieldName, headerFieldValue);
end;

function CkEmailBundle_FindEmail (objHandle: HCkEmailBundle; json: HCkJsonObject; email: HCkEmail): wordbool;
begin
  result := TCkEmailBundle_FindEmail(_map(22, 'CkEmailBundle_FindEmail'))
    (objHandle, json, email);
end;

function CkEmailBundle_GetEmail (objHandle: HCkEmailBundle; index: Integer): HCkEmail;
begin
  result := TCkEmailBundle_GetEmail(_map(23, 'CkEmailBundle_GetEmail'))
    (objHandle, index);
end;

function CkEmailBundle_GetUidls (objHandle: HCkEmailBundle): HCkStringArray;
begin
  result := TCkEmailBundle_GetUidls(_map(24, 'CkEmailBundle_GetUidls'))
    (objHandle);
end;

function CkEmailBundle_GetXml (objHandle: HCkEmailBundle; outStr: HCkString): wordbool;
begin
  result := TCkEmailBundle_GetXml(_map(25, 'CkEmailBundle_GetXml'))
    (objHandle, outStr);
end;

function CkEmailBundle__getXml (objHandle: HCkEmailBundle): PWideChar;
begin
  result := TCkEmailBundle__getXml(_map(26, 'CkEmailBundle__getXml'))
    (objHandle);
end;

function CkEmailBundle_LoadTaskResult (objHandle: HCkEmailBundle; task: HCkTask): wordbool;
begin
  result := TCkEmailBundle_LoadTaskResult(_map(27, 'CkEmailBundle_LoadTaskResult'))
    (objHandle, task);
end;

function CkEmailBundle_LoadXml (objHandle: HCkEmailBundle; filename: PWideChar): wordbool;
begin
  result := TCkEmailBundle_LoadXml(_map(28, 'CkEmailBundle_LoadXml'))
    (objHandle, filename);
end;

function CkEmailBundle_LoadXmlString (objHandle: HCkEmailBundle; xmlStr: PWideChar): wordbool;
begin
  result := TCkEmailBundle_LoadXmlString(_map(29, 'CkEmailBundle_LoadXmlString'))
    (objHandle, xmlStr);
end;

function CkEmailBundle_RemoveEmail (objHandle: HCkEmailBundle; email: HCkEmail): wordbool;
begin
  result := TCkEmailBundle_RemoveEmail(_map(30, 'CkEmailBundle_RemoveEmail'))
    (objHandle, email);
end;

function CkEmailBundle_RemoveEmailByIndex (objHandle: HCkEmailBundle; index: Integer): wordbool;
begin
  result := TCkEmailBundle_RemoveEmailByIndex(_map(31, 'CkEmailBundle_RemoveEmailByIndex'))
    (objHandle, index);
end;

function CkEmailBundle_SaveXml (objHandle: HCkEmailBundle; filename: PWideChar): wordbool;
begin
  result := TCkEmailBundle_SaveXml(_map(32, 'CkEmailBundle_SaveXml'))
    (objHandle, filename);
end;

procedure CkEmailBundle_SortByDate (objHandle: HCkEmailBundle; ascending: wordbool);
begin
  TCkEmailBundle_SortByDate(_map(33, 'CkEmailBundle_SortByDate'))
    (objHandle, ascending);
end;

procedure CkEmailBundle_SortByRecipient (objHandle: HCkEmailBundle; ascending: wordbool);
begin
  TCkEmailBundle_SortByRecipient(_map(34, 'CkEmailBundle_SortByRecipient'))
    (objHandle, ascending);
end;

procedure CkEmailBundle_SortBySender (objHandle: HCkEmailBundle; ascending: wordbool);
begin
  TCkEmailBundle_SortBySender(_map(35, 'CkEmailBundle_SortBySender'))
    (objHandle, ascending);
end;

procedure CkEmailBundle_SortBySubject (objHandle: HCkEmailBundle; ascending: wordbool);
begin
  TCkEmailBundle_SortBySubject(_map(36, 'CkEmailBundle_SortBySubject'))
    (objHandle, ascending);
end;

end.
