unit Hashtable;

interface

type

HCkStringTable = Pointer;
HCkStringBuilder = Pointer;
HCkHashtable = Pointer;
HCkString = Pointer;


function CkHashtable_Create: HCkHashtable;  stdcall;
procedure CkHashtable_Dispose(handle: HCkHashtable); stdcall;
function CkHashtable_getCount(objHandle: HCkHashtable): Integer;
procedure CkHashtable_getDebugLogFilePath(objHandle: HCkHashtable; outPropVal: HCkString);
procedure CkHashtable_putDebugLogFilePath(objHandle: HCkHashtable; newPropVal: PWideChar);
function CkHashtable__debugLogFilePath(objHandle: HCkHashtable): PWideChar;
procedure CkHashtable_getLastErrorHtml(objHandle: HCkHashtable; outPropVal: HCkString);
function CkHashtable__lastErrorHtml(objHandle: HCkHashtable): PWideChar;
procedure CkHashtable_getLastErrorText(objHandle: HCkHashtable; outPropVal: HCkString);
function CkHashtable__lastErrorText(objHandle: HCkHashtable): PWideChar;
procedure CkHashtable_getLastErrorXml(objHandle: HCkHashtable; outPropVal: HCkString);
function CkHashtable__lastErrorXml(objHandle: HCkHashtable): PWideChar;
function CkHashtable_getLastMethodSuccess(objHandle: HCkHashtable): wordbool;
procedure CkHashtable_putLastMethodSuccess(objHandle: HCkHashtable; newPropVal: wordbool);
function CkHashtable_getVerboseLogging(objHandle: HCkHashtable): wordbool;
procedure CkHashtable_putVerboseLogging(objHandle: HCkHashtable; newPropVal: wordbool);
procedure CkHashtable_getVersion(objHandle: HCkHashtable; outPropVal: HCkString);
function CkHashtable__version(objHandle: HCkHashtable): PWideChar;
function CkHashtable_AddFromXmlSb(objHandle: HCkHashtable; sbXml: HCkStringBuilder): wordbool;
function CkHashtable_AddInt(objHandle: HCkHashtable; key: PWideChar; value: Integer): wordbool;
function CkHashtable_AddQueryParams(objHandle: HCkHashtable; queryParams: PWideChar): wordbool;
function CkHashtable_AddStr(objHandle: HCkHashtable; key: PWideChar; value: PWideChar): wordbool;
procedure CkHashtable_Clear(objHandle: HCkHashtable);
function CkHashtable_ClearWithNewCapacity(objHandle: HCkHashtable; capacity: Integer): wordbool;
function CkHashtable_Contains(objHandle: HCkHashtable; key: PWideChar): wordbool;
function CkHashtable_ContainsIntKey(objHandle: HCkHashtable; key: Integer): wordbool;
function CkHashtable_GetKeys(objHandle: HCkHashtable; strTable: HCkStringTable): wordbool;
function CkHashtable_LookupInt(objHandle: HCkHashtable; key: PWideChar): Integer;
function CkHashtable_LookupStr(objHandle: HCkHashtable; key: PWideChar; outStr: HCkString): wordbool;
function CkHashtable__lookupStr(objHandle: HCkHashtable; key: PWideChar): PWideChar;
function CkHashtable_Remove(objHandle: HCkHashtable; key: PWideChar): wordbool;
function CkHashtable_ToQueryString(objHandle: HCkHashtable; outStr: HCkString): wordbool;
function CkHashtable__toQueryString(objHandle: HCkHashtable): PWideChar;
function CkHashtable_ToXmlSb(objHandle: HCkHashtable; sbXml: HCkStringBuilder): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkHashtable_Create = function : HCkHashtable; stdcall;
  TCkHashtable_Dispose = procedure (handle: HCkHashtable); stdcall;
  TCkHashtable_getCount = function (objHandle: HCkHashtable): Integer; stdcall;
  TCkHashtable_getDebugLogFilePath = procedure (objHandle: HCkHashtable; outPropVal: HCkString); stdcall;
  TCkHashtable_putDebugLogFilePath = procedure (objHandle: HCkHashtable; newPropVal: PWideChar); stdcall;
  TCkHashtable__debugLogFilePath = function (objHandle: HCkHashtable): PWideChar; stdcall;
  TCkHashtable_getLastErrorHtml = procedure (objHandle: HCkHashtable; outPropVal: HCkString); stdcall;
  TCkHashtable__lastErrorHtml = function (objHandle: HCkHashtable): PWideChar; stdcall;
  TCkHashtable_getLastErrorText = procedure (objHandle: HCkHashtable; outPropVal: HCkString); stdcall;
  TCkHashtable__lastErrorText = function (objHandle: HCkHashtable): PWideChar; stdcall;
  TCkHashtable_getLastErrorXml = procedure (objHandle: HCkHashtable; outPropVal: HCkString); stdcall;
  TCkHashtable__lastErrorXml = function (objHandle: HCkHashtable): PWideChar; stdcall;
  TCkHashtable_getLastMethodSuccess = function (objHandle: HCkHashtable): wordbool; stdcall;
  TCkHashtable_putLastMethodSuccess = procedure (objHandle: HCkHashtable; newPropVal: wordbool); stdcall;
  TCkHashtable_getVerboseLogging = function (objHandle: HCkHashtable): wordbool; stdcall;
  TCkHashtable_putVerboseLogging = procedure (objHandle: HCkHashtable; newPropVal: wordbool); stdcall;
  TCkHashtable_getVersion = procedure (objHandle: HCkHashtable; outPropVal: HCkString); stdcall;
  TCkHashtable__version = function (objHandle: HCkHashtable): PWideChar; stdcall;
  TCkHashtable_AddFromXmlSb = function (objHandle: HCkHashtable; sbXml: HCkStringBuilder): wordbool; stdcall;
  TCkHashtable_AddInt = function (objHandle: HCkHashtable; key: PWideChar; value: Integer): wordbool; stdcall;
  TCkHashtable_AddQueryParams = function (objHandle: HCkHashtable; queryParams: PWideChar): wordbool; stdcall;
  TCkHashtable_AddStr = function (objHandle: HCkHashtable; key: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkHashtable_Clear = procedure (objHandle: HCkHashtable); stdcall;
  TCkHashtable_ClearWithNewCapacity = function (objHandle: HCkHashtable; capacity: Integer): wordbool; stdcall;
  TCkHashtable_Contains = function (objHandle: HCkHashtable; key: PWideChar): wordbool; stdcall;
  TCkHashtable_ContainsIntKey = function (objHandle: HCkHashtable; key: Integer): wordbool; stdcall;
  TCkHashtable_GetKeys = function (objHandle: HCkHashtable; strTable: HCkStringTable): wordbool; stdcall;
  TCkHashtable_LookupInt = function (objHandle: HCkHashtable; key: PWideChar): Integer; stdcall;
  TCkHashtable_LookupStr = function (objHandle: HCkHashtable; key: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHashtable__lookupStr = function (objHandle: HCkHashtable; key: PWideChar): PWideChar; stdcall;
  TCkHashtable_Remove = function (objHandle: HCkHashtable; key: PWideChar): wordbool; stdcall;
  TCkHashtable_ToQueryString = function (objHandle: HCkHashtable; outStr: HCkString): wordbool; stdcall;
  TCkHashtable__toQueryString = function (objHandle: HCkHashtable): PWideChar; stdcall;
  TCkHashtable_ToXmlSb = function (objHandle: HCkHashtable; sbXml: HCkStringBuilder): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..33] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkHashtable_Create : HCkHashtable;
begin
  result := TCkHashtable_Create(_map(0, 'CkHashtable_Create'));
end;

procedure CkHashtable_Dispose (handle: HCkHashtable);
begin
  TCkHashtable_Dispose(_map(1, 'CkHashtable_Dispose'))
    (handle);
end;


function CkHashtable_getCount (objHandle: HCkHashtable): Integer;
begin
    result := TCkHashtable_getCount(_map(2, 'CkHashtable_getCount'))
    (objHandle);
end;

procedure CkHashtable_getDebugLogFilePath (objHandle: HCkHashtable; outPropVal: HCkString);
begin
  TCkHashtable_getDebugLogFilePath(_map(3, 'CkHashtable_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkHashtable_putDebugLogFilePath (objHandle: HCkHashtable; newPropVal: PWideChar);
begin
  TCkHashtable_putDebugLogFilePath(_map(4, 'CkHashtable_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkHashtable__debugLogFilePath (objHandle: HCkHashtable): PWideChar;
begin
  result := TCkHashtable__debugLogFilePath(_map(5, 'CkHashtable__debugLogFilePath'))
    (objHandle);
end;

procedure CkHashtable_getLastErrorHtml (objHandle: HCkHashtable; outPropVal: HCkString);
begin
  TCkHashtable_getLastErrorHtml(_map(6, 'CkHashtable_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkHashtable__lastErrorHtml (objHandle: HCkHashtable): PWideChar;
begin
  result := TCkHashtable__lastErrorHtml(_map(7, 'CkHashtable__lastErrorHtml'))
    (objHandle);
end;

procedure CkHashtable_getLastErrorText (objHandle: HCkHashtable; outPropVal: HCkString);
begin
  TCkHashtable_getLastErrorText(_map(8, 'CkHashtable_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkHashtable__lastErrorText (objHandle: HCkHashtable): PWideChar;
begin
  result := TCkHashtable__lastErrorText(_map(9, 'CkHashtable__lastErrorText'))
    (objHandle);
end;

procedure CkHashtable_getLastErrorXml (objHandle: HCkHashtable; outPropVal: HCkString);
begin
  TCkHashtable_getLastErrorXml(_map(10, 'CkHashtable_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkHashtable__lastErrorXml (objHandle: HCkHashtable): PWideChar;
begin
  result := TCkHashtable__lastErrorXml(_map(11, 'CkHashtable__lastErrorXml'))
    (objHandle);
end;

function CkHashtable_getLastMethodSuccess (objHandle: HCkHashtable): wordbool;
begin
    result := TCkHashtable_getLastMethodSuccess(_map(12, 'CkHashtable_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkHashtable_putLastMethodSuccess (objHandle: HCkHashtable; newPropVal: wordbool);
begin
  TCkHashtable_putLastMethodSuccess(_map(13, 'CkHashtable_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkHashtable_getVerboseLogging (objHandle: HCkHashtable): wordbool;
begin
    result := TCkHashtable_getVerboseLogging(_map(14, 'CkHashtable_getVerboseLogging'))
    (objHandle);
end;

procedure CkHashtable_putVerboseLogging (objHandle: HCkHashtable; newPropVal: wordbool);
begin
  TCkHashtable_putVerboseLogging(_map(15, 'CkHashtable_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkHashtable_getVersion (objHandle: HCkHashtable; outPropVal: HCkString);
begin
  TCkHashtable_getVersion(_map(16, 'CkHashtable_getVersion'))
    (objHandle, outPropVal);
end;

function CkHashtable__version (objHandle: HCkHashtable): PWideChar;
begin
  result := TCkHashtable__version(_map(17, 'CkHashtable__version'))
    (objHandle);
end;

function CkHashtable_AddFromXmlSb (objHandle: HCkHashtable; sbXml: HCkStringBuilder): wordbool;
begin
  result := TCkHashtable_AddFromXmlSb(_map(18, 'CkHashtable_AddFromXmlSb'))
    (objHandle, sbXml);
end;

function CkHashtable_AddInt (objHandle: HCkHashtable; key: PWideChar; value: Integer): wordbool;
begin
  result := TCkHashtable_AddInt(_map(19, 'CkHashtable_AddInt'))
    (objHandle, key, value);
end;

function CkHashtable_AddQueryParams (objHandle: HCkHashtable; queryParams: PWideChar): wordbool;
begin
  result := TCkHashtable_AddQueryParams(_map(20, 'CkHashtable_AddQueryParams'))
    (objHandle, queryParams);
end;

function CkHashtable_AddStr (objHandle: HCkHashtable; key: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkHashtable_AddStr(_map(21, 'CkHashtable_AddStr'))
    (objHandle, key, value);
end;

procedure CkHashtable_Clear (objHandle: HCkHashtable);
begin
  TCkHashtable_Clear(_map(22, 'CkHashtable_Clear'))
    (objHandle);
end;

function CkHashtable_ClearWithNewCapacity (objHandle: HCkHashtable; capacity: Integer): wordbool;
begin
  result := TCkHashtable_ClearWithNewCapacity(_map(23, 'CkHashtable_ClearWithNewCapacity'))
    (objHandle, capacity);
end;

function CkHashtable_Contains (objHandle: HCkHashtable; key: PWideChar): wordbool;
begin
  result := TCkHashtable_Contains(_map(24, 'CkHashtable_Contains'))
    (objHandle, key);
end;

function CkHashtable_ContainsIntKey (objHandle: HCkHashtable; key: Integer): wordbool;
begin
  result := TCkHashtable_ContainsIntKey(_map(25, 'CkHashtable_ContainsIntKey'))
    (objHandle, key);
end;

function CkHashtable_GetKeys (objHandle: HCkHashtable; strTable: HCkStringTable): wordbool;
begin
  result := TCkHashtable_GetKeys(_map(26, 'CkHashtable_GetKeys'))
    (objHandle, strTable);
end;

function CkHashtable_LookupInt (objHandle: HCkHashtable; key: PWideChar): Integer;
begin
  result := TCkHashtable_LookupInt(_map(27, 'CkHashtable_LookupInt'))
    (objHandle, key);
end;

function CkHashtable_LookupStr (objHandle: HCkHashtable; key: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHashtable_LookupStr(_map(28, 'CkHashtable_LookupStr'))
    (objHandle, key, outStr);
end;

function CkHashtable__lookupStr (objHandle: HCkHashtable; key: PWideChar): PWideChar;
begin
  result := TCkHashtable__lookupStr(_map(29, 'CkHashtable__lookupStr'))
    (objHandle, key);
end;

function CkHashtable_Remove (objHandle: HCkHashtable; key: PWideChar): wordbool;
begin
  result := TCkHashtable_Remove(_map(30, 'CkHashtable_Remove'))
    (objHandle, key);
end;

function CkHashtable_ToQueryString (objHandle: HCkHashtable; outStr: HCkString): wordbool;
begin
  result := TCkHashtable_ToQueryString(_map(31, 'CkHashtable_ToQueryString'))
    (objHandle, outStr);
end;

function CkHashtable__toQueryString (objHandle: HCkHashtable): PWideChar;
begin
  result := TCkHashtable__toQueryString(_map(32, 'CkHashtable__toQueryString'))
    (objHandle);
end;

function CkHashtable_ToXmlSb (objHandle: HCkHashtable; sbXml: HCkStringBuilder): wordbool;
begin
  result := TCkHashtable_ToXmlSb(_map(33, 'CkHashtable_ToXmlSb'))
    (objHandle, sbXml);
end;

end.
