unit HtmlToText;

interface

type

HCkStringBuilder = Pointer;
HCkHtmlToText = Pointer;
HCkString = Pointer;


function CkHtmlToText_Create: HCkHtmlToText;  stdcall;
procedure CkHtmlToText_Dispose(handle: HCkHtmlToText); stdcall;
procedure CkHtmlToText_getDebugLogFilePath(objHandle: HCkHtmlToText; outPropVal: HCkString);
procedure CkHtmlToText_putDebugLogFilePath(objHandle: HCkHtmlToText; newPropVal: PWideChar);
function CkHtmlToText__debugLogFilePath(objHandle: HCkHtmlToText): PWideChar;
function CkHtmlToText_getDecodeHtmlEntities(objHandle: HCkHtmlToText): wordbool;
procedure CkHtmlToText_putDecodeHtmlEntities(objHandle: HCkHtmlToText; newPropVal: wordbool);
procedure CkHtmlToText_getLastErrorHtml(objHandle: HCkHtmlToText; outPropVal: HCkString);
function CkHtmlToText__lastErrorHtml(objHandle: HCkHtmlToText): PWideChar;
procedure CkHtmlToText_getLastErrorText(objHandle: HCkHtmlToText; outPropVal: HCkString);
function CkHtmlToText__lastErrorText(objHandle: HCkHtmlToText): PWideChar;
procedure CkHtmlToText_getLastErrorXml(objHandle: HCkHtmlToText; outPropVal: HCkString);
function CkHtmlToText__lastErrorXml(objHandle: HCkHtmlToText): PWideChar;
function CkHtmlToText_getLastMethodSuccess(objHandle: HCkHtmlToText): wordbool;
procedure CkHtmlToText_putLastMethodSuccess(objHandle: HCkHtmlToText; newPropVal: wordbool);
function CkHtmlToText_getRightMargin(objHandle: HCkHtmlToText): Integer;
procedure CkHtmlToText_putRightMargin(objHandle: HCkHtmlToText; newPropVal: Integer);
function CkHtmlToText_getSuppressLinks(objHandle: HCkHtmlToText): wordbool;
procedure CkHtmlToText_putSuppressLinks(objHandle: HCkHtmlToText; newPropVal: wordbool);
procedure CkHtmlToText_getUncommonOptions(objHandle: HCkHtmlToText; outPropVal: HCkString);
procedure CkHtmlToText_putUncommonOptions(objHandle: HCkHtmlToText; newPropVal: PWideChar);
function CkHtmlToText__uncommonOptions(objHandle: HCkHtmlToText): PWideChar;
function CkHtmlToText_getVerboseLogging(objHandle: HCkHtmlToText): wordbool;
procedure CkHtmlToText_putVerboseLogging(objHandle: HCkHtmlToText; newPropVal: wordbool);
procedure CkHtmlToText_getVersion(objHandle: HCkHtmlToText; outPropVal: HCkString);
function CkHtmlToText__version(objHandle: HCkHtmlToText): PWideChar;
function CkHtmlToText_ReadFileToString(objHandle: HCkHtmlToText; filename: PWideChar; srcCharset: PWideChar; outStr: HCkString): wordbool;
function CkHtmlToText__readFileToString(objHandle: HCkHtmlToText; filename: PWideChar; srcCharset: PWideChar): PWideChar;
function CkHtmlToText_ToText(objHandle: HCkHtmlToText; html: PWideChar; outStr: HCkString): wordbool;
function CkHtmlToText__toText(objHandle: HCkHtmlToText; html: PWideChar): PWideChar;
function CkHtmlToText_ToTextSb(objHandle: HCkHtmlToText; sb: HCkStringBuilder): wordbool;
function CkHtmlToText_WriteStringToFile(objHandle: HCkHtmlToText; stringToWrite: PWideChar; filename: PWideChar; charset: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkHtmlToText_Create = function : HCkHtmlToText; stdcall;
  TCkHtmlToText_Dispose = procedure (handle: HCkHtmlToText); stdcall;
  TCkHtmlToText_getDebugLogFilePath = procedure (objHandle: HCkHtmlToText; outPropVal: HCkString); stdcall;
  TCkHtmlToText_putDebugLogFilePath = procedure (objHandle: HCkHtmlToText; newPropVal: PWideChar); stdcall;
  TCkHtmlToText__debugLogFilePath = function (objHandle: HCkHtmlToText): PWideChar; stdcall;
  TCkHtmlToText_getDecodeHtmlEntities = function (objHandle: HCkHtmlToText): wordbool; stdcall;
  TCkHtmlToText_putDecodeHtmlEntities = procedure (objHandle: HCkHtmlToText; newPropVal: wordbool); stdcall;
  TCkHtmlToText_getLastErrorHtml = procedure (objHandle: HCkHtmlToText; outPropVal: HCkString); stdcall;
  TCkHtmlToText__lastErrorHtml = function (objHandle: HCkHtmlToText): PWideChar; stdcall;
  TCkHtmlToText_getLastErrorText = procedure (objHandle: HCkHtmlToText; outPropVal: HCkString); stdcall;
  TCkHtmlToText__lastErrorText = function (objHandle: HCkHtmlToText): PWideChar; stdcall;
  TCkHtmlToText_getLastErrorXml = procedure (objHandle: HCkHtmlToText; outPropVal: HCkString); stdcall;
  TCkHtmlToText__lastErrorXml = function (objHandle: HCkHtmlToText): PWideChar; stdcall;
  TCkHtmlToText_getLastMethodSuccess = function (objHandle: HCkHtmlToText): wordbool; stdcall;
  TCkHtmlToText_putLastMethodSuccess = procedure (objHandle: HCkHtmlToText; newPropVal: wordbool); stdcall;
  TCkHtmlToText_getRightMargin = function (objHandle: HCkHtmlToText): Integer; stdcall;
  TCkHtmlToText_putRightMargin = procedure (objHandle: HCkHtmlToText; newPropVal: Integer); stdcall;
  TCkHtmlToText_getSuppressLinks = function (objHandle: HCkHtmlToText): wordbool; stdcall;
  TCkHtmlToText_putSuppressLinks = procedure (objHandle: HCkHtmlToText; newPropVal: wordbool); stdcall;
  TCkHtmlToText_getUncommonOptions = procedure (objHandle: HCkHtmlToText; outPropVal: HCkString); stdcall;
  TCkHtmlToText_putUncommonOptions = procedure (objHandle: HCkHtmlToText; newPropVal: PWideChar); stdcall;
  TCkHtmlToText__uncommonOptions = function (objHandle: HCkHtmlToText): PWideChar; stdcall;
  TCkHtmlToText_getVerboseLogging = function (objHandle: HCkHtmlToText): wordbool; stdcall;
  TCkHtmlToText_putVerboseLogging = procedure (objHandle: HCkHtmlToText; newPropVal: wordbool); stdcall;
  TCkHtmlToText_getVersion = procedure (objHandle: HCkHtmlToText; outPropVal: HCkString); stdcall;
  TCkHtmlToText__version = function (objHandle: HCkHtmlToText): PWideChar; stdcall;
  TCkHtmlToText_ReadFileToString = function (objHandle: HCkHtmlToText; filename: PWideChar; srcCharset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHtmlToText__readFileToString = function (objHandle: HCkHtmlToText; filename: PWideChar; srcCharset: PWideChar): PWideChar; stdcall;
  TCkHtmlToText_ToText = function (objHandle: HCkHtmlToText; html: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHtmlToText__toText = function (objHandle: HCkHtmlToText; html: PWideChar): PWideChar; stdcall;
  TCkHtmlToText_ToTextSb = function (objHandle: HCkHtmlToText; sb: HCkStringBuilder): wordbool; stdcall;
  TCkHtmlToText_WriteStringToFile = function (objHandle: HCkHtmlToText; stringToWrite: PWideChar; filename: PWideChar; charset: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..31] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkHtmlToText_Create : HCkHtmlToText;
begin
  result := TCkHtmlToText_Create(_map(0, 'CkHtmlToText_Create'));
end;

procedure CkHtmlToText_Dispose (handle: HCkHtmlToText);
begin
  TCkHtmlToText_Dispose(_map(1, 'CkHtmlToText_Dispose'))
    (handle);
end;


procedure CkHtmlToText_getDebugLogFilePath (objHandle: HCkHtmlToText; outPropVal: HCkString);
begin
  TCkHtmlToText_getDebugLogFilePath(_map(2, 'CkHtmlToText_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkHtmlToText_putDebugLogFilePath (objHandle: HCkHtmlToText; newPropVal: PWideChar);
begin
  TCkHtmlToText_putDebugLogFilePath(_map(3, 'CkHtmlToText_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkHtmlToText__debugLogFilePath (objHandle: HCkHtmlToText): PWideChar;
begin
  result := TCkHtmlToText__debugLogFilePath(_map(4, 'CkHtmlToText__debugLogFilePath'))
    (objHandle);
end;

function CkHtmlToText_getDecodeHtmlEntities (objHandle: HCkHtmlToText): wordbool;
begin
    result := TCkHtmlToText_getDecodeHtmlEntities(_map(5, 'CkHtmlToText_getDecodeHtmlEntities'))
    (objHandle);
end;

procedure CkHtmlToText_putDecodeHtmlEntities (objHandle: HCkHtmlToText; newPropVal: wordbool);
begin
  TCkHtmlToText_putDecodeHtmlEntities(_map(6, 'CkHtmlToText_putDecodeHtmlEntities'))
    (objHandle, newPropVal);
end;

procedure CkHtmlToText_getLastErrorHtml (objHandle: HCkHtmlToText; outPropVal: HCkString);
begin
  TCkHtmlToText_getLastErrorHtml(_map(7, 'CkHtmlToText_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkHtmlToText__lastErrorHtml (objHandle: HCkHtmlToText): PWideChar;
begin
  result := TCkHtmlToText__lastErrorHtml(_map(8, 'CkHtmlToText__lastErrorHtml'))
    (objHandle);
end;

procedure CkHtmlToText_getLastErrorText (objHandle: HCkHtmlToText; outPropVal: HCkString);
begin
  TCkHtmlToText_getLastErrorText(_map(9, 'CkHtmlToText_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkHtmlToText__lastErrorText (objHandle: HCkHtmlToText): PWideChar;
begin
  result := TCkHtmlToText__lastErrorText(_map(10, 'CkHtmlToText__lastErrorText'))
    (objHandle);
end;

procedure CkHtmlToText_getLastErrorXml (objHandle: HCkHtmlToText; outPropVal: HCkString);
begin
  TCkHtmlToText_getLastErrorXml(_map(11, 'CkHtmlToText_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkHtmlToText__lastErrorXml (objHandle: HCkHtmlToText): PWideChar;
begin
  result := TCkHtmlToText__lastErrorXml(_map(12, 'CkHtmlToText__lastErrorXml'))
    (objHandle);
end;

function CkHtmlToText_getLastMethodSuccess (objHandle: HCkHtmlToText): wordbool;
begin
    result := TCkHtmlToText_getLastMethodSuccess(_map(13, 'CkHtmlToText_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkHtmlToText_putLastMethodSuccess (objHandle: HCkHtmlToText; newPropVal: wordbool);
begin
  TCkHtmlToText_putLastMethodSuccess(_map(14, 'CkHtmlToText_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkHtmlToText_getRightMargin (objHandle: HCkHtmlToText): Integer;
begin
    result := TCkHtmlToText_getRightMargin(_map(15, 'CkHtmlToText_getRightMargin'))
    (objHandle);
end;

procedure CkHtmlToText_putRightMargin (objHandle: HCkHtmlToText; newPropVal: Integer);
begin
  TCkHtmlToText_putRightMargin(_map(16, 'CkHtmlToText_putRightMargin'))
    (objHandle, newPropVal);
end;

function CkHtmlToText_getSuppressLinks (objHandle: HCkHtmlToText): wordbool;
begin
    result := TCkHtmlToText_getSuppressLinks(_map(17, 'CkHtmlToText_getSuppressLinks'))
    (objHandle);
end;

procedure CkHtmlToText_putSuppressLinks (objHandle: HCkHtmlToText; newPropVal: wordbool);
begin
  TCkHtmlToText_putSuppressLinks(_map(18, 'CkHtmlToText_putSuppressLinks'))
    (objHandle, newPropVal);
end;

procedure CkHtmlToText_getUncommonOptions (objHandle: HCkHtmlToText; outPropVal: HCkString);
begin
  TCkHtmlToText_getUncommonOptions(_map(19, 'CkHtmlToText_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkHtmlToText_putUncommonOptions (objHandle: HCkHtmlToText; newPropVal: PWideChar);
begin
  TCkHtmlToText_putUncommonOptions(_map(20, 'CkHtmlToText_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkHtmlToText__uncommonOptions (objHandle: HCkHtmlToText): PWideChar;
begin
  result := TCkHtmlToText__uncommonOptions(_map(21, 'CkHtmlToText__uncommonOptions'))
    (objHandle);
end;

function CkHtmlToText_getVerboseLogging (objHandle: HCkHtmlToText): wordbool;
begin
    result := TCkHtmlToText_getVerboseLogging(_map(22, 'CkHtmlToText_getVerboseLogging'))
    (objHandle);
end;

procedure CkHtmlToText_putVerboseLogging (objHandle: HCkHtmlToText; newPropVal: wordbool);
begin
  TCkHtmlToText_putVerboseLogging(_map(23, 'CkHtmlToText_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkHtmlToText_getVersion (objHandle: HCkHtmlToText; outPropVal: HCkString);
begin
  TCkHtmlToText_getVersion(_map(24, 'CkHtmlToText_getVersion'))
    (objHandle, outPropVal);
end;

function CkHtmlToText__version (objHandle: HCkHtmlToText): PWideChar;
begin
  result := TCkHtmlToText__version(_map(25, 'CkHtmlToText__version'))
    (objHandle);
end;

function CkHtmlToText_ReadFileToString (objHandle: HCkHtmlToText; filename: PWideChar; srcCharset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHtmlToText_ReadFileToString(_map(26, 'CkHtmlToText_ReadFileToString'))
    (objHandle, filename, srcCharset, outStr);
end;

function CkHtmlToText__readFileToString (objHandle: HCkHtmlToText; filename: PWideChar; srcCharset: PWideChar): PWideChar;
begin
  result := TCkHtmlToText__readFileToString(_map(27, 'CkHtmlToText__readFileToString'))
    (objHandle, filename, srcCharset);
end;

function CkHtmlToText_ToText (objHandle: HCkHtmlToText; html: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHtmlToText_ToText(_map(28, 'CkHtmlToText_ToText'))
    (objHandle, html, outStr);
end;

function CkHtmlToText__toText (objHandle: HCkHtmlToText; html: PWideChar): PWideChar;
begin
  result := TCkHtmlToText__toText(_map(29, 'CkHtmlToText__toText'))
    (objHandle, html);
end;

function CkHtmlToText_ToTextSb (objHandle: HCkHtmlToText; sb: HCkStringBuilder): wordbool;
begin
  result := TCkHtmlToText_ToTextSb(_map(30, 'CkHtmlToText_ToTextSb'))
    (objHandle, sb);
end;

function CkHtmlToText_WriteStringToFile (objHandle: HCkHtmlToText; stringToWrite: PWideChar; filename: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkHtmlToText_WriteStringToFile(_map(31, 'CkHtmlToText_WriteStringToFile'))
    (objHandle, stringToWrite, filename, charset);
end;

end.
