unit Http;

interface

type

HCkPrivateKey = Pointer;
HCkSecureString = Pointer;
HCkStringBuilder = Pointer;
HCkCert = Pointer;
HCkHttpResponse = Pointer;
HCkHttpRequest = Pointer;
HCkHashtable = Pointer;
HCkString = Pointer;
HCkStringTable = Pointer;
HCkByteData = Pointer;
HCkDateTime = Pointer;
HCkHttp = Pointer;
HCkStringArray = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
THttpAbortCheck = function(): Integer; cdecl;
THttpProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
THttpPercentDone = function(pctDone: Integer): Integer; cdecl;
THttpTaskCompleted = procedure(task: HCkTask); cdecl;


function CkHttp_Create: HCkHttp;  stdcall;
procedure CkHttp_Dispose(handle: HCkHttp); stdcall;

procedure CkHttp_SetAbortCheck(objHandle: HCkHttp; fn: THttpAbortCheck) stdcall;
procedure CkHttp_SetProgressInfo(objHandle: HCkHttp; fn: THttpProgressInfo) stdcall;
procedure CkHttp_SetPercentDone(objHandle: HCkHttp; fn: THttpPercentDone) stdcall;
procedure CkHttp_SetTaskCompleted(objHandle: HCkHttp; fn: THttpTaskCompleted) stdcall;
function CkHttp_getAbortCurrent(objHandle: HCkHttp): wordbool;
procedure CkHttp_putAbortCurrent(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getAccept(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAccept(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__accept(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAcceptCharset(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAcceptCharset(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__acceptCharset(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAcceptLanguage(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAcceptLanguage(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__acceptLanguage(objHandle: HCkHttp): PWideChar;
function CkHttp_getAllowGzip(objHandle: HCkHttp): wordbool;
procedure CkHttp_putAllowGzip(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getAllowHeaderFolding(objHandle: HCkHttp): wordbool;
procedure CkHttp_putAllowHeaderFolding(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getAuthSignature(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAuthSignature(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__authSignature(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAuthToken(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAuthToken(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__authToken(objHandle: HCkHttp): PWideChar;
function CkHttp_getAutoAddHostHeader(objHandle: HCkHttp): wordbool;
procedure CkHttp_putAutoAddHostHeader(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getAwsAccessKey(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAwsAccessKey(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__awsAccessKey(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAwsEndpoint(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAwsEndpoint(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__awsEndpoint(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAwsRegion(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAwsRegion(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__awsRegion(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAwsSecretKey(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAwsSecretKey(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__awsSecretKey(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getAwsSessionToken(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAwsSessionToken(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__awsSessionToken(objHandle: HCkHttp): PWideChar;
function CkHttp_getAwsSignatureVersion(objHandle: HCkHttp): Integer;
procedure CkHttp_putAwsSignatureVersion(objHandle: HCkHttp; newPropVal: Integer);
procedure CkHttp_getAwsSubResources(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putAwsSubResources(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__awsSubResources(objHandle: HCkHttp): PWideChar;
function CkHttp_getBandwidthThrottleDown(objHandle: HCkHttp): Integer;
procedure CkHttp_putBandwidthThrottleDown(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getBandwidthThrottleUp(objHandle: HCkHttp): Integer;
procedure CkHttp_putBandwidthThrottleUp(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getBasicAuth(objHandle: HCkHttp): wordbool;
procedure CkHttp_putBasicAuth(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getClientIpAddress(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putClientIpAddress(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__clientIpAddress(objHandle: HCkHttp): PWideChar;
function CkHttp_getConnectFailReason(objHandle: HCkHttp): Integer;
procedure CkHttp_getConnection(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putConnection(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__connection(objHandle: HCkHttp): PWideChar;
function CkHttp_getConnectTimeout(objHandle: HCkHttp): Integer;
procedure CkHttp_putConnectTimeout(objHandle: HCkHttp; newPropVal: Integer);
procedure CkHttp_getCookieDir(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putCookieDir(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__cookieDir(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getDebugLogFilePath(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putDebugLogFilePath(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__debugLogFilePath(objHandle: HCkHttp): PWideChar;
function CkHttp_getDefaultFreshPeriod(objHandle: HCkHttp): Integer;
procedure CkHttp_putDefaultFreshPeriod(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getDigestAuth(objHandle: HCkHttp): wordbool;
procedure CkHttp_putDigestAuth(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getFetchFromCache(objHandle: HCkHttp): wordbool;
procedure CkHttp_putFetchFromCache(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getFinalRedirectUrl(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__finalRedirectUrl(objHandle: HCkHttp): PWideChar;
function CkHttp_getFollowRedirects(objHandle: HCkHttp): wordbool;
procedure CkHttp_putFollowRedirects(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getFreshnessAlgorithm(objHandle: HCkHttp): Integer;
procedure CkHttp_putFreshnessAlgorithm(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getHeartbeatMs(objHandle: HCkHttp): Integer;
procedure CkHttp_putHeartbeatMs(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getIgnoreMustRevalidate(objHandle: HCkHttp): wordbool;
procedure CkHttp_putIgnoreMustRevalidate(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getIgnoreNoCache(objHandle: HCkHttp): wordbool;
procedure CkHttp_putIgnoreNoCache(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getKeepResponseBody(objHandle: HCkHttp): wordbool;
procedure CkHttp_putKeepResponseBody(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getLastContentType(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastContentType(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getLastErrorHtml(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastErrorHtml(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getLastErrorText(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastErrorText(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getLastErrorXml(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastErrorXml(objHandle: HCkHttp): PWideChar;
function CkHttp_getLastFromCache(objHandle: HCkHttp): wordbool;
procedure CkHttp_getLastHeader(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastHeader(objHandle: HCkHttp): PWideChar;
function CkHttp_getLastMethodSuccess(objHandle: HCkHttp): wordbool;
procedure CkHttp_putLastMethodSuccess(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getLastModDate(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastModDate(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getLastResponseBody(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastResponseBody(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getLastResponseHeader(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastResponseHeader(objHandle: HCkHttp): PWideChar;
function CkHttp_getLastStatus(objHandle: HCkHttp): Integer;
procedure CkHttp_getLastStatusText(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__lastStatusText(objHandle: HCkHttp): PWideChar;
function CkHttp_getLMFactor(objHandle: HCkHttp): Integer;
procedure CkHttp_putLMFactor(objHandle: HCkHttp; newPropVal: Integer);
procedure CkHttp_getLogin(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putLogin(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__login(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getLoginDomain(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putLoginDomain(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__loginDomain(objHandle: HCkHttp): PWideChar;
function CkHttp_getMaxConnections(objHandle: HCkHttp): Integer;
procedure CkHttp_putMaxConnections(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getMaxFreshPeriod(objHandle: HCkHttp): Integer;
procedure CkHttp_putMaxFreshPeriod(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getMaxResponseSize(objHandle: HCkHttp): LongWord;
procedure CkHttp_putMaxResponseSize(objHandle: HCkHttp; newPropVal: LongWord);
function CkHttp_getMaxUrlLen(objHandle: HCkHttp): Integer;
procedure CkHttp_putMaxUrlLen(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getMimicFireFox(objHandle: HCkHttp): wordbool;
procedure CkHttp_putMimicFireFox(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getMimicIE(objHandle: HCkHttp): wordbool;
procedure CkHttp_putMimicIE(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getMinFreshPeriod(objHandle: HCkHttp): Integer;
procedure CkHttp_putMinFreshPeriod(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getNegotiateAuth(objHandle: HCkHttp): wordbool;
procedure CkHttp_putNegotiateAuth(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getNtlmAuth(objHandle: HCkHttp): wordbool;
procedure CkHttp_putNtlmAuth(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getNumCacheLevels(objHandle: HCkHttp): Integer;
procedure CkHttp_putNumCacheLevels(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getNumCacheRoots(objHandle: HCkHttp): Integer;
function CkHttp_getOAuth1(objHandle: HCkHttp): wordbool;
procedure CkHttp_putOAuth1(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getOAuthBodyHash(objHandle: HCkHttp): wordbool;
procedure CkHttp_putOAuthBodyHash(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getOAuthCallback(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthCallback(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthCallback(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthConsumerKey(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthConsumerKey(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthConsumerKey(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthConsumerSecret(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthConsumerSecret(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthConsumerSecret(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthRealm(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthRealm(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthRealm(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthSigMethod(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthSigMethod(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthSigMethod(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthToken(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthToken(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthToken(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthTokenSecret(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthTokenSecret(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthTokenSecret(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getOAuthVerifier(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putOAuthVerifier(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__oAuthVerifier(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getPassword(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putPassword(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__password(objHandle: HCkHttp): PWideChar;
function CkHttp_getPercentDoneScale(objHandle: HCkHttp): Integer;
procedure CkHttp_putPercentDoneScale(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getPreferIpv6(objHandle: HCkHttp): wordbool;
procedure CkHttp_putPreferIpv6(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getProxyAuthMethod(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putProxyAuthMethod(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__proxyAuthMethod(objHandle: HCkHttp): PWideChar;
function CkHttp_getProxyDirectTls(objHandle: HCkHttp): wordbool;
procedure CkHttp_putProxyDirectTls(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getProxyDomain(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putProxyDomain(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__proxyDomain(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getProxyLogin(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putProxyLogin(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__proxyLogin(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getProxyLoginDomain(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putProxyLoginDomain(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__proxyLoginDomain(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getProxyPassword(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putProxyPassword(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__proxyPassword(objHandle: HCkHttp): PWideChar;
function CkHttp_getProxyPort(objHandle: HCkHttp): Integer;
procedure CkHttp_putProxyPort(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getReadTimeout(objHandle: HCkHttp): Integer;
procedure CkHttp_putReadTimeout(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getReceivedCertReq(objHandle: HCkHttp): wordbool;
procedure CkHttp_getRedirectVerb(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putRedirectVerb(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__redirectVerb(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getReferer(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putReferer(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__referer(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getRequiredContentType(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putRequiredContentType(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__requiredContentType(objHandle: HCkHttp): PWideChar;
function CkHttp_getRequireHostnameMatch(objHandle: HCkHttp): wordbool;
procedure CkHttp_putRequireHostnameMatch(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getRequireSslCertVerify(objHandle: HCkHttp): wordbool;
procedure CkHttp_putRequireSslCertVerify(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getSaveCookies(objHandle: HCkHttp): wordbool;
procedure CkHttp_putSaveCookies(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getSendBufferSize(objHandle: HCkHttp): Integer;
procedure CkHttp_putSendBufferSize(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getSendCookies(objHandle: HCkHttp): wordbool;
procedure CkHttp_putSendCookies(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getSessionLogFilename(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSessionLogFilename(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__sessionLogFilename(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getSniHostname(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSniHostname(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__sniHostname(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getSocksHostname(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSocksHostname(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__socksHostname(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getSocksPassword(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSocksPassword(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__socksPassword(objHandle: HCkHttp): PWideChar;
function CkHttp_getSocksPort(objHandle: HCkHttp): Integer;
procedure CkHttp_putSocksPort(objHandle: HCkHttp; newPropVal: Integer);
procedure CkHttp_getSocksUsername(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSocksUsername(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__socksUsername(objHandle: HCkHttp): PWideChar;
function CkHttp_getSocksVersion(objHandle: HCkHttp): Integer;
procedure CkHttp_putSocksVersion(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getSoRcvBuf(objHandle: HCkHttp): Integer;
procedure CkHttp_putSoRcvBuf(objHandle: HCkHttp; newPropVal: Integer);
function CkHttp_getSoSndBuf(objHandle: HCkHttp): Integer;
procedure CkHttp_putSoSndBuf(objHandle: HCkHttp; newPropVal: Integer);
procedure CkHttp_getSslAllowedCiphers(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSslAllowedCiphers(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__sslAllowedCiphers(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getSslProtocol(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putSslProtocol(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__sslProtocol(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getStreamResponseBodyPath(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putStreamResponseBodyPath(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__streamResponseBodyPath(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getTlsCipherSuite(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__tlsCipherSuite(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getTlsPinSet(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putTlsPinSet(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__tlsPinSet(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getTlsVersion(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__tlsVersion(objHandle: HCkHttp): PWideChar;
procedure CkHttp_getUncommonOptions(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putUncommonOptions(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__uncommonOptions(objHandle: HCkHttp): PWideChar;
function CkHttp_getUpdateCache(objHandle: HCkHttp): wordbool;
procedure CkHttp_putUpdateCache(objHandle: HCkHttp; newPropVal: wordbool);
function CkHttp_getUseIEProxy(objHandle: HCkHttp): wordbool;
procedure CkHttp_putUseIEProxy(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getUserAgent(objHandle: HCkHttp; outPropVal: HCkString);
procedure CkHttp_putUserAgent(objHandle: HCkHttp; newPropVal: PWideChar);
function CkHttp__userAgent(objHandle: HCkHttp): PWideChar;
function CkHttp_getVerboseLogging(objHandle: HCkHttp): wordbool;
procedure CkHttp_putVerboseLogging(objHandle: HCkHttp; newPropVal: wordbool);
procedure CkHttp_getVersion(objHandle: HCkHttp; outPropVal: HCkString);
function CkHttp__version(objHandle: HCkHttp): PWideChar;
function CkHttp_getWasRedirected(objHandle: HCkHttp): wordbool;
procedure CkHttp_AddCacheRoot(objHandle: HCkHttp; dir: PWideChar);
procedure CkHttp_ClearHeaders(objHandle: HCkHttp);
procedure CkHttp_ClearInMemoryCookies(objHandle: HCkHttp);
procedure CkHttp_ClearUrlVars(objHandle: HCkHttp);
function CkHttp_CloseAllConnections(objHandle: HCkHttp): wordbool;
function CkHttp_CloseAllConnectionsAsync(objHandle: HCkHttp): HCkTask;
function CkHttp_CreateOcspRequest(objHandle: HCkHttp; requestDetails: HCkJsonObject; ocspRequest: HCkBinData): wordbool;
function CkHttp_CreateTimestampRequest(objHandle: HCkHttp; hashAlg: PWideChar; hashVal: PWideChar; reqPolicyOid: PWideChar; addNonce: wordbool; reqTsaCert: wordbool; timestampToken: HCkBinData): wordbool;
procedure CkHttp_DnsCacheClear(objHandle: HCkHttp);
function CkHttp_Download(objHandle: HCkHttp; url: PWideChar; localFilePath: PWideChar): wordbool;
function CkHttp_DownloadAsync(objHandle: HCkHttp; url: PWideChar; localFilePath: PWideChar): HCkTask;
function CkHttp_DownloadAppend(objHandle: HCkHttp; url: PWideChar; appendToPath: PWideChar): wordbool;
function CkHttp_DownloadAppendAsync(objHandle: HCkHttp; url: PWideChar; appendToPath: PWideChar): HCkTask;
function CkHttp_DownloadBd(objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool;
function CkHttp_DownloadBdAsync(objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask;
function CkHttp_DownloadHash(objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkHttp__downloadHash(objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar): PWideChar;
function CkHttp_DownloadHashAsync(objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar): HCkTask;
function CkHttp_DownloadSb(objHandle: HCkHttp; url: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool;
function CkHttp_DownloadSbAsync(objHandle: HCkHttp; url: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
function CkHttp_ExtractMetaRefreshUrl(objHandle: HCkHttp; htmlContent: PWideChar; outStr: HCkString): wordbool;
function CkHttp__extractMetaRefreshUrl(objHandle: HCkHttp; htmlContent: PWideChar): PWideChar;
function CkHttp_G_SvcOauthAccessToken(objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert; outStr: HCkString): wordbool;
function CkHttp__g_SvcOauthAccessToken(objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert): PWideChar;
function CkHttp_G_SvcOauthAccessTokenAsync(objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert): HCkTask;
function CkHttp_G_SvcOauthAccessToken2(objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert; outStr: HCkString): wordbool;
function CkHttp__g_SvcOauthAccessToken2(objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert): PWideChar;
function CkHttp_G_SvcOauthAccessToken2Async(objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert): HCkTask;
function CkHttp_GenTimeStamp(objHandle: HCkHttp; outStr: HCkString): wordbool;
function CkHttp__genTimeStamp(objHandle: HCkHttp): PWideChar;
function CkHttp_GetCacheRoot(objHandle: HCkHttp; index: Integer; outStr: HCkString): wordbool;
function CkHttp__getCacheRoot(objHandle: HCkHttp; index: Integer): PWideChar;
function CkHttp_GetCookieXml(objHandle: HCkHttp; domain: PWideChar; outStr: HCkString): wordbool;
function CkHttp__getCookieXml(objHandle: HCkHttp; domain: PWideChar): PWideChar;
function CkHttp_GetDomain(objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
function CkHttp__getDomain(objHandle: HCkHttp; url: PWideChar): PWideChar;
function CkHttp_GetHead(objHandle: HCkHttp; url: PWideChar): HCkHttpResponse;
function CkHttp_GetHeadAsync(objHandle: HCkHttp; url: PWideChar): HCkTask;
procedure CkHttp_GetLastJsonData(objHandle: HCkHttp; json: HCkJsonObject);
function CkHttp_GetRequestHeader(objHandle: HCkHttp; name: PWideChar; outStr: HCkString): wordbool;
function CkHttp__getRequestHeader(objHandle: HCkHttp; name: PWideChar): PWideChar;
function CkHttp_GetServerCert(objHandle: HCkHttp; domain: PWideChar; port: Integer; cert: HCkCert): wordbool;
function CkHttp_GetServerCertAsync(objHandle: HCkHttp; domain: PWideChar; port: Integer; cert: HCkCert): HCkTask;
function CkHttp_GetServerSslCert(objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkCert;
function CkHttp_GetServerSslCertAsync(objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkTask;
function CkHttp_GetUrlPath(objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
function CkHttp__getUrlPath(objHandle: HCkHttp; url: PWideChar): PWideChar;
function CkHttp_HasRequestHeader(objHandle: HCkHttp; name: PWideChar): wordbool;
function CkHttp_HttpBd(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bd: HCkBinData; contentType: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpBdAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bd: HCkBinData; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpBinary(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpBinaryAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpFile(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpFileAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpJson(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; contentType: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpJsonAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpNoBody(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpNoBodyAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpParams(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; response: HCkHttpResponse): wordbool;
function CkHttp_HttpParamsAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpReq(objHandle: HCkHttp; url: PWideChar; request: HCkHttpRequest; response: HCkHttpResponse): wordbool;
function CkHttp_HttpReqAsync(objHandle: HCkHttp; url: PWideChar; request: HCkHttpRequest; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpSb(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; sb: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpSbAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; sb: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpSReq(objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; request: HCkHttpRequest; response: HCkHttpResponse): wordbool;
function CkHttp_HttpSReqAsync(objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; request: HCkHttpRequest; response: HCkHttpResponse): HCkTask;
function CkHttp_HttpStr(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bodyStr: PWideChar; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool;
function CkHttp_HttpStrAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bodyStr: PWideChar; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
function CkHttp_LastJsonData(objHandle: HCkHttp): HCkJsonObject;
function CkHttp_LoadTaskCaller(objHandle: HCkHttp; task: HCkTask): wordbool;
function CkHttp_OcspCheck(objHandle: HCkHttp; domain: PWideChar; port: Integer): Integer;
function CkHttp_OcspCheckAsync(objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkTask;
function CkHttp_ParseOcspReply(objHandle: HCkHttp; ocspReply: HCkBinData; replyData: HCkJsonObject): Integer;
function CkHttp_PBinary(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
function CkHttp_PBinaryAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PBinaryBd(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; data: HCkBinData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
function CkHttp_PBinaryBdAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; data: HCkBinData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PFile(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
function CkHttp_PFileAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PostBinary(objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool;
function CkHttp__postBinary(objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar;
function CkHttp_PostBinaryAsync(objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PostJson(objHandle: HCkHttp; url: PWideChar; jsonText: PWideChar): HCkHttpResponse;
function CkHttp_PostJsonAsync(objHandle: HCkHttp; url: PWideChar; jsonText: PWideChar): HCkTask;
function CkHttp_PostJson2(objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; jsonText: PWideChar): HCkHttpResponse;
function CkHttp_PostJson2Async(objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; jsonText: PWideChar): HCkTask;
function CkHttp_PostJson3(objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; json: HCkJsonObject): HCkHttpResponse;
function CkHttp_PostJson3Async(objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; json: HCkJsonObject): HCkTask;
function CkHttp_PostUrlEncoded(objHandle: HCkHttp; url: PWideChar; req: HCkHttpRequest): HCkHttpResponse;
function CkHttp_PostUrlEncodedAsync(objHandle: HCkHttp; url: PWideChar; req: HCkHttpRequest): HCkTask;
function CkHttp_PostXml(objHandle: HCkHttp; endpointUrl: PWideChar; xmlContent: PWideChar; xmlCharset: PWideChar): HCkHttpResponse;
function CkHttp_PostXmlAsync(objHandle: HCkHttp; endpointUrl: PWideChar; xmlContent: PWideChar; xmlCharset: PWideChar): HCkTask;
function CkHttp_PText(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
function CkHttp_PTextAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PTextSb(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
function CkHttp_PTextSbAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PutBinary(objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool;
function CkHttp__putBinary(objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar;
function CkHttp_PutBinaryAsync(objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_PutText(objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool;
function CkHttp__putText(objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar;
function CkHttp_PutTextAsync(objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
function CkHttp_QuickDeleteStr(objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
function CkHttp__quickDeleteStr(objHandle: HCkHttp; url: PWideChar): PWideChar;
function CkHttp_QuickDeleteStrAsync(objHandle: HCkHttp; url: PWideChar): HCkTask;
function CkHttp_QuickGet(objHandle: HCkHttp; url: PWideChar; outData: HCkByteData): wordbool;
function CkHttp_QuickGetAsync(objHandle: HCkHttp; url: PWideChar): HCkTask;
function CkHttp_QuickGetBd(objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool;
function CkHttp_QuickGetBdAsync(objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask;
function CkHttp_QuickGetObj(objHandle: HCkHttp; url: PWideChar): HCkHttpResponse;
function CkHttp_QuickGetObjAsync(objHandle: HCkHttp; url: PWideChar): HCkTask;
function CkHttp_QuickGetSb(objHandle: HCkHttp; url: PWideChar; sbContent: HCkStringBuilder): wordbool;
function CkHttp_QuickGetSbAsync(objHandle: HCkHttp; url: PWideChar; sbContent: HCkStringBuilder): HCkTask;
function CkHttp_QuickGetStr(objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
function CkHttp__quickGetStr(objHandle: HCkHttp; url: PWideChar): PWideChar;
function CkHttp_QuickGetStrAsync(objHandle: HCkHttp; url: PWideChar): HCkTask;
function CkHttp_QuickPutStr(objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
function CkHttp__quickPutStr(objHandle: HCkHttp; url: PWideChar): PWideChar;
function CkHttp_QuickPutStrAsync(objHandle: HCkHttp; url: PWideChar): HCkTask;
function CkHttp_QuickRequest(objHandle: HCkHttp; verb: PWideChar; url: PWideChar): HCkHttpResponse;
function CkHttp_QuickRequestAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar): HCkTask;
function CkHttp_QuickRequestParams(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject): HCkHttpResponse;
function CkHttp_QuickRequestParamsAsync(objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject): HCkTask;
procedure CkHttp_RemoveRequestHeader(objHandle: HCkHttp; name: PWideChar);
function CkHttp_RenderGet(objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
function CkHttp__renderGet(objHandle: HCkHttp; url: PWideChar): PWideChar;
function CkHttp_ResumeDownload(objHandle: HCkHttp; url: PWideChar; targetFilename: PWideChar): wordbool;
function CkHttp_ResumeDownloadAsync(objHandle: HCkHttp; url: PWideChar; targetFilename: PWideChar): HCkTask;
function CkHttp_ResumeDownloadBd(objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool;
function CkHttp_ResumeDownloadBdAsync(objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask;
function CkHttp_S3_CreateBucket(objHandle: HCkHttp; bucketPath: PWideChar): wordbool;
function CkHttp_S3_CreateBucketAsync(objHandle: HCkHttp; bucketPath: PWideChar): HCkTask;
function CkHttp_S3_DeleteBucket(objHandle: HCkHttp; bucketPath: PWideChar): wordbool;
function CkHttp_S3_DeleteBucketAsync(objHandle: HCkHttp; bucketPath: PWideChar): HCkTask;
function CkHttp_S3_DeleteMultipleObjects(objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringArray): HCkHttpResponse;
function CkHttp_S3_DeleteMultipleObjectsAsync(objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringArray): HCkTask;
function CkHttp_S3_DeleteObject(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): wordbool;
function CkHttp_S3_DeleteObjectAsync(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_S3_DeleteObjects(objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringTable; jsonResponse: HCkJsonObject): wordbool;
function CkHttp_S3_DeleteObjectsAsync(objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringTable; jsonResponse: HCkJsonObject): HCkTask;
function CkHttp_S3_DownloadBd(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; bd: HCkBinData): wordbool;
function CkHttp_S3_DownloadBdAsync(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; bd: HCkBinData): HCkTask;
function CkHttp_S3_DownloadBytes(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; outData: HCkByteData): wordbool;
function CkHttp_S3_DownloadBytesAsync(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_S3_DownloadFile(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; localFilePath: PWideChar): wordbool;
function CkHttp_S3_DownloadFileAsync(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; localFilePath: PWideChar): HCkTask;
function CkHttp_S3_DownloadString(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkHttp__s3_DownloadString(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar): PWideChar;
function CkHttp_S3_DownloadStringAsync(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar): HCkTask;
function CkHttp_S3_FileExists(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): Integer;
function CkHttp_S3_FileExistsAsync(objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_S3_GenerateUrl(objHandle: HCkHttp; bucket: PWideChar; path: PWideChar; expire: HCkDateTime; outStr: HCkString): wordbool;
function CkHttp__s3_GenerateUrl(objHandle: HCkHttp; bucket: PWideChar; path: PWideChar; expire: HCkDateTime): PWideChar;
function CkHttp_S3_GenerateUrlV4(objHandle: HCkHttp; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar; outStr: HCkString): wordbool;
function CkHttp__s3_GenerateUrlV4(objHandle: HCkHttp; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar): PWideChar;
function CkHttp_S3_GenPresignedUrl(objHandle: HCkHttp; httpVerb: PWideChar; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar; outStr: HCkString): wordbool;
function CkHttp__s3_GenPresignedUrl(objHandle: HCkHttp; httpVerb: PWideChar; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar): PWideChar;
function CkHttp_S3_ListBucketObjects(objHandle: HCkHttp; bucketPath: PWideChar; outStr: HCkString): wordbool;
function CkHttp__s3_ListBucketObjects(objHandle: HCkHttp; bucketPath: PWideChar): PWideChar;
function CkHttp_S3_ListBucketObjectsAsync(objHandle: HCkHttp; bucketPath: PWideChar): HCkTask;
function CkHttp_S3_ListBuckets(objHandle: HCkHttp; outStr: HCkString): wordbool;
function CkHttp__s3_ListBuckets(objHandle: HCkHttp): PWideChar;
function CkHttp_S3_ListBucketsAsync(objHandle: HCkHttp): HCkTask;
function CkHttp_S3_UploadBd(objHandle: HCkHttp; bd: HCkBinData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
function CkHttp_S3_UploadBdAsync(objHandle: HCkHttp; bd: HCkBinData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_S3_UploadBytes(objHandle: HCkHttp; contentBytes: HCkByteData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
function CkHttp_S3_UploadBytesAsync(objHandle: HCkHttp; contentBytes: HCkByteData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_S3_UploadFile(objHandle: HCkHttp; localFilePath: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
function CkHttp_S3_UploadFileAsync(objHandle: HCkHttp; localFilePath: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_S3_UploadString(objHandle: HCkHttp; objectContent: PWideChar; charset: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
function CkHttp_S3_UploadStringAsync(objHandle: HCkHttp; objectContent: PWideChar; charset: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
function CkHttp_SetAuthPrivateKey(objHandle: HCkHttp; publicKeyId: PWideChar; privKey: HCkPrivateKey): wordbool;
function CkHttp_SetAuthTokenSb(objHandle: HCkHttp; sb: HCkStringBuilder): wordbool;
function CkHttp_SetCookieXml(objHandle: HCkHttp; domain: PWideChar; cookieXml: PWideChar): wordbool;
function CkHttp_SetOAuthRsaKey(objHandle: HCkHttp; privKey: HCkPrivateKey): wordbool;
procedure CkHttp_SetRequestHeader(objHandle: HCkHttp; headerFieldName: PWideChar; headerFieldValue: PWideChar);
function CkHttp_SetSecurePassword(objHandle: HCkHttp; password: HCkSecureString): wordbool;
procedure CkHttp_SetSslCertRequirement(objHandle: HCkHttp; reqName: PWideChar; reqValue: PWideChar);
function CkHttp_SetSslClientCert(objHandle: HCkHttp; cert: HCkCert): wordbool;
function CkHttp_SetSslClientCertPem(objHandle: HCkHttp; pemDataOrPath: PWideChar; pemPassword: PWideChar): wordbool;
function CkHttp_SetSslClientCertPfx(objHandle: HCkHttp; pfxPath: PWideChar; pfxPassword: PWideChar): wordbool;
function CkHttp_SetUrlVar(objHandle: HCkHttp; name: PWideChar; value: PWideChar): wordbool;
function CkHttp_SharePointOnlineAuth(objHandle: HCkHttp; siteUrl: PWideChar; username: PWideChar; password: HCkSecureString; extraInfo: HCkJsonObject): wordbool;
function CkHttp_SharePointOnlineAuthAsync(objHandle: HCkHttp; siteUrl: PWideChar; username: PWideChar; password: HCkSecureString; extraInfo: HCkJsonObject): HCkTask;
procedure CkHttp_SleepMs(objHandle: HCkHttp; millisec: Integer);
function CkHttp_SynchronousRequest(objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; req: HCkHttpRequest): HCkHttpResponse;
function CkHttp_SynchronousRequestAsync(objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; req: HCkHttpRequest): HCkTask;
function CkHttp_UrlDecode(objHandle: HCkHttp; str: PWideChar; outStr: HCkString): wordbool;
function CkHttp__urlDecode(objHandle: HCkHttp; str: PWideChar): PWideChar;
function CkHttp_UrlEncode(objHandle: HCkHttp; str: PWideChar; outStr: HCkString): wordbool;
function CkHttp__urlEncode(objHandle: HCkHttp; str: PWideChar): PWideChar;
function CkHttp_VerifyTimestampReply(objHandle: HCkHttp; timestampReply: HCkBinData; tsaCert: HCkCert): Integer;
function CkHttp_XmlRpc(objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar; outStr: HCkString): wordbool;
function CkHttp__xmlRpc(objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): PWideChar;
function CkHttp_XmlRpcAsync(objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): HCkTask;
function CkHttp_XmlRpcPut(objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar; outStr: HCkString): wordbool;
function CkHttp__xmlRpcPut(objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): PWideChar;
function CkHttp_XmlRpcPutAsync(objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkHttp_Create = function : HCkHttp; stdcall;
  TCkHttp_Dispose = procedure (handle: HCkHttp); stdcall;
  TCkHttp_SetAbortCheck = procedure (objHandle: HCkHttp; fn: THttpAbortCheck); stdcall;
  TCkHttp_SetProgressInfo = procedure (objHandle: HCkHttp; fn: THttpProgressInfo); stdcall;
  TCkHttp_SetPercentDone = procedure (objHandle: HCkHttp; fn: THttpPercentDone); stdcall;
  TCkHttp_SetTaskCompleted = procedure (objHandle: HCkHttp; fn: THttpTaskCompleted); stdcall;
  TCkHttp_getAbortCurrent = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putAbortCurrent = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getAccept = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAccept = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__accept = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAcceptCharset = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAcceptCharset = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__acceptCharset = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAcceptLanguage = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAcceptLanguage = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__acceptLanguage = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAllowGzip = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putAllowGzip = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getAllowHeaderFolding = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putAllowHeaderFolding = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getAuthSignature = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAuthSignature = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__authSignature = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAuthToken = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAuthToken = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__authToken = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAutoAddHostHeader = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putAutoAddHostHeader = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getAwsAccessKey = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAwsAccessKey = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__awsAccessKey = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAwsEndpoint = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAwsEndpoint = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__awsEndpoint = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAwsRegion = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAwsRegion = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__awsRegion = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAwsSecretKey = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAwsSecretKey = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__awsSecretKey = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAwsSessionToken = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAwsSessionToken = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__awsSessionToken = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getAwsSignatureVersion = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putAwsSignatureVersion = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getAwsSubResources = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putAwsSubResources = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__awsSubResources = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getBandwidthThrottleDown = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putBandwidthThrottleDown = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getBandwidthThrottleUp = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putBandwidthThrottleUp = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getBasicAuth = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putBasicAuth = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getClientIpAddress = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putClientIpAddress = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__clientIpAddress = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getConnectFailReason = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_getConnection = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putConnection = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__connection = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getConnectTimeout = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putConnectTimeout = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getCookieDir = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putCookieDir = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__cookieDir = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getDebugLogFilePath = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putDebugLogFilePath = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__debugLogFilePath = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getDefaultFreshPeriod = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putDefaultFreshPeriod = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getDigestAuth = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putDigestAuth = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getFetchFromCache = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putFetchFromCache = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getFinalRedirectUrl = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__finalRedirectUrl = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getFollowRedirects = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putFollowRedirects = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getFreshnessAlgorithm = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putFreshnessAlgorithm = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getHeartbeatMs = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putHeartbeatMs = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getIgnoreMustRevalidate = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putIgnoreMustRevalidate = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getIgnoreNoCache = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putIgnoreNoCache = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getKeepResponseBody = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putKeepResponseBody = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getLastContentType = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastContentType = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastErrorHtml = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastErrorHtml = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastErrorText = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastErrorText = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastErrorXml = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastErrorXml = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastFromCache = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_getLastHeader = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastHeader = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastMethodSuccess = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putLastMethodSuccess = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getLastModDate = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastModDate = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastResponseBody = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastResponseBody = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastResponseHeader = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastResponseHeader = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLastStatus = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_getLastStatusText = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__lastStatusText = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLMFactor = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putLMFactor = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getLogin = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putLogin = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__login = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getLoginDomain = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putLoginDomain = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__loginDomain = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getMaxConnections = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putMaxConnections = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getMaxFreshPeriod = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putMaxFreshPeriod = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getMaxResponseSize = function (objHandle: HCkHttp): LongWord; stdcall;
  TCkHttp_putMaxResponseSize = procedure (objHandle: HCkHttp; newPropVal: LongWord); stdcall;
  TCkHttp_getMaxUrlLen = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putMaxUrlLen = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getMimicFireFox = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putMimicFireFox = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getMimicIE = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putMimicIE = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getMinFreshPeriod = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putMinFreshPeriod = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getNegotiateAuth = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putNegotiateAuth = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getNtlmAuth = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putNtlmAuth = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getNumCacheLevels = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putNumCacheLevels = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getNumCacheRoots = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_getOAuth1 = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putOAuth1 = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getOAuthBodyHash = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putOAuthBodyHash = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getOAuthCallback = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthCallback = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthCallback = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthConsumerKey = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthConsumerKey = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthConsumerKey = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthConsumerSecret = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthConsumerSecret = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthConsumerSecret = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthRealm = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthRealm = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthRealm = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthSigMethod = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthSigMethod = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthSigMethod = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthToken = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthToken = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthToken = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthTokenSecret = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthTokenSecret = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthTokenSecret = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getOAuthVerifier = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putOAuthVerifier = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__oAuthVerifier = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getPassword = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putPassword = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__password = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getPercentDoneScale = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putPercentDoneScale = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getPreferIpv6 = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putPreferIpv6 = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getProxyAuthMethod = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putProxyAuthMethod = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__proxyAuthMethod = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getProxyDirectTls = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putProxyDirectTls = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getProxyDomain = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putProxyDomain = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__proxyDomain = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getProxyLogin = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putProxyLogin = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__proxyLogin = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getProxyLoginDomain = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putProxyLoginDomain = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__proxyLoginDomain = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getProxyPassword = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putProxyPassword = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__proxyPassword = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getProxyPort = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putProxyPort = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getReadTimeout = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putReadTimeout = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getReceivedCertReq = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_getRedirectVerb = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putRedirectVerb = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__redirectVerb = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getReferer = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putReferer = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__referer = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getRequiredContentType = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putRequiredContentType = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__requiredContentType = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getRequireHostnameMatch = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putRequireHostnameMatch = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getRequireSslCertVerify = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putRequireSslCertVerify = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getSaveCookies = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putSaveCookies = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getSendBufferSize = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putSendBufferSize = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getSendCookies = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putSendCookies = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getSessionLogFilename = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSessionLogFilename = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__sessionLogFilename = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getSniHostname = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSniHostname = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__sniHostname = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getSocksHostname = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSocksHostname = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__socksHostname = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getSocksPassword = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSocksPassword = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__socksPassword = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getSocksPort = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putSocksPort = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getSocksUsername = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSocksUsername = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__socksUsername = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getSocksVersion = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putSocksVersion = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getSoRcvBuf = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putSoRcvBuf = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getSoSndBuf = function (objHandle: HCkHttp): Integer; stdcall;
  TCkHttp_putSoSndBuf = procedure (objHandle: HCkHttp; newPropVal: Integer); stdcall;
  TCkHttp_getSslAllowedCiphers = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSslAllowedCiphers = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__sslAllowedCiphers = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getSslProtocol = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putSslProtocol = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__sslProtocol = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getStreamResponseBodyPath = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putStreamResponseBodyPath = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__streamResponseBodyPath = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getTlsCipherSuite = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__tlsCipherSuite = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getTlsPinSet = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putTlsPinSet = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__tlsPinSet = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getTlsVersion = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__tlsVersion = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getUncommonOptions = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putUncommonOptions = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__uncommonOptions = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getUpdateCache = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putUpdateCache = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getUseIEProxy = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putUseIEProxy = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getUserAgent = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp_putUserAgent = procedure (objHandle: HCkHttp; newPropVal: PWideChar); stdcall;
  TCkHttp__userAgent = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getVerboseLogging = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_putVerboseLogging = procedure (objHandle: HCkHttp; newPropVal: wordbool); stdcall;
  TCkHttp_getVersion = procedure (objHandle: HCkHttp; outPropVal: HCkString); stdcall;
  TCkHttp__version = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_getWasRedirected = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_AddCacheRoot = procedure (objHandle: HCkHttp; dir: PWideChar); stdcall;
  TCkHttp_ClearHeaders = procedure (objHandle: HCkHttp); stdcall;
  TCkHttp_ClearInMemoryCookies = procedure (objHandle: HCkHttp); stdcall;
  TCkHttp_ClearUrlVars = procedure (objHandle: HCkHttp); stdcall;
  TCkHttp_CloseAllConnections = function (objHandle: HCkHttp): wordbool; stdcall;
  TCkHttp_CloseAllConnectionsAsync = function (objHandle: HCkHttp): HCkTask; stdcall;
  TCkHttp_CreateOcspRequest = function (objHandle: HCkHttp; requestDetails: HCkJsonObject; ocspRequest: HCkBinData): wordbool; stdcall;
  TCkHttp_CreateTimestampRequest = function (objHandle: HCkHttp; hashAlg: PWideChar; hashVal: PWideChar; reqPolicyOid: PWideChar; addNonce: wordbool; reqTsaCert: wordbool; timestampToken: HCkBinData): wordbool; stdcall;
  TCkHttp_DnsCacheClear = procedure (objHandle: HCkHttp); stdcall;
  TCkHttp_Download = function (objHandle: HCkHttp; url: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkHttp_DownloadAsync = function (objHandle: HCkHttp; url: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkHttp_DownloadAppend = function (objHandle: HCkHttp; url: PWideChar; appendToPath: PWideChar): wordbool; stdcall;
  TCkHttp_DownloadAppendAsync = function (objHandle: HCkHttp; url: PWideChar; appendToPath: PWideChar): HCkTask; stdcall;
  TCkHttp_DownloadBd = function (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool; stdcall;
  TCkHttp_DownloadBdAsync = function (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask; stdcall;
  TCkHttp_DownloadHash = function (objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__downloadHash = function (objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkHttp_DownloadHashAsync = function (objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar): HCkTask; stdcall;
  TCkHttp_DownloadSb = function (objHandle: HCkHttp; url: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkHttp_DownloadSbAsync = function (objHandle: HCkHttp; url: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkHttp_ExtractMetaRefreshUrl = function (objHandle: HCkHttp; htmlContent: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__extractMetaRefreshUrl = function (objHandle: HCkHttp; htmlContent: PWideChar): PWideChar; stdcall;
  TCkHttp_G_SvcOauthAccessToken = function (objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkHttp__g_SvcOauthAccessToken = function (objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert): PWideChar; stdcall;
  TCkHttp_G_SvcOauthAccessTokenAsync = function (objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert): HCkTask; stdcall;
  TCkHttp_G_SvcOauthAccessToken2 = function (objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkHttp__g_SvcOauthAccessToken2 = function (objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert): PWideChar; stdcall;
  TCkHttp_G_SvcOauthAccessToken2Async = function (objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert): HCkTask; stdcall;
  TCkHttp_GenTimeStamp = function (objHandle: HCkHttp; outStr: HCkString): wordbool; stdcall;
  TCkHttp__genTimeStamp = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_GetCacheRoot = function (objHandle: HCkHttp; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttp__getCacheRoot = function (objHandle: HCkHttp; index: Integer): PWideChar; stdcall;
  TCkHttp_GetCookieXml = function (objHandle: HCkHttp; domain: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__getCookieXml = function (objHandle: HCkHttp; domain: PWideChar): PWideChar; stdcall;
  TCkHttp_GetDomain = function (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__getDomain = function (objHandle: HCkHttp; url: PWideChar): PWideChar; stdcall;
  TCkHttp_GetHead = function (objHandle: HCkHttp; url: PWideChar): HCkHttpResponse; stdcall;
  TCkHttp_GetHeadAsync = function (objHandle: HCkHttp; url: PWideChar): HCkTask; stdcall;
  TCkHttp_GetLastJsonData = procedure (objHandle: HCkHttp; json: HCkJsonObject); stdcall;
  TCkHttp_GetRequestHeader = function (objHandle: HCkHttp; name: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__getRequestHeader = function (objHandle: HCkHttp; name: PWideChar): PWideChar; stdcall;
  TCkHttp_GetServerCert = function (objHandle: HCkHttp; domain: PWideChar; port: Integer; cert: HCkCert): wordbool; stdcall;
  TCkHttp_GetServerCertAsync = function (objHandle: HCkHttp; domain: PWideChar; port: Integer; cert: HCkCert): HCkTask; stdcall;
  TCkHttp_GetServerSslCert = function (objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkCert; stdcall;
  TCkHttp_GetServerSslCertAsync = function (objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkTask; stdcall;
  TCkHttp_GetUrlPath = function (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__getUrlPath = function (objHandle: HCkHttp; url: PWideChar): PWideChar; stdcall;
  TCkHttp_HasRequestHeader = function (objHandle: HCkHttp; name: PWideChar): wordbool; stdcall;
  TCkHttp_HttpBd = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bd: HCkBinData; contentType: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpBdAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bd: HCkBinData; contentType: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpBinary = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpBinaryAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpFile = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpFileAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpJson = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; contentType: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpJsonAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; contentType: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpNoBody = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpNoBodyAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpParams = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpParamsAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpReq = function (objHandle: HCkHttp; url: PWideChar; request: HCkHttpRequest; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpReqAsync = function (objHandle: HCkHttp; url: PWideChar; request: HCkHttpRequest; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpSb = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; sb: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpSbAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; sb: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpSReq = function (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; request: HCkHttpRequest; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpSReqAsync = function (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; request: HCkHttpRequest; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_HttpStr = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bodyStr: PWideChar; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool; stdcall;
  TCkHttp_HttpStrAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bodyStr: PWideChar; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask; stdcall;
  TCkHttp_LastJsonData = function (objHandle: HCkHttp): HCkJsonObject; stdcall;
  TCkHttp_LoadTaskCaller = function (objHandle: HCkHttp; task: HCkTask): wordbool; stdcall;
  TCkHttp_OcspCheck = function (objHandle: HCkHttp; domain: PWideChar; port: Integer): Integer; stdcall;
  TCkHttp_OcspCheckAsync = function (objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkTask; stdcall;
  TCkHttp_ParseOcspReply = function (objHandle: HCkHttp; ocspReply: HCkBinData; replyData: HCkJsonObject): Integer; stdcall;
  TCkHttp_PBinary = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse; stdcall;
  TCkHttp_PBinaryAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PBinaryBd = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; data: HCkBinData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse; stdcall;
  TCkHttp_PBinaryBdAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; data: HCkBinData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PFile = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse; stdcall;
  TCkHttp_PFileAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PostBinary = function (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkHttp__postBinary = function (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar; stdcall;
  TCkHttp_PostBinaryAsync = function (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PostJson = function (objHandle: HCkHttp; url: PWideChar; jsonText: PWideChar): HCkHttpResponse; stdcall;
  TCkHttp_PostJsonAsync = function (objHandle: HCkHttp; url: PWideChar; jsonText: PWideChar): HCkTask; stdcall;
  TCkHttp_PostJson2 = function (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; jsonText: PWideChar): HCkHttpResponse; stdcall;
  TCkHttp_PostJson2Async = function (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; jsonText: PWideChar): HCkTask; stdcall;
  TCkHttp_PostJson3 = function (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; json: HCkJsonObject): HCkHttpResponse; stdcall;
  TCkHttp_PostJson3Async = function (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; json: HCkJsonObject): HCkTask; stdcall;
  TCkHttp_PostUrlEncoded = function (objHandle: HCkHttp; url: PWideChar; req: HCkHttpRequest): HCkHttpResponse; stdcall;
  TCkHttp_PostUrlEncodedAsync = function (objHandle: HCkHttp; url: PWideChar; req: HCkHttpRequest): HCkTask; stdcall;
  TCkHttp_PostXml = function (objHandle: HCkHttp; endpointUrl: PWideChar; xmlContent: PWideChar; xmlCharset: PWideChar): HCkHttpResponse; stdcall;
  TCkHttp_PostXmlAsync = function (objHandle: HCkHttp; endpointUrl: PWideChar; xmlContent: PWideChar; xmlCharset: PWideChar): HCkTask; stdcall;
  TCkHttp_PText = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse; stdcall;
  TCkHttp_PTextAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PTextSb = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse; stdcall;
  TCkHttp_PTextSbAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PutBinary = function (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkHttp__putBinary = function (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar; stdcall;
  TCkHttp_PutBinaryAsync = function (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_PutText = function (objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkHttp__putText = function (objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar; stdcall;
  TCkHttp_PutTextAsync = function (objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask; stdcall;
  TCkHttp_QuickDeleteStr = function (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__quickDeleteStr = function (objHandle: HCkHttp; url: PWideChar): PWideChar; stdcall;
  TCkHttp_QuickDeleteStrAsync = function (objHandle: HCkHttp; url: PWideChar): HCkTask; stdcall;
  TCkHttp_QuickGet = function (objHandle: HCkHttp; url: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkHttp_QuickGetAsync = function (objHandle: HCkHttp; url: PWideChar): HCkTask; stdcall;
  TCkHttp_QuickGetBd = function (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool; stdcall;
  TCkHttp_QuickGetBdAsync = function (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask; stdcall;
  TCkHttp_QuickGetObj = function (objHandle: HCkHttp; url: PWideChar): HCkHttpResponse; stdcall;
  TCkHttp_QuickGetObjAsync = function (objHandle: HCkHttp; url: PWideChar): HCkTask; stdcall;
  TCkHttp_QuickGetSb = function (objHandle: HCkHttp; url: PWideChar; sbContent: HCkStringBuilder): wordbool; stdcall;
  TCkHttp_QuickGetSbAsync = function (objHandle: HCkHttp; url: PWideChar; sbContent: HCkStringBuilder): HCkTask; stdcall;
  TCkHttp_QuickGetStr = function (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__quickGetStr = function (objHandle: HCkHttp; url: PWideChar): PWideChar; stdcall;
  TCkHttp_QuickGetStrAsync = function (objHandle: HCkHttp; url: PWideChar): HCkTask; stdcall;
  TCkHttp_QuickPutStr = function (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__quickPutStr = function (objHandle: HCkHttp; url: PWideChar): PWideChar; stdcall;
  TCkHttp_QuickPutStrAsync = function (objHandle: HCkHttp; url: PWideChar): HCkTask; stdcall;
  TCkHttp_QuickRequest = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar): HCkHttpResponse; stdcall;
  TCkHttp_QuickRequestAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar): HCkTask; stdcall;
  TCkHttp_QuickRequestParams = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject): HCkHttpResponse; stdcall;
  TCkHttp_QuickRequestParamsAsync = function (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject): HCkTask; stdcall;
  TCkHttp_RemoveRequestHeader = procedure (objHandle: HCkHttp; name: PWideChar); stdcall;
  TCkHttp_RenderGet = function (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__renderGet = function (objHandle: HCkHttp; url: PWideChar): PWideChar; stdcall;
  TCkHttp_ResumeDownload = function (objHandle: HCkHttp; url: PWideChar; targetFilename: PWideChar): wordbool; stdcall;
  TCkHttp_ResumeDownloadAsync = function (objHandle: HCkHttp; url: PWideChar; targetFilename: PWideChar): HCkTask; stdcall;
  TCkHttp_ResumeDownloadBd = function (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool; stdcall;
  TCkHttp_ResumeDownloadBdAsync = function (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask; stdcall;
  TCkHttp_S3_CreateBucket = function (objHandle: HCkHttp; bucketPath: PWideChar): wordbool; stdcall;
  TCkHttp_S3_CreateBucketAsync = function (objHandle: HCkHttp; bucketPath: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_DeleteBucket = function (objHandle: HCkHttp; bucketPath: PWideChar): wordbool; stdcall;
  TCkHttp_S3_DeleteBucketAsync = function (objHandle: HCkHttp; bucketPath: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_DeleteMultipleObjects = function (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringArray): HCkHttpResponse; stdcall;
  TCkHttp_S3_DeleteMultipleObjectsAsync = function (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringArray): HCkTask; stdcall;
  TCkHttp_S3_DeleteObject = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): wordbool; stdcall;
  TCkHttp_S3_DeleteObjectAsync = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_DeleteObjects = function (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringTable; jsonResponse: HCkJsonObject): wordbool; stdcall;
  TCkHttp_S3_DeleteObjectsAsync = function (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringTable; jsonResponse: HCkJsonObject): HCkTask; stdcall;
  TCkHttp_S3_DownloadBd = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkHttp_S3_DownloadBdAsync = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkHttp_S3_DownloadBytes = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkHttp_S3_DownloadBytesAsync = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_DownloadFile = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkHttp_S3_DownloadFileAsync = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_DownloadString = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__s3_DownloadString = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkHttp_S3_DownloadStringAsync = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_FileExists = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): Integer; stdcall;
  TCkHttp_S3_FileExistsAsync = function (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_GenerateUrl = function (objHandle: HCkHttp; bucket: PWideChar; path: PWideChar; expire: HCkDateTime; outStr: HCkString): wordbool; stdcall;
  TCkHttp__s3_GenerateUrl = function (objHandle: HCkHttp; bucket: PWideChar; path: PWideChar; expire: HCkDateTime): PWideChar; stdcall;
  TCkHttp_S3_GenerateUrlV4 = function (objHandle: HCkHttp; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__s3_GenerateUrlV4 = function (objHandle: HCkHttp; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar): PWideChar; stdcall;
  TCkHttp_S3_GenPresignedUrl = function (objHandle: HCkHttp; httpVerb: PWideChar; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__s3_GenPresignedUrl = function (objHandle: HCkHttp; httpVerb: PWideChar; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar): PWideChar; stdcall;
  TCkHttp_S3_ListBucketObjects = function (objHandle: HCkHttp; bucketPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__s3_ListBucketObjects = function (objHandle: HCkHttp; bucketPath: PWideChar): PWideChar; stdcall;
  TCkHttp_S3_ListBucketObjectsAsync = function (objHandle: HCkHttp; bucketPath: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_ListBuckets = function (objHandle: HCkHttp; outStr: HCkString): wordbool; stdcall;
  TCkHttp__s3_ListBuckets = function (objHandle: HCkHttp): PWideChar; stdcall;
  TCkHttp_S3_ListBucketsAsync = function (objHandle: HCkHttp): HCkTask; stdcall;
  TCkHttp_S3_UploadBd = function (objHandle: HCkHttp; bd: HCkBinData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool; stdcall;
  TCkHttp_S3_UploadBdAsync = function (objHandle: HCkHttp; bd: HCkBinData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_UploadBytes = function (objHandle: HCkHttp; contentBytes: HCkByteData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool; stdcall;
  TCkHttp_S3_UploadBytesAsync = function (objHandle: HCkHttp; contentBytes: HCkByteData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_UploadFile = function (objHandle: HCkHttp; localFilePath: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool; stdcall;
  TCkHttp_S3_UploadFileAsync = function (objHandle: HCkHttp; localFilePath: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_S3_UploadString = function (objHandle: HCkHttp; objectContent: PWideChar; charset: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool; stdcall;
  TCkHttp_S3_UploadStringAsync = function (objHandle: HCkHttp; objectContent: PWideChar; charset: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask; stdcall;
  TCkHttp_SetAuthPrivateKey = function (objHandle: HCkHttp; publicKeyId: PWideChar; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkHttp_SetAuthTokenSb = function (objHandle: HCkHttp; sb: HCkStringBuilder): wordbool; stdcall;
  TCkHttp_SetCookieXml = function (objHandle: HCkHttp; domain: PWideChar; cookieXml: PWideChar): wordbool; stdcall;
  TCkHttp_SetOAuthRsaKey = function (objHandle: HCkHttp; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkHttp_SetRequestHeader = procedure (objHandle: HCkHttp; headerFieldName: PWideChar; headerFieldValue: PWideChar); stdcall;
  TCkHttp_SetSecurePassword = function (objHandle: HCkHttp; password: HCkSecureString): wordbool; stdcall;
  TCkHttp_SetSslCertRequirement = procedure (objHandle: HCkHttp; reqName: PWideChar; reqValue: PWideChar); stdcall;
  TCkHttp_SetSslClientCert = function (objHandle: HCkHttp; cert: HCkCert): wordbool; stdcall;
  TCkHttp_SetSslClientCertPem = function (objHandle: HCkHttp; pemDataOrPath: PWideChar; pemPassword: PWideChar): wordbool; stdcall;
  TCkHttp_SetSslClientCertPfx = function (objHandle: HCkHttp; pfxPath: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkHttp_SetUrlVar = function (objHandle: HCkHttp; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkHttp_SharePointOnlineAuth = function (objHandle: HCkHttp; siteUrl: PWideChar; username: PWideChar; password: HCkSecureString; extraInfo: HCkJsonObject): wordbool; stdcall;
  TCkHttp_SharePointOnlineAuthAsync = function (objHandle: HCkHttp; siteUrl: PWideChar; username: PWideChar; password: HCkSecureString; extraInfo: HCkJsonObject): HCkTask; stdcall;
  TCkHttp_SleepMs = procedure (objHandle: HCkHttp; millisec: Integer); stdcall;
  TCkHttp_SynchronousRequest = function (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; req: HCkHttpRequest): HCkHttpResponse; stdcall;
  TCkHttp_SynchronousRequestAsync = function (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; req: HCkHttpRequest): HCkTask; stdcall;
  TCkHttp_UrlDecode = function (objHandle: HCkHttp; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__urlDecode = function (objHandle: HCkHttp; str: PWideChar): PWideChar; stdcall;
  TCkHttp_UrlEncode = function (objHandle: HCkHttp; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__urlEncode = function (objHandle: HCkHttp; str: PWideChar): PWideChar; stdcall;
  TCkHttp_VerifyTimestampReply = function (objHandle: HCkHttp; timestampReply: HCkBinData; tsaCert: HCkCert): Integer; stdcall;
  TCkHttp_XmlRpc = function (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__xmlRpc = function (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): PWideChar; stdcall;
  TCkHttp_XmlRpcAsync = function (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): HCkTask; stdcall;
  TCkHttp_XmlRpcPut = function (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttp__xmlRpcPut = function (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): PWideChar; stdcall;
  TCkHttp_XmlRpcPutAsync = function (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..468] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkHttp_Create : HCkHttp;
begin
  result := TCkHttp_Create(_map(0, 'CkHttp_Create'));
end;

procedure CkHttp_Dispose (handle: HCkHttp);
begin
  TCkHttp_Dispose(_map(1, 'CkHttp_Dispose'))
    (handle);
end;


procedure CkHttp_SetAbortCheck (objHandle: HCkHttp; fn: THttpAbortCheck);
begin
    TCkHttp_SetAbortCheck(_map(2, 'CkHttp_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkHttp_SetProgressInfo (objHandle: HCkHttp; fn: THttpProgressInfo);
begin
    TCkHttp_SetProgressInfo(_map(3, 'CkHttp_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkHttp_SetPercentDone (objHandle: HCkHttp; fn: THttpPercentDone);
begin
    TCkHttp_SetPercentDone(_map(4, 'CkHttp_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkHttp_SetTaskCompleted (objHandle: HCkHttp; fn: THttpTaskCompleted);
begin
    TCkHttp_SetTaskCompleted(_map(5, 'CkHttp_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkHttp_getAbortCurrent (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getAbortCurrent(_map(6, 'CkHttp_getAbortCurrent'))
    (objHandle);
end;

procedure CkHttp_putAbortCurrent (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putAbortCurrent(_map(7, 'CkHttp_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getAccept (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAccept(_map(8, 'CkHttp_getAccept'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAccept (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAccept(_map(9, 'CkHttp_putAccept'))
    (objHandle, newPropVal);
end;

function CkHttp__accept (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__accept(_map(10, 'CkHttp__accept'))
    (objHandle);
end;

procedure CkHttp_getAcceptCharset (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAcceptCharset(_map(11, 'CkHttp_getAcceptCharset'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAcceptCharset (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAcceptCharset(_map(12, 'CkHttp_putAcceptCharset'))
    (objHandle, newPropVal);
end;

function CkHttp__acceptCharset (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__acceptCharset(_map(13, 'CkHttp__acceptCharset'))
    (objHandle);
end;

procedure CkHttp_getAcceptLanguage (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAcceptLanguage(_map(14, 'CkHttp_getAcceptLanguage'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAcceptLanguage (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAcceptLanguage(_map(15, 'CkHttp_putAcceptLanguage'))
    (objHandle, newPropVal);
end;

function CkHttp__acceptLanguage (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__acceptLanguage(_map(16, 'CkHttp__acceptLanguage'))
    (objHandle);
end;

function CkHttp_getAllowGzip (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getAllowGzip(_map(17, 'CkHttp_getAllowGzip'))
    (objHandle);
end;

procedure CkHttp_putAllowGzip (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putAllowGzip(_map(18, 'CkHttp_putAllowGzip'))
    (objHandle, newPropVal);
end;

function CkHttp_getAllowHeaderFolding (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getAllowHeaderFolding(_map(19, 'CkHttp_getAllowHeaderFolding'))
    (objHandle);
end;

procedure CkHttp_putAllowHeaderFolding (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putAllowHeaderFolding(_map(20, 'CkHttp_putAllowHeaderFolding'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getAuthSignature (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAuthSignature(_map(21, 'CkHttp_getAuthSignature'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAuthSignature (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAuthSignature(_map(22, 'CkHttp_putAuthSignature'))
    (objHandle, newPropVal);
end;

function CkHttp__authSignature (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__authSignature(_map(23, 'CkHttp__authSignature'))
    (objHandle);
end;

procedure CkHttp_getAuthToken (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAuthToken(_map(24, 'CkHttp_getAuthToken'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAuthToken (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAuthToken(_map(25, 'CkHttp_putAuthToken'))
    (objHandle, newPropVal);
end;

function CkHttp__authToken (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__authToken(_map(26, 'CkHttp__authToken'))
    (objHandle);
end;

function CkHttp_getAutoAddHostHeader (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getAutoAddHostHeader(_map(27, 'CkHttp_getAutoAddHostHeader'))
    (objHandle);
end;

procedure CkHttp_putAutoAddHostHeader (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putAutoAddHostHeader(_map(28, 'CkHttp_putAutoAddHostHeader'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getAwsAccessKey (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAwsAccessKey(_map(29, 'CkHttp_getAwsAccessKey'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAwsAccessKey (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAwsAccessKey(_map(30, 'CkHttp_putAwsAccessKey'))
    (objHandle, newPropVal);
end;

function CkHttp__awsAccessKey (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__awsAccessKey(_map(31, 'CkHttp__awsAccessKey'))
    (objHandle);
end;

procedure CkHttp_getAwsEndpoint (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAwsEndpoint(_map(32, 'CkHttp_getAwsEndpoint'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAwsEndpoint (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAwsEndpoint(_map(33, 'CkHttp_putAwsEndpoint'))
    (objHandle, newPropVal);
end;

function CkHttp__awsEndpoint (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__awsEndpoint(_map(34, 'CkHttp__awsEndpoint'))
    (objHandle);
end;

procedure CkHttp_getAwsRegion (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAwsRegion(_map(35, 'CkHttp_getAwsRegion'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAwsRegion (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAwsRegion(_map(36, 'CkHttp_putAwsRegion'))
    (objHandle, newPropVal);
end;

function CkHttp__awsRegion (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__awsRegion(_map(37, 'CkHttp__awsRegion'))
    (objHandle);
end;

procedure CkHttp_getAwsSecretKey (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAwsSecretKey(_map(38, 'CkHttp_getAwsSecretKey'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAwsSecretKey (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAwsSecretKey(_map(39, 'CkHttp_putAwsSecretKey'))
    (objHandle, newPropVal);
end;

function CkHttp__awsSecretKey (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__awsSecretKey(_map(40, 'CkHttp__awsSecretKey'))
    (objHandle);
end;

procedure CkHttp_getAwsSessionToken (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAwsSessionToken(_map(41, 'CkHttp_getAwsSessionToken'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAwsSessionToken (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAwsSessionToken(_map(42, 'CkHttp_putAwsSessionToken'))
    (objHandle, newPropVal);
end;

function CkHttp__awsSessionToken (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__awsSessionToken(_map(43, 'CkHttp__awsSessionToken'))
    (objHandle);
end;

function CkHttp_getAwsSignatureVersion (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getAwsSignatureVersion(_map(44, 'CkHttp_getAwsSignatureVersion'))
    (objHandle);
end;

procedure CkHttp_putAwsSignatureVersion (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putAwsSignatureVersion(_map(45, 'CkHttp_putAwsSignatureVersion'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getAwsSubResources (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getAwsSubResources(_map(46, 'CkHttp_getAwsSubResources'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putAwsSubResources (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putAwsSubResources(_map(47, 'CkHttp_putAwsSubResources'))
    (objHandle, newPropVal);
end;

function CkHttp__awsSubResources (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__awsSubResources(_map(48, 'CkHttp__awsSubResources'))
    (objHandle);
end;

function CkHttp_getBandwidthThrottleDown (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getBandwidthThrottleDown(_map(49, 'CkHttp_getBandwidthThrottleDown'))
    (objHandle);
end;

procedure CkHttp_putBandwidthThrottleDown (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putBandwidthThrottleDown(_map(50, 'CkHttp_putBandwidthThrottleDown'))
    (objHandle, newPropVal);
end;

function CkHttp_getBandwidthThrottleUp (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getBandwidthThrottleUp(_map(51, 'CkHttp_getBandwidthThrottleUp'))
    (objHandle);
end;

procedure CkHttp_putBandwidthThrottleUp (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putBandwidthThrottleUp(_map(52, 'CkHttp_putBandwidthThrottleUp'))
    (objHandle, newPropVal);
end;

function CkHttp_getBasicAuth (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getBasicAuth(_map(53, 'CkHttp_getBasicAuth'))
    (objHandle);
end;

procedure CkHttp_putBasicAuth (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putBasicAuth(_map(54, 'CkHttp_putBasicAuth'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getClientIpAddress (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getClientIpAddress(_map(55, 'CkHttp_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putClientIpAddress (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putClientIpAddress(_map(56, 'CkHttp_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkHttp__clientIpAddress (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__clientIpAddress(_map(57, 'CkHttp__clientIpAddress'))
    (objHandle);
end;

function CkHttp_getConnectFailReason (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getConnectFailReason(_map(58, 'CkHttp_getConnectFailReason'))
    (objHandle);
end;

procedure CkHttp_getConnection (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getConnection(_map(59, 'CkHttp_getConnection'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putConnection (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putConnection(_map(60, 'CkHttp_putConnection'))
    (objHandle, newPropVal);
end;

function CkHttp__connection (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__connection(_map(61, 'CkHttp__connection'))
    (objHandle);
end;

function CkHttp_getConnectTimeout (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getConnectTimeout(_map(62, 'CkHttp_getConnectTimeout'))
    (objHandle);
end;

procedure CkHttp_putConnectTimeout (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putConnectTimeout(_map(63, 'CkHttp_putConnectTimeout'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getCookieDir (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getCookieDir(_map(64, 'CkHttp_getCookieDir'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putCookieDir (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putCookieDir(_map(65, 'CkHttp_putCookieDir'))
    (objHandle, newPropVal);
end;

function CkHttp__cookieDir (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__cookieDir(_map(66, 'CkHttp__cookieDir'))
    (objHandle);
end;

procedure CkHttp_getDebugLogFilePath (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getDebugLogFilePath(_map(67, 'CkHttp_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putDebugLogFilePath (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putDebugLogFilePath(_map(68, 'CkHttp_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkHttp__debugLogFilePath (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__debugLogFilePath(_map(69, 'CkHttp__debugLogFilePath'))
    (objHandle);
end;

function CkHttp_getDefaultFreshPeriod (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getDefaultFreshPeriod(_map(70, 'CkHttp_getDefaultFreshPeriod'))
    (objHandle);
end;

procedure CkHttp_putDefaultFreshPeriod (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putDefaultFreshPeriod(_map(71, 'CkHttp_putDefaultFreshPeriod'))
    (objHandle, newPropVal);
end;

function CkHttp_getDigestAuth (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getDigestAuth(_map(72, 'CkHttp_getDigestAuth'))
    (objHandle);
end;

procedure CkHttp_putDigestAuth (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putDigestAuth(_map(73, 'CkHttp_putDigestAuth'))
    (objHandle, newPropVal);
end;

function CkHttp_getFetchFromCache (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getFetchFromCache(_map(74, 'CkHttp_getFetchFromCache'))
    (objHandle);
end;

procedure CkHttp_putFetchFromCache (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putFetchFromCache(_map(75, 'CkHttp_putFetchFromCache'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getFinalRedirectUrl (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getFinalRedirectUrl(_map(76, 'CkHttp_getFinalRedirectUrl'))
    (objHandle, outPropVal);
end;

function CkHttp__finalRedirectUrl (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__finalRedirectUrl(_map(77, 'CkHttp__finalRedirectUrl'))
    (objHandle);
end;

function CkHttp_getFollowRedirects (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getFollowRedirects(_map(78, 'CkHttp_getFollowRedirects'))
    (objHandle);
end;

procedure CkHttp_putFollowRedirects (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putFollowRedirects(_map(79, 'CkHttp_putFollowRedirects'))
    (objHandle, newPropVal);
end;

function CkHttp_getFreshnessAlgorithm (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getFreshnessAlgorithm(_map(80, 'CkHttp_getFreshnessAlgorithm'))
    (objHandle);
end;

procedure CkHttp_putFreshnessAlgorithm (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putFreshnessAlgorithm(_map(81, 'CkHttp_putFreshnessAlgorithm'))
    (objHandle, newPropVal);
end;

function CkHttp_getHeartbeatMs (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getHeartbeatMs(_map(82, 'CkHttp_getHeartbeatMs'))
    (objHandle);
end;

procedure CkHttp_putHeartbeatMs (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putHeartbeatMs(_map(83, 'CkHttp_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkHttp_getIgnoreMustRevalidate (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getIgnoreMustRevalidate(_map(84, 'CkHttp_getIgnoreMustRevalidate'))
    (objHandle);
end;

procedure CkHttp_putIgnoreMustRevalidate (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putIgnoreMustRevalidate(_map(85, 'CkHttp_putIgnoreMustRevalidate'))
    (objHandle, newPropVal);
end;

function CkHttp_getIgnoreNoCache (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getIgnoreNoCache(_map(86, 'CkHttp_getIgnoreNoCache'))
    (objHandle);
end;

procedure CkHttp_putIgnoreNoCache (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putIgnoreNoCache(_map(87, 'CkHttp_putIgnoreNoCache'))
    (objHandle, newPropVal);
end;

function CkHttp_getKeepResponseBody (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getKeepResponseBody(_map(88, 'CkHttp_getKeepResponseBody'))
    (objHandle);
end;

procedure CkHttp_putKeepResponseBody (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putKeepResponseBody(_map(89, 'CkHttp_putKeepResponseBody'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getLastContentType (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastContentType(_map(90, 'CkHttp_getLastContentType'))
    (objHandle, outPropVal);
end;

function CkHttp__lastContentType (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastContentType(_map(91, 'CkHttp__lastContentType'))
    (objHandle);
end;

procedure CkHttp_getLastErrorHtml (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastErrorHtml(_map(92, 'CkHttp_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkHttp__lastErrorHtml (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastErrorHtml(_map(93, 'CkHttp__lastErrorHtml'))
    (objHandle);
end;

procedure CkHttp_getLastErrorText (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastErrorText(_map(94, 'CkHttp_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkHttp__lastErrorText (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastErrorText(_map(95, 'CkHttp__lastErrorText'))
    (objHandle);
end;

procedure CkHttp_getLastErrorXml (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastErrorXml(_map(96, 'CkHttp_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkHttp__lastErrorXml (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastErrorXml(_map(97, 'CkHttp__lastErrorXml'))
    (objHandle);
end;

function CkHttp_getLastFromCache (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getLastFromCache(_map(98, 'CkHttp_getLastFromCache'))
    (objHandle);
end;

procedure CkHttp_getLastHeader (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastHeader(_map(99, 'CkHttp_getLastHeader'))
    (objHandle, outPropVal);
end;

function CkHttp__lastHeader (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastHeader(_map(100, 'CkHttp__lastHeader'))
    (objHandle);
end;

function CkHttp_getLastMethodSuccess (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getLastMethodSuccess(_map(101, 'CkHttp_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkHttp_putLastMethodSuccess (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putLastMethodSuccess(_map(102, 'CkHttp_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getLastModDate (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastModDate(_map(103, 'CkHttp_getLastModDate'))
    (objHandle, outPropVal);
end;

function CkHttp__lastModDate (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastModDate(_map(104, 'CkHttp__lastModDate'))
    (objHandle);
end;

procedure CkHttp_getLastResponseBody (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastResponseBody(_map(105, 'CkHttp_getLastResponseBody'))
    (objHandle, outPropVal);
end;

function CkHttp__lastResponseBody (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastResponseBody(_map(106, 'CkHttp__lastResponseBody'))
    (objHandle);
end;

procedure CkHttp_getLastResponseHeader (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastResponseHeader(_map(107, 'CkHttp_getLastResponseHeader'))
    (objHandle, outPropVal);
end;

function CkHttp__lastResponseHeader (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastResponseHeader(_map(108, 'CkHttp__lastResponseHeader'))
    (objHandle);
end;

function CkHttp_getLastStatus (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getLastStatus(_map(109, 'CkHttp_getLastStatus'))
    (objHandle);
end;

procedure CkHttp_getLastStatusText (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLastStatusText(_map(110, 'CkHttp_getLastStatusText'))
    (objHandle, outPropVal);
end;

function CkHttp__lastStatusText (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__lastStatusText(_map(111, 'CkHttp__lastStatusText'))
    (objHandle);
end;

function CkHttp_getLMFactor (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getLMFactor(_map(112, 'CkHttp_getLMFactor'))
    (objHandle);
end;

procedure CkHttp_putLMFactor (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putLMFactor(_map(113, 'CkHttp_putLMFactor'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getLogin (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLogin(_map(114, 'CkHttp_getLogin'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putLogin (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putLogin(_map(115, 'CkHttp_putLogin'))
    (objHandle, newPropVal);
end;

function CkHttp__login (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__login(_map(116, 'CkHttp__login'))
    (objHandle);
end;

procedure CkHttp_getLoginDomain (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getLoginDomain(_map(117, 'CkHttp_getLoginDomain'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putLoginDomain (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putLoginDomain(_map(118, 'CkHttp_putLoginDomain'))
    (objHandle, newPropVal);
end;

function CkHttp__loginDomain (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__loginDomain(_map(119, 'CkHttp__loginDomain'))
    (objHandle);
end;

function CkHttp_getMaxConnections (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getMaxConnections(_map(120, 'CkHttp_getMaxConnections'))
    (objHandle);
end;

procedure CkHttp_putMaxConnections (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putMaxConnections(_map(121, 'CkHttp_putMaxConnections'))
    (objHandle, newPropVal);
end;

function CkHttp_getMaxFreshPeriod (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getMaxFreshPeriod(_map(122, 'CkHttp_getMaxFreshPeriod'))
    (objHandle);
end;

procedure CkHttp_putMaxFreshPeriod (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putMaxFreshPeriod(_map(123, 'CkHttp_putMaxFreshPeriod'))
    (objHandle, newPropVal);
end;

function CkHttp_getMaxResponseSize (objHandle: HCkHttp): LongWord;
begin
    result := TCkHttp_getMaxResponseSize(_map(124, 'CkHttp_getMaxResponseSize'))
    (objHandle);
end;

procedure CkHttp_putMaxResponseSize (objHandle: HCkHttp; newPropVal: LongWord);
begin
  TCkHttp_putMaxResponseSize(_map(125, 'CkHttp_putMaxResponseSize'))
    (objHandle, newPropVal);
end;

function CkHttp_getMaxUrlLen (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getMaxUrlLen(_map(126, 'CkHttp_getMaxUrlLen'))
    (objHandle);
end;

procedure CkHttp_putMaxUrlLen (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putMaxUrlLen(_map(127, 'CkHttp_putMaxUrlLen'))
    (objHandle, newPropVal);
end;

function CkHttp_getMimicFireFox (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getMimicFireFox(_map(128, 'CkHttp_getMimicFireFox'))
    (objHandle);
end;

procedure CkHttp_putMimicFireFox (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putMimicFireFox(_map(129, 'CkHttp_putMimicFireFox'))
    (objHandle, newPropVal);
end;

function CkHttp_getMimicIE (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getMimicIE(_map(130, 'CkHttp_getMimicIE'))
    (objHandle);
end;

procedure CkHttp_putMimicIE (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putMimicIE(_map(131, 'CkHttp_putMimicIE'))
    (objHandle, newPropVal);
end;

function CkHttp_getMinFreshPeriod (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getMinFreshPeriod(_map(132, 'CkHttp_getMinFreshPeriod'))
    (objHandle);
end;

procedure CkHttp_putMinFreshPeriod (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putMinFreshPeriod(_map(133, 'CkHttp_putMinFreshPeriod'))
    (objHandle, newPropVal);
end;

function CkHttp_getNegotiateAuth (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getNegotiateAuth(_map(134, 'CkHttp_getNegotiateAuth'))
    (objHandle);
end;

procedure CkHttp_putNegotiateAuth (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putNegotiateAuth(_map(135, 'CkHttp_putNegotiateAuth'))
    (objHandle, newPropVal);
end;

function CkHttp_getNtlmAuth (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getNtlmAuth(_map(136, 'CkHttp_getNtlmAuth'))
    (objHandle);
end;

procedure CkHttp_putNtlmAuth (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putNtlmAuth(_map(137, 'CkHttp_putNtlmAuth'))
    (objHandle, newPropVal);
end;

function CkHttp_getNumCacheLevels (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getNumCacheLevels(_map(138, 'CkHttp_getNumCacheLevels'))
    (objHandle);
end;

procedure CkHttp_putNumCacheLevels (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putNumCacheLevels(_map(139, 'CkHttp_putNumCacheLevels'))
    (objHandle, newPropVal);
end;

function CkHttp_getNumCacheRoots (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getNumCacheRoots(_map(140, 'CkHttp_getNumCacheRoots'))
    (objHandle);
end;

function CkHttp_getOAuth1 (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getOAuth1(_map(141, 'CkHttp_getOAuth1'))
    (objHandle);
end;

procedure CkHttp_putOAuth1 (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putOAuth1(_map(142, 'CkHttp_putOAuth1'))
    (objHandle, newPropVal);
end;

function CkHttp_getOAuthBodyHash (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getOAuthBodyHash(_map(143, 'CkHttp_getOAuthBodyHash'))
    (objHandle);
end;

procedure CkHttp_putOAuthBodyHash (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putOAuthBodyHash(_map(144, 'CkHttp_putOAuthBodyHash'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getOAuthCallback (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthCallback(_map(145, 'CkHttp_getOAuthCallback'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthCallback (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthCallback(_map(146, 'CkHttp_putOAuthCallback'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthCallback (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthCallback(_map(147, 'CkHttp__oAuthCallback'))
    (objHandle);
end;

procedure CkHttp_getOAuthConsumerKey (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthConsumerKey(_map(148, 'CkHttp_getOAuthConsumerKey'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthConsumerKey (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthConsumerKey(_map(149, 'CkHttp_putOAuthConsumerKey'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthConsumerKey (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthConsumerKey(_map(150, 'CkHttp__oAuthConsumerKey'))
    (objHandle);
end;

procedure CkHttp_getOAuthConsumerSecret (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthConsumerSecret(_map(151, 'CkHttp_getOAuthConsumerSecret'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthConsumerSecret (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthConsumerSecret(_map(152, 'CkHttp_putOAuthConsumerSecret'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthConsumerSecret (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthConsumerSecret(_map(153, 'CkHttp__oAuthConsumerSecret'))
    (objHandle);
end;

procedure CkHttp_getOAuthRealm (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthRealm(_map(154, 'CkHttp_getOAuthRealm'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthRealm (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthRealm(_map(155, 'CkHttp_putOAuthRealm'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthRealm (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthRealm(_map(156, 'CkHttp__oAuthRealm'))
    (objHandle);
end;

procedure CkHttp_getOAuthSigMethod (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthSigMethod(_map(157, 'CkHttp_getOAuthSigMethod'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthSigMethod (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthSigMethod(_map(158, 'CkHttp_putOAuthSigMethod'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthSigMethod (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthSigMethod(_map(159, 'CkHttp__oAuthSigMethod'))
    (objHandle);
end;

procedure CkHttp_getOAuthToken (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthToken(_map(160, 'CkHttp_getOAuthToken'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthToken (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthToken(_map(161, 'CkHttp_putOAuthToken'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthToken (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthToken(_map(162, 'CkHttp__oAuthToken'))
    (objHandle);
end;

procedure CkHttp_getOAuthTokenSecret (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthTokenSecret(_map(163, 'CkHttp_getOAuthTokenSecret'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthTokenSecret (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthTokenSecret(_map(164, 'CkHttp_putOAuthTokenSecret'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthTokenSecret (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthTokenSecret(_map(165, 'CkHttp__oAuthTokenSecret'))
    (objHandle);
end;

procedure CkHttp_getOAuthVerifier (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getOAuthVerifier(_map(166, 'CkHttp_getOAuthVerifier'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putOAuthVerifier (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putOAuthVerifier(_map(167, 'CkHttp_putOAuthVerifier'))
    (objHandle, newPropVal);
end;

function CkHttp__oAuthVerifier (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__oAuthVerifier(_map(168, 'CkHttp__oAuthVerifier'))
    (objHandle);
end;

procedure CkHttp_getPassword (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getPassword(_map(169, 'CkHttp_getPassword'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putPassword (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putPassword(_map(170, 'CkHttp_putPassword'))
    (objHandle, newPropVal);
end;

function CkHttp__password (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__password(_map(171, 'CkHttp__password'))
    (objHandle);
end;

function CkHttp_getPercentDoneScale (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getPercentDoneScale(_map(172, 'CkHttp_getPercentDoneScale'))
    (objHandle);
end;

procedure CkHttp_putPercentDoneScale (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putPercentDoneScale(_map(173, 'CkHttp_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkHttp_getPreferIpv6 (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getPreferIpv6(_map(174, 'CkHttp_getPreferIpv6'))
    (objHandle);
end;

procedure CkHttp_putPreferIpv6 (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putPreferIpv6(_map(175, 'CkHttp_putPreferIpv6'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getProxyAuthMethod (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getProxyAuthMethod(_map(176, 'CkHttp_getProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putProxyAuthMethod (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putProxyAuthMethod(_map(177, 'CkHttp_putProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkHttp__proxyAuthMethod (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__proxyAuthMethod(_map(178, 'CkHttp__proxyAuthMethod'))
    (objHandle);
end;

function CkHttp_getProxyDirectTls (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getProxyDirectTls(_map(179, 'CkHttp_getProxyDirectTls'))
    (objHandle);
end;

procedure CkHttp_putProxyDirectTls (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putProxyDirectTls(_map(180, 'CkHttp_putProxyDirectTls'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getProxyDomain (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getProxyDomain(_map(181, 'CkHttp_getProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putProxyDomain (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putProxyDomain(_map(182, 'CkHttp_putProxyDomain'))
    (objHandle, newPropVal);
end;

function CkHttp__proxyDomain (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__proxyDomain(_map(183, 'CkHttp__proxyDomain'))
    (objHandle);
end;

procedure CkHttp_getProxyLogin (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getProxyLogin(_map(184, 'CkHttp_getProxyLogin'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putProxyLogin (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putProxyLogin(_map(185, 'CkHttp_putProxyLogin'))
    (objHandle, newPropVal);
end;

function CkHttp__proxyLogin (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__proxyLogin(_map(186, 'CkHttp__proxyLogin'))
    (objHandle);
end;

procedure CkHttp_getProxyLoginDomain (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getProxyLoginDomain(_map(187, 'CkHttp_getProxyLoginDomain'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putProxyLoginDomain (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putProxyLoginDomain(_map(188, 'CkHttp_putProxyLoginDomain'))
    (objHandle, newPropVal);
end;

function CkHttp__proxyLoginDomain (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__proxyLoginDomain(_map(189, 'CkHttp__proxyLoginDomain'))
    (objHandle);
end;

procedure CkHttp_getProxyPassword (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getProxyPassword(_map(190, 'CkHttp_getProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putProxyPassword (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putProxyPassword(_map(191, 'CkHttp_putProxyPassword'))
    (objHandle, newPropVal);
end;

function CkHttp__proxyPassword (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__proxyPassword(_map(192, 'CkHttp__proxyPassword'))
    (objHandle);
end;

function CkHttp_getProxyPort (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getProxyPort(_map(193, 'CkHttp_getProxyPort'))
    (objHandle);
end;

procedure CkHttp_putProxyPort (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putProxyPort(_map(194, 'CkHttp_putProxyPort'))
    (objHandle, newPropVal);
end;

function CkHttp_getReadTimeout (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getReadTimeout(_map(195, 'CkHttp_getReadTimeout'))
    (objHandle);
end;

procedure CkHttp_putReadTimeout (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putReadTimeout(_map(196, 'CkHttp_putReadTimeout'))
    (objHandle, newPropVal);
end;

function CkHttp_getReceivedCertReq (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getReceivedCertReq(_map(197, 'CkHttp_getReceivedCertReq'))
    (objHandle);
end;

procedure CkHttp_getRedirectVerb (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getRedirectVerb(_map(198, 'CkHttp_getRedirectVerb'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putRedirectVerb (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putRedirectVerb(_map(199, 'CkHttp_putRedirectVerb'))
    (objHandle, newPropVal);
end;

function CkHttp__redirectVerb (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__redirectVerb(_map(200, 'CkHttp__redirectVerb'))
    (objHandle);
end;

procedure CkHttp_getReferer (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getReferer(_map(201, 'CkHttp_getReferer'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putReferer (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putReferer(_map(202, 'CkHttp_putReferer'))
    (objHandle, newPropVal);
end;

function CkHttp__referer (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__referer(_map(203, 'CkHttp__referer'))
    (objHandle);
end;

procedure CkHttp_getRequiredContentType (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getRequiredContentType(_map(204, 'CkHttp_getRequiredContentType'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putRequiredContentType (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putRequiredContentType(_map(205, 'CkHttp_putRequiredContentType'))
    (objHandle, newPropVal);
end;

function CkHttp__requiredContentType (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__requiredContentType(_map(206, 'CkHttp__requiredContentType'))
    (objHandle);
end;

function CkHttp_getRequireHostnameMatch (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getRequireHostnameMatch(_map(207, 'CkHttp_getRequireHostnameMatch'))
    (objHandle);
end;

procedure CkHttp_putRequireHostnameMatch (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putRequireHostnameMatch(_map(208, 'CkHttp_putRequireHostnameMatch'))
    (objHandle, newPropVal);
end;

function CkHttp_getRequireSslCertVerify (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getRequireSslCertVerify(_map(209, 'CkHttp_getRequireSslCertVerify'))
    (objHandle);
end;

procedure CkHttp_putRequireSslCertVerify (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putRequireSslCertVerify(_map(210, 'CkHttp_putRequireSslCertVerify'))
    (objHandle, newPropVal);
end;

function CkHttp_getSaveCookies (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getSaveCookies(_map(211, 'CkHttp_getSaveCookies'))
    (objHandle);
end;

procedure CkHttp_putSaveCookies (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putSaveCookies(_map(212, 'CkHttp_putSaveCookies'))
    (objHandle, newPropVal);
end;

function CkHttp_getSendBufferSize (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getSendBufferSize(_map(213, 'CkHttp_getSendBufferSize'))
    (objHandle);
end;

procedure CkHttp_putSendBufferSize (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putSendBufferSize(_map(214, 'CkHttp_putSendBufferSize'))
    (objHandle, newPropVal);
end;

function CkHttp_getSendCookies (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getSendCookies(_map(215, 'CkHttp_getSendCookies'))
    (objHandle);
end;

procedure CkHttp_putSendCookies (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putSendCookies(_map(216, 'CkHttp_putSendCookies'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getSessionLogFilename (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSessionLogFilename(_map(217, 'CkHttp_getSessionLogFilename'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSessionLogFilename (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSessionLogFilename(_map(218, 'CkHttp_putSessionLogFilename'))
    (objHandle, newPropVal);
end;

function CkHttp__sessionLogFilename (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__sessionLogFilename(_map(219, 'CkHttp__sessionLogFilename'))
    (objHandle);
end;

procedure CkHttp_getSniHostname (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSniHostname(_map(220, 'CkHttp_getSniHostname'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSniHostname (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSniHostname(_map(221, 'CkHttp_putSniHostname'))
    (objHandle, newPropVal);
end;

function CkHttp__sniHostname (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__sniHostname(_map(222, 'CkHttp__sniHostname'))
    (objHandle);
end;

procedure CkHttp_getSocksHostname (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSocksHostname(_map(223, 'CkHttp_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSocksHostname (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSocksHostname(_map(224, 'CkHttp_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkHttp__socksHostname (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__socksHostname(_map(225, 'CkHttp__socksHostname'))
    (objHandle);
end;

procedure CkHttp_getSocksPassword (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSocksPassword(_map(226, 'CkHttp_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSocksPassword (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSocksPassword(_map(227, 'CkHttp_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkHttp__socksPassword (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__socksPassword(_map(228, 'CkHttp__socksPassword'))
    (objHandle);
end;

function CkHttp_getSocksPort (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getSocksPort(_map(229, 'CkHttp_getSocksPort'))
    (objHandle);
end;

procedure CkHttp_putSocksPort (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putSocksPort(_map(230, 'CkHttp_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getSocksUsername (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSocksUsername(_map(231, 'CkHttp_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSocksUsername (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSocksUsername(_map(232, 'CkHttp_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkHttp__socksUsername (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__socksUsername(_map(233, 'CkHttp__socksUsername'))
    (objHandle);
end;

function CkHttp_getSocksVersion (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getSocksVersion(_map(234, 'CkHttp_getSocksVersion'))
    (objHandle);
end;

procedure CkHttp_putSocksVersion (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putSocksVersion(_map(235, 'CkHttp_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkHttp_getSoRcvBuf (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getSoRcvBuf(_map(236, 'CkHttp_getSoRcvBuf'))
    (objHandle);
end;

procedure CkHttp_putSoRcvBuf (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putSoRcvBuf(_map(237, 'CkHttp_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkHttp_getSoSndBuf (objHandle: HCkHttp): Integer;
begin
    result := TCkHttp_getSoSndBuf(_map(238, 'CkHttp_getSoSndBuf'))
    (objHandle);
end;

procedure CkHttp_putSoSndBuf (objHandle: HCkHttp; newPropVal: Integer);
begin
  TCkHttp_putSoSndBuf(_map(239, 'CkHttp_putSoSndBuf'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getSslAllowedCiphers (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSslAllowedCiphers(_map(240, 'CkHttp_getSslAllowedCiphers'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSslAllowedCiphers (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSslAllowedCiphers(_map(241, 'CkHttp_putSslAllowedCiphers'))
    (objHandle, newPropVal);
end;

function CkHttp__sslAllowedCiphers (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__sslAllowedCiphers(_map(242, 'CkHttp__sslAllowedCiphers'))
    (objHandle);
end;

procedure CkHttp_getSslProtocol (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getSslProtocol(_map(243, 'CkHttp_getSslProtocol'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putSslProtocol (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putSslProtocol(_map(244, 'CkHttp_putSslProtocol'))
    (objHandle, newPropVal);
end;

function CkHttp__sslProtocol (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__sslProtocol(_map(245, 'CkHttp__sslProtocol'))
    (objHandle);
end;

procedure CkHttp_getStreamResponseBodyPath (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getStreamResponseBodyPath(_map(246, 'CkHttp_getStreamResponseBodyPath'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putStreamResponseBodyPath (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putStreamResponseBodyPath(_map(247, 'CkHttp_putStreamResponseBodyPath'))
    (objHandle, newPropVal);
end;

function CkHttp__streamResponseBodyPath (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__streamResponseBodyPath(_map(248, 'CkHttp__streamResponseBodyPath'))
    (objHandle);
end;

procedure CkHttp_getTlsCipherSuite (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getTlsCipherSuite(_map(249, 'CkHttp_getTlsCipherSuite'))
    (objHandle, outPropVal);
end;

function CkHttp__tlsCipherSuite (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__tlsCipherSuite(_map(250, 'CkHttp__tlsCipherSuite'))
    (objHandle);
end;

procedure CkHttp_getTlsPinSet (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getTlsPinSet(_map(251, 'CkHttp_getTlsPinSet'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putTlsPinSet (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putTlsPinSet(_map(252, 'CkHttp_putTlsPinSet'))
    (objHandle, newPropVal);
end;

function CkHttp__tlsPinSet (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__tlsPinSet(_map(253, 'CkHttp__tlsPinSet'))
    (objHandle);
end;

procedure CkHttp_getTlsVersion (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getTlsVersion(_map(254, 'CkHttp_getTlsVersion'))
    (objHandle, outPropVal);
end;

function CkHttp__tlsVersion (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__tlsVersion(_map(255, 'CkHttp__tlsVersion'))
    (objHandle);
end;

procedure CkHttp_getUncommonOptions (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getUncommonOptions(_map(256, 'CkHttp_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putUncommonOptions (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putUncommonOptions(_map(257, 'CkHttp_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkHttp__uncommonOptions (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__uncommonOptions(_map(258, 'CkHttp__uncommonOptions'))
    (objHandle);
end;

function CkHttp_getUpdateCache (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getUpdateCache(_map(259, 'CkHttp_getUpdateCache'))
    (objHandle);
end;

procedure CkHttp_putUpdateCache (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putUpdateCache(_map(260, 'CkHttp_putUpdateCache'))
    (objHandle, newPropVal);
end;

function CkHttp_getUseIEProxy (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getUseIEProxy(_map(261, 'CkHttp_getUseIEProxy'))
    (objHandle);
end;

procedure CkHttp_putUseIEProxy (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putUseIEProxy(_map(262, 'CkHttp_putUseIEProxy'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getUserAgent (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getUserAgent(_map(263, 'CkHttp_getUserAgent'))
    (objHandle, outPropVal);
end;

procedure CkHttp_putUserAgent (objHandle: HCkHttp; newPropVal: PWideChar);
begin
  TCkHttp_putUserAgent(_map(264, 'CkHttp_putUserAgent'))
    (objHandle, newPropVal);
end;

function CkHttp__userAgent (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__userAgent(_map(265, 'CkHttp__userAgent'))
    (objHandle);
end;

function CkHttp_getVerboseLogging (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getVerboseLogging(_map(266, 'CkHttp_getVerboseLogging'))
    (objHandle);
end;

procedure CkHttp_putVerboseLogging (objHandle: HCkHttp; newPropVal: wordbool);
begin
  TCkHttp_putVerboseLogging(_map(267, 'CkHttp_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkHttp_getVersion (objHandle: HCkHttp; outPropVal: HCkString);
begin
  TCkHttp_getVersion(_map(268, 'CkHttp_getVersion'))
    (objHandle, outPropVal);
end;

function CkHttp__version (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__version(_map(269, 'CkHttp__version'))
    (objHandle);
end;

function CkHttp_getWasRedirected (objHandle: HCkHttp): wordbool;
begin
    result := TCkHttp_getWasRedirected(_map(270, 'CkHttp_getWasRedirected'))
    (objHandle);
end;

procedure CkHttp_AddCacheRoot (objHandle: HCkHttp; dir: PWideChar);
begin
  TCkHttp_AddCacheRoot(_map(271, 'CkHttp_AddCacheRoot'))
    (objHandle, dir);
end;

procedure CkHttp_ClearHeaders (objHandle: HCkHttp);
begin
  TCkHttp_ClearHeaders(_map(272, 'CkHttp_ClearHeaders'))
    (objHandle);
end;

procedure CkHttp_ClearInMemoryCookies (objHandle: HCkHttp);
begin
  TCkHttp_ClearInMemoryCookies(_map(273, 'CkHttp_ClearInMemoryCookies'))
    (objHandle);
end;

procedure CkHttp_ClearUrlVars (objHandle: HCkHttp);
begin
  TCkHttp_ClearUrlVars(_map(274, 'CkHttp_ClearUrlVars'))
    (objHandle);
end;

function CkHttp_CloseAllConnections (objHandle: HCkHttp): wordbool;
begin
  result := TCkHttp_CloseAllConnections(_map(275, 'CkHttp_CloseAllConnections'))
    (objHandle);
end;

function CkHttp_CloseAllConnectionsAsync (objHandle: HCkHttp): HCkTask;
begin
  result := TCkHttp_CloseAllConnectionsAsync(_map(276, 'CkHttp_CloseAllConnectionsAsync'))
    (objHandle);
end;

function CkHttp_CreateOcspRequest (objHandle: HCkHttp; requestDetails: HCkJsonObject; ocspRequest: HCkBinData): wordbool;
begin
  result := TCkHttp_CreateOcspRequest(_map(277, 'CkHttp_CreateOcspRequest'))
    (objHandle, requestDetails, ocspRequest);
end;

function CkHttp_CreateTimestampRequest (objHandle: HCkHttp; hashAlg: PWideChar; hashVal: PWideChar; reqPolicyOid: PWideChar; addNonce: wordbool; reqTsaCert: wordbool; timestampToken: HCkBinData): wordbool;
begin
  result := TCkHttp_CreateTimestampRequest(_map(278, 'CkHttp_CreateTimestampRequest'))
    (objHandle, hashAlg, hashVal, reqPolicyOid, addNonce, reqTsaCert, timestampToken);
end;

procedure CkHttp_DnsCacheClear (objHandle: HCkHttp);
begin
  TCkHttp_DnsCacheClear(_map(279, 'CkHttp_DnsCacheClear'))
    (objHandle);
end;

function CkHttp_Download (objHandle: HCkHttp; url: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkHttp_Download(_map(280, 'CkHttp_Download'))
    (objHandle, url, localFilePath);
end;

function CkHttp_DownloadAsync (objHandle: HCkHttp; url: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkHttp_DownloadAsync(_map(281, 'CkHttp_DownloadAsync'))
    (objHandle, url, localFilePath);
end;

function CkHttp_DownloadAppend (objHandle: HCkHttp; url: PWideChar; appendToPath: PWideChar): wordbool;
begin
  result := TCkHttp_DownloadAppend(_map(282, 'CkHttp_DownloadAppend'))
    (objHandle, url, appendToPath);
end;

function CkHttp_DownloadAppendAsync (objHandle: HCkHttp; url: PWideChar; appendToPath: PWideChar): HCkTask;
begin
  result := TCkHttp_DownloadAppendAsync(_map(283, 'CkHttp_DownloadAppendAsync'))
    (objHandle, url, appendToPath);
end;

function CkHttp_DownloadBd (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool;
begin
  result := TCkHttp_DownloadBd(_map(284, 'CkHttp_DownloadBd'))
    (objHandle, url, binData);
end;

function CkHttp_DownloadBdAsync (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask;
begin
  result := TCkHttp_DownloadBdAsync(_map(285, 'CkHttp_DownloadBdAsync'))
    (objHandle, url, binData);
end;

function CkHttp_DownloadHash (objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_DownloadHash(_map(286, 'CkHttp_DownloadHash'))
    (objHandle, url, hashAlgorithm, encoding, outStr);
end;

function CkHttp__downloadHash (objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkHttp__downloadHash(_map(287, 'CkHttp__downloadHash'))
    (objHandle, url, hashAlgorithm, encoding);
end;

function CkHttp_DownloadHashAsync (objHandle: HCkHttp; url: PWideChar; hashAlgorithm: PWideChar; encoding: PWideChar): HCkTask;
begin
  result := TCkHttp_DownloadHashAsync(_map(288, 'CkHttp_DownloadHashAsync'))
    (objHandle, url, hashAlgorithm, encoding);
end;

function CkHttp_DownloadSb (objHandle: HCkHttp; url: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkHttp_DownloadSb(_map(289, 'CkHttp_DownloadSb'))
    (objHandle, url, charset, sb);
end;

function CkHttp_DownloadSbAsync (objHandle: HCkHttp; url: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkHttp_DownloadSbAsync(_map(290, 'CkHttp_DownloadSbAsync'))
    (objHandle, url, charset, sb);
end;

function CkHttp_ExtractMetaRefreshUrl (objHandle: HCkHttp; htmlContent: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_ExtractMetaRefreshUrl(_map(291, 'CkHttp_ExtractMetaRefreshUrl'))
    (objHandle, htmlContent, outStr);
end;

function CkHttp__extractMetaRefreshUrl (objHandle: HCkHttp; htmlContent: PWideChar): PWideChar;
begin
  result := TCkHttp__extractMetaRefreshUrl(_map(292, 'CkHttp__extractMetaRefreshUrl'))
    (objHandle, htmlContent);
end;

function CkHttp_G_SvcOauthAccessToken (objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkHttp_G_SvcOauthAccessToken(_map(293, 'CkHttp_G_SvcOauthAccessToken'))
    (objHandle, iss, scope, subEmail, numSec, cert, outStr);
end;

function CkHttp__g_SvcOauthAccessToken (objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert): PWideChar;
begin
  result := TCkHttp__g_SvcOauthAccessToken(_map(294, 'CkHttp__g_SvcOauthAccessToken'))
    (objHandle, iss, scope, subEmail, numSec, cert);
end;

function CkHttp_G_SvcOauthAccessTokenAsync (objHandle: HCkHttp; iss: PWideChar; scope: PWideChar; subEmail: PWideChar; numSec: Integer; cert: HCkCert): HCkTask;
begin
  result := TCkHttp_G_SvcOauthAccessTokenAsync(_map(295, 'CkHttp_G_SvcOauthAccessTokenAsync'))
    (objHandle, iss, scope, subEmail, numSec, cert);
end;

function CkHttp_G_SvcOauthAccessToken2 (objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkHttp_G_SvcOauthAccessToken2(_map(296, 'CkHttp_G_SvcOauthAccessToken2'))
    (objHandle, claimParams, numSec, cert, outStr);
end;

function CkHttp__g_SvcOauthAccessToken2 (objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert): PWideChar;
begin
  result := TCkHttp__g_SvcOauthAccessToken2(_map(297, 'CkHttp__g_SvcOauthAccessToken2'))
    (objHandle, claimParams, numSec, cert);
end;

function CkHttp_G_SvcOauthAccessToken2Async (objHandle: HCkHttp; claimParams: HCkHashtable; numSec: Integer; cert: HCkCert): HCkTask;
begin
  result := TCkHttp_G_SvcOauthAccessToken2Async(_map(298, 'CkHttp_G_SvcOauthAccessToken2Async'))
    (objHandle, claimParams, numSec, cert);
end;

function CkHttp_GenTimeStamp (objHandle: HCkHttp; outStr: HCkString): wordbool;
begin
  result := TCkHttp_GenTimeStamp(_map(299, 'CkHttp_GenTimeStamp'))
    (objHandle, outStr);
end;

function CkHttp__genTimeStamp (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__genTimeStamp(_map(300, 'CkHttp__genTimeStamp'))
    (objHandle);
end;

function CkHttp_GetCacheRoot (objHandle: HCkHttp; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttp_GetCacheRoot(_map(301, 'CkHttp_GetCacheRoot'))
    (objHandle, index, outStr);
end;

function CkHttp__getCacheRoot (objHandle: HCkHttp; index: Integer): PWideChar;
begin
  result := TCkHttp__getCacheRoot(_map(302, 'CkHttp__getCacheRoot'))
    (objHandle, index);
end;

function CkHttp_GetCookieXml (objHandle: HCkHttp; domain: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_GetCookieXml(_map(303, 'CkHttp_GetCookieXml'))
    (objHandle, domain, outStr);
end;

function CkHttp__getCookieXml (objHandle: HCkHttp; domain: PWideChar): PWideChar;
begin
  result := TCkHttp__getCookieXml(_map(304, 'CkHttp__getCookieXml'))
    (objHandle, domain);
end;

function CkHttp_GetDomain (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_GetDomain(_map(305, 'CkHttp_GetDomain'))
    (objHandle, url, outStr);
end;

function CkHttp__getDomain (objHandle: HCkHttp; url: PWideChar): PWideChar;
begin
  result := TCkHttp__getDomain(_map(306, 'CkHttp__getDomain'))
    (objHandle, url);
end;

function CkHttp_GetHead (objHandle: HCkHttp; url: PWideChar): HCkHttpResponse;
begin
  result := TCkHttp_GetHead(_map(307, 'CkHttp_GetHead'))
    (objHandle, url);
end;

function CkHttp_GetHeadAsync (objHandle: HCkHttp; url: PWideChar): HCkTask;
begin
  result := TCkHttp_GetHeadAsync(_map(308, 'CkHttp_GetHeadAsync'))
    (objHandle, url);
end;

procedure CkHttp_GetLastJsonData (objHandle: HCkHttp; json: HCkJsonObject);
begin
  TCkHttp_GetLastJsonData(_map(309, 'CkHttp_GetLastJsonData'))
    (objHandle, json);
end;

function CkHttp_GetRequestHeader (objHandle: HCkHttp; name: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_GetRequestHeader(_map(310, 'CkHttp_GetRequestHeader'))
    (objHandle, name, outStr);
end;

function CkHttp__getRequestHeader (objHandle: HCkHttp; name: PWideChar): PWideChar;
begin
  result := TCkHttp__getRequestHeader(_map(311, 'CkHttp__getRequestHeader'))
    (objHandle, name);
end;

function CkHttp_GetServerCert (objHandle: HCkHttp; domain: PWideChar; port: Integer; cert: HCkCert): wordbool;
begin
  result := TCkHttp_GetServerCert(_map(312, 'CkHttp_GetServerCert'))
    (objHandle, domain, port, cert);
end;

function CkHttp_GetServerCertAsync (objHandle: HCkHttp; domain: PWideChar; port: Integer; cert: HCkCert): HCkTask;
begin
  result := TCkHttp_GetServerCertAsync(_map(313, 'CkHttp_GetServerCertAsync'))
    (objHandle, domain, port, cert);
end;

function CkHttp_GetServerSslCert (objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkCert;
begin
  result := TCkHttp_GetServerSslCert(_map(314, 'CkHttp_GetServerSslCert'))
    (objHandle, domain, port);
end;

function CkHttp_GetServerSslCertAsync (objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkTask;
begin
  result := TCkHttp_GetServerSslCertAsync(_map(315, 'CkHttp_GetServerSslCertAsync'))
    (objHandle, domain, port);
end;

function CkHttp_GetUrlPath (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_GetUrlPath(_map(316, 'CkHttp_GetUrlPath'))
    (objHandle, url, outStr);
end;

function CkHttp__getUrlPath (objHandle: HCkHttp; url: PWideChar): PWideChar;
begin
  result := TCkHttp__getUrlPath(_map(317, 'CkHttp__getUrlPath'))
    (objHandle, url);
end;

function CkHttp_HasRequestHeader (objHandle: HCkHttp; name: PWideChar): wordbool;
begin
  result := TCkHttp_HasRequestHeader(_map(318, 'CkHttp_HasRequestHeader'))
    (objHandle, name);
end;

function CkHttp_HttpBd (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bd: HCkBinData; contentType: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpBd(_map(319, 'CkHttp_HttpBd'))
    (objHandle, verb, url, bd, contentType, response);
end;

function CkHttp_HttpBdAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bd: HCkBinData; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpBdAsync(_map(320, 'CkHttp_HttpBdAsync'))
    (objHandle, verb, url, bd, contentType, response);
end;

function CkHttp_HttpBinary (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpBinary(_map(321, 'CkHttp_HttpBinary'))
    (objHandle, verb, url, byteData, contentType, response);
end;

function CkHttp_HttpBinaryAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpBinaryAsync(_map(322, 'CkHttp_HttpBinaryAsync'))
    (objHandle, verb, url, byteData, contentType, response);
end;

function CkHttp_HttpFile (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpFile(_map(323, 'CkHttp_HttpFile'))
    (objHandle, verb, url, localFilePath, contentType, response);
end;

function CkHttp_HttpFileAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpFileAsync(_map(324, 'CkHttp_HttpFileAsync'))
    (objHandle, verb, url, localFilePath, contentType, response);
end;

function CkHttp_HttpJson (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; contentType: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpJson(_map(325, 'CkHttp_HttpJson'))
    (objHandle, verb, url, json, contentType, response);
end;

function CkHttp_HttpJsonAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpJsonAsync(_map(326, 'CkHttp_HttpJsonAsync'))
    (objHandle, verb, url, json, contentType, response);
end;

function CkHttp_HttpNoBody (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpNoBody(_map(327, 'CkHttp_HttpNoBody'))
    (objHandle, verb, url, response);
end;

function CkHttp_HttpNoBodyAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpNoBodyAsync(_map(328, 'CkHttp_HttpNoBodyAsync'))
    (objHandle, verb, url, response);
end;

function CkHttp_HttpParams (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpParams(_map(329, 'CkHttp_HttpParams'))
    (objHandle, verb, url, json, response);
end;

function CkHttp_HttpParamsAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpParamsAsync(_map(330, 'CkHttp_HttpParamsAsync'))
    (objHandle, verb, url, json, response);
end;

function CkHttp_HttpReq (objHandle: HCkHttp; url: PWideChar; request: HCkHttpRequest; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpReq(_map(331, 'CkHttp_HttpReq'))
    (objHandle, url, request, response);
end;

function CkHttp_HttpReqAsync (objHandle: HCkHttp; url: PWideChar; request: HCkHttpRequest; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpReqAsync(_map(332, 'CkHttp_HttpReqAsync'))
    (objHandle, url, request, response);
end;

function CkHttp_HttpSb (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; sb: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpSb(_map(333, 'CkHttp_HttpSb'))
    (objHandle, verb, url, sb, charset, contentType, response);
end;

function CkHttp_HttpSbAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; sb: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpSbAsync(_map(334, 'CkHttp_HttpSbAsync'))
    (objHandle, verb, url, sb, charset, contentType, response);
end;

function CkHttp_HttpSReq (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; request: HCkHttpRequest; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpSReq(_map(335, 'CkHttp_HttpSReq'))
    (objHandle, domain, port, ssl, request, response);
end;

function CkHttp_HttpSReqAsync (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; request: HCkHttpRequest; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpSReqAsync(_map(336, 'CkHttp_HttpSReqAsync'))
    (objHandle, domain, port, ssl, request, response);
end;

function CkHttp_HttpStr (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bodyStr: PWideChar; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): wordbool;
begin
  result := TCkHttp_HttpStr(_map(337, 'CkHttp_HttpStr'))
    (objHandle, verb, url, bodyStr, charset, contentType, response);
end;

function CkHttp_HttpStrAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; bodyStr: PWideChar; charset: PWideChar; contentType: PWideChar; response: HCkHttpResponse): HCkTask;
begin
  result := TCkHttp_HttpStrAsync(_map(338, 'CkHttp_HttpStrAsync'))
    (objHandle, verb, url, bodyStr, charset, contentType, response);
end;

function CkHttp_LastJsonData (objHandle: HCkHttp): HCkJsonObject;
begin
  result := TCkHttp_LastJsonData(_map(339, 'CkHttp_LastJsonData'))
    (objHandle);
end;

function CkHttp_LoadTaskCaller (objHandle: HCkHttp; task: HCkTask): wordbool;
begin
  result := TCkHttp_LoadTaskCaller(_map(340, 'CkHttp_LoadTaskCaller'))
    (objHandle, task);
end;

function CkHttp_OcspCheck (objHandle: HCkHttp; domain: PWideChar; port: Integer): Integer;
begin
  result := TCkHttp_OcspCheck(_map(341, 'CkHttp_OcspCheck'))
    (objHandle, domain, port);
end;

function CkHttp_OcspCheckAsync (objHandle: HCkHttp; domain: PWideChar; port: Integer): HCkTask;
begin
  result := TCkHttp_OcspCheckAsync(_map(342, 'CkHttp_OcspCheckAsync'))
    (objHandle, domain, port);
end;

function CkHttp_ParseOcspReply (objHandle: HCkHttp; ocspReply: HCkBinData; replyData: HCkJsonObject): Integer;
begin
  result := TCkHttp_ParseOcspReply(_map(343, 'CkHttp_ParseOcspReply'))
    (objHandle, ocspReply, replyData);
end;

function CkHttp_PBinary (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
begin
  result := TCkHttp_PBinary(_map(344, 'CkHttp_PBinary'))
    (objHandle, verb, url, byteData, contentType, md5, gzip);
end;

function CkHttp_PBinaryAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PBinaryAsync(_map(345, 'CkHttp_PBinaryAsync'))
    (objHandle, verb, url, byteData, contentType, md5, gzip);
end;

function CkHttp_PBinaryBd (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; data: HCkBinData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
begin
  result := TCkHttp_PBinaryBd(_map(346, 'CkHttp_PBinaryBd'))
    (objHandle, verb, url, data, contentType, md5, gzip);
end;

function CkHttp_PBinaryBdAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; data: HCkBinData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PBinaryBdAsync(_map(347, 'CkHttp_PBinaryBdAsync'))
    (objHandle, verb, url, data, contentType, md5, gzip);
end;

function CkHttp_PFile (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
begin
  result := TCkHttp_PFile(_map(348, 'CkHttp_PFile'))
    (objHandle, verb, url, localFilePath, contentType, md5, gzip);
end;

function CkHttp_PFileAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; localFilePath: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PFileAsync(_map(349, 'CkHttp_PFileAsync'))
    (objHandle, verb, url, localFilePath, contentType, md5, gzip);
end;

function CkHttp_PostBinary (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkHttp_PostBinary(_map(350, 'CkHttp_PostBinary'))
    (objHandle, url, byteData, contentType, md5, gzip, outStr);
end;

function CkHttp__postBinary (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar;
begin
  result := TCkHttp__postBinary(_map(351, 'CkHttp__postBinary'))
    (objHandle, url, byteData, contentType, md5, gzip);
end;

function CkHttp_PostBinaryAsync (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PostBinaryAsync(_map(352, 'CkHttp_PostBinaryAsync'))
    (objHandle, url, byteData, contentType, md5, gzip);
end;

function CkHttp_PostJson (objHandle: HCkHttp; url: PWideChar; jsonText: PWideChar): HCkHttpResponse;
begin
  result := TCkHttp_PostJson(_map(353, 'CkHttp_PostJson'))
    (objHandle, url, jsonText);
end;

function CkHttp_PostJsonAsync (objHandle: HCkHttp; url: PWideChar; jsonText: PWideChar): HCkTask;
begin
  result := TCkHttp_PostJsonAsync(_map(354, 'CkHttp_PostJsonAsync'))
    (objHandle, url, jsonText);
end;

function CkHttp_PostJson2 (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; jsonText: PWideChar): HCkHttpResponse;
begin
  result := TCkHttp_PostJson2(_map(355, 'CkHttp_PostJson2'))
    (objHandle, url, contentType, jsonText);
end;

function CkHttp_PostJson2Async (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; jsonText: PWideChar): HCkTask;
begin
  result := TCkHttp_PostJson2Async(_map(356, 'CkHttp_PostJson2Async'))
    (objHandle, url, contentType, jsonText);
end;

function CkHttp_PostJson3 (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; json: HCkJsonObject): HCkHttpResponse;
begin
  result := TCkHttp_PostJson3(_map(357, 'CkHttp_PostJson3'))
    (objHandle, url, contentType, json);
end;

function CkHttp_PostJson3Async (objHandle: HCkHttp; url: PWideChar; contentType: PWideChar; json: HCkJsonObject): HCkTask;
begin
  result := TCkHttp_PostJson3Async(_map(358, 'CkHttp_PostJson3Async'))
    (objHandle, url, contentType, json);
end;

function CkHttp_PostUrlEncoded (objHandle: HCkHttp; url: PWideChar; req: HCkHttpRequest): HCkHttpResponse;
begin
  result := TCkHttp_PostUrlEncoded(_map(359, 'CkHttp_PostUrlEncoded'))
    (objHandle, url, req);
end;

function CkHttp_PostUrlEncodedAsync (objHandle: HCkHttp; url: PWideChar; req: HCkHttpRequest): HCkTask;
begin
  result := TCkHttp_PostUrlEncodedAsync(_map(360, 'CkHttp_PostUrlEncodedAsync'))
    (objHandle, url, req);
end;

function CkHttp_PostXml (objHandle: HCkHttp; endpointUrl: PWideChar; xmlContent: PWideChar; xmlCharset: PWideChar): HCkHttpResponse;
begin
  result := TCkHttp_PostXml(_map(361, 'CkHttp_PostXml'))
    (objHandle, endpointUrl, xmlContent, xmlCharset);
end;

function CkHttp_PostXmlAsync (objHandle: HCkHttp; endpointUrl: PWideChar; xmlContent: PWideChar; xmlCharset: PWideChar): HCkTask;
begin
  result := TCkHttp_PostXmlAsync(_map(362, 'CkHttp_PostXmlAsync'))
    (objHandle, endpointUrl, xmlContent, xmlCharset);
end;

function CkHttp_PText (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
begin
  result := TCkHttp_PText(_map(363, 'CkHttp_PText'))
    (objHandle, verb, url, textData, charset, contentType, md5, gzip);
end;

function CkHttp_PTextAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PTextAsync(_map(364, 'CkHttp_PTextAsync'))
    (objHandle, verb, url, textData, charset, contentType, md5, gzip);
end;

function CkHttp_PTextSb (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkHttpResponse;
begin
  result := TCkHttp_PTextSb(_map(365, 'CkHttp_PTextSb'))
    (objHandle, verb, url, textData, charset, contentType, md5, gzip);
end;

function CkHttp_PTextSbAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; textData: HCkStringBuilder; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PTextSbAsync(_map(366, 'CkHttp_PTextSbAsync'))
    (objHandle, verb, url, textData, charset, contentType, md5, gzip);
end;

function CkHttp_PutBinary (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkHttp_PutBinary(_map(367, 'CkHttp_PutBinary'))
    (objHandle, url, byteData, contentType, md5, gzip, outStr);
end;

function CkHttp__putBinary (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar;
begin
  result := TCkHttp__putBinary(_map(368, 'CkHttp__putBinary'))
    (objHandle, url, byteData, contentType, md5, gzip);
end;

function CkHttp_PutBinaryAsync (objHandle: HCkHttp; url: PWideChar; byteData: HCkByteData; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PutBinaryAsync(_map(369, 'CkHttp_PutBinaryAsync'))
    (objHandle, url, byteData, contentType, md5, gzip);
end;

function CkHttp_PutText (objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkHttp_PutText(_map(370, 'CkHttp_PutText'))
    (objHandle, url, textData, charset, contentType, md5, gzip, outStr);
end;

function CkHttp__putText (objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): PWideChar;
begin
  result := TCkHttp__putText(_map(371, 'CkHttp__putText'))
    (objHandle, url, textData, charset, contentType, md5, gzip);
end;

function CkHttp_PutTextAsync (objHandle: HCkHttp; url: PWideChar; textData: PWideChar; charset: PWideChar; contentType: PWideChar; md5: wordbool; gzip: wordbool): HCkTask;
begin
  result := TCkHttp_PutTextAsync(_map(372, 'CkHttp_PutTextAsync'))
    (objHandle, url, textData, charset, contentType, md5, gzip);
end;

function CkHttp_QuickDeleteStr (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_QuickDeleteStr(_map(373, 'CkHttp_QuickDeleteStr'))
    (objHandle, url, outStr);
end;

function CkHttp__quickDeleteStr (objHandle: HCkHttp; url: PWideChar): PWideChar;
begin
  result := TCkHttp__quickDeleteStr(_map(374, 'CkHttp__quickDeleteStr'))
    (objHandle, url);
end;

function CkHttp_QuickDeleteStrAsync (objHandle: HCkHttp; url: PWideChar): HCkTask;
begin
  result := TCkHttp_QuickDeleteStrAsync(_map(375, 'CkHttp_QuickDeleteStrAsync'))
    (objHandle, url);
end;

function CkHttp_QuickGet (objHandle: HCkHttp; url: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkHttp_QuickGet(_map(376, 'CkHttp_QuickGet'))
    (objHandle, url, outData);
end;

function CkHttp_QuickGetAsync (objHandle: HCkHttp; url: PWideChar): HCkTask;
begin
  result := TCkHttp_QuickGetAsync(_map(377, 'CkHttp_QuickGetAsync'))
    (objHandle, url);
end;

function CkHttp_QuickGetBd (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool;
begin
  result := TCkHttp_QuickGetBd(_map(378, 'CkHttp_QuickGetBd'))
    (objHandle, url, binData);
end;

function CkHttp_QuickGetBdAsync (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask;
begin
  result := TCkHttp_QuickGetBdAsync(_map(379, 'CkHttp_QuickGetBdAsync'))
    (objHandle, url, binData);
end;

function CkHttp_QuickGetObj (objHandle: HCkHttp; url: PWideChar): HCkHttpResponse;
begin
  result := TCkHttp_QuickGetObj(_map(380, 'CkHttp_QuickGetObj'))
    (objHandle, url);
end;

function CkHttp_QuickGetObjAsync (objHandle: HCkHttp; url: PWideChar): HCkTask;
begin
  result := TCkHttp_QuickGetObjAsync(_map(381, 'CkHttp_QuickGetObjAsync'))
    (objHandle, url);
end;

function CkHttp_QuickGetSb (objHandle: HCkHttp; url: PWideChar; sbContent: HCkStringBuilder): wordbool;
begin
  result := TCkHttp_QuickGetSb(_map(382, 'CkHttp_QuickGetSb'))
    (objHandle, url, sbContent);
end;

function CkHttp_QuickGetSbAsync (objHandle: HCkHttp; url: PWideChar; sbContent: HCkStringBuilder): HCkTask;
begin
  result := TCkHttp_QuickGetSbAsync(_map(383, 'CkHttp_QuickGetSbAsync'))
    (objHandle, url, sbContent);
end;

function CkHttp_QuickGetStr (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_QuickGetStr(_map(384, 'CkHttp_QuickGetStr'))
    (objHandle, url, outStr);
end;

function CkHttp__quickGetStr (objHandle: HCkHttp; url: PWideChar): PWideChar;
begin
  result := TCkHttp__quickGetStr(_map(385, 'CkHttp__quickGetStr'))
    (objHandle, url);
end;

function CkHttp_QuickGetStrAsync (objHandle: HCkHttp; url: PWideChar): HCkTask;
begin
  result := TCkHttp_QuickGetStrAsync(_map(386, 'CkHttp_QuickGetStrAsync'))
    (objHandle, url);
end;

function CkHttp_QuickPutStr (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_QuickPutStr(_map(387, 'CkHttp_QuickPutStr'))
    (objHandle, url, outStr);
end;

function CkHttp__quickPutStr (objHandle: HCkHttp; url: PWideChar): PWideChar;
begin
  result := TCkHttp__quickPutStr(_map(388, 'CkHttp__quickPutStr'))
    (objHandle, url);
end;

function CkHttp_QuickPutStrAsync (objHandle: HCkHttp; url: PWideChar): HCkTask;
begin
  result := TCkHttp_QuickPutStrAsync(_map(389, 'CkHttp_QuickPutStrAsync'))
    (objHandle, url);
end;

function CkHttp_QuickRequest (objHandle: HCkHttp; verb: PWideChar; url: PWideChar): HCkHttpResponse;
begin
  result := TCkHttp_QuickRequest(_map(390, 'CkHttp_QuickRequest'))
    (objHandle, verb, url);
end;

function CkHttp_QuickRequestAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar): HCkTask;
begin
  result := TCkHttp_QuickRequestAsync(_map(391, 'CkHttp_QuickRequestAsync'))
    (objHandle, verb, url);
end;

function CkHttp_QuickRequestParams (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject): HCkHttpResponse;
begin
  result := TCkHttp_QuickRequestParams(_map(392, 'CkHttp_QuickRequestParams'))
    (objHandle, verb, url, json);
end;

function CkHttp_QuickRequestParamsAsync (objHandle: HCkHttp; verb: PWideChar; url: PWideChar; json: HCkJsonObject): HCkTask;
begin
  result := TCkHttp_QuickRequestParamsAsync(_map(393, 'CkHttp_QuickRequestParamsAsync'))
    (objHandle, verb, url, json);
end;

procedure CkHttp_RemoveRequestHeader (objHandle: HCkHttp; name: PWideChar);
begin
  TCkHttp_RemoveRequestHeader(_map(394, 'CkHttp_RemoveRequestHeader'))
    (objHandle, name);
end;

function CkHttp_RenderGet (objHandle: HCkHttp; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_RenderGet(_map(395, 'CkHttp_RenderGet'))
    (objHandle, url, outStr);
end;

function CkHttp__renderGet (objHandle: HCkHttp; url: PWideChar): PWideChar;
begin
  result := TCkHttp__renderGet(_map(396, 'CkHttp__renderGet'))
    (objHandle, url);
end;

function CkHttp_ResumeDownload (objHandle: HCkHttp; url: PWideChar; targetFilename: PWideChar): wordbool;
begin
  result := TCkHttp_ResumeDownload(_map(397, 'CkHttp_ResumeDownload'))
    (objHandle, url, targetFilename);
end;

function CkHttp_ResumeDownloadAsync (objHandle: HCkHttp; url: PWideChar; targetFilename: PWideChar): HCkTask;
begin
  result := TCkHttp_ResumeDownloadAsync(_map(398, 'CkHttp_ResumeDownloadAsync'))
    (objHandle, url, targetFilename);
end;

function CkHttp_ResumeDownloadBd (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): wordbool;
begin
  result := TCkHttp_ResumeDownloadBd(_map(399, 'CkHttp_ResumeDownloadBd'))
    (objHandle, url, binData);
end;

function CkHttp_ResumeDownloadBdAsync (objHandle: HCkHttp; url: PWideChar; binData: HCkBinData): HCkTask;
begin
  result := TCkHttp_ResumeDownloadBdAsync(_map(400, 'CkHttp_ResumeDownloadBdAsync'))
    (objHandle, url, binData);
end;

function CkHttp_S3_CreateBucket (objHandle: HCkHttp; bucketPath: PWideChar): wordbool;
begin
  result := TCkHttp_S3_CreateBucket(_map(401, 'CkHttp_S3_CreateBucket'))
    (objHandle, bucketPath);
end;

function CkHttp_S3_CreateBucketAsync (objHandle: HCkHttp; bucketPath: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_CreateBucketAsync(_map(402, 'CkHttp_S3_CreateBucketAsync'))
    (objHandle, bucketPath);
end;

function CkHttp_S3_DeleteBucket (objHandle: HCkHttp; bucketPath: PWideChar): wordbool;
begin
  result := TCkHttp_S3_DeleteBucket(_map(403, 'CkHttp_S3_DeleteBucket'))
    (objHandle, bucketPath);
end;

function CkHttp_S3_DeleteBucketAsync (objHandle: HCkHttp; bucketPath: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_DeleteBucketAsync(_map(404, 'CkHttp_S3_DeleteBucketAsync'))
    (objHandle, bucketPath);
end;

function CkHttp_S3_DeleteMultipleObjects (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringArray): HCkHttpResponse;
begin
  result := TCkHttp_S3_DeleteMultipleObjects(_map(405, 'CkHttp_S3_DeleteMultipleObjects'))
    (objHandle, bucketName, objectNames);
end;

function CkHttp_S3_DeleteMultipleObjectsAsync (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringArray): HCkTask;
begin
  result := TCkHttp_S3_DeleteMultipleObjectsAsync(_map(406, 'CkHttp_S3_DeleteMultipleObjectsAsync'))
    (objHandle, bucketName, objectNames);
end;

function CkHttp_S3_DeleteObject (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): wordbool;
begin
  result := TCkHttp_S3_DeleteObject(_map(407, 'CkHttp_S3_DeleteObject'))
    (objHandle, bucketPath, objectName);
end;

function CkHttp_S3_DeleteObjectAsync (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_DeleteObjectAsync(_map(408, 'CkHttp_S3_DeleteObjectAsync'))
    (objHandle, bucketPath, objectName);
end;

function CkHttp_S3_DeleteObjects (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringTable; jsonResponse: HCkJsonObject): wordbool;
begin
  result := TCkHttp_S3_DeleteObjects(_map(409, 'CkHttp_S3_DeleteObjects'))
    (objHandle, bucketName, objectNames, jsonResponse);
end;

function CkHttp_S3_DeleteObjectsAsync (objHandle: HCkHttp; bucketName: PWideChar; objectNames: HCkStringTable; jsonResponse: HCkJsonObject): HCkTask;
begin
  result := TCkHttp_S3_DeleteObjectsAsync(_map(410, 'CkHttp_S3_DeleteObjectsAsync'))
    (objHandle, bucketName, objectNames, jsonResponse);
end;

function CkHttp_S3_DownloadBd (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkHttp_S3_DownloadBd(_map(411, 'CkHttp_S3_DownloadBd'))
    (objHandle, bucketPath, objectName, bd);
end;

function CkHttp_S3_DownloadBdAsync (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkHttp_S3_DownloadBdAsync(_map(412, 'CkHttp_S3_DownloadBdAsync'))
    (objHandle, bucketPath, objectName, bd);
end;

function CkHttp_S3_DownloadBytes (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkHttp_S3_DownloadBytes(_map(413, 'CkHttp_S3_DownloadBytes'))
    (objHandle, bucketPath, objectName, outData);
end;

function CkHttp_S3_DownloadBytesAsync (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_DownloadBytesAsync(_map(414, 'CkHttp_S3_DownloadBytesAsync'))
    (objHandle, bucketPath, objectName);
end;

function CkHttp_S3_DownloadFile (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkHttp_S3_DownloadFile(_map(415, 'CkHttp_S3_DownloadFile'))
    (objHandle, bucketPath, objectName, localFilePath);
end;

function CkHttp_S3_DownloadFileAsync (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_DownloadFileAsync(_map(416, 'CkHttp_S3_DownloadFileAsync'))
    (objHandle, bucketPath, objectName, localFilePath);
end;

function CkHttp_S3_DownloadString (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_S3_DownloadString(_map(417, 'CkHttp_S3_DownloadString'))
    (objHandle, bucketPath, objectName, charset, outStr);
end;

function CkHttp__s3_DownloadString (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkHttp__s3_DownloadString(_map(418, 'CkHttp__s3_DownloadString'))
    (objHandle, bucketPath, objectName, charset);
end;

function CkHttp_S3_DownloadStringAsync (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_DownloadStringAsync(_map(419, 'CkHttp_S3_DownloadStringAsync'))
    (objHandle, bucketPath, objectName, charset);
end;

function CkHttp_S3_FileExists (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): Integer;
begin
  result := TCkHttp_S3_FileExists(_map(420, 'CkHttp_S3_FileExists'))
    (objHandle, bucketPath, objectName);
end;

function CkHttp_S3_FileExistsAsync (objHandle: HCkHttp; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_FileExistsAsync(_map(421, 'CkHttp_S3_FileExistsAsync'))
    (objHandle, bucketPath, objectName);
end;

function CkHttp_S3_GenerateUrl (objHandle: HCkHttp; bucket: PWideChar; path: PWideChar; expire: HCkDateTime; outStr: HCkString): wordbool;
begin
  result := TCkHttp_S3_GenerateUrl(_map(422, 'CkHttp_S3_GenerateUrl'))
    (objHandle, bucket, path, expire, outStr);
end;

function CkHttp__s3_GenerateUrl (objHandle: HCkHttp; bucket: PWideChar; path: PWideChar; expire: HCkDateTime): PWideChar;
begin
  result := TCkHttp__s3_GenerateUrl(_map(423, 'CkHttp__s3_GenerateUrl'))
    (objHandle, bucket, path, expire);
end;

function CkHttp_S3_GenerateUrlV4 (objHandle: HCkHttp; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_S3_GenerateUrlV4(_map(424, 'CkHttp_S3_GenerateUrlV4'))
    (objHandle, useHttps, bucketName, path, numSecondsValid, awsService, outStr);
end;

function CkHttp__s3_GenerateUrlV4 (objHandle: HCkHttp; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar): PWideChar;
begin
  result := TCkHttp__s3_GenerateUrlV4(_map(425, 'CkHttp__s3_GenerateUrlV4'))
    (objHandle, useHttps, bucketName, path, numSecondsValid, awsService);
end;

function CkHttp_S3_GenPresignedUrl (objHandle: HCkHttp; httpVerb: PWideChar; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_S3_GenPresignedUrl(_map(426, 'CkHttp_S3_GenPresignedUrl'))
    (objHandle, httpVerb, useHttps, bucketName, path, numSecondsValid, awsService, outStr);
end;

function CkHttp__s3_GenPresignedUrl (objHandle: HCkHttp; httpVerb: PWideChar; useHttps: wordbool; bucketName: PWideChar; path: PWideChar; numSecondsValid: Integer; awsService: PWideChar): PWideChar;
begin
  result := TCkHttp__s3_GenPresignedUrl(_map(427, 'CkHttp__s3_GenPresignedUrl'))
    (objHandle, httpVerb, useHttps, bucketName, path, numSecondsValid, awsService);
end;

function CkHttp_S3_ListBucketObjects (objHandle: HCkHttp; bucketPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_S3_ListBucketObjects(_map(428, 'CkHttp_S3_ListBucketObjects'))
    (objHandle, bucketPath, outStr);
end;

function CkHttp__s3_ListBucketObjects (objHandle: HCkHttp; bucketPath: PWideChar): PWideChar;
begin
  result := TCkHttp__s3_ListBucketObjects(_map(429, 'CkHttp__s3_ListBucketObjects'))
    (objHandle, bucketPath);
end;

function CkHttp_S3_ListBucketObjectsAsync (objHandle: HCkHttp; bucketPath: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_ListBucketObjectsAsync(_map(430, 'CkHttp_S3_ListBucketObjectsAsync'))
    (objHandle, bucketPath);
end;

function CkHttp_S3_ListBuckets (objHandle: HCkHttp; outStr: HCkString): wordbool;
begin
  result := TCkHttp_S3_ListBuckets(_map(431, 'CkHttp_S3_ListBuckets'))
    (objHandle, outStr);
end;

function CkHttp__s3_ListBuckets (objHandle: HCkHttp): PWideChar;
begin
  result := TCkHttp__s3_ListBuckets(_map(432, 'CkHttp__s3_ListBuckets'))
    (objHandle);
end;

function CkHttp_S3_ListBucketsAsync (objHandle: HCkHttp): HCkTask;
begin
  result := TCkHttp_S3_ListBucketsAsync(_map(433, 'CkHttp_S3_ListBucketsAsync'))
    (objHandle);
end;

function CkHttp_S3_UploadBd (objHandle: HCkHttp; bd: HCkBinData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
begin
  result := TCkHttp_S3_UploadBd(_map(434, 'CkHttp_S3_UploadBd'))
    (objHandle, bd, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadBdAsync (objHandle: HCkHttp; bd: HCkBinData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_UploadBdAsync(_map(435, 'CkHttp_S3_UploadBdAsync'))
    (objHandle, bd, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadBytes (objHandle: HCkHttp; contentBytes: HCkByteData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
begin
  result := TCkHttp_S3_UploadBytes(_map(436, 'CkHttp_S3_UploadBytes'))
    (objHandle, contentBytes, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadBytesAsync (objHandle: HCkHttp; contentBytes: HCkByteData; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_UploadBytesAsync(_map(437, 'CkHttp_S3_UploadBytesAsync'))
    (objHandle, contentBytes, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadFile (objHandle: HCkHttp; localFilePath: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
begin
  result := TCkHttp_S3_UploadFile(_map(438, 'CkHttp_S3_UploadFile'))
    (objHandle, localFilePath, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadFileAsync (objHandle: HCkHttp; localFilePath: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_UploadFileAsync(_map(439, 'CkHttp_S3_UploadFileAsync'))
    (objHandle, localFilePath, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadString (objHandle: HCkHttp; objectContent: PWideChar; charset: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): wordbool;
begin
  result := TCkHttp_S3_UploadString(_map(440, 'CkHttp_S3_UploadString'))
    (objHandle, objectContent, charset, contentType, bucketPath, objectName);
end;

function CkHttp_S3_UploadStringAsync (objHandle: HCkHttp; objectContent: PWideChar; charset: PWideChar; contentType: PWideChar; bucketPath: PWideChar; objectName: PWideChar): HCkTask;
begin
  result := TCkHttp_S3_UploadStringAsync(_map(441, 'CkHttp_S3_UploadStringAsync'))
    (objHandle, objectContent, charset, contentType, bucketPath, objectName);
end;

function CkHttp_SetAuthPrivateKey (objHandle: HCkHttp; publicKeyId: PWideChar; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkHttp_SetAuthPrivateKey(_map(442, 'CkHttp_SetAuthPrivateKey'))
    (objHandle, publicKeyId, privKey);
end;

function CkHttp_SetAuthTokenSb (objHandle: HCkHttp; sb: HCkStringBuilder): wordbool;
begin
  result := TCkHttp_SetAuthTokenSb(_map(443, 'CkHttp_SetAuthTokenSb'))
    (objHandle, sb);
end;

function CkHttp_SetCookieXml (objHandle: HCkHttp; domain: PWideChar; cookieXml: PWideChar): wordbool;
begin
  result := TCkHttp_SetCookieXml(_map(444, 'CkHttp_SetCookieXml'))
    (objHandle, domain, cookieXml);
end;

function CkHttp_SetOAuthRsaKey (objHandle: HCkHttp; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkHttp_SetOAuthRsaKey(_map(445, 'CkHttp_SetOAuthRsaKey'))
    (objHandle, privKey);
end;

procedure CkHttp_SetRequestHeader (objHandle: HCkHttp; headerFieldName: PWideChar; headerFieldValue: PWideChar);
begin
  TCkHttp_SetRequestHeader(_map(446, 'CkHttp_SetRequestHeader'))
    (objHandle, headerFieldName, headerFieldValue);
end;

function CkHttp_SetSecurePassword (objHandle: HCkHttp; password: HCkSecureString): wordbool;
begin
  result := TCkHttp_SetSecurePassword(_map(447, 'CkHttp_SetSecurePassword'))
    (objHandle, password);
end;

procedure CkHttp_SetSslCertRequirement (objHandle: HCkHttp; reqName: PWideChar; reqValue: PWideChar);
begin
  TCkHttp_SetSslCertRequirement(_map(448, 'CkHttp_SetSslCertRequirement'))
    (objHandle, reqName, reqValue);
end;

function CkHttp_SetSslClientCert (objHandle: HCkHttp; cert: HCkCert): wordbool;
begin
  result := TCkHttp_SetSslClientCert(_map(449, 'CkHttp_SetSslClientCert'))
    (objHandle, cert);
end;

function CkHttp_SetSslClientCertPem (objHandle: HCkHttp; pemDataOrPath: PWideChar; pemPassword: PWideChar): wordbool;
begin
  result := TCkHttp_SetSslClientCertPem(_map(450, 'CkHttp_SetSslClientCertPem'))
    (objHandle, pemDataOrPath, pemPassword);
end;

function CkHttp_SetSslClientCertPfx (objHandle: HCkHttp; pfxPath: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkHttp_SetSslClientCertPfx(_map(451, 'CkHttp_SetSslClientCertPfx'))
    (objHandle, pfxPath, pfxPassword);
end;

function CkHttp_SetUrlVar (objHandle: HCkHttp; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkHttp_SetUrlVar(_map(452, 'CkHttp_SetUrlVar'))
    (objHandle, name, value);
end;

function CkHttp_SharePointOnlineAuth (objHandle: HCkHttp; siteUrl: PWideChar; username: PWideChar; password: HCkSecureString; extraInfo: HCkJsonObject): wordbool;
begin
  result := TCkHttp_SharePointOnlineAuth(_map(453, 'CkHttp_SharePointOnlineAuth'))
    (objHandle, siteUrl, username, password, extraInfo);
end;

function CkHttp_SharePointOnlineAuthAsync (objHandle: HCkHttp; siteUrl: PWideChar; username: PWideChar; password: HCkSecureString; extraInfo: HCkJsonObject): HCkTask;
begin
  result := TCkHttp_SharePointOnlineAuthAsync(_map(454, 'CkHttp_SharePointOnlineAuthAsync'))
    (objHandle, siteUrl, username, password, extraInfo);
end;

procedure CkHttp_SleepMs (objHandle: HCkHttp; millisec: Integer);
begin
  TCkHttp_SleepMs(_map(455, 'CkHttp_SleepMs'))
    (objHandle, millisec);
end;

function CkHttp_SynchronousRequest (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; req: HCkHttpRequest): HCkHttpResponse;
begin
  result := TCkHttp_SynchronousRequest(_map(456, 'CkHttp_SynchronousRequest'))
    (objHandle, domain, port, ssl, req);
end;

function CkHttp_SynchronousRequestAsync (objHandle: HCkHttp; domain: PWideChar; port: Integer; ssl: wordbool; req: HCkHttpRequest): HCkTask;
begin
  result := TCkHttp_SynchronousRequestAsync(_map(457, 'CkHttp_SynchronousRequestAsync'))
    (objHandle, domain, port, ssl, req);
end;

function CkHttp_UrlDecode (objHandle: HCkHttp; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_UrlDecode(_map(458, 'CkHttp_UrlDecode'))
    (objHandle, str, outStr);
end;

function CkHttp__urlDecode (objHandle: HCkHttp; str: PWideChar): PWideChar;
begin
  result := TCkHttp__urlDecode(_map(459, 'CkHttp__urlDecode'))
    (objHandle, str);
end;

function CkHttp_UrlEncode (objHandle: HCkHttp; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_UrlEncode(_map(460, 'CkHttp_UrlEncode'))
    (objHandle, str, outStr);
end;

function CkHttp__urlEncode (objHandle: HCkHttp; str: PWideChar): PWideChar;
begin
  result := TCkHttp__urlEncode(_map(461, 'CkHttp__urlEncode'))
    (objHandle, str);
end;

function CkHttp_VerifyTimestampReply (objHandle: HCkHttp; timestampReply: HCkBinData; tsaCert: HCkCert): Integer;
begin
  result := TCkHttp_VerifyTimestampReply(_map(462, 'CkHttp_VerifyTimestampReply'))
    (objHandle, timestampReply, tsaCert);
end;

function CkHttp_XmlRpc (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_XmlRpc(_map(463, 'CkHttp_XmlRpc'))
    (objHandle, urlEndpoint, xmlIn, outStr);
end;

function CkHttp__xmlRpc (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): PWideChar;
begin
  result := TCkHttp__xmlRpc(_map(464, 'CkHttp__xmlRpc'))
    (objHandle, urlEndpoint, xmlIn);
end;

function CkHttp_XmlRpcAsync (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): HCkTask;
begin
  result := TCkHttp_XmlRpcAsync(_map(465, 'CkHttp_XmlRpcAsync'))
    (objHandle, urlEndpoint, xmlIn);
end;

function CkHttp_XmlRpcPut (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttp_XmlRpcPut(_map(466, 'CkHttp_XmlRpcPut'))
    (objHandle, urlEndpoint, xmlIn, outStr);
end;

function CkHttp__xmlRpcPut (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): PWideChar;
begin
  result := TCkHttp__xmlRpcPut(_map(467, 'CkHttp__xmlRpcPut'))
    (objHandle, urlEndpoint, xmlIn);
end;

function CkHttp_XmlRpcPutAsync (objHandle: HCkHttp; urlEndpoint: PWideChar; xmlIn: PWideChar): HCkTask;
begin
  result := TCkHttp_XmlRpcPutAsync(_map(468, 'CkHttp_XmlRpcPutAsync'))
    (objHandle, urlEndpoint, xmlIn);
end;

end.
