unit HttpRequest;

interface

type

HCkBinData = Pointer;
HCkStringBuilder = Pointer;
HCkByteData = Pointer;
HCkHttpRequest = Pointer;
HCkString = Pointer;


function CkHttpRequest_Create: HCkHttpRequest;  stdcall;
procedure CkHttpRequest_Dispose(handle: HCkHttpRequest); stdcall;
procedure CkHttpRequest_getBoundary(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putBoundary(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__boundary(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getCharset(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putCharset(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__charset(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getContentType(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putContentType(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__contentType(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getDebugLogFilePath(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putDebugLogFilePath(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__debugLogFilePath(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getEntireHeader(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putEntireHeader(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__entireHeader(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getHttpVerb(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putHttpVerb(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__httpVerb(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getHttpVersion(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putHttpVersion(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__httpVersion(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getLastErrorHtml(objHandle: HCkHttpRequest; outPropVal: HCkString);
function CkHttpRequest__lastErrorHtml(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getLastErrorText(objHandle: HCkHttpRequest; outPropVal: HCkString);
function CkHttpRequest__lastErrorText(objHandle: HCkHttpRequest): PWideChar;
procedure CkHttpRequest_getLastErrorXml(objHandle: HCkHttpRequest; outPropVal: HCkString);
function CkHttpRequest__lastErrorXml(objHandle: HCkHttpRequest): PWideChar;
function CkHttpRequest_getLastMethodSuccess(objHandle: HCkHttpRequest): wordbool;
procedure CkHttpRequest_putLastMethodSuccess(objHandle: HCkHttpRequest; newPropVal: wordbool);
function CkHttpRequest_getNumHeaderFields(objHandle: HCkHttpRequest): Integer;
function CkHttpRequest_getNumParams(objHandle: HCkHttpRequest): Integer;
procedure CkHttpRequest_getPath(objHandle: HCkHttpRequest; outPropVal: HCkString);
procedure CkHttpRequest_putPath(objHandle: HCkHttpRequest; newPropVal: PWideChar);
function CkHttpRequest__path(objHandle: HCkHttpRequest): PWideChar;
function CkHttpRequest_getSendCharset(objHandle: HCkHttpRequest): wordbool;
procedure CkHttpRequest_putSendCharset(objHandle: HCkHttpRequest; newPropVal: wordbool);
function CkHttpRequest_getVerboseLogging(objHandle: HCkHttpRequest): wordbool;
procedure CkHttpRequest_putVerboseLogging(objHandle: HCkHttpRequest; newPropVal: wordbool);
procedure CkHttpRequest_getVersion(objHandle: HCkHttpRequest; outPropVal: HCkString);
function CkHttpRequest__version(objHandle: HCkHttpRequest): PWideChar;
function CkHttpRequest_AddBdForUpload(objHandle: HCkHttpRequest; name: PWideChar; remoteFilename: PWideChar; byteData: HCkBinData; contentType: PWideChar): wordbool;
function CkHttpRequest_AddBytesForUpload(objHandle: HCkHttpRequest; name: PWideChar; remoteFileName: PWideChar; byteData: HCkByteData): wordbool;
function CkHttpRequest_AddBytesForUpload2(objHandle: HCkHttpRequest; name: PWideChar; remoteFileName: PWideChar; byteData: HCkByteData; contentType: PWideChar): wordbool;
function CkHttpRequest_AddFileForUpload(objHandle: HCkHttpRequest; name: PWideChar; filePath: PWideChar): wordbool;
function CkHttpRequest_AddFileForUpload2(objHandle: HCkHttpRequest; name: PWideChar; filePath: PWideChar; contentType: PWideChar): wordbool;
procedure CkHttpRequest_AddHeader(objHandle: HCkHttpRequest; name: PWideChar; value: PWideChar);
function CkHttpRequest_AddMwsSignature(objHandle: HCkHttpRequest; domain: PWideChar; mwsSecretKey: PWideChar): wordbool;
procedure CkHttpRequest_AddParam(objHandle: HCkHttpRequest; name: PWideChar; value: PWideChar);
function CkHttpRequest_AddStringForUpload(objHandle: HCkHttpRequest; name: PWideChar; filename: PWideChar; strData: PWideChar; charset: PWideChar): wordbool;
function CkHttpRequest_AddStringForUpload2(objHandle: HCkHttpRequest; name: PWideChar; filename: PWideChar; strData: PWideChar; charset: PWideChar; contentType: PWideChar): wordbool;
function CkHttpRequest_AddSubHeader(objHandle: HCkHttpRequest; index: Integer; name: PWideChar; value: PWideChar): wordbool;
function CkHttpRequest_GenerateRequestFile(objHandle: HCkHttpRequest; path: PWideChar): wordbool;
function CkHttpRequest_GenerateRequestText(objHandle: HCkHttpRequest; outStr: HCkString): wordbool;
function CkHttpRequest__generateRequestText(objHandle: HCkHttpRequest): PWideChar;
function CkHttpRequest_GetHeaderField(objHandle: HCkHttpRequest; name: PWideChar; outStr: HCkString): wordbool;
function CkHttpRequest__getHeaderField(objHandle: HCkHttpRequest; name: PWideChar): PWideChar;
function CkHttpRequest_GetHeaderName(objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
function CkHttpRequest__getHeaderName(objHandle: HCkHttpRequest; index: Integer): PWideChar;
function CkHttpRequest_GetHeaderValue(objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
function CkHttpRequest__getHeaderValue(objHandle: HCkHttpRequest; index: Integer): PWideChar;
function CkHttpRequest_GetParam(objHandle: HCkHttpRequest; name: PWideChar; outStr: HCkString): wordbool;
function CkHttpRequest__getParam(objHandle: HCkHttpRequest; name: PWideChar): PWideChar;
function CkHttpRequest_GetParamName(objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
function CkHttpRequest__getParamName(objHandle: HCkHttpRequest; index: Integer): PWideChar;
function CkHttpRequest_GetParamValue(objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
function CkHttpRequest__getParamValue(objHandle: HCkHttpRequest; index: Integer): PWideChar;
function CkHttpRequest_GetUrlEncodedParams(objHandle: HCkHttpRequest; outStr: HCkString): wordbool;
function CkHttpRequest__getUrlEncodedParams(objHandle: HCkHttpRequest): PWideChar;
function CkHttpRequest_LoadBodyFromBd(objHandle: HCkHttpRequest; requestBody: HCkBinData): wordbool;
function CkHttpRequest_LoadBodyFromBytes(objHandle: HCkHttpRequest; byteData: HCkByteData): wordbool;
function CkHttpRequest_LoadBodyFromFile(objHandle: HCkHttpRequest; filePath: PWideChar): wordbool;
function CkHttpRequest_LoadBodyFromSb(objHandle: HCkHttpRequest; requestBody: HCkStringBuilder; charset: PWideChar): wordbool;
function CkHttpRequest_LoadBodyFromString(objHandle: HCkHttpRequest; bodyStr: PWideChar; charset: PWideChar): wordbool;
procedure CkHttpRequest_RemoveAllParams(objHandle: HCkHttpRequest);
function CkHttpRequest_RemoveHeader(objHandle: HCkHttpRequest; name: PWideChar): wordbool;
procedure CkHttpRequest_RemoveParam(objHandle: HCkHttpRequest; name: PWideChar);
procedure CkHttpRequest_SetFromUrl(objHandle: HCkHttpRequest; url: PWideChar);
function CkHttpRequest_StreamBodyFromFile(objHandle: HCkHttpRequest; filePath: PWideChar): wordbool;
function CkHttpRequest_StreamChunkFromFile(objHandle: HCkHttpRequest; path: PWideChar; offset: PWideChar; numBytes: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkHttpRequest_Create = function : HCkHttpRequest; stdcall;
  TCkHttpRequest_Dispose = procedure (handle: HCkHttpRequest); stdcall;
  TCkHttpRequest_getBoundary = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putBoundary = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__boundary = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getCharset = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putCharset = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__charset = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getContentType = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putContentType = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__contentType = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getDebugLogFilePath = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putDebugLogFilePath = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__debugLogFilePath = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getEntireHeader = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putEntireHeader = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__entireHeader = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getHttpVerb = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putHttpVerb = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__httpVerb = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getHttpVersion = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putHttpVersion = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__httpVersion = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getLastErrorHtml = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest__lastErrorHtml = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getLastErrorText = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest__lastErrorText = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getLastErrorXml = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest__lastErrorXml = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getLastMethodSuccess = function (objHandle: HCkHttpRequest): wordbool; stdcall;
  TCkHttpRequest_putLastMethodSuccess = procedure (objHandle: HCkHttpRequest; newPropVal: wordbool); stdcall;
  TCkHttpRequest_getNumHeaderFields = function (objHandle: HCkHttpRequest): Integer; stdcall;
  TCkHttpRequest_getNumParams = function (objHandle: HCkHttpRequest): Integer; stdcall;
  TCkHttpRequest_getPath = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest_putPath = procedure (objHandle: HCkHttpRequest; newPropVal: PWideChar); stdcall;
  TCkHttpRequest__path = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_getSendCharset = function (objHandle: HCkHttpRequest): wordbool; stdcall;
  TCkHttpRequest_putSendCharset = procedure (objHandle: HCkHttpRequest; newPropVal: wordbool); stdcall;
  TCkHttpRequest_getVerboseLogging = function (objHandle: HCkHttpRequest): wordbool; stdcall;
  TCkHttpRequest_putVerboseLogging = procedure (objHandle: HCkHttpRequest; newPropVal: wordbool); stdcall;
  TCkHttpRequest_getVersion = procedure (objHandle: HCkHttpRequest; outPropVal: HCkString); stdcall;
  TCkHttpRequest__version = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_AddBdForUpload = function (objHandle: HCkHttpRequest; name: PWideChar; remoteFilename: PWideChar; byteData: HCkBinData; contentType: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddBytesForUpload = function (objHandle: HCkHttpRequest; name: PWideChar; remoteFileName: PWideChar; byteData: HCkByteData): wordbool; stdcall;
  TCkHttpRequest_AddBytesForUpload2 = function (objHandle: HCkHttpRequest; name: PWideChar; remoteFileName: PWideChar; byteData: HCkByteData; contentType: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddFileForUpload = function (objHandle: HCkHttpRequest; name: PWideChar; filePath: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddFileForUpload2 = function (objHandle: HCkHttpRequest; name: PWideChar; filePath: PWideChar; contentType: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddHeader = procedure (objHandle: HCkHttpRequest; name: PWideChar; value: PWideChar); stdcall;
  TCkHttpRequest_AddMwsSignature = function (objHandle: HCkHttpRequest; domain: PWideChar; mwsSecretKey: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddParam = procedure (objHandle: HCkHttpRequest; name: PWideChar; value: PWideChar); stdcall;
  TCkHttpRequest_AddStringForUpload = function (objHandle: HCkHttpRequest; name: PWideChar; filename: PWideChar; strData: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddStringForUpload2 = function (objHandle: HCkHttpRequest; name: PWideChar; filename: PWideChar; strData: PWideChar; charset: PWideChar; contentType: PWideChar): wordbool; stdcall;
  TCkHttpRequest_AddSubHeader = function (objHandle: HCkHttpRequest; index: Integer; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkHttpRequest_GenerateRequestFile = function (objHandle: HCkHttpRequest; path: PWideChar): wordbool; stdcall;
  TCkHttpRequest_GenerateRequestText = function (objHandle: HCkHttpRequest; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__generateRequestText = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_GetHeaderField = function (objHandle: HCkHttpRequest; name: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getHeaderField = function (objHandle: HCkHttpRequest; name: PWideChar): PWideChar; stdcall;
  TCkHttpRequest_GetHeaderName = function (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getHeaderName = function (objHandle: HCkHttpRequest; index: Integer): PWideChar; stdcall;
  TCkHttpRequest_GetHeaderValue = function (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getHeaderValue = function (objHandle: HCkHttpRequest; index: Integer): PWideChar; stdcall;
  TCkHttpRequest_GetParam = function (objHandle: HCkHttpRequest; name: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getParam = function (objHandle: HCkHttpRequest; name: PWideChar): PWideChar; stdcall;
  TCkHttpRequest_GetParamName = function (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getParamName = function (objHandle: HCkHttpRequest; index: Integer): PWideChar; stdcall;
  TCkHttpRequest_GetParamValue = function (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getParamValue = function (objHandle: HCkHttpRequest; index: Integer): PWideChar; stdcall;
  TCkHttpRequest_GetUrlEncodedParams = function (objHandle: HCkHttpRequest; outStr: HCkString): wordbool; stdcall;
  TCkHttpRequest__getUrlEncodedParams = function (objHandle: HCkHttpRequest): PWideChar; stdcall;
  TCkHttpRequest_LoadBodyFromBd = function (objHandle: HCkHttpRequest; requestBody: HCkBinData): wordbool; stdcall;
  TCkHttpRequest_LoadBodyFromBytes = function (objHandle: HCkHttpRequest; byteData: HCkByteData): wordbool; stdcall;
  TCkHttpRequest_LoadBodyFromFile = function (objHandle: HCkHttpRequest; filePath: PWideChar): wordbool; stdcall;
  TCkHttpRequest_LoadBodyFromSb = function (objHandle: HCkHttpRequest; requestBody: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkHttpRequest_LoadBodyFromString = function (objHandle: HCkHttpRequest; bodyStr: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkHttpRequest_RemoveAllParams = procedure (objHandle: HCkHttpRequest); stdcall;
  TCkHttpRequest_RemoveHeader = function (objHandle: HCkHttpRequest; name: PWideChar): wordbool; stdcall;
  TCkHttpRequest_RemoveParam = procedure (objHandle: HCkHttpRequest; name: PWideChar); stdcall;
  TCkHttpRequest_SetFromUrl = procedure (objHandle: HCkHttpRequest; url: PWideChar); stdcall;
  TCkHttpRequest_StreamBodyFromFile = function (objHandle: HCkHttpRequest; filePath: PWideChar): wordbool; stdcall;
  TCkHttpRequest_StreamChunkFromFile = function (objHandle: HCkHttpRequest; path: PWideChar; offset: PWideChar; numBytes: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..80] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkHttpRequest_Create : HCkHttpRequest;
begin
  result := TCkHttpRequest_Create(_map(0, 'CkHttpRequest_Create'));
end;

procedure CkHttpRequest_Dispose (handle: HCkHttpRequest);
begin
  TCkHttpRequest_Dispose(_map(1, 'CkHttpRequest_Dispose'))
    (handle);
end;


procedure CkHttpRequest_getBoundary (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getBoundary(_map(2, 'CkHttpRequest_getBoundary'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putBoundary (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putBoundary(_map(3, 'CkHttpRequest_putBoundary'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__boundary (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__boundary(_map(4, 'CkHttpRequest__boundary'))
    (objHandle);
end;

procedure CkHttpRequest_getCharset (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getCharset(_map(5, 'CkHttpRequest_getCharset'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putCharset (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putCharset(_map(6, 'CkHttpRequest_putCharset'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__charset (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__charset(_map(7, 'CkHttpRequest__charset'))
    (objHandle);
end;

procedure CkHttpRequest_getContentType (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getContentType(_map(8, 'CkHttpRequest_getContentType'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putContentType (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putContentType(_map(9, 'CkHttpRequest_putContentType'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__contentType (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__contentType(_map(10, 'CkHttpRequest__contentType'))
    (objHandle);
end;

procedure CkHttpRequest_getDebugLogFilePath (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getDebugLogFilePath(_map(11, 'CkHttpRequest_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putDebugLogFilePath (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putDebugLogFilePath(_map(12, 'CkHttpRequest_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__debugLogFilePath (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__debugLogFilePath(_map(13, 'CkHttpRequest__debugLogFilePath'))
    (objHandle);
end;

procedure CkHttpRequest_getEntireHeader (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getEntireHeader(_map(14, 'CkHttpRequest_getEntireHeader'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putEntireHeader (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putEntireHeader(_map(15, 'CkHttpRequest_putEntireHeader'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__entireHeader (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__entireHeader(_map(16, 'CkHttpRequest__entireHeader'))
    (objHandle);
end;

procedure CkHttpRequest_getHttpVerb (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getHttpVerb(_map(17, 'CkHttpRequest_getHttpVerb'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putHttpVerb (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putHttpVerb(_map(18, 'CkHttpRequest_putHttpVerb'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__httpVerb (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__httpVerb(_map(19, 'CkHttpRequest__httpVerb'))
    (objHandle);
end;

procedure CkHttpRequest_getHttpVersion (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getHttpVersion(_map(20, 'CkHttpRequest_getHttpVersion'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putHttpVersion (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putHttpVersion(_map(21, 'CkHttpRequest_putHttpVersion'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__httpVersion (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__httpVersion(_map(22, 'CkHttpRequest__httpVersion'))
    (objHandle);
end;

procedure CkHttpRequest_getLastErrorHtml (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getLastErrorHtml(_map(23, 'CkHttpRequest_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkHttpRequest__lastErrorHtml (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__lastErrorHtml(_map(24, 'CkHttpRequest__lastErrorHtml'))
    (objHandle);
end;

procedure CkHttpRequest_getLastErrorText (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getLastErrorText(_map(25, 'CkHttpRequest_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkHttpRequest__lastErrorText (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__lastErrorText(_map(26, 'CkHttpRequest__lastErrorText'))
    (objHandle);
end;

procedure CkHttpRequest_getLastErrorXml (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getLastErrorXml(_map(27, 'CkHttpRequest_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkHttpRequest__lastErrorXml (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__lastErrorXml(_map(28, 'CkHttpRequest__lastErrorXml'))
    (objHandle);
end;

function CkHttpRequest_getLastMethodSuccess (objHandle: HCkHttpRequest): wordbool;
begin
    result := TCkHttpRequest_getLastMethodSuccess(_map(29, 'CkHttpRequest_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkHttpRequest_putLastMethodSuccess (objHandle: HCkHttpRequest; newPropVal: wordbool);
begin
  TCkHttpRequest_putLastMethodSuccess(_map(30, 'CkHttpRequest_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkHttpRequest_getNumHeaderFields (objHandle: HCkHttpRequest): Integer;
begin
    result := TCkHttpRequest_getNumHeaderFields(_map(31, 'CkHttpRequest_getNumHeaderFields'))
    (objHandle);
end;

function CkHttpRequest_getNumParams (objHandle: HCkHttpRequest): Integer;
begin
    result := TCkHttpRequest_getNumParams(_map(32, 'CkHttpRequest_getNumParams'))
    (objHandle);
end;

procedure CkHttpRequest_getPath (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getPath(_map(33, 'CkHttpRequest_getPath'))
    (objHandle, outPropVal);
end;

procedure CkHttpRequest_putPath (objHandle: HCkHttpRequest; newPropVal: PWideChar);
begin
  TCkHttpRequest_putPath(_map(34, 'CkHttpRequest_putPath'))
    (objHandle, newPropVal);
end;

function CkHttpRequest__path (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__path(_map(35, 'CkHttpRequest__path'))
    (objHandle);
end;

function CkHttpRequest_getSendCharset (objHandle: HCkHttpRequest): wordbool;
begin
    result := TCkHttpRequest_getSendCharset(_map(36, 'CkHttpRequest_getSendCharset'))
    (objHandle);
end;

procedure CkHttpRequest_putSendCharset (objHandle: HCkHttpRequest; newPropVal: wordbool);
begin
  TCkHttpRequest_putSendCharset(_map(37, 'CkHttpRequest_putSendCharset'))
    (objHandle, newPropVal);
end;

function CkHttpRequest_getVerboseLogging (objHandle: HCkHttpRequest): wordbool;
begin
    result := TCkHttpRequest_getVerboseLogging(_map(38, 'CkHttpRequest_getVerboseLogging'))
    (objHandle);
end;

procedure CkHttpRequest_putVerboseLogging (objHandle: HCkHttpRequest; newPropVal: wordbool);
begin
  TCkHttpRequest_putVerboseLogging(_map(39, 'CkHttpRequest_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkHttpRequest_getVersion (objHandle: HCkHttpRequest; outPropVal: HCkString);
begin
  TCkHttpRequest_getVersion(_map(40, 'CkHttpRequest_getVersion'))
    (objHandle, outPropVal);
end;

function CkHttpRequest__version (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__version(_map(41, 'CkHttpRequest__version'))
    (objHandle);
end;

function CkHttpRequest_AddBdForUpload (objHandle: HCkHttpRequest; name: PWideChar; remoteFilename: PWideChar; byteData: HCkBinData; contentType: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddBdForUpload(_map(42, 'CkHttpRequest_AddBdForUpload'))
    (objHandle, name, remoteFilename, byteData, contentType);
end;

function CkHttpRequest_AddBytesForUpload (objHandle: HCkHttpRequest; name: PWideChar; remoteFileName: PWideChar; byteData: HCkByteData): wordbool;
begin
  result := TCkHttpRequest_AddBytesForUpload(_map(43, 'CkHttpRequest_AddBytesForUpload'))
    (objHandle, name, remoteFileName, byteData);
end;

function CkHttpRequest_AddBytesForUpload2 (objHandle: HCkHttpRequest; name: PWideChar; remoteFileName: PWideChar; byteData: HCkByteData; contentType: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddBytesForUpload2(_map(44, 'CkHttpRequest_AddBytesForUpload2'))
    (objHandle, name, remoteFileName, byteData, contentType);
end;

function CkHttpRequest_AddFileForUpload (objHandle: HCkHttpRequest; name: PWideChar; filePath: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddFileForUpload(_map(45, 'CkHttpRequest_AddFileForUpload'))
    (objHandle, name, filePath);
end;

function CkHttpRequest_AddFileForUpload2 (objHandle: HCkHttpRequest; name: PWideChar; filePath: PWideChar; contentType: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddFileForUpload2(_map(46, 'CkHttpRequest_AddFileForUpload2'))
    (objHandle, name, filePath, contentType);
end;

procedure CkHttpRequest_AddHeader (objHandle: HCkHttpRequest; name: PWideChar; value: PWideChar);
begin
  TCkHttpRequest_AddHeader(_map(47, 'CkHttpRequest_AddHeader'))
    (objHandle, name, value);
end;

function CkHttpRequest_AddMwsSignature (objHandle: HCkHttpRequest; domain: PWideChar; mwsSecretKey: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddMwsSignature(_map(48, 'CkHttpRequest_AddMwsSignature'))
    (objHandle, domain, mwsSecretKey);
end;

procedure CkHttpRequest_AddParam (objHandle: HCkHttpRequest; name: PWideChar; value: PWideChar);
begin
  TCkHttpRequest_AddParam(_map(49, 'CkHttpRequest_AddParam'))
    (objHandle, name, value);
end;

function CkHttpRequest_AddStringForUpload (objHandle: HCkHttpRequest; name: PWideChar; filename: PWideChar; strData: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddStringForUpload(_map(50, 'CkHttpRequest_AddStringForUpload'))
    (objHandle, name, filename, strData, charset);
end;

function CkHttpRequest_AddStringForUpload2 (objHandle: HCkHttpRequest; name: PWideChar; filename: PWideChar; strData: PWideChar; charset: PWideChar; contentType: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddStringForUpload2(_map(51, 'CkHttpRequest_AddStringForUpload2'))
    (objHandle, name, filename, strData, charset, contentType);
end;

function CkHttpRequest_AddSubHeader (objHandle: HCkHttpRequest; index: Integer; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkHttpRequest_AddSubHeader(_map(52, 'CkHttpRequest_AddSubHeader'))
    (objHandle, index, name, value);
end;

function CkHttpRequest_GenerateRequestFile (objHandle: HCkHttpRequest; path: PWideChar): wordbool;
begin
  result := TCkHttpRequest_GenerateRequestFile(_map(53, 'CkHttpRequest_GenerateRequestFile'))
    (objHandle, path);
end;

function CkHttpRequest_GenerateRequestText (objHandle: HCkHttpRequest; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GenerateRequestText(_map(54, 'CkHttpRequest_GenerateRequestText'))
    (objHandle, outStr);
end;

function CkHttpRequest__generateRequestText (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__generateRequestText(_map(55, 'CkHttpRequest__generateRequestText'))
    (objHandle);
end;

function CkHttpRequest_GetHeaderField (objHandle: HCkHttpRequest; name: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetHeaderField(_map(56, 'CkHttpRequest_GetHeaderField'))
    (objHandle, name, outStr);
end;

function CkHttpRequest__getHeaderField (objHandle: HCkHttpRequest; name: PWideChar): PWideChar;
begin
  result := TCkHttpRequest__getHeaderField(_map(57, 'CkHttpRequest__getHeaderField'))
    (objHandle, name);
end;

function CkHttpRequest_GetHeaderName (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetHeaderName(_map(58, 'CkHttpRequest_GetHeaderName'))
    (objHandle, index, outStr);
end;

function CkHttpRequest__getHeaderName (objHandle: HCkHttpRequest; index: Integer): PWideChar;
begin
  result := TCkHttpRequest__getHeaderName(_map(59, 'CkHttpRequest__getHeaderName'))
    (objHandle, index);
end;

function CkHttpRequest_GetHeaderValue (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetHeaderValue(_map(60, 'CkHttpRequest_GetHeaderValue'))
    (objHandle, index, outStr);
end;

function CkHttpRequest__getHeaderValue (objHandle: HCkHttpRequest; index: Integer): PWideChar;
begin
  result := TCkHttpRequest__getHeaderValue(_map(61, 'CkHttpRequest__getHeaderValue'))
    (objHandle, index);
end;

function CkHttpRequest_GetParam (objHandle: HCkHttpRequest; name: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetParam(_map(62, 'CkHttpRequest_GetParam'))
    (objHandle, name, outStr);
end;

function CkHttpRequest__getParam (objHandle: HCkHttpRequest; name: PWideChar): PWideChar;
begin
  result := TCkHttpRequest__getParam(_map(63, 'CkHttpRequest__getParam'))
    (objHandle, name);
end;

function CkHttpRequest_GetParamName (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetParamName(_map(64, 'CkHttpRequest_GetParamName'))
    (objHandle, index, outStr);
end;

function CkHttpRequest__getParamName (objHandle: HCkHttpRequest; index: Integer): PWideChar;
begin
  result := TCkHttpRequest__getParamName(_map(65, 'CkHttpRequest__getParamName'))
    (objHandle, index);
end;

function CkHttpRequest_GetParamValue (objHandle: HCkHttpRequest; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetParamValue(_map(66, 'CkHttpRequest_GetParamValue'))
    (objHandle, index, outStr);
end;

function CkHttpRequest__getParamValue (objHandle: HCkHttpRequest; index: Integer): PWideChar;
begin
  result := TCkHttpRequest__getParamValue(_map(67, 'CkHttpRequest__getParamValue'))
    (objHandle, index);
end;

function CkHttpRequest_GetUrlEncodedParams (objHandle: HCkHttpRequest; outStr: HCkString): wordbool;
begin
  result := TCkHttpRequest_GetUrlEncodedParams(_map(68, 'CkHttpRequest_GetUrlEncodedParams'))
    (objHandle, outStr);
end;

function CkHttpRequest__getUrlEncodedParams (objHandle: HCkHttpRequest): PWideChar;
begin
  result := TCkHttpRequest__getUrlEncodedParams(_map(69, 'CkHttpRequest__getUrlEncodedParams'))
    (objHandle);
end;

function CkHttpRequest_LoadBodyFromBd (objHandle: HCkHttpRequest; requestBody: HCkBinData): wordbool;
begin
  result := TCkHttpRequest_LoadBodyFromBd(_map(70, 'CkHttpRequest_LoadBodyFromBd'))
    (objHandle, requestBody);
end;

function CkHttpRequest_LoadBodyFromBytes (objHandle: HCkHttpRequest; byteData: HCkByteData): wordbool;
begin
  result := TCkHttpRequest_LoadBodyFromBytes(_map(71, 'CkHttpRequest_LoadBodyFromBytes'))
    (objHandle, byteData);
end;

function CkHttpRequest_LoadBodyFromFile (objHandle: HCkHttpRequest; filePath: PWideChar): wordbool;
begin
  result := TCkHttpRequest_LoadBodyFromFile(_map(72, 'CkHttpRequest_LoadBodyFromFile'))
    (objHandle, filePath);
end;

function CkHttpRequest_LoadBodyFromSb (objHandle: HCkHttpRequest; requestBody: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkHttpRequest_LoadBodyFromSb(_map(73, 'CkHttpRequest_LoadBodyFromSb'))
    (objHandle, requestBody, charset);
end;

function CkHttpRequest_LoadBodyFromString (objHandle: HCkHttpRequest; bodyStr: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkHttpRequest_LoadBodyFromString(_map(74, 'CkHttpRequest_LoadBodyFromString'))
    (objHandle, bodyStr, charset);
end;

procedure CkHttpRequest_RemoveAllParams (objHandle: HCkHttpRequest);
begin
  TCkHttpRequest_RemoveAllParams(_map(75, 'CkHttpRequest_RemoveAllParams'))
    (objHandle);
end;

function CkHttpRequest_RemoveHeader (objHandle: HCkHttpRequest; name: PWideChar): wordbool;
begin
  result := TCkHttpRequest_RemoveHeader(_map(76, 'CkHttpRequest_RemoveHeader'))
    (objHandle, name);
end;

procedure CkHttpRequest_RemoveParam (objHandle: HCkHttpRequest; name: PWideChar);
begin
  TCkHttpRequest_RemoveParam(_map(77, 'CkHttpRequest_RemoveParam'))
    (objHandle, name);
end;

procedure CkHttpRequest_SetFromUrl (objHandle: HCkHttpRequest; url: PWideChar);
begin
  TCkHttpRequest_SetFromUrl(_map(78, 'CkHttpRequest_SetFromUrl'))
    (objHandle, url);
end;

function CkHttpRequest_StreamBodyFromFile (objHandle: HCkHttpRequest; filePath: PWideChar): wordbool;
begin
  result := TCkHttpRequest_StreamBodyFromFile(_map(79, 'CkHttpRequest_StreamBodyFromFile'))
    (objHandle, filePath);
end;

function CkHttpRequest_StreamChunkFromFile (objHandle: HCkHttpRequest; path: PWideChar; offset: PWideChar; numBytes: PWideChar): wordbool;
begin
  result := TCkHttpRequest_StreamChunkFromFile(_map(80, 'CkHttpRequest_StreamChunkFromFile'))
    (objHandle, path, offset, numBytes);
end;

end.
