unit Imap;

interface

type

HCkPrivateKey = Pointer;
HCkEmailBundle = Pointer;
HCkSshKey = Pointer;
HCkSecureString = Pointer;
HCkStringBuilder = Pointer;
HCkCert = Pointer;
HCkSocket = Pointer;
HCkSsh = Pointer;
HCkBinData = Pointer;
HCkString = Pointer;
HCkXmlCertVault = Pointer;
HCkByteData = Pointer;
HCkMessageSet = Pointer;
HCkJsonObject = Pointer;
HCkEmail = Pointer;
HCkMailboxes = Pointer;
HCkTask = Pointer;
HCkImap = Pointer;
HCkStringArray = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TImapAbortCheck = function(): Integer; cdecl;
TImapProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TImapPercentDone = function(pctDone: Integer): Integer; cdecl;
TImapTaskCompleted = procedure(task: HCkTask); cdecl;


function CkImap_Create: HCkImap;  stdcall;
procedure CkImap_Dispose(handle: HCkImap); stdcall;

procedure CkImap_SetAbortCheck(objHandle: HCkImap; fn: TImapAbortCheck) stdcall;
procedure CkImap_SetProgressInfo(objHandle: HCkImap; fn: TImapProgressInfo) stdcall;
procedure CkImap_SetPercentDone(objHandle: HCkImap; fn: TImapPercentDone) stdcall;
procedure CkImap_SetTaskCompleted(objHandle: HCkImap; fn: TImapTaskCompleted) stdcall;
function CkImap_getAbortCurrent(objHandle: HCkImap): wordbool;
procedure CkImap_putAbortCurrent(objHandle: HCkImap; newPropVal: wordbool);
function CkImap_getAppendSeen(objHandle: HCkImap): wordbool;
procedure CkImap_putAppendSeen(objHandle: HCkImap; newPropVal: wordbool);
function CkImap_getAppendUid(objHandle: HCkImap): Integer;
procedure CkImap_getAuthMethod(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putAuthMethod(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__authMethod(objHandle: HCkImap): PWideChar;
procedure CkImap_getAuthzId(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putAuthzId(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__authzId(objHandle: HCkImap): PWideChar;
function CkImap_getAutoDownloadAttachments(objHandle: HCkImap): wordbool;
procedure CkImap_putAutoDownloadAttachments(objHandle: HCkImap; newPropVal: wordbool);
function CkImap_getAutoFix(objHandle: HCkImap): wordbool;
procedure CkImap_putAutoFix(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getClientIpAddress(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putClientIpAddress(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__clientIpAddress(objHandle: HCkImap): PWideChar;
procedure CkImap_getConnectedToHost(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__connectedToHost(objHandle: HCkImap): PWideChar;
function CkImap_getConnectTimeout(objHandle: HCkImap): Integer;
procedure CkImap_putConnectTimeout(objHandle: HCkImap; newPropVal: Integer);
procedure CkImap_getDebugLogFilePath(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putDebugLogFilePath(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__debugLogFilePath(objHandle: HCkImap): PWideChar;
procedure CkImap_getDomain(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putDomain(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__domain(objHandle: HCkImap): PWideChar;
function CkImap_getHeartbeatMs(objHandle: HCkImap): Integer;
procedure CkImap_putHeartbeatMs(objHandle: HCkImap; newPropVal: Integer);
procedure CkImap_getHighestModSeq(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__highestModSeq(objHandle: HCkImap): PWideChar;
procedure CkImap_getHttpProxyAuthMethod(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putHttpProxyAuthMethod(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__httpProxyAuthMethod(objHandle: HCkImap): PWideChar;
procedure CkImap_getHttpProxyDomain(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putHttpProxyDomain(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__httpProxyDomain(objHandle: HCkImap): PWideChar;
procedure CkImap_getHttpProxyHostname(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putHttpProxyHostname(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__httpProxyHostname(objHandle: HCkImap): PWideChar;
procedure CkImap_getHttpProxyPassword(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putHttpProxyPassword(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__httpProxyPassword(objHandle: HCkImap): PWideChar;
function CkImap_getHttpProxyPort(objHandle: HCkImap): Integer;
procedure CkImap_putHttpProxyPort(objHandle: HCkImap; newPropVal: Integer);
procedure CkImap_getHttpProxyUsername(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putHttpProxyUsername(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__httpProxyUsername(objHandle: HCkImap): PWideChar;
function CkImap_getKeepSessionLog(objHandle: HCkImap): wordbool;
procedure CkImap_putKeepSessionLog(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getLastAppendedMime(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastAppendedMime(objHandle: HCkImap): PWideChar;
procedure CkImap_getLastCommand(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastCommand(objHandle: HCkImap): PWideChar;
procedure CkImap_getLastErrorHtml(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastErrorHtml(objHandle: HCkImap): PWideChar;
procedure CkImap_getLastErrorText(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastErrorText(objHandle: HCkImap): PWideChar;
procedure CkImap_getLastErrorXml(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastErrorXml(objHandle: HCkImap): PWideChar;
procedure CkImap_getLastIntermediateResponse(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastIntermediateResponse(objHandle: HCkImap): PWideChar;
function CkImap_getLastMethodSuccess(objHandle: HCkImap): wordbool;
procedure CkImap_putLastMethodSuccess(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getLastResponse(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastResponse(objHandle: HCkImap): PWideChar;
procedure CkImap_getLastResponseCode(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__lastResponseCode(objHandle: HCkImap): PWideChar;
procedure CkImap_getLoggedInUser(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__loggedInUser(objHandle: HCkImap): PWideChar;
function CkImap_getNumMessages(objHandle: HCkImap): Integer;
function CkImap_getPeekMode(objHandle: HCkImap): wordbool;
procedure CkImap_putPeekMode(objHandle: HCkImap; newPropVal: wordbool);
function CkImap_getPercentDoneScale(objHandle: HCkImap): Integer;
procedure CkImap_putPercentDoneScale(objHandle: HCkImap; newPropVal: Integer);
function CkImap_getPort(objHandle: HCkImap): Integer;
procedure CkImap_putPort(objHandle: HCkImap; newPropVal: Integer);
function CkImap_getPreferIpv6(objHandle: HCkImap): wordbool;
procedure CkImap_putPreferIpv6(objHandle: HCkImap; newPropVal: wordbool);
function CkImap_getReadTimeout(objHandle: HCkImap): Integer;
procedure CkImap_putReadTimeout(objHandle: HCkImap; newPropVal: Integer);
function CkImap_getRequireSslCertVerify(objHandle: HCkImap): wordbool;
procedure CkImap_putRequireSslCertVerify(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getSearchCharset(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSearchCharset(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__searchCharset(objHandle: HCkImap): PWideChar;
procedure CkImap_getSelectedMailbox(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__selectedMailbox(objHandle: HCkImap): PWideChar;
function CkImap_getSendBufferSize(objHandle: HCkImap): Integer;
procedure CkImap_putSendBufferSize(objHandle: HCkImap; newPropVal: Integer);
procedure CkImap_getSeparatorChar(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSeparatorChar(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__separatorChar(objHandle: HCkImap): PWideChar;
procedure CkImap_getSessionLog(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__sessionLog(objHandle: HCkImap): PWideChar;
procedure CkImap_getSocksHostname(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSocksHostname(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__socksHostname(objHandle: HCkImap): PWideChar;
procedure CkImap_getSocksPassword(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSocksPassword(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__socksPassword(objHandle: HCkImap): PWideChar;
function CkImap_getSocksPort(objHandle: HCkImap): Integer;
procedure CkImap_putSocksPort(objHandle: HCkImap; newPropVal: Integer);
procedure CkImap_getSocksUsername(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSocksUsername(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__socksUsername(objHandle: HCkImap): PWideChar;
function CkImap_getSocksVersion(objHandle: HCkImap): Integer;
procedure CkImap_putSocksVersion(objHandle: HCkImap; newPropVal: Integer);
function CkImap_getSoRcvBuf(objHandle: HCkImap): Integer;
procedure CkImap_putSoRcvBuf(objHandle: HCkImap; newPropVal: Integer);
procedure CkImap_getSortCriteria(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSortCriteria(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__sortCriteria(objHandle: HCkImap): PWideChar;
function CkImap_getSoSndBuf(objHandle: HCkImap): Integer;
procedure CkImap_putSoSndBuf(objHandle: HCkImap; newPropVal: Integer);
function CkImap_getSsl(objHandle: HCkImap): wordbool;
procedure CkImap_putSsl(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getSslAllowedCiphers(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSslAllowedCiphers(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__sslAllowedCiphers(objHandle: HCkImap): PWideChar;
procedure CkImap_getSslProtocol(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putSslProtocol(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__sslProtocol(objHandle: HCkImap): PWideChar;
function CkImap_getSslServerCertVerified(objHandle: HCkImap): wordbool;
function CkImap_getStartTls(objHandle: HCkImap): wordbool;
procedure CkImap_putStartTls(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getTlsCipherSuite(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__tlsCipherSuite(objHandle: HCkImap): PWideChar;
procedure CkImap_getTlsPinSet(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putTlsPinSet(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__tlsPinSet(objHandle: HCkImap): PWideChar;
procedure CkImap_getTlsVersion(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__tlsVersion(objHandle: HCkImap): PWideChar;
function CkImap_getUidNext(objHandle: HCkImap): LongWord;
function CkImap_getUidValidity(objHandle: HCkImap): LongWord;
procedure CkImap_getUncommonOptions(objHandle: HCkImap; outPropVal: HCkString);
procedure CkImap_putUncommonOptions(objHandle: HCkImap; newPropVal: PWideChar);
function CkImap__uncommonOptions(objHandle: HCkImap): PWideChar;
function CkImap_getVerboseLogging(objHandle: HCkImap): wordbool;
procedure CkImap_putVerboseLogging(objHandle: HCkImap; newPropVal: wordbool);
procedure CkImap_getVersion(objHandle: HCkImap; outPropVal: HCkString);
function CkImap__version(objHandle: HCkImap): PWideChar;
function CkImap_AddPfxSourceBd(objHandle: HCkImap; bd: HCkBinData; password: PWideChar): wordbool;
function CkImap_AddPfxSourceData(objHandle: HCkImap; pfxBytes: HCkByteData; pfxPassword: PWideChar): wordbool;
function CkImap_AddPfxSourceFile(objHandle: HCkImap; pfxFilePath: PWideChar; pfxPassword: PWideChar): wordbool;
function CkImap_AppendMail(objHandle: HCkImap; mailbox: PWideChar; email: HCkEmail): wordbool;
function CkImap_AppendMailAsync(objHandle: HCkImap; mailbox: PWideChar; email: HCkEmail): HCkTask;
function CkImap_AppendMime(objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar): wordbool;
function CkImap_AppendMimeAsync(objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar): HCkTask;
function CkImap_AppendMimeWithDateStr(objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; internalDateStr: PWideChar): wordbool;
function CkImap_AppendMimeWithDateStrAsync(objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; internalDateStr: PWideChar): HCkTask;
function CkImap_AppendMimeWithFlags(objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): wordbool;
function CkImap_AppendMimeWithFlagsAsync(objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): HCkTask;
function CkImap_AppendMimeWithFlagsSb(objHandle: HCkImap; mailbox: PWideChar; sbMime: HCkStringBuilder; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): wordbool;
function CkImap_AppendMimeWithFlagsSbAsync(objHandle: HCkImap; mailbox: PWideChar; sbMime: HCkStringBuilder; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): HCkTask;
function CkImap_Capability(objHandle: HCkImap; outStr: HCkString): wordbool;
function CkImap__capability(objHandle: HCkImap): PWideChar;
function CkImap_CapabilityAsync(objHandle: HCkImap): HCkTask;
function CkImap_CheckConnection(objHandle: HCkImap): wordbool;
function CkImap_CheckForNewEmail(objHandle: HCkImap): HCkMessageSet;
function CkImap_CheckForNewEmailAsync(objHandle: HCkImap): HCkTask;
procedure CkImap_ClearSessionLog(objHandle: HCkImap);
function CkImap_CloseMailbox(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_CloseMailboxAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_Connect(objHandle: HCkImap; domainName: PWideChar): wordbool;
function CkImap_ConnectAsync(objHandle: HCkImap; domainName: PWideChar): HCkTask;
function CkImap_Copy(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; copyToMailbox: PWideChar): wordbool;
function CkImap_CopyAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; copyToMailbox: PWideChar): HCkTask;
function CkImap_CopyMultiple(objHandle: HCkImap; messageSet: HCkMessageSet; copyToMailbox: PWideChar): wordbool;
function CkImap_CopyMultipleAsync(objHandle: HCkImap; messageSet: HCkMessageSet; copyToMailbox: PWideChar): HCkTask;
function CkImap_CopySequence(objHandle: HCkImap; startSeqNum: Integer; count: Integer; copyToMailbox: PWideChar): wordbool;
function CkImap_CopySequenceAsync(objHandle: HCkImap; startSeqNum: Integer; count: Integer; copyToMailbox: PWideChar): HCkTask;
function CkImap_CreateMailbox(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_CreateMailboxAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_DeleteMailbox(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_DeleteMailboxAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_Disconnect(objHandle: HCkImap): wordbool;
function CkImap_DisconnectAsync(objHandle: HCkImap): HCkTask;
function CkImap_ExamineMailbox(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_ExamineMailboxAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_Expunge(objHandle: HCkImap): wordbool;
function CkImap_ExpungeAsync(objHandle: HCkImap): HCkTask;
function CkImap_ExpungeAndClose(objHandle: HCkImap): wordbool;
function CkImap_ExpungeAndCloseAsync(objHandle: HCkImap): HCkTask;
function CkImap_FetchAttachment(objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; saveToPath: PWideChar): wordbool;
function CkImap_FetchAttachmentAsync(objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; saveToPath: PWideChar): HCkTask;
function CkImap_FetchAttachmentBd(objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; binData: HCkBinData): wordbool;
function CkImap_FetchAttachmentBdAsync(objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; binData: HCkBinData): HCkTask;
function CkImap_FetchAttachmentBytes(objHandle: HCkImap; email: HCkEmail; attachIndex: Integer; outData: HCkByteData): wordbool;
function CkImap_FetchAttachmentBytesAsync(objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): HCkTask;
function CkImap_FetchAttachmentSb(objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; charset: PWideChar; sb: HCkStringBuilder): wordbool;
function CkImap_FetchAttachmentSbAsync(objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
function CkImap_FetchAttachmentString(objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkImap__fetchAttachmentString(objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar): PWideChar;
function CkImap_FetchAttachmentStringAsync(objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar): HCkTask;
function CkImap_FetchBundle(objHandle: HCkImap; messageSet: HCkMessageSet): HCkEmailBundle;
function CkImap_FetchBundleAsync(objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask;
function CkImap_FetchBundleAsMime(objHandle: HCkImap; messageSet: HCkMessageSet): HCkStringArray;
function CkImap_FetchBundleAsMimeAsync(objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask;
function CkImap_FetchChunk(objHandle: HCkImap; startSeqNum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet): HCkEmailBundle;
function CkImap_FetchChunkAsync(objHandle: HCkImap; startSeqNum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet): HCkTask;
function CkImap_FetchChunk2(objHandle: HCkImap; seqnum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet; bundle: HCkEmailBundle): wordbool;
function CkImap_FetchChunk2Async(objHandle: HCkImap; seqnum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet; bundle: HCkEmailBundle): HCkTask;
function CkImap_FetchEmail(objHandle: HCkImap; headerOnly: wordbool; msgId: LongWord; bUid: wordbool; email: HCkEmail): wordbool;
function CkImap_FetchEmailAsync(objHandle: HCkImap; headerOnly: wordbool; msgId: LongWord; bUid: wordbool; email: HCkEmail): HCkTask;
function CkImap_FetchFlags(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; outStr: HCkString): wordbool;
function CkImap__fetchFlags(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): PWideChar;
function CkImap_FetchFlagsAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
function CkImap_FetchHeaders(objHandle: HCkImap; messageSet: HCkMessageSet): HCkEmailBundle;
function CkImap_FetchHeadersAsync(objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask;
function CkImap_FetchMsgSet(objHandle: HCkImap; headersOnly: wordbool; msgSet: HCkMessageSet; bundle: HCkEmailBundle): wordbool;
function CkImap_FetchMsgSetAsync(objHandle: HCkImap; headersOnly: wordbool; msgSet: HCkMessageSet; bundle: HCkEmailBundle): HCkTask;
function CkImap_FetchRange(objHandle: HCkImap; headersOnly: wordbool; seqnum: Integer; count: Integer; bundle: HCkEmailBundle): wordbool;
function CkImap_FetchRangeAsync(objHandle: HCkImap; headersOnly: wordbool; seqnum: Integer; count: Integer; bundle: HCkEmailBundle): HCkTask;
function CkImap_FetchSequence(objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkEmailBundle;
function CkImap_FetchSequenceAsync(objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask;
function CkImap_FetchSequenceAsMime(objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkStringArray;
function CkImap_FetchSequenceAsMimeAsync(objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask;
function CkImap_FetchSequenceHeaders(objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkEmailBundle;
function CkImap_FetchSequenceHeadersAsync(objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask;
function CkImap_FetchSingle(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkEmail;
function CkImap_FetchSingleAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
function CkImap_FetchSingleAsMime(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; outStr: HCkString): wordbool;
function CkImap__fetchSingleAsMime(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): PWideChar;
function CkImap_FetchSingleAsMimeAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
function CkImap_FetchSingleAsMimeSb(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; sbMime: HCkStringBuilder): wordbool;
function CkImap_FetchSingleAsMimeSbAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; sbMime: HCkStringBuilder): HCkTask;
function CkImap_FetchSingleBd(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; mimeData: HCkBinData): wordbool;
function CkImap_FetchSingleBdAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; mimeData: HCkBinData): HCkTask;
function CkImap_FetchSingleHeader(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkEmail;
function CkImap_FetchSingleHeaderAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
function CkImap_FetchSingleHeaderAsMime(objHandle: HCkImap; msgId: LongWord; bUID: wordbool; outStr: HCkString): wordbool;
function CkImap__fetchSingleHeaderAsMime(objHandle: HCkImap; msgId: LongWord; bUID: wordbool): PWideChar;
function CkImap_FetchSingleHeaderAsMimeAsync(objHandle: HCkImap; msgId: LongWord; bUID: wordbool): HCkTask;
function CkImap_GetAllUids(objHandle: HCkImap): HCkMessageSet;
function CkImap_GetAllUidsAsync(objHandle: HCkImap): HCkTask;
function CkImap_GetMailAttachFilename(objHandle: HCkImap; email: HCkEmail; attachIndex: Integer; outStr: HCkString): wordbool;
function CkImap__getMailAttachFilename(objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): PWideChar;
function CkImap_GetMailAttachSize(objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): Integer;
function CkImap_GetMailboxStatus(objHandle: HCkImap; mailbox: PWideChar; outStr: HCkString): wordbool;
function CkImap__getMailboxStatus(objHandle: HCkImap; mailbox: PWideChar): PWideChar;
function CkImap_GetMailboxStatusAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_GetMailFlag(objHandle: HCkImap; email: HCkEmail; flagName: PWideChar): Integer;
function CkImap_GetMailNumAttach(objHandle: HCkImap; email: HCkEmail): Integer;
function CkImap_GetMailSize(objHandle: HCkImap; email: HCkEmail): Integer;
function CkImap_GetQuota(objHandle: HCkImap; quotaRoot: PWideChar; outStr: HCkString): wordbool;
function CkImap__getQuota(objHandle: HCkImap; quotaRoot: PWideChar): PWideChar;
function CkImap_GetQuotaAsync(objHandle: HCkImap; quotaRoot: PWideChar): HCkTask;
function CkImap_GetQuotaRoot(objHandle: HCkImap; mailboxName: PWideChar; outStr: HCkString): wordbool;
function CkImap__getQuotaRoot(objHandle: HCkImap; mailboxName: PWideChar): PWideChar;
function CkImap_GetQuotaRootAsync(objHandle: HCkImap; mailboxName: PWideChar): HCkTask;
function CkImap_GetServerCert(objHandle: HCkImap; cert: HCkCert): wordbool;
function CkImap_GetSslServerCert(objHandle: HCkImap): HCkCert;
function CkImap_HasCapability(objHandle: HCkImap; name: PWideChar; capabilityResponse: PWideChar): wordbool;
function CkImap_IdleCheck(objHandle: HCkImap; timeoutMs: Integer; outStr: HCkString): wordbool;
function CkImap__idleCheck(objHandle: HCkImap; timeoutMs: Integer): PWideChar;
function CkImap_IdleCheckAsync(objHandle: HCkImap; timeoutMs: Integer): HCkTask;
function CkImap_IdleDone(objHandle: HCkImap): wordbool;
function CkImap_IdleDoneAsync(objHandle: HCkImap): HCkTask;
function CkImap_IdleStart(objHandle: HCkImap): wordbool;
function CkImap_IdleStartAsync(objHandle: HCkImap): HCkTask;
function CkImap_IsConnected(objHandle: HCkImap): wordbool;
function CkImap_IsLoggedIn(objHandle: HCkImap): wordbool;
function CkImap_ListMailboxes(objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkMailboxes;
function CkImap_ListMailboxesAsync(objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkTask;
function CkImap_ListSubscribed(objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkMailboxes;
function CkImap_ListSubscribedAsync(objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkTask;
function CkImap_LoadTaskCaller(objHandle: HCkImap; task: HCkTask): wordbool;
function CkImap_Login(objHandle: HCkImap; loginName: PWideChar; password: PWideChar): wordbool;
function CkImap_LoginAsync(objHandle: HCkImap; loginName: PWideChar; password: PWideChar): HCkTask;
function CkImap_LoginSecure(objHandle: HCkImap; loginName: HCkSecureString; password: HCkSecureString): wordbool;
function CkImap_LoginSecureAsync(objHandle: HCkImap; loginName: HCkSecureString; password: HCkSecureString): HCkTask;
function CkImap_Logout(objHandle: HCkImap): wordbool;
function CkImap_LogoutAsync(objHandle: HCkImap): HCkTask;
function CkImap_MbxList(objHandle: HCkImap; subscribed: wordbool; reference: PWideChar; mbxPattern: PWideChar; mboxes: HCkMailboxes): wordbool;
function CkImap_MbxListAsync(objHandle: HCkImap; subscribed: wordbool; reference: PWideChar; mbxPattern: PWideChar; mboxes: HCkMailboxes): HCkTask;
function CkImap_MoveMessages(objHandle: HCkImap; messageSet: HCkMessageSet; destFolder: PWideChar): wordbool;
function CkImap_MoveMessagesAsync(objHandle: HCkImap; messageSet: HCkMessageSet; destFolder: PWideChar): HCkTask;
function CkImap_Noop(objHandle: HCkImap): wordbool;
function CkImap_NoopAsync(objHandle: HCkImap): HCkTask;
function CkImap_QueryMbx(objHandle: HCkImap; criteria: PWideChar; bUid: wordbool; msgSet: HCkMessageSet): wordbool;
function CkImap_QueryMbxAsync(objHandle: HCkImap; criteria: PWideChar; bUid: wordbool; msgSet: HCkMessageSet): HCkTask;
function CkImap_QueryThread(objHandle: HCkImap; threadAlg: PWideChar; searchCriteria: PWideChar; bUid: wordbool; json: HCkJsonObject): wordbool;
function CkImap_QueryThreadAsync(objHandle: HCkImap; threadAlg: PWideChar; searchCriteria: PWideChar; bUid: wordbool; json: HCkJsonObject): HCkTask;
function CkImap_RawCommandBd(objHandle: HCkImap; bdCmd: HCkBinData; bdResp: HCkBinData): wordbool;
function CkImap_RawCommandBdAsync(objHandle: HCkImap; bdCmd: HCkBinData; bdResp: HCkBinData): HCkTask;
function CkImap_RefetchMailFlags(objHandle: HCkImap; email: HCkEmail): wordbool;
function CkImap_RefetchMailFlagsAsync(objHandle: HCkImap; email: HCkEmail): HCkTask;
function CkImap_RenameMailbox(objHandle: HCkImap; fromMailbox: PWideChar; toMailbox: PWideChar): wordbool;
function CkImap_RenameMailboxAsync(objHandle: HCkImap; fromMailbox: PWideChar; toMailbox: PWideChar): HCkTask;
function CkImap_Search(objHandle: HCkImap; criteria: PWideChar; bUid: wordbool): HCkMessageSet;
function CkImap_SearchAsync(objHandle: HCkImap; criteria: PWideChar; bUid: wordbool): HCkTask;
function CkImap_SelectMailbox(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_SelectMailboxAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_SendRawCommand(objHandle: HCkImap; cmd: PWideChar; outStr: HCkString): wordbool;
function CkImap__sendRawCommand(objHandle: HCkImap; cmd: PWideChar): PWideChar;
function CkImap_SendRawCommandAsync(objHandle: HCkImap; cmd: PWideChar): HCkTask;
function CkImap_SendRawCommandB(objHandle: HCkImap; cmd: PWideChar; outData: HCkByteData): wordbool;
function CkImap_SendRawCommandBAsync(objHandle: HCkImap; cmd: PWideChar): HCkTask;
function CkImap_SendRawCommandC(objHandle: HCkImap; cmd: HCkByteData; outData: HCkByteData): wordbool;
function CkImap_SendRawCommandCAsync(objHandle: HCkImap; cmd: HCkByteData): HCkTask;
function CkImap_SetDecryptCert(objHandle: HCkImap; cert: HCkCert): wordbool;
function CkImap_SetDecryptCert2(objHandle: HCkImap; cert: HCkCert; key: HCkPrivateKey): wordbool;
function CkImap_SetFlag(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagName: PWideChar; value: Integer): wordbool;
function CkImap_SetFlagAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagName: PWideChar; value: Integer): HCkTask;
function CkImap_SetFlags(objHandle: HCkImap; messageSet: HCkMessageSet; flagName: PWideChar; value: Integer): wordbool;
function CkImap_SetFlagsAsync(objHandle: HCkImap; messageSet: HCkMessageSet; flagName: PWideChar; value: Integer): HCkTask;
function CkImap_SetMailFlag(objHandle: HCkImap; email: HCkEmail; flagName: PWideChar; value: Integer): wordbool;
function CkImap_SetMailFlagAsync(objHandle: HCkImap; email: HCkEmail; flagName: PWideChar; value: Integer): HCkTask;
function CkImap_SetQuota(objHandle: HCkImap; quotaRoot: PWideChar; resource: PWideChar; quota: Integer): wordbool;
function CkImap_SetQuotaAsync(objHandle: HCkImap; quotaRoot: PWideChar; resource: PWideChar; quota: Integer): HCkTask;
function CkImap_SetSslClientCert(objHandle: HCkImap; cert: HCkCert): wordbool;
function CkImap_SetSslClientCertPem(objHandle: HCkImap; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
function CkImap_SetSslClientCertPfx(objHandle: HCkImap; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
function CkImap_Sort(objHandle: HCkImap; sortCriteria: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkMessageSet;
function CkImap_SortAsync(objHandle: HCkImap; sortCriteria: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkTask;
function CkImap_SshAuthenticatePk(objHandle: HCkImap; sshLogin: PWideChar; privateKey: HCkSshKey): wordbool;
function CkImap_SshAuthenticatePkAsync(objHandle: HCkImap; sshLogin: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkImap_SshAuthenticatePw(objHandle: HCkImap; sshLogin: PWideChar; sshPassword: PWideChar): wordbool;
function CkImap_SshAuthenticatePwAsync(objHandle: HCkImap; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask;
function CkImap_SshCloseTunnel(objHandle: HCkImap): wordbool;
function CkImap_SshCloseTunnelAsync(objHandle: HCkImap): HCkTask;
function CkImap_SshOpenTunnel(objHandle: HCkImap; sshHostname: PWideChar; sshPort: Integer): wordbool;
function CkImap_SshOpenTunnelAsync(objHandle: HCkImap; sshHostname: PWideChar; sshPort: Integer): HCkTask;
function CkImap_StoreFlags(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagNames: PWideChar; value: Integer): wordbool;
function CkImap_StoreFlagsAsync(objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagNames: PWideChar; value: Integer): HCkTask;
function CkImap_Subscribe(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_SubscribeAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_ThreadCmd(objHandle: HCkImap; threadAlg: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkJsonObject;
function CkImap_ThreadCmdAsync(objHandle: HCkImap; threadAlg: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkTask;
function CkImap_Unsubscribe(objHandle: HCkImap; mailbox: PWideChar): wordbool;
function CkImap_UnsubscribeAsync(objHandle: HCkImap; mailbox: PWideChar): HCkTask;
function CkImap_UseCertVault(objHandle: HCkImap; vault: HCkXmlCertVault): wordbool;
function CkImap_UseSsh(objHandle: HCkImap; ssh: HCkSsh): wordbool;
function CkImap_UseSshTunnel(objHandle: HCkImap; tunnel: HCkSocket): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkImap_Create = function : HCkImap; stdcall;
  TCkImap_Dispose = procedure (handle: HCkImap); stdcall;
  TCkImap_SetAbortCheck = procedure (objHandle: HCkImap; fn: TImapAbortCheck); stdcall;
  TCkImap_SetProgressInfo = procedure (objHandle: HCkImap; fn: TImapProgressInfo); stdcall;
  TCkImap_SetPercentDone = procedure (objHandle: HCkImap; fn: TImapPercentDone); stdcall;
  TCkImap_SetTaskCompleted = procedure (objHandle: HCkImap; fn: TImapTaskCompleted); stdcall;
  TCkImap_getAbortCurrent = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putAbortCurrent = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getAppendSeen = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putAppendSeen = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getAppendUid = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_getAuthMethod = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putAuthMethod = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__authMethod = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getAuthzId = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putAuthzId = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__authzId = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getAutoDownloadAttachments = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putAutoDownloadAttachments = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getAutoFix = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putAutoFix = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getClientIpAddress = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putClientIpAddress = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__clientIpAddress = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getConnectedToHost = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__connectedToHost = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getConnectTimeout = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putConnectTimeout = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getDebugLogFilePath = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putDebugLogFilePath = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__debugLogFilePath = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getDomain = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putDomain = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__domain = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getHeartbeatMs = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putHeartbeatMs = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getHighestModSeq = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__highestModSeq = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getHttpProxyAuthMethod = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putHttpProxyAuthMethod = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__httpProxyAuthMethod = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getHttpProxyDomain = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putHttpProxyDomain = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__httpProxyDomain = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getHttpProxyHostname = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putHttpProxyHostname = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__httpProxyHostname = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getHttpProxyPassword = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putHttpProxyPassword = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__httpProxyPassword = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getHttpProxyPort = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putHttpProxyPort = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getHttpProxyUsername = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putHttpProxyUsername = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__httpProxyUsername = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getKeepSessionLog = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putKeepSessionLog = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getLastAppendedMime = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastAppendedMime = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastCommand = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastCommand = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastErrorHtml = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastErrorHtml = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastErrorText = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastErrorText = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastErrorXml = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastErrorXml = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastIntermediateResponse = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastIntermediateResponse = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastMethodSuccess = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putLastMethodSuccess = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getLastResponse = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastResponse = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLastResponseCode = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__lastResponseCode = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getLoggedInUser = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__loggedInUser = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getNumMessages = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_getPeekMode = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putPeekMode = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getPercentDoneScale = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putPercentDoneScale = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getPort = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putPort = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getPreferIpv6 = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putPreferIpv6 = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getReadTimeout = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putReadTimeout = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getRequireSslCertVerify = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putRequireSslCertVerify = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getSearchCharset = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSearchCharset = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__searchCharset = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSelectedMailbox = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__selectedMailbox = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSendBufferSize = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putSendBufferSize = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getSeparatorChar = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSeparatorChar = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__separatorChar = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSessionLog = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__sessionLog = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSocksHostname = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSocksHostname = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__socksHostname = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSocksPassword = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSocksPassword = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__socksPassword = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSocksPort = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putSocksPort = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getSocksUsername = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSocksUsername = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__socksUsername = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSocksVersion = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putSocksVersion = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getSoRcvBuf = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putSoRcvBuf = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getSortCriteria = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSortCriteria = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__sortCriteria = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSoSndBuf = function (objHandle: HCkImap): Integer; stdcall;
  TCkImap_putSoSndBuf = procedure (objHandle: HCkImap; newPropVal: Integer); stdcall;
  TCkImap_getSsl = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putSsl = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getSslAllowedCiphers = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSslAllowedCiphers = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__sslAllowedCiphers = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSslProtocol = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putSslProtocol = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__sslProtocol = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getSslServerCertVerified = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_getStartTls = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putStartTls = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getTlsCipherSuite = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__tlsCipherSuite = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getTlsPinSet = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putTlsPinSet = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__tlsPinSet = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getTlsVersion = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__tlsVersion = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getUidNext = function (objHandle: HCkImap): LongWord; stdcall;
  TCkImap_getUidValidity = function (objHandle: HCkImap): LongWord; stdcall;
  TCkImap_getUncommonOptions = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap_putUncommonOptions = procedure (objHandle: HCkImap; newPropVal: PWideChar); stdcall;
  TCkImap__uncommonOptions = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_getVerboseLogging = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_putVerboseLogging = procedure (objHandle: HCkImap; newPropVal: wordbool); stdcall;
  TCkImap_getVersion = procedure (objHandle: HCkImap; outPropVal: HCkString); stdcall;
  TCkImap__version = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_AddPfxSourceBd = function (objHandle: HCkImap; bd: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkImap_AddPfxSourceData = function (objHandle: HCkImap; pfxBytes: HCkByteData; pfxPassword: PWideChar): wordbool; stdcall;
  TCkImap_AddPfxSourceFile = function (objHandle: HCkImap; pfxFilePath: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkImap_AppendMail = function (objHandle: HCkImap; mailbox: PWideChar; email: HCkEmail): wordbool; stdcall;
  TCkImap_AppendMailAsync = function (objHandle: HCkImap; mailbox: PWideChar; email: HCkEmail): HCkTask; stdcall;
  TCkImap_AppendMime = function (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar): wordbool; stdcall;
  TCkImap_AppendMimeAsync = function (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar): HCkTask; stdcall;
  TCkImap_AppendMimeWithDateStr = function (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; internalDateStr: PWideChar): wordbool; stdcall;
  TCkImap_AppendMimeWithDateStrAsync = function (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; internalDateStr: PWideChar): HCkTask; stdcall;
  TCkImap_AppendMimeWithFlags = function (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): wordbool; stdcall;
  TCkImap_AppendMimeWithFlagsAsync = function (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): HCkTask; stdcall;
  TCkImap_AppendMimeWithFlagsSb = function (objHandle: HCkImap; mailbox: PWideChar; sbMime: HCkStringBuilder; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): wordbool; stdcall;
  TCkImap_AppendMimeWithFlagsSbAsync = function (objHandle: HCkImap; mailbox: PWideChar; sbMime: HCkStringBuilder; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): HCkTask; stdcall;
  TCkImap_Capability = function (objHandle: HCkImap; outStr: HCkString): wordbool; stdcall;
  TCkImap__capability = function (objHandle: HCkImap): PWideChar; stdcall;
  TCkImap_CapabilityAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_CheckConnection = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_CheckForNewEmail = function (objHandle: HCkImap): HCkMessageSet; stdcall;
  TCkImap_CheckForNewEmailAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_ClearSessionLog = procedure (objHandle: HCkImap); stdcall;
  TCkImap_CloseMailbox = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_CloseMailboxAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_Connect = function (objHandle: HCkImap; domainName: PWideChar): wordbool; stdcall;
  TCkImap_ConnectAsync = function (objHandle: HCkImap; domainName: PWideChar): HCkTask; stdcall;
  TCkImap_Copy = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; copyToMailbox: PWideChar): wordbool; stdcall;
  TCkImap_CopyAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; copyToMailbox: PWideChar): HCkTask; stdcall;
  TCkImap_CopyMultiple = function (objHandle: HCkImap; messageSet: HCkMessageSet; copyToMailbox: PWideChar): wordbool; stdcall;
  TCkImap_CopyMultipleAsync = function (objHandle: HCkImap; messageSet: HCkMessageSet; copyToMailbox: PWideChar): HCkTask; stdcall;
  TCkImap_CopySequence = function (objHandle: HCkImap; startSeqNum: Integer; count: Integer; copyToMailbox: PWideChar): wordbool; stdcall;
  TCkImap_CopySequenceAsync = function (objHandle: HCkImap; startSeqNum: Integer; count: Integer; copyToMailbox: PWideChar): HCkTask; stdcall;
  TCkImap_CreateMailbox = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_CreateMailboxAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_DeleteMailbox = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_DeleteMailboxAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_Disconnect = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_DisconnectAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_ExamineMailbox = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_ExamineMailboxAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_Expunge = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_ExpungeAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_ExpungeAndClose = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_ExpungeAndCloseAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_FetchAttachment = function (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; saveToPath: PWideChar): wordbool; stdcall;
  TCkImap_FetchAttachmentAsync = function (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; saveToPath: PWideChar): HCkTask; stdcall;
  TCkImap_FetchAttachmentBd = function (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; binData: HCkBinData): wordbool; stdcall;
  TCkImap_FetchAttachmentBdAsync = function (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; binData: HCkBinData): HCkTask; stdcall;
  TCkImap_FetchAttachmentBytes = function (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkImap_FetchAttachmentBytesAsync = function (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): HCkTask; stdcall;
  TCkImap_FetchAttachmentSb = function (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; charset: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkImap_FetchAttachmentSbAsync = function (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; charset: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkImap_FetchAttachmentString = function (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkImap__fetchAttachmentString = function (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkImap_FetchAttachmentStringAsync = function (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar): HCkTask; stdcall;
  TCkImap_FetchBundle = function (objHandle: HCkImap; messageSet: HCkMessageSet): HCkEmailBundle; stdcall;
  TCkImap_FetchBundleAsync = function (objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask; stdcall;
  TCkImap_FetchBundleAsMime = function (objHandle: HCkImap; messageSet: HCkMessageSet): HCkStringArray; stdcall;
  TCkImap_FetchBundleAsMimeAsync = function (objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask; stdcall;
  TCkImap_FetchChunk = function (objHandle: HCkImap; startSeqNum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet): HCkEmailBundle; stdcall;
  TCkImap_FetchChunkAsync = function (objHandle: HCkImap; startSeqNum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet): HCkTask; stdcall;
  TCkImap_FetchChunk2 = function (objHandle: HCkImap; seqnum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkImap_FetchChunk2Async = function (objHandle: HCkImap; seqnum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkImap_FetchEmail = function (objHandle: HCkImap; headerOnly: wordbool; msgId: LongWord; bUid: wordbool; email: HCkEmail): wordbool; stdcall;
  TCkImap_FetchEmailAsync = function (objHandle: HCkImap; headerOnly: wordbool; msgId: LongWord; bUid: wordbool; email: HCkEmail): HCkTask; stdcall;
  TCkImap_FetchFlags = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkImap__fetchFlags = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): PWideChar; stdcall;
  TCkImap_FetchFlagsAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask; stdcall;
  TCkImap_FetchHeaders = function (objHandle: HCkImap; messageSet: HCkMessageSet): HCkEmailBundle; stdcall;
  TCkImap_FetchHeadersAsync = function (objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask; stdcall;
  TCkImap_FetchMsgSet = function (objHandle: HCkImap; headersOnly: wordbool; msgSet: HCkMessageSet; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkImap_FetchMsgSetAsync = function (objHandle: HCkImap; headersOnly: wordbool; msgSet: HCkMessageSet; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkImap_FetchRange = function (objHandle: HCkImap; headersOnly: wordbool; seqnum: Integer; count: Integer; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkImap_FetchRangeAsync = function (objHandle: HCkImap; headersOnly: wordbool; seqnum: Integer; count: Integer; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkImap_FetchSequence = function (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkEmailBundle; stdcall;
  TCkImap_FetchSequenceAsync = function (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask; stdcall;
  TCkImap_FetchSequenceAsMime = function (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkStringArray; stdcall;
  TCkImap_FetchSequenceAsMimeAsync = function (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask; stdcall;
  TCkImap_FetchSequenceHeaders = function (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkEmailBundle; stdcall;
  TCkImap_FetchSequenceHeadersAsync = function (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask; stdcall;
  TCkImap_FetchSingle = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkEmail; stdcall;
  TCkImap_FetchSingleAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask; stdcall;
  TCkImap_FetchSingleAsMime = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkImap__fetchSingleAsMime = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): PWideChar; stdcall;
  TCkImap_FetchSingleAsMimeAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask; stdcall;
  TCkImap_FetchSingleAsMimeSb = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; sbMime: HCkStringBuilder): wordbool; stdcall;
  TCkImap_FetchSingleAsMimeSbAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; sbMime: HCkStringBuilder): HCkTask; stdcall;
  TCkImap_FetchSingleBd = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; mimeData: HCkBinData): wordbool; stdcall;
  TCkImap_FetchSingleBdAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; mimeData: HCkBinData): HCkTask; stdcall;
  TCkImap_FetchSingleHeader = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkEmail; stdcall;
  TCkImap_FetchSingleHeaderAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask; stdcall;
  TCkImap_FetchSingleHeaderAsMime = function (objHandle: HCkImap; msgId: LongWord; bUID: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkImap__fetchSingleHeaderAsMime = function (objHandle: HCkImap; msgId: LongWord; bUID: wordbool): PWideChar; stdcall;
  TCkImap_FetchSingleHeaderAsMimeAsync = function (objHandle: HCkImap; msgId: LongWord; bUID: wordbool): HCkTask; stdcall;
  TCkImap_GetAllUids = function (objHandle: HCkImap): HCkMessageSet; stdcall;
  TCkImap_GetAllUidsAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_GetMailAttachFilename = function (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer; outStr: HCkString): wordbool; stdcall;
  TCkImap__getMailAttachFilename = function (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): PWideChar; stdcall;
  TCkImap_GetMailAttachSize = function (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): Integer; stdcall;
  TCkImap_GetMailboxStatus = function (objHandle: HCkImap; mailbox: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkImap__getMailboxStatus = function (objHandle: HCkImap; mailbox: PWideChar): PWideChar; stdcall;
  TCkImap_GetMailboxStatusAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_GetMailFlag = function (objHandle: HCkImap; email: HCkEmail; flagName: PWideChar): Integer; stdcall;
  TCkImap_GetMailNumAttach = function (objHandle: HCkImap; email: HCkEmail): Integer; stdcall;
  TCkImap_GetMailSize = function (objHandle: HCkImap; email: HCkEmail): Integer; stdcall;
  TCkImap_GetQuota = function (objHandle: HCkImap; quotaRoot: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkImap__getQuota = function (objHandle: HCkImap; quotaRoot: PWideChar): PWideChar; stdcall;
  TCkImap_GetQuotaAsync = function (objHandle: HCkImap; quotaRoot: PWideChar): HCkTask; stdcall;
  TCkImap_GetQuotaRoot = function (objHandle: HCkImap; mailboxName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkImap__getQuotaRoot = function (objHandle: HCkImap; mailboxName: PWideChar): PWideChar; stdcall;
  TCkImap_GetQuotaRootAsync = function (objHandle: HCkImap; mailboxName: PWideChar): HCkTask; stdcall;
  TCkImap_GetServerCert = function (objHandle: HCkImap; cert: HCkCert): wordbool; stdcall;
  TCkImap_GetSslServerCert = function (objHandle: HCkImap): HCkCert; stdcall;
  TCkImap_HasCapability = function (objHandle: HCkImap; name: PWideChar; capabilityResponse: PWideChar): wordbool; stdcall;
  TCkImap_IdleCheck = function (objHandle: HCkImap; timeoutMs: Integer; outStr: HCkString): wordbool; stdcall;
  TCkImap__idleCheck = function (objHandle: HCkImap; timeoutMs: Integer): PWideChar; stdcall;
  TCkImap_IdleCheckAsync = function (objHandle: HCkImap; timeoutMs: Integer): HCkTask; stdcall;
  TCkImap_IdleDone = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_IdleDoneAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_IdleStart = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_IdleStartAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_IsConnected = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_IsLoggedIn = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_ListMailboxes = function (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkMailboxes; stdcall;
  TCkImap_ListMailboxesAsync = function (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkTask; stdcall;
  TCkImap_ListSubscribed = function (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkMailboxes; stdcall;
  TCkImap_ListSubscribedAsync = function (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkTask; stdcall;
  TCkImap_LoadTaskCaller = function (objHandle: HCkImap; task: HCkTask): wordbool; stdcall;
  TCkImap_Login = function (objHandle: HCkImap; loginName: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkImap_LoginAsync = function (objHandle: HCkImap; loginName: PWideChar; password: PWideChar): HCkTask; stdcall;
  TCkImap_LoginSecure = function (objHandle: HCkImap; loginName: HCkSecureString; password: HCkSecureString): wordbool; stdcall;
  TCkImap_LoginSecureAsync = function (objHandle: HCkImap; loginName: HCkSecureString; password: HCkSecureString): HCkTask; stdcall;
  TCkImap_Logout = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_LogoutAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_MbxList = function (objHandle: HCkImap; subscribed: wordbool; reference: PWideChar; mbxPattern: PWideChar; mboxes: HCkMailboxes): wordbool; stdcall;
  TCkImap_MbxListAsync = function (objHandle: HCkImap; subscribed: wordbool; reference: PWideChar; mbxPattern: PWideChar; mboxes: HCkMailboxes): HCkTask; stdcall;
  TCkImap_MoveMessages = function (objHandle: HCkImap; messageSet: HCkMessageSet; destFolder: PWideChar): wordbool; stdcall;
  TCkImap_MoveMessagesAsync = function (objHandle: HCkImap; messageSet: HCkMessageSet; destFolder: PWideChar): HCkTask; stdcall;
  TCkImap_Noop = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_NoopAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_QueryMbx = function (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool; msgSet: HCkMessageSet): wordbool; stdcall;
  TCkImap_QueryMbxAsync = function (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool; msgSet: HCkMessageSet): HCkTask; stdcall;
  TCkImap_QueryThread = function (objHandle: HCkImap; threadAlg: PWideChar; searchCriteria: PWideChar; bUid: wordbool; json: HCkJsonObject): wordbool; stdcall;
  TCkImap_QueryThreadAsync = function (objHandle: HCkImap; threadAlg: PWideChar; searchCriteria: PWideChar; bUid: wordbool; json: HCkJsonObject): HCkTask; stdcall;
  TCkImap_RawCommandBd = function (objHandle: HCkImap; bdCmd: HCkBinData; bdResp: HCkBinData): wordbool; stdcall;
  TCkImap_RawCommandBdAsync = function (objHandle: HCkImap; bdCmd: HCkBinData; bdResp: HCkBinData): HCkTask; stdcall;
  TCkImap_RefetchMailFlags = function (objHandle: HCkImap; email: HCkEmail): wordbool; stdcall;
  TCkImap_RefetchMailFlagsAsync = function (objHandle: HCkImap; email: HCkEmail): HCkTask; stdcall;
  TCkImap_RenameMailbox = function (objHandle: HCkImap; fromMailbox: PWideChar; toMailbox: PWideChar): wordbool; stdcall;
  TCkImap_RenameMailboxAsync = function (objHandle: HCkImap; fromMailbox: PWideChar; toMailbox: PWideChar): HCkTask; stdcall;
  TCkImap_Search = function (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool): HCkMessageSet; stdcall;
  TCkImap_SearchAsync = function (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool): HCkTask; stdcall;
  TCkImap_SelectMailbox = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_SelectMailboxAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_SendRawCommand = function (objHandle: HCkImap; cmd: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkImap__sendRawCommand = function (objHandle: HCkImap; cmd: PWideChar): PWideChar; stdcall;
  TCkImap_SendRawCommandAsync = function (objHandle: HCkImap; cmd: PWideChar): HCkTask; stdcall;
  TCkImap_SendRawCommandB = function (objHandle: HCkImap; cmd: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkImap_SendRawCommandBAsync = function (objHandle: HCkImap; cmd: PWideChar): HCkTask; stdcall;
  TCkImap_SendRawCommandC = function (objHandle: HCkImap; cmd: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkImap_SendRawCommandCAsync = function (objHandle: HCkImap; cmd: HCkByteData): HCkTask; stdcall;
  TCkImap_SetDecryptCert = function (objHandle: HCkImap; cert: HCkCert): wordbool; stdcall;
  TCkImap_SetDecryptCert2 = function (objHandle: HCkImap; cert: HCkCert; key: HCkPrivateKey): wordbool; stdcall;
  TCkImap_SetFlag = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagName: PWideChar; value: Integer): wordbool; stdcall;
  TCkImap_SetFlagAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagName: PWideChar; value: Integer): HCkTask; stdcall;
  TCkImap_SetFlags = function (objHandle: HCkImap; messageSet: HCkMessageSet; flagName: PWideChar; value: Integer): wordbool; stdcall;
  TCkImap_SetFlagsAsync = function (objHandle: HCkImap; messageSet: HCkMessageSet; flagName: PWideChar; value: Integer): HCkTask; stdcall;
  TCkImap_SetMailFlag = function (objHandle: HCkImap; email: HCkEmail; flagName: PWideChar; value: Integer): wordbool; stdcall;
  TCkImap_SetMailFlagAsync = function (objHandle: HCkImap; email: HCkEmail; flagName: PWideChar; value: Integer): HCkTask; stdcall;
  TCkImap_SetQuota = function (objHandle: HCkImap; quotaRoot: PWideChar; resource: PWideChar; quota: Integer): wordbool; stdcall;
  TCkImap_SetQuotaAsync = function (objHandle: HCkImap; quotaRoot: PWideChar; resource: PWideChar; quota: Integer): HCkTask; stdcall;
  TCkImap_SetSslClientCert = function (objHandle: HCkImap; cert: HCkCert): wordbool; stdcall;
  TCkImap_SetSslClientCertPem = function (objHandle: HCkImap; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool; stdcall;
  TCkImap_SetSslClientCertPfx = function (objHandle: HCkImap; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkImap_Sort = function (objHandle: HCkImap; sortCriteria: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkMessageSet; stdcall;
  TCkImap_SortAsync = function (objHandle: HCkImap; sortCriteria: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkTask; stdcall;
  TCkImap_SshAuthenticatePk = function (objHandle: HCkImap; sshLogin: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkImap_SshAuthenticatePkAsync = function (objHandle: HCkImap; sshLogin: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkImap_SshAuthenticatePw = function (objHandle: HCkImap; sshLogin: PWideChar; sshPassword: PWideChar): wordbool; stdcall;
  TCkImap_SshAuthenticatePwAsync = function (objHandle: HCkImap; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask; stdcall;
  TCkImap_SshCloseTunnel = function (objHandle: HCkImap): wordbool; stdcall;
  TCkImap_SshCloseTunnelAsync = function (objHandle: HCkImap): HCkTask; stdcall;
  TCkImap_SshOpenTunnel = function (objHandle: HCkImap; sshHostname: PWideChar; sshPort: Integer): wordbool; stdcall;
  TCkImap_SshOpenTunnelAsync = function (objHandle: HCkImap; sshHostname: PWideChar; sshPort: Integer): HCkTask; stdcall;
  TCkImap_StoreFlags = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagNames: PWideChar; value: Integer): wordbool; stdcall;
  TCkImap_StoreFlagsAsync = function (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagNames: PWideChar; value: Integer): HCkTask; stdcall;
  TCkImap_Subscribe = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_SubscribeAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_ThreadCmd = function (objHandle: HCkImap; threadAlg: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkJsonObject; stdcall;
  TCkImap_ThreadCmdAsync = function (objHandle: HCkImap; threadAlg: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkTask; stdcall;
  TCkImap_Unsubscribe = function (objHandle: HCkImap; mailbox: PWideChar): wordbool; stdcall;
  TCkImap_UnsubscribeAsync = function (objHandle: HCkImap; mailbox: PWideChar): HCkTask; stdcall;
  TCkImap_UseCertVault = function (objHandle: HCkImap; vault: HCkXmlCertVault): wordbool; stdcall;
  TCkImap_UseSsh = function (objHandle: HCkImap; ssh: HCkSsh): wordbool; stdcall;
  TCkImap_UseSshTunnel = function (objHandle: HCkImap; tunnel: HCkSocket): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..341] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkImap_Create : HCkImap;
begin
  result := TCkImap_Create(_map(0, 'CkImap_Create'));
end;

procedure CkImap_Dispose (handle: HCkImap);
begin
  TCkImap_Dispose(_map(1, 'CkImap_Dispose'))
    (handle);
end;


procedure CkImap_SetAbortCheck (objHandle: HCkImap; fn: TImapAbortCheck);
begin
    TCkImap_SetAbortCheck(_map(2, 'CkImap_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkImap_SetProgressInfo (objHandle: HCkImap; fn: TImapProgressInfo);
begin
    TCkImap_SetProgressInfo(_map(3, 'CkImap_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkImap_SetPercentDone (objHandle: HCkImap; fn: TImapPercentDone);
begin
    TCkImap_SetPercentDone(_map(4, 'CkImap_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkImap_SetTaskCompleted (objHandle: HCkImap; fn: TImapTaskCompleted);
begin
    TCkImap_SetTaskCompleted(_map(5, 'CkImap_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkImap_getAbortCurrent (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getAbortCurrent(_map(6, 'CkImap_getAbortCurrent'))
    (objHandle);
end;

procedure CkImap_putAbortCurrent (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putAbortCurrent(_map(7, 'CkImap_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkImap_getAppendSeen (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getAppendSeen(_map(8, 'CkImap_getAppendSeen'))
    (objHandle);
end;

procedure CkImap_putAppendSeen (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putAppendSeen(_map(9, 'CkImap_putAppendSeen'))
    (objHandle, newPropVal);
end;

function CkImap_getAppendUid (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getAppendUid(_map(10, 'CkImap_getAppendUid'))
    (objHandle);
end;

procedure CkImap_getAuthMethod (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getAuthMethod(_map(11, 'CkImap_getAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkImap_putAuthMethod (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putAuthMethod(_map(12, 'CkImap_putAuthMethod'))
    (objHandle, newPropVal);
end;

function CkImap__authMethod (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__authMethod(_map(13, 'CkImap__authMethod'))
    (objHandle);
end;

procedure CkImap_getAuthzId (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getAuthzId(_map(14, 'CkImap_getAuthzId'))
    (objHandle, outPropVal);
end;

procedure CkImap_putAuthzId (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putAuthzId(_map(15, 'CkImap_putAuthzId'))
    (objHandle, newPropVal);
end;

function CkImap__authzId (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__authzId(_map(16, 'CkImap__authzId'))
    (objHandle);
end;

function CkImap_getAutoDownloadAttachments (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getAutoDownloadAttachments(_map(17, 'CkImap_getAutoDownloadAttachments'))
    (objHandle);
end;

procedure CkImap_putAutoDownloadAttachments (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putAutoDownloadAttachments(_map(18, 'CkImap_putAutoDownloadAttachments'))
    (objHandle, newPropVal);
end;

function CkImap_getAutoFix (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getAutoFix(_map(19, 'CkImap_getAutoFix'))
    (objHandle);
end;

procedure CkImap_putAutoFix (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putAutoFix(_map(20, 'CkImap_putAutoFix'))
    (objHandle, newPropVal);
end;

procedure CkImap_getClientIpAddress (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getClientIpAddress(_map(21, 'CkImap_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkImap_putClientIpAddress (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putClientIpAddress(_map(22, 'CkImap_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkImap__clientIpAddress (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__clientIpAddress(_map(23, 'CkImap__clientIpAddress'))
    (objHandle);
end;

procedure CkImap_getConnectedToHost (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getConnectedToHost(_map(24, 'CkImap_getConnectedToHost'))
    (objHandle, outPropVal);
end;

function CkImap__connectedToHost (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__connectedToHost(_map(25, 'CkImap__connectedToHost'))
    (objHandle);
end;

function CkImap_getConnectTimeout (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getConnectTimeout(_map(26, 'CkImap_getConnectTimeout'))
    (objHandle);
end;

procedure CkImap_putConnectTimeout (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putConnectTimeout(_map(27, 'CkImap_putConnectTimeout'))
    (objHandle, newPropVal);
end;

procedure CkImap_getDebugLogFilePath (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getDebugLogFilePath(_map(28, 'CkImap_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkImap_putDebugLogFilePath (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putDebugLogFilePath(_map(29, 'CkImap_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkImap__debugLogFilePath (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__debugLogFilePath(_map(30, 'CkImap__debugLogFilePath'))
    (objHandle);
end;

procedure CkImap_getDomain (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getDomain(_map(31, 'CkImap_getDomain'))
    (objHandle, outPropVal);
end;

procedure CkImap_putDomain (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putDomain(_map(32, 'CkImap_putDomain'))
    (objHandle, newPropVal);
end;

function CkImap__domain (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__domain(_map(33, 'CkImap__domain'))
    (objHandle);
end;

function CkImap_getHeartbeatMs (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getHeartbeatMs(_map(34, 'CkImap_getHeartbeatMs'))
    (objHandle);
end;

procedure CkImap_putHeartbeatMs (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putHeartbeatMs(_map(35, 'CkImap_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkImap_getHighestModSeq (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getHighestModSeq(_map(36, 'CkImap_getHighestModSeq'))
    (objHandle, outPropVal);
end;

function CkImap__highestModSeq (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__highestModSeq(_map(37, 'CkImap__highestModSeq'))
    (objHandle);
end;

procedure CkImap_getHttpProxyAuthMethod (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getHttpProxyAuthMethod(_map(38, 'CkImap_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkImap_putHttpProxyAuthMethod (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putHttpProxyAuthMethod(_map(39, 'CkImap_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkImap__httpProxyAuthMethod (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__httpProxyAuthMethod(_map(40, 'CkImap__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkImap_getHttpProxyDomain (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getHttpProxyDomain(_map(41, 'CkImap_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkImap_putHttpProxyDomain (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putHttpProxyDomain(_map(42, 'CkImap_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkImap__httpProxyDomain (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__httpProxyDomain(_map(43, 'CkImap__httpProxyDomain'))
    (objHandle);
end;

procedure CkImap_getHttpProxyHostname (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getHttpProxyHostname(_map(44, 'CkImap_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkImap_putHttpProxyHostname (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putHttpProxyHostname(_map(45, 'CkImap_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkImap__httpProxyHostname (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__httpProxyHostname(_map(46, 'CkImap__httpProxyHostname'))
    (objHandle);
end;

procedure CkImap_getHttpProxyPassword (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getHttpProxyPassword(_map(47, 'CkImap_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkImap_putHttpProxyPassword (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putHttpProxyPassword(_map(48, 'CkImap_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkImap__httpProxyPassword (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__httpProxyPassword(_map(49, 'CkImap__httpProxyPassword'))
    (objHandle);
end;

function CkImap_getHttpProxyPort (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getHttpProxyPort(_map(50, 'CkImap_getHttpProxyPort'))
    (objHandle);
end;

procedure CkImap_putHttpProxyPort (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putHttpProxyPort(_map(51, 'CkImap_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkImap_getHttpProxyUsername (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getHttpProxyUsername(_map(52, 'CkImap_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkImap_putHttpProxyUsername (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putHttpProxyUsername(_map(53, 'CkImap_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkImap__httpProxyUsername (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__httpProxyUsername(_map(54, 'CkImap__httpProxyUsername'))
    (objHandle);
end;

function CkImap_getKeepSessionLog (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getKeepSessionLog(_map(55, 'CkImap_getKeepSessionLog'))
    (objHandle);
end;

procedure CkImap_putKeepSessionLog (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putKeepSessionLog(_map(56, 'CkImap_putKeepSessionLog'))
    (objHandle, newPropVal);
end;

procedure CkImap_getLastAppendedMime (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastAppendedMime(_map(57, 'CkImap_getLastAppendedMime'))
    (objHandle, outPropVal);
end;

function CkImap__lastAppendedMime (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastAppendedMime(_map(58, 'CkImap__lastAppendedMime'))
    (objHandle);
end;

procedure CkImap_getLastCommand (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastCommand(_map(59, 'CkImap_getLastCommand'))
    (objHandle, outPropVal);
end;

function CkImap__lastCommand (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastCommand(_map(60, 'CkImap__lastCommand'))
    (objHandle);
end;

procedure CkImap_getLastErrorHtml (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastErrorHtml(_map(61, 'CkImap_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkImap__lastErrorHtml (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastErrorHtml(_map(62, 'CkImap__lastErrorHtml'))
    (objHandle);
end;

procedure CkImap_getLastErrorText (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastErrorText(_map(63, 'CkImap_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkImap__lastErrorText (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastErrorText(_map(64, 'CkImap__lastErrorText'))
    (objHandle);
end;

procedure CkImap_getLastErrorXml (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastErrorXml(_map(65, 'CkImap_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkImap__lastErrorXml (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastErrorXml(_map(66, 'CkImap__lastErrorXml'))
    (objHandle);
end;

procedure CkImap_getLastIntermediateResponse (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastIntermediateResponse(_map(67, 'CkImap_getLastIntermediateResponse'))
    (objHandle, outPropVal);
end;

function CkImap__lastIntermediateResponse (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastIntermediateResponse(_map(68, 'CkImap__lastIntermediateResponse'))
    (objHandle);
end;

function CkImap_getLastMethodSuccess (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getLastMethodSuccess(_map(69, 'CkImap_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkImap_putLastMethodSuccess (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putLastMethodSuccess(_map(70, 'CkImap_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkImap_getLastResponse (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastResponse(_map(71, 'CkImap_getLastResponse'))
    (objHandle, outPropVal);
end;

function CkImap__lastResponse (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastResponse(_map(72, 'CkImap__lastResponse'))
    (objHandle);
end;

procedure CkImap_getLastResponseCode (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLastResponseCode(_map(73, 'CkImap_getLastResponseCode'))
    (objHandle, outPropVal);
end;

function CkImap__lastResponseCode (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__lastResponseCode(_map(74, 'CkImap__lastResponseCode'))
    (objHandle);
end;

procedure CkImap_getLoggedInUser (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getLoggedInUser(_map(75, 'CkImap_getLoggedInUser'))
    (objHandle, outPropVal);
end;

function CkImap__loggedInUser (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__loggedInUser(_map(76, 'CkImap__loggedInUser'))
    (objHandle);
end;

function CkImap_getNumMessages (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getNumMessages(_map(77, 'CkImap_getNumMessages'))
    (objHandle);
end;

function CkImap_getPeekMode (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getPeekMode(_map(78, 'CkImap_getPeekMode'))
    (objHandle);
end;

procedure CkImap_putPeekMode (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putPeekMode(_map(79, 'CkImap_putPeekMode'))
    (objHandle, newPropVal);
end;

function CkImap_getPercentDoneScale (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getPercentDoneScale(_map(80, 'CkImap_getPercentDoneScale'))
    (objHandle);
end;

procedure CkImap_putPercentDoneScale (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putPercentDoneScale(_map(81, 'CkImap_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkImap_getPort (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getPort(_map(82, 'CkImap_getPort'))
    (objHandle);
end;

procedure CkImap_putPort (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putPort(_map(83, 'CkImap_putPort'))
    (objHandle, newPropVal);
end;

function CkImap_getPreferIpv6 (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getPreferIpv6(_map(84, 'CkImap_getPreferIpv6'))
    (objHandle);
end;

procedure CkImap_putPreferIpv6 (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putPreferIpv6(_map(85, 'CkImap_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkImap_getReadTimeout (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getReadTimeout(_map(86, 'CkImap_getReadTimeout'))
    (objHandle);
end;

procedure CkImap_putReadTimeout (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putReadTimeout(_map(87, 'CkImap_putReadTimeout'))
    (objHandle, newPropVal);
end;

function CkImap_getRequireSslCertVerify (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getRequireSslCertVerify(_map(88, 'CkImap_getRequireSslCertVerify'))
    (objHandle);
end;

procedure CkImap_putRequireSslCertVerify (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putRequireSslCertVerify(_map(89, 'CkImap_putRequireSslCertVerify'))
    (objHandle, newPropVal);
end;

procedure CkImap_getSearchCharset (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSearchCharset(_map(90, 'CkImap_getSearchCharset'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSearchCharset (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSearchCharset(_map(91, 'CkImap_putSearchCharset'))
    (objHandle, newPropVal);
end;

function CkImap__searchCharset (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__searchCharset(_map(92, 'CkImap__searchCharset'))
    (objHandle);
end;

procedure CkImap_getSelectedMailbox (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSelectedMailbox(_map(93, 'CkImap_getSelectedMailbox'))
    (objHandle, outPropVal);
end;

function CkImap__selectedMailbox (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__selectedMailbox(_map(94, 'CkImap__selectedMailbox'))
    (objHandle);
end;

function CkImap_getSendBufferSize (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getSendBufferSize(_map(95, 'CkImap_getSendBufferSize'))
    (objHandle);
end;

procedure CkImap_putSendBufferSize (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putSendBufferSize(_map(96, 'CkImap_putSendBufferSize'))
    (objHandle, newPropVal);
end;

procedure CkImap_getSeparatorChar (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSeparatorChar(_map(97, 'CkImap_getSeparatorChar'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSeparatorChar (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSeparatorChar(_map(98, 'CkImap_putSeparatorChar'))
    (objHandle, newPropVal);
end;

function CkImap__separatorChar (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__separatorChar(_map(99, 'CkImap__separatorChar'))
    (objHandle);
end;

procedure CkImap_getSessionLog (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSessionLog(_map(100, 'CkImap_getSessionLog'))
    (objHandle, outPropVal);
end;

function CkImap__sessionLog (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__sessionLog(_map(101, 'CkImap__sessionLog'))
    (objHandle);
end;

procedure CkImap_getSocksHostname (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSocksHostname(_map(102, 'CkImap_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSocksHostname (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSocksHostname(_map(103, 'CkImap_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkImap__socksHostname (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__socksHostname(_map(104, 'CkImap__socksHostname'))
    (objHandle);
end;

procedure CkImap_getSocksPassword (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSocksPassword(_map(105, 'CkImap_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSocksPassword (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSocksPassword(_map(106, 'CkImap_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkImap__socksPassword (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__socksPassword(_map(107, 'CkImap__socksPassword'))
    (objHandle);
end;

function CkImap_getSocksPort (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getSocksPort(_map(108, 'CkImap_getSocksPort'))
    (objHandle);
end;

procedure CkImap_putSocksPort (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putSocksPort(_map(109, 'CkImap_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkImap_getSocksUsername (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSocksUsername(_map(110, 'CkImap_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSocksUsername (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSocksUsername(_map(111, 'CkImap_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkImap__socksUsername (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__socksUsername(_map(112, 'CkImap__socksUsername'))
    (objHandle);
end;

function CkImap_getSocksVersion (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getSocksVersion(_map(113, 'CkImap_getSocksVersion'))
    (objHandle);
end;

procedure CkImap_putSocksVersion (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putSocksVersion(_map(114, 'CkImap_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkImap_getSoRcvBuf (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getSoRcvBuf(_map(115, 'CkImap_getSoRcvBuf'))
    (objHandle);
end;

procedure CkImap_putSoRcvBuf (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putSoRcvBuf(_map(116, 'CkImap_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

procedure CkImap_getSortCriteria (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSortCriteria(_map(117, 'CkImap_getSortCriteria'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSortCriteria (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSortCriteria(_map(118, 'CkImap_putSortCriteria'))
    (objHandle, newPropVal);
end;

function CkImap__sortCriteria (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__sortCriteria(_map(119, 'CkImap__sortCriteria'))
    (objHandle);
end;

function CkImap_getSoSndBuf (objHandle: HCkImap): Integer;
begin
    result := TCkImap_getSoSndBuf(_map(120, 'CkImap_getSoSndBuf'))
    (objHandle);
end;

procedure CkImap_putSoSndBuf (objHandle: HCkImap; newPropVal: Integer);
begin
  TCkImap_putSoSndBuf(_map(121, 'CkImap_putSoSndBuf'))
    (objHandle, newPropVal);
end;

function CkImap_getSsl (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getSsl(_map(122, 'CkImap_getSsl'))
    (objHandle);
end;

procedure CkImap_putSsl (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putSsl(_map(123, 'CkImap_putSsl'))
    (objHandle, newPropVal);
end;

procedure CkImap_getSslAllowedCiphers (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSslAllowedCiphers(_map(124, 'CkImap_getSslAllowedCiphers'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSslAllowedCiphers (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSslAllowedCiphers(_map(125, 'CkImap_putSslAllowedCiphers'))
    (objHandle, newPropVal);
end;

function CkImap__sslAllowedCiphers (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__sslAllowedCiphers(_map(126, 'CkImap__sslAllowedCiphers'))
    (objHandle);
end;

procedure CkImap_getSslProtocol (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getSslProtocol(_map(127, 'CkImap_getSslProtocol'))
    (objHandle, outPropVal);
end;

procedure CkImap_putSslProtocol (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putSslProtocol(_map(128, 'CkImap_putSslProtocol'))
    (objHandle, newPropVal);
end;

function CkImap__sslProtocol (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__sslProtocol(_map(129, 'CkImap__sslProtocol'))
    (objHandle);
end;

function CkImap_getSslServerCertVerified (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getSslServerCertVerified(_map(130, 'CkImap_getSslServerCertVerified'))
    (objHandle);
end;

function CkImap_getStartTls (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getStartTls(_map(131, 'CkImap_getStartTls'))
    (objHandle);
end;

procedure CkImap_putStartTls (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putStartTls(_map(132, 'CkImap_putStartTls'))
    (objHandle, newPropVal);
end;

procedure CkImap_getTlsCipherSuite (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getTlsCipherSuite(_map(133, 'CkImap_getTlsCipherSuite'))
    (objHandle, outPropVal);
end;

function CkImap__tlsCipherSuite (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__tlsCipherSuite(_map(134, 'CkImap__tlsCipherSuite'))
    (objHandle);
end;

procedure CkImap_getTlsPinSet (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getTlsPinSet(_map(135, 'CkImap_getTlsPinSet'))
    (objHandle, outPropVal);
end;

procedure CkImap_putTlsPinSet (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putTlsPinSet(_map(136, 'CkImap_putTlsPinSet'))
    (objHandle, newPropVal);
end;

function CkImap__tlsPinSet (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__tlsPinSet(_map(137, 'CkImap__tlsPinSet'))
    (objHandle);
end;

procedure CkImap_getTlsVersion (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getTlsVersion(_map(138, 'CkImap_getTlsVersion'))
    (objHandle, outPropVal);
end;

function CkImap__tlsVersion (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__tlsVersion(_map(139, 'CkImap__tlsVersion'))
    (objHandle);
end;

function CkImap_getUidNext (objHandle: HCkImap): LongWord;
begin
    result := TCkImap_getUidNext(_map(140, 'CkImap_getUidNext'))
    (objHandle);
end;

function CkImap_getUidValidity (objHandle: HCkImap): LongWord;
begin
    result := TCkImap_getUidValidity(_map(141, 'CkImap_getUidValidity'))
    (objHandle);
end;

procedure CkImap_getUncommonOptions (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getUncommonOptions(_map(142, 'CkImap_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkImap_putUncommonOptions (objHandle: HCkImap; newPropVal: PWideChar);
begin
  TCkImap_putUncommonOptions(_map(143, 'CkImap_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkImap__uncommonOptions (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__uncommonOptions(_map(144, 'CkImap__uncommonOptions'))
    (objHandle);
end;

function CkImap_getVerboseLogging (objHandle: HCkImap): wordbool;
begin
    result := TCkImap_getVerboseLogging(_map(145, 'CkImap_getVerboseLogging'))
    (objHandle);
end;

procedure CkImap_putVerboseLogging (objHandle: HCkImap; newPropVal: wordbool);
begin
  TCkImap_putVerboseLogging(_map(146, 'CkImap_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkImap_getVersion (objHandle: HCkImap; outPropVal: HCkString);
begin
  TCkImap_getVersion(_map(147, 'CkImap_getVersion'))
    (objHandle, outPropVal);
end;

function CkImap__version (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__version(_map(148, 'CkImap__version'))
    (objHandle);
end;

function CkImap_AddPfxSourceBd (objHandle: HCkImap; bd: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkImap_AddPfxSourceBd(_map(149, 'CkImap_AddPfxSourceBd'))
    (objHandle, bd, password);
end;

function CkImap_AddPfxSourceData (objHandle: HCkImap; pfxBytes: HCkByteData; pfxPassword: PWideChar): wordbool;
begin
  result := TCkImap_AddPfxSourceData(_map(150, 'CkImap_AddPfxSourceData'))
    (objHandle, pfxBytes, pfxPassword);
end;

function CkImap_AddPfxSourceFile (objHandle: HCkImap; pfxFilePath: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkImap_AddPfxSourceFile(_map(151, 'CkImap_AddPfxSourceFile'))
    (objHandle, pfxFilePath, pfxPassword);
end;

function CkImap_AppendMail (objHandle: HCkImap; mailbox: PWideChar; email: HCkEmail): wordbool;
begin
  result := TCkImap_AppendMail(_map(152, 'CkImap_AppendMail'))
    (objHandle, mailbox, email);
end;

function CkImap_AppendMailAsync (objHandle: HCkImap; mailbox: PWideChar; email: HCkEmail): HCkTask;
begin
  result := TCkImap_AppendMailAsync(_map(153, 'CkImap_AppendMailAsync'))
    (objHandle, mailbox, email);
end;

function CkImap_AppendMime (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar): wordbool;
begin
  result := TCkImap_AppendMime(_map(154, 'CkImap_AppendMime'))
    (objHandle, mailbox, mimeText);
end;

function CkImap_AppendMimeAsync (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar): HCkTask;
begin
  result := TCkImap_AppendMimeAsync(_map(155, 'CkImap_AppendMimeAsync'))
    (objHandle, mailbox, mimeText);
end;

function CkImap_AppendMimeWithDateStr (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; internalDateStr: PWideChar): wordbool;
begin
  result := TCkImap_AppendMimeWithDateStr(_map(156, 'CkImap_AppendMimeWithDateStr'))
    (objHandle, mailbox, mimeText, internalDateStr);
end;

function CkImap_AppendMimeWithDateStrAsync (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; internalDateStr: PWideChar): HCkTask;
begin
  result := TCkImap_AppendMimeWithDateStrAsync(_map(157, 'CkImap_AppendMimeWithDateStrAsync'))
    (objHandle, mailbox, mimeText, internalDateStr);
end;

function CkImap_AppendMimeWithFlags (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): wordbool;
begin
  result := TCkImap_AppendMimeWithFlags(_map(158, 'CkImap_AppendMimeWithFlags'))
    (objHandle, mailbox, mimeText, seen, flagged, answered, draft);
end;

function CkImap_AppendMimeWithFlagsAsync (objHandle: HCkImap; mailbox: PWideChar; mimeText: PWideChar; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): HCkTask;
begin
  result := TCkImap_AppendMimeWithFlagsAsync(_map(159, 'CkImap_AppendMimeWithFlagsAsync'))
    (objHandle, mailbox, mimeText, seen, flagged, answered, draft);
end;

function CkImap_AppendMimeWithFlagsSb (objHandle: HCkImap; mailbox: PWideChar; sbMime: HCkStringBuilder; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): wordbool;
begin
  result := TCkImap_AppendMimeWithFlagsSb(_map(160, 'CkImap_AppendMimeWithFlagsSb'))
    (objHandle, mailbox, sbMime, seen, flagged, answered, draft);
end;

function CkImap_AppendMimeWithFlagsSbAsync (objHandle: HCkImap; mailbox: PWideChar; sbMime: HCkStringBuilder; seen: wordbool; flagged: wordbool; answered: wordbool; draft: wordbool): HCkTask;
begin
  result := TCkImap_AppendMimeWithFlagsSbAsync(_map(161, 'CkImap_AppendMimeWithFlagsSbAsync'))
    (objHandle, mailbox, sbMime, seen, flagged, answered, draft);
end;

function CkImap_Capability (objHandle: HCkImap; outStr: HCkString): wordbool;
begin
  result := TCkImap_Capability(_map(162, 'CkImap_Capability'))
    (objHandle, outStr);
end;

function CkImap__capability (objHandle: HCkImap): PWideChar;
begin
  result := TCkImap__capability(_map(163, 'CkImap__capability'))
    (objHandle);
end;

function CkImap_CapabilityAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_CapabilityAsync(_map(164, 'CkImap_CapabilityAsync'))
    (objHandle);
end;

function CkImap_CheckConnection (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_CheckConnection(_map(165, 'CkImap_CheckConnection'))
    (objHandle);
end;

function CkImap_CheckForNewEmail (objHandle: HCkImap): HCkMessageSet;
begin
  result := TCkImap_CheckForNewEmail(_map(166, 'CkImap_CheckForNewEmail'))
    (objHandle);
end;

function CkImap_CheckForNewEmailAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_CheckForNewEmailAsync(_map(167, 'CkImap_CheckForNewEmailAsync'))
    (objHandle);
end;

procedure CkImap_ClearSessionLog (objHandle: HCkImap);
begin
  TCkImap_ClearSessionLog(_map(168, 'CkImap_ClearSessionLog'))
    (objHandle);
end;

function CkImap_CloseMailbox (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_CloseMailbox(_map(169, 'CkImap_CloseMailbox'))
    (objHandle, mailbox);
end;

function CkImap_CloseMailboxAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_CloseMailboxAsync(_map(170, 'CkImap_CloseMailboxAsync'))
    (objHandle, mailbox);
end;

function CkImap_Connect (objHandle: HCkImap; domainName: PWideChar): wordbool;
begin
  result := TCkImap_Connect(_map(171, 'CkImap_Connect'))
    (objHandle, domainName);
end;

function CkImap_ConnectAsync (objHandle: HCkImap; domainName: PWideChar): HCkTask;
begin
  result := TCkImap_ConnectAsync(_map(172, 'CkImap_ConnectAsync'))
    (objHandle, domainName);
end;

function CkImap_Copy (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; copyToMailbox: PWideChar): wordbool;
begin
  result := TCkImap_Copy(_map(173, 'CkImap_Copy'))
    (objHandle, msgId, bUid, copyToMailbox);
end;

function CkImap_CopyAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; copyToMailbox: PWideChar): HCkTask;
begin
  result := TCkImap_CopyAsync(_map(174, 'CkImap_CopyAsync'))
    (objHandle, msgId, bUid, copyToMailbox);
end;

function CkImap_CopyMultiple (objHandle: HCkImap; messageSet: HCkMessageSet; copyToMailbox: PWideChar): wordbool;
begin
  result := TCkImap_CopyMultiple(_map(175, 'CkImap_CopyMultiple'))
    (objHandle, messageSet, copyToMailbox);
end;

function CkImap_CopyMultipleAsync (objHandle: HCkImap; messageSet: HCkMessageSet; copyToMailbox: PWideChar): HCkTask;
begin
  result := TCkImap_CopyMultipleAsync(_map(176, 'CkImap_CopyMultipleAsync'))
    (objHandle, messageSet, copyToMailbox);
end;

function CkImap_CopySequence (objHandle: HCkImap; startSeqNum: Integer; count: Integer; copyToMailbox: PWideChar): wordbool;
begin
  result := TCkImap_CopySequence(_map(177, 'CkImap_CopySequence'))
    (objHandle, startSeqNum, count, copyToMailbox);
end;

function CkImap_CopySequenceAsync (objHandle: HCkImap; startSeqNum: Integer; count: Integer; copyToMailbox: PWideChar): HCkTask;
begin
  result := TCkImap_CopySequenceAsync(_map(178, 'CkImap_CopySequenceAsync'))
    (objHandle, startSeqNum, count, copyToMailbox);
end;

function CkImap_CreateMailbox (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_CreateMailbox(_map(179, 'CkImap_CreateMailbox'))
    (objHandle, mailbox);
end;

function CkImap_CreateMailboxAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_CreateMailboxAsync(_map(180, 'CkImap_CreateMailboxAsync'))
    (objHandle, mailbox);
end;

function CkImap_DeleteMailbox (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_DeleteMailbox(_map(181, 'CkImap_DeleteMailbox'))
    (objHandle, mailbox);
end;

function CkImap_DeleteMailboxAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_DeleteMailboxAsync(_map(182, 'CkImap_DeleteMailboxAsync'))
    (objHandle, mailbox);
end;

function CkImap_Disconnect (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_Disconnect(_map(183, 'CkImap_Disconnect'))
    (objHandle);
end;

function CkImap_DisconnectAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_DisconnectAsync(_map(184, 'CkImap_DisconnectAsync'))
    (objHandle);
end;

function CkImap_ExamineMailbox (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_ExamineMailbox(_map(185, 'CkImap_ExamineMailbox'))
    (objHandle, mailbox);
end;

function CkImap_ExamineMailboxAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_ExamineMailboxAsync(_map(186, 'CkImap_ExamineMailboxAsync'))
    (objHandle, mailbox);
end;

function CkImap_Expunge (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_Expunge(_map(187, 'CkImap_Expunge'))
    (objHandle);
end;

function CkImap_ExpungeAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_ExpungeAsync(_map(188, 'CkImap_ExpungeAsync'))
    (objHandle);
end;

function CkImap_ExpungeAndClose (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_ExpungeAndClose(_map(189, 'CkImap_ExpungeAndClose'))
    (objHandle);
end;

function CkImap_ExpungeAndCloseAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_ExpungeAndCloseAsync(_map(190, 'CkImap_ExpungeAndCloseAsync'))
    (objHandle);
end;

function CkImap_FetchAttachment (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; saveToPath: PWideChar): wordbool;
begin
  result := TCkImap_FetchAttachment(_map(191, 'CkImap_FetchAttachment'))
    (objHandle, emailObject, attachmentIndex, saveToPath);
end;

function CkImap_FetchAttachmentAsync (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; saveToPath: PWideChar): HCkTask;
begin
  result := TCkImap_FetchAttachmentAsync(_map(192, 'CkImap_FetchAttachmentAsync'))
    (objHandle, emailObject, attachmentIndex, saveToPath);
end;

function CkImap_FetchAttachmentBd (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; binData: HCkBinData): wordbool;
begin
  result := TCkImap_FetchAttachmentBd(_map(193, 'CkImap_FetchAttachmentBd'))
    (objHandle, email, attachmentIndex, binData);
end;

function CkImap_FetchAttachmentBdAsync (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; binData: HCkBinData): HCkTask;
begin
  result := TCkImap_FetchAttachmentBdAsync(_map(194, 'CkImap_FetchAttachmentBdAsync'))
    (objHandle, email, attachmentIndex, binData);
end;

function CkImap_FetchAttachmentBytes (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkImap_FetchAttachmentBytes(_map(195, 'CkImap_FetchAttachmentBytes'))
    (objHandle, email, attachIndex, outData);
end;

function CkImap_FetchAttachmentBytesAsync (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): HCkTask;
begin
  result := TCkImap_FetchAttachmentBytesAsync(_map(196, 'CkImap_FetchAttachmentBytesAsync'))
    (objHandle, email, attachIndex);
end;

function CkImap_FetchAttachmentSb (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; charset: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkImap_FetchAttachmentSb(_map(197, 'CkImap_FetchAttachmentSb'))
    (objHandle, email, attachmentIndex, charset, sb);
end;

function CkImap_FetchAttachmentSbAsync (objHandle: HCkImap; email: HCkEmail; attachmentIndex: Integer; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkImap_FetchAttachmentSbAsync(_map(198, 'CkImap_FetchAttachmentSbAsync'))
    (objHandle, email, attachmentIndex, charset, sb);
end;

function CkImap_FetchAttachmentString (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkImap_FetchAttachmentString(_map(199, 'CkImap_FetchAttachmentString'))
    (objHandle, emailObject, attachmentIndex, charset, outStr);
end;

function CkImap__fetchAttachmentString (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkImap__fetchAttachmentString(_map(200, 'CkImap__fetchAttachmentString'))
    (objHandle, emailObject, attachmentIndex, charset);
end;

function CkImap_FetchAttachmentStringAsync (objHandle: HCkImap; emailObject: HCkEmail; attachmentIndex: Integer; charset: PWideChar): HCkTask;
begin
  result := TCkImap_FetchAttachmentStringAsync(_map(201, 'CkImap_FetchAttachmentStringAsync'))
    (objHandle, emailObject, attachmentIndex, charset);
end;

function CkImap_FetchBundle (objHandle: HCkImap; messageSet: HCkMessageSet): HCkEmailBundle;
begin
  result := TCkImap_FetchBundle(_map(202, 'CkImap_FetchBundle'))
    (objHandle, messageSet);
end;

function CkImap_FetchBundleAsync (objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask;
begin
  result := TCkImap_FetchBundleAsync(_map(203, 'CkImap_FetchBundleAsync'))
    (objHandle, messageSet);
end;

function CkImap_FetchBundleAsMime (objHandle: HCkImap; messageSet: HCkMessageSet): HCkStringArray;
begin
  result := TCkImap_FetchBundleAsMime(_map(204, 'CkImap_FetchBundleAsMime'))
    (objHandle, messageSet);
end;

function CkImap_FetchBundleAsMimeAsync (objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask;
begin
  result := TCkImap_FetchBundleAsMimeAsync(_map(205, 'CkImap_FetchBundleAsMimeAsync'))
    (objHandle, messageSet);
end;

function CkImap_FetchChunk (objHandle: HCkImap; startSeqNum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet): HCkEmailBundle;
begin
  result := TCkImap_FetchChunk(_map(206, 'CkImap_FetchChunk'))
    (objHandle, startSeqNum, count, failedSet, fetchedSet);
end;

function CkImap_FetchChunkAsync (objHandle: HCkImap; startSeqNum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet): HCkTask;
begin
  result := TCkImap_FetchChunkAsync(_map(207, 'CkImap_FetchChunkAsync'))
    (objHandle, startSeqNum, count, failedSet, fetchedSet);
end;

function CkImap_FetchChunk2 (objHandle: HCkImap; seqnum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkImap_FetchChunk2(_map(208, 'CkImap_FetchChunk2'))
    (objHandle, seqnum, count, failedSet, fetchedSet, bundle);
end;

function CkImap_FetchChunk2Async (objHandle: HCkImap; seqnum: Integer; count: Integer; failedSet: HCkMessageSet; fetchedSet: HCkMessageSet; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkImap_FetchChunk2Async(_map(209, 'CkImap_FetchChunk2Async'))
    (objHandle, seqnum, count, failedSet, fetchedSet, bundle);
end;

function CkImap_FetchEmail (objHandle: HCkImap; headerOnly: wordbool; msgId: LongWord; bUid: wordbool; email: HCkEmail): wordbool;
begin
  result := TCkImap_FetchEmail(_map(210, 'CkImap_FetchEmail'))
    (objHandle, headerOnly, msgId, bUid, email);
end;

function CkImap_FetchEmailAsync (objHandle: HCkImap; headerOnly: wordbool; msgId: LongWord; bUid: wordbool; email: HCkEmail): HCkTask;
begin
  result := TCkImap_FetchEmailAsync(_map(211, 'CkImap_FetchEmailAsync'))
    (objHandle, headerOnly, msgId, bUid, email);
end;

function CkImap_FetchFlags (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkImap_FetchFlags(_map(212, 'CkImap_FetchFlags'))
    (objHandle, msgId, bUid, outStr);
end;

function CkImap__fetchFlags (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): PWideChar;
begin
  result := TCkImap__fetchFlags(_map(213, 'CkImap__fetchFlags'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchFlagsAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
begin
  result := TCkImap_FetchFlagsAsync(_map(214, 'CkImap_FetchFlagsAsync'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchHeaders (objHandle: HCkImap; messageSet: HCkMessageSet): HCkEmailBundle;
begin
  result := TCkImap_FetchHeaders(_map(215, 'CkImap_FetchHeaders'))
    (objHandle, messageSet);
end;

function CkImap_FetchHeadersAsync (objHandle: HCkImap; messageSet: HCkMessageSet): HCkTask;
begin
  result := TCkImap_FetchHeadersAsync(_map(216, 'CkImap_FetchHeadersAsync'))
    (objHandle, messageSet);
end;

function CkImap_FetchMsgSet (objHandle: HCkImap; headersOnly: wordbool; msgSet: HCkMessageSet; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkImap_FetchMsgSet(_map(217, 'CkImap_FetchMsgSet'))
    (objHandle, headersOnly, msgSet, bundle);
end;

function CkImap_FetchMsgSetAsync (objHandle: HCkImap; headersOnly: wordbool; msgSet: HCkMessageSet; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkImap_FetchMsgSetAsync(_map(218, 'CkImap_FetchMsgSetAsync'))
    (objHandle, headersOnly, msgSet, bundle);
end;

function CkImap_FetchRange (objHandle: HCkImap; headersOnly: wordbool; seqnum: Integer; count: Integer; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkImap_FetchRange(_map(219, 'CkImap_FetchRange'))
    (objHandle, headersOnly, seqnum, count, bundle);
end;

function CkImap_FetchRangeAsync (objHandle: HCkImap; headersOnly: wordbool; seqnum: Integer; count: Integer; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkImap_FetchRangeAsync(_map(220, 'CkImap_FetchRangeAsync'))
    (objHandle, headersOnly, seqnum, count, bundle);
end;

function CkImap_FetchSequence (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkEmailBundle;
begin
  result := TCkImap_FetchSequence(_map(221, 'CkImap_FetchSequence'))
    (objHandle, startSeqNum, numMessages);
end;

function CkImap_FetchSequenceAsync (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask;
begin
  result := TCkImap_FetchSequenceAsync(_map(222, 'CkImap_FetchSequenceAsync'))
    (objHandle, startSeqNum, numMessages);
end;

function CkImap_FetchSequenceAsMime (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkStringArray;
begin
  result := TCkImap_FetchSequenceAsMime(_map(223, 'CkImap_FetchSequenceAsMime'))
    (objHandle, startSeqNum, numMessages);
end;

function CkImap_FetchSequenceAsMimeAsync (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask;
begin
  result := TCkImap_FetchSequenceAsMimeAsync(_map(224, 'CkImap_FetchSequenceAsMimeAsync'))
    (objHandle, startSeqNum, numMessages);
end;

function CkImap_FetchSequenceHeaders (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkEmailBundle;
begin
  result := TCkImap_FetchSequenceHeaders(_map(225, 'CkImap_FetchSequenceHeaders'))
    (objHandle, startSeqNum, numMessages);
end;

function CkImap_FetchSequenceHeadersAsync (objHandle: HCkImap; startSeqNum: Integer; numMessages: Integer): HCkTask;
begin
  result := TCkImap_FetchSequenceHeadersAsync(_map(226, 'CkImap_FetchSequenceHeadersAsync'))
    (objHandle, startSeqNum, numMessages);
end;

function CkImap_FetchSingle (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkEmail;
begin
  result := TCkImap_FetchSingle(_map(227, 'CkImap_FetchSingle'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchSingleAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
begin
  result := TCkImap_FetchSingleAsync(_map(228, 'CkImap_FetchSingleAsync'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchSingleAsMime (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkImap_FetchSingleAsMime(_map(229, 'CkImap_FetchSingleAsMime'))
    (objHandle, msgId, bUid, outStr);
end;

function CkImap__fetchSingleAsMime (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): PWideChar;
begin
  result := TCkImap__fetchSingleAsMime(_map(230, 'CkImap__fetchSingleAsMime'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchSingleAsMimeAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
begin
  result := TCkImap_FetchSingleAsMimeAsync(_map(231, 'CkImap_FetchSingleAsMimeAsync'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchSingleAsMimeSb (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; sbMime: HCkStringBuilder): wordbool;
begin
  result := TCkImap_FetchSingleAsMimeSb(_map(232, 'CkImap_FetchSingleAsMimeSb'))
    (objHandle, msgId, bUid, sbMime);
end;

function CkImap_FetchSingleAsMimeSbAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; sbMime: HCkStringBuilder): HCkTask;
begin
  result := TCkImap_FetchSingleAsMimeSbAsync(_map(233, 'CkImap_FetchSingleAsMimeSbAsync'))
    (objHandle, msgId, bUid, sbMime);
end;

function CkImap_FetchSingleBd (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; mimeData: HCkBinData): wordbool;
begin
  result := TCkImap_FetchSingleBd(_map(234, 'CkImap_FetchSingleBd'))
    (objHandle, msgId, bUid, mimeData);
end;

function CkImap_FetchSingleBdAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; mimeData: HCkBinData): HCkTask;
begin
  result := TCkImap_FetchSingleBdAsync(_map(235, 'CkImap_FetchSingleBdAsync'))
    (objHandle, msgId, bUid, mimeData);
end;

function CkImap_FetchSingleHeader (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkEmail;
begin
  result := TCkImap_FetchSingleHeader(_map(236, 'CkImap_FetchSingleHeader'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchSingleHeaderAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool): HCkTask;
begin
  result := TCkImap_FetchSingleHeaderAsync(_map(237, 'CkImap_FetchSingleHeaderAsync'))
    (objHandle, msgId, bUid);
end;

function CkImap_FetchSingleHeaderAsMime (objHandle: HCkImap; msgId: LongWord; bUID: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkImap_FetchSingleHeaderAsMime(_map(238, 'CkImap_FetchSingleHeaderAsMime'))
    (objHandle, msgId, bUID, outStr);
end;

function CkImap__fetchSingleHeaderAsMime (objHandle: HCkImap; msgId: LongWord; bUID: wordbool): PWideChar;
begin
  result := TCkImap__fetchSingleHeaderAsMime(_map(239, 'CkImap__fetchSingleHeaderAsMime'))
    (objHandle, msgId, bUID);
end;

function CkImap_FetchSingleHeaderAsMimeAsync (objHandle: HCkImap; msgId: LongWord; bUID: wordbool): HCkTask;
begin
  result := TCkImap_FetchSingleHeaderAsMimeAsync(_map(240, 'CkImap_FetchSingleHeaderAsMimeAsync'))
    (objHandle, msgId, bUID);
end;

function CkImap_GetAllUids (objHandle: HCkImap): HCkMessageSet;
begin
  result := TCkImap_GetAllUids(_map(241, 'CkImap_GetAllUids'))
    (objHandle);
end;

function CkImap_GetAllUidsAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_GetAllUidsAsync(_map(242, 'CkImap_GetAllUidsAsync'))
    (objHandle);
end;

function CkImap_GetMailAttachFilename (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer; outStr: HCkString): wordbool;
begin
  result := TCkImap_GetMailAttachFilename(_map(243, 'CkImap_GetMailAttachFilename'))
    (objHandle, email, attachIndex, outStr);
end;

function CkImap__getMailAttachFilename (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): PWideChar;
begin
  result := TCkImap__getMailAttachFilename(_map(244, 'CkImap__getMailAttachFilename'))
    (objHandle, email, attachIndex);
end;

function CkImap_GetMailAttachSize (objHandle: HCkImap; email: HCkEmail; attachIndex: Integer): Integer;
begin
  result := TCkImap_GetMailAttachSize(_map(245, 'CkImap_GetMailAttachSize'))
    (objHandle, email, attachIndex);
end;

function CkImap_GetMailboxStatus (objHandle: HCkImap; mailbox: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkImap_GetMailboxStatus(_map(246, 'CkImap_GetMailboxStatus'))
    (objHandle, mailbox, outStr);
end;

function CkImap__getMailboxStatus (objHandle: HCkImap; mailbox: PWideChar): PWideChar;
begin
  result := TCkImap__getMailboxStatus(_map(247, 'CkImap__getMailboxStatus'))
    (objHandle, mailbox);
end;

function CkImap_GetMailboxStatusAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_GetMailboxStatusAsync(_map(248, 'CkImap_GetMailboxStatusAsync'))
    (objHandle, mailbox);
end;

function CkImap_GetMailFlag (objHandle: HCkImap; email: HCkEmail; flagName: PWideChar): Integer;
begin
  result := TCkImap_GetMailFlag(_map(249, 'CkImap_GetMailFlag'))
    (objHandle, email, flagName);
end;

function CkImap_GetMailNumAttach (objHandle: HCkImap; email: HCkEmail): Integer;
begin
  result := TCkImap_GetMailNumAttach(_map(250, 'CkImap_GetMailNumAttach'))
    (objHandle, email);
end;

function CkImap_GetMailSize (objHandle: HCkImap; email: HCkEmail): Integer;
begin
  result := TCkImap_GetMailSize(_map(251, 'CkImap_GetMailSize'))
    (objHandle, email);
end;

function CkImap_GetQuota (objHandle: HCkImap; quotaRoot: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkImap_GetQuota(_map(252, 'CkImap_GetQuota'))
    (objHandle, quotaRoot, outStr);
end;

function CkImap__getQuota (objHandle: HCkImap; quotaRoot: PWideChar): PWideChar;
begin
  result := TCkImap__getQuota(_map(253, 'CkImap__getQuota'))
    (objHandle, quotaRoot);
end;

function CkImap_GetQuotaAsync (objHandle: HCkImap; quotaRoot: PWideChar): HCkTask;
begin
  result := TCkImap_GetQuotaAsync(_map(254, 'CkImap_GetQuotaAsync'))
    (objHandle, quotaRoot);
end;

function CkImap_GetQuotaRoot (objHandle: HCkImap; mailboxName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkImap_GetQuotaRoot(_map(255, 'CkImap_GetQuotaRoot'))
    (objHandle, mailboxName, outStr);
end;

function CkImap__getQuotaRoot (objHandle: HCkImap; mailboxName: PWideChar): PWideChar;
begin
  result := TCkImap__getQuotaRoot(_map(256, 'CkImap__getQuotaRoot'))
    (objHandle, mailboxName);
end;

function CkImap_GetQuotaRootAsync (objHandle: HCkImap; mailboxName: PWideChar): HCkTask;
begin
  result := TCkImap_GetQuotaRootAsync(_map(257, 'CkImap_GetQuotaRootAsync'))
    (objHandle, mailboxName);
end;

function CkImap_GetServerCert (objHandle: HCkImap; cert: HCkCert): wordbool;
begin
  result := TCkImap_GetServerCert(_map(258, 'CkImap_GetServerCert'))
    (objHandle, cert);
end;

function CkImap_GetSslServerCert (objHandle: HCkImap): HCkCert;
begin
  result := TCkImap_GetSslServerCert(_map(259, 'CkImap_GetSslServerCert'))
    (objHandle);
end;

function CkImap_HasCapability (objHandle: HCkImap; name: PWideChar; capabilityResponse: PWideChar): wordbool;
begin
  result := TCkImap_HasCapability(_map(260, 'CkImap_HasCapability'))
    (objHandle, name, capabilityResponse);
end;

function CkImap_IdleCheck (objHandle: HCkImap; timeoutMs: Integer; outStr: HCkString): wordbool;
begin
  result := TCkImap_IdleCheck(_map(261, 'CkImap_IdleCheck'))
    (objHandle, timeoutMs, outStr);
end;

function CkImap__idleCheck (objHandle: HCkImap; timeoutMs: Integer): PWideChar;
begin
  result := TCkImap__idleCheck(_map(262, 'CkImap__idleCheck'))
    (objHandle, timeoutMs);
end;

function CkImap_IdleCheckAsync (objHandle: HCkImap; timeoutMs: Integer): HCkTask;
begin
  result := TCkImap_IdleCheckAsync(_map(263, 'CkImap_IdleCheckAsync'))
    (objHandle, timeoutMs);
end;

function CkImap_IdleDone (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_IdleDone(_map(264, 'CkImap_IdleDone'))
    (objHandle);
end;

function CkImap_IdleDoneAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_IdleDoneAsync(_map(265, 'CkImap_IdleDoneAsync'))
    (objHandle);
end;

function CkImap_IdleStart (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_IdleStart(_map(266, 'CkImap_IdleStart'))
    (objHandle);
end;

function CkImap_IdleStartAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_IdleStartAsync(_map(267, 'CkImap_IdleStartAsync'))
    (objHandle);
end;

function CkImap_IsConnected (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_IsConnected(_map(268, 'CkImap_IsConnected'))
    (objHandle);
end;

function CkImap_IsLoggedIn (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_IsLoggedIn(_map(269, 'CkImap_IsLoggedIn'))
    (objHandle);
end;

function CkImap_ListMailboxes (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkMailboxes;
begin
  result := TCkImap_ListMailboxes(_map(270, 'CkImap_ListMailboxes'))
    (objHandle, reference, wildcardedMailbox);
end;

function CkImap_ListMailboxesAsync (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkTask;
begin
  result := TCkImap_ListMailboxesAsync(_map(271, 'CkImap_ListMailboxesAsync'))
    (objHandle, reference, wildcardedMailbox);
end;

function CkImap_ListSubscribed (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkMailboxes;
begin
  result := TCkImap_ListSubscribed(_map(272, 'CkImap_ListSubscribed'))
    (objHandle, reference, wildcardedMailbox);
end;

function CkImap_ListSubscribedAsync (objHandle: HCkImap; reference: PWideChar; wildcardedMailbox: PWideChar): HCkTask;
begin
  result := TCkImap_ListSubscribedAsync(_map(273, 'CkImap_ListSubscribedAsync'))
    (objHandle, reference, wildcardedMailbox);
end;

function CkImap_LoadTaskCaller (objHandle: HCkImap; task: HCkTask): wordbool;
begin
  result := TCkImap_LoadTaskCaller(_map(274, 'CkImap_LoadTaskCaller'))
    (objHandle, task);
end;

function CkImap_Login (objHandle: HCkImap; loginName: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkImap_Login(_map(275, 'CkImap_Login'))
    (objHandle, loginName, password);
end;

function CkImap_LoginAsync (objHandle: HCkImap; loginName: PWideChar; password: PWideChar): HCkTask;
begin
  result := TCkImap_LoginAsync(_map(276, 'CkImap_LoginAsync'))
    (objHandle, loginName, password);
end;

function CkImap_LoginSecure (objHandle: HCkImap; loginName: HCkSecureString; password: HCkSecureString): wordbool;
begin
  result := TCkImap_LoginSecure(_map(277, 'CkImap_LoginSecure'))
    (objHandle, loginName, password);
end;

function CkImap_LoginSecureAsync (objHandle: HCkImap; loginName: HCkSecureString; password: HCkSecureString): HCkTask;
begin
  result := TCkImap_LoginSecureAsync(_map(278, 'CkImap_LoginSecureAsync'))
    (objHandle, loginName, password);
end;

function CkImap_Logout (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_Logout(_map(279, 'CkImap_Logout'))
    (objHandle);
end;

function CkImap_LogoutAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_LogoutAsync(_map(280, 'CkImap_LogoutAsync'))
    (objHandle);
end;

function CkImap_MbxList (objHandle: HCkImap; subscribed: wordbool; reference: PWideChar; mbxPattern: PWideChar; mboxes: HCkMailboxes): wordbool;
begin
  result := TCkImap_MbxList(_map(281, 'CkImap_MbxList'))
    (objHandle, subscribed, reference, mbxPattern, mboxes);
end;

function CkImap_MbxListAsync (objHandle: HCkImap; subscribed: wordbool; reference: PWideChar; mbxPattern: PWideChar; mboxes: HCkMailboxes): HCkTask;
begin
  result := TCkImap_MbxListAsync(_map(282, 'CkImap_MbxListAsync'))
    (objHandle, subscribed, reference, mbxPattern, mboxes);
end;

function CkImap_MoveMessages (objHandle: HCkImap; messageSet: HCkMessageSet; destFolder: PWideChar): wordbool;
begin
  result := TCkImap_MoveMessages(_map(283, 'CkImap_MoveMessages'))
    (objHandle, messageSet, destFolder);
end;

function CkImap_MoveMessagesAsync (objHandle: HCkImap; messageSet: HCkMessageSet; destFolder: PWideChar): HCkTask;
begin
  result := TCkImap_MoveMessagesAsync(_map(284, 'CkImap_MoveMessagesAsync'))
    (objHandle, messageSet, destFolder);
end;

function CkImap_Noop (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_Noop(_map(285, 'CkImap_Noop'))
    (objHandle);
end;

function CkImap_NoopAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_NoopAsync(_map(286, 'CkImap_NoopAsync'))
    (objHandle);
end;

function CkImap_QueryMbx (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool; msgSet: HCkMessageSet): wordbool;
begin
  result := TCkImap_QueryMbx(_map(287, 'CkImap_QueryMbx'))
    (objHandle, criteria, bUid, msgSet);
end;

function CkImap_QueryMbxAsync (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool; msgSet: HCkMessageSet): HCkTask;
begin
  result := TCkImap_QueryMbxAsync(_map(288, 'CkImap_QueryMbxAsync'))
    (objHandle, criteria, bUid, msgSet);
end;

function CkImap_QueryThread (objHandle: HCkImap; threadAlg: PWideChar; searchCriteria: PWideChar; bUid: wordbool; json: HCkJsonObject): wordbool;
begin
  result := TCkImap_QueryThread(_map(289, 'CkImap_QueryThread'))
    (objHandle, threadAlg, searchCriteria, bUid, json);
end;

function CkImap_QueryThreadAsync (objHandle: HCkImap; threadAlg: PWideChar; searchCriteria: PWideChar; bUid: wordbool; json: HCkJsonObject): HCkTask;
begin
  result := TCkImap_QueryThreadAsync(_map(290, 'CkImap_QueryThreadAsync'))
    (objHandle, threadAlg, searchCriteria, bUid, json);
end;

function CkImap_RawCommandBd (objHandle: HCkImap; bdCmd: HCkBinData; bdResp: HCkBinData): wordbool;
begin
  result := TCkImap_RawCommandBd(_map(291, 'CkImap_RawCommandBd'))
    (objHandle, bdCmd, bdResp);
end;

function CkImap_RawCommandBdAsync (objHandle: HCkImap; bdCmd: HCkBinData; bdResp: HCkBinData): HCkTask;
begin
  result := TCkImap_RawCommandBdAsync(_map(292, 'CkImap_RawCommandBdAsync'))
    (objHandle, bdCmd, bdResp);
end;

function CkImap_RefetchMailFlags (objHandle: HCkImap; email: HCkEmail): wordbool;
begin
  result := TCkImap_RefetchMailFlags(_map(293, 'CkImap_RefetchMailFlags'))
    (objHandle, email);
end;

function CkImap_RefetchMailFlagsAsync (objHandle: HCkImap; email: HCkEmail): HCkTask;
begin
  result := TCkImap_RefetchMailFlagsAsync(_map(294, 'CkImap_RefetchMailFlagsAsync'))
    (objHandle, email);
end;

function CkImap_RenameMailbox (objHandle: HCkImap; fromMailbox: PWideChar; toMailbox: PWideChar): wordbool;
begin
  result := TCkImap_RenameMailbox(_map(295, 'CkImap_RenameMailbox'))
    (objHandle, fromMailbox, toMailbox);
end;

function CkImap_RenameMailboxAsync (objHandle: HCkImap; fromMailbox: PWideChar; toMailbox: PWideChar): HCkTask;
begin
  result := TCkImap_RenameMailboxAsync(_map(296, 'CkImap_RenameMailboxAsync'))
    (objHandle, fromMailbox, toMailbox);
end;

function CkImap_Search (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool): HCkMessageSet;
begin
  result := TCkImap_Search(_map(297, 'CkImap_Search'))
    (objHandle, criteria, bUid);
end;

function CkImap_SearchAsync (objHandle: HCkImap; criteria: PWideChar; bUid: wordbool): HCkTask;
begin
  result := TCkImap_SearchAsync(_map(298, 'CkImap_SearchAsync'))
    (objHandle, criteria, bUid);
end;

function CkImap_SelectMailbox (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_SelectMailbox(_map(299, 'CkImap_SelectMailbox'))
    (objHandle, mailbox);
end;

function CkImap_SelectMailboxAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_SelectMailboxAsync(_map(300, 'CkImap_SelectMailboxAsync'))
    (objHandle, mailbox);
end;

function CkImap_SendRawCommand (objHandle: HCkImap; cmd: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkImap_SendRawCommand(_map(301, 'CkImap_SendRawCommand'))
    (objHandle, cmd, outStr);
end;

function CkImap__sendRawCommand (objHandle: HCkImap; cmd: PWideChar): PWideChar;
begin
  result := TCkImap__sendRawCommand(_map(302, 'CkImap__sendRawCommand'))
    (objHandle, cmd);
end;

function CkImap_SendRawCommandAsync (objHandle: HCkImap; cmd: PWideChar): HCkTask;
begin
  result := TCkImap_SendRawCommandAsync(_map(303, 'CkImap_SendRawCommandAsync'))
    (objHandle, cmd);
end;

function CkImap_SendRawCommandB (objHandle: HCkImap; cmd: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkImap_SendRawCommandB(_map(304, 'CkImap_SendRawCommandB'))
    (objHandle, cmd, outData);
end;

function CkImap_SendRawCommandBAsync (objHandle: HCkImap; cmd: PWideChar): HCkTask;
begin
  result := TCkImap_SendRawCommandBAsync(_map(305, 'CkImap_SendRawCommandBAsync'))
    (objHandle, cmd);
end;

function CkImap_SendRawCommandC (objHandle: HCkImap; cmd: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkImap_SendRawCommandC(_map(306, 'CkImap_SendRawCommandC'))
    (objHandle, cmd, outData);
end;

function CkImap_SendRawCommandCAsync (objHandle: HCkImap; cmd: HCkByteData): HCkTask;
begin
  result := TCkImap_SendRawCommandCAsync(_map(307, 'CkImap_SendRawCommandCAsync'))
    (objHandle, cmd);
end;

function CkImap_SetDecryptCert (objHandle: HCkImap; cert: HCkCert): wordbool;
begin
  result := TCkImap_SetDecryptCert(_map(308, 'CkImap_SetDecryptCert'))
    (objHandle, cert);
end;

function CkImap_SetDecryptCert2 (objHandle: HCkImap; cert: HCkCert; key: HCkPrivateKey): wordbool;
begin
  result := TCkImap_SetDecryptCert2(_map(309, 'CkImap_SetDecryptCert2'))
    (objHandle, cert, key);
end;

function CkImap_SetFlag (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagName: PWideChar; value: Integer): wordbool;
begin
  result := TCkImap_SetFlag(_map(310, 'CkImap_SetFlag'))
    (objHandle, msgId, bUid, flagName, value);
end;

function CkImap_SetFlagAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagName: PWideChar; value: Integer): HCkTask;
begin
  result := TCkImap_SetFlagAsync(_map(311, 'CkImap_SetFlagAsync'))
    (objHandle, msgId, bUid, flagName, value);
end;

function CkImap_SetFlags (objHandle: HCkImap; messageSet: HCkMessageSet; flagName: PWideChar; value: Integer): wordbool;
begin
  result := TCkImap_SetFlags(_map(312, 'CkImap_SetFlags'))
    (objHandle, messageSet, flagName, value);
end;

function CkImap_SetFlagsAsync (objHandle: HCkImap; messageSet: HCkMessageSet; flagName: PWideChar; value: Integer): HCkTask;
begin
  result := TCkImap_SetFlagsAsync(_map(313, 'CkImap_SetFlagsAsync'))
    (objHandle, messageSet, flagName, value);
end;

function CkImap_SetMailFlag (objHandle: HCkImap; email: HCkEmail; flagName: PWideChar; value: Integer): wordbool;
begin
  result := TCkImap_SetMailFlag(_map(314, 'CkImap_SetMailFlag'))
    (objHandle, email, flagName, value);
end;

function CkImap_SetMailFlagAsync (objHandle: HCkImap; email: HCkEmail; flagName: PWideChar; value: Integer): HCkTask;
begin
  result := TCkImap_SetMailFlagAsync(_map(315, 'CkImap_SetMailFlagAsync'))
    (objHandle, email, flagName, value);
end;

function CkImap_SetQuota (objHandle: HCkImap; quotaRoot: PWideChar; resource: PWideChar; quota: Integer): wordbool;
begin
  result := TCkImap_SetQuota(_map(316, 'CkImap_SetQuota'))
    (objHandle, quotaRoot, resource, quota);
end;

function CkImap_SetQuotaAsync (objHandle: HCkImap; quotaRoot: PWideChar; resource: PWideChar; quota: Integer): HCkTask;
begin
  result := TCkImap_SetQuotaAsync(_map(317, 'CkImap_SetQuotaAsync'))
    (objHandle, quotaRoot, resource, quota);
end;

function CkImap_SetSslClientCert (objHandle: HCkImap; cert: HCkCert): wordbool;
begin
  result := TCkImap_SetSslClientCert(_map(318, 'CkImap_SetSslClientCert'))
    (objHandle, cert);
end;

function CkImap_SetSslClientCertPem (objHandle: HCkImap; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
begin
  result := TCkImap_SetSslClientCertPem(_map(319, 'CkImap_SetSslClientCertPem'))
    (objHandle, pemDataOrFilename, pemPassword);
end;

function CkImap_SetSslClientCertPfx (objHandle: HCkImap; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkImap_SetSslClientCertPfx(_map(320, 'CkImap_SetSslClientCertPfx'))
    (objHandle, pfxFilename, pfxPassword);
end;

function CkImap_Sort (objHandle: HCkImap; sortCriteria: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkMessageSet;
begin
  result := TCkImap_Sort(_map(321, 'CkImap_Sort'))
    (objHandle, sortCriteria, charset, searchCriteria, bUid);
end;

function CkImap_SortAsync (objHandle: HCkImap; sortCriteria: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkTask;
begin
  result := TCkImap_SortAsync(_map(322, 'CkImap_SortAsync'))
    (objHandle, sortCriteria, charset, searchCriteria, bUid);
end;

function CkImap_SshAuthenticatePk (objHandle: HCkImap; sshLogin: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkImap_SshAuthenticatePk(_map(323, 'CkImap_SshAuthenticatePk'))
    (objHandle, sshLogin, privateKey);
end;

function CkImap_SshAuthenticatePkAsync (objHandle: HCkImap; sshLogin: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkImap_SshAuthenticatePkAsync(_map(324, 'CkImap_SshAuthenticatePkAsync'))
    (objHandle, sshLogin, privateKey);
end;

function CkImap_SshAuthenticatePw (objHandle: HCkImap; sshLogin: PWideChar; sshPassword: PWideChar): wordbool;
begin
  result := TCkImap_SshAuthenticatePw(_map(325, 'CkImap_SshAuthenticatePw'))
    (objHandle, sshLogin, sshPassword);
end;

function CkImap_SshAuthenticatePwAsync (objHandle: HCkImap; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask;
begin
  result := TCkImap_SshAuthenticatePwAsync(_map(326, 'CkImap_SshAuthenticatePwAsync'))
    (objHandle, sshLogin, sshPassword);
end;

function CkImap_SshCloseTunnel (objHandle: HCkImap): wordbool;
begin
  result := TCkImap_SshCloseTunnel(_map(327, 'CkImap_SshCloseTunnel'))
    (objHandle);
end;

function CkImap_SshCloseTunnelAsync (objHandle: HCkImap): HCkTask;
begin
  result := TCkImap_SshCloseTunnelAsync(_map(328, 'CkImap_SshCloseTunnelAsync'))
    (objHandle);
end;

function CkImap_SshOpenTunnel (objHandle: HCkImap; sshHostname: PWideChar; sshPort: Integer): wordbool;
begin
  result := TCkImap_SshOpenTunnel(_map(329, 'CkImap_SshOpenTunnel'))
    (objHandle, sshHostname, sshPort);
end;

function CkImap_SshOpenTunnelAsync (objHandle: HCkImap; sshHostname: PWideChar; sshPort: Integer): HCkTask;
begin
  result := TCkImap_SshOpenTunnelAsync(_map(330, 'CkImap_SshOpenTunnelAsync'))
    (objHandle, sshHostname, sshPort);
end;

function CkImap_StoreFlags (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagNames: PWideChar; value: Integer): wordbool;
begin
  result := TCkImap_StoreFlags(_map(331, 'CkImap_StoreFlags'))
    (objHandle, msgId, bUid, flagNames, value);
end;

function CkImap_StoreFlagsAsync (objHandle: HCkImap; msgId: LongWord; bUid: wordbool; flagNames: PWideChar; value: Integer): HCkTask;
begin
  result := TCkImap_StoreFlagsAsync(_map(332, 'CkImap_StoreFlagsAsync'))
    (objHandle, msgId, bUid, flagNames, value);
end;

function CkImap_Subscribe (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_Subscribe(_map(333, 'CkImap_Subscribe'))
    (objHandle, mailbox);
end;

function CkImap_SubscribeAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_SubscribeAsync(_map(334, 'CkImap_SubscribeAsync'))
    (objHandle, mailbox);
end;

function CkImap_ThreadCmd (objHandle: HCkImap; threadAlg: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkJsonObject;
begin
  result := TCkImap_ThreadCmd(_map(335, 'CkImap_ThreadCmd'))
    (objHandle, threadAlg, charset, searchCriteria, bUid);
end;

function CkImap_ThreadCmdAsync (objHandle: HCkImap; threadAlg: PWideChar; charset: PWideChar; searchCriteria: PWideChar; bUid: wordbool): HCkTask;
begin
  result := TCkImap_ThreadCmdAsync(_map(336, 'CkImap_ThreadCmdAsync'))
    (objHandle, threadAlg, charset, searchCriteria, bUid);
end;

function CkImap_Unsubscribe (objHandle: HCkImap; mailbox: PWideChar): wordbool;
begin
  result := TCkImap_Unsubscribe(_map(337, 'CkImap_Unsubscribe'))
    (objHandle, mailbox);
end;

function CkImap_UnsubscribeAsync (objHandle: HCkImap; mailbox: PWideChar): HCkTask;
begin
  result := TCkImap_UnsubscribeAsync(_map(338, 'CkImap_UnsubscribeAsync'))
    (objHandle, mailbox);
end;

function CkImap_UseCertVault (objHandle: HCkImap; vault: HCkXmlCertVault): wordbool;
begin
  result := TCkImap_UseCertVault(_map(339, 'CkImap_UseCertVault'))
    (objHandle, vault);
end;

function CkImap_UseSsh (objHandle: HCkImap; ssh: HCkSsh): wordbool;
begin
  result := TCkImap_UseSsh(_map(340, 'CkImap_UseSsh'))
    (objHandle, ssh);
end;

function CkImap_UseSshTunnel (objHandle: HCkImap; tunnel: HCkSocket): wordbool;
begin
  result := TCkImap_UseSshTunnel(_map(341, 'CkImap_UseSshTunnel'))
    (objHandle, tunnel);
end;

end.
