unit JavaKeyStore;

interface

type

HCkPem = Pointer;
HCkJavaKeyStore = Pointer;
HCkPrivateKey = Pointer;
HCkXmlCertVault = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkPfx = Pointer;
HCkStringBuilder = Pointer;
HCkCertChain = Pointer;
HCkCert = Pointer;
HCkJsonObject = Pointer;
HCkBinData = Pointer;


function CkJavaKeyStore_Create: HCkJavaKeyStore;  stdcall;
procedure CkJavaKeyStore_Dispose(handle: HCkJavaKeyStore); stdcall;
procedure CkJavaKeyStore_getDebugLogFilePath(objHandle: HCkJavaKeyStore; outPropVal: HCkString);
procedure CkJavaKeyStore_putDebugLogFilePath(objHandle: HCkJavaKeyStore; newPropVal: PWideChar);
function CkJavaKeyStore__debugLogFilePath(objHandle: HCkJavaKeyStore): PWideChar;
procedure CkJavaKeyStore_getLastErrorHtml(objHandle: HCkJavaKeyStore; outPropVal: HCkString);
function CkJavaKeyStore__lastErrorHtml(objHandle: HCkJavaKeyStore): PWideChar;
procedure CkJavaKeyStore_getLastErrorText(objHandle: HCkJavaKeyStore; outPropVal: HCkString);
function CkJavaKeyStore__lastErrorText(objHandle: HCkJavaKeyStore): PWideChar;
procedure CkJavaKeyStore_getLastErrorXml(objHandle: HCkJavaKeyStore; outPropVal: HCkString);
function CkJavaKeyStore__lastErrorXml(objHandle: HCkJavaKeyStore): PWideChar;
function CkJavaKeyStore_getLastMethodSuccess(objHandle: HCkJavaKeyStore): wordbool;
procedure CkJavaKeyStore_putLastMethodSuccess(objHandle: HCkJavaKeyStore; newPropVal: wordbool);
function CkJavaKeyStore_getNumPrivateKeys(objHandle: HCkJavaKeyStore): Integer;
function CkJavaKeyStore_getNumSecretKeys(objHandle: HCkJavaKeyStore): Integer;
function CkJavaKeyStore_getNumTrustedCerts(objHandle: HCkJavaKeyStore): Integer;
function CkJavaKeyStore_getRequireCompleteChain(objHandle: HCkJavaKeyStore): wordbool;
procedure CkJavaKeyStore_putRequireCompleteChain(objHandle: HCkJavaKeyStore; newPropVal: wordbool);
function CkJavaKeyStore_getVerboseLogging(objHandle: HCkJavaKeyStore): wordbool;
procedure CkJavaKeyStore_putVerboseLogging(objHandle: HCkJavaKeyStore; newPropVal: wordbool);
function CkJavaKeyStore_getVerifyKeyedDigest(objHandle: HCkJavaKeyStore): wordbool;
procedure CkJavaKeyStore_putVerifyKeyedDigest(objHandle: HCkJavaKeyStore; newPropVal: wordbool);
procedure CkJavaKeyStore_getVersion(objHandle: HCkJavaKeyStore; outPropVal: HCkString);
function CkJavaKeyStore__version(objHandle: HCkJavaKeyStore): PWideChar;
function CkJavaKeyStore_AddPfx(objHandle: HCkJavaKeyStore; pfx: HCkPfx; alias: PWideChar; password: PWideChar): wordbool;
function CkJavaKeyStore_AddPrivateKey(objHandle: HCkJavaKeyStore; cert: HCkCert; alias: PWideChar; password: PWideChar): wordbool;
function CkJavaKeyStore_AddSecretKey(objHandle: HCkJavaKeyStore; encodedKeyBytes: PWideChar; encoding: PWideChar; algorithm: PWideChar; alias: PWideChar; password: PWideChar): wordbool;
function CkJavaKeyStore_AddTrustedCert(objHandle: HCkJavaKeyStore; cert: HCkCert; alias: PWideChar): wordbool;
function CkJavaKeyStore_CertChainAt(objHandle: HCkJavaKeyStore; index: Integer; certChain: HCkCertChain): wordbool;
function CkJavaKeyStore_CertChainOf(objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool; certChain: HCkCertChain): wordbool;
function CkJavaKeyStore_ChangePassword(objHandle: HCkJavaKeyStore; index: Integer; oldPassword: PWideChar; newPassword: PWideChar): wordbool;
function CkJavaKeyStore_FindCertChain(objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool): HCkCertChain;
function CkJavaKeyStore_FindPrivateKey(objHandle: HCkJavaKeyStore; password: PWideChar; alias: PWideChar; caseSensitive: wordbool): HCkPrivateKey;
function CkJavaKeyStore_FindTrustedCert(objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool): HCkCert;
function CkJavaKeyStore_GetCertChain(objHandle: HCkJavaKeyStore; index: Integer): HCkCertChain;
function CkJavaKeyStore_GetPrivateKey(objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer): HCkPrivateKey;
function CkJavaKeyStore_GetPrivateKeyAlias(objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool;
function CkJavaKeyStore__getPrivateKeyAlias(objHandle: HCkJavaKeyStore; index: Integer): PWideChar;
function CkJavaKeyStore_GetSecretKey(objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
function CkJavaKeyStore__getSecretKey(objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; encoding: PWideChar): PWideChar;
function CkJavaKeyStore_GetSecretKeyAlias(objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool;
function CkJavaKeyStore__getSecretKeyAlias(objHandle: HCkJavaKeyStore; index: Integer): PWideChar;
function CkJavaKeyStore_GetTrustedCert(objHandle: HCkJavaKeyStore; index: Integer): HCkCert;
function CkJavaKeyStore_GetTrustedCertAlias(objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool;
function CkJavaKeyStore__getTrustedCertAlias(objHandle: HCkJavaKeyStore; index: Integer): PWideChar;
function CkJavaKeyStore_LoadBd(objHandle: HCkJavaKeyStore; password: PWideChar; bd: HCkBinData): wordbool;
function CkJavaKeyStore_LoadBinary(objHandle: HCkJavaKeyStore; password: PWideChar; jksData: HCkByteData): wordbool;
function CkJavaKeyStore_LoadEncoded(objHandle: HCkJavaKeyStore; password: PWideChar; jksEncData: PWideChar; encoding: PWideChar): wordbool;
function CkJavaKeyStore_LoadFile(objHandle: HCkJavaKeyStore; password: PWideChar; path: PWideChar): wordbool;
function CkJavaKeyStore_LoadJwkSet(objHandle: HCkJavaKeyStore; password: PWideChar; jwkSet: HCkJsonObject): wordbool;
function CkJavaKeyStore_PrivateKeyAt(objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; privKey: HCkPrivateKey): wordbool;
function CkJavaKeyStore_PrivateKeyOf(objHandle: HCkJavaKeyStore; password: PWideChar; alias: PWideChar; caseSensitive: wordbool; privKey: HCkPrivateKey): wordbool;
function CkJavaKeyStore_RemoveEntry(objHandle: HCkJavaKeyStore; entryType: Integer; index: Integer): wordbool;
function CkJavaKeyStore_SetAlias(objHandle: HCkJavaKeyStore; entryType: Integer; index: Integer; alias: PWideChar): wordbool;
function CkJavaKeyStore_ToBd(objHandle: HCkJavaKeyStore; password: PWideChar; bd: HCkBinData): wordbool;
function CkJavaKeyStore_ToBinary(objHandle: HCkJavaKeyStore; password: PWideChar; outData: HCkByteData): wordbool;
function CkJavaKeyStore_ToEncodedString(objHandle: HCkJavaKeyStore; password: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkJavaKeyStore__toEncodedString(objHandle: HCkJavaKeyStore; password: PWideChar; encoding: PWideChar): PWideChar;
function CkJavaKeyStore_ToFile(objHandle: HCkJavaKeyStore; password: PWideChar; path: PWideChar): wordbool;
function CkJavaKeyStore_ToJwkSet(objHandle: HCkJavaKeyStore; password: PWideChar; sbJwkSet: HCkStringBuilder): wordbool;
function CkJavaKeyStore_ToPem(objHandle: HCkJavaKeyStore; password: PWideChar): HCkPem;
function CkJavaKeyStore_ToPemObj(objHandle: HCkJavaKeyStore; password: PWideChar; pemObj: HCkPem): wordbool;
function CkJavaKeyStore_ToPfx(objHandle: HCkJavaKeyStore; password: PWideChar): HCkPfx;
function CkJavaKeyStore_ToPfxObj(objHandle: HCkJavaKeyStore; password: PWideChar; pfxObj: HCkPfx): wordbool;
function CkJavaKeyStore_TrustedCertAt(objHandle: HCkJavaKeyStore; index: Integer; cert: HCkCert): wordbool;
function CkJavaKeyStore_TrustedCertOf(objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool; cert: HCkCert): wordbool;
function CkJavaKeyStore_UseCertVault(objHandle: HCkJavaKeyStore; vault: HCkXmlCertVault): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkJavaKeyStore_Create = function : HCkJavaKeyStore; stdcall;
  TCkJavaKeyStore_Dispose = procedure (handle: HCkJavaKeyStore); stdcall;
  TCkJavaKeyStore_getDebugLogFilePath = procedure (objHandle: HCkJavaKeyStore; outPropVal: HCkString); stdcall;
  TCkJavaKeyStore_putDebugLogFilePath = procedure (objHandle: HCkJavaKeyStore; newPropVal: PWideChar); stdcall;
  TCkJavaKeyStore__debugLogFilePath = function (objHandle: HCkJavaKeyStore): PWideChar; stdcall;
  TCkJavaKeyStore_getLastErrorHtml = procedure (objHandle: HCkJavaKeyStore; outPropVal: HCkString); stdcall;
  TCkJavaKeyStore__lastErrorHtml = function (objHandle: HCkJavaKeyStore): PWideChar; stdcall;
  TCkJavaKeyStore_getLastErrorText = procedure (objHandle: HCkJavaKeyStore; outPropVal: HCkString); stdcall;
  TCkJavaKeyStore__lastErrorText = function (objHandle: HCkJavaKeyStore): PWideChar; stdcall;
  TCkJavaKeyStore_getLastErrorXml = procedure (objHandle: HCkJavaKeyStore; outPropVal: HCkString); stdcall;
  TCkJavaKeyStore__lastErrorXml = function (objHandle: HCkJavaKeyStore): PWideChar; stdcall;
  TCkJavaKeyStore_getLastMethodSuccess = function (objHandle: HCkJavaKeyStore): wordbool; stdcall;
  TCkJavaKeyStore_putLastMethodSuccess = procedure (objHandle: HCkJavaKeyStore; newPropVal: wordbool); stdcall;
  TCkJavaKeyStore_getNumPrivateKeys = function (objHandle: HCkJavaKeyStore): Integer; stdcall;
  TCkJavaKeyStore_getNumSecretKeys = function (objHandle: HCkJavaKeyStore): Integer; stdcall;
  TCkJavaKeyStore_getNumTrustedCerts = function (objHandle: HCkJavaKeyStore): Integer; stdcall;
  TCkJavaKeyStore_getRequireCompleteChain = function (objHandle: HCkJavaKeyStore): wordbool; stdcall;
  TCkJavaKeyStore_putRequireCompleteChain = procedure (objHandle: HCkJavaKeyStore; newPropVal: wordbool); stdcall;
  TCkJavaKeyStore_getVerboseLogging = function (objHandle: HCkJavaKeyStore): wordbool; stdcall;
  TCkJavaKeyStore_putVerboseLogging = procedure (objHandle: HCkJavaKeyStore; newPropVal: wordbool); stdcall;
  TCkJavaKeyStore_getVerifyKeyedDigest = function (objHandle: HCkJavaKeyStore): wordbool; stdcall;
  TCkJavaKeyStore_putVerifyKeyedDigest = procedure (objHandle: HCkJavaKeyStore; newPropVal: wordbool); stdcall;
  TCkJavaKeyStore_getVersion = procedure (objHandle: HCkJavaKeyStore; outPropVal: HCkString); stdcall;
  TCkJavaKeyStore__version = function (objHandle: HCkJavaKeyStore): PWideChar; stdcall;
  TCkJavaKeyStore_AddPfx = function (objHandle: HCkJavaKeyStore; pfx: HCkPfx; alias: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_AddPrivateKey = function (objHandle: HCkJavaKeyStore; cert: HCkCert; alias: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_AddSecretKey = function (objHandle: HCkJavaKeyStore; encodedKeyBytes: PWideChar; encoding: PWideChar; algorithm: PWideChar; alias: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_AddTrustedCert = function (objHandle: HCkJavaKeyStore; cert: HCkCert; alias: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_CertChainAt = function (objHandle: HCkJavaKeyStore; index: Integer; certChain: HCkCertChain): wordbool; stdcall;
  TCkJavaKeyStore_CertChainOf = function (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool; certChain: HCkCertChain): wordbool; stdcall;
  TCkJavaKeyStore_ChangePassword = function (objHandle: HCkJavaKeyStore; index: Integer; oldPassword: PWideChar; newPassword: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_FindCertChain = function (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool): HCkCertChain; stdcall;
  TCkJavaKeyStore_FindPrivateKey = function (objHandle: HCkJavaKeyStore; password: PWideChar; alias: PWideChar; caseSensitive: wordbool): HCkPrivateKey; stdcall;
  TCkJavaKeyStore_FindTrustedCert = function (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool): HCkCert; stdcall;
  TCkJavaKeyStore_GetCertChain = function (objHandle: HCkJavaKeyStore; index: Integer): HCkCertChain; stdcall;
  TCkJavaKeyStore_GetPrivateKey = function (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer): HCkPrivateKey; stdcall;
  TCkJavaKeyStore_GetPrivateKeyAlias = function (objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkJavaKeyStore__getPrivateKeyAlias = function (objHandle: HCkJavaKeyStore; index: Integer): PWideChar; stdcall;
  TCkJavaKeyStore_GetSecretKey = function (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJavaKeyStore__getSecretKey = function (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; encoding: PWideChar): PWideChar; stdcall;
  TCkJavaKeyStore_GetSecretKeyAlias = function (objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkJavaKeyStore__getSecretKeyAlias = function (objHandle: HCkJavaKeyStore; index: Integer): PWideChar; stdcall;
  TCkJavaKeyStore_GetTrustedCert = function (objHandle: HCkJavaKeyStore; index: Integer): HCkCert; stdcall;
  TCkJavaKeyStore_GetTrustedCertAlias = function (objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkJavaKeyStore__getTrustedCertAlias = function (objHandle: HCkJavaKeyStore; index: Integer): PWideChar; stdcall;
  TCkJavaKeyStore_LoadBd = function (objHandle: HCkJavaKeyStore; password: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkJavaKeyStore_LoadBinary = function (objHandle: HCkJavaKeyStore; password: PWideChar; jksData: HCkByteData): wordbool; stdcall;
  TCkJavaKeyStore_LoadEncoded = function (objHandle: HCkJavaKeyStore; password: PWideChar; jksEncData: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_LoadFile = function (objHandle: HCkJavaKeyStore; password: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_LoadJwkSet = function (objHandle: HCkJavaKeyStore; password: PWideChar; jwkSet: HCkJsonObject): wordbool; stdcall;
  TCkJavaKeyStore_PrivateKeyAt = function (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkJavaKeyStore_PrivateKeyOf = function (objHandle: HCkJavaKeyStore; password: PWideChar; alias: PWideChar; caseSensitive: wordbool; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkJavaKeyStore_RemoveEntry = function (objHandle: HCkJavaKeyStore; entryType: Integer; index: Integer): wordbool; stdcall;
  TCkJavaKeyStore_SetAlias = function (objHandle: HCkJavaKeyStore; entryType: Integer; index: Integer; alias: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_ToBd = function (objHandle: HCkJavaKeyStore; password: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkJavaKeyStore_ToBinary = function (objHandle: HCkJavaKeyStore; password: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkJavaKeyStore_ToEncodedString = function (objHandle: HCkJavaKeyStore; password: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJavaKeyStore__toEncodedString = function (objHandle: HCkJavaKeyStore; password: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkJavaKeyStore_ToFile = function (objHandle: HCkJavaKeyStore; password: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkJavaKeyStore_ToJwkSet = function (objHandle: HCkJavaKeyStore; password: PWideChar; sbJwkSet: HCkStringBuilder): wordbool; stdcall;
  TCkJavaKeyStore_ToPem = function (objHandle: HCkJavaKeyStore; password: PWideChar): HCkPem; stdcall;
  TCkJavaKeyStore_ToPemObj = function (objHandle: HCkJavaKeyStore; password: PWideChar; pemObj: HCkPem): wordbool; stdcall;
  TCkJavaKeyStore_ToPfx = function (objHandle: HCkJavaKeyStore; password: PWideChar): HCkPfx; stdcall;
  TCkJavaKeyStore_ToPfxObj = function (objHandle: HCkJavaKeyStore; password: PWideChar; pfxObj: HCkPfx): wordbool; stdcall;
  TCkJavaKeyStore_TrustedCertAt = function (objHandle: HCkJavaKeyStore; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkJavaKeyStore_TrustedCertOf = function (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool; cert: HCkCert): wordbool; stdcall;
  TCkJavaKeyStore_UseCertVault = function (objHandle: HCkJavaKeyStore; vault: HCkXmlCertVault): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..66] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkJavaKeyStore_Create : HCkJavaKeyStore;
begin
  result := TCkJavaKeyStore_Create(_map(0, 'CkJavaKeyStore_Create'));
end;

procedure CkJavaKeyStore_Dispose (handle: HCkJavaKeyStore);
begin
  TCkJavaKeyStore_Dispose(_map(1, 'CkJavaKeyStore_Dispose'))
    (handle);
end;


procedure CkJavaKeyStore_getDebugLogFilePath (objHandle: HCkJavaKeyStore; outPropVal: HCkString);
begin
  TCkJavaKeyStore_getDebugLogFilePath(_map(2, 'CkJavaKeyStore_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkJavaKeyStore_putDebugLogFilePath (objHandle: HCkJavaKeyStore; newPropVal: PWideChar);
begin
  TCkJavaKeyStore_putDebugLogFilePath(_map(3, 'CkJavaKeyStore_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkJavaKeyStore__debugLogFilePath (objHandle: HCkJavaKeyStore): PWideChar;
begin
  result := TCkJavaKeyStore__debugLogFilePath(_map(4, 'CkJavaKeyStore__debugLogFilePath'))
    (objHandle);
end;

procedure CkJavaKeyStore_getLastErrorHtml (objHandle: HCkJavaKeyStore; outPropVal: HCkString);
begin
  TCkJavaKeyStore_getLastErrorHtml(_map(5, 'CkJavaKeyStore_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkJavaKeyStore__lastErrorHtml (objHandle: HCkJavaKeyStore): PWideChar;
begin
  result := TCkJavaKeyStore__lastErrorHtml(_map(6, 'CkJavaKeyStore__lastErrorHtml'))
    (objHandle);
end;

procedure CkJavaKeyStore_getLastErrorText (objHandle: HCkJavaKeyStore; outPropVal: HCkString);
begin
  TCkJavaKeyStore_getLastErrorText(_map(7, 'CkJavaKeyStore_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkJavaKeyStore__lastErrorText (objHandle: HCkJavaKeyStore): PWideChar;
begin
  result := TCkJavaKeyStore__lastErrorText(_map(8, 'CkJavaKeyStore__lastErrorText'))
    (objHandle);
end;

procedure CkJavaKeyStore_getLastErrorXml (objHandle: HCkJavaKeyStore; outPropVal: HCkString);
begin
  TCkJavaKeyStore_getLastErrorXml(_map(9, 'CkJavaKeyStore_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkJavaKeyStore__lastErrorXml (objHandle: HCkJavaKeyStore): PWideChar;
begin
  result := TCkJavaKeyStore__lastErrorXml(_map(10, 'CkJavaKeyStore__lastErrorXml'))
    (objHandle);
end;

function CkJavaKeyStore_getLastMethodSuccess (objHandle: HCkJavaKeyStore): wordbool;
begin
    result := TCkJavaKeyStore_getLastMethodSuccess(_map(11, 'CkJavaKeyStore_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkJavaKeyStore_putLastMethodSuccess (objHandle: HCkJavaKeyStore; newPropVal: wordbool);
begin
  TCkJavaKeyStore_putLastMethodSuccess(_map(12, 'CkJavaKeyStore_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkJavaKeyStore_getNumPrivateKeys (objHandle: HCkJavaKeyStore): Integer;
begin
    result := TCkJavaKeyStore_getNumPrivateKeys(_map(13, 'CkJavaKeyStore_getNumPrivateKeys'))
    (objHandle);
end;

function CkJavaKeyStore_getNumSecretKeys (objHandle: HCkJavaKeyStore): Integer;
begin
    result := TCkJavaKeyStore_getNumSecretKeys(_map(14, 'CkJavaKeyStore_getNumSecretKeys'))
    (objHandle);
end;

function CkJavaKeyStore_getNumTrustedCerts (objHandle: HCkJavaKeyStore): Integer;
begin
    result := TCkJavaKeyStore_getNumTrustedCerts(_map(15, 'CkJavaKeyStore_getNumTrustedCerts'))
    (objHandle);
end;

function CkJavaKeyStore_getRequireCompleteChain (objHandle: HCkJavaKeyStore): wordbool;
begin
    result := TCkJavaKeyStore_getRequireCompleteChain(_map(16, 'CkJavaKeyStore_getRequireCompleteChain'))
    (objHandle);
end;

procedure CkJavaKeyStore_putRequireCompleteChain (objHandle: HCkJavaKeyStore; newPropVal: wordbool);
begin
  TCkJavaKeyStore_putRequireCompleteChain(_map(17, 'CkJavaKeyStore_putRequireCompleteChain'))
    (objHandle, newPropVal);
end;

function CkJavaKeyStore_getVerboseLogging (objHandle: HCkJavaKeyStore): wordbool;
begin
    result := TCkJavaKeyStore_getVerboseLogging(_map(18, 'CkJavaKeyStore_getVerboseLogging'))
    (objHandle);
end;

procedure CkJavaKeyStore_putVerboseLogging (objHandle: HCkJavaKeyStore; newPropVal: wordbool);
begin
  TCkJavaKeyStore_putVerboseLogging(_map(19, 'CkJavaKeyStore_putVerboseLogging'))
    (objHandle, newPropVal);
end;

function CkJavaKeyStore_getVerifyKeyedDigest (objHandle: HCkJavaKeyStore): wordbool;
begin
    result := TCkJavaKeyStore_getVerifyKeyedDigest(_map(20, 'CkJavaKeyStore_getVerifyKeyedDigest'))
    (objHandle);
end;

procedure CkJavaKeyStore_putVerifyKeyedDigest (objHandle: HCkJavaKeyStore; newPropVal: wordbool);
begin
  TCkJavaKeyStore_putVerifyKeyedDigest(_map(21, 'CkJavaKeyStore_putVerifyKeyedDigest'))
    (objHandle, newPropVal);
end;

procedure CkJavaKeyStore_getVersion (objHandle: HCkJavaKeyStore; outPropVal: HCkString);
begin
  TCkJavaKeyStore_getVersion(_map(22, 'CkJavaKeyStore_getVersion'))
    (objHandle, outPropVal);
end;

function CkJavaKeyStore__version (objHandle: HCkJavaKeyStore): PWideChar;
begin
  result := TCkJavaKeyStore__version(_map(23, 'CkJavaKeyStore__version'))
    (objHandle);
end;

function CkJavaKeyStore_AddPfx (objHandle: HCkJavaKeyStore; pfx: HCkPfx; alias: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_AddPfx(_map(24, 'CkJavaKeyStore_AddPfx'))
    (objHandle, pfx, alias, password);
end;

function CkJavaKeyStore_AddPrivateKey (objHandle: HCkJavaKeyStore; cert: HCkCert; alias: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_AddPrivateKey(_map(25, 'CkJavaKeyStore_AddPrivateKey'))
    (objHandle, cert, alias, password);
end;

function CkJavaKeyStore_AddSecretKey (objHandle: HCkJavaKeyStore; encodedKeyBytes: PWideChar; encoding: PWideChar; algorithm: PWideChar; alias: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_AddSecretKey(_map(26, 'CkJavaKeyStore_AddSecretKey'))
    (objHandle, encodedKeyBytes, encoding, algorithm, alias, password);
end;

function CkJavaKeyStore_AddTrustedCert (objHandle: HCkJavaKeyStore; cert: HCkCert; alias: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_AddTrustedCert(_map(27, 'CkJavaKeyStore_AddTrustedCert'))
    (objHandle, cert, alias);
end;

function CkJavaKeyStore_CertChainAt (objHandle: HCkJavaKeyStore; index: Integer; certChain: HCkCertChain): wordbool;
begin
  result := TCkJavaKeyStore_CertChainAt(_map(28, 'CkJavaKeyStore_CertChainAt'))
    (objHandle, index, certChain);
end;

function CkJavaKeyStore_CertChainOf (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool; certChain: HCkCertChain): wordbool;
begin
  result := TCkJavaKeyStore_CertChainOf(_map(29, 'CkJavaKeyStore_CertChainOf'))
    (objHandle, alias, caseSensitive, certChain);
end;

function CkJavaKeyStore_ChangePassword (objHandle: HCkJavaKeyStore; index: Integer; oldPassword: PWideChar; newPassword: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_ChangePassword(_map(30, 'CkJavaKeyStore_ChangePassword'))
    (objHandle, index, oldPassword, newPassword);
end;

function CkJavaKeyStore_FindCertChain (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool): HCkCertChain;
begin
  result := TCkJavaKeyStore_FindCertChain(_map(31, 'CkJavaKeyStore_FindCertChain'))
    (objHandle, alias, caseSensitive);
end;

function CkJavaKeyStore_FindPrivateKey (objHandle: HCkJavaKeyStore; password: PWideChar; alias: PWideChar; caseSensitive: wordbool): HCkPrivateKey;
begin
  result := TCkJavaKeyStore_FindPrivateKey(_map(32, 'CkJavaKeyStore_FindPrivateKey'))
    (objHandle, password, alias, caseSensitive);
end;

function CkJavaKeyStore_FindTrustedCert (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool): HCkCert;
begin
  result := TCkJavaKeyStore_FindTrustedCert(_map(33, 'CkJavaKeyStore_FindTrustedCert'))
    (objHandle, alias, caseSensitive);
end;

function CkJavaKeyStore_GetCertChain (objHandle: HCkJavaKeyStore; index: Integer): HCkCertChain;
begin
  result := TCkJavaKeyStore_GetCertChain(_map(34, 'CkJavaKeyStore_GetCertChain'))
    (objHandle, index);
end;

function CkJavaKeyStore_GetPrivateKey (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer): HCkPrivateKey;
begin
  result := TCkJavaKeyStore_GetPrivateKey(_map(35, 'CkJavaKeyStore_GetPrivateKey'))
    (objHandle, password, index);
end;

function CkJavaKeyStore_GetPrivateKeyAlias (objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkJavaKeyStore_GetPrivateKeyAlias(_map(36, 'CkJavaKeyStore_GetPrivateKeyAlias'))
    (objHandle, index, outStr);
end;

function CkJavaKeyStore__getPrivateKeyAlias (objHandle: HCkJavaKeyStore; index: Integer): PWideChar;
begin
  result := TCkJavaKeyStore__getPrivateKeyAlias(_map(37, 'CkJavaKeyStore__getPrivateKeyAlias'))
    (objHandle, index);
end;

function CkJavaKeyStore_GetSecretKey (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJavaKeyStore_GetSecretKey(_map(38, 'CkJavaKeyStore_GetSecretKey'))
    (objHandle, password, index, encoding, outStr);
end;

function CkJavaKeyStore__getSecretKey (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; encoding: PWideChar): PWideChar;
begin
  result := TCkJavaKeyStore__getSecretKey(_map(39, 'CkJavaKeyStore__getSecretKey'))
    (objHandle, password, index, encoding);
end;

function CkJavaKeyStore_GetSecretKeyAlias (objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkJavaKeyStore_GetSecretKeyAlias(_map(40, 'CkJavaKeyStore_GetSecretKeyAlias'))
    (objHandle, index, outStr);
end;

function CkJavaKeyStore__getSecretKeyAlias (objHandle: HCkJavaKeyStore; index: Integer): PWideChar;
begin
  result := TCkJavaKeyStore__getSecretKeyAlias(_map(41, 'CkJavaKeyStore__getSecretKeyAlias'))
    (objHandle, index);
end;

function CkJavaKeyStore_GetTrustedCert (objHandle: HCkJavaKeyStore; index: Integer): HCkCert;
begin
  result := TCkJavaKeyStore_GetTrustedCert(_map(42, 'CkJavaKeyStore_GetTrustedCert'))
    (objHandle, index);
end;

function CkJavaKeyStore_GetTrustedCertAlias (objHandle: HCkJavaKeyStore; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkJavaKeyStore_GetTrustedCertAlias(_map(43, 'CkJavaKeyStore_GetTrustedCertAlias'))
    (objHandle, index, outStr);
end;

function CkJavaKeyStore__getTrustedCertAlias (objHandle: HCkJavaKeyStore; index: Integer): PWideChar;
begin
  result := TCkJavaKeyStore__getTrustedCertAlias(_map(44, 'CkJavaKeyStore__getTrustedCertAlias'))
    (objHandle, index);
end;

function CkJavaKeyStore_LoadBd (objHandle: HCkJavaKeyStore; password: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkJavaKeyStore_LoadBd(_map(45, 'CkJavaKeyStore_LoadBd'))
    (objHandle, password, bd);
end;

function CkJavaKeyStore_LoadBinary (objHandle: HCkJavaKeyStore; password: PWideChar; jksData: HCkByteData): wordbool;
begin
  result := TCkJavaKeyStore_LoadBinary(_map(46, 'CkJavaKeyStore_LoadBinary'))
    (objHandle, password, jksData);
end;

function CkJavaKeyStore_LoadEncoded (objHandle: HCkJavaKeyStore; password: PWideChar; jksEncData: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_LoadEncoded(_map(47, 'CkJavaKeyStore_LoadEncoded'))
    (objHandle, password, jksEncData, encoding);
end;

function CkJavaKeyStore_LoadFile (objHandle: HCkJavaKeyStore; password: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_LoadFile(_map(48, 'CkJavaKeyStore_LoadFile'))
    (objHandle, password, path);
end;

function CkJavaKeyStore_LoadJwkSet (objHandle: HCkJavaKeyStore; password: PWideChar; jwkSet: HCkJsonObject): wordbool;
begin
  result := TCkJavaKeyStore_LoadJwkSet(_map(49, 'CkJavaKeyStore_LoadJwkSet'))
    (objHandle, password, jwkSet);
end;

function CkJavaKeyStore_PrivateKeyAt (objHandle: HCkJavaKeyStore; password: PWideChar; index: Integer; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkJavaKeyStore_PrivateKeyAt(_map(50, 'CkJavaKeyStore_PrivateKeyAt'))
    (objHandle, password, index, privKey);
end;

function CkJavaKeyStore_PrivateKeyOf (objHandle: HCkJavaKeyStore; password: PWideChar; alias: PWideChar; caseSensitive: wordbool; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkJavaKeyStore_PrivateKeyOf(_map(51, 'CkJavaKeyStore_PrivateKeyOf'))
    (objHandle, password, alias, caseSensitive, privKey);
end;

function CkJavaKeyStore_RemoveEntry (objHandle: HCkJavaKeyStore; entryType: Integer; index: Integer): wordbool;
begin
  result := TCkJavaKeyStore_RemoveEntry(_map(52, 'CkJavaKeyStore_RemoveEntry'))
    (objHandle, entryType, index);
end;

function CkJavaKeyStore_SetAlias (objHandle: HCkJavaKeyStore; entryType: Integer; index: Integer; alias: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_SetAlias(_map(53, 'CkJavaKeyStore_SetAlias'))
    (objHandle, entryType, index, alias);
end;

function CkJavaKeyStore_ToBd (objHandle: HCkJavaKeyStore; password: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkJavaKeyStore_ToBd(_map(54, 'CkJavaKeyStore_ToBd'))
    (objHandle, password, bd);
end;

function CkJavaKeyStore_ToBinary (objHandle: HCkJavaKeyStore; password: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkJavaKeyStore_ToBinary(_map(55, 'CkJavaKeyStore_ToBinary'))
    (objHandle, password, outData);
end;

function CkJavaKeyStore_ToEncodedString (objHandle: HCkJavaKeyStore; password: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJavaKeyStore_ToEncodedString(_map(56, 'CkJavaKeyStore_ToEncodedString'))
    (objHandle, password, encoding, outStr);
end;

function CkJavaKeyStore__toEncodedString (objHandle: HCkJavaKeyStore; password: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkJavaKeyStore__toEncodedString(_map(57, 'CkJavaKeyStore__toEncodedString'))
    (objHandle, password, encoding);
end;

function CkJavaKeyStore_ToFile (objHandle: HCkJavaKeyStore; password: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkJavaKeyStore_ToFile(_map(58, 'CkJavaKeyStore_ToFile'))
    (objHandle, password, path);
end;

function CkJavaKeyStore_ToJwkSet (objHandle: HCkJavaKeyStore; password: PWideChar; sbJwkSet: HCkStringBuilder): wordbool;
begin
  result := TCkJavaKeyStore_ToJwkSet(_map(59, 'CkJavaKeyStore_ToJwkSet'))
    (objHandle, password, sbJwkSet);
end;

function CkJavaKeyStore_ToPem (objHandle: HCkJavaKeyStore; password: PWideChar): HCkPem;
begin
  result := TCkJavaKeyStore_ToPem(_map(60, 'CkJavaKeyStore_ToPem'))
    (objHandle, password);
end;

function CkJavaKeyStore_ToPemObj (objHandle: HCkJavaKeyStore; password: PWideChar; pemObj: HCkPem): wordbool;
begin
  result := TCkJavaKeyStore_ToPemObj(_map(61, 'CkJavaKeyStore_ToPemObj'))
    (objHandle, password, pemObj);
end;

function CkJavaKeyStore_ToPfx (objHandle: HCkJavaKeyStore; password: PWideChar): HCkPfx;
begin
  result := TCkJavaKeyStore_ToPfx(_map(62, 'CkJavaKeyStore_ToPfx'))
    (objHandle, password);
end;

function CkJavaKeyStore_ToPfxObj (objHandle: HCkJavaKeyStore; password: PWideChar; pfxObj: HCkPfx): wordbool;
begin
  result := TCkJavaKeyStore_ToPfxObj(_map(63, 'CkJavaKeyStore_ToPfxObj'))
    (objHandle, password, pfxObj);
end;

function CkJavaKeyStore_TrustedCertAt (objHandle: HCkJavaKeyStore; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkJavaKeyStore_TrustedCertAt(_map(64, 'CkJavaKeyStore_TrustedCertAt'))
    (objHandle, index, cert);
end;

function CkJavaKeyStore_TrustedCertOf (objHandle: HCkJavaKeyStore; alias: PWideChar; caseSensitive: wordbool; cert: HCkCert): wordbool;
begin
  result := TCkJavaKeyStore_TrustedCertOf(_map(65, 'CkJavaKeyStore_TrustedCertOf'))
    (objHandle, alias, caseSensitive, cert);
end;

function CkJavaKeyStore_UseCertVault (objHandle: HCkJavaKeyStore; vault: HCkXmlCertVault): wordbool;
begin
  result := TCkJavaKeyStore_UseCertVault(_map(66, 'CkJavaKeyStore_UseCertVault'))
    (objHandle, vault);
end;

end.
