unit JsonArray;

interface

type

HCkJsonObject = Pointer;
HCkDateTime = Pointer;
HCkJsonArray = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkDtObj = Pointer;


function CkJsonArray_Create: HCkJsonArray;  stdcall;
procedure CkJsonArray_Dispose(handle: HCkJsonArray); stdcall;
procedure CkJsonArray_getDebugLogFilePath(objHandle: HCkJsonArray; outPropVal: HCkString);
procedure CkJsonArray_putDebugLogFilePath(objHandle: HCkJsonArray; newPropVal: PWideChar);
function CkJsonArray__debugLogFilePath(objHandle: HCkJsonArray): PWideChar;
function CkJsonArray_getEmitCompact(objHandle: HCkJsonArray): wordbool;
procedure CkJsonArray_putEmitCompact(objHandle: HCkJsonArray; newPropVal: wordbool);
function CkJsonArray_getEmitCrlf(objHandle: HCkJsonArray): wordbool;
procedure CkJsonArray_putEmitCrlf(objHandle: HCkJsonArray; newPropVal: wordbool);
procedure CkJsonArray_getLastErrorHtml(objHandle: HCkJsonArray; outPropVal: HCkString);
function CkJsonArray__lastErrorHtml(objHandle: HCkJsonArray): PWideChar;
procedure CkJsonArray_getLastErrorText(objHandle: HCkJsonArray; outPropVal: HCkString);
function CkJsonArray__lastErrorText(objHandle: HCkJsonArray): PWideChar;
procedure CkJsonArray_getLastErrorXml(objHandle: HCkJsonArray; outPropVal: HCkString);
function CkJsonArray__lastErrorXml(objHandle: HCkJsonArray): PWideChar;
function CkJsonArray_getLastMethodSuccess(objHandle: HCkJsonArray): wordbool;
procedure CkJsonArray_putLastMethodSuccess(objHandle: HCkJsonArray; newPropVal: wordbool);
function CkJsonArray_getSize(objHandle: HCkJsonArray): Integer;
function CkJsonArray_getVerboseLogging(objHandle: HCkJsonArray): wordbool;
procedure CkJsonArray_putVerboseLogging(objHandle: HCkJsonArray; newPropVal: wordbool);
procedure CkJsonArray_getVersion(objHandle: HCkJsonArray; outPropVal: HCkString);
function CkJsonArray__version(objHandle: HCkJsonArray): PWideChar;
function CkJsonArray_AddArrayAt(objHandle: HCkJsonArray; index: Integer): wordbool;
function CkJsonArray_AddArrayAt2(objHandle: HCkJsonArray; index: Integer; jarr: HCkJsonArray): wordbool;
function CkJsonArray_AddBoolAt(objHandle: HCkJsonArray; index: Integer; value: wordbool): wordbool;
function CkJsonArray_AddIntAt(objHandle: HCkJsonArray; index: Integer; value: Integer): wordbool;
function CkJsonArray_AddNullAt(objHandle: HCkJsonArray; index: Integer): wordbool;
function CkJsonArray_AddNumberAt(objHandle: HCkJsonArray; index: Integer; numericStr: PWideChar): wordbool;
function CkJsonArray_AddObjectAt(objHandle: HCkJsonArray; index: Integer): wordbool;
function CkJsonArray_AddObjectAt2(objHandle: HCkJsonArray; index: Integer; json: HCkJsonObject): wordbool;
function CkJsonArray_AddObjectCopyAt(objHandle: HCkJsonArray; index: Integer; jsonObj: HCkJsonObject): wordbool;
function CkJsonArray_AddStringAt(objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool;
function CkJsonArray_AddUIntAt(objHandle: HCkJsonArray; index: Integer; value: LongWord): wordbool;
function CkJsonArray_AppendArrayItems(objHandle: HCkJsonArray; jarr: HCkJsonArray): wordbool;
function CkJsonArray_ArrayAt(objHandle: HCkJsonArray; index: Integer): HCkJsonArray;
function CkJsonArray_ArrayAt2(objHandle: HCkJsonArray; index: Integer; jarr: HCkJsonArray): wordbool;
function CkJsonArray_BoolAt(objHandle: HCkJsonArray; index: Integer): wordbool;
procedure CkJsonArray_Clear(objHandle: HCkJsonArray);
function CkJsonArray_DateAt(objHandle: HCkJsonArray; index: Integer; dateTime: HCkDateTime): wordbool;
function CkJsonArray_DeleteAt(objHandle: HCkJsonArray; index: Integer): wordbool;
function CkJsonArray_DtAt(objHandle: HCkJsonArray; index: Integer; bLocal: wordbool; dt: HCkDtObj): wordbool;
function CkJsonArray_Emit(objHandle: HCkJsonArray; outStr: HCkString): wordbool;
function CkJsonArray__emit(objHandle: HCkJsonArray): PWideChar;
function CkJsonArray_EmitSb(objHandle: HCkJsonArray; sb: HCkStringBuilder): wordbool;
function CkJsonArray_FindObject(objHandle: HCkJsonArray; name: PWideChar; value: PWideChar; caseSensitive: wordbool): Integer;
function CkJsonArray_FindString(objHandle: HCkJsonArray; value: PWideChar; caseSensitive: wordbool): Integer;
function CkJsonArray_IntAt(objHandle: HCkJsonArray; index: Integer): Integer;
function CkJsonArray_IsNullAt(objHandle: HCkJsonArray; index: Integer): wordbool;
function CkJsonArray_Load(objHandle: HCkJsonArray; jsonArray: PWideChar): wordbool;
function CkJsonArray_LoadSb(objHandle: HCkJsonArray; sb: HCkStringBuilder): wordbool;
function CkJsonArray_ObjectAt(objHandle: HCkJsonArray; index: Integer): HCkJsonObject;
function CkJsonArray_ObjectAt2(objHandle: HCkJsonArray; index: Integer; jsonObj: HCkJsonObject): wordbool;
function CkJsonArray_SetBoolAt(objHandle: HCkJsonArray; index: Integer; value: wordbool): wordbool;
function CkJsonArray_SetIntAt(objHandle: HCkJsonArray; index: Integer; value: Integer): wordbool;
function CkJsonArray_SetNullAt(objHandle: HCkJsonArray; index: Integer): wordbool;
function CkJsonArray_SetNumberAt(objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool;
function CkJsonArray_SetStringAt(objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool;
function CkJsonArray_SetUIntAt(objHandle: HCkJsonArray; index: Integer; value: LongWord): wordbool;
function CkJsonArray_StringAt(objHandle: HCkJsonArray; index: Integer; outStr: HCkString): wordbool;
function CkJsonArray__stringAt(objHandle: HCkJsonArray; index: Integer): PWideChar;
function CkJsonArray_Swap(objHandle: HCkJsonArray; index1: Integer; index2: Integer): wordbool;
function CkJsonArray_TypeAt(objHandle: HCkJsonArray; index: Integer): Integer;
function CkJsonArray_UIntAt(objHandle: HCkJsonArray; index: Integer): LongWord;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkJsonArray_Create = function : HCkJsonArray; stdcall;
  TCkJsonArray_Dispose = procedure (handle: HCkJsonArray); stdcall;
  TCkJsonArray_getDebugLogFilePath = procedure (objHandle: HCkJsonArray; outPropVal: HCkString); stdcall;
  TCkJsonArray_putDebugLogFilePath = procedure (objHandle: HCkJsonArray; newPropVal: PWideChar); stdcall;
  TCkJsonArray__debugLogFilePath = function (objHandle: HCkJsonArray): PWideChar; stdcall;
  TCkJsonArray_getEmitCompact = function (objHandle: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_putEmitCompact = procedure (objHandle: HCkJsonArray; newPropVal: wordbool); stdcall;
  TCkJsonArray_getEmitCrlf = function (objHandle: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_putEmitCrlf = procedure (objHandle: HCkJsonArray; newPropVal: wordbool); stdcall;
  TCkJsonArray_getLastErrorHtml = procedure (objHandle: HCkJsonArray; outPropVal: HCkString); stdcall;
  TCkJsonArray__lastErrorHtml = function (objHandle: HCkJsonArray): PWideChar; stdcall;
  TCkJsonArray_getLastErrorText = procedure (objHandle: HCkJsonArray; outPropVal: HCkString); stdcall;
  TCkJsonArray__lastErrorText = function (objHandle: HCkJsonArray): PWideChar; stdcall;
  TCkJsonArray_getLastErrorXml = procedure (objHandle: HCkJsonArray; outPropVal: HCkString); stdcall;
  TCkJsonArray__lastErrorXml = function (objHandle: HCkJsonArray): PWideChar; stdcall;
  TCkJsonArray_getLastMethodSuccess = function (objHandle: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_putLastMethodSuccess = procedure (objHandle: HCkJsonArray; newPropVal: wordbool); stdcall;
  TCkJsonArray_getSize = function (objHandle: HCkJsonArray): Integer; stdcall;
  TCkJsonArray_getVerboseLogging = function (objHandle: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_putVerboseLogging = procedure (objHandle: HCkJsonArray; newPropVal: wordbool); stdcall;
  TCkJsonArray_getVersion = procedure (objHandle: HCkJsonArray; outPropVal: HCkString); stdcall;
  TCkJsonArray__version = function (objHandle: HCkJsonArray): PWideChar; stdcall;
  TCkJsonArray_AddArrayAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_AddArrayAt2 = function (objHandle: HCkJsonArray; index: Integer; jarr: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_AddBoolAt = function (objHandle: HCkJsonArray; index: Integer; value: wordbool): wordbool; stdcall;
  TCkJsonArray_AddIntAt = function (objHandle: HCkJsonArray; index: Integer; value: Integer): wordbool; stdcall;
  TCkJsonArray_AddNullAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_AddNumberAt = function (objHandle: HCkJsonArray; index: Integer; numericStr: PWideChar): wordbool; stdcall;
  TCkJsonArray_AddObjectAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_AddObjectAt2 = function (objHandle: HCkJsonArray; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkJsonArray_AddObjectCopyAt = function (objHandle: HCkJsonArray; index: Integer; jsonObj: HCkJsonObject): wordbool; stdcall;
  TCkJsonArray_AddStringAt = function (objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool; stdcall;
  TCkJsonArray_AddUIntAt = function (objHandle: HCkJsonArray; index: Integer; value: LongWord): wordbool; stdcall;
  TCkJsonArray_AppendArrayItems = function (objHandle: HCkJsonArray; jarr: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_ArrayAt = function (objHandle: HCkJsonArray; index: Integer): HCkJsonArray; stdcall;
  TCkJsonArray_ArrayAt2 = function (objHandle: HCkJsonArray; index: Integer; jarr: HCkJsonArray): wordbool; stdcall;
  TCkJsonArray_BoolAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_Clear = procedure (objHandle: HCkJsonArray); stdcall;
  TCkJsonArray_DateAt = function (objHandle: HCkJsonArray; index: Integer; dateTime: HCkDateTime): wordbool; stdcall;
  TCkJsonArray_DeleteAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_DtAt = function (objHandle: HCkJsonArray; index: Integer; bLocal: wordbool; dt: HCkDtObj): wordbool; stdcall;
  TCkJsonArray_Emit = function (objHandle: HCkJsonArray; outStr: HCkString): wordbool; stdcall;
  TCkJsonArray__emit = function (objHandle: HCkJsonArray): PWideChar; stdcall;
  TCkJsonArray_EmitSb = function (objHandle: HCkJsonArray; sb: HCkStringBuilder): wordbool; stdcall;
  TCkJsonArray_FindObject = function (objHandle: HCkJsonArray; name: PWideChar; value: PWideChar; caseSensitive: wordbool): Integer; stdcall;
  TCkJsonArray_FindString = function (objHandle: HCkJsonArray; value: PWideChar; caseSensitive: wordbool): Integer; stdcall;
  TCkJsonArray_IntAt = function (objHandle: HCkJsonArray; index: Integer): Integer; stdcall;
  TCkJsonArray_IsNullAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_Load = function (objHandle: HCkJsonArray; jsonArray: PWideChar): wordbool; stdcall;
  TCkJsonArray_LoadSb = function (objHandle: HCkJsonArray; sb: HCkStringBuilder): wordbool; stdcall;
  TCkJsonArray_ObjectAt = function (objHandle: HCkJsonArray; index: Integer): HCkJsonObject; stdcall;
  TCkJsonArray_ObjectAt2 = function (objHandle: HCkJsonArray; index: Integer; jsonObj: HCkJsonObject): wordbool; stdcall;
  TCkJsonArray_SetBoolAt = function (objHandle: HCkJsonArray; index: Integer; value: wordbool): wordbool; stdcall;
  TCkJsonArray_SetIntAt = function (objHandle: HCkJsonArray; index: Integer; value: Integer): wordbool; stdcall;
  TCkJsonArray_SetNullAt = function (objHandle: HCkJsonArray; index: Integer): wordbool; stdcall;
  TCkJsonArray_SetNumberAt = function (objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool; stdcall;
  TCkJsonArray_SetStringAt = function (objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool; stdcall;
  TCkJsonArray_SetUIntAt = function (objHandle: HCkJsonArray; index: Integer; value: LongWord): wordbool; stdcall;
  TCkJsonArray_StringAt = function (objHandle: HCkJsonArray; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkJsonArray__stringAt = function (objHandle: HCkJsonArray; index: Integer): PWideChar; stdcall;
  TCkJsonArray_Swap = function (objHandle: HCkJsonArray; index1: Integer; index2: Integer): wordbool; stdcall;
  TCkJsonArray_TypeAt = function (objHandle: HCkJsonArray; index: Integer): Integer; stdcall;
  TCkJsonArray_UIntAt = function (objHandle: HCkJsonArray; index: Integer): LongWord; stdcall;

var
  _fkt_ptr_arr:   array [0..62] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkJsonArray_Create : HCkJsonArray;
begin
  result := TCkJsonArray_Create(_map(0, 'CkJsonArray_Create'));
end;

procedure CkJsonArray_Dispose (handle: HCkJsonArray);
begin
  TCkJsonArray_Dispose(_map(1, 'CkJsonArray_Dispose'))
    (handle);
end;


procedure CkJsonArray_getDebugLogFilePath (objHandle: HCkJsonArray; outPropVal: HCkString);
begin
  TCkJsonArray_getDebugLogFilePath(_map(2, 'CkJsonArray_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkJsonArray_putDebugLogFilePath (objHandle: HCkJsonArray; newPropVal: PWideChar);
begin
  TCkJsonArray_putDebugLogFilePath(_map(3, 'CkJsonArray_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkJsonArray__debugLogFilePath (objHandle: HCkJsonArray): PWideChar;
begin
  result := TCkJsonArray__debugLogFilePath(_map(4, 'CkJsonArray__debugLogFilePath'))
    (objHandle);
end;

function CkJsonArray_getEmitCompact (objHandle: HCkJsonArray): wordbool;
begin
    result := TCkJsonArray_getEmitCompact(_map(5, 'CkJsonArray_getEmitCompact'))
    (objHandle);
end;

procedure CkJsonArray_putEmitCompact (objHandle: HCkJsonArray; newPropVal: wordbool);
begin
  TCkJsonArray_putEmitCompact(_map(6, 'CkJsonArray_putEmitCompact'))
    (objHandle, newPropVal);
end;

function CkJsonArray_getEmitCrlf (objHandle: HCkJsonArray): wordbool;
begin
    result := TCkJsonArray_getEmitCrlf(_map(7, 'CkJsonArray_getEmitCrlf'))
    (objHandle);
end;

procedure CkJsonArray_putEmitCrlf (objHandle: HCkJsonArray; newPropVal: wordbool);
begin
  TCkJsonArray_putEmitCrlf(_map(8, 'CkJsonArray_putEmitCrlf'))
    (objHandle, newPropVal);
end;

procedure CkJsonArray_getLastErrorHtml (objHandle: HCkJsonArray; outPropVal: HCkString);
begin
  TCkJsonArray_getLastErrorHtml(_map(9, 'CkJsonArray_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkJsonArray__lastErrorHtml (objHandle: HCkJsonArray): PWideChar;
begin
  result := TCkJsonArray__lastErrorHtml(_map(10, 'CkJsonArray__lastErrorHtml'))
    (objHandle);
end;

procedure CkJsonArray_getLastErrorText (objHandle: HCkJsonArray; outPropVal: HCkString);
begin
  TCkJsonArray_getLastErrorText(_map(11, 'CkJsonArray_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkJsonArray__lastErrorText (objHandle: HCkJsonArray): PWideChar;
begin
  result := TCkJsonArray__lastErrorText(_map(12, 'CkJsonArray__lastErrorText'))
    (objHandle);
end;

procedure CkJsonArray_getLastErrorXml (objHandle: HCkJsonArray; outPropVal: HCkString);
begin
  TCkJsonArray_getLastErrorXml(_map(13, 'CkJsonArray_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkJsonArray__lastErrorXml (objHandle: HCkJsonArray): PWideChar;
begin
  result := TCkJsonArray__lastErrorXml(_map(14, 'CkJsonArray__lastErrorXml'))
    (objHandle);
end;

function CkJsonArray_getLastMethodSuccess (objHandle: HCkJsonArray): wordbool;
begin
    result := TCkJsonArray_getLastMethodSuccess(_map(15, 'CkJsonArray_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkJsonArray_putLastMethodSuccess (objHandle: HCkJsonArray; newPropVal: wordbool);
begin
  TCkJsonArray_putLastMethodSuccess(_map(16, 'CkJsonArray_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkJsonArray_getSize (objHandle: HCkJsonArray): Integer;
begin
    result := TCkJsonArray_getSize(_map(17, 'CkJsonArray_getSize'))
    (objHandle);
end;

function CkJsonArray_getVerboseLogging (objHandle: HCkJsonArray): wordbool;
begin
    result := TCkJsonArray_getVerboseLogging(_map(18, 'CkJsonArray_getVerboseLogging'))
    (objHandle);
end;

procedure CkJsonArray_putVerboseLogging (objHandle: HCkJsonArray; newPropVal: wordbool);
begin
  TCkJsonArray_putVerboseLogging(_map(19, 'CkJsonArray_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkJsonArray_getVersion (objHandle: HCkJsonArray; outPropVal: HCkString);
begin
  TCkJsonArray_getVersion(_map(20, 'CkJsonArray_getVersion'))
    (objHandle, outPropVal);
end;

function CkJsonArray__version (objHandle: HCkJsonArray): PWideChar;
begin
  result := TCkJsonArray__version(_map(21, 'CkJsonArray__version'))
    (objHandle);
end;

function CkJsonArray_AddArrayAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_AddArrayAt(_map(22, 'CkJsonArray_AddArrayAt'))
    (objHandle, index);
end;

function CkJsonArray_AddArrayAt2 (objHandle: HCkJsonArray; index: Integer; jarr: HCkJsonArray): wordbool;
begin
  result := TCkJsonArray_AddArrayAt2(_map(23, 'CkJsonArray_AddArrayAt2'))
    (objHandle, index, jarr);
end;

function CkJsonArray_AddBoolAt (objHandle: HCkJsonArray; index: Integer; value: wordbool): wordbool;
begin
  result := TCkJsonArray_AddBoolAt(_map(24, 'CkJsonArray_AddBoolAt'))
    (objHandle, index, value);
end;

function CkJsonArray_AddIntAt (objHandle: HCkJsonArray; index: Integer; value: Integer): wordbool;
begin
  result := TCkJsonArray_AddIntAt(_map(25, 'CkJsonArray_AddIntAt'))
    (objHandle, index, value);
end;

function CkJsonArray_AddNullAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_AddNullAt(_map(26, 'CkJsonArray_AddNullAt'))
    (objHandle, index);
end;

function CkJsonArray_AddNumberAt (objHandle: HCkJsonArray; index: Integer; numericStr: PWideChar): wordbool;
begin
  result := TCkJsonArray_AddNumberAt(_map(27, 'CkJsonArray_AddNumberAt'))
    (objHandle, index, numericStr);
end;

function CkJsonArray_AddObjectAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_AddObjectAt(_map(28, 'CkJsonArray_AddObjectAt'))
    (objHandle, index);
end;

function CkJsonArray_AddObjectAt2 (objHandle: HCkJsonArray; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkJsonArray_AddObjectAt2(_map(29, 'CkJsonArray_AddObjectAt2'))
    (objHandle, index, json);
end;

function CkJsonArray_AddObjectCopyAt (objHandle: HCkJsonArray; index: Integer; jsonObj: HCkJsonObject): wordbool;
begin
  result := TCkJsonArray_AddObjectCopyAt(_map(30, 'CkJsonArray_AddObjectCopyAt'))
    (objHandle, index, jsonObj);
end;

function CkJsonArray_AddStringAt (objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool;
begin
  result := TCkJsonArray_AddStringAt(_map(31, 'CkJsonArray_AddStringAt'))
    (objHandle, index, value);
end;

function CkJsonArray_AddUIntAt (objHandle: HCkJsonArray; index: Integer; value: LongWord): wordbool;
begin
  result := TCkJsonArray_AddUIntAt(_map(32, 'CkJsonArray_AddUIntAt'))
    (objHandle, index, value);
end;

function CkJsonArray_AppendArrayItems (objHandle: HCkJsonArray; jarr: HCkJsonArray): wordbool;
begin
  result := TCkJsonArray_AppendArrayItems(_map(33, 'CkJsonArray_AppendArrayItems'))
    (objHandle, jarr);
end;

function CkJsonArray_ArrayAt (objHandle: HCkJsonArray; index: Integer): HCkJsonArray;
begin
  result := TCkJsonArray_ArrayAt(_map(34, 'CkJsonArray_ArrayAt'))
    (objHandle, index);
end;

function CkJsonArray_ArrayAt2 (objHandle: HCkJsonArray; index: Integer; jarr: HCkJsonArray): wordbool;
begin
  result := TCkJsonArray_ArrayAt2(_map(35, 'CkJsonArray_ArrayAt2'))
    (objHandle, index, jarr);
end;

function CkJsonArray_BoolAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_BoolAt(_map(36, 'CkJsonArray_BoolAt'))
    (objHandle, index);
end;

procedure CkJsonArray_Clear (objHandle: HCkJsonArray);
begin
  TCkJsonArray_Clear(_map(37, 'CkJsonArray_Clear'))
    (objHandle);
end;

function CkJsonArray_DateAt (objHandle: HCkJsonArray; index: Integer; dateTime: HCkDateTime): wordbool;
begin
  result := TCkJsonArray_DateAt(_map(38, 'CkJsonArray_DateAt'))
    (objHandle, index, dateTime);
end;

function CkJsonArray_DeleteAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_DeleteAt(_map(39, 'CkJsonArray_DeleteAt'))
    (objHandle, index);
end;

function CkJsonArray_DtAt (objHandle: HCkJsonArray; index: Integer; bLocal: wordbool; dt: HCkDtObj): wordbool;
begin
  result := TCkJsonArray_DtAt(_map(40, 'CkJsonArray_DtAt'))
    (objHandle, index, bLocal, dt);
end;

function CkJsonArray_Emit (objHandle: HCkJsonArray; outStr: HCkString): wordbool;
begin
  result := TCkJsonArray_Emit(_map(41, 'CkJsonArray_Emit'))
    (objHandle, outStr);
end;

function CkJsonArray__emit (objHandle: HCkJsonArray): PWideChar;
begin
  result := TCkJsonArray__emit(_map(42, 'CkJsonArray__emit'))
    (objHandle);
end;

function CkJsonArray_EmitSb (objHandle: HCkJsonArray; sb: HCkStringBuilder): wordbool;
begin
  result := TCkJsonArray_EmitSb(_map(43, 'CkJsonArray_EmitSb'))
    (objHandle, sb);
end;

function CkJsonArray_FindObject (objHandle: HCkJsonArray; name: PWideChar; value: PWideChar; caseSensitive: wordbool): Integer;
begin
  result := TCkJsonArray_FindObject(_map(44, 'CkJsonArray_FindObject'))
    (objHandle, name, value, caseSensitive);
end;

function CkJsonArray_FindString (objHandle: HCkJsonArray; value: PWideChar; caseSensitive: wordbool): Integer;
begin
  result := TCkJsonArray_FindString(_map(45, 'CkJsonArray_FindString'))
    (objHandle, value, caseSensitive);
end;

function CkJsonArray_IntAt (objHandle: HCkJsonArray; index: Integer): Integer;
begin
  result := TCkJsonArray_IntAt(_map(46, 'CkJsonArray_IntAt'))
    (objHandle, index);
end;

function CkJsonArray_IsNullAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_IsNullAt(_map(47, 'CkJsonArray_IsNullAt'))
    (objHandle, index);
end;

function CkJsonArray_Load (objHandle: HCkJsonArray; jsonArray: PWideChar): wordbool;
begin
  result := TCkJsonArray_Load(_map(48, 'CkJsonArray_Load'))
    (objHandle, jsonArray);
end;

function CkJsonArray_LoadSb (objHandle: HCkJsonArray; sb: HCkStringBuilder): wordbool;
begin
  result := TCkJsonArray_LoadSb(_map(49, 'CkJsonArray_LoadSb'))
    (objHandle, sb);
end;

function CkJsonArray_ObjectAt (objHandle: HCkJsonArray; index: Integer): HCkJsonObject;
begin
  result := TCkJsonArray_ObjectAt(_map(50, 'CkJsonArray_ObjectAt'))
    (objHandle, index);
end;

function CkJsonArray_ObjectAt2 (objHandle: HCkJsonArray; index: Integer; jsonObj: HCkJsonObject): wordbool;
begin
  result := TCkJsonArray_ObjectAt2(_map(51, 'CkJsonArray_ObjectAt2'))
    (objHandle, index, jsonObj);
end;

function CkJsonArray_SetBoolAt (objHandle: HCkJsonArray; index: Integer; value: wordbool): wordbool;
begin
  result := TCkJsonArray_SetBoolAt(_map(52, 'CkJsonArray_SetBoolAt'))
    (objHandle, index, value);
end;

function CkJsonArray_SetIntAt (objHandle: HCkJsonArray; index: Integer; value: Integer): wordbool;
begin
  result := TCkJsonArray_SetIntAt(_map(53, 'CkJsonArray_SetIntAt'))
    (objHandle, index, value);
end;

function CkJsonArray_SetNullAt (objHandle: HCkJsonArray; index: Integer): wordbool;
begin
  result := TCkJsonArray_SetNullAt(_map(54, 'CkJsonArray_SetNullAt'))
    (objHandle, index);
end;

function CkJsonArray_SetNumberAt (objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool;
begin
  result := TCkJsonArray_SetNumberAt(_map(55, 'CkJsonArray_SetNumberAt'))
    (objHandle, index, value);
end;

function CkJsonArray_SetStringAt (objHandle: HCkJsonArray; index: Integer; value: PWideChar): wordbool;
begin
  result := TCkJsonArray_SetStringAt(_map(56, 'CkJsonArray_SetStringAt'))
    (objHandle, index, value);
end;

function CkJsonArray_SetUIntAt (objHandle: HCkJsonArray; index: Integer; value: LongWord): wordbool;
begin
  result := TCkJsonArray_SetUIntAt(_map(57, 'CkJsonArray_SetUIntAt'))
    (objHandle, index, value);
end;

function CkJsonArray_StringAt (objHandle: HCkJsonArray; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkJsonArray_StringAt(_map(58, 'CkJsonArray_StringAt'))
    (objHandle, index, outStr);
end;

function CkJsonArray__stringAt (objHandle: HCkJsonArray; index: Integer): PWideChar;
begin
  result := TCkJsonArray__stringAt(_map(59, 'CkJsonArray__stringAt'))
    (objHandle, index);
end;

function CkJsonArray_Swap (objHandle: HCkJsonArray; index1: Integer; index2: Integer): wordbool;
begin
  result := TCkJsonArray_Swap(_map(60, 'CkJsonArray_Swap'))
    (objHandle, index1, index2);
end;

function CkJsonArray_TypeAt (objHandle: HCkJsonArray; index: Integer): Integer;
begin
  result := TCkJsonArray_TypeAt(_map(61, 'CkJsonArray_TypeAt'))
    (objHandle, index);
end;

function CkJsonArray_UIntAt (objHandle: HCkJsonArray; index: Integer): LongWord;
begin
  result := TCkJsonArray_UIntAt(_map(62, 'CkJsonArray_UIntAt'))
    (objHandle, index);
end;

end.
