unit Jwe;

interface

type

HCkJwe = Pointer;
HCkJsonObject = Pointer;
HCkPrivateKey = Pointer;
HCkPublicKey = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkBinData = Pointer;


function CkJwe_Create: HCkJwe;  stdcall;
procedure CkJwe_Dispose(handle: HCkJwe); stdcall;
procedure CkJwe_getDebugLogFilePath(objHandle: HCkJwe; outPropVal: HCkString);
procedure CkJwe_putDebugLogFilePath(objHandle: HCkJwe; newPropVal: PWideChar);
function CkJwe__debugLogFilePath(objHandle: HCkJwe): PWideChar;
procedure CkJwe_getLastErrorHtml(objHandle: HCkJwe; outPropVal: HCkString);
function CkJwe__lastErrorHtml(objHandle: HCkJwe): PWideChar;
procedure CkJwe_getLastErrorText(objHandle: HCkJwe; outPropVal: HCkString);
function CkJwe__lastErrorText(objHandle: HCkJwe): PWideChar;
procedure CkJwe_getLastErrorXml(objHandle: HCkJwe; outPropVal: HCkString);
function CkJwe__lastErrorXml(objHandle: HCkJwe): PWideChar;
function CkJwe_getLastMethodSuccess(objHandle: HCkJwe): wordbool;
procedure CkJwe_putLastMethodSuccess(objHandle: HCkJwe; newPropVal: wordbool);
function CkJwe_getNumRecipients(objHandle: HCkJwe): Integer;
function CkJwe_getPreferCompact(objHandle: HCkJwe): wordbool;
procedure CkJwe_putPreferCompact(objHandle: HCkJwe; newPropVal: wordbool);
function CkJwe_getPreferFlattened(objHandle: HCkJwe): wordbool;
procedure CkJwe_putPreferFlattened(objHandle: HCkJwe; newPropVal: wordbool);
procedure CkJwe_getUncommonOptions(objHandle: HCkJwe; outPropVal: HCkString);
procedure CkJwe_putUncommonOptions(objHandle: HCkJwe; newPropVal: PWideChar);
function CkJwe__uncommonOptions(objHandle: HCkJwe): PWideChar;
function CkJwe_getVerboseLogging(objHandle: HCkJwe): wordbool;
procedure CkJwe_putVerboseLogging(objHandle: HCkJwe; newPropVal: wordbool);
procedure CkJwe_getVersion(objHandle: HCkJwe; outPropVal: HCkString);
function CkJwe__version(objHandle: HCkJwe): PWideChar;
function CkJwe_Decrypt(objHandle: HCkJwe; index: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkJwe__decrypt(objHandle: HCkJwe; index: Integer; charset: PWideChar): PWideChar;
function CkJwe_DecryptBd(objHandle: HCkJwe; index: Integer; bd: HCkBinData): wordbool;
function CkJwe_DecryptSb(objHandle: HCkJwe; index: Integer; charset: PWideChar; contentSb: HCkStringBuilder): wordbool;
function CkJwe_Encrypt(objHandle: HCkJwe; content: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkJwe__encrypt(objHandle: HCkJwe; content: PWideChar; charset: PWideChar): PWideChar;
function CkJwe_EncryptBd(objHandle: HCkJwe; contentBd: HCkBinData; jweSb: HCkStringBuilder): wordbool;
function CkJwe_EncryptSb(objHandle: HCkJwe; contentSb: HCkStringBuilder; charset: PWideChar; jweSb: HCkStringBuilder): wordbool;
function CkJwe_FindRecipient(objHandle: HCkJwe; paramName: PWideChar; paramValue: PWideChar; caseSensitive: wordbool): Integer;
function CkJwe_GetHeader(objHandle: HCkJwe; json: HCkJsonObject): wordbool;
function CkJwe_GetProtectedHeader(objHandle: HCkJwe; json: HCkJsonObject): wordbool;
function CkJwe_LoadJwe(objHandle: HCkJwe; jwe: PWideChar): wordbool;
function CkJwe_LoadJweSb(objHandle: HCkJwe; sb: HCkStringBuilder): wordbool;
function CkJwe_SetAad(objHandle: HCkJwe; aad: PWideChar; charset: PWideChar): wordbool;
function CkJwe_SetAadBd(objHandle: HCkJwe; aad: HCkBinData): wordbool;
function CkJwe_SetPassword(objHandle: HCkJwe; index: Integer; password: PWideChar): wordbool;
function CkJwe_SetPrivateKey(objHandle: HCkJwe; index: Integer; privKey: HCkPrivateKey): wordbool;
function CkJwe_SetProtectedHeader(objHandle: HCkJwe; json: HCkJsonObject): wordbool;
function CkJwe_SetPublicKey(objHandle: HCkJwe; index: Integer; pubKey: HCkPublicKey): wordbool;
function CkJwe_SetRecipientHeader(objHandle: HCkJwe; index: Integer; json: HCkJsonObject): wordbool;
function CkJwe_SetUnprotectedHeader(objHandle: HCkJwe; json: HCkJsonObject): wordbool;
function CkJwe_SetWrappingKey(objHandle: HCkJwe; index: Integer; encodedKey: PWideChar; encoding: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkJwe_Create = function : HCkJwe; stdcall;
  TCkJwe_Dispose = procedure (handle: HCkJwe); stdcall;
  TCkJwe_getDebugLogFilePath = procedure (objHandle: HCkJwe; outPropVal: HCkString); stdcall;
  TCkJwe_putDebugLogFilePath = procedure (objHandle: HCkJwe; newPropVal: PWideChar); stdcall;
  TCkJwe__debugLogFilePath = function (objHandle: HCkJwe): PWideChar; stdcall;
  TCkJwe_getLastErrorHtml = procedure (objHandle: HCkJwe; outPropVal: HCkString); stdcall;
  TCkJwe__lastErrorHtml = function (objHandle: HCkJwe): PWideChar; stdcall;
  TCkJwe_getLastErrorText = procedure (objHandle: HCkJwe; outPropVal: HCkString); stdcall;
  TCkJwe__lastErrorText = function (objHandle: HCkJwe): PWideChar; stdcall;
  TCkJwe_getLastErrorXml = procedure (objHandle: HCkJwe; outPropVal: HCkString); stdcall;
  TCkJwe__lastErrorXml = function (objHandle: HCkJwe): PWideChar; stdcall;
  TCkJwe_getLastMethodSuccess = function (objHandle: HCkJwe): wordbool; stdcall;
  TCkJwe_putLastMethodSuccess = procedure (objHandle: HCkJwe; newPropVal: wordbool); stdcall;
  TCkJwe_getNumRecipients = function (objHandle: HCkJwe): Integer; stdcall;
  TCkJwe_getPreferCompact = function (objHandle: HCkJwe): wordbool; stdcall;
  TCkJwe_putPreferCompact = procedure (objHandle: HCkJwe; newPropVal: wordbool); stdcall;
  TCkJwe_getPreferFlattened = function (objHandle: HCkJwe): wordbool; stdcall;
  TCkJwe_putPreferFlattened = procedure (objHandle: HCkJwe; newPropVal: wordbool); stdcall;
  TCkJwe_getUncommonOptions = procedure (objHandle: HCkJwe; outPropVal: HCkString); stdcall;
  TCkJwe_putUncommonOptions = procedure (objHandle: HCkJwe; newPropVal: PWideChar); stdcall;
  TCkJwe__uncommonOptions = function (objHandle: HCkJwe): PWideChar; stdcall;
  TCkJwe_getVerboseLogging = function (objHandle: HCkJwe): wordbool; stdcall;
  TCkJwe_putVerboseLogging = procedure (objHandle: HCkJwe; newPropVal: wordbool); stdcall;
  TCkJwe_getVersion = procedure (objHandle: HCkJwe; outPropVal: HCkString); stdcall;
  TCkJwe__version = function (objHandle: HCkJwe): PWideChar; stdcall;
  TCkJwe_Decrypt = function (objHandle: HCkJwe; index: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJwe__decrypt = function (objHandle: HCkJwe; index: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkJwe_DecryptBd = function (objHandle: HCkJwe; index: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkJwe_DecryptSb = function (objHandle: HCkJwe; index: Integer; charset: PWideChar; contentSb: HCkStringBuilder): wordbool; stdcall;
  TCkJwe_Encrypt = function (objHandle: HCkJwe; content: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJwe__encrypt = function (objHandle: HCkJwe; content: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkJwe_EncryptBd = function (objHandle: HCkJwe; contentBd: HCkBinData; jweSb: HCkStringBuilder): wordbool; stdcall;
  TCkJwe_EncryptSb = function (objHandle: HCkJwe; contentSb: HCkStringBuilder; charset: PWideChar; jweSb: HCkStringBuilder): wordbool; stdcall;
  TCkJwe_FindRecipient = function (objHandle: HCkJwe; paramName: PWideChar; paramValue: PWideChar; caseSensitive: wordbool): Integer; stdcall;
  TCkJwe_GetHeader = function (objHandle: HCkJwe; json: HCkJsonObject): wordbool; stdcall;
  TCkJwe_GetProtectedHeader = function (objHandle: HCkJwe; json: HCkJsonObject): wordbool; stdcall;
  TCkJwe_LoadJwe = function (objHandle: HCkJwe; jwe: PWideChar): wordbool; stdcall;
  TCkJwe_LoadJweSb = function (objHandle: HCkJwe; sb: HCkStringBuilder): wordbool; stdcall;
  TCkJwe_SetAad = function (objHandle: HCkJwe; aad: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkJwe_SetAadBd = function (objHandle: HCkJwe; aad: HCkBinData): wordbool; stdcall;
  TCkJwe_SetPassword = function (objHandle: HCkJwe; index: Integer; password: PWideChar): wordbool; stdcall;
  TCkJwe_SetPrivateKey = function (objHandle: HCkJwe; index: Integer; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkJwe_SetProtectedHeader = function (objHandle: HCkJwe; json: HCkJsonObject): wordbool; stdcall;
  TCkJwe_SetPublicKey = function (objHandle: HCkJwe; index: Integer; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkJwe_SetRecipientHeader = function (objHandle: HCkJwe; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkJwe_SetUnprotectedHeader = function (objHandle: HCkJwe; json: HCkJsonObject): wordbool; stdcall;
  TCkJwe_SetWrappingKey = function (objHandle: HCkJwe; index: Integer; encodedKey: PWideChar; encoding: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..46] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkJwe_Create : HCkJwe;
begin
  result := TCkJwe_Create(_map(0, 'CkJwe_Create'));
end;

procedure CkJwe_Dispose (handle: HCkJwe);
begin
  TCkJwe_Dispose(_map(1, 'CkJwe_Dispose'))
    (handle);
end;


procedure CkJwe_getDebugLogFilePath (objHandle: HCkJwe; outPropVal: HCkString);
begin
  TCkJwe_getDebugLogFilePath(_map(2, 'CkJwe_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkJwe_putDebugLogFilePath (objHandle: HCkJwe; newPropVal: PWideChar);
begin
  TCkJwe_putDebugLogFilePath(_map(3, 'CkJwe_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkJwe__debugLogFilePath (objHandle: HCkJwe): PWideChar;
begin
  result := TCkJwe__debugLogFilePath(_map(4, 'CkJwe__debugLogFilePath'))
    (objHandle);
end;

procedure CkJwe_getLastErrorHtml (objHandle: HCkJwe; outPropVal: HCkString);
begin
  TCkJwe_getLastErrorHtml(_map(5, 'CkJwe_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkJwe__lastErrorHtml (objHandle: HCkJwe): PWideChar;
begin
  result := TCkJwe__lastErrorHtml(_map(6, 'CkJwe__lastErrorHtml'))
    (objHandle);
end;

procedure CkJwe_getLastErrorText (objHandle: HCkJwe; outPropVal: HCkString);
begin
  TCkJwe_getLastErrorText(_map(7, 'CkJwe_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkJwe__lastErrorText (objHandle: HCkJwe): PWideChar;
begin
  result := TCkJwe__lastErrorText(_map(8, 'CkJwe__lastErrorText'))
    (objHandle);
end;

procedure CkJwe_getLastErrorXml (objHandle: HCkJwe; outPropVal: HCkString);
begin
  TCkJwe_getLastErrorXml(_map(9, 'CkJwe_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkJwe__lastErrorXml (objHandle: HCkJwe): PWideChar;
begin
  result := TCkJwe__lastErrorXml(_map(10, 'CkJwe__lastErrorXml'))
    (objHandle);
end;

function CkJwe_getLastMethodSuccess (objHandle: HCkJwe): wordbool;
begin
    result := TCkJwe_getLastMethodSuccess(_map(11, 'CkJwe_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkJwe_putLastMethodSuccess (objHandle: HCkJwe; newPropVal: wordbool);
begin
  TCkJwe_putLastMethodSuccess(_map(12, 'CkJwe_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkJwe_getNumRecipients (objHandle: HCkJwe): Integer;
begin
    result := TCkJwe_getNumRecipients(_map(13, 'CkJwe_getNumRecipients'))
    (objHandle);
end;

function CkJwe_getPreferCompact (objHandle: HCkJwe): wordbool;
begin
    result := TCkJwe_getPreferCompact(_map(14, 'CkJwe_getPreferCompact'))
    (objHandle);
end;

procedure CkJwe_putPreferCompact (objHandle: HCkJwe; newPropVal: wordbool);
begin
  TCkJwe_putPreferCompact(_map(15, 'CkJwe_putPreferCompact'))
    (objHandle, newPropVal);
end;

function CkJwe_getPreferFlattened (objHandle: HCkJwe): wordbool;
begin
    result := TCkJwe_getPreferFlattened(_map(16, 'CkJwe_getPreferFlattened'))
    (objHandle);
end;

procedure CkJwe_putPreferFlattened (objHandle: HCkJwe; newPropVal: wordbool);
begin
  TCkJwe_putPreferFlattened(_map(17, 'CkJwe_putPreferFlattened'))
    (objHandle, newPropVal);
end;

procedure CkJwe_getUncommonOptions (objHandle: HCkJwe; outPropVal: HCkString);
begin
  TCkJwe_getUncommonOptions(_map(18, 'CkJwe_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkJwe_putUncommonOptions (objHandle: HCkJwe; newPropVal: PWideChar);
begin
  TCkJwe_putUncommonOptions(_map(19, 'CkJwe_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkJwe__uncommonOptions (objHandle: HCkJwe): PWideChar;
begin
  result := TCkJwe__uncommonOptions(_map(20, 'CkJwe__uncommonOptions'))
    (objHandle);
end;

function CkJwe_getVerboseLogging (objHandle: HCkJwe): wordbool;
begin
    result := TCkJwe_getVerboseLogging(_map(21, 'CkJwe_getVerboseLogging'))
    (objHandle);
end;

procedure CkJwe_putVerboseLogging (objHandle: HCkJwe; newPropVal: wordbool);
begin
  TCkJwe_putVerboseLogging(_map(22, 'CkJwe_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkJwe_getVersion (objHandle: HCkJwe; outPropVal: HCkString);
begin
  TCkJwe_getVersion(_map(23, 'CkJwe_getVersion'))
    (objHandle, outPropVal);
end;

function CkJwe__version (objHandle: HCkJwe): PWideChar;
begin
  result := TCkJwe__version(_map(24, 'CkJwe__version'))
    (objHandle);
end;

function CkJwe_Decrypt (objHandle: HCkJwe; index: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJwe_Decrypt(_map(25, 'CkJwe_Decrypt'))
    (objHandle, index, charset, outStr);
end;

function CkJwe__decrypt (objHandle: HCkJwe; index: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkJwe__decrypt(_map(26, 'CkJwe__decrypt'))
    (objHandle, index, charset);
end;

function CkJwe_DecryptBd (objHandle: HCkJwe; index: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkJwe_DecryptBd(_map(27, 'CkJwe_DecryptBd'))
    (objHandle, index, bd);
end;

function CkJwe_DecryptSb (objHandle: HCkJwe; index: Integer; charset: PWideChar; contentSb: HCkStringBuilder): wordbool;
begin
  result := TCkJwe_DecryptSb(_map(28, 'CkJwe_DecryptSb'))
    (objHandle, index, charset, contentSb);
end;

function CkJwe_Encrypt (objHandle: HCkJwe; content: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJwe_Encrypt(_map(29, 'CkJwe_Encrypt'))
    (objHandle, content, charset, outStr);
end;

function CkJwe__encrypt (objHandle: HCkJwe; content: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkJwe__encrypt(_map(30, 'CkJwe__encrypt'))
    (objHandle, content, charset);
end;

function CkJwe_EncryptBd (objHandle: HCkJwe; contentBd: HCkBinData; jweSb: HCkStringBuilder): wordbool;
begin
  result := TCkJwe_EncryptBd(_map(31, 'CkJwe_EncryptBd'))
    (objHandle, contentBd, jweSb);
end;

function CkJwe_EncryptSb (objHandle: HCkJwe; contentSb: HCkStringBuilder; charset: PWideChar; jweSb: HCkStringBuilder): wordbool;
begin
  result := TCkJwe_EncryptSb(_map(32, 'CkJwe_EncryptSb'))
    (objHandle, contentSb, charset, jweSb);
end;

function CkJwe_FindRecipient (objHandle: HCkJwe; paramName: PWideChar; paramValue: PWideChar; caseSensitive: wordbool): Integer;
begin
  result := TCkJwe_FindRecipient(_map(33, 'CkJwe_FindRecipient'))
    (objHandle, paramName, paramValue, caseSensitive);
end;

function CkJwe_GetHeader (objHandle: HCkJwe; json: HCkJsonObject): wordbool;
begin
  result := TCkJwe_GetHeader(_map(34, 'CkJwe_GetHeader'))
    (objHandle, json);
end;

function CkJwe_GetProtectedHeader (objHandle: HCkJwe; json: HCkJsonObject): wordbool;
begin
  result := TCkJwe_GetProtectedHeader(_map(35, 'CkJwe_GetProtectedHeader'))
    (objHandle, json);
end;

function CkJwe_LoadJwe (objHandle: HCkJwe; jwe: PWideChar): wordbool;
begin
  result := TCkJwe_LoadJwe(_map(36, 'CkJwe_LoadJwe'))
    (objHandle, jwe);
end;

function CkJwe_LoadJweSb (objHandle: HCkJwe; sb: HCkStringBuilder): wordbool;
begin
  result := TCkJwe_LoadJweSb(_map(37, 'CkJwe_LoadJweSb'))
    (objHandle, sb);
end;

function CkJwe_SetAad (objHandle: HCkJwe; aad: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkJwe_SetAad(_map(38, 'CkJwe_SetAad'))
    (objHandle, aad, charset);
end;

function CkJwe_SetAadBd (objHandle: HCkJwe; aad: HCkBinData): wordbool;
begin
  result := TCkJwe_SetAadBd(_map(39, 'CkJwe_SetAadBd'))
    (objHandle, aad);
end;

function CkJwe_SetPassword (objHandle: HCkJwe; index: Integer; password: PWideChar): wordbool;
begin
  result := TCkJwe_SetPassword(_map(40, 'CkJwe_SetPassword'))
    (objHandle, index, password);
end;

function CkJwe_SetPrivateKey (objHandle: HCkJwe; index: Integer; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkJwe_SetPrivateKey(_map(41, 'CkJwe_SetPrivateKey'))
    (objHandle, index, privKey);
end;

function CkJwe_SetProtectedHeader (objHandle: HCkJwe; json: HCkJsonObject): wordbool;
begin
  result := TCkJwe_SetProtectedHeader(_map(42, 'CkJwe_SetProtectedHeader'))
    (objHandle, json);
end;

function CkJwe_SetPublicKey (objHandle: HCkJwe; index: Integer; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkJwe_SetPublicKey(_map(43, 'CkJwe_SetPublicKey'))
    (objHandle, index, pubKey);
end;

function CkJwe_SetRecipientHeader (objHandle: HCkJwe; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkJwe_SetRecipientHeader(_map(44, 'CkJwe_SetRecipientHeader'))
    (objHandle, index, json);
end;

function CkJwe_SetUnprotectedHeader (objHandle: HCkJwe; json: HCkJsonObject): wordbool;
begin
  result := TCkJwe_SetUnprotectedHeader(_map(45, 'CkJwe_SetUnprotectedHeader'))
    (objHandle, json);
end;

function CkJwe_SetWrappingKey (objHandle: HCkJwe; index: Integer; encodedKey: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkJwe_SetWrappingKey(_map(46, 'CkJwe_SetWrappingKey'))
    (objHandle, index, encodedKey, encoding);
end;

end.
