unit Jws;

interface

type

HCkPublicKey = Pointer;
HCkJsonObject = Pointer;
HCkPrivateKey = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkBinData = Pointer;
HCkJws = Pointer;


function CkJws_Create: HCkJws;  stdcall;
procedure CkJws_Dispose(handle: HCkJws); stdcall;
procedure CkJws_getDebugLogFilePath(objHandle: HCkJws; outPropVal: HCkString);
procedure CkJws_putDebugLogFilePath(objHandle: HCkJws; newPropVal: PWideChar);
function CkJws__debugLogFilePath(objHandle: HCkJws): PWideChar;
procedure CkJws_getLastErrorHtml(objHandle: HCkJws; outPropVal: HCkString);
function CkJws__lastErrorHtml(objHandle: HCkJws): PWideChar;
procedure CkJws_getLastErrorText(objHandle: HCkJws; outPropVal: HCkString);
function CkJws__lastErrorText(objHandle: HCkJws): PWideChar;
procedure CkJws_getLastErrorXml(objHandle: HCkJws; outPropVal: HCkString);
function CkJws__lastErrorXml(objHandle: HCkJws): PWideChar;
function CkJws_getLastMethodSuccess(objHandle: HCkJws): wordbool;
procedure CkJws_putLastMethodSuccess(objHandle: HCkJws; newPropVal: wordbool);
function CkJws_getNumSignatures(objHandle: HCkJws): Integer;
function CkJws_getPreferCompact(objHandle: HCkJws): wordbool;
procedure CkJws_putPreferCompact(objHandle: HCkJws; newPropVal: wordbool);
function CkJws_getPreferFlattened(objHandle: HCkJws): wordbool;
procedure CkJws_putPreferFlattened(objHandle: HCkJws; newPropVal: wordbool);
procedure CkJws_getUncommonOptions(objHandle: HCkJws; outPropVal: HCkString);
procedure CkJws_putUncommonOptions(objHandle: HCkJws; newPropVal: PWideChar);
function CkJws__uncommonOptions(objHandle: HCkJws): PWideChar;
function CkJws_getVerboseLogging(objHandle: HCkJws): wordbool;
procedure CkJws_putVerboseLogging(objHandle: HCkJws; newPropVal: wordbool);
procedure CkJws_getVersion(objHandle: HCkJws; outPropVal: HCkString);
function CkJws__version(objHandle: HCkJws): PWideChar;
function CkJws_CreateJws(objHandle: HCkJws; outStr: HCkString): wordbool;
function CkJws__createJws(objHandle: HCkJws): PWideChar;
function CkJws_CreateJwsSb(objHandle: HCkJws; sbJws: HCkStringBuilder): wordbool;
function CkJws_GetPayload(objHandle: HCkJws; charset: PWideChar; outStr: HCkString): wordbool;
function CkJws__getPayload(objHandle: HCkJws; charset: PWideChar): PWideChar;
function CkJws_GetPayloadBd(objHandle: HCkJws; binData: HCkBinData): wordbool;
function CkJws_GetPayloadSb(objHandle: HCkJws; charset: PWideChar; sbPayload: HCkStringBuilder): wordbool;
function CkJws_GetProtectedH(objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
function CkJws_GetProtectedHeader(objHandle: HCkJws; index: Integer): HCkJsonObject;
function CkJws_GetUnprotectedH(objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
function CkJws_GetUnprotectedHeader(objHandle: HCkJws; index: Integer): HCkJsonObject;
function CkJws_LoadJws(objHandle: HCkJws; jwsStr: PWideChar): wordbool;
function CkJws_LoadJwsSb(objHandle: HCkJws; sbJws: HCkStringBuilder): wordbool;
function CkJws_SetMacKey(objHandle: HCkJws; index: Integer; key: PWideChar; encoding: PWideChar): wordbool;
function CkJws_SetMacKeyBd(objHandle: HCkJws; index: Integer; key: HCkBinData): wordbool;
function CkJws_SetPayload(objHandle: HCkJws; payload: PWideChar; charset: PWideChar; includeBom: wordbool): wordbool;
function CkJws_SetPayloadBd(objHandle: HCkJws; binData: HCkBinData): wordbool;
function CkJws_SetPayloadSb(objHandle: HCkJws; sbPayload: HCkStringBuilder; charset: PWideChar; includeBom: wordbool): wordbool;
function CkJws_SetPrivateKey(objHandle: HCkJws; index: Integer; privKey: HCkPrivateKey): wordbool;
function CkJws_SetProtectedHeader(objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
function CkJws_SetPublicKey(objHandle: HCkJws; index: Integer; pubKey: HCkPublicKey): wordbool;
function CkJws_SetUnprotectedHeader(objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
function CkJws_Validate(objHandle: HCkJws; index: Integer): Integer;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkJws_Create = function : HCkJws; stdcall;
  TCkJws_Dispose = procedure (handle: HCkJws); stdcall;
  TCkJws_getDebugLogFilePath = procedure (objHandle: HCkJws; outPropVal: HCkString); stdcall;
  TCkJws_putDebugLogFilePath = procedure (objHandle: HCkJws; newPropVal: PWideChar); stdcall;
  TCkJws__debugLogFilePath = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_getLastErrorHtml = procedure (objHandle: HCkJws; outPropVal: HCkString); stdcall;
  TCkJws__lastErrorHtml = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_getLastErrorText = procedure (objHandle: HCkJws; outPropVal: HCkString); stdcall;
  TCkJws__lastErrorText = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_getLastErrorXml = procedure (objHandle: HCkJws; outPropVal: HCkString); stdcall;
  TCkJws__lastErrorXml = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_getLastMethodSuccess = function (objHandle: HCkJws): wordbool; stdcall;
  TCkJws_putLastMethodSuccess = procedure (objHandle: HCkJws; newPropVal: wordbool); stdcall;
  TCkJws_getNumSignatures = function (objHandle: HCkJws): Integer; stdcall;
  TCkJws_getPreferCompact = function (objHandle: HCkJws): wordbool; stdcall;
  TCkJws_putPreferCompact = procedure (objHandle: HCkJws; newPropVal: wordbool); stdcall;
  TCkJws_getPreferFlattened = function (objHandle: HCkJws): wordbool; stdcall;
  TCkJws_putPreferFlattened = procedure (objHandle: HCkJws; newPropVal: wordbool); stdcall;
  TCkJws_getUncommonOptions = procedure (objHandle: HCkJws; outPropVal: HCkString); stdcall;
  TCkJws_putUncommonOptions = procedure (objHandle: HCkJws; newPropVal: PWideChar); stdcall;
  TCkJws__uncommonOptions = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_getVerboseLogging = function (objHandle: HCkJws): wordbool; stdcall;
  TCkJws_putVerboseLogging = procedure (objHandle: HCkJws; newPropVal: wordbool); stdcall;
  TCkJws_getVersion = procedure (objHandle: HCkJws; outPropVal: HCkString); stdcall;
  TCkJws__version = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_CreateJws = function (objHandle: HCkJws; outStr: HCkString): wordbool; stdcall;
  TCkJws__createJws = function (objHandle: HCkJws): PWideChar; stdcall;
  TCkJws_CreateJwsSb = function (objHandle: HCkJws; sbJws: HCkStringBuilder): wordbool; stdcall;
  TCkJws_GetPayload = function (objHandle: HCkJws; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJws__getPayload = function (objHandle: HCkJws; charset: PWideChar): PWideChar; stdcall;
  TCkJws_GetPayloadBd = function (objHandle: HCkJws; binData: HCkBinData): wordbool; stdcall;
  TCkJws_GetPayloadSb = function (objHandle: HCkJws; charset: PWideChar; sbPayload: HCkStringBuilder): wordbool; stdcall;
  TCkJws_GetProtectedH = function (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkJws_GetProtectedHeader = function (objHandle: HCkJws; index: Integer): HCkJsonObject; stdcall;
  TCkJws_GetUnprotectedH = function (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkJws_GetUnprotectedHeader = function (objHandle: HCkJws; index: Integer): HCkJsonObject; stdcall;
  TCkJws_LoadJws = function (objHandle: HCkJws; jwsStr: PWideChar): wordbool; stdcall;
  TCkJws_LoadJwsSb = function (objHandle: HCkJws; sbJws: HCkStringBuilder): wordbool; stdcall;
  TCkJws_SetMacKey = function (objHandle: HCkJws; index: Integer; key: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkJws_SetMacKeyBd = function (objHandle: HCkJws; index: Integer; key: HCkBinData): wordbool; stdcall;
  TCkJws_SetPayload = function (objHandle: HCkJws; payload: PWideChar; charset: PWideChar; includeBom: wordbool): wordbool; stdcall;
  TCkJws_SetPayloadBd = function (objHandle: HCkJws; binData: HCkBinData): wordbool; stdcall;
  TCkJws_SetPayloadSb = function (objHandle: HCkJws; sbPayload: HCkStringBuilder; charset: PWideChar; includeBom: wordbool): wordbool; stdcall;
  TCkJws_SetPrivateKey = function (objHandle: HCkJws; index: Integer; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkJws_SetProtectedHeader = function (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkJws_SetPublicKey = function (objHandle: HCkJws; index: Integer; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkJws_SetUnprotectedHeader = function (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkJws_Validate = function (objHandle: HCkJws; index: Integer): Integer; stdcall;

var
  _fkt_ptr_arr:   array [0..47] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkJws_Create : HCkJws;
begin
  result := TCkJws_Create(_map(0, 'CkJws_Create'));
end;

procedure CkJws_Dispose (handle: HCkJws);
begin
  TCkJws_Dispose(_map(1, 'CkJws_Dispose'))
    (handle);
end;


procedure CkJws_getDebugLogFilePath (objHandle: HCkJws; outPropVal: HCkString);
begin
  TCkJws_getDebugLogFilePath(_map(2, 'CkJws_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkJws_putDebugLogFilePath (objHandle: HCkJws; newPropVal: PWideChar);
begin
  TCkJws_putDebugLogFilePath(_map(3, 'CkJws_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkJws__debugLogFilePath (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__debugLogFilePath(_map(4, 'CkJws__debugLogFilePath'))
    (objHandle);
end;

procedure CkJws_getLastErrorHtml (objHandle: HCkJws; outPropVal: HCkString);
begin
  TCkJws_getLastErrorHtml(_map(5, 'CkJws_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkJws__lastErrorHtml (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__lastErrorHtml(_map(6, 'CkJws__lastErrorHtml'))
    (objHandle);
end;

procedure CkJws_getLastErrorText (objHandle: HCkJws; outPropVal: HCkString);
begin
  TCkJws_getLastErrorText(_map(7, 'CkJws_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkJws__lastErrorText (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__lastErrorText(_map(8, 'CkJws__lastErrorText'))
    (objHandle);
end;

procedure CkJws_getLastErrorXml (objHandle: HCkJws; outPropVal: HCkString);
begin
  TCkJws_getLastErrorXml(_map(9, 'CkJws_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkJws__lastErrorXml (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__lastErrorXml(_map(10, 'CkJws__lastErrorXml'))
    (objHandle);
end;

function CkJws_getLastMethodSuccess (objHandle: HCkJws): wordbool;
begin
    result := TCkJws_getLastMethodSuccess(_map(11, 'CkJws_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkJws_putLastMethodSuccess (objHandle: HCkJws; newPropVal: wordbool);
begin
  TCkJws_putLastMethodSuccess(_map(12, 'CkJws_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkJws_getNumSignatures (objHandle: HCkJws): Integer;
begin
    result := TCkJws_getNumSignatures(_map(13, 'CkJws_getNumSignatures'))
    (objHandle);
end;

function CkJws_getPreferCompact (objHandle: HCkJws): wordbool;
begin
    result := TCkJws_getPreferCompact(_map(14, 'CkJws_getPreferCompact'))
    (objHandle);
end;

procedure CkJws_putPreferCompact (objHandle: HCkJws; newPropVal: wordbool);
begin
  TCkJws_putPreferCompact(_map(15, 'CkJws_putPreferCompact'))
    (objHandle, newPropVal);
end;

function CkJws_getPreferFlattened (objHandle: HCkJws): wordbool;
begin
    result := TCkJws_getPreferFlattened(_map(16, 'CkJws_getPreferFlattened'))
    (objHandle);
end;

procedure CkJws_putPreferFlattened (objHandle: HCkJws; newPropVal: wordbool);
begin
  TCkJws_putPreferFlattened(_map(17, 'CkJws_putPreferFlattened'))
    (objHandle, newPropVal);
end;

procedure CkJws_getUncommonOptions (objHandle: HCkJws; outPropVal: HCkString);
begin
  TCkJws_getUncommonOptions(_map(18, 'CkJws_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkJws_putUncommonOptions (objHandle: HCkJws; newPropVal: PWideChar);
begin
  TCkJws_putUncommonOptions(_map(19, 'CkJws_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkJws__uncommonOptions (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__uncommonOptions(_map(20, 'CkJws__uncommonOptions'))
    (objHandle);
end;

function CkJws_getVerboseLogging (objHandle: HCkJws): wordbool;
begin
    result := TCkJws_getVerboseLogging(_map(21, 'CkJws_getVerboseLogging'))
    (objHandle);
end;

procedure CkJws_putVerboseLogging (objHandle: HCkJws; newPropVal: wordbool);
begin
  TCkJws_putVerboseLogging(_map(22, 'CkJws_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkJws_getVersion (objHandle: HCkJws; outPropVal: HCkString);
begin
  TCkJws_getVersion(_map(23, 'CkJws_getVersion'))
    (objHandle, outPropVal);
end;

function CkJws__version (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__version(_map(24, 'CkJws__version'))
    (objHandle);
end;

function CkJws_CreateJws (objHandle: HCkJws; outStr: HCkString): wordbool;
begin
  result := TCkJws_CreateJws(_map(25, 'CkJws_CreateJws'))
    (objHandle, outStr);
end;

function CkJws__createJws (objHandle: HCkJws): PWideChar;
begin
  result := TCkJws__createJws(_map(26, 'CkJws__createJws'))
    (objHandle);
end;

function CkJws_CreateJwsSb (objHandle: HCkJws; sbJws: HCkStringBuilder): wordbool;
begin
  result := TCkJws_CreateJwsSb(_map(27, 'CkJws_CreateJwsSb'))
    (objHandle, sbJws);
end;

function CkJws_GetPayload (objHandle: HCkJws; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJws_GetPayload(_map(28, 'CkJws_GetPayload'))
    (objHandle, charset, outStr);
end;

function CkJws__getPayload (objHandle: HCkJws; charset: PWideChar): PWideChar;
begin
  result := TCkJws__getPayload(_map(29, 'CkJws__getPayload'))
    (objHandle, charset);
end;

function CkJws_GetPayloadBd (objHandle: HCkJws; binData: HCkBinData): wordbool;
begin
  result := TCkJws_GetPayloadBd(_map(30, 'CkJws_GetPayloadBd'))
    (objHandle, binData);
end;

function CkJws_GetPayloadSb (objHandle: HCkJws; charset: PWideChar; sbPayload: HCkStringBuilder): wordbool;
begin
  result := TCkJws_GetPayloadSb(_map(31, 'CkJws_GetPayloadSb'))
    (objHandle, charset, sbPayload);
end;

function CkJws_GetProtectedH (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkJws_GetProtectedH(_map(32, 'CkJws_GetProtectedH'))
    (objHandle, index, json);
end;

function CkJws_GetProtectedHeader (objHandle: HCkJws; index: Integer): HCkJsonObject;
begin
  result := TCkJws_GetProtectedHeader(_map(33, 'CkJws_GetProtectedHeader'))
    (objHandle, index);
end;

function CkJws_GetUnprotectedH (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkJws_GetUnprotectedH(_map(34, 'CkJws_GetUnprotectedH'))
    (objHandle, index, json);
end;

function CkJws_GetUnprotectedHeader (objHandle: HCkJws; index: Integer): HCkJsonObject;
begin
  result := TCkJws_GetUnprotectedHeader(_map(35, 'CkJws_GetUnprotectedHeader'))
    (objHandle, index);
end;

function CkJws_LoadJws (objHandle: HCkJws; jwsStr: PWideChar): wordbool;
begin
  result := TCkJws_LoadJws(_map(36, 'CkJws_LoadJws'))
    (objHandle, jwsStr);
end;

function CkJws_LoadJwsSb (objHandle: HCkJws; sbJws: HCkStringBuilder): wordbool;
begin
  result := TCkJws_LoadJwsSb(_map(37, 'CkJws_LoadJwsSb'))
    (objHandle, sbJws);
end;

function CkJws_SetMacKey (objHandle: HCkJws; index: Integer; key: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkJws_SetMacKey(_map(38, 'CkJws_SetMacKey'))
    (objHandle, index, key, encoding);
end;

function CkJws_SetMacKeyBd (objHandle: HCkJws; index: Integer; key: HCkBinData): wordbool;
begin
  result := TCkJws_SetMacKeyBd(_map(39, 'CkJws_SetMacKeyBd'))
    (objHandle, index, key);
end;

function CkJws_SetPayload (objHandle: HCkJws; payload: PWideChar; charset: PWideChar; includeBom: wordbool): wordbool;
begin
  result := TCkJws_SetPayload(_map(40, 'CkJws_SetPayload'))
    (objHandle, payload, charset, includeBom);
end;

function CkJws_SetPayloadBd (objHandle: HCkJws; binData: HCkBinData): wordbool;
begin
  result := TCkJws_SetPayloadBd(_map(41, 'CkJws_SetPayloadBd'))
    (objHandle, binData);
end;

function CkJws_SetPayloadSb (objHandle: HCkJws; sbPayload: HCkStringBuilder; charset: PWideChar; includeBom: wordbool): wordbool;
begin
  result := TCkJws_SetPayloadSb(_map(42, 'CkJws_SetPayloadSb'))
    (objHandle, sbPayload, charset, includeBom);
end;

function CkJws_SetPrivateKey (objHandle: HCkJws; index: Integer; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkJws_SetPrivateKey(_map(43, 'CkJws_SetPrivateKey'))
    (objHandle, index, privKey);
end;

function CkJws_SetProtectedHeader (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkJws_SetProtectedHeader(_map(44, 'CkJws_SetProtectedHeader'))
    (objHandle, index, json);
end;

function CkJws_SetPublicKey (objHandle: HCkJws; index: Integer; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkJws_SetPublicKey(_map(45, 'CkJws_SetPublicKey'))
    (objHandle, index, pubKey);
end;

function CkJws_SetUnprotectedHeader (objHandle: HCkJws; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkJws_SetUnprotectedHeader(_map(46, 'CkJws_SetUnprotectedHeader'))
    (objHandle, index, json);
end;

function CkJws_Validate (objHandle: HCkJws; index: Integer): Integer;
begin
  result := TCkJws_Validate(_map(47, 'CkJws_Validate'))
    (objHandle, index);
end;

end.
