unit MailMan;

interface

type

HCkEmailBundle = Pointer;
HCkSshKey = Pointer;
HCkSecureString = Pointer;
HCkStringBuilder = Pointer;
HCkCert = Pointer;
HCkSocket = Pointer;
HCkMailMan = Pointer;
HCkBinData = Pointer;
HCkString = Pointer;
HCkStringTable = Pointer;
HCkByteData = Pointer;
HCkXmlCertVault = Pointer;
HCkPrivateKey = Pointer;
HCkSsh = Pointer;
HCkEmail = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;
HCkStringArray = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TMailManAbortCheck = function(): Integer; cdecl;
TMailManProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TMailManPercentDone = function(pctDone: Integer): Integer; cdecl;
TMailManTaskCompleted = procedure(task: HCkTask); cdecl;


function CkMailMan_Create: HCkMailMan;  stdcall;
procedure CkMailMan_Dispose(handle: HCkMailMan); stdcall;

procedure CkMailMan_SetAbortCheck(objHandle: HCkMailMan; fn: TMailManAbortCheck) stdcall;
procedure CkMailMan_SetProgressInfo(objHandle: HCkMailMan; fn: TMailManProgressInfo) stdcall;
procedure CkMailMan_SetPercentDone(objHandle: HCkMailMan; fn: TMailManPercentDone) stdcall;
procedure CkMailMan_SetTaskCompleted(objHandle: HCkMailMan; fn: TMailManTaskCompleted) stdcall;
function CkMailMan_getAbortCurrent(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putAbortCurrent(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getAllOrNone(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putAllOrNone(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getAutoFix(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putAutoFix(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getAutoGenMessageId(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putAutoGenMessageId(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getAutoSmtpRset(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putAutoSmtpRset(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getAutoUnwrapSecurity(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putAutoUnwrapSecurity(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getClientIpAddress(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putClientIpAddress(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__clientIpAddress(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getConnectFailReason(objHandle: HCkMailMan): Integer;
function CkMailMan_getConnectTimeout(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putConnectTimeout(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getDebugLogFilePath(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putDebugLogFilePath(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__debugLogFilePath(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getDsnEnvid(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putDsnEnvid(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__dsnEnvid(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getDsnNotify(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putDsnNotify(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__dsnNotify(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getDsnRet(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putDsnRet(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__dsnRet(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getEmbedCertChain(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putEmbedCertChain(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getFilter(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putFilter(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__filter(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getHeartbeatMs(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putHeartbeatMs(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getHeloHostname(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putHeloHostname(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__heloHostname(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getHttpProxyAuthMethod(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putHttpProxyAuthMethod(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__httpProxyAuthMethod(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getHttpProxyDomain(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putHttpProxyDomain(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__httpProxyDomain(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getHttpProxyHostname(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putHttpProxyHostname(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__httpProxyHostname(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getHttpProxyPassword(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putHttpProxyPassword(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__httpProxyPassword(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getHttpProxyPort(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putHttpProxyPort(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getHttpProxyUsername(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putHttpProxyUsername(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__httpProxyUsername(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getImmediateDelete(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putImmediateDelete(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getIncludeRootCert(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putIncludeRootCert(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getIsPop3Connected(objHandle: HCkMailMan): wordbool;
function CkMailMan_getIsSmtpConnected(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_getLastErrorHtml(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__lastErrorHtml(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getLastErrorText(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__lastErrorText(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getLastErrorXml(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__lastErrorXml(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getLastMethodSuccess(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putLastMethodSuccess(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getLastSmtpStatus(objHandle: HCkMailMan): Integer;
procedure CkMailMan_getLastSmtpStatusMsg(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__lastSmtpStatusMsg(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getLogMailReceivedFilename(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putLogMailReceivedFilename(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__logMailReceivedFilename(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getLogMailSentFilename(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putLogMailSentFilename(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__logMailSentFilename(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getMailHost(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putMailHost(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__mailHost(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getMailPort(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putMailPort(objHandle: HCkMailMan; newPropVal: Integer);
function CkMailMan_getMaxCount(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putMaxCount(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getOAuth2AccessToken(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putOAuth2AccessToken(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__oAuth2AccessToken(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getOpaqueSigning(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putOpaqueSigning(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getP7mEncryptAttachFilename(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putP7mEncryptAttachFilename(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__p7mEncryptAttachFilename(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getP7mSigAttachFilename(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putP7mSigAttachFilename(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__p7mSigAttachFilename(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getP7sSigAttachFilename(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putP7sSigAttachFilename(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__p7sSigAttachFilename(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getPercentDoneScale(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putPercentDoneScale(objHandle: HCkMailMan; newPropVal: Integer);
function CkMailMan_getPop3SessionId(objHandle: HCkMailMan): Integer;
procedure CkMailMan_getPop3SessionLog(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__pop3SessionLog(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getPop3SPA(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putPop3SPA(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getPop3SslServerCertVerified(objHandle: HCkMailMan): wordbool;
function CkMailMan_getPop3Stls(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putPop3Stls(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getPop3StlsIfPossible(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putPop3StlsIfPossible(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getPopPassword(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putPopPassword(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__popPassword(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getPopPasswordBase64(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putPopPasswordBase64(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__popPasswordBase64(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getPopSsl(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putPopSsl(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getPopUsername(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putPopUsername(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__popUsername(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getPreferIpv6(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putPreferIpv6(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getReadTimeout(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putReadTimeout(objHandle: HCkMailMan; newPropVal: Integer);
function CkMailMan_getRequireSslCertVerify(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putRequireSslCertVerify(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getResetDateOnLoad(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putResetDateOnLoad(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getSendBufferSize(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSendBufferSize(objHandle: HCkMailMan; newPropVal: Integer);
function CkMailMan_getSendIndividual(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putSendIndividual(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getSizeLimit(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSizeLimit(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getSmtpAuthMethod(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSmtpAuthMethod(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__smtpAuthMethod(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSmtpFailReason(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__smtpFailReason(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSmtpHost(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSmtpHost(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__smtpHost(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSmtpLoginDomain(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSmtpLoginDomain(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__smtpLoginDomain(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSmtpMailFrom(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSmtpMailFrom(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__smtpMailFrom(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSmtpPassword(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSmtpPassword(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__smtpPassword(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getSmtpPipelining(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putSmtpPipelining(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getSmtpPort(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSmtpPort(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getSmtpSessionLog(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__smtpSessionLog(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getSmtpSsl(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putSmtpSsl(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getSmtpSslServerCertVerified(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_getSmtpUsername(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSmtpUsername(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__smtpUsername(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSocksHostname(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSocksHostname(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__socksHostname(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSocksPassword(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSocksPassword(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__socksPassword(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getSocksPort(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSocksPort(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getSocksUsername(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSocksUsername(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__socksUsername(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getSocksVersion(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSocksVersion(objHandle: HCkMailMan; newPropVal: Integer);
function CkMailMan_getSoRcvBuf(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSoRcvBuf(objHandle: HCkMailMan; newPropVal: Integer);
function CkMailMan_getSoSndBuf(objHandle: HCkMailMan): Integer;
procedure CkMailMan_putSoSndBuf(objHandle: HCkMailMan; newPropVal: Integer);
procedure CkMailMan_getSslAllowedCiphers(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSslAllowedCiphers(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__sslAllowedCiphers(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getSslProtocol(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putSslProtocol(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__sslProtocol(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getStartTLS(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putStartTLS(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getStartTLSifPossible(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putStartTLSifPossible(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getTlsCipherSuite(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__tlsCipherSuite(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getTlsPinSet(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putTlsPinSet(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__tlsPinSet(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getTlsVersion(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__tlsVersion(objHandle: HCkMailMan): PWideChar;
procedure CkMailMan_getUncommonOptions(objHandle: HCkMailMan; outPropVal: HCkString);
procedure CkMailMan_putUncommonOptions(objHandle: HCkMailMan; newPropVal: PWideChar);
function CkMailMan__uncommonOptions(objHandle: HCkMailMan): PWideChar;
function CkMailMan_getUseApop(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putUseApop(objHandle: HCkMailMan; newPropVal: wordbool);
function CkMailMan_getVerboseLogging(objHandle: HCkMailMan): wordbool;
procedure CkMailMan_putVerboseLogging(objHandle: HCkMailMan; newPropVal: wordbool);
procedure CkMailMan_getVersion(objHandle: HCkMailMan; outPropVal: HCkString);
function CkMailMan__version(objHandle: HCkMailMan): PWideChar;
function CkMailMan_AddPfxSourceBd(objHandle: HCkMailMan; bd: HCkBinData; password: PWideChar): wordbool;
function CkMailMan_AddPfxSourceData(objHandle: HCkMailMan; pfxData: HCkByteData; password: PWideChar): wordbool;
function CkMailMan_AddPfxSourceFile(objHandle: HCkMailMan; pfxFilePath: PWideChar; password: PWideChar): wordbool;
function CkMailMan_CheckMail(objHandle: HCkMailMan): Integer;
function CkMailMan_CheckMailAsync(objHandle: HCkMailMan): HCkTask;
procedure CkMailMan_ClearBadEmailAddresses(objHandle: HCkMailMan);
procedure CkMailMan_ClearPop3SessionLog(objHandle: HCkMailMan);
procedure CkMailMan_ClearSmtpSessionLog(objHandle: HCkMailMan);
function CkMailMan_CloseSmtpConnection(objHandle: HCkMailMan): wordbool;
function CkMailMan_CloseSmtpConnectionAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_CopyMail(objHandle: HCkMailMan): HCkEmailBundle;
function CkMailMan_CopyMailAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_DeleteBundle(objHandle: HCkMailMan; emailBundle: HCkEmailBundle): wordbool;
function CkMailMan_DeleteBundleAsync(objHandle: HCkMailMan; emailBundle: HCkEmailBundle): HCkTask;
function CkMailMan_DeleteByMsgnum(objHandle: HCkMailMan; msgnum: Integer): wordbool;
function CkMailMan_DeleteByMsgnumAsync(objHandle: HCkMailMan; msgnum: Integer): HCkTask;
function CkMailMan_DeleteByUidl(objHandle: HCkMailMan; uidl: PWideChar): wordbool;
function CkMailMan_DeleteByUidlAsync(objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
function CkMailMan_DeleteEmail(objHandle: HCkMailMan; email: HCkEmail): wordbool;
function CkMailMan_DeleteEmailAsync(objHandle: HCkMailMan; email: HCkEmail): HCkTask;
function CkMailMan_DeleteMultiple(objHandle: HCkMailMan; uidlArray: HCkStringArray): wordbool;
function CkMailMan_DeleteMultipleAsync(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
function CkMailMan_DeleteUidlSet(objHandle: HCkMailMan; stUidls: HCkStringTable): wordbool;
function CkMailMan_DeleteUidlSetAsync(objHandle: HCkMailMan; stUidls: HCkStringTable): HCkTask;
function CkMailMan_FetchAll(objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): wordbool;
function CkMailMan_FetchAllAsync(objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): HCkTask;
function CkMailMan_FetchByMsgnum(objHandle: HCkMailMan; msgnum: Integer): HCkEmail;
function CkMailMan_FetchByMsgnumAsync(objHandle: HCkMailMan; msgnum: Integer): HCkTask;
function CkMailMan_FetchByUidl(objHandle: HCkMailMan; uidl: PWideChar; headerOnly: wordbool; numBodyLines: Integer; email: HCkEmail): wordbool;
function CkMailMan_FetchByUidlAsync(objHandle: HCkMailMan; uidl: PWideChar; headerOnly: wordbool; numBodyLines: Integer; email: HCkEmail): HCkTask;
function CkMailMan_FetchEmail(objHandle: HCkMailMan; uidl: PWideChar): HCkEmail;
function CkMailMan_FetchEmailAsync(objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
function CkMailMan_FetchFull(objHandle: HCkMailMan; partialEmail: HCkEmail; fullEmail: HCkEmail): wordbool;
function CkMailMan_FetchFullAsync(objHandle: HCkMailMan; partialEmail: HCkEmail; fullEmail: HCkEmail): HCkTask;
function CkMailMan_FetchMime(objHandle: HCkMailMan; uidl: PWideChar; outData: HCkByteData): wordbool;
function CkMailMan_FetchMimeAsync(objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
function CkMailMan_FetchMimeBd(objHandle: HCkMailMan; uidl: PWideChar; mimeData: HCkBinData): wordbool;
function CkMailMan_FetchMimeBdAsync(objHandle: HCkMailMan; uidl: PWideChar; mimeData: HCkBinData): HCkTask;
function CkMailMan_FetchMimeByMsgnum(objHandle: HCkMailMan; msgnum: Integer; outData: HCkByteData): wordbool;
function CkMailMan_FetchMimeByMsgnumAsync(objHandle: HCkMailMan; msgnum: Integer): HCkTask;
function CkMailMan_FetchMimeByMsgnumBd(objHandle: HCkMailMan; msgnum: Integer; bd: HCkBinData): wordbool;
function CkMailMan_FetchMimeByMsgnumBdAsync(objHandle: HCkMailMan; msgnum: Integer; bd: HCkBinData): HCkTask;
function CkMailMan_FetchMultiple(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkEmailBundle;
function CkMailMan_FetchMultipleAsync(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
function CkMailMan_FetchMultipleHeaders(objHandle: HCkMailMan; uidlArray: HCkStringArray; numBodyLines: Integer): HCkEmailBundle;
function CkMailMan_FetchMultipleHeadersAsync(objHandle: HCkMailMan; uidlArray: HCkStringArray; numBodyLines: Integer): HCkTask;
function CkMailMan_FetchMultipleMime(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkStringArray;
function CkMailMan_FetchMultipleMimeAsync(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
function CkMailMan_FetchOne(objHandle: HCkMailMan; headerOnly: wordbool; numBodyLines: Integer; msgNum: Integer; email: HCkEmail): wordbool;
function CkMailMan_FetchOneAsync(objHandle: HCkMailMan; headerOnly: wordbool; numBodyLines: Integer; msgNum: Integer; email: HCkEmail): HCkTask;
function CkMailMan_FetchRange(objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; startIndex: Integer; endIndex: Integer; bundle: HCkEmailBundle): wordbool;
function CkMailMan_FetchRangeAsync(objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; startIndex: Integer; endIndex: Integer; bundle: HCkEmailBundle): HCkTask;
function CkMailMan_FetchSingleHeader(objHandle: HCkMailMan; numBodyLines: Integer; messageNumber: Integer): HCkEmail;
function CkMailMan_FetchSingleHeaderAsync(objHandle: HCkMailMan; numBodyLines: Integer; messageNumber: Integer): HCkTask;
function CkMailMan_FetchSingleHeaderByUidl(objHandle: HCkMailMan; numBodyLines: Integer; uidl: PWideChar): HCkEmail;
function CkMailMan_FetchSingleHeaderByUidlAsync(objHandle: HCkMailMan; numBodyLines: Integer; uidl: PWideChar): HCkTask;
function CkMailMan_FetchUidls(objHandle: HCkMailMan; uidls: HCkStringTable): wordbool;
function CkMailMan_FetchUidlsAsync(objHandle: HCkMailMan; uidls: HCkStringTable): HCkTask;
function CkMailMan_FetchUidlSet(objHandle: HCkMailMan; uidls: HCkStringTable; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): wordbool;
function CkMailMan_FetchUidlSetAsync(objHandle: HCkMailMan; uidls: HCkStringTable; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): HCkTask;
function CkMailMan_GetAllHeaders(objHandle: HCkMailMan; numBodyLines: Integer): HCkEmailBundle;
function CkMailMan_GetAllHeadersAsync(objHandle: HCkMailMan; numBodyLines: Integer): HCkTask;
function CkMailMan_GetBadEmailAddrs(objHandle: HCkMailMan): HCkStringArray;
function CkMailMan_GetFullEmail(objHandle: HCkMailMan; email: HCkEmail): HCkEmail;
function CkMailMan_GetFullEmailAsync(objHandle: HCkMailMan; email: HCkEmail): HCkTask;
function CkMailMan_GetHeaders(objHandle: HCkMailMan; numBodyLines: Integer; fromIndex: Integer; toIndex: Integer): HCkEmailBundle;
function CkMailMan_GetHeadersAsync(objHandle: HCkMailMan; numBodyLines: Integer; fromIndex: Integer; toIndex: Integer): HCkTask;
procedure CkMailMan_GetLastJsonData(objHandle: HCkMailMan; json: HCkJsonObject);
function CkMailMan_GetMailboxCount(objHandle: HCkMailMan): Integer;
function CkMailMan_GetMailboxCountAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_GetMailboxInfoXml(objHandle: HCkMailMan; outStr: HCkString): wordbool;
function CkMailMan__getMailboxInfoXml(objHandle: HCkMailMan): PWideChar;
function CkMailMan_GetMailboxInfoXmlAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_GetMailboxSize(objHandle: HCkMailMan): LongWord;
function CkMailMan_GetMailboxSizeAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_GetPop3SslServerCert(objHandle: HCkMailMan): HCkCert;
function CkMailMan_GetSentToEmailAddrs(objHandle: HCkMailMan): HCkStringArray;
function CkMailMan_GetServerCert(objHandle: HCkMailMan; useSmtp: wordbool; cert: HCkCert): wordbool;
function CkMailMan_GetSizeByUidl(objHandle: HCkMailMan; uidl: PWideChar): Integer;
function CkMailMan_GetSizeByUidlAsync(objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
function CkMailMan_GetSmtpSslServerCert(objHandle: HCkMailMan): HCkCert;
function CkMailMan_GetUidls(objHandle: HCkMailMan): HCkStringArray;
function CkMailMan_GetUidlsAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_IsSmtpDsnCapable(objHandle: HCkMailMan): wordbool;
function CkMailMan_IsSmtpDsnCapableAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_LastJsonData(objHandle: HCkMailMan): HCkJsonObject;
function CkMailMan_LoadEml(objHandle: HCkMailMan; emlFilename: PWideChar): HCkEmail;
function CkMailMan_LoadMbx(objHandle: HCkMailMan; mbxFileName: PWideChar): HCkEmailBundle;
function CkMailMan_LoadMbxFile(objHandle: HCkMailMan; mbxPath: PWideChar; bundle: HCkEmailBundle): wordbool;
function CkMailMan_LoadMime(objHandle: HCkMailMan; mimeText: PWideChar): HCkEmail;
function CkMailMan_LoadTaskCaller(objHandle: HCkMailMan; task: HCkTask): wordbool;
function CkMailMan_LoadXmlEmail(objHandle: HCkMailMan; filename: PWideChar): HCkEmail;
function CkMailMan_LoadXmlEmailString(objHandle: HCkMailMan; xmlString: PWideChar): HCkEmail;
function CkMailMan_LoadXmlFile(objHandle: HCkMailMan; filename: PWideChar): HCkEmailBundle;
function CkMailMan_LoadXmlString(objHandle: HCkMailMan; xmlString: PWideChar): HCkEmailBundle;
function CkMailMan_MxLookup(objHandle: HCkMailMan; emailAddress: PWideChar; outStr: HCkString): wordbool;
function CkMailMan__mxLookup(objHandle: HCkMailMan; emailAddress: PWideChar): PWideChar;
function CkMailMan_MxLookupAll(objHandle: HCkMailMan; emailAddress: PWideChar): HCkStringArray;
function CkMailMan_OpenSmtpConnection(objHandle: HCkMailMan): wordbool;
function CkMailMan_OpenSmtpConnectionAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3Authenticate(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3AuthenticateAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3BeginSession(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3BeginSessionAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3Connect(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3ConnectAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3EndSession(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3EndSessionAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3EndSessionNoQuit(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3EndSessionNoQuitAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3Noop(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3NoopAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3Reset(objHandle: HCkMailMan): wordbool;
function CkMailMan_Pop3ResetAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_Pop3SendRawCommand(objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkMailMan__pop3SendRawCommand(objHandle: HCkMailMan; command: PWideChar; charset: PWideChar): PWideChar;
function CkMailMan_Pop3SendRawCommandAsync(objHandle: HCkMailMan; command: PWideChar; charset: PWideChar): HCkTask;
function CkMailMan_QuickSend(objHandle: HCkMailMan; fromAddr: PWideChar; toAddr: PWideChar; subject: PWideChar; body: PWideChar; smtpServer: PWideChar): wordbool;
function CkMailMan_QuickSendAsync(objHandle: HCkMailMan; fromAddr: PWideChar; toAddr: PWideChar; subject: PWideChar; body: PWideChar; smtpServer: PWideChar): HCkTask;
function CkMailMan_RenderToMime(objHandle: HCkMailMan; email: HCkEmail; outStr: HCkString): wordbool;
function CkMailMan__renderToMime(objHandle: HCkMailMan; email: HCkEmail): PWideChar;
function CkMailMan_RenderToMimeBd(objHandle: HCkMailMan; email: HCkEmail; renderedMime: HCkBinData): wordbool;
function CkMailMan_RenderToMimeBytes(objHandle: HCkMailMan; email: HCkEmail; outData: HCkByteData): wordbool;
function CkMailMan_RenderToMimeSb(objHandle: HCkMailMan; email: HCkEmail; renderedMime: HCkStringBuilder): wordbool;
function CkMailMan_SendBundle(objHandle: HCkMailMan; bundle: HCkEmailBundle): wordbool;
function CkMailMan_SendBundleAsync(objHandle: HCkMailMan; bundle: HCkEmailBundle): HCkTask;
function CkMailMan_SendEmail(objHandle: HCkMailMan; email: HCkEmail): wordbool;
function CkMailMan_SendEmailAsync(objHandle: HCkMailMan; email: HCkEmail): HCkTask;
function CkMailMan_SendMime(objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: PWideChar): wordbool;
function CkMailMan_SendMimeAsync(objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: PWideChar): HCkTask;
function CkMailMan_SendMimeBd(objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeData: HCkBinData): wordbool;
function CkMailMan_SendMimeBdAsync(objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeData: HCkBinData): HCkTask;
function CkMailMan_SendMimeBytes(objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: HCkByteData): wordbool;
function CkMailMan_SendMimeBytesAsync(objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: HCkByteData): HCkTask;
function CkMailMan_SendMimeToList(objHandle: HCkMailMan; fromAddr: PWideChar; distListFilename: PWideChar; mimeSource: PWideChar): wordbool;
function CkMailMan_SendMimeToListAsync(objHandle: HCkMailMan; fromAddr: PWideChar; distListFilename: PWideChar; mimeSource: PWideChar): HCkTask;
function CkMailMan_SetDecryptCert(objHandle: HCkMailMan; cert: HCkCert): wordbool;
function CkMailMan_SetDecryptCert2(objHandle: HCkMailMan; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
function CkMailMan_SetPassword(objHandle: HCkMailMan; protocol: PWideChar; password: HCkSecureString): wordbool;
function CkMailMan_SetSslClientCert(objHandle: HCkMailMan; cert: HCkCert): wordbool;
function CkMailMan_SetSslClientCertPem(objHandle: HCkMailMan; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
function CkMailMan_SetSslClientCertPfx(objHandle: HCkMailMan; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
function CkMailMan_SmtpAuthenticate(objHandle: HCkMailMan): wordbool;
function CkMailMan_SmtpAuthenticateAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_SmtpConnect(objHandle: HCkMailMan): wordbool;
function CkMailMan_SmtpConnectAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_SmtpNoop(objHandle: HCkMailMan): wordbool;
function CkMailMan_SmtpNoopAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_SmtpReset(objHandle: HCkMailMan): wordbool;
function CkMailMan_SmtpResetAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_SmtpSendRawCommand(objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool; outStr: HCkString): wordbool;
function CkMailMan__smtpSendRawCommand(objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool): PWideChar;
function CkMailMan_SmtpSendRawCommandAsync(objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool): HCkTask;
function CkMailMan_SshAuthenticatePk(objHandle: HCkMailMan; sshLogin: PWideChar; sshUsername: HCkSshKey): wordbool;
function CkMailMan_SshAuthenticatePkAsync(objHandle: HCkMailMan; sshLogin: PWideChar; sshUsername: HCkSshKey): HCkTask;
function CkMailMan_SshAuthenticatePw(objHandle: HCkMailMan; sshLogin: PWideChar; sshPassword: PWideChar): wordbool;
function CkMailMan_SshAuthenticatePwAsync(objHandle: HCkMailMan; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask;
function CkMailMan_SshCloseTunnel(objHandle: HCkMailMan): wordbool;
function CkMailMan_SshCloseTunnelAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_SshOpenTunnel(objHandle: HCkMailMan; sshHostname: PWideChar; sshPort: Integer): wordbool;
function CkMailMan_SshOpenTunnelAsync(objHandle: HCkMailMan; sshHostname: PWideChar; sshPort: Integer): HCkTask;
function CkMailMan_TransferMail(objHandle: HCkMailMan): HCkEmailBundle;
function CkMailMan_TransferMailAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_TransferMultipleMime(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkStringArray;
function CkMailMan_TransferMultipleMimeAsync(objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
function CkMailMan_UseCertVault(objHandle: HCkMailMan; vault: HCkXmlCertVault): wordbool;
function CkMailMan_UseSsh(objHandle: HCkMailMan; ssh: HCkSsh): wordbool;
function CkMailMan_UseSshTunnel(objHandle: HCkMailMan; tunnel: HCkSocket): wordbool;
function CkMailMan_VerifyPopConnection(objHandle: HCkMailMan): wordbool;
function CkMailMan_VerifyPopConnectionAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_VerifyPopLogin(objHandle: HCkMailMan): wordbool;
function CkMailMan_VerifyPopLoginAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_VerifyRecips(objHandle: HCkMailMan; email: HCkEmail; badAddrs: HCkStringArray): wordbool;
function CkMailMan_VerifyRecipsAsync(objHandle: HCkMailMan; email: HCkEmail; badAddrs: HCkStringArray): HCkTask;
function CkMailMan_VerifySmtpConnection(objHandle: HCkMailMan): wordbool;
function CkMailMan_VerifySmtpConnectionAsync(objHandle: HCkMailMan): HCkTask;
function CkMailMan_VerifySmtpLogin(objHandle: HCkMailMan): wordbool;
function CkMailMan_VerifySmtpLoginAsync(objHandle: HCkMailMan): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkMailMan_Create = function : HCkMailMan; stdcall;
  TCkMailMan_Dispose = procedure (handle: HCkMailMan); stdcall;
  TCkMailMan_SetAbortCheck = procedure (objHandle: HCkMailMan; fn: TMailManAbortCheck); stdcall;
  TCkMailMan_SetProgressInfo = procedure (objHandle: HCkMailMan; fn: TMailManProgressInfo); stdcall;
  TCkMailMan_SetPercentDone = procedure (objHandle: HCkMailMan; fn: TMailManPercentDone); stdcall;
  TCkMailMan_SetTaskCompleted = procedure (objHandle: HCkMailMan; fn: TMailManTaskCompleted); stdcall;
  TCkMailMan_getAbortCurrent = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putAbortCurrent = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getAllOrNone = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putAllOrNone = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getAutoFix = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putAutoFix = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getAutoGenMessageId = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putAutoGenMessageId = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getAutoSmtpRset = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putAutoSmtpRset = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getAutoUnwrapSecurity = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putAutoUnwrapSecurity = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getClientIpAddress = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putClientIpAddress = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__clientIpAddress = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getConnectFailReason = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_getConnectTimeout = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putConnectTimeout = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getDebugLogFilePath = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putDebugLogFilePath = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__debugLogFilePath = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getDsnEnvid = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putDsnEnvid = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__dsnEnvid = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getDsnNotify = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putDsnNotify = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__dsnNotify = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getDsnRet = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putDsnRet = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__dsnRet = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getEmbedCertChain = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putEmbedCertChain = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getFilter = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putFilter = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__filter = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getHeartbeatMs = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putHeartbeatMs = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getHeloHostname = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putHeloHostname = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__heloHostname = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getHttpProxyAuthMethod = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putHttpProxyAuthMethod = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__httpProxyAuthMethod = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getHttpProxyDomain = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putHttpProxyDomain = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__httpProxyDomain = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getHttpProxyHostname = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putHttpProxyHostname = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__httpProxyHostname = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getHttpProxyPassword = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putHttpProxyPassword = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__httpProxyPassword = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getHttpProxyPort = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putHttpProxyPort = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getHttpProxyUsername = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putHttpProxyUsername = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__httpProxyUsername = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getImmediateDelete = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putImmediateDelete = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getIncludeRootCert = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putIncludeRootCert = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getIsPop3Connected = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_getIsSmtpConnected = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_getLastErrorHtml = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__lastErrorHtml = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getLastErrorText = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__lastErrorText = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getLastErrorXml = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__lastErrorXml = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getLastMethodSuccess = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putLastMethodSuccess = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getLastSmtpStatus = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_getLastSmtpStatusMsg = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__lastSmtpStatusMsg = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getLogMailReceivedFilename = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putLogMailReceivedFilename = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__logMailReceivedFilename = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getLogMailSentFilename = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putLogMailSentFilename = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__logMailSentFilename = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getMailHost = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putMailHost = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__mailHost = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getMailPort = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putMailPort = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getMaxCount = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putMaxCount = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getOAuth2AccessToken = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putOAuth2AccessToken = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__oAuth2AccessToken = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getOpaqueSigning = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putOpaqueSigning = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getP7mEncryptAttachFilename = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putP7mEncryptAttachFilename = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__p7mEncryptAttachFilename = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getP7mSigAttachFilename = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putP7mSigAttachFilename = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__p7mSigAttachFilename = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getP7sSigAttachFilename = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putP7sSigAttachFilename = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__p7sSigAttachFilename = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getPercentDoneScale = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putPercentDoneScale = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getPop3SessionId = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_getPop3SessionLog = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__pop3SessionLog = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getPop3SPA = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putPop3SPA = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getPop3SslServerCertVerified = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_getPop3Stls = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putPop3Stls = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getPop3StlsIfPossible = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putPop3StlsIfPossible = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getPopPassword = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putPopPassword = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__popPassword = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getPopPasswordBase64 = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putPopPasswordBase64 = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__popPasswordBase64 = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getPopSsl = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putPopSsl = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getPopUsername = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putPopUsername = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__popUsername = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getPreferIpv6 = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putPreferIpv6 = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getReadTimeout = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putReadTimeout = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getRequireSslCertVerify = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putRequireSslCertVerify = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getResetDateOnLoad = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putResetDateOnLoad = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getSendBufferSize = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSendBufferSize = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSendIndividual = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putSendIndividual = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getSizeLimit = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSizeLimit = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSmtpAuthMethod = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSmtpAuthMethod = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__smtpAuthMethod = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpFailReason = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__smtpFailReason = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpHost = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSmtpHost = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__smtpHost = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpLoginDomain = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSmtpLoginDomain = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__smtpLoginDomain = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpMailFrom = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSmtpMailFrom = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__smtpMailFrom = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpPassword = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSmtpPassword = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__smtpPassword = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpPipelining = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putSmtpPipelining = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getSmtpPort = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSmtpPort = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSmtpSessionLog = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__smtpSessionLog = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSmtpSsl = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putSmtpSsl = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getSmtpSslServerCertVerified = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_getSmtpUsername = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSmtpUsername = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__smtpUsername = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSocksHostname = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSocksHostname = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__socksHostname = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSocksPassword = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSocksPassword = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__socksPassword = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSocksPort = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSocksPort = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSocksUsername = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSocksUsername = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__socksUsername = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSocksVersion = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSocksVersion = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSoRcvBuf = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSoRcvBuf = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSoSndBuf = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_putSoSndBuf = procedure (objHandle: HCkMailMan; newPropVal: Integer); stdcall;
  TCkMailMan_getSslAllowedCiphers = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSslAllowedCiphers = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__sslAllowedCiphers = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getSslProtocol = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putSslProtocol = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__sslProtocol = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getStartTLS = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putStartTLS = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getStartTLSifPossible = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putStartTLSifPossible = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getTlsCipherSuite = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__tlsCipherSuite = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getTlsPinSet = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putTlsPinSet = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__tlsPinSet = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getTlsVersion = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__tlsVersion = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getUncommonOptions = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan_putUncommonOptions = procedure (objHandle: HCkMailMan; newPropVal: PWideChar); stdcall;
  TCkMailMan__uncommonOptions = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_getUseApop = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putUseApop = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getVerboseLogging = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_putVerboseLogging = procedure (objHandle: HCkMailMan; newPropVal: wordbool); stdcall;
  TCkMailMan_getVersion = procedure (objHandle: HCkMailMan; outPropVal: HCkString); stdcall;
  TCkMailMan__version = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_AddPfxSourceBd = function (objHandle: HCkMailMan; bd: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkMailMan_AddPfxSourceData = function (objHandle: HCkMailMan; pfxData: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkMailMan_AddPfxSourceFile = function (objHandle: HCkMailMan; pfxFilePath: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkMailMan_CheckMail = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_CheckMailAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_ClearBadEmailAddresses = procedure (objHandle: HCkMailMan); stdcall;
  TCkMailMan_ClearPop3SessionLog = procedure (objHandle: HCkMailMan); stdcall;
  TCkMailMan_ClearSmtpSessionLog = procedure (objHandle: HCkMailMan); stdcall;
  TCkMailMan_CloseSmtpConnection = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_CloseSmtpConnectionAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_CopyMail = function (objHandle: HCkMailMan): HCkEmailBundle; stdcall;
  TCkMailMan_CopyMailAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_DeleteBundle = function (objHandle: HCkMailMan; emailBundle: HCkEmailBundle): wordbool; stdcall;
  TCkMailMan_DeleteBundleAsync = function (objHandle: HCkMailMan; emailBundle: HCkEmailBundle): HCkTask; stdcall;
  TCkMailMan_DeleteByMsgnum = function (objHandle: HCkMailMan; msgnum: Integer): wordbool; stdcall;
  TCkMailMan_DeleteByMsgnumAsync = function (objHandle: HCkMailMan; msgnum: Integer): HCkTask; stdcall;
  TCkMailMan_DeleteByUidl = function (objHandle: HCkMailMan; uidl: PWideChar): wordbool; stdcall;
  TCkMailMan_DeleteByUidlAsync = function (objHandle: HCkMailMan; uidl: PWideChar): HCkTask; stdcall;
  TCkMailMan_DeleteEmail = function (objHandle: HCkMailMan; email: HCkEmail): wordbool; stdcall;
  TCkMailMan_DeleteEmailAsync = function (objHandle: HCkMailMan; email: HCkEmail): HCkTask; stdcall;
  TCkMailMan_DeleteMultiple = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): wordbool; stdcall;
  TCkMailMan_DeleteMultipleAsync = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask; stdcall;
  TCkMailMan_DeleteUidlSet = function (objHandle: HCkMailMan; stUidls: HCkStringTable): wordbool; stdcall;
  TCkMailMan_DeleteUidlSetAsync = function (objHandle: HCkMailMan; stUidls: HCkStringTable): HCkTask; stdcall;
  TCkMailMan_FetchAll = function (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkMailMan_FetchAllAsync = function (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkMailMan_FetchByMsgnum = function (objHandle: HCkMailMan; msgnum: Integer): HCkEmail; stdcall;
  TCkMailMan_FetchByMsgnumAsync = function (objHandle: HCkMailMan; msgnum: Integer): HCkTask; stdcall;
  TCkMailMan_FetchByUidl = function (objHandle: HCkMailMan; uidl: PWideChar; headerOnly: wordbool; numBodyLines: Integer; email: HCkEmail): wordbool; stdcall;
  TCkMailMan_FetchByUidlAsync = function (objHandle: HCkMailMan; uidl: PWideChar; headerOnly: wordbool; numBodyLines: Integer; email: HCkEmail): HCkTask; stdcall;
  TCkMailMan_FetchEmail = function (objHandle: HCkMailMan; uidl: PWideChar): HCkEmail; stdcall;
  TCkMailMan_FetchEmailAsync = function (objHandle: HCkMailMan; uidl: PWideChar): HCkTask; stdcall;
  TCkMailMan_FetchFull = function (objHandle: HCkMailMan; partialEmail: HCkEmail; fullEmail: HCkEmail): wordbool; stdcall;
  TCkMailMan_FetchFullAsync = function (objHandle: HCkMailMan; partialEmail: HCkEmail; fullEmail: HCkEmail): HCkTask; stdcall;
  TCkMailMan_FetchMime = function (objHandle: HCkMailMan; uidl: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkMailMan_FetchMimeAsync = function (objHandle: HCkMailMan; uidl: PWideChar): HCkTask; stdcall;
  TCkMailMan_FetchMimeBd = function (objHandle: HCkMailMan; uidl: PWideChar; mimeData: HCkBinData): wordbool; stdcall;
  TCkMailMan_FetchMimeBdAsync = function (objHandle: HCkMailMan; uidl: PWideChar; mimeData: HCkBinData): HCkTask; stdcall;
  TCkMailMan_FetchMimeByMsgnum = function (objHandle: HCkMailMan; msgnum: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkMailMan_FetchMimeByMsgnumAsync = function (objHandle: HCkMailMan; msgnum: Integer): HCkTask; stdcall;
  TCkMailMan_FetchMimeByMsgnumBd = function (objHandle: HCkMailMan; msgnum: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkMailMan_FetchMimeByMsgnumBdAsync = function (objHandle: HCkMailMan; msgnum: Integer; bd: HCkBinData): HCkTask; stdcall;
  TCkMailMan_FetchMultiple = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkEmailBundle; stdcall;
  TCkMailMan_FetchMultipleAsync = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask; stdcall;
  TCkMailMan_FetchMultipleHeaders = function (objHandle: HCkMailMan; uidlArray: HCkStringArray; numBodyLines: Integer): HCkEmailBundle; stdcall;
  TCkMailMan_FetchMultipleHeadersAsync = function (objHandle: HCkMailMan; uidlArray: HCkStringArray; numBodyLines: Integer): HCkTask; stdcall;
  TCkMailMan_FetchMultipleMime = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkStringArray; stdcall;
  TCkMailMan_FetchMultipleMimeAsync = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask; stdcall;
  TCkMailMan_FetchOne = function (objHandle: HCkMailMan; headerOnly: wordbool; numBodyLines: Integer; msgNum: Integer; email: HCkEmail): wordbool; stdcall;
  TCkMailMan_FetchOneAsync = function (objHandle: HCkMailMan; headerOnly: wordbool; numBodyLines: Integer; msgNum: Integer; email: HCkEmail): HCkTask; stdcall;
  TCkMailMan_FetchRange = function (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; startIndex: Integer; endIndex: Integer; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkMailMan_FetchRangeAsync = function (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; startIndex: Integer; endIndex: Integer; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkMailMan_FetchSingleHeader = function (objHandle: HCkMailMan; numBodyLines: Integer; messageNumber: Integer): HCkEmail; stdcall;
  TCkMailMan_FetchSingleHeaderAsync = function (objHandle: HCkMailMan; numBodyLines: Integer; messageNumber: Integer): HCkTask; stdcall;
  TCkMailMan_FetchSingleHeaderByUidl = function (objHandle: HCkMailMan; numBodyLines: Integer; uidl: PWideChar): HCkEmail; stdcall;
  TCkMailMan_FetchSingleHeaderByUidlAsync = function (objHandle: HCkMailMan; numBodyLines: Integer; uidl: PWideChar): HCkTask; stdcall;
  TCkMailMan_FetchUidls = function (objHandle: HCkMailMan; uidls: HCkStringTable): wordbool; stdcall;
  TCkMailMan_FetchUidlsAsync = function (objHandle: HCkMailMan; uidls: HCkStringTable): HCkTask; stdcall;
  TCkMailMan_FetchUidlSet = function (objHandle: HCkMailMan; uidls: HCkStringTable; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkMailMan_FetchUidlSetAsync = function (objHandle: HCkMailMan; uidls: HCkStringTable; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkMailMan_GetAllHeaders = function (objHandle: HCkMailMan; numBodyLines: Integer): HCkEmailBundle; stdcall;
  TCkMailMan_GetAllHeadersAsync = function (objHandle: HCkMailMan; numBodyLines: Integer): HCkTask; stdcall;
  TCkMailMan_GetBadEmailAddrs = function (objHandle: HCkMailMan): HCkStringArray; stdcall;
  TCkMailMan_GetFullEmail = function (objHandle: HCkMailMan; email: HCkEmail): HCkEmail; stdcall;
  TCkMailMan_GetFullEmailAsync = function (objHandle: HCkMailMan; email: HCkEmail): HCkTask; stdcall;
  TCkMailMan_GetHeaders = function (objHandle: HCkMailMan; numBodyLines: Integer; fromIndex: Integer; toIndex: Integer): HCkEmailBundle; stdcall;
  TCkMailMan_GetHeadersAsync = function (objHandle: HCkMailMan; numBodyLines: Integer; fromIndex: Integer; toIndex: Integer): HCkTask; stdcall;
  TCkMailMan_GetLastJsonData = procedure (objHandle: HCkMailMan; json: HCkJsonObject); stdcall;
  TCkMailMan_GetMailboxCount = function (objHandle: HCkMailMan): Integer; stdcall;
  TCkMailMan_GetMailboxCountAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_GetMailboxInfoXml = function (objHandle: HCkMailMan; outStr: HCkString): wordbool; stdcall;
  TCkMailMan__getMailboxInfoXml = function (objHandle: HCkMailMan): PWideChar; stdcall;
  TCkMailMan_GetMailboxInfoXmlAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_GetMailboxSize = function (objHandle: HCkMailMan): LongWord; stdcall;
  TCkMailMan_GetMailboxSizeAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_GetPop3SslServerCert = function (objHandle: HCkMailMan): HCkCert; stdcall;
  TCkMailMan_GetSentToEmailAddrs = function (objHandle: HCkMailMan): HCkStringArray; stdcall;
  TCkMailMan_GetServerCert = function (objHandle: HCkMailMan; useSmtp: wordbool; cert: HCkCert): wordbool; stdcall;
  TCkMailMan_GetSizeByUidl = function (objHandle: HCkMailMan; uidl: PWideChar): Integer; stdcall;
  TCkMailMan_GetSizeByUidlAsync = function (objHandle: HCkMailMan; uidl: PWideChar): HCkTask; stdcall;
  TCkMailMan_GetSmtpSslServerCert = function (objHandle: HCkMailMan): HCkCert; stdcall;
  TCkMailMan_GetUidls = function (objHandle: HCkMailMan): HCkStringArray; stdcall;
  TCkMailMan_GetUidlsAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_IsSmtpDsnCapable = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_IsSmtpDsnCapableAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_LastJsonData = function (objHandle: HCkMailMan): HCkJsonObject; stdcall;
  TCkMailMan_LoadEml = function (objHandle: HCkMailMan; emlFilename: PWideChar): HCkEmail; stdcall;
  TCkMailMan_LoadMbx = function (objHandle: HCkMailMan; mbxFileName: PWideChar): HCkEmailBundle; stdcall;
  TCkMailMan_LoadMbxFile = function (objHandle: HCkMailMan; mbxPath: PWideChar; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkMailMan_LoadMime = function (objHandle: HCkMailMan; mimeText: PWideChar): HCkEmail; stdcall;
  TCkMailMan_LoadTaskCaller = function (objHandle: HCkMailMan; task: HCkTask): wordbool; stdcall;
  TCkMailMan_LoadXmlEmail = function (objHandle: HCkMailMan; filename: PWideChar): HCkEmail; stdcall;
  TCkMailMan_LoadXmlEmailString = function (objHandle: HCkMailMan; xmlString: PWideChar): HCkEmail; stdcall;
  TCkMailMan_LoadXmlFile = function (objHandle: HCkMailMan; filename: PWideChar): HCkEmailBundle; stdcall;
  TCkMailMan_LoadXmlString = function (objHandle: HCkMailMan; xmlString: PWideChar): HCkEmailBundle; stdcall;
  TCkMailMan_MxLookup = function (objHandle: HCkMailMan; emailAddress: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMailMan__mxLookup = function (objHandle: HCkMailMan; emailAddress: PWideChar): PWideChar; stdcall;
  TCkMailMan_MxLookupAll = function (objHandle: HCkMailMan; emailAddress: PWideChar): HCkStringArray; stdcall;
  TCkMailMan_OpenSmtpConnection = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_OpenSmtpConnectionAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3Authenticate = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3AuthenticateAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3BeginSession = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3BeginSessionAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3Connect = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3ConnectAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3EndSession = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3EndSessionAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3EndSessionNoQuit = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3EndSessionNoQuitAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3Noop = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3NoopAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3Reset = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_Pop3ResetAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_Pop3SendRawCommand = function (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMailMan__pop3SendRawCommand = function (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkMailMan_Pop3SendRawCommandAsync = function (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkMailMan_QuickSend = function (objHandle: HCkMailMan; fromAddr: PWideChar; toAddr: PWideChar; subject: PWideChar; body: PWideChar; smtpServer: PWideChar): wordbool; stdcall;
  TCkMailMan_QuickSendAsync = function (objHandle: HCkMailMan; fromAddr: PWideChar; toAddr: PWideChar; subject: PWideChar; body: PWideChar; smtpServer: PWideChar): HCkTask; stdcall;
  TCkMailMan_RenderToMime = function (objHandle: HCkMailMan; email: HCkEmail; outStr: HCkString): wordbool; stdcall;
  TCkMailMan__renderToMime = function (objHandle: HCkMailMan; email: HCkEmail): PWideChar; stdcall;
  TCkMailMan_RenderToMimeBd = function (objHandle: HCkMailMan; email: HCkEmail; renderedMime: HCkBinData): wordbool; stdcall;
  TCkMailMan_RenderToMimeBytes = function (objHandle: HCkMailMan; email: HCkEmail; outData: HCkByteData): wordbool; stdcall;
  TCkMailMan_RenderToMimeSb = function (objHandle: HCkMailMan; email: HCkEmail; renderedMime: HCkStringBuilder): wordbool; stdcall;
  TCkMailMan_SendBundle = function (objHandle: HCkMailMan; bundle: HCkEmailBundle): wordbool; stdcall;
  TCkMailMan_SendBundleAsync = function (objHandle: HCkMailMan; bundle: HCkEmailBundle): HCkTask; stdcall;
  TCkMailMan_SendEmail = function (objHandle: HCkMailMan; email: HCkEmail): wordbool; stdcall;
  TCkMailMan_SendEmailAsync = function (objHandle: HCkMailMan; email: HCkEmail): HCkTask; stdcall;
  TCkMailMan_SendMime = function (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: PWideChar): wordbool; stdcall;
  TCkMailMan_SendMimeAsync = function (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: PWideChar): HCkTask; stdcall;
  TCkMailMan_SendMimeBd = function (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeData: HCkBinData): wordbool; stdcall;
  TCkMailMan_SendMimeBdAsync = function (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeData: HCkBinData): HCkTask; stdcall;
  TCkMailMan_SendMimeBytes = function (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: HCkByteData): wordbool; stdcall;
  TCkMailMan_SendMimeBytesAsync = function (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: HCkByteData): HCkTask; stdcall;
  TCkMailMan_SendMimeToList = function (objHandle: HCkMailMan; fromAddr: PWideChar; distListFilename: PWideChar; mimeSource: PWideChar): wordbool; stdcall;
  TCkMailMan_SendMimeToListAsync = function (objHandle: HCkMailMan; fromAddr: PWideChar; distListFilename: PWideChar; mimeSource: PWideChar): HCkTask; stdcall;
  TCkMailMan_SetDecryptCert = function (objHandle: HCkMailMan; cert: HCkCert): wordbool; stdcall;
  TCkMailMan_SetDecryptCert2 = function (objHandle: HCkMailMan; cert: HCkCert; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkMailMan_SetPassword = function (objHandle: HCkMailMan; protocol: PWideChar; password: HCkSecureString): wordbool; stdcall;
  TCkMailMan_SetSslClientCert = function (objHandle: HCkMailMan; cert: HCkCert): wordbool; stdcall;
  TCkMailMan_SetSslClientCertPem = function (objHandle: HCkMailMan; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool; stdcall;
  TCkMailMan_SetSslClientCertPfx = function (objHandle: HCkMailMan; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkMailMan_SmtpAuthenticate = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_SmtpAuthenticateAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_SmtpConnect = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_SmtpConnectAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_SmtpNoop = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_SmtpNoopAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_SmtpReset = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_SmtpResetAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_SmtpSendRawCommand = function (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkMailMan__smtpSendRawCommand = function (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool): PWideChar; stdcall;
  TCkMailMan_SmtpSendRawCommandAsync = function (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool): HCkTask; stdcall;
  TCkMailMan_SshAuthenticatePk = function (objHandle: HCkMailMan; sshLogin: PWideChar; sshUsername: HCkSshKey): wordbool; stdcall;
  TCkMailMan_SshAuthenticatePkAsync = function (objHandle: HCkMailMan; sshLogin: PWideChar; sshUsername: HCkSshKey): HCkTask; stdcall;
  TCkMailMan_SshAuthenticatePw = function (objHandle: HCkMailMan; sshLogin: PWideChar; sshPassword: PWideChar): wordbool; stdcall;
  TCkMailMan_SshAuthenticatePwAsync = function (objHandle: HCkMailMan; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask; stdcall;
  TCkMailMan_SshCloseTunnel = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_SshCloseTunnelAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_SshOpenTunnel = function (objHandle: HCkMailMan; sshHostname: PWideChar; sshPort: Integer): wordbool; stdcall;
  TCkMailMan_SshOpenTunnelAsync = function (objHandle: HCkMailMan; sshHostname: PWideChar; sshPort: Integer): HCkTask; stdcall;
  TCkMailMan_TransferMail = function (objHandle: HCkMailMan): HCkEmailBundle; stdcall;
  TCkMailMan_TransferMailAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_TransferMultipleMime = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkStringArray; stdcall;
  TCkMailMan_TransferMultipleMimeAsync = function (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask; stdcall;
  TCkMailMan_UseCertVault = function (objHandle: HCkMailMan; vault: HCkXmlCertVault): wordbool; stdcall;
  TCkMailMan_UseSsh = function (objHandle: HCkMailMan; ssh: HCkSsh): wordbool; stdcall;
  TCkMailMan_UseSshTunnel = function (objHandle: HCkMailMan; tunnel: HCkSocket): wordbool; stdcall;
  TCkMailMan_VerifyPopConnection = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_VerifyPopConnectionAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_VerifyPopLogin = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_VerifyPopLoginAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_VerifyRecips = function (objHandle: HCkMailMan; email: HCkEmail; badAddrs: HCkStringArray): wordbool; stdcall;
  TCkMailMan_VerifyRecipsAsync = function (objHandle: HCkMailMan; email: HCkEmail; badAddrs: HCkStringArray): HCkTask; stdcall;
  TCkMailMan_VerifySmtpConnection = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_VerifySmtpConnectionAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;
  TCkMailMan_VerifySmtpLogin = function (objHandle: HCkMailMan): wordbool; stdcall;
  TCkMailMan_VerifySmtpLoginAsync = function (objHandle: HCkMailMan): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..393] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkMailMan_Create : HCkMailMan;
begin
  result := TCkMailMan_Create(_map(0, 'CkMailMan_Create'));
end;

procedure CkMailMan_Dispose (handle: HCkMailMan);
begin
  TCkMailMan_Dispose(_map(1, 'CkMailMan_Dispose'))
    (handle);
end;


procedure CkMailMan_SetAbortCheck (objHandle: HCkMailMan; fn: TMailManAbortCheck);
begin
    TCkMailMan_SetAbortCheck(_map(2, 'CkMailMan_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkMailMan_SetProgressInfo (objHandle: HCkMailMan; fn: TMailManProgressInfo);
begin
    TCkMailMan_SetProgressInfo(_map(3, 'CkMailMan_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkMailMan_SetPercentDone (objHandle: HCkMailMan; fn: TMailManPercentDone);
begin
    TCkMailMan_SetPercentDone(_map(4, 'CkMailMan_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkMailMan_SetTaskCompleted (objHandle: HCkMailMan; fn: TMailManTaskCompleted);
begin
    TCkMailMan_SetTaskCompleted(_map(5, 'CkMailMan_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkMailMan_getAbortCurrent (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getAbortCurrent(_map(6, 'CkMailMan_getAbortCurrent'))
    (objHandle);
end;

procedure CkMailMan_putAbortCurrent (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putAbortCurrent(_map(7, 'CkMailMan_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkMailMan_getAllOrNone (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getAllOrNone(_map(8, 'CkMailMan_getAllOrNone'))
    (objHandle);
end;

procedure CkMailMan_putAllOrNone (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putAllOrNone(_map(9, 'CkMailMan_putAllOrNone'))
    (objHandle, newPropVal);
end;

function CkMailMan_getAutoFix (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getAutoFix(_map(10, 'CkMailMan_getAutoFix'))
    (objHandle);
end;

procedure CkMailMan_putAutoFix (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putAutoFix(_map(11, 'CkMailMan_putAutoFix'))
    (objHandle, newPropVal);
end;

function CkMailMan_getAutoGenMessageId (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getAutoGenMessageId(_map(12, 'CkMailMan_getAutoGenMessageId'))
    (objHandle);
end;

procedure CkMailMan_putAutoGenMessageId (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putAutoGenMessageId(_map(13, 'CkMailMan_putAutoGenMessageId'))
    (objHandle, newPropVal);
end;

function CkMailMan_getAutoSmtpRset (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getAutoSmtpRset(_map(14, 'CkMailMan_getAutoSmtpRset'))
    (objHandle);
end;

procedure CkMailMan_putAutoSmtpRset (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putAutoSmtpRset(_map(15, 'CkMailMan_putAutoSmtpRset'))
    (objHandle, newPropVal);
end;

function CkMailMan_getAutoUnwrapSecurity (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getAutoUnwrapSecurity(_map(16, 'CkMailMan_getAutoUnwrapSecurity'))
    (objHandle);
end;

procedure CkMailMan_putAutoUnwrapSecurity (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putAutoUnwrapSecurity(_map(17, 'CkMailMan_putAutoUnwrapSecurity'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getClientIpAddress (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getClientIpAddress(_map(18, 'CkMailMan_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putClientIpAddress (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putClientIpAddress(_map(19, 'CkMailMan_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkMailMan__clientIpAddress (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__clientIpAddress(_map(20, 'CkMailMan__clientIpAddress'))
    (objHandle);
end;

function CkMailMan_getConnectFailReason (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getConnectFailReason(_map(21, 'CkMailMan_getConnectFailReason'))
    (objHandle);
end;

function CkMailMan_getConnectTimeout (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getConnectTimeout(_map(22, 'CkMailMan_getConnectTimeout'))
    (objHandle);
end;

procedure CkMailMan_putConnectTimeout (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putConnectTimeout(_map(23, 'CkMailMan_putConnectTimeout'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getDebugLogFilePath (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getDebugLogFilePath(_map(24, 'CkMailMan_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putDebugLogFilePath (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putDebugLogFilePath(_map(25, 'CkMailMan_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkMailMan__debugLogFilePath (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__debugLogFilePath(_map(26, 'CkMailMan__debugLogFilePath'))
    (objHandle);
end;

procedure CkMailMan_getDsnEnvid (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getDsnEnvid(_map(27, 'CkMailMan_getDsnEnvid'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putDsnEnvid (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putDsnEnvid(_map(28, 'CkMailMan_putDsnEnvid'))
    (objHandle, newPropVal);
end;

function CkMailMan__dsnEnvid (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__dsnEnvid(_map(29, 'CkMailMan__dsnEnvid'))
    (objHandle);
end;

procedure CkMailMan_getDsnNotify (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getDsnNotify(_map(30, 'CkMailMan_getDsnNotify'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putDsnNotify (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putDsnNotify(_map(31, 'CkMailMan_putDsnNotify'))
    (objHandle, newPropVal);
end;

function CkMailMan__dsnNotify (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__dsnNotify(_map(32, 'CkMailMan__dsnNotify'))
    (objHandle);
end;

procedure CkMailMan_getDsnRet (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getDsnRet(_map(33, 'CkMailMan_getDsnRet'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putDsnRet (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putDsnRet(_map(34, 'CkMailMan_putDsnRet'))
    (objHandle, newPropVal);
end;

function CkMailMan__dsnRet (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__dsnRet(_map(35, 'CkMailMan__dsnRet'))
    (objHandle);
end;

function CkMailMan_getEmbedCertChain (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getEmbedCertChain(_map(36, 'CkMailMan_getEmbedCertChain'))
    (objHandle);
end;

procedure CkMailMan_putEmbedCertChain (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putEmbedCertChain(_map(37, 'CkMailMan_putEmbedCertChain'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getFilter (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getFilter(_map(38, 'CkMailMan_getFilter'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putFilter (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putFilter(_map(39, 'CkMailMan_putFilter'))
    (objHandle, newPropVal);
end;

function CkMailMan__filter (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__filter(_map(40, 'CkMailMan__filter'))
    (objHandle);
end;

function CkMailMan_getHeartbeatMs (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getHeartbeatMs(_map(41, 'CkMailMan_getHeartbeatMs'))
    (objHandle);
end;

procedure CkMailMan_putHeartbeatMs (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putHeartbeatMs(_map(42, 'CkMailMan_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getHeloHostname (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getHeloHostname(_map(43, 'CkMailMan_getHeloHostname'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putHeloHostname (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putHeloHostname(_map(44, 'CkMailMan_putHeloHostname'))
    (objHandle, newPropVal);
end;

function CkMailMan__heloHostname (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__heloHostname(_map(45, 'CkMailMan__heloHostname'))
    (objHandle);
end;

procedure CkMailMan_getHttpProxyAuthMethod (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getHttpProxyAuthMethod(_map(46, 'CkMailMan_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putHttpProxyAuthMethod (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putHttpProxyAuthMethod(_map(47, 'CkMailMan_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkMailMan__httpProxyAuthMethod (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__httpProxyAuthMethod(_map(48, 'CkMailMan__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkMailMan_getHttpProxyDomain (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getHttpProxyDomain(_map(49, 'CkMailMan_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putHttpProxyDomain (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putHttpProxyDomain(_map(50, 'CkMailMan_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkMailMan__httpProxyDomain (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__httpProxyDomain(_map(51, 'CkMailMan__httpProxyDomain'))
    (objHandle);
end;

procedure CkMailMan_getHttpProxyHostname (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getHttpProxyHostname(_map(52, 'CkMailMan_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putHttpProxyHostname (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putHttpProxyHostname(_map(53, 'CkMailMan_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkMailMan__httpProxyHostname (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__httpProxyHostname(_map(54, 'CkMailMan__httpProxyHostname'))
    (objHandle);
end;

procedure CkMailMan_getHttpProxyPassword (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getHttpProxyPassword(_map(55, 'CkMailMan_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putHttpProxyPassword (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putHttpProxyPassword(_map(56, 'CkMailMan_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkMailMan__httpProxyPassword (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__httpProxyPassword(_map(57, 'CkMailMan__httpProxyPassword'))
    (objHandle);
end;

function CkMailMan_getHttpProxyPort (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getHttpProxyPort(_map(58, 'CkMailMan_getHttpProxyPort'))
    (objHandle);
end;

procedure CkMailMan_putHttpProxyPort (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putHttpProxyPort(_map(59, 'CkMailMan_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getHttpProxyUsername (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getHttpProxyUsername(_map(60, 'CkMailMan_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putHttpProxyUsername (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putHttpProxyUsername(_map(61, 'CkMailMan_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkMailMan__httpProxyUsername (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__httpProxyUsername(_map(62, 'CkMailMan__httpProxyUsername'))
    (objHandle);
end;

function CkMailMan_getImmediateDelete (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getImmediateDelete(_map(63, 'CkMailMan_getImmediateDelete'))
    (objHandle);
end;

procedure CkMailMan_putImmediateDelete (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putImmediateDelete(_map(64, 'CkMailMan_putImmediateDelete'))
    (objHandle, newPropVal);
end;

function CkMailMan_getIncludeRootCert (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getIncludeRootCert(_map(65, 'CkMailMan_getIncludeRootCert'))
    (objHandle);
end;

procedure CkMailMan_putIncludeRootCert (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putIncludeRootCert(_map(66, 'CkMailMan_putIncludeRootCert'))
    (objHandle, newPropVal);
end;

function CkMailMan_getIsPop3Connected (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getIsPop3Connected(_map(67, 'CkMailMan_getIsPop3Connected'))
    (objHandle);
end;

function CkMailMan_getIsSmtpConnected (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getIsSmtpConnected(_map(68, 'CkMailMan_getIsSmtpConnected'))
    (objHandle);
end;

procedure CkMailMan_getLastErrorHtml (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getLastErrorHtml(_map(69, 'CkMailMan_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkMailMan__lastErrorHtml (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__lastErrorHtml(_map(70, 'CkMailMan__lastErrorHtml'))
    (objHandle);
end;

procedure CkMailMan_getLastErrorText (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getLastErrorText(_map(71, 'CkMailMan_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkMailMan__lastErrorText (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__lastErrorText(_map(72, 'CkMailMan__lastErrorText'))
    (objHandle);
end;

procedure CkMailMan_getLastErrorXml (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getLastErrorXml(_map(73, 'CkMailMan_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkMailMan__lastErrorXml (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__lastErrorXml(_map(74, 'CkMailMan__lastErrorXml'))
    (objHandle);
end;

function CkMailMan_getLastMethodSuccess (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getLastMethodSuccess(_map(75, 'CkMailMan_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkMailMan_putLastMethodSuccess (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putLastMethodSuccess(_map(76, 'CkMailMan_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkMailMan_getLastSmtpStatus (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getLastSmtpStatus(_map(77, 'CkMailMan_getLastSmtpStatus'))
    (objHandle);
end;

procedure CkMailMan_getLastSmtpStatusMsg (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getLastSmtpStatusMsg(_map(78, 'CkMailMan_getLastSmtpStatusMsg'))
    (objHandle, outPropVal);
end;

function CkMailMan__lastSmtpStatusMsg (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__lastSmtpStatusMsg(_map(79, 'CkMailMan__lastSmtpStatusMsg'))
    (objHandle);
end;

procedure CkMailMan_getLogMailReceivedFilename (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getLogMailReceivedFilename(_map(80, 'CkMailMan_getLogMailReceivedFilename'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putLogMailReceivedFilename (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putLogMailReceivedFilename(_map(81, 'CkMailMan_putLogMailReceivedFilename'))
    (objHandle, newPropVal);
end;

function CkMailMan__logMailReceivedFilename (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__logMailReceivedFilename(_map(82, 'CkMailMan__logMailReceivedFilename'))
    (objHandle);
end;

procedure CkMailMan_getLogMailSentFilename (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getLogMailSentFilename(_map(83, 'CkMailMan_getLogMailSentFilename'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putLogMailSentFilename (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putLogMailSentFilename(_map(84, 'CkMailMan_putLogMailSentFilename'))
    (objHandle, newPropVal);
end;

function CkMailMan__logMailSentFilename (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__logMailSentFilename(_map(85, 'CkMailMan__logMailSentFilename'))
    (objHandle);
end;

procedure CkMailMan_getMailHost (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getMailHost(_map(86, 'CkMailMan_getMailHost'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putMailHost (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putMailHost(_map(87, 'CkMailMan_putMailHost'))
    (objHandle, newPropVal);
end;

function CkMailMan__mailHost (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__mailHost(_map(88, 'CkMailMan__mailHost'))
    (objHandle);
end;

function CkMailMan_getMailPort (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getMailPort(_map(89, 'CkMailMan_getMailPort'))
    (objHandle);
end;

procedure CkMailMan_putMailPort (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putMailPort(_map(90, 'CkMailMan_putMailPort'))
    (objHandle, newPropVal);
end;

function CkMailMan_getMaxCount (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getMaxCount(_map(91, 'CkMailMan_getMaxCount'))
    (objHandle);
end;

procedure CkMailMan_putMaxCount (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putMaxCount(_map(92, 'CkMailMan_putMaxCount'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getOAuth2AccessToken (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getOAuth2AccessToken(_map(93, 'CkMailMan_getOAuth2AccessToken'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putOAuth2AccessToken (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putOAuth2AccessToken(_map(94, 'CkMailMan_putOAuth2AccessToken'))
    (objHandle, newPropVal);
end;

function CkMailMan__oAuth2AccessToken (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__oAuth2AccessToken(_map(95, 'CkMailMan__oAuth2AccessToken'))
    (objHandle);
end;

function CkMailMan_getOpaqueSigning (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getOpaqueSigning(_map(96, 'CkMailMan_getOpaqueSigning'))
    (objHandle);
end;

procedure CkMailMan_putOpaqueSigning (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putOpaqueSigning(_map(97, 'CkMailMan_putOpaqueSigning'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getP7mEncryptAttachFilename (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getP7mEncryptAttachFilename(_map(98, 'CkMailMan_getP7mEncryptAttachFilename'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putP7mEncryptAttachFilename (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putP7mEncryptAttachFilename(_map(99, 'CkMailMan_putP7mEncryptAttachFilename'))
    (objHandle, newPropVal);
end;

function CkMailMan__p7mEncryptAttachFilename (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__p7mEncryptAttachFilename(_map(100, 'CkMailMan__p7mEncryptAttachFilename'))
    (objHandle);
end;

procedure CkMailMan_getP7mSigAttachFilename (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getP7mSigAttachFilename(_map(101, 'CkMailMan_getP7mSigAttachFilename'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putP7mSigAttachFilename (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putP7mSigAttachFilename(_map(102, 'CkMailMan_putP7mSigAttachFilename'))
    (objHandle, newPropVal);
end;

function CkMailMan__p7mSigAttachFilename (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__p7mSigAttachFilename(_map(103, 'CkMailMan__p7mSigAttachFilename'))
    (objHandle);
end;

procedure CkMailMan_getP7sSigAttachFilename (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getP7sSigAttachFilename(_map(104, 'CkMailMan_getP7sSigAttachFilename'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putP7sSigAttachFilename (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putP7sSigAttachFilename(_map(105, 'CkMailMan_putP7sSigAttachFilename'))
    (objHandle, newPropVal);
end;

function CkMailMan__p7sSigAttachFilename (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__p7sSigAttachFilename(_map(106, 'CkMailMan__p7sSigAttachFilename'))
    (objHandle);
end;

function CkMailMan_getPercentDoneScale (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getPercentDoneScale(_map(107, 'CkMailMan_getPercentDoneScale'))
    (objHandle);
end;

procedure CkMailMan_putPercentDoneScale (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putPercentDoneScale(_map(108, 'CkMailMan_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkMailMan_getPop3SessionId (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getPop3SessionId(_map(109, 'CkMailMan_getPop3SessionId'))
    (objHandle);
end;

procedure CkMailMan_getPop3SessionLog (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getPop3SessionLog(_map(110, 'CkMailMan_getPop3SessionLog'))
    (objHandle, outPropVal);
end;

function CkMailMan__pop3SessionLog (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__pop3SessionLog(_map(111, 'CkMailMan__pop3SessionLog'))
    (objHandle);
end;

function CkMailMan_getPop3SPA (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getPop3SPA(_map(112, 'CkMailMan_getPop3SPA'))
    (objHandle);
end;

procedure CkMailMan_putPop3SPA (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putPop3SPA(_map(113, 'CkMailMan_putPop3SPA'))
    (objHandle, newPropVal);
end;

function CkMailMan_getPop3SslServerCertVerified (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getPop3SslServerCertVerified(_map(114, 'CkMailMan_getPop3SslServerCertVerified'))
    (objHandle);
end;

function CkMailMan_getPop3Stls (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getPop3Stls(_map(115, 'CkMailMan_getPop3Stls'))
    (objHandle);
end;

procedure CkMailMan_putPop3Stls (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putPop3Stls(_map(116, 'CkMailMan_putPop3Stls'))
    (objHandle, newPropVal);
end;

function CkMailMan_getPop3StlsIfPossible (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getPop3StlsIfPossible(_map(117, 'CkMailMan_getPop3StlsIfPossible'))
    (objHandle);
end;

procedure CkMailMan_putPop3StlsIfPossible (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putPop3StlsIfPossible(_map(118, 'CkMailMan_putPop3StlsIfPossible'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getPopPassword (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getPopPassword(_map(119, 'CkMailMan_getPopPassword'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putPopPassword (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putPopPassword(_map(120, 'CkMailMan_putPopPassword'))
    (objHandle, newPropVal);
end;

function CkMailMan__popPassword (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__popPassword(_map(121, 'CkMailMan__popPassword'))
    (objHandle);
end;

procedure CkMailMan_getPopPasswordBase64 (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getPopPasswordBase64(_map(122, 'CkMailMan_getPopPasswordBase64'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putPopPasswordBase64 (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putPopPasswordBase64(_map(123, 'CkMailMan_putPopPasswordBase64'))
    (objHandle, newPropVal);
end;

function CkMailMan__popPasswordBase64 (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__popPasswordBase64(_map(124, 'CkMailMan__popPasswordBase64'))
    (objHandle);
end;

function CkMailMan_getPopSsl (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getPopSsl(_map(125, 'CkMailMan_getPopSsl'))
    (objHandle);
end;

procedure CkMailMan_putPopSsl (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putPopSsl(_map(126, 'CkMailMan_putPopSsl'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getPopUsername (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getPopUsername(_map(127, 'CkMailMan_getPopUsername'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putPopUsername (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putPopUsername(_map(128, 'CkMailMan_putPopUsername'))
    (objHandle, newPropVal);
end;

function CkMailMan__popUsername (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__popUsername(_map(129, 'CkMailMan__popUsername'))
    (objHandle);
end;

function CkMailMan_getPreferIpv6 (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getPreferIpv6(_map(130, 'CkMailMan_getPreferIpv6'))
    (objHandle);
end;

procedure CkMailMan_putPreferIpv6 (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putPreferIpv6(_map(131, 'CkMailMan_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkMailMan_getReadTimeout (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getReadTimeout(_map(132, 'CkMailMan_getReadTimeout'))
    (objHandle);
end;

procedure CkMailMan_putReadTimeout (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putReadTimeout(_map(133, 'CkMailMan_putReadTimeout'))
    (objHandle, newPropVal);
end;

function CkMailMan_getRequireSslCertVerify (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getRequireSslCertVerify(_map(134, 'CkMailMan_getRequireSslCertVerify'))
    (objHandle);
end;

procedure CkMailMan_putRequireSslCertVerify (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putRequireSslCertVerify(_map(135, 'CkMailMan_putRequireSslCertVerify'))
    (objHandle, newPropVal);
end;

function CkMailMan_getResetDateOnLoad (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getResetDateOnLoad(_map(136, 'CkMailMan_getResetDateOnLoad'))
    (objHandle);
end;

procedure CkMailMan_putResetDateOnLoad (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putResetDateOnLoad(_map(137, 'CkMailMan_putResetDateOnLoad'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSendBufferSize (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSendBufferSize(_map(138, 'CkMailMan_getSendBufferSize'))
    (objHandle);
end;

procedure CkMailMan_putSendBufferSize (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSendBufferSize(_map(139, 'CkMailMan_putSendBufferSize'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSendIndividual (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getSendIndividual(_map(140, 'CkMailMan_getSendIndividual'))
    (objHandle);
end;

procedure CkMailMan_putSendIndividual (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putSendIndividual(_map(141, 'CkMailMan_putSendIndividual'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSizeLimit (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSizeLimit(_map(142, 'CkMailMan_getSizeLimit'))
    (objHandle);
end;

procedure CkMailMan_putSizeLimit (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSizeLimit(_map(143, 'CkMailMan_putSizeLimit'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getSmtpAuthMethod (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpAuthMethod(_map(144, 'CkMailMan_getSmtpAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSmtpAuthMethod (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSmtpAuthMethod(_map(145, 'CkMailMan_putSmtpAuthMethod'))
    (objHandle, newPropVal);
end;

function CkMailMan__smtpAuthMethod (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpAuthMethod(_map(146, 'CkMailMan__smtpAuthMethod'))
    (objHandle);
end;

procedure CkMailMan_getSmtpFailReason (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpFailReason(_map(147, 'CkMailMan_getSmtpFailReason'))
    (objHandle, outPropVal);
end;

function CkMailMan__smtpFailReason (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpFailReason(_map(148, 'CkMailMan__smtpFailReason'))
    (objHandle);
end;

procedure CkMailMan_getSmtpHost (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpHost(_map(149, 'CkMailMan_getSmtpHost'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSmtpHost (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSmtpHost(_map(150, 'CkMailMan_putSmtpHost'))
    (objHandle, newPropVal);
end;

function CkMailMan__smtpHost (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpHost(_map(151, 'CkMailMan__smtpHost'))
    (objHandle);
end;

procedure CkMailMan_getSmtpLoginDomain (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpLoginDomain(_map(152, 'CkMailMan_getSmtpLoginDomain'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSmtpLoginDomain (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSmtpLoginDomain(_map(153, 'CkMailMan_putSmtpLoginDomain'))
    (objHandle, newPropVal);
end;

function CkMailMan__smtpLoginDomain (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpLoginDomain(_map(154, 'CkMailMan__smtpLoginDomain'))
    (objHandle);
end;

procedure CkMailMan_getSmtpMailFrom (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpMailFrom(_map(155, 'CkMailMan_getSmtpMailFrom'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSmtpMailFrom (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSmtpMailFrom(_map(156, 'CkMailMan_putSmtpMailFrom'))
    (objHandle, newPropVal);
end;

function CkMailMan__smtpMailFrom (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpMailFrom(_map(157, 'CkMailMan__smtpMailFrom'))
    (objHandle);
end;

procedure CkMailMan_getSmtpPassword (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpPassword(_map(158, 'CkMailMan_getSmtpPassword'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSmtpPassword (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSmtpPassword(_map(159, 'CkMailMan_putSmtpPassword'))
    (objHandle, newPropVal);
end;

function CkMailMan__smtpPassword (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpPassword(_map(160, 'CkMailMan__smtpPassword'))
    (objHandle);
end;

function CkMailMan_getSmtpPipelining (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getSmtpPipelining(_map(161, 'CkMailMan_getSmtpPipelining'))
    (objHandle);
end;

procedure CkMailMan_putSmtpPipelining (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putSmtpPipelining(_map(162, 'CkMailMan_putSmtpPipelining'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSmtpPort (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSmtpPort(_map(163, 'CkMailMan_getSmtpPort'))
    (objHandle);
end;

procedure CkMailMan_putSmtpPort (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSmtpPort(_map(164, 'CkMailMan_putSmtpPort'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getSmtpSessionLog (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpSessionLog(_map(165, 'CkMailMan_getSmtpSessionLog'))
    (objHandle, outPropVal);
end;

function CkMailMan__smtpSessionLog (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpSessionLog(_map(166, 'CkMailMan__smtpSessionLog'))
    (objHandle);
end;

function CkMailMan_getSmtpSsl (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getSmtpSsl(_map(167, 'CkMailMan_getSmtpSsl'))
    (objHandle);
end;

procedure CkMailMan_putSmtpSsl (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putSmtpSsl(_map(168, 'CkMailMan_putSmtpSsl'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSmtpSslServerCertVerified (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getSmtpSslServerCertVerified(_map(169, 'CkMailMan_getSmtpSslServerCertVerified'))
    (objHandle);
end;

procedure CkMailMan_getSmtpUsername (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSmtpUsername(_map(170, 'CkMailMan_getSmtpUsername'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSmtpUsername (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSmtpUsername(_map(171, 'CkMailMan_putSmtpUsername'))
    (objHandle, newPropVal);
end;

function CkMailMan__smtpUsername (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__smtpUsername(_map(172, 'CkMailMan__smtpUsername'))
    (objHandle);
end;

procedure CkMailMan_getSocksHostname (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSocksHostname(_map(173, 'CkMailMan_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSocksHostname (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSocksHostname(_map(174, 'CkMailMan_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkMailMan__socksHostname (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__socksHostname(_map(175, 'CkMailMan__socksHostname'))
    (objHandle);
end;

procedure CkMailMan_getSocksPassword (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSocksPassword(_map(176, 'CkMailMan_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSocksPassword (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSocksPassword(_map(177, 'CkMailMan_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkMailMan__socksPassword (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__socksPassword(_map(178, 'CkMailMan__socksPassword'))
    (objHandle);
end;

function CkMailMan_getSocksPort (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSocksPort(_map(179, 'CkMailMan_getSocksPort'))
    (objHandle);
end;

procedure CkMailMan_putSocksPort (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSocksPort(_map(180, 'CkMailMan_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getSocksUsername (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSocksUsername(_map(181, 'CkMailMan_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSocksUsername (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSocksUsername(_map(182, 'CkMailMan_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkMailMan__socksUsername (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__socksUsername(_map(183, 'CkMailMan__socksUsername'))
    (objHandle);
end;

function CkMailMan_getSocksVersion (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSocksVersion(_map(184, 'CkMailMan_getSocksVersion'))
    (objHandle);
end;

procedure CkMailMan_putSocksVersion (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSocksVersion(_map(185, 'CkMailMan_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSoRcvBuf (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSoRcvBuf(_map(186, 'CkMailMan_getSoRcvBuf'))
    (objHandle);
end;

procedure CkMailMan_putSoRcvBuf (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSoRcvBuf(_map(187, 'CkMailMan_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkMailMan_getSoSndBuf (objHandle: HCkMailMan): Integer;
begin
    result := TCkMailMan_getSoSndBuf(_map(188, 'CkMailMan_getSoSndBuf'))
    (objHandle);
end;

procedure CkMailMan_putSoSndBuf (objHandle: HCkMailMan; newPropVal: Integer);
begin
  TCkMailMan_putSoSndBuf(_map(189, 'CkMailMan_putSoSndBuf'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getSslAllowedCiphers (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSslAllowedCiphers(_map(190, 'CkMailMan_getSslAllowedCiphers'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSslAllowedCiphers (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSslAllowedCiphers(_map(191, 'CkMailMan_putSslAllowedCiphers'))
    (objHandle, newPropVal);
end;

function CkMailMan__sslAllowedCiphers (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__sslAllowedCiphers(_map(192, 'CkMailMan__sslAllowedCiphers'))
    (objHandle);
end;

procedure CkMailMan_getSslProtocol (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getSslProtocol(_map(193, 'CkMailMan_getSslProtocol'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putSslProtocol (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putSslProtocol(_map(194, 'CkMailMan_putSslProtocol'))
    (objHandle, newPropVal);
end;

function CkMailMan__sslProtocol (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__sslProtocol(_map(195, 'CkMailMan__sslProtocol'))
    (objHandle);
end;

function CkMailMan_getStartTLS (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getStartTLS(_map(196, 'CkMailMan_getStartTLS'))
    (objHandle);
end;

procedure CkMailMan_putStartTLS (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putStartTLS(_map(197, 'CkMailMan_putStartTLS'))
    (objHandle, newPropVal);
end;

function CkMailMan_getStartTLSifPossible (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getStartTLSifPossible(_map(198, 'CkMailMan_getStartTLSifPossible'))
    (objHandle);
end;

procedure CkMailMan_putStartTLSifPossible (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putStartTLSifPossible(_map(199, 'CkMailMan_putStartTLSifPossible'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getTlsCipherSuite (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getTlsCipherSuite(_map(200, 'CkMailMan_getTlsCipherSuite'))
    (objHandle, outPropVal);
end;

function CkMailMan__tlsCipherSuite (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__tlsCipherSuite(_map(201, 'CkMailMan__tlsCipherSuite'))
    (objHandle);
end;

procedure CkMailMan_getTlsPinSet (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getTlsPinSet(_map(202, 'CkMailMan_getTlsPinSet'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putTlsPinSet (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putTlsPinSet(_map(203, 'CkMailMan_putTlsPinSet'))
    (objHandle, newPropVal);
end;

function CkMailMan__tlsPinSet (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__tlsPinSet(_map(204, 'CkMailMan__tlsPinSet'))
    (objHandle);
end;

procedure CkMailMan_getTlsVersion (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getTlsVersion(_map(205, 'CkMailMan_getTlsVersion'))
    (objHandle, outPropVal);
end;

function CkMailMan__tlsVersion (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__tlsVersion(_map(206, 'CkMailMan__tlsVersion'))
    (objHandle);
end;

procedure CkMailMan_getUncommonOptions (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getUncommonOptions(_map(207, 'CkMailMan_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkMailMan_putUncommonOptions (objHandle: HCkMailMan; newPropVal: PWideChar);
begin
  TCkMailMan_putUncommonOptions(_map(208, 'CkMailMan_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkMailMan__uncommonOptions (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__uncommonOptions(_map(209, 'CkMailMan__uncommonOptions'))
    (objHandle);
end;

function CkMailMan_getUseApop (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getUseApop(_map(210, 'CkMailMan_getUseApop'))
    (objHandle);
end;

procedure CkMailMan_putUseApop (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putUseApop(_map(211, 'CkMailMan_putUseApop'))
    (objHandle, newPropVal);
end;

function CkMailMan_getVerboseLogging (objHandle: HCkMailMan): wordbool;
begin
    result := TCkMailMan_getVerboseLogging(_map(212, 'CkMailMan_getVerboseLogging'))
    (objHandle);
end;

procedure CkMailMan_putVerboseLogging (objHandle: HCkMailMan; newPropVal: wordbool);
begin
  TCkMailMan_putVerboseLogging(_map(213, 'CkMailMan_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkMailMan_getVersion (objHandle: HCkMailMan; outPropVal: HCkString);
begin
  TCkMailMan_getVersion(_map(214, 'CkMailMan_getVersion'))
    (objHandle, outPropVal);
end;

function CkMailMan__version (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__version(_map(215, 'CkMailMan__version'))
    (objHandle);
end;

function CkMailMan_AddPfxSourceBd (objHandle: HCkMailMan; bd: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkMailMan_AddPfxSourceBd(_map(216, 'CkMailMan_AddPfxSourceBd'))
    (objHandle, bd, password);
end;

function CkMailMan_AddPfxSourceData (objHandle: HCkMailMan; pfxData: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkMailMan_AddPfxSourceData(_map(217, 'CkMailMan_AddPfxSourceData'))
    (objHandle, pfxData, password);
end;

function CkMailMan_AddPfxSourceFile (objHandle: HCkMailMan; pfxFilePath: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkMailMan_AddPfxSourceFile(_map(218, 'CkMailMan_AddPfxSourceFile'))
    (objHandle, pfxFilePath, password);
end;

function CkMailMan_CheckMail (objHandle: HCkMailMan): Integer;
begin
  result := TCkMailMan_CheckMail(_map(219, 'CkMailMan_CheckMail'))
    (objHandle);
end;

function CkMailMan_CheckMailAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_CheckMailAsync(_map(220, 'CkMailMan_CheckMailAsync'))
    (objHandle);
end;

procedure CkMailMan_ClearBadEmailAddresses (objHandle: HCkMailMan);
begin
  TCkMailMan_ClearBadEmailAddresses(_map(221, 'CkMailMan_ClearBadEmailAddresses'))
    (objHandle);
end;

procedure CkMailMan_ClearPop3SessionLog (objHandle: HCkMailMan);
begin
  TCkMailMan_ClearPop3SessionLog(_map(222, 'CkMailMan_ClearPop3SessionLog'))
    (objHandle);
end;

procedure CkMailMan_ClearSmtpSessionLog (objHandle: HCkMailMan);
begin
  TCkMailMan_ClearSmtpSessionLog(_map(223, 'CkMailMan_ClearSmtpSessionLog'))
    (objHandle);
end;

function CkMailMan_CloseSmtpConnection (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_CloseSmtpConnection(_map(224, 'CkMailMan_CloseSmtpConnection'))
    (objHandle);
end;

function CkMailMan_CloseSmtpConnectionAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_CloseSmtpConnectionAsync(_map(225, 'CkMailMan_CloseSmtpConnectionAsync'))
    (objHandle);
end;

function CkMailMan_CopyMail (objHandle: HCkMailMan): HCkEmailBundle;
begin
  result := TCkMailMan_CopyMail(_map(226, 'CkMailMan_CopyMail'))
    (objHandle);
end;

function CkMailMan_CopyMailAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_CopyMailAsync(_map(227, 'CkMailMan_CopyMailAsync'))
    (objHandle);
end;

function CkMailMan_DeleteBundle (objHandle: HCkMailMan; emailBundle: HCkEmailBundle): wordbool;
begin
  result := TCkMailMan_DeleteBundle(_map(228, 'CkMailMan_DeleteBundle'))
    (objHandle, emailBundle);
end;

function CkMailMan_DeleteBundleAsync (objHandle: HCkMailMan; emailBundle: HCkEmailBundle): HCkTask;
begin
  result := TCkMailMan_DeleteBundleAsync(_map(229, 'CkMailMan_DeleteBundleAsync'))
    (objHandle, emailBundle);
end;

function CkMailMan_DeleteByMsgnum (objHandle: HCkMailMan; msgnum: Integer): wordbool;
begin
  result := TCkMailMan_DeleteByMsgnum(_map(230, 'CkMailMan_DeleteByMsgnum'))
    (objHandle, msgnum);
end;

function CkMailMan_DeleteByMsgnumAsync (objHandle: HCkMailMan; msgnum: Integer): HCkTask;
begin
  result := TCkMailMan_DeleteByMsgnumAsync(_map(231, 'CkMailMan_DeleteByMsgnumAsync'))
    (objHandle, msgnum);
end;

function CkMailMan_DeleteByUidl (objHandle: HCkMailMan; uidl: PWideChar): wordbool;
begin
  result := TCkMailMan_DeleteByUidl(_map(232, 'CkMailMan_DeleteByUidl'))
    (objHandle, uidl);
end;

function CkMailMan_DeleteByUidlAsync (objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
begin
  result := TCkMailMan_DeleteByUidlAsync(_map(233, 'CkMailMan_DeleteByUidlAsync'))
    (objHandle, uidl);
end;

function CkMailMan_DeleteEmail (objHandle: HCkMailMan; email: HCkEmail): wordbool;
begin
  result := TCkMailMan_DeleteEmail(_map(234, 'CkMailMan_DeleteEmail'))
    (objHandle, email);
end;

function CkMailMan_DeleteEmailAsync (objHandle: HCkMailMan; email: HCkEmail): HCkTask;
begin
  result := TCkMailMan_DeleteEmailAsync(_map(235, 'CkMailMan_DeleteEmailAsync'))
    (objHandle, email);
end;

function CkMailMan_DeleteMultiple (objHandle: HCkMailMan; uidlArray: HCkStringArray): wordbool;
begin
  result := TCkMailMan_DeleteMultiple(_map(236, 'CkMailMan_DeleteMultiple'))
    (objHandle, uidlArray);
end;

function CkMailMan_DeleteMultipleAsync (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
begin
  result := TCkMailMan_DeleteMultipleAsync(_map(237, 'CkMailMan_DeleteMultipleAsync'))
    (objHandle, uidlArray);
end;

function CkMailMan_DeleteUidlSet (objHandle: HCkMailMan; stUidls: HCkStringTable): wordbool;
begin
  result := TCkMailMan_DeleteUidlSet(_map(238, 'CkMailMan_DeleteUidlSet'))
    (objHandle, stUidls);
end;

function CkMailMan_DeleteUidlSetAsync (objHandle: HCkMailMan; stUidls: HCkStringTable): HCkTask;
begin
  result := TCkMailMan_DeleteUidlSetAsync(_map(239, 'CkMailMan_DeleteUidlSetAsync'))
    (objHandle, stUidls);
end;

function CkMailMan_FetchAll (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkMailMan_FetchAll(_map(240, 'CkMailMan_FetchAll'))
    (objHandle, keepOnServer, headersOnly, numBodyLines, bundle);
end;

function CkMailMan_FetchAllAsync (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkMailMan_FetchAllAsync(_map(241, 'CkMailMan_FetchAllAsync'))
    (objHandle, keepOnServer, headersOnly, numBodyLines, bundle);
end;

function CkMailMan_FetchByMsgnum (objHandle: HCkMailMan; msgnum: Integer): HCkEmail;
begin
  result := TCkMailMan_FetchByMsgnum(_map(242, 'CkMailMan_FetchByMsgnum'))
    (objHandle, msgnum);
end;

function CkMailMan_FetchByMsgnumAsync (objHandle: HCkMailMan; msgnum: Integer): HCkTask;
begin
  result := TCkMailMan_FetchByMsgnumAsync(_map(243, 'CkMailMan_FetchByMsgnumAsync'))
    (objHandle, msgnum);
end;

function CkMailMan_FetchByUidl (objHandle: HCkMailMan; uidl: PWideChar; headerOnly: wordbool; numBodyLines: Integer; email: HCkEmail): wordbool;
begin
  result := TCkMailMan_FetchByUidl(_map(244, 'CkMailMan_FetchByUidl'))
    (objHandle, uidl, headerOnly, numBodyLines, email);
end;

function CkMailMan_FetchByUidlAsync (objHandle: HCkMailMan; uidl: PWideChar; headerOnly: wordbool; numBodyLines: Integer; email: HCkEmail): HCkTask;
begin
  result := TCkMailMan_FetchByUidlAsync(_map(245, 'CkMailMan_FetchByUidlAsync'))
    (objHandle, uidl, headerOnly, numBodyLines, email);
end;

function CkMailMan_FetchEmail (objHandle: HCkMailMan; uidl: PWideChar): HCkEmail;
begin
  result := TCkMailMan_FetchEmail(_map(246, 'CkMailMan_FetchEmail'))
    (objHandle, uidl);
end;

function CkMailMan_FetchEmailAsync (objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
begin
  result := TCkMailMan_FetchEmailAsync(_map(247, 'CkMailMan_FetchEmailAsync'))
    (objHandle, uidl);
end;

function CkMailMan_FetchFull (objHandle: HCkMailMan; partialEmail: HCkEmail; fullEmail: HCkEmail): wordbool;
begin
  result := TCkMailMan_FetchFull(_map(248, 'CkMailMan_FetchFull'))
    (objHandle, partialEmail, fullEmail);
end;

function CkMailMan_FetchFullAsync (objHandle: HCkMailMan; partialEmail: HCkEmail; fullEmail: HCkEmail): HCkTask;
begin
  result := TCkMailMan_FetchFullAsync(_map(249, 'CkMailMan_FetchFullAsync'))
    (objHandle, partialEmail, fullEmail);
end;

function CkMailMan_FetchMime (objHandle: HCkMailMan; uidl: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkMailMan_FetchMime(_map(250, 'CkMailMan_FetchMime'))
    (objHandle, uidl, outData);
end;

function CkMailMan_FetchMimeAsync (objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
begin
  result := TCkMailMan_FetchMimeAsync(_map(251, 'CkMailMan_FetchMimeAsync'))
    (objHandle, uidl);
end;

function CkMailMan_FetchMimeBd (objHandle: HCkMailMan; uidl: PWideChar; mimeData: HCkBinData): wordbool;
begin
  result := TCkMailMan_FetchMimeBd(_map(252, 'CkMailMan_FetchMimeBd'))
    (objHandle, uidl, mimeData);
end;

function CkMailMan_FetchMimeBdAsync (objHandle: HCkMailMan; uidl: PWideChar; mimeData: HCkBinData): HCkTask;
begin
  result := TCkMailMan_FetchMimeBdAsync(_map(253, 'CkMailMan_FetchMimeBdAsync'))
    (objHandle, uidl, mimeData);
end;

function CkMailMan_FetchMimeByMsgnum (objHandle: HCkMailMan; msgnum: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkMailMan_FetchMimeByMsgnum(_map(254, 'CkMailMan_FetchMimeByMsgnum'))
    (objHandle, msgnum, outData);
end;

function CkMailMan_FetchMimeByMsgnumAsync (objHandle: HCkMailMan; msgnum: Integer): HCkTask;
begin
  result := TCkMailMan_FetchMimeByMsgnumAsync(_map(255, 'CkMailMan_FetchMimeByMsgnumAsync'))
    (objHandle, msgnum);
end;

function CkMailMan_FetchMimeByMsgnumBd (objHandle: HCkMailMan; msgnum: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkMailMan_FetchMimeByMsgnumBd(_map(256, 'CkMailMan_FetchMimeByMsgnumBd'))
    (objHandle, msgnum, bd);
end;

function CkMailMan_FetchMimeByMsgnumBdAsync (objHandle: HCkMailMan; msgnum: Integer; bd: HCkBinData): HCkTask;
begin
  result := TCkMailMan_FetchMimeByMsgnumBdAsync(_map(257, 'CkMailMan_FetchMimeByMsgnumBdAsync'))
    (objHandle, msgnum, bd);
end;

function CkMailMan_FetchMultiple (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkEmailBundle;
begin
  result := TCkMailMan_FetchMultiple(_map(258, 'CkMailMan_FetchMultiple'))
    (objHandle, uidlArray);
end;

function CkMailMan_FetchMultipleAsync (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
begin
  result := TCkMailMan_FetchMultipleAsync(_map(259, 'CkMailMan_FetchMultipleAsync'))
    (objHandle, uidlArray);
end;

function CkMailMan_FetchMultipleHeaders (objHandle: HCkMailMan; uidlArray: HCkStringArray; numBodyLines: Integer): HCkEmailBundle;
begin
  result := TCkMailMan_FetchMultipleHeaders(_map(260, 'CkMailMan_FetchMultipleHeaders'))
    (objHandle, uidlArray, numBodyLines);
end;

function CkMailMan_FetchMultipleHeadersAsync (objHandle: HCkMailMan; uidlArray: HCkStringArray; numBodyLines: Integer): HCkTask;
begin
  result := TCkMailMan_FetchMultipleHeadersAsync(_map(261, 'CkMailMan_FetchMultipleHeadersAsync'))
    (objHandle, uidlArray, numBodyLines);
end;

function CkMailMan_FetchMultipleMime (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkStringArray;
begin
  result := TCkMailMan_FetchMultipleMime(_map(262, 'CkMailMan_FetchMultipleMime'))
    (objHandle, uidlArray);
end;

function CkMailMan_FetchMultipleMimeAsync (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
begin
  result := TCkMailMan_FetchMultipleMimeAsync(_map(263, 'CkMailMan_FetchMultipleMimeAsync'))
    (objHandle, uidlArray);
end;

function CkMailMan_FetchOne (objHandle: HCkMailMan; headerOnly: wordbool; numBodyLines: Integer; msgNum: Integer; email: HCkEmail): wordbool;
begin
  result := TCkMailMan_FetchOne(_map(264, 'CkMailMan_FetchOne'))
    (objHandle, headerOnly, numBodyLines, msgNum, email);
end;

function CkMailMan_FetchOneAsync (objHandle: HCkMailMan; headerOnly: wordbool; numBodyLines: Integer; msgNum: Integer; email: HCkEmail): HCkTask;
begin
  result := TCkMailMan_FetchOneAsync(_map(265, 'CkMailMan_FetchOneAsync'))
    (objHandle, headerOnly, numBodyLines, msgNum, email);
end;

function CkMailMan_FetchRange (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; startIndex: Integer; endIndex: Integer; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkMailMan_FetchRange(_map(266, 'CkMailMan_FetchRange'))
    (objHandle, keepOnServer, headersOnly, numBodyLines, startIndex, endIndex, bundle);
end;

function CkMailMan_FetchRangeAsync (objHandle: HCkMailMan; keepOnServer: wordbool; headersOnly: wordbool; numBodyLines: Integer; startIndex: Integer; endIndex: Integer; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkMailMan_FetchRangeAsync(_map(267, 'CkMailMan_FetchRangeAsync'))
    (objHandle, keepOnServer, headersOnly, numBodyLines, startIndex, endIndex, bundle);
end;

function CkMailMan_FetchSingleHeader (objHandle: HCkMailMan; numBodyLines: Integer; messageNumber: Integer): HCkEmail;
begin
  result := TCkMailMan_FetchSingleHeader(_map(268, 'CkMailMan_FetchSingleHeader'))
    (objHandle, numBodyLines, messageNumber);
end;

function CkMailMan_FetchSingleHeaderAsync (objHandle: HCkMailMan; numBodyLines: Integer; messageNumber: Integer): HCkTask;
begin
  result := TCkMailMan_FetchSingleHeaderAsync(_map(269, 'CkMailMan_FetchSingleHeaderAsync'))
    (objHandle, numBodyLines, messageNumber);
end;

function CkMailMan_FetchSingleHeaderByUidl (objHandle: HCkMailMan; numBodyLines: Integer; uidl: PWideChar): HCkEmail;
begin
  result := TCkMailMan_FetchSingleHeaderByUidl(_map(270, 'CkMailMan_FetchSingleHeaderByUidl'))
    (objHandle, numBodyLines, uidl);
end;

function CkMailMan_FetchSingleHeaderByUidlAsync (objHandle: HCkMailMan; numBodyLines: Integer; uidl: PWideChar): HCkTask;
begin
  result := TCkMailMan_FetchSingleHeaderByUidlAsync(_map(271, 'CkMailMan_FetchSingleHeaderByUidlAsync'))
    (objHandle, numBodyLines, uidl);
end;

function CkMailMan_FetchUidls (objHandle: HCkMailMan; uidls: HCkStringTable): wordbool;
begin
  result := TCkMailMan_FetchUidls(_map(272, 'CkMailMan_FetchUidls'))
    (objHandle, uidls);
end;

function CkMailMan_FetchUidlsAsync (objHandle: HCkMailMan; uidls: HCkStringTable): HCkTask;
begin
  result := TCkMailMan_FetchUidlsAsync(_map(273, 'CkMailMan_FetchUidlsAsync'))
    (objHandle, uidls);
end;

function CkMailMan_FetchUidlSet (objHandle: HCkMailMan; uidls: HCkStringTable; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkMailMan_FetchUidlSet(_map(274, 'CkMailMan_FetchUidlSet'))
    (objHandle, uidls, headersOnly, numBodyLines, bundle);
end;

function CkMailMan_FetchUidlSetAsync (objHandle: HCkMailMan; uidls: HCkStringTable; headersOnly: wordbool; numBodyLines: Integer; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkMailMan_FetchUidlSetAsync(_map(275, 'CkMailMan_FetchUidlSetAsync'))
    (objHandle, uidls, headersOnly, numBodyLines, bundle);
end;

function CkMailMan_GetAllHeaders (objHandle: HCkMailMan; numBodyLines: Integer): HCkEmailBundle;
begin
  result := TCkMailMan_GetAllHeaders(_map(276, 'CkMailMan_GetAllHeaders'))
    (objHandle, numBodyLines);
end;

function CkMailMan_GetAllHeadersAsync (objHandle: HCkMailMan; numBodyLines: Integer): HCkTask;
begin
  result := TCkMailMan_GetAllHeadersAsync(_map(277, 'CkMailMan_GetAllHeadersAsync'))
    (objHandle, numBodyLines);
end;

function CkMailMan_GetBadEmailAddrs (objHandle: HCkMailMan): HCkStringArray;
begin
  result := TCkMailMan_GetBadEmailAddrs(_map(278, 'CkMailMan_GetBadEmailAddrs'))
    (objHandle);
end;

function CkMailMan_GetFullEmail (objHandle: HCkMailMan; email: HCkEmail): HCkEmail;
begin
  result := TCkMailMan_GetFullEmail(_map(279, 'CkMailMan_GetFullEmail'))
    (objHandle, email);
end;

function CkMailMan_GetFullEmailAsync (objHandle: HCkMailMan; email: HCkEmail): HCkTask;
begin
  result := TCkMailMan_GetFullEmailAsync(_map(280, 'CkMailMan_GetFullEmailAsync'))
    (objHandle, email);
end;

function CkMailMan_GetHeaders (objHandle: HCkMailMan; numBodyLines: Integer; fromIndex: Integer; toIndex: Integer): HCkEmailBundle;
begin
  result := TCkMailMan_GetHeaders(_map(281, 'CkMailMan_GetHeaders'))
    (objHandle, numBodyLines, fromIndex, toIndex);
end;

function CkMailMan_GetHeadersAsync (objHandle: HCkMailMan; numBodyLines: Integer; fromIndex: Integer; toIndex: Integer): HCkTask;
begin
  result := TCkMailMan_GetHeadersAsync(_map(282, 'CkMailMan_GetHeadersAsync'))
    (objHandle, numBodyLines, fromIndex, toIndex);
end;

procedure CkMailMan_GetLastJsonData (objHandle: HCkMailMan; json: HCkJsonObject);
begin
  TCkMailMan_GetLastJsonData(_map(283, 'CkMailMan_GetLastJsonData'))
    (objHandle, json);
end;

function CkMailMan_GetMailboxCount (objHandle: HCkMailMan): Integer;
begin
  result := TCkMailMan_GetMailboxCount(_map(284, 'CkMailMan_GetMailboxCount'))
    (objHandle);
end;

function CkMailMan_GetMailboxCountAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_GetMailboxCountAsync(_map(285, 'CkMailMan_GetMailboxCountAsync'))
    (objHandle);
end;

function CkMailMan_GetMailboxInfoXml (objHandle: HCkMailMan; outStr: HCkString): wordbool;
begin
  result := TCkMailMan_GetMailboxInfoXml(_map(286, 'CkMailMan_GetMailboxInfoXml'))
    (objHandle, outStr);
end;

function CkMailMan__getMailboxInfoXml (objHandle: HCkMailMan): PWideChar;
begin
  result := TCkMailMan__getMailboxInfoXml(_map(287, 'CkMailMan__getMailboxInfoXml'))
    (objHandle);
end;

function CkMailMan_GetMailboxInfoXmlAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_GetMailboxInfoXmlAsync(_map(288, 'CkMailMan_GetMailboxInfoXmlAsync'))
    (objHandle);
end;

function CkMailMan_GetMailboxSize (objHandle: HCkMailMan): LongWord;
begin
  result := TCkMailMan_GetMailboxSize(_map(289, 'CkMailMan_GetMailboxSize'))
    (objHandle);
end;

function CkMailMan_GetMailboxSizeAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_GetMailboxSizeAsync(_map(290, 'CkMailMan_GetMailboxSizeAsync'))
    (objHandle);
end;

function CkMailMan_GetPop3SslServerCert (objHandle: HCkMailMan): HCkCert;
begin
  result := TCkMailMan_GetPop3SslServerCert(_map(291, 'CkMailMan_GetPop3SslServerCert'))
    (objHandle);
end;

function CkMailMan_GetSentToEmailAddrs (objHandle: HCkMailMan): HCkStringArray;
begin
  result := TCkMailMan_GetSentToEmailAddrs(_map(292, 'CkMailMan_GetSentToEmailAddrs'))
    (objHandle);
end;

function CkMailMan_GetServerCert (objHandle: HCkMailMan; useSmtp: wordbool; cert: HCkCert): wordbool;
begin
  result := TCkMailMan_GetServerCert(_map(293, 'CkMailMan_GetServerCert'))
    (objHandle, useSmtp, cert);
end;

function CkMailMan_GetSizeByUidl (objHandle: HCkMailMan; uidl: PWideChar): Integer;
begin
  result := TCkMailMan_GetSizeByUidl(_map(294, 'CkMailMan_GetSizeByUidl'))
    (objHandle, uidl);
end;

function CkMailMan_GetSizeByUidlAsync (objHandle: HCkMailMan; uidl: PWideChar): HCkTask;
begin
  result := TCkMailMan_GetSizeByUidlAsync(_map(295, 'CkMailMan_GetSizeByUidlAsync'))
    (objHandle, uidl);
end;

function CkMailMan_GetSmtpSslServerCert (objHandle: HCkMailMan): HCkCert;
begin
  result := TCkMailMan_GetSmtpSslServerCert(_map(296, 'CkMailMan_GetSmtpSslServerCert'))
    (objHandle);
end;

function CkMailMan_GetUidls (objHandle: HCkMailMan): HCkStringArray;
begin
  result := TCkMailMan_GetUidls(_map(297, 'CkMailMan_GetUidls'))
    (objHandle);
end;

function CkMailMan_GetUidlsAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_GetUidlsAsync(_map(298, 'CkMailMan_GetUidlsAsync'))
    (objHandle);
end;

function CkMailMan_IsSmtpDsnCapable (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_IsSmtpDsnCapable(_map(299, 'CkMailMan_IsSmtpDsnCapable'))
    (objHandle);
end;

function CkMailMan_IsSmtpDsnCapableAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_IsSmtpDsnCapableAsync(_map(300, 'CkMailMan_IsSmtpDsnCapableAsync'))
    (objHandle);
end;

function CkMailMan_LastJsonData (objHandle: HCkMailMan): HCkJsonObject;
begin
  result := TCkMailMan_LastJsonData(_map(301, 'CkMailMan_LastJsonData'))
    (objHandle);
end;

function CkMailMan_LoadEml (objHandle: HCkMailMan; emlFilename: PWideChar): HCkEmail;
begin
  result := TCkMailMan_LoadEml(_map(302, 'CkMailMan_LoadEml'))
    (objHandle, emlFilename);
end;

function CkMailMan_LoadMbx (objHandle: HCkMailMan; mbxFileName: PWideChar): HCkEmailBundle;
begin
  result := TCkMailMan_LoadMbx(_map(303, 'CkMailMan_LoadMbx'))
    (objHandle, mbxFileName);
end;

function CkMailMan_LoadMbxFile (objHandle: HCkMailMan; mbxPath: PWideChar; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkMailMan_LoadMbxFile(_map(304, 'CkMailMan_LoadMbxFile'))
    (objHandle, mbxPath, bundle);
end;

function CkMailMan_LoadMime (objHandle: HCkMailMan; mimeText: PWideChar): HCkEmail;
begin
  result := TCkMailMan_LoadMime(_map(305, 'CkMailMan_LoadMime'))
    (objHandle, mimeText);
end;

function CkMailMan_LoadTaskCaller (objHandle: HCkMailMan; task: HCkTask): wordbool;
begin
  result := TCkMailMan_LoadTaskCaller(_map(306, 'CkMailMan_LoadTaskCaller'))
    (objHandle, task);
end;

function CkMailMan_LoadXmlEmail (objHandle: HCkMailMan; filename: PWideChar): HCkEmail;
begin
  result := TCkMailMan_LoadXmlEmail(_map(307, 'CkMailMan_LoadXmlEmail'))
    (objHandle, filename);
end;

function CkMailMan_LoadXmlEmailString (objHandle: HCkMailMan; xmlString: PWideChar): HCkEmail;
begin
  result := TCkMailMan_LoadXmlEmailString(_map(308, 'CkMailMan_LoadXmlEmailString'))
    (objHandle, xmlString);
end;

function CkMailMan_LoadXmlFile (objHandle: HCkMailMan; filename: PWideChar): HCkEmailBundle;
begin
  result := TCkMailMan_LoadXmlFile(_map(309, 'CkMailMan_LoadXmlFile'))
    (objHandle, filename);
end;

function CkMailMan_LoadXmlString (objHandle: HCkMailMan; xmlString: PWideChar): HCkEmailBundle;
begin
  result := TCkMailMan_LoadXmlString(_map(310, 'CkMailMan_LoadXmlString'))
    (objHandle, xmlString);
end;

function CkMailMan_MxLookup (objHandle: HCkMailMan; emailAddress: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMailMan_MxLookup(_map(311, 'CkMailMan_MxLookup'))
    (objHandle, emailAddress, outStr);
end;

function CkMailMan__mxLookup (objHandle: HCkMailMan; emailAddress: PWideChar): PWideChar;
begin
  result := TCkMailMan__mxLookup(_map(312, 'CkMailMan__mxLookup'))
    (objHandle, emailAddress);
end;

function CkMailMan_MxLookupAll (objHandle: HCkMailMan; emailAddress: PWideChar): HCkStringArray;
begin
  result := TCkMailMan_MxLookupAll(_map(313, 'CkMailMan_MxLookupAll'))
    (objHandle, emailAddress);
end;

function CkMailMan_OpenSmtpConnection (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_OpenSmtpConnection(_map(314, 'CkMailMan_OpenSmtpConnection'))
    (objHandle);
end;

function CkMailMan_OpenSmtpConnectionAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_OpenSmtpConnectionAsync(_map(315, 'CkMailMan_OpenSmtpConnectionAsync'))
    (objHandle);
end;

function CkMailMan_Pop3Authenticate (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3Authenticate(_map(316, 'CkMailMan_Pop3Authenticate'))
    (objHandle);
end;

function CkMailMan_Pop3AuthenticateAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3AuthenticateAsync(_map(317, 'CkMailMan_Pop3AuthenticateAsync'))
    (objHandle);
end;

function CkMailMan_Pop3BeginSession (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3BeginSession(_map(318, 'CkMailMan_Pop3BeginSession'))
    (objHandle);
end;

function CkMailMan_Pop3BeginSessionAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3BeginSessionAsync(_map(319, 'CkMailMan_Pop3BeginSessionAsync'))
    (objHandle);
end;

function CkMailMan_Pop3Connect (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3Connect(_map(320, 'CkMailMan_Pop3Connect'))
    (objHandle);
end;

function CkMailMan_Pop3ConnectAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3ConnectAsync(_map(321, 'CkMailMan_Pop3ConnectAsync'))
    (objHandle);
end;

function CkMailMan_Pop3EndSession (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3EndSession(_map(322, 'CkMailMan_Pop3EndSession'))
    (objHandle);
end;

function CkMailMan_Pop3EndSessionAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3EndSessionAsync(_map(323, 'CkMailMan_Pop3EndSessionAsync'))
    (objHandle);
end;

function CkMailMan_Pop3EndSessionNoQuit (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3EndSessionNoQuit(_map(324, 'CkMailMan_Pop3EndSessionNoQuit'))
    (objHandle);
end;

function CkMailMan_Pop3EndSessionNoQuitAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3EndSessionNoQuitAsync(_map(325, 'CkMailMan_Pop3EndSessionNoQuitAsync'))
    (objHandle);
end;

function CkMailMan_Pop3Noop (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3Noop(_map(326, 'CkMailMan_Pop3Noop'))
    (objHandle);
end;

function CkMailMan_Pop3NoopAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3NoopAsync(_map(327, 'CkMailMan_Pop3NoopAsync'))
    (objHandle);
end;

function CkMailMan_Pop3Reset (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_Pop3Reset(_map(328, 'CkMailMan_Pop3Reset'))
    (objHandle);
end;

function CkMailMan_Pop3ResetAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_Pop3ResetAsync(_map(329, 'CkMailMan_Pop3ResetAsync'))
    (objHandle);
end;

function CkMailMan_Pop3SendRawCommand (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMailMan_Pop3SendRawCommand(_map(330, 'CkMailMan_Pop3SendRawCommand'))
    (objHandle, command, charset, outStr);
end;

function CkMailMan__pop3SendRawCommand (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkMailMan__pop3SendRawCommand(_map(331, 'CkMailMan__pop3SendRawCommand'))
    (objHandle, command, charset);
end;

function CkMailMan_Pop3SendRawCommandAsync (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkMailMan_Pop3SendRawCommandAsync(_map(332, 'CkMailMan_Pop3SendRawCommandAsync'))
    (objHandle, command, charset);
end;

function CkMailMan_QuickSend (objHandle: HCkMailMan; fromAddr: PWideChar; toAddr: PWideChar; subject: PWideChar; body: PWideChar; smtpServer: PWideChar): wordbool;
begin
  result := TCkMailMan_QuickSend(_map(333, 'CkMailMan_QuickSend'))
    (objHandle, fromAddr, toAddr, subject, body, smtpServer);
end;

function CkMailMan_QuickSendAsync (objHandle: HCkMailMan; fromAddr: PWideChar; toAddr: PWideChar; subject: PWideChar; body: PWideChar; smtpServer: PWideChar): HCkTask;
begin
  result := TCkMailMan_QuickSendAsync(_map(334, 'CkMailMan_QuickSendAsync'))
    (objHandle, fromAddr, toAddr, subject, body, smtpServer);
end;

function CkMailMan_RenderToMime (objHandle: HCkMailMan; email: HCkEmail; outStr: HCkString): wordbool;
begin
  result := TCkMailMan_RenderToMime(_map(335, 'CkMailMan_RenderToMime'))
    (objHandle, email, outStr);
end;

function CkMailMan__renderToMime (objHandle: HCkMailMan; email: HCkEmail): PWideChar;
begin
  result := TCkMailMan__renderToMime(_map(336, 'CkMailMan__renderToMime'))
    (objHandle, email);
end;

function CkMailMan_RenderToMimeBd (objHandle: HCkMailMan; email: HCkEmail; renderedMime: HCkBinData): wordbool;
begin
  result := TCkMailMan_RenderToMimeBd(_map(337, 'CkMailMan_RenderToMimeBd'))
    (objHandle, email, renderedMime);
end;

function CkMailMan_RenderToMimeBytes (objHandle: HCkMailMan; email: HCkEmail; outData: HCkByteData): wordbool;
begin
  result := TCkMailMan_RenderToMimeBytes(_map(338, 'CkMailMan_RenderToMimeBytes'))
    (objHandle, email, outData);
end;

function CkMailMan_RenderToMimeSb (objHandle: HCkMailMan; email: HCkEmail; renderedMime: HCkStringBuilder): wordbool;
begin
  result := TCkMailMan_RenderToMimeSb(_map(339, 'CkMailMan_RenderToMimeSb'))
    (objHandle, email, renderedMime);
end;

function CkMailMan_SendBundle (objHandle: HCkMailMan; bundle: HCkEmailBundle): wordbool;
begin
  result := TCkMailMan_SendBundle(_map(340, 'CkMailMan_SendBundle'))
    (objHandle, bundle);
end;

function CkMailMan_SendBundleAsync (objHandle: HCkMailMan; bundle: HCkEmailBundle): HCkTask;
begin
  result := TCkMailMan_SendBundleAsync(_map(341, 'CkMailMan_SendBundleAsync'))
    (objHandle, bundle);
end;

function CkMailMan_SendEmail (objHandle: HCkMailMan; email: HCkEmail): wordbool;
begin
  result := TCkMailMan_SendEmail(_map(342, 'CkMailMan_SendEmail'))
    (objHandle, email);
end;

function CkMailMan_SendEmailAsync (objHandle: HCkMailMan; email: HCkEmail): HCkTask;
begin
  result := TCkMailMan_SendEmailAsync(_map(343, 'CkMailMan_SendEmailAsync'))
    (objHandle, email);
end;

function CkMailMan_SendMime (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: PWideChar): wordbool;
begin
  result := TCkMailMan_SendMime(_map(344, 'CkMailMan_SendMime'))
    (objHandle, fromAddr, recipients, mimeSource);
end;

function CkMailMan_SendMimeAsync (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: PWideChar): HCkTask;
begin
  result := TCkMailMan_SendMimeAsync(_map(345, 'CkMailMan_SendMimeAsync'))
    (objHandle, fromAddr, recipients, mimeSource);
end;

function CkMailMan_SendMimeBd (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeData: HCkBinData): wordbool;
begin
  result := TCkMailMan_SendMimeBd(_map(346, 'CkMailMan_SendMimeBd'))
    (objHandle, fromAddr, recipients, mimeData);
end;

function CkMailMan_SendMimeBdAsync (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeData: HCkBinData): HCkTask;
begin
  result := TCkMailMan_SendMimeBdAsync(_map(347, 'CkMailMan_SendMimeBdAsync'))
    (objHandle, fromAddr, recipients, mimeData);
end;

function CkMailMan_SendMimeBytes (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: HCkByteData): wordbool;
begin
  result := TCkMailMan_SendMimeBytes(_map(348, 'CkMailMan_SendMimeBytes'))
    (objHandle, fromAddr, recipients, mimeSource);
end;

function CkMailMan_SendMimeBytesAsync (objHandle: HCkMailMan; fromAddr: PWideChar; recipients: PWideChar; mimeSource: HCkByteData): HCkTask;
begin
  result := TCkMailMan_SendMimeBytesAsync(_map(349, 'CkMailMan_SendMimeBytesAsync'))
    (objHandle, fromAddr, recipients, mimeSource);
end;

function CkMailMan_SendMimeToList (objHandle: HCkMailMan; fromAddr: PWideChar; distListFilename: PWideChar; mimeSource: PWideChar): wordbool;
begin
  result := TCkMailMan_SendMimeToList(_map(350, 'CkMailMan_SendMimeToList'))
    (objHandle, fromAddr, distListFilename, mimeSource);
end;

function CkMailMan_SendMimeToListAsync (objHandle: HCkMailMan; fromAddr: PWideChar; distListFilename: PWideChar; mimeSource: PWideChar): HCkTask;
begin
  result := TCkMailMan_SendMimeToListAsync(_map(351, 'CkMailMan_SendMimeToListAsync'))
    (objHandle, fromAddr, distListFilename, mimeSource);
end;

function CkMailMan_SetDecryptCert (objHandle: HCkMailMan; cert: HCkCert): wordbool;
begin
  result := TCkMailMan_SetDecryptCert(_map(352, 'CkMailMan_SetDecryptCert'))
    (objHandle, cert);
end;

function CkMailMan_SetDecryptCert2 (objHandle: HCkMailMan; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkMailMan_SetDecryptCert2(_map(353, 'CkMailMan_SetDecryptCert2'))
    (objHandle, cert, privateKey);
end;

function CkMailMan_SetPassword (objHandle: HCkMailMan; protocol: PWideChar; password: HCkSecureString): wordbool;
begin
  result := TCkMailMan_SetPassword(_map(354, 'CkMailMan_SetPassword'))
    (objHandle, protocol, password);
end;

function CkMailMan_SetSslClientCert (objHandle: HCkMailMan; cert: HCkCert): wordbool;
begin
  result := TCkMailMan_SetSslClientCert(_map(355, 'CkMailMan_SetSslClientCert'))
    (objHandle, cert);
end;

function CkMailMan_SetSslClientCertPem (objHandle: HCkMailMan; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
begin
  result := TCkMailMan_SetSslClientCertPem(_map(356, 'CkMailMan_SetSslClientCertPem'))
    (objHandle, pemDataOrFilename, pemPassword);
end;

function CkMailMan_SetSslClientCertPfx (objHandle: HCkMailMan; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkMailMan_SetSslClientCertPfx(_map(357, 'CkMailMan_SetSslClientCertPfx'))
    (objHandle, pfxFilename, pfxPassword);
end;

function CkMailMan_SmtpAuthenticate (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_SmtpAuthenticate(_map(358, 'CkMailMan_SmtpAuthenticate'))
    (objHandle);
end;

function CkMailMan_SmtpAuthenticateAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_SmtpAuthenticateAsync(_map(359, 'CkMailMan_SmtpAuthenticateAsync'))
    (objHandle);
end;

function CkMailMan_SmtpConnect (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_SmtpConnect(_map(360, 'CkMailMan_SmtpConnect'))
    (objHandle);
end;

function CkMailMan_SmtpConnectAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_SmtpConnectAsync(_map(361, 'CkMailMan_SmtpConnectAsync'))
    (objHandle);
end;

function CkMailMan_SmtpNoop (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_SmtpNoop(_map(362, 'CkMailMan_SmtpNoop'))
    (objHandle);
end;

function CkMailMan_SmtpNoopAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_SmtpNoopAsync(_map(363, 'CkMailMan_SmtpNoopAsync'))
    (objHandle);
end;

function CkMailMan_SmtpReset (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_SmtpReset(_map(364, 'CkMailMan_SmtpReset'))
    (objHandle);
end;

function CkMailMan_SmtpResetAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_SmtpResetAsync(_map(365, 'CkMailMan_SmtpResetAsync'))
    (objHandle);
end;

function CkMailMan_SmtpSendRawCommand (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkMailMan_SmtpSendRawCommand(_map(366, 'CkMailMan_SmtpSendRawCommand'))
    (objHandle, command, charset, bEncodeBase64, outStr);
end;

function CkMailMan__smtpSendRawCommand (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool): PWideChar;
begin
  result := TCkMailMan__smtpSendRawCommand(_map(367, 'CkMailMan__smtpSendRawCommand'))
    (objHandle, command, charset, bEncodeBase64);
end;

function CkMailMan_SmtpSendRawCommandAsync (objHandle: HCkMailMan; command: PWideChar; charset: PWideChar; bEncodeBase64: wordbool): HCkTask;
begin
  result := TCkMailMan_SmtpSendRawCommandAsync(_map(368, 'CkMailMan_SmtpSendRawCommandAsync'))
    (objHandle, command, charset, bEncodeBase64);
end;

function CkMailMan_SshAuthenticatePk (objHandle: HCkMailMan; sshLogin: PWideChar; sshUsername: HCkSshKey): wordbool;
begin
  result := TCkMailMan_SshAuthenticatePk(_map(369, 'CkMailMan_SshAuthenticatePk'))
    (objHandle, sshLogin, sshUsername);
end;

function CkMailMan_SshAuthenticatePkAsync (objHandle: HCkMailMan; sshLogin: PWideChar; sshUsername: HCkSshKey): HCkTask;
begin
  result := TCkMailMan_SshAuthenticatePkAsync(_map(370, 'CkMailMan_SshAuthenticatePkAsync'))
    (objHandle, sshLogin, sshUsername);
end;

function CkMailMan_SshAuthenticatePw (objHandle: HCkMailMan; sshLogin: PWideChar; sshPassword: PWideChar): wordbool;
begin
  result := TCkMailMan_SshAuthenticatePw(_map(371, 'CkMailMan_SshAuthenticatePw'))
    (objHandle, sshLogin, sshPassword);
end;

function CkMailMan_SshAuthenticatePwAsync (objHandle: HCkMailMan; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask;
begin
  result := TCkMailMan_SshAuthenticatePwAsync(_map(372, 'CkMailMan_SshAuthenticatePwAsync'))
    (objHandle, sshLogin, sshPassword);
end;

function CkMailMan_SshCloseTunnel (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_SshCloseTunnel(_map(373, 'CkMailMan_SshCloseTunnel'))
    (objHandle);
end;

function CkMailMan_SshCloseTunnelAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_SshCloseTunnelAsync(_map(374, 'CkMailMan_SshCloseTunnelAsync'))
    (objHandle);
end;

function CkMailMan_SshOpenTunnel (objHandle: HCkMailMan; sshHostname: PWideChar; sshPort: Integer): wordbool;
begin
  result := TCkMailMan_SshOpenTunnel(_map(375, 'CkMailMan_SshOpenTunnel'))
    (objHandle, sshHostname, sshPort);
end;

function CkMailMan_SshOpenTunnelAsync (objHandle: HCkMailMan; sshHostname: PWideChar; sshPort: Integer): HCkTask;
begin
  result := TCkMailMan_SshOpenTunnelAsync(_map(376, 'CkMailMan_SshOpenTunnelAsync'))
    (objHandle, sshHostname, sshPort);
end;

function CkMailMan_TransferMail (objHandle: HCkMailMan): HCkEmailBundle;
begin
  result := TCkMailMan_TransferMail(_map(377, 'CkMailMan_TransferMail'))
    (objHandle);
end;

function CkMailMan_TransferMailAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_TransferMailAsync(_map(378, 'CkMailMan_TransferMailAsync'))
    (objHandle);
end;

function CkMailMan_TransferMultipleMime (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkStringArray;
begin
  result := TCkMailMan_TransferMultipleMime(_map(379, 'CkMailMan_TransferMultipleMime'))
    (objHandle, uidlArray);
end;

function CkMailMan_TransferMultipleMimeAsync (objHandle: HCkMailMan; uidlArray: HCkStringArray): HCkTask;
begin
  result := TCkMailMan_TransferMultipleMimeAsync(_map(380, 'CkMailMan_TransferMultipleMimeAsync'))
    (objHandle, uidlArray);
end;

function CkMailMan_UseCertVault (objHandle: HCkMailMan; vault: HCkXmlCertVault): wordbool;
begin
  result := TCkMailMan_UseCertVault(_map(381, 'CkMailMan_UseCertVault'))
    (objHandle, vault);
end;

function CkMailMan_UseSsh (objHandle: HCkMailMan; ssh: HCkSsh): wordbool;
begin
  result := TCkMailMan_UseSsh(_map(382, 'CkMailMan_UseSsh'))
    (objHandle, ssh);
end;

function CkMailMan_UseSshTunnel (objHandle: HCkMailMan; tunnel: HCkSocket): wordbool;
begin
  result := TCkMailMan_UseSshTunnel(_map(383, 'CkMailMan_UseSshTunnel'))
    (objHandle, tunnel);
end;

function CkMailMan_VerifyPopConnection (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_VerifyPopConnection(_map(384, 'CkMailMan_VerifyPopConnection'))
    (objHandle);
end;

function CkMailMan_VerifyPopConnectionAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_VerifyPopConnectionAsync(_map(385, 'CkMailMan_VerifyPopConnectionAsync'))
    (objHandle);
end;

function CkMailMan_VerifyPopLogin (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_VerifyPopLogin(_map(386, 'CkMailMan_VerifyPopLogin'))
    (objHandle);
end;

function CkMailMan_VerifyPopLoginAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_VerifyPopLoginAsync(_map(387, 'CkMailMan_VerifyPopLoginAsync'))
    (objHandle);
end;

function CkMailMan_VerifyRecips (objHandle: HCkMailMan; email: HCkEmail; badAddrs: HCkStringArray): wordbool;
begin
  result := TCkMailMan_VerifyRecips(_map(388, 'CkMailMan_VerifyRecips'))
    (objHandle, email, badAddrs);
end;

function CkMailMan_VerifyRecipsAsync (objHandle: HCkMailMan; email: HCkEmail; badAddrs: HCkStringArray): HCkTask;
begin
  result := TCkMailMan_VerifyRecipsAsync(_map(389, 'CkMailMan_VerifyRecipsAsync'))
    (objHandle, email, badAddrs);
end;

function CkMailMan_VerifySmtpConnection (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_VerifySmtpConnection(_map(390, 'CkMailMan_VerifySmtpConnection'))
    (objHandle);
end;

function CkMailMan_VerifySmtpConnectionAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_VerifySmtpConnectionAsync(_map(391, 'CkMailMan_VerifySmtpConnectionAsync'))
    (objHandle);
end;

function CkMailMan_VerifySmtpLogin (objHandle: HCkMailMan): wordbool;
begin
  result := TCkMailMan_VerifySmtpLogin(_map(392, 'CkMailMan_VerifySmtpLogin'))
    (objHandle);
end;

function CkMailMan_VerifySmtpLoginAsync (objHandle: HCkMailMan): HCkTask;
begin
  result := TCkMailMan_VerifySmtpLoginAsync(_map(393, 'CkMailMan_VerifySmtpLoginAsync'))
    (objHandle);
end;

end.
