unit Mailboxes;

interface

type

HCkTask = Pointer;
HCkMailboxes = Pointer;
HCkString = Pointer;


function CkMailboxes_Create: HCkMailboxes;  stdcall;
procedure CkMailboxes_Dispose(handle: HCkMailboxes); stdcall;
function CkMailboxes_getCount(objHandle: HCkMailboxes): Integer;
procedure CkMailboxes_getDebugLogFilePath(objHandle: HCkMailboxes; outPropVal: HCkString);
procedure CkMailboxes_putDebugLogFilePath(objHandle: HCkMailboxes; newPropVal: PWideChar);
function CkMailboxes__debugLogFilePath(objHandle: HCkMailboxes): PWideChar;
procedure CkMailboxes_getLastErrorHtml(objHandle: HCkMailboxes; outPropVal: HCkString);
function CkMailboxes__lastErrorHtml(objHandle: HCkMailboxes): PWideChar;
procedure CkMailboxes_getLastErrorText(objHandle: HCkMailboxes; outPropVal: HCkString);
function CkMailboxes__lastErrorText(objHandle: HCkMailboxes): PWideChar;
procedure CkMailboxes_getLastErrorXml(objHandle: HCkMailboxes; outPropVal: HCkString);
function CkMailboxes__lastErrorXml(objHandle: HCkMailboxes): PWideChar;
function CkMailboxes_getLastMethodSuccess(objHandle: HCkMailboxes): wordbool;
procedure CkMailboxes_putLastMethodSuccess(objHandle: HCkMailboxes; newPropVal: wordbool);
function CkMailboxes_getVerboseLogging(objHandle: HCkMailboxes): wordbool;
procedure CkMailboxes_putVerboseLogging(objHandle: HCkMailboxes; newPropVal: wordbool);
procedure CkMailboxes_getVersion(objHandle: HCkMailboxes; outPropVal: HCkString);
function CkMailboxes__version(objHandle: HCkMailboxes): PWideChar;
function CkMailboxes_GetFlags(objHandle: HCkMailboxes; index: Integer; outStr: HCkString): wordbool;
function CkMailboxes__getFlags(objHandle: HCkMailboxes; index: Integer): PWideChar;
function CkMailboxes_GetMailboxIndex(objHandle: HCkMailboxes; mbxName: PWideChar): Integer;
function CkMailboxes_GetName(objHandle: HCkMailboxes; index: Integer; outStr: HCkString): wordbool;
function CkMailboxes__getName(objHandle: HCkMailboxes; index: Integer): PWideChar;
function CkMailboxes_GetNthFlag(objHandle: HCkMailboxes; index: Integer; flagIndex: Integer; outStr: HCkString): wordbool;
function CkMailboxes__getNthFlag(objHandle: HCkMailboxes; index: Integer; flagIndex: Integer): PWideChar;
function CkMailboxes_GetNumFlags(objHandle: HCkMailboxes; index: Integer): Integer;
function CkMailboxes_HasFlag(objHandle: HCkMailboxes; index: Integer; flagName: PWideChar): wordbool;
function CkMailboxes_HasInferiors(objHandle: HCkMailboxes; index: Integer): wordbool;
function CkMailboxes_IsMarked(objHandle: HCkMailboxes; index: Integer): wordbool;
function CkMailboxes_IsSelectable(objHandle: HCkMailboxes; index: Integer): wordbool;
function CkMailboxes_LoadTaskResult(objHandle: HCkMailboxes; task: HCkTask): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkMailboxes_Create = function : HCkMailboxes; stdcall;
  TCkMailboxes_Dispose = procedure (handle: HCkMailboxes); stdcall;
  TCkMailboxes_getCount = function (objHandle: HCkMailboxes): Integer; stdcall;
  TCkMailboxes_getDebugLogFilePath = procedure (objHandle: HCkMailboxes; outPropVal: HCkString); stdcall;
  TCkMailboxes_putDebugLogFilePath = procedure (objHandle: HCkMailboxes; newPropVal: PWideChar); stdcall;
  TCkMailboxes__debugLogFilePath = function (objHandle: HCkMailboxes): PWideChar; stdcall;
  TCkMailboxes_getLastErrorHtml = procedure (objHandle: HCkMailboxes; outPropVal: HCkString); stdcall;
  TCkMailboxes__lastErrorHtml = function (objHandle: HCkMailboxes): PWideChar; stdcall;
  TCkMailboxes_getLastErrorText = procedure (objHandle: HCkMailboxes; outPropVal: HCkString); stdcall;
  TCkMailboxes__lastErrorText = function (objHandle: HCkMailboxes): PWideChar; stdcall;
  TCkMailboxes_getLastErrorXml = procedure (objHandle: HCkMailboxes; outPropVal: HCkString); stdcall;
  TCkMailboxes__lastErrorXml = function (objHandle: HCkMailboxes): PWideChar; stdcall;
  TCkMailboxes_getLastMethodSuccess = function (objHandle: HCkMailboxes): wordbool; stdcall;
  TCkMailboxes_putLastMethodSuccess = procedure (objHandle: HCkMailboxes; newPropVal: wordbool); stdcall;
  TCkMailboxes_getVerboseLogging = function (objHandle: HCkMailboxes): wordbool; stdcall;
  TCkMailboxes_putVerboseLogging = procedure (objHandle: HCkMailboxes; newPropVal: wordbool); stdcall;
  TCkMailboxes_getVersion = procedure (objHandle: HCkMailboxes; outPropVal: HCkString); stdcall;
  TCkMailboxes__version = function (objHandle: HCkMailboxes): PWideChar; stdcall;
  TCkMailboxes_GetFlags = function (objHandle: HCkMailboxes; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMailboxes__getFlags = function (objHandle: HCkMailboxes; index: Integer): PWideChar; stdcall;
  TCkMailboxes_GetMailboxIndex = function (objHandle: HCkMailboxes; mbxName: PWideChar): Integer; stdcall;
  TCkMailboxes_GetName = function (objHandle: HCkMailboxes; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMailboxes__getName = function (objHandle: HCkMailboxes; index: Integer): PWideChar; stdcall;
  TCkMailboxes_GetNthFlag = function (objHandle: HCkMailboxes; index: Integer; flagIndex: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMailboxes__getNthFlag = function (objHandle: HCkMailboxes; index: Integer; flagIndex: Integer): PWideChar; stdcall;
  TCkMailboxes_GetNumFlags = function (objHandle: HCkMailboxes; index: Integer): Integer; stdcall;
  TCkMailboxes_HasFlag = function (objHandle: HCkMailboxes; index: Integer; flagName: PWideChar): wordbool; stdcall;
  TCkMailboxes_HasInferiors = function (objHandle: HCkMailboxes; index: Integer): wordbool; stdcall;
  TCkMailboxes_IsMarked = function (objHandle: HCkMailboxes; index: Integer): wordbool; stdcall;
  TCkMailboxes_IsSelectable = function (objHandle: HCkMailboxes; index: Integer): wordbool; stdcall;
  TCkMailboxes_LoadTaskResult = function (objHandle: HCkMailboxes; task: HCkTask): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..30] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkMailboxes_Create : HCkMailboxes;
begin
  result := TCkMailboxes_Create(_map(0, 'CkMailboxes_Create'));
end;

procedure CkMailboxes_Dispose (handle: HCkMailboxes);
begin
  TCkMailboxes_Dispose(_map(1, 'CkMailboxes_Dispose'))
    (handle);
end;


function CkMailboxes_getCount (objHandle: HCkMailboxes): Integer;
begin
    result := TCkMailboxes_getCount(_map(2, 'CkMailboxes_getCount'))
    (objHandle);
end;

procedure CkMailboxes_getDebugLogFilePath (objHandle: HCkMailboxes; outPropVal: HCkString);
begin
  TCkMailboxes_getDebugLogFilePath(_map(3, 'CkMailboxes_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkMailboxes_putDebugLogFilePath (objHandle: HCkMailboxes; newPropVal: PWideChar);
begin
  TCkMailboxes_putDebugLogFilePath(_map(4, 'CkMailboxes_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkMailboxes__debugLogFilePath (objHandle: HCkMailboxes): PWideChar;
begin
  result := TCkMailboxes__debugLogFilePath(_map(5, 'CkMailboxes__debugLogFilePath'))
    (objHandle);
end;

procedure CkMailboxes_getLastErrorHtml (objHandle: HCkMailboxes; outPropVal: HCkString);
begin
  TCkMailboxes_getLastErrorHtml(_map(6, 'CkMailboxes_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkMailboxes__lastErrorHtml (objHandle: HCkMailboxes): PWideChar;
begin
  result := TCkMailboxes__lastErrorHtml(_map(7, 'CkMailboxes__lastErrorHtml'))
    (objHandle);
end;

procedure CkMailboxes_getLastErrorText (objHandle: HCkMailboxes; outPropVal: HCkString);
begin
  TCkMailboxes_getLastErrorText(_map(8, 'CkMailboxes_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkMailboxes__lastErrorText (objHandle: HCkMailboxes): PWideChar;
begin
  result := TCkMailboxes__lastErrorText(_map(9, 'CkMailboxes__lastErrorText'))
    (objHandle);
end;

procedure CkMailboxes_getLastErrorXml (objHandle: HCkMailboxes; outPropVal: HCkString);
begin
  TCkMailboxes_getLastErrorXml(_map(10, 'CkMailboxes_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkMailboxes__lastErrorXml (objHandle: HCkMailboxes): PWideChar;
begin
  result := TCkMailboxes__lastErrorXml(_map(11, 'CkMailboxes__lastErrorXml'))
    (objHandle);
end;

function CkMailboxes_getLastMethodSuccess (objHandle: HCkMailboxes): wordbool;
begin
    result := TCkMailboxes_getLastMethodSuccess(_map(12, 'CkMailboxes_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkMailboxes_putLastMethodSuccess (objHandle: HCkMailboxes; newPropVal: wordbool);
begin
  TCkMailboxes_putLastMethodSuccess(_map(13, 'CkMailboxes_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkMailboxes_getVerboseLogging (objHandle: HCkMailboxes): wordbool;
begin
    result := TCkMailboxes_getVerboseLogging(_map(14, 'CkMailboxes_getVerboseLogging'))
    (objHandle);
end;

procedure CkMailboxes_putVerboseLogging (objHandle: HCkMailboxes; newPropVal: wordbool);
begin
  TCkMailboxes_putVerboseLogging(_map(15, 'CkMailboxes_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkMailboxes_getVersion (objHandle: HCkMailboxes; outPropVal: HCkString);
begin
  TCkMailboxes_getVersion(_map(16, 'CkMailboxes_getVersion'))
    (objHandle, outPropVal);
end;

function CkMailboxes__version (objHandle: HCkMailboxes): PWideChar;
begin
  result := TCkMailboxes__version(_map(17, 'CkMailboxes__version'))
    (objHandle);
end;

function CkMailboxes_GetFlags (objHandle: HCkMailboxes; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMailboxes_GetFlags(_map(18, 'CkMailboxes_GetFlags'))
    (objHandle, index, outStr);
end;

function CkMailboxes__getFlags (objHandle: HCkMailboxes; index: Integer): PWideChar;
begin
  result := TCkMailboxes__getFlags(_map(19, 'CkMailboxes__getFlags'))
    (objHandle, index);
end;

function CkMailboxes_GetMailboxIndex (objHandle: HCkMailboxes; mbxName: PWideChar): Integer;
begin
  result := TCkMailboxes_GetMailboxIndex(_map(20, 'CkMailboxes_GetMailboxIndex'))
    (objHandle, mbxName);
end;

function CkMailboxes_GetName (objHandle: HCkMailboxes; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMailboxes_GetName(_map(21, 'CkMailboxes_GetName'))
    (objHandle, index, outStr);
end;

function CkMailboxes__getName (objHandle: HCkMailboxes; index: Integer): PWideChar;
begin
  result := TCkMailboxes__getName(_map(22, 'CkMailboxes__getName'))
    (objHandle, index);
end;

function CkMailboxes_GetNthFlag (objHandle: HCkMailboxes; index: Integer; flagIndex: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMailboxes_GetNthFlag(_map(23, 'CkMailboxes_GetNthFlag'))
    (objHandle, index, flagIndex, outStr);
end;

function CkMailboxes__getNthFlag (objHandle: HCkMailboxes; index: Integer; flagIndex: Integer): PWideChar;
begin
  result := TCkMailboxes__getNthFlag(_map(24, 'CkMailboxes__getNthFlag'))
    (objHandle, index, flagIndex);
end;

function CkMailboxes_GetNumFlags (objHandle: HCkMailboxes; index: Integer): Integer;
begin
  result := TCkMailboxes_GetNumFlags(_map(25, 'CkMailboxes_GetNumFlags'))
    (objHandle, index);
end;

function CkMailboxes_HasFlag (objHandle: HCkMailboxes; index: Integer; flagName: PWideChar): wordbool;
begin
  result := TCkMailboxes_HasFlag(_map(26, 'CkMailboxes_HasFlag'))
    (objHandle, index, flagName);
end;

function CkMailboxes_HasInferiors (objHandle: HCkMailboxes; index: Integer): wordbool;
begin
  result := TCkMailboxes_HasInferiors(_map(27, 'CkMailboxes_HasInferiors'))
    (objHandle, index);
end;

function CkMailboxes_IsMarked (objHandle: HCkMailboxes; index: Integer): wordbool;
begin
  result := TCkMailboxes_IsMarked(_map(28, 'CkMailboxes_IsMarked'))
    (objHandle, index);
end;

function CkMailboxes_IsSelectable (objHandle: HCkMailboxes; index: Integer): wordbool;
begin
  result := TCkMailboxes_IsSelectable(_map(29, 'CkMailboxes_IsSelectable'))
    (objHandle, index);
end;

function CkMailboxes_LoadTaskResult (objHandle: HCkMailboxes; task: HCkTask): wordbool;
begin
  result := TCkMailboxes_LoadTaskResult(_map(30, 'CkMailboxes_LoadTaskResult'))
    (objHandle, task);
end;

end.
