unit MessageSet;

interface

type

HCkTask = Pointer;
HCkMessageSet = Pointer;
HCkString = Pointer;


function CkMessageSet_Create: HCkMessageSet;  stdcall;
procedure CkMessageSet_Dispose(handle: HCkMessageSet); stdcall;
function CkMessageSet_getCount(objHandle: HCkMessageSet): Integer;
procedure CkMessageSet_getDebugLogFilePath(objHandle: HCkMessageSet; outPropVal: HCkString);
procedure CkMessageSet_putDebugLogFilePath(objHandle: HCkMessageSet; newPropVal: PWideChar);
function CkMessageSet__debugLogFilePath(objHandle: HCkMessageSet): PWideChar;
function CkMessageSet_getHasUids(objHandle: HCkMessageSet): wordbool;
procedure CkMessageSet_putHasUids(objHandle: HCkMessageSet; newPropVal: wordbool);
procedure CkMessageSet_getLastErrorHtml(objHandle: HCkMessageSet; outPropVal: HCkString);
function CkMessageSet__lastErrorHtml(objHandle: HCkMessageSet): PWideChar;
procedure CkMessageSet_getLastErrorText(objHandle: HCkMessageSet; outPropVal: HCkString);
function CkMessageSet__lastErrorText(objHandle: HCkMessageSet): PWideChar;
procedure CkMessageSet_getLastErrorXml(objHandle: HCkMessageSet; outPropVal: HCkString);
function CkMessageSet__lastErrorXml(objHandle: HCkMessageSet): PWideChar;
function CkMessageSet_getLastMethodSuccess(objHandle: HCkMessageSet): wordbool;
procedure CkMessageSet_putLastMethodSuccess(objHandle: HCkMessageSet; newPropVal: wordbool);
function CkMessageSet_getVerboseLogging(objHandle: HCkMessageSet): wordbool;
procedure CkMessageSet_putVerboseLogging(objHandle: HCkMessageSet; newPropVal: wordbool);
procedure CkMessageSet_getVersion(objHandle: HCkMessageSet; outPropVal: HCkString);
function CkMessageSet__version(objHandle: HCkMessageSet): PWideChar;
function CkMessageSet_ContainsId(objHandle: HCkMessageSet; msgId: LongWord): wordbool;
function CkMessageSet_FromCompactString(objHandle: HCkMessageSet; str: PWideChar): wordbool;
function CkMessageSet_GetId(objHandle: HCkMessageSet; index: Integer): LongWord;
procedure CkMessageSet_InsertId(objHandle: HCkMessageSet; id: LongWord);
function CkMessageSet_LoadTaskResult(objHandle: HCkMessageSet; task: HCkTask): wordbool;
procedure CkMessageSet_RemoveId(objHandle: HCkMessageSet; id: LongWord);
procedure CkMessageSet_Subtract(objHandle: HCkMessageSet; msgSet: HCkMessageSet);
function CkMessageSet_ToCommaSeparatedStr(objHandle: HCkMessageSet; outStr: HCkString): wordbool;
function CkMessageSet__toCommaSeparatedStr(objHandle: HCkMessageSet): PWideChar;
function CkMessageSet_ToCompactString(objHandle: HCkMessageSet; outStr: HCkString): wordbool;
function CkMessageSet__toCompactString(objHandle: HCkMessageSet): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkMessageSet_Create = function : HCkMessageSet; stdcall;
  TCkMessageSet_Dispose = procedure (handle: HCkMessageSet); stdcall;
  TCkMessageSet_getCount = function (objHandle: HCkMessageSet): Integer; stdcall;
  TCkMessageSet_getDebugLogFilePath = procedure (objHandle: HCkMessageSet; outPropVal: HCkString); stdcall;
  TCkMessageSet_putDebugLogFilePath = procedure (objHandle: HCkMessageSet; newPropVal: PWideChar); stdcall;
  TCkMessageSet__debugLogFilePath = function (objHandle: HCkMessageSet): PWideChar; stdcall;
  TCkMessageSet_getHasUids = function (objHandle: HCkMessageSet): wordbool; stdcall;
  TCkMessageSet_putHasUids = procedure (objHandle: HCkMessageSet; newPropVal: wordbool); stdcall;
  TCkMessageSet_getLastErrorHtml = procedure (objHandle: HCkMessageSet; outPropVal: HCkString); stdcall;
  TCkMessageSet__lastErrorHtml = function (objHandle: HCkMessageSet): PWideChar; stdcall;
  TCkMessageSet_getLastErrorText = procedure (objHandle: HCkMessageSet; outPropVal: HCkString); stdcall;
  TCkMessageSet__lastErrorText = function (objHandle: HCkMessageSet): PWideChar; stdcall;
  TCkMessageSet_getLastErrorXml = procedure (objHandle: HCkMessageSet; outPropVal: HCkString); stdcall;
  TCkMessageSet__lastErrorXml = function (objHandle: HCkMessageSet): PWideChar; stdcall;
  TCkMessageSet_getLastMethodSuccess = function (objHandle: HCkMessageSet): wordbool; stdcall;
  TCkMessageSet_putLastMethodSuccess = procedure (objHandle: HCkMessageSet; newPropVal: wordbool); stdcall;
  TCkMessageSet_getVerboseLogging = function (objHandle: HCkMessageSet): wordbool; stdcall;
  TCkMessageSet_putVerboseLogging = procedure (objHandle: HCkMessageSet; newPropVal: wordbool); stdcall;
  TCkMessageSet_getVersion = procedure (objHandle: HCkMessageSet; outPropVal: HCkString); stdcall;
  TCkMessageSet__version = function (objHandle: HCkMessageSet): PWideChar; stdcall;
  TCkMessageSet_ContainsId = function (objHandle: HCkMessageSet; msgId: LongWord): wordbool; stdcall;
  TCkMessageSet_FromCompactString = function (objHandle: HCkMessageSet; str: PWideChar): wordbool; stdcall;
  TCkMessageSet_GetId = function (objHandle: HCkMessageSet; index: Integer): LongWord; stdcall;
  TCkMessageSet_InsertId = procedure (objHandle: HCkMessageSet; id: LongWord); stdcall;
  TCkMessageSet_LoadTaskResult = function (objHandle: HCkMessageSet; task: HCkTask): wordbool; stdcall;
  TCkMessageSet_RemoveId = procedure (objHandle: HCkMessageSet; id: LongWord); stdcall;
  TCkMessageSet_Subtract = procedure (objHandle: HCkMessageSet; msgSet: HCkMessageSet); stdcall;
  TCkMessageSet_ToCommaSeparatedStr = function (objHandle: HCkMessageSet; outStr: HCkString): wordbool; stdcall;
  TCkMessageSet__toCommaSeparatedStr = function (objHandle: HCkMessageSet): PWideChar; stdcall;
  TCkMessageSet_ToCompactString = function (objHandle: HCkMessageSet; outStr: HCkString): wordbool; stdcall;
  TCkMessageSet__toCompactString = function (objHandle: HCkMessageSet): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..30] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkMessageSet_Create : HCkMessageSet;
begin
  result := TCkMessageSet_Create(_map(0, 'CkMessageSet_Create'));
end;

procedure CkMessageSet_Dispose (handle: HCkMessageSet);
begin
  TCkMessageSet_Dispose(_map(1, 'CkMessageSet_Dispose'))
    (handle);
end;


function CkMessageSet_getCount (objHandle: HCkMessageSet): Integer;
begin
    result := TCkMessageSet_getCount(_map(2, 'CkMessageSet_getCount'))
    (objHandle);
end;

procedure CkMessageSet_getDebugLogFilePath (objHandle: HCkMessageSet; outPropVal: HCkString);
begin
  TCkMessageSet_getDebugLogFilePath(_map(3, 'CkMessageSet_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkMessageSet_putDebugLogFilePath (objHandle: HCkMessageSet; newPropVal: PWideChar);
begin
  TCkMessageSet_putDebugLogFilePath(_map(4, 'CkMessageSet_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkMessageSet__debugLogFilePath (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__debugLogFilePath(_map(5, 'CkMessageSet__debugLogFilePath'))
    (objHandle);
end;

function CkMessageSet_getHasUids (objHandle: HCkMessageSet): wordbool;
begin
    result := TCkMessageSet_getHasUids(_map(6, 'CkMessageSet_getHasUids'))
    (objHandle);
end;

procedure CkMessageSet_putHasUids (objHandle: HCkMessageSet; newPropVal: wordbool);
begin
  TCkMessageSet_putHasUids(_map(7, 'CkMessageSet_putHasUids'))
    (objHandle, newPropVal);
end;

procedure CkMessageSet_getLastErrorHtml (objHandle: HCkMessageSet; outPropVal: HCkString);
begin
  TCkMessageSet_getLastErrorHtml(_map(8, 'CkMessageSet_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkMessageSet__lastErrorHtml (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__lastErrorHtml(_map(9, 'CkMessageSet__lastErrorHtml'))
    (objHandle);
end;

procedure CkMessageSet_getLastErrorText (objHandle: HCkMessageSet; outPropVal: HCkString);
begin
  TCkMessageSet_getLastErrorText(_map(10, 'CkMessageSet_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkMessageSet__lastErrorText (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__lastErrorText(_map(11, 'CkMessageSet__lastErrorText'))
    (objHandle);
end;

procedure CkMessageSet_getLastErrorXml (objHandle: HCkMessageSet; outPropVal: HCkString);
begin
  TCkMessageSet_getLastErrorXml(_map(12, 'CkMessageSet_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkMessageSet__lastErrorXml (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__lastErrorXml(_map(13, 'CkMessageSet__lastErrorXml'))
    (objHandle);
end;

function CkMessageSet_getLastMethodSuccess (objHandle: HCkMessageSet): wordbool;
begin
    result := TCkMessageSet_getLastMethodSuccess(_map(14, 'CkMessageSet_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkMessageSet_putLastMethodSuccess (objHandle: HCkMessageSet; newPropVal: wordbool);
begin
  TCkMessageSet_putLastMethodSuccess(_map(15, 'CkMessageSet_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkMessageSet_getVerboseLogging (objHandle: HCkMessageSet): wordbool;
begin
    result := TCkMessageSet_getVerboseLogging(_map(16, 'CkMessageSet_getVerboseLogging'))
    (objHandle);
end;

procedure CkMessageSet_putVerboseLogging (objHandle: HCkMessageSet; newPropVal: wordbool);
begin
  TCkMessageSet_putVerboseLogging(_map(17, 'CkMessageSet_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkMessageSet_getVersion (objHandle: HCkMessageSet; outPropVal: HCkString);
begin
  TCkMessageSet_getVersion(_map(18, 'CkMessageSet_getVersion'))
    (objHandle, outPropVal);
end;

function CkMessageSet__version (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__version(_map(19, 'CkMessageSet__version'))
    (objHandle);
end;

function CkMessageSet_ContainsId (objHandle: HCkMessageSet; msgId: LongWord): wordbool;
begin
  result := TCkMessageSet_ContainsId(_map(20, 'CkMessageSet_ContainsId'))
    (objHandle, msgId);
end;

function CkMessageSet_FromCompactString (objHandle: HCkMessageSet; str: PWideChar): wordbool;
begin
  result := TCkMessageSet_FromCompactString(_map(21, 'CkMessageSet_FromCompactString'))
    (objHandle, str);
end;

function CkMessageSet_GetId (objHandle: HCkMessageSet; index: Integer): LongWord;
begin
  result := TCkMessageSet_GetId(_map(22, 'CkMessageSet_GetId'))
    (objHandle, index);
end;

procedure CkMessageSet_InsertId (objHandle: HCkMessageSet; id: LongWord);
begin
  TCkMessageSet_InsertId(_map(23, 'CkMessageSet_InsertId'))
    (objHandle, id);
end;

function CkMessageSet_LoadTaskResult (objHandle: HCkMessageSet; task: HCkTask): wordbool;
begin
  result := TCkMessageSet_LoadTaskResult(_map(24, 'CkMessageSet_LoadTaskResult'))
    (objHandle, task);
end;

procedure CkMessageSet_RemoveId (objHandle: HCkMessageSet; id: LongWord);
begin
  TCkMessageSet_RemoveId(_map(25, 'CkMessageSet_RemoveId'))
    (objHandle, id);
end;

procedure CkMessageSet_Subtract (objHandle: HCkMessageSet; msgSet: HCkMessageSet);
begin
  TCkMessageSet_Subtract(_map(26, 'CkMessageSet_Subtract'))
    (objHandle, msgSet);
end;

function CkMessageSet_ToCommaSeparatedStr (objHandle: HCkMessageSet; outStr: HCkString): wordbool;
begin
  result := TCkMessageSet_ToCommaSeparatedStr(_map(27, 'CkMessageSet_ToCommaSeparatedStr'))
    (objHandle, outStr);
end;

function CkMessageSet__toCommaSeparatedStr (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__toCommaSeparatedStr(_map(28, 'CkMessageSet__toCommaSeparatedStr'))
    (objHandle);
end;

function CkMessageSet_ToCompactString (objHandle: HCkMessageSet; outStr: HCkString): wordbool;
begin
  result := TCkMessageSet_ToCompactString(_map(29, 'CkMessageSet_ToCompactString'))
    (objHandle, outStr);
end;

function CkMessageSet__toCompactString (objHandle: HCkMessageSet): PWideChar;
begin
  result := TCkMessageSet__toCompactString(_map(30, 'CkMessageSet__toCompactString'))
    (objHandle);
end;

end.
