unit Mht;

interface

type

HCkMht = Pointer;
HCkTask = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TMhtAbortCheck = function(): Integer; cdecl;
TMhtProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TMhtPercentDone = function(pctDone: Integer): Integer; cdecl;
TMhtTaskCompleted = procedure(task: HCkTask); cdecl;


function CkMht_Create: HCkMht;  stdcall;
procedure CkMht_Dispose(handle: HCkMht); stdcall;

procedure CkMht_SetAbortCheck(objHandle: HCkMht; fn: TMhtAbortCheck) stdcall;
procedure CkMht_SetProgressInfo(objHandle: HCkMht; fn: TMhtProgressInfo) stdcall;
procedure CkMht_SetPercentDone(objHandle: HCkMht; fn: TMhtPercentDone) stdcall;
procedure CkMht_SetTaskCompleted(objHandle: HCkMht; fn: TMhtTaskCompleted) stdcall;
function CkMht_getAbortCurrent(objHandle: HCkMht): wordbool;
procedure CkMht_putAbortCurrent(objHandle: HCkMht; newPropVal: wordbool);
procedure CkMht_getBaseUrl(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putBaseUrl(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__baseUrl(objHandle: HCkMht): PWideChar;
function CkMht_getConnectTimeout(objHandle: HCkMht): Integer;
procedure CkMht_putConnectTimeout(objHandle: HCkMht; newPropVal: Integer);
procedure CkMht_getDebugHtmlAfter(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putDebugHtmlAfter(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__debugHtmlAfter(objHandle: HCkMht): PWideChar;
procedure CkMht_getDebugHtmlBefore(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putDebugHtmlBefore(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__debugHtmlBefore(objHandle: HCkMht): PWideChar;
procedure CkMht_getDebugLogFilePath(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putDebugLogFilePath(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__debugLogFilePath(objHandle: HCkMht): PWideChar;
function CkMht_getEmbedImages(objHandle: HCkMht): wordbool;
procedure CkMht_putEmbedImages(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getEmbedLocalOnly(objHandle: HCkMht): wordbool;
procedure CkMht_putEmbedLocalOnly(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getFetchFromCache(objHandle: HCkMht): wordbool;
procedure CkMht_putFetchFromCache(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getHeartbeatMs(objHandle: HCkMht): Integer;
procedure CkMht_putHeartbeatMs(objHandle: HCkMht; newPropVal: Integer);
function CkMht_getIgnoreMustRevalidate(objHandle: HCkMht): wordbool;
procedure CkMht_putIgnoreMustRevalidate(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getIgnoreNoCache(objHandle: HCkMht): wordbool;
procedure CkMht_putIgnoreNoCache(objHandle: HCkMht; newPropVal: wordbool);
procedure CkMht_getLastErrorHtml(objHandle: HCkMht; outPropVal: HCkString);
function CkMht__lastErrorHtml(objHandle: HCkMht): PWideChar;
procedure CkMht_getLastErrorText(objHandle: HCkMht; outPropVal: HCkString);
function CkMht__lastErrorText(objHandle: HCkMht): PWideChar;
procedure CkMht_getLastErrorXml(objHandle: HCkMht; outPropVal: HCkString);
function CkMht__lastErrorXml(objHandle: HCkMht): PWideChar;
function CkMht_getLastMethodSuccess(objHandle: HCkMht): wordbool;
procedure CkMht_putLastMethodSuccess(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getNoScripts(objHandle: HCkMht): wordbool;
procedure CkMht_putNoScripts(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getNtlmAuth(objHandle: HCkMht): wordbool;
procedure CkMht_putNtlmAuth(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getNumCacheLevels(objHandle: HCkMht): Integer;
procedure CkMht_putNumCacheLevels(objHandle: HCkMht; newPropVal: Integer);
function CkMht_getNumCacheRoots(objHandle: HCkMht): Integer;
function CkMht_getPreferIpv6(objHandle: HCkMht): wordbool;
procedure CkMht_putPreferIpv6(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getPreferMHTScripts(objHandle: HCkMht): wordbool;
procedure CkMht_putPreferMHTScripts(objHandle: HCkMht; newPropVal: wordbool);
procedure CkMht_getProxy(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putProxy(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__proxy(objHandle: HCkMht): PWideChar;
procedure CkMht_getProxyLogin(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putProxyLogin(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__proxyLogin(objHandle: HCkMht): PWideChar;
procedure CkMht_getProxyPassword(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putProxyPassword(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__proxyPassword(objHandle: HCkMht): PWideChar;
function CkMht_getReadTimeout(objHandle: HCkMht): Integer;
procedure CkMht_putReadTimeout(objHandle: HCkMht; newPropVal: Integer);
function CkMht_getRequireSslCertVerify(objHandle: HCkMht): wordbool;
procedure CkMht_putRequireSslCertVerify(objHandle: HCkMht; newPropVal: wordbool);
procedure CkMht_getSocksHostname(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putSocksHostname(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__socksHostname(objHandle: HCkMht): PWideChar;
procedure CkMht_getSocksPassword(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putSocksPassword(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__socksPassword(objHandle: HCkMht): PWideChar;
function CkMht_getSocksPort(objHandle: HCkMht): Integer;
procedure CkMht_putSocksPort(objHandle: HCkMht; newPropVal: Integer);
procedure CkMht_getSocksUsername(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putSocksUsername(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__socksUsername(objHandle: HCkMht): PWideChar;
function CkMht_getSocksVersion(objHandle: HCkMht): Integer;
procedure CkMht_putSocksVersion(objHandle: HCkMht; newPropVal: Integer);
function CkMht_getUnpackDirect(objHandle: HCkMht): wordbool;
procedure CkMht_putUnpackDirect(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getUnpackUseRelPaths(objHandle: HCkMht): wordbool;
procedure CkMht_putUnpackUseRelPaths(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getUpdateCache(objHandle: HCkMht): wordbool;
procedure CkMht_putUpdateCache(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getUseCids(objHandle: HCkMht): wordbool;
procedure CkMht_putUseCids(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getUseFilename(objHandle: HCkMht): wordbool;
procedure CkMht_putUseFilename(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getUseIEProxy(objHandle: HCkMht): wordbool;
procedure CkMht_putUseIEProxy(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getUseInline(objHandle: HCkMht): wordbool;
procedure CkMht_putUseInline(objHandle: HCkMht; newPropVal: wordbool);
function CkMht_getVerboseLogging(objHandle: HCkMht): wordbool;
procedure CkMht_putVerboseLogging(objHandle: HCkMht; newPropVal: wordbool);
procedure CkMht_getVersion(objHandle: HCkMht; outPropVal: HCkString);
function CkMht__version(objHandle: HCkMht): PWideChar;
procedure CkMht_getWebSiteLogin(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putWebSiteLogin(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__webSiteLogin(objHandle: HCkMht): PWideChar;
procedure CkMht_getWebSiteLoginDomain(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putWebSiteLoginDomain(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__webSiteLoginDomain(objHandle: HCkMht): PWideChar;
procedure CkMht_getWebSitePassword(objHandle: HCkMht; outPropVal: HCkString);
procedure CkMht_putWebSitePassword(objHandle: HCkMht; newPropVal: PWideChar);
function CkMht__webSitePassword(objHandle: HCkMht): PWideChar;
procedure CkMht_AddCacheRoot(objHandle: HCkMht; dir: PWideChar);
procedure CkMht_AddCustomHeader(objHandle: HCkMht; name: PWideChar; value: PWideChar);
procedure CkMht_AddExternalStyleSheet(objHandle: HCkMht; url: PWideChar);
procedure CkMht_ClearCustomHeaders(objHandle: HCkMht);
procedure CkMht_ExcludeImagesMatching(objHandle: HCkMht; pattern: PWideChar);
function CkMht_GetAndSaveEML(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; emlPath: PWideChar): wordbool;
function CkMht_GetAndSaveEMLAsync(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; emlPath: PWideChar): HCkTask;
function CkMht_GetAndSaveMHT(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; mhtPath: PWideChar): wordbool;
function CkMht_GetAndSaveMHTAsync(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; mhtPath: PWideChar): HCkTask;
function CkMht_GetAndZipEML(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): wordbool;
function CkMht_GetAndZipEMLAsync(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): HCkTask;
function CkMht_GetAndZipMHT(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): wordbool;
function CkMht_GetAndZipMHTAsync(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): HCkTask;
function CkMht_GetCacheRoot(objHandle: HCkMht; index: Integer; outStr: HCkString): wordbool;
function CkMht__getCacheRoot(objHandle: HCkMht; index: Integer): PWideChar;
function CkMht_GetEML(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; outStr: HCkString): wordbool;
function CkMht__getEML(objHandle: HCkMht; url_or_htmlFilepath: PWideChar): PWideChar;
function CkMht_GetEMLAsync(objHandle: HCkMht; url_or_htmlFilepath: PWideChar): HCkTask;
function CkMht_GetMHT(objHandle: HCkMht; url_or_htmlFilepath: PWideChar; outStr: HCkString): wordbool;
function CkMht__getMHT(objHandle: HCkMht; url_or_htmlFilepath: PWideChar): PWideChar;
function CkMht_GetMHTAsync(objHandle: HCkMht; url_or_htmlFilepath: PWideChar): HCkTask;
function CkMht_HtmlToEML(objHandle: HCkMht; htmlText: PWideChar; outStr: HCkString): wordbool;
function CkMht__htmlToEML(objHandle: HCkMht; htmlText: PWideChar): PWideChar;
function CkMht_HtmlToEMLAsync(objHandle: HCkMht; htmlText: PWideChar): HCkTask;
function CkMht_HtmlToEMLFile(objHandle: HCkMht; html: PWideChar; emlFilename: PWideChar): wordbool;
function CkMht_HtmlToEMLFileAsync(objHandle: HCkMht; html: PWideChar; emlFilename: PWideChar): HCkTask;
function CkMht_HtmlToMHT(objHandle: HCkMht; htmlText: PWideChar; outStr: HCkString): wordbool;
function CkMht__htmlToMHT(objHandle: HCkMht; htmlText: PWideChar): PWideChar;
function CkMht_HtmlToMHTAsync(objHandle: HCkMht; htmlText: PWideChar): HCkTask;
function CkMht_HtmlToMHTFile(objHandle: HCkMht; html: PWideChar; mhtFilename: PWideChar): wordbool;
function CkMht_HtmlToMHTFileAsync(objHandle: HCkMht; html: PWideChar; mhtFilename: PWideChar): HCkTask;
function CkMht_LoadTaskCaller(objHandle: HCkMht; task: HCkTask): wordbool;
procedure CkMht_RemoveCustomHeader(objHandle: HCkMht; name: PWideChar);
procedure CkMht_RestoreDefaults(objHandle: HCkMht);
function CkMht_UnpackMHT(objHandle: HCkMht; mhtFilename: PWideChar; unpackDir: PWideChar; htmlFilename: PWideChar; partsSubDir: PWideChar): wordbool;
function CkMht_UnpackMHTString(objHandle: HCkMht; mhtString: PWideChar; unpackDir: PWideChar; htmlFilename: PWideChar; partsSubDir: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkMht_Create = function : HCkMht; stdcall;
  TCkMht_Dispose = procedure (handle: HCkMht); stdcall;
  TCkMht_SetAbortCheck = procedure (objHandle: HCkMht; fn: TMhtAbortCheck); stdcall;
  TCkMht_SetProgressInfo = procedure (objHandle: HCkMht; fn: TMhtProgressInfo); stdcall;
  TCkMht_SetPercentDone = procedure (objHandle: HCkMht; fn: TMhtPercentDone); stdcall;
  TCkMht_SetTaskCompleted = procedure (objHandle: HCkMht; fn: TMhtTaskCompleted); stdcall;
  TCkMht_getAbortCurrent = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putAbortCurrent = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getBaseUrl = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putBaseUrl = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__baseUrl = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getConnectTimeout = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_putConnectTimeout = procedure (objHandle: HCkMht; newPropVal: Integer); stdcall;
  TCkMht_getDebugHtmlAfter = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putDebugHtmlAfter = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__debugHtmlAfter = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getDebugHtmlBefore = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putDebugHtmlBefore = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__debugHtmlBefore = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getDebugLogFilePath = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putDebugLogFilePath = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__debugLogFilePath = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getEmbedImages = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putEmbedImages = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getEmbedLocalOnly = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putEmbedLocalOnly = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getFetchFromCache = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putFetchFromCache = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getHeartbeatMs = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_putHeartbeatMs = procedure (objHandle: HCkMht; newPropVal: Integer); stdcall;
  TCkMht_getIgnoreMustRevalidate = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putIgnoreMustRevalidate = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getIgnoreNoCache = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putIgnoreNoCache = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getLastErrorHtml = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht__lastErrorHtml = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getLastErrorText = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht__lastErrorText = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getLastErrorXml = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht__lastErrorXml = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getLastMethodSuccess = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putLastMethodSuccess = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getNoScripts = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putNoScripts = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getNtlmAuth = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putNtlmAuth = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getNumCacheLevels = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_putNumCacheLevels = procedure (objHandle: HCkMht; newPropVal: Integer); stdcall;
  TCkMht_getNumCacheRoots = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_getPreferIpv6 = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putPreferIpv6 = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getPreferMHTScripts = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putPreferMHTScripts = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getProxy = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putProxy = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__proxy = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getProxyLogin = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putProxyLogin = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__proxyLogin = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getProxyPassword = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putProxyPassword = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__proxyPassword = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getReadTimeout = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_putReadTimeout = procedure (objHandle: HCkMht; newPropVal: Integer); stdcall;
  TCkMht_getRequireSslCertVerify = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putRequireSslCertVerify = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getSocksHostname = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putSocksHostname = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__socksHostname = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getSocksPassword = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putSocksPassword = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__socksPassword = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getSocksPort = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_putSocksPort = procedure (objHandle: HCkMht; newPropVal: Integer); stdcall;
  TCkMht_getSocksUsername = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putSocksUsername = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__socksUsername = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getSocksVersion = function (objHandle: HCkMht): Integer; stdcall;
  TCkMht_putSocksVersion = procedure (objHandle: HCkMht; newPropVal: Integer); stdcall;
  TCkMht_getUnpackDirect = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUnpackDirect = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getUnpackUseRelPaths = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUnpackUseRelPaths = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getUpdateCache = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUpdateCache = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getUseCids = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUseCids = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getUseFilename = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUseFilename = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getUseIEProxy = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUseIEProxy = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getUseInline = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putUseInline = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getVerboseLogging = function (objHandle: HCkMht): wordbool; stdcall;
  TCkMht_putVerboseLogging = procedure (objHandle: HCkMht; newPropVal: wordbool); stdcall;
  TCkMht_getVersion = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht__version = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getWebSiteLogin = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putWebSiteLogin = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__webSiteLogin = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getWebSiteLoginDomain = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putWebSiteLoginDomain = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__webSiteLoginDomain = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_getWebSitePassword = procedure (objHandle: HCkMht; outPropVal: HCkString); stdcall;
  TCkMht_putWebSitePassword = procedure (objHandle: HCkMht; newPropVal: PWideChar); stdcall;
  TCkMht__webSitePassword = function (objHandle: HCkMht): PWideChar; stdcall;
  TCkMht_AddCacheRoot = procedure (objHandle: HCkMht; dir: PWideChar); stdcall;
  TCkMht_AddCustomHeader = procedure (objHandle: HCkMht; name: PWideChar; value: PWideChar); stdcall;
  TCkMht_AddExternalStyleSheet = procedure (objHandle: HCkMht; url: PWideChar); stdcall;
  TCkMht_ClearCustomHeaders = procedure (objHandle: HCkMht); stdcall;
  TCkMht_ExcludeImagesMatching = procedure (objHandle: HCkMht; pattern: PWideChar); stdcall;
  TCkMht_GetAndSaveEML = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; emlPath: PWideChar): wordbool; stdcall;
  TCkMht_GetAndSaveEMLAsync = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; emlPath: PWideChar): HCkTask; stdcall;
  TCkMht_GetAndSaveMHT = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; mhtPath: PWideChar): wordbool; stdcall;
  TCkMht_GetAndSaveMHTAsync = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; mhtPath: PWideChar): HCkTask; stdcall;
  TCkMht_GetAndZipEML = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): wordbool; stdcall;
  TCkMht_GetAndZipEMLAsync = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): HCkTask; stdcall;
  TCkMht_GetAndZipMHT = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): wordbool; stdcall;
  TCkMht_GetAndZipMHTAsync = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): HCkTask; stdcall;
  TCkMht_GetCacheRoot = function (objHandle: HCkMht; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMht__getCacheRoot = function (objHandle: HCkMht; index: Integer): PWideChar; stdcall;
  TCkMht_GetEML = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMht__getEML = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): PWideChar; stdcall;
  TCkMht_GetEMLAsync = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): HCkTask; stdcall;
  TCkMht_GetMHT = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMht__getMHT = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): PWideChar; stdcall;
  TCkMht_GetMHTAsync = function (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): HCkTask; stdcall;
  TCkMht_HtmlToEML = function (objHandle: HCkMht; htmlText: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMht__htmlToEML = function (objHandle: HCkMht; htmlText: PWideChar): PWideChar; stdcall;
  TCkMht_HtmlToEMLAsync = function (objHandle: HCkMht; htmlText: PWideChar): HCkTask; stdcall;
  TCkMht_HtmlToEMLFile = function (objHandle: HCkMht; html: PWideChar; emlFilename: PWideChar): wordbool; stdcall;
  TCkMht_HtmlToEMLFileAsync = function (objHandle: HCkMht; html: PWideChar; emlFilename: PWideChar): HCkTask; stdcall;
  TCkMht_HtmlToMHT = function (objHandle: HCkMht; htmlText: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMht__htmlToMHT = function (objHandle: HCkMht; htmlText: PWideChar): PWideChar; stdcall;
  TCkMht_HtmlToMHTAsync = function (objHandle: HCkMht; htmlText: PWideChar): HCkTask; stdcall;
  TCkMht_HtmlToMHTFile = function (objHandle: HCkMht; html: PWideChar; mhtFilename: PWideChar): wordbool; stdcall;
  TCkMht_HtmlToMHTFileAsync = function (objHandle: HCkMht; html: PWideChar; mhtFilename: PWideChar): HCkTask; stdcall;
  TCkMht_LoadTaskCaller = function (objHandle: HCkMht; task: HCkTask): wordbool; stdcall;
  TCkMht_RemoveCustomHeader = procedure (objHandle: HCkMht; name: PWideChar); stdcall;
  TCkMht_RestoreDefaults = procedure (objHandle: HCkMht); stdcall;
  TCkMht_UnpackMHT = function (objHandle: HCkMht; mhtFilename: PWideChar; unpackDir: PWideChar; htmlFilename: PWideChar; partsSubDir: PWideChar): wordbool; stdcall;
  TCkMht_UnpackMHTString = function (objHandle: HCkMht; mhtString: PWideChar; unpackDir: PWideChar; htmlFilename: PWideChar; partsSubDir: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..141] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkMht_Create : HCkMht;
begin
  result := TCkMht_Create(_map(0, 'CkMht_Create'));
end;

procedure CkMht_Dispose (handle: HCkMht);
begin
  TCkMht_Dispose(_map(1, 'CkMht_Dispose'))
    (handle);
end;


procedure CkMht_SetAbortCheck (objHandle: HCkMht; fn: TMhtAbortCheck);
begin
    TCkMht_SetAbortCheck(_map(2, 'CkMht_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkMht_SetProgressInfo (objHandle: HCkMht; fn: TMhtProgressInfo);
begin
    TCkMht_SetProgressInfo(_map(3, 'CkMht_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkMht_SetPercentDone (objHandle: HCkMht; fn: TMhtPercentDone);
begin
    TCkMht_SetPercentDone(_map(4, 'CkMht_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkMht_SetTaskCompleted (objHandle: HCkMht; fn: TMhtTaskCompleted);
begin
    TCkMht_SetTaskCompleted(_map(5, 'CkMht_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkMht_getAbortCurrent (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getAbortCurrent(_map(6, 'CkMht_getAbortCurrent'))
    (objHandle);
end;

procedure CkMht_putAbortCurrent (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putAbortCurrent(_map(7, 'CkMht_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkMht_getBaseUrl (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getBaseUrl(_map(8, 'CkMht_getBaseUrl'))
    (objHandle, outPropVal);
end;

procedure CkMht_putBaseUrl (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putBaseUrl(_map(9, 'CkMht_putBaseUrl'))
    (objHandle, newPropVal);
end;

function CkMht__baseUrl (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__baseUrl(_map(10, 'CkMht__baseUrl'))
    (objHandle);
end;

function CkMht_getConnectTimeout (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getConnectTimeout(_map(11, 'CkMht_getConnectTimeout'))
    (objHandle);
end;

procedure CkMht_putConnectTimeout (objHandle: HCkMht; newPropVal: Integer);
begin
  TCkMht_putConnectTimeout(_map(12, 'CkMht_putConnectTimeout'))
    (objHandle, newPropVal);
end;

procedure CkMht_getDebugHtmlAfter (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getDebugHtmlAfter(_map(13, 'CkMht_getDebugHtmlAfter'))
    (objHandle, outPropVal);
end;

procedure CkMht_putDebugHtmlAfter (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putDebugHtmlAfter(_map(14, 'CkMht_putDebugHtmlAfter'))
    (objHandle, newPropVal);
end;

function CkMht__debugHtmlAfter (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__debugHtmlAfter(_map(15, 'CkMht__debugHtmlAfter'))
    (objHandle);
end;

procedure CkMht_getDebugHtmlBefore (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getDebugHtmlBefore(_map(16, 'CkMht_getDebugHtmlBefore'))
    (objHandle, outPropVal);
end;

procedure CkMht_putDebugHtmlBefore (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putDebugHtmlBefore(_map(17, 'CkMht_putDebugHtmlBefore'))
    (objHandle, newPropVal);
end;

function CkMht__debugHtmlBefore (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__debugHtmlBefore(_map(18, 'CkMht__debugHtmlBefore'))
    (objHandle);
end;

procedure CkMht_getDebugLogFilePath (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getDebugLogFilePath(_map(19, 'CkMht_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkMht_putDebugLogFilePath (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putDebugLogFilePath(_map(20, 'CkMht_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkMht__debugLogFilePath (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__debugLogFilePath(_map(21, 'CkMht__debugLogFilePath'))
    (objHandle);
end;

function CkMht_getEmbedImages (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getEmbedImages(_map(22, 'CkMht_getEmbedImages'))
    (objHandle);
end;

procedure CkMht_putEmbedImages (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putEmbedImages(_map(23, 'CkMht_putEmbedImages'))
    (objHandle, newPropVal);
end;

function CkMht_getEmbedLocalOnly (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getEmbedLocalOnly(_map(24, 'CkMht_getEmbedLocalOnly'))
    (objHandle);
end;

procedure CkMht_putEmbedLocalOnly (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putEmbedLocalOnly(_map(25, 'CkMht_putEmbedLocalOnly'))
    (objHandle, newPropVal);
end;

function CkMht_getFetchFromCache (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getFetchFromCache(_map(26, 'CkMht_getFetchFromCache'))
    (objHandle);
end;

procedure CkMht_putFetchFromCache (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putFetchFromCache(_map(27, 'CkMht_putFetchFromCache'))
    (objHandle, newPropVal);
end;

function CkMht_getHeartbeatMs (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getHeartbeatMs(_map(28, 'CkMht_getHeartbeatMs'))
    (objHandle);
end;

procedure CkMht_putHeartbeatMs (objHandle: HCkMht; newPropVal: Integer);
begin
  TCkMht_putHeartbeatMs(_map(29, 'CkMht_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkMht_getIgnoreMustRevalidate (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getIgnoreMustRevalidate(_map(30, 'CkMht_getIgnoreMustRevalidate'))
    (objHandle);
end;

procedure CkMht_putIgnoreMustRevalidate (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putIgnoreMustRevalidate(_map(31, 'CkMht_putIgnoreMustRevalidate'))
    (objHandle, newPropVal);
end;

function CkMht_getIgnoreNoCache (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getIgnoreNoCache(_map(32, 'CkMht_getIgnoreNoCache'))
    (objHandle);
end;

procedure CkMht_putIgnoreNoCache (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putIgnoreNoCache(_map(33, 'CkMht_putIgnoreNoCache'))
    (objHandle, newPropVal);
end;

procedure CkMht_getLastErrorHtml (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getLastErrorHtml(_map(34, 'CkMht_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkMht__lastErrorHtml (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__lastErrorHtml(_map(35, 'CkMht__lastErrorHtml'))
    (objHandle);
end;

procedure CkMht_getLastErrorText (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getLastErrorText(_map(36, 'CkMht_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkMht__lastErrorText (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__lastErrorText(_map(37, 'CkMht__lastErrorText'))
    (objHandle);
end;

procedure CkMht_getLastErrorXml (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getLastErrorXml(_map(38, 'CkMht_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkMht__lastErrorXml (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__lastErrorXml(_map(39, 'CkMht__lastErrorXml'))
    (objHandle);
end;

function CkMht_getLastMethodSuccess (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getLastMethodSuccess(_map(40, 'CkMht_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkMht_putLastMethodSuccess (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putLastMethodSuccess(_map(41, 'CkMht_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkMht_getNoScripts (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getNoScripts(_map(42, 'CkMht_getNoScripts'))
    (objHandle);
end;

procedure CkMht_putNoScripts (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putNoScripts(_map(43, 'CkMht_putNoScripts'))
    (objHandle, newPropVal);
end;

function CkMht_getNtlmAuth (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getNtlmAuth(_map(44, 'CkMht_getNtlmAuth'))
    (objHandle);
end;

procedure CkMht_putNtlmAuth (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putNtlmAuth(_map(45, 'CkMht_putNtlmAuth'))
    (objHandle, newPropVal);
end;

function CkMht_getNumCacheLevels (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getNumCacheLevels(_map(46, 'CkMht_getNumCacheLevels'))
    (objHandle);
end;

procedure CkMht_putNumCacheLevels (objHandle: HCkMht; newPropVal: Integer);
begin
  TCkMht_putNumCacheLevels(_map(47, 'CkMht_putNumCacheLevels'))
    (objHandle, newPropVal);
end;

function CkMht_getNumCacheRoots (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getNumCacheRoots(_map(48, 'CkMht_getNumCacheRoots'))
    (objHandle);
end;

function CkMht_getPreferIpv6 (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getPreferIpv6(_map(49, 'CkMht_getPreferIpv6'))
    (objHandle);
end;

procedure CkMht_putPreferIpv6 (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putPreferIpv6(_map(50, 'CkMht_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkMht_getPreferMHTScripts (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getPreferMHTScripts(_map(51, 'CkMht_getPreferMHTScripts'))
    (objHandle);
end;

procedure CkMht_putPreferMHTScripts (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putPreferMHTScripts(_map(52, 'CkMht_putPreferMHTScripts'))
    (objHandle, newPropVal);
end;

procedure CkMht_getProxy (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getProxy(_map(53, 'CkMht_getProxy'))
    (objHandle, outPropVal);
end;

procedure CkMht_putProxy (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putProxy(_map(54, 'CkMht_putProxy'))
    (objHandle, newPropVal);
end;

function CkMht__proxy (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__proxy(_map(55, 'CkMht__proxy'))
    (objHandle);
end;

procedure CkMht_getProxyLogin (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getProxyLogin(_map(56, 'CkMht_getProxyLogin'))
    (objHandle, outPropVal);
end;

procedure CkMht_putProxyLogin (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putProxyLogin(_map(57, 'CkMht_putProxyLogin'))
    (objHandle, newPropVal);
end;

function CkMht__proxyLogin (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__proxyLogin(_map(58, 'CkMht__proxyLogin'))
    (objHandle);
end;

procedure CkMht_getProxyPassword (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getProxyPassword(_map(59, 'CkMht_getProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkMht_putProxyPassword (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putProxyPassword(_map(60, 'CkMht_putProxyPassword'))
    (objHandle, newPropVal);
end;

function CkMht__proxyPassword (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__proxyPassword(_map(61, 'CkMht__proxyPassword'))
    (objHandle);
end;

function CkMht_getReadTimeout (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getReadTimeout(_map(62, 'CkMht_getReadTimeout'))
    (objHandle);
end;

procedure CkMht_putReadTimeout (objHandle: HCkMht; newPropVal: Integer);
begin
  TCkMht_putReadTimeout(_map(63, 'CkMht_putReadTimeout'))
    (objHandle, newPropVal);
end;

function CkMht_getRequireSslCertVerify (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getRequireSslCertVerify(_map(64, 'CkMht_getRequireSslCertVerify'))
    (objHandle);
end;

procedure CkMht_putRequireSslCertVerify (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putRequireSslCertVerify(_map(65, 'CkMht_putRequireSslCertVerify'))
    (objHandle, newPropVal);
end;

procedure CkMht_getSocksHostname (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getSocksHostname(_map(66, 'CkMht_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkMht_putSocksHostname (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putSocksHostname(_map(67, 'CkMht_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkMht__socksHostname (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__socksHostname(_map(68, 'CkMht__socksHostname'))
    (objHandle);
end;

procedure CkMht_getSocksPassword (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getSocksPassword(_map(69, 'CkMht_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkMht_putSocksPassword (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putSocksPassword(_map(70, 'CkMht_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkMht__socksPassword (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__socksPassword(_map(71, 'CkMht__socksPassword'))
    (objHandle);
end;

function CkMht_getSocksPort (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getSocksPort(_map(72, 'CkMht_getSocksPort'))
    (objHandle);
end;

procedure CkMht_putSocksPort (objHandle: HCkMht; newPropVal: Integer);
begin
  TCkMht_putSocksPort(_map(73, 'CkMht_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkMht_getSocksUsername (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getSocksUsername(_map(74, 'CkMht_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkMht_putSocksUsername (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putSocksUsername(_map(75, 'CkMht_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkMht__socksUsername (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__socksUsername(_map(76, 'CkMht__socksUsername'))
    (objHandle);
end;

function CkMht_getSocksVersion (objHandle: HCkMht): Integer;
begin
    result := TCkMht_getSocksVersion(_map(77, 'CkMht_getSocksVersion'))
    (objHandle);
end;

procedure CkMht_putSocksVersion (objHandle: HCkMht; newPropVal: Integer);
begin
  TCkMht_putSocksVersion(_map(78, 'CkMht_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkMht_getUnpackDirect (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUnpackDirect(_map(79, 'CkMht_getUnpackDirect'))
    (objHandle);
end;

procedure CkMht_putUnpackDirect (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUnpackDirect(_map(80, 'CkMht_putUnpackDirect'))
    (objHandle, newPropVal);
end;

function CkMht_getUnpackUseRelPaths (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUnpackUseRelPaths(_map(81, 'CkMht_getUnpackUseRelPaths'))
    (objHandle);
end;

procedure CkMht_putUnpackUseRelPaths (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUnpackUseRelPaths(_map(82, 'CkMht_putUnpackUseRelPaths'))
    (objHandle, newPropVal);
end;

function CkMht_getUpdateCache (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUpdateCache(_map(83, 'CkMht_getUpdateCache'))
    (objHandle);
end;

procedure CkMht_putUpdateCache (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUpdateCache(_map(84, 'CkMht_putUpdateCache'))
    (objHandle, newPropVal);
end;

function CkMht_getUseCids (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUseCids(_map(85, 'CkMht_getUseCids'))
    (objHandle);
end;

procedure CkMht_putUseCids (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUseCids(_map(86, 'CkMht_putUseCids'))
    (objHandle, newPropVal);
end;

function CkMht_getUseFilename (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUseFilename(_map(87, 'CkMht_getUseFilename'))
    (objHandle);
end;

procedure CkMht_putUseFilename (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUseFilename(_map(88, 'CkMht_putUseFilename'))
    (objHandle, newPropVal);
end;

function CkMht_getUseIEProxy (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUseIEProxy(_map(89, 'CkMht_getUseIEProxy'))
    (objHandle);
end;

procedure CkMht_putUseIEProxy (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUseIEProxy(_map(90, 'CkMht_putUseIEProxy'))
    (objHandle, newPropVal);
end;

function CkMht_getUseInline (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getUseInline(_map(91, 'CkMht_getUseInline'))
    (objHandle);
end;

procedure CkMht_putUseInline (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putUseInline(_map(92, 'CkMht_putUseInline'))
    (objHandle, newPropVal);
end;

function CkMht_getVerboseLogging (objHandle: HCkMht): wordbool;
begin
    result := TCkMht_getVerboseLogging(_map(93, 'CkMht_getVerboseLogging'))
    (objHandle);
end;

procedure CkMht_putVerboseLogging (objHandle: HCkMht; newPropVal: wordbool);
begin
  TCkMht_putVerboseLogging(_map(94, 'CkMht_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkMht_getVersion (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getVersion(_map(95, 'CkMht_getVersion'))
    (objHandle, outPropVal);
end;

function CkMht__version (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__version(_map(96, 'CkMht__version'))
    (objHandle);
end;

procedure CkMht_getWebSiteLogin (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getWebSiteLogin(_map(97, 'CkMht_getWebSiteLogin'))
    (objHandle, outPropVal);
end;

procedure CkMht_putWebSiteLogin (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putWebSiteLogin(_map(98, 'CkMht_putWebSiteLogin'))
    (objHandle, newPropVal);
end;

function CkMht__webSiteLogin (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__webSiteLogin(_map(99, 'CkMht__webSiteLogin'))
    (objHandle);
end;

procedure CkMht_getWebSiteLoginDomain (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getWebSiteLoginDomain(_map(100, 'CkMht_getWebSiteLoginDomain'))
    (objHandle, outPropVal);
end;

procedure CkMht_putWebSiteLoginDomain (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putWebSiteLoginDomain(_map(101, 'CkMht_putWebSiteLoginDomain'))
    (objHandle, newPropVal);
end;

function CkMht__webSiteLoginDomain (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__webSiteLoginDomain(_map(102, 'CkMht__webSiteLoginDomain'))
    (objHandle);
end;

procedure CkMht_getWebSitePassword (objHandle: HCkMht; outPropVal: HCkString);
begin
  TCkMht_getWebSitePassword(_map(103, 'CkMht_getWebSitePassword'))
    (objHandle, outPropVal);
end;

procedure CkMht_putWebSitePassword (objHandle: HCkMht; newPropVal: PWideChar);
begin
  TCkMht_putWebSitePassword(_map(104, 'CkMht_putWebSitePassword'))
    (objHandle, newPropVal);
end;

function CkMht__webSitePassword (objHandle: HCkMht): PWideChar;
begin
  result := TCkMht__webSitePassword(_map(105, 'CkMht__webSitePassword'))
    (objHandle);
end;

procedure CkMht_AddCacheRoot (objHandle: HCkMht; dir: PWideChar);
begin
  TCkMht_AddCacheRoot(_map(106, 'CkMht_AddCacheRoot'))
    (objHandle, dir);
end;

procedure CkMht_AddCustomHeader (objHandle: HCkMht; name: PWideChar; value: PWideChar);
begin
  TCkMht_AddCustomHeader(_map(107, 'CkMht_AddCustomHeader'))
    (objHandle, name, value);
end;

procedure CkMht_AddExternalStyleSheet (objHandle: HCkMht; url: PWideChar);
begin
  TCkMht_AddExternalStyleSheet(_map(108, 'CkMht_AddExternalStyleSheet'))
    (objHandle, url);
end;

procedure CkMht_ClearCustomHeaders (objHandle: HCkMht);
begin
  TCkMht_ClearCustomHeaders(_map(109, 'CkMht_ClearCustomHeaders'))
    (objHandle);
end;

procedure CkMht_ExcludeImagesMatching (objHandle: HCkMht; pattern: PWideChar);
begin
  TCkMht_ExcludeImagesMatching(_map(110, 'CkMht_ExcludeImagesMatching'))
    (objHandle, pattern);
end;

function CkMht_GetAndSaveEML (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; emlPath: PWideChar): wordbool;
begin
  result := TCkMht_GetAndSaveEML(_map(111, 'CkMht_GetAndSaveEML'))
    (objHandle, url_or_htmlFilepath, emlPath);
end;

function CkMht_GetAndSaveEMLAsync (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; emlPath: PWideChar): HCkTask;
begin
  result := TCkMht_GetAndSaveEMLAsync(_map(112, 'CkMht_GetAndSaveEMLAsync'))
    (objHandle, url_or_htmlFilepath, emlPath);
end;

function CkMht_GetAndSaveMHT (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; mhtPath: PWideChar): wordbool;
begin
  result := TCkMht_GetAndSaveMHT(_map(113, 'CkMht_GetAndSaveMHT'))
    (objHandle, url_or_htmlFilepath, mhtPath);
end;

function CkMht_GetAndSaveMHTAsync (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; mhtPath: PWideChar): HCkTask;
begin
  result := TCkMht_GetAndSaveMHTAsync(_map(114, 'CkMht_GetAndSaveMHTAsync'))
    (objHandle, url_or_htmlFilepath, mhtPath);
end;

function CkMht_GetAndZipEML (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): wordbool;
begin
  result := TCkMht_GetAndZipEML(_map(115, 'CkMht_GetAndZipEML'))
    (objHandle, url_or_htmlFilepath, zipEntryFilename, zipFilename);
end;

function CkMht_GetAndZipEMLAsync (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): HCkTask;
begin
  result := TCkMht_GetAndZipEMLAsync(_map(116, 'CkMht_GetAndZipEMLAsync'))
    (objHandle, url_or_htmlFilepath, zipEntryFilename, zipFilename);
end;

function CkMht_GetAndZipMHT (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): wordbool;
begin
  result := TCkMht_GetAndZipMHT(_map(117, 'CkMht_GetAndZipMHT'))
    (objHandle, url_or_htmlFilepath, zipEntryFilename, zipFilename);
end;

function CkMht_GetAndZipMHTAsync (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; zipEntryFilename: PWideChar; zipFilename: PWideChar): HCkTask;
begin
  result := TCkMht_GetAndZipMHTAsync(_map(118, 'CkMht_GetAndZipMHTAsync'))
    (objHandle, url_or_htmlFilepath, zipEntryFilename, zipFilename);
end;

function CkMht_GetCacheRoot (objHandle: HCkMht; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMht_GetCacheRoot(_map(119, 'CkMht_GetCacheRoot'))
    (objHandle, index, outStr);
end;

function CkMht__getCacheRoot (objHandle: HCkMht; index: Integer): PWideChar;
begin
  result := TCkMht__getCacheRoot(_map(120, 'CkMht__getCacheRoot'))
    (objHandle, index);
end;

function CkMht_GetEML (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMht_GetEML(_map(121, 'CkMht_GetEML'))
    (objHandle, url_or_htmlFilepath, outStr);
end;

function CkMht__getEML (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): PWideChar;
begin
  result := TCkMht__getEML(_map(122, 'CkMht__getEML'))
    (objHandle, url_or_htmlFilepath);
end;

function CkMht_GetEMLAsync (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): HCkTask;
begin
  result := TCkMht_GetEMLAsync(_map(123, 'CkMht_GetEMLAsync'))
    (objHandle, url_or_htmlFilepath);
end;

function CkMht_GetMHT (objHandle: HCkMht; url_or_htmlFilepath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMht_GetMHT(_map(124, 'CkMht_GetMHT'))
    (objHandle, url_or_htmlFilepath, outStr);
end;

function CkMht__getMHT (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): PWideChar;
begin
  result := TCkMht__getMHT(_map(125, 'CkMht__getMHT'))
    (objHandle, url_or_htmlFilepath);
end;

function CkMht_GetMHTAsync (objHandle: HCkMht; url_or_htmlFilepath: PWideChar): HCkTask;
begin
  result := TCkMht_GetMHTAsync(_map(126, 'CkMht_GetMHTAsync'))
    (objHandle, url_or_htmlFilepath);
end;

function CkMht_HtmlToEML (objHandle: HCkMht; htmlText: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMht_HtmlToEML(_map(127, 'CkMht_HtmlToEML'))
    (objHandle, htmlText, outStr);
end;

function CkMht__htmlToEML (objHandle: HCkMht; htmlText: PWideChar): PWideChar;
begin
  result := TCkMht__htmlToEML(_map(128, 'CkMht__htmlToEML'))
    (objHandle, htmlText);
end;

function CkMht_HtmlToEMLAsync (objHandle: HCkMht; htmlText: PWideChar): HCkTask;
begin
  result := TCkMht_HtmlToEMLAsync(_map(129, 'CkMht_HtmlToEMLAsync'))
    (objHandle, htmlText);
end;

function CkMht_HtmlToEMLFile (objHandle: HCkMht; html: PWideChar; emlFilename: PWideChar): wordbool;
begin
  result := TCkMht_HtmlToEMLFile(_map(130, 'CkMht_HtmlToEMLFile'))
    (objHandle, html, emlFilename);
end;

function CkMht_HtmlToEMLFileAsync (objHandle: HCkMht; html: PWideChar; emlFilename: PWideChar): HCkTask;
begin
  result := TCkMht_HtmlToEMLFileAsync(_map(131, 'CkMht_HtmlToEMLFileAsync'))
    (objHandle, html, emlFilename);
end;

function CkMht_HtmlToMHT (objHandle: HCkMht; htmlText: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMht_HtmlToMHT(_map(132, 'CkMht_HtmlToMHT'))
    (objHandle, htmlText, outStr);
end;

function CkMht__htmlToMHT (objHandle: HCkMht; htmlText: PWideChar): PWideChar;
begin
  result := TCkMht__htmlToMHT(_map(133, 'CkMht__htmlToMHT'))
    (objHandle, htmlText);
end;

function CkMht_HtmlToMHTAsync (objHandle: HCkMht; htmlText: PWideChar): HCkTask;
begin
  result := TCkMht_HtmlToMHTAsync(_map(134, 'CkMht_HtmlToMHTAsync'))
    (objHandle, htmlText);
end;

function CkMht_HtmlToMHTFile (objHandle: HCkMht; html: PWideChar; mhtFilename: PWideChar): wordbool;
begin
  result := TCkMht_HtmlToMHTFile(_map(135, 'CkMht_HtmlToMHTFile'))
    (objHandle, html, mhtFilename);
end;

function CkMht_HtmlToMHTFileAsync (objHandle: HCkMht; html: PWideChar; mhtFilename: PWideChar): HCkTask;
begin
  result := TCkMht_HtmlToMHTFileAsync(_map(136, 'CkMht_HtmlToMHTFileAsync'))
    (objHandle, html, mhtFilename);
end;

function CkMht_LoadTaskCaller (objHandle: HCkMht; task: HCkTask): wordbool;
begin
  result := TCkMht_LoadTaskCaller(_map(137, 'CkMht_LoadTaskCaller'))
    (objHandle, task);
end;

procedure CkMht_RemoveCustomHeader (objHandle: HCkMht; name: PWideChar);
begin
  TCkMht_RemoveCustomHeader(_map(138, 'CkMht_RemoveCustomHeader'))
    (objHandle, name);
end;

procedure CkMht_RestoreDefaults (objHandle: HCkMht);
begin
  TCkMht_RestoreDefaults(_map(139, 'CkMht_RestoreDefaults'))
    (objHandle);
end;

function CkMht_UnpackMHT (objHandle: HCkMht; mhtFilename: PWideChar; unpackDir: PWideChar; htmlFilename: PWideChar; partsSubDir: PWideChar): wordbool;
begin
  result := TCkMht_UnpackMHT(_map(140, 'CkMht_UnpackMHT'))
    (objHandle, mhtFilename, unpackDir, htmlFilename, partsSubDir);
end;

function CkMht_UnpackMHTString (objHandle: HCkMht; mhtString: PWideChar; unpackDir: PWideChar; htmlFilename: PWideChar; partsSubDir: PWideChar): wordbool;
begin
  result := TCkMht_UnpackMHTString(_map(141, 'CkMht_UnpackMHTString'))
    (objHandle, mhtString, unpackDir, htmlFilename, partsSubDir);
end;

end.
