unit Mime;

interface

type

HCkXmlCertVault = Pointer;
HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkMime = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStringArray = Pointer;
HCkStringTable = Pointer;
HCkStringBuilder = Pointer;
HCkCertChain = Pointer;
HCkCert = Pointer;
HCkJsonObject = Pointer;


function CkMime_Create: HCkMime;  stdcall;
procedure CkMime_Dispose(handle: HCkMime); stdcall;
procedure CkMime_getBoundary(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putBoundary(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__boundary(objHandle: HCkMime): PWideChar;
procedure CkMime_getCharset(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putCharset(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__charset(objHandle: HCkMime): PWideChar;
procedure CkMime_getCmsOptions(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putCmsOptions(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__cmsOptions(objHandle: HCkMime): PWideChar;
procedure CkMime_getContentType(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putContentType(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__contentType(objHandle: HCkMime): PWideChar;
procedure CkMime_getCurrentDateTime(objHandle: HCkMime; outPropVal: HCkString);
function CkMime__currentDateTime(objHandle: HCkMime): PWideChar;
procedure CkMime_getDebugLogFilePath(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putDebugLogFilePath(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__debugLogFilePath(objHandle: HCkMime): PWideChar;
procedure CkMime_getDisposition(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putDisposition(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__disposition(objHandle: HCkMime): PWideChar;
procedure CkMime_getEncoding(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putEncoding(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__encoding(objHandle: HCkMime): PWideChar;
procedure CkMime_getFilename(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putFilename(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__filename(objHandle: HCkMime): PWideChar;
procedure CkMime_getLastErrorHtml(objHandle: HCkMime; outPropVal: HCkString);
function CkMime__lastErrorHtml(objHandle: HCkMime): PWideChar;
procedure CkMime_getLastErrorText(objHandle: HCkMime; outPropVal: HCkString);
function CkMime__lastErrorText(objHandle: HCkMime): PWideChar;
procedure CkMime_getLastErrorXml(objHandle: HCkMime; outPropVal: HCkString);
function CkMime__lastErrorXml(objHandle: HCkMime): PWideChar;
function CkMime_getLastMethodSuccess(objHandle: HCkMime): wordbool;
procedure CkMime_putLastMethodSuccess(objHandle: HCkMime; newPropVal: wordbool);
procedure CkMime_getMicalg(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putMicalg(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__micalg(objHandle: HCkMime): PWideChar;
procedure CkMime_getName(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putName(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__name(objHandle: HCkMime): PWideChar;
function CkMime_getNumDecryptCerts(objHandle: HCkMime): Integer;
function CkMime_getNumEncryptCerts(objHandle: HCkMime): Integer;
function CkMime_getNumHeaderFields(objHandle: HCkMime): Integer;
function CkMime_getNumParts(objHandle: HCkMime): Integer;
function CkMime_getNumSignerCerts(objHandle: HCkMime): Integer;
procedure CkMime_getOaepHash(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putOaepHash(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__oaepHash(objHandle: HCkMime): PWideChar;
procedure CkMime_getOaepMgfHash(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putOaepMgfHash(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__oaepMgfHash(objHandle: HCkMime): PWideChar;
function CkMime_getOaepPadding(objHandle: HCkMime): wordbool;
procedure CkMime_putOaepPadding(objHandle: HCkMime; newPropVal: wordbool);
procedure CkMime_getPkcs7CryptAlg(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putPkcs7CryptAlg(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__pkcs7CryptAlg(objHandle: HCkMime): PWideChar;
function CkMime_getPkcs7KeyLength(objHandle: HCkMime): Integer;
procedure CkMime_putPkcs7KeyLength(objHandle: HCkMime; newPropVal: Integer);
procedure CkMime_getProtocol(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putProtocol(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__protocol(objHandle: HCkMime): PWideChar;
procedure CkMime_getSigningAlg(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putSigningAlg(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__signingAlg(objHandle: HCkMime): PWideChar;
procedure CkMime_getSigningHashAlg(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putSigningHashAlg(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__signingHashAlg(objHandle: HCkMime): PWideChar;
procedure CkMime_getUncommonOptions(objHandle: HCkMime; outPropVal: HCkString);
procedure CkMime_putUncommonOptions(objHandle: HCkMime; newPropVal: PWideChar);
function CkMime__uncommonOptions(objHandle: HCkMime): PWideChar;
function CkMime_getUnwrapExtras(objHandle: HCkMime): wordbool;
procedure CkMime_putUnwrapExtras(objHandle: HCkMime; newPropVal: wordbool);
function CkMime_getUseMmDescription(objHandle: HCkMime): wordbool;
procedure CkMime_putUseMmDescription(objHandle: HCkMime; newPropVal: wordbool);
function CkMime_getUseXPkcs7(objHandle: HCkMime): wordbool;
procedure CkMime_putUseXPkcs7(objHandle: HCkMime; newPropVal: wordbool);
function CkMime_getVerboseLogging(objHandle: HCkMime): wordbool;
procedure CkMime_putVerboseLogging(objHandle: HCkMime; newPropVal: wordbool);
procedure CkMime_getVersion(objHandle: HCkMime; outPropVal: HCkString);
function CkMime__version(objHandle: HCkMime): PWideChar;
procedure CkMime_AddContentLength(objHandle: HCkMime);
function CkMime_AddDecryptCert(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_AddDetachedSignature(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_AddDetachedSignature2(objHandle: HCkMime; cert: HCkCert; transferHeaderFields: wordbool): wordbool;
function CkMime_AddDetachedSignaturePk(objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
function CkMime_AddDetachedSignaturePk2(objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey; transferHeaderFields: wordbool): wordbool;
function CkMime_AddEncryptCert(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_AddHeaderField(objHandle: HCkMime; name: PWideChar; value: PWideChar): wordbool;
function CkMime_AddPfxSourceBd(objHandle: HCkMime; bd: HCkBinData; password: PWideChar): wordbool;
function CkMime_AddPfxSourceData(objHandle: HCkMime; pfxFileData: HCkByteData; pfxPassword: PWideChar): wordbool;
function CkMime_AddPfxSourceFile(objHandle: HCkMime; pfxFilePath: PWideChar; password: PWideChar): wordbool;
function CkMime_AppendPart(objHandle: HCkMime; mime: HCkMime): wordbool;
function CkMime_AppendPartFromFile(objHandle: HCkMime; filename: PWideChar): wordbool;
function CkMime_AsnBodyToXml(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__asnBodyToXml(objHandle: HCkMime): PWideChar;
procedure CkMime_ClearEncryptCerts(objHandle: HCkMime);
function CkMime_ContainsEncryptedParts(objHandle: HCkMime): wordbool;
function CkMime_ContainsSignedParts(objHandle: HCkMime): wordbool;
procedure CkMime_Convert8Bit(objHandle: HCkMime);
function CkMime_ConvertToMultipartAlt(objHandle: HCkMime): wordbool;
function CkMime_ConvertToMultipartMixed(objHandle: HCkMime): wordbool;
function CkMime_ConvertToSigned(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_ConvertToSignedPk(objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
function CkMime_Decrypt(objHandle: HCkMime): wordbool;
function CkMime_Decrypt2(objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
function CkMime_DecryptUsingCert(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_DecryptUsingPfxData(objHandle: HCkMime; pfxData: HCkByteData; password: PWideChar): wordbool;
function CkMime_DecryptUsingPfxFile(objHandle: HCkMime; pfxFilePath: PWideChar; pfxPassword: PWideChar): wordbool;
function CkMime_Encrypt(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_EncryptN(objHandle: HCkMime): wordbool;
function CkMime_ExtractPartsToFiles(objHandle: HCkMime; dirPath: PWideChar): HCkStringArray;
function CkMime_FindIssuer(objHandle: HCkMime; cert: HCkCert): HCkCert;
function CkMime_GetBodyBd(objHandle: HCkMime; binDat: HCkBinData): wordbool;
function CkMime_GetBodyBinary(objHandle: HCkMime; outData: HCkByteData): wordbool;
function CkMime_GetBodyDecoded(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__getBodyDecoded(objHandle: HCkMime): PWideChar;
function CkMime_GetBodyEncoded(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__getBodyEncoded(objHandle: HCkMime): PWideChar;
function CkMime_GetEncryptCert(objHandle: HCkMime; index: Integer): HCkCert;
function CkMime_GetEntireBody(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__getEntireBody(objHandle: HCkMime): PWideChar;
function CkMime_GetEntireHead(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__getEntireHead(objHandle: HCkMime): PWideChar;
function CkMime_GetHeaderField(objHandle: HCkMime; fieldName: PWideChar; outStr: HCkString): wordbool;
function CkMime__getHeaderField(objHandle: HCkMime; fieldName: PWideChar): PWideChar;
function CkMime_GetHeaderFieldAttribute(objHandle: HCkMime; name: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool;
function CkMime__getHeaderFieldAttribute(objHandle: HCkMime; name: PWideChar; attrName: PWideChar): PWideChar;
function CkMime_GetHeaderFieldName(objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool;
function CkMime__getHeaderFieldName(objHandle: HCkMime; index: Integer): PWideChar;
function CkMime_GetHeaderFieldValue(objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool;
function CkMime__getHeaderFieldValue(objHandle: HCkMime; index: Integer): PWideChar;
procedure CkMime_GetLastJsonData(objHandle: HCkMime; json: HCkJsonObject);
function CkMime_GetMime(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__getMime(objHandle: HCkMime): PWideChar;
function CkMime_GetMimeBd(objHandle: HCkMime; bindat: HCkBinData): wordbool;
function CkMime_GetMimeBytes(objHandle: HCkMime; outData: HCkByteData): wordbool;
function CkMime_GetMimeSb(objHandle: HCkMime; sb: HCkStringBuilder): wordbool;
function CkMime_GetPart(objHandle: HCkMime; index: Integer): HCkMime;
function CkMime_GetSignatureSigningTimeStr(objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool;
function CkMime__getSignatureSigningTimeStr(objHandle: HCkMime; index: Integer): PWideChar;
function CkMime_GetSignerCert(objHandle: HCkMime; index: Integer): HCkCert;
function CkMime_GetSignerCertChain(objHandle: HCkMime; index: Integer): HCkCertChain;
function CkMime_GetStructure(objHandle: HCkMime; fmt: PWideChar; outStr: HCkString): wordbool;
function CkMime__getStructure(objHandle: HCkMime; fmt: PWideChar): PWideChar;
function CkMime_GetXml(objHandle: HCkMime; outStr: HCkString): wordbool;
function CkMime__getXml(objHandle: HCkMime): PWideChar;
function CkMime_HasSignatureSigningTime(objHandle: HCkMime; index: Integer): wordbool;
function CkMime_IsApplicationData(objHandle: HCkMime): wordbool;
function CkMime_IsAttachment(objHandle: HCkMime): wordbool;
function CkMime_IsAudio(objHandle: HCkMime): wordbool;
function CkMime_IsEncrypted(objHandle: HCkMime): wordbool;
function CkMime_IsHtml(objHandle: HCkMime): wordbool;
function CkMime_IsImage(objHandle: HCkMime): wordbool;
function CkMime_IsMultipart(objHandle: HCkMime): wordbool;
function CkMime_IsMultipartAlternative(objHandle: HCkMime): wordbool;
function CkMime_IsMultipartMixed(objHandle: HCkMime): wordbool;
function CkMime_IsMultipartRelated(objHandle: HCkMime): wordbool;
function CkMime_IsPlainText(objHandle: HCkMime): wordbool;
function CkMime_IsSigned(objHandle: HCkMime): wordbool;
function CkMime_IsText(objHandle: HCkMime): wordbool;
function CkMime_IsVideo(objHandle: HCkMime): wordbool;
function CkMime_IsXml(objHandle: HCkMime): wordbool;
function CkMime_LastDecryptCert(objHandle: HCkMime; index: Integer; cert: HCkCert): wordbool;
function CkMime_LastJsonData(objHandle: HCkMime): HCkJsonObject;
function CkMime_LastSignerCert(objHandle: HCkMime; index: Integer; cert: HCkCert): wordbool;
function CkMime_LoadMime(objHandle: HCkMime; mimeMsg: PWideChar): wordbool;
function CkMime_LoadMimeBd(objHandle: HCkMime; bindat: HCkBinData): wordbool;
function CkMime_LoadMimeBytes(objHandle: HCkMime; binData: HCkByteData): wordbool;
function CkMime_LoadMimeFile(objHandle: HCkMime; fileName: PWideChar): wordbool;
function CkMime_LoadMimeSb(objHandle: HCkMime; sb: HCkStringBuilder): wordbool;
function CkMime_LoadXml(objHandle: HCkMime; xml: PWideChar): wordbool;
function CkMime_LoadXmlFile(objHandle: HCkMime; fileName: PWideChar): wordbool;
function CkMime_NewMessageRfc822(objHandle: HCkMime; mimeObject: HCkMime): wordbool;
function CkMime_NewMultipartAlternative(objHandle: HCkMime): wordbool;
function CkMime_NewMultipartMixed(objHandle: HCkMime): wordbool;
function CkMime_NewMultipartRelated(objHandle: HCkMime): wordbool;
function CkMime_PartAt(objHandle: HCkMime; index: Integer; subPart: HCkMime): wordbool;
function CkMime_PartsToFiles(objHandle: HCkMime; path: PWideChar; st: HCkStringTable): wordbool;
procedure CkMime_RemoveHeaderField(objHandle: HCkMime; fieldName: PWideChar; bAllOccurrences: wordbool);
function CkMime_RemovePart(objHandle: HCkMime; index: Integer): wordbool;
function CkMime_SaveBody(objHandle: HCkMime; filename: PWideChar): wordbool;
function CkMime_SaveMime(objHandle: HCkMime; filename: PWideChar): wordbool;
function CkMime_SaveXml(objHandle: HCkMime; filename: PWideChar): wordbool;
procedure CkMime_SetBody(objHandle: HCkMime; str: PWideChar);
function CkMime_SetBodyBd(objHandle: HCkMime; bd: HCkBinData): wordbool;
function CkMime_SetBodyFromBinary(objHandle: HCkMime; binData: HCkByteData): wordbool;
function CkMime_SetBodyFromEncoded(objHandle: HCkMime; encoding: PWideChar; str: PWideChar): wordbool;
function CkMime_SetBodyFromFile(objHandle: HCkMime; fileName: PWideChar): wordbool;
function CkMime_SetBodyFromHtml(objHandle: HCkMime; str: PWideChar): wordbool;
function CkMime_SetBodyFromPlainText(objHandle: HCkMime; str: PWideChar): wordbool;
function CkMime_SetBodyFromXml(objHandle: HCkMime; str: PWideChar): wordbool;
function CkMime_SetHeaderField(objHandle: HCkMime; name: PWideChar; value: PWideChar): wordbool;
function CkMime_SetVerifyCert(objHandle: HCkMime; cert: HCkCert): wordbool;
function CkMime_UnwrapSecurity(objHandle: HCkMime): wordbool;
procedure CkMime_UrlEncodeBody(objHandle: HCkMime; charset: PWideChar);
function CkMime_UseCertVault(objHandle: HCkMime; vault: HCkXmlCertVault): wordbool;
function CkMime_Verify(objHandle: HCkMime): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkMime_Create = function : HCkMime; stdcall;
  TCkMime_Dispose = procedure (handle: HCkMime); stdcall;
  TCkMime_getBoundary = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putBoundary = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__boundary = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getCharset = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putCharset = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__charset = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getCmsOptions = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putCmsOptions = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__cmsOptions = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getContentType = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putContentType = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__contentType = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getCurrentDateTime = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime__currentDateTime = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getDebugLogFilePath = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putDebugLogFilePath = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__debugLogFilePath = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getDisposition = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putDisposition = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__disposition = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getEncoding = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putEncoding = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__encoding = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getFilename = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putFilename = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__filename = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getLastErrorHtml = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime__lastErrorHtml = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getLastErrorText = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime__lastErrorText = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getLastErrorXml = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime__lastErrorXml = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getLastMethodSuccess = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_putLastMethodSuccess = procedure (objHandle: HCkMime; newPropVal: wordbool); stdcall;
  TCkMime_getMicalg = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putMicalg = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__micalg = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getName = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putName = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__name = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getNumDecryptCerts = function (objHandle: HCkMime): Integer; stdcall;
  TCkMime_getNumEncryptCerts = function (objHandle: HCkMime): Integer; stdcall;
  TCkMime_getNumHeaderFields = function (objHandle: HCkMime): Integer; stdcall;
  TCkMime_getNumParts = function (objHandle: HCkMime): Integer; stdcall;
  TCkMime_getNumSignerCerts = function (objHandle: HCkMime): Integer; stdcall;
  TCkMime_getOaepHash = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putOaepHash = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__oaepHash = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getOaepMgfHash = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putOaepMgfHash = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__oaepMgfHash = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getOaepPadding = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_putOaepPadding = procedure (objHandle: HCkMime; newPropVal: wordbool); stdcall;
  TCkMime_getPkcs7CryptAlg = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putPkcs7CryptAlg = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__pkcs7CryptAlg = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getPkcs7KeyLength = function (objHandle: HCkMime): Integer; stdcall;
  TCkMime_putPkcs7KeyLength = procedure (objHandle: HCkMime; newPropVal: Integer); stdcall;
  TCkMime_getProtocol = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putProtocol = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__protocol = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getSigningAlg = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putSigningAlg = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__signingAlg = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getSigningHashAlg = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putSigningHashAlg = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__signingHashAlg = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getUncommonOptions = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime_putUncommonOptions = procedure (objHandle: HCkMime; newPropVal: PWideChar); stdcall;
  TCkMime__uncommonOptions = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_getUnwrapExtras = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_putUnwrapExtras = procedure (objHandle: HCkMime; newPropVal: wordbool); stdcall;
  TCkMime_getUseMmDescription = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_putUseMmDescription = procedure (objHandle: HCkMime; newPropVal: wordbool); stdcall;
  TCkMime_getUseXPkcs7 = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_putUseXPkcs7 = procedure (objHandle: HCkMime; newPropVal: wordbool); stdcall;
  TCkMime_getVerboseLogging = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_putVerboseLogging = procedure (objHandle: HCkMime; newPropVal: wordbool); stdcall;
  TCkMime_getVersion = procedure (objHandle: HCkMime; outPropVal: HCkString); stdcall;
  TCkMime__version = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_AddContentLength = procedure (objHandle: HCkMime); stdcall;
  TCkMime_AddDecryptCert = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_AddDetachedSignature = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_AddDetachedSignature2 = function (objHandle: HCkMime; cert: HCkCert; transferHeaderFields: wordbool): wordbool; stdcall;
  TCkMime_AddDetachedSignaturePk = function (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkMime_AddDetachedSignaturePk2 = function (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey; transferHeaderFields: wordbool): wordbool; stdcall;
  TCkMime_AddEncryptCert = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_AddHeaderField = function (objHandle: HCkMime; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkMime_AddPfxSourceBd = function (objHandle: HCkMime; bd: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkMime_AddPfxSourceData = function (objHandle: HCkMime; pfxFileData: HCkByteData; pfxPassword: PWideChar): wordbool; stdcall;
  TCkMime_AddPfxSourceFile = function (objHandle: HCkMime; pfxFilePath: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkMime_AppendPart = function (objHandle: HCkMime; mime: HCkMime): wordbool; stdcall;
  TCkMime_AppendPartFromFile = function (objHandle: HCkMime; filename: PWideChar): wordbool; stdcall;
  TCkMime_AsnBodyToXml = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__asnBodyToXml = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_ClearEncryptCerts = procedure (objHandle: HCkMime); stdcall;
  TCkMime_ContainsEncryptedParts = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_ContainsSignedParts = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_Convert8Bit = procedure (objHandle: HCkMime); stdcall;
  TCkMime_ConvertToMultipartAlt = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_ConvertToMultipartMixed = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_ConvertToSigned = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_ConvertToSignedPk = function (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkMime_Decrypt = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_Decrypt2 = function (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkMime_DecryptUsingCert = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_DecryptUsingPfxData = function (objHandle: HCkMime; pfxData: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkMime_DecryptUsingPfxFile = function (objHandle: HCkMime; pfxFilePath: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkMime_Encrypt = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_EncryptN = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_ExtractPartsToFiles = function (objHandle: HCkMime; dirPath: PWideChar): HCkStringArray; stdcall;
  TCkMime_FindIssuer = function (objHandle: HCkMime; cert: HCkCert): HCkCert; stdcall;
  TCkMime_GetBodyBd = function (objHandle: HCkMime; binDat: HCkBinData): wordbool; stdcall;
  TCkMime_GetBodyBinary = function (objHandle: HCkMime; outData: HCkByteData): wordbool; stdcall;
  TCkMime_GetBodyDecoded = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__getBodyDecoded = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_GetBodyEncoded = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__getBodyEncoded = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_GetEncryptCert = function (objHandle: HCkMime; index: Integer): HCkCert; stdcall;
  TCkMime_GetEntireBody = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__getEntireBody = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_GetEntireHead = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__getEntireHead = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_GetHeaderField = function (objHandle: HCkMime; fieldName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMime__getHeaderField = function (objHandle: HCkMime; fieldName: PWideChar): PWideChar; stdcall;
  TCkMime_GetHeaderFieldAttribute = function (objHandle: HCkMime; name: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMime__getHeaderFieldAttribute = function (objHandle: HCkMime; name: PWideChar; attrName: PWideChar): PWideChar; stdcall;
  TCkMime_GetHeaderFieldName = function (objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMime__getHeaderFieldName = function (objHandle: HCkMime; index: Integer): PWideChar; stdcall;
  TCkMime_GetHeaderFieldValue = function (objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMime__getHeaderFieldValue = function (objHandle: HCkMime; index: Integer): PWideChar; stdcall;
  TCkMime_GetLastJsonData = procedure (objHandle: HCkMime; json: HCkJsonObject); stdcall;
  TCkMime_GetMime = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__getMime = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_GetMimeBd = function (objHandle: HCkMime; bindat: HCkBinData): wordbool; stdcall;
  TCkMime_GetMimeBytes = function (objHandle: HCkMime; outData: HCkByteData): wordbool; stdcall;
  TCkMime_GetMimeSb = function (objHandle: HCkMime; sb: HCkStringBuilder): wordbool; stdcall;
  TCkMime_GetPart = function (objHandle: HCkMime; index: Integer): HCkMime; stdcall;
  TCkMime_GetSignatureSigningTimeStr = function (objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkMime__getSignatureSigningTimeStr = function (objHandle: HCkMime; index: Integer): PWideChar; stdcall;
  TCkMime_GetSignerCert = function (objHandle: HCkMime; index: Integer): HCkCert; stdcall;
  TCkMime_GetSignerCertChain = function (objHandle: HCkMime; index: Integer): HCkCertChain; stdcall;
  TCkMime_GetStructure = function (objHandle: HCkMime; fmt: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkMime__getStructure = function (objHandle: HCkMime; fmt: PWideChar): PWideChar; stdcall;
  TCkMime_GetXml = function (objHandle: HCkMime; outStr: HCkString): wordbool; stdcall;
  TCkMime__getXml = function (objHandle: HCkMime): PWideChar; stdcall;
  TCkMime_HasSignatureSigningTime = function (objHandle: HCkMime; index: Integer): wordbool; stdcall;
  TCkMime_IsApplicationData = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsAttachment = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsAudio = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsEncrypted = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsHtml = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsImage = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsMultipart = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsMultipartAlternative = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsMultipartMixed = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsMultipartRelated = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsPlainText = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsSigned = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsText = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsVideo = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_IsXml = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_LastDecryptCert = function (objHandle: HCkMime; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkMime_LastJsonData = function (objHandle: HCkMime): HCkJsonObject; stdcall;
  TCkMime_LastSignerCert = function (objHandle: HCkMime; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkMime_LoadMime = function (objHandle: HCkMime; mimeMsg: PWideChar): wordbool; stdcall;
  TCkMime_LoadMimeBd = function (objHandle: HCkMime; bindat: HCkBinData): wordbool; stdcall;
  TCkMime_LoadMimeBytes = function (objHandle: HCkMime; binData: HCkByteData): wordbool; stdcall;
  TCkMime_LoadMimeFile = function (objHandle: HCkMime; fileName: PWideChar): wordbool; stdcall;
  TCkMime_LoadMimeSb = function (objHandle: HCkMime; sb: HCkStringBuilder): wordbool; stdcall;
  TCkMime_LoadXml = function (objHandle: HCkMime; xml: PWideChar): wordbool; stdcall;
  TCkMime_LoadXmlFile = function (objHandle: HCkMime; fileName: PWideChar): wordbool; stdcall;
  TCkMime_NewMessageRfc822 = function (objHandle: HCkMime; mimeObject: HCkMime): wordbool; stdcall;
  TCkMime_NewMultipartAlternative = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_NewMultipartMixed = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_NewMultipartRelated = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_PartAt = function (objHandle: HCkMime; index: Integer; subPart: HCkMime): wordbool; stdcall;
  TCkMime_PartsToFiles = function (objHandle: HCkMime; path: PWideChar; st: HCkStringTable): wordbool; stdcall;
  TCkMime_RemoveHeaderField = procedure (objHandle: HCkMime; fieldName: PWideChar; bAllOccurrences: wordbool); stdcall;
  TCkMime_RemovePart = function (objHandle: HCkMime; index: Integer): wordbool; stdcall;
  TCkMime_SaveBody = function (objHandle: HCkMime; filename: PWideChar): wordbool; stdcall;
  TCkMime_SaveMime = function (objHandle: HCkMime; filename: PWideChar): wordbool; stdcall;
  TCkMime_SaveXml = function (objHandle: HCkMime; filename: PWideChar): wordbool; stdcall;
  TCkMime_SetBody = procedure (objHandle: HCkMime; str: PWideChar); stdcall;
  TCkMime_SetBodyBd = function (objHandle: HCkMime; bd: HCkBinData): wordbool; stdcall;
  TCkMime_SetBodyFromBinary = function (objHandle: HCkMime; binData: HCkByteData): wordbool; stdcall;
  TCkMime_SetBodyFromEncoded = function (objHandle: HCkMime; encoding: PWideChar; str: PWideChar): wordbool; stdcall;
  TCkMime_SetBodyFromFile = function (objHandle: HCkMime; fileName: PWideChar): wordbool; stdcall;
  TCkMime_SetBodyFromHtml = function (objHandle: HCkMime; str: PWideChar): wordbool; stdcall;
  TCkMime_SetBodyFromPlainText = function (objHandle: HCkMime; str: PWideChar): wordbool; stdcall;
  TCkMime_SetBodyFromXml = function (objHandle: HCkMime; str: PWideChar): wordbool; stdcall;
  TCkMime_SetHeaderField = function (objHandle: HCkMime; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkMime_SetVerifyCert = function (objHandle: HCkMime; cert: HCkCert): wordbool; stdcall;
  TCkMime_UnwrapSecurity = function (objHandle: HCkMime): wordbool; stdcall;
  TCkMime_UrlEncodeBody = procedure (objHandle: HCkMime; charset: PWideChar); stdcall;
  TCkMime_UseCertVault = function (objHandle: HCkMime; vault: HCkXmlCertVault): wordbool; stdcall;
  TCkMime_Verify = function (objHandle: HCkMime): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..198] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkMime_Create : HCkMime;
begin
  result := TCkMime_Create(_map(0, 'CkMime_Create'));
end;

procedure CkMime_Dispose (handle: HCkMime);
begin
  TCkMime_Dispose(_map(1, 'CkMime_Dispose'))
    (handle);
end;


procedure CkMime_getBoundary (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getBoundary(_map(2, 'CkMime_getBoundary'))
    (objHandle, outPropVal);
end;

procedure CkMime_putBoundary (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putBoundary(_map(3, 'CkMime_putBoundary'))
    (objHandle, newPropVal);
end;

function CkMime__boundary (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__boundary(_map(4, 'CkMime__boundary'))
    (objHandle);
end;

procedure CkMime_getCharset (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getCharset(_map(5, 'CkMime_getCharset'))
    (objHandle, outPropVal);
end;

procedure CkMime_putCharset (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putCharset(_map(6, 'CkMime_putCharset'))
    (objHandle, newPropVal);
end;

function CkMime__charset (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__charset(_map(7, 'CkMime__charset'))
    (objHandle);
end;

procedure CkMime_getCmsOptions (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getCmsOptions(_map(8, 'CkMime_getCmsOptions'))
    (objHandle, outPropVal);
end;

procedure CkMime_putCmsOptions (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putCmsOptions(_map(9, 'CkMime_putCmsOptions'))
    (objHandle, newPropVal);
end;

function CkMime__cmsOptions (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__cmsOptions(_map(10, 'CkMime__cmsOptions'))
    (objHandle);
end;

procedure CkMime_getContentType (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getContentType(_map(11, 'CkMime_getContentType'))
    (objHandle, outPropVal);
end;

procedure CkMime_putContentType (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putContentType(_map(12, 'CkMime_putContentType'))
    (objHandle, newPropVal);
end;

function CkMime__contentType (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__contentType(_map(13, 'CkMime__contentType'))
    (objHandle);
end;

procedure CkMime_getCurrentDateTime (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getCurrentDateTime(_map(14, 'CkMime_getCurrentDateTime'))
    (objHandle, outPropVal);
end;

function CkMime__currentDateTime (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__currentDateTime(_map(15, 'CkMime__currentDateTime'))
    (objHandle);
end;

procedure CkMime_getDebugLogFilePath (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getDebugLogFilePath(_map(16, 'CkMime_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkMime_putDebugLogFilePath (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putDebugLogFilePath(_map(17, 'CkMime_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkMime__debugLogFilePath (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__debugLogFilePath(_map(18, 'CkMime__debugLogFilePath'))
    (objHandle);
end;

procedure CkMime_getDisposition (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getDisposition(_map(19, 'CkMime_getDisposition'))
    (objHandle, outPropVal);
end;

procedure CkMime_putDisposition (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putDisposition(_map(20, 'CkMime_putDisposition'))
    (objHandle, newPropVal);
end;

function CkMime__disposition (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__disposition(_map(21, 'CkMime__disposition'))
    (objHandle);
end;

procedure CkMime_getEncoding (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getEncoding(_map(22, 'CkMime_getEncoding'))
    (objHandle, outPropVal);
end;

procedure CkMime_putEncoding (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putEncoding(_map(23, 'CkMime_putEncoding'))
    (objHandle, newPropVal);
end;

function CkMime__encoding (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__encoding(_map(24, 'CkMime__encoding'))
    (objHandle);
end;

procedure CkMime_getFilename (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getFilename(_map(25, 'CkMime_getFilename'))
    (objHandle, outPropVal);
end;

procedure CkMime_putFilename (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putFilename(_map(26, 'CkMime_putFilename'))
    (objHandle, newPropVal);
end;

function CkMime__filename (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__filename(_map(27, 'CkMime__filename'))
    (objHandle);
end;

procedure CkMime_getLastErrorHtml (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getLastErrorHtml(_map(28, 'CkMime_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkMime__lastErrorHtml (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__lastErrorHtml(_map(29, 'CkMime__lastErrorHtml'))
    (objHandle);
end;

procedure CkMime_getLastErrorText (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getLastErrorText(_map(30, 'CkMime_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkMime__lastErrorText (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__lastErrorText(_map(31, 'CkMime__lastErrorText'))
    (objHandle);
end;

procedure CkMime_getLastErrorXml (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getLastErrorXml(_map(32, 'CkMime_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkMime__lastErrorXml (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__lastErrorXml(_map(33, 'CkMime__lastErrorXml'))
    (objHandle);
end;

function CkMime_getLastMethodSuccess (objHandle: HCkMime): wordbool;
begin
    result := TCkMime_getLastMethodSuccess(_map(34, 'CkMime_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkMime_putLastMethodSuccess (objHandle: HCkMime; newPropVal: wordbool);
begin
  TCkMime_putLastMethodSuccess(_map(35, 'CkMime_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkMime_getMicalg (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getMicalg(_map(36, 'CkMime_getMicalg'))
    (objHandle, outPropVal);
end;

procedure CkMime_putMicalg (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putMicalg(_map(37, 'CkMime_putMicalg'))
    (objHandle, newPropVal);
end;

function CkMime__micalg (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__micalg(_map(38, 'CkMime__micalg'))
    (objHandle);
end;

procedure CkMime_getName (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getName(_map(39, 'CkMime_getName'))
    (objHandle, outPropVal);
end;

procedure CkMime_putName (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putName(_map(40, 'CkMime_putName'))
    (objHandle, newPropVal);
end;

function CkMime__name (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__name(_map(41, 'CkMime__name'))
    (objHandle);
end;

function CkMime_getNumDecryptCerts (objHandle: HCkMime): Integer;
begin
    result := TCkMime_getNumDecryptCerts(_map(42, 'CkMime_getNumDecryptCerts'))
    (objHandle);
end;

function CkMime_getNumEncryptCerts (objHandle: HCkMime): Integer;
begin
    result := TCkMime_getNumEncryptCerts(_map(43, 'CkMime_getNumEncryptCerts'))
    (objHandle);
end;

function CkMime_getNumHeaderFields (objHandle: HCkMime): Integer;
begin
    result := TCkMime_getNumHeaderFields(_map(44, 'CkMime_getNumHeaderFields'))
    (objHandle);
end;

function CkMime_getNumParts (objHandle: HCkMime): Integer;
begin
    result := TCkMime_getNumParts(_map(45, 'CkMime_getNumParts'))
    (objHandle);
end;

function CkMime_getNumSignerCerts (objHandle: HCkMime): Integer;
begin
    result := TCkMime_getNumSignerCerts(_map(46, 'CkMime_getNumSignerCerts'))
    (objHandle);
end;

procedure CkMime_getOaepHash (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getOaepHash(_map(47, 'CkMime_getOaepHash'))
    (objHandle, outPropVal);
end;

procedure CkMime_putOaepHash (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putOaepHash(_map(48, 'CkMime_putOaepHash'))
    (objHandle, newPropVal);
end;

function CkMime__oaepHash (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__oaepHash(_map(49, 'CkMime__oaepHash'))
    (objHandle);
end;

procedure CkMime_getOaepMgfHash (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getOaepMgfHash(_map(50, 'CkMime_getOaepMgfHash'))
    (objHandle, outPropVal);
end;

procedure CkMime_putOaepMgfHash (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putOaepMgfHash(_map(51, 'CkMime_putOaepMgfHash'))
    (objHandle, newPropVal);
end;

function CkMime__oaepMgfHash (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__oaepMgfHash(_map(52, 'CkMime__oaepMgfHash'))
    (objHandle);
end;

function CkMime_getOaepPadding (objHandle: HCkMime): wordbool;
begin
    result := TCkMime_getOaepPadding(_map(53, 'CkMime_getOaepPadding'))
    (objHandle);
end;

procedure CkMime_putOaepPadding (objHandle: HCkMime; newPropVal: wordbool);
begin
  TCkMime_putOaepPadding(_map(54, 'CkMime_putOaepPadding'))
    (objHandle, newPropVal);
end;

procedure CkMime_getPkcs7CryptAlg (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getPkcs7CryptAlg(_map(55, 'CkMime_getPkcs7CryptAlg'))
    (objHandle, outPropVal);
end;

procedure CkMime_putPkcs7CryptAlg (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putPkcs7CryptAlg(_map(56, 'CkMime_putPkcs7CryptAlg'))
    (objHandle, newPropVal);
end;

function CkMime__pkcs7CryptAlg (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__pkcs7CryptAlg(_map(57, 'CkMime__pkcs7CryptAlg'))
    (objHandle);
end;

function CkMime_getPkcs7KeyLength (objHandle: HCkMime): Integer;
begin
    result := TCkMime_getPkcs7KeyLength(_map(58, 'CkMime_getPkcs7KeyLength'))
    (objHandle);
end;

procedure CkMime_putPkcs7KeyLength (objHandle: HCkMime; newPropVal: Integer);
begin
  TCkMime_putPkcs7KeyLength(_map(59, 'CkMime_putPkcs7KeyLength'))
    (objHandle, newPropVal);
end;

procedure CkMime_getProtocol (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getProtocol(_map(60, 'CkMime_getProtocol'))
    (objHandle, outPropVal);
end;

procedure CkMime_putProtocol (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putProtocol(_map(61, 'CkMime_putProtocol'))
    (objHandle, newPropVal);
end;

function CkMime__protocol (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__protocol(_map(62, 'CkMime__protocol'))
    (objHandle);
end;

procedure CkMime_getSigningAlg (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getSigningAlg(_map(63, 'CkMime_getSigningAlg'))
    (objHandle, outPropVal);
end;

procedure CkMime_putSigningAlg (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putSigningAlg(_map(64, 'CkMime_putSigningAlg'))
    (objHandle, newPropVal);
end;

function CkMime__signingAlg (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__signingAlg(_map(65, 'CkMime__signingAlg'))
    (objHandle);
end;

procedure CkMime_getSigningHashAlg (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getSigningHashAlg(_map(66, 'CkMime_getSigningHashAlg'))
    (objHandle, outPropVal);
end;

procedure CkMime_putSigningHashAlg (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putSigningHashAlg(_map(67, 'CkMime_putSigningHashAlg'))
    (objHandle, newPropVal);
end;

function CkMime__signingHashAlg (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__signingHashAlg(_map(68, 'CkMime__signingHashAlg'))
    (objHandle);
end;

procedure CkMime_getUncommonOptions (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getUncommonOptions(_map(69, 'CkMime_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkMime_putUncommonOptions (objHandle: HCkMime; newPropVal: PWideChar);
begin
  TCkMime_putUncommonOptions(_map(70, 'CkMime_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkMime__uncommonOptions (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__uncommonOptions(_map(71, 'CkMime__uncommonOptions'))
    (objHandle);
end;

function CkMime_getUnwrapExtras (objHandle: HCkMime): wordbool;
begin
    result := TCkMime_getUnwrapExtras(_map(72, 'CkMime_getUnwrapExtras'))
    (objHandle);
end;

procedure CkMime_putUnwrapExtras (objHandle: HCkMime; newPropVal: wordbool);
begin
  TCkMime_putUnwrapExtras(_map(73, 'CkMime_putUnwrapExtras'))
    (objHandle, newPropVal);
end;

function CkMime_getUseMmDescription (objHandle: HCkMime): wordbool;
begin
    result := TCkMime_getUseMmDescription(_map(74, 'CkMime_getUseMmDescription'))
    (objHandle);
end;

procedure CkMime_putUseMmDescription (objHandle: HCkMime; newPropVal: wordbool);
begin
  TCkMime_putUseMmDescription(_map(75, 'CkMime_putUseMmDescription'))
    (objHandle, newPropVal);
end;

function CkMime_getUseXPkcs7 (objHandle: HCkMime): wordbool;
begin
    result := TCkMime_getUseXPkcs7(_map(76, 'CkMime_getUseXPkcs7'))
    (objHandle);
end;

procedure CkMime_putUseXPkcs7 (objHandle: HCkMime; newPropVal: wordbool);
begin
  TCkMime_putUseXPkcs7(_map(77, 'CkMime_putUseXPkcs7'))
    (objHandle, newPropVal);
end;

function CkMime_getVerboseLogging (objHandle: HCkMime): wordbool;
begin
    result := TCkMime_getVerboseLogging(_map(78, 'CkMime_getVerboseLogging'))
    (objHandle);
end;

procedure CkMime_putVerboseLogging (objHandle: HCkMime; newPropVal: wordbool);
begin
  TCkMime_putVerboseLogging(_map(79, 'CkMime_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkMime_getVersion (objHandle: HCkMime; outPropVal: HCkString);
begin
  TCkMime_getVersion(_map(80, 'CkMime_getVersion'))
    (objHandle, outPropVal);
end;

function CkMime__version (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__version(_map(81, 'CkMime__version'))
    (objHandle);
end;

procedure CkMime_AddContentLength (objHandle: HCkMime);
begin
  TCkMime_AddContentLength(_map(82, 'CkMime_AddContentLength'))
    (objHandle);
end;

function CkMime_AddDecryptCert (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_AddDecryptCert(_map(83, 'CkMime_AddDecryptCert'))
    (objHandle, cert);
end;

function CkMime_AddDetachedSignature (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_AddDetachedSignature(_map(84, 'CkMime_AddDetachedSignature'))
    (objHandle, cert);
end;

function CkMime_AddDetachedSignature2 (objHandle: HCkMime; cert: HCkCert; transferHeaderFields: wordbool): wordbool;
begin
  result := TCkMime_AddDetachedSignature2(_map(85, 'CkMime_AddDetachedSignature2'))
    (objHandle, cert, transferHeaderFields);
end;

function CkMime_AddDetachedSignaturePk (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkMime_AddDetachedSignaturePk(_map(86, 'CkMime_AddDetachedSignaturePk'))
    (objHandle, cert, privateKey);
end;

function CkMime_AddDetachedSignaturePk2 (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey; transferHeaderFields: wordbool): wordbool;
begin
  result := TCkMime_AddDetachedSignaturePk2(_map(87, 'CkMime_AddDetachedSignaturePk2'))
    (objHandle, cert, privateKey, transferHeaderFields);
end;

function CkMime_AddEncryptCert (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_AddEncryptCert(_map(88, 'CkMime_AddEncryptCert'))
    (objHandle, cert);
end;

function CkMime_AddHeaderField (objHandle: HCkMime; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkMime_AddHeaderField(_map(89, 'CkMime_AddHeaderField'))
    (objHandle, name, value);
end;

function CkMime_AddPfxSourceBd (objHandle: HCkMime; bd: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkMime_AddPfxSourceBd(_map(90, 'CkMime_AddPfxSourceBd'))
    (objHandle, bd, password);
end;

function CkMime_AddPfxSourceData (objHandle: HCkMime; pfxFileData: HCkByteData; pfxPassword: PWideChar): wordbool;
begin
  result := TCkMime_AddPfxSourceData(_map(91, 'CkMime_AddPfxSourceData'))
    (objHandle, pfxFileData, pfxPassword);
end;

function CkMime_AddPfxSourceFile (objHandle: HCkMime; pfxFilePath: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkMime_AddPfxSourceFile(_map(92, 'CkMime_AddPfxSourceFile'))
    (objHandle, pfxFilePath, password);
end;

function CkMime_AppendPart (objHandle: HCkMime; mime: HCkMime): wordbool;
begin
  result := TCkMime_AppendPart(_map(93, 'CkMime_AppendPart'))
    (objHandle, mime);
end;

function CkMime_AppendPartFromFile (objHandle: HCkMime; filename: PWideChar): wordbool;
begin
  result := TCkMime_AppendPartFromFile(_map(94, 'CkMime_AppendPartFromFile'))
    (objHandle, filename);
end;

function CkMime_AsnBodyToXml (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_AsnBodyToXml(_map(95, 'CkMime_AsnBodyToXml'))
    (objHandle, outStr);
end;

function CkMime__asnBodyToXml (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__asnBodyToXml(_map(96, 'CkMime__asnBodyToXml'))
    (objHandle);
end;

procedure CkMime_ClearEncryptCerts (objHandle: HCkMime);
begin
  TCkMime_ClearEncryptCerts(_map(97, 'CkMime_ClearEncryptCerts'))
    (objHandle);
end;

function CkMime_ContainsEncryptedParts (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_ContainsEncryptedParts(_map(98, 'CkMime_ContainsEncryptedParts'))
    (objHandle);
end;

function CkMime_ContainsSignedParts (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_ContainsSignedParts(_map(99, 'CkMime_ContainsSignedParts'))
    (objHandle);
end;

procedure CkMime_Convert8Bit (objHandle: HCkMime);
begin
  TCkMime_Convert8Bit(_map(100, 'CkMime_Convert8Bit'))
    (objHandle);
end;

function CkMime_ConvertToMultipartAlt (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_ConvertToMultipartAlt(_map(101, 'CkMime_ConvertToMultipartAlt'))
    (objHandle);
end;

function CkMime_ConvertToMultipartMixed (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_ConvertToMultipartMixed(_map(102, 'CkMime_ConvertToMultipartMixed'))
    (objHandle);
end;

function CkMime_ConvertToSigned (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_ConvertToSigned(_map(103, 'CkMime_ConvertToSigned'))
    (objHandle, cert);
end;

function CkMime_ConvertToSignedPk (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkMime_ConvertToSignedPk(_map(104, 'CkMime_ConvertToSignedPk'))
    (objHandle, cert, privateKey);
end;

function CkMime_Decrypt (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_Decrypt(_map(105, 'CkMime_Decrypt'))
    (objHandle);
end;

function CkMime_Decrypt2 (objHandle: HCkMime; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkMime_Decrypt2(_map(106, 'CkMime_Decrypt2'))
    (objHandle, cert, privateKey);
end;

function CkMime_DecryptUsingCert (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_DecryptUsingCert(_map(107, 'CkMime_DecryptUsingCert'))
    (objHandle, cert);
end;

function CkMime_DecryptUsingPfxData (objHandle: HCkMime; pfxData: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkMime_DecryptUsingPfxData(_map(108, 'CkMime_DecryptUsingPfxData'))
    (objHandle, pfxData, password);
end;

function CkMime_DecryptUsingPfxFile (objHandle: HCkMime; pfxFilePath: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkMime_DecryptUsingPfxFile(_map(109, 'CkMime_DecryptUsingPfxFile'))
    (objHandle, pfxFilePath, pfxPassword);
end;

function CkMime_Encrypt (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_Encrypt(_map(110, 'CkMime_Encrypt'))
    (objHandle, cert);
end;

function CkMime_EncryptN (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_EncryptN(_map(111, 'CkMime_EncryptN'))
    (objHandle);
end;

function CkMime_ExtractPartsToFiles (objHandle: HCkMime; dirPath: PWideChar): HCkStringArray;
begin
  result := TCkMime_ExtractPartsToFiles(_map(112, 'CkMime_ExtractPartsToFiles'))
    (objHandle, dirPath);
end;

function CkMime_FindIssuer (objHandle: HCkMime; cert: HCkCert): HCkCert;
begin
  result := TCkMime_FindIssuer(_map(113, 'CkMime_FindIssuer'))
    (objHandle, cert);
end;

function CkMime_GetBodyBd (objHandle: HCkMime; binDat: HCkBinData): wordbool;
begin
  result := TCkMime_GetBodyBd(_map(114, 'CkMime_GetBodyBd'))
    (objHandle, binDat);
end;

function CkMime_GetBodyBinary (objHandle: HCkMime; outData: HCkByteData): wordbool;
begin
  result := TCkMime_GetBodyBinary(_map(115, 'CkMime_GetBodyBinary'))
    (objHandle, outData);
end;

function CkMime_GetBodyDecoded (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetBodyDecoded(_map(116, 'CkMime_GetBodyDecoded'))
    (objHandle, outStr);
end;

function CkMime__getBodyDecoded (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__getBodyDecoded(_map(117, 'CkMime__getBodyDecoded'))
    (objHandle);
end;

function CkMime_GetBodyEncoded (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetBodyEncoded(_map(118, 'CkMime_GetBodyEncoded'))
    (objHandle, outStr);
end;

function CkMime__getBodyEncoded (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__getBodyEncoded(_map(119, 'CkMime__getBodyEncoded'))
    (objHandle);
end;

function CkMime_GetEncryptCert (objHandle: HCkMime; index: Integer): HCkCert;
begin
  result := TCkMime_GetEncryptCert(_map(120, 'CkMime_GetEncryptCert'))
    (objHandle, index);
end;

function CkMime_GetEntireBody (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetEntireBody(_map(121, 'CkMime_GetEntireBody'))
    (objHandle, outStr);
end;

function CkMime__getEntireBody (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__getEntireBody(_map(122, 'CkMime__getEntireBody'))
    (objHandle);
end;

function CkMime_GetEntireHead (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetEntireHead(_map(123, 'CkMime_GetEntireHead'))
    (objHandle, outStr);
end;

function CkMime__getEntireHead (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__getEntireHead(_map(124, 'CkMime__getEntireHead'))
    (objHandle);
end;

function CkMime_GetHeaderField (objHandle: HCkMime; fieldName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetHeaderField(_map(125, 'CkMime_GetHeaderField'))
    (objHandle, fieldName, outStr);
end;

function CkMime__getHeaderField (objHandle: HCkMime; fieldName: PWideChar): PWideChar;
begin
  result := TCkMime__getHeaderField(_map(126, 'CkMime__getHeaderField'))
    (objHandle, fieldName);
end;

function CkMime_GetHeaderFieldAttribute (objHandle: HCkMime; name: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetHeaderFieldAttribute(_map(127, 'CkMime_GetHeaderFieldAttribute'))
    (objHandle, name, attrName, outStr);
end;

function CkMime__getHeaderFieldAttribute (objHandle: HCkMime; name: PWideChar; attrName: PWideChar): PWideChar;
begin
  result := TCkMime__getHeaderFieldAttribute(_map(128, 'CkMime__getHeaderFieldAttribute'))
    (objHandle, name, attrName);
end;

function CkMime_GetHeaderFieldName (objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetHeaderFieldName(_map(129, 'CkMime_GetHeaderFieldName'))
    (objHandle, index, outStr);
end;

function CkMime__getHeaderFieldName (objHandle: HCkMime; index: Integer): PWideChar;
begin
  result := TCkMime__getHeaderFieldName(_map(130, 'CkMime__getHeaderFieldName'))
    (objHandle, index);
end;

function CkMime_GetHeaderFieldValue (objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetHeaderFieldValue(_map(131, 'CkMime_GetHeaderFieldValue'))
    (objHandle, index, outStr);
end;

function CkMime__getHeaderFieldValue (objHandle: HCkMime; index: Integer): PWideChar;
begin
  result := TCkMime__getHeaderFieldValue(_map(132, 'CkMime__getHeaderFieldValue'))
    (objHandle, index);
end;

procedure CkMime_GetLastJsonData (objHandle: HCkMime; json: HCkJsonObject);
begin
  TCkMime_GetLastJsonData(_map(133, 'CkMime_GetLastJsonData'))
    (objHandle, json);
end;

function CkMime_GetMime (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetMime(_map(134, 'CkMime_GetMime'))
    (objHandle, outStr);
end;

function CkMime__getMime (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__getMime(_map(135, 'CkMime__getMime'))
    (objHandle);
end;

function CkMime_GetMimeBd (objHandle: HCkMime; bindat: HCkBinData): wordbool;
begin
  result := TCkMime_GetMimeBd(_map(136, 'CkMime_GetMimeBd'))
    (objHandle, bindat);
end;

function CkMime_GetMimeBytes (objHandle: HCkMime; outData: HCkByteData): wordbool;
begin
  result := TCkMime_GetMimeBytes(_map(137, 'CkMime_GetMimeBytes'))
    (objHandle, outData);
end;

function CkMime_GetMimeSb (objHandle: HCkMime; sb: HCkStringBuilder): wordbool;
begin
  result := TCkMime_GetMimeSb(_map(138, 'CkMime_GetMimeSb'))
    (objHandle, sb);
end;

function CkMime_GetPart (objHandle: HCkMime; index: Integer): HCkMime;
begin
  result := TCkMime_GetPart(_map(139, 'CkMime_GetPart'))
    (objHandle, index);
end;

function CkMime_GetSignatureSigningTimeStr (objHandle: HCkMime; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetSignatureSigningTimeStr(_map(140, 'CkMime_GetSignatureSigningTimeStr'))
    (objHandle, index, outStr);
end;

function CkMime__getSignatureSigningTimeStr (objHandle: HCkMime; index: Integer): PWideChar;
begin
  result := TCkMime__getSignatureSigningTimeStr(_map(141, 'CkMime__getSignatureSigningTimeStr'))
    (objHandle, index);
end;

function CkMime_GetSignerCert (objHandle: HCkMime; index: Integer): HCkCert;
begin
  result := TCkMime_GetSignerCert(_map(142, 'CkMime_GetSignerCert'))
    (objHandle, index);
end;

function CkMime_GetSignerCertChain (objHandle: HCkMime; index: Integer): HCkCertChain;
begin
  result := TCkMime_GetSignerCertChain(_map(143, 'CkMime_GetSignerCertChain'))
    (objHandle, index);
end;

function CkMime_GetStructure (objHandle: HCkMime; fmt: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetStructure(_map(144, 'CkMime_GetStructure'))
    (objHandle, fmt, outStr);
end;

function CkMime__getStructure (objHandle: HCkMime; fmt: PWideChar): PWideChar;
begin
  result := TCkMime__getStructure(_map(145, 'CkMime__getStructure'))
    (objHandle, fmt);
end;

function CkMime_GetXml (objHandle: HCkMime; outStr: HCkString): wordbool;
begin
  result := TCkMime_GetXml(_map(146, 'CkMime_GetXml'))
    (objHandle, outStr);
end;

function CkMime__getXml (objHandle: HCkMime): PWideChar;
begin
  result := TCkMime__getXml(_map(147, 'CkMime__getXml'))
    (objHandle);
end;

function CkMime_HasSignatureSigningTime (objHandle: HCkMime; index: Integer): wordbool;
begin
  result := TCkMime_HasSignatureSigningTime(_map(148, 'CkMime_HasSignatureSigningTime'))
    (objHandle, index);
end;

function CkMime_IsApplicationData (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsApplicationData(_map(149, 'CkMime_IsApplicationData'))
    (objHandle);
end;

function CkMime_IsAttachment (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsAttachment(_map(150, 'CkMime_IsAttachment'))
    (objHandle);
end;

function CkMime_IsAudio (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsAudio(_map(151, 'CkMime_IsAudio'))
    (objHandle);
end;

function CkMime_IsEncrypted (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsEncrypted(_map(152, 'CkMime_IsEncrypted'))
    (objHandle);
end;

function CkMime_IsHtml (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsHtml(_map(153, 'CkMime_IsHtml'))
    (objHandle);
end;

function CkMime_IsImage (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsImage(_map(154, 'CkMime_IsImage'))
    (objHandle);
end;

function CkMime_IsMultipart (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsMultipart(_map(155, 'CkMime_IsMultipart'))
    (objHandle);
end;

function CkMime_IsMultipartAlternative (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsMultipartAlternative(_map(156, 'CkMime_IsMultipartAlternative'))
    (objHandle);
end;

function CkMime_IsMultipartMixed (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsMultipartMixed(_map(157, 'CkMime_IsMultipartMixed'))
    (objHandle);
end;

function CkMime_IsMultipartRelated (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsMultipartRelated(_map(158, 'CkMime_IsMultipartRelated'))
    (objHandle);
end;

function CkMime_IsPlainText (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsPlainText(_map(159, 'CkMime_IsPlainText'))
    (objHandle);
end;

function CkMime_IsSigned (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsSigned(_map(160, 'CkMime_IsSigned'))
    (objHandle);
end;

function CkMime_IsText (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsText(_map(161, 'CkMime_IsText'))
    (objHandle);
end;

function CkMime_IsVideo (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsVideo(_map(162, 'CkMime_IsVideo'))
    (objHandle);
end;

function CkMime_IsXml (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_IsXml(_map(163, 'CkMime_IsXml'))
    (objHandle);
end;

function CkMime_LastDecryptCert (objHandle: HCkMime; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkMime_LastDecryptCert(_map(164, 'CkMime_LastDecryptCert'))
    (objHandle, index, cert);
end;

function CkMime_LastJsonData (objHandle: HCkMime): HCkJsonObject;
begin
  result := TCkMime_LastJsonData(_map(165, 'CkMime_LastJsonData'))
    (objHandle);
end;

function CkMime_LastSignerCert (objHandle: HCkMime; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkMime_LastSignerCert(_map(166, 'CkMime_LastSignerCert'))
    (objHandle, index, cert);
end;

function CkMime_LoadMime (objHandle: HCkMime; mimeMsg: PWideChar): wordbool;
begin
  result := TCkMime_LoadMime(_map(167, 'CkMime_LoadMime'))
    (objHandle, mimeMsg);
end;

function CkMime_LoadMimeBd (objHandle: HCkMime; bindat: HCkBinData): wordbool;
begin
  result := TCkMime_LoadMimeBd(_map(168, 'CkMime_LoadMimeBd'))
    (objHandle, bindat);
end;

function CkMime_LoadMimeBytes (objHandle: HCkMime; binData: HCkByteData): wordbool;
begin
  result := TCkMime_LoadMimeBytes(_map(169, 'CkMime_LoadMimeBytes'))
    (objHandle, binData);
end;

function CkMime_LoadMimeFile (objHandle: HCkMime; fileName: PWideChar): wordbool;
begin
  result := TCkMime_LoadMimeFile(_map(170, 'CkMime_LoadMimeFile'))
    (objHandle, fileName);
end;

function CkMime_LoadMimeSb (objHandle: HCkMime; sb: HCkStringBuilder): wordbool;
begin
  result := TCkMime_LoadMimeSb(_map(171, 'CkMime_LoadMimeSb'))
    (objHandle, sb);
end;

function CkMime_LoadXml (objHandle: HCkMime; xml: PWideChar): wordbool;
begin
  result := TCkMime_LoadXml(_map(172, 'CkMime_LoadXml'))
    (objHandle, xml);
end;

function CkMime_LoadXmlFile (objHandle: HCkMime; fileName: PWideChar): wordbool;
begin
  result := TCkMime_LoadXmlFile(_map(173, 'CkMime_LoadXmlFile'))
    (objHandle, fileName);
end;

function CkMime_NewMessageRfc822 (objHandle: HCkMime; mimeObject: HCkMime): wordbool;
begin
  result := TCkMime_NewMessageRfc822(_map(174, 'CkMime_NewMessageRfc822'))
    (objHandle, mimeObject);
end;

function CkMime_NewMultipartAlternative (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_NewMultipartAlternative(_map(175, 'CkMime_NewMultipartAlternative'))
    (objHandle);
end;

function CkMime_NewMultipartMixed (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_NewMultipartMixed(_map(176, 'CkMime_NewMultipartMixed'))
    (objHandle);
end;

function CkMime_NewMultipartRelated (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_NewMultipartRelated(_map(177, 'CkMime_NewMultipartRelated'))
    (objHandle);
end;

function CkMime_PartAt (objHandle: HCkMime; index: Integer; subPart: HCkMime): wordbool;
begin
  result := TCkMime_PartAt(_map(178, 'CkMime_PartAt'))
    (objHandle, index, subPart);
end;

function CkMime_PartsToFiles (objHandle: HCkMime; path: PWideChar; st: HCkStringTable): wordbool;
begin
  result := TCkMime_PartsToFiles(_map(179, 'CkMime_PartsToFiles'))
    (objHandle, path, st);
end;

procedure CkMime_RemoveHeaderField (objHandle: HCkMime; fieldName: PWideChar; bAllOccurrences: wordbool);
begin
  TCkMime_RemoveHeaderField(_map(180, 'CkMime_RemoveHeaderField'))
    (objHandle, fieldName, bAllOccurrences);
end;

function CkMime_RemovePart (objHandle: HCkMime; index: Integer): wordbool;
begin
  result := TCkMime_RemovePart(_map(181, 'CkMime_RemovePart'))
    (objHandle, index);
end;

function CkMime_SaveBody (objHandle: HCkMime; filename: PWideChar): wordbool;
begin
  result := TCkMime_SaveBody(_map(182, 'CkMime_SaveBody'))
    (objHandle, filename);
end;

function CkMime_SaveMime (objHandle: HCkMime; filename: PWideChar): wordbool;
begin
  result := TCkMime_SaveMime(_map(183, 'CkMime_SaveMime'))
    (objHandle, filename);
end;

function CkMime_SaveXml (objHandle: HCkMime; filename: PWideChar): wordbool;
begin
  result := TCkMime_SaveXml(_map(184, 'CkMime_SaveXml'))
    (objHandle, filename);
end;

procedure CkMime_SetBody (objHandle: HCkMime; str: PWideChar);
begin
  TCkMime_SetBody(_map(185, 'CkMime_SetBody'))
    (objHandle, str);
end;

function CkMime_SetBodyBd (objHandle: HCkMime; bd: HCkBinData): wordbool;
begin
  result := TCkMime_SetBodyBd(_map(186, 'CkMime_SetBodyBd'))
    (objHandle, bd);
end;

function CkMime_SetBodyFromBinary (objHandle: HCkMime; binData: HCkByteData): wordbool;
begin
  result := TCkMime_SetBodyFromBinary(_map(187, 'CkMime_SetBodyFromBinary'))
    (objHandle, binData);
end;

function CkMime_SetBodyFromEncoded (objHandle: HCkMime; encoding: PWideChar; str: PWideChar): wordbool;
begin
  result := TCkMime_SetBodyFromEncoded(_map(188, 'CkMime_SetBodyFromEncoded'))
    (objHandle, encoding, str);
end;

function CkMime_SetBodyFromFile (objHandle: HCkMime; fileName: PWideChar): wordbool;
begin
  result := TCkMime_SetBodyFromFile(_map(189, 'CkMime_SetBodyFromFile'))
    (objHandle, fileName);
end;

function CkMime_SetBodyFromHtml (objHandle: HCkMime; str: PWideChar): wordbool;
begin
  result := TCkMime_SetBodyFromHtml(_map(190, 'CkMime_SetBodyFromHtml'))
    (objHandle, str);
end;

function CkMime_SetBodyFromPlainText (objHandle: HCkMime; str: PWideChar): wordbool;
begin
  result := TCkMime_SetBodyFromPlainText(_map(191, 'CkMime_SetBodyFromPlainText'))
    (objHandle, str);
end;

function CkMime_SetBodyFromXml (objHandle: HCkMime; str: PWideChar): wordbool;
begin
  result := TCkMime_SetBodyFromXml(_map(192, 'CkMime_SetBodyFromXml'))
    (objHandle, str);
end;

function CkMime_SetHeaderField (objHandle: HCkMime; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkMime_SetHeaderField(_map(193, 'CkMime_SetHeaderField'))
    (objHandle, name, value);
end;

function CkMime_SetVerifyCert (objHandle: HCkMime; cert: HCkCert): wordbool;
begin
  result := TCkMime_SetVerifyCert(_map(194, 'CkMime_SetVerifyCert'))
    (objHandle, cert);
end;

function CkMime_UnwrapSecurity (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_UnwrapSecurity(_map(195, 'CkMime_UnwrapSecurity'))
    (objHandle);
end;

procedure CkMime_UrlEncodeBody (objHandle: HCkMime; charset: PWideChar);
begin
  TCkMime_UrlEncodeBody(_map(196, 'CkMime_UrlEncodeBody'))
    (objHandle, charset);
end;

function CkMime_UseCertVault (objHandle: HCkMime; vault: HCkXmlCertVault): wordbool;
begin
  result := TCkMime_UseCertVault(_map(197, 'CkMime_UseCertVault'))
    (objHandle, vault);
end;

function CkMime_Verify (objHandle: HCkMime): wordbool;
begin
  result := TCkMime_Verify(_map(198, 'CkMime_Verify'))
    (objHandle);
end;

end.
