unit OAuth1;

interface

type

HCkPrivateKey = Pointer;
HCkOAuth1 = Pointer;
HCkString = Pointer;


function CkOAuth1_Create: HCkOAuth1;  stdcall;
procedure CkOAuth1_Dispose(handle: HCkOAuth1); stdcall;
procedure CkOAuth1_getAuthorizationHeader(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__authorizationHeader(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getBaseString(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__baseString(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getConsumerKey(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putConsumerKey(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__consumerKey(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getConsumerSecret(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putConsumerSecret(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__consumerSecret(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getDebugLogFilePath(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putDebugLogFilePath(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__debugLogFilePath(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getEncodedSignature(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__encodedSignature(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getGeneratedUrl(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__generatedUrl(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getHmacKey(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__hmacKey(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getLastErrorHtml(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__lastErrorHtml(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getLastErrorText(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__lastErrorText(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getLastErrorXml(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__lastErrorXml(objHandle: HCkOAuth1): PWideChar;
function CkOAuth1_getLastMethodSuccess(objHandle: HCkOAuth1): wordbool;
procedure CkOAuth1_putLastMethodSuccess(objHandle: HCkOAuth1; newPropVal: wordbool);
procedure CkOAuth1_getNonce(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putNonce(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__nonce(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getOauthMethod(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putOauthMethod(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__oauthMethod(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getOauthUrl(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putOauthUrl(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__oauthUrl(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getOauthVersion(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putOauthVersion(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__oauthVersion(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getQueryString(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__queryString(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getRealm(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putRealm(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__realm(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getSignature(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__signature(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getSignatureMethod(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putSignatureMethod(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__signatureMethod(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getTimestamp(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putTimestamp(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__timestamp(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getToken(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putToken(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__token(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getTokenSecret(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putTokenSecret(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__tokenSecret(objHandle: HCkOAuth1): PWideChar;
procedure CkOAuth1_getUncommonOptions(objHandle: HCkOAuth1; outPropVal: HCkString);
procedure CkOAuth1_putUncommonOptions(objHandle: HCkOAuth1; newPropVal: PWideChar);
function CkOAuth1__uncommonOptions(objHandle: HCkOAuth1): PWideChar;
function CkOAuth1_getVerboseLogging(objHandle: HCkOAuth1): wordbool;
procedure CkOAuth1_putVerboseLogging(objHandle: HCkOAuth1; newPropVal: wordbool);
procedure CkOAuth1_getVersion(objHandle: HCkOAuth1; outPropVal: HCkString);
function CkOAuth1__version(objHandle: HCkOAuth1): PWideChar;
function CkOAuth1_AddParam(objHandle: HCkOAuth1; name: PWideChar; value: PWideChar): wordbool;
function CkOAuth1_Generate(objHandle: HCkOAuth1): wordbool;
function CkOAuth1_GenNonce(objHandle: HCkOAuth1; numBytes: Integer): wordbool;
function CkOAuth1_GenTimestamp(objHandle: HCkOAuth1): wordbool;
function CkOAuth1_RemoveParam(objHandle: HCkOAuth1; name: PWideChar): wordbool;
function CkOAuth1_SetRsaKey(objHandle: HCkOAuth1; privKey: HCkPrivateKey): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkOAuth1_Create = function : HCkOAuth1; stdcall;
  TCkOAuth1_Dispose = procedure (handle: HCkOAuth1); stdcall;
  TCkOAuth1_getAuthorizationHeader = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__authorizationHeader = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getBaseString = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__baseString = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getConsumerKey = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putConsumerKey = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__consumerKey = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getConsumerSecret = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putConsumerSecret = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__consumerSecret = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getDebugLogFilePath = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putDebugLogFilePath = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__debugLogFilePath = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getEncodedSignature = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__encodedSignature = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getGeneratedUrl = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__generatedUrl = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getHmacKey = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__hmacKey = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getLastErrorHtml = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__lastErrorHtml = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getLastErrorText = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__lastErrorText = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getLastErrorXml = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__lastErrorXml = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getLastMethodSuccess = function (objHandle: HCkOAuth1): wordbool; stdcall;
  TCkOAuth1_putLastMethodSuccess = procedure (objHandle: HCkOAuth1; newPropVal: wordbool); stdcall;
  TCkOAuth1_getNonce = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putNonce = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__nonce = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getOauthMethod = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putOauthMethod = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__oauthMethod = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getOauthUrl = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putOauthUrl = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__oauthUrl = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getOauthVersion = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putOauthVersion = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__oauthVersion = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getQueryString = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__queryString = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getRealm = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putRealm = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__realm = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getSignature = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__signature = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getSignatureMethod = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putSignatureMethod = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__signatureMethod = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getTimestamp = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putTimestamp = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__timestamp = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getToken = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putToken = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__token = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getTokenSecret = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putTokenSecret = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__tokenSecret = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getUncommonOptions = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1_putUncommonOptions = procedure (objHandle: HCkOAuth1; newPropVal: PWideChar); stdcall;
  TCkOAuth1__uncommonOptions = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_getVerboseLogging = function (objHandle: HCkOAuth1): wordbool; stdcall;
  TCkOAuth1_putVerboseLogging = procedure (objHandle: HCkOAuth1; newPropVal: wordbool); stdcall;
  TCkOAuth1_getVersion = procedure (objHandle: HCkOAuth1; outPropVal: HCkString); stdcall;
  TCkOAuth1__version = function (objHandle: HCkOAuth1): PWideChar; stdcall;
  TCkOAuth1_AddParam = function (objHandle: HCkOAuth1; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkOAuth1_Generate = function (objHandle: HCkOAuth1): wordbool; stdcall;
  TCkOAuth1_GenNonce = function (objHandle: HCkOAuth1; numBytes: Integer): wordbool; stdcall;
  TCkOAuth1_GenTimestamp = function (objHandle: HCkOAuth1): wordbool; stdcall;
  TCkOAuth1_RemoveParam = function (objHandle: HCkOAuth1; name: PWideChar): wordbool; stdcall;
  TCkOAuth1_SetRsaKey = function (objHandle: HCkOAuth1; privKey: HCkPrivateKey): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..72] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkOAuth1_Create : HCkOAuth1;
begin
  result := TCkOAuth1_Create(_map(0, 'CkOAuth1_Create'));
end;

procedure CkOAuth1_Dispose (handle: HCkOAuth1);
begin
  TCkOAuth1_Dispose(_map(1, 'CkOAuth1_Dispose'))
    (handle);
end;


procedure CkOAuth1_getAuthorizationHeader (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getAuthorizationHeader(_map(2, 'CkOAuth1_getAuthorizationHeader'))
    (objHandle, outPropVal);
end;

function CkOAuth1__authorizationHeader (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__authorizationHeader(_map(3, 'CkOAuth1__authorizationHeader'))
    (objHandle);
end;

procedure CkOAuth1_getBaseString (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getBaseString(_map(4, 'CkOAuth1_getBaseString'))
    (objHandle, outPropVal);
end;

function CkOAuth1__baseString (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__baseString(_map(5, 'CkOAuth1__baseString'))
    (objHandle);
end;

procedure CkOAuth1_getConsumerKey (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getConsumerKey(_map(6, 'CkOAuth1_getConsumerKey'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putConsumerKey (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putConsumerKey(_map(7, 'CkOAuth1_putConsumerKey'))
    (objHandle, newPropVal);
end;

function CkOAuth1__consumerKey (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__consumerKey(_map(8, 'CkOAuth1__consumerKey'))
    (objHandle);
end;

procedure CkOAuth1_getConsumerSecret (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getConsumerSecret(_map(9, 'CkOAuth1_getConsumerSecret'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putConsumerSecret (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putConsumerSecret(_map(10, 'CkOAuth1_putConsumerSecret'))
    (objHandle, newPropVal);
end;

function CkOAuth1__consumerSecret (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__consumerSecret(_map(11, 'CkOAuth1__consumerSecret'))
    (objHandle);
end;

procedure CkOAuth1_getDebugLogFilePath (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getDebugLogFilePath(_map(12, 'CkOAuth1_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putDebugLogFilePath (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putDebugLogFilePath(_map(13, 'CkOAuth1_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkOAuth1__debugLogFilePath (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__debugLogFilePath(_map(14, 'CkOAuth1__debugLogFilePath'))
    (objHandle);
end;

procedure CkOAuth1_getEncodedSignature (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getEncodedSignature(_map(15, 'CkOAuth1_getEncodedSignature'))
    (objHandle, outPropVal);
end;

function CkOAuth1__encodedSignature (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__encodedSignature(_map(16, 'CkOAuth1__encodedSignature'))
    (objHandle);
end;

procedure CkOAuth1_getGeneratedUrl (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getGeneratedUrl(_map(17, 'CkOAuth1_getGeneratedUrl'))
    (objHandle, outPropVal);
end;

function CkOAuth1__generatedUrl (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__generatedUrl(_map(18, 'CkOAuth1__generatedUrl'))
    (objHandle);
end;

procedure CkOAuth1_getHmacKey (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getHmacKey(_map(19, 'CkOAuth1_getHmacKey'))
    (objHandle, outPropVal);
end;

function CkOAuth1__hmacKey (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__hmacKey(_map(20, 'CkOAuth1__hmacKey'))
    (objHandle);
end;

procedure CkOAuth1_getLastErrorHtml (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getLastErrorHtml(_map(21, 'CkOAuth1_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkOAuth1__lastErrorHtml (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__lastErrorHtml(_map(22, 'CkOAuth1__lastErrorHtml'))
    (objHandle);
end;

procedure CkOAuth1_getLastErrorText (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getLastErrorText(_map(23, 'CkOAuth1_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkOAuth1__lastErrorText (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__lastErrorText(_map(24, 'CkOAuth1__lastErrorText'))
    (objHandle);
end;

procedure CkOAuth1_getLastErrorXml (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getLastErrorXml(_map(25, 'CkOAuth1_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkOAuth1__lastErrorXml (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__lastErrorXml(_map(26, 'CkOAuth1__lastErrorXml'))
    (objHandle);
end;

function CkOAuth1_getLastMethodSuccess (objHandle: HCkOAuth1): wordbool;
begin
    result := TCkOAuth1_getLastMethodSuccess(_map(27, 'CkOAuth1_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkOAuth1_putLastMethodSuccess (objHandle: HCkOAuth1; newPropVal: wordbool);
begin
  TCkOAuth1_putLastMethodSuccess(_map(28, 'CkOAuth1_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkOAuth1_getNonce (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getNonce(_map(29, 'CkOAuth1_getNonce'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putNonce (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putNonce(_map(30, 'CkOAuth1_putNonce'))
    (objHandle, newPropVal);
end;

function CkOAuth1__nonce (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__nonce(_map(31, 'CkOAuth1__nonce'))
    (objHandle);
end;

procedure CkOAuth1_getOauthMethod (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getOauthMethod(_map(32, 'CkOAuth1_getOauthMethod'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putOauthMethod (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putOauthMethod(_map(33, 'CkOAuth1_putOauthMethod'))
    (objHandle, newPropVal);
end;

function CkOAuth1__oauthMethod (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__oauthMethod(_map(34, 'CkOAuth1__oauthMethod'))
    (objHandle);
end;

procedure CkOAuth1_getOauthUrl (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getOauthUrl(_map(35, 'CkOAuth1_getOauthUrl'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putOauthUrl (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putOauthUrl(_map(36, 'CkOAuth1_putOauthUrl'))
    (objHandle, newPropVal);
end;

function CkOAuth1__oauthUrl (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__oauthUrl(_map(37, 'CkOAuth1__oauthUrl'))
    (objHandle);
end;

procedure CkOAuth1_getOauthVersion (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getOauthVersion(_map(38, 'CkOAuth1_getOauthVersion'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putOauthVersion (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putOauthVersion(_map(39, 'CkOAuth1_putOauthVersion'))
    (objHandle, newPropVal);
end;

function CkOAuth1__oauthVersion (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__oauthVersion(_map(40, 'CkOAuth1__oauthVersion'))
    (objHandle);
end;

procedure CkOAuth1_getQueryString (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getQueryString(_map(41, 'CkOAuth1_getQueryString'))
    (objHandle, outPropVal);
end;

function CkOAuth1__queryString (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__queryString(_map(42, 'CkOAuth1__queryString'))
    (objHandle);
end;

procedure CkOAuth1_getRealm (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getRealm(_map(43, 'CkOAuth1_getRealm'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putRealm (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putRealm(_map(44, 'CkOAuth1_putRealm'))
    (objHandle, newPropVal);
end;

function CkOAuth1__realm (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__realm(_map(45, 'CkOAuth1__realm'))
    (objHandle);
end;

procedure CkOAuth1_getSignature (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getSignature(_map(46, 'CkOAuth1_getSignature'))
    (objHandle, outPropVal);
end;

function CkOAuth1__signature (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__signature(_map(47, 'CkOAuth1__signature'))
    (objHandle);
end;

procedure CkOAuth1_getSignatureMethod (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getSignatureMethod(_map(48, 'CkOAuth1_getSignatureMethod'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putSignatureMethod (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putSignatureMethod(_map(49, 'CkOAuth1_putSignatureMethod'))
    (objHandle, newPropVal);
end;

function CkOAuth1__signatureMethod (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__signatureMethod(_map(50, 'CkOAuth1__signatureMethod'))
    (objHandle);
end;

procedure CkOAuth1_getTimestamp (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getTimestamp(_map(51, 'CkOAuth1_getTimestamp'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putTimestamp (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putTimestamp(_map(52, 'CkOAuth1_putTimestamp'))
    (objHandle, newPropVal);
end;

function CkOAuth1__timestamp (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__timestamp(_map(53, 'CkOAuth1__timestamp'))
    (objHandle);
end;

procedure CkOAuth1_getToken (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getToken(_map(54, 'CkOAuth1_getToken'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putToken (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putToken(_map(55, 'CkOAuth1_putToken'))
    (objHandle, newPropVal);
end;

function CkOAuth1__token (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__token(_map(56, 'CkOAuth1__token'))
    (objHandle);
end;

procedure CkOAuth1_getTokenSecret (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getTokenSecret(_map(57, 'CkOAuth1_getTokenSecret'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putTokenSecret (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putTokenSecret(_map(58, 'CkOAuth1_putTokenSecret'))
    (objHandle, newPropVal);
end;

function CkOAuth1__tokenSecret (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__tokenSecret(_map(59, 'CkOAuth1__tokenSecret'))
    (objHandle);
end;

procedure CkOAuth1_getUncommonOptions (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getUncommonOptions(_map(60, 'CkOAuth1_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkOAuth1_putUncommonOptions (objHandle: HCkOAuth1; newPropVal: PWideChar);
begin
  TCkOAuth1_putUncommonOptions(_map(61, 'CkOAuth1_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkOAuth1__uncommonOptions (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__uncommonOptions(_map(62, 'CkOAuth1__uncommonOptions'))
    (objHandle);
end;

function CkOAuth1_getVerboseLogging (objHandle: HCkOAuth1): wordbool;
begin
    result := TCkOAuth1_getVerboseLogging(_map(63, 'CkOAuth1_getVerboseLogging'))
    (objHandle);
end;

procedure CkOAuth1_putVerboseLogging (objHandle: HCkOAuth1; newPropVal: wordbool);
begin
  TCkOAuth1_putVerboseLogging(_map(64, 'CkOAuth1_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkOAuth1_getVersion (objHandle: HCkOAuth1; outPropVal: HCkString);
begin
  TCkOAuth1_getVersion(_map(65, 'CkOAuth1_getVersion'))
    (objHandle, outPropVal);
end;

function CkOAuth1__version (objHandle: HCkOAuth1): PWideChar;
begin
  result := TCkOAuth1__version(_map(66, 'CkOAuth1__version'))
    (objHandle);
end;

function CkOAuth1_AddParam (objHandle: HCkOAuth1; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkOAuth1_AddParam(_map(67, 'CkOAuth1_AddParam'))
    (objHandle, name, value);
end;

function CkOAuth1_Generate (objHandle: HCkOAuth1): wordbool;
begin
  result := TCkOAuth1_Generate(_map(68, 'CkOAuth1_Generate'))
    (objHandle);
end;

function CkOAuth1_GenNonce (objHandle: HCkOAuth1; numBytes: Integer): wordbool;
begin
  result := TCkOAuth1_GenNonce(_map(69, 'CkOAuth1_GenNonce'))
    (objHandle, numBytes);
end;

function CkOAuth1_GenTimestamp (objHandle: HCkOAuth1): wordbool;
begin
  result := TCkOAuth1_GenTimestamp(_map(70, 'CkOAuth1_GenTimestamp'))
    (objHandle);
end;

function CkOAuth1_RemoveParam (objHandle: HCkOAuth1; name: PWideChar): wordbool;
begin
  result := TCkOAuth1_RemoveParam(_map(71, 'CkOAuth1_RemoveParam'))
    (objHandle, name);
end;

function CkOAuth1_SetRsaKey (objHandle: HCkOAuth1; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkOAuth1_SetRsaKey(_map(72, 'CkOAuth1_SetRsaKey'))
    (objHandle, privKey);
end;

end.
