unit OAuth2;

interface

type

HCkTask = Pointer;
HCkStringBuilder = Pointer;
HCkSocket = Pointer;
HCkOAuth2 = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TOAuth2AbortCheck = function(): Integer; cdecl;
TOAuth2ProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TOAuth2PercentDone = function(pctDone: Integer): Integer; cdecl;
TOAuth2TaskCompleted = procedure(task: HCkTask); cdecl;


function CkOAuth2_Create: HCkOAuth2;  stdcall;
procedure CkOAuth2_Dispose(handle: HCkOAuth2); stdcall;

procedure CkOAuth2_SetAbortCheck(objHandle: HCkOAuth2; fn: TOAuth2AbortCheck) stdcall;
procedure CkOAuth2_SetProgressInfo(objHandle: HCkOAuth2; fn: TOAuth2ProgressInfo) stdcall;
procedure CkOAuth2_SetPercentDone(objHandle: HCkOAuth2; fn: TOAuth2PercentDone) stdcall;
procedure CkOAuth2_SetTaskCompleted(objHandle: HCkOAuth2; fn: TOAuth2TaskCompleted) stdcall;
procedure CkOAuth2_getAccessToken(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putAccessToken(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__accessToken(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getAccessTokenResponse(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__accessTokenResponse(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getAppCallbackUrl(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putAppCallbackUrl(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__appCallbackUrl(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_getAuthFlowState(objHandle: HCkOAuth2): Integer;
procedure CkOAuth2_getAuthorizationEndpoint(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putAuthorizationEndpoint(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__authorizationEndpoint(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getClientId(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putClientId(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__clientId(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getClientSecret(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putClientSecret(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__clientSecret(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_getCodeChallenge(objHandle: HCkOAuth2): wordbool;
procedure CkOAuth2_putCodeChallenge(objHandle: HCkOAuth2; newPropVal: wordbool);
procedure CkOAuth2_getCodeChallengeMethod(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putCodeChallengeMethod(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__codeChallengeMethod(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getDebugLogFilePath(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putDebugLogFilePath(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__debugLogFilePath(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getFailureInfo(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__failureInfo(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_getIncludeNonce(objHandle: HCkOAuth2): wordbool;
procedure CkOAuth2_putIncludeNonce(objHandle: HCkOAuth2; newPropVal: wordbool);
procedure CkOAuth2_getLastErrorHtml(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__lastErrorHtml(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getLastErrorText(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__lastErrorText(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getLastErrorXml(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__lastErrorXml(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_getLastMethodSuccess(objHandle: HCkOAuth2): wordbool;
procedure CkOAuth2_putLastMethodSuccess(objHandle: HCkOAuth2; newPropVal: wordbool);
function CkOAuth2_getListenPort(objHandle: HCkOAuth2): Integer;
procedure CkOAuth2_putListenPort(objHandle: HCkOAuth2; newPropVal: Integer);
function CkOAuth2_getListenPortRangeEnd(objHandle: HCkOAuth2): Integer;
procedure CkOAuth2_putListenPortRangeEnd(objHandle: HCkOAuth2; newPropVal: Integer);
function CkOAuth2_getListenPortSelected(objHandle: HCkOAuth2): Integer;
procedure CkOAuth2_getLocalHost(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putLocalHost(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__localHost(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_getNonceLength(objHandle: HCkOAuth2): Integer;
procedure CkOAuth2_putNonceLength(objHandle: HCkOAuth2; newPropVal: Integer);
function CkOAuth2_getOob(objHandle: HCkOAuth2): wordbool;
procedure CkOAuth2_putOob(objHandle: HCkOAuth2; newPropVal: wordbool);
procedure CkOAuth2_getRedirectAllowHtml(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putRedirectAllowHtml(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__redirectAllowHtml(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getRedirectDenyHtml(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putRedirectDenyHtml(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__redirectDenyHtml(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getRedirectReqReceived(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__redirectReqReceived(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getRefreshToken(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putRefreshToken(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__refreshToken(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getResource(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putResource(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__resource(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getResponseMode(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putResponseMode(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__responseMode(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getResponseType(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putResponseType(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__responseType(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getScope(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putScope(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__scope(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getStateParam(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putStateParam(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__stateParam(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getTokenEndpoint(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putTokenEndpoint(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__tokenEndpoint(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getTokenType(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putTokenType(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__tokenType(objHandle: HCkOAuth2): PWideChar;
procedure CkOAuth2_getUncommonOptions(objHandle: HCkOAuth2; outPropVal: HCkString);
procedure CkOAuth2_putUncommonOptions(objHandle: HCkOAuth2; newPropVal: PWideChar);
function CkOAuth2__uncommonOptions(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_getUseBasicAuth(objHandle: HCkOAuth2): wordbool;
procedure CkOAuth2_putUseBasicAuth(objHandle: HCkOAuth2; newPropVal: wordbool);
function CkOAuth2_getVerboseLogging(objHandle: HCkOAuth2): wordbool;
procedure CkOAuth2_putVerboseLogging(objHandle: HCkOAuth2; newPropVal: wordbool);
procedure CkOAuth2_getVersion(objHandle: HCkOAuth2; outPropVal: HCkString);
function CkOAuth2__version(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_AddAuthQueryParam(objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
function CkOAuth2_AddRefreshQueryParam(objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
function CkOAuth2_AddTokenQueryParam(objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
function CkOAuth2_Cancel(objHandle: HCkOAuth2): wordbool;
function CkOAuth2_ExchangeCodeForToken(objHandle: HCkOAuth2; code: PWideChar): wordbool;
function CkOAuth2_ExchangeCodeForTokenAsync(objHandle: HCkOAuth2; code: PWideChar): HCkTask;
function CkOAuth2_GetAccessTokenResponseSb(objHandle: HCkOAuth2; sb: HCkStringBuilder): wordbool;
function CkOAuth2_GetRedirectRequestParam(objHandle: HCkOAuth2; paramName: PWideChar; outStr: HCkString): wordbool;
function CkOAuth2__getRedirectRequestParam(objHandle: HCkOAuth2; paramName: PWideChar): PWideChar;
function CkOAuth2_LaunchBrowser(objHandle: HCkOAuth2; url: PWideChar): wordbool;
function CkOAuth2_LoadTaskCaller(objHandle: HCkOAuth2; task: HCkTask): wordbool;
function CkOAuth2_RefreshAccessToken(objHandle: HCkOAuth2): wordbool;
function CkOAuth2_RefreshAccessTokenAsync(objHandle: HCkOAuth2): HCkTask;
function CkOAuth2_SetRefreshHeader(objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
procedure CkOAuth2_SleepMs(objHandle: HCkOAuth2; millisec: Integer);
function CkOAuth2_StartAuth(objHandle: HCkOAuth2; outStr: HCkString): wordbool;
function CkOAuth2__startAuth(objHandle: HCkOAuth2): PWideChar;
function CkOAuth2_UseConnection(objHandle: HCkOAuth2; sock: HCkSocket): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkOAuth2_Create = function : HCkOAuth2; stdcall;
  TCkOAuth2_Dispose = procedure (handle: HCkOAuth2); stdcall;
  TCkOAuth2_SetAbortCheck = procedure (objHandle: HCkOAuth2; fn: TOAuth2AbortCheck); stdcall;
  TCkOAuth2_SetProgressInfo = procedure (objHandle: HCkOAuth2; fn: TOAuth2ProgressInfo); stdcall;
  TCkOAuth2_SetPercentDone = procedure (objHandle: HCkOAuth2; fn: TOAuth2PercentDone); stdcall;
  TCkOAuth2_SetTaskCompleted = procedure (objHandle: HCkOAuth2; fn: TOAuth2TaskCompleted); stdcall;
  TCkOAuth2_getAccessToken = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putAccessToken = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__accessToken = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getAccessTokenResponse = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__accessTokenResponse = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getAppCallbackUrl = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putAppCallbackUrl = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__appCallbackUrl = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getAuthFlowState = function (objHandle: HCkOAuth2): Integer; stdcall;
  TCkOAuth2_getAuthorizationEndpoint = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putAuthorizationEndpoint = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__authorizationEndpoint = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getClientId = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putClientId = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__clientId = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getClientSecret = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putClientSecret = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__clientSecret = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getCodeChallenge = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_putCodeChallenge = procedure (objHandle: HCkOAuth2; newPropVal: wordbool); stdcall;
  TCkOAuth2_getCodeChallengeMethod = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putCodeChallengeMethod = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__codeChallengeMethod = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getDebugLogFilePath = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putDebugLogFilePath = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__debugLogFilePath = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getFailureInfo = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__failureInfo = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getIncludeNonce = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_putIncludeNonce = procedure (objHandle: HCkOAuth2; newPropVal: wordbool); stdcall;
  TCkOAuth2_getLastErrorHtml = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__lastErrorHtml = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getLastErrorText = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__lastErrorText = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getLastErrorXml = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__lastErrorXml = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getLastMethodSuccess = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_putLastMethodSuccess = procedure (objHandle: HCkOAuth2; newPropVal: wordbool); stdcall;
  TCkOAuth2_getListenPort = function (objHandle: HCkOAuth2): Integer; stdcall;
  TCkOAuth2_putListenPort = procedure (objHandle: HCkOAuth2; newPropVal: Integer); stdcall;
  TCkOAuth2_getListenPortRangeEnd = function (objHandle: HCkOAuth2): Integer; stdcall;
  TCkOAuth2_putListenPortRangeEnd = procedure (objHandle: HCkOAuth2; newPropVal: Integer); stdcall;
  TCkOAuth2_getListenPortSelected = function (objHandle: HCkOAuth2): Integer; stdcall;
  TCkOAuth2_getLocalHost = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putLocalHost = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__localHost = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getNonceLength = function (objHandle: HCkOAuth2): Integer; stdcall;
  TCkOAuth2_putNonceLength = procedure (objHandle: HCkOAuth2; newPropVal: Integer); stdcall;
  TCkOAuth2_getOob = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_putOob = procedure (objHandle: HCkOAuth2; newPropVal: wordbool); stdcall;
  TCkOAuth2_getRedirectAllowHtml = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putRedirectAllowHtml = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__redirectAllowHtml = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getRedirectDenyHtml = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putRedirectDenyHtml = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__redirectDenyHtml = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getRedirectReqReceived = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__redirectReqReceived = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getRefreshToken = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putRefreshToken = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__refreshToken = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getResource = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putResource = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__resource = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getResponseMode = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putResponseMode = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__responseMode = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getResponseType = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putResponseType = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__responseType = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getScope = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putScope = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__scope = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getStateParam = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putStateParam = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__stateParam = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getTokenEndpoint = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putTokenEndpoint = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__tokenEndpoint = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getTokenType = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putTokenType = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__tokenType = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getUncommonOptions = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2_putUncommonOptions = procedure (objHandle: HCkOAuth2; newPropVal: PWideChar); stdcall;
  TCkOAuth2__uncommonOptions = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_getUseBasicAuth = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_putUseBasicAuth = procedure (objHandle: HCkOAuth2; newPropVal: wordbool); stdcall;
  TCkOAuth2_getVerboseLogging = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_putVerboseLogging = procedure (objHandle: HCkOAuth2; newPropVal: wordbool); stdcall;
  TCkOAuth2_getVersion = procedure (objHandle: HCkOAuth2; outPropVal: HCkString); stdcall;
  TCkOAuth2__version = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_AddAuthQueryParam = function (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkOAuth2_AddRefreshQueryParam = function (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkOAuth2_AddTokenQueryParam = function (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkOAuth2_Cancel = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_ExchangeCodeForToken = function (objHandle: HCkOAuth2; code: PWideChar): wordbool; stdcall;
  TCkOAuth2_ExchangeCodeForTokenAsync = function (objHandle: HCkOAuth2; code: PWideChar): HCkTask; stdcall;
  TCkOAuth2_GetAccessTokenResponseSb = function (objHandle: HCkOAuth2; sb: HCkStringBuilder): wordbool; stdcall;
  TCkOAuth2_GetRedirectRequestParam = function (objHandle: HCkOAuth2; paramName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkOAuth2__getRedirectRequestParam = function (objHandle: HCkOAuth2; paramName: PWideChar): PWideChar; stdcall;
  TCkOAuth2_LaunchBrowser = function (objHandle: HCkOAuth2; url: PWideChar): wordbool; stdcall;
  TCkOAuth2_LoadTaskCaller = function (objHandle: HCkOAuth2; task: HCkTask): wordbool; stdcall;
  TCkOAuth2_RefreshAccessToken = function (objHandle: HCkOAuth2): wordbool; stdcall;
  TCkOAuth2_RefreshAccessTokenAsync = function (objHandle: HCkOAuth2): HCkTask; stdcall;
  TCkOAuth2_SetRefreshHeader = function (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkOAuth2_SleepMs = procedure (objHandle: HCkOAuth2; millisec: Integer); stdcall;
  TCkOAuth2_StartAuth = function (objHandle: HCkOAuth2; outStr: HCkString): wordbool; stdcall;
  TCkOAuth2__startAuth = function (objHandle: HCkOAuth2): PWideChar; stdcall;
  TCkOAuth2_UseConnection = function (objHandle: HCkOAuth2; sock: HCkSocket): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..114] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkOAuth2_Create : HCkOAuth2;
begin
  result := TCkOAuth2_Create(_map(0, 'CkOAuth2_Create'));
end;

procedure CkOAuth2_Dispose (handle: HCkOAuth2);
begin
  TCkOAuth2_Dispose(_map(1, 'CkOAuth2_Dispose'))
    (handle);
end;


procedure CkOAuth2_SetAbortCheck (objHandle: HCkOAuth2; fn: TOAuth2AbortCheck);
begin
    TCkOAuth2_SetAbortCheck(_map(2, 'CkOAuth2_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkOAuth2_SetProgressInfo (objHandle: HCkOAuth2; fn: TOAuth2ProgressInfo);
begin
    TCkOAuth2_SetProgressInfo(_map(3, 'CkOAuth2_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkOAuth2_SetPercentDone (objHandle: HCkOAuth2; fn: TOAuth2PercentDone);
begin
    TCkOAuth2_SetPercentDone(_map(4, 'CkOAuth2_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkOAuth2_SetTaskCompleted (objHandle: HCkOAuth2; fn: TOAuth2TaskCompleted);
begin
    TCkOAuth2_SetTaskCompleted(_map(5, 'CkOAuth2_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkOAuth2_getAccessToken (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getAccessToken(_map(6, 'CkOAuth2_getAccessToken'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putAccessToken (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putAccessToken(_map(7, 'CkOAuth2_putAccessToken'))
    (objHandle, newPropVal);
end;

function CkOAuth2__accessToken (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__accessToken(_map(8, 'CkOAuth2__accessToken'))
    (objHandle);
end;

procedure CkOAuth2_getAccessTokenResponse (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getAccessTokenResponse(_map(9, 'CkOAuth2_getAccessTokenResponse'))
    (objHandle, outPropVal);
end;

function CkOAuth2__accessTokenResponse (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__accessTokenResponse(_map(10, 'CkOAuth2__accessTokenResponse'))
    (objHandle);
end;

procedure CkOAuth2_getAppCallbackUrl (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getAppCallbackUrl(_map(11, 'CkOAuth2_getAppCallbackUrl'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putAppCallbackUrl (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putAppCallbackUrl(_map(12, 'CkOAuth2_putAppCallbackUrl'))
    (objHandle, newPropVal);
end;

function CkOAuth2__appCallbackUrl (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__appCallbackUrl(_map(13, 'CkOAuth2__appCallbackUrl'))
    (objHandle);
end;

function CkOAuth2_getAuthFlowState (objHandle: HCkOAuth2): Integer;
begin
    result := TCkOAuth2_getAuthFlowState(_map(14, 'CkOAuth2_getAuthFlowState'))
    (objHandle);
end;

procedure CkOAuth2_getAuthorizationEndpoint (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getAuthorizationEndpoint(_map(15, 'CkOAuth2_getAuthorizationEndpoint'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putAuthorizationEndpoint (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putAuthorizationEndpoint(_map(16, 'CkOAuth2_putAuthorizationEndpoint'))
    (objHandle, newPropVal);
end;

function CkOAuth2__authorizationEndpoint (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__authorizationEndpoint(_map(17, 'CkOAuth2__authorizationEndpoint'))
    (objHandle);
end;

procedure CkOAuth2_getClientId (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getClientId(_map(18, 'CkOAuth2_getClientId'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putClientId (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putClientId(_map(19, 'CkOAuth2_putClientId'))
    (objHandle, newPropVal);
end;

function CkOAuth2__clientId (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__clientId(_map(20, 'CkOAuth2__clientId'))
    (objHandle);
end;

procedure CkOAuth2_getClientSecret (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getClientSecret(_map(21, 'CkOAuth2_getClientSecret'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putClientSecret (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putClientSecret(_map(22, 'CkOAuth2_putClientSecret'))
    (objHandle, newPropVal);
end;

function CkOAuth2__clientSecret (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__clientSecret(_map(23, 'CkOAuth2__clientSecret'))
    (objHandle);
end;

function CkOAuth2_getCodeChallenge (objHandle: HCkOAuth2): wordbool;
begin
    result := TCkOAuth2_getCodeChallenge(_map(24, 'CkOAuth2_getCodeChallenge'))
    (objHandle);
end;

procedure CkOAuth2_putCodeChallenge (objHandle: HCkOAuth2; newPropVal: wordbool);
begin
  TCkOAuth2_putCodeChallenge(_map(25, 'CkOAuth2_putCodeChallenge'))
    (objHandle, newPropVal);
end;

procedure CkOAuth2_getCodeChallengeMethod (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getCodeChallengeMethod(_map(26, 'CkOAuth2_getCodeChallengeMethod'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putCodeChallengeMethod (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putCodeChallengeMethod(_map(27, 'CkOAuth2_putCodeChallengeMethod'))
    (objHandle, newPropVal);
end;

function CkOAuth2__codeChallengeMethod (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__codeChallengeMethod(_map(28, 'CkOAuth2__codeChallengeMethod'))
    (objHandle);
end;

procedure CkOAuth2_getDebugLogFilePath (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getDebugLogFilePath(_map(29, 'CkOAuth2_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putDebugLogFilePath (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putDebugLogFilePath(_map(30, 'CkOAuth2_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkOAuth2__debugLogFilePath (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__debugLogFilePath(_map(31, 'CkOAuth2__debugLogFilePath'))
    (objHandle);
end;

procedure CkOAuth2_getFailureInfo (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getFailureInfo(_map(32, 'CkOAuth2_getFailureInfo'))
    (objHandle, outPropVal);
end;

function CkOAuth2__failureInfo (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__failureInfo(_map(33, 'CkOAuth2__failureInfo'))
    (objHandle);
end;

function CkOAuth2_getIncludeNonce (objHandle: HCkOAuth2): wordbool;
begin
    result := TCkOAuth2_getIncludeNonce(_map(34, 'CkOAuth2_getIncludeNonce'))
    (objHandle);
end;

procedure CkOAuth2_putIncludeNonce (objHandle: HCkOAuth2; newPropVal: wordbool);
begin
  TCkOAuth2_putIncludeNonce(_map(35, 'CkOAuth2_putIncludeNonce'))
    (objHandle, newPropVal);
end;

procedure CkOAuth2_getLastErrorHtml (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getLastErrorHtml(_map(36, 'CkOAuth2_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkOAuth2__lastErrorHtml (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__lastErrorHtml(_map(37, 'CkOAuth2__lastErrorHtml'))
    (objHandle);
end;

procedure CkOAuth2_getLastErrorText (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getLastErrorText(_map(38, 'CkOAuth2_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkOAuth2__lastErrorText (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__lastErrorText(_map(39, 'CkOAuth2__lastErrorText'))
    (objHandle);
end;

procedure CkOAuth2_getLastErrorXml (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getLastErrorXml(_map(40, 'CkOAuth2_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkOAuth2__lastErrorXml (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__lastErrorXml(_map(41, 'CkOAuth2__lastErrorXml'))
    (objHandle);
end;

function CkOAuth2_getLastMethodSuccess (objHandle: HCkOAuth2): wordbool;
begin
    result := TCkOAuth2_getLastMethodSuccess(_map(42, 'CkOAuth2_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkOAuth2_putLastMethodSuccess (objHandle: HCkOAuth2; newPropVal: wordbool);
begin
  TCkOAuth2_putLastMethodSuccess(_map(43, 'CkOAuth2_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkOAuth2_getListenPort (objHandle: HCkOAuth2): Integer;
begin
    result := TCkOAuth2_getListenPort(_map(44, 'CkOAuth2_getListenPort'))
    (objHandle);
end;

procedure CkOAuth2_putListenPort (objHandle: HCkOAuth2; newPropVal: Integer);
begin
  TCkOAuth2_putListenPort(_map(45, 'CkOAuth2_putListenPort'))
    (objHandle, newPropVal);
end;

function CkOAuth2_getListenPortRangeEnd (objHandle: HCkOAuth2): Integer;
begin
    result := TCkOAuth2_getListenPortRangeEnd(_map(46, 'CkOAuth2_getListenPortRangeEnd'))
    (objHandle);
end;

procedure CkOAuth2_putListenPortRangeEnd (objHandle: HCkOAuth2; newPropVal: Integer);
begin
  TCkOAuth2_putListenPortRangeEnd(_map(47, 'CkOAuth2_putListenPortRangeEnd'))
    (objHandle, newPropVal);
end;

function CkOAuth2_getListenPortSelected (objHandle: HCkOAuth2): Integer;
begin
    result := TCkOAuth2_getListenPortSelected(_map(48, 'CkOAuth2_getListenPortSelected'))
    (objHandle);
end;

procedure CkOAuth2_getLocalHost (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getLocalHost(_map(49, 'CkOAuth2_getLocalHost'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putLocalHost (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putLocalHost(_map(50, 'CkOAuth2_putLocalHost'))
    (objHandle, newPropVal);
end;

function CkOAuth2__localHost (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__localHost(_map(51, 'CkOAuth2__localHost'))
    (objHandle);
end;

function CkOAuth2_getNonceLength (objHandle: HCkOAuth2): Integer;
begin
    result := TCkOAuth2_getNonceLength(_map(52, 'CkOAuth2_getNonceLength'))
    (objHandle);
end;

procedure CkOAuth2_putNonceLength (objHandle: HCkOAuth2; newPropVal: Integer);
begin
  TCkOAuth2_putNonceLength(_map(53, 'CkOAuth2_putNonceLength'))
    (objHandle, newPropVal);
end;

function CkOAuth2_getOob (objHandle: HCkOAuth2): wordbool;
begin
    result := TCkOAuth2_getOob(_map(54, 'CkOAuth2_getOob'))
    (objHandle);
end;

procedure CkOAuth2_putOob (objHandle: HCkOAuth2; newPropVal: wordbool);
begin
  TCkOAuth2_putOob(_map(55, 'CkOAuth2_putOob'))
    (objHandle, newPropVal);
end;

procedure CkOAuth2_getRedirectAllowHtml (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getRedirectAllowHtml(_map(56, 'CkOAuth2_getRedirectAllowHtml'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putRedirectAllowHtml (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putRedirectAllowHtml(_map(57, 'CkOAuth2_putRedirectAllowHtml'))
    (objHandle, newPropVal);
end;

function CkOAuth2__redirectAllowHtml (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__redirectAllowHtml(_map(58, 'CkOAuth2__redirectAllowHtml'))
    (objHandle);
end;

procedure CkOAuth2_getRedirectDenyHtml (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getRedirectDenyHtml(_map(59, 'CkOAuth2_getRedirectDenyHtml'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putRedirectDenyHtml (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putRedirectDenyHtml(_map(60, 'CkOAuth2_putRedirectDenyHtml'))
    (objHandle, newPropVal);
end;

function CkOAuth2__redirectDenyHtml (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__redirectDenyHtml(_map(61, 'CkOAuth2__redirectDenyHtml'))
    (objHandle);
end;

procedure CkOAuth2_getRedirectReqReceived (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getRedirectReqReceived(_map(62, 'CkOAuth2_getRedirectReqReceived'))
    (objHandle, outPropVal);
end;

function CkOAuth2__redirectReqReceived (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__redirectReqReceived(_map(63, 'CkOAuth2__redirectReqReceived'))
    (objHandle);
end;

procedure CkOAuth2_getRefreshToken (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getRefreshToken(_map(64, 'CkOAuth2_getRefreshToken'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putRefreshToken (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putRefreshToken(_map(65, 'CkOAuth2_putRefreshToken'))
    (objHandle, newPropVal);
end;

function CkOAuth2__refreshToken (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__refreshToken(_map(66, 'CkOAuth2__refreshToken'))
    (objHandle);
end;

procedure CkOAuth2_getResource (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getResource(_map(67, 'CkOAuth2_getResource'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putResource (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putResource(_map(68, 'CkOAuth2_putResource'))
    (objHandle, newPropVal);
end;

function CkOAuth2__resource (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__resource(_map(69, 'CkOAuth2__resource'))
    (objHandle);
end;

procedure CkOAuth2_getResponseMode (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getResponseMode(_map(70, 'CkOAuth2_getResponseMode'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putResponseMode (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putResponseMode(_map(71, 'CkOAuth2_putResponseMode'))
    (objHandle, newPropVal);
end;

function CkOAuth2__responseMode (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__responseMode(_map(72, 'CkOAuth2__responseMode'))
    (objHandle);
end;

procedure CkOAuth2_getResponseType (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getResponseType(_map(73, 'CkOAuth2_getResponseType'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putResponseType (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putResponseType(_map(74, 'CkOAuth2_putResponseType'))
    (objHandle, newPropVal);
end;

function CkOAuth2__responseType (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__responseType(_map(75, 'CkOAuth2__responseType'))
    (objHandle);
end;

procedure CkOAuth2_getScope (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getScope(_map(76, 'CkOAuth2_getScope'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putScope (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putScope(_map(77, 'CkOAuth2_putScope'))
    (objHandle, newPropVal);
end;

function CkOAuth2__scope (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__scope(_map(78, 'CkOAuth2__scope'))
    (objHandle);
end;

procedure CkOAuth2_getStateParam (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getStateParam(_map(79, 'CkOAuth2_getStateParam'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putStateParam (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putStateParam(_map(80, 'CkOAuth2_putStateParam'))
    (objHandle, newPropVal);
end;

function CkOAuth2__stateParam (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__stateParam(_map(81, 'CkOAuth2__stateParam'))
    (objHandle);
end;

procedure CkOAuth2_getTokenEndpoint (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getTokenEndpoint(_map(82, 'CkOAuth2_getTokenEndpoint'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putTokenEndpoint (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putTokenEndpoint(_map(83, 'CkOAuth2_putTokenEndpoint'))
    (objHandle, newPropVal);
end;

function CkOAuth2__tokenEndpoint (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__tokenEndpoint(_map(84, 'CkOAuth2__tokenEndpoint'))
    (objHandle);
end;

procedure CkOAuth2_getTokenType (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getTokenType(_map(85, 'CkOAuth2_getTokenType'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putTokenType (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putTokenType(_map(86, 'CkOAuth2_putTokenType'))
    (objHandle, newPropVal);
end;

function CkOAuth2__tokenType (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__tokenType(_map(87, 'CkOAuth2__tokenType'))
    (objHandle);
end;

procedure CkOAuth2_getUncommonOptions (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getUncommonOptions(_map(88, 'CkOAuth2_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkOAuth2_putUncommonOptions (objHandle: HCkOAuth2; newPropVal: PWideChar);
begin
  TCkOAuth2_putUncommonOptions(_map(89, 'CkOAuth2_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkOAuth2__uncommonOptions (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__uncommonOptions(_map(90, 'CkOAuth2__uncommonOptions'))
    (objHandle);
end;

function CkOAuth2_getUseBasicAuth (objHandle: HCkOAuth2): wordbool;
begin
    result := TCkOAuth2_getUseBasicAuth(_map(91, 'CkOAuth2_getUseBasicAuth'))
    (objHandle);
end;

procedure CkOAuth2_putUseBasicAuth (objHandle: HCkOAuth2; newPropVal: wordbool);
begin
  TCkOAuth2_putUseBasicAuth(_map(92, 'CkOAuth2_putUseBasicAuth'))
    (objHandle, newPropVal);
end;

function CkOAuth2_getVerboseLogging (objHandle: HCkOAuth2): wordbool;
begin
    result := TCkOAuth2_getVerboseLogging(_map(93, 'CkOAuth2_getVerboseLogging'))
    (objHandle);
end;

procedure CkOAuth2_putVerboseLogging (objHandle: HCkOAuth2; newPropVal: wordbool);
begin
  TCkOAuth2_putVerboseLogging(_map(94, 'CkOAuth2_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkOAuth2_getVersion (objHandle: HCkOAuth2; outPropVal: HCkString);
begin
  TCkOAuth2_getVersion(_map(95, 'CkOAuth2_getVersion'))
    (objHandle, outPropVal);
end;

function CkOAuth2__version (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__version(_map(96, 'CkOAuth2__version'))
    (objHandle);
end;

function CkOAuth2_AddAuthQueryParam (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkOAuth2_AddAuthQueryParam(_map(97, 'CkOAuth2_AddAuthQueryParam'))
    (objHandle, name, value);
end;

function CkOAuth2_AddRefreshQueryParam (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkOAuth2_AddRefreshQueryParam(_map(98, 'CkOAuth2_AddRefreshQueryParam'))
    (objHandle, name, value);
end;

function CkOAuth2_AddTokenQueryParam (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkOAuth2_AddTokenQueryParam(_map(99, 'CkOAuth2_AddTokenQueryParam'))
    (objHandle, name, value);
end;

function CkOAuth2_Cancel (objHandle: HCkOAuth2): wordbool;
begin
  result := TCkOAuth2_Cancel(_map(100, 'CkOAuth2_Cancel'))
    (objHandle);
end;

function CkOAuth2_ExchangeCodeForToken (objHandle: HCkOAuth2; code: PWideChar): wordbool;
begin
  result := TCkOAuth2_ExchangeCodeForToken(_map(101, 'CkOAuth2_ExchangeCodeForToken'))
    (objHandle, code);
end;

function CkOAuth2_ExchangeCodeForTokenAsync (objHandle: HCkOAuth2; code: PWideChar): HCkTask;
begin
  result := TCkOAuth2_ExchangeCodeForTokenAsync(_map(102, 'CkOAuth2_ExchangeCodeForTokenAsync'))
    (objHandle, code);
end;

function CkOAuth2_GetAccessTokenResponseSb (objHandle: HCkOAuth2; sb: HCkStringBuilder): wordbool;
begin
  result := TCkOAuth2_GetAccessTokenResponseSb(_map(103, 'CkOAuth2_GetAccessTokenResponseSb'))
    (objHandle, sb);
end;

function CkOAuth2_GetRedirectRequestParam (objHandle: HCkOAuth2; paramName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkOAuth2_GetRedirectRequestParam(_map(104, 'CkOAuth2_GetRedirectRequestParam'))
    (objHandle, paramName, outStr);
end;

function CkOAuth2__getRedirectRequestParam (objHandle: HCkOAuth2; paramName: PWideChar): PWideChar;
begin
  result := TCkOAuth2__getRedirectRequestParam(_map(105, 'CkOAuth2__getRedirectRequestParam'))
    (objHandle, paramName);
end;

function CkOAuth2_LaunchBrowser (objHandle: HCkOAuth2; url: PWideChar): wordbool;
begin
  result := TCkOAuth2_LaunchBrowser(_map(106, 'CkOAuth2_LaunchBrowser'))
    (objHandle, url);
end;

function CkOAuth2_LoadTaskCaller (objHandle: HCkOAuth2; task: HCkTask): wordbool;
begin
  result := TCkOAuth2_LoadTaskCaller(_map(107, 'CkOAuth2_LoadTaskCaller'))
    (objHandle, task);
end;

function CkOAuth2_RefreshAccessToken (objHandle: HCkOAuth2): wordbool;
begin
  result := TCkOAuth2_RefreshAccessToken(_map(108, 'CkOAuth2_RefreshAccessToken'))
    (objHandle);
end;

function CkOAuth2_RefreshAccessTokenAsync (objHandle: HCkOAuth2): HCkTask;
begin
  result := TCkOAuth2_RefreshAccessTokenAsync(_map(109, 'CkOAuth2_RefreshAccessTokenAsync'))
    (objHandle);
end;

function CkOAuth2_SetRefreshHeader (objHandle: HCkOAuth2; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkOAuth2_SetRefreshHeader(_map(110, 'CkOAuth2_SetRefreshHeader'))
    (objHandle, name, value);
end;

procedure CkOAuth2_SleepMs (objHandle: HCkOAuth2; millisec: Integer);
begin
  TCkOAuth2_SleepMs(_map(111, 'CkOAuth2_SleepMs'))
    (objHandle, millisec);
end;

function CkOAuth2_StartAuth (objHandle: HCkOAuth2; outStr: HCkString): wordbool;
begin
  result := TCkOAuth2_StartAuth(_map(112, 'CkOAuth2_StartAuth'))
    (objHandle, outStr);
end;

function CkOAuth2__startAuth (objHandle: HCkOAuth2): PWideChar;
begin
  result := TCkOAuth2__startAuth(_map(113, 'CkOAuth2__startAuth'))
    (objHandle);
end;

function CkOAuth2_UseConnection (objHandle: HCkOAuth2; sock: HCkSocket): wordbool;
begin
  result := TCkOAuth2_UseConnection(_map(114, 'CkOAuth2_UseConnection'))
    (objHandle, sock);
end;

end.
