unit Pfx;

interface

type

HCkJsonObject = Pointer;
HCkPrivateKey = Pointer;
HCkXmlCertVault = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkJavaKeyStore = Pointer;
HCkPfx = Pointer;
HCkCertChain = Pointer;
HCkCert = Pointer;
HCkBinData = Pointer;


function CkPfx_Create: HCkPfx;  stdcall;
procedure CkPfx_Dispose(handle: HCkPfx); stdcall;
procedure CkPfx_getAlgorithmId(objHandle: HCkPfx; outPropVal: HCkString);
procedure CkPfx_putAlgorithmId(objHandle: HCkPfx; newPropVal: PWideChar);
function CkPfx__algorithmId(objHandle: HCkPfx): PWideChar;
procedure CkPfx_getDebugLogFilePath(objHandle: HCkPfx; outPropVal: HCkString);
procedure CkPfx_putDebugLogFilePath(objHandle: HCkPfx; newPropVal: PWideChar);
function CkPfx__debugLogFilePath(objHandle: HCkPfx): PWideChar;
procedure CkPfx_getLastErrorHtml(objHandle: HCkPfx; outPropVal: HCkString);
function CkPfx__lastErrorHtml(objHandle: HCkPfx): PWideChar;
procedure CkPfx_getLastErrorText(objHandle: HCkPfx; outPropVal: HCkString);
function CkPfx__lastErrorText(objHandle: HCkPfx): PWideChar;
procedure CkPfx_getLastErrorXml(objHandle: HCkPfx; outPropVal: HCkString);
function CkPfx__lastErrorXml(objHandle: HCkPfx): PWideChar;
function CkPfx_getLastMethodSuccess(objHandle: HCkPfx): wordbool;
procedure CkPfx_putLastMethodSuccess(objHandle: HCkPfx; newPropVal: wordbool);
function CkPfx_getNumCerts(objHandle: HCkPfx): Integer;
function CkPfx_getNumPrivateKeys(objHandle: HCkPfx): Integer;
procedure CkPfx_getPbes2CryptAlg(objHandle: HCkPfx; outPropVal: HCkString);
procedure CkPfx_putPbes2CryptAlg(objHandle: HCkPfx; newPropVal: PWideChar);
function CkPfx__pbes2CryptAlg(objHandle: HCkPfx): PWideChar;
procedure CkPfx_getPbes2HmacAlg(objHandle: HCkPfx; outPropVal: HCkString);
procedure CkPfx_putPbes2HmacAlg(objHandle: HCkPfx; newPropVal: PWideChar);
function CkPfx__pbes2HmacAlg(objHandle: HCkPfx): PWideChar;
procedure CkPfx_getUncommonOptions(objHandle: HCkPfx; outPropVal: HCkString);
procedure CkPfx_putUncommonOptions(objHandle: HCkPfx; newPropVal: PWideChar);
function CkPfx__uncommonOptions(objHandle: HCkPfx): PWideChar;
function CkPfx_getVerboseLogging(objHandle: HCkPfx): wordbool;
procedure CkPfx_putVerboseLogging(objHandle: HCkPfx; newPropVal: wordbool);
procedure CkPfx_getVersion(objHandle: HCkPfx; outPropVal: HCkString);
function CkPfx__version(objHandle: HCkPfx): PWideChar;
function CkPfx_AddCert(objHandle: HCkPfx; cert: HCkCert; includeChain: wordbool): wordbool;
function CkPfx_AddPrivateKey(objHandle: HCkPfx; privKey: HCkPrivateKey; certChain: HCkCertChain): wordbool;
function CkPfx_CertAt(objHandle: HCkPfx; index: Integer; cert: HCkCert): wordbool;
function CkPfx_CertByLocalKeyId(objHandle: HCkPfx; localKeyId: PWideChar; encoding: PWideChar; cert: HCkCert): wordbool;
function CkPfx_FindCertByLocalKeyId(objHandle: HCkPfx; localKeyId: PWideChar; encoding: PWideChar): HCkCert;
function CkPfx_GetCert(objHandle: HCkPfx; index: Integer): HCkCert;
procedure CkPfx_GetLastJsonData(objHandle: HCkPfx; json: HCkJsonObject);
function CkPfx_GetPrivateKey(objHandle: HCkPfx; index: Integer): HCkPrivateKey;
function CkPfx_GetSafeBagAttr(objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; attrName: PWideChar; outStr: HCkString): wordbool;
function CkPfx__getSafeBagAttr(objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; attrName: PWideChar): PWideChar;
function CkPfx_ImportToKeychain(objHandle: HCkPfx; opts: HCkJsonObject): wordbool;
function CkPfx_ImportToWindows(objHandle: HCkPfx; exportable: wordbool; userProtected: wordbool; machineKeyset: wordbool; allowOverwriteKey: wordbool; allowExport: wordbool; leafStore: PWideChar; intermediateStore: PWideChar; rootStore: PWideChar; extraOptions: PWideChar): wordbool;
function CkPfx_LastJsonData(objHandle: HCkPfx): HCkJsonObject;
function CkPfx_LoadPem(objHandle: HCkPfx; pemStr: PWideChar; password: PWideChar): wordbool;
function CkPfx_LoadPfxBd(objHandle: HCkPfx; bd: HCkBinData; password: PWideChar): wordbool;
function CkPfx_LoadPfxBytes(objHandle: HCkPfx; pfxData: HCkByteData; password: PWideChar): wordbool;
function CkPfx_LoadPfxEncoded(objHandle: HCkPfx; encodedData: PWideChar; encoding: PWideChar; password: PWideChar): wordbool;
function CkPfx_LoadPfxFile(objHandle: HCkPfx; path: PWideChar; password: PWideChar): wordbool;
function CkPfx_PrivateKeyAt(objHandle: HCkPfx; index: Integer; privKey: HCkPrivateKey): wordbool;
function CkPfx_SetSafeBagAttr(objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; name: PWideChar; value: PWideChar; encoding: PWideChar): wordbool;
function CkPfx_ToBd(objHandle: HCkPfx; password: PWideChar; bd: HCkBinData): wordbool;
function CkPfx_ToBinary(objHandle: HCkPfx; password: PWideChar; outData: HCkByteData): wordbool;
function CkPfx_ToEncodedString(objHandle: HCkPfx; password: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkPfx__toEncodedString(objHandle: HCkPfx; password: PWideChar; encoding: PWideChar): PWideChar;
function CkPfx_ToFile(objHandle: HCkPfx; password: PWideChar; path: PWideChar): wordbool;
function CkPfx_ToJavaKeyStore(objHandle: HCkPfx; alias: PWideChar; password: PWideChar): HCkJavaKeyStore;
function CkPfx_ToJksObj(objHandle: HCkPfx; alias: PWideChar; password: PWideChar; jksObj: HCkJavaKeyStore): wordbool;
function CkPfx_ToPem(objHandle: HCkPfx; outStr: HCkString): wordbool;
function CkPfx__toPem(objHandle: HCkPfx): PWideChar;
function CkPfx_ToPemEx(objHandle: HCkPfx; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
function CkPfx__toPemEx(objHandle: HCkPfx; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar): PWideChar;
function CkPfx_UseCertVault(objHandle: HCkPfx; vault: HCkXmlCertVault): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkPfx_Create = function : HCkPfx; stdcall;
  TCkPfx_Dispose = procedure (handle: HCkPfx); stdcall;
  TCkPfx_getAlgorithmId = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx_putAlgorithmId = procedure (objHandle: HCkPfx; newPropVal: PWideChar); stdcall;
  TCkPfx__algorithmId = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getDebugLogFilePath = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx_putDebugLogFilePath = procedure (objHandle: HCkPfx; newPropVal: PWideChar); stdcall;
  TCkPfx__debugLogFilePath = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getLastErrorHtml = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx__lastErrorHtml = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getLastErrorText = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx__lastErrorText = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getLastErrorXml = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx__lastErrorXml = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getLastMethodSuccess = function (objHandle: HCkPfx): wordbool; stdcall;
  TCkPfx_putLastMethodSuccess = procedure (objHandle: HCkPfx; newPropVal: wordbool); stdcall;
  TCkPfx_getNumCerts = function (objHandle: HCkPfx): Integer; stdcall;
  TCkPfx_getNumPrivateKeys = function (objHandle: HCkPfx): Integer; stdcall;
  TCkPfx_getPbes2CryptAlg = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx_putPbes2CryptAlg = procedure (objHandle: HCkPfx; newPropVal: PWideChar); stdcall;
  TCkPfx__pbes2CryptAlg = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getPbes2HmacAlg = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx_putPbes2HmacAlg = procedure (objHandle: HCkPfx; newPropVal: PWideChar); stdcall;
  TCkPfx__pbes2HmacAlg = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getUncommonOptions = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx_putUncommonOptions = procedure (objHandle: HCkPfx; newPropVal: PWideChar); stdcall;
  TCkPfx__uncommonOptions = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_getVerboseLogging = function (objHandle: HCkPfx): wordbool; stdcall;
  TCkPfx_putVerboseLogging = procedure (objHandle: HCkPfx; newPropVal: wordbool); stdcall;
  TCkPfx_getVersion = procedure (objHandle: HCkPfx; outPropVal: HCkString); stdcall;
  TCkPfx__version = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_AddCert = function (objHandle: HCkPfx; cert: HCkCert; includeChain: wordbool): wordbool; stdcall;
  TCkPfx_AddPrivateKey = function (objHandle: HCkPfx; privKey: HCkPrivateKey; certChain: HCkCertChain): wordbool; stdcall;
  TCkPfx_CertAt = function (objHandle: HCkPfx; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkPfx_CertByLocalKeyId = function (objHandle: HCkPfx; localKeyId: PWideChar; encoding: PWideChar; cert: HCkCert): wordbool; stdcall;
  TCkPfx_FindCertByLocalKeyId = function (objHandle: HCkPfx; localKeyId: PWideChar; encoding: PWideChar): HCkCert; stdcall;
  TCkPfx_GetCert = function (objHandle: HCkPfx; index: Integer): HCkCert; stdcall;
  TCkPfx_GetLastJsonData = procedure (objHandle: HCkPfx; json: HCkJsonObject); stdcall;
  TCkPfx_GetPrivateKey = function (objHandle: HCkPfx; index: Integer): HCkPrivateKey; stdcall;
  TCkPfx_GetSafeBagAttr = function (objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; attrName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPfx__getSafeBagAttr = function (objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; attrName: PWideChar): PWideChar; stdcall;
  TCkPfx_ImportToKeychain = function (objHandle: HCkPfx; opts: HCkJsonObject): wordbool; stdcall;
  TCkPfx_ImportToWindows = function (objHandle: HCkPfx; exportable: wordbool; userProtected: wordbool; machineKeyset: wordbool; allowOverwriteKey: wordbool; allowExport: wordbool; leafStore: PWideChar; intermediateStore: PWideChar; rootStore: PWideChar; extraOptions: PWideChar): wordbool; stdcall;
  TCkPfx_LastJsonData = function (objHandle: HCkPfx): HCkJsonObject; stdcall;
  TCkPfx_LoadPem = function (objHandle: HCkPfx; pemStr: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPfx_LoadPfxBd = function (objHandle: HCkPfx; bd: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkPfx_LoadPfxBytes = function (objHandle: HCkPfx; pfxData: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkPfx_LoadPfxEncoded = function (objHandle: HCkPfx; encodedData: PWideChar; encoding: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPfx_LoadPfxFile = function (objHandle: HCkPfx; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPfx_PrivateKeyAt = function (objHandle: HCkPfx; index: Integer; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkPfx_SetSafeBagAttr = function (objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; name: PWideChar; value: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkPfx_ToBd = function (objHandle: HCkPfx; password: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkPfx_ToBinary = function (objHandle: HCkPfx; password: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkPfx_ToEncodedString = function (objHandle: HCkPfx; password: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPfx__toEncodedString = function (objHandle: HCkPfx; password: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkPfx_ToFile = function (objHandle: HCkPfx; password: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkPfx_ToJavaKeyStore = function (objHandle: HCkPfx; alias: PWideChar; password: PWideChar): HCkJavaKeyStore; stdcall;
  TCkPfx_ToJksObj = function (objHandle: HCkPfx; alias: PWideChar; password: PWideChar; jksObj: HCkJavaKeyStore): wordbool; stdcall;
  TCkPfx_ToPem = function (objHandle: HCkPfx; outStr: HCkString): wordbool; stdcall;
  TCkPfx__toPem = function (objHandle: HCkPfx): PWideChar; stdcall;
  TCkPfx_ToPemEx = function (objHandle: HCkPfx; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPfx__toPemEx = function (objHandle: HCkPfx; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar): PWideChar; stdcall;
  TCkPfx_UseCertVault = function (objHandle: HCkPfx; vault: HCkXmlCertVault): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..62] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkPfx_Create : HCkPfx;
begin
  result := TCkPfx_Create(_map(0, 'CkPfx_Create'));
end;

procedure CkPfx_Dispose (handle: HCkPfx);
begin
  TCkPfx_Dispose(_map(1, 'CkPfx_Dispose'))
    (handle);
end;


procedure CkPfx_getAlgorithmId (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getAlgorithmId(_map(2, 'CkPfx_getAlgorithmId'))
    (objHandle, outPropVal);
end;

procedure CkPfx_putAlgorithmId (objHandle: HCkPfx; newPropVal: PWideChar);
begin
  TCkPfx_putAlgorithmId(_map(3, 'CkPfx_putAlgorithmId'))
    (objHandle, newPropVal);
end;

function CkPfx__algorithmId (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__algorithmId(_map(4, 'CkPfx__algorithmId'))
    (objHandle);
end;

procedure CkPfx_getDebugLogFilePath (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getDebugLogFilePath(_map(5, 'CkPfx_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkPfx_putDebugLogFilePath (objHandle: HCkPfx; newPropVal: PWideChar);
begin
  TCkPfx_putDebugLogFilePath(_map(6, 'CkPfx_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkPfx__debugLogFilePath (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__debugLogFilePath(_map(7, 'CkPfx__debugLogFilePath'))
    (objHandle);
end;

procedure CkPfx_getLastErrorHtml (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getLastErrorHtml(_map(8, 'CkPfx_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkPfx__lastErrorHtml (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__lastErrorHtml(_map(9, 'CkPfx__lastErrorHtml'))
    (objHandle);
end;

procedure CkPfx_getLastErrorText (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getLastErrorText(_map(10, 'CkPfx_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkPfx__lastErrorText (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__lastErrorText(_map(11, 'CkPfx__lastErrorText'))
    (objHandle);
end;

procedure CkPfx_getLastErrorXml (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getLastErrorXml(_map(12, 'CkPfx_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkPfx__lastErrorXml (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__lastErrorXml(_map(13, 'CkPfx__lastErrorXml'))
    (objHandle);
end;

function CkPfx_getLastMethodSuccess (objHandle: HCkPfx): wordbool;
begin
    result := TCkPfx_getLastMethodSuccess(_map(14, 'CkPfx_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkPfx_putLastMethodSuccess (objHandle: HCkPfx; newPropVal: wordbool);
begin
  TCkPfx_putLastMethodSuccess(_map(15, 'CkPfx_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkPfx_getNumCerts (objHandle: HCkPfx): Integer;
begin
    result := TCkPfx_getNumCerts(_map(16, 'CkPfx_getNumCerts'))
    (objHandle);
end;

function CkPfx_getNumPrivateKeys (objHandle: HCkPfx): Integer;
begin
    result := TCkPfx_getNumPrivateKeys(_map(17, 'CkPfx_getNumPrivateKeys'))
    (objHandle);
end;

procedure CkPfx_getPbes2CryptAlg (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getPbes2CryptAlg(_map(18, 'CkPfx_getPbes2CryptAlg'))
    (objHandle, outPropVal);
end;

procedure CkPfx_putPbes2CryptAlg (objHandle: HCkPfx; newPropVal: PWideChar);
begin
  TCkPfx_putPbes2CryptAlg(_map(19, 'CkPfx_putPbes2CryptAlg'))
    (objHandle, newPropVal);
end;

function CkPfx__pbes2CryptAlg (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__pbes2CryptAlg(_map(20, 'CkPfx__pbes2CryptAlg'))
    (objHandle);
end;

procedure CkPfx_getPbes2HmacAlg (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getPbes2HmacAlg(_map(21, 'CkPfx_getPbes2HmacAlg'))
    (objHandle, outPropVal);
end;

procedure CkPfx_putPbes2HmacAlg (objHandle: HCkPfx; newPropVal: PWideChar);
begin
  TCkPfx_putPbes2HmacAlg(_map(22, 'CkPfx_putPbes2HmacAlg'))
    (objHandle, newPropVal);
end;

function CkPfx__pbes2HmacAlg (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__pbes2HmacAlg(_map(23, 'CkPfx__pbes2HmacAlg'))
    (objHandle);
end;

procedure CkPfx_getUncommonOptions (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getUncommonOptions(_map(24, 'CkPfx_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkPfx_putUncommonOptions (objHandle: HCkPfx; newPropVal: PWideChar);
begin
  TCkPfx_putUncommonOptions(_map(25, 'CkPfx_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkPfx__uncommonOptions (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__uncommonOptions(_map(26, 'CkPfx__uncommonOptions'))
    (objHandle);
end;

function CkPfx_getVerboseLogging (objHandle: HCkPfx): wordbool;
begin
    result := TCkPfx_getVerboseLogging(_map(27, 'CkPfx_getVerboseLogging'))
    (objHandle);
end;

procedure CkPfx_putVerboseLogging (objHandle: HCkPfx; newPropVal: wordbool);
begin
  TCkPfx_putVerboseLogging(_map(28, 'CkPfx_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkPfx_getVersion (objHandle: HCkPfx; outPropVal: HCkString);
begin
  TCkPfx_getVersion(_map(29, 'CkPfx_getVersion'))
    (objHandle, outPropVal);
end;

function CkPfx__version (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__version(_map(30, 'CkPfx__version'))
    (objHandle);
end;

function CkPfx_AddCert (objHandle: HCkPfx; cert: HCkCert; includeChain: wordbool): wordbool;
begin
  result := TCkPfx_AddCert(_map(31, 'CkPfx_AddCert'))
    (objHandle, cert, includeChain);
end;

function CkPfx_AddPrivateKey (objHandle: HCkPfx; privKey: HCkPrivateKey; certChain: HCkCertChain): wordbool;
begin
  result := TCkPfx_AddPrivateKey(_map(32, 'CkPfx_AddPrivateKey'))
    (objHandle, privKey, certChain);
end;

function CkPfx_CertAt (objHandle: HCkPfx; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkPfx_CertAt(_map(33, 'CkPfx_CertAt'))
    (objHandle, index, cert);
end;

function CkPfx_CertByLocalKeyId (objHandle: HCkPfx; localKeyId: PWideChar; encoding: PWideChar; cert: HCkCert): wordbool;
begin
  result := TCkPfx_CertByLocalKeyId(_map(34, 'CkPfx_CertByLocalKeyId'))
    (objHandle, localKeyId, encoding, cert);
end;

function CkPfx_FindCertByLocalKeyId (objHandle: HCkPfx; localKeyId: PWideChar; encoding: PWideChar): HCkCert;
begin
  result := TCkPfx_FindCertByLocalKeyId(_map(35, 'CkPfx_FindCertByLocalKeyId'))
    (objHandle, localKeyId, encoding);
end;

function CkPfx_GetCert (objHandle: HCkPfx; index: Integer): HCkCert;
begin
  result := TCkPfx_GetCert(_map(36, 'CkPfx_GetCert'))
    (objHandle, index);
end;

procedure CkPfx_GetLastJsonData (objHandle: HCkPfx; json: HCkJsonObject);
begin
  TCkPfx_GetLastJsonData(_map(37, 'CkPfx_GetLastJsonData'))
    (objHandle, json);
end;

function CkPfx_GetPrivateKey (objHandle: HCkPfx; index: Integer): HCkPrivateKey;
begin
  result := TCkPfx_GetPrivateKey(_map(38, 'CkPfx_GetPrivateKey'))
    (objHandle, index);
end;

function CkPfx_GetSafeBagAttr (objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; attrName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPfx_GetSafeBagAttr(_map(39, 'CkPfx_GetSafeBagAttr'))
    (objHandle, forPrivateKey, index, attrName, outStr);
end;

function CkPfx__getSafeBagAttr (objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; attrName: PWideChar): PWideChar;
begin
  result := TCkPfx__getSafeBagAttr(_map(40, 'CkPfx__getSafeBagAttr'))
    (objHandle, forPrivateKey, index, attrName);
end;

function CkPfx_ImportToKeychain (objHandle: HCkPfx; opts: HCkJsonObject): wordbool;
begin
  result := TCkPfx_ImportToKeychain(_map(41, 'CkPfx_ImportToKeychain'))
    (objHandle, opts);
end;

function CkPfx_ImportToWindows (objHandle: HCkPfx; exportable: wordbool; userProtected: wordbool; machineKeyset: wordbool; allowOverwriteKey: wordbool; allowExport: wordbool; leafStore: PWideChar; intermediateStore: PWideChar; rootStore: PWideChar; extraOptions: PWideChar): wordbool;
begin
  result := TCkPfx_ImportToWindows(_map(42, 'CkPfx_ImportToWindows'))
    (objHandle, exportable, userProtected, machineKeyset, allowOverwriteKey, allowExport, leafStore, intermediateStore, rootStore, extraOptions);
end;

function CkPfx_LastJsonData (objHandle: HCkPfx): HCkJsonObject;
begin
  result := TCkPfx_LastJsonData(_map(43, 'CkPfx_LastJsonData'))
    (objHandle);
end;

function CkPfx_LoadPem (objHandle: HCkPfx; pemStr: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPfx_LoadPem(_map(44, 'CkPfx_LoadPem'))
    (objHandle, pemStr, password);
end;

function CkPfx_LoadPfxBd (objHandle: HCkPfx; bd: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkPfx_LoadPfxBd(_map(45, 'CkPfx_LoadPfxBd'))
    (objHandle, bd, password);
end;

function CkPfx_LoadPfxBytes (objHandle: HCkPfx; pfxData: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkPfx_LoadPfxBytes(_map(46, 'CkPfx_LoadPfxBytes'))
    (objHandle, pfxData, password);
end;

function CkPfx_LoadPfxEncoded (objHandle: HCkPfx; encodedData: PWideChar; encoding: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPfx_LoadPfxEncoded(_map(47, 'CkPfx_LoadPfxEncoded'))
    (objHandle, encodedData, encoding, password);
end;

function CkPfx_LoadPfxFile (objHandle: HCkPfx; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPfx_LoadPfxFile(_map(48, 'CkPfx_LoadPfxFile'))
    (objHandle, path, password);
end;

function CkPfx_PrivateKeyAt (objHandle: HCkPfx; index: Integer; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkPfx_PrivateKeyAt(_map(49, 'CkPfx_PrivateKeyAt'))
    (objHandle, index, privKey);
end;

function CkPfx_SetSafeBagAttr (objHandle: HCkPfx; forPrivateKey: wordbool; index: Integer; name: PWideChar; value: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkPfx_SetSafeBagAttr(_map(50, 'CkPfx_SetSafeBagAttr'))
    (objHandle, forPrivateKey, index, name, value, encoding);
end;

function CkPfx_ToBd (objHandle: HCkPfx; password: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkPfx_ToBd(_map(51, 'CkPfx_ToBd'))
    (objHandle, password, bd);
end;

function CkPfx_ToBinary (objHandle: HCkPfx; password: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkPfx_ToBinary(_map(52, 'CkPfx_ToBinary'))
    (objHandle, password, outData);
end;

function CkPfx_ToEncodedString (objHandle: HCkPfx; password: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPfx_ToEncodedString(_map(53, 'CkPfx_ToEncodedString'))
    (objHandle, password, encoding, outStr);
end;

function CkPfx__toEncodedString (objHandle: HCkPfx; password: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkPfx__toEncodedString(_map(54, 'CkPfx__toEncodedString'))
    (objHandle, password, encoding);
end;

function CkPfx_ToFile (objHandle: HCkPfx; password: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkPfx_ToFile(_map(55, 'CkPfx_ToFile'))
    (objHandle, password, path);
end;

function CkPfx_ToJavaKeyStore (objHandle: HCkPfx; alias: PWideChar; password: PWideChar): HCkJavaKeyStore;
begin
  result := TCkPfx_ToJavaKeyStore(_map(56, 'CkPfx_ToJavaKeyStore'))
    (objHandle, alias, password);
end;

function CkPfx_ToJksObj (objHandle: HCkPfx; alias: PWideChar; password: PWideChar; jksObj: HCkJavaKeyStore): wordbool;
begin
  result := TCkPfx_ToJksObj(_map(57, 'CkPfx_ToJksObj'))
    (objHandle, alias, password, jksObj);
end;

function CkPfx_ToPem (objHandle: HCkPfx; outStr: HCkString): wordbool;
begin
  result := TCkPfx_ToPem(_map(58, 'CkPfx_ToPem'))
    (objHandle, outStr);
end;

function CkPfx__toPem (objHandle: HCkPfx): PWideChar;
begin
  result := TCkPfx__toPem(_map(59, 'CkPfx__toPem'))
    (objHandle);
end;

function CkPfx_ToPemEx (objHandle: HCkPfx; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPfx_ToPemEx(_map(60, 'CkPfx_ToPemEx'))
    (objHandle, extendedAttrs, noKeys, noCerts, noCaCerts, encryptAlg, password, outStr);
end;

function CkPfx__toPemEx (objHandle: HCkPfx; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar): PWideChar;
begin
  result := TCkPfx__toPemEx(_map(61, 'CkPfx__toPemEx'))
    (objHandle, extendedAttrs, noKeys, noCerts, noCaCerts, encryptAlg, password);
end;

function CkPfx_UseCertVault (objHandle: HCkPfx; vault: HCkXmlCertVault): wordbool;
begin
  result := TCkPfx_UseCertVault(_map(62, 'CkPfx_UseCertVault'))
    (objHandle, vault);
end;

end.
