unit Rest;

interface

type

HCkSecureString = Pointer;
HCkAuthAzureStorage = Pointer;
HCkAuthGoogle = Pointer;
HCkStringBuilder = Pointer;
HCkSocket = Pointer;
HCkBinData = Pointer;
HCkString = Pointer;
HCkByteData = Pointer;
HCkAuthAws = Pointer;
HCkUrl = Pointer;
HCkAuthAzureSAS = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;
HCkStream = Pointer;
HCkOAuth2 = Pointer;
HCkRest = Pointer;
HCkOAuth1 = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TRestAbortCheck = function(): Integer; cdecl;
TRestProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TRestPercentDone = function(pctDone: Integer): Integer; cdecl;
TRestTaskCompleted = procedure(task: HCkTask); cdecl;


function CkRest_Create: HCkRest;  stdcall;
procedure CkRest_Dispose(handle: HCkRest); stdcall;

procedure CkRest_SetAbortCheck(objHandle: HCkRest; fn: TRestAbortCheck) stdcall;
procedure CkRest_SetProgressInfo(objHandle: HCkRest; fn: TRestProgressInfo) stdcall;
procedure CkRest_SetPercentDone(objHandle: HCkRest; fn: TRestPercentDone) stdcall;
procedure CkRest_SetTaskCompleted(objHandle: HCkRest; fn: TRestTaskCompleted) stdcall;
function CkRest_getAllowHeaderFolding(objHandle: HCkRest): wordbool;
procedure CkRest_putAllowHeaderFolding(objHandle: HCkRest; newPropVal: wordbool);
function CkRest_getAllowHeaderQB(objHandle: HCkRest): wordbool;
procedure CkRest_putAllowHeaderQB(objHandle: HCkRest; newPropVal: wordbool);
procedure CkRest_getAuthorization(objHandle: HCkRest; outPropVal: HCkString);
procedure CkRest_putAuthorization(objHandle: HCkRest; newPropVal: PWideChar);
function CkRest__authorization(objHandle: HCkRest): PWideChar;
function CkRest_getConnectFailReason(objHandle: HCkRest): Integer;
function CkRest_getConnectTimeoutMs(objHandle: HCkRest): Integer;
procedure CkRest_putConnectTimeoutMs(objHandle: HCkRest; newPropVal: Integer);
procedure CkRest_getDebugLogFilePath(objHandle: HCkRest; outPropVal: HCkString);
procedure CkRest_putDebugLogFilePath(objHandle: HCkRest; newPropVal: PWideChar);
function CkRest__debugLogFilePath(objHandle: HCkRest): PWideChar;
function CkRest_getDebugMode(objHandle: HCkRest): wordbool;
procedure CkRest_putDebugMode(objHandle: HCkRest; newPropVal: wordbool);
function CkRest_getHeartbeatMs(objHandle: HCkRest): Integer;
procedure CkRest_putHeartbeatMs(objHandle: HCkRest; newPropVal: Integer);
procedure CkRest_getHost(objHandle: HCkRest; outPropVal: HCkString);
procedure CkRest_putHost(objHandle: HCkRest; newPropVal: PWideChar);
function CkRest__host(objHandle: HCkRest): PWideChar;
function CkRest_getIdleTimeoutMs(objHandle: HCkRest): Integer;
procedure CkRest_putIdleTimeoutMs(objHandle: HCkRest; newPropVal: Integer);
procedure CkRest_getLastErrorHtml(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__lastErrorHtml(objHandle: HCkRest): PWideChar;
procedure CkRest_getLastErrorText(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__lastErrorText(objHandle: HCkRest): PWideChar;
procedure CkRest_getLastErrorXml(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__lastErrorXml(objHandle: HCkRest): PWideChar;
function CkRest_getLastMethodSuccess(objHandle: HCkRest): wordbool;
procedure CkRest_putLastMethodSuccess(objHandle: HCkRest; newPropVal: wordbool);
procedure CkRest_getLastRedirectUrl(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__lastRedirectUrl(objHandle: HCkRest): PWideChar;
procedure CkRest_getLastRequestHeader(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__lastRequestHeader(objHandle: HCkRest): PWideChar;
procedure CkRest_getLastRequestStartLine(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__lastRequestStartLine(objHandle: HCkRest): PWideChar;
function CkRest_getNumResponseHeaders(objHandle: HCkRest): Integer;
procedure CkRest_getPartSelector(objHandle: HCkRest; outPropVal: HCkString);
procedure CkRest_putPartSelector(objHandle: HCkRest; newPropVal: PWideChar);
function CkRest__partSelector(objHandle: HCkRest): PWideChar;
function CkRest_getPercentDoneOnSend(objHandle: HCkRest): wordbool;
procedure CkRest_putPercentDoneOnSend(objHandle: HCkRest; newPropVal: wordbool);
procedure CkRest_getResponseHeader(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__responseHeader(objHandle: HCkRest): PWideChar;
function CkRest_getResponseStatusCode(objHandle: HCkRest): Integer;
procedure CkRest_getResponseStatusText(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__responseStatusText(objHandle: HCkRest): PWideChar;
function CkRest_getStreamNonChunked(objHandle: HCkRest): wordbool;
procedure CkRest_putStreamNonChunked(objHandle: HCkRest; newPropVal: wordbool);
procedure CkRest_getUncommonOptions(objHandle: HCkRest; outPropVal: HCkString);
procedure CkRest_putUncommonOptions(objHandle: HCkRest; newPropVal: PWideChar);
function CkRest__uncommonOptions(objHandle: HCkRest): PWideChar;
function CkRest_getVerboseLogging(objHandle: HCkRest): wordbool;
procedure CkRest_putVerboseLogging(objHandle: HCkRest; newPropVal: wordbool);
procedure CkRest_getVersion(objHandle: HCkRest; outPropVal: HCkString);
function CkRest__version(objHandle: HCkRest): PWideChar;
function CkRest_AddHeader(objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool;
function CkRest_AddMwsSignature(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; domain: PWideChar; mwsSecretKey: PWideChar): wordbool;
function CkRest_AddPathParam(objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool;
function CkRest_AddQueryParam(objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool;
function CkRest_AddQueryParams(objHandle: HCkRest; queryString: PWideChar): wordbool;
function CkRest_AddQueryParamSb(objHandle: HCkRest; name: PWideChar; value: HCkStringBuilder): wordbool;
function CkRest_ClearAllHeaders(objHandle: HCkRest): wordbool;
function CkRest_ClearAllParts(objHandle: HCkRest): wordbool;
function CkRest_ClearAllPathParams(objHandle: HCkRest): wordbool;
function CkRest_ClearAllQueryParams(objHandle: HCkRest): wordbool;
function CkRest_ClearAuth(objHandle: HCkRest): wordbool;
procedure CkRest_ClearResponseBodyStream(objHandle: HCkRest);
function CkRest_Connect(objHandle: HCkRest; hostname: PWideChar; port: Integer; tls: wordbool; autoReconnect: wordbool): wordbool;
function CkRest_ConnectAsync(objHandle: HCkRest; hostname: PWideChar; port: Integer; tls: wordbool; autoReconnect: wordbool): HCkTask;
function CkRest_Disconnect(objHandle: HCkRest; maxWaitMs: Integer): wordbool;
function CkRest_DisconnectAsync(objHandle: HCkRest; maxWaitMs: Integer): HCkTask;
function CkRest_FullRequestBd(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData; responseBody: HCkStringBuilder): wordbool;
function CkRest_FullRequestBdAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData; responseBody: HCkStringBuilder): HCkTask;
function CkRest_FullRequestBinary(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData; outStr: HCkString): wordbool;
function CkRest__fullRequestBinary(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData): PWideChar;
function CkRest_FullRequestBinaryAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData): HCkTask;
function CkRest_FullRequestFormUrlEncoded(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool;
function CkRest__fullRequestFormUrlEncoded(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar;
function CkRest_FullRequestFormUrlEncodedAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
function CkRest_FullRequestMultipart(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool;
function CkRest__fullRequestMultipart(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar;
function CkRest_FullRequestMultipartAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
function CkRest_FullRequestNoBody(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool;
function CkRest__fullRequestNoBody(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar;
function CkRest_FullRequestNoBodyAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
function CkRest_FullRequestNoBodyBd(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData): wordbool;
function CkRest_FullRequestNoBodyBdAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData): HCkTask;
function CkRest_FullRequestNoBodySb(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; sb: HCkStringBuilder): wordbool;
function CkRest_FullRequestNoBodySbAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; sb: HCkStringBuilder): HCkTask;
function CkRest_FullRequestSb(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; requestBody: HCkStringBuilder; responseBody: HCkStringBuilder): wordbool;
function CkRest_FullRequestSbAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; requestBody: HCkStringBuilder; responseBody: HCkStringBuilder): HCkTask;
function CkRest_FullRequestStream(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream; outStr: HCkString): wordbool;
function CkRest__fullRequestStream(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): PWideChar;
function CkRest_FullRequestStreamAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): HCkTask;
function CkRest_FullRequestString(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar; outStr: HCkString): wordbool;
function CkRest__fullRequestString(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): PWideChar;
function CkRest_FullRequestStringAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): HCkTask;
function CkRest_GetLastDebugRequest(objHandle: HCkRest; bd: HCkBinData): wordbool;
procedure CkRest_GetLastJsonData(objHandle: HCkRest; json: HCkJsonObject);
function CkRest_LastJsonData(objHandle: HCkRest): HCkJsonObject;
function CkRest_LoadTaskCaller(objHandle: HCkRest; task: HCkTask): wordbool;
function CkRest_ReadRespBd(objHandle: HCkRest; responseBody: HCkBinData): wordbool;
function CkRest_ReadRespBdAsync(objHandle: HCkRest; responseBody: HCkBinData): HCkTask;
function CkRest_ReadRespBodyBinary(objHandle: HCkRest; outData: HCkByteData): wordbool;
function CkRest_ReadRespBodyBinaryAsync(objHandle: HCkRest): HCkTask;
function CkRest_ReadRespBodyStream(objHandle: HCkRest; stream: HCkStream; autoSetStreamCharset: wordbool): wordbool;
function CkRest_ReadRespBodyStreamAsync(objHandle: HCkRest; stream: HCkStream; autoSetStreamCharset: wordbool): HCkTask;
function CkRest_ReadRespBodyString(objHandle: HCkRest; outStr: HCkString): wordbool;
function CkRest__readRespBodyString(objHandle: HCkRest): PWideChar;
function CkRest_ReadRespBodyStringAsync(objHandle: HCkRest): HCkTask;
function CkRest_ReadRespChunkBd(objHandle: HCkRest; minSize: Integer; bd: HCkBinData): Integer;
function CkRest_ReadRespChunkBdAsync(objHandle: HCkRest; minSize: Integer; bd: HCkBinData): HCkTask;
function CkRest_ReadResponseHeader(objHandle: HCkRest): Integer;
function CkRest_ReadResponseHeaderAsync(objHandle: HCkRest): HCkTask;
function CkRest_ReadRespSb(objHandle: HCkRest; responseBody: HCkStringBuilder): wordbool;
function CkRest_ReadRespSbAsync(objHandle: HCkRest; responseBody: HCkStringBuilder): HCkTask;
function CkRest_RedirectUrl(objHandle: HCkRest): HCkUrl;
function CkRest_RemoveHeader(objHandle: HCkRest; name: PWideChar): wordbool;
function CkRest_RemoveQueryParam(objHandle: HCkRest; name: PWideChar): wordbool;
function CkRest_ResponseHdrByName(objHandle: HCkRest; name: PWideChar; outStr: HCkString): wordbool;
function CkRest__responseHdrByName(objHandle: HCkRest; name: PWideChar): PWideChar;
function CkRest_ResponseHdrName(objHandle: HCkRest; index: Integer; outStr: HCkString): wordbool;
function CkRest__responseHdrName(objHandle: HCkRest; index: Integer): PWideChar;
function CkRest_ResponseHdrValue(objHandle: HCkRest; index: Integer; outStr: HCkString): wordbool;
function CkRest__responseHdrValue(objHandle: HCkRest; index: Integer): PWideChar;
function CkRest_SendReqBd(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkBinData): wordbool;
function CkRest_SendReqBdAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkBinData): HCkTask;
function CkRest_SendReqBinaryBody(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkByteData): wordbool;
function CkRest_SendReqBinaryBodyAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkByteData): HCkTask;
function CkRest_SendReqFormUrlEncoded(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool;
function CkRest_SendReqFormUrlEncodedAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
function CkRest_SendReqMultipart(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool;
function CkRest_SendReqMultipartAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
function CkRest_SendReqNoBody(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool;
function CkRest_SendReqNoBodyAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
function CkRest_SendReqSb(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodySb: HCkStringBuilder): wordbool;
function CkRest_SendReqSbAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodySb: HCkStringBuilder): HCkTask;
function CkRest_SendReqStreamBody(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): wordbool;
function CkRest_SendReqStreamBodyAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): HCkTask;
function CkRest_SendReqStringBody(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): wordbool;
function CkRest_SendReqStringBodyAsync(objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): HCkTask;
function CkRest_SetAuthAws(objHandle: HCkRest; authProvider: HCkAuthAws): wordbool;
function CkRest_SetAuthAzureSas(objHandle: HCkRest; authProvider: HCkAuthAzureSAS): wordbool;
function CkRest_SetAuthAzureStorage(objHandle: HCkRest; authProvider: HCkAuthAzureStorage): wordbool;
function CkRest_SetAuthBasic(objHandle: HCkRest; username: PWideChar; password: PWideChar): wordbool;
function CkRest_SetAuthBasicSecure(objHandle: HCkRest; username: HCkSecureString; password: HCkSecureString): wordbool;
function CkRest_SetAuthGoogle(objHandle: HCkRest; authProvider: HCkAuthGoogle): wordbool;
function CkRest_SetAuthOAuth1(objHandle: HCkRest; authProvider: HCkOAuth1; useQueryParams: wordbool): wordbool;
function CkRest_SetAuthOAuth2(objHandle: HCkRest; authProvider: HCkOAuth2): wordbool;
function CkRest_SetMultipartBodyBd(objHandle: HCkRest; bodyData: HCkBinData): wordbool;
function CkRest_SetMultipartBodyBinary(objHandle: HCkRest; bodyData: HCkByteData): wordbool;
function CkRest_SetMultipartBodySb(objHandle: HCkRest; bodySb: HCkStringBuilder): wordbool;
function CkRest_SetMultipartBodyStream(objHandle: HCkRest; stream: HCkStream): wordbool;
function CkRest_SetMultipartBodyString(objHandle: HCkRest; bodyText: PWideChar): wordbool;
function CkRest_SetResponseBodyStream(objHandle: HCkRest; expectedStatus: Integer; autoSetStreamCharset: wordbool; responseStream: HCkStream): wordbool;
function CkRest_UseConnection(objHandle: HCkRest; connection: HCkSocket; autoReconnect: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkRest_Create = function : HCkRest; stdcall;
  TCkRest_Dispose = procedure (handle: HCkRest); stdcall;
  TCkRest_SetAbortCheck = procedure (objHandle: HCkRest; fn: TRestAbortCheck); stdcall;
  TCkRest_SetProgressInfo = procedure (objHandle: HCkRest; fn: TRestProgressInfo); stdcall;
  TCkRest_SetPercentDone = procedure (objHandle: HCkRest; fn: TRestPercentDone); stdcall;
  TCkRest_SetTaskCompleted = procedure (objHandle: HCkRest; fn: TRestTaskCompleted); stdcall;
  TCkRest_getAllowHeaderFolding = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putAllowHeaderFolding = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getAllowHeaderQB = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putAllowHeaderQB = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getAuthorization = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest_putAuthorization = procedure (objHandle: HCkRest; newPropVal: PWideChar); stdcall;
  TCkRest__authorization = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getConnectFailReason = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_getConnectTimeoutMs = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_putConnectTimeoutMs = procedure (objHandle: HCkRest; newPropVal: Integer); stdcall;
  TCkRest_getDebugLogFilePath = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest_putDebugLogFilePath = procedure (objHandle: HCkRest; newPropVal: PWideChar); stdcall;
  TCkRest__debugLogFilePath = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getDebugMode = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putDebugMode = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getHeartbeatMs = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_putHeartbeatMs = procedure (objHandle: HCkRest; newPropVal: Integer); stdcall;
  TCkRest_getHost = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest_putHost = procedure (objHandle: HCkRest; newPropVal: PWideChar); stdcall;
  TCkRest__host = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getIdleTimeoutMs = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_putIdleTimeoutMs = procedure (objHandle: HCkRest; newPropVal: Integer); stdcall;
  TCkRest_getLastErrorHtml = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__lastErrorHtml = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getLastErrorText = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__lastErrorText = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getLastErrorXml = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__lastErrorXml = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getLastMethodSuccess = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putLastMethodSuccess = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getLastRedirectUrl = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__lastRedirectUrl = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getLastRequestHeader = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__lastRequestHeader = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getLastRequestStartLine = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__lastRequestStartLine = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getNumResponseHeaders = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_getPartSelector = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest_putPartSelector = procedure (objHandle: HCkRest; newPropVal: PWideChar); stdcall;
  TCkRest__partSelector = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getPercentDoneOnSend = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putPercentDoneOnSend = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getResponseHeader = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__responseHeader = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getResponseStatusCode = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_getResponseStatusText = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__responseStatusText = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getStreamNonChunked = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putStreamNonChunked = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getUncommonOptions = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest_putUncommonOptions = procedure (objHandle: HCkRest; newPropVal: PWideChar); stdcall;
  TCkRest__uncommonOptions = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_getVerboseLogging = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_putVerboseLogging = procedure (objHandle: HCkRest; newPropVal: wordbool); stdcall;
  TCkRest_getVersion = procedure (objHandle: HCkRest; outPropVal: HCkString); stdcall;
  TCkRest__version = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_AddHeader = function (objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkRest_AddMwsSignature = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; domain: PWideChar; mwsSecretKey: PWideChar): wordbool; stdcall;
  TCkRest_AddPathParam = function (objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkRest_AddQueryParam = function (objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkRest_AddQueryParams = function (objHandle: HCkRest; queryString: PWideChar): wordbool; stdcall;
  TCkRest_AddQueryParamSb = function (objHandle: HCkRest; name: PWideChar; value: HCkStringBuilder): wordbool; stdcall;
  TCkRest_ClearAllHeaders = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_ClearAllParts = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_ClearAllPathParams = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_ClearAllQueryParams = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_ClearAuth = function (objHandle: HCkRest): wordbool; stdcall;
  TCkRest_ClearResponseBodyStream = procedure (objHandle: HCkRest); stdcall;
  TCkRest_Connect = function (objHandle: HCkRest; hostname: PWideChar; port: Integer; tls: wordbool; autoReconnect: wordbool): wordbool; stdcall;
  TCkRest_ConnectAsync = function (objHandle: HCkRest; hostname: PWideChar; port: Integer; tls: wordbool; autoReconnect: wordbool): HCkTask; stdcall;
  TCkRest_Disconnect = function (objHandle: HCkRest; maxWaitMs: Integer): wordbool; stdcall;
  TCkRest_DisconnectAsync = function (objHandle: HCkRest; maxWaitMs: Integer): HCkTask; stdcall;
  TCkRest_FullRequestBd = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData; responseBody: HCkStringBuilder): wordbool; stdcall;
  TCkRest_FullRequestBdAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData; responseBody: HCkStringBuilder): HCkTask; stdcall;
  TCkRest_FullRequestBinary = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkRest__fullRequestBinary = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData): PWideChar; stdcall;
  TCkRest_FullRequestBinaryAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData): HCkTask; stdcall;
  TCkRest_FullRequestFormUrlEncoded = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRest__fullRequestFormUrlEncoded = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar; stdcall;
  TCkRest_FullRequestFormUrlEncodedAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask; stdcall;
  TCkRest_FullRequestMultipart = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRest__fullRequestMultipart = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar; stdcall;
  TCkRest_FullRequestMultipartAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask; stdcall;
  TCkRest_FullRequestNoBody = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRest__fullRequestNoBody = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar; stdcall;
  TCkRest_FullRequestNoBodyAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask; stdcall;
  TCkRest_FullRequestNoBodyBd = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData): wordbool; stdcall;
  TCkRest_FullRequestNoBodyBdAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData): HCkTask; stdcall;
  TCkRest_FullRequestNoBodySb = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkRest_FullRequestNoBodySbAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkRest_FullRequestSb = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; requestBody: HCkStringBuilder; responseBody: HCkStringBuilder): wordbool; stdcall;
  TCkRest_FullRequestSbAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; requestBody: HCkStringBuilder; responseBody: HCkStringBuilder): HCkTask; stdcall;
  TCkRest_FullRequestStream = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream; outStr: HCkString): wordbool; stdcall;
  TCkRest__fullRequestStream = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): PWideChar; stdcall;
  TCkRest_FullRequestStreamAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): HCkTask; stdcall;
  TCkRest_FullRequestString = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRest__fullRequestString = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): PWideChar; stdcall;
  TCkRest_FullRequestStringAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): HCkTask; stdcall;
  TCkRest_GetLastDebugRequest = function (objHandle: HCkRest; bd: HCkBinData): wordbool; stdcall;
  TCkRest_GetLastJsonData = procedure (objHandle: HCkRest; json: HCkJsonObject); stdcall;
  TCkRest_LastJsonData = function (objHandle: HCkRest): HCkJsonObject; stdcall;
  TCkRest_LoadTaskCaller = function (objHandle: HCkRest; task: HCkTask): wordbool; stdcall;
  TCkRest_ReadRespBd = function (objHandle: HCkRest; responseBody: HCkBinData): wordbool; stdcall;
  TCkRest_ReadRespBdAsync = function (objHandle: HCkRest; responseBody: HCkBinData): HCkTask; stdcall;
  TCkRest_ReadRespBodyBinary = function (objHandle: HCkRest; outData: HCkByteData): wordbool; stdcall;
  TCkRest_ReadRespBodyBinaryAsync = function (objHandle: HCkRest): HCkTask; stdcall;
  TCkRest_ReadRespBodyStream = function (objHandle: HCkRest; stream: HCkStream; autoSetStreamCharset: wordbool): wordbool; stdcall;
  TCkRest_ReadRespBodyStreamAsync = function (objHandle: HCkRest; stream: HCkStream; autoSetStreamCharset: wordbool): HCkTask; stdcall;
  TCkRest_ReadRespBodyString = function (objHandle: HCkRest; outStr: HCkString): wordbool; stdcall;
  TCkRest__readRespBodyString = function (objHandle: HCkRest): PWideChar; stdcall;
  TCkRest_ReadRespBodyStringAsync = function (objHandle: HCkRest): HCkTask; stdcall;
  TCkRest_ReadRespChunkBd = function (objHandle: HCkRest; minSize: Integer; bd: HCkBinData): Integer; stdcall;
  TCkRest_ReadRespChunkBdAsync = function (objHandle: HCkRest; minSize: Integer; bd: HCkBinData): HCkTask; stdcall;
  TCkRest_ReadResponseHeader = function (objHandle: HCkRest): Integer; stdcall;
  TCkRest_ReadResponseHeaderAsync = function (objHandle: HCkRest): HCkTask; stdcall;
  TCkRest_ReadRespSb = function (objHandle: HCkRest; responseBody: HCkStringBuilder): wordbool; stdcall;
  TCkRest_ReadRespSbAsync = function (objHandle: HCkRest; responseBody: HCkStringBuilder): HCkTask; stdcall;
  TCkRest_RedirectUrl = function (objHandle: HCkRest): HCkUrl; stdcall;
  TCkRest_RemoveHeader = function (objHandle: HCkRest; name: PWideChar): wordbool; stdcall;
  TCkRest_RemoveQueryParam = function (objHandle: HCkRest; name: PWideChar): wordbool; stdcall;
  TCkRest_ResponseHdrByName = function (objHandle: HCkRest; name: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRest__responseHdrByName = function (objHandle: HCkRest; name: PWideChar): PWideChar; stdcall;
  TCkRest_ResponseHdrName = function (objHandle: HCkRest; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkRest__responseHdrName = function (objHandle: HCkRest; index: Integer): PWideChar; stdcall;
  TCkRest_ResponseHdrValue = function (objHandle: HCkRest; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkRest__responseHdrValue = function (objHandle: HCkRest; index: Integer): PWideChar; stdcall;
  TCkRest_SendReqBd = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkBinData): wordbool; stdcall;
  TCkRest_SendReqBdAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkBinData): HCkTask; stdcall;
  TCkRest_SendReqBinaryBody = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkByteData): wordbool; stdcall;
  TCkRest_SendReqBinaryBodyAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkByteData): HCkTask; stdcall;
  TCkRest_SendReqFormUrlEncoded = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool; stdcall;
  TCkRest_SendReqFormUrlEncodedAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask; stdcall;
  TCkRest_SendReqMultipart = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool; stdcall;
  TCkRest_SendReqMultipartAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask; stdcall;
  TCkRest_SendReqNoBody = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool; stdcall;
  TCkRest_SendReqNoBodyAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask; stdcall;
  TCkRest_SendReqSb = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodySb: HCkStringBuilder): wordbool; stdcall;
  TCkRest_SendReqSbAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodySb: HCkStringBuilder): HCkTask; stdcall;
  TCkRest_SendReqStreamBody = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): wordbool; stdcall;
  TCkRest_SendReqStreamBodyAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): HCkTask; stdcall;
  TCkRest_SendReqStringBody = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): wordbool; stdcall;
  TCkRest_SendReqStringBodyAsync = function (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): HCkTask; stdcall;
  TCkRest_SetAuthAws = function (objHandle: HCkRest; authProvider: HCkAuthAws): wordbool; stdcall;
  TCkRest_SetAuthAzureSas = function (objHandle: HCkRest; authProvider: HCkAuthAzureSAS): wordbool; stdcall;
  TCkRest_SetAuthAzureStorage = function (objHandle: HCkRest; authProvider: HCkAuthAzureStorage): wordbool; stdcall;
  TCkRest_SetAuthBasic = function (objHandle: HCkRest; username: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkRest_SetAuthBasicSecure = function (objHandle: HCkRest; username: HCkSecureString; password: HCkSecureString): wordbool; stdcall;
  TCkRest_SetAuthGoogle = function (objHandle: HCkRest; authProvider: HCkAuthGoogle): wordbool; stdcall;
  TCkRest_SetAuthOAuth1 = function (objHandle: HCkRest; authProvider: HCkOAuth1; useQueryParams: wordbool): wordbool; stdcall;
  TCkRest_SetAuthOAuth2 = function (objHandle: HCkRest; authProvider: HCkOAuth2): wordbool; stdcall;
  TCkRest_SetMultipartBodyBd = function (objHandle: HCkRest; bodyData: HCkBinData): wordbool; stdcall;
  TCkRest_SetMultipartBodyBinary = function (objHandle: HCkRest; bodyData: HCkByteData): wordbool; stdcall;
  TCkRest_SetMultipartBodySb = function (objHandle: HCkRest; bodySb: HCkStringBuilder): wordbool; stdcall;
  TCkRest_SetMultipartBodyStream = function (objHandle: HCkRest; stream: HCkStream): wordbool; stdcall;
  TCkRest_SetMultipartBodyString = function (objHandle: HCkRest; bodyText: PWideChar): wordbool; stdcall;
  TCkRest_SetResponseBodyStream = function (objHandle: HCkRest; expectedStatus: Integer; autoSetStreamCharset: wordbool; responseStream: HCkStream): wordbool; stdcall;
  TCkRest_UseConnection = function (objHandle: HCkRest; connection: HCkSocket; autoReconnect: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..162] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkRest_Create : HCkRest;
begin
  result := TCkRest_Create(_map(0, 'CkRest_Create'));
end;

procedure CkRest_Dispose (handle: HCkRest);
begin
  TCkRest_Dispose(_map(1, 'CkRest_Dispose'))
    (handle);
end;


procedure CkRest_SetAbortCheck (objHandle: HCkRest; fn: TRestAbortCheck);
begin
    TCkRest_SetAbortCheck(_map(2, 'CkRest_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkRest_SetProgressInfo (objHandle: HCkRest; fn: TRestProgressInfo);
begin
    TCkRest_SetProgressInfo(_map(3, 'CkRest_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkRest_SetPercentDone (objHandle: HCkRest; fn: TRestPercentDone);
begin
    TCkRest_SetPercentDone(_map(4, 'CkRest_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkRest_SetTaskCompleted (objHandle: HCkRest; fn: TRestTaskCompleted);
begin
    TCkRest_SetTaskCompleted(_map(5, 'CkRest_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkRest_getAllowHeaderFolding (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getAllowHeaderFolding(_map(6, 'CkRest_getAllowHeaderFolding'))
    (objHandle);
end;

procedure CkRest_putAllowHeaderFolding (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putAllowHeaderFolding(_map(7, 'CkRest_putAllowHeaderFolding'))
    (objHandle, newPropVal);
end;

function CkRest_getAllowHeaderQB (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getAllowHeaderQB(_map(8, 'CkRest_getAllowHeaderQB'))
    (objHandle);
end;

procedure CkRest_putAllowHeaderQB (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putAllowHeaderQB(_map(9, 'CkRest_putAllowHeaderQB'))
    (objHandle, newPropVal);
end;

procedure CkRest_getAuthorization (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getAuthorization(_map(10, 'CkRest_getAuthorization'))
    (objHandle, outPropVal);
end;

procedure CkRest_putAuthorization (objHandle: HCkRest; newPropVal: PWideChar);
begin
  TCkRest_putAuthorization(_map(11, 'CkRest_putAuthorization'))
    (objHandle, newPropVal);
end;

function CkRest__authorization (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__authorization(_map(12, 'CkRest__authorization'))
    (objHandle);
end;

function CkRest_getConnectFailReason (objHandle: HCkRest): Integer;
begin
    result := TCkRest_getConnectFailReason(_map(13, 'CkRest_getConnectFailReason'))
    (objHandle);
end;

function CkRest_getConnectTimeoutMs (objHandle: HCkRest): Integer;
begin
    result := TCkRest_getConnectTimeoutMs(_map(14, 'CkRest_getConnectTimeoutMs'))
    (objHandle);
end;

procedure CkRest_putConnectTimeoutMs (objHandle: HCkRest; newPropVal: Integer);
begin
  TCkRest_putConnectTimeoutMs(_map(15, 'CkRest_putConnectTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkRest_getDebugLogFilePath (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getDebugLogFilePath(_map(16, 'CkRest_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkRest_putDebugLogFilePath (objHandle: HCkRest; newPropVal: PWideChar);
begin
  TCkRest_putDebugLogFilePath(_map(17, 'CkRest_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkRest__debugLogFilePath (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__debugLogFilePath(_map(18, 'CkRest__debugLogFilePath'))
    (objHandle);
end;

function CkRest_getDebugMode (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getDebugMode(_map(19, 'CkRest_getDebugMode'))
    (objHandle);
end;

procedure CkRest_putDebugMode (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putDebugMode(_map(20, 'CkRest_putDebugMode'))
    (objHandle, newPropVal);
end;

function CkRest_getHeartbeatMs (objHandle: HCkRest): Integer;
begin
    result := TCkRest_getHeartbeatMs(_map(21, 'CkRest_getHeartbeatMs'))
    (objHandle);
end;

procedure CkRest_putHeartbeatMs (objHandle: HCkRest; newPropVal: Integer);
begin
  TCkRest_putHeartbeatMs(_map(22, 'CkRest_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkRest_getHost (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getHost(_map(23, 'CkRest_getHost'))
    (objHandle, outPropVal);
end;

procedure CkRest_putHost (objHandle: HCkRest; newPropVal: PWideChar);
begin
  TCkRest_putHost(_map(24, 'CkRest_putHost'))
    (objHandle, newPropVal);
end;

function CkRest__host (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__host(_map(25, 'CkRest__host'))
    (objHandle);
end;

function CkRest_getIdleTimeoutMs (objHandle: HCkRest): Integer;
begin
    result := TCkRest_getIdleTimeoutMs(_map(26, 'CkRest_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkRest_putIdleTimeoutMs (objHandle: HCkRest; newPropVal: Integer);
begin
  TCkRest_putIdleTimeoutMs(_map(27, 'CkRest_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkRest_getLastErrorHtml (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getLastErrorHtml(_map(28, 'CkRest_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkRest__lastErrorHtml (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__lastErrorHtml(_map(29, 'CkRest__lastErrorHtml'))
    (objHandle);
end;

procedure CkRest_getLastErrorText (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getLastErrorText(_map(30, 'CkRest_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkRest__lastErrorText (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__lastErrorText(_map(31, 'CkRest__lastErrorText'))
    (objHandle);
end;

procedure CkRest_getLastErrorXml (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getLastErrorXml(_map(32, 'CkRest_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkRest__lastErrorXml (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__lastErrorXml(_map(33, 'CkRest__lastErrorXml'))
    (objHandle);
end;

function CkRest_getLastMethodSuccess (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getLastMethodSuccess(_map(34, 'CkRest_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkRest_putLastMethodSuccess (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putLastMethodSuccess(_map(35, 'CkRest_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkRest_getLastRedirectUrl (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getLastRedirectUrl(_map(36, 'CkRest_getLastRedirectUrl'))
    (objHandle, outPropVal);
end;

function CkRest__lastRedirectUrl (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__lastRedirectUrl(_map(37, 'CkRest__lastRedirectUrl'))
    (objHandle);
end;

procedure CkRest_getLastRequestHeader (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getLastRequestHeader(_map(38, 'CkRest_getLastRequestHeader'))
    (objHandle, outPropVal);
end;

function CkRest__lastRequestHeader (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__lastRequestHeader(_map(39, 'CkRest__lastRequestHeader'))
    (objHandle);
end;

procedure CkRest_getLastRequestStartLine (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getLastRequestStartLine(_map(40, 'CkRest_getLastRequestStartLine'))
    (objHandle, outPropVal);
end;

function CkRest__lastRequestStartLine (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__lastRequestStartLine(_map(41, 'CkRest__lastRequestStartLine'))
    (objHandle);
end;

function CkRest_getNumResponseHeaders (objHandle: HCkRest): Integer;
begin
    result := TCkRest_getNumResponseHeaders(_map(42, 'CkRest_getNumResponseHeaders'))
    (objHandle);
end;

procedure CkRest_getPartSelector (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getPartSelector(_map(43, 'CkRest_getPartSelector'))
    (objHandle, outPropVal);
end;

procedure CkRest_putPartSelector (objHandle: HCkRest; newPropVal: PWideChar);
begin
  TCkRest_putPartSelector(_map(44, 'CkRest_putPartSelector'))
    (objHandle, newPropVal);
end;

function CkRest__partSelector (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__partSelector(_map(45, 'CkRest__partSelector'))
    (objHandle);
end;

function CkRest_getPercentDoneOnSend (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getPercentDoneOnSend(_map(46, 'CkRest_getPercentDoneOnSend'))
    (objHandle);
end;

procedure CkRest_putPercentDoneOnSend (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putPercentDoneOnSend(_map(47, 'CkRest_putPercentDoneOnSend'))
    (objHandle, newPropVal);
end;

procedure CkRest_getResponseHeader (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getResponseHeader(_map(48, 'CkRest_getResponseHeader'))
    (objHandle, outPropVal);
end;

function CkRest__responseHeader (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__responseHeader(_map(49, 'CkRest__responseHeader'))
    (objHandle);
end;

function CkRest_getResponseStatusCode (objHandle: HCkRest): Integer;
begin
    result := TCkRest_getResponseStatusCode(_map(50, 'CkRest_getResponseStatusCode'))
    (objHandle);
end;

procedure CkRest_getResponseStatusText (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getResponseStatusText(_map(51, 'CkRest_getResponseStatusText'))
    (objHandle, outPropVal);
end;

function CkRest__responseStatusText (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__responseStatusText(_map(52, 'CkRest__responseStatusText'))
    (objHandle);
end;

function CkRest_getStreamNonChunked (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getStreamNonChunked(_map(53, 'CkRest_getStreamNonChunked'))
    (objHandle);
end;

procedure CkRest_putStreamNonChunked (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putStreamNonChunked(_map(54, 'CkRest_putStreamNonChunked'))
    (objHandle, newPropVal);
end;

procedure CkRest_getUncommonOptions (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getUncommonOptions(_map(55, 'CkRest_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkRest_putUncommonOptions (objHandle: HCkRest; newPropVal: PWideChar);
begin
  TCkRest_putUncommonOptions(_map(56, 'CkRest_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkRest__uncommonOptions (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__uncommonOptions(_map(57, 'CkRest__uncommonOptions'))
    (objHandle);
end;

function CkRest_getVerboseLogging (objHandle: HCkRest): wordbool;
begin
    result := TCkRest_getVerboseLogging(_map(58, 'CkRest_getVerboseLogging'))
    (objHandle);
end;

procedure CkRest_putVerboseLogging (objHandle: HCkRest; newPropVal: wordbool);
begin
  TCkRest_putVerboseLogging(_map(59, 'CkRest_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkRest_getVersion (objHandle: HCkRest; outPropVal: HCkString);
begin
  TCkRest_getVersion(_map(60, 'CkRest_getVersion'))
    (objHandle, outPropVal);
end;

function CkRest__version (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__version(_map(61, 'CkRest__version'))
    (objHandle);
end;

function CkRest_AddHeader (objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkRest_AddHeader(_map(62, 'CkRest_AddHeader'))
    (objHandle, name, value);
end;

function CkRest_AddMwsSignature (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; domain: PWideChar; mwsSecretKey: PWideChar): wordbool;
begin
  result := TCkRest_AddMwsSignature(_map(63, 'CkRest_AddMwsSignature'))
    (objHandle, httpVerb, uriPath, domain, mwsSecretKey);
end;

function CkRest_AddPathParam (objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkRest_AddPathParam(_map(64, 'CkRest_AddPathParam'))
    (objHandle, name, value);
end;

function CkRest_AddQueryParam (objHandle: HCkRest; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkRest_AddQueryParam(_map(65, 'CkRest_AddQueryParam'))
    (objHandle, name, value);
end;

function CkRest_AddQueryParams (objHandle: HCkRest; queryString: PWideChar): wordbool;
begin
  result := TCkRest_AddQueryParams(_map(66, 'CkRest_AddQueryParams'))
    (objHandle, queryString);
end;

function CkRest_AddQueryParamSb (objHandle: HCkRest; name: PWideChar; value: HCkStringBuilder): wordbool;
begin
  result := TCkRest_AddQueryParamSb(_map(67, 'CkRest_AddQueryParamSb'))
    (objHandle, name, value);
end;

function CkRest_ClearAllHeaders (objHandle: HCkRest): wordbool;
begin
  result := TCkRest_ClearAllHeaders(_map(68, 'CkRest_ClearAllHeaders'))
    (objHandle);
end;

function CkRest_ClearAllParts (objHandle: HCkRest): wordbool;
begin
  result := TCkRest_ClearAllParts(_map(69, 'CkRest_ClearAllParts'))
    (objHandle);
end;

function CkRest_ClearAllPathParams (objHandle: HCkRest): wordbool;
begin
  result := TCkRest_ClearAllPathParams(_map(70, 'CkRest_ClearAllPathParams'))
    (objHandle);
end;

function CkRest_ClearAllQueryParams (objHandle: HCkRest): wordbool;
begin
  result := TCkRest_ClearAllQueryParams(_map(71, 'CkRest_ClearAllQueryParams'))
    (objHandle);
end;

function CkRest_ClearAuth (objHandle: HCkRest): wordbool;
begin
  result := TCkRest_ClearAuth(_map(72, 'CkRest_ClearAuth'))
    (objHandle);
end;

procedure CkRest_ClearResponseBodyStream (objHandle: HCkRest);
begin
  TCkRest_ClearResponseBodyStream(_map(73, 'CkRest_ClearResponseBodyStream'))
    (objHandle);
end;

function CkRest_Connect (objHandle: HCkRest; hostname: PWideChar; port: Integer; tls: wordbool; autoReconnect: wordbool): wordbool;
begin
  result := TCkRest_Connect(_map(74, 'CkRest_Connect'))
    (objHandle, hostname, port, tls, autoReconnect);
end;

function CkRest_ConnectAsync (objHandle: HCkRest; hostname: PWideChar; port: Integer; tls: wordbool; autoReconnect: wordbool): HCkTask;
begin
  result := TCkRest_ConnectAsync(_map(75, 'CkRest_ConnectAsync'))
    (objHandle, hostname, port, tls, autoReconnect);
end;

function CkRest_Disconnect (objHandle: HCkRest; maxWaitMs: Integer): wordbool;
begin
  result := TCkRest_Disconnect(_map(76, 'CkRest_Disconnect'))
    (objHandle, maxWaitMs);
end;

function CkRest_DisconnectAsync (objHandle: HCkRest; maxWaitMs: Integer): HCkTask;
begin
  result := TCkRest_DisconnectAsync(_map(77, 'CkRest_DisconnectAsync'))
    (objHandle, maxWaitMs);
end;

function CkRest_FullRequestBd (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData; responseBody: HCkStringBuilder): wordbool;
begin
  result := TCkRest_FullRequestBd(_map(78, 'CkRest_FullRequestBd'))
    (objHandle, httpVerb, uriPath, binData, responseBody);
end;

function CkRest_FullRequestBdAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData; responseBody: HCkStringBuilder): HCkTask;
begin
  result := TCkRest_FullRequestBdAsync(_map(79, 'CkRest_FullRequestBdAsync'))
    (objHandle, httpVerb, uriPath, binData, responseBody);
end;

function CkRest_FullRequestBinary (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkRest_FullRequestBinary(_map(80, 'CkRest_FullRequestBinary'))
    (objHandle, httpVerb, uriPath, bodyBytes, outStr);
end;

function CkRest__fullRequestBinary (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData): PWideChar;
begin
  result := TCkRest__fullRequestBinary(_map(81, 'CkRest__fullRequestBinary'))
    (objHandle, httpVerb, uriPath, bodyBytes);
end;

function CkRest_FullRequestBinaryAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyBytes: HCkByteData): HCkTask;
begin
  result := TCkRest_FullRequestBinaryAsync(_map(82, 'CkRest_FullRequestBinaryAsync'))
    (objHandle, httpVerb, uriPath, bodyBytes);
end;

function CkRest_FullRequestFormUrlEncoded (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRest_FullRequestFormUrlEncoded(_map(83, 'CkRest_FullRequestFormUrlEncoded'))
    (objHandle, httpVerb, uriPath, outStr);
end;

function CkRest__fullRequestFormUrlEncoded (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar;
begin
  result := TCkRest__fullRequestFormUrlEncoded(_map(84, 'CkRest__fullRequestFormUrlEncoded'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_FullRequestFormUrlEncodedAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
begin
  result := TCkRest_FullRequestFormUrlEncodedAsync(_map(85, 'CkRest_FullRequestFormUrlEncodedAsync'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_FullRequestMultipart (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRest_FullRequestMultipart(_map(86, 'CkRest_FullRequestMultipart'))
    (objHandle, httpVerb, uriPath, outStr);
end;

function CkRest__fullRequestMultipart (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar;
begin
  result := TCkRest__fullRequestMultipart(_map(87, 'CkRest__fullRequestMultipart'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_FullRequestMultipartAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
begin
  result := TCkRest_FullRequestMultipartAsync(_map(88, 'CkRest_FullRequestMultipartAsync'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_FullRequestNoBody (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRest_FullRequestNoBody(_map(89, 'CkRest_FullRequestNoBody'))
    (objHandle, httpVerb, uriPath, outStr);
end;

function CkRest__fullRequestNoBody (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): PWideChar;
begin
  result := TCkRest__fullRequestNoBody(_map(90, 'CkRest__fullRequestNoBody'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_FullRequestNoBodyAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
begin
  result := TCkRest_FullRequestNoBodyAsync(_map(91, 'CkRest_FullRequestNoBodyAsync'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_FullRequestNoBodyBd (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData): wordbool;
begin
  result := TCkRest_FullRequestNoBodyBd(_map(92, 'CkRest_FullRequestNoBodyBd'))
    (objHandle, httpVerb, uriPath, binData);
end;

function CkRest_FullRequestNoBodyBdAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; binData: HCkBinData): HCkTask;
begin
  result := TCkRest_FullRequestNoBodyBdAsync(_map(93, 'CkRest_FullRequestNoBodyBdAsync'))
    (objHandle, httpVerb, uriPath, binData);
end;

function CkRest_FullRequestNoBodySb (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkRest_FullRequestNoBodySb(_map(94, 'CkRest_FullRequestNoBodySb'))
    (objHandle, httpVerb, uriPath, sb);
end;

function CkRest_FullRequestNoBodySbAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkRest_FullRequestNoBodySbAsync(_map(95, 'CkRest_FullRequestNoBodySbAsync'))
    (objHandle, httpVerb, uriPath, sb);
end;

function CkRest_FullRequestSb (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; requestBody: HCkStringBuilder; responseBody: HCkStringBuilder): wordbool;
begin
  result := TCkRest_FullRequestSb(_map(96, 'CkRest_FullRequestSb'))
    (objHandle, httpVerb, uriPath, requestBody, responseBody);
end;

function CkRest_FullRequestSbAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; requestBody: HCkStringBuilder; responseBody: HCkStringBuilder): HCkTask;
begin
  result := TCkRest_FullRequestSbAsync(_map(97, 'CkRest_FullRequestSbAsync'))
    (objHandle, httpVerb, uriPath, requestBody, responseBody);
end;

function CkRest_FullRequestStream (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream; outStr: HCkString): wordbool;
begin
  result := TCkRest_FullRequestStream(_map(98, 'CkRest_FullRequestStream'))
    (objHandle, httpVerb, uriPath, stream, outStr);
end;

function CkRest__fullRequestStream (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): PWideChar;
begin
  result := TCkRest__fullRequestStream(_map(99, 'CkRest__fullRequestStream'))
    (objHandle, httpVerb, uriPath, stream);
end;

function CkRest_FullRequestStreamAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): HCkTask;
begin
  result := TCkRest_FullRequestStreamAsync(_map(100, 'CkRest_FullRequestStreamAsync'))
    (objHandle, httpVerb, uriPath, stream);
end;

function CkRest_FullRequestString (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRest_FullRequestString(_map(101, 'CkRest_FullRequestString'))
    (objHandle, httpVerb, uriPath, bodyText, outStr);
end;

function CkRest__fullRequestString (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): PWideChar;
begin
  result := TCkRest__fullRequestString(_map(102, 'CkRest__fullRequestString'))
    (objHandle, httpVerb, uriPath, bodyText);
end;

function CkRest_FullRequestStringAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): HCkTask;
begin
  result := TCkRest_FullRequestStringAsync(_map(103, 'CkRest_FullRequestStringAsync'))
    (objHandle, httpVerb, uriPath, bodyText);
end;

function CkRest_GetLastDebugRequest (objHandle: HCkRest; bd: HCkBinData): wordbool;
begin
  result := TCkRest_GetLastDebugRequest(_map(104, 'CkRest_GetLastDebugRequest'))
    (objHandle, bd);
end;

procedure CkRest_GetLastJsonData (objHandle: HCkRest; json: HCkJsonObject);
begin
  TCkRest_GetLastJsonData(_map(105, 'CkRest_GetLastJsonData'))
    (objHandle, json);
end;

function CkRest_LastJsonData (objHandle: HCkRest): HCkJsonObject;
begin
  result := TCkRest_LastJsonData(_map(106, 'CkRest_LastJsonData'))
    (objHandle);
end;

function CkRest_LoadTaskCaller (objHandle: HCkRest; task: HCkTask): wordbool;
begin
  result := TCkRest_LoadTaskCaller(_map(107, 'CkRest_LoadTaskCaller'))
    (objHandle, task);
end;

function CkRest_ReadRespBd (objHandle: HCkRest; responseBody: HCkBinData): wordbool;
begin
  result := TCkRest_ReadRespBd(_map(108, 'CkRest_ReadRespBd'))
    (objHandle, responseBody);
end;

function CkRest_ReadRespBdAsync (objHandle: HCkRest; responseBody: HCkBinData): HCkTask;
begin
  result := TCkRest_ReadRespBdAsync(_map(109, 'CkRest_ReadRespBdAsync'))
    (objHandle, responseBody);
end;

function CkRest_ReadRespBodyBinary (objHandle: HCkRest; outData: HCkByteData): wordbool;
begin
  result := TCkRest_ReadRespBodyBinary(_map(110, 'CkRest_ReadRespBodyBinary'))
    (objHandle, outData);
end;

function CkRest_ReadRespBodyBinaryAsync (objHandle: HCkRest): HCkTask;
begin
  result := TCkRest_ReadRespBodyBinaryAsync(_map(111, 'CkRest_ReadRespBodyBinaryAsync'))
    (objHandle);
end;

function CkRest_ReadRespBodyStream (objHandle: HCkRest; stream: HCkStream; autoSetStreamCharset: wordbool): wordbool;
begin
  result := TCkRest_ReadRespBodyStream(_map(112, 'CkRest_ReadRespBodyStream'))
    (objHandle, stream, autoSetStreamCharset);
end;

function CkRest_ReadRespBodyStreamAsync (objHandle: HCkRest; stream: HCkStream; autoSetStreamCharset: wordbool): HCkTask;
begin
  result := TCkRest_ReadRespBodyStreamAsync(_map(113, 'CkRest_ReadRespBodyStreamAsync'))
    (objHandle, stream, autoSetStreamCharset);
end;

function CkRest_ReadRespBodyString (objHandle: HCkRest; outStr: HCkString): wordbool;
begin
  result := TCkRest_ReadRespBodyString(_map(114, 'CkRest_ReadRespBodyString'))
    (objHandle, outStr);
end;

function CkRest__readRespBodyString (objHandle: HCkRest): PWideChar;
begin
  result := TCkRest__readRespBodyString(_map(115, 'CkRest__readRespBodyString'))
    (objHandle);
end;

function CkRest_ReadRespBodyStringAsync (objHandle: HCkRest): HCkTask;
begin
  result := TCkRest_ReadRespBodyStringAsync(_map(116, 'CkRest_ReadRespBodyStringAsync'))
    (objHandle);
end;

function CkRest_ReadRespChunkBd (objHandle: HCkRest; minSize: Integer; bd: HCkBinData): Integer;
begin
  result := TCkRest_ReadRespChunkBd(_map(117, 'CkRest_ReadRespChunkBd'))
    (objHandle, minSize, bd);
end;

function CkRest_ReadRespChunkBdAsync (objHandle: HCkRest; minSize: Integer; bd: HCkBinData): HCkTask;
begin
  result := TCkRest_ReadRespChunkBdAsync(_map(118, 'CkRest_ReadRespChunkBdAsync'))
    (objHandle, minSize, bd);
end;

function CkRest_ReadResponseHeader (objHandle: HCkRest): Integer;
begin
  result := TCkRest_ReadResponseHeader(_map(119, 'CkRest_ReadResponseHeader'))
    (objHandle);
end;

function CkRest_ReadResponseHeaderAsync (objHandle: HCkRest): HCkTask;
begin
  result := TCkRest_ReadResponseHeaderAsync(_map(120, 'CkRest_ReadResponseHeaderAsync'))
    (objHandle);
end;

function CkRest_ReadRespSb (objHandle: HCkRest; responseBody: HCkStringBuilder): wordbool;
begin
  result := TCkRest_ReadRespSb(_map(121, 'CkRest_ReadRespSb'))
    (objHandle, responseBody);
end;

function CkRest_ReadRespSbAsync (objHandle: HCkRest; responseBody: HCkStringBuilder): HCkTask;
begin
  result := TCkRest_ReadRespSbAsync(_map(122, 'CkRest_ReadRespSbAsync'))
    (objHandle, responseBody);
end;

function CkRest_RedirectUrl (objHandle: HCkRest): HCkUrl;
begin
  result := TCkRest_RedirectUrl(_map(123, 'CkRest_RedirectUrl'))
    (objHandle);
end;

function CkRest_RemoveHeader (objHandle: HCkRest; name: PWideChar): wordbool;
begin
  result := TCkRest_RemoveHeader(_map(124, 'CkRest_RemoveHeader'))
    (objHandle, name);
end;

function CkRest_RemoveQueryParam (objHandle: HCkRest; name: PWideChar): wordbool;
begin
  result := TCkRest_RemoveQueryParam(_map(125, 'CkRest_RemoveQueryParam'))
    (objHandle, name);
end;

function CkRest_ResponseHdrByName (objHandle: HCkRest; name: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRest_ResponseHdrByName(_map(126, 'CkRest_ResponseHdrByName'))
    (objHandle, name, outStr);
end;

function CkRest__responseHdrByName (objHandle: HCkRest; name: PWideChar): PWideChar;
begin
  result := TCkRest__responseHdrByName(_map(127, 'CkRest__responseHdrByName'))
    (objHandle, name);
end;

function CkRest_ResponseHdrName (objHandle: HCkRest; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkRest_ResponseHdrName(_map(128, 'CkRest_ResponseHdrName'))
    (objHandle, index, outStr);
end;

function CkRest__responseHdrName (objHandle: HCkRest; index: Integer): PWideChar;
begin
  result := TCkRest__responseHdrName(_map(129, 'CkRest__responseHdrName'))
    (objHandle, index);
end;

function CkRest_ResponseHdrValue (objHandle: HCkRest; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkRest_ResponseHdrValue(_map(130, 'CkRest_ResponseHdrValue'))
    (objHandle, index, outStr);
end;

function CkRest__responseHdrValue (objHandle: HCkRest; index: Integer): PWideChar;
begin
  result := TCkRest__responseHdrValue(_map(131, 'CkRest__responseHdrValue'))
    (objHandle, index);
end;

function CkRest_SendReqBd (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkBinData): wordbool;
begin
  result := TCkRest_SendReqBd(_map(132, 'CkRest_SendReqBd'))
    (objHandle, httpVerb, uriPath, body);
end;

function CkRest_SendReqBdAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkBinData): HCkTask;
begin
  result := TCkRest_SendReqBdAsync(_map(133, 'CkRest_SendReqBdAsync'))
    (objHandle, httpVerb, uriPath, body);
end;

function CkRest_SendReqBinaryBody (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkByteData): wordbool;
begin
  result := TCkRest_SendReqBinaryBody(_map(134, 'CkRest_SendReqBinaryBody'))
    (objHandle, httpVerb, uriPath, body);
end;

function CkRest_SendReqBinaryBodyAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; body: HCkByteData): HCkTask;
begin
  result := TCkRest_SendReqBinaryBodyAsync(_map(135, 'CkRest_SendReqBinaryBodyAsync'))
    (objHandle, httpVerb, uriPath, body);
end;

function CkRest_SendReqFormUrlEncoded (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool;
begin
  result := TCkRest_SendReqFormUrlEncoded(_map(136, 'CkRest_SendReqFormUrlEncoded'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_SendReqFormUrlEncodedAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
begin
  result := TCkRest_SendReqFormUrlEncodedAsync(_map(137, 'CkRest_SendReqFormUrlEncodedAsync'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_SendReqMultipart (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool;
begin
  result := TCkRest_SendReqMultipart(_map(138, 'CkRest_SendReqMultipart'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_SendReqMultipartAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
begin
  result := TCkRest_SendReqMultipartAsync(_map(139, 'CkRest_SendReqMultipartAsync'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_SendReqNoBody (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): wordbool;
begin
  result := TCkRest_SendReqNoBody(_map(140, 'CkRest_SendReqNoBody'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_SendReqNoBodyAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar): HCkTask;
begin
  result := TCkRest_SendReqNoBodyAsync(_map(141, 'CkRest_SendReqNoBodyAsync'))
    (objHandle, httpVerb, uriPath);
end;

function CkRest_SendReqSb (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodySb: HCkStringBuilder): wordbool;
begin
  result := TCkRest_SendReqSb(_map(142, 'CkRest_SendReqSb'))
    (objHandle, httpVerb, uriPath, bodySb);
end;

function CkRest_SendReqSbAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodySb: HCkStringBuilder): HCkTask;
begin
  result := TCkRest_SendReqSbAsync(_map(143, 'CkRest_SendReqSbAsync'))
    (objHandle, httpVerb, uriPath, bodySb);
end;

function CkRest_SendReqStreamBody (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): wordbool;
begin
  result := TCkRest_SendReqStreamBody(_map(144, 'CkRest_SendReqStreamBody'))
    (objHandle, httpVerb, uriPath, stream);
end;

function CkRest_SendReqStreamBodyAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; stream: HCkStream): HCkTask;
begin
  result := TCkRest_SendReqStreamBodyAsync(_map(145, 'CkRest_SendReqStreamBodyAsync'))
    (objHandle, httpVerb, uriPath, stream);
end;

function CkRest_SendReqStringBody (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): wordbool;
begin
  result := TCkRest_SendReqStringBody(_map(146, 'CkRest_SendReqStringBody'))
    (objHandle, httpVerb, uriPath, bodyText);
end;

function CkRest_SendReqStringBodyAsync (objHandle: HCkRest; httpVerb: PWideChar; uriPath: PWideChar; bodyText: PWideChar): HCkTask;
begin
  result := TCkRest_SendReqStringBodyAsync(_map(147, 'CkRest_SendReqStringBodyAsync'))
    (objHandle, httpVerb, uriPath, bodyText);
end;

function CkRest_SetAuthAws (objHandle: HCkRest; authProvider: HCkAuthAws): wordbool;
begin
  result := TCkRest_SetAuthAws(_map(148, 'CkRest_SetAuthAws'))
    (objHandle, authProvider);
end;

function CkRest_SetAuthAzureSas (objHandle: HCkRest; authProvider: HCkAuthAzureSAS): wordbool;
begin
  result := TCkRest_SetAuthAzureSas(_map(149, 'CkRest_SetAuthAzureSas'))
    (objHandle, authProvider);
end;

function CkRest_SetAuthAzureStorage (objHandle: HCkRest; authProvider: HCkAuthAzureStorage): wordbool;
begin
  result := TCkRest_SetAuthAzureStorage(_map(150, 'CkRest_SetAuthAzureStorage'))
    (objHandle, authProvider);
end;

function CkRest_SetAuthBasic (objHandle: HCkRest; username: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkRest_SetAuthBasic(_map(151, 'CkRest_SetAuthBasic'))
    (objHandle, username, password);
end;

function CkRest_SetAuthBasicSecure (objHandle: HCkRest; username: HCkSecureString; password: HCkSecureString): wordbool;
begin
  result := TCkRest_SetAuthBasicSecure(_map(152, 'CkRest_SetAuthBasicSecure'))
    (objHandle, username, password);
end;

function CkRest_SetAuthGoogle (objHandle: HCkRest; authProvider: HCkAuthGoogle): wordbool;
begin
  result := TCkRest_SetAuthGoogle(_map(153, 'CkRest_SetAuthGoogle'))
    (objHandle, authProvider);
end;

function CkRest_SetAuthOAuth1 (objHandle: HCkRest; authProvider: HCkOAuth1; useQueryParams: wordbool): wordbool;
begin
  result := TCkRest_SetAuthOAuth1(_map(154, 'CkRest_SetAuthOAuth1'))
    (objHandle, authProvider, useQueryParams);
end;

function CkRest_SetAuthOAuth2 (objHandle: HCkRest; authProvider: HCkOAuth2): wordbool;
begin
  result := TCkRest_SetAuthOAuth2(_map(155, 'CkRest_SetAuthOAuth2'))
    (objHandle, authProvider);
end;

function CkRest_SetMultipartBodyBd (objHandle: HCkRest; bodyData: HCkBinData): wordbool;
begin
  result := TCkRest_SetMultipartBodyBd(_map(156, 'CkRest_SetMultipartBodyBd'))
    (objHandle, bodyData);
end;

function CkRest_SetMultipartBodyBinary (objHandle: HCkRest; bodyData: HCkByteData): wordbool;
begin
  result := TCkRest_SetMultipartBodyBinary(_map(157, 'CkRest_SetMultipartBodyBinary'))
    (objHandle, bodyData);
end;

function CkRest_SetMultipartBodySb (objHandle: HCkRest; bodySb: HCkStringBuilder): wordbool;
begin
  result := TCkRest_SetMultipartBodySb(_map(158, 'CkRest_SetMultipartBodySb'))
    (objHandle, bodySb);
end;

function CkRest_SetMultipartBodyStream (objHandle: HCkRest; stream: HCkStream): wordbool;
begin
  result := TCkRest_SetMultipartBodyStream(_map(159, 'CkRest_SetMultipartBodyStream'))
    (objHandle, stream);
end;

function CkRest_SetMultipartBodyString (objHandle: HCkRest; bodyText: PWideChar): wordbool;
begin
  result := TCkRest_SetMultipartBodyString(_map(160, 'CkRest_SetMultipartBodyString'))
    (objHandle, bodyText);
end;

function CkRest_SetResponseBodyStream (objHandle: HCkRest; expectedStatus: Integer; autoSetStreamCharset: wordbool; responseStream: HCkStream): wordbool;
begin
  result := TCkRest_SetResponseBodyStream(_map(161, 'CkRest_SetResponseBodyStream'))
    (objHandle, expectedStatus, autoSetStreamCharset, responseStream);
end;

function CkRest_UseConnection (objHandle: HCkRest; connection: HCkSocket; autoReconnect: wordbool): wordbool;
begin
  result := TCkRest_UseConnection(_map(162, 'CkRest_UseConnection'))
    (objHandle, connection, autoReconnect);
end;

end.
