unit Rsa;

interface

type

HCkPublicKey = Pointer;
HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkRsa = Pointer;
HCkCert = Pointer;


function CkRsa_Create: HCkRsa;  stdcall;
procedure CkRsa_Dispose(handle: HCkRsa); stdcall;
procedure CkRsa_getCharset(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putCharset(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__charset(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getDebugLogFilePath(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putDebugLogFilePath(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__debugLogFilePath(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getEncodingMode(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putEncodingMode(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__encodingMode(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getLastErrorHtml(objHandle: HCkRsa; outPropVal: HCkString);
function CkRsa__lastErrorHtml(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getLastErrorText(objHandle: HCkRsa; outPropVal: HCkString);
function CkRsa__lastErrorText(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getLastErrorXml(objHandle: HCkRsa; outPropVal: HCkString);
function CkRsa__lastErrorXml(objHandle: HCkRsa): PWideChar;
function CkRsa_getLastMethodSuccess(objHandle: HCkRsa): wordbool;
procedure CkRsa_putLastMethodSuccess(objHandle: HCkRsa; newPropVal: wordbool);
function CkRsa_getLittleEndian(objHandle: HCkRsa): wordbool;
procedure CkRsa_putLittleEndian(objHandle: HCkRsa; newPropVal: wordbool);
function CkRsa_getNoUnpad(objHandle: HCkRsa): wordbool;
procedure CkRsa_putNoUnpad(objHandle: HCkRsa; newPropVal: wordbool);
function CkRsa_getNumBits(objHandle: HCkRsa): Integer;
procedure CkRsa_getOaepHash(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putOaepHash(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__oaepHash(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getOaepLabel(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putOaepLabel(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__oaepLabel(objHandle: HCkRsa): PWideChar;
procedure CkRsa_getOaepMgfHash(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putOaepMgfHash(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__oaepMgfHash(objHandle: HCkRsa): PWideChar;
function CkRsa_getOaepPadding(objHandle: HCkRsa): wordbool;
procedure CkRsa_putOaepPadding(objHandle: HCkRsa; newPropVal: wordbool);
function CkRsa_getPkcsPadding(objHandle: HCkRsa): wordbool;
procedure CkRsa_putPkcsPadding(objHandle: HCkRsa; newPropVal: wordbool);
function CkRsa_getPssSaltLen(objHandle: HCkRsa): Integer;
procedure CkRsa_putPssSaltLen(objHandle: HCkRsa; newPropVal: Integer);
procedure CkRsa_getUncommonOptions(objHandle: HCkRsa; outPropVal: HCkString);
procedure CkRsa_putUncommonOptions(objHandle: HCkRsa; newPropVal: PWideChar);
function CkRsa__uncommonOptions(objHandle: HCkRsa): PWideChar;
function CkRsa_getVerboseLogging(objHandle: HCkRsa): wordbool;
procedure CkRsa_putVerboseLogging(objHandle: HCkRsa; newPropVal: wordbool);
procedure CkRsa_getVersion(objHandle: HCkRsa; outPropVal: HCkString);
function CkRsa__version(objHandle: HCkRsa): PWideChar;
function CkRsa_DecryptBd(objHandle: HCkRsa; bd: HCkBinData; usePrivateKey: wordbool): wordbool;
function CkRsa_DecryptBytes(objHandle: HCkRsa; inData: HCkByteData; usePrivateKey: wordbool; outData: HCkByteData): wordbool;
function CkRsa_DecryptBytesENC(objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool; outData: HCkByteData): wordbool;
function CkRsa_DecryptString(objHandle: HCkRsa; encBytes: HCkByteData; usePrivateKey: wordbool; outStr: HCkString): wordbool;
function CkRsa__decryptString(objHandle: HCkRsa; encBytes: HCkByteData; usePrivateKey: wordbool): PWideChar;
function CkRsa_DecryptStringENC(objHandle: HCkRsa; str: PWideChar; usePrivateKey: wordbool; outStr: HCkString): wordbool;
function CkRsa__decryptStringENC(objHandle: HCkRsa; str: PWideChar; usePrivateKey: wordbool): PWideChar;
function CkRsa_EncryptBd(objHandle: HCkRsa; bd: HCkBinData; usePrivateKey: wordbool): wordbool;
function CkRsa_EncryptBytes(objHandle: HCkRsa; binaryData: HCkByteData; usePrivateKey: wordbool; outData: HCkByteData): wordbool;
function CkRsa_EncryptBytesENC(objHandle: HCkRsa; data: HCkByteData; bUsePrivateKey: wordbool; outStr: HCkString): wordbool;
function CkRsa__encryptBytesENC(objHandle: HCkRsa; data: HCkByteData; bUsePrivateKey: wordbool): PWideChar;
function CkRsa_EncryptString(objHandle: HCkRsa; stringToEncrypt: PWideChar; usePrivateKey: wordbool; outData: HCkByteData): wordbool;
function CkRsa_EncryptStringENC(objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool; outStr: HCkString): wordbool;
function CkRsa__encryptStringENC(objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool): PWideChar;
function CkRsa_ExportPrivateKey(objHandle: HCkRsa; outStr: HCkString): wordbool;
function CkRsa__exportPrivateKey(objHandle: HCkRsa): PWideChar;
function CkRsa_ExportPrivateKeyObj(objHandle: HCkRsa): HCkPrivateKey;
function CkRsa_ExportPublicKey(objHandle: HCkRsa; outStr: HCkString): wordbool;
function CkRsa__exportPublicKey(objHandle: HCkRsa): PWideChar;
function CkRsa_ExportPublicKeyObj(objHandle: HCkRsa): HCkPublicKey;
function CkRsa_GenerateKey(objHandle: HCkRsa; numBits: Integer): wordbool;
function CkRsa_GenKey(objHandle: HCkRsa; numBits: Integer; privKey: HCkPrivateKey): wordbool;
function CkRsa_ImportPrivateKey(objHandle: HCkRsa; xmlKey: PWideChar): wordbool;
function CkRsa_ImportPrivateKeyObj(objHandle: HCkRsa; key: HCkPrivateKey): wordbool;
function CkRsa_ImportPublicKey(objHandle: HCkRsa; xmlKey: PWideChar): wordbool;
function CkRsa_ImportPublicKeyObj(objHandle: HCkRsa; key: HCkPublicKey): wordbool;
function CkRsa_OpenSslSignBd(objHandle: HCkRsa; bd: HCkBinData): wordbool;
function CkRsa_OpenSslSignBytes(objHandle: HCkRsa; data: HCkByteData; outData: HCkByteData): wordbool;
function CkRsa_OpenSslSignBytesENC(objHandle: HCkRsa; data: HCkByteData; outStr: HCkString): wordbool;
function CkRsa__openSslSignBytesENC(objHandle: HCkRsa; data: HCkByteData): PWideChar;
function CkRsa_OpenSslSignString(objHandle: HCkRsa; str: PWideChar; outData: HCkByteData): wordbool;
function CkRsa_OpenSslSignStringENC(objHandle: HCkRsa; str: PWideChar; outStr: HCkString): wordbool;
function CkRsa__openSslSignStringENC(objHandle: HCkRsa; str: PWideChar): PWideChar;
function CkRsa_OpenSslVerifyBd(objHandle: HCkRsa; bd: HCkBinData): wordbool;
function CkRsa_OpenSslVerifyBytes(objHandle: HCkRsa; signature: HCkByteData; outData: HCkByteData): wordbool;
function CkRsa_OpenSslVerifyBytesENC(objHandle: HCkRsa; str: PWideChar; outData: HCkByteData): wordbool;
function CkRsa_OpenSslVerifyString(objHandle: HCkRsa; data: HCkByteData; outStr: HCkString): wordbool;
function CkRsa__openSslVerifyString(objHandle: HCkRsa; data: HCkByteData): PWideChar;
function CkRsa_OpenSslVerifyStringENC(objHandle: HCkRsa; str: PWideChar; outStr: HCkString): wordbool;
function CkRsa__openSslVerifyStringENC(objHandle: HCkRsa; str: PWideChar): PWideChar;
function CkRsa_SetX509Cert(objHandle: HCkRsa; cert: HCkCert; usePrivateKey: wordbool): wordbool;
function CkRsa_SignBd(objHandle: HCkRsa; bdData: HCkBinData; hashAlgorithm: PWideChar; bdSig: HCkBinData): wordbool;
function CkRsa_SignBytes(objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar; outData: HCkByteData): wordbool;
function CkRsa_SignBytesENC(objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar; outStr: HCkString): wordbool;
function CkRsa__signBytesENC(objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar): PWideChar;
function CkRsa_SignHash(objHandle: HCkRsa; hashBytes: HCkByteData; hashAlg: PWideChar; outData: HCkByteData): wordbool;
function CkRsa_SignHashENC(objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar; outStr: HCkString): wordbool;
function CkRsa__signHashENC(objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar): PWideChar;
function CkRsa_SignRawBd(objHandle: HCkRsa; bd: HCkBinData): wordbool;
function CkRsa_SignString(objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar; outData: HCkByteData): wordbool;
function CkRsa_SignStringENC(objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar; outStr: HCkString): wordbool;
function CkRsa__signStringENC(objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar): PWideChar;
function CkRsa_SnkToXml(objHandle: HCkRsa; filename: PWideChar; outStr: HCkString): wordbool;
function CkRsa__snkToXml(objHandle: HCkRsa; filename: PWideChar): PWideChar;
function CkRsa_UsePrivateKey(objHandle: HCkRsa; privKey: HCkPrivateKey): wordbool;
function CkRsa_UsePublicKey(objHandle: HCkRsa; pubKey: HCkPublicKey): wordbool;
function CkRsa_VerifyBd(objHandle: HCkRsa; bdData: HCkBinData; hashAlgorithm: PWideChar; bdSig: HCkBinData): wordbool;
function CkRsa_VerifyBytes(objHandle: HCkRsa; originalData: HCkByteData; hashAlgorithm: PWideChar; signatureBytes: HCkByteData): wordbool;
function CkRsa_VerifyBytesENC(objHandle: HCkRsa; originalData: HCkByteData; hashAlgorithm: PWideChar; encodedSig: PWideChar): wordbool;
function CkRsa_VerifyHash(objHandle: HCkRsa; hashBytes: HCkByteData; hashAlg: PWideChar; sigBytes: HCkByteData): wordbool;
function CkRsa_VerifyHashENC(objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar; encodedSig: PWideChar): wordbool;
function CkRsa_VerifyRawBd(objHandle: HCkRsa; bd: HCkBinData): wordbool;
function CkRsa_VerifyString(objHandle: HCkRsa; originalString: PWideChar; hashAlgorithm: PWideChar; binarySig: HCkByteData): wordbool;
function CkRsa_VerifyStringENC(objHandle: HCkRsa; originalString: PWideChar; hashAlgorithm: PWideChar; encodedSig: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkRsa_Create = function : HCkRsa; stdcall;
  TCkRsa_Dispose = procedure (handle: HCkRsa); stdcall;
  TCkRsa_getCharset = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putCharset = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__charset = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getDebugLogFilePath = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putDebugLogFilePath = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__debugLogFilePath = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getEncodingMode = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putEncodingMode = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__encodingMode = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getLastErrorHtml = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa__lastErrorHtml = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getLastErrorText = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa__lastErrorText = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getLastErrorXml = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa__lastErrorXml = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getLastMethodSuccess = function (objHandle: HCkRsa): wordbool; stdcall;
  TCkRsa_putLastMethodSuccess = procedure (objHandle: HCkRsa; newPropVal: wordbool); stdcall;
  TCkRsa_getLittleEndian = function (objHandle: HCkRsa): wordbool; stdcall;
  TCkRsa_putLittleEndian = procedure (objHandle: HCkRsa; newPropVal: wordbool); stdcall;
  TCkRsa_getNoUnpad = function (objHandle: HCkRsa): wordbool; stdcall;
  TCkRsa_putNoUnpad = procedure (objHandle: HCkRsa; newPropVal: wordbool); stdcall;
  TCkRsa_getNumBits = function (objHandle: HCkRsa): Integer; stdcall;
  TCkRsa_getOaepHash = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putOaepHash = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__oaepHash = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getOaepLabel = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putOaepLabel = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__oaepLabel = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getOaepMgfHash = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putOaepMgfHash = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__oaepMgfHash = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getOaepPadding = function (objHandle: HCkRsa): wordbool; stdcall;
  TCkRsa_putOaepPadding = procedure (objHandle: HCkRsa; newPropVal: wordbool); stdcall;
  TCkRsa_getPkcsPadding = function (objHandle: HCkRsa): wordbool; stdcall;
  TCkRsa_putPkcsPadding = procedure (objHandle: HCkRsa; newPropVal: wordbool); stdcall;
  TCkRsa_getPssSaltLen = function (objHandle: HCkRsa): Integer; stdcall;
  TCkRsa_putPssSaltLen = procedure (objHandle: HCkRsa; newPropVal: Integer); stdcall;
  TCkRsa_getUncommonOptions = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa_putUncommonOptions = procedure (objHandle: HCkRsa; newPropVal: PWideChar); stdcall;
  TCkRsa__uncommonOptions = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_getVerboseLogging = function (objHandle: HCkRsa): wordbool; stdcall;
  TCkRsa_putVerboseLogging = procedure (objHandle: HCkRsa; newPropVal: wordbool); stdcall;
  TCkRsa_getVersion = procedure (objHandle: HCkRsa; outPropVal: HCkString); stdcall;
  TCkRsa__version = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_DecryptBd = function (objHandle: HCkRsa; bd: HCkBinData; usePrivateKey: wordbool): wordbool; stdcall;
  TCkRsa_DecryptBytes = function (objHandle: HCkRsa; inData: HCkByteData; usePrivateKey: wordbool; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_DecryptBytesENC = function (objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_DecryptString = function (objHandle: HCkRsa; encBytes: HCkByteData; usePrivateKey: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkRsa__decryptString = function (objHandle: HCkRsa; encBytes: HCkByteData; usePrivateKey: wordbool): PWideChar; stdcall;
  TCkRsa_DecryptStringENC = function (objHandle: HCkRsa; str: PWideChar; usePrivateKey: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkRsa__decryptStringENC = function (objHandle: HCkRsa; str: PWideChar; usePrivateKey: wordbool): PWideChar; stdcall;
  TCkRsa_EncryptBd = function (objHandle: HCkRsa; bd: HCkBinData; usePrivateKey: wordbool): wordbool; stdcall;
  TCkRsa_EncryptBytes = function (objHandle: HCkRsa; binaryData: HCkByteData; usePrivateKey: wordbool; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_EncryptBytesENC = function (objHandle: HCkRsa; data: HCkByteData; bUsePrivateKey: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkRsa__encryptBytesENC = function (objHandle: HCkRsa; data: HCkByteData; bUsePrivateKey: wordbool): PWideChar; stdcall;
  TCkRsa_EncryptString = function (objHandle: HCkRsa; stringToEncrypt: PWideChar; usePrivateKey: wordbool; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_EncryptStringENC = function (objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkRsa__encryptStringENC = function (objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool): PWideChar; stdcall;
  TCkRsa_ExportPrivateKey = function (objHandle: HCkRsa; outStr: HCkString): wordbool; stdcall;
  TCkRsa__exportPrivateKey = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_ExportPrivateKeyObj = function (objHandle: HCkRsa): HCkPrivateKey; stdcall;
  TCkRsa_ExportPublicKey = function (objHandle: HCkRsa; outStr: HCkString): wordbool; stdcall;
  TCkRsa__exportPublicKey = function (objHandle: HCkRsa): PWideChar; stdcall;
  TCkRsa_ExportPublicKeyObj = function (objHandle: HCkRsa): HCkPublicKey; stdcall;
  TCkRsa_GenerateKey = function (objHandle: HCkRsa; numBits: Integer): wordbool; stdcall;
  TCkRsa_GenKey = function (objHandle: HCkRsa; numBits: Integer; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkRsa_ImportPrivateKey = function (objHandle: HCkRsa; xmlKey: PWideChar): wordbool; stdcall;
  TCkRsa_ImportPrivateKeyObj = function (objHandle: HCkRsa; key: HCkPrivateKey): wordbool; stdcall;
  TCkRsa_ImportPublicKey = function (objHandle: HCkRsa; xmlKey: PWideChar): wordbool; stdcall;
  TCkRsa_ImportPublicKeyObj = function (objHandle: HCkRsa; key: HCkPublicKey): wordbool; stdcall;
  TCkRsa_OpenSslSignBd = function (objHandle: HCkRsa; bd: HCkBinData): wordbool; stdcall;
  TCkRsa_OpenSslSignBytes = function (objHandle: HCkRsa; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_OpenSslSignBytesENC = function (objHandle: HCkRsa; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkRsa__openSslSignBytesENC = function (objHandle: HCkRsa; data: HCkByteData): PWideChar; stdcall;
  TCkRsa_OpenSslSignString = function (objHandle: HCkRsa; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_OpenSslSignStringENC = function (objHandle: HCkRsa; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRsa__openSslSignStringENC = function (objHandle: HCkRsa; str: PWideChar): PWideChar; stdcall;
  TCkRsa_OpenSslVerifyBd = function (objHandle: HCkRsa; bd: HCkBinData): wordbool; stdcall;
  TCkRsa_OpenSslVerifyBytes = function (objHandle: HCkRsa; signature: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_OpenSslVerifyBytesENC = function (objHandle: HCkRsa; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_OpenSslVerifyString = function (objHandle: HCkRsa; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkRsa__openSslVerifyString = function (objHandle: HCkRsa; data: HCkByteData): PWideChar; stdcall;
  TCkRsa_OpenSslVerifyStringENC = function (objHandle: HCkRsa; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRsa__openSslVerifyStringENC = function (objHandle: HCkRsa; str: PWideChar): PWideChar; stdcall;
  TCkRsa_SetX509Cert = function (objHandle: HCkRsa; cert: HCkCert; usePrivateKey: wordbool): wordbool; stdcall;
  TCkRsa_SignBd = function (objHandle: HCkRsa; bdData: HCkBinData; hashAlgorithm: PWideChar; bdSig: HCkBinData): wordbool; stdcall;
  TCkRsa_SignBytes = function (objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_SignBytesENC = function (objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRsa__signBytesENC = function (objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar): PWideChar; stdcall;
  TCkRsa_SignHash = function (objHandle: HCkRsa; hashBytes: HCkByteData; hashAlg: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_SignHashENC = function (objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRsa__signHashENC = function (objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar): PWideChar; stdcall;
  TCkRsa_SignRawBd = function (objHandle: HCkRsa; bd: HCkBinData): wordbool; stdcall;
  TCkRsa_SignString = function (objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkRsa_SignStringENC = function (objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRsa__signStringENC = function (objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar): PWideChar; stdcall;
  TCkRsa_SnkToXml = function (objHandle: HCkRsa; filename: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkRsa__snkToXml = function (objHandle: HCkRsa; filename: PWideChar): PWideChar; stdcall;
  TCkRsa_UsePrivateKey = function (objHandle: HCkRsa; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkRsa_UsePublicKey = function (objHandle: HCkRsa; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkRsa_VerifyBd = function (objHandle: HCkRsa; bdData: HCkBinData; hashAlgorithm: PWideChar; bdSig: HCkBinData): wordbool; stdcall;
  TCkRsa_VerifyBytes = function (objHandle: HCkRsa; originalData: HCkByteData; hashAlgorithm: PWideChar; signatureBytes: HCkByteData): wordbool; stdcall;
  TCkRsa_VerifyBytesENC = function (objHandle: HCkRsa; originalData: HCkByteData; hashAlgorithm: PWideChar; encodedSig: PWideChar): wordbool; stdcall;
  TCkRsa_VerifyHash = function (objHandle: HCkRsa; hashBytes: HCkByteData; hashAlg: PWideChar; sigBytes: HCkByteData): wordbool; stdcall;
  TCkRsa_VerifyHashENC = function (objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar; encodedSig: PWideChar): wordbool; stdcall;
  TCkRsa_VerifyRawBd = function (objHandle: HCkRsa; bd: HCkBinData): wordbool; stdcall;
  TCkRsa_VerifyString = function (objHandle: HCkRsa; originalString: PWideChar; hashAlgorithm: PWideChar; binarySig: HCkByteData): wordbool; stdcall;
  TCkRsa_VerifyStringENC = function (objHandle: HCkRsa; originalString: PWideChar; hashAlgorithm: PWideChar; encodedSig: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..109] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkRsa_Create : HCkRsa;
begin
  result := TCkRsa_Create(_map(0, 'CkRsa_Create'));
end;

procedure CkRsa_Dispose (handle: HCkRsa);
begin
  TCkRsa_Dispose(_map(1, 'CkRsa_Dispose'))
    (handle);
end;


procedure CkRsa_getCharset (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getCharset(_map(2, 'CkRsa_getCharset'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putCharset (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putCharset(_map(3, 'CkRsa_putCharset'))
    (objHandle, newPropVal);
end;

function CkRsa__charset (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__charset(_map(4, 'CkRsa__charset'))
    (objHandle);
end;

procedure CkRsa_getDebugLogFilePath (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getDebugLogFilePath(_map(5, 'CkRsa_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putDebugLogFilePath (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putDebugLogFilePath(_map(6, 'CkRsa_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkRsa__debugLogFilePath (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__debugLogFilePath(_map(7, 'CkRsa__debugLogFilePath'))
    (objHandle);
end;

procedure CkRsa_getEncodingMode (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getEncodingMode(_map(8, 'CkRsa_getEncodingMode'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putEncodingMode (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putEncodingMode(_map(9, 'CkRsa_putEncodingMode'))
    (objHandle, newPropVal);
end;

function CkRsa__encodingMode (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__encodingMode(_map(10, 'CkRsa__encodingMode'))
    (objHandle);
end;

procedure CkRsa_getLastErrorHtml (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getLastErrorHtml(_map(11, 'CkRsa_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkRsa__lastErrorHtml (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__lastErrorHtml(_map(12, 'CkRsa__lastErrorHtml'))
    (objHandle);
end;

procedure CkRsa_getLastErrorText (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getLastErrorText(_map(13, 'CkRsa_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkRsa__lastErrorText (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__lastErrorText(_map(14, 'CkRsa__lastErrorText'))
    (objHandle);
end;

procedure CkRsa_getLastErrorXml (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getLastErrorXml(_map(15, 'CkRsa_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkRsa__lastErrorXml (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__lastErrorXml(_map(16, 'CkRsa__lastErrorXml'))
    (objHandle);
end;

function CkRsa_getLastMethodSuccess (objHandle: HCkRsa): wordbool;
begin
    result := TCkRsa_getLastMethodSuccess(_map(17, 'CkRsa_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkRsa_putLastMethodSuccess (objHandle: HCkRsa; newPropVal: wordbool);
begin
  TCkRsa_putLastMethodSuccess(_map(18, 'CkRsa_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkRsa_getLittleEndian (objHandle: HCkRsa): wordbool;
begin
    result := TCkRsa_getLittleEndian(_map(19, 'CkRsa_getLittleEndian'))
    (objHandle);
end;

procedure CkRsa_putLittleEndian (objHandle: HCkRsa; newPropVal: wordbool);
begin
  TCkRsa_putLittleEndian(_map(20, 'CkRsa_putLittleEndian'))
    (objHandle, newPropVal);
end;

function CkRsa_getNoUnpad (objHandle: HCkRsa): wordbool;
begin
    result := TCkRsa_getNoUnpad(_map(21, 'CkRsa_getNoUnpad'))
    (objHandle);
end;

procedure CkRsa_putNoUnpad (objHandle: HCkRsa; newPropVal: wordbool);
begin
  TCkRsa_putNoUnpad(_map(22, 'CkRsa_putNoUnpad'))
    (objHandle, newPropVal);
end;

function CkRsa_getNumBits (objHandle: HCkRsa): Integer;
begin
    result := TCkRsa_getNumBits(_map(23, 'CkRsa_getNumBits'))
    (objHandle);
end;

procedure CkRsa_getOaepHash (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getOaepHash(_map(24, 'CkRsa_getOaepHash'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putOaepHash (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putOaepHash(_map(25, 'CkRsa_putOaepHash'))
    (objHandle, newPropVal);
end;

function CkRsa__oaepHash (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__oaepHash(_map(26, 'CkRsa__oaepHash'))
    (objHandle);
end;

procedure CkRsa_getOaepLabel (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getOaepLabel(_map(27, 'CkRsa_getOaepLabel'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putOaepLabel (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putOaepLabel(_map(28, 'CkRsa_putOaepLabel'))
    (objHandle, newPropVal);
end;

function CkRsa__oaepLabel (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__oaepLabel(_map(29, 'CkRsa__oaepLabel'))
    (objHandle);
end;

procedure CkRsa_getOaepMgfHash (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getOaepMgfHash(_map(30, 'CkRsa_getOaepMgfHash'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putOaepMgfHash (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putOaepMgfHash(_map(31, 'CkRsa_putOaepMgfHash'))
    (objHandle, newPropVal);
end;

function CkRsa__oaepMgfHash (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__oaepMgfHash(_map(32, 'CkRsa__oaepMgfHash'))
    (objHandle);
end;

function CkRsa_getOaepPadding (objHandle: HCkRsa): wordbool;
begin
    result := TCkRsa_getOaepPadding(_map(33, 'CkRsa_getOaepPadding'))
    (objHandle);
end;

procedure CkRsa_putOaepPadding (objHandle: HCkRsa; newPropVal: wordbool);
begin
  TCkRsa_putOaepPadding(_map(34, 'CkRsa_putOaepPadding'))
    (objHandle, newPropVal);
end;

function CkRsa_getPkcsPadding (objHandle: HCkRsa): wordbool;
begin
    result := TCkRsa_getPkcsPadding(_map(35, 'CkRsa_getPkcsPadding'))
    (objHandle);
end;

procedure CkRsa_putPkcsPadding (objHandle: HCkRsa; newPropVal: wordbool);
begin
  TCkRsa_putPkcsPadding(_map(36, 'CkRsa_putPkcsPadding'))
    (objHandle, newPropVal);
end;

function CkRsa_getPssSaltLen (objHandle: HCkRsa): Integer;
begin
    result := TCkRsa_getPssSaltLen(_map(37, 'CkRsa_getPssSaltLen'))
    (objHandle);
end;

procedure CkRsa_putPssSaltLen (objHandle: HCkRsa; newPropVal: Integer);
begin
  TCkRsa_putPssSaltLen(_map(38, 'CkRsa_putPssSaltLen'))
    (objHandle, newPropVal);
end;

procedure CkRsa_getUncommonOptions (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getUncommonOptions(_map(39, 'CkRsa_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkRsa_putUncommonOptions (objHandle: HCkRsa; newPropVal: PWideChar);
begin
  TCkRsa_putUncommonOptions(_map(40, 'CkRsa_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkRsa__uncommonOptions (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__uncommonOptions(_map(41, 'CkRsa__uncommonOptions'))
    (objHandle);
end;

function CkRsa_getVerboseLogging (objHandle: HCkRsa): wordbool;
begin
    result := TCkRsa_getVerboseLogging(_map(42, 'CkRsa_getVerboseLogging'))
    (objHandle);
end;

procedure CkRsa_putVerboseLogging (objHandle: HCkRsa; newPropVal: wordbool);
begin
  TCkRsa_putVerboseLogging(_map(43, 'CkRsa_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkRsa_getVersion (objHandle: HCkRsa; outPropVal: HCkString);
begin
  TCkRsa_getVersion(_map(44, 'CkRsa_getVersion'))
    (objHandle, outPropVal);
end;

function CkRsa__version (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__version(_map(45, 'CkRsa__version'))
    (objHandle);
end;

function CkRsa_DecryptBd (objHandle: HCkRsa; bd: HCkBinData; usePrivateKey: wordbool): wordbool;
begin
  result := TCkRsa_DecryptBd(_map(46, 'CkRsa_DecryptBd'))
    (objHandle, bd, usePrivateKey);
end;

function CkRsa_DecryptBytes (objHandle: HCkRsa; inData: HCkByteData; usePrivateKey: wordbool; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_DecryptBytes(_map(47, 'CkRsa_DecryptBytes'))
    (objHandle, inData, usePrivateKey, outData);
end;

function CkRsa_DecryptBytesENC (objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_DecryptBytesENC(_map(48, 'CkRsa_DecryptBytesENC'))
    (objHandle, str, bUsePrivateKey, outData);
end;

function CkRsa_DecryptString (objHandle: HCkRsa; encBytes: HCkByteData; usePrivateKey: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkRsa_DecryptString(_map(49, 'CkRsa_DecryptString'))
    (objHandle, encBytes, usePrivateKey, outStr);
end;

function CkRsa__decryptString (objHandle: HCkRsa; encBytes: HCkByteData; usePrivateKey: wordbool): PWideChar;
begin
  result := TCkRsa__decryptString(_map(50, 'CkRsa__decryptString'))
    (objHandle, encBytes, usePrivateKey);
end;

function CkRsa_DecryptStringENC (objHandle: HCkRsa; str: PWideChar; usePrivateKey: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkRsa_DecryptStringENC(_map(51, 'CkRsa_DecryptStringENC'))
    (objHandle, str, usePrivateKey, outStr);
end;

function CkRsa__decryptStringENC (objHandle: HCkRsa; str: PWideChar; usePrivateKey: wordbool): PWideChar;
begin
  result := TCkRsa__decryptStringENC(_map(52, 'CkRsa__decryptStringENC'))
    (objHandle, str, usePrivateKey);
end;

function CkRsa_EncryptBd (objHandle: HCkRsa; bd: HCkBinData; usePrivateKey: wordbool): wordbool;
begin
  result := TCkRsa_EncryptBd(_map(53, 'CkRsa_EncryptBd'))
    (objHandle, bd, usePrivateKey);
end;

function CkRsa_EncryptBytes (objHandle: HCkRsa; binaryData: HCkByteData; usePrivateKey: wordbool; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_EncryptBytes(_map(54, 'CkRsa_EncryptBytes'))
    (objHandle, binaryData, usePrivateKey, outData);
end;

function CkRsa_EncryptBytesENC (objHandle: HCkRsa; data: HCkByteData; bUsePrivateKey: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkRsa_EncryptBytesENC(_map(55, 'CkRsa_EncryptBytesENC'))
    (objHandle, data, bUsePrivateKey, outStr);
end;

function CkRsa__encryptBytesENC (objHandle: HCkRsa; data: HCkByteData; bUsePrivateKey: wordbool): PWideChar;
begin
  result := TCkRsa__encryptBytesENC(_map(56, 'CkRsa__encryptBytesENC'))
    (objHandle, data, bUsePrivateKey);
end;

function CkRsa_EncryptString (objHandle: HCkRsa; stringToEncrypt: PWideChar; usePrivateKey: wordbool; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_EncryptString(_map(57, 'CkRsa_EncryptString'))
    (objHandle, stringToEncrypt, usePrivateKey, outData);
end;

function CkRsa_EncryptStringENC (objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkRsa_EncryptStringENC(_map(58, 'CkRsa_EncryptStringENC'))
    (objHandle, str, bUsePrivateKey, outStr);
end;

function CkRsa__encryptStringENC (objHandle: HCkRsa; str: PWideChar; bUsePrivateKey: wordbool): PWideChar;
begin
  result := TCkRsa__encryptStringENC(_map(59, 'CkRsa__encryptStringENC'))
    (objHandle, str, bUsePrivateKey);
end;

function CkRsa_ExportPrivateKey (objHandle: HCkRsa; outStr: HCkString): wordbool;
begin
  result := TCkRsa_ExportPrivateKey(_map(60, 'CkRsa_ExportPrivateKey'))
    (objHandle, outStr);
end;

function CkRsa__exportPrivateKey (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__exportPrivateKey(_map(61, 'CkRsa__exportPrivateKey'))
    (objHandle);
end;

function CkRsa_ExportPrivateKeyObj (objHandle: HCkRsa): HCkPrivateKey;
begin
  result := TCkRsa_ExportPrivateKeyObj(_map(62, 'CkRsa_ExportPrivateKeyObj'))
    (objHandle);
end;

function CkRsa_ExportPublicKey (objHandle: HCkRsa; outStr: HCkString): wordbool;
begin
  result := TCkRsa_ExportPublicKey(_map(63, 'CkRsa_ExportPublicKey'))
    (objHandle, outStr);
end;

function CkRsa__exportPublicKey (objHandle: HCkRsa): PWideChar;
begin
  result := TCkRsa__exportPublicKey(_map(64, 'CkRsa__exportPublicKey'))
    (objHandle);
end;

function CkRsa_ExportPublicKeyObj (objHandle: HCkRsa): HCkPublicKey;
begin
  result := TCkRsa_ExportPublicKeyObj(_map(65, 'CkRsa_ExportPublicKeyObj'))
    (objHandle);
end;

function CkRsa_GenerateKey (objHandle: HCkRsa; numBits: Integer): wordbool;
begin
  result := TCkRsa_GenerateKey(_map(66, 'CkRsa_GenerateKey'))
    (objHandle, numBits);
end;

function CkRsa_GenKey (objHandle: HCkRsa; numBits: Integer; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkRsa_GenKey(_map(67, 'CkRsa_GenKey'))
    (objHandle, numBits, privKey);
end;

function CkRsa_ImportPrivateKey (objHandle: HCkRsa; xmlKey: PWideChar): wordbool;
begin
  result := TCkRsa_ImportPrivateKey(_map(68, 'CkRsa_ImportPrivateKey'))
    (objHandle, xmlKey);
end;

function CkRsa_ImportPrivateKeyObj (objHandle: HCkRsa; key: HCkPrivateKey): wordbool;
begin
  result := TCkRsa_ImportPrivateKeyObj(_map(69, 'CkRsa_ImportPrivateKeyObj'))
    (objHandle, key);
end;

function CkRsa_ImportPublicKey (objHandle: HCkRsa; xmlKey: PWideChar): wordbool;
begin
  result := TCkRsa_ImportPublicKey(_map(70, 'CkRsa_ImportPublicKey'))
    (objHandle, xmlKey);
end;

function CkRsa_ImportPublicKeyObj (objHandle: HCkRsa; key: HCkPublicKey): wordbool;
begin
  result := TCkRsa_ImportPublicKeyObj(_map(71, 'CkRsa_ImportPublicKeyObj'))
    (objHandle, key);
end;

function CkRsa_OpenSslSignBd (objHandle: HCkRsa; bd: HCkBinData): wordbool;
begin
  result := TCkRsa_OpenSslSignBd(_map(72, 'CkRsa_OpenSslSignBd'))
    (objHandle, bd);
end;

function CkRsa_OpenSslSignBytes (objHandle: HCkRsa; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_OpenSslSignBytes(_map(73, 'CkRsa_OpenSslSignBytes'))
    (objHandle, data, outData);
end;

function CkRsa_OpenSslSignBytesENC (objHandle: HCkRsa; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkRsa_OpenSslSignBytesENC(_map(74, 'CkRsa_OpenSslSignBytesENC'))
    (objHandle, data, outStr);
end;

function CkRsa__openSslSignBytesENC (objHandle: HCkRsa; data: HCkByteData): PWideChar;
begin
  result := TCkRsa__openSslSignBytesENC(_map(75, 'CkRsa__openSslSignBytesENC'))
    (objHandle, data);
end;

function CkRsa_OpenSslSignString (objHandle: HCkRsa; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_OpenSslSignString(_map(76, 'CkRsa_OpenSslSignString'))
    (objHandle, str, outData);
end;

function CkRsa_OpenSslSignStringENC (objHandle: HCkRsa; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRsa_OpenSslSignStringENC(_map(77, 'CkRsa_OpenSslSignStringENC'))
    (objHandle, str, outStr);
end;

function CkRsa__openSslSignStringENC (objHandle: HCkRsa; str: PWideChar): PWideChar;
begin
  result := TCkRsa__openSslSignStringENC(_map(78, 'CkRsa__openSslSignStringENC'))
    (objHandle, str);
end;

function CkRsa_OpenSslVerifyBd (objHandle: HCkRsa; bd: HCkBinData): wordbool;
begin
  result := TCkRsa_OpenSslVerifyBd(_map(79, 'CkRsa_OpenSslVerifyBd'))
    (objHandle, bd);
end;

function CkRsa_OpenSslVerifyBytes (objHandle: HCkRsa; signature: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_OpenSslVerifyBytes(_map(80, 'CkRsa_OpenSslVerifyBytes'))
    (objHandle, signature, outData);
end;

function CkRsa_OpenSslVerifyBytesENC (objHandle: HCkRsa; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_OpenSslVerifyBytesENC(_map(81, 'CkRsa_OpenSslVerifyBytesENC'))
    (objHandle, str, outData);
end;

function CkRsa_OpenSslVerifyString (objHandle: HCkRsa; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkRsa_OpenSslVerifyString(_map(82, 'CkRsa_OpenSslVerifyString'))
    (objHandle, data, outStr);
end;

function CkRsa__openSslVerifyString (objHandle: HCkRsa; data: HCkByteData): PWideChar;
begin
  result := TCkRsa__openSslVerifyString(_map(83, 'CkRsa__openSslVerifyString'))
    (objHandle, data);
end;

function CkRsa_OpenSslVerifyStringENC (objHandle: HCkRsa; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRsa_OpenSslVerifyStringENC(_map(84, 'CkRsa_OpenSslVerifyStringENC'))
    (objHandle, str, outStr);
end;

function CkRsa__openSslVerifyStringENC (objHandle: HCkRsa; str: PWideChar): PWideChar;
begin
  result := TCkRsa__openSslVerifyStringENC(_map(85, 'CkRsa__openSslVerifyStringENC'))
    (objHandle, str);
end;

function CkRsa_SetX509Cert (objHandle: HCkRsa; cert: HCkCert; usePrivateKey: wordbool): wordbool;
begin
  result := TCkRsa_SetX509Cert(_map(86, 'CkRsa_SetX509Cert'))
    (objHandle, cert, usePrivateKey);
end;

function CkRsa_SignBd (objHandle: HCkRsa; bdData: HCkBinData; hashAlgorithm: PWideChar; bdSig: HCkBinData): wordbool;
begin
  result := TCkRsa_SignBd(_map(87, 'CkRsa_SignBd'))
    (objHandle, bdData, hashAlgorithm, bdSig);
end;

function CkRsa_SignBytes (objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_SignBytes(_map(88, 'CkRsa_SignBytes'))
    (objHandle, binaryData, hashAlgorithm, outData);
end;

function CkRsa_SignBytesENC (objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRsa_SignBytesENC(_map(89, 'CkRsa_SignBytesENC'))
    (objHandle, binaryData, hashAlgorithm, outStr);
end;

function CkRsa__signBytesENC (objHandle: HCkRsa; binaryData: HCkByteData; hashAlgorithm: PWideChar): PWideChar;
begin
  result := TCkRsa__signBytesENC(_map(90, 'CkRsa__signBytesENC'))
    (objHandle, binaryData, hashAlgorithm);
end;

function CkRsa_SignHash (objHandle: HCkRsa; hashBytes: HCkByteData; hashAlg: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_SignHash(_map(91, 'CkRsa_SignHash'))
    (objHandle, hashBytes, hashAlg, outData);
end;

function CkRsa_SignHashENC (objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRsa_SignHashENC(_map(92, 'CkRsa_SignHashENC'))
    (objHandle, encodedHash, hashAlg, outStr);
end;

function CkRsa__signHashENC (objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar): PWideChar;
begin
  result := TCkRsa__signHashENC(_map(93, 'CkRsa__signHashENC'))
    (objHandle, encodedHash, hashAlg);
end;

function CkRsa_SignRawBd (objHandle: HCkRsa; bd: HCkBinData): wordbool;
begin
  result := TCkRsa_SignRawBd(_map(94, 'CkRsa_SignRawBd'))
    (objHandle, bd);
end;

function CkRsa_SignString (objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkRsa_SignString(_map(95, 'CkRsa_SignString'))
    (objHandle, strToBeHashed, hashAlgorithm, outData);
end;

function CkRsa_SignStringENC (objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRsa_SignStringENC(_map(96, 'CkRsa_SignStringENC'))
    (objHandle, strToBeHashed, hashAlgorithm, outStr);
end;

function CkRsa__signStringENC (objHandle: HCkRsa; strToBeHashed: PWideChar; hashAlgorithm: PWideChar): PWideChar;
begin
  result := TCkRsa__signStringENC(_map(97, 'CkRsa__signStringENC'))
    (objHandle, strToBeHashed, hashAlgorithm);
end;

function CkRsa_SnkToXml (objHandle: HCkRsa; filename: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkRsa_SnkToXml(_map(98, 'CkRsa_SnkToXml'))
    (objHandle, filename, outStr);
end;

function CkRsa__snkToXml (objHandle: HCkRsa; filename: PWideChar): PWideChar;
begin
  result := TCkRsa__snkToXml(_map(99, 'CkRsa__snkToXml'))
    (objHandle, filename);
end;

function CkRsa_UsePrivateKey (objHandle: HCkRsa; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkRsa_UsePrivateKey(_map(100, 'CkRsa_UsePrivateKey'))
    (objHandle, privKey);
end;

function CkRsa_UsePublicKey (objHandle: HCkRsa; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkRsa_UsePublicKey(_map(101, 'CkRsa_UsePublicKey'))
    (objHandle, pubKey);
end;

function CkRsa_VerifyBd (objHandle: HCkRsa; bdData: HCkBinData; hashAlgorithm: PWideChar; bdSig: HCkBinData): wordbool;
begin
  result := TCkRsa_VerifyBd(_map(102, 'CkRsa_VerifyBd'))
    (objHandle, bdData, hashAlgorithm, bdSig);
end;

function CkRsa_VerifyBytes (objHandle: HCkRsa; originalData: HCkByteData; hashAlgorithm: PWideChar; signatureBytes: HCkByteData): wordbool;
begin
  result := TCkRsa_VerifyBytes(_map(103, 'CkRsa_VerifyBytes'))
    (objHandle, originalData, hashAlgorithm, signatureBytes);
end;

function CkRsa_VerifyBytesENC (objHandle: HCkRsa; originalData: HCkByteData; hashAlgorithm: PWideChar; encodedSig: PWideChar): wordbool;
begin
  result := TCkRsa_VerifyBytesENC(_map(104, 'CkRsa_VerifyBytesENC'))
    (objHandle, originalData, hashAlgorithm, encodedSig);
end;

function CkRsa_VerifyHash (objHandle: HCkRsa; hashBytes: HCkByteData; hashAlg: PWideChar; sigBytes: HCkByteData): wordbool;
begin
  result := TCkRsa_VerifyHash(_map(105, 'CkRsa_VerifyHash'))
    (objHandle, hashBytes, hashAlg, sigBytes);
end;

function CkRsa_VerifyHashENC (objHandle: HCkRsa; encodedHash: PWideChar; hashAlg: PWideChar; encodedSig: PWideChar): wordbool;
begin
  result := TCkRsa_VerifyHashENC(_map(106, 'CkRsa_VerifyHashENC'))
    (objHandle, encodedHash, hashAlg, encodedSig);
end;

function CkRsa_VerifyRawBd (objHandle: HCkRsa; bd: HCkBinData): wordbool;
begin
  result := TCkRsa_VerifyRawBd(_map(107, 'CkRsa_VerifyRawBd'))
    (objHandle, bd);
end;

function CkRsa_VerifyString (objHandle: HCkRsa; originalString: PWideChar; hashAlgorithm: PWideChar; binarySig: HCkByteData): wordbool;
begin
  result := TCkRsa_VerifyString(_map(108, 'CkRsa_VerifyString'))
    (objHandle, originalString, hashAlgorithm, binarySig);
end;

function CkRsa_VerifyStringENC (objHandle: HCkRsa; originalString: PWideChar; hashAlgorithm: PWideChar; encodedSig: PWideChar): wordbool;
begin
  result := TCkRsa_VerifyStringENC(_map(109, 'CkRsa_VerifyStringENC'))
    (objHandle, originalString, hashAlgorithm, encodedSig);
end;

end.
