unit SFtp;

interface

type

HCkSFtp = Pointer;
HCkSecureString = Pointer;
HCkSsh = Pointer;
HCkStringBuilder = Pointer;
HCkSshKey = Pointer;
HCkSFtpDir = Pointer;
HCkString = Pointer;
HCkStringTable = Pointer;
HCkByteData = Pointer;
HCkDateTime = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSFtpAbortCheck = function(): Integer; cdecl;
TSFtpProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSFtpPercentDone = function(pctDone: Integer): Integer; cdecl;
TSFtpTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSFtp_Create: HCkSFtp;  stdcall;
procedure CkSFtp_Dispose(handle: HCkSFtp); stdcall;

procedure CkSFtp_SetAbortCheck(objHandle: HCkSFtp; fn: TSFtpAbortCheck) stdcall;
procedure CkSFtp_SetProgressInfo(objHandle: HCkSFtp; fn: TSFtpProgressInfo) stdcall;
procedure CkSFtp_SetPercentDone(objHandle: HCkSFtp; fn: TSFtpPercentDone) stdcall;
procedure CkSFtp_SetTaskCompleted(objHandle: HCkSFtp; fn: TSFtpTaskCompleted) stdcall;
function CkSFtp_getAbortCurrent(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putAbortCurrent(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getAuthFailReason(objHandle: HCkSFtp): Integer;
function CkSFtp_getBandwidthThrottleDown(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putBandwidthThrottleDown(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getBandwidthThrottleUp(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putBandwidthThrottleUp(objHandle: HCkSFtp; newPropVal: Integer);
procedure CkSFtp_getClientIdentifier(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putClientIdentifier(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__clientIdentifier(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getClientIpAddress(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putClientIpAddress(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__clientIpAddress(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getConnectTimeoutMs(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putConnectTimeoutMs(objHandle: HCkSFtp; newPropVal: Integer);
procedure CkSFtp_getDebugLogFilePath(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putDebugLogFilePath(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__debugLogFilePath(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getDisconnectCode(objHandle: HCkSFtp): Integer;
procedure CkSFtp_getDisconnectReason(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__disconnectReason(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getEnableCache(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putEnableCache(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getEnableCompression(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putEnableCompression(objHandle: HCkSFtp; newPropVal: wordbool);
procedure CkSFtp_getFilenameCharset(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putFilenameCharset(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__filenameCharset(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getForceCipher(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putForceCipher(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__forceCipher(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getForceV3(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putForceV3(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getHeartbeatMs(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putHeartbeatMs(objHandle: HCkSFtp; newPropVal: Integer);
procedure CkSFtp_getHostKeyAlg(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putHostKeyAlg(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__hostKeyAlg(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getHostKeyFingerprint(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__hostKeyFingerprint(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getHttpProxyAuthMethod(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putHttpProxyAuthMethod(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__httpProxyAuthMethod(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getHttpProxyDomain(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putHttpProxyDomain(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__httpProxyDomain(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getHttpProxyHostname(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putHttpProxyHostname(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__httpProxyHostname(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getHttpProxyPassword(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putHttpProxyPassword(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__httpProxyPassword(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getHttpProxyPort(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putHttpProxyPort(objHandle: HCkSFtp; newPropVal: Integer);
procedure CkSFtp_getHttpProxyUsername(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putHttpProxyUsername(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__httpProxyUsername(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getIdleTimeoutMs(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putIdleTimeoutMs(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getIncludeDotDirs(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putIncludeDotDirs(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getInitializeFailCode(objHandle: HCkSFtp): Integer;
procedure CkSFtp_getInitializeFailReason(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__initializeFailReason(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getIsConnected(objHandle: HCkSFtp): wordbool;
function CkSFtp_getKeepSessionLog(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putKeepSessionLog(objHandle: HCkSFtp; newPropVal: wordbool);
procedure CkSFtp_getLastErrorHtml(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__lastErrorHtml(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getLastErrorText(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__lastErrorText(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getLastErrorXml(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__lastErrorXml(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getLastMethodSuccess(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putLastMethodSuccess(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getLastStatusCode(objHandle: HCkSFtp): Integer;
procedure CkSFtp_getLastStatusMessage(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__lastStatusMessage(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getMaxPacketSize(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putMaxPacketSize(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getPasswordChangeRequested(objHandle: HCkSFtp): wordbool;
function CkSFtp_getPercentDoneScale(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putPercentDoneScale(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getPreferIpv6(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putPreferIpv6(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getPreserveDate(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putPreserveDate(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getProtocolVersion(objHandle: HCkSFtp): Integer;
procedure CkSFtp_getReadDirMustMatch(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putReadDirMustMatch(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__readDirMustMatch(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getReadDirMustNotMatch(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putReadDirMustNotMatch(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__readDirMustNotMatch(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getServerIdentifier(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__serverIdentifier(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSessionLog(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__sessionLog(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSocksHostname(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSocksHostname(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__socksHostname(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSocksPassword(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSocksPassword(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__socksPassword(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getSocksPort(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putSocksPort(objHandle: HCkSFtp; newPropVal: Integer);
procedure CkSFtp_getSocksUsername(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSocksUsername(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__socksUsername(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getSocksVersion(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putSocksVersion(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getSoRcvBuf(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putSoRcvBuf(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getSoSndBuf(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putSoSndBuf(objHandle: HCkSFtp; newPropVal: Integer);
function CkSFtp_getSyncCreateAllLocalDirs(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putSyncCreateAllLocalDirs(objHandle: HCkSFtp; newPropVal: wordbool);
procedure CkSFtp_getSyncDirectives(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSyncDirectives(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__syncDirectives(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSyncMustMatch(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSyncMustMatch(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__syncMustMatch(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSyncMustMatchDir(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSyncMustMatchDir(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__syncMustMatchDir(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSyncMustNotMatch(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSyncMustNotMatch(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__syncMustNotMatch(objHandle: HCkSFtp): PWideChar;
procedure CkSFtp_getSyncMustNotMatchDir(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putSyncMustNotMatchDir(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__syncMustNotMatchDir(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getTcpNoDelay(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putTcpNoDelay(objHandle: HCkSFtp; newPropVal: wordbool);
procedure CkSFtp_getUncommonOptions(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putUncommonOptions(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__uncommonOptions(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getUploadChunkSize(objHandle: HCkSFtp): Integer;
procedure CkSFtp_putUploadChunkSize(objHandle: HCkSFtp; newPropVal: Integer);
procedure CkSFtp_getUserAuthBanner(objHandle: HCkSFtp; outPropVal: HCkString);
procedure CkSFtp_putUserAuthBanner(objHandle: HCkSFtp; newPropVal: PWideChar);
function CkSFtp__userAuthBanner(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getUtcMode(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putUtcMode(objHandle: HCkSFtp; newPropVal: wordbool);
function CkSFtp_getVerboseLogging(objHandle: HCkSFtp): wordbool;
procedure CkSFtp_putVerboseLogging(objHandle: HCkSFtp; newPropVal: wordbool);
procedure CkSFtp_getVersion(objHandle: HCkSFtp; outPropVal: HCkString);
function CkSFtp__version(objHandle: HCkSFtp): PWideChar;
function CkSFtp_getXferByteCount(objHandle: HCkSFtp): LongWord;
function CkSFtp_getXferByteCount64(objHandle: HCkSFtp): Int64;
function CkSFtp_AccumulateBytes(objHandle: HCkSFtp; handle: PWideChar; maxBytes: Integer): Integer;
function CkSFtp_AccumulateBytesAsync(objHandle: HCkSFtp; handle: PWideChar; maxBytes: Integer): HCkTask;
function CkSFtp_Add64(objHandle: HCkSFtp; n1: PWideChar; n2: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__add64(objHandle: HCkSFtp; n1: PWideChar; n2: PWideChar): PWideChar;
function CkSFtp_AuthenticatePk(objHandle: HCkSFtp; username: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSFtp_AuthenticatePkAsync(objHandle: HCkSFtp; username: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSFtp_AuthenticatePw(objHandle: HCkSFtp; login: PWideChar; password: PWideChar): wordbool;
function CkSFtp_AuthenticatePwAsync(objHandle: HCkSFtp; login: PWideChar; password: PWideChar): HCkTask;
function CkSFtp_AuthenticatePwPk(objHandle: HCkSFtp; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSFtp_AuthenticatePwPkAsync(objHandle: HCkSFtp; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSFtp_AuthenticateSecPw(objHandle: HCkSFtp; login: HCkSecureString; password: HCkSecureString): wordbool;
function CkSFtp_AuthenticateSecPwAsync(objHandle: HCkSFtp; login: HCkSecureString; password: HCkSecureString): HCkTask;
function CkSFtp_AuthenticateSecPwPk(objHandle: HCkSFtp; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool;
function CkSFtp_AuthenticateSecPwPkAsync(objHandle: HCkSFtp; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask;
procedure CkSFtp_ClearAccumulateBuffer(objHandle: HCkSFtp);
procedure CkSFtp_ClearCache(objHandle: HCkSFtp);
procedure CkSFtp_ClearSessionLog(objHandle: HCkSFtp);
function CkSFtp_CloseHandle(objHandle: HCkSFtp; handle: PWideChar): wordbool;
function CkSFtp_CloseHandleAsync(objHandle: HCkSFtp; handle: PWideChar): HCkTask;
function CkSFtp_Connect(objHandle: HCkSFtp; domainName: PWideChar; port: Integer): wordbool;
function CkSFtp_ConnectAsync(objHandle: HCkSFtp; domainName: PWideChar; port: Integer): HCkTask;
function CkSFtp_ConnectThroughSsh(objHandle: HCkSFtp; sshConn: HCkSsh; hostname: PWideChar; port: Integer): wordbool;
function CkSFtp_ConnectThroughSshAsync(objHandle: HCkSFtp; sshConn: HCkSsh; hostname: PWideChar; port: Integer): HCkTask;
function CkSFtp_ContinueKeyboardAuth(objHandle: HCkSFtp; response: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__continueKeyboardAuth(objHandle: HCkSFtp; response: PWideChar): PWideChar;
function CkSFtp_ContinueKeyboardAuthAsync(objHandle: HCkSFtp; response: PWideChar): HCkTask;
function CkSFtp_CopyFileAttr(objHandle: HCkSFtp; localFilename: PWideChar; remoteFilename: PWideChar; isHandle: wordbool): wordbool;
function CkSFtp_CopyFileAttrAsync(objHandle: HCkSFtp; localFilename: PWideChar; remoteFilename: PWideChar; isHandle: wordbool): HCkTask;
function CkSFtp_CreateDir(objHandle: HCkSFtp; path: PWideChar): wordbool;
function CkSFtp_CreateDirAsync(objHandle: HCkSFtp; path: PWideChar): HCkTask;
procedure CkSFtp_Disconnect(objHandle: HCkSFtp);
function CkSFtp_DownloadBd(objHandle: HCkSFtp; remoteFilePath: PWideChar; binData: HCkBinData): wordbool;
function CkSFtp_DownloadBdAsync(objHandle: HCkSFtp; remoteFilePath: PWideChar; binData: HCkBinData): HCkTask;
function CkSFtp_DownloadFile(objHandle: HCkSFtp; handle: PWideChar; toFilename: PWideChar): wordbool;
function CkSFtp_DownloadFileAsync(objHandle: HCkSFtp; handle: PWideChar; toFilename: PWideChar): HCkTask;
function CkSFtp_DownloadFileByName(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
function CkSFtp_DownloadFileByNameAsync(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
function CkSFtp_DownloadSb(objHandle: HCkSFtp; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool;
function CkSFtp_DownloadSbAsync(objHandle: HCkSFtp; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
function CkSFtp_Eof(objHandle: HCkSFtp; handle: PWideChar): wordbool;
function CkSFtp_FileExists(objHandle: HCkSFtp; remotePath: PWideChar; followLinks: wordbool): Integer;
function CkSFtp_FileExistsAsync(objHandle: HCkSFtp; remotePath: PWideChar; followLinks: wordbool): HCkTask;
function CkSFtp_Fsync(objHandle: HCkSFtp; handle: PWideChar): wordbool;
function CkSFtp_FsyncAsync(objHandle: HCkSFtp; handle: PWideChar): HCkTask;
function CkSFtp_GetFileCreateDt(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime;
function CkSFtp_GetFileCreateDtAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileCreateTimeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getFileCreateTimeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
function CkSFtp_GetFileCreateTimeStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileGroup(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getFileGroup(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
function CkSFtp_GetFileGroupAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileLastAccessDt(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime;
function CkSFtp_GetFileLastAccessDtAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileLastAccessStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getFileLastAccessStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
function CkSFtp_GetFileLastAccessStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileLastModifiedDt(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime;
function CkSFtp_GetFileLastModifiedDtAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileLastModifiedStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getFileLastModifiedStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
function CkSFtp_GetFileLastModifiedStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileOwner(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getFileOwner(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
function CkSFtp_GetFileOwnerAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFilePermissions(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Integer;
function CkSFtp_GetFilePermissionsAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileSize32(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Integer;
function CkSFtp_GetFileSize32Async(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileSize64(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Int64;
function CkSFtp_GetFileSize64Async(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetFileSizeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getFileSizeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
function CkSFtp_GetFileSizeStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
function CkSFtp_GetHostKeyFP(objHandle: HCkSFtp; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool; outStr: HCkString): wordbool;
function CkSFtp__getHostKeyFP(objHandle: HCkSFtp; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool): PWideChar;
procedure CkSFtp_GetLastJsonData(objHandle: HCkSFtp; json: HCkJsonObject);
procedure CkSFtp_GetSyncedFiles(objHandle: HCkSFtp; strTab: HCkStringTable);
function CkSFtp_HardLink(objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool;
function CkSFtp_HardLinkAsync(objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask;
function CkSFtp_InitializeSftp(objHandle: HCkSFtp): wordbool;
function CkSFtp_InitializeSftpAsync(objHandle: HCkSFtp): HCkTask;
function CkSFtp_LastJsonData(objHandle: HCkSFtp): HCkJsonObject;
function CkSFtp_LastReadFailed(objHandle: HCkSFtp; handle: PWideChar): wordbool;
function CkSFtp_LastReadNumBytes(objHandle: HCkSFtp; handle: PWideChar): Integer;
function CkSFtp_LoadTaskCaller(objHandle: HCkSFtp; task: HCkTask): wordbool;
function CkSFtp_OpenDir(objHandle: HCkSFtp; path: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__openDir(objHandle: HCkSFtp; path: PWideChar): PWideChar;
function CkSFtp_OpenDirAsync(objHandle: HCkSFtp; path: PWideChar): HCkTask;
function CkSFtp_OpenFile(objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__openFile(objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar): PWideChar;
function CkSFtp_OpenFileAsync(objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar): HCkTask;
function CkSFtp_ReadDir(objHandle: HCkSFtp; handle: PWideChar): HCkSFtpDir;
function CkSFtp_ReadDirAsync(objHandle: HCkSFtp; handle: PWideChar): HCkTask;
function CkSFtp_ReadDirListing(objHandle: HCkSFtp; handle: PWideChar; dirObj: HCkSFtpDir): wordbool;
function CkSFtp_ReadDirListingAsync(objHandle: HCkSFtp; handle: PWideChar; dirObj: HCkSFtpDir): HCkTask;
function CkSFtp_ReadFileBd(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; bd: HCkBinData): wordbool;
function CkSFtp_ReadFileBdAsync(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; bd: HCkBinData): HCkTask;
function CkSFtp_ReadFileBytes(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; outData: HCkByteData): wordbool;
function CkSFtp_ReadFileBytesAsync(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer): HCkTask;
function CkSFtp_ReadFileBytes32(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; outData: HCkByteData): wordbool;
function CkSFtp_ReadFileBytes32Async(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer): HCkTask;
function CkSFtp_ReadFileBytes64(objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; outData: HCkByteData): wordbool;
function CkSFtp_ReadFileBytes64Async(objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer): HCkTask;
function CkSFtp_ReadFileBytes64s(objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; outData: HCkByteData): wordbool;
function CkSFtp_ReadFileBytes64sAsync(objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer): HCkTask;
function CkSFtp_ReadFileText(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__readFileText(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar): PWideChar;
function CkSFtp_ReadFileTextAsync(objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar): HCkTask;
function CkSFtp_ReadFileText32(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__readFileText32(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar): PWideChar;
function CkSFtp_ReadFileText32Async(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar): HCkTask;
function CkSFtp_ReadFileText64(objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__readFileText64(objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar): PWideChar;
function CkSFtp_ReadFileText64Async(objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar): HCkTask;
function CkSFtp_ReadFileText64s(objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__readFileText64s(objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar): PWideChar;
function CkSFtp_ReadFileText64sAsync(objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar): HCkTask;
function CkSFtp_ReadLink(objHandle: HCkSFtp; path: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__readLink(objHandle: HCkSFtp; path: PWideChar): PWideChar;
function CkSFtp_ReadLinkAsync(objHandle: HCkSFtp; path: PWideChar): HCkTask;
function CkSFtp_RealPath(objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__realPath(objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar): PWideChar;
function CkSFtp_RealPathAsync(objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar): HCkTask;
function CkSFtp_RemoveDir(objHandle: HCkSFtp; path: PWideChar): wordbool;
function CkSFtp_RemoveDirAsync(objHandle: HCkSFtp; path: PWideChar): HCkTask;
function CkSFtp_RemoveFile(objHandle: HCkSFtp; filename: PWideChar): wordbool;
function CkSFtp_RemoveFileAsync(objHandle: HCkSFtp; filename: PWideChar): HCkTask;
function CkSFtp_RenameFileOrDir(objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool;
function CkSFtp_RenameFileOrDirAsync(objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask;
function CkSFtp_ResumeDownloadFileByName(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
function CkSFtp_ResumeDownloadFileByNameAsync(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
function CkSFtp_ResumeUploadFileByName(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
function CkSFtp_ResumeUploadFileByNameAsync(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
function CkSFtp_SendIgnore(objHandle: HCkSFtp): wordbool;
function CkSFtp_SendIgnoreAsync(objHandle: HCkSFtp): HCkTask;
function CkSFtp_SetAllowedAlgorithms(objHandle: HCkSFtp; json: HCkJsonObject): wordbool;
function CkSFtp_SetCreateDt(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; createDateTime: HCkDateTime): wordbool;
function CkSFtp_SetCreateDtAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; createDateTime: HCkDateTime): HCkTask;
function CkSFtp_SetCreateTimeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool;
function CkSFtp_SetCreateTimeStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask;
function CkSFtp_SetLastAccessDt(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; accessDateTime: HCkDateTime): wordbool;
function CkSFtp_SetLastAccessDtAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; accessDateTime: HCkDateTime): HCkTask;
function CkSFtp_SetLastAccessTimeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool;
function CkSFtp_SetLastAccessTimeStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask;
function CkSFtp_SetLastModifiedDt(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; modifiedDateTime: HCkDateTime): wordbool;
function CkSFtp_SetLastModifiedDtAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; modifiedDateTime: HCkDateTime): HCkTask;
function CkSFtp_SetLastModifiedTimeStr(objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool;
function CkSFtp_SetLastModifiedTimeStrAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask;
function CkSFtp_SetOwnerAndGroup(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; owner: PWideChar; group: PWideChar): wordbool;
function CkSFtp_SetOwnerAndGroupAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; owner: PWideChar; group: PWideChar): HCkTask;
function CkSFtp_SetPermissions(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; permissions: Integer): wordbool;
function CkSFtp_SetPermissionsAsync(objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; permissions: Integer): HCkTask;
function CkSFtp_StartKeyboardAuth(objHandle: HCkSFtp; login: PWideChar; outStr: HCkString): wordbool;
function CkSFtp__startKeyboardAuth(objHandle: HCkSFtp; login: PWideChar): PWideChar;
function CkSFtp_StartKeyboardAuthAsync(objHandle: HCkSFtp; login: PWideChar): HCkTask;
function CkSFtp_SymLink(objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool;
function CkSFtp_SymLinkAsync(objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask;
function CkSFtp_SyncTreeDownload(objHandle: HCkSFtp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; recurse: wordbool): wordbool;
function CkSFtp_SyncTreeDownloadAsync(objHandle: HCkSFtp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; recurse: wordbool): HCkTask;
function CkSFtp_SyncTreeUpload(objHandle: HCkSFtp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): wordbool;
function CkSFtp_SyncTreeUploadAsync(objHandle: HCkSFtp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask;
function CkSFtp_UploadBd(objHandle: HCkSFtp; binData: HCkBinData; remoteFilePath: PWideChar): wordbool;
function CkSFtp_UploadBdAsync(objHandle: HCkSFtp; binData: HCkBinData; remoteFilePath: PWideChar): HCkTask;
function CkSFtp_UploadFile(objHandle: HCkSFtp; handle: PWideChar; fromLocalFilePath: PWideChar): wordbool;
function CkSFtp_UploadFileAsync(objHandle: HCkSFtp; handle: PWideChar; fromLocalFilePath: PWideChar): HCkTask;
function CkSFtp_UploadFileByName(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
function CkSFtp_UploadFileByNameAsync(objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
function CkSFtp_UploadSb(objHandle: HCkSFtp; sb: HCkStringBuilder; remoteFilePath: PWideChar; charset: PWideChar; includeBom: wordbool): wordbool;
function CkSFtp_UploadSbAsync(objHandle: HCkSFtp; sb: HCkStringBuilder; remoteFilePath: PWideChar; charset: PWideChar; includeBom: wordbool): HCkTask;
function CkSFtp_WriteFileBd(objHandle: HCkSFtp; handle: PWideChar; bd: HCkBinData): wordbool;
function CkSFtp_WriteFileBdAsync(objHandle: HCkSFtp; handle: PWideChar; bd: HCkBinData): HCkTask;
function CkSFtp_WriteFileBytes(objHandle: HCkSFtp; handle: PWideChar; byteData: HCkByteData): wordbool;
function CkSFtp_WriteFileBytesAsync(objHandle: HCkSFtp; handle: PWideChar; byteData: HCkByteData): HCkTask;
function CkSFtp_WriteFileBytes32(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; data: HCkByteData): wordbool;
function CkSFtp_WriteFileBytes32Async(objHandle: HCkSFtp; handle: PWideChar; offset: Integer; data: HCkByteData): HCkTask;
function CkSFtp_WriteFileBytes64(objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; data: HCkByteData): wordbool;
function CkSFtp_WriteFileBytes64Async(objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; data: HCkByteData): HCkTask;
function CkSFtp_WriteFileBytes64s(objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; data: HCkByteData): wordbool;
function CkSFtp_WriteFileBytes64sAsync(objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; data: HCkByteData): HCkTask;
function CkSFtp_WriteFileText(objHandle: HCkSFtp; handle: PWideChar; charset: PWideChar; textData: PWideChar): wordbool;
function CkSFtp_WriteFileTextAsync(objHandle: HCkSFtp; handle: PWideChar; charset: PWideChar; textData: PWideChar): HCkTask;
function CkSFtp_WriteFileText32(objHandle: HCkSFtp; handle: PWideChar; offset32: Integer; charset: PWideChar; textData: PWideChar): wordbool;
function CkSFtp_WriteFileText32Async(objHandle: HCkSFtp; handle: PWideChar; offset32: Integer; charset: PWideChar; textData: PWideChar): HCkTask;
function CkSFtp_WriteFileText64(objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; charset: PWideChar; textData: PWideChar): wordbool;
function CkSFtp_WriteFileText64Async(objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; charset: PWideChar; textData: PWideChar): HCkTask;
function CkSFtp_WriteFileText64s(objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; charset: PWideChar; textData: PWideChar): wordbool;
function CkSFtp_WriteFileText64sAsync(objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; charset: PWideChar; textData: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSFtp_Create = function : HCkSFtp; stdcall;
  TCkSFtp_Dispose = procedure (handle: HCkSFtp); stdcall;
  TCkSFtp_SetAbortCheck = procedure (objHandle: HCkSFtp; fn: TSFtpAbortCheck); stdcall;
  TCkSFtp_SetProgressInfo = procedure (objHandle: HCkSFtp; fn: TSFtpProgressInfo); stdcall;
  TCkSFtp_SetPercentDone = procedure (objHandle: HCkSFtp; fn: TSFtpPercentDone); stdcall;
  TCkSFtp_SetTaskCompleted = procedure (objHandle: HCkSFtp; fn: TSFtpTaskCompleted); stdcall;
  TCkSFtp_getAbortCurrent = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putAbortCurrent = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getAuthFailReason = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_getBandwidthThrottleDown = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putBandwidthThrottleDown = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getBandwidthThrottleUp = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putBandwidthThrottleUp = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getClientIdentifier = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putClientIdentifier = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__clientIdentifier = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getClientIpAddress = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putClientIpAddress = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__clientIpAddress = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getConnectTimeoutMs = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putConnectTimeoutMs = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getDebugLogFilePath = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putDebugLogFilePath = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__debugLogFilePath = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getDisconnectCode = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_getDisconnectReason = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__disconnectReason = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getEnableCache = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putEnableCache = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getEnableCompression = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putEnableCompression = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getFilenameCharset = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putFilenameCharset = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__filenameCharset = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getForceCipher = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putForceCipher = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__forceCipher = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getForceV3 = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putForceV3 = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getHeartbeatMs = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putHeartbeatMs = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getHostKeyAlg = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putHostKeyAlg = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__hostKeyAlg = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getHostKeyFingerprint = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__hostKeyFingerprint = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getHttpProxyAuthMethod = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putHttpProxyAuthMethod = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__httpProxyAuthMethod = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getHttpProxyDomain = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putHttpProxyDomain = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__httpProxyDomain = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getHttpProxyHostname = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putHttpProxyHostname = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__httpProxyHostname = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getHttpProxyPassword = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putHttpProxyPassword = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__httpProxyPassword = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getHttpProxyPort = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putHttpProxyPort = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getHttpProxyUsername = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putHttpProxyUsername = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__httpProxyUsername = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getIdleTimeoutMs = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putIdleTimeoutMs = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getIncludeDotDirs = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putIncludeDotDirs = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getInitializeFailCode = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_getInitializeFailReason = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__initializeFailReason = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getIsConnected = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_getKeepSessionLog = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putKeepSessionLog = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getLastErrorHtml = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__lastErrorHtml = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getLastErrorText = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__lastErrorText = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getLastErrorXml = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__lastErrorXml = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getLastMethodSuccess = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putLastMethodSuccess = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getLastStatusCode = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_getLastStatusMessage = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__lastStatusMessage = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getMaxPacketSize = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putMaxPacketSize = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getPasswordChangeRequested = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_getPercentDoneScale = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putPercentDoneScale = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getPreferIpv6 = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putPreferIpv6 = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getPreserveDate = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putPreserveDate = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getProtocolVersion = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_getReadDirMustMatch = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putReadDirMustMatch = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__readDirMustMatch = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getReadDirMustNotMatch = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putReadDirMustNotMatch = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__readDirMustNotMatch = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getServerIdentifier = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__serverIdentifier = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSessionLog = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__sessionLog = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSocksHostname = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSocksHostname = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__socksHostname = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSocksPassword = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSocksPassword = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__socksPassword = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSocksPort = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putSocksPort = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getSocksUsername = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSocksUsername = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__socksUsername = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSocksVersion = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putSocksVersion = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getSoRcvBuf = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putSoRcvBuf = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getSoSndBuf = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putSoSndBuf = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getSyncCreateAllLocalDirs = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putSyncCreateAllLocalDirs = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getSyncDirectives = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSyncDirectives = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__syncDirectives = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSyncMustMatch = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSyncMustMatch = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__syncMustMatch = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSyncMustMatchDir = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSyncMustMatchDir = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__syncMustMatchDir = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSyncMustNotMatch = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSyncMustNotMatch = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__syncMustNotMatch = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getSyncMustNotMatchDir = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putSyncMustNotMatchDir = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__syncMustNotMatchDir = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getTcpNoDelay = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putTcpNoDelay = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getUncommonOptions = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putUncommonOptions = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__uncommonOptions = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getUploadChunkSize = function (objHandle: HCkSFtp): Integer; stdcall;
  TCkSFtp_putUploadChunkSize = procedure (objHandle: HCkSFtp; newPropVal: Integer); stdcall;
  TCkSFtp_getUserAuthBanner = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp_putUserAuthBanner = procedure (objHandle: HCkSFtp; newPropVal: PWideChar); stdcall;
  TCkSFtp__userAuthBanner = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getUtcMode = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putUtcMode = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getVerboseLogging = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_putVerboseLogging = procedure (objHandle: HCkSFtp; newPropVal: wordbool); stdcall;
  TCkSFtp_getVersion = procedure (objHandle: HCkSFtp; outPropVal: HCkString); stdcall;
  TCkSFtp__version = function (objHandle: HCkSFtp): PWideChar; stdcall;
  TCkSFtp_getXferByteCount = function (objHandle: HCkSFtp): LongWord; stdcall;
  TCkSFtp_getXferByteCount64 = function (objHandle: HCkSFtp): Int64; stdcall;
  TCkSFtp_AccumulateBytes = function (objHandle: HCkSFtp; handle: PWideChar; maxBytes: Integer): Integer; stdcall;
  TCkSFtp_AccumulateBytesAsync = function (objHandle: HCkSFtp; handle: PWideChar; maxBytes: Integer): HCkTask; stdcall;
  TCkSFtp_Add64 = function (objHandle: HCkSFtp; n1: PWideChar; n2: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__add64 = function (objHandle: HCkSFtp; n1: PWideChar; n2: PWideChar): PWideChar; stdcall;
  TCkSFtp_AuthenticatePk = function (objHandle: HCkSFtp; username: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSFtp_AuthenticatePkAsync = function (objHandle: HCkSFtp; username: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSFtp_AuthenticatePw = function (objHandle: HCkSFtp; login: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkSFtp_AuthenticatePwAsync = function (objHandle: HCkSFtp; login: PWideChar; password: PWideChar): HCkTask; stdcall;
  TCkSFtp_AuthenticatePwPk = function (objHandle: HCkSFtp; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSFtp_AuthenticatePwPkAsync = function (objHandle: HCkSFtp; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSFtp_AuthenticateSecPw = function (objHandle: HCkSFtp; login: HCkSecureString; password: HCkSecureString): wordbool; stdcall;
  TCkSFtp_AuthenticateSecPwAsync = function (objHandle: HCkSFtp; login: HCkSecureString; password: HCkSecureString): HCkTask; stdcall;
  TCkSFtp_AuthenticateSecPwPk = function (objHandle: HCkSFtp; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSFtp_AuthenticateSecPwPkAsync = function (objHandle: HCkSFtp; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSFtp_ClearAccumulateBuffer = procedure (objHandle: HCkSFtp); stdcall;
  TCkSFtp_ClearCache = procedure (objHandle: HCkSFtp); stdcall;
  TCkSFtp_ClearSessionLog = procedure (objHandle: HCkSFtp); stdcall;
  TCkSFtp_CloseHandle = function (objHandle: HCkSFtp; handle: PWideChar): wordbool; stdcall;
  TCkSFtp_CloseHandleAsync = function (objHandle: HCkSFtp; handle: PWideChar): HCkTask; stdcall;
  TCkSFtp_Connect = function (objHandle: HCkSFtp; domainName: PWideChar; port: Integer): wordbool; stdcall;
  TCkSFtp_ConnectAsync = function (objHandle: HCkSFtp; domainName: PWideChar; port: Integer): HCkTask; stdcall;
  TCkSFtp_ConnectThroughSsh = function (objHandle: HCkSFtp; sshConn: HCkSsh; hostname: PWideChar; port: Integer): wordbool; stdcall;
  TCkSFtp_ConnectThroughSshAsync = function (objHandle: HCkSFtp; sshConn: HCkSsh; hostname: PWideChar; port: Integer): HCkTask; stdcall;
  TCkSFtp_ContinueKeyboardAuth = function (objHandle: HCkSFtp; response: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__continueKeyboardAuth = function (objHandle: HCkSFtp; response: PWideChar): PWideChar; stdcall;
  TCkSFtp_ContinueKeyboardAuthAsync = function (objHandle: HCkSFtp; response: PWideChar): HCkTask; stdcall;
  TCkSFtp_CopyFileAttr = function (objHandle: HCkSFtp; localFilename: PWideChar; remoteFilename: PWideChar; isHandle: wordbool): wordbool; stdcall;
  TCkSFtp_CopyFileAttrAsync = function (objHandle: HCkSFtp; localFilename: PWideChar; remoteFilename: PWideChar; isHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_CreateDir = function (objHandle: HCkSFtp; path: PWideChar): wordbool; stdcall;
  TCkSFtp_CreateDirAsync = function (objHandle: HCkSFtp; path: PWideChar): HCkTask; stdcall;
  TCkSFtp_Disconnect = procedure (objHandle: HCkSFtp); stdcall;
  TCkSFtp_DownloadBd = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; binData: HCkBinData): wordbool; stdcall;
  TCkSFtp_DownloadBdAsync = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; binData: HCkBinData): HCkTask; stdcall;
  TCkSFtp_DownloadFile = function (objHandle: HCkSFtp; handle: PWideChar; toFilename: PWideChar): wordbool; stdcall;
  TCkSFtp_DownloadFileAsync = function (objHandle: HCkSFtp; handle: PWideChar; toFilename: PWideChar): HCkTask; stdcall;
  TCkSFtp_DownloadFileByName = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkSFtp_DownloadFileByNameAsync = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_DownloadSb = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSFtp_DownloadSbAsync = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkSFtp_Eof = function (objHandle: HCkSFtp; handle: PWideChar): wordbool; stdcall;
  TCkSFtp_FileExists = function (objHandle: HCkSFtp; remotePath: PWideChar; followLinks: wordbool): Integer; stdcall;
  TCkSFtp_FileExistsAsync = function (objHandle: HCkSFtp; remotePath: PWideChar; followLinks: wordbool): HCkTask; stdcall;
  TCkSFtp_Fsync = function (objHandle: HCkSFtp; handle: PWideChar): wordbool; stdcall;
  TCkSFtp_FsyncAsync = function (objHandle: HCkSFtp; handle: PWideChar): HCkTask; stdcall;
  TCkSFtp_GetFileCreateDt = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime; stdcall;
  TCkSFtp_GetFileCreateDtAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileCreateTimeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getFileCreateTimeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar; stdcall;
  TCkSFtp_GetFileCreateTimeStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileGroup = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getFileGroup = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar; stdcall;
  TCkSFtp_GetFileGroupAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileLastAccessDt = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime; stdcall;
  TCkSFtp_GetFileLastAccessDtAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileLastAccessStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getFileLastAccessStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar; stdcall;
  TCkSFtp_GetFileLastAccessStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileLastModifiedDt = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime; stdcall;
  TCkSFtp_GetFileLastModifiedDtAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileLastModifiedStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getFileLastModifiedStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar; stdcall;
  TCkSFtp_GetFileLastModifiedStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileOwner = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getFileOwner = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar; stdcall;
  TCkSFtp_GetFileOwnerAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFilePermissions = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Integer; stdcall;
  TCkSFtp_GetFilePermissionsAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileSize32 = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Integer; stdcall;
  TCkSFtp_GetFileSize32Async = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileSize64 = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Int64; stdcall;
  TCkSFtp_GetFileSize64Async = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetFileSizeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getFileSizeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar; stdcall;
  TCkSFtp_GetFileSizeStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask; stdcall;
  TCkSFtp_GetHostKeyFP = function (objHandle: HCkSFtp; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__getHostKeyFP = function (objHandle: HCkSFtp; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool): PWideChar; stdcall;
  TCkSFtp_GetLastJsonData = procedure (objHandle: HCkSFtp; json: HCkJsonObject); stdcall;
  TCkSFtp_GetSyncedFiles = procedure (objHandle: HCkSFtp; strTab: HCkStringTable); stdcall;
  TCkSFtp_HardLink = function (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool; stdcall;
  TCkSFtp_HardLinkAsync = function (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask; stdcall;
  TCkSFtp_InitializeSftp = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_InitializeSftpAsync = function (objHandle: HCkSFtp): HCkTask; stdcall;
  TCkSFtp_LastJsonData = function (objHandle: HCkSFtp): HCkJsonObject; stdcall;
  TCkSFtp_LastReadFailed = function (objHandle: HCkSFtp; handle: PWideChar): wordbool; stdcall;
  TCkSFtp_LastReadNumBytes = function (objHandle: HCkSFtp; handle: PWideChar): Integer; stdcall;
  TCkSFtp_LoadTaskCaller = function (objHandle: HCkSFtp; task: HCkTask): wordbool; stdcall;
  TCkSFtp_OpenDir = function (objHandle: HCkSFtp; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__openDir = function (objHandle: HCkSFtp; path: PWideChar): PWideChar; stdcall;
  TCkSFtp_OpenDirAsync = function (objHandle: HCkSFtp; path: PWideChar): HCkTask; stdcall;
  TCkSFtp_OpenFile = function (objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__openFile = function (objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar): PWideChar; stdcall;
  TCkSFtp_OpenFileAsync = function (objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar): HCkTask; stdcall;
  TCkSFtp_ReadDir = function (objHandle: HCkSFtp; handle: PWideChar): HCkSFtpDir; stdcall;
  TCkSFtp_ReadDirAsync = function (objHandle: HCkSFtp; handle: PWideChar): HCkTask; stdcall;
  TCkSFtp_ReadDirListing = function (objHandle: HCkSFtp; handle: PWideChar; dirObj: HCkSFtpDir): wordbool; stdcall;
  TCkSFtp_ReadDirListingAsync = function (objHandle: HCkSFtp; handle: PWideChar; dirObj: HCkSFtpDir): HCkTask; stdcall;
  TCkSFtp_ReadFileBd = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkSFtp_ReadFileBdAsync = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; bd: HCkBinData): HCkTask; stdcall;
  TCkSFtp_ReadFileBytes = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSFtp_ReadFileBytesAsync = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer): HCkTask; stdcall;
  TCkSFtp_ReadFileBytes32 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSFtp_ReadFileBytes32Async = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer): HCkTask; stdcall;
  TCkSFtp_ReadFileBytes64 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSFtp_ReadFileBytes64Async = function (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer): HCkTask; stdcall;
  TCkSFtp_ReadFileBytes64s = function (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSFtp_ReadFileBytes64sAsync = function (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer): HCkTask; stdcall;
  TCkSFtp_ReadFileText = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__readFileText = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSFtp_ReadFileTextAsync = function (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar): HCkTask; stdcall;
  TCkSFtp_ReadFileText32 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__readFileText32 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSFtp_ReadFileText32Async = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar): HCkTask; stdcall;
  TCkSFtp_ReadFileText64 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__readFileText64 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSFtp_ReadFileText64Async = function (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar): HCkTask; stdcall;
  TCkSFtp_ReadFileText64s = function (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__readFileText64s = function (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSFtp_ReadFileText64sAsync = function (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar): HCkTask; stdcall;
  TCkSFtp_ReadLink = function (objHandle: HCkSFtp; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__readLink = function (objHandle: HCkSFtp; path: PWideChar): PWideChar; stdcall;
  TCkSFtp_ReadLinkAsync = function (objHandle: HCkSFtp; path: PWideChar): HCkTask; stdcall;
  TCkSFtp_RealPath = function (objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__realPath = function (objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar): PWideChar; stdcall;
  TCkSFtp_RealPathAsync = function (objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_RemoveDir = function (objHandle: HCkSFtp; path: PWideChar): wordbool; stdcall;
  TCkSFtp_RemoveDirAsync = function (objHandle: HCkSFtp; path: PWideChar): HCkTask; stdcall;
  TCkSFtp_RemoveFile = function (objHandle: HCkSFtp; filename: PWideChar): wordbool; stdcall;
  TCkSFtp_RemoveFileAsync = function (objHandle: HCkSFtp; filename: PWideChar): HCkTask; stdcall;
  TCkSFtp_RenameFileOrDir = function (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool; stdcall;
  TCkSFtp_RenameFileOrDirAsync = function (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask; stdcall;
  TCkSFtp_ResumeDownloadFileByName = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkSFtp_ResumeDownloadFileByNameAsync = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_ResumeUploadFileByName = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkSFtp_ResumeUploadFileByNameAsync = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_SendIgnore = function (objHandle: HCkSFtp): wordbool; stdcall;
  TCkSFtp_SendIgnoreAsync = function (objHandle: HCkSFtp): HCkTask; stdcall;
  TCkSFtp_SetAllowedAlgorithms = function (objHandle: HCkSFtp; json: HCkJsonObject): wordbool; stdcall;
  TCkSFtp_SetCreateDt = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; createDateTime: HCkDateTime): wordbool; stdcall;
  TCkSFtp_SetCreateDtAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; createDateTime: HCkDateTime): HCkTask; stdcall;
  TCkSFtp_SetCreateTimeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool; stdcall;
  TCkSFtp_SetCreateTimeStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask; stdcall;
  TCkSFtp_SetLastAccessDt = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; accessDateTime: HCkDateTime): wordbool; stdcall;
  TCkSFtp_SetLastAccessDtAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; accessDateTime: HCkDateTime): HCkTask; stdcall;
  TCkSFtp_SetLastAccessTimeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool; stdcall;
  TCkSFtp_SetLastAccessTimeStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask; stdcall;
  TCkSFtp_SetLastModifiedDt = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; modifiedDateTime: HCkDateTime): wordbool; stdcall;
  TCkSFtp_SetLastModifiedDtAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; modifiedDateTime: HCkDateTime): HCkTask; stdcall;
  TCkSFtp_SetLastModifiedTimeStr = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool; stdcall;
  TCkSFtp_SetLastModifiedTimeStrAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask; stdcall;
  TCkSFtp_SetOwnerAndGroup = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; owner: PWideChar; group: PWideChar): wordbool; stdcall;
  TCkSFtp_SetOwnerAndGroupAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; owner: PWideChar; group: PWideChar): HCkTask; stdcall;
  TCkSFtp_SetPermissions = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; permissions: Integer): wordbool; stdcall;
  TCkSFtp_SetPermissionsAsync = function (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; permissions: Integer): HCkTask; stdcall;
  TCkSFtp_StartKeyboardAuth = function (objHandle: HCkSFtp; login: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSFtp__startKeyboardAuth = function (objHandle: HCkSFtp; login: PWideChar): PWideChar; stdcall;
  TCkSFtp_StartKeyboardAuthAsync = function (objHandle: HCkSFtp; login: PWideChar): HCkTask; stdcall;
  TCkSFtp_SymLink = function (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool; stdcall;
  TCkSFtp_SymLinkAsync = function (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask; stdcall;
  TCkSFtp_SyncTreeDownload = function (objHandle: HCkSFtp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; recurse: wordbool): wordbool; stdcall;
  TCkSFtp_SyncTreeDownloadAsync = function (objHandle: HCkSFtp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; recurse: wordbool): HCkTask; stdcall;
  TCkSFtp_SyncTreeUpload = function (objHandle: HCkSFtp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): wordbool; stdcall;
  TCkSFtp_SyncTreeUploadAsync = function (objHandle: HCkSFtp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask; stdcall;
  TCkSFtp_UploadBd = function (objHandle: HCkSFtp; binData: HCkBinData; remoteFilePath: PWideChar): wordbool; stdcall;
  TCkSFtp_UploadBdAsync = function (objHandle: HCkSFtp; binData: HCkBinData; remoteFilePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_UploadFile = function (objHandle: HCkSFtp; handle: PWideChar; fromLocalFilePath: PWideChar): wordbool; stdcall;
  TCkSFtp_UploadFileAsync = function (objHandle: HCkSFtp; handle: PWideChar; fromLocalFilePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_UploadFileByName = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkSFtp_UploadFileByNameAsync = function (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkSFtp_UploadSb = function (objHandle: HCkSFtp; sb: HCkStringBuilder; remoteFilePath: PWideChar; charset: PWideChar; includeBom: wordbool): wordbool; stdcall;
  TCkSFtp_UploadSbAsync = function (objHandle: HCkSFtp; sb: HCkStringBuilder; remoteFilePath: PWideChar; charset: PWideChar; includeBom: wordbool): HCkTask; stdcall;
  TCkSFtp_WriteFileBd = function (objHandle: HCkSFtp; handle: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkSFtp_WriteFileBdAsync = function (objHandle: HCkSFtp; handle: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkSFtp_WriteFileBytes = function (objHandle: HCkSFtp; handle: PWideChar; byteData: HCkByteData): wordbool; stdcall;
  TCkSFtp_WriteFileBytesAsync = function (objHandle: HCkSFtp; handle: PWideChar; byteData: HCkByteData): HCkTask; stdcall;
  TCkSFtp_WriteFileBytes32 = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; data: HCkByteData): wordbool; stdcall;
  TCkSFtp_WriteFileBytes32Async = function (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; data: HCkByteData): HCkTask; stdcall;
  TCkSFtp_WriteFileBytes64 = function (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; data: HCkByteData): wordbool; stdcall;
  TCkSFtp_WriteFileBytes64Async = function (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; data: HCkByteData): HCkTask; stdcall;
  TCkSFtp_WriteFileBytes64s = function (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; data: HCkByteData): wordbool; stdcall;
  TCkSFtp_WriteFileBytes64sAsync = function (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; data: HCkByteData): HCkTask; stdcall;
  TCkSFtp_WriteFileText = function (objHandle: HCkSFtp; handle: PWideChar; charset: PWideChar; textData: PWideChar): wordbool; stdcall;
  TCkSFtp_WriteFileTextAsync = function (objHandle: HCkSFtp; handle: PWideChar; charset: PWideChar; textData: PWideChar): HCkTask; stdcall;
  TCkSFtp_WriteFileText32 = function (objHandle: HCkSFtp; handle: PWideChar; offset32: Integer; charset: PWideChar; textData: PWideChar): wordbool; stdcall;
  TCkSFtp_WriteFileText32Async = function (objHandle: HCkSFtp; handle: PWideChar; offset32: Integer; charset: PWideChar; textData: PWideChar): HCkTask; stdcall;
  TCkSFtp_WriteFileText64 = function (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; charset: PWideChar; textData: PWideChar): wordbool; stdcall;
  TCkSFtp_WriteFileText64Async = function (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; charset: PWideChar; textData: PWideChar): HCkTask; stdcall;
  TCkSFtp_WriteFileText64s = function (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; charset: PWideChar; textData: PWideChar): wordbool; stdcall;
  TCkSFtp_WriteFileText64sAsync = function (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; charset: PWideChar; textData: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..343] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSFtp_Create : HCkSFtp;
begin
  result := TCkSFtp_Create(_map(0, 'CkSFtp_Create'));
end;

procedure CkSFtp_Dispose (handle: HCkSFtp);
begin
  TCkSFtp_Dispose(_map(1, 'CkSFtp_Dispose'))
    (handle);
end;


procedure CkSFtp_SetAbortCheck (objHandle: HCkSFtp; fn: TSFtpAbortCheck);
begin
    TCkSFtp_SetAbortCheck(_map(2, 'CkSFtp_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSFtp_SetProgressInfo (objHandle: HCkSFtp; fn: TSFtpProgressInfo);
begin
    TCkSFtp_SetProgressInfo(_map(3, 'CkSFtp_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSFtp_SetPercentDone (objHandle: HCkSFtp; fn: TSFtpPercentDone);
begin
    TCkSFtp_SetPercentDone(_map(4, 'CkSFtp_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSFtp_SetTaskCompleted (objHandle: HCkSFtp; fn: TSFtpTaskCompleted);
begin
    TCkSFtp_SetTaskCompleted(_map(5, 'CkSFtp_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkSFtp_getAbortCurrent (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getAbortCurrent(_map(6, 'CkSFtp_getAbortCurrent'))
    (objHandle);
end;

procedure CkSFtp_putAbortCurrent (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putAbortCurrent(_map(7, 'CkSFtp_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkSFtp_getAuthFailReason (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getAuthFailReason(_map(8, 'CkSFtp_getAuthFailReason'))
    (objHandle);
end;

function CkSFtp_getBandwidthThrottleDown (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getBandwidthThrottleDown(_map(9, 'CkSFtp_getBandwidthThrottleDown'))
    (objHandle);
end;

procedure CkSFtp_putBandwidthThrottleDown (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putBandwidthThrottleDown(_map(10, 'CkSFtp_putBandwidthThrottleDown'))
    (objHandle, newPropVal);
end;

function CkSFtp_getBandwidthThrottleUp (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getBandwidthThrottleUp(_map(11, 'CkSFtp_getBandwidthThrottleUp'))
    (objHandle);
end;

procedure CkSFtp_putBandwidthThrottleUp (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putBandwidthThrottleUp(_map(12, 'CkSFtp_putBandwidthThrottleUp'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getClientIdentifier (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getClientIdentifier(_map(13, 'CkSFtp_getClientIdentifier'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putClientIdentifier (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putClientIdentifier(_map(14, 'CkSFtp_putClientIdentifier'))
    (objHandle, newPropVal);
end;

function CkSFtp__clientIdentifier (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__clientIdentifier(_map(15, 'CkSFtp__clientIdentifier'))
    (objHandle);
end;

procedure CkSFtp_getClientIpAddress (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getClientIpAddress(_map(16, 'CkSFtp_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putClientIpAddress (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putClientIpAddress(_map(17, 'CkSFtp_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkSFtp__clientIpAddress (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__clientIpAddress(_map(18, 'CkSFtp__clientIpAddress'))
    (objHandle);
end;

function CkSFtp_getConnectTimeoutMs (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getConnectTimeoutMs(_map(19, 'CkSFtp_getConnectTimeoutMs'))
    (objHandle);
end;

procedure CkSFtp_putConnectTimeoutMs (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putConnectTimeoutMs(_map(20, 'CkSFtp_putConnectTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getDebugLogFilePath (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getDebugLogFilePath(_map(21, 'CkSFtp_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putDebugLogFilePath (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putDebugLogFilePath(_map(22, 'CkSFtp_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSFtp__debugLogFilePath (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__debugLogFilePath(_map(23, 'CkSFtp__debugLogFilePath'))
    (objHandle);
end;

function CkSFtp_getDisconnectCode (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getDisconnectCode(_map(24, 'CkSFtp_getDisconnectCode'))
    (objHandle);
end;

procedure CkSFtp_getDisconnectReason (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getDisconnectReason(_map(25, 'CkSFtp_getDisconnectReason'))
    (objHandle, outPropVal);
end;

function CkSFtp__disconnectReason (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__disconnectReason(_map(26, 'CkSFtp__disconnectReason'))
    (objHandle);
end;

function CkSFtp_getEnableCache (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getEnableCache(_map(27, 'CkSFtp_getEnableCache'))
    (objHandle);
end;

procedure CkSFtp_putEnableCache (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putEnableCache(_map(28, 'CkSFtp_putEnableCache'))
    (objHandle, newPropVal);
end;

function CkSFtp_getEnableCompression (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getEnableCompression(_map(29, 'CkSFtp_getEnableCompression'))
    (objHandle);
end;

procedure CkSFtp_putEnableCompression (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putEnableCompression(_map(30, 'CkSFtp_putEnableCompression'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getFilenameCharset (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getFilenameCharset(_map(31, 'CkSFtp_getFilenameCharset'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putFilenameCharset (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putFilenameCharset(_map(32, 'CkSFtp_putFilenameCharset'))
    (objHandle, newPropVal);
end;

function CkSFtp__filenameCharset (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__filenameCharset(_map(33, 'CkSFtp__filenameCharset'))
    (objHandle);
end;

procedure CkSFtp_getForceCipher (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getForceCipher(_map(34, 'CkSFtp_getForceCipher'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putForceCipher (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putForceCipher(_map(35, 'CkSFtp_putForceCipher'))
    (objHandle, newPropVal);
end;

function CkSFtp__forceCipher (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__forceCipher(_map(36, 'CkSFtp__forceCipher'))
    (objHandle);
end;

function CkSFtp_getForceV3 (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getForceV3(_map(37, 'CkSFtp_getForceV3'))
    (objHandle);
end;

procedure CkSFtp_putForceV3 (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putForceV3(_map(38, 'CkSFtp_putForceV3'))
    (objHandle, newPropVal);
end;

function CkSFtp_getHeartbeatMs (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getHeartbeatMs(_map(39, 'CkSFtp_getHeartbeatMs'))
    (objHandle);
end;

procedure CkSFtp_putHeartbeatMs (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putHeartbeatMs(_map(40, 'CkSFtp_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getHostKeyAlg (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHostKeyAlg(_map(41, 'CkSFtp_getHostKeyAlg'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putHostKeyAlg (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putHostKeyAlg(_map(42, 'CkSFtp_putHostKeyAlg'))
    (objHandle, newPropVal);
end;

function CkSFtp__hostKeyAlg (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__hostKeyAlg(_map(43, 'CkSFtp__hostKeyAlg'))
    (objHandle);
end;

procedure CkSFtp_getHostKeyFingerprint (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHostKeyFingerprint(_map(44, 'CkSFtp_getHostKeyFingerprint'))
    (objHandle, outPropVal);
end;

function CkSFtp__hostKeyFingerprint (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__hostKeyFingerprint(_map(45, 'CkSFtp__hostKeyFingerprint'))
    (objHandle);
end;

procedure CkSFtp_getHttpProxyAuthMethod (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHttpProxyAuthMethod(_map(46, 'CkSFtp_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putHttpProxyAuthMethod (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putHttpProxyAuthMethod(_map(47, 'CkSFtp_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkSFtp__httpProxyAuthMethod (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__httpProxyAuthMethod(_map(48, 'CkSFtp__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkSFtp_getHttpProxyDomain (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHttpProxyDomain(_map(49, 'CkSFtp_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putHttpProxyDomain (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putHttpProxyDomain(_map(50, 'CkSFtp_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkSFtp__httpProxyDomain (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__httpProxyDomain(_map(51, 'CkSFtp__httpProxyDomain'))
    (objHandle);
end;

procedure CkSFtp_getHttpProxyHostname (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHttpProxyHostname(_map(52, 'CkSFtp_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putHttpProxyHostname (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putHttpProxyHostname(_map(53, 'CkSFtp_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkSFtp__httpProxyHostname (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__httpProxyHostname(_map(54, 'CkSFtp__httpProxyHostname'))
    (objHandle);
end;

procedure CkSFtp_getHttpProxyPassword (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHttpProxyPassword(_map(55, 'CkSFtp_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putHttpProxyPassword (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putHttpProxyPassword(_map(56, 'CkSFtp_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkSFtp__httpProxyPassword (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__httpProxyPassword(_map(57, 'CkSFtp__httpProxyPassword'))
    (objHandle);
end;

function CkSFtp_getHttpProxyPort (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getHttpProxyPort(_map(58, 'CkSFtp_getHttpProxyPort'))
    (objHandle);
end;

procedure CkSFtp_putHttpProxyPort (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putHttpProxyPort(_map(59, 'CkSFtp_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getHttpProxyUsername (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getHttpProxyUsername(_map(60, 'CkSFtp_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putHttpProxyUsername (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putHttpProxyUsername(_map(61, 'CkSFtp_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkSFtp__httpProxyUsername (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__httpProxyUsername(_map(62, 'CkSFtp__httpProxyUsername'))
    (objHandle);
end;

function CkSFtp_getIdleTimeoutMs (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getIdleTimeoutMs(_map(63, 'CkSFtp_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkSFtp_putIdleTimeoutMs (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putIdleTimeoutMs(_map(64, 'CkSFtp_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

function CkSFtp_getIncludeDotDirs (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getIncludeDotDirs(_map(65, 'CkSFtp_getIncludeDotDirs'))
    (objHandle);
end;

procedure CkSFtp_putIncludeDotDirs (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putIncludeDotDirs(_map(66, 'CkSFtp_putIncludeDotDirs'))
    (objHandle, newPropVal);
end;

function CkSFtp_getInitializeFailCode (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getInitializeFailCode(_map(67, 'CkSFtp_getInitializeFailCode'))
    (objHandle);
end;

procedure CkSFtp_getInitializeFailReason (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getInitializeFailReason(_map(68, 'CkSFtp_getInitializeFailReason'))
    (objHandle, outPropVal);
end;

function CkSFtp__initializeFailReason (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__initializeFailReason(_map(69, 'CkSFtp__initializeFailReason'))
    (objHandle);
end;

function CkSFtp_getIsConnected (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getIsConnected(_map(70, 'CkSFtp_getIsConnected'))
    (objHandle);
end;

function CkSFtp_getKeepSessionLog (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getKeepSessionLog(_map(71, 'CkSFtp_getKeepSessionLog'))
    (objHandle);
end;

procedure CkSFtp_putKeepSessionLog (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putKeepSessionLog(_map(72, 'CkSFtp_putKeepSessionLog'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getLastErrorHtml (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getLastErrorHtml(_map(73, 'CkSFtp_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSFtp__lastErrorHtml (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__lastErrorHtml(_map(74, 'CkSFtp__lastErrorHtml'))
    (objHandle);
end;

procedure CkSFtp_getLastErrorText (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getLastErrorText(_map(75, 'CkSFtp_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSFtp__lastErrorText (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__lastErrorText(_map(76, 'CkSFtp__lastErrorText'))
    (objHandle);
end;

procedure CkSFtp_getLastErrorXml (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getLastErrorXml(_map(77, 'CkSFtp_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSFtp__lastErrorXml (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__lastErrorXml(_map(78, 'CkSFtp__lastErrorXml'))
    (objHandle);
end;

function CkSFtp_getLastMethodSuccess (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getLastMethodSuccess(_map(79, 'CkSFtp_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSFtp_putLastMethodSuccess (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putLastMethodSuccess(_map(80, 'CkSFtp_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkSFtp_getLastStatusCode (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getLastStatusCode(_map(81, 'CkSFtp_getLastStatusCode'))
    (objHandle);
end;

procedure CkSFtp_getLastStatusMessage (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getLastStatusMessage(_map(82, 'CkSFtp_getLastStatusMessage'))
    (objHandle, outPropVal);
end;

function CkSFtp__lastStatusMessage (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__lastStatusMessage(_map(83, 'CkSFtp__lastStatusMessage'))
    (objHandle);
end;

function CkSFtp_getMaxPacketSize (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getMaxPacketSize(_map(84, 'CkSFtp_getMaxPacketSize'))
    (objHandle);
end;

procedure CkSFtp_putMaxPacketSize (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putMaxPacketSize(_map(85, 'CkSFtp_putMaxPacketSize'))
    (objHandle, newPropVal);
end;

function CkSFtp_getPasswordChangeRequested (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getPasswordChangeRequested(_map(86, 'CkSFtp_getPasswordChangeRequested'))
    (objHandle);
end;

function CkSFtp_getPercentDoneScale (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getPercentDoneScale(_map(87, 'CkSFtp_getPercentDoneScale'))
    (objHandle);
end;

procedure CkSFtp_putPercentDoneScale (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putPercentDoneScale(_map(88, 'CkSFtp_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkSFtp_getPreferIpv6 (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getPreferIpv6(_map(89, 'CkSFtp_getPreferIpv6'))
    (objHandle);
end;

procedure CkSFtp_putPreferIpv6 (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putPreferIpv6(_map(90, 'CkSFtp_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkSFtp_getPreserveDate (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getPreserveDate(_map(91, 'CkSFtp_getPreserveDate'))
    (objHandle);
end;

procedure CkSFtp_putPreserveDate (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putPreserveDate(_map(92, 'CkSFtp_putPreserveDate'))
    (objHandle, newPropVal);
end;

function CkSFtp_getProtocolVersion (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getProtocolVersion(_map(93, 'CkSFtp_getProtocolVersion'))
    (objHandle);
end;

procedure CkSFtp_getReadDirMustMatch (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getReadDirMustMatch(_map(94, 'CkSFtp_getReadDirMustMatch'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putReadDirMustMatch (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putReadDirMustMatch(_map(95, 'CkSFtp_putReadDirMustMatch'))
    (objHandle, newPropVal);
end;

function CkSFtp__readDirMustMatch (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__readDirMustMatch(_map(96, 'CkSFtp__readDirMustMatch'))
    (objHandle);
end;

procedure CkSFtp_getReadDirMustNotMatch (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getReadDirMustNotMatch(_map(97, 'CkSFtp_getReadDirMustNotMatch'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putReadDirMustNotMatch (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putReadDirMustNotMatch(_map(98, 'CkSFtp_putReadDirMustNotMatch'))
    (objHandle, newPropVal);
end;

function CkSFtp__readDirMustNotMatch (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__readDirMustNotMatch(_map(99, 'CkSFtp__readDirMustNotMatch'))
    (objHandle);
end;

procedure CkSFtp_getServerIdentifier (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getServerIdentifier(_map(100, 'CkSFtp_getServerIdentifier'))
    (objHandle, outPropVal);
end;

function CkSFtp__serverIdentifier (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__serverIdentifier(_map(101, 'CkSFtp__serverIdentifier'))
    (objHandle);
end;

procedure CkSFtp_getSessionLog (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSessionLog(_map(102, 'CkSFtp_getSessionLog'))
    (objHandle, outPropVal);
end;

function CkSFtp__sessionLog (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__sessionLog(_map(103, 'CkSFtp__sessionLog'))
    (objHandle);
end;

procedure CkSFtp_getSocksHostname (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSocksHostname(_map(104, 'CkSFtp_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSocksHostname (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSocksHostname(_map(105, 'CkSFtp_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkSFtp__socksHostname (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__socksHostname(_map(106, 'CkSFtp__socksHostname'))
    (objHandle);
end;

procedure CkSFtp_getSocksPassword (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSocksPassword(_map(107, 'CkSFtp_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSocksPassword (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSocksPassword(_map(108, 'CkSFtp_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkSFtp__socksPassword (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__socksPassword(_map(109, 'CkSFtp__socksPassword'))
    (objHandle);
end;

function CkSFtp_getSocksPort (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getSocksPort(_map(110, 'CkSFtp_getSocksPort'))
    (objHandle);
end;

procedure CkSFtp_putSocksPort (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putSocksPort(_map(111, 'CkSFtp_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getSocksUsername (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSocksUsername(_map(112, 'CkSFtp_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSocksUsername (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSocksUsername(_map(113, 'CkSFtp_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkSFtp__socksUsername (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__socksUsername(_map(114, 'CkSFtp__socksUsername'))
    (objHandle);
end;

function CkSFtp_getSocksVersion (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getSocksVersion(_map(115, 'CkSFtp_getSocksVersion'))
    (objHandle);
end;

procedure CkSFtp_putSocksVersion (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putSocksVersion(_map(116, 'CkSFtp_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkSFtp_getSoRcvBuf (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getSoRcvBuf(_map(117, 'CkSFtp_getSoRcvBuf'))
    (objHandle);
end;

procedure CkSFtp_putSoRcvBuf (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putSoRcvBuf(_map(118, 'CkSFtp_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkSFtp_getSoSndBuf (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getSoSndBuf(_map(119, 'CkSFtp_getSoSndBuf'))
    (objHandle);
end;

procedure CkSFtp_putSoSndBuf (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putSoSndBuf(_map(120, 'CkSFtp_putSoSndBuf'))
    (objHandle, newPropVal);
end;

function CkSFtp_getSyncCreateAllLocalDirs (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getSyncCreateAllLocalDirs(_map(121, 'CkSFtp_getSyncCreateAllLocalDirs'))
    (objHandle);
end;

procedure CkSFtp_putSyncCreateAllLocalDirs (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putSyncCreateAllLocalDirs(_map(122, 'CkSFtp_putSyncCreateAllLocalDirs'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getSyncDirectives (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSyncDirectives(_map(123, 'CkSFtp_getSyncDirectives'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSyncDirectives (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSyncDirectives(_map(124, 'CkSFtp_putSyncDirectives'))
    (objHandle, newPropVal);
end;

function CkSFtp__syncDirectives (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__syncDirectives(_map(125, 'CkSFtp__syncDirectives'))
    (objHandle);
end;

procedure CkSFtp_getSyncMustMatch (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSyncMustMatch(_map(126, 'CkSFtp_getSyncMustMatch'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSyncMustMatch (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSyncMustMatch(_map(127, 'CkSFtp_putSyncMustMatch'))
    (objHandle, newPropVal);
end;

function CkSFtp__syncMustMatch (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__syncMustMatch(_map(128, 'CkSFtp__syncMustMatch'))
    (objHandle);
end;

procedure CkSFtp_getSyncMustMatchDir (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSyncMustMatchDir(_map(129, 'CkSFtp_getSyncMustMatchDir'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSyncMustMatchDir (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSyncMustMatchDir(_map(130, 'CkSFtp_putSyncMustMatchDir'))
    (objHandle, newPropVal);
end;

function CkSFtp__syncMustMatchDir (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__syncMustMatchDir(_map(131, 'CkSFtp__syncMustMatchDir'))
    (objHandle);
end;

procedure CkSFtp_getSyncMustNotMatch (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSyncMustNotMatch(_map(132, 'CkSFtp_getSyncMustNotMatch'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSyncMustNotMatch (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSyncMustNotMatch(_map(133, 'CkSFtp_putSyncMustNotMatch'))
    (objHandle, newPropVal);
end;

function CkSFtp__syncMustNotMatch (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__syncMustNotMatch(_map(134, 'CkSFtp__syncMustNotMatch'))
    (objHandle);
end;

procedure CkSFtp_getSyncMustNotMatchDir (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getSyncMustNotMatchDir(_map(135, 'CkSFtp_getSyncMustNotMatchDir'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putSyncMustNotMatchDir (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putSyncMustNotMatchDir(_map(136, 'CkSFtp_putSyncMustNotMatchDir'))
    (objHandle, newPropVal);
end;

function CkSFtp__syncMustNotMatchDir (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__syncMustNotMatchDir(_map(137, 'CkSFtp__syncMustNotMatchDir'))
    (objHandle);
end;

function CkSFtp_getTcpNoDelay (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getTcpNoDelay(_map(138, 'CkSFtp_getTcpNoDelay'))
    (objHandle);
end;

procedure CkSFtp_putTcpNoDelay (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putTcpNoDelay(_map(139, 'CkSFtp_putTcpNoDelay'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getUncommonOptions (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getUncommonOptions(_map(140, 'CkSFtp_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putUncommonOptions (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putUncommonOptions(_map(141, 'CkSFtp_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkSFtp__uncommonOptions (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__uncommonOptions(_map(142, 'CkSFtp__uncommonOptions'))
    (objHandle);
end;

function CkSFtp_getUploadChunkSize (objHandle: HCkSFtp): Integer;
begin
    result := TCkSFtp_getUploadChunkSize(_map(143, 'CkSFtp_getUploadChunkSize'))
    (objHandle);
end;

procedure CkSFtp_putUploadChunkSize (objHandle: HCkSFtp; newPropVal: Integer);
begin
  TCkSFtp_putUploadChunkSize(_map(144, 'CkSFtp_putUploadChunkSize'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getUserAuthBanner (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getUserAuthBanner(_map(145, 'CkSFtp_getUserAuthBanner'))
    (objHandle, outPropVal);
end;

procedure CkSFtp_putUserAuthBanner (objHandle: HCkSFtp; newPropVal: PWideChar);
begin
  TCkSFtp_putUserAuthBanner(_map(146, 'CkSFtp_putUserAuthBanner'))
    (objHandle, newPropVal);
end;

function CkSFtp__userAuthBanner (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__userAuthBanner(_map(147, 'CkSFtp__userAuthBanner'))
    (objHandle);
end;

function CkSFtp_getUtcMode (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getUtcMode(_map(148, 'CkSFtp_getUtcMode'))
    (objHandle);
end;

procedure CkSFtp_putUtcMode (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putUtcMode(_map(149, 'CkSFtp_putUtcMode'))
    (objHandle, newPropVal);
end;

function CkSFtp_getVerboseLogging (objHandle: HCkSFtp): wordbool;
begin
    result := TCkSFtp_getVerboseLogging(_map(150, 'CkSFtp_getVerboseLogging'))
    (objHandle);
end;

procedure CkSFtp_putVerboseLogging (objHandle: HCkSFtp; newPropVal: wordbool);
begin
  TCkSFtp_putVerboseLogging(_map(151, 'CkSFtp_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSFtp_getVersion (objHandle: HCkSFtp; outPropVal: HCkString);
begin
  TCkSFtp_getVersion(_map(152, 'CkSFtp_getVersion'))
    (objHandle, outPropVal);
end;

function CkSFtp__version (objHandle: HCkSFtp): PWideChar;
begin
  result := TCkSFtp__version(_map(153, 'CkSFtp__version'))
    (objHandle);
end;

function CkSFtp_getXferByteCount (objHandle: HCkSFtp): LongWord;
begin
    result := TCkSFtp_getXferByteCount(_map(154, 'CkSFtp_getXferByteCount'))
    (objHandle);
end;

function CkSFtp_getXferByteCount64 (objHandle: HCkSFtp): Int64;
begin
    result := TCkSFtp_getXferByteCount64(_map(155, 'CkSFtp_getXferByteCount64'))
    (objHandle);
end;

function CkSFtp_AccumulateBytes (objHandle: HCkSFtp; handle: PWideChar; maxBytes: Integer): Integer;
begin
  result := TCkSFtp_AccumulateBytes(_map(156, 'CkSFtp_AccumulateBytes'))
    (objHandle, handle, maxBytes);
end;

function CkSFtp_AccumulateBytesAsync (objHandle: HCkSFtp; handle: PWideChar; maxBytes: Integer): HCkTask;
begin
  result := TCkSFtp_AccumulateBytesAsync(_map(157, 'CkSFtp_AccumulateBytesAsync'))
    (objHandle, handle, maxBytes);
end;

function CkSFtp_Add64 (objHandle: HCkSFtp; n1: PWideChar; n2: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_Add64(_map(158, 'CkSFtp_Add64'))
    (objHandle, n1, n2, outStr);
end;

function CkSFtp__add64 (objHandle: HCkSFtp; n1: PWideChar; n2: PWideChar): PWideChar;
begin
  result := TCkSFtp__add64(_map(159, 'CkSFtp__add64'))
    (objHandle, n1, n2);
end;

function CkSFtp_AuthenticatePk (objHandle: HCkSFtp; username: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSFtp_AuthenticatePk(_map(160, 'CkSFtp_AuthenticatePk'))
    (objHandle, username, privateKey);
end;

function CkSFtp_AuthenticatePkAsync (objHandle: HCkSFtp; username: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSFtp_AuthenticatePkAsync(_map(161, 'CkSFtp_AuthenticatePkAsync'))
    (objHandle, username, privateKey);
end;

function CkSFtp_AuthenticatePw (objHandle: HCkSFtp; login: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkSFtp_AuthenticatePw(_map(162, 'CkSFtp_AuthenticatePw'))
    (objHandle, login, password);
end;

function CkSFtp_AuthenticatePwAsync (objHandle: HCkSFtp; login: PWideChar; password: PWideChar): HCkTask;
begin
  result := TCkSFtp_AuthenticatePwAsync(_map(163, 'CkSFtp_AuthenticatePwAsync'))
    (objHandle, login, password);
end;

function CkSFtp_AuthenticatePwPk (objHandle: HCkSFtp; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSFtp_AuthenticatePwPk(_map(164, 'CkSFtp_AuthenticatePwPk'))
    (objHandle, username, password, privateKey);
end;

function CkSFtp_AuthenticatePwPkAsync (objHandle: HCkSFtp; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSFtp_AuthenticatePwPkAsync(_map(165, 'CkSFtp_AuthenticatePwPkAsync'))
    (objHandle, username, password, privateKey);
end;

function CkSFtp_AuthenticateSecPw (objHandle: HCkSFtp; login: HCkSecureString; password: HCkSecureString): wordbool;
begin
  result := TCkSFtp_AuthenticateSecPw(_map(166, 'CkSFtp_AuthenticateSecPw'))
    (objHandle, login, password);
end;

function CkSFtp_AuthenticateSecPwAsync (objHandle: HCkSFtp; login: HCkSecureString; password: HCkSecureString): HCkTask;
begin
  result := TCkSFtp_AuthenticateSecPwAsync(_map(167, 'CkSFtp_AuthenticateSecPwAsync'))
    (objHandle, login, password);
end;

function CkSFtp_AuthenticateSecPwPk (objHandle: HCkSFtp; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSFtp_AuthenticateSecPwPk(_map(168, 'CkSFtp_AuthenticateSecPwPk'))
    (objHandle, username, password, privateKey);
end;

function CkSFtp_AuthenticateSecPwPkAsync (objHandle: HCkSFtp; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSFtp_AuthenticateSecPwPkAsync(_map(169, 'CkSFtp_AuthenticateSecPwPkAsync'))
    (objHandle, username, password, privateKey);
end;

procedure CkSFtp_ClearAccumulateBuffer (objHandle: HCkSFtp);
begin
  TCkSFtp_ClearAccumulateBuffer(_map(170, 'CkSFtp_ClearAccumulateBuffer'))
    (objHandle);
end;

procedure CkSFtp_ClearCache (objHandle: HCkSFtp);
begin
  TCkSFtp_ClearCache(_map(171, 'CkSFtp_ClearCache'))
    (objHandle);
end;

procedure CkSFtp_ClearSessionLog (objHandle: HCkSFtp);
begin
  TCkSFtp_ClearSessionLog(_map(172, 'CkSFtp_ClearSessionLog'))
    (objHandle);
end;

function CkSFtp_CloseHandle (objHandle: HCkSFtp; handle: PWideChar): wordbool;
begin
  result := TCkSFtp_CloseHandle(_map(173, 'CkSFtp_CloseHandle'))
    (objHandle, handle);
end;

function CkSFtp_CloseHandleAsync (objHandle: HCkSFtp; handle: PWideChar): HCkTask;
begin
  result := TCkSFtp_CloseHandleAsync(_map(174, 'CkSFtp_CloseHandleAsync'))
    (objHandle, handle);
end;

function CkSFtp_Connect (objHandle: HCkSFtp; domainName: PWideChar; port: Integer): wordbool;
begin
  result := TCkSFtp_Connect(_map(175, 'CkSFtp_Connect'))
    (objHandle, domainName, port);
end;

function CkSFtp_ConnectAsync (objHandle: HCkSFtp; domainName: PWideChar; port: Integer): HCkTask;
begin
  result := TCkSFtp_ConnectAsync(_map(176, 'CkSFtp_ConnectAsync'))
    (objHandle, domainName, port);
end;

function CkSFtp_ConnectThroughSsh (objHandle: HCkSFtp; sshConn: HCkSsh; hostname: PWideChar; port: Integer): wordbool;
begin
  result := TCkSFtp_ConnectThroughSsh(_map(177, 'CkSFtp_ConnectThroughSsh'))
    (objHandle, sshConn, hostname, port);
end;

function CkSFtp_ConnectThroughSshAsync (objHandle: HCkSFtp; sshConn: HCkSsh; hostname: PWideChar; port: Integer): HCkTask;
begin
  result := TCkSFtp_ConnectThroughSshAsync(_map(178, 'CkSFtp_ConnectThroughSshAsync'))
    (objHandle, sshConn, hostname, port);
end;

function CkSFtp_ContinueKeyboardAuth (objHandle: HCkSFtp; response: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_ContinueKeyboardAuth(_map(179, 'CkSFtp_ContinueKeyboardAuth'))
    (objHandle, response, outStr);
end;

function CkSFtp__continueKeyboardAuth (objHandle: HCkSFtp; response: PWideChar): PWideChar;
begin
  result := TCkSFtp__continueKeyboardAuth(_map(180, 'CkSFtp__continueKeyboardAuth'))
    (objHandle, response);
end;

function CkSFtp_ContinueKeyboardAuthAsync (objHandle: HCkSFtp; response: PWideChar): HCkTask;
begin
  result := TCkSFtp_ContinueKeyboardAuthAsync(_map(181, 'CkSFtp_ContinueKeyboardAuthAsync'))
    (objHandle, response);
end;

function CkSFtp_CopyFileAttr (objHandle: HCkSFtp; localFilename: PWideChar; remoteFilename: PWideChar; isHandle: wordbool): wordbool;
begin
  result := TCkSFtp_CopyFileAttr(_map(182, 'CkSFtp_CopyFileAttr'))
    (objHandle, localFilename, remoteFilename, isHandle);
end;

function CkSFtp_CopyFileAttrAsync (objHandle: HCkSFtp; localFilename: PWideChar; remoteFilename: PWideChar; isHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_CopyFileAttrAsync(_map(183, 'CkSFtp_CopyFileAttrAsync'))
    (objHandle, localFilename, remoteFilename, isHandle);
end;

function CkSFtp_CreateDir (objHandle: HCkSFtp; path: PWideChar): wordbool;
begin
  result := TCkSFtp_CreateDir(_map(184, 'CkSFtp_CreateDir'))
    (objHandle, path);
end;

function CkSFtp_CreateDirAsync (objHandle: HCkSFtp; path: PWideChar): HCkTask;
begin
  result := TCkSFtp_CreateDirAsync(_map(185, 'CkSFtp_CreateDirAsync'))
    (objHandle, path);
end;

procedure CkSFtp_Disconnect (objHandle: HCkSFtp);
begin
  TCkSFtp_Disconnect(_map(186, 'CkSFtp_Disconnect'))
    (objHandle);
end;

function CkSFtp_DownloadBd (objHandle: HCkSFtp; remoteFilePath: PWideChar; binData: HCkBinData): wordbool;
begin
  result := TCkSFtp_DownloadBd(_map(187, 'CkSFtp_DownloadBd'))
    (objHandle, remoteFilePath, binData);
end;

function CkSFtp_DownloadBdAsync (objHandle: HCkSFtp; remoteFilePath: PWideChar; binData: HCkBinData): HCkTask;
begin
  result := TCkSFtp_DownloadBdAsync(_map(188, 'CkSFtp_DownloadBdAsync'))
    (objHandle, remoteFilePath, binData);
end;

function CkSFtp_DownloadFile (objHandle: HCkSFtp; handle: PWideChar; toFilename: PWideChar): wordbool;
begin
  result := TCkSFtp_DownloadFile(_map(189, 'CkSFtp_DownloadFile'))
    (objHandle, handle, toFilename);
end;

function CkSFtp_DownloadFileAsync (objHandle: HCkSFtp; handle: PWideChar; toFilename: PWideChar): HCkTask;
begin
  result := TCkSFtp_DownloadFileAsync(_map(190, 'CkSFtp_DownloadFileAsync'))
    (objHandle, handle, toFilename);
end;

function CkSFtp_DownloadFileByName (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkSFtp_DownloadFileByName(_map(191, 'CkSFtp_DownloadFileByName'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_DownloadFileByNameAsync (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_DownloadFileByNameAsync(_map(192, 'CkSFtp_DownloadFileByNameAsync'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_DownloadSb (objHandle: HCkSFtp; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSFtp_DownloadSb(_map(193, 'CkSFtp_DownloadSb'))
    (objHandle, remoteFilePath, charset, sb);
end;

function CkSFtp_DownloadSbAsync (objHandle: HCkSFtp; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkSFtp_DownloadSbAsync(_map(194, 'CkSFtp_DownloadSbAsync'))
    (objHandle, remoteFilePath, charset, sb);
end;

function CkSFtp_Eof (objHandle: HCkSFtp; handle: PWideChar): wordbool;
begin
  result := TCkSFtp_Eof(_map(195, 'CkSFtp_Eof'))
    (objHandle, handle);
end;

function CkSFtp_FileExists (objHandle: HCkSFtp; remotePath: PWideChar; followLinks: wordbool): Integer;
begin
  result := TCkSFtp_FileExists(_map(196, 'CkSFtp_FileExists'))
    (objHandle, remotePath, followLinks);
end;

function CkSFtp_FileExistsAsync (objHandle: HCkSFtp; remotePath: PWideChar; followLinks: wordbool): HCkTask;
begin
  result := TCkSFtp_FileExistsAsync(_map(197, 'CkSFtp_FileExistsAsync'))
    (objHandle, remotePath, followLinks);
end;

function CkSFtp_Fsync (objHandle: HCkSFtp; handle: PWideChar): wordbool;
begin
  result := TCkSFtp_Fsync(_map(198, 'CkSFtp_Fsync'))
    (objHandle, handle);
end;

function CkSFtp_FsyncAsync (objHandle: HCkSFtp; handle: PWideChar): HCkTask;
begin
  result := TCkSFtp_FsyncAsync(_map(199, 'CkSFtp_FsyncAsync'))
    (objHandle, handle);
end;

function CkSFtp_GetFileCreateDt (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime;
begin
  result := TCkSFtp_GetFileCreateDt(_map(200, 'CkSFtp_GetFileCreateDt'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileCreateDtAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileCreateDtAsync(_map(201, 'CkSFtp_GetFileCreateDtAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileCreateTimeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetFileCreateTimeStr(_map(202, 'CkSFtp_GetFileCreateTimeStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle, outStr);
end;

function CkSFtp__getFileCreateTimeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
begin
  result := TCkSFtp__getFileCreateTimeStr(_map(203, 'CkSFtp__getFileCreateTimeStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileCreateTimeStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileCreateTimeStrAsync(_map(204, 'CkSFtp_GetFileCreateTimeStrAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileGroup (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetFileGroup(_map(205, 'CkSFtp_GetFileGroup'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle, outStr);
end;

function CkSFtp__getFileGroup (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
begin
  result := TCkSFtp__getFileGroup(_map(206, 'CkSFtp__getFileGroup'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileGroupAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileGroupAsync(_map(207, 'CkSFtp_GetFileGroupAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastAccessDt (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime;
begin
  result := TCkSFtp_GetFileLastAccessDt(_map(208, 'CkSFtp_GetFileLastAccessDt'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastAccessDtAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileLastAccessDtAsync(_map(209, 'CkSFtp_GetFileLastAccessDtAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastAccessStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetFileLastAccessStr(_map(210, 'CkSFtp_GetFileLastAccessStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle, outStr);
end;

function CkSFtp__getFileLastAccessStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
begin
  result := TCkSFtp__getFileLastAccessStr(_map(211, 'CkSFtp__getFileLastAccessStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastAccessStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileLastAccessStrAsync(_map(212, 'CkSFtp_GetFileLastAccessStrAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastModifiedDt (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkDateTime;
begin
  result := TCkSFtp_GetFileLastModifiedDt(_map(213, 'CkSFtp_GetFileLastModifiedDt'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastModifiedDtAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileLastModifiedDtAsync(_map(214, 'CkSFtp_GetFileLastModifiedDtAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastModifiedStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetFileLastModifiedStr(_map(215, 'CkSFtp_GetFileLastModifiedStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle, outStr);
end;

function CkSFtp__getFileLastModifiedStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
begin
  result := TCkSFtp__getFileLastModifiedStr(_map(216, 'CkSFtp__getFileLastModifiedStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileLastModifiedStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileLastModifiedStrAsync(_map(217, 'CkSFtp_GetFileLastModifiedStrAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileOwner (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetFileOwner(_map(218, 'CkSFtp_GetFileOwner'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle, outStr);
end;

function CkSFtp__getFileOwner (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
begin
  result := TCkSFtp__getFileOwner(_map(219, 'CkSFtp__getFileOwner'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileOwnerAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileOwnerAsync(_map(220, 'CkSFtp_GetFileOwnerAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFilePermissions (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Integer;
begin
  result := TCkSFtp_GetFilePermissions(_map(221, 'CkSFtp_GetFilePermissions'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFilePermissionsAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFilePermissionsAsync(_map(222, 'CkSFtp_GetFilePermissionsAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileSize32 (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Integer;
begin
  result := TCkSFtp_GetFileSize32(_map(223, 'CkSFtp_GetFileSize32'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileSize32Async (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileSize32Async(_map(224, 'CkSFtp_GetFileSize32Async'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileSize64 (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): Int64;
begin
  result := TCkSFtp_GetFileSize64(_map(225, 'CkSFtp_GetFileSize64'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileSize64Async (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileSize64Async(_map(226, 'CkSFtp_GetFileSize64Async'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileSizeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetFileSizeStr(_map(227, 'CkSFtp_GetFileSizeStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle, outStr);
end;

function CkSFtp__getFileSizeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): PWideChar;
begin
  result := TCkSFtp__getFileSizeStr(_map(228, 'CkSFtp__getFileSizeStr'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetFileSizeStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bFollowLinks: wordbool; bIsHandle: wordbool): HCkTask;
begin
  result := TCkSFtp_GetFileSizeStrAsync(_map(229, 'CkSFtp_GetFileSizeStrAsync'))
    (objHandle, pathOrHandle, bFollowLinks, bIsHandle);
end;

function CkSFtp_GetHostKeyFP (objHandle: HCkSFtp; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_GetHostKeyFP(_map(230, 'CkSFtp_GetHostKeyFP'))
    (objHandle, hashAlg, includeKeyType, includeHashName, outStr);
end;

function CkSFtp__getHostKeyFP (objHandle: HCkSFtp; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool): PWideChar;
begin
  result := TCkSFtp__getHostKeyFP(_map(231, 'CkSFtp__getHostKeyFP'))
    (objHandle, hashAlg, includeKeyType, includeHashName);
end;

procedure CkSFtp_GetLastJsonData (objHandle: HCkSFtp; json: HCkJsonObject);
begin
  TCkSFtp_GetLastJsonData(_map(232, 'CkSFtp_GetLastJsonData'))
    (objHandle, json);
end;

procedure CkSFtp_GetSyncedFiles (objHandle: HCkSFtp; strTab: HCkStringTable);
begin
  TCkSFtp_GetSyncedFiles(_map(233, 'CkSFtp_GetSyncedFiles'))
    (objHandle, strTab);
end;

function CkSFtp_HardLink (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool;
begin
  result := TCkSFtp_HardLink(_map(234, 'CkSFtp_HardLink'))
    (objHandle, oldPath, newPath);
end;

function CkSFtp_HardLinkAsync (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask;
begin
  result := TCkSFtp_HardLinkAsync(_map(235, 'CkSFtp_HardLinkAsync'))
    (objHandle, oldPath, newPath);
end;

function CkSFtp_InitializeSftp (objHandle: HCkSFtp): wordbool;
begin
  result := TCkSFtp_InitializeSftp(_map(236, 'CkSFtp_InitializeSftp'))
    (objHandle);
end;

function CkSFtp_InitializeSftpAsync (objHandle: HCkSFtp): HCkTask;
begin
  result := TCkSFtp_InitializeSftpAsync(_map(237, 'CkSFtp_InitializeSftpAsync'))
    (objHandle);
end;

function CkSFtp_LastJsonData (objHandle: HCkSFtp): HCkJsonObject;
begin
  result := TCkSFtp_LastJsonData(_map(238, 'CkSFtp_LastJsonData'))
    (objHandle);
end;

function CkSFtp_LastReadFailed (objHandle: HCkSFtp; handle: PWideChar): wordbool;
begin
  result := TCkSFtp_LastReadFailed(_map(239, 'CkSFtp_LastReadFailed'))
    (objHandle, handle);
end;

function CkSFtp_LastReadNumBytes (objHandle: HCkSFtp; handle: PWideChar): Integer;
begin
  result := TCkSFtp_LastReadNumBytes(_map(240, 'CkSFtp_LastReadNumBytes'))
    (objHandle, handle);
end;

function CkSFtp_LoadTaskCaller (objHandle: HCkSFtp; task: HCkTask): wordbool;
begin
  result := TCkSFtp_LoadTaskCaller(_map(241, 'CkSFtp_LoadTaskCaller'))
    (objHandle, task);
end;

function CkSFtp_OpenDir (objHandle: HCkSFtp; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_OpenDir(_map(242, 'CkSFtp_OpenDir'))
    (objHandle, path, outStr);
end;

function CkSFtp__openDir (objHandle: HCkSFtp; path: PWideChar): PWideChar;
begin
  result := TCkSFtp__openDir(_map(243, 'CkSFtp__openDir'))
    (objHandle, path);
end;

function CkSFtp_OpenDirAsync (objHandle: HCkSFtp; path: PWideChar): HCkTask;
begin
  result := TCkSFtp_OpenDirAsync(_map(244, 'CkSFtp_OpenDirAsync'))
    (objHandle, path);
end;

function CkSFtp_OpenFile (objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_OpenFile(_map(245, 'CkSFtp_OpenFile'))
    (objHandle, remotePath, access, createDisposition, outStr);
end;

function CkSFtp__openFile (objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar): PWideChar;
begin
  result := TCkSFtp__openFile(_map(246, 'CkSFtp__openFile'))
    (objHandle, remotePath, access, createDisposition);
end;

function CkSFtp_OpenFileAsync (objHandle: HCkSFtp; remotePath: PWideChar; access: PWideChar; createDisposition: PWideChar): HCkTask;
begin
  result := TCkSFtp_OpenFileAsync(_map(247, 'CkSFtp_OpenFileAsync'))
    (objHandle, remotePath, access, createDisposition);
end;

function CkSFtp_ReadDir (objHandle: HCkSFtp; handle: PWideChar): HCkSFtpDir;
begin
  result := TCkSFtp_ReadDir(_map(248, 'CkSFtp_ReadDir'))
    (objHandle, handle);
end;

function CkSFtp_ReadDirAsync (objHandle: HCkSFtp; handle: PWideChar): HCkTask;
begin
  result := TCkSFtp_ReadDirAsync(_map(249, 'CkSFtp_ReadDirAsync'))
    (objHandle, handle);
end;

function CkSFtp_ReadDirListing (objHandle: HCkSFtp; handle: PWideChar; dirObj: HCkSFtpDir): wordbool;
begin
  result := TCkSFtp_ReadDirListing(_map(250, 'CkSFtp_ReadDirListing'))
    (objHandle, handle, dirObj);
end;

function CkSFtp_ReadDirListingAsync (objHandle: HCkSFtp; handle: PWideChar; dirObj: HCkSFtpDir): HCkTask;
begin
  result := TCkSFtp_ReadDirListingAsync(_map(251, 'CkSFtp_ReadDirListingAsync'))
    (objHandle, handle, dirObj);
end;

function CkSFtp_ReadFileBd (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkSFtp_ReadFileBd(_map(252, 'CkSFtp_ReadFileBd'))
    (objHandle, handle, numBytes, bd);
end;

function CkSFtp_ReadFileBdAsync (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; bd: HCkBinData): HCkTask;
begin
  result := TCkSFtp_ReadFileBdAsync(_map(253, 'CkSFtp_ReadFileBdAsync'))
    (objHandle, handle, numBytes, bd);
end;

function CkSFtp_ReadFileBytes (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSFtp_ReadFileBytes(_map(254, 'CkSFtp_ReadFileBytes'))
    (objHandle, handle, numBytes, outData);
end;

function CkSFtp_ReadFileBytesAsync (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer): HCkTask;
begin
  result := TCkSFtp_ReadFileBytesAsync(_map(255, 'CkSFtp_ReadFileBytesAsync'))
    (objHandle, handle, numBytes);
end;

function CkSFtp_ReadFileBytes32 (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSFtp_ReadFileBytes32(_map(256, 'CkSFtp_ReadFileBytes32'))
    (objHandle, handle, offset, numBytes, outData);
end;

function CkSFtp_ReadFileBytes32Async (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer): HCkTask;
begin
  result := TCkSFtp_ReadFileBytes32Async(_map(257, 'CkSFtp_ReadFileBytes32Async'))
    (objHandle, handle, offset, numBytes);
end;

function CkSFtp_ReadFileBytes64 (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSFtp_ReadFileBytes64(_map(258, 'CkSFtp_ReadFileBytes64'))
    (objHandle, handle, offset, numBytes, outData);
end;

function CkSFtp_ReadFileBytes64Async (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer): HCkTask;
begin
  result := TCkSFtp_ReadFileBytes64Async(_map(259, 'CkSFtp_ReadFileBytes64Async'))
    (objHandle, handle, offset, numBytes);
end;

function CkSFtp_ReadFileBytes64s (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSFtp_ReadFileBytes64s(_map(260, 'CkSFtp_ReadFileBytes64s'))
    (objHandle, handle, offset, numBytes, outData);
end;

function CkSFtp_ReadFileBytes64sAsync (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer): HCkTask;
begin
  result := TCkSFtp_ReadFileBytes64sAsync(_map(261, 'CkSFtp_ReadFileBytes64sAsync'))
    (objHandle, handle, offset, numBytes);
end;

function CkSFtp_ReadFileText (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_ReadFileText(_map(262, 'CkSFtp_ReadFileText'))
    (objHandle, handle, numBytes, charset, outStr);
end;

function CkSFtp__readFileText (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSFtp__readFileText(_map(263, 'CkSFtp__readFileText'))
    (objHandle, handle, numBytes, charset);
end;

function CkSFtp_ReadFileTextAsync (objHandle: HCkSFtp; handle: PWideChar; numBytes: Integer; charset: PWideChar): HCkTask;
begin
  result := TCkSFtp_ReadFileTextAsync(_map(264, 'CkSFtp_ReadFileTextAsync'))
    (objHandle, handle, numBytes, charset);
end;

function CkSFtp_ReadFileText32 (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_ReadFileText32(_map(265, 'CkSFtp_ReadFileText32'))
    (objHandle, handle, offset, numBytes, charset, outStr);
end;

function CkSFtp__readFileText32 (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSFtp__readFileText32(_map(266, 'CkSFtp__readFileText32'))
    (objHandle, handle, offset, numBytes, charset);
end;

function CkSFtp_ReadFileText32Async (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; numBytes: Integer; charset: PWideChar): HCkTask;
begin
  result := TCkSFtp_ReadFileText32Async(_map(267, 'CkSFtp_ReadFileText32Async'))
    (objHandle, handle, offset, numBytes, charset);
end;

function CkSFtp_ReadFileText64 (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_ReadFileText64(_map(268, 'CkSFtp_ReadFileText64'))
    (objHandle, handle, offset, numBytes, charset, outStr);
end;

function CkSFtp__readFileText64 (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSFtp__readFileText64(_map(269, 'CkSFtp__readFileText64'))
    (objHandle, handle, offset, numBytes, charset);
end;

function CkSFtp_ReadFileText64Async (objHandle: HCkSFtp; handle: PWideChar; offset: Int64; numBytes: Integer; charset: PWideChar): HCkTask;
begin
  result := TCkSFtp_ReadFileText64Async(_map(270, 'CkSFtp_ReadFileText64Async'))
    (objHandle, handle, offset, numBytes, charset);
end;

function CkSFtp_ReadFileText64s (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_ReadFileText64s(_map(271, 'CkSFtp_ReadFileText64s'))
    (objHandle, handle, offset, numBytes, charset, outStr);
end;

function CkSFtp__readFileText64s (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSFtp__readFileText64s(_map(272, 'CkSFtp__readFileText64s'))
    (objHandle, handle, offset, numBytes, charset);
end;

function CkSFtp_ReadFileText64sAsync (objHandle: HCkSFtp; handle: PWideChar; offset: PWideChar; numBytes: Integer; charset: PWideChar): HCkTask;
begin
  result := TCkSFtp_ReadFileText64sAsync(_map(273, 'CkSFtp_ReadFileText64sAsync'))
    (objHandle, handle, offset, numBytes, charset);
end;

function CkSFtp_ReadLink (objHandle: HCkSFtp; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_ReadLink(_map(274, 'CkSFtp_ReadLink'))
    (objHandle, path, outStr);
end;

function CkSFtp__readLink (objHandle: HCkSFtp; path: PWideChar): PWideChar;
begin
  result := TCkSFtp__readLink(_map(275, 'CkSFtp__readLink'))
    (objHandle, path);
end;

function CkSFtp_ReadLinkAsync (objHandle: HCkSFtp; path: PWideChar): HCkTask;
begin
  result := TCkSFtp_ReadLinkAsync(_map(276, 'CkSFtp_ReadLinkAsync'))
    (objHandle, path);
end;

function CkSFtp_RealPath (objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_RealPath(_map(277, 'CkSFtp_RealPath'))
    (objHandle, originalPath, composePath, outStr);
end;

function CkSFtp__realPath (objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar): PWideChar;
begin
  result := TCkSFtp__realPath(_map(278, 'CkSFtp__realPath'))
    (objHandle, originalPath, composePath);
end;

function CkSFtp_RealPathAsync (objHandle: HCkSFtp; originalPath: PWideChar; composePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_RealPathAsync(_map(279, 'CkSFtp_RealPathAsync'))
    (objHandle, originalPath, composePath);
end;

function CkSFtp_RemoveDir (objHandle: HCkSFtp; path: PWideChar): wordbool;
begin
  result := TCkSFtp_RemoveDir(_map(280, 'CkSFtp_RemoveDir'))
    (objHandle, path);
end;

function CkSFtp_RemoveDirAsync (objHandle: HCkSFtp; path: PWideChar): HCkTask;
begin
  result := TCkSFtp_RemoveDirAsync(_map(281, 'CkSFtp_RemoveDirAsync'))
    (objHandle, path);
end;

function CkSFtp_RemoveFile (objHandle: HCkSFtp; filename: PWideChar): wordbool;
begin
  result := TCkSFtp_RemoveFile(_map(282, 'CkSFtp_RemoveFile'))
    (objHandle, filename);
end;

function CkSFtp_RemoveFileAsync (objHandle: HCkSFtp; filename: PWideChar): HCkTask;
begin
  result := TCkSFtp_RemoveFileAsync(_map(283, 'CkSFtp_RemoveFileAsync'))
    (objHandle, filename);
end;

function CkSFtp_RenameFileOrDir (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool;
begin
  result := TCkSFtp_RenameFileOrDir(_map(284, 'CkSFtp_RenameFileOrDir'))
    (objHandle, oldPath, newPath);
end;

function CkSFtp_RenameFileOrDirAsync (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask;
begin
  result := TCkSFtp_RenameFileOrDirAsync(_map(285, 'CkSFtp_RenameFileOrDirAsync'))
    (objHandle, oldPath, newPath);
end;

function CkSFtp_ResumeDownloadFileByName (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkSFtp_ResumeDownloadFileByName(_map(286, 'CkSFtp_ResumeDownloadFileByName'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_ResumeDownloadFileByNameAsync (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_ResumeDownloadFileByNameAsync(_map(287, 'CkSFtp_ResumeDownloadFileByNameAsync'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_ResumeUploadFileByName (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkSFtp_ResumeUploadFileByName(_map(288, 'CkSFtp_ResumeUploadFileByName'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_ResumeUploadFileByNameAsync (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_ResumeUploadFileByNameAsync(_map(289, 'CkSFtp_ResumeUploadFileByNameAsync'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_SendIgnore (objHandle: HCkSFtp): wordbool;
begin
  result := TCkSFtp_SendIgnore(_map(290, 'CkSFtp_SendIgnore'))
    (objHandle);
end;

function CkSFtp_SendIgnoreAsync (objHandle: HCkSFtp): HCkTask;
begin
  result := TCkSFtp_SendIgnoreAsync(_map(291, 'CkSFtp_SendIgnoreAsync'))
    (objHandle);
end;

function CkSFtp_SetAllowedAlgorithms (objHandle: HCkSFtp; json: HCkJsonObject): wordbool;
begin
  result := TCkSFtp_SetAllowedAlgorithms(_map(292, 'CkSFtp_SetAllowedAlgorithms'))
    (objHandle, json);
end;

function CkSFtp_SetCreateDt (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; createDateTime: HCkDateTime): wordbool;
begin
  result := TCkSFtp_SetCreateDt(_map(293, 'CkSFtp_SetCreateDt'))
    (objHandle, pathOrHandle, isHandle, createDateTime);
end;

function CkSFtp_SetCreateDtAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; createDateTime: HCkDateTime): HCkTask;
begin
  result := TCkSFtp_SetCreateDtAsync(_map(294, 'CkSFtp_SetCreateDtAsync'))
    (objHandle, pathOrHandle, isHandle, createDateTime);
end;

function CkSFtp_SetCreateTimeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool;
begin
  result := TCkSFtp_SetCreateTimeStr(_map(295, 'CkSFtp_SetCreateTimeStr'))
    (objHandle, pathOrHandle, bIsHandle, dateTimeStr);
end;

function CkSFtp_SetCreateTimeStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask;
begin
  result := TCkSFtp_SetCreateTimeStrAsync(_map(296, 'CkSFtp_SetCreateTimeStrAsync'))
    (objHandle, pathOrHandle, bIsHandle, dateTimeStr);
end;

function CkSFtp_SetLastAccessDt (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; accessDateTime: HCkDateTime): wordbool;
begin
  result := TCkSFtp_SetLastAccessDt(_map(297, 'CkSFtp_SetLastAccessDt'))
    (objHandle, pathOrHandle, isHandle, accessDateTime);
end;

function CkSFtp_SetLastAccessDtAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; accessDateTime: HCkDateTime): HCkTask;
begin
  result := TCkSFtp_SetLastAccessDtAsync(_map(298, 'CkSFtp_SetLastAccessDtAsync'))
    (objHandle, pathOrHandle, isHandle, accessDateTime);
end;

function CkSFtp_SetLastAccessTimeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool;
begin
  result := TCkSFtp_SetLastAccessTimeStr(_map(299, 'CkSFtp_SetLastAccessTimeStr'))
    (objHandle, pathOrHandle, bIsHandle, dateTimeStr);
end;

function CkSFtp_SetLastAccessTimeStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask;
begin
  result := TCkSFtp_SetLastAccessTimeStrAsync(_map(300, 'CkSFtp_SetLastAccessTimeStrAsync'))
    (objHandle, pathOrHandle, bIsHandle, dateTimeStr);
end;

function CkSFtp_SetLastModifiedDt (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; modifiedDateTime: HCkDateTime): wordbool;
begin
  result := TCkSFtp_SetLastModifiedDt(_map(301, 'CkSFtp_SetLastModifiedDt'))
    (objHandle, pathOrHandle, isHandle, modifiedDateTime);
end;

function CkSFtp_SetLastModifiedDtAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; modifiedDateTime: HCkDateTime): HCkTask;
begin
  result := TCkSFtp_SetLastModifiedDtAsync(_map(302, 'CkSFtp_SetLastModifiedDtAsync'))
    (objHandle, pathOrHandle, isHandle, modifiedDateTime);
end;

function CkSFtp_SetLastModifiedTimeStr (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): wordbool;
begin
  result := TCkSFtp_SetLastModifiedTimeStr(_map(303, 'CkSFtp_SetLastModifiedTimeStr'))
    (objHandle, pathOrHandle, bIsHandle, dateTimeStr);
end;

function CkSFtp_SetLastModifiedTimeStrAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; bIsHandle: wordbool; dateTimeStr: PWideChar): HCkTask;
begin
  result := TCkSFtp_SetLastModifiedTimeStrAsync(_map(304, 'CkSFtp_SetLastModifiedTimeStrAsync'))
    (objHandle, pathOrHandle, bIsHandle, dateTimeStr);
end;

function CkSFtp_SetOwnerAndGroup (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; owner: PWideChar; group: PWideChar): wordbool;
begin
  result := TCkSFtp_SetOwnerAndGroup(_map(305, 'CkSFtp_SetOwnerAndGroup'))
    (objHandle, pathOrHandle, isHandle, owner, group);
end;

function CkSFtp_SetOwnerAndGroupAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; owner: PWideChar; group: PWideChar): HCkTask;
begin
  result := TCkSFtp_SetOwnerAndGroupAsync(_map(306, 'CkSFtp_SetOwnerAndGroupAsync'))
    (objHandle, pathOrHandle, isHandle, owner, group);
end;

function CkSFtp_SetPermissions (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; permissions: Integer): wordbool;
begin
  result := TCkSFtp_SetPermissions(_map(307, 'CkSFtp_SetPermissions'))
    (objHandle, pathOrHandle, isHandle, permissions);
end;

function CkSFtp_SetPermissionsAsync (objHandle: HCkSFtp; pathOrHandle: PWideChar; isHandle: wordbool; permissions: Integer): HCkTask;
begin
  result := TCkSFtp_SetPermissionsAsync(_map(308, 'CkSFtp_SetPermissionsAsync'))
    (objHandle, pathOrHandle, isHandle, permissions);
end;

function CkSFtp_StartKeyboardAuth (objHandle: HCkSFtp; login: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSFtp_StartKeyboardAuth(_map(309, 'CkSFtp_StartKeyboardAuth'))
    (objHandle, login, outStr);
end;

function CkSFtp__startKeyboardAuth (objHandle: HCkSFtp; login: PWideChar): PWideChar;
begin
  result := TCkSFtp__startKeyboardAuth(_map(310, 'CkSFtp__startKeyboardAuth'))
    (objHandle, login);
end;

function CkSFtp_StartKeyboardAuthAsync (objHandle: HCkSFtp; login: PWideChar): HCkTask;
begin
  result := TCkSFtp_StartKeyboardAuthAsync(_map(311, 'CkSFtp_StartKeyboardAuthAsync'))
    (objHandle, login);
end;

function CkSFtp_SymLink (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): wordbool;
begin
  result := TCkSFtp_SymLink(_map(312, 'CkSFtp_SymLink'))
    (objHandle, oldPath, newPath);
end;

function CkSFtp_SymLinkAsync (objHandle: HCkSFtp; oldPath: PWideChar; newPath: PWideChar): HCkTask;
begin
  result := TCkSFtp_SymLinkAsync(_map(313, 'CkSFtp_SymLinkAsync'))
    (objHandle, oldPath, newPath);
end;

function CkSFtp_SyncTreeDownload (objHandle: HCkSFtp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; recurse: wordbool): wordbool;
begin
  result := TCkSFtp_SyncTreeDownload(_map(314, 'CkSFtp_SyncTreeDownload'))
    (objHandle, remoteRoot, localRoot, mode, recurse);
end;

function CkSFtp_SyncTreeDownloadAsync (objHandle: HCkSFtp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; recurse: wordbool): HCkTask;
begin
  result := TCkSFtp_SyncTreeDownloadAsync(_map(315, 'CkSFtp_SyncTreeDownloadAsync'))
    (objHandle, remoteRoot, localRoot, mode, recurse);
end;

function CkSFtp_SyncTreeUpload (objHandle: HCkSFtp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): wordbool;
begin
  result := TCkSFtp_SyncTreeUpload(_map(316, 'CkSFtp_SyncTreeUpload'))
    (objHandle, localBaseDir, remoteBaseDir, mode, bRecurse);
end;

function CkSFtp_SyncTreeUploadAsync (objHandle: HCkSFtp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask;
begin
  result := TCkSFtp_SyncTreeUploadAsync(_map(317, 'CkSFtp_SyncTreeUploadAsync'))
    (objHandle, localBaseDir, remoteBaseDir, mode, bRecurse);
end;

function CkSFtp_UploadBd (objHandle: HCkSFtp; binData: HCkBinData; remoteFilePath: PWideChar): wordbool;
begin
  result := TCkSFtp_UploadBd(_map(318, 'CkSFtp_UploadBd'))
    (objHandle, binData, remoteFilePath);
end;

function CkSFtp_UploadBdAsync (objHandle: HCkSFtp; binData: HCkBinData; remoteFilePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_UploadBdAsync(_map(319, 'CkSFtp_UploadBdAsync'))
    (objHandle, binData, remoteFilePath);
end;

function CkSFtp_UploadFile (objHandle: HCkSFtp; handle: PWideChar; fromLocalFilePath: PWideChar): wordbool;
begin
  result := TCkSFtp_UploadFile(_map(320, 'CkSFtp_UploadFile'))
    (objHandle, handle, fromLocalFilePath);
end;

function CkSFtp_UploadFileAsync (objHandle: HCkSFtp; handle: PWideChar; fromLocalFilePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_UploadFileAsync(_map(321, 'CkSFtp_UploadFileAsync'))
    (objHandle, handle, fromLocalFilePath);
end;

function CkSFtp_UploadFileByName (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkSFtp_UploadFileByName(_map(322, 'CkSFtp_UploadFileByName'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_UploadFileByNameAsync (objHandle: HCkSFtp; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkSFtp_UploadFileByNameAsync(_map(323, 'CkSFtp_UploadFileByNameAsync'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkSFtp_UploadSb (objHandle: HCkSFtp; sb: HCkStringBuilder; remoteFilePath: PWideChar; charset: PWideChar; includeBom: wordbool): wordbool;
begin
  result := TCkSFtp_UploadSb(_map(324, 'CkSFtp_UploadSb'))
    (objHandle, sb, remoteFilePath, charset, includeBom);
end;

function CkSFtp_UploadSbAsync (objHandle: HCkSFtp; sb: HCkStringBuilder; remoteFilePath: PWideChar; charset: PWideChar; includeBom: wordbool): HCkTask;
begin
  result := TCkSFtp_UploadSbAsync(_map(325, 'CkSFtp_UploadSbAsync'))
    (objHandle, sb, remoteFilePath, charset, includeBom);
end;

function CkSFtp_WriteFileBd (objHandle: HCkSFtp; handle: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkSFtp_WriteFileBd(_map(326, 'CkSFtp_WriteFileBd'))
    (objHandle, handle, bd);
end;

function CkSFtp_WriteFileBdAsync (objHandle: HCkSFtp; handle: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkSFtp_WriteFileBdAsync(_map(327, 'CkSFtp_WriteFileBdAsync'))
    (objHandle, handle, bd);
end;

function CkSFtp_WriteFileBytes (objHandle: HCkSFtp; handle: PWideChar; byteData: HCkByteData): wordbool;
begin
  result := TCkSFtp_WriteFileBytes(_map(328, 'CkSFtp_WriteFileBytes'))
    (objHandle, handle, byteData);
end;

function CkSFtp_WriteFileBytesAsync (objHandle: HCkSFtp; handle: PWideChar; byteData: HCkByteData): HCkTask;
begin
  result := TCkSFtp_WriteFileBytesAsync(_map(329, 'CkSFtp_WriteFileBytesAsync'))
    (objHandle, handle, byteData);
end;

function CkSFtp_WriteFileBytes32 (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; data: HCkByteData): wordbool;
begin
  result := TCkSFtp_WriteFileBytes32(_map(330, 'CkSFtp_WriteFileBytes32'))
    (objHandle, handle, offset, data);
end;

function CkSFtp_WriteFileBytes32Async (objHandle: HCkSFtp; handle: PWideChar; offset: Integer; data: HCkByteData): HCkTask;
begin
  result := TCkSFtp_WriteFileBytes32Async(_map(331, 'CkSFtp_WriteFileBytes32Async'))
    (objHandle, handle, offset, data);
end;

function CkSFtp_WriteFileBytes64 (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; data: HCkByteData): wordbool;
begin
  result := TCkSFtp_WriteFileBytes64(_map(332, 'CkSFtp_WriteFileBytes64'))
    (objHandle, handle, offset64, data);
end;

function CkSFtp_WriteFileBytes64Async (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; data: HCkByteData): HCkTask;
begin
  result := TCkSFtp_WriteFileBytes64Async(_map(333, 'CkSFtp_WriteFileBytes64Async'))
    (objHandle, handle, offset64, data);
end;

function CkSFtp_WriteFileBytes64s (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; data: HCkByteData): wordbool;
begin
  result := TCkSFtp_WriteFileBytes64s(_map(334, 'CkSFtp_WriteFileBytes64s'))
    (objHandle, handle, offset64, data);
end;

function CkSFtp_WriteFileBytes64sAsync (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; data: HCkByteData): HCkTask;
begin
  result := TCkSFtp_WriteFileBytes64sAsync(_map(335, 'CkSFtp_WriteFileBytes64sAsync'))
    (objHandle, handle, offset64, data);
end;

function CkSFtp_WriteFileText (objHandle: HCkSFtp; handle: PWideChar; charset: PWideChar; textData: PWideChar): wordbool;
begin
  result := TCkSFtp_WriteFileText(_map(336, 'CkSFtp_WriteFileText'))
    (objHandle, handle, charset, textData);
end;

function CkSFtp_WriteFileTextAsync (objHandle: HCkSFtp; handle: PWideChar; charset: PWideChar; textData: PWideChar): HCkTask;
begin
  result := TCkSFtp_WriteFileTextAsync(_map(337, 'CkSFtp_WriteFileTextAsync'))
    (objHandle, handle, charset, textData);
end;

function CkSFtp_WriteFileText32 (objHandle: HCkSFtp; handle: PWideChar; offset32: Integer; charset: PWideChar; textData: PWideChar): wordbool;
begin
  result := TCkSFtp_WriteFileText32(_map(338, 'CkSFtp_WriteFileText32'))
    (objHandle, handle, offset32, charset, textData);
end;

function CkSFtp_WriteFileText32Async (objHandle: HCkSFtp; handle: PWideChar; offset32: Integer; charset: PWideChar; textData: PWideChar): HCkTask;
begin
  result := TCkSFtp_WriteFileText32Async(_map(339, 'CkSFtp_WriteFileText32Async'))
    (objHandle, handle, offset32, charset, textData);
end;

function CkSFtp_WriteFileText64 (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; charset: PWideChar; textData: PWideChar): wordbool;
begin
  result := TCkSFtp_WriteFileText64(_map(340, 'CkSFtp_WriteFileText64'))
    (objHandle, handle, offset64, charset, textData);
end;

function CkSFtp_WriteFileText64Async (objHandle: HCkSFtp; handle: PWideChar; offset64: Int64; charset: PWideChar; textData: PWideChar): HCkTask;
begin
  result := TCkSFtp_WriteFileText64Async(_map(341, 'CkSFtp_WriteFileText64Async'))
    (objHandle, handle, offset64, charset, textData);
end;

function CkSFtp_WriteFileText64s (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; charset: PWideChar; textData: PWideChar): wordbool;
begin
  result := TCkSFtp_WriteFileText64s(_map(342, 'CkSFtp_WriteFileText64s'))
    (objHandle, handle, offset64, charset, textData);
end;

function CkSFtp_WriteFileText64sAsync (objHandle: HCkSFtp; handle: PWideChar; offset64: PWideChar; charset: PWideChar; textData: PWideChar): HCkTask;
begin
  result := TCkSFtp_WriteFileText64sAsync(_map(343, 'CkSFtp_WriteFileText64sAsync'))
    (objHandle, handle, offset64, charset, textData);
end;

end.
