unit SFtpDir;

interface

type

HCkTask = Pointer;
HCkSFtpFile = Pointer;
HCkSFtpDir = Pointer;
HCkString = Pointer;


function CkSFtpDir_Create: HCkSFtpDir;  stdcall;
procedure CkSFtpDir_Dispose(handle: HCkSFtpDir); stdcall;
procedure CkSFtpDir_getDebugLogFilePath(objHandle: HCkSFtpDir; outPropVal: HCkString);
procedure CkSFtpDir_putDebugLogFilePath(objHandle: HCkSFtpDir; newPropVal: PWideChar);
function CkSFtpDir__debugLogFilePath(objHandle: HCkSFtpDir): PWideChar;
procedure CkSFtpDir_getLastErrorHtml(objHandle: HCkSFtpDir; outPropVal: HCkString);
function CkSFtpDir__lastErrorHtml(objHandle: HCkSFtpDir): PWideChar;
procedure CkSFtpDir_getLastErrorText(objHandle: HCkSFtpDir; outPropVal: HCkString);
function CkSFtpDir__lastErrorText(objHandle: HCkSFtpDir): PWideChar;
procedure CkSFtpDir_getLastErrorXml(objHandle: HCkSFtpDir; outPropVal: HCkString);
function CkSFtpDir__lastErrorXml(objHandle: HCkSFtpDir): PWideChar;
function CkSFtpDir_getLastMethodSuccess(objHandle: HCkSFtpDir): wordbool;
procedure CkSFtpDir_putLastMethodSuccess(objHandle: HCkSFtpDir; newPropVal: wordbool);
function CkSFtpDir_getNumFilesAndDirs(objHandle: HCkSFtpDir): Integer;
procedure CkSFtpDir_getOriginalPath(objHandle: HCkSFtpDir; outPropVal: HCkString);
function CkSFtpDir__originalPath(objHandle: HCkSFtpDir): PWideChar;
function CkSFtpDir_getVerboseLogging(objHandle: HCkSFtpDir): wordbool;
procedure CkSFtpDir_putVerboseLogging(objHandle: HCkSFtpDir; newPropVal: wordbool);
procedure CkSFtpDir_getVersion(objHandle: HCkSFtpDir; outPropVal: HCkString);
function CkSFtpDir__version(objHandle: HCkSFtpDir): PWideChar;
function CkSFtpDir_FileAt(objHandle: HCkSFtpDir; index: Integer; fileObj: HCkSFtpFile): wordbool;
function CkSFtpDir_GetFilename(objHandle: HCkSFtpDir; index: Integer; outStr: HCkString): wordbool;
function CkSFtpDir__getFilename(objHandle: HCkSFtpDir; index: Integer): PWideChar;
function CkSFtpDir_GetFileObject(objHandle: HCkSFtpDir; index: Integer): HCkSFtpFile;
function CkSFtpDir_LoadTaskResult(objHandle: HCkSFtpDir; task: HCkTask): wordbool;
procedure CkSFtpDir_Sort(objHandle: HCkSFtpDir; field: PWideChar; ascending: wordbool);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSFtpDir_Create = function : HCkSFtpDir; stdcall;
  TCkSFtpDir_Dispose = procedure (handle: HCkSFtpDir); stdcall;
  TCkSFtpDir_getDebugLogFilePath = procedure (objHandle: HCkSFtpDir; outPropVal: HCkString); stdcall;
  TCkSFtpDir_putDebugLogFilePath = procedure (objHandle: HCkSFtpDir; newPropVal: PWideChar); stdcall;
  TCkSFtpDir__debugLogFilePath = function (objHandle: HCkSFtpDir): PWideChar; stdcall;
  TCkSFtpDir_getLastErrorHtml = procedure (objHandle: HCkSFtpDir; outPropVal: HCkString); stdcall;
  TCkSFtpDir__lastErrorHtml = function (objHandle: HCkSFtpDir): PWideChar; stdcall;
  TCkSFtpDir_getLastErrorText = procedure (objHandle: HCkSFtpDir; outPropVal: HCkString); stdcall;
  TCkSFtpDir__lastErrorText = function (objHandle: HCkSFtpDir): PWideChar; stdcall;
  TCkSFtpDir_getLastErrorXml = procedure (objHandle: HCkSFtpDir; outPropVal: HCkString); stdcall;
  TCkSFtpDir__lastErrorXml = function (objHandle: HCkSFtpDir): PWideChar; stdcall;
  TCkSFtpDir_getLastMethodSuccess = function (objHandle: HCkSFtpDir): wordbool; stdcall;
  TCkSFtpDir_putLastMethodSuccess = procedure (objHandle: HCkSFtpDir; newPropVal: wordbool); stdcall;
  TCkSFtpDir_getNumFilesAndDirs = function (objHandle: HCkSFtpDir): Integer; stdcall;
  TCkSFtpDir_getOriginalPath = procedure (objHandle: HCkSFtpDir; outPropVal: HCkString); stdcall;
  TCkSFtpDir__originalPath = function (objHandle: HCkSFtpDir): PWideChar; stdcall;
  TCkSFtpDir_getVerboseLogging = function (objHandle: HCkSFtpDir): wordbool; stdcall;
  TCkSFtpDir_putVerboseLogging = procedure (objHandle: HCkSFtpDir; newPropVal: wordbool); stdcall;
  TCkSFtpDir_getVersion = procedure (objHandle: HCkSFtpDir; outPropVal: HCkString); stdcall;
  TCkSFtpDir__version = function (objHandle: HCkSFtpDir): PWideChar; stdcall;
  TCkSFtpDir_FileAt = function (objHandle: HCkSFtpDir; index: Integer; fileObj: HCkSFtpFile): wordbool; stdcall;
  TCkSFtpDir_GetFilename = function (objHandle: HCkSFtpDir; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSFtpDir__getFilename = function (objHandle: HCkSFtpDir; index: Integer): PWideChar; stdcall;
  TCkSFtpDir_GetFileObject = function (objHandle: HCkSFtpDir; index: Integer): HCkSFtpFile; stdcall;
  TCkSFtpDir_LoadTaskResult = function (objHandle: HCkSFtpDir; task: HCkTask): wordbool; stdcall;
  TCkSFtpDir_Sort = procedure (objHandle: HCkSFtpDir; field: PWideChar; ascending: wordbool); stdcall;

var
  _fkt_ptr_arr:   array [0..25] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSFtpDir_Create : HCkSFtpDir;
begin
  result := TCkSFtpDir_Create(_map(0, 'CkSFtpDir_Create'));
end;

procedure CkSFtpDir_Dispose (handle: HCkSFtpDir);
begin
  TCkSFtpDir_Dispose(_map(1, 'CkSFtpDir_Dispose'))
    (handle);
end;


procedure CkSFtpDir_getDebugLogFilePath (objHandle: HCkSFtpDir; outPropVal: HCkString);
begin
  TCkSFtpDir_getDebugLogFilePath(_map(2, 'CkSFtpDir_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSFtpDir_putDebugLogFilePath (objHandle: HCkSFtpDir; newPropVal: PWideChar);
begin
  TCkSFtpDir_putDebugLogFilePath(_map(3, 'CkSFtpDir_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSFtpDir__debugLogFilePath (objHandle: HCkSFtpDir): PWideChar;
begin
  result := TCkSFtpDir__debugLogFilePath(_map(4, 'CkSFtpDir__debugLogFilePath'))
    (objHandle);
end;

procedure CkSFtpDir_getLastErrorHtml (objHandle: HCkSFtpDir; outPropVal: HCkString);
begin
  TCkSFtpDir_getLastErrorHtml(_map(5, 'CkSFtpDir_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSFtpDir__lastErrorHtml (objHandle: HCkSFtpDir): PWideChar;
begin
  result := TCkSFtpDir__lastErrorHtml(_map(6, 'CkSFtpDir__lastErrorHtml'))
    (objHandle);
end;

procedure CkSFtpDir_getLastErrorText (objHandle: HCkSFtpDir; outPropVal: HCkString);
begin
  TCkSFtpDir_getLastErrorText(_map(7, 'CkSFtpDir_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSFtpDir__lastErrorText (objHandle: HCkSFtpDir): PWideChar;
begin
  result := TCkSFtpDir__lastErrorText(_map(8, 'CkSFtpDir__lastErrorText'))
    (objHandle);
end;

procedure CkSFtpDir_getLastErrorXml (objHandle: HCkSFtpDir; outPropVal: HCkString);
begin
  TCkSFtpDir_getLastErrorXml(_map(9, 'CkSFtpDir_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSFtpDir__lastErrorXml (objHandle: HCkSFtpDir): PWideChar;
begin
  result := TCkSFtpDir__lastErrorXml(_map(10, 'CkSFtpDir__lastErrorXml'))
    (objHandle);
end;

function CkSFtpDir_getLastMethodSuccess (objHandle: HCkSFtpDir): wordbool;
begin
    result := TCkSFtpDir_getLastMethodSuccess(_map(11, 'CkSFtpDir_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSFtpDir_putLastMethodSuccess (objHandle: HCkSFtpDir; newPropVal: wordbool);
begin
  TCkSFtpDir_putLastMethodSuccess(_map(12, 'CkSFtpDir_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkSFtpDir_getNumFilesAndDirs (objHandle: HCkSFtpDir): Integer;
begin
    result := TCkSFtpDir_getNumFilesAndDirs(_map(13, 'CkSFtpDir_getNumFilesAndDirs'))
    (objHandle);
end;

procedure CkSFtpDir_getOriginalPath (objHandle: HCkSFtpDir; outPropVal: HCkString);
begin
  TCkSFtpDir_getOriginalPath(_map(14, 'CkSFtpDir_getOriginalPath'))
    (objHandle, outPropVal);
end;

function CkSFtpDir__originalPath (objHandle: HCkSFtpDir): PWideChar;
begin
  result := TCkSFtpDir__originalPath(_map(15, 'CkSFtpDir__originalPath'))
    (objHandle);
end;

function CkSFtpDir_getVerboseLogging (objHandle: HCkSFtpDir): wordbool;
begin
    result := TCkSFtpDir_getVerboseLogging(_map(16, 'CkSFtpDir_getVerboseLogging'))
    (objHandle);
end;

procedure CkSFtpDir_putVerboseLogging (objHandle: HCkSFtpDir; newPropVal: wordbool);
begin
  TCkSFtpDir_putVerboseLogging(_map(17, 'CkSFtpDir_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSFtpDir_getVersion (objHandle: HCkSFtpDir; outPropVal: HCkString);
begin
  TCkSFtpDir_getVersion(_map(18, 'CkSFtpDir_getVersion'))
    (objHandle, outPropVal);
end;

function CkSFtpDir__version (objHandle: HCkSFtpDir): PWideChar;
begin
  result := TCkSFtpDir__version(_map(19, 'CkSFtpDir__version'))
    (objHandle);
end;

function CkSFtpDir_FileAt (objHandle: HCkSFtpDir; index: Integer; fileObj: HCkSFtpFile): wordbool;
begin
  result := TCkSFtpDir_FileAt(_map(20, 'CkSFtpDir_FileAt'))
    (objHandle, index, fileObj);
end;

function CkSFtpDir_GetFilename (objHandle: HCkSFtpDir; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSFtpDir_GetFilename(_map(21, 'CkSFtpDir_GetFilename'))
    (objHandle, index, outStr);
end;

function CkSFtpDir__getFilename (objHandle: HCkSFtpDir; index: Integer): PWideChar;
begin
  result := TCkSFtpDir__getFilename(_map(22, 'CkSFtpDir__getFilename'))
    (objHandle, index);
end;

function CkSFtpDir_GetFileObject (objHandle: HCkSFtpDir; index: Integer): HCkSFtpFile;
begin
  result := TCkSFtpDir_GetFileObject(_map(23, 'CkSFtpDir_GetFileObject'))
    (objHandle, index);
end;

function CkSFtpDir_LoadTaskResult (objHandle: HCkSFtpDir; task: HCkTask): wordbool;
begin
  result := TCkSFtpDir_LoadTaskResult(_map(24, 'CkSFtpDir_LoadTaskResult'))
    (objHandle, task);
end;

procedure CkSFtpDir_Sort (objHandle: HCkSFtpDir; field: PWideChar; ascending: wordbool);
begin
  TCkSFtpDir_Sort(_map(25, 'CkSFtpDir_Sort'))
    (objHandle, field, ascending);
end;

end.
