unit Scp;

interface

type

HCkBinData = Pointer;
HCkSsh = Pointer;
HCkByteData = Pointer;
HCkScp = Pointer;
HCkString = Pointer;
HCkTask = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TScpAbortCheck = function(): Integer; cdecl;
TScpProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TScpPercentDone = function(pctDone: Integer): Integer; cdecl;
TScpTaskCompleted = procedure(task: HCkTask); cdecl;


function CkScp_Create: HCkScp;  stdcall;
procedure CkScp_Dispose(handle: HCkScp); stdcall;

procedure CkScp_SetAbortCheck(objHandle: HCkScp; fn: TScpAbortCheck) stdcall;
procedure CkScp_SetProgressInfo(objHandle: HCkScp; fn: TScpProgressInfo) stdcall;
procedure CkScp_SetPercentDone(objHandle: HCkScp; fn: TScpPercentDone) stdcall;
procedure CkScp_SetTaskCompleted(objHandle: HCkScp; fn: TScpTaskCompleted) stdcall;
function CkScp_getAbortCurrent(objHandle: HCkScp): wordbool;
procedure CkScp_putAbortCurrent(objHandle: HCkScp; newPropVal: wordbool);
procedure CkScp_getDebugLogFilePath(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putDebugLogFilePath(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__debugLogFilePath(objHandle: HCkScp): PWideChar;
function CkScp_getHeartbeatMs(objHandle: HCkScp): Integer;
procedure CkScp_putHeartbeatMs(objHandle: HCkScp; newPropVal: Integer);
procedure CkScp_getLastErrorHtml(objHandle: HCkScp; outPropVal: HCkString);
function CkScp__lastErrorHtml(objHandle: HCkScp): PWideChar;
procedure CkScp_getLastErrorText(objHandle: HCkScp; outPropVal: HCkString);
function CkScp__lastErrorText(objHandle: HCkScp): PWideChar;
procedure CkScp_getLastErrorXml(objHandle: HCkScp; outPropVal: HCkString);
function CkScp__lastErrorXml(objHandle: HCkScp): PWideChar;
function CkScp_getLastMethodSuccess(objHandle: HCkScp): wordbool;
procedure CkScp_putLastMethodSuccess(objHandle: HCkScp; newPropVal: wordbool);
function CkScp_getPercentDoneScale(objHandle: HCkScp): Integer;
procedure CkScp_putPercentDoneScale(objHandle: HCkScp; newPropVal: Integer);
procedure CkScp_getSendEnv(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putSendEnv(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__sendEnv(objHandle: HCkScp): PWideChar;
procedure CkScp_getSyncedFiles(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putSyncedFiles(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__syncedFiles(objHandle: HCkScp): PWideChar;
procedure CkScp_getSyncMustMatch(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putSyncMustMatch(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__syncMustMatch(objHandle: HCkScp): PWideChar;
procedure CkScp_getSyncMustMatchDir(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putSyncMustMatchDir(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__syncMustMatchDir(objHandle: HCkScp): PWideChar;
procedure CkScp_getSyncMustNotMatch(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putSyncMustNotMatch(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__syncMustNotMatch(objHandle: HCkScp): PWideChar;
procedure CkScp_getSyncMustNotMatchDir(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putSyncMustNotMatchDir(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__syncMustNotMatchDir(objHandle: HCkScp): PWideChar;
procedure CkScp_getUncommonOptions(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putUncommonOptions(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__uncommonOptions(objHandle: HCkScp): PWideChar;
procedure CkScp_getUnixPermOverride(objHandle: HCkScp; outPropVal: HCkString);
procedure CkScp_putUnixPermOverride(objHandle: HCkScp; newPropVal: PWideChar);
function CkScp__unixPermOverride(objHandle: HCkScp): PWideChar;
function CkScp_getVerboseLogging(objHandle: HCkScp): wordbool;
procedure CkScp_putVerboseLogging(objHandle: HCkScp; newPropVal: wordbool);
procedure CkScp_getVersion(objHandle: HCkScp; outPropVal: HCkString);
function CkScp__version(objHandle: HCkScp): PWideChar;
function CkScp_DownloadBd(objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): wordbool;
function CkScp_DownloadBdAsync(objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): HCkTask;
function CkScp_DownloadBinary(objHandle: HCkScp; remotePath: PWideChar; outData: HCkByteData): wordbool;
function CkScp_DownloadBinaryAsync(objHandle: HCkScp; remotePath: PWideChar): HCkTask;
function CkScp_DownloadBinaryEncoded(objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkScp__downloadBinaryEncoded(objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar): PWideChar;
function CkScp_DownloadBinaryEncodedAsync(objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar): HCkTask;
function CkScp_DownloadFile(objHandle: HCkScp; remotePath: PWideChar; localPath: PWideChar): wordbool;
function CkScp_DownloadFileAsync(objHandle: HCkScp; remotePath: PWideChar; localPath: PWideChar): HCkTask;
function CkScp_DownloadString(objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkScp__downloadString(objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar): PWideChar;
function CkScp_DownloadStringAsync(objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar): HCkTask;
function CkScp_LoadTaskCaller(objHandle: HCkScp; task: HCkTask): wordbool;
function CkScp_SyncTreeDownload(objHandle: HCkScp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; bRecurse: wordbool): wordbool;
function CkScp_SyncTreeDownloadAsync(objHandle: HCkScp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask;
function CkScp_SyncTreeUpload(objHandle: HCkScp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): wordbool;
function CkScp_SyncTreeUploadAsync(objHandle: HCkScp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask;
function CkScp_UploadBd(objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): wordbool;
function CkScp_UploadBdAsync(objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): HCkTask;
function CkScp_UploadBinary(objHandle: HCkScp; remotePath: PWideChar; binData: HCkByteData): wordbool;
function CkScp_UploadBinaryAsync(objHandle: HCkScp; remotePath: PWideChar; binData: HCkByteData): HCkTask;
function CkScp_UploadBinaryEncoded(objHandle: HCkScp; remotePath: PWideChar; encodedData: PWideChar; encoding: PWideChar): wordbool;
function CkScp_UploadBinaryEncodedAsync(objHandle: HCkScp; remotePath: PWideChar; encodedData: PWideChar; encoding: PWideChar): HCkTask;
function CkScp_UploadFile(objHandle: HCkScp; localPath: PWideChar; remotePath: PWideChar): wordbool;
function CkScp_UploadFileAsync(objHandle: HCkScp; localPath: PWideChar; remotePath: PWideChar): HCkTask;
function CkScp_UploadString(objHandle: HCkScp; remotePath: PWideChar; textData: PWideChar; charset: PWideChar): wordbool;
function CkScp_UploadStringAsync(objHandle: HCkScp; remotePath: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask;
function CkScp_UseSsh(objHandle: HCkScp; sshConnection: HCkSsh): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkScp_Create = function : HCkScp; stdcall;
  TCkScp_Dispose = procedure (handle: HCkScp); stdcall;
  TCkScp_SetAbortCheck = procedure (objHandle: HCkScp; fn: TScpAbortCheck); stdcall;
  TCkScp_SetProgressInfo = procedure (objHandle: HCkScp; fn: TScpProgressInfo); stdcall;
  TCkScp_SetPercentDone = procedure (objHandle: HCkScp; fn: TScpPercentDone); stdcall;
  TCkScp_SetTaskCompleted = procedure (objHandle: HCkScp; fn: TScpTaskCompleted); stdcall;
  TCkScp_getAbortCurrent = function (objHandle: HCkScp): wordbool; stdcall;
  TCkScp_putAbortCurrent = procedure (objHandle: HCkScp; newPropVal: wordbool); stdcall;
  TCkScp_getDebugLogFilePath = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putDebugLogFilePath = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__debugLogFilePath = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getHeartbeatMs = function (objHandle: HCkScp): Integer; stdcall;
  TCkScp_putHeartbeatMs = procedure (objHandle: HCkScp; newPropVal: Integer); stdcall;
  TCkScp_getLastErrorHtml = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp__lastErrorHtml = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getLastErrorText = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp__lastErrorText = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getLastErrorXml = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp__lastErrorXml = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getLastMethodSuccess = function (objHandle: HCkScp): wordbool; stdcall;
  TCkScp_putLastMethodSuccess = procedure (objHandle: HCkScp; newPropVal: wordbool); stdcall;
  TCkScp_getPercentDoneScale = function (objHandle: HCkScp): Integer; stdcall;
  TCkScp_putPercentDoneScale = procedure (objHandle: HCkScp; newPropVal: Integer); stdcall;
  TCkScp_getSendEnv = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putSendEnv = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__sendEnv = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getSyncedFiles = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putSyncedFiles = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__syncedFiles = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getSyncMustMatch = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putSyncMustMatch = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__syncMustMatch = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getSyncMustMatchDir = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putSyncMustMatchDir = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__syncMustMatchDir = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getSyncMustNotMatch = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putSyncMustNotMatch = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__syncMustNotMatch = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getSyncMustNotMatchDir = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putSyncMustNotMatchDir = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__syncMustNotMatchDir = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getUncommonOptions = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putUncommonOptions = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__uncommonOptions = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getUnixPermOverride = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp_putUnixPermOverride = procedure (objHandle: HCkScp; newPropVal: PWideChar); stdcall;
  TCkScp__unixPermOverride = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_getVerboseLogging = function (objHandle: HCkScp): wordbool; stdcall;
  TCkScp_putVerboseLogging = procedure (objHandle: HCkScp; newPropVal: wordbool); stdcall;
  TCkScp_getVersion = procedure (objHandle: HCkScp; outPropVal: HCkString); stdcall;
  TCkScp__version = function (objHandle: HCkScp): PWideChar; stdcall;
  TCkScp_DownloadBd = function (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkScp_DownloadBdAsync = function (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkScp_DownloadBinary = function (objHandle: HCkScp; remotePath: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkScp_DownloadBinaryAsync = function (objHandle: HCkScp; remotePath: PWideChar): HCkTask; stdcall;
  TCkScp_DownloadBinaryEncoded = function (objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkScp__downloadBinaryEncoded = function (objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkScp_DownloadBinaryEncodedAsync = function (objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar): HCkTask; stdcall;
  TCkScp_DownloadFile = function (objHandle: HCkScp; remotePath: PWideChar; localPath: PWideChar): wordbool; stdcall;
  TCkScp_DownloadFileAsync = function (objHandle: HCkScp; remotePath: PWideChar; localPath: PWideChar): HCkTask; stdcall;
  TCkScp_DownloadString = function (objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkScp__downloadString = function (objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkScp_DownloadStringAsync = function (objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkScp_LoadTaskCaller = function (objHandle: HCkScp; task: HCkTask): wordbool; stdcall;
  TCkScp_SyncTreeDownload = function (objHandle: HCkScp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; bRecurse: wordbool): wordbool; stdcall;
  TCkScp_SyncTreeDownloadAsync = function (objHandle: HCkScp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask; stdcall;
  TCkScp_SyncTreeUpload = function (objHandle: HCkScp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): wordbool; stdcall;
  TCkScp_SyncTreeUploadAsync = function (objHandle: HCkScp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask; stdcall;
  TCkScp_UploadBd = function (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkScp_UploadBdAsync = function (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkScp_UploadBinary = function (objHandle: HCkScp; remotePath: PWideChar; binData: HCkByteData): wordbool; stdcall;
  TCkScp_UploadBinaryAsync = function (objHandle: HCkScp; remotePath: PWideChar; binData: HCkByteData): HCkTask; stdcall;
  TCkScp_UploadBinaryEncoded = function (objHandle: HCkScp; remotePath: PWideChar; encodedData: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkScp_UploadBinaryEncodedAsync = function (objHandle: HCkScp; remotePath: PWideChar; encodedData: PWideChar; encoding: PWideChar): HCkTask; stdcall;
  TCkScp_UploadFile = function (objHandle: HCkScp; localPath: PWideChar; remotePath: PWideChar): wordbool; stdcall;
  TCkScp_UploadFileAsync = function (objHandle: HCkScp; localPath: PWideChar; remotePath: PWideChar): HCkTask; stdcall;
  TCkScp_UploadString = function (objHandle: HCkScp; remotePath: PWideChar; textData: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkScp_UploadStringAsync = function (objHandle: HCkScp; remotePath: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkScp_UseSsh = function (objHandle: HCkScp; sshConnection: HCkSsh): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..78] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkScp_Create : HCkScp;
begin
  result := TCkScp_Create(_map(0, 'CkScp_Create'));
end;

procedure CkScp_Dispose (handle: HCkScp);
begin
  TCkScp_Dispose(_map(1, 'CkScp_Dispose'))
    (handle);
end;


procedure CkScp_SetAbortCheck (objHandle: HCkScp; fn: TScpAbortCheck);
begin
    TCkScp_SetAbortCheck(_map(2, 'CkScp_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkScp_SetProgressInfo (objHandle: HCkScp; fn: TScpProgressInfo);
begin
    TCkScp_SetProgressInfo(_map(3, 'CkScp_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkScp_SetPercentDone (objHandle: HCkScp; fn: TScpPercentDone);
begin
    TCkScp_SetPercentDone(_map(4, 'CkScp_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkScp_SetTaskCompleted (objHandle: HCkScp; fn: TScpTaskCompleted);
begin
    TCkScp_SetTaskCompleted(_map(5, 'CkScp_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkScp_getAbortCurrent (objHandle: HCkScp): wordbool;
begin
    result := TCkScp_getAbortCurrent(_map(6, 'CkScp_getAbortCurrent'))
    (objHandle);
end;

procedure CkScp_putAbortCurrent (objHandle: HCkScp; newPropVal: wordbool);
begin
  TCkScp_putAbortCurrent(_map(7, 'CkScp_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkScp_getDebugLogFilePath (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getDebugLogFilePath(_map(8, 'CkScp_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkScp_putDebugLogFilePath (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putDebugLogFilePath(_map(9, 'CkScp_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkScp__debugLogFilePath (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__debugLogFilePath(_map(10, 'CkScp__debugLogFilePath'))
    (objHandle);
end;

function CkScp_getHeartbeatMs (objHandle: HCkScp): Integer;
begin
    result := TCkScp_getHeartbeatMs(_map(11, 'CkScp_getHeartbeatMs'))
    (objHandle);
end;

procedure CkScp_putHeartbeatMs (objHandle: HCkScp; newPropVal: Integer);
begin
  TCkScp_putHeartbeatMs(_map(12, 'CkScp_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkScp_getLastErrorHtml (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getLastErrorHtml(_map(13, 'CkScp_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkScp__lastErrorHtml (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__lastErrorHtml(_map(14, 'CkScp__lastErrorHtml'))
    (objHandle);
end;

procedure CkScp_getLastErrorText (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getLastErrorText(_map(15, 'CkScp_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkScp__lastErrorText (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__lastErrorText(_map(16, 'CkScp__lastErrorText'))
    (objHandle);
end;

procedure CkScp_getLastErrorXml (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getLastErrorXml(_map(17, 'CkScp_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkScp__lastErrorXml (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__lastErrorXml(_map(18, 'CkScp__lastErrorXml'))
    (objHandle);
end;

function CkScp_getLastMethodSuccess (objHandle: HCkScp): wordbool;
begin
    result := TCkScp_getLastMethodSuccess(_map(19, 'CkScp_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkScp_putLastMethodSuccess (objHandle: HCkScp; newPropVal: wordbool);
begin
  TCkScp_putLastMethodSuccess(_map(20, 'CkScp_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkScp_getPercentDoneScale (objHandle: HCkScp): Integer;
begin
    result := TCkScp_getPercentDoneScale(_map(21, 'CkScp_getPercentDoneScale'))
    (objHandle);
end;

procedure CkScp_putPercentDoneScale (objHandle: HCkScp; newPropVal: Integer);
begin
  TCkScp_putPercentDoneScale(_map(22, 'CkScp_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

procedure CkScp_getSendEnv (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getSendEnv(_map(23, 'CkScp_getSendEnv'))
    (objHandle, outPropVal);
end;

procedure CkScp_putSendEnv (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putSendEnv(_map(24, 'CkScp_putSendEnv'))
    (objHandle, newPropVal);
end;

function CkScp__sendEnv (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__sendEnv(_map(25, 'CkScp__sendEnv'))
    (objHandle);
end;

procedure CkScp_getSyncedFiles (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getSyncedFiles(_map(26, 'CkScp_getSyncedFiles'))
    (objHandle, outPropVal);
end;

procedure CkScp_putSyncedFiles (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putSyncedFiles(_map(27, 'CkScp_putSyncedFiles'))
    (objHandle, newPropVal);
end;

function CkScp__syncedFiles (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__syncedFiles(_map(28, 'CkScp__syncedFiles'))
    (objHandle);
end;

procedure CkScp_getSyncMustMatch (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getSyncMustMatch(_map(29, 'CkScp_getSyncMustMatch'))
    (objHandle, outPropVal);
end;

procedure CkScp_putSyncMustMatch (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putSyncMustMatch(_map(30, 'CkScp_putSyncMustMatch'))
    (objHandle, newPropVal);
end;

function CkScp__syncMustMatch (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__syncMustMatch(_map(31, 'CkScp__syncMustMatch'))
    (objHandle);
end;

procedure CkScp_getSyncMustMatchDir (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getSyncMustMatchDir(_map(32, 'CkScp_getSyncMustMatchDir'))
    (objHandle, outPropVal);
end;

procedure CkScp_putSyncMustMatchDir (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putSyncMustMatchDir(_map(33, 'CkScp_putSyncMustMatchDir'))
    (objHandle, newPropVal);
end;

function CkScp__syncMustMatchDir (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__syncMustMatchDir(_map(34, 'CkScp__syncMustMatchDir'))
    (objHandle);
end;

procedure CkScp_getSyncMustNotMatch (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getSyncMustNotMatch(_map(35, 'CkScp_getSyncMustNotMatch'))
    (objHandle, outPropVal);
end;

procedure CkScp_putSyncMustNotMatch (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putSyncMustNotMatch(_map(36, 'CkScp_putSyncMustNotMatch'))
    (objHandle, newPropVal);
end;

function CkScp__syncMustNotMatch (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__syncMustNotMatch(_map(37, 'CkScp__syncMustNotMatch'))
    (objHandle);
end;

procedure CkScp_getSyncMustNotMatchDir (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getSyncMustNotMatchDir(_map(38, 'CkScp_getSyncMustNotMatchDir'))
    (objHandle, outPropVal);
end;

procedure CkScp_putSyncMustNotMatchDir (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putSyncMustNotMatchDir(_map(39, 'CkScp_putSyncMustNotMatchDir'))
    (objHandle, newPropVal);
end;

function CkScp__syncMustNotMatchDir (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__syncMustNotMatchDir(_map(40, 'CkScp__syncMustNotMatchDir'))
    (objHandle);
end;

procedure CkScp_getUncommonOptions (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getUncommonOptions(_map(41, 'CkScp_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkScp_putUncommonOptions (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putUncommonOptions(_map(42, 'CkScp_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkScp__uncommonOptions (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__uncommonOptions(_map(43, 'CkScp__uncommonOptions'))
    (objHandle);
end;

procedure CkScp_getUnixPermOverride (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getUnixPermOverride(_map(44, 'CkScp_getUnixPermOverride'))
    (objHandle, outPropVal);
end;

procedure CkScp_putUnixPermOverride (objHandle: HCkScp; newPropVal: PWideChar);
begin
  TCkScp_putUnixPermOverride(_map(45, 'CkScp_putUnixPermOverride'))
    (objHandle, newPropVal);
end;

function CkScp__unixPermOverride (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__unixPermOverride(_map(46, 'CkScp__unixPermOverride'))
    (objHandle);
end;

function CkScp_getVerboseLogging (objHandle: HCkScp): wordbool;
begin
    result := TCkScp_getVerboseLogging(_map(47, 'CkScp_getVerboseLogging'))
    (objHandle);
end;

procedure CkScp_putVerboseLogging (objHandle: HCkScp; newPropVal: wordbool);
begin
  TCkScp_putVerboseLogging(_map(48, 'CkScp_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkScp_getVersion (objHandle: HCkScp; outPropVal: HCkString);
begin
  TCkScp_getVersion(_map(49, 'CkScp_getVersion'))
    (objHandle, outPropVal);
end;

function CkScp__version (objHandle: HCkScp): PWideChar;
begin
  result := TCkScp__version(_map(50, 'CkScp__version'))
    (objHandle);
end;

function CkScp_DownloadBd (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkScp_DownloadBd(_map(51, 'CkScp_DownloadBd'))
    (objHandle, remotePath, bd);
end;

function CkScp_DownloadBdAsync (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkScp_DownloadBdAsync(_map(52, 'CkScp_DownloadBdAsync'))
    (objHandle, remotePath, bd);
end;

function CkScp_DownloadBinary (objHandle: HCkScp; remotePath: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkScp_DownloadBinary(_map(53, 'CkScp_DownloadBinary'))
    (objHandle, remotePath, outData);
end;

function CkScp_DownloadBinaryAsync (objHandle: HCkScp; remotePath: PWideChar): HCkTask;
begin
  result := TCkScp_DownloadBinaryAsync(_map(54, 'CkScp_DownloadBinaryAsync'))
    (objHandle, remotePath);
end;

function CkScp_DownloadBinaryEncoded (objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkScp_DownloadBinaryEncoded(_map(55, 'CkScp_DownloadBinaryEncoded'))
    (objHandle, remotePath, encoding, outStr);
end;

function CkScp__downloadBinaryEncoded (objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkScp__downloadBinaryEncoded(_map(56, 'CkScp__downloadBinaryEncoded'))
    (objHandle, remotePath, encoding);
end;

function CkScp_DownloadBinaryEncodedAsync (objHandle: HCkScp; remotePath: PWideChar; encoding: PWideChar): HCkTask;
begin
  result := TCkScp_DownloadBinaryEncodedAsync(_map(57, 'CkScp_DownloadBinaryEncodedAsync'))
    (objHandle, remotePath, encoding);
end;

function CkScp_DownloadFile (objHandle: HCkScp; remotePath: PWideChar; localPath: PWideChar): wordbool;
begin
  result := TCkScp_DownloadFile(_map(58, 'CkScp_DownloadFile'))
    (objHandle, remotePath, localPath);
end;

function CkScp_DownloadFileAsync (objHandle: HCkScp; remotePath: PWideChar; localPath: PWideChar): HCkTask;
begin
  result := TCkScp_DownloadFileAsync(_map(59, 'CkScp_DownloadFileAsync'))
    (objHandle, remotePath, localPath);
end;

function CkScp_DownloadString (objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkScp_DownloadString(_map(60, 'CkScp_DownloadString'))
    (objHandle, remotePath, charset, outStr);
end;

function CkScp__downloadString (objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkScp__downloadString(_map(61, 'CkScp__downloadString'))
    (objHandle, remotePath, charset);
end;

function CkScp_DownloadStringAsync (objHandle: HCkScp; remotePath: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkScp_DownloadStringAsync(_map(62, 'CkScp_DownloadStringAsync'))
    (objHandle, remotePath, charset);
end;

function CkScp_LoadTaskCaller (objHandle: HCkScp; task: HCkTask): wordbool;
begin
  result := TCkScp_LoadTaskCaller(_map(63, 'CkScp_LoadTaskCaller'))
    (objHandle, task);
end;

function CkScp_SyncTreeDownload (objHandle: HCkScp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; bRecurse: wordbool): wordbool;
begin
  result := TCkScp_SyncTreeDownload(_map(64, 'CkScp_SyncTreeDownload'))
    (objHandle, remoteRoot, localRoot, mode, bRecurse);
end;

function CkScp_SyncTreeDownloadAsync (objHandle: HCkScp; remoteRoot: PWideChar; localRoot: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask;
begin
  result := TCkScp_SyncTreeDownloadAsync(_map(65, 'CkScp_SyncTreeDownloadAsync'))
    (objHandle, remoteRoot, localRoot, mode, bRecurse);
end;

function CkScp_SyncTreeUpload (objHandle: HCkScp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): wordbool;
begin
  result := TCkScp_SyncTreeUpload(_map(66, 'CkScp_SyncTreeUpload'))
    (objHandle, localBaseDir, remoteBaseDir, mode, bRecurse);
end;

function CkScp_SyncTreeUploadAsync (objHandle: HCkScp; localBaseDir: PWideChar; remoteBaseDir: PWideChar; mode: Integer; bRecurse: wordbool): HCkTask;
begin
  result := TCkScp_SyncTreeUploadAsync(_map(67, 'CkScp_SyncTreeUploadAsync'))
    (objHandle, localBaseDir, remoteBaseDir, mode, bRecurse);
end;

function CkScp_UploadBd (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkScp_UploadBd(_map(68, 'CkScp_UploadBd'))
    (objHandle, remotePath, bd);
end;

function CkScp_UploadBdAsync (objHandle: HCkScp; remotePath: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkScp_UploadBdAsync(_map(69, 'CkScp_UploadBdAsync'))
    (objHandle, remotePath, bd);
end;

function CkScp_UploadBinary (objHandle: HCkScp; remotePath: PWideChar; binData: HCkByteData): wordbool;
begin
  result := TCkScp_UploadBinary(_map(70, 'CkScp_UploadBinary'))
    (objHandle, remotePath, binData);
end;

function CkScp_UploadBinaryAsync (objHandle: HCkScp; remotePath: PWideChar; binData: HCkByteData): HCkTask;
begin
  result := TCkScp_UploadBinaryAsync(_map(71, 'CkScp_UploadBinaryAsync'))
    (objHandle, remotePath, binData);
end;

function CkScp_UploadBinaryEncoded (objHandle: HCkScp; remotePath: PWideChar; encodedData: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkScp_UploadBinaryEncoded(_map(72, 'CkScp_UploadBinaryEncoded'))
    (objHandle, remotePath, encodedData, encoding);
end;

function CkScp_UploadBinaryEncodedAsync (objHandle: HCkScp; remotePath: PWideChar; encodedData: PWideChar; encoding: PWideChar): HCkTask;
begin
  result := TCkScp_UploadBinaryEncodedAsync(_map(73, 'CkScp_UploadBinaryEncodedAsync'))
    (objHandle, remotePath, encodedData, encoding);
end;

function CkScp_UploadFile (objHandle: HCkScp; localPath: PWideChar; remotePath: PWideChar): wordbool;
begin
  result := TCkScp_UploadFile(_map(74, 'CkScp_UploadFile'))
    (objHandle, localPath, remotePath);
end;

function CkScp_UploadFileAsync (objHandle: HCkScp; localPath: PWideChar; remotePath: PWideChar): HCkTask;
begin
  result := TCkScp_UploadFileAsync(_map(75, 'CkScp_UploadFileAsync'))
    (objHandle, localPath, remotePath);
end;

function CkScp_UploadString (objHandle: HCkScp; remotePath: PWideChar; textData: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkScp_UploadString(_map(76, 'CkScp_UploadString'))
    (objHandle, remotePath, textData, charset);
end;

function CkScp_UploadStringAsync (objHandle: HCkScp; remotePath: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkScp_UploadStringAsync(_map(77, 'CkScp_UploadStringAsync'))
    (objHandle, remotePath, textData, charset);
end;

function CkScp_UseSsh (objHandle: HCkScp; sshConnection: HCkSsh): wordbool;
begin
  result := TCkScp_UseSsh(_map(78, 'CkScp_UseSsh'))
    (objHandle, sshConnection);
end;

end.
