unit ServerSentEvent;

interface

type

HCkString = Pointer;
HCkServerSentEvent = Pointer;


function CkServerSentEvent_Create: HCkServerSentEvent;  stdcall;
procedure CkServerSentEvent_Dispose(handle: HCkServerSentEvent); stdcall;
procedure CkServerSentEvent_getData(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__data(objHandle: HCkServerSentEvent): PWideChar;
procedure CkServerSentEvent_getDebugLogFilePath(objHandle: HCkServerSentEvent; outPropVal: HCkString);
procedure CkServerSentEvent_putDebugLogFilePath(objHandle: HCkServerSentEvent; newPropVal: PWideChar);
function CkServerSentEvent__debugLogFilePath(objHandle: HCkServerSentEvent): PWideChar;
procedure CkServerSentEvent_getEventName(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__eventName(objHandle: HCkServerSentEvent): PWideChar;
procedure CkServerSentEvent_getLastErrorHtml(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__lastErrorHtml(objHandle: HCkServerSentEvent): PWideChar;
procedure CkServerSentEvent_getLastErrorText(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__lastErrorText(objHandle: HCkServerSentEvent): PWideChar;
procedure CkServerSentEvent_getLastErrorXml(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__lastErrorXml(objHandle: HCkServerSentEvent): PWideChar;
procedure CkServerSentEvent_getLastEventId(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__lastEventId(objHandle: HCkServerSentEvent): PWideChar;
function CkServerSentEvent_getLastMethodSuccess(objHandle: HCkServerSentEvent): wordbool;
procedure CkServerSentEvent_putLastMethodSuccess(objHandle: HCkServerSentEvent; newPropVal: wordbool);
function CkServerSentEvent_getRetry(objHandle: HCkServerSentEvent): Integer;
function CkServerSentEvent_getVerboseLogging(objHandle: HCkServerSentEvent): wordbool;
procedure CkServerSentEvent_putVerboseLogging(objHandle: HCkServerSentEvent; newPropVal: wordbool);
procedure CkServerSentEvent_getVersion(objHandle: HCkServerSentEvent; outPropVal: HCkString);
function CkServerSentEvent__version(objHandle: HCkServerSentEvent): PWideChar;
function CkServerSentEvent_LoadEvent(objHandle: HCkServerSentEvent; eventText: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkServerSentEvent_Create = function : HCkServerSentEvent; stdcall;
  TCkServerSentEvent_Dispose = procedure (handle: HCkServerSentEvent); stdcall;
  TCkServerSentEvent_getData = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__data = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getDebugLogFilePath = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent_putDebugLogFilePath = procedure (objHandle: HCkServerSentEvent; newPropVal: PWideChar); stdcall;
  TCkServerSentEvent__debugLogFilePath = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getEventName = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__eventName = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getLastErrorHtml = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__lastErrorHtml = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getLastErrorText = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__lastErrorText = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getLastErrorXml = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__lastErrorXml = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getLastEventId = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__lastEventId = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_getLastMethodSuccess = function (objHandle: HCkServerSentEvent): wordbool; stdcall;
  TCkServerSentEvent_putLastMethodSuccess = procedure (objHandle: HCkServerSentEvent; newPropVal: wordbool); stdcall;
  TCkServerSentEvent_getRetry = function (objHandle: HCkServerSentEvent): Integer; stdcall;
  TCkServerSentEvent_getVerboseLogging = function (objHandle: HCkServerSentEvent): wordbool; stdcall;
  TCkServerSentEvent_putVerboseLogging = procedure (objHandle: HCkServerSentEvent; newPropVal: wordbool); stdcall;
  TCkServerSentEvent_getVersion = procedure (objHandle: HCkServerSentEvent; outPropVal: HCkString); stdcall;
  TCkServerSentEvent__version = function (objHandle: HCkServerSentEvent): PWideChar; stdcall;
  TCkServerSentEvent_LoadEvent = function (objHandle: HCkServerSentEvent; eventText: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..24] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkServerSentEvent_Create : HCkServerSentEvent;
begin
  result := TCkServerSentEvent_Create(_map(0, 'CkServerSentEvent_Create'));
end;

procedure CkServerSentEvent_Dispose (handle: HCkServerSentEvent);
begin
  TCkServerSentEvent_Dispose(_map(1, 'CkServerSentEvent_Dispose'))
    (handle);
end;


procedure CkServerSentEvent_getData (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getData(_map(2, 'CkServerSentEvent_getData'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__data (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__data(_map(3, 'CkServerSentEvent__data'))
    (objHandle);
end;

procedure CkServerSentEvent_getDebugLogFilePath (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getDebugLogFilePath(_map(4, 'CkServerSentEvent_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkServerSentEvent_putDebugLogFilePath (objHandle: HCkServerSentEvent; newPropVal: PWideChar);
begin
  TCkServerSentEvent_putDebugLogFilePath(_map(5, 'CkServerSentEvent_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkServerSentEvent__debugLogFilePath (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__debugLogFilePath(_map(6, 'CkServerSentEvent__debugLogFilePath'))
    (objHandle);
end;

procedure CkServerSentEvent_getEventName (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getEventName(_map(7, 'CkServerSentEvent_getEventName'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__eventName (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__eventName(_map(8, 'CkServerSentEvent__eventName'))
    (objHandle);
end;

procedure CkServerSentEvent_getLastErrorHtml (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getLastErrorHtml(_map(9, 'CkServerSentEvent_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__lastErrorHtml (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__lastErrorHtml(_map(10, 'CkServerSentEvent__lastErrorHtml'))
    (objHandle);
end;

procedure CkServerSentEvent_getLastErrorText (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getLastErrorText(_map(11, 'CkServerSentEvent_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__lastErrorText (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__lastErrorText(_map(12, 'CkServerSentEvent__lastErrorText'))
    (objHandle);
end;

procedure CkServerSentEvent_getLastErrorXml (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getLastErrorXml(_map(13, 'CkServerSentEvent_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__lastErrorXml (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__lastErrorXml(_map(14, 'CkServerSentEvent__lastErrorXml'))
    (objHandle);
end;

procedure CkServerSentEvent_getLastEventId (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getLastEventId(_map(15, 'CkServerSentEvent_getLastEventId'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__lastEventId (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__lastEventId(_map(16, 'CkServerSentEvent__lastEventId'))
    (objHandle);
end;

function CkServerSentEvent_getLastMethodSuccess (objHandle: HCkServerSentEvent): wordbool;
begin
    result := TCkServerSentEvent_getLastMethodSuccess(_map(17, 'CkServerSentEvent_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkServerSentEvent_putLastMethodSuccess (objHandle: HCkServerSentEvent; newPropVal: wordbool);
begin
  TCkServerSentEvent_putLastMethodSuccess(_map(18, 'CkServerSentEvent_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkServerSentEvent_getRetry (objHandle: HCkServerSentEvent): Integer;
begin
    result := TCkServerSentEvent_getRetry(_map(19, 'CkServerSentEvent_getRetry'))
    (objHandle);
end;

function CkServerSentEvent_getVerboseLogging (objHandle: HCkServerSentEvent): wordbool;
begin
    result := TCkServerSentEvent_getVerboseLogging(_map(20, 'CkServerSentEvent_getVerboseLogging'))
    (objHandle);
end;

procedure CkServerSentEvent_putVerboseLogging (objHandle: HCkServerSentEvent; newPropVal: wordbool);
begin
  TCkServerSentEvent_putVerboseLogging(_map(21, 'CkServerSentEvent_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkServerSentEvent_getVersion (objHandle: HCkServerSentEvent; outPropVal: HCkString);
begin
  TCkServerSentEvent_getVersion(_map(22, 'CkServerSentEvent_getVersion'))
    (objHandle, outPropVal);
end;

function CkServerSentEvent__version (objHandle: HCkServerSentEvent): PWideChar;
begin
  result := TCkServerSentEvent__version(_map(23, 'CkServerSentEvent__version'))
    (objHandle);
end;

function CkServerSentEvent_LoadEvent (objHandle: HCkServerSentEvent; eventText: PWideChar): wordbool;
begin
  result := TCkServerSentEvent_LoadEvent(_map(24, 'CkServerSentEvent_LoadEvent'))
    (objHandle, eventText);
end;

end.
