unit Socket;

interface

type

HCkJsonObject = Pointer;
HCkSsh = Pointer;
HCkCert = Pointer;
HCkSocket = Pointer;
HCkByteData = Pointer;
HCkSshKey = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSocketAbortCheck = function(): Integer; cdecl;
TSocketProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSocketPercentDone = function(pctDone: Integer): Integer; cdecl;
TSocketTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSocket_Create: HCkSocket;  stdcall;
procedure CkSocket_Dispose(handle: HCkSocket); stdcall;

procedure CkSocket_SetAbortCheck(objHandle: HCkSocket; fn: TSocketAbortCheck) stdcall;
procedure CkSocket_SetProgressInfo(objHandle: HCkSocket; fn: TSocketProgressInfo) stdcall;
procedure CkSocket_SetPercentDone(objHandle: HCkSocket; fn: TSocketPercentDone) stdcall;
procedure CkSocket_SetTaskCompleted(objHandle: HCkSocket; fn: TSocketTaskCompleted) stdcall;
function CkSocket_getAbortCurrent(objHandle: HCkSocket): wordbool;
procedure CkSocket_putAbortCurrent(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getAcceptFailReason(objHandle: HCkSocket): Integer;
procedure CkSocket_getAlpnProtocol(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putAlpnProtocol(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__alpnProtocol(objHandle: HCkSocket): PWideChar;
function CkSocket_getBandwidthThrottleDown(objHandle: HCkSocket): Integer;
procedure CkSocket_putBandwidthThrottleDown(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getBandwidthThrottleUp(objHandle: HCkSocket): Integer;
procedure CkSocket_putBandwidthThrottleUp(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getBigEndian(objHandle: HCkSocket): wordbool;
procedure CkSocket_putBigEndian(objHandle: HCkSocket; newPropVal: wordbool);
procedure CkSocket_getClientIpAddress(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putClientIpAddress(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__clientIpAddress(objHandle: HCkSocket): PWideChar;
function CkSocket_getClientPort(objHandle: HCkSocket): Integer;
procedure CkSocket_putClientPort(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getConnectFailReason(objHandle: HCkSocket): Integer;
procedure CkSocket_getDebugLogFilePath(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putDebugLogFilePath(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__debugLogFilePath(objHandle: HCkSocket): PWideChar;
function CkSocket_getElapsedSeconds(objHandle: HCkSocket): Integer;
function CkSocket_getHeartbeatMs(objHandle: HCkSocket): Integer;
procedure CkSocket_putHeartbeatMs(objHandle: HCkSocket; newPropVal: Integer);
procedure CkSocket_getHttpProxyAuthMethod(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putHttpProxyAuthMethod(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__httpProxyAuthMethod(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getHttpProxyDomain(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putHttpProxyDomain(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__httpProxyDomain(objHandle: HCkSocket): PWideChar;
function CkSocket_getHttpProxyForHttp(objHandle: HCkSocket): wordbool;
procedure CkSocket_putHttpProxyForHttp(objHandle: HCkSocket; newPropVal: wordbool);
procedure CkSocket_getHttpProxyHostname(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putHttpProxyHostname(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__httpProxyHostname(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getHttpProxyPassword(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putHttpProxyPassword(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__httpProxyPassword(objHandle: HCkSocket): PWideChar;
function CkSocket_getHttpProxyPort(objHandle: HCkSocket): Integer;
procedure CkSocket_putHttpProxyPort(objHandle: HCkSocket; newPropVal: Integer);
procedure CkSocket_getHttpProxyUsername(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putHttpProxyUsername(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__httpProxyUsername(objHandle: HCkSocket): PWideChar;
function CkSocket_getIsConnected(objHandle: HCkSocket): wordbool;
function CkSocket_getKeepAlive(objHandle: HCkSocket): wordbool;
procedure CkSocket_putKeepAlive(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getKeepSessionLog(objHandle: HCkSocket): wordbool;
procedure CkSocket_putKeepSessionLog(objHandle: HCkSocket; newPropVal: wordbool);
procedure CkSocket_getLastErrorHtml(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__lastErrorHtml(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getLastErrorText(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__lastErrorText(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getLastErrorXml(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__lastErrorXml(objHandle: HCkSocket): PWideChar;
function CkSocket_getLastMethodFailed(objHandle: HCkSocket): wordbool;
function CkSocket_getLastMethodSuccess(objHandle: HCkSocket): wordbool;
procedure CkSocket_putLastMethodSuccess(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getListenIpv6(objHandle: HCkSocket): wordbool;
procedure CkSocket_putListenIpv6(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getListenPort(objHandle: HCkSocket): Integer;
procedure CkSocket_getLocalIpAddress(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__localIpAddress(objHandle: HCkSocket): PWideChar;
function CkSocket_getLocalPort(objHandle: HCkSocket): Integer;
function CkSocket_getMaxReadIdleMs(objHandle: HCkSocket): Integer;
procedure CkSocket_putMaxReadIdleMs(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getMaxSendIdleMs(objHandle: HCkSocket): Integer;
procedure CkSocket_putMaxSendIdleMs(objHandle: HCkSocket; newPropVal: Integer);
procedure CkSocket_getMyIpAddress(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__myIpAddress(objHandle: HCkSocket): PWideChar;
function CkSocket_getNumBytesAvailable(objHandle: HCkSocket): Integer;
function CkSocket_getNumReceivedClientCerts(objHandle: HCkSocket): Integer;
function CkSocket_getNumSocketsInSet(objHandle: HCkSocket): Integer;
function CkSocket_getNumSslAcceptableClientCAs(objHandle: HCkSocket): Integer;
function CkSocket_getObjectId(objHandle: HCkSocket): Integer;
function CkSocket_getPercentDoneScale(objHandle: HCkSocket): Integer;
procedure CkSocket_putPercentDoneScale(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getPreferIpv6(objHandle: HCkSocket): wordbool;
procedure CkSocket_putPreferIpv6(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getRcvBytesPerSec(objHandle: HCkSocket): Integer;
function CkSocket_getReceivedCount(objHandle: HCkSocket): Integer;
procedure CkSocket_putReceivedCount(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getReceivedInt(objHandle: HCkSocket): Integer;
procedure CkSocket_putReceivedInt(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getReceiveFailReason(objHandle: HCkSocket): Integer;
function CkSocket_getReceivePacketSize(objHandle: HCkSocket): Integer;
procedure CkSocket_putReceivePacketSize(objHandle: HCkSocket; newPropVal: Integer);
procedure CkSocket_getRemoteIpAddress(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__remoteIpAddress(objHandle: HCkSocket): PWideChar;
function CkSocket_getRemotePort(objHandle: HCkSocket): Integer;
function CkSocket_getRequireSslCertVerify(objHandle: HCkSocket): wordbool;
procedure CkSocket_putRequireSslCertVerify(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getSelectorIndex(objHandle: HCkSocket): Integer;
procedure CkSocket_putSelectorIndex(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getSelectorReadIndex(objHandle: HCkSocket): Integer;
procedure CkSocket_putSelectorReadIndex(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getSelectorWriteIndex(objHandle: HCkSocket): Integer;
procedure CkSocket_putSelectorWriteIndex(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getSendBytesPerSec(objHandle: HCkSocket): Integer;
function CkSocket_getSendFailReason(objHandle: HCkSocket): Integer;
function CkSocket_getSendPacketSize(objHandle: HCkSocket): Integer;
procedure CkSocket_putSendPacketSize(objHandle: HCkSocket; newPropVal: Integer);
procedure CkSocket_getSessionLog(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__sessionLog(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getSessionLogEncoding(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSessionLogEncoding(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__sessionLogEncoding(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getSniHostname(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSniHostname(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__sniHostname(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getSocksHostname(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSocksHostname(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__socksHostname(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getSocksPassword(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSocksPassword(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__socksPassword(objHandle: HCkSocket): PWideChar;
function CkSocket_getSocksPort(objHandle: HCkSocket): Integer;
procedure CkSocket_putSocksPort(objHandle: HCkSocket; newPropVal: Integer);
procedure CkSocket_getSocksUsername(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSocksUsername(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__socksUsername(objHandle: HCkSocket): PWideChar;
function CkSocket_getSocksVersion(objHandle: HCkSocket): Integer;
procedure CkSocket_putSocksVersion(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getSoRcvBuf(objHandle: HCkSocket): Integer;
procedure CkSocket_putSoRcvBuf(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getSoReuseAddr(objHandle: HCkSocket): wordbool;
procedure CkSocket_putSoReuseAddr(objHandle: HCkSocket; newPropVal: wordbool);
function CkSocket_getSoSndBuf(objHandle: HCkSocket): Integer;
procedure CkSocket_putSoSndBuf(objHandle: HCkSocket; newPropVal: Integer);
function CkSocket_getSsl(objHandle: HCkSocket): wordbool;
procedure CkSocket_putSsl(objHandle: HCkSocket; newPropVal: wordbool);
procedure CkSocket_getSslAllowedCiphers(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSslAllowedCiphers(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__sslAllowedCiphers(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getSslProtocol(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putSslProtocol(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__sslProtocol(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getStringCharset(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putStringCharset(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__stringCharset(objHandle: HCkSocket): PWideChar;
function CkSocket_getTcpNoDelay(objHandle: HCkSocket): wordbool;
procedure CkSocket_putTcpNoDelay(objHandle: HCkSocket; newPropVal: wordbool);
procedure CkSocket_getTlsCipherSuite(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__tlsCipherSuite(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getTlsPinSet(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putTlsPinSet(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__tlsPinSet(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getTlsVersion(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__tlsVersion(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getUncommonOptions(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putUncommonOptions(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__uncommonOptions(objHandle: HCkSocket): PWideChar;
procedure CkSocket_getUserData(objHandle: HCkSocket; outPropVal: HCkString);
procedure CkSocket_putUserData(objHandle: HCkSocket; newPropVal: PWideChar);
function CkSocket__userData(objHandle: HCkSocket): PWideChar;
function CkSocket_getVerboseLogging(objHandle: HCkSocket): wordbool;
procedure CkSocket_putVerboseLogging(objHandle: HCkSocket; newPropVal: wordbool);
procedure CkSocket_getVersion(objHandle: HCkSocket; outPropVal: HCkString);
function CkSocket__version(objHandle: HCkSocket): PWideChar;
function CkSocket_AcceptNext(objHandle: HCkSocket; maxWaitMs: Integer; socket: HCkSocket): wordbool;
function CkSocket_AcceptNextAsync(objHandle: HCkSocket; maxWaitMs: Integer; socket: HCkSocket): HCkTask;
function CkSocket_AcceptNextConnection(objHandle: HCkSocket; maxWaitMs: Integer): HCkSocket;
function CkSocket_AcceptNextConnectionAsync(objHandle: HCkSocket; maxWaitMs: Integer): HCkTask;
function CkSocket_AddSslAcceptableClientCaDn(objHandle: HCkSocket; certAuthDN: PWideChar): wordbool;
function CkSocket_BindAndListen(objHandle: HCkSocket; port: Integer; backLog: Integer): wordbool;
function CkSocket_BindAndListenAsync(objHandle: HCkSocket; port: Integer; backLog: Integer): HCkTask;
function CkSocket_BindAndListenPortRange(objHandle: HCkSocket; beginPort: Integer; endPort: Integer; backLog: Integer): Integer;
function CkSocket_BindAndListenPortRangeAsync(objHandle: HCkSocket; beginPort: Integer; endPort: Integer; backLog: Integer): HCkTask;
function CkSocket_BuildHttpGetRequest(objHandle: HCkSocket; url: PWideChar; outStr: HCkString): wordbool;
function CkSocket__buildHttpGetRequest(objHandle: HCkSocket; url: PWideChar): PWideChar;
function CkSocket_CheckWriteable(objHandle: HCkSocket; maxWaitMs: Integer): Integer;
function CkSocket_CheckWriteableAsync(objHandle: HCkSocket; maxWaitMs: Integer): HCkTask;
procedure CkSocket_ClearSessionLog(objHandle: HCkSocket);
function CkSocket_CloneSocket(objHandle: HCkSocket): HCkSocket;
function CkSocket_Close(objHandle: HCkSocket; maxWaitMs: Integer): wordbool;
function CkSocket_CloseAsync(objHandle: HCkSocket; maxWaitMs: Integer): HCkTask;
function CkSocket_Connect(objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): wordbool;
function CkSocket_ConnectAsync(objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkTask;
function CkSocket_ConvertFromSsl(objHandle: HCkSocket): wordbool;
function CkSocket_ConvertFromSslAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_ConvertToSsl(objHandle: HCkSocket): wordbool;
function CkSocket_ConvertToSslAsync(objHandle: HCkSocket): HCkTask;
procedure CkSocket_DnsCacheClear(objHandle: HCkSocket);
function CkSocket_DnsLookup(objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer; outStr: HCkString): wordbool;
function CkSocket__dnsLookup(objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer): PWideChar;
function CkSocket_DnsLookupAsync(objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer): HCkTask;
function CkSocket_DupSocket(objHandle: HCkSocket; dest: HCkSocket): wordbool;
function CkSocket_GetAdaptersAddresses(objHandle: HCkSocket; json: HCkJsonObject): wordbool;
procedure CkSocket_GetLastJsonData(objHandle: HCkSocket; json: HCkJsonObject);
function CkSocket_GetMyCert(objHandle: HCkSocket): HCkCert;
function CkSocket_GetMyServerCert(objHandle: HCkSocket; cert: HCkCert): wordbool;
function CkSocket_GetRcvdClientCert(objHandle: HCkSocket; index: Integer; cert: HCkCert): wordbool;
function CkSocket_GetReceivedClientCert(objHandle: HCkSocket; index: Integer): HCkCert;
function CkSocket_GetServerCert(objHandle: HCkSocket; cert: HCkCert): wordbool;
function CkSocket_GetSslAcceptableClientCaDn(objHandle: HCkSocket; index: Integer; outStr: HCkString): wordbool;
function CkSocket__getSslAcceptableClientCaDn(objHandle: HCkSocket; index: Integer): PWideChar;
function CkSocket_GetSslServerCert(objHandle: HCkSocket): HCkCert;
function CkSocket_InitSslServer(objHandle: HCkSocket; cert: HCkCert): wordbool;
function CkSocket_LastJsonData(objHandle: HCkSocket): HCkJsonObject;
function CkSocket_LoadTaskCaller(objHandle: HCkSocket; task: HCkTask): wordbool;
function CkSocket_LoadTaskResult(objHandle: HCkSocket; task: HCkTask): wordbool;
function CkSocket_PollDataAvailable(objHandle: HCkSocket): wordbool;
function CkSocket_PollDataAvailableAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_ReceiveBd(objHandle: HCkSocket; binData: HCkBinData): wordbool;
function CkSocket_ReceiveBdAsync(objHandle: HCkSocket; binData: HCkBinData): HCkTask;
function CkSocket_ReceiveBdN(objHandle: HCkSocket; numBytes: LongWord; binData: HCkBinData): wordbool;
function CkSocket_ReceiveBdNAsync(objHandle: HCkSocket; numBytes: LongWord; binData: HCkBinData): HCkTask;
function CkSocket_ReceiveByte(objHandle: HCkSocket; bUnsigned: wordbool): wordbool;
function CkSocket_ReceiveByteAsync(objHandle: HCkSocket; bUnsigned: wordbool): HCkTask;
function CkSocket_ReceiveBytes(objHandle: HCkSocket; outData: HCkByteData): wordbool;
function CkSocket_ReceiveBytesAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_ReceiveBytesENC(objHandle: HCkSocket; encodingAlg: PWideChar; outStr: HCkString): wordbool;
function CkSocket__receiveBytesENC(objHandle: HCkSocket; encodingAlg: PWideChar): PWideChar;
function CkSocket_ReceiveBytesENCAsync(objHandle: HCkSocket; encodingAlg: PWideChar): HCkTask;
function CkSocket_ReceiveBytesN(objHandle: HCkSocket; numBytes: LongWord; outData: HCkByteData): wordbool;
function CkSocket_ReceiveBytesNAsync(objHandle: HCkSocket; numBytes: LongWord): HCkTask;
function CkSocket_ReceiveBytesToFile(objHandle: HCkSocket; appendFilename: PWideChar): wordbool;
function CkSocket_ReceiveBytesToFileAsync(objHandle: HCkSocket; appendFilename: PWideChar): HCkTask;
function CkSocket_ReceiveCount(objHandle: HCkSocket): Integer;
function CkSocket_ReceiveCountAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_ReceiveInt16(objHandle: HCkSocket; bigEndian: wordbool; bUnsigned: wordbool): wordbool;
function CkSocket_ReceiveInt16Async(objHandle: HCkSocket; bigEndian: wordbool; bUnsigned: wordbool): HCkTask;
function CkSocket_ReceiveInt32(objHandle: HCkSocket; bigEndian: wordbool): wordbool;
function CkSocket_ReceiveInt32Async(objHandle: HCkSocket; bigEndian: wordbool): HCkTask;
function CkSocket_ReceiveNBytesENC(objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar; outStr: HCkString): wordbool;
function CkSocket__receiveNBytesENC(objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar): PWideChar;
function CkSocket_ReceiveNBytesENCAsync(objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar): HCkTask;
function CkSocket_ReceiveSb(objHandle: HCkSocket; sb: HCkStringBuilder): wordbool;
function CkSocket_ReceiveSbAsync(objHandle: HCkSocket; sb: HCkStringBuilder): HCkTask;
function CkSocket_ReceiveString(objHandle: HCkSocket; outStr: HCkString): wordbool;
function CkSocket__receiveString(objHandle: HCkSocket): PWideChar;
function CkSocket_ReceiveStringAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_ReceiveStringMaxN(objHandle: HCkSocket; maxByteCount: Integer; outStr: HCkString): wordbool;
function CkSocket__receiveStringMaxN(objHandle: HCkSocket; maxByteCount: Integer): PWideChar;
function CkSocket_ReceiveStringMaxNAsync(objHandle: HCkSocket; maxByteCount: Integer): HCkTask;
function CkSocket_ReceiveStringUntilByte(objHandle: HCkSocket; lookForByte: Integer; outStr: HCkString): wordbool;
function CkSocket__receiveStringUntilByte(objHandle: HCkSocket; lookForByte: Integer): PWideChar;
function CkSocket_ReceiveStringUntilByteAsync(objHandle: HCkSocket; lookForByte: Integer): HCkTask;
function CkSocket_ReceiveToCRLF(objHandle: HCkSocket; outStr: HCkString): wordbool;
function CkSocket__receiveToCRLF(objHandle: HCkSocket): PWideChar;
function CkSocket_ReceiveToCRLFAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_ReceiveUntilByte(objHandle: HCkSocket; lookForByte: Integer; outData: HCkByteData): wordbool;
function CkSocket_ReceiveUntilByteAsync(objHandle: HCkSocket; lookForByte: Integer): HCkTask;
function CkSocket_ReceiveUntilByteBd(objHandle: HCkSocket; lookForByte: Integer; bd: HCkBinData): wordbool;
function CkSocket_ReceiveUntilByteBdAsync(objHandle: HCkSocket; lookForByte: Integer; bd: HCkBinData): HCkTask;
function CkSocket_ReceiveUntilMatch(objHandle: HCkSocket; matchStr: PWideChar; outStr: HCkString): wordbool;
function CkSocket__receiveUntilMatch(objHandle: HCkSocket; matchStr: PWideChar): PWideChar;
function CkSocket_ReceiveUntilMatchAsync(objHandle: HCkSocket; matchStr: PWideChar): HCkTask;
function CkSocket_ReceiveUntilMatchSb(objHandle: HCkSocket; matchStr: PWideChar; sb: HCkStringBuilder): wordbool;
function CkSocket_ReceiveUntilMatchSbAsync(objHandle: HCkSocket; matchStr: PWideChar; sb: HCkStringBuilder): HCkTask;
procedure CkSocket_ResetPerf(objHandle: HCkSocket; rcvPerf: wordbool);
function CkSocket_SelectForReading(objHandle: HCkSocket; timeoutMs: Integer): Integer;
function CkSocket_SelectForReadingAsync(objHandle: HCkSocket; timeoutMs: Integer): HCkTask;
function CkSocket_SelectForWriting(objHandle: HCkSocket; timeoutMs: Integer): Integer;
function CkSocket_SelectForWritingAsync(objHandle: HCkSocket; timeoutMs: Integer): HCkTask;
function CkSocket_SendBd(objHandle: HCkSocket; binData: HCkBinData; offset: LongWord; numBytes: LongWord): wordbool;
function CkSocket_SendBdAsync(objHandle: HCkSocket; binData: HCkBinData; offset: LongWord; numBytes: LongWord): HCkTask;
function CkSocket_SendByte(objHandle: HCkSocket; value: Integer): wordbool;
function CkSocket_SendByteAsync(objHandle: HCkSocket; value: Integer): HCkTask;
function CkSocket_SendBytes(objHandle: HCkSocket; data: HCkByteData): wordbool;
function CkSocket_SendBytesAsync(objHandle: HCkSocket; data: HCkByteData): HCkTask;
function CkSocket_SendBytesENC(objHandle: HCkSocket; encodedBytes: PWideChar; encodingAlg: PWideChar): wordbool;
function CkSocket_SendBytesENCAsync(objHandle: HCkSocket; encodedBytes: PWideChar; encodingAlg: PWideChar): HCkTask;
function CkSocket_SendCount(objHandle: HCkSocket; byteCount: Integer): wordbool;
function CkSocket_SendCountAsync(objHandle: HCkSocket; byteCount: Integer): HCkTask;
function CkSocket_SendInt16(objHandle: HCkSocket; value: Integer; bigEndian: wordbool): wordbool;
function CkSocket_SendInt16Async(objHandle: HCkSocket; value: Integer; bigEndian: wordbool): HCkTask;
function CkSocket_SendInt32(objHandle: HCkSocket; value: Integer; bigEndian: wordbool): wordbool;
function CkSocket_SendInt32Async(objHandle: HCkSocket; value: Integer; bigEndian: wordbool): HCkTask;
function CkSocket_SendSb(objHandle: HCkSocket; sb: HCkStringBuilder): wordbool;
function CkSocket_SendSbAsync(objHandle: HCkSocket; sb: HCkStringBuilder): HCkTask;
function CkSocket_SendString(objHandle: HCkSocket; stringToSend: PWideChar): wordbool;
function CkSocket_SendStringAsync(objHandle: HCkSocket; stringToSend: PWideChar): HCkTask;
function CkSocket_SendWakeOnLan(objHandle: HCkSocket; macAddress: PWideChar; port: Integer; ipBroadcastAddr: PWideChar): wordbool;
function CkSocket_SendWakeOnLan2(objHandle: HCkSocket; macAddress: PWideChar; port: Integer; ipBroadcastAddr: PWideChar; password: PWideChar): wordbool;
function CkSocket_SetSslClientCert(objHandle: HCkSocket; cert: HCkCert): wordbool;
function CkSocket_SetSslClientCertPem(objHandle: HCkSocket; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
function CkSocket_SetSslClientCertPfx(objHandle: HCkSocket; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
procedure CkSocket_SleepMs(objHandle: HCkSocket; millisec: Integer);
function CkSocket_SshAuthenticatePk(objHandle: HCkSocket; sshLogin: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSocket_SshAuthenticatePkAsync(objHandle: HCkSocket; sshLogin: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSocket_SshAuthenticatePw(objHandle: HCkSocket; sshLogin: PWideChar; sshPassword: PWideChar): wordbool;
function CkSocket_SshAuthenticatePwAsync(objHandle: HCkSocket; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask;
function CkSocket_SshCloseTunnel(objHandle: HCkSocket): wordbool;
function CkSocket_SshCloseTunnelAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_SshNewChannel(objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer; channel: HCkSocket): wordbool;
function CkSocket_SshNewChannelAsync(objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer; channel: HCkSocket): HCkTask;
function CkSocket_SshOpenChannel(objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkSocket;
function CkSocket_SshOpenChannelAsync(objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkTask;
function CkSocket_SshOpenTunnel(objHandle: HCkSocket; sshHostname: PWideChar; sshPort: Integer): wordbool;
function CkSocket_SshOpenTunnelAsync(objHandle: HCkSocket; sshHostname: PWideChar; sshPort: Integer): HCkTask;
procedure CkSocket_StartTiming(objHandle: HCkSocket);
function CkSocket_TakeConnection(objHandle: HCkSocket; sock: HCkSocket): wordbool;
function CkSocket_TakeSocket(objHandle: HCkSocket; sock: HCkSocket): wordbool;
function CkSocket_TlsRenegotiate(objHandle: HCkSocket): wordbool;
function CkSocket_TlsRenegotiateAsync(objHandle: HCkSocket): HCkTask;
function CkSocket_UseSsh(objHandle: HCkSocket; ssh: HCkSsh): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSocket_Create = function : HCkSocket; stdcall;
  TCkSocket_Dispose = procedure (handle: HCkSocket); stdcall;
  TCkSocket_SetAbortCheck = procedure (objHandle: HCkSocket; fn: TSocketAbortCheck); stdcall;
  TCkSocket_SetProgressInfo = procedure (objHandle: HCkSocket; fn: TSocketProgressInfo); stdcall;
  TCkSocket_SetPercentDone = procedure (objHandle: HCkSocket; fn: TSocketPercentDone); stdcall;
  TCkSocket_SetTaskCompleted = procedure (objHandle: HCkSocket; fn: TSocketTaskCompleted); stdcall;
  TCkSocket_getAbortCurrent = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putAbortCurrent = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getAcceptFailReason = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getAlpnProtocol = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putAlpnProtocol = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__alpnProtocol = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getBandwidthThrottleDown = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putBandwidthThrottleDown = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getBandwidthThrottleUp = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putBandwidthThrottleUp = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getBigEndian = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putBigEndian = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getClientIpAddress = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putClientIpAddress = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__clientIpAddress = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getClientPort = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putClientPort = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getConnectFailReason = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getDebugLogFilePath = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putDebugLogFilePath = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__debugLogFilePath = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getElapsedSeconds = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getHeartbeatMs = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putHeartbeatMs = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getHttpProxyAuthMethod = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putHttpProxyAuthMethod = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__httpProxyAuthMethod = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getHttpProxyDomain = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putHttpProxyDomain = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__httpProxyDomain = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getHttpProxyForHttp = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putHttpProxyForHttp = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getHttpProxyHostname = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putHttpProxyHostname = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__httpProxyHostname = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getHttpProxyPassword = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putHttpProxyPassword = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__httpProxyPassword = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getHttpProxyPort = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putHttpProxyPort = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getHttpProxyUsername = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putHttpProxyUsername = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__httpProxyUsername = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getIsConnected = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_getKeepAlive = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putKeepAlive = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getKeepSessionLog = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putKeepSessionLog = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getLastErrorHtml = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__lastErrorHtml = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getLastErrorText = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__lastErrorText = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getLastErrorXml = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__lastErrorXml = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getLastMethodFailed = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_getLastMethodSuccess = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putLastMethodSuccess = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getListenIpv6 = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putListenIpv6 = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getListenPort = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getLocalIpAddress = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__localIpAddress = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getLocalPort = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getMaxReadIdleMs = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putMaxReadIdleMs = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getMaxSendIdleMs = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putMaxSendIdleMs = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getMyIpAddress = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__myIpAddress = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getNumBytesAvailable = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getNumReceivedClientCerts = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getNumSocketsInSet = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getNumSslAcceptableClientCAs = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getObjectId = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getPercentDoneScale = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putPercentDoneScale = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getPreferIpv6 = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putPreferIpv6 = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getRcvBytesPerSec = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getReceivedCount = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putReceivedCount = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getReceivedInt = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putReceivedInt = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getReceiveFailReason = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getReceivePacketSize = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putReceivePacketSize = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getRemoteIpAddress = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__remoteIpAddress = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getRemotePort = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getRequireSslCertVerify = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putRequireSslCertVerify = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getSelectorIndex = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSelectorIndex = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSelectorReadIndex = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSelectorReadIndex = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSelectorWriteIndex = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSelectorWriteIndex = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSendBytesPerSec = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getSendFailReason = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_getSendPacketSize = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSendPacketSize = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSessionLog = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__sessionLog = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSessionLogEncoding = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSessionLogEncoding = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__sessionLogEncoding = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSniHostname = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSniHostname = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__sniHostname = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSocksHostname = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSocksHostname = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__socksHostname = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSocksPassword = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSocksPassword = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__socksPassword = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSocksPort = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSocksPort = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSocksUsername = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSocksUsername = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__socksUsername = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSocksVersion = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSocksVersion = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSoRcvBuf = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSoRcvBuf = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSoReuseAddr = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putSoReuseAddr = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getSoSndBuf = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_putSoSndBuf = procedure (objHandle: HCkSocket; newPropVal: Integer); stdcall;
  TCkSocket_getSsl = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putSsl = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getSslAllowedCiphers = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSslAllowedCiphers = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__sslAllowedCiphers = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getSslProtocol = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putSslProtocol = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__sslProtocol = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getStringCharset = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putStringCharset = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__stringCharset = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getTcpNoDelay = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putTcpNoDelay = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getTlsCipherSuite = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__tlsCipherSuite = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getTlsPinSet = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putTlsPinSet = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__tlsPinSet = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getTlsVersion = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__tlsVersion = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getUncommonOptions = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putUncommonOptions = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__uncommonOptions = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getUserData = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket_putUserData = procedure (objHandle: HCkSocket; newPropVal: PWideChar); stdcall;
  TCkSocket__userData = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_getVerboseLogging = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_putVerboseLogging = procedure (objHandle: HCkSocket; newPropVal: wordbool); stdcall;
  TCkSocket_getVersion = procedure (objHandle: HCkSocket; outPropVal: HCkString); stdcall;
  TCkSocket__version = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_AcceptNext = function (objHandle: HCkSocket; maxWaitMs: Integer; socket: HCkSocket): wordbool; stdcall;
  TCkSocket_AcceptNextAsync = function (objHandle: HCkSocket; maxWaitMs: Integer; socket: HCkSocket): HCkTask; stdcall;
  TCkSocket_AcceptNextConnection = function (objHandle: HCkSocket; maxWaitMs: Integer): HCkSocket; stdcall;
  TCkSocket_AcceptNextConnectionAsync = function (objHandle: HCkSocket; maxWaitMs: Integer): HCkTask; stdcall;
  TCkSocket_AddSslAcceptableClientCaDn = function (objHandle: HCkSocket; certAuthDN: PWideChar): wordbool; stdcall;
  TCkSocket_BindAndListen = function (objHandle: HCkSocket; port: Integer; backLog: Integer): wordbool; stdcall;
  TCkSocket_BindAndListenAsync = function (objHandle: HCkSocket; port: Integer; backLog: Integer): HCkTask; stdcall;
  TCkSocket_BindAndListenPortRange = function (objHandle: HCkSocket; beginPort: Integer; endPort: Integer; backLog: Integer): Integer; stdcall;
  TCkSocket_BindAndListenPortRangeAsync = function (objHandle: HCkSocket; beginPort: Integer; endPort: Integer; backLog: Integer): HCkTask; stdcall;
  TCkSocket_BuildHttpGetRequest = function (objHandle: HCkSocket; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSocket__buildHttpGetRequest = function (objHandle: HCkSocket; url: PWideChar): PWideChar; stdcall;
  TCkSocket_CheckWriteable = function (objHandle: HCkSocket; maxWaitMs: Integer): Integer; stdcall;
  TCkSocket_CheckWriteableAsync = function (objHandle: HCkSocket; maxWaitMs: Integer): HCkTask; stdcall;
  TCkSocket_ClearSessionLog = procedure (objHandle: HCkSocket); stdcall;
  TCkSocket_CloneSocket = function (objHandle: HCkSocket): HCkSocket; stdcall;
  TCkSocket_Close = function (objHandle: HCkSocket; maxWaitMs: Integer): wordbool; stdcall;
  TCkSocket_CloseAsync = function (objHandle: HCkSocket; maxWaitMs: Integer): HCkTask; stdcall;
  TCkSocket_Connect = function (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): wordbool; stdcall;
  TCkSocket_ConnectAsync = function (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkTask; stdcall;
  TCkSocket_ConvertFromSsl = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_ConvertFromSslAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_ConvertToSsl = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_ConvertToSslAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_DnsCacheClear = procedure (objHandle: HCkSocket); stdcall;
  TCkSocket_DnsLookup = function (objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSocket__dnsLookup = function (objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer): PWideChar; stdcall;
  TCkSocket_DnsLookupAsync = function (objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer): HCkTask; stdcall;
  TCkSocket_DupSocket = function (objHandle: HCkSocket; dest: HCkSocket): wordbool; stdcall;
  TCkSocket_GetAdaptersAddresses = function (objHandle: HCkSocket; json: HCkJsonObject): wordbool; stdcall;
  TCkSocket_GetLastJsonData = procedure (objHandle: HCkSocket; json: HCkJsonObject); stdcall;
  TCkSocket_GetMyCert = function (objHandle: HCkSocket): HCkCert; stdcall;
  TCkSocket_GetMyServerCert = function (objHandle: HCkSocket; cert: HCkCert): wordbool; stdcall;
  TCkSocket_GetRcvdClientCert = function (objHandle: HCkSocket; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkSocket_GetReceivedClientCert = function (objHandle: HCkSocket; index: Integer): HCkCert; stdcall;
  TCkSocket_GetServerCert = function (objHandle: HCkSocket; cert: HCkCert): wordbool; stdcall;
  TCkSocket_GetSslAcceptableClientCaDn = function (objHandle: HCkSocket; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSocket__getSslAcceptableClientCaDn = function (objHandle: HCkSocket; index: Integer): PWideChar; stdcall;
  TCkSocket_GetSslServerCert = function (objHandle: HCkSocket): HCkCert; stdcall;
  TCkSocket_InitSslServer = function (objHandle: HCkSocket; cert: HCkCert): wordbool; stdcall;
  TCkSocket_LastJsonData = function (objHandle: HCkSocket): HCkJsonObject; stdcall;
  TCkSocket_LoadTaskCaller = function (objHandle: HCkSocket; task: HCkTask): wordbool; stdcall;
  TCkSocket_LoadTaskResult = function (objHandle: HCkSocket; task: HCkTask): wordbool; stdcall;
  TCkSocket_PollDataAvailable = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_PollDataAvailableAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_ReceiveBd = function (objHandle: HCkSocket; binData: HCkBinData): wordbool; stdcall;
  TCkSocket_ReceiveBdAsync = function (objHandle: HCkSocket; binData: HCkBinData): HCkTask; stdcall;
  TCkSocket_ReceiveBdN = function (objHandle: HCkSocket; numBytes: LongWord; binData: HCkBinData): wordbool; stdcall;
  TCkSocket_ReceiveBdNAsync = function (objHandle: HCkSocket; numBytes: LongWord; binData: HCkBinData): HCkTask; stdcall;
  TCkSocket_ReceiveByte = function (objHandle: HCkSocket; bUnsigned: wordbool): wordbool; stdcall;
  TCkSocket_ReceiveByteAsync = function (objHandle: HCkSocket; bUnsigned: wordbool): HCkTask; stdcall;
  TCkSocket_ReceiveBytes = function (objHandle: HCkSocket; outData: HCkByteData): wordbool; stdcall;
  TCkSocket_ReceiveBytesAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_ReceiveBytesENC = function (objHandle: HCkSocket; encodingAlg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveBytesENC = function (objHandle: HCkSocket; encodingAlg: PWideChar): PWideChar; stdcall;
  TCkSocket_ReceiveBytesENCAsync = function (objHandle: HCkSocket; encodingAlg: PWideChar): HCkTask; stdcall;
  TCkSocket_ReceiveBytesN = function (objHandle: HCkSocket; numBytes: LongWord; outData: HCkByteData): wordbool; stdcall;
  TCkSocket_ReceiveBytesNAsync = function (objHandle: HCkSocket; numBytes: LongWord): HCkTask; stdcall;
  TCkSocket_ReceiveBytesToFile = function (objHandle: HCkSocket; appendFilename: PWideChar): wordbool; stdcall;
  TCkSocket_ReceiveBytesToFileAsync = function (objHandle: HCkSocket; appendFilename: PWideChar): HCkTask; stdcall;
  TCkSocket_ReceiveCount = function (objHandle: HCkSocket): Integer; stdcall;
  TCkSocket_ReceiveCountAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_ReceiveInt16 = function (objHandle: HCkSocket; bigEndian: wordbool; bUnsigned: wordbool): wordbool; stdcall;
  TCkSocket_ReceiveInt16Async = function (objHandle: HCkSocket; bigEndian: wordbool; bUnsigned: wordbool): HCkTask; stdcall;
  TCkSocket_ReceiveInt32 = function (objHandle: HCkSocket; bigEndian: wordbool): wordbool; stdcall;
  TCkSocket_ReceiveInt32Async = function (objHandle: HCkSocket; bigEndian: wordbool): HCkTask; stdcall;
  TCkSocket_ReceiveNBytesENC = function (objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveNBytesENC = function (objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar): PWideChar; stdcall;
  TCkSocket_ReceiveNBytesENCAsync = function (objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar): HCkTask; stdcall;
  TCkSocket_ReceiveSb = function (objHandle: HCkSocket; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSocket_ReceiveSbAsync = function (objHandle: HCkSocket; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkSocket_ReceiveString = function (objHandle: HCkSocket; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveString = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_ReceiveStringAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_ReceiveStringMaxN = function (objHandle: HCkSocket; maxByteCount: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveStringMaxN = function (objHandle: HCkSocket; maxByteCount: Integer): PWideChar; stdcall;
  TCkSocket_ReceiveStringMaxNAsync = function (objHandle: HCkSocket; maxByteCount: Integer): HCkTask; stdcall;
  TCkSocket_ReceiveStringUntilByte = function (objHandle: HCkSocket; lookForByte: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveStringUntilByte = function (objHandle: HCkSocket; lookForByte: Integer): PWideChar; stdcall;
  TCkSocket_ReceiveStringUntilByteAsync = function (objHandle: HCkSocket; lookForByte: Integer): HCkTask; stdcall;
  TCkSocket_ReceiveToCRLF = function (objHandle: HCkSocket; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveToCRLF = function (objHandle: HCkSocket): PWideChar; stdcall;
  TCkSocket_ReceiveToCRLFAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_ReceiveUntilByte = function (objHandle: HCkSocket; lookForByte: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSocket_ReceiveUntilByteAsync = function (objHandle: HCkSocket; lookForByte: Integer): HCkTask; stdcall;
  TCkSocket_ReceiveUntilByteBd = function (objHandle: HCkSocket; lookForByte: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkSocket_ReceiveUntilByteBdAsync = function (objHandle: HCkSocket; lookForByte: Integer; bd: HCkBinData): HCkTask; stdcall;
  TCkSocket_ReceiveUntilMatch = function (objHandle: HCkSocket; matchStr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSocket__receiveUntilMatch = function (objHandle: HCkSocket; matchStr: PWideChar): PWideChar; stdcall;
  TCkSocket_ReceiveUntilMatchAsync = function (objHandle: HCkSocket; matchStr: PWideChar): HCkTask; stdcall;
  TCkSocket_ReceiveUntilMatchSb = function (objHandle: HCkSocket; matchStr: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSocket_ReceiveUntilMatchSbAsync = function (objHandle: HCkSocket; matchStr: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkSocket_ResetPerf = procedure (objHandle: HCkSocket; rcvPerf: wordbool); stdcall;
  TCkSocket_SelectForReading = function (objHandle: HCkSocket; timeoutMs: Integer): Integer; stdcall;
  TCkSocket_SelectForReadingAsync = function (objHandle: HCkSocket; timeoutMs: Integer): HCkTask; stdcall;
  TCkSocket_SelectForWriting = function (objHandle: HCkSocket; timeoutMs: Integer): Integer; stdcall;
  TCkSocket_SelectForWritingAsync = function (objHandle: HCkSocket; timeoutMs: Integer): HCkTask; stdcall;
  TCkSocket_SendBd = function (objHandle: HCkSocket; binData: HCkBinData; offset: LongWord; numBytes: LongWord): wordbool; stdcall;
  TCkSocket_SendBdAsync = function (objHandle: HCkSocket; binData: HCkBinData; offset: LongWord; numBytes: LongWord): HCkTask; stdcall;
  TCkSocket_SendByte = function (objHandle: HCkSocket; value: Integer): wordbool; stdcall;
  TCkSocket_SendByteAsync = function (objHandle: HCkSocket; value: Integer): HCkTask; stdcall;
  TCkSocket_SendBytes = function (objHandle: HCkSocket; data: HCkByteData): wordbool; stdcall;
  TCkSocket_SendBytesAsync = function (objHandle: HCkSocket; data: HCkByteData): HCkTask; stdcall;
  TCkSocket_SendBytesENC = function (objHandle: HCkSocket; encodedBytes: PWideChar; encodingAlg: PWideChar): wordbool; stdcall;
  TCkSocket_SendBytesENCAsync = function (objHandle: HCkSocket; encodedBytes: PWideChar; encodingAlg: PWideChar): HCkTask; stdcall;
  TCkSocket_SendCount = function (objHandle: HCkSocket; byteCount: Integer): wordbool; stdcall;
  TCkSocket_SendCountAsync = function (objHandle: HCkSocket; byteCount: Integer): HCkTask; stdcall;
  TCkSocket_SendInt16 = function (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): wordbool; stdcall;
  TCkSocket_SendInt16Async = function (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): HCkTask; stdcall;
  TCkSocket_SendInt32 = function (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): wordbool; stdcall;
  TCkSocket_SendInt32Async = function (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): HCkTask; stdcall;
  TCkSocket_SendSb = function (objHandle: HCkSocket; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSocket_SendSbAsync = function (objHandle: HCkSocket; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkSocket_SendString = function (objHandle: HCkSocket; stringToSend: PWideChar): wordbool; stdcall;
  TCkSocket_SendStringAsync = function (objHandle: HCkSocket; stringToSend: PWideChar): HCkTask; stdcall;
  TCkSocket_SendWakeOnLan = function (objHandle: HCkSocket; macAddress: PWideChar; port: Integer; ipBroadcastAddr: PWideChar): wordbool; stdcall;
  TCkSocket_SendWakeOnLan2 = function (objHandle: HCkSocket; macAddress: PWideChar; port: Integer; ipBroadcastAddr: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkSocket_SetSslClientCert = function (objHandle: HCkSocket; cert: HCkCert): wordbool; stdcall;
  TCkSocket_SetSslClientCertPem = function (objHandle: HCkSocket; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool; stdcall;
  TCkSocket_SetSslClientCertPfx = function (objHandle: HCkSocket; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkSocket_SleepMs = procedure (objHandle: HCkSocket; millisec: Integer); stdcall;
  TCkSocket_SshAuthenticatePk = function (objHandle: HCkSocket; sshLogin: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSocket_SshAuthenticatePkAsync = function (objHandle: HCkSocket; sshLogin: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSocket_SshAuthenticatePw = function (objHandle: HCkSocket; sshLogin: PWideChar; sshPassword: PWideChar): wordbool; stdcall;
  TCkSocket_SshAuthenticatePwAsync = function (objHandle: HCkSocket; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask; stdcall;
  TCkSocket_SshCloseTunnel = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_SshCloseTunnelAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_SshNewChannel = function (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer; channel: HCkSocket): wordbool; stdcall;
  TCkSocket_SshNewChannelAsync = function (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer; channel: HCkSocket): HCkTask; stdcall;
  TCkSocket_SshOpenChannel = function (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkSocket; stdcall;
  TCkSocket_SshOpenChannelAsync = function (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkTask; stdcall;
  TCkSocket_SshOpenTunnel = function (objHandle: HCkSocket; sshHostname: PWideChar; sshPort: Integer): wordbool; stdcall;
  TCkSocket_SshOpenTunnelAsync = function (objHandle: HCkSocket; sshHostname: PWideChar; sshPort: Integer): HCkTask; stdcall;
  TCkSocket_StartTiming = procedure (objHandle: HCkSocket); stdcall;
  TCkSocket_TakeConnection = function (objHandle: HCkSocket; sock: HCkSocket): wordbool; stdcall;
  TCkSocket_TakeSocket = function (objHandle: HCkSocket; sock: HCkSocket): wordbool; stdcall;
  TCkSocket_TlsRenegotiate = function (objHandle: HCkSocket): wordbool; stdcall;
  TCkSocket_TlsRenegotiateAsync = function (objHandle: HCkSocket): HCkTask; stdcall;
  TCkSocket_UseSsh = function (objHandle: HCkSocket; ssh: HCkSsh): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..301] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSocket_Create : HCkSocket;
begin
  result := TCkSocket_Create(_map(0, 'CkSocket_Create'));
end;

procedure CkSocket_Dispose (handle: HCkSocket);
begin
  TCkSocket_Dispose(_map(1, 'CkSocket_Dispose'))
    (handle);
end;


procedure CkSocket_SetAbortCheck (objHandle: HCkSocket; fn: TSocketAbortCheck);
begin
    TCkSocket_SetAbortCheck(_map(2, 'CkSocket_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSocket_SetProgressInfo (objHandle: HCkSocket; fn: TSocketProgressInfo);
begin
    TCkSocket_SetProgressInfo(_map(3, 'CkSocket_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSocket_SetPercentDone (objHandle: HCkSocket; fn: TSocketPercentDone);
begin
    TCkSocket_SetPercentDone(_map(4, 'CkSocket_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSocket_SetTaskCompleted (objHandle: HCkSocket; fn: TSocketTaskCompleted);
begin
    TCkSocket_SetTaskCompleted(_map(5, 'CkSocket_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkSocket_getAbortCurrent (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getAbortCurrent(_map(6, 'CkSocket_getAbortCurrent'))
    (objHandle);
end;

procedure CkSocket_putAbortCurrent (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putAbortCurrent(_map(7, 'CkSocket_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkSocket_getAcceptFailReason (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getAcceptFailReason(_map(8, 'CkSocket_getAcceptFailReason'))
    (objHandle);
end;

procedure CkSocket_getAlpnProtocol (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getAlpnProtocol(_map(9, 'CkSocket_getAlpnProtocol'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putAlpnProtocol (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putAlpnProtocol(_map(10, 'CkSocket_putAlpnProtocol'))
    (objHandle, newPropVal);
end;

function CkSocket__alpnProtocol (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__alpnProtocol(_map(11, 'CkSocket__alpnProtocol'))
    (objHandle);
end;

function CkSocket_getBandwidthThrottleDown (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getBandwidthThrottleDown(_map(12, 'CkSocket_getBandwidthThrottleDown'))
    (objHandle);
end;

procedure CkSocket_putBandwidthThrottleDown (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putBandwidthThrottleDown(_map(13, 'CkSocket_putBandwidthThrottleDown'))
    (objHandle, newPropVal);
end;

function CkSocket_getBandwidthThrottleUp (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getBandwidthThrottleUp(_map(14, 'CkSocket_getBandwidthThrottleUp'))
    (objHandle);
end;

procedure CkSocket_putBandwidthThrottleUp (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putBandwidthThrottleUp(_map(15, 'CkSocket_putBandwidthThrottleUp'))
    (objHandle, newPropVal);
end;

function CkSocket_getBigEndian (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getBigEndian(_map(16, 'CkSocket_getBigEndian'))
    (objHandle);
end;

procedure CkSocket_putBigEndian (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putBigEndian(_map(17, 'CkSocket_putBigEndian'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getClientIpAddress (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getClientIpAddress(_map(18, 'CkSocket_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putClientIpAddress (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putClientIpAddress(_map(19, 'CkSocket_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkSocket__clientIpAddress (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__clientIpAddress(_map(20, 'CkSocket__clientIpAddress'))
    (objHandle);
end;

function CkSocket_getClientPort (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getClientPort(_map(21, 'CkSocket_getClientPort'))
    (objHandle);
end;

procedure CkSocket_putClientPort (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putClientPort(_map(22, 'CkSocket_putClientPort'))
    (objHandle, newPropVal);
end;

function CkSocket_getConnectFailReason (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getConnectFailReason(_map(23, 'CkSocket_getConnectFailReason'))
    (objHandle);
end;

procedure CkSocket_getDebugLogFilePath (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getDebugLogFilePath(_map(24, 'CkSocket_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putDebugLogFilePath (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putDebugLogFilePath(_map(25, 'CkSocket_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSocket__debugLogFilePath (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__debugLogFilePath(_map(26, 'CkSocket__debugLogFilePath'))
    (objHandle);
end;

function CkSocket_getElapsedSeconds (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getElapsedSeconds(_map(27, 'CkSocket_getElapsedSeconds'))
    (objHandle);
end;

function CkSocket_getHeartbeatMs (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getHeartbeatMs(_map(28, 'CkSocket_getHeartbeatMs'))
    (objHandle);
end;

procedure CkSocket_putHeartbeatMs (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putHeartbeatMs(_map(29, 'CkSocket_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getHttpProxyAuthMethod (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getHttpProxyAuthMethod(_map(30, 'CkSocket_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putHttpProxyAuthMethod (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putHttpProxyAuthMethod(_map(31, 'CkSocket_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkSocket__httpProxyAuthMethod (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__httpProxyAuthMethod(_map(32, 'CkSocket__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkSocket_getHttpProxyDomain (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getHttpProxyDomain(_map(33, 'CkSocket_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putHttpProxyDomain (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putHttpProxyDomain(_map(34, 'CkSocket_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkSocket__httpProxyDomain (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__httpProxyDomain(_map(35, 'CkSocket__httpProxyDomain'))
    (objHandle);
end;

function CkSocket_getHttpProxyForHttp (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getHttpProxyForHttp(_map(36, 'CkSocket_getHttpProxyForHttp'))
    (objHandle);
end;

procedure CkSocket_putHttpProxyForHttp (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putHttpProxyForHttp(_map(37, 'CkSocket_putHttpProxyForHttp'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getHttpProxyHostname (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getHttpProxyHostname(_map(38, 'CkSocket_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putHttpProxyHostname (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putHttpProxyHostname(_map(39, 'CkSocket_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkSocket__httpProxyHostname (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__httpProxyHostname(_map(40, 'CkSocket__httpProxyHostname'))
    (objHandle);
end;

procedure CkSocket_getHttpProxyPassword (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getHttpProxyPassword(_map(41, 'CkSocket_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putHttpProxyPassword (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putHttpProxyPassword(_map(42, 'CkSocket_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkSocket__httpProxyPassword (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__httpProxyPassword(_map(43, 'CkSocket__httpProxyPassword'))
    (objHandle);
end;

function CkSocket_getHttpProxyPort (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getHttpProxyPort(_map(44, 'CkSocket_getHttpProxyPort'))
    (objHandle);
end;

procedure CkSocket_putHttpProxyPort (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putHttpProxyPort(_map(45, 'CkSocket_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getHttpProxyUsername (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getHttpProxyUsername(_map(46, 'CkSocket_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putHttpProxyUsername (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putHttpProxyUsername(_map(47, 'CkSocket_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkSocket__httpProxyUsername (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__httpProxyUsername(_map(48, 'CkSocket__httpProxyUsername'))
    (objHandle);
end;

function CkSocket_getIsConnected (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getIsConnected(_map(49, 'CkSocket_getIsConnected'))
    (objHandle);
end;

function CkSocket_getKeepAlive (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getKeepAlive(_map(50, 'CkSocket_getKeepAlive'))
    (objHandle);
end;

procedure CkSocket_putKeepAlive (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putKeepAlive(_map(51, 'CkSocket_putKeepAlive'))
    (objHandle, newPropVal);
end;

function CkSocket_getKeepSessionLog (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getKeepSessionLog(_map(52, 'CkSocket_getKeepSessionLog'))
    (objHandle);
end;

procedure CkSocket_putKeepSessionLog (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putKeepSessionLog(_map(53, 'CkSocket_putKeepSessionLog'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getLastErrorHtml (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getLastErrorHtml(_map(54, 'CkSocket_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSocket__lastErrorHtml (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__lastErrorHtml(_map(55, 'CkSocket__lastErrorHtml'))
    (objHandle);
end;

procedure CkSocket_getLastErrorText (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getLastErrorText(_map(56, 'CkSocket_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSocket__lastErrorText (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__lastErrorText(_map(57, 'CkSocket__lastErrorText'))
    (objHandle);
end;

procedure CkSocket_getLastErrorXml (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getLastErrorXml(_map(58, 'CkSocket_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSocket__lastErrorXml (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__lastErrorXml(_map(59, 'CkSocket__lastErrorXml'))
    (objHandle);
end;

function CkSocket_getLastMethodFailed (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getLastMethodFailed(_map(60, 'CkSocket_getLastMethodFailed'))
    (objHandle);
end;

function CkSocket_getLastMethodSuccess (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getLastMethodSuccess(_map(61, 'CkSocket_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSocket_putLastMethodSuccess (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putLastMethodSuccess(_map(62, 'CkSocket_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkSocket_getListenIpv6 (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getListenIpv6(_map(63, 'CkSocket_getListenIpv6'))
    (objHandle);
end;

procedure CkSocket_putListenIpv6 (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putListenIpv6(_map(64, 'CkSocket_putListenIpv6'))
    (objHandle, newPropVal);
end;

function CkSocket_getListenPort (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getListenPort(_map(65, 'CkSocket_getListenPort'))
    (objHandle);
end;

procedure CkSocket_getLocalIpAddress (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getLocalIpAddress(_map(66, 'CkSocket_getLocalIpAddress'))
    (objHandle, outPropVal);
end;

function CkSocket__localIpAddress (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__localIpAddress(_map(67, 'CkSocket__localIpAddress'))
    (objHandle);
end;

function CkSocket_getLocalPort (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getLocalPort(_map(68, 'CkSocket_getLocalPort'))
    (objHandle);
end;

function CkSocket_getMaxReadIdleMs (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getMaxReadIdleMs(_map(69, 'CkSocket_getMaxReadIdleMs'))
    (objHandle);
end;

procedure CkSocket_putMaxReadIdleMs (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putMaxReadIdleMs(_map(70, 'CkSocket_putMaxReadIdleMs'))
    (objHandle, newPropVal);
end;

function CkSocket_getMaxSendIdleMs (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getMaxSendIdleMs(_map(71, 'CkSocket_getMaxSendIdleMs'))
    (objHandle);
end;

procedure CkSocket_putMaxSendIdleMs (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putMaxSendIdleMs(_map(72, 'CkSocket_putMaxSendIdleMs'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getMyIpAddress (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getMyIpAddress(_map(73, 'CkSocket_getMyIpAddress'))
    (objHandle, outPropVal);
end;

function CkSocket__myIpAddress (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__myIpAddress(_map(74, 'CkSocket__myIpAddress'))
    (objHandle);
end;

function CkSocket_getNumBytesAvailable (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getNumBytesAvailable(_map(75, 'CkSocket_getNumBytesAvailable'))
    (objHandle);
end;

function CkSocket_getNumReceivedClientCerts (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getNumReceivedClientCerts(_map(76, 'CkSocket_getNumReceivedClientCerts'))
    (objHandle);
end;

function CkSocket_getNumSocketsInSet (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getNumSocketsInSet(_map(77, 'CkSocket_getNumSocketsInSet'))
    (objHandle);
end;

function CkSocket_getNumSslAcceptableClientCAs (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getNumSslAcceptableClientCAs(_map(78, 'CkSocket_getNumSslAcceptableClientCAs'))
    (objHandle);
end;

function CkSocket_getObjectId (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getObjectId(_map(79, 'CkSocket_getObjectId'))
    (objHandle);
end;

function CkSocket_getPercentDoneScale (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getPercentDoneScale(_map(80, 'CkSocket_getPercentDoneScale'))
    (objHandle);
end;

procedure CkSocket_putPercentDoneScale (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putPercentDoneScale(_map(81, 'CkSocket_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkSocket_getPreferIpv6 (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getPreferIpv6(_map(82, 'CkSocket_getPreferIpv6'))
    (objHandle);
end;

procedure CkSocket_putPreferIpv6 (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putPreferIpv6(_map(83, 'CkSocket_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkSocket_getRcvBytesPerSec (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getRcvBytesPerSec(_map(84, 'CkSocket_getRcvBytesPerSec'))
    (objHandle);
end;

function CkSocket_getReceivedCount (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getReceivedCount(_map(85, 'CkSocket_getReceivedCount'))
    (objHandle);
end;

procedure CkSocket_putReceivedCount (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putReceivedCount(_map(86, 'CkSocket_putReceivedCount'))
    (objHandle, newPropVal);
end;

function CkSocket_getReceivedInt (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getReceivedInt(_map(87, 'CkSocket_getReceivedInt'))
    (objHandle);
end;

procedure CkSocket_putReceivedInt (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putReceivedInt(_map(88, 'CkSocket_putReceivedInt'))
    (objHandle, newPropVal);
end;

function CkSocket_getReceiveFailReason (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getReceiveFailReason(_map(89, 'CkSocket_getReceiveFailReason'))
    (objHandle);
end;

function CkSocket_getReceivePacketSize (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getReceivePacketSize(_map(90, 'CkSocket_getReceivePacketSize'))
    (objHandle);
end;

procedure CkSocket_putReceivePacketSize (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putReceivePacketSize(_map(91, 'CkSocket_putReceivePacketSize'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getRemoteIpAddress (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getRemoteIpAddress(_map(92, 'CkSocket_getRemoteIpAddress'))
    (objHandle, outPropVal);
end;

function CkSocket__remoteIpAddress (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__remoteIpAddress(_map(93, 'CkSocket__remoteIpAddress'))
    (objHandle);
end;

function CkSocket_getRemotePort (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getRemotePort(_map(94, 'CkSocket_getRemotePort'))
    (objHandle);
end;

function CkSocket_getRequireSslCertVerify (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getRequireSslCertVerify(_map(95, 'CkSocket_getRequireSslCertVerify'))
    (objHandle);
end;

procedure CkSocket_putRequireSslCertVerify (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putRequireSslCertVerify(_map(96, 'CkSocket_putRequireSslCertVerify'))
    (objHandle, newPropVal);
end;

function CkSocket_getSelectorIndex (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSelectorIndex(_map(97, 'CkSocket_getSelectorIndex'))
    (objHandle);
end;

procedure CkSocket_putSelectorIndex (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSelectorIndex(_map(98, 'CkSocket_putSelectorIndex'))
    (objHandle, newPropVal);
end;

function CkSocket_getSelectorReadIndex (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSelectorReadIndex(_map(99, 'CkSocket_getSelectorReadIndex'))
    (objHandle);
end;

procedure CkSocket_putSelectorReadIndex (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSelectorReadIndex(_map(100, 'CkSocket_putSelectorReadIndex'))
    (objHandle, newPropVal);
end;

function CkSocket_getSelectorWriteIndex (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSelectorWriteIndex(_map(101, 'CkSocket_getSelectorWriteIndex'))
    (objHandle);
end;

procedure CkSocket_putSelectorWriteIndex (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSelectorWriteIndex(_map(102, 'CkSocket_putSelectorWriteIndex'))
    (objHandle, newPropVal);
end;

function CkSocket_getSendBytesPerSec (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSendBytesPerSec(_map(103, 'CkSocket_getSendBytesPerSec'))
    (objHandle);
end;

function CkSocket_getSendFailReason (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSendFailReason(_map(104, 'CkSocket_getSendFailReason'))
    (objHandle);
end;

function CkSocket_getSendPacketSize (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSendPacketSize(_map(105, 'CkSocket_getSendPacketSize'))
    (objHandle);
end;

procedure CkSocket_putSendPacketSize (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSendPacketSize(_map(106, 'CkSocket_putSendPacketSize'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getSessionLog (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSessionLog(_map(107, 'CkSocket_getSessionLog'))
    (objHandle, outPropVal);
end;

function CkSocket__sessionLog (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__sessionLog(_map(108, 'CkSocket__sessionLog'))
    (objHandle);
end;

procedure CkSocket_getSessionLogEncoding (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSessionLogEncoding(_map(109, 'CkSocket_getSessionLogEncoding'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSessionLogEncoding (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSessionLogEncoding(_map(110, 'CkSocket_putSessionLogEncoding'))
    (objHandle, newPropVal);
end;

function CkSocket__sessionLogEncoding (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__sessionLogEncoding(_map(111, 'CkSocket__sessionLogEncoding'))
    (objHandle);
end;

procedure CkSocket_getSniHostname (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSniHostname(_map(112, 'CkSocket_getSniHostname'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSniHostname (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSniHostname(_map(113, 'CkSocket_putSniHostname'))
    (objHandle, newPropVal);
end;

function CkSocket__sniHostname (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__sniHostname(_map(114, 'CkSocket__sniHostname'))
    (objHandle);
end;

procedure CkSocket_getSocksHostname (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSocksHostname(_map(115, 'CkSocket_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSocksHostname (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSocksHostname(_map(116, 'CkSocket_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkSocket__socksHostname (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__socksHostname(_map(117, 'CkSocket__socksHostname'))
    (objHandle);
end;

procedure CkSocket_getSocksPassword (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSocksPassword(_map(118, 'CkSocket_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSocksPassword (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSocksPassword(_map(119, 'CkSocket_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkSocket__socksPassword (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__socksPassword(_map(120, 'CkSocket__socksPassword'))
    (objHandle);
end;

function CkSocket_getSocksPort (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSocksPort(_map(121, 'CkSocket_getSocksPort'))
    (objHandle);
end;

procedure CkSocket_putSocksPort (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSocksPort(_map(122, 'CkSocket_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getSocksUsername (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSocksUsername(_map(123, 'CkSocket_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSocksUsername (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSocksUsername(_map(124, 'CkSocket_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkSocket__socksUsername (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__socksUsername(_map(125, 'CkSocket__socksUsername'))
    (objHandle);
end;

function CkSocket_getSocksVersion (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSocksVersion(_map(126, 'CkSocket_getSocksVersion'))
    (objHandle);
end;

procedure CkSocket_putSocksVersion (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSocksVersion(_map(127, 'CkSocket_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkSocket_getSoRcvBuf (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSoRcvBuf(_map(128, 'CkSocket_getSoRcvBuf'))
    (objHandle);
end;

procedure CkSocket_putSoRcvBuf (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSoRcvBuf(_map(129, 'CkSocket_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkSocket_getSoReuseAddr (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getSoReuseAddr(_map(130, 'CkSocket_getSoReuseAddr'))
    (objHandle);
end;

procedure CkSocket_putSoReuseAddr (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putSoReuseAddr(_map(131, 'CkSocket_putSoReuseAddr'))
    (objHandle, newPropVal);
end;

function CkSocket_getSoSndBuf (objHandle: HCkSocket): Integer;
begin
    result := TCkSocket_getSoSndBuf(_map(132, 'CkSocket_getSoSndBuf'))
    (objHandle);
end;

procedure CkSocket_putSoSndBuf (objHandle: HCkSocket; newPropVal: Integer);
begin
  TCkSocket_putSoSndBuf(_map(133, 'CkSocket_putSoSndBuf'))
    (objHandle, newPropVal);
end;

function CkSocket_getSsl (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getSsl(_map(134, 'CkSocket_getSsl'))
    (objHandle);
end;

procedure CkSocket_putSsl (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putSsl(_map(135, 'CkSocket_putSsl'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getSslAllowedCiphers (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSslAllowedCiphers(_map(136, 'CkSocket_getSslAllowedCiphers'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSslAllowedCiphers (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSslAllowedCiphers(_map(137, 'CkSocket_putSslAllowedCiphers'))
    (objHandle, newPropVal);
end;

function CkSocket__sslAllowedCiphers (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__sslAllowedCiphers(_map(138, 'CkSocket__sslAllowedCiphers'))
    (objHandle);
end;

procedure CkSocket_getSslProtocol (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getSslProtocol(_map(139, 'CkSocket_getSslProtocol'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putSslProtocol (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putSslProtocol(_map(140, 'CkSocket_putSslProtocol'))
    (objHandle, newPropVal);
end;

function CkSocket__sslProtocol (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__sslProtocol(_map(141, 'CkSocket__sslProtocol'))
    (objHandle);
end;

procedure CkSocket_getStringCharset (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getStringCharset(_map(142, 'CkSocket_getStringCharset'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putStringCharset (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putStringCharset(_map(143, 'CkSocket_putStringCharset'))
    (objHandle, newPropVal);
end;

function CkSocket__stringCharset (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__stringCharset(_map(144, 'CkSocket__stringCharset'))
    (objHandle);
end;

function CkSocket_getTcpNoDelay (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getTcpNoDelay(_map(145, 'CkSocket_getTcpNoDelay'))
    (objHandle);
end;

procedure CkSocket_putTcpNoDelay (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putTcpNoDelay(_map(146, 'CkSocket_putTcpNoDelay'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getTlsCipherSuite (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getTlsCipherSuite(_map(147, 'CkSocket_getTlsCipherSuite'))
    (objHandle, outPropVal);
end;

function CkSocket__tlsCipherSuite (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__tlsCipherSuite(_map(148, 'CkSocket__tlsCipherSuite'))
    (objHandle);
end;

procedure CkSocket_getTlsPinSet (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getTlsPinSet(_map(149, 'CkSocket_getTlsPinSet'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putTlsPinSet (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putTlsPinSet(_map(150, 'CkSocket_putTlsPinSet'))
    (objHandle, newPropVal);
end;

function CkSocket__tlsPinSet (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__tlsPinSet(_map(151, 'CkSocket__tlsPinSet'))
    (objHandle);
end;

procedure CkSocket_getTlsVersion (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getTlsVersion(_map(152, 'CkSocket_getTlsVersion'))
    (objHandle, outPropVal);
end;

function CkSocket__tlsVersion (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__tlsVersion(_map(153, 'CkSocket__tlsVersion'))
    (objHandle);
end;

procedure CkSocket_getUncommonOptions (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getUncommonOptions(_map(154, 'CkSocket_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putUncommonOptions (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putUncommonOptions(_map(155, 'CkSocket_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkSocket__uncommonOptions (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__uncommonOptions(_map(156, 'CkSocket__uncommonOptions'))
    (objHandle);
end;

procedure CkSocket_getUserData (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getUserData(_map(157, 'CkSocket_getUserData'))
    (objHandle, outPropVal);
end;

procedure CkSocket_putUserData (objHandle: HCkSocket; newPropVal: PWideChar);
begin
  TCkSocket_putUserData(_map(158, 'CkSocket_putUserData'))
    (objHandle, newPropVal);
end;

function CkSocket__userData (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__userData(_map(159, 'CkSocket__userData'))
    (objHandle);
end;

function CkSocket_getVerboseLogging (objHandle: HCkSocket): wordbool;
begin
    result := TCkSocket_getVerboseLogging(_map(160, 'CkSocket_getVerboseLogging'))
    (objHandle);
end;

procedure CkSocket_putVerboseLogging (objHandle: HCkSocket; newPropVal: wordbool);
begin
  TCkSocket_putVerboseLogging(_map(161, 'CkSocket_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSocket_getVersion (objHandle: HCkSocket; outPropVal: HCkString);
begin
  TCkSocket_getVersion(_map(162, 'CkSocket_getVersion'))
    (objHandle, outPropVal);
end;

function CkSocket__version (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__version(_map(163, 'CkSocket__version'))
    (objHandle);
end;

function CkSocket_AcceptNext (objHandle: HCkSocket; maxWaitMs: Integer; socket: HCkSocket): wordbool;
begin
  result := TCkSocket_AcceptNext(_map(164, 'CkSocket_AcceptNext'))
    (objHandle, maxWaitMs, socket);
end;

function CkSocket_AcceptNextAsync (objHandle: HCkSocket; maxWaitMs: Integer; socket: HCkSocket): HCkTask;
begin
  result := TCkSocket_AcceptNextAsync(_map(165, 'CkSocket_AcceptNextAsync'))
    (objHandle, maxWaitMs, socket);
end;

function CkSocket_AcceptNextConnection (objHandle: HCkSocket; maxWaitMs: Integer): HCkSocket;
begin
  result := TCkSocket_AcceptNextConnection(_map(166, 'CkSocket_AcceptNextConnection'))
    (objHandle, maxWaitMs);
end;

function CkSocket_AcceptNextConnectionAsync (objHandle: HCkSocket; maxWaitMs: Integer): HCkTask;
begin
  result := TCkSocket_AcceptNextConnectionAsync(_map(167, 'CkSocket_AcceptNextConnectionAsync'))
    (objHandle, maxWaitMs);
end;

function CkSocket_AddSslAcceptableClientCaDn (objHandle: HCkSocket; certAuthDN: PWideChar): wordbool;
begin
  result := TCkSocket_AddSslAcceptableClientCaDn(_map(168, 'CkSocket_AddSslAcceptableClientCaDn'))
    (objHandle, certAuthDN);
end;

function CkSocket_BindAndListen (objHandle: HCkSocket; port: Integer; backLog: Integer): wordbool;
begin
  result := TCkSocket_BindAndListen(_map(169, 'CkSocket_BindAndListen'))
    (objHandle, port, backLog);
end;

function CkSocket_BindAndListenAsync (objHandle: HCkSocket; port: Integer; backLog: Integer): HCkTask;
begin
  result := TCkSocket_BindAndListenAsync(_map(170, 'CkSocket_BindAndListenAsync'))
    (objHandle, port, backLog);
end;

function CkSocket_BindAndListenPortRange (objHandle: HCkSocket; beginPort: Integer; endPort: Integer; backLog: Integer): Integer;
begin
  result := TCkSocket_BindAndListenPortRange(_map(171, 'CkSocket_BindAndListenPortRange'))
    (objHandle, beginPort, endPort, backLog);
end;

function CkSocket_BindAndListenPortRangeAsync (objHandle: HCkSocket; beginPort: Integer; endPort: Integer; backLog: Integer): HCkTask;
begin
  result := TCkSocket_BindAndListenPortRangeAsync(_map(172, 'CkSocket_BindAndListenPortRangeAsync'))
    (objHandle, beginPort, endPort, backLog);
end;

function CkSocket_BuildHttpGetRequest (objHandle: HCkSocket; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSocket_BuildHttpGetRequest(_map(173, 'CkSocket_BuildHttpGetRequest'))
    (objHandle, url, outStr);
end;

function CkSocket__buildHttpGetRequest (objHandle: HCkSocket; url: PWideChar): PWideChar;
begin
  result := TCkSocket__buildHttpGetRequest(_map(174, 'CkSocket__buildHttpGetRequest'))
    (objHandle, url);
end;

function CkSocket_CheckWriteable (objHandle: HCkSocket; maxWaitMs: Integer): Integer;
begin
  result := TCkSocket_CheckWriteable(_map(175, 'CkSocket_CheckWriteable'))
    (objHandle, maxWaitMs);
end;

function CkSocket_CheckWriteableAsync (objHandle: HCkSocket; maxWaitMs: Integer): HCkTask;
begin
  result := TCkSocket_CheckWriteableAsync(_map(176, 'CkSocket_CheckWriteableAsync'))
    (objHandle, maxWaitMs);
end;

procedure CkSocket_ClearSessionLog (objHandle: HCkSocket);
begin
  TCkSocket_ClearSessionLog(_map(177, 'CkSocket_ClearSessionLog'))
    (objHandle);
end;

function CkSocket_CloneSocket (objHandle: HCkSocket): HCkSocket;
begin
  result := TCkSocket_CloneSocket(_map(178, 'CkSocket_CloneSocket'))
    (objHandle);
end;

function CkSocket_Close (objHandle: HCkSocket; maxWaitMs: Integer): wordbool;
begin
  result := TCkSocket_Close(_map(179, 'CkSocket_Close'))
    (objHandle, maxWaitMs);
end;

function CkSocket_CloseAsync (objHandle: HCkSocket; maxWaitMs: Integer): HCkTask;
begin
  result := TCkSocket_CloseAsync(_map(180, 'CkSocket_CloseAsync'))
    (objHandle, maxWaitMs);
end;

function CkSocket_Connect (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): wordbool;
begin
  result := TCkSocket_Connect(_map(181, 'CkSocket_Connect'))
    (objHandle, hostname, port, ssl, maxWaitMs);
end;

function CkSocket_ConnectAsync (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkTask;
begin
  result := TCkSocket_ConnectAsync(_map(182, 'CkSocket_ConnectAsync'))
    (objHandle, hostname, port, ssl, maxWaitMs);
end;

function CkSocket_ConvertFromSsl (objHandle: HCkSocket): wordbool;
begin
  result := TCkSocket_ConvertFromSsl(_map(183, 'CkSocket_ConvertFromSsl'))
    (objHandle);
end;

function CkSocket_ConvertFromSslAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_ConvertFromSslAsync(_map(184, 'CkSocket_ConvertFromSslAsync'))
    (objHandle);
end;

function CkSocket_ConvertToSsl (objHandle: HCkSocket): wordbool;
begin
  result := TCkSocket_ConvertToSsl(_map(185, 'CkSocket_ConvertToSsl'))
    (objHandle);
end;

function CkSocket_ConvertToSslAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_ConvertToSslAsync(_map(186, 'CkSocket_ConvertToSslAsync'))
    (objHandle);
end;

procedure CkSocket_DnsCacheClear (objHandle: HCkSocket);
begin
  TCkSocket_DnsCacheClear(_map(187, 'CkSocket_DnsCacheClear'))
    (objHandle);
end;

function CkSocket_DnsLookup (objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSocket_DnsLookup(_map(188, 'CkSocket_DnsLookup'))
    (objHandle, hostname, maxWaitMs, outStr);
end;

function CkSocket__dnsLookup (objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer): PWideChar;
begin
  result := TCkSocket__dnsLookup(_map(189, 'CkSocket__dnsLookup'))
    (objHandle, hostname, maxWaitMs);
end;

function CkSocket_DnsLookupAsync (objHandle: HCkSocket; hostname: PWideChar; maxWaitMs: Integer): HCkTask;
begin
  result := TCkSocket_DnsLookupAsync(_map(190, 'CkSocket_DnsLookupAsync'))
    (objHandle, hostname, maxWaitMs);
end;

function CkSocket_DupSocket (objHandle: HCkSocket; dest: HCkSocket): wordbool;
begin
  result := TCkSocket_DupSocket(_map(191, 'CkSocket_DupSocket'))
    (objHandle, dest);
end;

function CkSocket_GetAdaptersAddresses (objHandle: HCkSocket; json: HCkJsonObject): wordbool;
begin
  result := TCkSocket_GetAdaptersAddresses(_map(192, 'CkSocket_GetAdaptersAddresses'))
    (objHandle, json);
end;

procedure CkSocket_GetLastJsonData (objHandle: HCkSocket; json: HCkJsonObject);
begin
  TCkSocket_GetLastJsonData(_map(193, 'CkSocket_GetLastJsonData'))
    (objHandle, json);
end;

function CkSocket_GetMyCert (objHandle: HCkSocket): HCkCert;
begin
  result := TCkSocket_GetMyCert(_map(194, 'CkSocket_GetMyCert'))
    (objHandle);
end;

function CkSocket_GetMyServerCert (objHandle: HCkSocket; cert: HCkCert): wordbool;
begin
  result := TCkSocket_GetMyServerCert(_map(195, 'CkSocket_GetMyServerCert'))
    (objHandle, cert);
end;

function CkSocket_GetRcvdClientCert (objHandle: HCkSocket; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkSocket_GetRcvdClientCert(_map(196, 'CkSocket_GetRcvdClientCert'))
    (objHandle, index, cert);
end;

function CkSocket_GetReceivedClientCert (objHandle: HCkSocket; index: Integer): HCkCert;
begin
  result := TCkSocket_GetReceivedClientCert(_map(197, 'CkSocket_GetReceivedClientCert'))
    (objHandle, index);
end;

function CkSocket_GetServerCert (objHandle: HCkSocket; cert: HCkCert): wordbool;
begin
  result := TCkSocket_GetServerCert(_map(198, 'CkSocket_GetServerCert'))
    (objHandle, cert);
end;

function CkSocket_GetSslAcceptableClientCaDn (objHandle: HCkSocket; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSocket_GetSslAcceptableClientCaDn(_map(199, 'CkSocket_GetSslAcceptableClientCaDn'))
    (objHandle, index, outStr);
end;

function CkSocket__getSslAcceptableClientCaDn (objHandle: HCkSocket; index: Integer): PWideChar;
begin
  result := TCkSocket__getSslAcceptableClientCaDn(_map(200, 'CkSocket__getSslAcceptableClientCaDn'))
    (objHandle, index);
end;

function CkSocket_GetSslServerCert (objHandle: HCkSocket): HCkCert;
begin
  result := TCkSocket_GetSslServerCert(_map(201, 'CkSocket_GetSslServerCert'))
    (objHandle);
end;

function CkSocket_InitSslServer (objHandle: HCkSocket; cert: HCkCert): wordbool;
begin
  result := TCkSocket_InitSslServer(_map(202, 'CkSocket_InitSslServer'))
    (objHandle, cert);
end;

function CkSocket_LastJsonData (objHandle: HCkSocket): HCkJsonObject;
begin
  result := TCkSocket_LastJsonData(_map(203, 'CkSocket_LastJsonData'))
    (objHandle);
end;

function CkSocket_LoadTaskCaller (objHandle: HCkSocket; task: HCkTask): wordbool;
begin
  result := TCkSocket_LoadTaskCaller(_map(204, 'CkSocket_LoadTaskCaller'))
    (objHandle, task);
end;

function CkSocket_LoadTaskResult (objHandle: HCkSocket; task: HCkTask): wordbool;
begin
  result := TCkSocket_LoadTaskResult(_map(205, 'CkSocket_LoadTaskResult'))
    (objHandle, task);
end;

function CkSocket_PollDataAvailable (objHandle: HCkSocket): wordbool;
begin
  result := TCkSocket_PollDataAvailable(_map(206, 'CkSocket_PollDataAvailable'))
    (objHandle);
end;

function CkSocket_PollDataAvailableAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_PollDataAvailableAsync(_map(207, 'CkSocket_PollDataAvailableAsync'))
    (objHandle);
end;

function CkSocket_ReceiveBd (objHandle: HCkSocket; binData: HCkBinData): wordbool;
begin
  result := TCkSocket_ReceiveBd(_map(208, 'CkSocket_ReceiveBd'))
    (objHandle, binData);
end;

function CkSocket_ReceiveBdAsync (objHandle: HCkSocket; binData: HCkBinData): HCkTask;
begin
  result := TCkSocket_ReceiveBdAsync(_map(209, 'CkSocket_ReceiveBdAsync'))
    (objHandle, binData);
end;

function CkSocket_ReceiveBdN (objHandle: HCkSocket; numBytes: LongWord; binData: HCkBinData): wordbool;
begin
  result := TCkSocket_ReceiveBdN(_map(210, 'CkSocket_ReceiveBdN'))
    (objHandle, numBytes, binData);
end;

function CkSocket_ReceiveBdNAsync (objHandle: HCkSocket; numBytes: LongWord; binData: HCkBinData): HCkTask;
begin
  result := TCkSocket_ReceiveBdNAsync(_map(211, 'CkSocket_ReceiveBdNAsync'))
    (objHandle, numBytes, binData);
end;

function CkSocket_ReceiveByte (objHandle: HCkSocket; bUnsigned: wordbool): wordbool;
begin
  result := TCkSocket_ReceiveByte(_map(212, 'CkSocket_ReceiveByte'))
    (objHandle, bUnsigned);
end;

function CkSocket_ReceiveByteAsync (objHandle: HCkSocket; bUnsigned: wordbool): HCkTask;
begin
  result := TCkSocket_ReceiveByteAsync(_map(213, 'CkSocket_ReceiveByteAsync'))
    (objHandle, bUnsigned);
end;

function CkSocket_ReceiveBytes (objHandle: HCkSocket; outData: HCkByteData): wordbool;
begin
  result := TCkSocket_ReceiveBytes(_map(214, 'CkSocket_ReceiveBytes'))
    (objHandle, outData);
end;

function CkSocket_ReceiveBytesAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_ReceiveBytesAsync(_map(215, 'CkSocket_ReceiveBytesAsync'))
    (objHandle);
end;

function CkSocket_ReceiveBytesENC (objHandle: HCkSocket; encodingAlg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveBytesENC(_map(216, 'CkSocket_ReceiveBytesENC'))
    (objHandle, encodingAlg, outStr);
end;

function CkSocket__receiveBytesENC (objHandle: HCkSocket; encodingAlg: PWideChar): PWideChar;
begin
  result := TCkSocket__receiveBytesENC(_map(217, 'CkSocket__receiveBytesENC'))
    (objHandle, encodingAlg);
end;

function CkSocket_ReceiveBytesENCAsync (objHandle: HCkSocket; encodingAlg: PWideChar): HCkTask;
begin
  result := TCkSocket_ReceiveBytesENCAsync(_map(218, 'CkSocket_ReceiveBytesENCAsync'))
    (objHandle, encodingAlg);
end;

function CkSocket_ReceiveBytesN (objHandle: HCkSocket; numBytes: LongWord; outData: HCkByteData): wordbool;
begin
  result := TCkSocket_ReceiveBytesN(_map(219, 'CkSocket_ReceiveBytesN'))
    (objHandle, numBytes, outData);
end;

function CkSocket_ReceiveBytesNAsync (objHandle: HCkSocket; numBytes: LongWord): HCkTask;
begin
  result := TCkSocket_ReceiveBytesNAsync(_map(220, 'CkSocket_ReceiveBytesNAsync'))
    (objHandle, numBytes);
end;

function CkSocket_ReceiveBytesToFile (objHandle: HCkSocket; appendFilename: PWideChar): wordbool;
begin
  result := TCkSocket_ReceiveBytesToFile(_map(221, 'CkSocket_ReceiveBytesToFile'))
    (objHandle, appendFilename);
end;

function CkSocket_ReceiveBytesToFileAsync (objHandle: HCkSocket; appendFilename: PWideChar): HCkTask;
begin
  result := TCkSocket_ReceiveBytesToFileAsync(_map(222, 'CkSocket_ReceiveBytesToFileAsync'))
    (objHandle, appendFilename);
end;

function CkSocket_ReceiveCount (objHandle: HCkSocket): Integer;
begin
  result := TCkSocket_ReceiveCount(_map(223, 'CkSocket_ReceiveCount'))
    (objHandle);
end;

function CkSocket_ReceiveCountAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_ReceiveCountAsync(_map(224, 'CkSocket_ReceiveCountAsync'))
    (objHandle);
end;

function CkSocket_ReceiveInt16 (objHandle: HCkSocket; bigEndian: wordbool; bUnsigned: wordbool): wordbool;
begin
  result := TCkSocket_ReceiveInt16(_map(225, 'CkSocket_ReceiveInt16'))
    (objHandle, bigEndian, bUnsigned);
end;

function CkSocket_ReceiveInt16Async (objHandle: HCkSocket; bigEndian: wordbool; bUnsigned: wordbool): HCkTask;
begin
  result := TCkSocket_ReceiveInt16Async(_map(226, 'CkSocket_ReceiveInt16Async'))
    (objHandle, bigEndian, bUnsigned);
end;

function CkSocket_ReceiveInt32 (objHandle: HCkSocket; bigEndian: wordbool): wordbool;
begin
  result := TCkSocket_ReceiveInt32(_map(227, 'CkSocket_ReceiveInt32'))
    (objHandle, bigEndian);
end;

function CkSocket_ReceiveInt32Async (objHandle: HCkSocket; bigEndian: wordbool): HCkTask;
begin
  result := TCkSocket_ReceiveInt32Async(_map(228, 'CkSocket_ReceiveInt32Async'))
    (objHandle, bigEndian);
end;

function CkSocket_ReceiveNBytesENC (objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveNBytesENC(_map(229, 'CkSocket_ReceiveNBytesENC'))
    (objHandle, numBytes, encodingAlg, outStr);
end;

function CkSocket__receiveNBytesENC (objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar): PWideChar;
begin
  result := TCkSocket__receiveNBytesENC(_map(230, 'CkSocket__receiveNBytesENC'))
    (objHandle, numBytes, encodingAlg);
end;

function CkSocket_ReceiveNBytesENCAsync (objHandle: HCkSocket; numBytes: LongWord; encodingAlg: PWideChar): HCkTask;
begin
  result := TCkSocket_ReceiveNBytesENCAsync(_map(231, 'CkSocket_ReceiveNBytesENCAsync'))
    (objHandle, numBytes, encodingAlg);
end;

function CkSocket_ReceiveSb (objHandle: HCkSocket; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSocket_ReceiveSb(_map(232, 'CkSocket_ReceiveSb'))
    (objHandle, sb);
end;

function CkSocket_ReceiveSbAsync (objHandle: HCkSocket; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkSocket_ReceiveSbAsync(_map(233, 'CkSocket_ReceiveSbAsync'))
    (objHandle, sb);
end;

function CkSocket_ReceiveString (objHandle: HCkSocket; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveString(_map(234, 'CkSocket_ReceiveString'))
    (objHandle, outStr);
end;

function CkSocket__receiveString (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__receiveString(_map(235, 'CkSocket__receiveString'))
    (objHandle);
end;

function CkSocket_ReceiveStringAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_ReceiveStringAsync(_map(236, 'CkSocket_ReceiveStringAsync'))
    (objHandle);
end;

function CkSocket_ReceiveStringMaxN (objHandle: HCkSocket; maxByteCount: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveStringMaxN(_map(237, 'CkSocket_ReceiveStringMaxN'))
    (objHandle, maxByteCount, outStr);
end;

function CkSocket__receiveStringMaxN (objHandle: HCkSocket; maxByteCount: Integer): PWideChar;
begin
  result := TCkSocket__receiveStringMaxN(_map(238, 'CkSocket__receiveStringMaxN'))
    (objHandle, maxByteCount);
end;

function CkSocket_ReceiveStringMaxNAsync (objHandle: HCkSocket; maxByteCount: Integer): HCkTask;
begin
  result := TCkSocket_ReceiveStringMaxNAsync(_map(239, 'CkSocket_ReceiveStringMaxNAsync'))
    (objHandle, maxByteCount);
end;

function CkSocket_ReceiveStringUntilByte (objHandle: HCkSocket; lookForByte: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveStringUntilByte(_map(240, 'CkSocket_ReceiveStringUntilByte'))
    (objHandle, lookForByte, outStr);
end;

function CkSocket__receiveStringUntilByte (objHandle: HCkSocket; lookForByte: Integer): PWideChar;
begin
  result := TCkSocket__receiveStringUntilByte(_map(241, 'CkSocket__receiveStringUntilByte'))
    (objHandle, lookForByte);
end;

function CkSocket_ReceiveStringUntilByteAsync (objHandle: HCkSocket; lookForByte: Integer): HCkTask;
begin
  result := TCkSocket_ReceiveStringUntilByteAsync(_map(242, 'CkSocket_ReceiveStringUntilByteAsync'))
    (objHandle, lookForByte);
end;

function CkSocket_ReceiveToCRLF (objHandle: HCkSocket; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveToCRLF(_map(243, 'CkSocket_ReceiveToCRLF'))
    (objHandle, outStr);
end;

function CkSocket__receiveToCRLF (objHandle: HCkSocket): PWideChar;
begin
  result := TCkSocket__receiveToCRLF(_map(244, 'CkSocket__receiveToCRLF'))
    (objHandle);
end;

function CkSocket_ReceiveToCRLFAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_ReceiveToCRLFAsync(_map(245, 'CkSocket_ReceiveToCRLFAsync'))
    (objHandle);
end;

function CkSocket_ReceiveUntilByte (objHandle: HCkSocket; lookForByte: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSocket_ReceiveUntilByte(_map(246, 'CkSocket_ReceiveUntilByte'))
    (objHandle, lookForByte, outData);
end;

function CkSocket_ReceiveUntilByteAsync (objHandle: HCkSocket; lookForByte: Integer): HCkTask;
begin
  result := TCkSocket_ReceiveUntilByteAsync(_map(247, 'CkSocket_ReceiveUntilByteAsync'))
    (objHandle, lookForByte);
end;

function CkSocket_ReceiveUntilByteBd (objHandle: HCkSocket; lookForByte: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkSocket_ReceiveUntilByteBd(_map(248, 'CkSocket_ReceiveUntilByteBd'))
    (objHandle, lookForByte, bd);
end;

function CkSocket_ReceiveUntilByteBdAsync (objHandle: HCkSocket; lookForByte: Integer; bd: HCkBinData): HCkTask;
begin
  result := TCkSocket_ReceiveUntilByteBdAsync(_map(249, 'CkSocket_ReceiveUntilByteBdAsync'))
    (objHandle, lookForByte, bd);
end;

function CkSocket_ReceiveUntilMatch (objHandle: HCkSocket; matchStr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSocket_ReceiveUntilMatch(_map(250, 'CkSocket_ReceiveUntilMatch'))
    (objHandle, matchStr, outStr);
end;

function CkSocket__receiveUntilMatch (objHandle: HCkSocket; matchStr: PWideChar): PWideChar;
begin
  result := TCkSocket__receiveUntilMatch(_map(251, 'CkSocket__receiveUntilMatch'))
    (objHandle, matchStr);
end;

function CkSocket_ReceiveUntilMatchAsync (objHandle: HCkSocket; matchStr: PWideChar): HCkTask;
begin
  result := TCkSocket_ReceiveUntilMatchAsync(_map(252, 'CkSocket_ReceiveUntilMatchAsync'))
    (objHandle, matchStr);
end;

function CkSocket_ReceiveUntilMatchSb (objHandle: HCkSocket; matchStr: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSocket_ReceiveUntilMatchSb(_map(253, 'CkSocket_ReceiveUntilMatchSb'))
    (objHandle, matchStr, sb);
end;

function CkSocket_ReceiveUntilMatchSbAsync (objHandle: HCkSocket; matchStr: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkSocket_ReceiveUntilMatchSbAsync(_map(254, 'CkSocket_ReceiveUntilMatchSbAsync'))
    (objHandle, matchStr, sb);
end;

procedure CkSocket_ResetPerf (objHandle: HCkSocket; rcvPerf: wordbool);
begin
  TCkSocket_ResetPerf(_map(255, 'CkSocket_ResetPerf'))
    (objHandle, rcvPerf);
end;

function CkSocket_SelectForReading (objHandle: HCkSocket; timeoutMs: Integer): Integer;
begin
  result := TCkSocket_SelectForReading(_map(256, 'CkSocket_SelectForReading'))
    (objHandle, timeoutMs);
end;

function CkSocket_SelectForReadingAsync (objHandle: HCkSocket; timeoutMs: Integer): HCkTask;
begin
  result := TCkSocket_SelectForReadingAsync(_map(257, 'CkSocket_SelectForReadingAsync'))
    (objHandle, timeoutMs);
end;

function CkSocket_SelectForWriting (objHandle: HCkSocket; timeoutMs: Integer): Integer;
begin
  result := TCkSocket_SelectForWriting(_map(258, 'CkSocket_SelectForWriting'))
    (objHandle, timeoutMs);
end;

function CkSocket_SelectForWritingAsync (objHandle: HCkSocket; timeoutMs: Integer): HCkTask;
begin
  result := TCkSocket_SelectForWritingAsync(_map(259, 'CkSocket_SelectForWritingAsync'))
    (objHandle, timeoutMs);
end;

function CkSocket_SendBd (objHandle: HCkSocket; binData: HCkBinData; offset: LongWord; numBytes: LongWord): wordbool;
begin
  result := TCkSocket_SendBd(_map(260, 'CkSocket_SendBd'))
    (objHandle, binData, offset, numBytes);
end;

function CkSocket_SendBdAsync (objHandle: HCkSocket; binData: HCkBinData; offset: LongWord; numBytes: LongWord): HCkTask;
begin
  result := TCkSocket_SendBdAsync(_map(261, 'CkSocket_SendBdAsync'))
    (objHandle, binData, offset, numBytes);
end;

function CkSocket_SendByte (objHandle: HCkSocket; value: Integer): wordbool;
begin
  result := TCkSocket_SendByte(_map(262, 'CkSocket_SendByte'))
    (objHandle, value);
end;

function CkSocket_SendByteAsync (objHandle: HCkSocket; value: Integer): HCkTask;
begin
  result := TCkSocket_SendByteAsync(_map(263, 'CkSocket_SendByteAsync'))
    (objHandle, value);
end;

function CkSocket_SendBytes (objHandle: HCkSocket; data: HCkByteData): wordbool;
begin
  result := TCkSocket_SendBytes(_map(264, 'CkSocket_SendBytes'))
    (objHandle, data);
end;

function CkSocket_SendBytesAsync (objHandle: HCkSocket; data: HCkByteData): HCkTask;
begin
  result := TCkSocket_SendBytesAsync(_map(265, 'CkSocket_SendBytesAsync'))
    (objHandle, data);
end;

function CkSocket_SendBytesENC (objHandle: HCkSocket; encodedBytes: PWideChar; encodingAlg: PWideChar): wordbool;
begin
  result := TCkSocket_SendBytesENC(_map(266, 'CkSocket_SendBytesENC'))
    (objHandle, encodedBytes, encodingAlg);
end;

function CkSocket_SendBytesENCAsync (objHandle: HCkSocket; encodedBytes: PWideChar; encodingAlg: PWideChar): HCkTask;
begin
  result := TCkSocket_SendBytesENCAsync(_map(267, 'CkSocket_SendBytesENCAsync'))
    (objHandle, encodedBytes, encodingAlg);
end;

function CkSocket_SendCount (objHandle: HCkSocket; byteCount: Integer): wordbool;
begin
  result := TCkSocket_SendCount(_map(268, 'CkSocket_SendCount'))
    (objHandle, byteCount);
end;

function CkSocket_SendCountAsync (objHandle: HCkSocket; byteCount: Integer): HCkTask;
begin
  result := TCkSocket_SendCountAsync(_map(269, 'CkSocket_SendCountAsync'))
    (objHandle, byteCount);
end;

function CkSocket_SendInt16 (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): wordbool;
begin
  result := TCkSocket_SendInt16(_map(270, 'CkSocket_SendInt16'))
    (objHandle, value, bigEndian);
end;

function CkSocket_SendInt16Async (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): HCkTask;
begin
  result := TCkSocket_SendInt16Async(_map(271, 'CkSocket_SendInt16Async'))
    (objHandle, value, bigEndian);
end;

function CkSocket_SendInt32 (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): wordbool;
begin
  result := TCkSocket_SendInt32(_map(272, 'CkSocket_SendInt32'))
    (objHandle, value, bigEndian);
end;

function CkSocket_SendInt32Async (objHandle: HCkSocket; value: Integer; bigEndian: wordbool): HCkTask;
begin
  result := TCkSocket_SendInt32Async(_map(273, 'CkSocket_SendInt32Async'))
    (objHandle, value, bigEndian);
end;

function CkSocket_SendSb (objHandle: HCkSocket; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSocket_SendSb(_map(274, 'CkSocket_SendSb'))
    (objHandle, sb);
end;

function CkSocket_SendSbAsync (objHandle: HCkSocket; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkSocket_SendSbAsync(_map(275, 'CkSocket_SendSbAsync'))
    (objHandle, sb);
end;

function CkSocket_SendString (objHandle: HCkSocket; stringToSend: PWideChar): wordbool;
begin
  result := TCkSocket_SendString(_map(276, 'CkSocket_SendString'))
    (objHandle, stringToSend);
end;

function CkSocket_SendStringAsync (objHandle: HCkSocket; stringToSend: PWideChar): HCkTask;
begin
  result := TCkSocket_SendStringAsync(_map(277, 'CkSocket_SendStringAsync'))
    (objHandle, stringToSend);
end;

function CkSocket_SendWakeOnLan (objHandle: HCkSocket; macAddress: PWideChar; port: Integer; ipBroadcastAddr: PWideChar): wordbool;
begin
  result := TCkSocket_SendWakeOnLan(_map(278, 'CkSocket_SendWakeOnLan'))
    (objHandle, macAddress, port, ipBroadcastAddr);
end;

function CkSocket_SendWakeOnLan2 (objHandle: HCkSocket; macAddress: PWideChar; port: Integer; ipBroadcastAddr: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkSocket_SendWakeOnLan2(_map(279, 'CkSocket_SendWakeOnLan2'))
    (objHandle, macAddress, port, ipBroadcastAddr, password);
end;

function CkSocket_SetSslClientCert (objHandle: HCkSocket; cert: HCkCert): wordbool;
begin
  result := TCkSocket_SetSslClientCert(_map(280, 'CkSocket_SetSslClientCert'))
    (objHandle, cert);
end;

function CkSocket_SetSslClientCertPem (objHandle: HCkSocket; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
begin
  result := TCkSocket_SetSslClientCertPem(_map(281, 'CkSocket_SetSslClientCertPem'))
    (objHandle, pemDataOrFilename, pemPassword);
end;

function CkSocket_SetSslClientCertPfx (objHandle: HCkSocket; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkSocket_SetSslClientCertPfx(_map(282, 'CkSocket_SetSslClientCertPfx'))
    (objHandle, pfxFilename, pfxPassword);
end;

procedure CkSocket_SleepMs (objHandle: HCkSocket; millisec: Integer);
begin
  TCkSocket_SleepMs(_map(283, 'CkSocket_SleepMs'))
    (objHandle, millisec);
end;

function CkSocket_SshAuthenticatePk (objHandle: HCkSocket; sshLogin: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSocket_SshAuthenticatePk(_map(284, 'CkSocket_SshAuthenticatePk'))
    (objHandle, sshLogin, privateKey);
end;

function CkSocket_SshAuthenticatePkAsync (objHandle: HCkSocket; sshLogin: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSocket_SshAuthenticatePkAsync(_map(285, 'CkSocket_SshAuthenticatePkAsync'))
    (objHandle, sshLogin, privateKey);
end;

function CkSocket_SshAuthenticatePw (objHandle: HCkSocket; sshLogin: PWideChar; sshPassword: PWideChar): wordbool;
begin
  result := TCkSocket_SshAuthenticatePw(_map(286, 'CkSocket_SshAuthenticatePw'))
    (objHandle, sshLogin, sshPassword);
end;

function CkSocket_SshAuthenticatePwAsync (objHandle: HCkSocket; sshLogin: PWideChar; sshPassword: PWideChar): HCkTask;
begin
  result := TCkSocket_SshAuthenticatePwAsync(_map(287, 'CkSocket_SshAuthenticatePwAsync'))
    (objHandle, sshLogin, sshPassword);
end;

function CkSocket_SshCloseTunnel (objHandle: HCkSocket): wordbool;
begin
  result := TCkSocket_SshCloseTunnel(_map(288, 'CkSocket_SshCloseTunnel'))
    (objHandle);
end;

function CkSocket_SshCloseTunnelAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_SshCloseTunnelAsync(_map(289, 'CkSocket_SshCloseTunnelAsync'))
    (objHandle);
end;

function CkSocket_SshNewChannel (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer; channel: HCkSocket): wordbool;
begin
  result := TCkSocket_SshNewChannel(_map(290, 'CkSocket_SshNewChannel'))
    (objHandle, hostname, port, ssl, maxWaitMs, channel);
end;

function CkSocket_SshNewChannelAsync (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer; channel: HCkSocket): HCkTask;
begin
  result := TCkSocket_SshNewChannelAsync(_map(291, 'CkSocket_SshNewChannelAsync'))
    (objHandle, hostname, port, ssl, maxWaitMs, channel);
end;

function CkSocket_SshOpenChannel (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkSocket;
begin
  result := TCkSocket_SshOpenChannel(_map(292, 'CkSocket_SshOpenChannel'))
    (objHandle, hostname, port, ssl, maxWaitMs);
end;

function CkSocket_SshOpenChannelAsync (objHandle: HCkSocket; hostname: PWideChar; port: Integer; ssl: wordbool; maxWaitMs: Integer): HCkTask;
begin
  result := TCkSocket_SshOpenChannelAsync(_map(293, 'CkSocket_SshOpenChannelAsync'))
    (objHandle, hostname, port, ssl, maxWaitMs);
end;

function CkSocket_SshOpenTunnel (objHandle: HCkSocket; sshHostname: PWideChar; sshPort: Integer): wordbool;
begin
  result := TCkSocket_SshOpenTunnel(_map(294, 'CkSocket_SshOpenTunnel'))
    (objHandle, sshHostname, sshPort);
end;

function CkSocket_SshOpenTunnelAsync (objHandle: HCkSocket; sshHostname: PWideChar; sshPort: Integer): HCkTask;
begin
  result := TCkSocket_SshOpenTunnelAsync(_map(295, 'CkSocket_SshOpenTunnelAsync'))
    (objHandle, sshHostname, sshPort);
end;

procedure CkSocket_StartTiming (objHandle: HCkSocket);
begin
  TCkSocket_StartTiming(_map(296, 'CkSocket_StartTiming'))
    (objHandle);
end;

function CkSocket_TakeConnection (objHandle: HCkSocket; sock: HCkSocket): wordbool;
begin
  result := TCkSocket_TakeConnection(_map(297, 'CkSocket_TakeConnection'))
    (objHandle, sock);
end;

function CkSocket_TakeSocket (objHandle: HCkSocket; sock: HCkSocket): wordbool;
begin
  result := TCkSocket_TakeSocket(_map(298, 'CkSocket_TakeSocket'))
    (objHandle, sock);
end;

function CkSocket_TlsRenegotiate (objHandle: HCkSocket): wordbool;
begin
  result := TCkSocket_TlsRenegotiate(_map(299, 'CkSocket_TlsRenegotiate'))
    (objHandle);
end;

function CkSocket_TlsRenegotiateAsync (objHandle: HCkSocket): HCkTask;
begin
  result := TCkSocket_TlsRenegotiateAsync(_map(300, 'CkSocket_TlsRenegotiateAsync'))
    (objHandle);
end;

function CkSocket_UseSsh (objHandle: HCkSocket; ssh: HCkSsh): wordbool;
begin
  result := TCkSocket_UseSsh(_map(301, 'CkSocket_UseSsh'))
    (objHandle, ssh);
end;

end.
