unit Spider;

interface

type

HCkTask = Pointer;
HCkSpider = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSpiderAbortCheck = function(): Integer; cdecl;
TSpiderProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSpiderPercentDone = function(pctDone: Integer): Integer; cdecl;
TSpiderTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSpider_Create: HCkSpider;  stdcall;
procedure CkSpider_Dispose(handle: HCkSpider); stdcall;

procedure CkSpider_SetAbortCheck(objHandle: HCkSpider; fn: TSpiderAbortCheck) stdcall;
procedure CkSpider_SetProgressInfo(objHandle: HCkSpider; fn: TSpiderProgressInfo) stdcall;
procedure CkSpider_SetPercentDone(objHandle: HCkSpider; fn: TSpiderPercentDone) stdcall;
procedure CkSpider_SetTaskCompleted(objHandle: HCkSpider; fn: TSpiderTaskCompleted) stdcall;
function CkSpider_getAbortCurrent(objHandle: HCkSpider): wordbool;
procedure CkSpider_putAbortCurrent(objHandle: HCkSpider; newPropVal: wordbool);
function CkSpider_getAvoidHttps(objHandle: HCkSpider): wordbool;
procedure CkSpider_putAvoidHttps(objHandle: HCkSpider; newPropVal: wordbool);
procedure CkSpider_getCacheDir(objHandle: HCkSpider; outPropVal: HCkString);
procedure CkSpider_putCacheDir(objHandle: HCkSpider; newPropVal: PWideChar);
function CkSpider__cacheDir(objHandle: HCkSpider): PWideChar;
function CkSpider_getChopAtQuery(objHandle: HCkSpider): wordbool;
procedure CkSpider_putChopAtQuery(objHandle: HCkSpider; newPropVal: wordbool);
function CkSpider_getConnectTimeout(objHandle: HCkSpider): Integer;
procedure CkSpider_putConnectTimeout(objHandle: HCkSpider; newPropVal: Integer);
procedure CkSpider_getDebugLogFilePath(objHandle: HCkSpider; outPropVal: HCkString);
procedure CkSpider_putDebugLogFilePath(objHandle: HCkSpider; newPropVal: PWideChar);
function CkSpider__debugLogFilePath(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getDomain(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__domain(objHandle: HCkSpider): PWideChar;
function CkSpider_getFetchFromCache(objHandle: HCkSpider): wordbool;
procedure CkSpider_putFetchFromCache(objHandle: HCkSpider; newPropVal: wordbool);
procedure CkSpider_getFinalRedirectUrl(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__finalRedirectUrl(objHandle: HCkSpider): PWideChar;
function CkSpider_getHeartbeatMs(objHandle: HCkSpider): Integer;
procedure CkSpider_putHeartbeatMs(objHandle: HCkSpider; newPropVal: Integer);
procedure CkSpider_getLastErrorHtml(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastErrorHtml(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getLastErrorText(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastErrorText(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getLastErrorXml(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastErrorXml(objHandle: HCkSpider): PWideChar;
function CkSpider_getLastFromCache(objHandle: HCkSpider): wordbool;
procedure CkSpider_getLastHtml(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastHtml(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getLastHtmlDescription(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastHtmlDescription(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getLastHtmlKeywords(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastHtmlKeywords(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getLastHtmlTitle(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastHtmlTitle(objHandle: HCkSpider): PWideChar;
function CkSpider_getLastMethodSuccess(objHandle: HCkSpider): wordbool;
procedure CkSpider_putLastMethodSuccess(objHandle: HCkSpider; newPropVal: wordbool);
procedure CkSpider_getLastModDateStr(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastModDateStr(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getLastUrl(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__lastUrl(objHandle: HCkSpider): PWideChar;
function CkSpider_getMaxResponseSize(objHandle: HCkSpider): Integer;
procedure CkSpider_putMaxResponseSize(objHandle: HCkSpider; newPropVal: Integer);
function CkSpider_getMaxUrlLen(objHandle: HCkSpider): Integer;
procedure CkSpider_putMaxUrlLen(objHandle: HCkSpider; newPropVal: Integer);
function CkSpider_getNumAvoidPatterns(objHandle: HCkSpider): Integer;
function CkSpider_getNumFailed(objHandle: HCkSpider): Integer;
function CkSpider_getNumOutboundLinks(objHandle: HCkSpider): Integer;
function CkSpider_getNumSpidered(objHandle: HCkSpider): Integer;
function CkSpider_getNumUnspidered(objHandle: HCkSpider): Integer;
function CkSpider_getPreferIpv6(objHandle: HCkSpider): wordbool;
procedure CkSpider_putPreferIpv6(objHandle: HCkSpider; newPropVal: wordbool);
procedure CkSpider_getProxyDomain(objHandle: HCkSpider; outPropVal: HCkString);
procedure CkSpider_putProxyDomain(objHandle: HCkSpider; newPropVal: PWideChar);
function CkSpider__proxyDomain(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getProxyLogin(objHandle: HCkSpider; outPropVal: HCkString);
procedure CkSpider_putProxyLogin(objHandle: HCkSpider; newPropVal: PWideChar);
function CkSpider__proxyLogin(objHandle: HCkSpider): PWideChar;
procedure CkSpider_getProxyPassword(objHandle: HCkSpider; outPropVal: HCkString);
procedure CkSpider_putProxyPassword(objHandle: HCkSpider; newPropVal: PWideChar);
function CkSpider__proxyPassword(objHandle: HCkSpider): PWideChar;
function CkSpider_getProxyPort(objHandle: HCkSpider): Integer;
procedure CkSpider_putProxyPort(objHandle: HCkSpider; newPropVal: Integer);
function CkSpider_getReadTimeout(objHandle: HCkSpider): Integer;
procedure CkSpider_putReadTimeout(objHandle: HCkSpider; newPropVal: Integer);
function CkSpider_getUpdateCache(objHandle: HCkSpider): wordbool;
procedure CkSpider_putUpdateCache(objHandle: HCkSpider; newPropVal: wordbool);
procedure CkSpider_getUserAgent(objHandle: HCkSpider; outPropVal: HCkString);
procedure CkSpider_putUserAgent(objHandle: HCkSpider; newPropVal: PWideChar);
function CkSpider__userAgent(objHandle: HCkSpider): PWideChar;
function CkSpider_getVerboseLogging(objHandle: HCkSpider): wordbool;
procedure CkSpider_putVerboseLogging(objHandle: HCkSpider; newPropVal: wordbool);
procedure CkSpider_getVersion(objHandle: HCkSpider; outPropVal: HCkString);
function CkSpider__version(objHandle: HCkSpider): PWideChar;
function CkSpider_getWasRedirected(objHandle: HCkSpider): wordbool;
function CkSpider_getWindDownCount(objHandle: HCkSpider): Integer;
procedure CkSpider_putWindDownCount(objHandle: HCkSpider; newPropVal: Integer);
procedure CkSpider_AddAvoidOutboundLinkPattern(objHandle: HCkSpider; pattern: PWideChar);
procedure CkSpider_AddAvoidPattern(objHandle: HCkSpider; pattern: PWideChar);
procedure CkSpider_AddMustMatchPattern(objHandle: HCkSpider; pattern: PWideChar);
procedure CkSpider_AddUnspidered(objHandle: HCkSpider; url: PWideChar);
function CkSpider_CanonicalizeUrl(objHandle: HCkSpider; url: PWideChar; outStr: HCkString): wordbool;
function CkSpider__canonicalizeUrl(objHandle: HCkSpider; url: PWideChar): PWideChar;
procedure CkSpider_ClearFailedUrls(objHandle: HCkSpider);
procedure CkSpider_ClearOutboundLinks(objHandle: HCkSpider);
procedure CkSpider_ClearSpideredUrls(objHandle: HCkSpider);
function CkSpider_CrawlNext(objHandle: HCkSpider): wordbool;
function CkSpider_CrawlNextAsync(objHandle: HCkSpider): HCkTask;
function CkSpider_FetchRobotsText(objHandle: HCkSpider; outStr: HCkString): wordbool;
function CkSpider__fetchRobotsText(objHandle: HCkSpider): PWideChar;
function CkSpider_FetchRobotsTextAsync(objHandle: HCkSpider): HCkTask;
function CkSpider_GetAvoidPattern(objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
function CkSpider__getAvoidPattern(objHandle: HCkSpider; index: Integer): PWideChar;
function CkSpider_GetBaseDomain(objHandle: HCkSpider; domain: PWideChar; outStr: HCkString): wordbool;
function CkSpider__getBaseDomain(objHandle: HCkSpider; domain: PWideChar): PWideChar;
function CkSpider_GetFailedUrl(objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
function CkSpider__getFailedUrl(objHandle: HCkSpider; index: Integer): PWideChar;
function CkSpider_GetOutboundLink(objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
function CkSpider__getOutboundLink(objHandle: HCkSpider; index: Integer): PWideChar;
function CkSpider_GetSpideredUrl(objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
function CkSpider__getSpideredUrl(objHandle: HCkSpider; index: Integer): PWideChar;
function CkSpider_GetUnspideredUrl(objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
function CkSpider__getUnspideredUrl(objHandle: HCkSpider; index: Integer): PWideChar;
function CkSpider_GetUrlDomain(objHandle: HCkSpider; url: PWideChar; outStr: HCkString): wordbool;
function CkSpider__getUrlDomain(objHandle: HCkSpider; url: PWideChar): PWideChar;
procedure CkSpider_Initialize(objHandle: HCkSpider; domain: PWideChar);
function CkSpider_LoadTaskCaller(objHandle: HCkSpider; task: HCkTask): wordbool;
function CkSpider_RecrawlLast(objHandle: HCkSpider): wordbool;
function CkSpider_RecrawlLastAsync(objHandle: HCkSpider): HCkTask;
procedure CkSpider_SkipUnspidered(objHandle: HCkSpider; index: Integer);
procedure CkSpider_SleepMs(objHandle: HCkSpider; numMilliseconds: Integer);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSpider_Create = function : HCkSpider; stdcall;
  TCkSpider_Dispose = procedure (handle: HCkSpider); stdcall;
  TCkSpider_SetAbortCheck = procedure (objHandle: HCkSpider; fn: TSpiderAbortCheck); stdcall;
  TCkSpider_SetProgressInfo = procedure (objHandle: HCkSpider; fn: TSpiderProgressInfo); stdcall;
  TCkSpider_SetPercentDone = procedure (objHandle: HCkSpider; fn: TSpiderPercentDone); stdcall;
  TCkSpider_SetTaskCompleted = procedure (objHandle: HCkSpider; fn: TSpiderTaskCompleted); stdcall;
  TCkSpider_getAbortCurrent = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putAbortCurrent = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getAvoidHttps = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putAvoidHttps = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getCacheDir = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider_putCacheDir = procedure (objHandle: HCkSpider; newPropVal: PWideChar); stdcall;
  TCkSpider__cacheDir = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getChopAtQuery = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putChopAtQuery = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getConnectTimeout = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putConnectTimeout = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_getDebugLogFilePath = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider_putDebugLogFilePath = procedure (objHandle: HCkSpider; newPropVal: PWideChar); stdcall;
  TCkSpider__debugLogFilePath = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getDomain = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__domain = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getFetchFromCache = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putFetchFromCache = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getFinalRedirectUrl = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__finalRedirectUrl = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getHeartbeatMs = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putHeartbeatMs = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_getLastErrorHtml = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastErrorHtml = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastErrorText = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastErrorText = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastErrorXml = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastErrorXml = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastFromCache = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_getLastHtml = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastHtml = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastHtmlDescription = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastHtmlDescription = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastHtmlKeywords = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastHtmlKeywords = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastHtmlTitle = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastHtmlTitle = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastMethodSuccess = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putLastMethodSuccess = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getLastModDateStr = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastModDateStr = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getLastUrl = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__lastUrl = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getMaxResponseSize = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putMaxResponseSize = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_getMaxUrlLen = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putMaxUrlLen = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_getNumAvoidPatterns = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_getNumFailed = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_getNumOutboundLinks = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_getNumSpidered = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_getNumUnspidered = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_getPreferIpv6 = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putPreferIpv6 = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getProxyDomain = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider_putProxyDomain = procedure (objHandle: HCkSpider; newPropVal: PWideChar); stdcall;
  TCkSpider__proxyDomain = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getProxyLogin = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider_putProxyLogin = procedure (objHandle: HCkSpider; newPropVal: PWideChar); stdcall;
  TCkSpider__proxyLogin = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getProxyPassword = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider_putProxyPassword = procedure (objHandle: HCkSpider; newPropVal: PWideChar); stdcall;
  TCkSpider__proxyPassword = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getProxyPort = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putProxyPort = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_getReadTimeout = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putReadTimeout = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_getUpdateCache = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putUpdateCache = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getUserAgent = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider_putUserAgent = procedure (objHandle: HCkSpider; newPropVal: PWideChar); stdcall;
  TCkSpider__userAgent = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getVerboseLogging = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_putVerboseLogging = procedure (objHandle: HCkSpider; newPropVal: wordbool); stdcall;
  TCkSpider_getVersion = procedure (objHandle: HCkSpider; outPropVal: HCkString); stdcall;
  TCkSpider__version = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_getWasRedirected = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_getWindDownCount = function (objHandle: HCkSpider): Integer; stdcall;
  TCkSpider_putWindDownCount = procedure (objHandle: HCkSpider; newPropVal: Integer); stdcall;
  TCkSpider_AddAvoidOutboundLinkPattern = procedure (objHandle: HCkSpider; pattern: PWideChar); stdcall;
  TCkSpider_AddAvoidPattern = procedure (objHandle: HCkSpider; pattern: PWideChar); stdcall;
  TCkSpider_AddMustMatchPattern = procedure (objHandle: HCkSpider; pattern: PWideChar); stdcall;
  TCkSpider_AddUnspidered = procedure (objHandle: HCkSpider; url: PWideChar); stdcall;
  TCkSpider_CanonicalizeUrl = function (objHandle: HCkSpider; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSpider__canonicalizeUrl = function (objHandle: HCkSpider; url: PWideChar): PWideChar; stdcall;
  TCkSpider_ClearFailedUrls = procedure (objHandle: HCkSpider); stdcall;
  TCkSpider_ClearOutboundLinks = procedure (objHandle: HCkSpider); stdcall;
  TCkSpider_ClearSpideredUrls = procedure (objHandle: HCkSpider); stdcall;
  TCkSpider_CrawlNext = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_CrawlNextAsync = function (objHandle: HCkSpider): HCkTask; stdcall;
  TCkSpider_FetchRobotsText = function (objHandle: HCkSpider; outStr: HCkString): wordbool; stdcall;
  TCkSpider__fetchRobotsText = function (objHandle: HCkSpider): PWideChar; stdcall;
  TCkSpider_FetchRobotsTextAsync = function (objHandle: HCkSpider): HCkTask; stdcall;
  TCkSpider_GetAvoidPattern = function (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getAvoidPattern = function (objHandle: HCkSpider; index: Integer): PWideChar; stdcall;
  TCkSpider_GetBaseDomain = function (objHandle: HCkSpider; domain: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getBaseDomain = function (objHandle: HCkSpider; domain: PWideChar): PWideChar; stdcall;
  TCkSpider_GetFailedUrl = function (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getFailedUrl = function (objHandle: HCkSpider; index: Integer): PWideChar; stdcall;
  TCkSpider_GetOutboundLink = function (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getOutboundLink = function (objHandle: HCkSpider; index: Integer): PWideChar; stdcall;
  TCkSpider_GetSpideredUrl = function (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getSpideredUrl = function (objHandle: HCkSpider; index: Integer): PWideChar; stdcall;
  TCkSpider_GetUnspideredUrl = function (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getUnspideredUrl = function (objHandle: HCkSpider; index: Integer): PWideChar; stdcall;
  TCkSpider_GetUrlDomain = function (objHandle: HCkSpider; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSpider__getUrlDomain = function (objHandle: HCkSpider; url: PWideChar): PWideChar; stdcall;
  TCkSpider_Initialize = procedure (objHandle: HCkSpider; domain: PWideChar); stdcall;
  TCkSpider_LoadTaskCaller = function (objHandle: HCkSpider; task: HCkTask): wordbool; stdcall;
  TCkSpider_RecrawlLast = function (objHandle: HCkSpider): wordbool; stdcall;
  TCkSpider_RecrawlLastAsync = function (objHandle: HCkSpider): HCkTask; stdcall;
  TCkSpider_SkipUnspidered = procedure (objHandle: HCkSpider; index: Integer); stdcall;
  TCkSpider_SleepMs = procedure (objHandle: HCkSpider; numMilliseconds: Integer); stdcall;

var
  _fkt_ptr_arr:   array [0..118] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSpider_Create : HCkSpider;
begin
  result := TCkSpider_Create(_map(0, 'CkSpider_Create'));
end;

procedure CkSpider_Dispose (handle: HCkSpider);
begin
  TCkSpider_Dispose(_map(1, 'CkSpider_Dispose'))
    (handle);
end;


procedure CkSpider_SetAbortCheck (objHandle: HCkSpider; fn: TSpiderAbortCheck);
begin
    TCkSpider_SetAbortCheck(_map(2, 'CkSpider_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSpider_SetProgressInfo (objHandle: HCkSpider; fn: TSpiderProgressInfo);
begin
    TCkSpider_SetProgressInfo(_map(3, 'CkSpider_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSpider_SetPercentDone (objHandle: HCkSpider; fn: TSpiderPercentDone);
begin
    TCkSpider_SetPercentDone(_map(4, 'CkSpider_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSpider_SetTaskCompleted (objHandle: HCkSpider; fn: TSpiderTaskCompleted);
begin
    TCkSpider_SetTaskCompleted(_map(5, 'CkSpider_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkSpider_getAbortCurrent (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getAbortCurrent(_map(6, 'CkSpider_getAbortCurrent'))
    (objHandle);
end;

procedure CkSpider_putAbortCurrent (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putAbortCurrent(_map(7, 'CkSpider_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkSpider_getAvoidHttps (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getAvoidHttps(_map(8, 'CkSpider_getAvoidHttps'))
    (objHandle);
end;

procedure CkSpider_putAvoidHttps (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putAvoidHttps(_map(9, 'CkSpider_putAvoidHttps'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getCacheDir (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getCacheDir(_map(10, 'CkSpider_getCacheDir'))
    (objHandle, outPropVal);
end;

procedure CkSpider_putCacheDir (objHandle: HCkSpider; newPropVal: PWideChar);
begin
  TCkSpider_putCacheDir(_map(11, 'CkSpider_putCacheDir'))
    (objHandle, newPropVal);
end;

function CkSpider__cacheDir (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__cacheDir(_map(12, 'CkSpider__cacheDir'))
    (objHandle);
end;

function CkSpider_getChopAtQuery (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getChopAtQuery(_map(13, 'CkSpider_getChopAtQuery'))
    (objHandle);
end;

procedure CkSpider_putChopAtQuery (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putChopAtQuery(_map(14, 'CkSpider_putChopAtQuery'))
    (objHandle, newPropVal);
end;

function CkSpider_getConnectTimeout (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getConnectTimeout(_map(15, 'CkSpider_getConnectTimeout'))
    (objHandle);
end;

procedure CkSpider_putConnectTimeout (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putConnectTimeout(_map(16, 'CkSpider_putConnectTimeout'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getDebugLogFilePath (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getDebugLogFilePath(_map(17, 'CkSpider_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSpider_putDebugLogFilePath (objHandle: HCkSpider; newPropVal: PWideChar);
begin
  TCkSpider_putDebugLogFilePath(_map(18, 'CkSpider_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSpider__debugLogFilePath (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__debugLogFilePath(_map(19, 'CkSpider__debugLogFilePath'))
    (objHandle);
end;

procedure CkSpider_getDomain (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getDomain(_map(20, 'CkSpider_getDomain'))
    (objHandle, outPropVal);
end;

function CkSpider__domain (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__domain(_map(21, 'CkSpider__domain'))
    (objHandle);
end;

function CkSpider_getFetchFromCache (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getFetchFromCache(_map(22, 'CkSpider_getFetchFromCache'))
    (objHandle);
end;

procedure CkSpider_putFetchFromCache (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putFetchFromCache(_map(23, 'CkSpider_putFetchFromCache'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getFinalRedirectUrl (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getFinalRedirectUrl(_map(24, 'CkSpider_getFinalRedirectUrl'))
    (objHandle, outPropVal);
end;

function CkSpider__finalRedirectUrl (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__finalRedirectUrl(_map(25, 'CkSpider__finalRedirectUrl'))
    (objHandle);
end;

function CkSpider_getHeartbeatMs (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getHeartbeatMs(_map(26, 'CkSpider_getHeartbeatMs'))
    (objHandle);
end;

procedure CkSpider_putHeartbeatMs (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putHeartbeatMs(_map(27, 'CkSpider_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getLastErrorHtml (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastErrorHtml(_map(28, 'CkSpider_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSpider__lastErrorHtml (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastErrorHtml(_map(29, 'CkSpider__lastErrorHtml'))
    (objHandle);
end;

procedure CkSpider_getLastErrorText (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastErrorText(_map(30, 'CkSpider_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSpider__lastErrorText (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastErrorText(_map(31, 'CkSpider__lastErrorText'))
    (objHandle);
end;

procedure CkSpider_getLastErrorXml (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastErrorXml(_map(32, 'CkSpider_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSpider__lastErrorXml (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastErrorXml(_map(33, 'CkSpider__lastErrorXml'))
    (objHandle);
end;

function CkSpider_getLastFromCache (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getLastFromCache(_map(34, 'CkSpider_getLastFromCache'))
    (objHandle);
end;

procedure CkSpider_getLastHtml (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastHtml(_map(35, 'CkSpider_getLastHtml'))
    (objHandle, outPropVal);
end;

function CkSpider__lastHtml (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastHtml(_map(36, 'CkSpider__lastHtml'))
    (objHandle);
end;

procedure CkSpider_getLastHtmlDescription (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastHtmlDescription(_map(37, 'CkSpider_getLastHtmlDescription'))
    (objHandle, outPropVal);
end;

function CkSpider__lastHtmlDescription (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastHtmlDescription(_map(38, 'CkSpider__lastHtmlDescription'))
    (objHandle);
end;

procedure CkSpider_getLastHtmlKeywords (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastHtmlKeywords(_map(39, 'CkSpider_getLastHtmlKeywords'))
    (objHandle, outPropVal);
end;

function CkSpider__lastHtmlKeywords (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastHtmlKeywords(_map(40, 'CkSpider__lastHtmlKeywords'))
    (objHandle);
end;

procedure CkSpider_getLastHtmlTitle (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastHtmlTitle(_map(41, 'CkSpider_getLastHtmlTitle'))
    (objHandle, outPropVal);
end;

function CkSpider__lastHtmlTitle (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastHtmlTitle(_map(42, 'CkSpider__lastHtmlTitle'))
    (objHandle);
end;

function CkSpider_getLastMethodSuccess (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getLastMethodSuccess(_map(43, 'CkSpider_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSpider_putLastMethodSuccess (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putLastMethodSuccess(_map(44, 'CkSpider_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getLastModDateStr (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastModDateStr(_map(45, 'CkSpider_getLastModDateStr'))
    (objHandle, outPropVal);
end;

function CkSpider__lastModDateStr (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastModDateStr(_map(46, 'CkSpider__lastModDateStr'))
    (objHandle);
end;

procedure CkSpider_getLastUrl (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getLastUrl(_map(47, 'CkSpider_getLastUrl'))
    (objHandle, outPropVal);
end;

function CkSpider__lastUrl (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__lastUrl(_map(48, 'CkSpider__lastUrl'))
    (objHandle);
end;

function CkSpider_getMaxResponseSize (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getMaxResponseSize(_map(49, 'CkSpider_getMaxResponseSize'))
    (objHandle);
end;

procedure CkSpider_putMaxResponseSize (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putMaxResponseSize(_map(50, 'CkSpider_putMaxResponseSize'))
    (objHandle, newPropVal);
end;

function CkSpider_getMaxUrlLen (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getMaxUrlLen(_map(51, 'CkSpider_getMaxUrlLen'))
    (objHandle);
end;

procedure CkSpider_putMaxUrlLen (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putMaxUrlLen(_map(52, 'CkSpider_putMaxUrlLen'))
    (objHandle, newPropVal);
end;

function CkSpider_getNumAvoidPatterns (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getNumAvoidPatterns(_map(53, 'CkSpider_getNumAvoidPatterns'))
    (objHandle);
end;

function CkSpider_getNumFailed (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getNumFailed(_map(54, 'CkSpider_getNumFailed'))
    (objHandle);
end;

function CkSpider_getNumOutboundLinks (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getNumOutboundLinks(_map(55, 'CkSpider_getNumOutboundLinks'))
    (objHandle);
end;

function CkSpider_getNumSpidered (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getNumSpidered(_map(56, 'CkSpider_getNumSpidered'))
    (objHandle);
end;

function CkSpider_getNumUnspidered (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getNumUnspidered(_map(57, 'CkSpider_getNumUnspidered'))
    (objHandle);
end;

function CkSpider_getPreferIpv6 (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getPreferIpv6(_map(58, 'CkSpider_getPreferIpv6'))
    (objHandle);
end;

procedure CkSpider_putPreferIpv6 (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putPreferIpv6(_map(59, 'CkSpider_putPreferIpv6'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getProxyDomain (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getProxyDomain(_map(60, 'CkSpider_getProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkSpider_putProxyDomain (objHandle: HCkSpider; newPropVal: PWideChar);
begin
  TCkSpider_putProxyDomain(_map(61, 'CkSpider_putProxyDomain'))
    (objHandle, newPropVal);
end;

function CkSpider__proxyDomain (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__proxyDomain(_map(62, 'CkSpider__proxyDomain'))
    (objHandle);
end;

procedure CkSpider_getProxyLogin (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getProxyLogin(_map(63, 'CkSpider_getProxyLogin'))
    (objHandle, outPropVal);
end;

procedure CkSpider_putProxyLogin (objHandle: HCkSpider; newPropVal: PWideChar);
begin
  TCkSpider_putProxyLogin(_map(64, 'CkSpider_putProxyLogin'))
    (objHandle, newPropVal);
end;

function CkSpider__proxyLogin (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__proxyLogin(_map(65, 'CkSpider__proxyLogin'))
    (objHandle);
end;

procedure CkSpider_getProxyPassword (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getProxyPassword(_map(66, 'CkSpider_getProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkSpider_putProxyPassword (objHandle: HCkSpider; newPropVal: PWideChar);
begin
  TCkSpider_putProxyPassword(_map(67, 'CkSpider_putProxyPassword'))
    (objHandle, newPropVal);
end;

function CkSpider__proxyPassword (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__proxyPassword(_map(68, 'CkSpider__proxyPassword'))
    (objHandle);
end;

function CkSpider_getProxyPort (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getProxyPort(_map(69, 'CkSpider_getProxyPort'))
    (objHandle);
end;

procedure CkSpider_putProxyPort (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putProxyPort(_map(70, 'CkSpider_putProxyPort'))
    (objHandle, newPropVal);
end;

function CkSpider_getReadTimeout (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getReadTimeout(_map(71, 'CkSpider_getReadTimeout'))
    (objHandle);
end;

procedure CkSpider_putReadTimeout (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putReadTimeout(_map(72, 'CkSpider_putReadTimeout'))
    (objHandle, newPropVal);
end;

function CkSpider_getUpdateCache (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getUpdateCache(_map(73, 'CkSpider_getUpdateCache'))
    (objHandle);
end;

procedure CkSpider_putUpdateCache (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putUpdateCache(_map(74, 'CkSpider_putUpdateCache'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getUserAgent (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getUserAgent(_map(75, 'CkSpider_getUserAgent'))
    (objHandle, outPropVal);
end;

procedure CkSpider_putUserAgent (objHandle: HCkSpider; newPropVal: PWideChar);
begin
  TCkSpider_putUserAgent(_map(76, 'CkSpider_putUserAgent'))
    (objHandle, newPropVal);
end;

function CkSpider__userAgent (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__userAgent(_map(77, 'CkSpider__userAgent'))
    (objHandle);
end;

function CkSpider_getVerboseLogging (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getVerboseLogging(_map(78, 'CkSpider_getVerboseLogging'))
    (objHandle);
end;

procedure CkSpider_putVerboseLogging (objHandle: HCkSpider; newPropVal: wordbool);
begin
  TCkSpider_putVerboseLogging(_map(79, 'CkSpider_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSpider_getVersion (objHandle: HCkSpider; outPropVal: HCkString);
begin
  TCkSpider_getVersion(_map(80, 'CkSpider_getVersion'))
    (objHandle, outPropVal);
end;

function CkSpider__version (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__version(_map(81, 'CkSpider__version'))
    (objHandle);
end;

function CkSpider_getWasRedirected (objHandle: HCkSpider): wordbool;
begin
    result := TCkSpider_getWasRedirected(_map(82, 'CkSpider_getWasRedirected'))
    (objHandle);
end;

function CkSpider_getWindDownCount (objHandle: HCkSpider): Integer;
begin
    result := TCkSpider_getWindDownCount(_map(83, 'CkSpider_getWindDownCount'))
    (objHandle);
end;

procedure CkSpider_putWindDownCount (objHandle: HCkSpider; newPropVal: Integer);
begin
  TCkSpider_putWindDownCount(_map(84, 'CkSpider_putWindDownCount'))
    (objHandle, newPropVal);
end;

procedure CkSpider_AddAvoidOutboundLinkPattern (objHandle: HCkSpider; pattern: PWideChar);
begin
  TCkSpider_AddAvoidOutboundLinkPattern(_map(85, 'CkSpider_AddAvoidOutboundLinkPattern'))
    (objHandle, pattern);
end;

procedure CkSpider_AddAvoidPattern (objHandle: HCkSpider; pattern: PWideChar);
begin
  TCkSpider_AddAvoidPattern(_map(86, 'CkSpider_AddAvoidPattern'))
    (objHandle, pattern);
end;

procedure CkSpider_AddMustMatchPattern (objHandle: HCkSpider; pattern: PWideChar);
begin
  TCkSpider_AddMustMatchPattern(_map(87, 'CkSpider_AddMustMatchPattern'))
    (objHandle, pattern);
end;

procedure CkSpider_AddUnspidered (objHandle: HCkSpider; url: PWideChar);
begin
  TCkSpider_AddUnspidered(_map(88, 'CkSpider_AddUnspidered'))
    (objHandle, url);
end;

function CkSpider_CanonicalizeUrl (objHandle: HCkSpider; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSpider_CanonicalizeUrl(_map(89, 'CkSpider_CanonicalizeUrl'))
    (objHandle, url, outStr);
end;

function CkSpider__canonicalizeUrl (objHandle: HCkSpider; url: PWideChar): PWideChar;
begin
  result := TCkSpider__canonicalizeUrl(_map(90, 'CkSpider__canonicalizeUrl'))
    (objHandle, url);
end;

procedure CkSpider_ClearFailedUrls (objHandle: HCkSpider);
begin
  TCkSpider_ClearFailedUrls(_map(91, 'CkSpider_ClearFailedUrls'))
    (objHandle);
end;

procedure CkSpider_ClearOutboundLinks (objHandle: HCkSpider);
begin
  TCkSpider_ClearOutboundLinks(_map(92, 'CkSpider_ClearOutboundLinks'))
    (objHandle);
end;

procedure CkSpider_ClearSpideredUrls (objHandle: HCkSpider);
begin
  TCkSpider_ClearSpideredUrls(_map(93, 'CkSpider_ClearSpideredUrls'))
    (objHandle);
end;

function CkSpider_CrawlNext (objHandle: HCkSpider): wordbool;
begin
  result := TCkSpider_CrawlNext(_map(94, 'CkSpider_CrawlNext'))
    (objHandle);
end;

function CkSpider_CrawlNextAsync (objHandle: HCkSpider): HCkTask;
begin
  result := TCkSpider_CrawlNextAsync(_map(95, 'CkSpider_CrawlNextAsync'))
    (objHandle);
end;

function CkSpider_FetchRobotsText (objHandle: HCkSpider; outStr: HCkString): wordbool;
begin
  result := TCkSpider_FetchRobotsText(_map(96, 'CkSpider_FetchRobotsText'))
    (objHandle, outStr);
end;

function CkSpider__fetchRobotsText (objHandle: HCkSpider): PWideChar;
begin
  result := TCkSpider__fetchRobotsText(_map(97, 'CkSpider__fetchRobotsText'))
    (objHandle);
end;

function CkSpider_FetchRobotsTextAsync (objHandle: HCkSpider): HCkTask;
begin
  result := TCkSpider_FetchRobotsTextAsync(_map(98, 'CkSpider_FetchRobotsTextAsync'))
    (objHandle);
end;

function CkSpider_GetAvoidPattern (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetAvoidPattern(_map(99, 'CkSpider_GetAvoidPattern'))
    (objHandle, index, outStr);
end;

function CkSpider__getAvoidPattern (objHandle: HCkSpider; index: Integer): PWideChar;
begin
  result := TCkSpider__getAvoidPattern(_map(100, 'CkSpider__getAvoidPattern'))
    (objHandle, index);
end;

function CkSpider_GetBaseDomain (objHandle: HCkSpider; domain: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetBaseDomain(_map(101, 'CkSpider_GetBaseDomain'))
    (objHandle, domain, outStr);
end;

function CkSpider__getBaseDomain (objHandle: HCkSpider; domain: PWideChar): PWideChar;
begin
  result := TCkSpider__getBaseDomain(_map(102, 'CkSpider__getBaseDomain'))
    (objHandle, domain);
end;

function CkSpider_GetFailedUrl (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetFailedUrl(_map(103, 'CkSpider_GetFailedUrl'))
    (objHandle, index, outStr);
end;

function CkSpider__getFailedUrl (objHandle: HCkSpider; index: Integer): PWideChar;
begin
  result := TCkSpider__getFailedUrl(_map(104, 'CkSpider__getFailedUrl'))
    (objHandle, index);
end;

function CkSpider_GetOutboundLink (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetOutboundLink(_map(105, 'CkSpider_GetOutboundLink'))
    (objHandle, index, outStr);
end;

function CkSpider__getOutboundLink (objHandle: HCkSpider; index: Integer): PWideChar;
begin
  result := TCkSpider__getOutboundLink(_map(106, 'CkSpider__getOutboundLink'))
    (objHandle, index);
end;

function CkSpider_GetSpideredUrl (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetSpideredUrl(_map(107, 'CkSpider_GetSpideredUrl'))
    (objHandle, index, outStr);
end;

function CkSpider__getSpideredUrl (objHandle: HCkSpider; index: Integer): PWideChar;
begin
  result := TCkSpider__getSpideredUrl(_map(108, 'CkSpider__getSpideredUrl'))
    (objHandle, index);
end;

function CkSpider_GetUnspideredUrl (objHandle: HCkSpider; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetUnspideredUrl(_map(109, 'CkSpider_GetUnspideredUrl'))
    (objHandle, index, outStr);
end;

function CkSpider__getUnspideredUrl (objHandle: HCkSpider; index: Integer): PWideChar;
begin
  result := TCkSpider__getUnspideredUrl(_map(110, 'CkSpider__getUnspideredUrl'))
    (objHandle, index);
end;

function CkSpider_GetUrlDomain (objHandle: HCkSpider; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSpider_GetUrlDomain(_map(111, 'CkSpider_GetUrlDomain'))
    (objHandle, url, outStr);
end;

function CkSpider__getUrlDomain (objHandle: HCkSpider; url: PWideChar): PWideChar;
begin
  result := TCkSpider__getUrlDomain(_map(112, 'CkSpider__getUrlDomain'))
    (objHandle, url);
end;

procedure CkSpider_Initialize (objHandle: HCkSpider; domain: PWideChar);
begin
  TCkSpider_Initialize(_map(113, 'CkSpider_Initialize'))
    (objHandle, domain);
end;

function CkSpider_LoadTaskCaller (objHandle: HCkSpider; task: HCkTask): wordbool;
begin
  result := TCkSpider_LoadTaskCaller(_map(114, 'CkSpider_LoadTaskCaller'))
    (objHandle, task);
end;

function CkSpider_RecrawlLast (objHandle: HCkSpider): wordbool;
begin
  result := TCkSpider_RecrawlLast(_map(115, 'CkSpider_RecrawlLast'))
    (objHandle);
end;

function CkSpider_RecrawlLastAsync (objHandle: HCkSpider): HCkTask;
begin
  result := TCkSpider_RecrawlLastAsync(_map(116, 'CkSpider_RecrawlLastAsync'))
    (objHandle);
end;

procedure CkSpider_SkipUnspidered (objHandle: HCkSpider; index: Integer);
begin
  TCkSpider_SkipUnspidered(_map(117, 'CkSpider_SkipUnspidered'))
    (objHandle, index);
end;

procedure CkSpider_SleepMs (objHandle: HCkSpider; numMilliseconds: Integer);
begin
  TCkSpider_SleepMs(_map(118, 'CkSpider_SleepMs'))
    (objHandle, numMilliseconds);
end;

end.
