unit SshKey;

interface

type

HCkSshKey = Pointer;
HCkPkcs11 = Pointer;
HCkString = Pointer;


function CkSshKey_Create: HCkSshKey;  stdcall;
procedure CkSshKey_Dispose(handle: HCkSshKey); stdcall;
procedure CkSshKey_getComment(objHandle: HCkSshKey; outPropVal: HCkString);
procedure CkSshKey_putComment(objHandle: HCkSshKey; newPropVal: PWideChar);
function CkSshKey__comment(objHandle: HCkSshKey): PWideChar;
procedure CkSshKey_getDebugLogFilePath(objHandle: HCkSshKey; outPropVal: HCkString);
procedure CkSshKey_putDebugLogFilePath(objHandle: HCkSshKey; newPropVal: PWideChar);
function CkSshKey__debugLogFilePath(objHandle: HCkSshKey): PWideChar;
function CkSshKey_getIsDsaKey(objHandle: HCkSshKey): wordbool;
function CkSshKey_getIsPrivateKey(objHandle: HCkSshKey): wordbool;
function CkSshKey_getIsRsaKey(objHandle: HCkSshKey): wordbool;
procedure CkSshKey_getKeyType(objHandle: HCkSshKey; outPropVal: HCkString);
function CkSshKey__keyType(objHandle: HCkSshKey): PWideChar;
procedure CkSshKey_getLastErrorHtml(objHandle: HCkSshKey; outPropVal: HCkString);
function CkSshKey__lastErrorHtml(objHandle: HCkSshKey): PWideChar;
procedure CkSshKey_getLastErrorText(objHandle: HCkSshKey; outPropVal: HCkString);
function CkSshKey__lastErrorText(objHandle: HCkSshKey): PWideChar;
procedure CkSshKey_getLastErrorXml(objHandle: HCkSshKey; outPropVal: HCkString);
function CkSshKey__lastErrorXml(objHandle: HCkSshKey): PWideChar;
function CkSshKey_getLastMethodSuccess(objHandle: HCkSshKey): wordbool;
procedure CkSshKey_putLastMethodSuccess(objHandle: HCkSshKey; newPropVal: wordbool);
procedure CkSshKey_getPassword(objHandle: HCkSshKey; outPropVal: HCkString);
procedure CkSshKey_putPassword(objHandle: HCkSshKey; newPropVal: PWideChar);
function CkSshKey__password(objHandle: HCkSshKey): PWideChar;
procedure CkSshKey_getUncommonOptions(objHandle: HCkSshKey; outPropVal: HCkString);
procedure CkSshKey_putUncommonOptions(objHandle: HCkSshKey; newPropVal: PWideChar);
function CkSshKey__uncommonOptions(objHandle: HCkSshKey): PWideChar;
function CkSshKey_getVerboseLogging(objHandle: HCkSshKey): wordbool;
procedure CkSshKey_putVerboseLogging(objHandle: HCkSshKey; newPropVal: wordbool);
procedure CkSshKey_getVersion(objHandle: HCkSshKey; outPropVal: HCkString);
function CkSshKey__version(objHandle: HCkSshKey): PWideChar;
function CkSshKey_FromOpenSshPrivateKey(objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
function CkSshKey_FromOpenSshPublicKey(objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
function CkSshKey_FromPuttyPrivateKey(objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
function CkSshKey_FromRfc4716PublicKey(objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
function CkSshKey_FromXml(objHandle: HCkSshKey; xmlKey: PWideChar): wordbool;
function CkSshKey_GenerateDsaKey(objHandle: HCkSshKey; numBits: Integer): wordbool;
function CkSshKey_GenerateEcdsaKey(objHandle: HCkSshKey; curveName: PWideChar): wordbool;
function CkSshKey_GenerateEd25519Key(objHandle: HCkSshKey): wordbool;
function CkSshKey_GenerateRsaKey(objHandle: HCkSshKey; numBits: Integer; exponent: Integer): wordbool;
function CkSshKey_GenFingerprint(objHandle: HCkSshKey; outStr: HCkString): wordbool;
function CkSshKey__genFingerprint(objHandle: HCkSshKey): PWideChar;
function CkSshKey_LoadText(objHandle: HCkSshKey; filename: PWideChar; outStr: HCkString): wordbool;
function CkSshKey__loadText(objHandle: HCkSshKey; filename: PWideChar): PWideChar;
function CkSshKey_SaveText(objHandle: HCkSshKey; strToSave: PWideChar; filename: PWideChar): wordbool;
function CkSshKey_ToOpenSshPrivateKey(objHandle: HCkSshKey; bEncrypt: wordbool; outStr: HCkString): wordbool;
function CkSshKey__toOpenSshPrivateKey(objHandle: HCkSshKey; bEncrypt: wordbool): PWideChar;
function CkSshKey_ToOpenSshPublicKey(objHandle: HCkSshKey; outStr: HCkString): wordbool;
function CkSshKey__toOpenSshPublicKey(objHandle: HCkSshKey): PWideChar;
function CkSshKey_ToPuttyPrivateKey(objHandle: HCkSshKey; bEncrypt: wordbool; outStr: HCkString): wordbool;
function CkSshKey__toPuttyPrivateKey(objHandle: HCkSshKey; bEncrypt: wordbool): PWideChar;
function CkSshKey_ToRfc4716PublicKey(objHandle: HCkSshKey; outStr: HCkString): wordbool;
function CkSshKey__toRfc4716PublicKey(objHandle: HCkSshKey): PWideChar;
function CkSshKey_ToXml(objHandle: HCkSshKey; outStr: HCkString): wordbool;
function CkSshKey__toXml(objHandle: HCkSshKey): PWideChar;
function CkSshKey_UsePkcs11(objHandle: HCkSshKey; session: HCkPkcs11; privKeyHandle: LongWord; pubKeyHandle: LongWord; keyType: PWideChar): wordbool;
function CkSshKey_UseSshCertificate(objHandle: HCkSshKey; sshCert: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSshKey_Create = function : HCkSshKey; stdcall;
  TCkSshKey_Dispose = procedure (handle: HCkSshKey); stdcall;
  TCkSshKey_getComment = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey_putComment = procedure (objHandle: HCkSshKey; newPropVal: PWideChar); stdcall;
  TCkSshKey__comment = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getDebugLogFilePath = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey_putDebugLogFilePath = procedure (objHandle: HCkSshKey; newPropVal: PWideChar); stdcall;
  TCkSshKey__debugLogFilePath = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getIsDsaKey = function (objHandle: HCkSshKey): wordbool; stdcall;
  TCkSshKey_getIsPrivateKey = function (objHandle: HCkSshKey): wordbool; stdcall;
  TCkSshKey_getIsRsaKey = function (objHandle: HCkSshKey): wordbool; stdcall;
  TCkSshKey_getKeyType = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey__keyType = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getLastErrorHtml = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey__lastErrorHtml = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getLastErrorText = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey__lastErrorText = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getLastErrorXml = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey__lastErrorXml = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getLastMethodSuccess = function (objHandle: HCkSshKey): wordbool; stdcall;
  TCkSshKey_putLastMethodSuccess = procedure (objHandle: HCkSshKey; newPropVal: wordbool); stdcall;
  TCkSshKey_getPassword = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey_putPassword = procedure (objHandle: HCkSshKey; newPropVal: PWideChar); stdcall;
  TCkSshKey__password = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getUncommonOptions = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey_putUncommonOptions = procedure (objHandle: HCkSshKey; newPropVal: PWideChar); stdcall;
  TCkSshKey__uncommonOptions = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_getVerboseLogging = function (objHandle: HCkSshKey): wordbool; stdcall;
  TCkSshKey_putVerboseLogging = procedure (objHandle: HCkSshKey; newPropVal: wordbool); stdcall;
  TCkSshKey_getVersion = procedure (objHandle: HCkSshKey; outPropVal: HCkString); stdcall;
  TCkSshKey__version = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_FromOpenSshPrivateKey = function (objHandle: HCkSshKey; keyStr: PWideChar): wordbool; stdcall;
  TCkSshKey_FromOpenSshPublicKey = function (objHandle: HCkSshKey; keyStr: PWideChar): wordbool; stdcall;
  TCkSshKey_FromPuttyPrivateKey = function (objHandle: HCkSshKey; keyStr: PWideChar): wordbool; stdcall;
  TCkSshKey_FromRfc4716PublicKey = function (objHandle: HCkSshKey; keyStr: PWideChar): wordbool; stdcall;
  TCkSshKey_FromXml = function (objHandle: HCkSshKey; xmlKey: PWideChar): wordbool; stdcall;
  TCkSshKey_GenerateDsaKey = function (objHandle: HCkSshKey; numBits: Integer): wordbool; stdcall;
  TCkSshKey_GenerateEcdsaKey = function (objHandle: HCkSshKey; curveName: PWideChar): wordbool; stdcall;
  TCkSshKey_GenerateEd25519Key = function (objHandle: HCkSshKey): wordbool; stdcall;
  TCkSshKey_GenerateRsaKey = function (objHandle: HCkSshKey; numBits: Integer; exponent: Integer): wordbool; stdcall;
  TCkSshKey_GenFingerprint = function (objHandle: HCkSshKey; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__genFingerprint = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_LoadText = function (objHandle: HCkSshKey; filename: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__loadText = function (objHandle: HCkSshKey; filename: PWideChar): PWideChar; stdcall;
  TCkSshKey_SaveText = function (objHandle: HCkSshKey; strToSave: PWideChar; filename: PWideChar): wordbool; stdcall;
  TCkSshKey_ToOpenSshPrivateKey = function (objHandle: HCkSshKey; bEncrypt: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__toOpenSshPrivateKey = function (objHandle: HCkSshKey; bEncrypt: wordbool): PWideChar; stdcall;
  TCkSshKey_ToOpenSshPublicKey = function (objHandle: HCkSshKey; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__toOpenSshPublicKey = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_ToPuttyPrivateKey = function (objHandle: HCkSshKey; bEncrypt: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__toPuttyPrivateKey = function (objHandle: HCkSshKey; bEncrypt: wordbool): PWideChar; stdcall;
  TCkSshKey_ToRfc4716PublicKey = function (objHandle: HCkSshKey; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__toRfc4716PublicKey = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_ToXml = function (objHandle: HCkSshKey; outStr: HCkString): wordbool; stdcall;
  TCkSshKey__toXml = function (objHandle: HCkSshKey): PWideChar; stdcall;
  TCkSshKey_UsePkcs11 = function (objHandle: HCkSshKey; session: HCkPkcs11; privKeyHandle: LongWord; pubKeyHandle: LongWord; keyType: PWideChar): wordbool; stdcall;
  TCkSshKey_UseSshCertificate = function (objHandle: HCkSshKey; sshCert: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..56] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSshKey_Create : HCkSshKey;
begin
  result := TCkSshKey_Create(_map(0, 'CkSshKey_Create'));
end;

procedure CkSshKey_Dispose (handle: HCkSshKey);
begin
  TCkSshKey_Dispose(_map(1, 'CkSshKey_Dispose'))
    (handle);
end;


procedure CkSshKey_getComment (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getComment(_map(2, 'CkSshKey_getComment'))
    (objHandle, outPropVal);
end;

procedure CkSshKey_putComment (objHandle: HCkSshKey; newPropVal: PWideChar);
begin
  TCkSshKey_putComment(_map(3, 'CkSshKey_putComment'))
    (objHandle, newPropVal);
end;

function CkSshKey__comment (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__comment(_map(4, 'CkSshKey__comment'))
    (objHandle);
end;

procedure CkSshKey_getDebugLogFilePath (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getDebugLogFilePath(_map(5, 'CkSshKey_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSshKey_putDebugLogFilePath (objHandle: HCkSshKey; newPropVal: PWideChar);
begin
  TCkSshKey_putDebugLogFilePath(_map(6, 'CkSshKey_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSshKey__debugLogFilePath (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__debugLogFilePath(_map(7, 'CkSshKey__debugLogFilePath'))
    (objHandle);
end;

function CkSshKey_getIsDsaKey (objHandle: HCkSshKey): wordbool;
begin
    result := TCkSshKey_getIsDsaKey(_map(8, 'CkSshKey_getIsDsaKey'))
    (objHandle);
end;

function CkSshKey_getIsPrivateKey (objHandle: HCkSshKey): wordbool;
begin
    result := TCkSshKey_getIsPrivateKey(_map(9, 'CkSshKey_getIsPrivateKey'))
    (objHandle);
end;

function CkSshKey_getIsRsaKey (objHandle: HCkSshKey): wordbool;
begin
    result := TCkSshKey_getIsRsaKey(_map(10, 'CkSshKey_getIsRsaKey'))
    (objHandle);
end;

procedure CkSshKey_getKeyType (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getKeyType(_map(11, 'CkSshKey_getKeyType'))
    (objHandle, outPropVal);
end;

function CkSshKey__keyType (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__keyType(_map(12, 'CkSshKey__keyType'))
    (objHandle);
end;

procedure CkSshKey_getLastErrorHtml (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getLastErrorHtml(_map(13, 'CkSshKey_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSshKey__lastErrorHtml (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__lastErrorHtml(_map(14, 'CkSshKey__lastErrorHtml'))
    (objHandle);
end;

procedure CkSshKey_getLastErrorText (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getLastErrorText(_map(15, 'CkSshKey_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSshKey__lastErrorText (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__lastErrorText(_map(16, 'CkSshKey__lastErrorText'))
    (objHandle);
end;

procedure CkSshKey_getLastErrorXml (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getLastErrorXml(_map(17, 'CkSshKey_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSshKey__lastErrorXml (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__lastErrorXml(_map(18, 'CkSshKey__lastErrorXml'))
    (objHandle);
end;

function CkSshKey_getLastMethodSuccess (objHandle: HCkSshKey): wordbool;
begin
    result := TCkSshKey_getLastMethodSuccess(_map(19, 'CkSshKey_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSshKey_putLastMethodSuccess (objHandle: HCkSshKey; newPropVal: wordbool);
begin
  TCkSshKey_putLastMethodSuccess(_map(20, 'CkSshKey_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkSshKey_getPassword (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getPassword(_map(21, 'CkSshKey_getPassword'))
    (objHandle, outPropVal);
end;

procedure CkSshKey_putPassword (objHandle: HCkSshKey; newPropVal: PWideChar);
begin
  TCkSshKey_putPassword(_map(22, 'CkSshKey_putPassword'))
    (objHandle, newPropVal);
end;

function CkSshKey__password (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__password(_map(23, 'CkSshKey__password'))
    (objHandle);
end;

procedure CkSshKey_getUncommonOptions (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getUncommonOptions(_map(24, 'CkSshKey_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkSshKey_putUncommonOptions (objHandle: HCkSshKey; newPropVal: PWideChar);
begin
  TCkSshKey_putUncommonOptions(_map(25, 'CkSshKey_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkSshKey__uncommonOptions (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__uncommonOptions(_map(26, 'CkSshKey__uncommonOptions'))
    (objHandle);
end;

function CkSshKey_getVerboseLogging (objHandle: HCkSshKey): wordbool;
begin
    result := TCkSshKey_getVerboseLogging(_map(27, 'CkSshKey_getVerboseLogging'))
    (objHandle);
end;

procedure CkSshKey_putVerboseLogging (objHandle: HCkSshKey; newPropVal: wordbool);
begin
  TCkSshKey_putVerboseLogging(_map(28, 'CkSshKey_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSshKey_getVersion (objHandle: HCkSshKey; outPropVal: HCkString);
begin
  TCkSshKey_getVersion(_map(29, 'CkSshKey_getVersion'))
    (objHandle, outPropVal);
end;

function CkSshKey__version (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__version(_map(30, 'CkSshKey__version'))
    (objHandle);
end;

function CkSshKey_FromOpenSshPrivateKey (objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
begin
  result := TCkSshKey_FromOpenSshPrivateKey(_map(31, 'CkSshKey_FromOpenSshPrivateKey'))
    (objHandle, keyStr);
end;

function CkSshKey_FromOpenSshPublicKey (objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
begin
  result := TCkSshKey_FromOpenSshPublicKey(_map(32, 'CkSshKey_FromOpenSshPublicKey'))
    (objHandle, keyStr);
end;

function CkSshKey_FromPuttyPrivateKey (objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
begin
  result := TCkSshKey_FromPuttyPrivateKey(_map(33, 'CkSshKey_FromPuttyPrivateKey'))
    (objHandle, keyStr);
end;

function CkSshKey_FromRfc4716PublicKey (objHandle: HCkSshKey; keyStr: PWideChar): wordbool;
begin
  result := TCkSshKey_FromRfc4716PublicKey(_map(34, 'CkSshKey_FromRfc4716PublicKey'))
    (objHandle, keyStr);
end;

function CkSshKey_FromXml (objHandle: HCkSshKey; xmlKey: PWideChar): wordbool;
begin
  result := TCkSshKey_FromXml(_map(35, 'CkSshKey_FromXml'))
    (objHandle, xmlKey);
end;

function CkSshKey_GenerateDsaKey (objHandle: HCkSshKey; numBits: Integer): wordbool;
begin
  result := TCkSshKey_GenerateDsaKey(_map(36, 'CkSshKey_GenerateDsaKey'))
    (objHandle, numBits);
end;

function CkSshKey_GenerateEcdsaKey (objHandle: HCkSshKey; curveName: PWideChar): wordbool;
begin
  result := TCkSshKey_GenerateEcdsaKey(_map(37, 'CkSshKey_GenerateEcdsaKey'))
    (objHandle, curveName);
end;

function CkSshKey_GenerateEd25519Key (objHandle: HCkSshKey): wordbool;
begin
  result := TCkSshKey_GenerateEd25519Key(_map(38, 'CkSshKey_GenerateEd25519Key'))
    (objHandle);
end;

function CkSshKey_GenerateRsaKey (objHandle: HCkSshKey; numBits: Integer; exponent: Integer): wordbool;
begin
  result := TCkSshKey_GenerateRsaKey(_map(39, 'CkSshKey_GenerateRsaKey'))
    (objHandle, numBits, exponent);
end;

function CkSshKey_GenFingerprint (objHandle: HCkSshKey; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_GenFingerprint(_map(40, 'CkSshKey_GenFingerprint'))
    (objHandle, outStr);
end;

function CkSshKey__genFingerprint (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__genFingerprint(_map(41, 'CkSshKey__genFingerprint'))
    (objHandle);
end;

function CkSshKey_LoadText (objHandle: HCkSshKey; filename: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_LoadText(_map(42, 'CkSshKey_LoadText'))
    (objHandle, filename, outStr);
end;

function CkSshKey__loadText (objHandle: HCkSshKey; filename: PWideChar): PWideChar;
begin
  result := TCkSshKey__loadText(_map(43, 'CkSshKey__loadText'))
    (objHandle, filename);
end;

function CkSshKey_SaveText (objHandle: HCkSshKey; strToSave: PWideChar; filename: PWideChar): wordbool;
begin
  result := TCkSshKey_SaveText(_map(44, 'CkSshKey_SaveText'))
    (objHandle, strToSave, filename);
end;

function CkSshKey_ToOpenSshPrivateKey (objHandle: HCkSshKey; bEncrypt: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_ToOpenSshPrivateKey(_map(45, 'CkSshKey_ToOpenSshPrivateKey'))
    (objHandle, bEncrypt, outStr);
end;

function CkSshKey__toOpenSshPrivateKey (objHandle: HCkSshKey; bEncrypt: wordbool): PWideChar;
begin
  result := TCkSshKey__toOpenSshPrivateKey(_map(46, 'CkSshKey__toOpenSshPrivateKey'))
    (objHandle, bEncrypt);
end;

function CkSshKey_ToOpenSshPublicKey (objHandle: HCkSshKey; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_ToOpenSshPublicKey(_map(47, 'CkSshKey_ToOpenSshPublicKey'))
    (objHandle, outStr);
end;

function CkSshKey__toOpenSshPublicKey (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__toOpenSshPublicKey(_map(48, 'CkSshKey__toOpenSshPublicKey'))
    (objHandle);
end;

function CkSshKey_ToPuttyPrivateKey (objHandle: HCkSshKey; bEncrypt: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_ToPuttyPrivateKey(_map(49, 'CkSshKey_ToPuttyPrivateKey'))
    (objHandle, bEncrypt, outStr);
end;

function CkSshKey__toPuttyPrivateKey (objHandle: HCkSshKey; bEncrypt: wordbool): PWideChar;
begin
  result := TCkSshKey__toPuttyPrivateKey(_map(50, 'CkSshKey__toPuttyPrivateKey'))
    (objHandle, bEncrypt);
end;

function CkSshKey_ToRfc4716PublicKey (objHandle: HCkSshKey; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_ToRfc4716PublicKey(_map(51, 'CkSshKey_ToRfc4716PublicKey'))
    (objHandle, outStr);
end;

function CkSshKey__toRfc4716PublicKey (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__toRfc4716PublicKey(_map(52, 'CkSshKey__toRfc4716PublicKey'))
    (objHandle);
end;

function CkSshKey_ToXml (objHandle: HCkSshKey; outStr: HCkString): wordbool;
begin
  result := TCkSshKey_ToXml(_map(53, 'CkSshKey_ToXml'))
    (objHandle, outStr);
end;

function CkSshKey__toXml (objHandle: HCkSshKey): PWideChar;
begin
  result := TCkSshKey__toXml(_map(54, 'CkSshKey__toXml'))
    (objHandle);
end;

function CkSshKey_UsePkcs11 (objHandle: HCkSshKey; session: HCkPkcs11; privKeyHandle: LongWord; pubKeyHandle: LongWord; keyType: PWideChar): wordbool;
begin
  result := TCkSshKey_UsePkcs11(_map(55, 'CkSshKey_UsePkcs11'))
    (objHandle, session, privKeyHandle, pubKeyHandle, keyType);
end;

function CkSshKey_UseSshCertificate (objHandle: HCkSshKey; sshCert: PWideChar): wordbool;
begin
  result := TCkSshKey_UseSshCertificate(_map(56, 'CkSshKey_UseSshCertificate'))
    (objHandle, sshCert);
end;

end.
