unit StringArray;

interface

type

HCkTask = Pointer;
HCkString = Pointer;
HCkStringArray = Pointer;


function CkStringArray_Create: HCkStringArray;  stdcall;
procedure CkStringArray_Dispose(handle: HCkStringArray); stdcall;
function CkStringArray_getCount(objHandle: HCkStringArray): Integer;
function CkStringArray_getCrlf(objHandle: HCkStringArray): wordbool;
procedure CkStringArray_putCrlf(objHandle: HCkStringArray; newPropVal: wordbool);
procedure CkStringArray_getDebugLogFilePath(objHandle: HCkStringArray; outPropVal: HCkString);
procedure CkStringArray_putDebugLogFilePath(objHandle: HCkStringArray; newPropVal: PWideChar);
function CkStringArray__debugLogFilePath(objHandle: HCkStringArray): PWideChar;
procedure CkStringArray_getLastErrorHtml(objHandle: HCkStringArray; outPropVal: HCkString);
function CkStringArray__lastErrorHtml(objHandle: HCkStringArray): PWideChar;
procedure CkStringArray_getLastErrorText(objHandle: HCkStringArray; outPropVal: HCkString);
function CkStringArray__lastErrorText(objHandle: HCkStringArray): PWideChar;
procedure CkStringArray_getLastErrorXml(objHandle: HCkStringArray; outPropVal: HCkString);
function CkStringArray__lastErrorXml(objHandle: HCkStringArray): PWideChar;
function CkStringArray_getLastMethodSuccess(objHandle: HCkStringArray): wordbool;
procedure CkStringArray_putLastMethodSuccess(objHandle: HCkStringArray; newPropVal: wordbool);
function CkStringArray_getLength(objHandle: HCkStringArray): Integer;
function CkStringArray_getTrim(objHandle: HCkStringArray): wordbool;
procedure CkStringArray_putTrim(objHandle: HCkStringArray; newPropVal: wordbool);
function CkStringArray_getUnique(objHandle: HCkStringArray): wordbool;
procedure CkStringArray_putUnique(objHandle: HCkStringArray; newPropVal: wordbool);
function CkStringArray_getVerboseLogging(objHandle: HCkStringArray): wordbool;
procedure CkStringArray_putVerboseLogging(objHandle: HCkStringArray; newPropVal: wordbool);
procedure CkStringArray_getVersion(objHandle: HCkStringArray; outPropVal: HCkString);
function CkStringArray__version(objHandle: HCkStringArray): PWideChar;
function CkStringArray_Append(objHandle: HCkStringArray; str: PWideChar): wordbool;
function CkStringArray_AppendSerialized(objHandle: HCkStringArray; encodedStr: PWideChar): wordbool;
procedure CkStringArray_Clear(objHandle: HCkStringArray);
function CkStringArray_Contains(objHandle: HCkStringArray; str: PWideChar): wordbool;
function CkStringArray_Find(objHandle: HCkStringArray; findStr: PWideChar; startIndex: Integer): Integer;
function CkStringArray_FindFirstMatch(objHandle: HCkStringArray; matchPattern: PWideChar; startIndex: Integer): Integer;
function CkStringArray_GetString(objHandle: HCkStringArray; index: Integer; outStr: HCkString): wordbool;
function CkStringArray__getString(objHandle: HCkStringArray; index: Integer): PWideChar;
function CkStringArray_GetStringLen(objHandle: HCkStringArray; index: Integer): Integer;
procedure CkStringArray_InsertAt(objHandle: HCkStringArray; index: Integer; str: PWideChar);
function CkStringArray_LastString(objHandle: HCkStringArray; outStr: HCkString): wordbool;
function CkStringArray__lastString(objHandle: HCkStringArray): PWideChar;
function CkStringArray_LoadFromFile(objHandle: HCkStringArray; path: PWideChar): wordbool;
function CkStringArray_LoadFromFile2(objHandle: HCkStringArray; path: PWideChar; charset: PWideChar): wordbool;
procedure CkStringArray_LoadFromText(objHandle: HCkStringArray; str: PWideChar);
function CkStringArray_LoadTaskResult(objHandle: HCkStringArray; task: HCkTask): wordbool;
function CkStringArray_Pop(objHandle: HCkStringArray; outStr: HCkString): wordbool;
function CkStringArray__pop(objHandle: HCkStringArray): PWideChar;
procedure CkStringArray_Prepend(objHandle: HCkStringArray; str: PWideChar);
procedure CkStringArray_Remove(objHandle: HCkStringArray; str: PWideChar);
function CkStringArray_RemoveAt(objHandle: HCkStringArray; index: Integer): wordbool;
procedure CkStringArray_ReplaceAt(objHandle: HCkStringArray; index: Integer; str: PWideChar);
function CkStringArray_SaveNthToFile(objHandle: HCkStringArray; index: Integer; saveToPath: PWideChar): wordbool;
function CkStringArray_SaveToFile(objHandle: HCkStringArray; path: PWideChar): wordbool;
function CkStringArray_SaveToFile2(objHandle: HCkStringArray; saveToPath: PWideChar; charset: PWideChar): wordbool;
function CkStringArray_SaveToText(objHandle: HCkStringArray; outStr: HCkString): wordbool;
function CkStringArray__saveToText(objHandle: HCkStringArray): PWideChar;
function CkStringArray_Serialize(objHandle: HCkStringArray; outStr: HCkString): wordbool;
function CkStringArray__serialize(objHandle: HCkStringArray): PWideChar;
procedure CkStringArray_Sort(objHandle: HCkStringArray; ascending: wordbool);
procedure CkStringArray_SplitAndAppend(objHandle: HCkStringArray; str: PWideChar; boundary: PWideChar);
function CkStringArray_StrAt(objHandle: HCkStringArray; index: Integer; outStr: HCkString): wordbool;
function CkStringArray__strAt(objHandle: HCkStringArray; index: Integer): PWideChar;
procedure CkStringArray_Subtract(objHandle: HCkStringArray; stringArrayObj: HCkStringArray);
procedure CkStringArray_Union(objHandle: HCkStringArray; stringArrayObj: HCkStringArray);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkStringArray_Create = function : HCkStringArray; stdcall;
  TCkStringArray_Dispose = procedure (handle: HCkStringArray); stdcall;
  TCkStringArray_getCount = function (objHandle: HCkStringArray): Integer; stdcall;
  TCkStringArray_getCrlf = function (objHandle: HCkStringArray): wordbool; stdcall;
  TCkStringArray_putCrlf = procedure (objHandle: HCkStringArray; newPropVal: wordbool); stdcall;
  TCkStringArray_getDebugLogFilePath = procedure (objHandle: HCkStringArray; outPropVal: HCkString); stdcall;
  TCkStringArray_putDebugLogFilePath = procedure (objHandle: HCkStringArray; newPropVal: PWideChar); stdcall;
  TCkStringArray__debugLogFilePath = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_getLastErrorHtml = procedure (objHandle: HCkStringArray; outPropVal: HCkString); stdcall;
  TCkStringArray__lastErrorHtml = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_getLastErrorText = procedure (objHandle: HCkStringArray; outPropVal: HCkString); stdcall;
  TCkStringArray__lastErrorText = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_getLastErrorXml = procedure (objHandle: HCkStringArray; outPropVal: HCkString); stdcall;
  TCkStringArray__lastErrorXml = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_getLastMethodSuccess = function (objHandle: HCkStringArray): wordbool; stdcall;
  TCkStringArray_putLastMethodSuccess = procedure (objHandle: HCkStringArray; newPropVal: wordbool); stdcall;
  TCkStringArray_getLength = function (objHandle: HCkStringArray): Integer; stdcall;
  TCkStringArray_getTrim = function (objHandle: HCkStringArray): wordbool; stdcall;
  TCkStringArray_putTrim = procedure (objHandle: HCkStringArray; newPropVal: wordbool); stdcall;
  TCkStringArray_getUnique = function (objHandle: HCkStringArray): wordbool; stdcall;
  TCkStringArray_putUnique = procedure (objHandle: HCkStringArray; newPropVal: wordbool); stdcall;
  TCkStringArray_getVerboseLogging = function (objHandle: HCkStringArray): wordbool; stdcall;
  TCkStringArray_putVerboseLogging = procedure (objHandle: HCkStringArray; newPropVal: wordbool); stdcall;
  TCkStringArray_getVersion = procedure (objHandle: HCkStringArray; outPropVal: HCkString); stdcall;
  TCkStringArray__version = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_Append = function (objHandle: HCkStringArray; str: PWideChar): wordbool; stdcall;
  TCkStringArray_AppendSerialized = function (objHandle: HCkStringArray; encodedStr: PWideChar): wordbool; stdcall;
  TCkStringArray_Clear = procedure (objHandle: HCkStringArray); stdcall;
  TCkStringArray_Contains = function (objHandle: HCkStringArray; str: PWideChar): wordbool; stdcall;
  TCkStringArray_Find = function (objHandle: HCkStringArray; findStr: PWideChar; startIndex: Integer): Integer; stdcall;
  TCkStringArray_FindFirstMatch = function (objHandle: HCkStringArray; matchPattern: PWideChar; startIndex: Integer): Integer; stdcall;
  TCkStringArray_GetString = function (objHandle: HCkStringArray; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkStringArray__getString = function (objHandle: HCkStringArray; index: Integer): PWideChar; stdcall;
  TCkStringArray_GetStringLen = function (objHandle: HCkStringArray; index: Integer): Integer; stdcall;
  TCkStringArray_InsertAt = procedure (objHandle: HCkStringArray; index: Integer; str: PWideChar); stdcall;
  TCkStringArray_LastString = function (objHandle: HCkStringArray; outStr: HCkString): wordbool; stdcall;
  TCkStringArray__lastString = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_LoadFromFile = function (objHandle: HCkStringArray; path: PWideChar): wordbool; stdcall;
  TCkStringArray_LoadFromFile2 = function (objHandle: HCkStringArray; path: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStringArray_LoadFromText = procedure (objHandle: HCkStringArray; str: PWideChar); stdcall;
  TCkStringArray_LoadTaskResult = function (objHandle: HCkStringArray; task: HCkTask): wordbool; stdcall;
  TCkStringArray_Pop = function (objHandle: HCkStringArray; outStr: HCkString): wordbool; stdcall;
  TCkStringArray__pop = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_Prepend = procedure (objHandle: HCkStringArray; str: PWideChar); stdcall;
  TCkStringArray_Remove = procedure (objHandle: HCkStringArray; str: PWideChar); stdcall;
  TCkStringArray_RemoveAt = function (objHandle: HCkStringArray; index: Integer): wordbool; stdcall;
  TCkStringArray_ReplaceAt = procedure (objHandle: HCkStringArray; index: Integer; str: PWideChar); stdcall;
  TCkStringArray_SaveNthToFile = function (objHandle: HCkStringArray; index: Integer; saveToPath: PWideChar): wordbool; stdcall;
  TCkStringArray_SaveToFile = function (objHandle: HCkStringArray; path: PWideChar): wordbool; stdcall;
  TCkStringArray_SaveToFile2 = function (objHandle: HCkStringArray; saveToPath: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStringArray_SaveToText = function (objHandle: HCkStringArray; outStr: HCkString): wordbool; stdcall;
  TCkStringArray__saveToText = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_Serialize = function (objHandle: HCkStringArray; outStr: HCkString): wordbool; stdcall;
  TCkStringArray__serialize = function (objHandle: HCkStringArray): PWideChar; stdcall;
  TCkStringArray_Sort = procedure (objHandle: HCkStringArray; ascending: wordbool); stdcall;
  TCkStringArray_SplitAndAppend = procedure (objHandle: HCkStringArray; str: PWideChar; boundary: PWideChar); stdcall;
  TCkStringArray_StrAt = function (objHandle: HCkStringArray; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkStringArray__strAt = function (objHandle: HCkStringArray; index: Integer): PWideChar; stdcall;
  TCkStringArray_Subtract = procedure (objHandle: HCkStringArray; stringArrayObj: HCkStringArray); stdcall;
  TCkStringArray_Union = procedure (objHandle: HCkStringArray; stringArrayObj: HCkStringArray); stdcall;

var
  _fkt_ptr_arr:   array [0..59] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkStringArray_Create : HCkStringArray;
begin
  result := TCkStringArray_Create(_map(0, 'CkStringArray_Create'));
end;

procedure CkStringArray_Dispose (handle: HCkStringArray);
begin
  TCkStringArray_Dispose(_map(1, 'CkStringArray_Dispose'))
    (handle);
end;


function CkStringArray_getCount (objHandle: HCkStringArray): Integer;
begin
    result := TCkStringArray_getCount(_map(2, 'CkStringArray_getCount'))
    (objHandle);
end;

function CkStringArray_getCrlf (objHandle: HCkStringArray): wordbool;
begin
    result := TCkStringArray_getCrlf(_map(3, 'CkStringArray_getCrlf'))
    (objHandle);
end;

procedure CkStringArray_putCrlf (objHandle: HCkStringArray; newPropVal: wordbool);
begin
  TCkStringArray_putCrlf(_map(4, 'CkStringArray_putCrlf'))
    (objHandle, newPropVal);
end;

procedure CkStringArray_getDebugLogFilePath (objHandle: HCkStringArray; outPropVal: HCkString);
begin
  TCkStringArray_getDebugLogFilePath(_map(5, 'CkStringArray_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkStringArray_putDebugLogFilePath (objHandle: HCkStringArray; newPropVal: PWideChar);
begin
  TCkStringArray_putDebugLogFilePath(_map(6, 'CkStringArray_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkStringArray__debugLogFilePath (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__debugLogFilePath(_map(7, 'CkStringArray__debugLogFilePath'))
    (objHandle);
end;

procedure CkStringArray_getLastErrorHtml (objHandle: HCkStringArray; outPropVal: HCkString);
begin
  TCkStringArray_getLastErrorHtml(_map(8, 'CkStringArray_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkStringArray__lastErrorHtml (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__lastErrorHtml(_map(9, 'CkStringArray__lastErrorHtml'))
    (objHandle);
end;

procedure CkStringArray_getLastErrorText (objHandle: HCkStringArray; outPropVal: HCkString);
begin
  TCkStringArray_getLastErrorText(_map(10, 'CkStringArray_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkStringArray__lastErrorText (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__lastErrorText(_map(11, 'CkStringArray__lastErrorText'))
    (objHandle);
end;

procedure CkStringArray_getLastErrorXml (objHandle: HCkStringArray; outPropVal: HCkString);
begin
  TCkStringArray_getLastErrorXml(_map(12, 'CkStringArray_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkStringArray__lastErrorXml (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__lastErrorXml(_map(13, 'CkStringArray__lastErrorXml'))
    (objHandle);
end;

function CkStringArray_getLastMethodSuccess (objHandle: HCkStringArray): wordbool;
begin
    result := TCkStringArray_getLastMethodSuccess(_map(14, 'CkStringArray_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkStringArray_putLastMethodSuccess (objHandle: HCkStringArray; newPropVal: wordbool);
begin
  TCkStringArray_putLastMethodSuccess(_map(15, 'CkStringArray_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkStringArray_getLength (objHandle: HCkStringArray): Integer;
begin
    result := TCkStringArray_getLength(_map(16, 'CkStringArray_getLength'))
    (objHandle);
end;

function CkStringArray_getTrim (objHandle: HCkStringArray): wordbool;
begin
    result := TCkStringArray_getTrim(_map(17, 'CkStringArray_getTrim'))
    (objHandle);
end;

procedure CkStringArray_putTrim (objHandle: HCkStringArray; newPropVal: wordbool);
begin
  TCkStringArray_putTrim(_map(18, 'CkStringArray_putTrim'))
    (objHandle, newPropVal);
end;

function CkStringArray_getUnique (objHandle: HCkStringArray): wordbool;
begin
    result := TCkStringArray_getUnique(_map(19, 'CkStringArray_getUnique'))
    (objHandle);
end;

procedure CkStringArray_putUnique (objHandle: HCkStringArray; newPropVal: wordbool);
begin
  TCkStringArray_putUnique(_map(20, 'CkStringArray_putUnique'))
    (objHandle, newPropVal);
end;

function CkStringArray_getVerboseLogging (objHandle: HCkStringArray): wordbool;
begin
    result := TCkStringArray_getVerboseLogging(_map(21, 'CkStringArray_getVerboseLogging'))
    (objHandle);
end;

procedure CkStringArray_putVerboseLogging (objHandle: HCkStringArray; newPropVal: wordbool);
begin
  TCkStringArray_putVerboseLogging(_map(22, 'CkStringArray_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkStringArray_getVersion (objHandle: HCkStringArray; outPropVal: HCkString);
begin
  TCkStringArray_getVersion(_map(23, 'CkStringArray_getVersion'))
    (objHandle, outPropVal);
end;

function CkStringArray__version (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__version(_map(24, 'CkStringArray__version'))
    (objHandle);
end;

function CkStringArray_Append (objHandle: HCkStringArray; str: PWideChar): wordbool;
begin
  result := TCkStringArray_Append(_map(25, 'CkStringArray_Append'))
    (objHandle, str);
end;

function CkStringArray_AppendSerialized (objHandle: HCkStringArray; encodedStr: PWideChar): wordbool;
begin
  result := TCkStringArray_AppendSerialized(_map(26, 'CkStringArray_AppendSerialized'))
    (objHandle, encodedStr);
end;

procedure CkStringArray_Clear (objHandle: HCkStringArray);
begin
  TCkStringArray_Clear(_map(27, 'CkStringArray_Clear'))
    (objHandle);
end;

function CkStringArray_Contains (objHandle: HCkStringArray; str: PWideChar): wordbool;
begin
  result := TCkStringArray_Contains(_map(28, 'CkStringArray_Contains'))
    (objHandle, str);
end;

function CkStringArray_Find (objHandle: HCkStringArray; findStr: PWideChar; startIndex: Integer): Integer;
begin
  result := TCkStringArray_Find(_map(29, 'CkStringArray_Find'))
    (objHandle, findStr, startIndex);
end;

function CkStringArray_FindFirstMatch (objHandle: HCkStringArray; matchPattern: PWideChar; startIndex: Integer): Integer;
begin
  result := TCkStringArray_FindFirstMatch(_map(30, 'CkStringArray_FindFirstMatch'))
    (objHandle, matchPattern, startIndex);
end;

function CkStringArray_GetString (objHandle: HCkStringArray; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkStringArray_GetString(_map(31, 'CkStringArray_GetString'))
    (objHandle, index, outStr);
end;

function CkStringArray__getString (objHandle: HCkStringArray; index: Integer): PWideChar;
begin
  result := TCkStringArray__getString(_map(32, 'CkStringArray__getString'))
    (objHandle, index);
end;

function CkStringArray_GetStringLen (objHandle: HCkStringArray; index: Integer): Integer;
begin
  result := TCkStringArray_GetStringLen(_map(33, 'CkStringArray_GetStringLen'))
    (objHandle, index);
end;

procedure CkStringArray_InsertAt (objHandle: HCkStringArray; index: Integer; str: PWideChar);
begin
  TCkStringArray_InsertAt(_map(34, 'CkStringArray_InsertAt'))
    (objHandle, index, str);
end;

function CkStringArray_LastString (objHandle: HCkStringArray; outStr: HCkString): wordbool;
begin
  result := TCkStringArray_LastString(_map(35, 'CkStringArray_LastString'))
    (objHandle, outStr);
end;

function CkStringArray__lastString (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__lastString(_map(36, 'CkStringArray__lastString'))
    (objHandle);
end;

function CkStringArray_LoadFromFile (objHandle: HCkStringArray; path: PWideChar): wordbool;
begin
  result := TCkStringArray_LoadFromFile(_map(37, 'CkStringArray_LoadFromFile'))
    (objHandle, path);
end;

function CkStringArray_LoadFromFile2 (objHandle: HCkStringArray; path: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStringArray_LoadFromFile2(_map(38, 'CkStringArray_LoadFromFile2'))
    (objHandle, path, charset);
end;

procedure CkStringArray_LoadFromText (objHandle: HCkStringArray; str: PWideChar);
begin
  TCkStringArray_LoadFromText(_map(39, 'CkStringArray_LoadFromText'))
    (objHandle, str);
end;

function CkStringArray_LoadTaskResult (objHandle: HCkStringArray; task: HCkTask): wordbool;
begin
  result := TCkStringArray_LoadTaskResult(_map(40, 'CkStringArray_LoadTaskResult'))
    (objHandle, task);
end;

function CkStringArray_Pop (objHandle: HCkStringArray; outStr: HCkString): wordbool;
begin
  result := TCkStringArray_Pop(_map(41, 'CkStringArray_Pop'))
    (objHandle, outStr);
end;

function CkStringArray__pop (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__pop(_map(42, 'CkStringArray__pop'))
    (objHandle);
end;

procedure CkStringArray_Prepend (objHandle: HCkStringArray; str: PWideChar);
begin
  TCkStringArray_Prepend(_map(43, 'CkStringArray_Prepend'))
    (objHandle, str);
end;

procedure CkStringArray_Remove (objHandle: HCkStringArray; str: PWideChar);
begin
  TCkStringArray_Remove(_map(44, 'CkStringArray_Remove'))
    (objHandle, str);
end;

function CkStringArray_RemoveAt (objHandle: HCkStringArray; index: Integer): wordbool;
begin
  result := TCkStringArray_RemoveAt(_map(45, 'CkStringArray_RemoveAt'))
    (objHandle, index);
end;

procedure CkStringArray_ReplaceAt (objHandle: HCkStringArray; index: Integer; str: PWideChar);
begin
  TCkStringArray_ReplaceAt(_map(46, 'CkStringArray_ReplaceAt'))
    (objHandle, index, str);
end;

function CkStringArray_SaveNthToFile (objHandle: HCkStringArray; index: Integer; saveToPath: PWideChar): wordbool;
begin
  result := TCkStringArray_SaveNthToFile(_map(47, 'CkStringArray_SaveNthToFile'))
    (objHandle, index, saveToPath);
end;

function CkStringArray_SaveToFile (objHandle: HCkStringArray; path: PWideChar): wordbool;
begin
  result := TCkStringArray_SaveToFile(_map(48, 'CkStringArray_SaveToFile'))
    (objHandle, path);
end;

function CkStringArray_SaveToFile2 (objHandle: HCkStringArray; saveToPath: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStringArray_SaveToFile2(_map(49, 'CkStringArray_SaveToFile2'))
    (objHandle, saveToPath, charset);
end;

function CkStringArray_SaveToText (objHandle: HCkStringArray; outStr: HCkString): wordbool;
begin
  result := TCkStringArray_SaveToText(_map(50, 'CkStringArray_SaveToText'))
    (objHandle, outStr);
end;

function CkStringArray__saveToText (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__saveToText(_map(51, 'CkStringArray__saveToText'))
    (objHandle);
end;

function CkStringArray_Serialize (objHandle: HCkStringArray; outStr: HCkString): wordbool;
begin
  result := TCkStringArray_Serialize(_map(52, 'CkStringArray_Serialize'))
    (objHandle, outStr);
end;

function CkStringArray__serialize (objHandle: HCkStringArray): PWideChar;
begin
  result := TCkStringArray__serialize(_map(53, 'CkStringArray__serialize'))
    (objHandle);
end;

procedure CkStringArray_Sort (objHandle: HCkStringArray; ascending: wordbool);
begin
  TCkStringArray_Sort(_map(54, 'CkStringArray_Sort'))
    (objHandle, ascending);
end;

procedure CkStringArray_SplitAndAppend (objHandle: HCkStringArray; str: PWideChar; boundary: PWideChar);
begin
  TCkStringArray_SplitAndAppend(_map(55, 'CkStringArray_SplitAndAppend'))
    (objHandle, str, boundary);
end;

function CkStringArray_StrAt (objHandle: HCkStringArray; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkStringArray_StrAt(_map(56, 'CkStringArray_StrAt'))
    (objHandle, index, outStr);
end;

function CkStringArray__strAt (objHandle: HCkStringArray; index: Integer): PWideChar;
begin
  result := TCkStringArray__strAt(_map(57, 'CkStringArray__strAt'))
    (objHandle, index);
end;

procedure CkStringArray_Subtract (objHandle: HCkStringArray; stringArrayObj: HCkStringArray);
begin
  TCkStringArray_Subtract(_map(58, 'CkStringArray_Subtract'))
    (objHandle, stringArrayObj);
end;

procedure CkStringArray_Union (objHandle: HCkStringArray; stringArrayObj: HCkStringArray);
begin
  TCkStringArray_Union(_map(59, 'CkStringArray_Union'))
    (objHandle, stringArrayObj);
end;

end.
