unit StringBuilder;

interface

type

HCkJsonObject = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkStringTable = Pointer;
HCkBinData = Pointer;


function CkStringBuilder_Create: HCkStringBuilder;  stdcall;
procedure CkStringBuilder_Dispose(handle: HCkStringBuilder); stdcall;
procedure CkStringBuilder_getDebugLogFilePath(objHandle: HCkStringBuilder; outPropVal: HCkString);
procedure CkStringBuilder_putDebugLogFilePath(objHandle: HCkStringBuilder; newPropVal: PWideChar);
function CkStringBuilder__debugLogFilePath(objHandle: HCkStringBuilder): PWideChar;
function CkStringBuilder_getHasEmojis(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_getIntValue(objHandle: HCkStringBuilder): Integer;
procedure CkStringBuilder_putIntValue(objHandle: HCkStringBuilder; newPropVal: Integer);
function CkStringBuilder_getIsBase64(objHandle: HCkStringBuilder): wordbool;
procedure CkStringBuilder_getLastErrorHtml(objHandle: HCkStringBuilder; outPropVal: HCkString);
function CkStringBuilder__lastErrorHtml(objHandle: HCkStringBuilder): PWideChar;
procedure CkStringBuilder_getLastErrorText(objHandle: HCkStringBuilder; outPropVal: HCkString);
function CkStringBuilder__lastErrorText(objHandle: HCkStringBuilder): PWideChar;
procedure CkStringBuilder_getLastErrorXml(objHandle: HCkStringBuilder; outPropVal: HCkString);
function CkStringBuilder__lastErrorXml(objHandle: HCkStringBuilder): PWideChar;
function CkStringBuilder_getLastMethodSuccess(objHandle: HCkStringBuilder): wordbool;
procedure CkStringBuilder_putLastMethodSuccess(objHandle: HCkStringBuilder; newPropVal: wordbool);
function CkStringBuilder_getLength(objHandle: HCkStringBuilder): Integer;
function CkStringBuilder_getVerboseLogging(objHandle: HCkStringBuilder): wordbool;
procedure CkStringBuilder_putVerboseLogging(objHandle: HCkStringBuilder; newPropVal: wordbool);
procedure CkStringBuilder_getVersion(objHandle: HCkStringBuilder; outPropVal: HCkString);
function CkStringBuilder__version(objHandle: HCkStringBuilder): PWideChar;
function CkStringBuilder_Append(objHandle: HCkStringBuilder; value: PWideChar): wordbool;
function CkStringBuilder_AppendBd(objHandle: HCkStringBuilder; binData: HCkBinData; charset: PWideChar; offset: Integer; numBytes: Integer): wordbool;
function CkStringBuilder_AppendEncoded(objHandle: HCkStringBuilder; binaryData: HCkByteData; encoding: PWideChar): wordbool;
function CkStringBuilder_AppendInt(objHandle: HCkStringBuilder; value: Integer): wordbool;
function CkStringBuilder_AppendInt64(objHandle: HCkStringBuilder; value: Int64): wordbool;
function CkStringBuilder_AppendLine(objHandle: HCkStringBuilder; value: PWideChar; crlf: wordbool): wordbool;
function CkStringBuilder_AppendRandom(objHandle: HCkStringBuilder; numBytes: Integer; encoding: PWideChar): wordbool;
function CkStringBuilder_AppendSb(objHandle: HCkStringBuilder; sb: HCkStringBuilder): wordbool;
function CkStringBuilder_AppendUuid(objHandle: HCkStringBuilder; lowerCase: wordbool): wordbool;
function CkStringBuilder_AppendUuid7(objHandle: HCkStringBuilder; lowerCase: wordbool): wordbool;
procedure CkStringBuilder_Clear(objHandle: HCkStringBuilder);
function CkStringBuilder_Contains(objHandle: HCkStringBuilder; str: PWideChar; caseSensitive: wordbool): wordbool;
function CkStringBuilder_ContainsWord(objHandle: HCkStringBuilder; word: PWideChar; caseSensitive: wordbool): wordbool;
function CkStringBuilder_ContentsEqual(objHandle: HCkStringBuilder; str: PWideChar; caseSensitive: wordbool): wordbool;
function CkStringBuilder_ContentsEqualSb(objHandle: HCkStringBuilder; sb: HCkStringBuilder; caseSensitive: wordbool): wordbool;
function CkStringBuilder_Decode(objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): wordbool;
function CkStringBuilder_DecodeAndAppend(objHandle: HCkStringBuilder; value: PWideChar; encoding: PWideChar; charset: PWideChar): wordbool;
function CkStringBuilder_Encode(objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): wordbool;
function CkStringBuilder_EndsWith(objHandle: HCkStringBuilder; substr: PWideChar; caseSensitive: wordbool): wordbool;
function CkStringBuilder_EntityDecode(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_GetAfterBetween(objHandle: HCkStringBuilder; searchAfter: PWideChar; beginMark: PWideChar; endMark: PWideChar; outStr: HCkString): wordbool;
function CkStringBuilder__getAfterBetween(objHandle: HCkStringBuilder; searchAfter: PWideChar; beginMark: PWideChar; endMark: PWideChar): PWideChar;
function CkStringBuilder_GetAfterFinal(objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool; outStr: HCkString): wordbool;
function CkStringBuilder__getAfterFinal(objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool): PWideChar;
function CkStringBuilder_GetAsString(objHandle: HCkStringBuilder; outStr: HCkString): wordbool;
function CkStringBuilder__getAsString(objHandle: HCkStringBuilder): PWideChar;
function CkStringBuilder_GetBefore(objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool; outStr: HCkString): wordbool;
function CkStringBuilder__getBefore(objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool): PWideChar;
function CkStringBuilder_GetBetween(objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; outStr: HCkString): wordbool;
function CkStringBuilder__getBetween(objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar): PWideChar;
function CkStringBuilder_GetDecoded(objHandle: HCkStringBuilder; encoding: PWideChar; outData: HCkByteData): wordbool;
function CkStringBuilder_GetEncoded(objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkStringBuilder__getEncoded(objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): PWideChar;
function CkStringBuilder_GetHash(objHandle: HCkStringBuilder; algorithm: PWideChar; encoding: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkStringBuilder__getHash(objHandle: HCkStringBuilder; algorithm: PWideChar; encoding: PWideChar; charset: PWideChar): PWideChar;
function CkStringBuilder_GetNth(objHandle: HCkStringBuilder; index: Integer; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; outStr: HCkString): wordbool;
function CkStringBuilder__getNth(objHandle: HCkStringBuilder; index: Integer; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): PWideChar;
function CkStringBuilder_GetRange(objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool; outStr: HCkString): wordbool;
function CkStringBuilder__getRange(objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool): PWideChar;
function CkStringBuilder_GetRangeSb(objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool; sb: HCkStringBuilder): wordbool;
function CkStringBuilder_LastNLines(objHandle: HCkStringBuilder; numLines: Integer; bCrlf: wordbool; outStr: HCkString): wordbool;
function CkStringBuilder__lastNLines(objHandle: HCkStringBuilder; numLines: Integer; bCrlf: wordbool): PWideChar;
function CkStringBuilder_LoadFile(objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar): wordbool;
function CkStringBuilder_MarkdownToHtml(objHandle: HCkStringBuilder; options: HCkJsonObject; sbHtml: HCkStringBuilder): wordbool;
function CkStringBuilder_MaskQuotedStrings(objHandle: HCkStringBuilder; maskChar: PWideChar; quoteType: Integer; maskedStrings: HCkStringTable): wordbool;
procedure CkStringBuilder_Obfuscate(objHandle: HCkStringBuilder);
function CkStringBuilder_Prepend(objHandle: HCkStringBuilder; value: PWideChar): wordbool;
function CkStringBuilder_PunyDecode(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_PunyEncode(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_RegexMatch(objHandle: HCkStringBuilder; pattern: PWideChar; json: HCkJsonObject; timeoutMs: Integer): Integer;
function CkStringBuilder_RegexReplace(objHandle: HCkStringBuilder; json: HCkJsonObject): wordbool;
function CkStringBuilder_RemoveAccents(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_RemoveAfterFinal(objHandle: HCkStringBuilder; marker: PWideChar): wordbool;
function CkStringBuilder_RemoveBefore(objHandle: HCkStringBuilder; marker: PWideChar): wordbool;
function CkStringBuilder_RemoveCharsAt(objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer): wordbool;
procedure CkStringBuilder_RemoveEmojis(objHandle: HCkStringBuilder);
function CkStringBuilder_Replace(objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer;
function CkStringBuilder_ReplaceAfterFinal(objHandle: HCkStringBuilder; marker: PWideChar; replacement: PWideChar): wordbool;
function CkStringBuilder_ReplaceAllBetween(objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; replacement: PWideChar; replaceMarks: wordbool): wordbool;
function CkStringBuilder_ReplaceBetween(objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; value: PWideChar; replacement: PWideChar): Integer;
function CkStringBuilder_ReplaceFirst(objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): wordbool;
function CkStringBuilder_ReplaceI(objHandle: HCkStringBuilder; value: PWideChar; replacement: Integer): Integer;
function CkStringBuilder_ReplaceNoCase(objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer;
function CkStringBuilder_ReplaceWord(objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer;
function CkStringBuilder_RestoreMaskedStrings(objHandle: HCkStringBuilder; quoteType: Integer; maskedStrings: HCkStringTable): wordbool;
procedure CkStringBuilder_SecureClear(objHandle: HCkStringBuilder);
function CkStringBuilder_SetNth(objHandle: HCkStringBuilder; index: Integer; value: PWideChar; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): wordbool;
function CkStringBuilder_SetString(objHandle: HCkStringBuilder; value: PWideChar): wordbool;
function CkStringBuilder_Shorten(objHandle: HCkStringBuilder; numChars: Integer): wordbool;
function CkStringBuilder_StartsWith(objHandle: HCkStringBuilder; substr: PWideChar; caseSensitive: wordbool): wordbool;
function CkStringBuilder_ToCRLF(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_ToLF(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_ToLowercase(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_ToUppercase(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_Trim(objHandle: HCkStringBuilder): wordbool;
function CkStringBuilder_TrimInsideSpaces(objHandle: HCkStringBuilder): wordbool;
procedure CkStringBuilder_Unobfuscate(objHandle: HCkStringBuilder);
function CkStringBuilder_WriteFile(objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar; emitBom: wordbool): wordbool;
function CkStringBuilder_WriteFileIfModified(objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar; emitBom: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkStringBuilder_Create = function : HCkStringBuilder; stdcall;
  TCkStringBuilder_Dispose = procedure (handle: HCkStringBuilder); stdcall;
  TCkStringBuilder_getDebugLogFilePath = procedure (objHandle: HCkStringBuilder; outPropVal: HCkString); stdcall;
  TCkStringBuilder_putDebugLogFilePath = procedure (objHandle: HCkStringBuilder; newPropVal: PWideChar); stdcall;
  TCkStringBuilder__debugLogFilePath = function (objHandle: HCkStringBuilder): PWideChar; stdcall;
  TCkStringBuilder_getHasEmojis = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_getIntValue = function (objHandle: HCkStringBuilder): Integer; stdcall;
  TCkStringBuilder_putIntValue = procedure (objHandle: HCkStringBuilder; newPropVal: Integer); stdcall;
  TCkStringBuilder_getIsBase64 = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_getLastErrorHtml = procedure (objHandle: HCkStringBuilder; outPropVal: HCkString); stdcall;
  TCkStringBuilder__lastErrorHtml = function (objHandle: HCkStringBuilder): PWideChar; stdcall;
  TCkStringBuilder_getLastErrorText = procedure (objHandle: HCkStringBuilder; outPropVal: HCkString); stdcall;
  TCkStringBuilder__lastErrorText = function (objHandle: HCkStringBuilder): PWideChar; stdcall;
  TCkStringBuilder_getLastErrorXml = procedure (objHandle: HCkStringBuilder; outPropVal: HCkString); stdcall;
  TCkStringBuilder__lastErrorXml = function (objHandle: HCkStringBuilder): PWideChar; stdcall;
  TCkStringBuilder_getLastMethodSuccess = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_putLastMethodSuccess = procedure (objHandle: HCkStringBuilder; newPropVal: wordbool); stdcall;
  TCkStringBuilder_getLength = function (objHandle: HCkStringBuilder): Integer; stdcall;
  TCkStringBuilder_getVerboseLogging = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_putVerboseLogging = procedure (objHandle: HCkStringBuilder; newPropVal: wordbool); stdcall;
  TCkStringBuilder_getVersion = procedure (objHandle: HCkStringBuilder; outPropVal: HCkString); stdcall;
  TCkStringBuilder__version = function (objHandle: HCkStringBuilder): PWideChar; stdcall;
  TCkStringBuilder_Append = function (objHandle: HCkStringBuilder; value: PWideChar): wordbool; stdcall;
  TCkStringBuilder_AppendBd = function (objHandle: HCkStringBuilder; binData: HCkBinData; charset: PWideChar; offset: Integer; numBytes: Integer): wordbool; stdcall;
  TCkStringBuilder_AppendEncoded = function (objHandle: HCkStringBuilder; binaryData: HCkByteData; encoding: PWideChar): wordbool; stdcall;
  TCkStringBuilder_AppendInt = function (objHandle: HCkStringBuilder; value: Integer): wordbool; stdcall;
  TCkStringBuilder_AppendInt64 = function (objHandle: HCkStringBuilder; value: Int64): wordbool; stdcall;
  TCkStringBuilder_AppendLine = function (objHandle: HCkStringBuilder; value: PWideChar; crlf: wordbool): wordbool; stdcall;
  TCkStringBuilder_AppendRandom = function (objHandle: HCkStringBuilder; numBytes: Integer; encoding: PWideChar): wordbool; stdcall;
  TCkStringBuilder_AppendSb = function (objHandle: HCkStringBuilder; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_AppendUuid = function (objHandle: HCkStringBuilder; lowerCase: wordbool): wordbool; stdcall;
  TCkStringBuilder_AppendUuid7 = function (objHandle: HCkStringBuilder; lowerCase: wordbool): wordbool; stdcall;
  TCkStringBuilder_Clear = procedure (objHandle: HCkStringBuilder); stdcall;
  TCkStringBuilder_Contains = function (objHandle: HCkStringBuilder; str: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringBuilder_ContainsWord = function (objHandle: HCkStringBuilder; word: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringBuilder_ContentsEqual = function (objHandle: HCkStringBuilder; str: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringBuilder_ContentsEqualSb = function (objHandle: HCkStringBuilder; sb: HCkStringBuilder; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringBuilder_Decode = function (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStringBuilder_DecodeAndAppend = function (objHandle: HCkStringBuilder; value: PWideChar; encoding: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStringBuilder_Encode = function (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStringBuilder_EndsWith = function (objHandle: HCkStringBuilder; substr: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringBuilder_EntityDecode = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_GetAfterBetween = function (objHandle: HCkStringBuilder; searchAfter: PWideChar; beginMark: PWideChar; endMark: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getAfterBetween = function (objHandle: HCkStringBuilder; searchAfter: PWideChar; beginMark: PWideChar; endMark: PWideChar): PWideChar; stdcall;
  TCkStringBuilder_GetAfterFinal = function (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getAfterFinal = function (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool): PWideChar; stdcall;
  TCkStringBuilder_GetAsString = function (objHandle: HCkStringBuilder; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getAsString = function (objHandle: HCkStringBuilder): PWideChar; stdcall;
  TCkStringBuilder_GetBefore = function (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getBefore = function (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool): PWideChar; stdcall;
  TCkStringBuilder_GetBetween = function (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getBetween = function (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar): PWideChar; stdcall;
  TCkStringBuilder_GetDecoded = function (objHandle: HCkStringBuilder; encoding: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkStringBuilder_GetEncoded = function (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getEncoded = function (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkStringBuilder_GetHash = function (objHandle: HCkStringBuilder; algorithm: PWideChar; encoding: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getHash = function (objHandle: HCkStringBuilder; algorithm: PWideChar; encoding: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkStringBuilder_GetNth = function (objHandle: HCkStringBuilder; index: Integer; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getNth = function (objHandle: HCkStringBuilder; index: Integer; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): PWideChar; stdcall;
  TCkStringBuilder_GetRange = function (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__getRange = function (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool): PWideChar; stdcall;
  TCkStringBuilder_GetRangeSb = function (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_LastNLines = function (objHandle: HCkStringBuilder; numLines: Integer; bCrlf: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkStringBuilder__lastNLines = function (objHandle: HCkStringBuilder; numLines: Integer; bCrlf: wordbool): PWideChar; stdcall;
  TCkStringBuilder_LoadFile = function (objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStringBuilder_MarkdownToHtml = function (objHandle: HCkStringBuilder; options: HCkJsonObject; sbHtml: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_MaskQuotedStrings = function (objHandle: HCkStringBuilder; maskChar: PWideChar; quoteType: Integer; maskedStrings: HCkStringTable): wordbool; stdcall;
  TCkStringBuilder_Obfuscate = procedure (objHandle: HCkStringBuilder); stdcall;
  TCkStringBuilder_Prepend = function (objHandle: HCkStringBuilder; value: PWideChar): wordbool; stdcall;
  TCkStringBuilder_PunyDecode = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_PunyEncode = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_RegexMatch = function (objHandle: HCkStringBuilder; pattern: PWideChar; json: HCkJsonObject; timeoutMs: Integer): Integer; stdcall;
  TCkStringBuilder_RegexReplace = function (objHandle: HCkStringBuilder; json: HCkJsonObject): wordbool; stdcall;
  TCkStringBuilder_RemoveAccents = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_RemoveAfterFinal = function (objHandle: HCkStringBuilder; marker: PWideChar): wordbool; stdcall;
  TCkStringBuilder_RemoveBefore = function (objHandle: HCkStringBuilder; marker: PWideChar): wordbool; stdcall;
  TCkStringBuilder_RemoveCharsAt = function (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer): wordbool; stdcall;
  TCkStringBuilder_RemoveEmojis = procedure (objHandle: HCkStringBuilder); stdcall;
  TCkStringBuilder_Replace = function (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer; stdcall;
  TCkStringBuilder_ReplaceAfterFinal = function (objHandle: HCkStringBuilder; marker: PWideChar; replacement: PWideChar): wordbool; stdcall;
  TCkStringBuilder_ReplaceAllBetween = function (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; replacement: PWideChar; replaceMarks: wordbool): wordbool; stdcall;
  TCkStringBuilder_ReplaceBetween = function (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; value: PWideChar; replacement: PWideChar): Integer; stdcall;
  TCkStringBuilder_ReplaceFirst = function (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): wordbool; stdcall;
  TCkStringBuilder_ReplaceI = function (objHandle: HCkStringBuilder; value: PWideChar; replacement: Integer): Integer; stdcall;
  TCkStringBuilder_ReplaceNoCase = function (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer; stdcall;
  TCkStringBuilder_ReplaceWord = function (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer; stdcall;
  TCkStringBuilder_RestoreMaskedStrings = function (objHandle: HCkStringBuilder; quoteType: Integer; maskedStrings: HCkStringTable): wordbool; stdcall;
  TCkStringBuilder_SecureClear = procedure (objHandle: HCkStringBuilder); stdcall;
  TCkStringBuilder_SetNth = function (objHandle: HCkStringBuilder; index: Integer; value: PWideChar; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): wordbool; stdcall;
  TCkStringBuilder_SetString = function (objHandle: HCkStringBuilder; value: PWideChar): wordbool; stdcall;
  TCkStringBuilder_Shorten = function (objHandle: HCkStringBuilder; numChars: Integer): wordbool; stdcall;
  TCkStringBuilder_StartsWith = function (objHandle: HCkStringBuilder; substr: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringBuilder_ToCRLF = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_ToLF = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_ToLowercase = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_ToUppercase = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_Trim = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_TrimInsideSpaces = function (objHandle: HCkStringBuilder): wordbool; stdcall;
  TCkStringBuilder_Unobfuscate = procedure (objHandle: HCkStringBuilder); stdcall;
  TCkStringBuilder_WriteFile = function (objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar; emitBom: wordbool): wordbool; stdcall;
  TCkStringBuilder_WriteFileIfModified = function (objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar; emitBom: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..100] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkStringBuilder_Create : HCkStringBuilder;
begin
  result := TCkStringBuilder_Create(_map(0, 'CkStringBuilder_Create'));
end;

procedure CkStringBuilder_Dispose (handle: HCkStringBuilder);
begin
  TCkStringBuilder_Dispose(_map(1, 'CkStringBuilder_Dispose'))
    (handle);
end;


procedure CkStringBuilder_getDebugLogFilePath (objHandle: HCkStringBuilder; outPropVal: HCkString);
begin
  TCkStringBuilder_getDebugLogFilePath(_map(2, 'CkStringBuilder_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkStringBuilder_putDebugLogFilePath (objHandle: HCkStringBuilder; newPropVal: PWideChar);
begin
  TCkStringBuilder_putDebugLogFilePath(_map(3, 'CkStringBuilder_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkStringBuilder__debugLogFilePath (objHandle: HCkStringBuilder): PWideChar;
begin
  result := TCkStringBuilder__debugLogFilePath(_map(4, 'CkStringBuilder__debugLogFilePath'))
    (objHandle);
end;

function CkStringBuilder_getHasEmojis (objHandle: HCkStringBuilder): wordbool;
begin
    result := TCkStringBuilder_getHasEmojis(_map(5, 'CkStringBuilder_getHasEmojis'))
    (objHandle);
end;

function CkStringBuilder_getIntValue (objHandle: HCkStringBuilder): Integer;
begin
    result := TCkStringBuilder_getIntValue(_map(6, 'CkStringBuilder_getIntValue'))
    (objHandle);
end;

procedure CkStringBuilder_putIntValue (objHandle: HCkStringBuilder; newPropVal: Integer);
begin
  TCkStringBuilder_putIntValue(_map(7, 'CkStringBuilder_putIntValue'))
    (objHandle, newPropVal);
end;

function CkStringBuilder_getIsBase64 (objHandle: HCkStringBuilder): wordbool;
begin
    result := TCkStringBuilder_getIsBase64(_map(8, 'CkStringBuilder_getIsBase64'))
    (objHandle);
end;

procedure CkStringBuilder_getLastErrorHtml (objHandle: HCkStringBuilder; outPropVal: HCkString);
begin
  TCkStringBuilder_getLastErrorHtml(_map(9, 'CkStringBuilder_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkStringBuilder__lastErrorHtml (objHandle: HCkStringBuilder): PWideChar;
begin
  result := TCkStringBuilder__lastErrorHtml(_map(10, 'CkStringBuilder__lastErrorHtml'))
    (objHandle);
end;

procedure CkStringBuilder_getLastErrorText (objHandle: HCkStringBuilder; outPropVal: HCkString);
begin
  TCkStringBuilder_getLastErrorText(_map(11, 'CkStringBuilder_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkStringBuilder__lastErrorText (objHandle: HCkStringBuilder): PWideChar;
begin
  result := TCkStringBuilder__lastErrorText(_map(12, 'CkStringBuilder__lastErrorText'))
    (objHandle);
end;

procedure CkStringBuilder_getLastErrorXml (objHandle: HCkStringBuilder; outPropVal: HCkString);
begin
  TCkStringBuilder_getLastErrorXml(_map(13, 'CkStringBuilder_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkStringBuilder__lastErrorXml (objHandle: HCkStringBuilder): PWideChar;
begin
  result := TCkStringBuilder__lastErrorXml(_map(14, 'CkStringBuilder__lastErrorXml'))
    (objHandle);
end;

function CkStringBuilder_getLastMethodSuccess (objHandle: HCkStringBuilder): wordbool;
begin
    result := TCkStringBuilder_getLastMethodSuccess(_map(15, 'CkStringBuilder_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkStringBuilder_putLastMethodSuccess (objHandle: HCkStringBuilder; newPropVal: wordbool);
begin
  TCkStringBuilder_putLastMethodSuccess(_map(16, 'CkStringBuilder_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkStringBuilder_getLength (objHandle: HCkStringBuilder): Integer;
begin
    result := TCkStringBuilder_getLength(_map(17, 'CkStringBuilder_getLength'))
    (objHandle);
end;

function CkStringBuilder_getVerboseLogging (objHandle: HCkStringBuilder): wordbool;
begin
    result := TCkStringBuilder_getVerboseLogging(_map(18, 'CkStringBuilder_getVerboseLogging'))
    (objHandle);
end;

procedure CkStringBuilder_putVerboseLogging (objHandle: HCkStringBuilder; newPropVal: wordbool);
begin
  TCkStringBuilder_putVerboseLogging(_map(19, 'CkStringBuilder_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkStringBuilder_getVersion (objHandle: HCkStringBuilder; outPropVal: HCkString);
begin
  TCkStringBuilder_getVersion(_map(20, 'CkStringBuilder_getVersion'))
    (objHandle, outPropVal);
end;

function CkStringBuilder__version (objHandle: HCkStringBuilder): PWideChar;
begin
  result := TCkStringBuilder__version(_map(21, 'CkStringBuilder__version'))
    (objHandle);
end;

function CkStringBuilder_Append (objHandle: HCkStringBuilder; value: PWideChar): wordbool;
begin
  result := TCkStringBuilder_Append(_map(22, 'CkStringBuilder_Append'))
    (objHandle, value);
end;

function CkStringBuilder_AppendBd (objHandle: HCkStringBuilder; binData: HCkBinData; charset: PWideChar; offset: Integer; numBytes: Integer): wordbool;
begin
  result := TCkStringBuilder_AppendBd(_map(23, 'CkStringBuilder_AppendBd'))
    (objHandle, binData, charset, offset, numBytes);
end;

function CkStringBuilder_AppendEncoded (objHandle: HCkStringBuilder; binaryData: HCkByteData; encoding: PWideChar): wordbool;
begin
  result := TCkStringBuilder_AppendEncoded(_map(24, 'CkStringBuilder_AppendEncoded'))
    (objHandle, binaryData, encoding);
end;

function CkStringBuilder_AppendInt (objHandle: HCkStringBuilder; value: Integer): wordbool;
begin
  result := TCkStringBuilder_AppendInt(_map(25, 'CkStringBuilder_AppendInt'))
    (objHandle, value);
end;

function CkStringBuilder_AppendInt64 (objHandle: HCkStringBuilder; value: Int64): wordbool;
begin
  result := TCkStringBuilder_AppendInt64(_map(26, 'CkStringBuilder_AppendInt64'))
    (objHandle, value);
end;

function CkStringBuilder_AppendLine (objHandle: HCkStringBuilder; value: PWideChar; crlf: wordbool): wordbool;
begin
  result := TCkStringBuilder_AppendLine(_map(27, 'CkStringBuilder_AppendLine'))
    (objHandle, value, crlf);
end;

function CkStringBuilder_AppendRandom (objHandle: HCkStringBuilder; numBytes: Integer; encoding: PWideChar): wordbool;
begin
  result := TCkStringBuilder_AppendRandom(_map(28, 'CkStringBuilder_AppendRandom'))
    (objHandle, numBytes, encoding);
end;

function CkStringBuilder_AppendSb (objHandle: HCkStringBuilder; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_AppendSb(_map(29, 'CkStringBuilder_AppendSb'))
    (objHandle, sb);
end;

function CkStringBuilder_AppendUuid (objHandle: HCkStringBuilder; lowerCase: wordbool): wordbool;
begin
  result := TCkStringBuilder_AppendUuid(_map(30, 'CkStringBuilder_AppendUuid'))
    (objHandle, lowerCase);
end;

function CkStringBuilder_AppendUuid7 (objHandle: HCkStringBuilder; lowerCase: wordbool): wordbool;
begin
  result := TCkStringBuilder_AppendUuid7(_map(31, 'CkStringBuilder_AppendUuid7'))
    (objHandle, lowerCase);
end;

procedure CkStringBuilder_Clear (objHandle: HCkStringBuilder);
begin
  TCkStringBuilder_Clear(_map(32, 'CkStringBuilder_Clear'))
    (objHandle);
end;

function CkStringBuilder_Contains (objHandle: HCkStringBuilder; str: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringBuilder_Contains(_map(33, 'CkStringBuilder_Contains'))
    (objHandle, str, caseSensitive);
end;

function CkStringBuilder_ContainsWord (objHandle: HCkStringBuilder; word: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringBuilder_ContainsWord(_map(34, 'CkStringBuilder_ContainsWord'))
    (objHandle, word, caseSensitive);
end;

function CkStringBuilder_ContentsEqual (objHandle: HCkStringBuilder; str: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringBuilder_ContentsEqual(_map(35, 'CkStringBuilder_ContentsEqual'))
    (objHandle, str, caseSensitive);
end;

function CkStringBuilder_ContentsEqualSb (objHandle: HCkStringBuilder; sb: HCkStringBuilder; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringBuilder_ContentsEqualSb(_map(36, 'CkStringBuilder_ContentsEqualSb'))
    (objHandle, sb, caseSensitive);
end;

function CkStringBuilder_Decode (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStringBuilder_Decode(_map(37, 'CkStringBuilder_Decode'))
    (objHandle, encoding, charset);
end;

function CkStringBuilder_DecodeAndAppend (objHandle: HCkStringBuilder; value: PWideChar; encoding: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStringBuilder_DecodeAndAppend(_map(38, 'CkStringBuilder_DecodeAndAppend'))
    (objHandle, value, encoding, charset);
end;

function CkStringBuilder_Encode (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStringBuilder_Encode(_map(39, 'CkStringBuilder_Encode'))
    (objHandle, encoding, charset);
end;

function CkStringBuilder_EndsWith (objHandle: HCkStringBuilder; substr: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringBuilder_EndsWith(_map(40, 'CkStringBuilder_EndsWith'))
    (objHandle, substr, caseSensitive);
end;

function CkStringBuilder_EntityDecode (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_EntityDecode(_map(41, 'CkStringBuilder_EntityDecode'))
    (objHandle);
end;

function CkStringBuilder_GetAfterBetween (objHandle: HCkStringBuilder; searchAfter: PWideChar; beginMark: PWideChar; endMark: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetAfterBetween(_map(42, 'CkStringBuilder_GetAfterBetween'))
    (objHandle, searchAfter, beginMark, endMark, outStr);
end;

function CkStringBuilder__getAfterBetween (objHandle: HCkStringBuilder; searchAfter: PWideChar; beginMark: PWideChar; endMark: PWideChar): PWideChar;
begin
  result := TCkStringBuilder__getAfterBetween(_map(43, 'CkStringBuilder__getAfterBetween'))
    (objHandle, searchAfter, beginMark, endMark);
end;

function CkStringBuilder_GetAfterFinal (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetAfterFinal(_map(44, 'CkStringBuilder_GetAfterFinal'))
    (objHandle, marker, removeFlag, outStr);
end;

function CkStringBuilder__getAfterFinal (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool): PWideChar;
begin
  result := TCkStringBuilder__getAfterFinal(_map(45, 'CkStringBuilder__getAfterFinal'))
    (objHandle, marker, removeFlag);
end;

function CkStringBuilder_GetAsString (objHandle: HCkStringBuilder; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetAsString(_map(46, 'CkStringBuilder_GetAsString'))
    (objHandle, outStr);
end;

function CkStringBuilder__getAsString (objHandle: HCkStringBuilder): PWideChar;
begin
  result := TCkStringBuilder__getAsString(_map(47, 'CkStringBuilder__getAsString'))
    (objHandle);
end;

function CkStringBuilder_GetBefore (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetBefore(_map(48, 'CkStringBuilder_GetBefore'))
    (objHandle, marker, removeFlag, outStr);
end;

function CkStringBuilder__getBefore (objHandle: HCkStringBuilder; marker: PWideChar; removeFlag: wordbool): PWideChar;
begin
  result := TCkStringBuilder__getBefore(_map(49, 'CkStringBuilder__getBefore'))
    (objHandle, marker, removeFlag);
end;

function CkStringBuilder_GetBetween (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetBetween(_map(50, 'CkStringBuilder_GetBetween'))
    (objHandle, beginMark, endMark, outStr);
end;

function CkStringBuilder__getBetween (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar): PWideChar;
begin
  result := TCkStringBuilder__getBetween(_map(51, 'CkStringBuilder__getBetween'))
    (objHandle, beginMark, endMark);
end;

function CkStringBuilder_GetDecoded (objHandle: HCkStringBuilder; encoding: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkStringBuilder_GetDecoded(_map(52, 'CkStringBuilder_GetDecoded'))
    (objHandle, encoding, outData);
end;

function CkStringBuilder_GetEncoded (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetEncoded(_map(53, 'CkStringBuilder_GetEncoded'))
    (objHandle, encoding, charset, outStr);
end;

function CkStringBuilder__getEncoded (objHandle: HCkStringBuilder; encoding: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkStringBuilder__getEncoded(_map(54, 'CkStringBuilder__getEncoded'))
    (objHandle, encoding, charset);
end;

function CkStringBuilder_GetHash (objHandle: HCkStringBuilder; algorithm: PWideChar; encoding: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetHash(_map(55, 'CkStringBuilder_GetHash'))
    (objHandle, algorithm, encoding, charset, outStr);
end;

function CkStringBuilder__getHash (objHandle: HCkStringBuilder; algorithm: PWideChar; encoding: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkStringBuilder__getHash(_map(56, 'CkStringBuilder__getHash'))
    (objHandle, algorithm, encoding, charset);
end;

function CkStringBuilder_GetNth (objHandle: HCkStringBuilder; index: Integer; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetNth(_map(57, 'CkStringBuilder_GetNth'))
    (objHandle, index, delimiterChar, exceptDoubleQuoted, exceptEscaped, outStr);
end;

function CkStringBuilder__getNth (objHandle: HCkStringBuilder; index: Integer; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): PWideChar;
begin
  result := TCkStringBuilder__getNth(_map(58, 'CkStringBuilder__getNth'))
    (objHandle, index, delimiterChar, exceptDoubleQuoted, exceptEscaped);
end;

function CkStringBuilder_GetRange (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_GetRange(_map(59, 'CkStringBuilder_GetRange'))
    (objHandle, startIndex, numChars, removeFlag, outStr);
end;

function CkStringBuilder__getRange (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool): PWideChar;
begin
  result := TCkStringBuilder__getRange(_map(60, 'CkStringBuilder__getRange'))
    (objHandle, startIndex, numChars, removeFlag);
end;

function CkStringBuilder_GetRangeSb (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer; removeFlag: wordbool; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_GetRangeSb(_map(61, 'CkStringBuilder_GetRangeSb'))
    (objHandle, startIndex, numChars, removeFlag, sb);
end;

function CkStringBuilder_LastNLines (objHandle: HCkStringBuilder; numLines: Integer; bCrlf: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkStringBuilder_LastNLines(_map(62, 'CkStringBuilder_LastNLines'))
    (objHandle, numLines, bCrlf, outStr);
end;

function CkStringBuilder__lastNLines (objHandle: HCkStringBuilder; numLines: Integer; bCrlf: wordbool): PWideChar;
begin
  result := TCkStringBuilder__lastNLines(_map(63, 'CkStringBuilder__lastNLines'))
    (objHandle, numLines, bCrlf);
end;

function CkStringBuilder_LoadFile (objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStringBuilder_LoadFile(_map(64, 'CkStringBuilder_LoadFile'))
    (objHandle, path, charset);
end;

function CkStringBuilder_MarkdownToHtml (objHandle: HCkStringBuilder; options: HCkJsonObject; sbHtml: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_MarkdownToHtml(_map(65, 'CkStringBuilder_MarkdownToHtml'))
    (objHandle, options, sbHtml);
end;

function CkStringBuilder_MaskQuotedStrings (objHandle: HCkStringBuilder; maskChar: PWideChar; quoteType: Integer; maskedStrings: HCkStringTable): wordbool;
begin
  result := TCkStringBuilder_MaskQuotedStrings(_map(66, 'CkStringBuilder_MaskQuotedStrings'))
    (objHandle, maskChar, quoteType, maskedStrings);
end;

procedure CkStringBuilder_Obfuscate (objHandle: HCkStringBuilder);
begin
  TCkStringBuilder_Obfuscate(_map(67, 'CkStringBuilder_Obfuscate'))
    (objHandle);
end;

function CkStringBuilder_Prepend (objHandle: HCkStringBuilder; value: PWideChar): wordbool;
begin
  result := TCkStringBuilder_Prepend(_map(68, 'CkStringBuilder_Prepend'))
    (objHandle, value);
end;

function CkStringBuilder_PunyDecode (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_PunyDecode(_map(69, 'CkStringBuilder_PunyDecode'))
    (objHandle);
end;

function CkStringBuilder_PunyEncode (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_PunyEncode(_map(70, 'CkStringBuilder_PunyEncode'))
    (objHandle);
end;

function CkStringBuilder_RegexMatch (objHandle: HCkStringBuilder; pattern: PWideChar; json: HCkJsonObject; timeoutMs: Integer): Integer;
begin
  result := TCkStringBuilder_RegexMatch(_map(71, 'CkStringBuilder_RegexMatch'))
    (objHandle, pattern, json, timeoutMs);
end;

function CkStringBuilder_RegexReplace (objHandle: HCkStringBuilder; json: HCkJsonObject): wordbool;
begin
  result := TCkStringBuilder_RegexReplace(_map(72, 'CkStringBuilder_RegexReplace'))
    (objHandle, json);
end;

function CkStringBuilder_RemoveAccents (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_RemoveAccents(_map(73, 'CkStringBuilder_RemoveAccents'))
    (objHandle);
end;

function CkStringBuilder_RemoveAfterFinal (objHandle: HCkStringBuilder; marker: PWideChar): wordbool;
begin
  result := TCkStringBuilder_RemoveAfterFinal(_map(74, 'CkStringBuilder_RemoveAfterFinal'))
    (objHandle, marker);
end;

function CkStringBuilder_RemoveBefore (objHandle: HCkStringBuilder; marker: PWideChar): wordbool;
begin
  result := TCkStringBuilder_RemoveBefore(_map(75, 'CkStringBuilder_RemoveBefore'))
    (objHandle, marker);
end;

function CkStringBuilder_RemoveCharsAt (objHandle: HCkStringBuilder; startIndex: Integer; numChars: Integer): wordbool;
begin
  result := TCkStringBuilder_RemoveCharsAt(_map(76, 'CkStringBuilder_RemoveCharsAt'))
    (objHandle, startIndex, numChars);
end;

procedure CkStringBuilder_RemoveEmojis (objHandle: HCkStringBuilder);
begin
  TCkStringBuilder_RemoveEmojis(_map(77, 'CkStringBuilder_RemoveEmojis'))
    (objHandle);
end;

function CkStringBuilder_Replace (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer;
begin
  result := TCkStringBuilder_Replace(_map(78, 'CkStringBuilder_Replace'))
    (objHandle, value, replacement);
end;

function CkStringBuilder_ReplaceAfterFinal (objHandle: HCkStringBuilder; marker: PWideChar; replacement: PWideChar): wordbool;
begin
  result := TCkStringBuilder_ReplaceAfterFinal(_map(79, 'CkStringBuilder_ReplaceAfterFinal'))
    (objHandle, marker, replacement);
end;

function CkStringBuilder_ReplaceAllBetween (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; replacement: PWideChar; replaceMarks: wordbool): wordbool;
begin
  result := TCkStringBuilder_ReplaceAllBetween(_map(80, 'CkStringBuilder_ReplaceAllBetween'))
    (objHandle, beginMark, endMark, replacement, replaceMarks);
end;

function CkStringBuilder_ReplaceBetween (objHandle: HCkStringBuilder; beginMark: PWideChar; endMark: PWideChar; value: PWideChar; replacement: PWideChar): Integer;
begin
  result := TCkStringBuilder_ReplaceBetween(_map(81, 'CkStringBuilder_ReplaceBetween'))
    (objHandle, beginMark, endMark, value, replacement);
end;

function CkStringBuilder_ReplaceFirst (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): wordbool;
begin
  result := TCkStringBuilder_ReplaceFirst(_map(82, 'CkStringBuilder_ReplaceFirst'))
    (objHandle, value, replacement);
end;

function CkStringBuilder_ReplaceI (objHandle: HCkStringBuilder; value: PWideChar; replacement: Integer): Integer;
begin
  result := TCkStringBuilder_ReplaceI(_map(83, 'CkStringBuilder_ReplaceI'))
    (objHandle, value, replacement);
end;

function CkStringBuilder_ReplaceNoCase (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer;
begin
  result := TCkStringBuilder_ReplaceNoCase(_map(84, 'CkStringBuilder_ReplaceNoCase'))
    (objHandle, value, replacement);
end;

function CkStringBuilder_ReplaceWord (objHandle: HCkStringBuilder; value: PWideChar; replacement: PWideChar): Integer;
begin
  result := TCkStringBuilder_ReplaceWord(_map(85, 'CkStringBuilder_ReplaceWord'))
    (objHandle, value, replacement);
end;

function CkStringBuilder_RestoreMaskedStrings (objHandle: HCkStringBuilder; quoteType: Integer; maskedStrings: HCkStringTable): wordbool;
begin
  result := TCkStringBuilder_RestoreMaskedStrings(_map(86, 'CkStringBuilder_RestoreMaskedStrings'))
    (objHandle, quoteType, maskedStrings);
end;

procedure CkStringBuilder_SecureClear (objHandle: HCkStringBuilder);
begin
  TCkStringBuilder_SecureClear(_map(87, 'CkStringBuilder_SecureClear'))
    (objHandle);
end;

function CkStringBuilder_SetNth (objHandle: HCkStringBuilder; index: Integer; value: PWideChar; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): wordbool;
begin
  result := TCkStringBuilder_SetNth(_map(88, 'CkStringBuilder_SetNth'))
    (objHandle, index, value, delimiterChar, exceptDoubleQuoted, exceptEscaped);
end;

function CkStringBuilder_SetString (objHandle: HCkStringBuilder; value: PWideChar): wordbool;
begin
  result := TCkStringBuilder_SetString(_map(89, 'CkStringBuilder_SetString'))
    (objHandle, value);
end;

function CkStringBuilder_Shorten (objHandle: HCkStringBuilder; numChars: Integer): wordbool;
begin
  result := TCkStringBuilder_Shorten(_map(90, 'CkStringBuilder_Shorten'))
    (objHandle, numChars);
end;

function CkStringBuilder_StartsWith (objHandle: HCkStringBuilder; substr: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringBuilder_StartsWith(_map(91, 'CkStringBuilder_StartsWith'))
    (objHandle, substr, caseSensitive);
end;

function CkStringBuilder_ToCRLF (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_ToCRLF(_map(92, 'CkStringBuilder_ToCRLF'))
    (objHandle);
end;

function CkStringBuilder_ToLF (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_ToLF(_map(93, 'CkStringBuilder_ToLF'))
    (objHandle);
end;

function CkStringBuilder_ToLowercase (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_ToLowercase(_map(94, 'CkStringBuilder_ToLowercase'))
    (objHandle);
end;

function CkStringBuilder_ToUppercase (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_ToUppercase(_map(95, 'CkStringBuilder_ToUppercase'))
    (objHandle);
end;

function CkStringBuilder_Trim (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_Trim(_map(96, 'CkStringBuilder_Trim'))
    (objHandle);
end;

function CkStringBuilder_TrimInsideSpaces (objHandle: HCkStringBuilder): wordbool;
begin
  result := TCkStringBuilder_TrimInsideSpaces(_map(97, 'CkStringBuilder_TrimInsideSpaces'))
    (objHandle);
end;

procedure CkStringBuilder_Unobfuscate (objHandle: HCkStringBuilder);
begin
  TCkStringBuilder_Unobfuscate(_map(98, 'CkStringBuilder_Unobfuscate'))
    (objHandle);
end;

function CkStringBuilder_WriteFile (objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar; emitBom: wordbool): wordbool;
begin
  result := TCkStringBuilder_WriteFile(_map(99, 'CkStringBuilder_WriteFile'))
    (objHandle, path, charset, emitBom);
end;

function CkStringBuilder_WriteFileIfModified (objHandle: HCkStringBuilder; path: PWideChar; charset: PWideChar; emitBom: wordbool): wordbool;
begin
  result := TCkStringBuilder_WriteFileIfModified(_map(100, 'CkStringBuilder_WriteFileIfModified'))
    (objHandle, path, charset, emitBom);
end;

end.
