unit StringTable;

interface

type

HCkStringTable = Pointer;
HCkStringBuilder = Pointer;
HCkString = Pointer;


function CkStringTable_Create: HCkStringTable;  stdcall;
procedure CkStringTable_Dispose(handle: HCkStringTable); stdcall;
function CkStringTable_getCount(objHandle: HCkStringTable): Integer;
procedure CkStringTable_getDebugLogFilePath(objHandle: HCkStringTable; outPropVal: HCkString);
procedure CkStringTable_putDebugLogFilePath(objHandle: HCkStringTable; newPropVal: PWideChar);
function CkStringTable__debugLogFilePath(objHandle: HCkStringTable): PWideChar;
procedure CkStringTable_getLastErrorHtml(objHandle: HCkStringTable; outPropVal: HCkString);
function CkStringTable__lastErrorHtml(objHandle: HCkStringTable): PWideChar;
procedure CkStringTable_getLastErrorText(objHandle: HCkStringTable; outPropVal: HCkString);
function CkStringTable__lastErrorText(objHandle: HCkStringTable): PWideChar;
procedure CkStringTable_getLastErrorXml(objHandle: HCkStringTable; outPropVal: HCkString);
function CkStringTable__lastErrorXml(objHandle: HCkStringTable): PWideChar;
function CkStringTable_getLastMethodSuccess(objHandle: HCkStringTable): wordbool;
procedure CkStringTable_putLastMethodSuccess(objHandle: HCkStringTable; newPropVal: wordbool);
function CkStringTable_getVerboseLogging(objHandle: HCkStringTable): wordbool;
procedure CkStringTable_putVerboseLogging(objHandle: HCkStringTable; newPropVal: wordbool);
procedure CkStringTable_getVersion(objHandle: HCkStringTable; outPropVal: HCkString);
function CkStringTable__version(objHandle: HCkStringTable): PWideChar;
function CkStringTable_Append(objHandle: HCkStringTable; value: PWideChar): wordbool;
function CkStringTable_AppendFromFile(objHandle: HCkStringTable; maxLineLen: Integer; charset: PWideChar; path: PWideChar): wordbool;
function CkStringTable_AppendFromSb(objHandle: HCkStringTable; sb: HCkStringBuilder): wordbool;
procedure CkStringTable_Clear(objHandle: HCkStringTable);
function CkStringTable_FindMatch(objHandle: HCkStringTable; sb: HCkStringBuilder; caseSensitive: wordbool): Integer;
function CkStringTable_FindSubstring(objHandle: HCkStringTable; startIndex: Integer; substr: PWideChar; caseSensitive: wordbool): Integer;
function CkStringTable_GetStrings(objHandle: HCkStringTable; startIdx: Integer; count: Integer; crlf: wordbool; outStr: HCkString): wordbool;
function CkStringTable__getStrings(objHandle: HCkStringTable; startIdx: Integer; count: Integer; crlf: wordbool): PWideChar;
function CkStringTable_IntAt(objHandle: HCkStringTable; index: Integer): Integer;
function CkStringTable_SaveToFile(objHandle: HCkStringTable; charset: PWideChar; bCrlf: wordbool; path: PWideChar): wordbool;
function CkStringTable_Sort(objHandle: HCkStringTable; ascending: wordbool; caseSensitive: wordbool): wordbool;
function CkStringTable_SplitAndAppend(objHandle: HCkStringTable; inStr: PWideChar; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): wordbool;
function CkStringTable_StringAt(objHandle: HCkStringTable; index: Integer; outStr: HCkString): wordbool;
function CkStringTable__stringAt(objHandle: HCkStringTable; index: Integer): PWideChar;
function CkStringTable_StringAtSb(objHandle: HCkStringTable; index: Integer; sb: HCkStringBuilder): wordbool;
function CkStringTable_ToSb(objHandle: HCkStringTable; sb: HCkStringBuilder): wordbool;
function CkStringTable_WordFollowing(objHandle: HCkStringTable; sb: HCkStringBuilder; captureEmailAddr: wordbool; sbWord: HCkStringBuilder): Integer;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkStringTable_Create = function : HCkStringTable; stdcall;
  TCkStringTable_Dispose = procedure (handle: HCkStringTable); stdcall;
  TCkStringTable_getCount = function (objHandle: HCkStringTable): Integer; stdcall;
  TCkStringTable_getDebugLogFilePath = procedure (objHandle: HCkStringTable; outPropVal: HCkString); stdcall;
  TCkStringTable_putDebugLogFilePath = procedure (objHandle: HCkStringTable; newPropVal: PWideChar); stdcall;
  TCkStringTable__debugLogFilePath = function (objHandle: HCkStringTable): PWideChar; stdcall;
  TCkStringTable_getLastErrorHtml = procedure (objHandle: HCkStringTable; outPropVal: HCkString); stdcall;
  TCkStringTable__lastErrorHtml = function (objHandle: HCkStringTable): PWideChar; stdcall;
  TCkStringTable_getLastErrorText = procedure (objHandle: HCkStringTable; outPropVal: HCkString); stdcall;
  TCkStringTable__lastErrorText = function (objHandle: HCkStringTable): PWideChar; stdcall;
  TCkStringTable_getLastErrorXml = procedure (objHandle: HCkStringTable; outPropVal: HCkString); stdcall;
  TCkStringTable__lastErrorXml = function (objHandle: HCkStringTable): PWideChar; stdcall;
  TCkStringTable_getLastMethodSuccess = function (objHandle: HCkStringTable): wordbool; stdcall;
  TCkStringTable_putLastMethodSuccess = procedure (objHandle: HCkStringTable; newPropVal: wordbool); stdcall;
  TCkStringTable_getVerboseLogging = function (objHandle: HCkStringTable): wordbool; stdcall;
  TCkStringTable_putVerboseLogging = procedure (objHandle: HCkStringTable; newPropVal: wordbool); stdcall;
  TCkStringTable_getVersion = procedure (objHandle: HCkStringTable; outPropVal: HCkString); stdcall;
  TCkStringTable__version = function (objHandle: HCkStringTable): PWideChar; stdcall;
  TCkStringTable_Append = function (objHandle: HCkStringTable; value: PWideChar): wordbool; stdcall;
  TCkStringTable_AppendFromFile = function (objHandle: HCkStringTable; maxLineLen: Integer; charset: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkStringTable_AppendFromSb = function (objHandle: HCkStringTable; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStringTable_Clear = procedure (objHandle: HCkStringTable); stdcall;
  TCkStringTable_FindMatch = function (objHandle: HCkStringTable; sb: HCkStringBuilder; caseSensitive: wordbool): Integer; stdcall;
  TCkStringTable_FindSubstring = function (objHandle: HCkStringTable; startIndex: Integer; substr: PWideChar; caseSensitive: wordbool): Integer; stdcall;
  TCkStringTable_GetStrings = function (objHandle: HCkStringTable; startIdx: Integer; count: Integer; crlf: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkStringTable__getStrings = function (objHandle: HCkStringTable; startIdx: Integer; count: Integer; crlf: wordbool): PWideChar; stdcall;
  TCkStringTable_IntAt = function (objHandle: HCkStringTable; index: Integer): Integer; stdcall;
  TCkStringTable_SaveToFile = function (objHandle: HCkStringTable; charset: PWideChar; bCrlf: wordbool; path: PWideChar): wordbool; stdcall;
  TCkStringTable_Sort = function (objHandle: HCkStringTable; ascending: wordbool; caseSensitive: wordbool): wordbool; stdcall;
  TCkStringTable_SplitAndAppend = function (objHandle: HCkStringTable; inStr: PWideChar; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): wordbool; stdcall;
  TCkStringTable_StringAt = function (objHandle: HCkStringTable; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkStringTable__stringAt = function (objHandle: HCkStringTable; index: Integer): PWideChar; stdcall;
  TCkStringTable_StringAtSb = function (objHandle: HCkStringTable; index: Integer; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStringTable_ToSb = function (objHandle: HCkStringTable; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStringTable_WordFollowing = function (objHandle: HCkStringTable; sb: HCkStringBuilder; captureEmailAddr: wordbool; sbWord: HCkStringBuilder): Integer; stdcall;

var
  _fkt_ptr_arr:   array [0..34] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkStringTable_Create : HCkStringTable;
begin
  result := TCkStringTable_Create(_map(0, 'CkStringTable_Create'));
end;

procedure CkStringTable_Dispose (handle: HCkStringTable);
begin
  TCkStringTable_Dispose(_map(1, 'CkStringTable_Dispose'))
    (handle);
end;


function CkStringTable_getCount (objHandle: HCkStringTable): Integer;
begin
    result := TCkStringTable_getCount(_map(2, 'CkStringTable_getCount'))
    (objHandle);
end;

procedure CkStringTable_getDebugLogFilePath (objHandle: HCkStringTable; outPropVal: HCkString);
begin
  TCkStringTable_getDebugLogFilePath(_map(3, 'CkStringTable_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkStringTable_putDebugLogFilePath (objHandle: HCkStringTable; newPropVal: PWideChar);
begin
  TCkStringTable_putDebugLogFilePath(_map(4, 'CkStringTable_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkStringTable__debugLogFilePath (objHandle: HCkStringTable): PWideChar;
begin
  result := TCkStringTable__debugLogFilePath(_map(5, 'CkStringTable__debugLogFilePath'))
    (objHandle);
end;

procedure CkStringTable_getLastErrorHtml (objHandle: HCkStringTable; outPropVal: HCkString);
begin
  TCkStringTable_getLastErrorHtml(_map(6, 'CkStringTable_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkStringTable__lastErrorHtml (objHandle: HCkStringTable): PWideChar;
begin
  result := TCkStringTable__lastErrorHtml(_map(7, 'CkStringTable__lastErrorHtml'))
    (objHandle);
end;

procedure CkStringTable_getLastErrorText (objHandle: HCkStringTable; outPropVal: HCkString);
begin
  TCkStringTable_getLastErrorText(_map(8, 'CkStringTable_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkStringTable__lastErrorText (objHandle: HCkStringTable): PWideChar;
begin
  result := TCkStringTable__lastErrorText(_map(9, 'CkStringTable__lastErrorText'))
    (objHandle);
end;

procedure CkStringTable_getLastErrorXml (objHandle: HCkStringTable; outPropVal: HCkString);
begin
  TCkStringTable_getLastErrorXml(_map(10, 'CkStringTable_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkStringTable__lastErrorXml (objHandle: HCkStringTable): PWideChar;
begin
  result := TCkStringTable__lastErrorXml(_map(11, 'CkStringTable__lastErrorXml'))
    (objHandle);
end;

function CkStringTable_getLastMethodSuccess (objHandle: HCkStringTable): wordbool;
begin
    result := TCkStringTable_getLastMethodSuccess(_map(12, 'CkStringTable_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkStringTable_putLastMethodSuccess (objHandle: HCkStringTable; newPropVal: wordbool);
begin
  TCkStringTable_putLastMethodSuccess(_map(13, 'CkStringTable_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkStringTable_getVerboseLogging (objHandle: HCkStringTable): wordbool;
begin
    result := TCkStringTable_getVerboseLogging(_map(14, 'CkStringTable_getVerboseLogging'))
    (objHandle);
end;

procedure CkStringTable_putVerboseLogging (objHandle: HCkStringTable; newPropVal: wordbool);
begin
  TCkStringTable_putVerboseLogging(_map(15, 'CkStringTable_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkStringTable_getVersion (objHandle: HCkStringTable; outPropVal: HCkString);
begin
  TCkStringTable_getVersion(_map(16, 'CkStringTable_getVersion'))
    (objHandle, outPropVal);
end;

function CkStringTable__version (objHandle: HCkStringTable): PWideChar;
begin
  result := TCkStringTable__version(_map(17, 'CkStringTable__version'))
    (objHandle);
end;

function CkStringTable_Append (objHandle: HCkStringTable; value: PWideChar): wordbool;
begin
  result := TCkStringTable_Append(_map(18, 'CkStringTable_Append'))
    (objHandle, value);
end;

function CkStringTable_AppendFromFile (objHandle: HCkStringTable; maxLineLen: Integer; charset: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkStringTable_AppendFromFile(_map(19, 'CkStringTable_AppendFromFile'))
    (objHandle, maxLineLen, charset, path);
end;

function CkStringTable_AppendFromSb (objHandle: HCkStringTable; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStringTable_AppendFromSb(_map(20, 'CkStringTable_AppendFromSb'))
    (objHandle, sb);
end;

procedure CkStringTable_Clear (objHandle: HCkStringTable);
begin
  TCkStringTable_Clear(_map(21, 'CkStringTable_Clear'))
    (objHandle);
end;

function CkStringTable_FindMatch (objHandle: HCkStringTable; sb: HCkStringBuilder; caseSensitive: wordbool): Integer;
begin
  result := TCkStringTable_FindMatch(_map(22, 'CkStringTable_FindMatch'))
    (objHandle, sb, caseSensitive);
end;

function CkStringTable_FindSubstring (objHandle: HCkStringTable; startIndex: Integer; substr: PWideChar; caseSensitive: wordbool): Integer;
begin
  result := TCkStringTable_FindSubstring(_map(23, 'CkStringTable_FindSubstring'))
    (objHandle, startIndex, substr, caseSensitive);
end;

function CkStringTable_GetStrings (objHandle: HCkStringTable; startIdx: Integer; count: Integer; crlf: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkStringTable_GetStrings(_map(24, 'CkStringTable_GetStrings'))
    (objHandle, startIdx, count, crlf, outStr);
end;

function CkStringTable__getStrings (objHandle: HCkStringTable; startIdx: Integer; count: Integer; crlf: wordbool): PWideChar;
begin
  result := TCkStringTable__getStrings(_map(25, 'CkStringTable__getStrings'))
    (objHandle, startIdx, count, crlf);
end;

function CkStringTable_IntAt (objHandle: HCkStringTable; index: Integer): Integer;
begin
  result := TCkStringTable_IntAt(_map(26, 'CkStringTable_IntAt'))
    (objHandle, index);
end;

function CkStringTable_SaveToFile (objHandle: HCkStringTable; charset: PWideChar; bCrlf: wordbool; path: PWideChar): wordbool;
begin
  result := TCkStringTable_SaveToFile(_map(27, 'CkStringTable_SaveToFile'))
    (objHandle, charset, bCrlf, path);
end;

function CkStringTable_Sort (objHandle: HCkStringTable; ascending: wordbool; caseSensitive: wordbool): wordbool;
begin
  result := TCkStringTable_Sort(_map(28, 'CkStringTable_Sort'))
    (objHandle, ascending, caseSensitive);
end;

function CkStringTable_SplitAndAppend (objHandle: HCkStringTable; inStr: PWideChar; delimiterChar: PWideChar; exceptDoubleQuoted: wordbool; exceptEscaped: wordbool): wordbool;
begin
  result := TCkStringTable_SplitAndAppend(_map(29, 'CkStringTable_SplitAndAppend'))
    (objHandle, inStr, delimiterChar, exceptDoubleQuoted, exceptEscaped);
end;

function CkStringTable_StringAt (objHandle: HCkStringTable; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkStringTable_StringAt(_map(30, 'CkStringTable_StringAt'))
    (objHandle, index, outStr);
end;

function CkStringTable__stringAt (objHandle: HCkStringTable; index: Integer): PWideChar;
begin
  result := TCkStringTable__stringAt(_map(31, 'CkStringTable__stringAt'))
    (objHandle, index);
end;

function CkStringTable_StringAtSb (objHandle: HCkStringTable; index: Integer; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStringTable_StringAtSb(_map(32, 'CkStringTable_StringAtSb'))
    (objHandle, index, sb);
end;

function CkStringTable_ToSb (objHandle: HCkStringTable; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStringTable_ToSb(_map(33, 'CkStringTable_ToSb'))
    (objHandle, sb);
end;

function CkStringTable_WordFollowing (objHandle: HCkStringTable; sb: HCkStringBuilder; captureEmailAddr: wordbool; sbWord: HCkStringBuilder): Integer;
begin
  result := TCkStringTable_WordFollowing(_map(34, 'CkStringTable_WordFollowing'))
    (objHandle, sb, captureEmailAddr, sbWord);
end;

end.
