unit Tar;

interface

type

HCkTask = Pointer;
HCkBinData = Pointer;
HCkByteData = Pointer;
HCkTar = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TTarAbortCheck = function(): Integer; cdecl;
TTarProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TTarPercentDone = function(pctDone: Integer): Integer; cdecl;
TTarTaskCompleted = procedure(task: HCkTask); cdecl;


function CkTar_Create: HCkTar;  stdcall;
procedure CkTar_Dispose(handle: HCkTar); stdcall;

procedure CkTar_SetAbortCheck(objHandle: HCkTar; fn: TTarAbortCheck) stdcall;
procedure CkTar_SetProgressInfo(objHandle: HCkTar; fn: TTarProgressInfo) stdcall;
procedure CkTar_SetPercentDone(objHandle: HCkTar; fn: TTarPercentDone) stdcall;
procedure CkTar_SetTaskCompleted(objHandle: HCkTar; fn: TTarTaskCompleted) stdcall;
function CkTar_getCaptureXmlListing(objHandle: HCkTar): wordbool;
procedure CkTar_putCaptureXmlListing(objHandle: HCkTar; newPropVal: wordbool);
procedure CkTar_getCharset(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putCharset(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__charset(objHandle: HCkTar): PWideChar;
procedure CkTar_getDebugLogFilePath(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putDebugLogFilePath(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__debugLogFilePath(objHandle: HCkTar): PWideChar;
function CkTar_getDirMode(objHandle: HCkTar): Integer;
procedure CkTar_putDirMode(objHandle: HCkTar; newPropVal: Integer);
procedure CkTar_getDirPrefix(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putDirPrefix(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__dirPrefix(objHandle: HCkTar): PWideChar;
function CkTar_getFileMode(objHandle: HCkTar): Integer;
procedure CkTar_putFileMode(objHandle: HCkTar; newPropVal: Integer);
function CkTar_getGroupId(objHandle: HCkTar): Integer;
procedure CkTar_putGroupId(objHandle: HCkTar; newPropVal: Integer);
procedure CkTar_getGroupName(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putGroupName(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__groupName(objHandle: HCkTar): PWideChar;
function CkTar_getHeartbeatMs(objHandle: HCkTar): Integer;
procedure CkTar_putHeartbeatMs(objHandle: HCkTar; newPropVal: Integer);
procedure CkTar_getLastErrorHtml(objHandle: HCkTar; outPropVal: HCkString);
function CkTar__lastErrorHtml(objHandle: HCkTar): PWideChar;
procedure CkTar_getLastErrorText(objHandle: HCkTar; outPropVal: HCkString);
function CkTar__lastErrorText(objHandle: HCkTar): PWideChar;
procedure CkTar_getLastErrorXml(objHandle: HCkTar; outPropVal: HCkString);
function CkTar__lastErrorXml(objHandle: HCkTar): PWideChar;
function CkTar_getLastMethodSuccess(objHandle: HCkTar): wordbool;
procedure CkTar_putLastMethodSuccess(objHandle: HCkTar; newPropVal: wordbool);
function CkTar_getMatchCaseSensitive(objHandle: HCkTar): wordbool;
procedure CkTar_putMatchCaseSensitive(objHandle: HCkTar; newPropVal: wordbool);
procedure CkTar_getMustMatch(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putMustMatch(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__mustMatch(objHandle: HCkTar): PWideChar;
procedure CkTar_getMustNotMatch(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putMustNotMatch(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__mustNotMatch(objHandle: HCkTar): PWideChar;
function CkTar_getNoAbsolutePaths(objHandle: HCkTar): wordbool;
procedure CkTar_putNoAbsolutePaths(objHandle: HCkTar; newPropVal: wordbool);
function CkTar_getNumDirRoots(objHandle: HCkTar): Integer;
function CkTar_getPercentDoneScale(objHandle: HCkTar): Integer;
procedure CkTar_putPercentDoneScale(objHandle: HCkTar; newPropVal: Integer);
function CkTar_getScriptFileMode(objHandle: HCkTar): Integer;
procedure CkTar_putScriptFileMode(objHandle: HCkTar; newPropVal: Integer);
function CkTar_getSuppressOutput(objHandle: HCkTar): wordbool;
procedure CkTar_putSuppressOutput(objHandle: HCkTar; newPropVal: wordbool);
function CkTar_getUntarCaseSensitive(objHandle: HCkTar): wordbool;
procedure CkTar_putUntarCaseSensitive(objHandle: HCkTar; newPropVal: wordbool);
function CkTar_getUntarDebugLog(objHandle: HCkTar): wordbool;
procedure CkTar_putUntarDebugLog(objHandle: HCkTar; newPropVal: wordbool);
function CkTar_getUntarDiscardPaths(objHandle: HCkTar): wordbool;
procedure CkTar_putUntarDiscardPaths(objHandle: HCkTar; newPropVal: wordbool);
procedure CkTar_getUntarFromDir(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putUntarFromDir(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__untarFromDir(objHandle: HCkTar): PWideChar;
function CkTar_getUntarMaxCount(objHandle: HCkTar): Integer;
procedure CkTar_putUntarMaxCount(objHandle: HCkTar; newPropVal: Integer);
function CkTar_getUserId(objHandle: HCkTar): Integer;
procedure CkTar_putUserId(objHandle: HCkTar; newPropVal: Integer);
procedure CkTar_getUserName(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putUserName(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__userName(objHandle: HCkTar): PWideChar;
function CkTar_getVerboseLogging(objHandle: HCkTar): wordbool;
procedure CkTar_putVerboseLogging(objHandle: HCkTar; newPropVal: wordbool);
procedure CkTar_getVersion(objHandle: HCkTar; outPropVal: HCkString);
function CkTar__version(objHandle: HCkTar): PWideChar;
procedure CkTar_getWriteFormat(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putWriteFormat(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__writeFormat(objHandle: HCkTar): PWideChar;
procedure CkTar_getXmlListing(objHandle: HCkTar; outPropVal: HCkString);
procedure CkTar_putXmlListing(objHandle: HCkTar; newPropVal: PWideChar);
function CkTar__xmlListing(objHandle: HCkTar): PWideChar;
function CkTar_AddDirRoot(objHandle: HCkTar; dirPath: PWideChar): wordbool;
function CkTar_AddDirRoot2(objHandle: HCkTar; rootPrefix: PWideChar; rootPath: PWideChar): wordbool;
function CkTar_AddFile(objHandle: HCkTar; path: PWideChar): wordbool;
function CkTar_AddFile2(objHandle: HCkTar; filePath: PWideChar; pathWithinTar: PWideChar): wordbool;
function CkTar_ClearDirRootsAndFiles(objHandle: HCkTar): wordbool;
function CkTar_CreateDeb(objHandle: HCkTar; controlPath: PWideChar; dataPath: PWideChar; debPath: PWideChar): wordbool;
function CkTar_GetDirRoot(objHandle: HCkTar; index: Integer; outStr: HCkString): wordbool;
function CkTar__getDirRoot(objHandle: HCkTar; index: Integer): PWideChar;
function CkTar_ListXml(objHandle: HCkTar; tarPath: PWideChar; outStr: HCkString): wordbool;
function CkTar__listXml(objHandle: HCkTar; tarPath: PWideChar): PWideChar;
function CkTar_ListXmlAsync(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_LoadTaskCaller(objHandle: HCkTar; task: HCkTask): wordbool;
function CkTar_Untar(objHandle: HCkTar; tarPath: PWideChar): Integer;
function CkTar_UntarAsync(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_UntarBz2(objHandle: HCkTar; tarPath: PWideChar): wordbool;
function CkTar_UntarBz2Async(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_UntarFirstMatchingToBd(objHandle: HCkTar; tarPath: PWideChar; matchPattern: PWideChar; bd: HCkBinData): wordbool;
function CkTar_UntarFirstMatchingToMemory(objHandle: HCkTar; tarFileBytes: HCkByteData; matchPattern: PWideChar; outData: HCkByteData): wordbool;
function CkTar_UntarFromMemory(objHandle: HCkTar; tarFileBytes: HCkByteData): Integer;
function CkTar_UntarFromMemoryAsync(objHandle: HCkTar; tarFileBytes: HCkByteData): HCkTask;
function CkTar_UntarGz(objHandle: HCkTar; tarPath: PWideChar): wordbool;
function CkTar_UntarGzAsync(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_UntarZ(objHandle: HCkTar; tarPath: PWideChar): wordbool;
function CkTar_UntarZAsync(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_VerifyTar(objHandle: HCkTar; tarPath: PWideChar): wordbool;
function CkTar_VerifyTarAsync(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_WriteTar(objHandle: HCkTar; tarPath: PWideChar): wordbool;
function CkTar_WriteTarAsync(objHandle: HCkTar; tarPath: PWideChar): HCkTask;
function CkTar_WriteTarBz2(objHandle: HCkTar; bz2Path: PWideChar): wordbool;
function CkTar_WriteTarBz2Async(objHandle: HCkTar; bz2Path: PWideChar): HCkTask;
function CkTar_WriteTarGz(objHandle: HCkTar; gzPath: PWideChar): wordbool;
function CkTar_WriteTarGzAsync(objHandle: HCkTar; gzPath: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkTar_Create = function : HCkTar; stdcall;
  TCkTar_Dispose = procedure (handle: HCkTar); stdcall;
  TCkTar_SetAbortCheck = procedure (objHandle: HCkTar; fn: TTarAbortCheck); stdcall;
  TCkTar_SetProgressInfo = procedure (objHandle: HCkTar; fn: TTarProgressInfo); stdcall;
  TCkTar_SetPercentDone = procedure (objHandle: HCkTar; fn: TTarPercentDone); stdcall;
  TCkTar_SetTaskCompleted = procedure (objHandle: HCkTar; fn: TTarTaskCompleted); stdcall;
  TCkTar_getCaptureXmlListing = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putCaptureXmlListing = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getCharset = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putCharset = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__charset = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getDebugLogFilePath = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putDebugLogFilePath = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__debugLogFilePath = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getDirMode = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putDirMode = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getDirPrefix = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putDirPrefix = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__dirPrefix = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getFileMode = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putFileMode = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getGroupId = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putGroupId = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getGroupName = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putGroupName = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__groupName = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getHeartbeatMs = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putHeartbeatMs = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getLastErrorHtml = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar__lastErrorHtml = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getLastErrorText = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar__lastErrorText = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getLastErrorXml = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar__lastErrorXml = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getLastMethodSuccess = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putLastMethodSuccess = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getMatchCaseSensitive = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putMatchCaseSensitive = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getMustMatch = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putMustMatch = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__mustMatch = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getMustNotMatch = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putMustNotMatch = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__mustNotMatch = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getNoAbsolutePaths = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putNoAbsolutePaths = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getNumDirRoots = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_getPercentDoneScale = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putPercentDoneScale = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getScriptFileMode = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putScriptFileMode = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getSuppressOutput = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putSuppressOutput = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getUntarCaseSensitive = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putUntarCaseSensitive = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getUntarDebugLog = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putUntarDebugLog = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getUntarDiscardPaths = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putUntarDiscardPaths = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getUntarFromDir = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putUntarFromDir = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__untarFromDir = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getUntarMaxCount = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putUntarMaxCount = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getUserId = function (objHandle: HCkTar): Integer; stdcall;
  TCkTar_putUserId = procedure (objHandle: HCkTar; newPropVal: Integer); stdcall;
  TCkTar_getUserName = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putUserName = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__userName = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getVerboseLogging = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_putVerboseLogging = procedure (objHandle: HCkTar; newPropVal: wordbool); stdcall;
  TCkTar_getVersion = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar__version = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getWriteFormat = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putWriteFormat = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__writeFormat = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_getXmlListing = procedure (objHandle: HCkTar; outPropVal: HCkString); stdcall;
  TCkTar_putXmlListing = procedure (objHandle: HCkTar; newPropVal: PWideChar); stdcall;
  TCkTar__xmlListing = function (objHandle: HCkTar): PWideChar; stdcall;
  TCkTar_AddDirRoot = function (objHandle: HCkTar; dirPath: PWideChar): wordbool; stdcall;
  TCkTar_AddDirRoot2 = function (objHandle: HCkTar; rootPrefix: PWideChar; rootPath: PWideChar): wordbool; stdcall;
  TCkTar_AddFile = function (objHandle: HCkTar; path: PWideChar): wordbool; stdcall;
  TCkTar_AddFile2 = function (objHandle: HCkTar; filePath: PWideChar; pathWithinTar: PWideChar): wordbool; stdcall;
  TCkTar_ClearDirRootsAndFiles = function (objHandle: HCkTar): wordbool; stdcall;
  TCkTar_CreateDeb = function (objHandle: HCkTar; controlPath: PWideChar; dataPath: PWideChar; debPath: PWideChar): wordbool; stdcall;
  TCkTar_GetDirRoot = function (objHandle: HCkTar; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkTar__getDirRoot = function (objHandle: HCkTar; index: Integer): PWideChar; stdcall;
  TCkTar_ListXml = function (objHandle: HCkTar; tarPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkTar__listXml = function (objHandle: HCkTar; tarPath: PWideChar): PWideChar; stdcall;
  TCkTar_ListXmlAsync = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_LoadTaskCaller = function (objHandle: HCkTar; task: HCkTask): wordbool; stdcall;
  TCkTar_Untar = function (objHandle: HCkTar; tarPath: PWideChar): Integer; stdcall;
  TCkTar_UntarAsync = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_UntarBz2 = function (objHandle: HCkTar; tarPath: PWideChar): wordbool; stdcall;
  TCkTar_UntarBz2Async = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_UntarFirstMatchingToBd = function (objHandle: HCkTar; tarPath: PWideChar; matchPattern: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkTar_UntarFirstMatchingToMemory = function (objHandle: HCkTar; tarFileBytes: HCkByteData; matchPattern: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkTar_UntarFromMemory = function (objHandle: HCkTar; tarFileBytes: HCkByteData): Integer; stdcall;
  TCkTar_UntarFromMemoryAsync = function (objHandle: HCkTar; tarFileBytes: HCkByteData): HCkTask; stdcall;
  TCkTar_UntarGz = function (objHandle: HCkTar; tarPath: PWideChar): wordbool; stdcall;
  TCkTar_UntarGzAsync = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_UntarZ = function (objHandle: HCkTar; tarPath: PWideChar): wordbool; stdcall;
  TCkTar_UntarZAsync = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_VerifyTar = function (objHandle: HCkTar; tarPath: PWideChar): wordbool; stdcall;
  TCkTar_VerifyTarAsync = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_WriteTar = function (objHandle: HCkTar; tarPath: PWideChar): wordbool; stdcall;
  TCkTar_WriteTarAsync = function (objHandle: HCkTar; tarPath: PWideChar): HCkTask; stdcall;
  TCkTar_WriteTarBz2 = function (objHandle: HCkTar; bz2Path: PWideChar): wordbool; stdcall;
  TCkTar_WriteTarBz2Async = function (objHandle: HCkTar; bz2Path: PWideChar): HCkTask; stdcall;
  TCkTar_WriteTarGz = function (objHandle: HCkTar; gzPath: PWideChar): wordbool; stdcall;
  TCkTar_WriteTarGzAsync = function (objHandle: HCkTar; gzPath: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..110] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkTar_Create : HCkTar;
begin
  result := TCkTar_Create(_map(0, 'CkTar_Create'));
end;

procedure CkTar_Dispose (handle: HCkTar);
begin
  TCkTar_Dispose(_map(1, 'CkTar_Dispose'))
    (handle);
end;


procedure CkTar_SetAbortCheck (objHandle: HCkTar; fn: TTarAbortCheck);
begin
    TCkTar_SetAbortCheck(_map(2, 'CkTar_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkTar_SetProgressInfo (objHandle: HCkTar; fn: TTarProgressInfo);
begin
    TCkTar_SetProgressInfo(_map(3, 'CkTar_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkTar_SetPercentDone (objHandle: HCkTar; fn: TTarPercentDone);
begin
    TCkTar_SetPercentDone(_map(4, 'CkTar_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkTar_SetTaskCompleted (objHandle: HCkTar; fn: TTarTaskCompleted);
begin
    TCkTar_SetTaskCompleted(_map(5, 'CkTar_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkTar_getCaptureXmlListing (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getCaptureXmlListing(_map(6, 'CkTar_getCaptureXmlListing'))
    (objHandle);
end;

procedure CkTar_putCaptureXmlListing (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putCaptureXmlListing(_map(7, 'CkTar_putCaptureXmlListing'))
    (objHandle, newPropVal);
end;

procedure CkTar_getCharset (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getCharset(_map(8, 'CkTar_getCharset'))
    (objHandle, outPropVal);
end;

procedure CkTar_putCharset (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putCharset(_map(9, 'CkTar_putCharset'))
    (objHandle, newPropVal);
end;

function CkTar__charset (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__charset(_map(10, 'CkTar__charset'))
    (objHandle);
end;

procedure CkTar_getDebugLogFilePath (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getDebugLogFilePath(_map(11, 'CkTar_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkTar_putDebugLogFilePath (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putDebugLogFilePath(_map(12, 'CkTar_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkTar__debugLogFilePath (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__debugLogFilePath(_map(13, 'CkTar__debugLogFilePath'))
    (objHandle);
end;

function CkTar_getDirMode (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getDirMode(_map(14, 'CkTar_getDirMode'))
    (objHandle);
end;

procedure CkTar_putDirMode (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putDirMode(_map(15, 'CkTar_putDirMode'))
    (objHandle, newPropVal);
end;

procedure CkTar_getDirPrefix (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getDirPrefix(_map(16, 'CkTar_getDirPrefix'))
    (objHandle, outPropVal);
end;

procedure CkTar_putDirPrefix (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putDirPrefix(_map(17, 'CkTar_putDirPrefix'))
    (objHandle, newPropVal);
end;

function CkTar__dirPrefix (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__dirPrefix(_map(18, 'CkTar__dirPrefix'))
    (objHandle);
end;

function CkTar_getFileMode (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getFileMode(_map(19, 'CkTar_getFileMode'))
    (objHandle);
end;

procedure CkTar_putFileMode (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putFileMode(_map(20, 'CkTar_putFileMode'))
    (objHandle, newPropVal);
end;

function CkTar_getGroupId (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getGroupId(_map(21, 'CkTar_getGroupId'))
    (objHandle);
end;

procedure CkTar_putGroupId (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putGroupId(_map(22, 'CkTar_putGroupId'))
    (objHandle, newPropVal);
end;

procedure CkTar_getGroupName (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getGroupName(_map(23, 'CkTar_getGroupName'))
    (objHandle, outPropVal);
end;

procedure CkTar_putGroupName (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putGroupName(_map(24, 'CkTar_putGroupName'))
    (objHandle, newPropVal);
end;

function CkTar__groupName (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__groupName(_map(25, 'CkTar__groupName'))
    (objHandle);
end;

function CkTar_getHeartbeatMs (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getHeartbeatMs(_map(26, 'CkTar_getHeartbeatMs'))
    (objHandle);
end;

procedure CkTar_putHeartbeatMs (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putHeartbeatMs(_map(27, 'CkTar_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkTar_getLastErrorHtml (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getLastErrorHtml(_map(28, 'CkTar_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkTar__lastErrorHtml (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__lastErrorHtml(_map(29, 'CkTar__lastErrorHtml'))
    (objHandle);
end;

procedure CkTar_getLastErrorText (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getLastErrorText(_map(30, 'CkTar_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkTar__lastErrorText (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__lastErrorText(_map(31, 'CkTar__lastErrorText'))
    (objHandle);
end;

procedure CkTar_getLastErrorXml (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getLastErrorXml(_map(32, 'CkTar_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkTar__lastErrorXml (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__lastErrorXml(_map(33, 'CkTar__lastErrorXml'))
    (objHandle);
end;

function CkTar_getLastMethodSuccess (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getLastMethodSuccess(_map(34, 'CkTar_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkTar_putLastMethodSuccess (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putLastMethodSuccess(_map(35, 'CkTar_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkTar_getMatchCaseSensitive (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getMatchCaseSensitive(_map(36, 'CkTar_getMatchCaseSensitive'))
    (objHandle);
end;

procedure CkTar_putMatchCaseSensitive (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putMatchCaseSensitive(_map(37, 'CkTar_putMatchCaseSensitive'))
    (objHandle, newPropVal);
end;

procedure CkTar_getMustMatch (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getMustMatch(_map(38, 'CkTar_getMustMatch'))
    (objHandle, outPropVal);
end;

procedure CkTar_putMustMatch (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putMustMatch(_map(39, 'CkTar_putMustMatch'))
    (objHandle, newPropVal);
end;

function CkTar__mustMatch (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__mustMatch(_map(40, 'CkTar__mustMatch'))
    (objHandle);
end;

procedure CkTar_getMustNotMatch (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getMustNotMatch(_map(41, 'CkTar_getMustNotMatch'))
    (objHandle, outPropVal);
end;

procedure CkTar_putMustNotMatch (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putMustNotMatch(_map(42, 'CkTar_putMustNotMatch'))
    (objHandle, newPropVal);
end;

function CkTar__mustNotMatch (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__mustNotMatch(_map(43, 'CkTar__mustNotMatch'))
    (objHandle);
end;

function CkTar_getNoAbsolutePaths (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getNoAbsolutePaths(_map(44, 'CkTar_getNoAbsolutePaths'))
    (objHandle);
end;

procedure CkTar_putNoAbsolutePaths (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putNoAbsolutePaths(_map(45, 'CkTar_putNoAbsolutePaths'))
    (objHandle, newPropVal);
end;

function CkTar_getNumDirRoots (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getNumDirRoots(_map(46, 'CkTar_getNumDirRoots'))
    (objHandle);
end;

function CkTar_getPercentDoneScale (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getPercentDoneScale(_map(47, 'CkTar_getPercentDoneScale'))
    (objHandle);
end;

procedure CkTar_putPercentDoneScale (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putPercentDoneScale(_map(48, 'CkTar_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkTar_getScriptFileMode (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getScriptFileMode(_map(49, 'CkTar_getScriptFileMode'))
    (objHandle);
end;

procedure CkTar_putScriptFileMode (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putScriptFileMode(_map(50, 'CkTar_putScriptFileMode'))
    (objHandle, newPropVal);
end;

function CkTar_getSuppressOutput (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getSuppressOutput(_map(51, 'CkTar_getSuppressOutput'))
    (objHandle);
end;

procedure CkTar_putSuppressOutput (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putSuppressOutput(_map(52, 'CkTar_putSuppressOutput'))
    (objHandle, newPropVal);
end;

function CkTar_getUntarCaseSensitive (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getUntarCaseSensitive(_map(53, 'CkTar_getUntarCaseSensitive'))
    (objHandle);
end;

procedure CkTar_putUntarCaseSensitive (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putUntarCaseSensitive(_map(54, 'CkTar_putUntarCaseSensitive'))
    (objHandle, newPropVal);
end;

function CkTar_getUntarDebugLog (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getUntarDebugLog(_map(55, 'CkTar_getUntarDebugLog'))
    (objHandle);
end;

procedure CkTar_putUntarDebugLog (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putUntarDebugLog(_map(56, 'CkTar_putUntarDebugLog'))
    (objHandle, newPropVal);
end;

function CkTar_getUntarDiscardPaths (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getUntarDiscardPaths(_map(57, 'CkTar_getUntarDiscardPaths'))
    (objHandle);
end;

procedure CkTar_putUntarDiscardPaths (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putUntarDiscardPaths(_map(58, 'CkTar_putUntarDiscardPaths'))
    (objHandle, newPropVal);
end;

procedure CkTar_getUntarFromDir (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getUntarFromDir(_map(59, 'CkTar_getUntarFromDir'))
    (objHandle, outPropVal);
end;

procedure CkTar_putUntarFromDir (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putUntarFromDir(_map(60, 'CkTar_putUntarFromDir'))
    (objHandle, newPropVal);
end;

function CkTar__untarFromDir (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__untarFromDir(_map(61, 'CkTar__untarFromDir'))
    (objHandle);
end;

function CkTar_getUntarMaxCount (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getUntarMaxCount(_map(62, 'CkTar_getUntarMaxCount'))
    (objHandle);
end;

procedure CkTar_putUntarMaxCount (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putUntarMaxCount(_map(63, 'CkTar_putUntarMaxCount'))
    (objHandle, newPropVal);
end;

function CkTar_getUserId (objHandle: HCkTar): Integer;
begin
    result := TCkTar_getUserId(_map(64, 'CkTar_getUserId'))
    (objHandle);
end;

procedure CkTar_putUserId (objHandle: HCkTar; newPropVal: Integer);
begin
  TCkTar_putUserId(_map(65, 'CkTar_putUserId'))
    (objHandle, newPropVal);
end;

procedure CkTar_getUserName (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getUserName(_map(66, 'CkTar_getUserName'))
    (objHandle, outPropVal);
end;

procedure CkTar_putUserName (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putUserName(_map(67, 'CkTar_putUserName'))
    (objHandle, newPropVal);
end;

function CkTar__userName (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__userName(_map(68, 'CkTar__userName'))
    (objHandle);
end;

function CkTar_getVerboseLogging (objHandle: HCkTar): wordbool;
begin
    result := TCkTar_getVerboseLogging(_map(69, 'CkTar_getVerboseLogging'))
    (objHandle);
end;

procedure CkTar_putVerboseLogging (objHandle: HCkTar; newPropVal: wordbool);
begin
  TCkTar_putVerboseLogging(_map(70, 'CkTar_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkTar_getVersion (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getVersion(_map(71, 'CkTar_getVersion'))
    (objHandle, outPropVal);
end;

function CkTar__version (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__version(_map(72, 'CkTar__version'))
    (objHandle);
end;

procedure CkTar_getWriteFormat (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getWriteFormat(_map(73, 'CkTar_getWriteFormat'))
    (objHandle, outPropVal);
end;

procedure CkTar_putWriteFormat (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putWriteFormat(_map(74, 'CkTar_putWriteFormat'))
    (objHandle, newPropVal);
end;

function CkTar__writeFormat (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__writeFormat(_map(75, 'CkTar__writeFormat'))
    (objHandle);
end;

procedure CkTar_getXmlListing (objHandle: HCkTar; outPropVal: HCkString);
begin
  TCkTar_getXmlListing(_map(76, 'CkTar_getXmlListing'))
    (objHandle, outPropVal);
end;

procedure CkTar_putXmlListing (objHandle: HCkTar; newPropVal: PWideChar);
begin
  TCkTar_putXmlListing(_map(77, 'CkTar_putXmlListing'))
    (objHandle, newPropVal);
end;

function CkTar__xmlListing (objHandle: HCkTar): PWideChar;
begin
  result := TCkTar__xmlListing(_map(78, 'CkTar__xmlListing'))
    (objHandle);
end;

function CkTar_AddDirRoot (objHandle: HCkTar; dirPath: PWideChar): wordbool;
begin
  result := TCkTar_AddDirRoot(_map(79, 'CkTar_AddDirRoot'))
    (objHandle, dirPath);
end;

function CkTar_AddDirRoot2 (objHandle: HCkTar; rootPrefix: PWideChar; rootPath: PWideChar): wordbool;
begin
  result := TCkTar_AddDirRoot2(_map(80, 'CkTar_AddDirRoot2'))
    (objHandle, rootPrefix, rootPath);
end;

function CkTar_AddFile (objHandle: HCkTar; path: PWideChar): wordbool;
begin
  result := TCkTar_AddFile(_map(81, 'CkTar_AddFile'))
    (objHandle, path);
end;

function CkTar_AddFile2 (objHandle: HCkTar; filePath: PWideChar; pathWithinTar: PWideChar): wordbool;
begin
  result := TCkTar_AddFile2(_map(82, 'CkTar_AddFile2'))
    (objHandle, filePath, pathWithinTar);
end;

function CkTar_ClearDirRootsAndFiles (objHandle: HCkTar): wordbool;
begin
  result := TCkTar_ClearDirRootsAndFiles(_map(83, 'CkTar_ClearDirRootsAndFiles'))
    (objHandle);
end;

function CkTar_CreateDeb (objHandle: HCkTar; controlPath: PWideChar; dataPath: PWideChar; debPath: PWideChar): wordbool;
begin
  result := TCkTar_CreateDeb(_map(84, 'CkTar_CreateDeb'))
    (objHandle, controlPath, dataPath, debPath);
end;

function CkTar_GetDirRoot (objHandle: HCkTar; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkTar_GetDirRoot(_map(85, 'CkTar_GetDirRoot'))
    (objHandle, index, outStr);
end;

function CkTar__getDirRoot (objHandle: HCkTar; index: Integer): PWideChar;
begin
  result := TCkTar__getDirRoot(_map(86, 'CkTar__getDirRoot'))
    (objHandle, index);
end;

function CkTar_ListXml (objHandle: HCkTar; tarPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkTar_ListXml(_map(87, 'CkTar_ListXml'))
    (objHandle, tarPath, outStr);
end;

function CkTar__listXml (objHandle: HCkTar; tarPath: PWideChar): PWideChar;
begin
  result := TCkTar__listXml(_map(88, 'CkTar__listXml'))
    (objHandle, tarPath);
end;

function CkTar_ListXmlAsync (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_ListXmlAsync(_map(89, 'CkTar_ListXmlAsync'))
    (objHandle, tarPath);
end;

function CkTar_LoadTaskCaller (objHandle: HCkTar; task: HCkTask): wordbool;
begin
  result := TCkTar_LoadTaskCaller(_map(90, 'CkTar_LoadTaskCaller'))
    (objHandle, task);
end;

function CkTar_Untar (objHandle: HCkTar; tarPath: PWideChar): Integer;
begin
  result := TCkTar_Untar(_map(91, 'CkTar_Untar'))
    (objHandle, tarPath);
end;

function CkTar_UntarAsync (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_UntarAsync(_map(92, 'CkTar_UntarAsync'))
    (objHandle, tarPath);
end;

function CkTar_UntarBz2 (objHandle: HCkTar; tarPath: PWideChar): wordbool;
begin
  result := TCkTar_UntarBz2(_map(93, 'CkTar_UntarBz2'))
    (objHandle, tarPath);
end;

function CkTar_UntarBz2Async (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_UntarBz2Async(_map(94, 'CkTar_UntarBz2Async'))
    (objHandle, tarPath);
end;

function CkTar_UntarFirstMatchingToBd (objHandle: HCkTar; tarPath: PWideChar; matchPattern: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkTar_UntarFirstMatchingToBd(_map(95, 'CkTar_UntarFirstMatchingToBd'))
    (objHandle, tarPath, matchPattern, bd);
end;

function CkTar_UntarFirstMatchingToMemory (objHandle: HCkTar; tarFileBytes: HCkByteData; matchPattern: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkTar_UntarFirstMatchingToMemory(_map(96, 'CkTar_UntarFirstMatchingToMemory'))
    (objHandle, tarFileBytes, matchPattern, outData);
end;

function CkTar_UntarFromMemory (objHandle: HCkTar; tarFileBytes: HCkByteData): Integer;
begin
  result := TCkTar_UntarFromMemory(_map(97, 'CkTar_UntarFromMemory'))
    (objHandle, tarFileBytes);
end;

function CkTar_UntarFromMemoryAsync (objHandle: HCkTar; tarFileBytes: HCkByteData): HCkTask;
begin
  result := TCkTar_UntarFromMemoryAsync(_map(98, 'CkTar_UntarFromMemoryAsync'))
    (objHandle, tarFileBytes);
end;

function CkTar_UntarGz (objHandle: HCkTar; tarPath: PWideChar): wordbool;
begin
  result := TCkTar_UntarGz(_map(99, 'CkTar_UntarGz'))
    (objHandle, tarPath);
end;

function CkTar_UntarGzAsync (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_UntarGzAsync(_map(100, 'CkTar_UntarGzAsync'))
    (objHandle, tarPath);
end;

function CkTar_UntarZ (objHandle: HCkTar; tarPath: PWideChar): wordbool;
begin
  result := TCkTar_UntarZ(_map(101, 'CkTar_UntarZ'))
    (objHandle, tarPath);
end;

function CkTar_UntarZAsync (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_UntarZAsync(_map(102, 'CkTar_UntarZAsync'))
    (objHandle, tarPath);
end;

function CkTar_VerifyTar (objHandle: HCkTar; tarPath: PWideChar): wordbool;
begin
  result := TCkTar_VerifyTar(_map(103, 'CkTar_VerifyTar'))
    (objHandle, tarPath);
end;

function CkTar_VerifyTarAsync (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_VerifyTarAsync(_map(104, 'CkTar_VerifyTarAsync'))
    (objHandle, tarPath);
end;

function CkTar_WriteTar (objHandle: HCkTar; tarPath: PWideChar): wordbool;
begin
  result := TCkTar_WriteTar(_map(105, 'CkTar_WriteTar'))
    (objHandle, tarPath);
end;

function CkTar_WriteTarAsync (objHandle: HCkTar; tarPath: PWideChar): HCkTask;
begin
  result := TCkTar_WriteTarAsync(_map(106, 'CkTar_WriteTarAsync'))
    (objHandle, tarPath);
end;

function CkTar_WriteTarBz2 (objHandle: HCkTar; bz2Path: PWideChar): wordbool;
begin
  result := TCkTar_WriteTarBz2(_map(107, 'CkTar_WriteTarBz2'))
    (objHandle, bz2Path);
end;

function CkTar_WriteTarBz2Async (objHandle: HCkTar; bz2Path: PWideChar): HCkTask;
begin
  result := TCkTar_WriteTarBz2Async(_map(108, 'CkTar_WriteTarBz2Async'))
    (objHandle, bz2Path);
end;

function CkTar_WriteTarGz (objHandle: HCkTar; gzPath: PWideChar): wordbool;
begin
  result := TCkTar_WriteTarGz(_map(109, 'CkTar_WriteTarGz'))
    (objHandle, gzPath);
end;

function CkTar_WriteTarGzAsync (objHandle: HCkTar; gzPath: PWideChar): HCkTask;
begin
  result := TCkTar_WriteTarGzAsync(_map(110, 'CkTar_WriteTarGzAsync'))
    (objHandle, gzPath);
end;

end.
