unit UnixCompress;

interface

type

HCkTask = Pointer;
HCkUnixCompress = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TUnixCompressAbortCheck = function(): Integer; cdecl;
TUnixCompressProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TUnixCompressPercentDone = function(pctDone: Integer): Integer; cdecl;
TUnixCompressTaskCompleted = procedure(task: HCkTask); cdecl;


function CkUnixCompress_Create: HCkUnixCompress;  stdcall;
procedure CkUnixCompress_Dispose(handle: HCkUnixCompress); stdcall;

procedure CkUnixCompress_SetAbortCheck(objHandle: HCkUnixCompress; fn: TUnixCompressAbortCheck) stdcall;
procedure CkUnixCompress_SetProgressInfo(objHandle: HCkUnixCompress; fn: TUnixCompressProgressInfo) stdcall;
procedure CkUnixCompress_SetPercentDone(objHandle: HCkUnixCompress; fn: TUnixCompressPercentDone) stdcall;
procedure CkUnixCompress_SetTaskCompleted(objHandle: HCkUnixCompress; fn: TUnixCompressTaskCompleted) stdcall;
function CkUnixCompress_getAbortCurrent(objHandle: HCkUnixCompress): wordbool;
procedure CkUnixCompress_putAbortCurrent(objHandle: HCkUnixCompress; newPropVal: wordbool);
procedure CkUnixCompress_getDebugLogFilePath(objHandle: HCkUnixCompress; outPropVal: HCkString);
procedure CkUnixCompress_putDebugLogFilePath(objHandle: HCkUnixCompress; newPropVal: PWideChar);
function CkUnixCompress__debugLogFilePath(objHandle: HCkUnixCompress): PWideChar;
function CkUnixCompress_getHeartbeatMs(objHandle: HCkUnixCompress): Integer;
procedure CkUnixCompress_putHeartbeatMs(objHandle: HCkUnixCompress; newPropVal: Integer);
procedure CkUnixCompress_getLastErrorHtml(objHandle: HCkUnixCompress; outPropVal: HCkString);
function CkUnixCompress__lastErrorHtml(objHandle: HCkUnixCompress): PWideChar;
procedure CkUnixCompress_getLastErrorText(objHandle: HCkUnixCompress; outPropVal: HCkString);
function CkUnixCompress__lastErrorText(objHandle: HCkUnixCompress): PWideChar;
procedure CkUnixCompress_getLastErrorXml(objHandle: HCkUnixCompress; outPropVal: HCkString);
function CkUnixCompress__lastErrorXml(objHandle: HCkUnixCompress): PWideChar;
function CkUnixCompress_getLastMethodSuccess(objHandle: HCkUnixCompress): wordbool;
procedure CkUnixCompress_putLastMethodSuccess(objHandle: HCkUnixCompress; newPropVal: wordbool);
function CkUnixCompress_getVerboseLogging(objHandle: HCkUnixCompress): wordbool;
procedure CkUnixCompress_putVerboseLogging(objHandle: HCkUnixCompress; newPropVal: wordbool);
procedure CkUnixCompress_getVersion(objHandle: HCkUnixCompress; outPropVal: HCkString);
function CkUnixCompress__version(objHandle: HCkUnixCompress): PWideChar;
function CkUnixCompress_CompressFile(objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): wordbool;
function CkUnixCompress_CompressFileAsync(objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): HCkTask;
function CkUnixCompress_CompressFileToMem(objHandle: HCkUnixCompress; inFilename: PWideChar; outData: HCkByteData): wordbool;
function CkUnixCompress_CompressFileToMemAsync(objHandle: HCkUnixCompress; inFilename: PWideChar): HCkTask;
function CkUnixCompress_CompressMemory(objHandle: HCkUnixCompress; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkUnixCompress_CompressMemToFile(objHandle: HCkUnixCompress; inData: HCkByteData; destPath: PWideChar): wordbool;
function CkUnixCompress_CompressString(objHandle: HCkUnixCompress; inStr: PWideChar; charset: PWideChar; outData: HCkByteData): wordbool;
function CkUnixCompress_CompressStringToFile(objHandle: HCkUnixCompress; inStr: PWideChar; charset: PWideChar; destPath: PWideChar): wordbool;
function CkUnixCompress_LoadTaskCaller(objHandle: HCkUnixCompress; task: HCkTask): wordbool;
function CkUnixCompress_UncompressFile(objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): wordbool;
function CkUnixCompress_UncompressFileAsync(objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): HCkTask;
function CkUnixCompress_UncompressFileToMem(objHandle: HCkUnixCompress; inFilename: PWideChar; outData: HCkByteData): wordbool;
function CkUnixCompress_UncompressFileToMemAsync(objHandle: HCkUnixCompress; inFilename: PWideChar): HCkTask;
function CkUnixCompress_UncompressFileToString(objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkUnixCompress__uncompressFileToString(objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar): PWideChar;
function CkUnixCompress_UncompressFileToStringAsync(objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar): HCkTask;
function CkUnixCompress_UncompressMemory(objHandle: HCkUnixCompress; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkUnixCompress_UncompressMemToFile(objHandle: HCkUnixCompress; inData: HCkByteData; destPath: PWideChar): wordbool;
function CkUnixCompress_UncompressString(objHandle: HCkUnixCompress; inCompressedData: HCkByteData; charset: PWideChar; outStr: HCkString): wordbool;
function CkUnixCompress__uncompressString(objHandle: HCkUnixCompress; inCompressedData: HCkByteData; charset: PWideChar): PWideChar;
function CkUnixCompress_UnTarZ(objHandle: HCkUnixCompress; zFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): wordbool;
function CkUnixCompress_UnTarZAsync(objHandle: HCkUnixCompress; zFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkUnixCompress_Create = function : HCkUnixCompress; stdcall;
  TCkUnixCompress_Dispose = procedure (handle: HCkUnixCompress); stdcall;
  TCkUnixCompress_SetAbortCheck = procedure (objHandle: HCkUnixCompress; fn: TUnixCompressAbortCheck); stdcall;
  TCkUnixCompress_SetProgressInfo = procedure (objHandle: HCkUnixCompress; fn: TUnixCompressProgressInfo); stdcall;
  TCkUnixCompress_SetPercentDone = procedure (objHandle: HCkUnixCompress; fn: TUnixCompressPercentDone); stdcall;
  TCkUnixCompress_SetTaskCompleted = procedure (objHandle: HCkUnixCompress; fn: TUnixCompressTaskCompleted); stdcall;
  TCkUnixCompress_getAbortCurrent = function (objHandle: HCkUnixCompress): wordbool; stdcall;
  TCkUnixCompress_putAbortCurrent = procedure (objHandle: HCkUnixCompress; newPropVal: wordbool); stdcall;
  TCkUnixCompress_getDebugLogFilePath = procedure (objHandle: HCkUnixCompress; outPropVal: HCkString); stdcall;
  TCkUnixCompress_putDebugLogFilePath = procedure (objHandle: HCkUnixCompress; newPropVal: PWideChar); stdcall;
  TCkUnixCompress__debugLogFilePath = function (objHandle: HCkUnixCompress): PWideChar; stdcall;
  TCkUnixCompress_getHeartbeatMs = function (objHandle: HCkUnixCompress): Integer; stdcall;
  TCkUnixCompress_putHeartbeatMs = procedure (objHandle: HCkUnixCompress; newPropVal: Integer); stdcall;
  TCkUnixCompress_getLastErrorHtml = procedure (objHandle: HCkUnixCompress; outPropVal: HCkString); stdcall;
  TCkUnixCompress__lastErrorHtml = function (objHandle: HCkUnixCompress): PWideChar; stdcall;
  TCkUnixCompress_getLastErrorText = procedure (objHandle: HCkUnixCompress; outPropVal: HCkString); stdcall;
  TCkUnixCompress__lastErrorText = function (objHandle: HCkUnixCompress): PWideChar; stdcall;
  TCkUnixCompress_getLastErrorXml = procedure (objHandle: HCkUnixCompress; outPropVal: HCkString); stdcall;
  TCkUnixCompress__lastErrorXml = function (objHandle: HCkUnixCompress): PWideChar; stdcall;
  TCkUnixCompress_getLastMethodSuccess = function (objHandle: HCkUnixCompress): wordbool; stdcall;
  TCkUnixCompress_putLastMethodSuccess = procedure (objHandle: HCkUnixCompress; newPropVal: wordbool); stdcall;
  TCkUnixCompress_getVerboseLogging = function (objHandle: HCkUnixCompress): wordbool; stdcall;
  TCkUnixCompress_putVerboseLogging = procedure (objHandle: HCkUnixCompress; newPropVal: wordbool); stdcall;
  TCkUnixCompress_getVersion = procedure (objHandle: HCkUnixCompress; outPropVal: HCkString); stdcall;
  TCkUnixCompress__version = function (objHandle: HCkUnixCompress): PWideChar; stdcall;
  TCkUnixCompress_CompressFile = function (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkUnixCompress_CompressFileAsync = function (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkUnixCompress_CompressFileToMem = function (objHandle: HCkUnixCompress; inFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkUnixCompress_CompressFileToMemAsync = function (objHandle: HCkUnixCompress; inFilename: PWideChar): HCkTask; stdcall;
  TCkUnixCompress_CompressMemory = function (objHandle: HCkUnixCompress; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkUnixCompress_CompressMemToFile = function (objHandle: HCkUnixCompress; inData: HCkByteData; destPath: PWideChar): wordbool; stdcall;
  TCkUnixCompress_CompressString = function (objHandle: HCkUnixCompress; inStr: PWideChar; charset: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkUnixCompress_CompressStringToFile = function (objHandle: HCkUnixCompress; inStr: PWideChar; charset: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkUnixCompress_LoadTaskCaller = function (objHandle: HCkUnixCompress; task: HCkTask): wordbool; stdcall;
  TCkUnixCompress_UncompressFile = function (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkUnixCompress_UncompressFileAsync = function (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkUnixCompress_UncompressFileToMem = function (objHandle: HCkUnixCompress; inFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkUnixCompress_UncompressFileToMemAsync = function (objHandle: HCkUnixCompress; inFilename: PWideChar): HCkTask; stdcall;
  TCkUnixCompress_UncompressFileToString = function (objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkUnixCompress__uncompressFileToString = function (objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkUnixCompress_UncompressFileToStringAsync = function (objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkUnixCompress_UncompressMemory = function (objHandle: HCkUnixCompress; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkUnixCompress_UncompressMemToFile = function (objHandle: HCkUnixCompress; inData: HCkByteData; destPath: PWideChar): wordbool; stdcall;
  TCkUnixCompress_UncompressString = function (objHandle: HCkUnixCompress; inCompressedData: HCkByteData; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkUnixCompress__uncompressString = function (objHandle: HCkUnixCompress; inCompressedData: HCkByteData; charset: PWideChar): PWideChar; stdcall;
  TCkUnixCompress_UnTarZ = function (objHandle: HCkUnixCompress; zFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): wordbool; stdcall;
  TCkUnixCompress_UnTarZAsync = function (objHandle: HCkUnixCompress; zFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..46] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkUnixCompress_Create : HCkUnixCompress;
begin
  result := TCkUnixCompress_Create(_map(0, 'CkUnixCompress_Create'));
end;

procedure CkUnixCompress_Dispose (handle: HCkUnixCompress);
begin
  TCkUnixCompress_Dispose(_map(1, 'CkUnixCompress_Dispose'))
    (handle);
end;


procedure CkUnixCompress_SetAbortCheck (objHandle: HCkUnixCompress; fn: TUnixCompressAbortCheck);
begin
    TCkUnixCompress_SetAbortCheck(_map(2, 'CkUnixCompress_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkUnixCompress_SetProgressInfo (objHandle: HCkUnixCompress; fn: TUnixCompressProgressInfo);
begin
    TCkUnixCompress_SetProgressInfo(_map(3, 'CkUnixCompress_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkUnixCompress_SetPercentDone (objHandle: HCkUnixCompress; fn: TUnixCompressPercentDone);
begin
    TCkUnixCompress_SetPercentDone(_map(4, 'CkUnixCompress_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkUnixCompress_SetTaskCompleted (objHandle: HCkUnixCompress; fn: TUnixCompressTaskCompleted);
begin
    TCkUnixCompress_SetTaskCompleted(_map(5, 'CkUnixCompress_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkUnixCompress_getAbortCurrent (objHandle: HCkUnixCompress): wordbool;
begin
    result := TCkUnixCompress_getAbortCurrent(_map(6, 'CkUnixCompress_getAbortCurrent'))
    (objHandle);
end;

procedure CkUnixCompress_putAbortCurrent (objHandle: HCkUnixCompress; newPropVal: wordbool);
begin
  TCkUnixCompress_putAbortCurrent(_map(7, 'CkUnixCompress_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkUnixCompress_getDebugLogFilePath (objHandle: HCkUnixCompress; outPropVal: HCkString);
begin
  TCkUnixCompress_getDebugLogFilePath(_map(8, 'CkUnixCompress_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkUnixCompress_putDebugLogFilePath (objHandle: HCkUnixCompress; newPropVal: PWideChar);
begin
  TCkUnixCompress_putDebugLogFilePath(_map(9, 'CkUnixCompress_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkUnixCompress__debugLogFilePath (objHandle: HCkUnixCompress): PWideChar;
begin
  result := TCkUnixCompress__debugLogFilePath(_map(10, 'CkUnixCompress__debugLogFilePath'))
    (objHandle);
end;

function CkUnixCompress_getHeartbeatMs (objHandle: HCkUnixCompress): Integer;
begin
    result := TCkUnixCompress_getHeartbeatMs(_map(11, 'CkUnixCompress_getHeartbeatMs'))
    (objHandle);
end;

procedure CkUnixCompress_putHeartbeatMs (objHandle: HCkUnixCompress; newPropVal: Integer);
begin
  TCkUnixCompress_putHeartbeatMs(_map(12, 'CkUnixCompress_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkUnixCompress_getLastErrorHtml (objHandle: HCkUnixCompress; outPropVal: HCkString);
begin
  TCkUnixCompress_getLastErrorHtml(_map(13, 'CkUnixCompress_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkUnixCompress__lastErrorHtml (objHandle: HCkUnixCompress): PWideChar;
begin
  result := TCkUnixCompress__lastErrorHtml(_map(14, 'CkUnixCompress__lastErrorHtml'))
    (objHandle);
end;

procedure CkUnixCompress_getLastErrorText (objHandle: HCkUnixCompress; outPropVal: HCkString);
begin
  TCkUnixCompress_getLastErrorText(_map(15, 'CkUnixCompress_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkUnixCompress__lastErrorText (objHandle: HCkUnixCompress): PWideChar;
begin
  result := TCkUnixCompress__lastErrorText(_map(16, 'CkUnixCompress__lastErrorText'))
    (objHandle);
end;

procedure CkUnixCompress_getLastErrorXml (objHandle: HCkUnixCompress; outPropVal: HCkString);
begin
  TCkUnixCompress_getLastErrorXml(_map(17, 'CkUnixCompress_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkUnixCompress__lastErrorXml (objHandle: HCkUnixCompress): PWideChar;
begin
  result := TCkUnixCompress__lastErrorXml(_map(18, 'CkUnixCompress__lastErrorXml'))
    (objHandle);
end;

function CkUnixCompress_getLastMethodSuccess (objHandle: HCkUnixCompress): wordbool;
begin
    result := TCkUnixCompress_getLastMethodSuccess(_map(19, 'CkUnixCompress_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkUnixCompress_putLastMethodSuccess (objHandle: HCkUnixCompress; newPropVal: wordbool);
begin
  TCkUnixCompress_putLastMethodSuccess(_map(20, 'CkUnixCompress_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkUnixCompress_getVerboseLogging (objHandle: HCkUnixCompress): wordbool;
begin
    result := TCkUnixCompress_getVerboseLogging(_map(21, 'CkUnixCompress_getVerboseLogging'))
    (objHandle);
end;

procedure CkUnixCompress_putVerboseLogging (objHandle: HCkUnixCompress; newPropVal: wordbool);
begin
  TCkUnixCompress_putVerboseLogging(_map(22, 'CkUnixCompress_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkUnixCompress_getVersion (objHandle: HCkUnixCompress; outPropVal: HCkString);
begin
  TCkUnixCompress_getVersion(_map(23, 'CkUnixCompress_getVersion'))
    (objHandle, outPropVal);
end;

function CkUnixCompress__version (objHandle: HCkUnixCompress): PWideChar;
begin
  result := TCkUnixCompress__version(_map(24, 'CkUnixCompress__version'))
    (objHandle);
end;

function CkUnixCompress_CompressFile (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkUnixCompress_CompressFile(_map(25, 'CkUnixCompress_CompressFile'))
    (objHandle, inFilename, destPath);
end;

function CkUnixCompress_CompressFileAsync (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkUnixCompress_CompressFileAsync(_map(26, 'CkUnixCompress_CompressFileAsync'))
    (objHandle, inFilename, destPath);
end;

function CkUnixCompress_CompressFileToMem (objHandle: HCkUnixCompress; inFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkUnixCompress_CompressFileToMem(_map(27, 'CkUnixCompress_CompressFileToMem'))
    (objHandle, inFilename, outData);
end;

function CkUnixCompress_CompressFileToMemAsync (objHandle: HCkUnixCompress; inFilename: PWideChar): HCkTask;
begin
  result := TCkUnixCompress_CompressFileToMemAsync(_map(28, 'CkUnixCompress_CompressFileToMemAsync'))
    (objHandle, inFilename);
end;

function CkUnixCompress_CompressMemory (objHandle: HCkUnixCompress; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkUnixCompress_CompressMemory(_map(29, 'CkUnixCompress_CompressMemory'))
    (objHandle, inData, outData);
end;

function CkUnixCompress_CompressMemToFile (objHandle: HCkUnixCompress; inData: HCkByteData; destPath: PWideChar): wordbool;
begin
  result := TCkUnixCompress_CompressMemToFile(_map(30, 'CkUnixCompress_CompressMemToFile'))
    (objHandle, inData, destPath);
end;

function CkUnixCompress_CompressString (objHandle: HCkUnixCompress; inStr: PWideChar; charset: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkUnixCompress_CompressString(_map(31, 'CkUnixCompress_CompressString'))
    (objHandle, inStr, charset, outData);
end;

function CkUnixCompress_CompressStringToFile (objHandle: HCkUnixCompress; inStr: PWideChar; charset: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkUnixCompress_CompressStringToFile(_map(32, 'CkUnixCompress_CompressStringToFile'))
    (objHandle, inStr, charset, destPath);
end;

function CkUnixCompress_LoadTaskCaller (objHandle: HCkUnixCompress; task: HCkTask): wordbool;
begin
  result := TCkUnixCompress_LoadTaskCaller(_map(33, 'CkUnixCompress_LoadTaskCaller'))
    (objHandle, task);
end;

function CkUnixCompress_UncompressFile (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkUnixCompress_UncompressFile(_map(34, 'CkUnixCompress_UncompressFile'))
    (objHandle, inFilename, destPath);
end;

function CkUnixCompress_UncompressFileAsync (objHandle: HCkUnixCompress; inFilename: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkUnixCompress_UncompressFileAsync(_map(35, 'CkUnixCompress_UncompressFileAsync'))
    (objHandle, inFilename, destPath);
end;

function CkUnixCompress_UncompressFileToMem (objHandle: HCkUnixCompress; inFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkUnixCompress_UncompressFileToMem(_map(36, 'CkUnixCompress_UncompressFileToMem'))
    (objHandle, inFilename, outData);
end;

function CkUnixCompress_UncompressFileToMemAsync (objHandle: HCkUnixCompress; inFilename: PWideChar): HCkTask;
begin
  result := TCkUnixCompress_UncompressFileToMemAsync(_map(37, 'CkUnixCompress_UncompressFileToMemAsync'))
    (objHandle, inFilename);
end;

function CkUnixCompress_UncompressFileToString (objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkUnixCompress_UncompressFileToString(_map(38, 'CkUnixCompress_UncompressFileToString'))
    (objHandle, zFilename, charset, outStr);
end;

function CkUnixCompress__uncompressFileToString (objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkUnixCompress__uncompressFileToString(_map(39, 'CkUnixCompress__uncompressFileToString'))
    (objHandle, zFilename, charset);
end;

function CkUnixCompress_UncompressFileToStringAsync (objHandle: HCkUnixCompress; zFilename: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkUnixCompress_UncompressFileToStringAsync(_map(40, 'CkUnixCompress_UncompressFileToStringAsync'))
    (objHandle, zFilename, charset);
end;

function CkUnixCompress_UncompressMemory (objHandle: HCkUnixCompress; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkUnixCompress_UncompressMemory(_map(41, 'CkUnixCompress_UncompressMemory'))
    (objHandle, inData, outData);
end;

function CkUnixCompress_UncompressMemToFile (objHandle: HCkUnixCompress; inData: HCkByteData; destPath: PWideChar): wordbool;
begin
  result := TCkUnixCompress_UncompressMemToFile(_map(42, 'CkUnixCompress_UncompressMemToFile'))
    (objHandle, inData, destPath);
end;

function CkUnixCompress_UncompressString (objHandle: HCkUnixCompress; inCompressedData: HCkByteData; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkUnixCompress_UncompressString(_map(43, 'CkUnixCompress_UncompressString'))
    (objHandle, inCompressedData, charset, outStr);
end;

function CkUnixCompress__uncompressString (objHandle: HCkUnixCompress; inCompressedData: HCkByteData; charset: PWideChar): PWideChar;
begin
  result := TCkUnixCompress__uncompressString(_map(44, 'CkUnixCompress__uncompressString'))
    (objHandle, inCompressedData, charset);
end;

function CkUnixCompress_UnTarZ (objHandle: HCkUnixCompress; zFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): wordbool;
begin
  result := TCkUnixCompress_UnTarZ(_map(45, 'CkUnixCompress_UnTarZ'))
    (objHandle, zFilename, destDir, bNoAbsolute);
end;

function CkUnixCompress_UnTarZAsync (objHandle: HCkUnixCompress; zFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): HCkTask;
begin
  result := TCkUnixCompress_UnTarZAsync(_map(46, 'CkUnixCompress_UnTarZAsync'))
    (objHandle, zFilename, destDir, bNoAbsolute);
end;

end.
